(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[   1153915,      31284]*)
(*NotebookOutlinePosition[   1156117,      31350]*)
(*  CellTagsIndexPosition[   1156009,      31343]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[TextData[{
  "Estructura eucl\[IAcute]dea de ",
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]]],
  ". Curvas"
}], "Title"],

Cell[TextData[StyleBox["Francisco Javier P\[EAcute]rez Gonz\[AAcute]lez\n\
Departamento de An\[AAcute]lisis Matem\[AAcute]tico\nUniversidad de Granada",
  FontSize->12]], "Author"],

Cell[CellGroupData[{

Cell["Introducci\[OAcute]n", "Section"],

Cell[TextData[{
  "Algunos temas de este curso los voy a presentar como cuadernos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "; de esta forma dispondremos de los recursos gr\[AAcute]ficos del programa \
para visualizar muchos de los conceptos que vamos a estudiar. Debe quedar \
claro desde ahora que lo que importa es el desarrollo te\[OAcute]rico de cada \
tema y que utilizo ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " como una herramienta para facilitar su estudio. Tu trabajo debe centrarse \
en el estudio y comprensi\[OAcute]n de los conceptos y definiciones y en la \
realizaci\[OAcute]n de los ejercicios que se proponen. No debes dedicar m\
\[AAcute]s tiempo del imprescindible a los comandos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que se definen; lo justo para saber usarlos para construir tus propios \
ejemplos pero no es preciso, ni es esa mi intenci\[OAcute]n, que comprendas \
bien los recursos de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " que utilizo, los cuales, por otra parte, pueden ser de utilidad para las \
clases de pr\[AAcute]cticas. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Estructura eucl\[IAcute]dea de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]]
}], "Section"],

Cell[TextData[{
  "Voy a recordarte algunas cosas que ya debes conocer. Como sabes, ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " es un espacio vectorial en el que suele destacarse la llamada ",
  StyleBox["base can\[OAcute]nica",
    FontSlant->"Italic"],
  " formada por los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`{\(e\_\(\(1\)\(,\)\)\) e\_2,  ... , e\_n}\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`e\_k\)]],
  " es el vector cuyas componentes son todas nulas excepto la que ocupa el \
lugar ",
  StyleBox["k",
    FontSlant->"Italic"],
  " que es igual a 1. En los libros de f\[IAcute]sica es frecuente poner \
flechas sobre las letras que representan vectores. Este proceder puede ser \
\[UAcute]til en algunos casos para evitar posibles confusiones pero, en \
general, no lo voy a seguir. Deber\[AAcute]s acostumbrarte a distinguir cu\
\[AAcute]ndo una letra representa un vector o un n\[UAcute]mero.\nDados dos \
vectores ",
  Cell[BoxData[
      \(TraditionalForm\`x = \((x\_1, x\_2,  ... , x\_n)\), \ 
      y = \((y\_1, y\_2,  ... , y\_n)\)\)]],
  " se define su producto escalar ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]x \[VerticalSeparator] 
          y\[RightAngleBracket]\)]],
  " por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[\(\[LeftAngleBracket]x | 
              y\[RightAngleBracket] = \(\[Sum]\+\(j = 1\)\%n\( x\_j\) 
                y\_j = \(\(x\_1\) y\_1 + \(x\_2\) y\_2 +  ... \) + \(x\_n\) 
                y\_n\)\),
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Este producto escalar se llama \"producto escalar eucl\[IAcute]deo\". \
Observa que el producto escalar de dos vectores no es un vector sino un n\
\[UAcute]mero real. La notaci\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", 
          StyleBox[".",
            FontWeight->"Bold"], "y"}], TraditionalForm]]],
  " es frecuentemente usada en los libros de F\[IAcute]sica para representar \
el producto escalar de los vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y. ",
    FontSlant->"Italic"],
  "Las dos notaciones son \[UAcute]tiles y las usaremos en lo que sigue con \
preferencia para la notaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]x | y\[RightAngleBracket]\)]],
  ".\nLas siguientes propiedades del producto escalar se deducen \
f\[AAcute]cilmente de la definici\[OAcute]n:\n",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]x | 
            y\[RightAngleBracket] = \[LeftAngleBracket]y | 
            x\[RightAngleBracket]\)]],
  "  para todos ",
  Cell[BoxData[
      \(TraditionalForm\`x, y, z \[Element] \[DoubleStruckCapitalR]\^n\)]],
  " (simetr\[IAcute]a).\n",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]\[Alpha]\ x + \[Beta]\ y | 
            z\[RightAngleBracket] = \[Alpha] \[LeftAngleBracket]x | 
                z\[RightAngleBracket]\  + \ \[Beta] \[LeftAngleBracket]y | 
                z\[RightAngleBracket]\)]],
  "  para todos ",
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha], \[Beta] \[Element] \[DoubleStruckCapitalR]\
\)]],
  " y para todos ",
  Cell[BoxData[
      \(TraditionalForm\`x, y, z \[Element] \[DoubleStruckCapitalR]\^n\)]],
  " (linealidad).\n",
  Cell[BoxData[
      \(TraditionalForm\`\[LeftAngleBracket]x | x\[RightAngleBracket] > 
        0\)]],
  " siempre que ",
  Cell[BoxData[
      \(TraditionalForm\`x \[NotEqual] 0\)]],
  "\nLa norma eucl\[IAcute]dea de un vector se define por:"
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[\(\(\(||\)\(x\)\(||\)\) = \(\@\[LeftAngleBracket]x | x\
\[RightAngleBracket] = \@\(\[Sum]\+\(j = 1\)\%n x\_j\%2\)\)\),
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En libros de f\[IAcute]sica es frecuente representar la norma \
eucl\[IAcute]dea por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["|",
            FontWeight->"Bold"], 
          StyleBox["x",
            FontWeight->"Plain"], 
          StyleBox["|",
            FontWeight->"Bold"]}], TraditionalForm]]],
  " y se le llama m\[OAcute]dulo o magnitud o longitud del vector ",
  StyleBox["x",
    FontSlant->"Italic"],
  ". Tambi\[EAcute]n es  frecuente seguir el convenio de que una letra en \
negrita, por ejemplo ",
  StyleBox["v",
    FontWeight->"Bold"],
  ", representa un vector (digamos, la velocidad); y la misma letra pero en \
tipo normal, v, representa su norma (que ser\[IAcute]a la rapidez o \
celeridad). Ni que decir tiene que este convenio da lugar a \
much\[IAcute]simas confusiones. Advertido quedas."
}], "Text"],

Cell[TextData[{
  StyleBox["Desigualdad de Cauchy-Schwarz",
    FontWeight->"Bold"],
  ". Para todos ",
  Cell[BoxData[
      \(TraditionalForm\`x, y \[Element] \[DoubleStruckCapitalR]\^n\)]],
  "  se verifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`|\[LeftAngleBracket]x | y\[RightAngleBracket] | 
        \( \[LessEqual] \( || x || \  || y || \)\)\)]],
  ". Adem\[AAcute]s, supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " no son nulos, la igualdad ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(|\[LeftAngleBracket]x | y\[RightAngleBracket] | \) = 
        \( || x || \  || y || \)\)]],
  " equivale a que hay un n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] \[Element] \[DoubleStruckCapitalR]\)]],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`y = \[Lambda]\ x\)]],
  " (es decir, los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " est\[AAcute]n en una misma recta que pasa por el origen)."
}], "Text"],

Cell[CellGroupData[{

Cell["Ejercicio 1", "Exercise"],

Cell[TextData[{
  "Prueba la desigualdad de Cauchy-Schwarz.\nSugerencia. Comprueba que la \
ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]x - \[Lambda]\ y | 
            x - \[Lambda]\ y\[RightAngleBracket] = 0\)]],
  ", en la que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[Lambda] \[Element] \[DoubleStruckCapitalR]\ 
      \)\)]],
  "es un n\[UAcute]mero real arbitrario y ",
  Cell[BoxData[
      \(TraditionalForm\`\(\ x, \ 
      y \[Element] \[DoubleStruckCapitalR]\^n\)\)]],
  " son vectores que se suponen fijos, es un trinomio de segundo grado en la \
variable \[Lambda]. Ten en cuenta que dicho trinomio toma siempre valores \
mayores o iguales que cero (\[DownQuestion]por qu\[EAcute]?) lo que \
proporciona informaci\[OAcute]n sobre su discriminante. "
}], "ExerciseText"],

Cell[TextData[{
  StyleBox["Desigualdad triangular",
    FontWeight->"Bold"],
  ". Para todos ",
  Cell[BoxData[
      \(TraditionalForm\`x, y \[Element] \[DoubleStruckCapitalR]\^n\)]],
  "  se verifica que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\( || x\  + \ y\) || 
        \( \[LessEqual] \( || x || \ \(+\ \( || y || \)\)\)\)\)]],
  ". Adem\[AAcute]s, supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " no son nulos, la igualdad ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\( || x + y\) || \) = \( || x || \ \(+\ \( || y || \)\)\)\)]],
  " equivale a que hay un n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda] > 0\)]],
  " tal que ",
  Cell[BoxData[
      \(TraditionalForm\`y = \[Lambda]\ x\)]],
  " (es decir, los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  " est\[AAcute]n en una misma ",
  StyleBox["semirecta",
    FontSlant->"Italic"],
  " que pasa por el origen)."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 2", "Exercise"],

Cell[TextData[{
  "Prueba la desigualdad triangular.\nSugerencia. Una estrategia para probar \
desigualdades entre normas eucl\[IAcute]deas es elevar al cuadrado. La \
desigualdad ",
  Cell[BoxData[
      \(TraditionalForm
      \`\( || x\  + \ y\( || \^2\)\( \[LessEqual] 
          \(( || x || \ \(+\ \( || y || \)\))\)\^2\)\)\)]],
  " es equivalente a la desigualdad triangular pero es muy f\[AAcute]cil de \
probar desarrollando el t\[EAcute]rmino ",
  Cell[BoxData[
      \(TraditionalForm
      \`\( || x\  + \ y\( || \^2\)\) = 
        \[LeftAngleBracket]x + y | x + y\[RightAngleBracket]\)]],
  " y usando la desigualdad de Cauchy-Schwarz."
}], "ExerciseText"],

Cell[TextData[{
  StyleBox["Se dice que los vectores "],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[" e "],
  StyleBox["y",
    FontSlant->"Italic"],
  StyleBox[" son ortogonales, y escribimos "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(x \[UpTee] y\ \)\)]]],
  StyleBox["cuando su producto escalar es cero. Se dice que un vector "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`x\)]]],
  StyleBox[" es ortogonal a un conjunto de vectores "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`D \[Subset] \[DoubleStruckCapitalR]\^n\)]]],
  StyleBox[" cuando "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`x\)]]],
  StyleBox[" es ortogonal a todo vector en "],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`D\)]]],
  StyleBox[
  ". Un conjunto de vectores no nulos que son mutuamente ortogonales se dice \
que es un "],
  StyleBox["conjunto ortogonal",
    FontWeight->"Bold"],
  StyleBox[
  " de vectores; si, adem\[AAcute]s, los vectores tienen todos norma 1 se \
dice que es un "],
  StyleBox["conjunto ortonormal",
    FontWeight->"Bold"],
  StyleBox[
  " de vectores. Una base vectorial que tambi\[EAcute]n es un conjunto \
ortogonal (ortonormal) se llama una base ortogonal (ortonormal). \nSi "],
  StyleBox["x",
    FontSlant->"Italic"],
  StyleBox[" e "],
  StyleBox["y",
    FontSlant->"Italic"],
  StyleBox[" son vectores no nulos, el vector"]
}], "Text"],

Cell[BoxData[
    FormBox[
      FrameBox[\(\(\[CapitalPi]\_y\) \((x)\) = \(\[LeftAngleBracket]x | 
                    y\[RightAngleBracket]\/\[LeftAngleBracket]y | 
                    y\[RightAngleBracket]\) y\)], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "se llama la ",
  StyleBox["proyeccci\[OAcute]n ortogonal de",
    FontWeight->"Bold"],
  StyleBox[" x",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" sobre ",
    FontWeight->"Bold"],
  StyleBox["y",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[". ",
    FontSlant->"Italic"],
  "Puedes comprobar que el vector  ",
  Cell[BoxData[
      \(TraditionalForm\`x - \(\[CapitalPi]\_y\)(x)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "es ortogonal a ",
  StyleBox["y. ",
    FontSlant->"Italic"],
  "En particular, si ",
  StyleBox["y",
    FontSlant->"Italic"],
  " es un ",
  StyleBox["vector unitario",
    FontWeight->"Bold"],
  " (de norma 1) entonces el vector ",
  Cell[BoxData[
      \(TraditionalForm
      \`x\  - \ \[LeftAngleBracket]x\  | \ y\[RightAngleBracket] y\)]],
  " es ortogonal a ",
  StyleBox["y. ",
    FontSlant->"Italic"]
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 3", "Exercise"],

Cell[TextData[{
  "a) (",
  StyleBox["Teorema de Pit\[AAcute]goras",
    FontWeight->"Bold"],
  ") Prueba que los vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  " son ortogonales si, y solo si, ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\( || x + y\)\( || \^2\)\) = 
        \( || x\( || \^2\)\(+\( || y\( || \^2\)\)\)\)\)]],
  ".\nb) Prueba que el vector  ",
  Cell[BoxData[
      \(TraditionalForm\`x - \(\[CapitalPi]\_y\)(x)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "es ortogonal a ",
  StyleBox["y.",
    FontSlant->"Italic"]
}], "ExerciseText"],

Cell[TextData[{
  "Es muy f\[AAcute]cil calcular las componentes de un vector en una base \
ortonormal. Sea ",
  Cell[BoxData[
      \(TraditionalForm\`B = {u\_1, u\_2,  ... , u\_n}\)]],
  " una base ortonormal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " y sea ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \[DoubleStruckCapitalR]\^n\)]],
  ". Puedes comprobar que ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", "=", 
          RowBox[{
            FormBox[\(\[Sum]\+\(j = 1\)\%n\),
              
              "TraditionalForm"], \(\[LeftAngleBracket]x | 
                  u\_j\[RightAngleBracket] u\_j\)}]}], TraditionalForm]]],
  ", es decir, ",
  StyleBox["x",
    FontSlant->"Italic"],
  " es la suma de sus proyecciones ortogonales sobre los vectores de la base. \
Las componentes de ",
  StyleBox["x",
    FontSlant->"Italic"],
  " en dicha base son, por tanto,  ",
  Cell[BoxData[
      \(TraditionalForm\`\((\[LeftAngleBracket]x | 
            u\_1\[RightAngleBracket], \[LeftAngleBracket]x | 
            u\_2\[RightAngleBracket], \(\(...\)\(\ \)\(\[LeftAngleBracket]x | 
              u\_n\[RightAngleBracket]\)\))\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  StyleBox["El producto escalar y la norma es invariante por cambios de base \
ortonormales",
    FontWeight->"Bold"],
  ". Es decir, si ",
  Cell[BoxData[
      \(TraditionalForm\`B = {u\_1, u\_2,  ... , u\_n}\)]],
  " es una base ortonormal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  "; ",
  Cell[BoxData[
      \(TraditionalForm\`x = \((x\_1, x\_2,  ... , x\_n)\), \ 
      y = \((y\_1, y\_2,  ... , y\_n)\)\)]],
  " son vectores de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " cuyas coordenadas en la base ",
  Cell[BoxData[
      \(TraditionalForm\`B\)]],
  " son, respectivamente, ",
  Cell[BoxData[
      FormBox[
        RowBox[{\((\[Alpha]\_1, \[Alpha]\_2,  ... , \[Alpha]\_n)\), "  ", 
          StyleBox["y",
            FontSlant->"Plain"], 
          "  ", \((\[Beta]\_1, \[Beta]\_2,  ... , \[Beta]\_n)\)}], 
        TraditionalForm]]],
  ", entonces se verifica que:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\[LeftAngleBracket]x | 
          y\[RightAngleBracket] = \(\[Sum]\+\(j = 1\)\%n\( x\_j\) 
            y\_j = \[Sum]\+\(j = 1\)\%n\( \[Alpha]\_j\) \[Beta]\_j\)\)], \
"Text",
  TextAlignment->Center],

Cell["En particular,", "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(\(||\)\(x\)\(||\)\) = \(\@\(\[Sum]\+\(j = 1\)\%n \
x\_j\%2\) = \@\(\[Sum]\+\(j = 1\)\%n \[Alpha]\_j\%2\)\)\)], "Text",
  TextAlignment->Center]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 4", "Exercise"],

Cell[TextData[{
  "Prueba las dos afirmaciones anteriores",
  StyleBox[".",
    FontSlant->"Italic"]
}], "ExerciseText"],

Cell[TextData[{
  "Dados dos vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  ", el n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`\(\( || x - y\) || \)\)]],
  " se llama la distancia (eucl\[IAcute]dea) entre ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "Supongamos ahora que H es un subespacio vectorial de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  " y que ",
  Cell[BoxData[
      \(TraditionalForm\`{v\_1, v\_2,  ... , v\_k}\)]],
  " es una base ortonormal de H. Dado un vector ",
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \[DoubleStruckCapitalR]\^n\)]],
  ", el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\(P\_H\)(x)\), "=", 
          RowBox[{
            RowBox[{
              FormBox[\(\[Sum]\+\(j = 1\)\%k\),
                "TraditionalForm"], 
              \(\[LeftAngleBracket]x | v\_j\[RightAngleBracket] v\_j\)}], 
            "\[Element]", "H"}]}], TraditionalForm]]],
  " se llama la ",
  StyleBox["proyecci\[OAcute]n ortogonal de ",
    FontWeight->"Bold"],
  StyleBox["x",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" sobre H",
    FontWeight->"Bold"],
  ". Es inmediato que el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", "-", 
          FormBox[\(\(P\_H\)(x)\),
            "TraditionalForm"]}], TraditionalForm]]],
  " es ortogonal a cada uno de los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`v\_j, \ 1 \[LessEqual] j \[LessEqual] k\)]],
  " y, por la linealidad del producto escalar, deducimos que ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", "-", 
          FormBox[\(\(P\_H\)(x)\),
            "TraditionalForm"]}], TraditionalForm]]],
  " es ortogonal a ",
  Cell[BoxData[
      \(TraditionalForm\`H\)]],
  ". "
}], "Text"],

Cell[TextData[{
  StyleBox["Distancia m\[IAcute]nima de un punto a un subespacio",
    FontWeight->"Bold"],
  StyleBox[". Vamos a probar que si ",
    FontWeight->"Plain"],
  StyleBox["H",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" es un subespacio vectorial de ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)],
    FontWeight->"Plain"],
  StyleBox[", ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`{v\_1, v\_2,  ... , v\_k}\)],
    FontWeight->"Plain"],
  StyleBox[" es una base ortonormal de ",
    FontWeight->"Plain"],
  StyleBox["H",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox["  y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`x \[Element] \[DoubleStruckCapitalR]\^n\)],
    FontWeight->"Plain"],
  StyleBox[", se verifica que la distancia m\[IAcute]nima de ",
    FontWeight->"Plain"],
  StyleBox["x",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[" al subespacio H es igual a ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        RowBox[{"||", 
          RowBox[{"x", "-", 
            FormBox[
              RowBox[{
                FormBox[\(\[Sum]\+\(j = 1\)\%k\),
                  
                  "TraditionalForm"], \(\[LeftAngleBracket]x | 
                      v\_j\[RightAngleBracket] v\_j\)}],
              "TraditionalForm"]}], "||"}], TraditionalForm]],
    FontWeight->"Plain"],
  StyleBox[".\n",
    FontWeight->"Plain"],
  StyleBox["Demostraci\[OAcute]n",
    FontWeight->"Bold"],
  StyleBox[". Llamemos ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[
          RowBox[{\(\(P\_H\)(x)\), "=", 
            RowBox[{
              FormBox[\(\[Sum]\+\(j = 1\)\%k\),
                
                "TraditionalForm"], \(\[LeftAngleBracket]x | 
                    v\_j\[RightAngleBracket] v\_j\)}]}],
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[". El vector ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\(P\_H\)(x)\)],
    FontWeight->"Plain"],
  StyleBox[" est\[AAcute] en ",
    FontWeight->"Plain"],
  StyleBox["H",
    FontWeight->"Plain",
    FontSlant->"Italic"],
  StyleBox[". Queremos probar que ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(||\)\(x - \(P\_H\)(
                x)\)\(||\)\(\(\[LessEqual]\)\(\(\(||\)\(x - y\)\)\(||\)\)\)\),
          
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["para todo ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(y \[Element] H\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox[". En efecto, para todo ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(y \[Element] H\),
          FontWeight->"Plain"], TraditionalForm]]],
  StyleBox["se tiene que el vector ",
    FontWeight->"Plain"],
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(P\_H\)(x) - y\),
          FontWeight->"Plain"], TraditionalForm]]],
  " ",
  StyleBox["tambi\[EAcute]n est\[AAcute] en ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`H\)],
    FontWeight->"Plain"],
  " por lo que ",
  StyleBox["los vectores ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`x - \(P\_H\)(x)\)],
    FontWeight->"Plain"],
  " ",
  StyleBox["y ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\(P\_H\)(x) - y\)],
    FontWeight->"Plain"],
  StyleBox[" son ortogonales y, usando el teorema de Pit\[AAcute]goras, \
deducimos que",
    FontWeight->"Plain"]
}], "Text"],

Cell[BoxData[
    FormBox[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              
              FormBox[\(\(\(\(||\)\(x - 
                        y\)\)\( || \^2\)\) = \(\(||\)\((\(x\)\(-\)\)\)\),
                "TraditionalForm"], 
              FormBox[
                FormBox[
                  StyleBox[\(\(P\_H\)(x)\),
                    FontWeight->"Plain"],
                  "TraditionalForm"],
                "TraditionalForm"]}], ")"}], "+", 
          RowBox[{"(", 
            RowBox[{
              FormBox[
                FormBox[
                  RowBox[{
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          RowBox[{
                            StyleBox[\(P\_H\),
                              FontWeight->"Plain"], "(", 
                            StyleBox["x",
                              FontWeight->"Plain"], 
                            StyleBox[")",
                              FontWeight->"Plain"]}], "-", "y"}], 
                        ")"}], \( || \^2\)}], "="}],
                  "TraditionalForm"],
                "TraditionalForm"], " ", "||", 
              RowBox[{"x", "-", 
                RowBox[{
                  StyleBox[\(P\_H\),
                    FontWeight->"Plain"], "(", 
                  StyleBox["x",
                    FontWeight->"Plain"], 
                  StyleBox[")",
                    FontWeight->"Plain"]}]}], \( || \^2\), 
              RowBox[{"+", 
                RowBox[{"||", 
                  RowBox[{
                    RowBox[{
                      StyleBox[\(P\_H\),
                        FontWeight->"Plain"], "(", 
                      StyleBox["x",
                        FontWeight->"Plain"], 
                      StyleBox[")",
                        FontWeight->"Plain"]}], "-", "y"}], \( || \^2\), 
                  "  \t\t\t\t\t"}]}]}]}]}],
        "TraditionalForm"], TraditionalForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "esta igualdad implica que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(||\)\(x - \(P\_H\)(
              x)\)\)\( || \^2\)\(\(\[LessEqual]\)\(\(\(||\)\(x - 
                y\)\)\( || \^2\)\)\)\)]],
  ", es decir, ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(||\)\(x - \(P\_H\)(
              x)\)\) || \(\(\[LessEqual]\)\(\(\(||\)\(x - 
                y\)\)\(||\)\)\)\)]],
  "  y la igualdad se da solamente cuando ",
  Cell[BoxData[
      \(TraditionalForm\`y = \(P\_H\)(x)\)]],
  ", es decir, que la distancia m\[IAcute]nima de ",
  StyleBox["x",
    FontSlant->"Italic"],
  " a ",
  StyleBox["H",
    FontSlant->"Italic"],
  " se alcanza solamente en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\(P\_H\)(x)\)]],
  "."
}], "Text"],

Cell[TextData[{
  " Cuando la dimensi\[OAcute]n de ",
  StyleBox["H",
    FontSlant->"Italic"],
  " es grande, puede calcularse f\[AAcute]cilmente el vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(x - \(P\_H\)(x)\), "=", 
          RowBox[{"x", "-", 
            FormBox[
              RowBox[{
                FormBox[\(\[Sum]\+\(j = 1\)\%k\),
                  "TraditionalForm"], 
                \(\[LeftAngleBracket]x | v\_j\[RightAngleBracket] v\_j\)}],
              "TraditionalForm"]}]}], TraditionalForm]]],
  " de la siguiente forma: se ampl\[IAcute]a la base ",
  Cell[BoxData[
      \(TraditionalForm\`{v\_1, v\_2,  ... , v\_k}\)]],
  " a una base ortonormal de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  "; sea esta ",
  Cell[BoxData[
      \(TraditionalForm
      \`B = {v\_1, v\_2,  ... , v\_k, \ u\_\(k + 1\),  ... , u\_n}\)]],
  ". De la igualdad ",
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          RowBox[{"x", "=", 
            RowBox[{
              RowBox[{
                FormBox[\(\[Sum]\+\(j = 1\)\%k\),
                  "TraditionalForm"], 
                \(\[LeftAngleBracket]x | v\_j\[RightAngleBracket] v\_j\)}], 
              "+", 
              RowBox[{
                FormBox[\(\[Sum]\+\(j = k + 1\)\%n\),
                  "TraditionalForm"], 
                \(\[LeftAngleBracket]x | u\_j\[RightAngleBracket] 
                  u\_j\)}]}]}]}], TraditionalForm]]],
  " se sigue que  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"x", "-", 
            FormBox[
              RowBox[{
                FormBox[\(\[Sum]\+\(j = 1\)\%k\),
                  "TraditionalForm"], 
                \(\[LeftAngleBracket]x | v\_j\[RightAngleBracket] v\_j\)}],
              "TraditionalForm"]}], "=", 
          RowBox[{
            FormBox[\(\[Sum]\+\(j = k + 1\)\%n\),
              "TraditionalForm"], 
            \(\[LeftAngleBracket]x | u\_j\[RightAngleBracket] u\_j\)}]}], 
        TraditionalForm]]],
  ". Este proceder es muy \[UAcute]til cuando ",
  Cell[BoxData[
      \(TraditionalForm\`k = n - 1\)]],
  " y permite calcular f\[AAcute]cilmente la distancia de un punto a un \
hiperplano (subespacio vectorial de dimensi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`n - 1\)]],
  "). Teniendo en cuenta que la distancia es invariante por traslaciones, \
este resultado te permite calcular (aunque no necesariamente por el camino m\
\[AAcute]s corto) la distancia de un punto a una recta o la distancia de un \
punto a un plano."
}], "Text"],

Cell[TextData[{
  "Acabamos de ver que es muy f\[AAcute]cil calcular la proyecci\[OAcute]n \
ortogonal de un vector sobre un subespacio si conocemos una base ortonormal \
del mismo. Por eso el siguiente procedimniento, conocido como ",
  StyleBox["procedimiento de ortogonalizaci\[OAcute]n de Gram-Schmidt ",
    FontSlant->"Italic"],
  "es de gran inter\[EAcute]s. Dico procedimiento consiste en lo siguiente. \
Dada una base ",
  Cell[BoxData[
      \(TraditionalForm\`{v\_1, v\_2,  ... , v\_k}\)]],
  " de un subespacio vectorial ",
  StyleBox["H",
    FontSlant->"Italic"],
  ", queremos obtener a partir de ella otra base de ",
  StyleBox["H",
    FontSlant->"Italic"],
  " que sea ortonormal. Para ello definimos"
}], "Text"],

Cell[BoxData[{
    FormBox[
      RowBox[{
        RowBox[{\(u\_1 = v\_1\/\(\(||\)\(v\_1\)\(||\)\)\), ",", 
          "                  ", \(u\_2 = \(v\_2 - \[LeftAngleBracket]v\_2 | u\
\_1\[RightAngleBracket] u\_1\)\/\(\(||\)\(v\_2 - \[LeftAngleBracket]v\_2 | \
u\_1\[RightAngleBracket] u\_1\)\(||\)\)\), " ", ",", 
          
          FormBox[\(\(\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \)\(\(u\_3 = \(v\_3 - \
\[LeftAngleBracket]v\_3 | u\_2\[RightAngleBracket] u\_2 - \
\[LeftAngleBracket]v\_3 | u\_1\[RightAngleBracket] u\_1\)\/\(\(||\)\(v\_3 - \
\[LeftAngleBracket]v\_3 | u\_2\[RightAngleBracket] u\_2 - \
\[LeftAngleBracket]v\_3 | u\_1\[RightAngleBracket] u\_1\)\(||\)\)\)\(,\)\)\),
            "TextForm"]}], "\n"}], TraditionalForm], "\n", 
    FormBox[
      FormBox[\(u\_4 = \(v\_4 - \[LeftAngleBracket]v\_4 | u\_3\
\[RightAngleBracket] u\_3 - \[LeftAngleBracket]v\_4 | \
u\_2\[RightAngleBracket] u\_2 - \[LeftAngleBracket]v\_4 | u\_1\
\[RightAngleBracket] u\_1\)\/\(\(||\)\(v\_4 - \[LeftAngleBracket]v\_4 | u\_3\
\[RightAngleBracket] u\_3 - \[LeftAngleBracket]v\_4 | \
u\_2\[RightAngleBracket] u\_2 - \[LeftAngleBracket]v\_4 | u\_1\
\[RightAngleBracket] u\_1\)\(||\)\), \  ... \),
        "TextForm"], TraditionalForm]}], "Text",
  TextAlignment->Left],

Cell[TextData[{
  "Supuestos construidos ",
  Cell[BoxData[
      \(TraditionalForm\`u\_1, u\_2,  ... , \ u\_j\)]],
  " ortonormales dos a dos, se define ",
  Cell[BoxData[
      \(TraditionalForm\`u\_\(j + 1\)\)]],
  " como ",
  Cell[BoxData[
      \(TraditionalForm\`v\_\(j + 1\)\)]],
  " menos la proyecci\[OAcute]n ortogonal de ",
  Cell[BoxData[
      \(TraditionalForm\`v\_\(j + 1\)\)]],
  " sobre el subespacio engendrado por los vectores  ",
  Cell[BoxData[
      \(TraditionalForm\`u\_1, u\_2,  ... , \ u\_j\)]],
  " divididido por su norma,"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`u\_\(j + 1\) = \(v\_\(j + 1\) - \[Sum]\+\(i = 1\)\%j\
\[LeftAngleBracket]v\_\(j + 1\) | u\_\(\(\ \)\(i\)\)\[RightAngleBracket] \
u\_\(\(\ \)\(i\)\)\)\/\(\(\(\(||\)\(v\)\)\_\(j + 1\) - \[Sum]\+\(i = 1\)\%j\
\[LeftAngleBracket]v\_\(j + 1\) | u\_\(\(\ \)\(i\)\)\[RightAngleBracket] \
u\_\(\(\ \)\(i\)\)\)\(||\)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "con lo que obtenemos un vector unitario ortogonal a los vectores  ",
  Cell[BoxData[
      \(TraditionalForm\`u\_1, u\_2,  ... , \ u\_j\)]],
  " y, en consecuencia,  ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            FormBox[\(u\_1, u\_2,  ... , \ u\_j\),
              "TraditionalForm"], ",", \(u\_\(j + 1\)\)}], "}"}], 
        TraditionalForm]]],
  " es un sistema ortonormal. Este proceso contin\[UAcute]a hasta agotar \
todos los vectores de la base dada. Observa que como los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            FormBox[\(u\_1, u\_2,  ... , \ \),
              "TraditionalForm"], \(u\_k\)}], "}"}], TraditionalForm]]],
  " dependen linealmente de los vectores ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          FormBox[\(v\_1, v\_2,  ... , \ v\_k\),
            "TraditionalForm"], "}"}], TraditionalForm]]],
  " el subespacio engendrado por ",
  Cell[BoxData[
      FormBox[
        RowBox[{"{", 
          RowBox[{
            FormBox[\(u\_1, u\_2,  ... , \ \),
              "TraditionalForm"], \(u\_k\)}], "}"}], TraditionalForm]]],
  " es tambi\[EAcute]n ",
  StyleBox["H",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "El siguiente comando es un ejemplo de la potencia del lenguaje de \
programaci\[OAcute]n de ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  ". En una sola l\[IAcute]nea se define un comando que realiza el proceso \
que acabamos de describir. Te recuerdo lo dicho: no trates de comprender la \
definici\[OAcute]n del comando. \[CapitalUAcute]salo como se indica en el \
ejemplo para ortonormalizar conjuntos de vectores que t\[UAcute] mismo debes \
definir y comprobar que efectivamente el resultado es un conjunto \
ortonormal."
}], "Text"],

Cell[BoxData[
    RowBox[{\( (*\ 
        autor : \ 
          Profesor\ Debra\ Lewis\ de\ la\ Universidad\ de\ California, \ 
        Berkeley\ *) \), "\[IndentingNewLine]", 
      StyleBox[\(gramschmidt = 
            Fold[Append[#1, \((#1\/\@\(#1 . #1\) &)\)[
                      Fold[#1 - #1 . #2\ #2\  &, #2, #1]]] &, {}, #1] &;\),
        FontFamily->"Courier New"]}]], "Input",
  FontFamily->"Courier New"],

Cell[TextData[{
  "Podemos aplicar este comando a vectores en cualquier dimensi\[OAcute]n (el \
comando ",
  Cell[BoxData[
      \(TraditionalForm\`Dot[x, y]\)]],
  " o ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", 
          StyleBox[".",
            FontWeight->"Bold"], "y"}], TraditionalForm]]],
  " calcula el producto escalar del vector ",
  Cell[BoxData[
      \(TraditionalForm\`x\)]],
  " por el vector ",
  Cell[BoxData[
      \(TraditionalForm\`y\)]],
  ")."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    StyleBox[\(\(tr1 = 
        gramschmidt[{{1, 0, 2}, {0, 2, 3}, {1, 4, 0}}] // Simplify\)\( (*\ 
        aplicamos\ el\ proceso\ a\ los\ vectores\ {1, 0, 2}, {0, 2, 3}, {1, 
          4, 0}\ *) \)\),
      FontFamily->"Courier New"], "\n", 
    RowBox[{
      StyleBox[\(tr2 = 
          gramschmidt[{{1, 0, 2, 1}, {0, 2, 3, \(-1\)}, {\(-2\), 1, 4, 0}}] // 
            Simplify\),
        FontFamily->"Courier New"], 
      StyleBox[\( (*\ 
          aplicamos\ el\ proceso\ a\ los\ vectores\ {1, 0, 2, 1}, {0, 2, 
            3, \(-1\)}, {\(-2\), 1, 4, 0}\ *) \),
        FontFamily->"Courier New"], "\n", 
      StyleBox[\( (*\ 
          ahora\ comprobamos\ que\ los\ vectores\ obtenidos\ son\ \
ortonormales\ dos\ a\ dos\ *) \),
        FontFamily->"Courier New"]}], "\n", 
    StyleBox[\(\(\(Outer[Dot, tr1, tr1, 1] // Simplify\) // Chop\)\(\ \)\),
      FontFamily->"Courier New"], "\n", 
    StyleBox[\(\(\(Outer[Dot, tr2, tr2, 1] // Simplify\) // Chop\)\(\ \)\),
      FontFamily->"Courier New"], "\n", \(Clear[tr1, tr2]\)}], "Input",
  FontFamily->"Courier New"],

Cell[BoxData[
    \({{1\/\@5, 0, 2\/\@5}, {\(-\(6\/\@145\)\), 2\ \@\(5\/29\), 
        3\/\@145}, {4\/\@29, 3\/\@29, \(-\(2\/\@29\)\)}}\)], "Output"],

Cell[BoxData[
    \({{1\/\@6, 0, \@\(2\/3\), 1\/\@6}, {\(-\(5\/\@354\)\), 2\ \@\(6\/59\), 
        4\ \@\(2\/177\), \(-\(11\/\@354\)\)}, {\(-44\)\ \@\(3\/7847\), \(-7\)\
\ \@\(7\/3363\), 46\/\@23541, 40\/\@23541}}\)], "Output"],

Cell[BoxData[
    \({{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}\)], "Output"],

Cell[BoxData[
    \({{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`x \[NotEqual] 0, \ y \[NotEqual] 0\)]],
  ", la desigualdad de Cauchy-Schwarz puede escribirse en la forma:"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`\(-1\) \[LessEqual] \[LeftAngleBracket]x | y\
\[RightAngleBracket]\/\(\(||\)\(x\)\(||\)\(\ \)\(||\)\(y\)\(||\)\) \
\[LessEqual] 1\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "La medida en radianes del \[AAcute]ngulo que forman los vectores no nulos \
",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  " se define como el \[UAcute]nico n\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] \([0, \[Pi]]\)\)]],
  " que verifica la igualdad"
}], "Text"],

Cell[BoxData[
    \(TraditionalForm\`cos\ t = \[LeftAngleBracket]x | \
y\[RightAngleBracket]\/\(\(||\)\(x\)\(||\)\(\ \)\(||\)\(y\)\(||\)\)\)], "Text",\

  TextAlignment->Center],

Cell[TextData[{
  "Naturalmente, como consecuencia de esta definici\[OAcute]n, se verifica \
que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]x | y\[RightAngleBracket] = 
        \( || x ||  || y || cos\ t\)\)]],
  "."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Particularizaci\[OAcute]n a ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]]
}], "Subsection"],

Cell[TextData[{
  "En f\[IAcute]sica se representan los vectores de la base can\[OAcute]nica \
de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "con las letras ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(i, \ j, \ k\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Es decir: "
}], "Text"],

Cell[TextData[{
  " ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["i",
              FontWeight->"Bold"], "=", \((1, 0, 0)\)}], ",", " ", 
          RowBox[{
            StyleBox["j",
              FontWeight->"Bold"], "=", \((0, 1, 0)\)}], ",", " ", 
          RowBox[{
            StyleBox["k",
              FontWeight->"Bold"], "=", \((0, 0, 1)\)}]}], TraditionalForm]]]
}], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Naturalmente, si ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " es un vector de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "se tiene que:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\((x, y, z)\), " ", "=", " ", 
        RowBox[{
          RowBox[{"x", " ", 
            StyleBox["i",
              FontWeight->"Bold"]}], "+", " ", 
          RowBox[{"y", " ", 
            StyleBox["j",
              FontWeight->"Bold"]}], "+", " ", 
          RowBox[{"z", " ", 
            StyleBox["k",
              FontWeight->"Bold"]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En Matem\[AAcute]ticas se prefiere la expresi\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`\((x, y, z)\)\)]],
  " y en f\[IAcute]sica se prefiere  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{"x", " ", 
            StyleBox["i",
              FontWeight->"Bold"]}], "+", " ", 
          RowBox[{"y", " ", 
            StyleBox["j",
              FontWeight->"Bold"]}], "+", " ", 
          RowBox[{"z", " ", 
            StyleBox["k",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ". Debes tener bien claro que son dos formas de escribir lo mismo: el \
vector cuyas componentes en la base can\[OAcute]nica de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " son ",
  Cell[BoxData[
      \(TraditionalForm\`x, \ y, \ z\)]],
  ".\nEn ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "se define el ",
  StyleBox["producto vectorial",
    FontSlant->"Italic"],
  " de dos vectores ",
  Cell[BoxData[
      \(TraditionalForm\`x = \((x\_1, x\_2, x\_3)\), \ 
      y = \((y\_1, y\_2, y\_3)\)\)]],
  " como el vector:"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(x\ \[Times]\ y\), "=", 
        RowBox[{
          RowBox[{"(", 
            RowBox[{
              FormBox[
                RowBox[{"|", "\[NegativeThinSpace]", GridBox[{
                      {\(x\_2\), \(x\_3\)},
                      {\(y\_2\), \(y\_3\)}
                      }], "\[NegativeThinSpace]", "|"}],
                "TraditionalForm"], ",", 
              RowBox[{"-", " ", 
                RowBox[{"|", "\[NegativeThinSpace]", GridBox[{
                      {\(x\_1\), \(x\_3\)},
                      {\(y\_1\), \(y\_3\)}
                      }], "\[NegativeThinSpace]", "|"}]}], ",", 
              RowBox[{"|", "\[NegativeThinSpace]", GridBox[{
                    {\(x\_1\), \(x\_2\)},
                    {\(y\_1\), \(y\_2\)}
                    }], "\[NegativeThinSpace]", "|"}]}], " ", ")"}], " ", 
          "=", 
          RowBox[{
            RowBox[{\((\(x\_2\) y\_3 - \(x\_3\) y\_2)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], " ", "+", 
            RowBox[{\((\(x\_3\) y\_1 - \(x\_1\) y\_3)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], " ", "+", " ", 
            RowBox[{\((\(x\_1\) y\_2 - \(x\_2\) y\_1)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell["\<\
No es imprescindible memorizar esta definici\[OAcute]n pues se verifica \
que:\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(x\ \[Times]\ y\), "=", 
        RowBox[{
          RowBox[{"determinante", " ", 
            RowBox[{"(", GridBox[{
                  {
                    StyleBox["i",
                      FontWeight->"Bold"], 
                    StyleBox["j",
                      FontWeight->"Bold"], 
                    StyleBox["k",
                      FontWeight->"Bold"]},
                  {\(x\_1\), \(x\_2\), \(x\_3\)},
                  {\(y\_1\), \(y\_2\), \(y\_3\)}
                  }], ")"}]}], "=", 
          RowBox[{
            RowBox[{\((\(x\_2\) y\_3 - \(x\_3\) y\_2)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\((\(x\_3\) y\_1 - \(x\_1\) y\_3)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", " ", 
            RowBox[{\((\(x\_1\) y\_2 - \(x\_2\) y\_1)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Donde el determinante de la matriz se ha calculado formalmente \
considerando ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(i, \ j, \ k\),
          FontWeight->"Bold"], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold"],
  "como s\[IAcute]mbolos algebraicos. De aqu\[IAcute] se deduce que el \
producto vectorial ",
  Cell[BoxData[
      \(TraditionalForm\`x\[Times]y\)]],
  " es nulo cuando los vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  " son linealmente dependientes (suele decirse que son paralelos)."
}], "Text"],

Cell[TextData[{
  "Las siguientes propiedades del producto vectorial son f\[AAcute]ciles de \
comprobar.\n",
  Cell[BoxData[
      \(TraditionalForm\`x\[Times]y = \(-y\)\[Times]x\)]],
  " (es anticonmutativo)\n",
  Cell[BoxData[
      \(TraditionalForm\`\((\[Alpha]\ x + \[Beta]\ y)\)\[Times]
          z = \[Alpha](x\[Times]y) + \[Beta](y\[Times]z)\)]],
  " (linealidad)\nUsando estas propiedades y sabiendo que ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(i\[Times]i = \(j\[Times]j = \(k\[Times]k = 0\)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(i\[Times]j = k\),
          FontWeight->"Bold"], TraditionalForm]]],
  ",",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(\ \)\(i\[Times]k = \(-j\)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(j\[Times]k = \(-i\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  ", es f\[AAcute]cil calcular productos vectoriales. Una precauci\[OAcute]n \
que debes tener al trabajar con productos vectoriales es no usar la propiedad \
asociativa porque, en general, es falsa. Por ejemplo ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            StyleBox["i",
              FontWeight->"Bold",
              FontSlant->"Italic"], 
            StyleBox["\[Times]",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            RowBox[{
              StyleBox["(",
                FontWeight->"Bold",
                FontSlant->"Italic"], 
              RowBox[{
                StyleBox["i",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox["\[Times]",
                  FontWeight->"Bold",
                  FontSlant->"Plain"], 
                StyleBox["j",
                  FontWeight->"Bold",
                  FontSlant->"Italic"]}], 
              StyleBox[")",
                FontWeight->"Bold",
                FontSlant->"Italic"]}]}], 
          StyleBox["=",
            FontWeight->"Bold"], 
          StyleBox[\(i\[Times]k = \(-j\)\),
            FontWeight->"Bold"]}], TraditionalForm]]],
  " pero ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\((i\[Times]i)\)\[Times]j = \(0\[Times]j = 0\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  "."
}], "Text"],

Cell["\<\
Vamos a calcular la norma eucl\[IAcute]dea del producto vectorial. Tenemos \
que:\
\>", "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          RowBox[{
            FormBox[\(\(\( || x\[Times]y\)\( || \^2\)\) = \),
              "TraditionalForm"], 
            
            FormBox[\(\((\(x\_2\) y\_3 - \(x\_3\) y\_2)\)\^2 + 
                  \((\(x\_3\) y\_1 - \(x\_1\) y\_3)\)\^2 + \ 
                  \((\(x\_1\) y\_2 - \(x\_2\) y\_1)\)\^2 = \),
              "TraditionalForm"], \(\((x\_1 + x\_2 + x\_3)\)\^2\), 
            \(\((\(x\_1\) y\_1 + y\_2 + y\_3)\)\^2\)}], "-", 
          \(\((\(x\_1\) y\_1 + \(x\_2\) y\_2 + \(x\_3\) y\_3)\)\^2\)}], "=", 
        "\n", \(\( || x\( || \^2\) || y
            \( || \^2\)\(-\ 
              \[LeftAngleBracket]x\  | \ y\[RightAngleBracket]\^2\)\) = \ 
          \(\( || x\( || \^2\) || y\( || \^2\)\ 
              \(-\ \ \( || x\( || \^2\) || y\( || \^2\)\ 
                  \(cos\^2\)(t)\)\)\) = 
            \( || x\( || \^2\) || y\( || \^2\)\(sen\^2\)(t)\)\)\)}], 
      TraditionalForm]]]], "Text"],

Cell[TextData[{
  "siendo ",
  StyleBox["t",
    FontSlant->"Italic"],
  " la medida en radianes del \[AAcute]ngulo que forman los vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y. ",
    FontSlant->"Italic"],
  "Como ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] \[Pi]\)]],
  ", se tiene que ",
  Cell[BoxData[
      \(TraditionalForm\`sen(t) \[GreaterEqual] 0\)]],
  ", y deducimos que ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\(||\)\(x\[Times]
              y\)\)\(||\)\) = \(\(||\)\(x\)\(||\)\(||\)\(y\)\(||\)\(sen(
            t)\)\)\)]],
  ". Realmente, hemos probado la bonita",
  StyleBox[" identidad de Lagrange",
    FontWeight->"Bold"],
  ": "
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(\(||\)\(x\)\( || \^2\)\(||\)\(y\)\( || \^2\)\), "=", 
        RowBox[{
          RowBox[{
            SuperscriptBox[
              RowBox[{"(", 
                RowBox[{"x", 
                  StyleBox[".",
                    FontWeight->"Bold"], 
                  StyleBox["y",
                    FontWeight->"Plain"]}], 
                StyleBox[")",
                  FontWeight->"Plain"]}], "2"], "+"}], 
          "||", \(x\[Times]y\), \( || \^2\)}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell["\<\
que relaciona la norma, el producto escalar y el producto vectorial.\
\>", "Text"],

Cell[TextData[{
  "En algunos textos de f\[IAcute]sica se emplea la notaci\[OAcute]n ",
  StyleBox["x",
    FontSlant->"Italic"],
  "\[And]",
  StyleBox["y",
    FontSlant->"Italic"],
  " para representar el producto vectorial ",
  Cell[BoxData[
      \(TraditionalForm\`x\ \[Times]\ y\)]],
  ". "
}], "Text"],

Cell[TextData[{
  "Tambi\[EAcute]n usaremos de aqu\[IAcute] en adelante las letras ",
  StyleBox["i",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", ",
  StyleBox["j",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " para representar los vectores de la base can\[OAcute]nica de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  ", es decir, los vectores (1,0) y (0,1). El contexto indicar\[AAcute] \
claramente cu\[AAcute]ndo dichas letras representan vectores de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " o de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Con ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " puedes calcular el producto escalar y el producto vectorial de dos \
vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  " con los comandos ",
  Cell[BoxData[
      FormBox[
        RowBox[{"x", 
          StyleBox[".",
            FontWeight->"Bold"], "y"}], TraditionalForm]]],
  " (o tambi\[EAcute]n Dot[x,y]) y Cross[x,y] respectivamente. \
Adem\[AAcute]s, podemos comprobar que el vector ",
  Cell[BoxData[
      \(TraditionalForm\`\(x\ \[Times]\ y\ \ \ \)\)]],
  "es ortogonal a los vectores ",
  StyleBox["x",
    FontSlant->"Italic"],
  " e ",
  StyleBox["y",
    FontSlant->"Italic"],
  ".  Comprobamos tambi\[EAcute]n que el vector  ",
  Cell[BoxData[
      \(TraditionalForm\`x - \(\[CapitalPi]\_y\)(x)\)]],
  StyleBox[" ",
    FontSlant->"Italic"],
  "es ortogonal a ",
  StyleBox["y.",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(X = {x\_1, x\_2, x\_3};\)\), "\n", 
    \(\(Y = {y\_1, y\_2, y\_3};\)\), "\n", 
    \(Cross[X, Y]\), "\n", 
    \(X . Cross[X, Y] // Simplify\), "\n", 
    \(Y . Cross[X, Y] // Simplify\), "\n", 
    \(\((X - \(X . Y\/Y . Y\) Y)\) . Y // Simplify\), "\n", 
    \(Clear[X, Y]\)}], "Input"],

Cell[BoxData[
    \({\(-x\_3\)\ y\_2 + x\_2\ y\_3, 
      x\_3\ y\_1 - x\_1\ y\_3, \(-x\_2\)\ y\_1 + x\_1\ y\_2}\)], "Output"],

Cell[BoxData[
    \(0\)], "Output"],

Cell[BoxData[
    \(0\)], "Output"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "En la definici\[OAcute]n de muchas magnitudes f\[IAcute]sicas intervienen \
el producto escalar o el producto vectorial. Los siguientes ejemplos son \
significativos.\n",
  StyleBox["Trabajo",
    FontWeight->"Bold"],
  ". El trabajo, ",
  StyleBox["W",
    FontSlant->"Italic"],
  ", realizado por una fuerza constante ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " (recuerda que la fuerza es un vector) al mover un objeto un \
desplazamiento ",
  StyleBox["d",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " (vector desplazamiento) viene dado por el producto escalar ",
  StyleBox["W",
    FontSlant->"Italic"],
  "=",
  StyleBox["F.d",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ".\n",
  StyleBox["Momento de una fuerza (par de torsi\[OAcute]n)",
    FontWeight->"Bold"],
  ". El momento, ",
  StyleBox["\[Tau]",
    FontWeight->"Bold"],
  ", tambi\[EAcute]n llamado par de torsi\[OAcute]n, de una fuerza ",
  StyleBox["F",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " que act\[UAcute]a en un punto ",
  StyleBox["a",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  "del espacio con vector de posici\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            FontWeight->"Bold"], "a"], TraditionalForm]]],
  " respecto de un punto ",
  StyleBox["b",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " con vector de posici\[OAcute]n ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["r",
            FontWeight->"Bold"], "b"], TraditionalForm]]],
  " est\[AAcute] dado por el producto vectorial ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["\[Tau]",
            FontWeight->"Bold"], "=", 
          RowBox[{
            RowBox[{"(", 
              RowBox[{
                SubscriptBox[
                  StyleBox["r",
                    FontWeight->"Bold"], "a"], "-", 
                SubscriptBox[
                  StyleBox["r",
                    FontWeight->"Bold"], "b"]}], ")"}], "\[Times]", 
            StyleBox["F",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ".\n",
  StyleBox["Momento cin\[EAcute]tico (o momento angular)",
    FontWeight->"Bold"],
  ". Sea una part\[IAcute]cula de masa ",
  StyleBox["m",
    FontSlant->"Italic"],
  ", con una velocidad ",
  StyleBox["v",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " situada en un punto cuyo vector de posici\[OAcute]n es ",
  StyleBox["r",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". El momento cin\[EAcute]tico, ",
  StyleBox["L",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", (respecto al origen) de dicha part\[IAcute]cula se define como ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["L",
            FontWeight->"Bold"], "=", 
          RowBox[{
            StyleBox["r",
              FontWeight->"Bold"], "\[Times]", "m", " ", 
            StyleBox["v",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ".\n",
  StyleBox[
  "Fuerza magn\[EAcute]tica ejercida por un campo magn\[EAcute]tico sobre una \
carga",
    FontWeight->"Bold"],
  ". Una carga ",
  StyleBox["q",
    FontSlant->"Italic"],
  " que se mueve con velocidad ",
  StyleBox["v",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " en un campo magn\[EAcute]tico constante ",
  StyleBox["B ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "experimenta una fuerza magn\[EAcute]tica, ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["F",
            FontWeight->"Bold"], "m"], TraditionalForm]]],
  ", dada por ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          SubscriptBox[
            StyleBox["F",
              FontWeight->"Bold"], "m"], "=", 
          RowBox[{"q", " ", 
            StyleBox["v",
              FontWeight->"Bold"], "\[Times]", 
            StyleBox["B",
              FontWeight->"Bold"]}]}], TraditionalForm]]],
  ". De hecho, esta igualdad se usa para ",
  StyleBox["definir",
    FontSlant->"Italic"],
  " el vector ",
  StyleBox["B",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " (que se llama tambi\[EAcute]n ",
  StyleBox["densidad de flujo magn\[EAcute]tico",
    FontSlant->"Italic"],
  ")."
}], "Text"],

Cell["\<\
Con la primitiva gr\[AAcute]fica Arrow[base,extremo,opciones] puedes \
representar un vector en el plano que va del punto \"base\" al punto \
\"extremo\". Necesitamos cargar el correspondiente paquete.\
\>", "Text"],

Cell["<<Graphics`Arrow`", "Input",
  CellTags->"S5.32.1"],

Cell["\<\
Para usar colores con comodidad podemos cargar el paquete \"Colors\".\
\>", "Text"],

Cell["<<Graphics`Colors`", "Input",
  CellTags->"S5.32.1"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[
        Graphics[{Red, Arrow[{ .5, \(- .5\)}, {\(- .5\), 1.5}], Blue, 
            Arrow[{\(- .5\),  .5}, {1.5, \(- .5\)}]}, 
          AspectRatio -> Automatic, Axes -> True]];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.261905 0.47619 0.261905 0.47619 [
[.02381 .2494 -12 -9 ]
[.02381 .2494 12 0 ]
[.5 .2494 -9 -9 ]
[.5 .2494 9 0 ]
[.7381 .2494 -3 -9 ]
[.7381 .2494 3 0 ]
[.97619 .2494 -9 -9 ]
[.97619 .2494 9 0 ]
[.2494 .02381 -24 -4.5 ]
[.2494 .02381 0 4.5 ]
[.2494 .5 -18 -4.5 ]
[.2494 .5 0 4.5 ]
[.2494 .7381 -6 -4.5 ]
[.2494 .7381 0 4.5 ]
[.2494 .97619 -18 -4.5 ]
[.2494 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .2619 m
.02381 .26815 L
s
[(-0.5)] .02381 .2494 0 1 Mshowa
.5 .2619 m
.5 .26815 L
s
[(0.5)] .5 .2494 0 1 Mshowa
.7381 .2619 m
.7381 .26815 L
s
[(1)] .7381 .2494 0 1 Mshowa
.97619 .2619 m
.97619 .26815 L
s
[(1.5)] .97619 .2494 0 1 Mshowa
.125 Mabswid
.07143 .2619 m
.07143 .26565 L
s
.11905 .2619 m
.11905 .26565 L
s
.16667 .2619 m
.16667 .26565 L
s
.21429 .2619 m
.21429 .26565 L
s
.30952 .2619 m
.30952 .26565 L
s
.35714 .2619 m
.35714 .26565 L
s
.40476 .2619 m
.40476 .26565 L
s
.45238 .2619 m
.45238 .26565 L
s
.54762 .2619 m
.54762 .26565 L
s
.59524 .2619 m
.59524 .26565 L
s
.64286 .2619 m
.64286 .26565 L
s
.69048 .2619 m
.69048 .26565 L
s
.78571 .2619 m
.78571 .26565 L
s
.83333 .2619 m
.83333 .26565 L
s
.88095 .2619 m
.88095 .26565 L
s
.92857 .2619 m
.92857 .26565 L
s
.25 Mabswid
0 .2619 m
1 .2619 L
s
.2619 .02381 m
.26815 .02381 L
s
[(-0.5)] .2494 .02381 1 0 Mshowa
.2619 .5 m
.26815 .5 L
s
[(0.5)] .2494 .5 1 0 Mshowa
.2619 .7381 m
.26815 .7381 L
s
[(1)] .2494 .7381 1 0 Mshowa
.2619 .97619 m
.26815 .97619 L
s
[(1.5)] .2494 .97619 1 0 Mshowa
.125 Mabswid
.2619 .07143 m
.26565 .07143 L
s
.2619 .11905 m
.26565 .11905 L
s
.2619 .16667 m
.26565 .16667 L
s
.2619 .21429 m
.26565 .21429 L
s
.2619 .30952 m
.26565 .30952 L
s
.2619 .35714 m
.26565 .35714 L
s
.2619 .40476 m
.26565 .40476 L
s
.2619 .45238 m
.26565 .45238 L
s
.2619 .54762 m
.26565 .54762 L
s
.2619 .59524 m
.26565 .59524 L
s
.2619 .64286 m
.26565 .64286 L
s
.2619 .69048 m
.26565 .69048 L
s
.2619 .78571 m
.26565 .78571 L
s
.2619 .83333 m
.26565 .83333 L
s
.2619 .88095 m
.26565 .88095 L
s
.2619 .92857 m
.26565 .92857 L
s
.25 Mabswid
.2619 0 m
.2619 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
1 0 0 r
.5 Mabswid
.5 .02381 m
.02381 .97619 L
s
% Start of user PostScript
0.5 -0.5 -0.5 1.5 MAarrowhead1
% End of user PostScript
0 0 1 r
.02381 .5 m
.97619 .02381 L
s
% Start of user PostScript
-0.5 0.5 1.5 -0.5 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False]
}, Open  ]],

Cell["Podemos modificar ese comando como sigue.", "Text"],

Cell[BoxData[
    \(\(\(vector2D[x_: {0, 0}, y_]\)\(:=\)\(Arrow[x, x + y]\)\(\ \)\( (*\ 
        traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x . \ 
              Por\ defecto\ x = {0, 0}*) \)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[
        Graphics[{Green, vector2D[{ .2,  .4}], Blue, 
            vector2D[{ .2,  .2}, { .2,  .4}], Red, PointSize[0.02], 
            Point[{ .2,  .2}]}, Axes -> True, 
          AspectRatio -> Automatic]];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 2.38095 0.0357143 2.38095 [
[.2619 .02321 -9 -9 ]
[.2619 .02321 9 0 ]
[.5 .02321 -9 -9 ]
[.5 .02321 9 0 ]
[.7381 .02321 -9 -9 ]
[.7381 .02321 9 0 ]
[.97619 .02321 -9 -9 ]
[.97619 .02321 9 0 ]
[.01131 .27381 -18 -4.5 ]
[.01131 .27381 0 4.5 ]
[.01131 .5119 -18 -4.5 ]
[.01131 .5119 0 4.5 ]
[.01131 .75 -18 -4.5 ]
[.01131 .75 0 4.5 ]
[.01131 .9881 -18 -4.5 ]
[.01131 .9881 0 4.5 ]
[.01131 1.22619 -18 -4.5 ]
[.01131 1.22619 0 4.5 ]
[.01131 1.46429 -18 -4.5 ]
[.01131 1.46429 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.2619 .03571 m
.2619 .04196 L
s
[(0.1)] .2619 .02321 0 1 Mshowa
.5 .03571 m
.5 .04196 L
s
[(0.2)] .5 .02321 0 1 Mshowa
.7381 .03571 m
.7381 .04196 L
s
[(0.3)] .7381 .02321 0 1 Mshowa
.97619 .03571 m
.97619 .04196 L
s
[(0.4)] .97619 .02321 0 1 Mshowa
.125 Mabswid
.07143 .03571 m
.07143 .03946 L
s
.11905 .03571 m
.11905 .03946 L
s
.16667 .03571 m
.16667 .03946 L
s
.21429 .03571 m
.21429 .03946 L
s
.30952 .03571 m
.30952 .03946 L
s
.35714 .03571 m
.35714 .03946 L
s
.40476 .03571 m
.40476 .03946 L
s
.45238 .03571 m
.45238 .03946 L
s
.54762 .03571 m
.54762 .03946 L
s
.59524 .03571 m
.59524 .03946 L
s
.64286 .03571 m
.64286 .03946 L
s
.69048 .03571 m
.69048 .03946 L
s
.78571 .03571 m
.78571 .03946 L
s
.83333 .03571 m
.83333 .03946 L
s
.88095 .03571 m
.88095 .03946 L
s
.92857 .03571 m
.92857 .03946 L
s
.25 Mabswid
0 .03571 m
1 .03571 L
s
.02381 .27381 m
.03006 .27381 L
s
[(0.1)] .01131 .27381 1 0 Mshowa
.02381 .5119 m
.03006 .5119 L
s
[(0.2)] .01131 .5119 1 0 Mshowa
.02381 .75 m
.03006 .75 L
s
[(0.3)] .01131 .75 1 0 Mshowa
.02381 .9881 m
.03006 .9881 L
s
[(0.4)] .01131 .9881 1 0 Mshowa
.02381 1.22619 m
.03006 1.22619 L
s
[(0.5)] .01131 1.22619 1 0 Mshowa
.02381 1.46429 m
.03006 1.46429 L
s
[(0.6)] .01131 1.46429 1 0 Mshowa
.125 Mabswid
.02381 .08333 m
.02756 .08333 L
s
.02381 .13095 m
.02756 .13095 L
s
.02381 .17857 m
.02756 .17857 L
s
.02381 .22619 m
.02756 .22619 L
s
.02381 .32143 m
.02756 .32143 L
s
.02381 .36905 m
.02756 .36905 L
s
.02381 .41667 m
.02756 .41667 L
s
.02381 .46429 m
.02756 .46429 L
s
.02381 .55952 m
.02756 .55952 L
s
.02381 .60714 m
.02756 .60714 L
s
.02381 .65476 m
.02756 .65476 L
s
.02381 .70238 m
.02756 .70238 L
s
.02381 .79762 m
.02756 .79762 L
s
.02381 .84524 m
.02756 .84524 L
s
.02381 .89286 m
.02756 .89286 L
s
.02381 .94048 m
.02756 .94048 L
s
.02381 1.03571 m
.02756 1.03571 L
s
.02381 1.08333 m
.02756 1.08333 L
s
.02381 1.13095 m
.02756 1.13095 L
s
.02381 1.17857 m
.02756 1.17857 L
s
.02381 1.27381 m
.02756 1.27381 L
s
.02381 1.32143 m
.02756 1.32143 L
s
.02381 1.36905 m
.02756 1.36905 L
s
.02381 1.41667 m
.02756 1.41667 L
s
.25 Mabswid
.02381 0 m
.02381 1.5 L
s
0 0 m
1 0 L
1 1.5 L
0 1.5 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 1 0 r
.5 Mabswid
.02381 .03571 m
.5 .9881 L
s
% Start of user PostScript
0 0 0.2 0.4 MAarrowhead1
% End of user PostScript
0 0 1 r
.5 .5119 m
.97619 1.46429 L
s
% Start of user PostScript
0.2 0.2 0.4 0.6 MAarrowhead1
% End of user PostScript
1 0 0 r
.02 w
.5 .5119 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{192, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False]
}, Open  ]],

Cell[TextData[{
  "Las bases ortonormales en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " son de la forma ",
  Cell[BoxData[
      \(TraditionalForm\`B = {\((a, b)\), \((\(-b\), a)\)}\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`a\^2 + b\^2 = 1\)]],
  ". En la siguiente firgura puedes ver la representaci\[OAcute]n de un \
vector de ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  " en una base ortonormal."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(u = {\(-1\)\/\@2, 1\/\@2}; v = {\(-1\)\/\@2, \(-1\)\/\@2}; 
    x = {1, 2};\), "\n", 
    \(\(Show[
        Graphics[{Green, vector2D[u], Green, vector2D[v], Red, vector2D[x], 
            Blue, vector2D[\((x . u)\) u], vector2D[\((x . v)\) v]}, 
          Axes -> True, AspectRatio -> Automatic]];\)\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.22654 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.328931 0.431507 0.334325 0.431507 [
[.11318 .32182 -12 -9 ]
[.11318 .32182 12 0 ]
[.54468 .32182 -9 -9 ]
[.54468 .32182 9 0 ]
[.76044 .32182 -3 -9 ]
[.76044 .32182 3 0 ]
[.97619 .32182 -9 -9 ]
[.97619 .32182 9 0 ]
[.31643 .11857 -24 -4.5 ]
[.31643 .11857 0 4.5 ]
[.31643 .55008 -18 -4.5 ]
[.31643 .55008 0 4.5 ]
[.31643 .76583 -6 -4.5 ]
[.31643 .76583 0 4.5 ]
[.31643 .98158 -18 -4.5 ]
[.31643 .98158 0 4.5 ]
[.31643 1.19734 -6 -4.5 ]
[.31643 1.19734 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.22654 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11318 .33432 m
.11318 .34057 L
s
[(-0.5)] .11318 .32182 0 1 Mshowa
.54468 .33432 m
.54468 .34057 L
s
[(0.5)] .54468 .32182 0 1 Mshowa
.76044 .33432 m
.76044 .34057 L
s
[(1)] .76044 .32182 0 1 Mshowa
.97619 .33432 m
.97619 .34057 L
s
[(1.5)] .97619 .32182 0 1 Mshowa
.125 Mabswid
.15633 .33432 m
.15633 .33807 L
s
.19948 .33432 m
.19948 .33807 L
s
.24263 .33432 m
.24263 .33807 L
s
.28578 .33432 m
.28578 .33807 L
s
.37208 .33432 m
.37208 .33807 L
s
.41523 .33432 m
.41523 .33807 L
s
.45838 .33432 m
.45838 .33807 L
s
.50153 .33432 m
.50153 .33807 L
s
.58783 .33432 m
.58783 .33807 L
s
.63099 .33432 m
.63099 .33807 L
s
.67414 .33432 m
.67414 .33807 L
s
.71729 .33432 m
.71729 .33807 L
s
.80359 .33432 m
.80359 .33807 L
s
.84674 .33432 m
.84674 .33807 L
s
.88989 .33432 m
.88989 .33807 L
s
.93304 .33432 m
.93304 .33807 L
s
.07003 .33432 m
.07003 .33807 L
s
.02688 .33432 m
.02688 .33807 L
s
.25 Mabswid
0 .33432 m
1 .33432 L
s
.32893 .11857 m
.33518 .11857 L
s
[(-0.5)] .31643 .11857 1 0 Mshowa
.32893 .55008 m
.33518 .55008 L
s
[(0.5)] .31643 .55008 1 0 Mshowa
.32893 .76583 m
.33518 .76583 L
s
[(1)] .31643 .76583 1 0 Mshowa
.32893 .98158 m
.33518 .98158 L
s
[(1.5)] .31643 .98158 1 0 Mshowa
.32893 1.19734 m
.33518 1.19734 L
s
[(2)] .31643 1.19734 1 0 Mshowa
.125 Mabswid
.32893 .16172 m
.33268 .16172 L
s
.32893 .20487 m
.33268 .20487 L
s
.32893 .24802 m
.33268 .24802 L
s
.32893 .29117 m
.33268 .29117 L
s
.32893 .37748 m
.33268 .37748 L
s
.32893 .42063 m
.33268 .42063 L
s
.32893 .46378 m
.33268 .46378 L
s
.32893 .50693 m
.33268 .50693 L
s
.32893 .59323 m
.33268 .59323 L
s
.32893 .63638 m
.33268 .63638 L
s
.32893 .67953 m
.33268 .67953 L
s
.32893 .72268 m
.33268 .72268 L
s
.32893 .80898 m
.33268 .80898 L
s
.32893 .85213 m
.33268 .85213 L
s
.32893 .89528 m
.33268 .89528 L
s
.32893 .93843 m
.33268 .93843 L
s
.32893 1.02473 m
.33268 1.02473 L
s
.32893 1.06789 m
.33268 1.06789 L
s
.32893 1.11104 m
.33268 1.11104 L
s
.32893 1.15419 m
.33268 1.15419 L
s
.32893 .07542 m
.33268 .07542 L
s
.32893 .03227 m
.33268 .03227 L
s
.25 Mabswid
.32893 0 m
.32893 1.22654 L
s
0 0 m
1 0 L
1 1.22654 L
0 1.22654 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
0 1 0 r
.5 Mabswid
.32893 .33432 m
.02381 .63945 L
s
% Start of user PostScript
0 0 -0.707107 0.707107 MAarrowhead1
% End of user PostScript
.32893 .33432 m
.02381 .0292 L
s
% Start of user PostScript
0 0 -0.707107 -0.707107 MAarrowhead1
% End of user PostScript
1 0 0 r
.32893 .33432 m
.76044 1.19734 L
s
% Start of user PostScript
0 0 1. 2. MAarrowhead1
% End of user PostScript
0 0 1 r
.32893 .33432 m
.11318 .55008 L
s
% Start of user PostScript
0 0 -0.5 0.5 MAarrowhead1
% End of user PostScript
.32893 .33432 m
.97619 .98158 L
s
% Start of user PostScript
0 0 1.5 1.5 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{234.75, 287.875},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False]
}, Open  ]],

Cell["\<\
En la figura siguiente puedes ver, para el caso de dos dimensiones, una \
representaci\[OAcute]n gr\[AAcute]fica de la proyecci\[OAcute]n ortogonal de \
un vector sobre otro.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(x = {0.6, 0.3};\)\), "\n", 
    \(\(y = {0.8, \(- .4\)};\)\), "\n", 
    \(w = \((x . y)\)*y/\((y . y)\)\ \ ; \  (*\ 
      proyecci\[OAcute]n\ ortogonal\ de\ x\ sobre\ y\ *) \n
    z = x - w\ \ ; \  (*\ es\ un\ vector\ ortogonal\ a\ y\ *) \n
    Show[Graphics[{Red, vector2D[x], vector2D[y], Blue, vector2D[w], Green, 
          vector2D[z], vector2D[w, z], Black, Text["\<z\>", z/2 + {0,  .1}], 
          Text["\<Tz\>", z/2 + {0,  .1} + w], Text["\<x\>", x/2 + {0,  .05}], 
          Text["\<y\>", 0.7*y - {0, 0.05}], Text["\<w\>", w/2 - {0,  .05}], 
          Text["\<O\>", {\(- .03\), \(- .03\)}], 
          Text["\<X\>", x + { .03,  .03}], Text["\<W\>", w - { .03,  .03}]}, 
        TextStyle -> {FontFamily -> "\<Times\>", \ FontSize -> 12}, 
        Axes -> True, AspectRatio -> Automatic, Ticks -> None]];\), "\n", 
    \(Print["\<w=(x.y)y/(y.y) es la proyeccci\[OAcute]n ortogonal de x sobre \
y \nz=x-w es un vector ortogonal a y\nTz es la traslaci\[OAcute]n del vector \
z alPunto W\nEl tri\[AAcute]ngulo OWX es rect\[AAcute]ngulo\nOberva que \
||z||=||Tz|| es la distancia del punto X a la recta vectorial\ngenerada por \
el vector y\>"]\), "\n", 
    \(z . y // Chop\  (*\ 
      el\ producto\ escalar\ de\ z\ por\ y\ es\ cero\ *) \), "\n", 
    \(Clear[x, y, w, z]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.06024 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0582329 1.14745 0.484223 1.14745 [
[ 0 0 0 0 ]
[ 1 1.06024 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .48422 m
1 .48422 L
s
.05823 0 m
.05823 1.06024 L
s
0 0 m
1 0 L
1 1.06024 L
0 1.06024 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
1 0 0 r
.5 Mabswid
.05823 .48422 m
.7467 .82846 L
s
% Start of user PostScript
0 0 0.6 0.3 MAarrowhead1
% End of user PostScript
.05823 .48422 m
.97619 .02524 L
s
% Start of user PostScript
0 0 0.8 -0.4 MAarrowhead1
% End of user PostScript
0 0 1 r
.05823 .48422 m
.47131 .27768 L
s
% Start of user PostScript
0 0 0.36 -0.18 MAarrowhead1
% End of user PostScript
0 1 0 r
.05823 .48422 m
.33362 1.035 L
s
% Start of user PostScript
0 0 0.24 0.48 MAarrowhead1
% End of user PostScript
.47131 .27768 m
.7467 .82846 L
s
% Start of user PostScript
0.36 -0.18 0.6 0.3 MAarrowhead1
% End of user PostScript
0 0 0 r
gsave
.19593 .87435 -65.6563 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
68.313 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.60901 .66781 -69.4063 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Tz) show
75.813 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.40247 .71371 -65.9063 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
68.813 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.7008 .10557 -65.7813 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
68.563 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.26477 .32358 -67.3438 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
71.688 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.02381 .4498 -67.3438 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(O) show
71.688 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.78112 .86288 -67.3438 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(X) show
71.688 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.43689 .24326 -68.5625 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
74.125 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{271.625, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[BoxData[
    \("w=(x.y)y/(y.y) es la proyeccci\[OAcute]n ortogonal de x sobre y \n\
z=x-w es un vector ortogonal a y\nTz es la traslaci\[OAcute]n del vector z \
alPunto W\nEl tri\[AAcute]ngulo OWX es rect\[AAcute]ngulo\nOberva que \
||z||=||Tz|| es la distancia del punto X a la recta vectorial\ngenerada por \
el vector y"\)], "Print"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell["\<\
Vamos a definir un comando para representar vectores en el espacio. \
Necesitamos algunos comandos previos que tienen su propio inter\[EAcute]s.\
\>", "Text"],

Cell[BoxData[
    \(\(\(norma[x_] := N[\@\(x . x\)]\  (*\ 
      norma\ eucl\[IAcute]dea\ del\ vector\ x\ *) \n
    \(\(normaliza[x_]\  := If[Simplify[x . x] == 0, x, \ x/norma[x]]; \  (*\ 
      vector\ unitario\ en\ la\ direcci\[OAcute]n\ del\ vector\ x\ *) \n
    normal3D[x_]\  := \ 
      normaliza[
        Which[x[\([1]\)] == 0, {1, 0, 
            0}, \((x[\([2]\)] \[NotEqual] 
                0)\) \[Or] \((x[\([3]\)] \[NotEqual] 0)\), {0, 
            x[\([3]\)], \(-x[\([2]\)]\)}, \((x[\([2]\)] == 0 \[And] 
              x[\([3]\)] == 0)\), {0, 1, 0}]]\)\(\n\)
    \)\)\( (*\ 
      un\ vector\ unitario\ ortogonal\ al\ vector\ x\ *) \)\)\)], "Input"],

Cell[BoxData[
    \(\(\(\(arrow3D[x_, y_, color_:  RGBColor[0. , 0. , 0. ], 
          grosor_:  0.007] := \n\t\t\t{{color, Thickness[grosor], 
            Line[{x, y}]}, \n\ \ \ \ \ {SurfaceColor[
              color], \ \(Polygon[
                  Append[#, 
                    y]] &\)\  /@ \ \n\t\t\t\t\t\tPartition[\(\((y\ \  - \ 
                        0.18*\((y - x)\) + \ #)\) &\) /@ \((\((0.3*\ 0.18*
                          norma[y - x]*\ 
                          Table[{Cos[2\ k\ Pi/8. ], \ Sin[2\ k\ Pi/8. ]}, {k, 
                              0, 8}])\) . {normal3D[y - x], 
                        normaliza[Cross[normal3D[y - x], y - x]]})\), 2, 
                1]}};\)\n
    vector3D[x_List: {0, 0, 0}, y_List, color_:  RGBColor[0. , 0. , 0. ], 
        grosor_:  0.007] := arrow3D[x, x + y, color, grosor]\)\(\ \)\( (*\ 
      traslaci\[OAcute]n\ del\ vector\ y\ al\ punto\ x\ *) \)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[
        Graphics3D[{vector3D[{1, 2, 3}, Blue,  .02], 
            vector3D[{ .5,  .5,  .5}, {1, 2, 3}, Green,  .02]}, Axes -> True, 
          PlotRange -> All]];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.64103 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.302881 1.66087 -2.05456e-017 1.66087 [
[.51364 1.6591 -3.00627 0 ]
[.51364 1.6591 2.99373 9 ]
[.66562 1.62306 -8.81237 0 ]
[.66562 1.62306 9.18763 9 ]
[.82239 1.58587 -2.86569 0 ]
[.82239 1.58587 3.13431 9 ]
[.98419 1.54748 -8.37228 0 ]
[.98419 1.54748 9.62772 9 ]
[.01228 1.27021 -3.24655 0 ]
[.01228 1.27021 2.75345 9 ]
[.222 1.43779 -3.1424 0 ]
[.222 1.43779 2.8576 9 ]
[.40729 1.58585 -3.05479 0 ]
[.40729 1.58585 2.94521 9 ]
[.06783 .21628 -6 -2.69161 ]
[.06783 .21628 0 6.30839 ]
[.04641 .46706 -6 -2.80884 ]
[.04641 .46706 0 6.19116 ]
[.02283 .74325 -6 -2.93857 ]
[.02283 .74325 0 6.06143 ]
[-0.00326 1.0489 -6 -3.08292 ]
[-0.00326 1.0489 0 5.91708 ]
[ 0 0 0 0 ]
[ 1 1.64103 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.5024 1.64103 m
1 1.52267 L
s
.51368 1.63834 m
.51371 1.62796 L
s
[(0)] .51364 1.6591 .00209 -1 Mshowa
.66518 1.6023 m
.66497 1.59193 L
s
[(0.5)] .66562 1.62306 -0.02085 -1 Mshowa
.82146 1.56513 m
.821 1.55476 L
s
[(1)] .82239 1.58587 -0.04477 -1 Mshowa
.98274 1.52677 m
.98202 1.51642 L
s
[(1.5)] .98419 1.54748 -0.06975 -1 Mshowa
.125 Mabswid
.54361 1.63122 m
.5436 1.62499 L
s
.57373 1.62406 m
.57368 1.61783 L
s
.60402 1.61685 m
.60395 1.61062 L
s
.63451 1.6096 m
.63441 1.60337 L
s
.69605 1.59496 m
.69589 1.58874 L
s
.72711 1.58758 m
.72692 1.58135 L
s
.75836 1.58014 m
.75814 1.57392 L
s
.78981 1.57266 m
.78956 1.56644 L
s
.85331 1.55756 m
.853 1.55134 L
s
.88536 1.54993 m
.88502 1.54372 L
s
.91761 1.54226 m
.91724 1.53605 L
s
.95007 1.53454 m
.94967 1.52833 L
s
.25 Mabswid
0 1.23831 m
.5024 1.64103 L
s
.01398 1.24952 m
.01483 1.23917 L
s
[(0)] .01228 1.27021 .08218 -1 Mshowa
.22299 1.41705 m
.22348 1.40669 L
s
[(1)] .222 1.43779 .04747 -1 Mshowa
.40766 1.56509 m
.40785 1.55471 L
s
[(2)] .40729 1.58585 .01826 -1 Mshowa
.125 Mabswid
.05796 1.28477 m
.05842 1.27856 L
s
.1008 1.31911 m
.10122 1.3129 L
s
.14256 1.35259 m
.14294 1.34637 L
s
.18328 1.38523 m
.18361 1.37901 L
s
.26173 1.44811 m
.26198 1.44188 L
s
.29953 1.47841 m
.29975 1.47219 L
s
.33643 1.50799 m
.33662 1.50177 L
s
.37247 1.53688 m
.37262 1.53065 L
s
.44205 1.59265 m
.44213 1.58642 L
s
.47565 1.61959 m
.4757 1.61336 L
s
.25 Mabswid
.08886 .18766 m
0 1.23831 L
s
.08709 .20854 m
.09672 .20467 L
s
[(0)] .06783 .21628 1 -0.40187 Mshowa
.06584 .45976 m
.07556 .45611 L
s
[(1)] .04641 .46706 1 -0.37581 Mshowa
.04244 .73644 m
.05225 .73304 L
s
[(2)] .02283 .74325 1 -0.34698 Mshowa
.01655 1.04267 m
.02645 1.03955 L
s
[(3)] -0.00326 1.0489 1 -0.31491 Mshowa
.125 Mabswid
.083 .25692 m
.08879 .25462 L
s
.07883 .3062 m
.08463 .30393 L
s
.07458 .35642 m
.08039 .35417 L
s
.07026 .4076 m
.07608 .40538 L
s
.06135 .51294 m
.06719 .51078 L
s
.05676 .56717 m
.06261 .56503 L
s
.05208 .62247 m
.05795 .62037 L
s
.04731 .67888 m
.05319 .67681 L
s
.03748 .79518 m
.04337 .79317 L
s
.03241 .85513 m
.03831 .85315 L
s
.02723 .91633 m
.03315 .91439 L
s
.02195 .97883 m
.02787 .97693 L
s
.01103 1.10788 m
.01698 1.10604 L
s
.0054 1.17451 m
.01136 1.17271 L
s
.25 Mabswid
.08886 .18766 m
0 1.23831 L
s
0 1.23831 m
.5024 1.64103 L
s
.5024 1.64103 m
.5061 .66364 L
s
.5061 .66364 m
.08886 .18766 L
s
.55332 0 m
.92746 .52124 L
s
.92746 .52124 m
1 1.52267 L
s
1 1.52267 m
.55886 1.07383 L
s
.55886 1.07383 m
.55332 0 L
s
.08886 .18766 m
0 1.23831 L
s
0 1.23831 m
.55886 1.07383 L
s
.55886 1.07383 m
.55332 0 L
s
.55332 0 m
.08886 .18766 L
s
.5061 .66364 m
.92746 .52124 L
s
.92746 .52124 m
1 1.52267 L
s
1 1.52267 m
.5024 1.64103 L
s
.5024 1.64103 m
.5061 .66364 L
s
0 0 m
1 0 L
1 1.64103 L
0 1.64103 L
closepath
clip
newpath
.5 Mabswid
0 0 .608 r
.59155 1.1156 m .63763 1.08932 L .7284 1.29854 L closepath p F P
0 g
s
0 0 .663 r
.63763 1.08932 m .66882 1.06572 L .7284 1.29854 L closepath p F P
0 g
s
0 1 0 r
.02 w
.33192 .38598 m
.67618 .9797 L
s
.5 Mabswid
0 0 .448 r
.5566 1.12972 m .59155 1.1156 L .7284 1.29854 L closepath p F P
0 g
s
0 0 0 r
.66882 1.06572 m .66685 1.05845 L .7284 1.29854 L closepath p F P
0 g
s
0 0 .59 r
.55323 1.12324 m .5566 1.12972 L .7284 1.29854 L closepath p F P
0 g
s
0 .463 0 r
.82734 1.29989 m .87382 1.27324 L .97187 1.48966 L closepath p F P
0 g
s
0 .365 0 r
.87382 1.27324 m .90735 1.25094 L .97187 1.48966 L closepath p F P
0 g
s
0 .471 0 r
.79416 1.31583 m .82734 1.29989 L .97187 1.48966 L closepath p F P
0 g
s
0 0 0 r
.90735 1.25094 m .90835 1.24593 L .97187 1.48966 L closepath p F P
0 g
s
0 .091 0 r
.79373 1.31163 m .79416 1.31583 L .97187 1.48966 L closepath p F P
0 g
s
0 0 .605 r
.66685 1.05845 m .63187 1.07234 L .7284 1.29854 L closepath p F P
0 g
s
0 1 0 r
.02 w
.67618 .9797 m
.68905 1.00191 L
s
.5 Mabswid
0 0 .805 r
.58439 1.09941 m .55323 1.12324 L .7284 1.29854 L closepath p F P
0 g
s
0 1 0 r
.02 w
.68905 1.00191 m
.81885 1.22575 L
s
.5 Mabswid
0 0 .717 r
.63187 1.07234 m .58439 1.09941 L .7284 1.29854 L closepath p F P
0 g
s
0 0 1 r
.02 w
.10904 .21722 m
.60697 1.08653 L
s
.5 Mabswid
0 .659 0 r
.90835 1.24593 m .87522 1.2617 L .97187 1.48966 L closepath p F P
0 g
s
0 .539 0 r
.82732 1.28916 m .79373 1.31163 L .97187 1.48966 L closepath p F P
0 g
s
0 .597 0 r
.87522 1.2617 m .82732 1.28916 L .97187 1.48966 L closepath p F P
0 g
s
0 1 0 r
.02 w
.81885 1.22575 m
.84855 1.27699 L
s
0 g
.25 Mabswid
.55332 0 m
.92746 .52124 L
s
.92746 .52124 m
1 1.52267 L
s
1 1.52267 m
.55886 1.07383 L
s
.55886 1.07383 m
.55332 0 L
s
.08886 .18766 m
0 1.23831 L
s
0 1.23831 m
.55886 1.07383 L
s
.55886 1.07383 m
.55332 0 L
s
.55332 0 m
.08886 .18766 L
s
0 1.23831 m
.5024 1.64103 L
s
.01398 1.24952 m
.01483 1.23917 L
s
[(0)] .01228 1.27021 .08218 -1 Mshowa
.22299 1.41705 m
.22348 1.40669 L
s
[(1)] .222 1.43779 .04747 -1 Mshowa
.40766 1.56509 m
.40785 1.55471 L
s
[(2)] .40729 1.58585 .01826 -1 Mshowa
.125 Mabswid
.05796 1.28477 m
.05842 1.27856 L
s
.1008 1.31911 m
.10122 1.3129 L
s
.14256 1.35259 m
.14294 1.34637 L
s
.18328 1.38523 m
.18361 1.37901 L
s
.26173 1.44811 m
.26198 1.44188 L
s
.29953 1.47841 m
.29975 1.47219 L
s
.33643 1.50799 m
.33662 1.50177 L
s
.37247 1.53688 m
.37262 1.53065 L
s
.44205 1.59265 m
.44213 1.58642 L
s
.47565 1.61959 m
.4757 1.61336 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{175.438, 287.875},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False]
}, Open  ]],

Cell[TextData[{
  "En la figura siguiente puedes ver, para el caso de tres dimensiones, una \
representaci\[OAcute]n gr\[AAcute]fica de la proyecci\[OAcute]n ortogonal de \
un vector sobre otro y una interpretaci\[OAcute]n gr\[AAcute]fica del n\
\[UAcute]mero ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(||\)\(x\[Times]
            y\)\(||\)\) = \(\(||\)\(x\)\(||\)\(||\)\(y\)\(||\)\(sen(
            t)\)\)\)]],
  " como el ",
  StyleBox["\[AAcute]rea del paralelogramo constru\[IAcute]do sobre los \
vectores",
    FontWeight->"Bold"],
  " ",
  StyleBox["x",
    FontSlant->"Italic"],
  " ",
  StyleBox["e",
    FontWeight->"Bold"],
  "  ",
  StyleBox["y",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(x = {1, 1, 1};\)\), "\n", 
    \(\(y = 1.5 {\@1.5, \@1.5, 0};\)\), "\n", 
    \(\(w = \((x . y)\)*y/\((y . y)\)\ \ \  (*\ 
        proyecci\[OAcute]n\ ortogonal\ de\ x\ sobre\ y\ *) ;\)\), "\n", 
    \(z = x - w\ \ ; \  (*\ es\ un\ vector\ ortogonal\ a\ y\ *) \n
    Show[Graphics3D[{vector3D[x, Red], vector3D[y, Red], vector3D[w, Blue], 
          vector3D[z, Green], vector3D[w, z, Green], Line[{x, x + y}], 
          Line[{y, x + y}], Text["\<z\>", z/2 + {0,  .15, 0}], 
          Text["\<x\>", x/2 + {0,  .05, 0.18}], 
          Text["\<y\>", 0.7*y - {0, 0.05, 0.1}], 
          Text["\<w\>", w/2 - {0,  .05, 0.1}], 
          Text["\<Tz\>", w +  .5*z + { .15, 0, 0}], 
          Text["\<O\>", {\(- .03\), \(- .03\), \(- .15\)}], 
          Text["\<X\>", x + { .03,  .03, 0.15}], 
          Text["\<W\>", w - { .03,  .03, 0.2}], 
          Text["\<t\>", { .2,  .4, 0.02}]}, 
        TextStyle -> {FontFamily -> "\<Times\>", \ FontSize -> 12}, 
        Axes -> True, AspectRatio -> Automatic, Ticks -> None, 
        Epilog -> {Circle[{0. , 
                0.3},  .2, {\[Pi]/8 -  .09, \[Pi]/8 +  .18}], {Blue, 
              Thickness[0.007], 
              Line[{{0.08, 0.34}, {0.35, 0.386}}]}}]];\), "\n", 
    \(Print["\<w=(x.y)y/(y.y) es la proyeccci\[OAcute]n ortogonal de x sobre \
y \nz=x-w es un vector ortogonal a y\nTz es la traslaci\[OAcute]n del vector \
z al punto W\nEl tri\[AAcute]ngulo OWX es rect\[AAcute]ngulo\n\
||Tz||=||x||sen(t) (longitud de la hipotenusa por el seno del \[AAcute]ngulo \
opuesto)\nEl \[AAcute]rea del paralelogramo constru\[IAcute]do sobre los \
vectores x e y\nviene dada por ||x\[Times]y||=||y||||x||sen(t) (longitud de \
la base por la altura)\>"]\), "\n", 
    \(z . y // Chop\  (*\ 
      el\ producto\ escalar\ de\ z\ por\ y\ es\ cero\ *) \), "\n", 
    \(Clear[x, y, w, z]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .84369 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
1.02457e-017 1.05008 -0.0522362 1.05008 [
[ 0 0 0 0 ]
[ 1 .84369 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.04314 .25422 m
.68681 0 L
s
.68681 0 m
.96442 .42793 L
s
.04314 .25422 m
0 .52643 L
s
.04314 .25422 m
0 .52643 L
s
0 .52643 m
.39814 .84369 L
s
.39814 .84369 m
.40675 .59742 L
s
.40675 .59742 m
.04314 .25422 L
s
.68681 0 m
.96442 .42793 L
s
.96442 .42793 m
1 .68823 L
s
1 .68823 m
.70335 .28495 L
s
.70335 .28495 m
.68681 0 L
s
.04314 .25422 m
0 .52643 L
s
0 .52643 m
.70335 .28495 L
s
.70335 .28495 m
.68681 0 L
s
.68681 0 m
.04314 .25422 L
s
.40675 .59742 m
.96442 .42793 L
s
.96442 .42793 m
1 .68823 L
s
1 .68823 m
.39814 .84369 L
s
.39814 .84369 m
.40675 .59742 L
s
0 0 m
1 0 L
1 .84369 L
0 .84369 L
closepath
clip
newpath
.5 Mabswid
.665 0 0 r
.55342 .38827 m .55989 .36786 L .65989 .41095 L closepath p F P
0 g
s
.705 0 0 r
.55088 .41112 m .55342 .38827 L .65989 .41095 L closepath p F P
0 g
s
.639 0 0 r
.55373 .42337 m .55088 .41112 L .65989 .41095 L closepath p F P
0 g
s
.496 0 0 r
.56044 .41765 m .55373 .42337 L .65989 .41095 L closepath p F P
0 g
s
.78 0 0 r
.56707 .39696 m .56044 .41765 L .65989 .41095 L closepath p F P
0 g
s
.819 0 0 r
.56963 .37362 m .56707 .39696 L .65989 .41095 L closepath p F P
0 g
s
.392 0 0 r
.55989 .36786 m .56661 .36165 L .65989 .41095 L closepath p F P
0 g
s
.805 0 0 r
.56661 .36165 m .56963 .37362 L .65989 .41095 L closepath p F P
0 g
s
.65989 .41095 m
.97369 .6486 L
s
0 0 .805 r
.34428 .35104 m .34731 .33955 L .40344 .36366 L closepath p F P
0 g
s
0 0 .651 r
.34256 .36375 m .34428 .35104 L .40344 .36366 L closepath p F P
0 g
s
0 0 .316 r
.34317 .37035 m .34256 .36375 L .40344 .36366 L closepath p F P
0 g
s
0 0 .988 r
.34576 .3669 m .34317 .37035 L .40344 .36366 L closepath p F P
0 g
s
0 0 .827 r
.34883 .35532 m .34576 .3669 L .40344 .36366 L closepath p F P
0 g
s
0 0 .658 r
.35056 .34245 m .34883 .35532 L .40344 .36366 L closepath p F P
0 g
s
0 0 .963 r
.34731 .33955 m .34992 .33595 L .40344 .36366 L closepath p F P
0 g
s
0 0 .265 r
.34992 .33595 m .35056 .34245 L .40344 .36366 L closepath p F P
0 g
s
1 0 0 r
.007 w
.40344 .36366 m
.56741 .3939 L
s
.07898 .30382 m
.34906 .35363 L
s
.5 Mabswid
0 .309 0 r
.39436 .52439 m .40416 .5238 L .39613 .553 L closepath p F P
0 g
s
0 .49 0 r
.38639 .52081 m .39436 .52439 L .39613 .553 L closepath p F P
0 g
s
0 0 0 r
.40416 .5238 m .41009 .51938 L .39613 .553 L closepath p F P
0 g
s
.625 0 0 r
.33642 .51587 m .34695 .50231 L .39613 .553 L closepath p F P
0 g
s
.418 0 0 r
.34695 .50231 m .35218 .49151 L .39613 .553 L closepath p F P
0 g
s
.705 0 0 r
.32663 .52441 m .33642 .51587 L .39613 .553 L closepath p F P
0 g
s
0 0 0 r
.3849 .51512 m .38639 .52081 L .39613 .553 L closepath p F P
0 g
s
0 .878 0 r
.41009 .51938 m .40868 .51369 L .39613 .553 L closepath p F P
0 g
s
0 .297 0 r
.39081 .51066 m .3849 .51512 L .39613 .553 L closepath p F P
0 g
s
0 .642 0 r
.40868 .51369 m .40069 .51006 L .39613 .553 L closepath p F P
0 g
s
.737 0 0 r
.35218 .49151 m .34902 .48978 L .39613 .553 L closepath p F P
0 g
s
0 0 0 r
.32328 .52291 m .32663 .52441 L .39613 .553 L closepath p F P
0 g
s
0 .488 0 r
.40069 .51006 m .39081 .51066 L .39613 .553 L closepath p F P
0 g
s
0 1 0 r
.007 w
.39778 .51024 m
.40344 .36366 L
s
.5 Mabswid
.833 0 0 r
.34902 .48978 m .33918 .49829 L .39613 .553 L closepath p F P
0 g
s
.59 0 0 r
.32846 .51208 m .32328 .52291 L .39613 .553 L closepath p F P
0 g
s
.729 0 0 r
.33918 .49829 m .32846 .51208 L .39613 .553 L closepath p F P
0 g
s
.39613 .553 m
.97369 .6486 L
s
1 0 0 r
.007 w
.07898 .30382 m
.33437 .50447 L
s
.5 Mabswid
0 .284 0 r
.05472 .46722 m .06472 .46659 L .05126 .49591 L closepath p F P
0 g
s
0 .502 0 r
.04574 .46339 m .05472 .46722 L .05126 .49591 L closepath p F P
0 g
s
0 0 0 r
.06472 .46659 m .06994 .46187 L .05126 .49591 L closepath p F P
0 g
s
0 .569 0 r
.04302 .45731 m .04574 .46339 L .05126 .49591 L closepath p F P
0 g
s
0 .857 0 r
.06994 .46187 m .0673 .45578 L .05126 .49591 L closepath p F P
0 g
s
0 .224 0 r
.04821 .45254 m .04302 .45731 L .05126 .49591 L closepath p F P
0 g
s
0 .639 0 r
.0673 .45578 m .05829 .4519 L .05126 .49591 L closepath p F P
0 g
s
0 .483 0 r
.05829 .4519 m .04821 .45254 L .05126 .49591 L closepath p F P
0 g
s
0 1 0 r
.007 w
.0576 .45195 m
.07898 .30382 L
s
0 g
gsave
.08769 .41657 -65.6563 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
68.313 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.23911 .46773 -65.9063 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
68.813 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.48722 .35614 -65.7813 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
68.563 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.2389 .30977 -67.3438 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
71.688 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.43045 .44546 -69.4063 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Tz) show
75.813 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.0729 .27506 -67.3438 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(O) show
71.688 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.40505 .58502 -67.3438 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(X) show
71.688 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.39547 .32658 -68.5625 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(W) show
74.125 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.17242 .34593 -64.8125 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(t) show
66.625 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.68681 0 m
.96442 .42793 L
s
.96442 .42793 m
1 .68823 L
s
1 .68823 m
.70335 .28495 L
s
.70335 .28495 m
.68681 0 L
s
.04314 .25422 m
0 .52643 L
s
0 .52643 m
.70335 .28495 L
s
.70335 .28495 m
.68681 0 L
s
.68681 0 m
.04314 .25422 L
s
.04314 .25422 m
.68681 0 L
s
.5 Mabswid
newpath
0 .26279 .21002 17.3434 32.8132 arc
s
0 0 1 r
.007 w
.08401 .30479 m
.36753 .35309 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 242.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[BoxData[
    \("w=(x.y)y/(y.y) es la proyeccci\[OAcute]n ortogonal de x sobre y \n\
z=x-w es un vector ortogonal a y\nTz es la traslaci\[OAcute]n del vector z al \
punto W\nEl tri\[AAcute]ngulo OWX es rect\[AAcute]ngulo\n||Tz||=||x||sen(t) \
(longitud de la hipotenusa por el seno del \[AAcute]ngulo opuesto)\nEl \
\[AAcute]rea del paralelogramo constru\[IAcute]do sobre los vectores x e y\n\
viene dada por ||x\[Times]y||=||y||||x||sen(t) (longitud de la base por la \
altura)"\)], "Print"],

Cell[BoxData[
    \(0\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 5", "Exercise"],

Cell[TextData[{
  "a) Calcula el \[AAcute]rea del paralelogramo de v\[EAcute]rtices (0,0,0), \
(5,0,0), (2,6,6), (7,6,6).\nb) Calcula el \[AAcute]rea del tri\[AAcute]ngulo \
de v\[EAcute]rtices (-1,1,2), (1,-1,3), (2,3,-1).\nc) Calcula el \[AAcute]rea \
del paralelogramo en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^2\)]],
  "de v\[EAcute]rtices (0,1), (3,0), (5,-2), (2,-1)."
}], "ExerciseText"],

Cell["\<\
Es conveniente disponer de un comando para representar los ejes de \
coordenadas.\
\>", "Text"],

Cell[BoxData[
    \(ejes3D[u_, v_, w_:  0.006, color_:  Black]\  := \ \ {color, 
        Thickness[w], 
        Line[{{u, 0, 0}, {v, 0, 0}}], \n\ \ \ \ Line[{{0, u, 0}, {0, v, 0}}], 
        Line[{{0, 0, u}, {0, 0, v}}]}\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(u = {1,  .6,  .3};\)\), "\n", 
    \(\(v = {\(- .2\), \(- .3\), 1};\)\), "\n", 
    \(\(w = Cross[u, v];\)\), "\n", 
    \(\(graf = 
        Show[Graphics3D[{vector3D[u, Blue,  .01], 
              Text["\<u\>", u/2 + { .1,  .1,  .1}], vector3D[v, Red,  .01], 
              Text["\<v\>", v/2 + { .02,  .1,  .1}], 
              vector3D[w, Green,  .01], Text["\<w\>", w/2 + { .1,  .1,  .1}], 
              ejes3D[\(-0.4\), 1.5]}, Boxed -> False, 
            PlotRange -> All]];\)\), "\n", 
    \(Print["\<El producto vectorial w=u\[Times]v es ortogonal a u y a v\>"]\ \
\), "\n", 
    \(Clear[u, v, w]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.10206 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0627694 1.19255 1.89735e-018 1.19255 [
[ 0 0 0 0 ]
[ 1 1.10206 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.10206 L
0 1.10206 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.29705 .41078 m
.56688 .69594 L
s
.36445 .38774 m
.34235 .85839 L
s
.26107 .51208 m
.76258 .33746 L
s
.5 Mabswid
0 0 .716 r
.64318 .54785 m .64632 .53357 L .7058 .55718 L closepath p F P
0 g
s
0 0 .52 r
.63984 .55914 m .64318 .54785 L .7058 .55718 L closepath p F P
0 g
s
0 0 .875 r
.64632 .53357 m .64746 .52455 L .7058 .55718 L closepath p F P
0 g
s
0 0 0 r
.63824 .56087 m .63984 .55914 L .7058 .55718 L closepath p F P
0 g
s
0 0 0 r
.64746 .52455 m .6459 .5261 L .7058 .55718 L closepath p F P
0 g
s
0 0 .914 r
.63935 .55189 m .63824 .56087 L .7058 .55718 L closepath p F P
0 g
s
0 0 .744 r
.64254 .53744 m .63935 .55189 L .7058 .55718 L closepath p F P
0 g
s
0 0 1 r
.01 w
.36023 .47755 m
.64145 .54235 L
s
.5 Mabswid
0 0 .561 r
.6459 .5261 m .64254 .53744 L .7058 .55718 L closepath p F P
0 g
s
.612 0 0 r
.26287 .6628 m .27554 .66471 L .24417 .6932 L closepath p F P
0 g
s
.866 0 0 r
.2523 .65445 m .26287 .6628 L .24417 .6932 L closepath p F P
0 g
s
.978 0 0 r
.24997 .6445 m .2523 .65445 L .24417 .6932 L closepath p F P
0 g
s
0 0 0 r
.27554 .66471 m .28295 .65906 L .24417 .6932 L closepath p F P
0 g
s
.199 0 0 r
.25732 .63875 m .24997 .6445 L .24417 .6932 L closepath p F P
0 g
s
.932 0 0 r
.28295 .65906 m .28072 .64908 L .24417 .6932 L closepath p F P
0 g
s
.647 0 0 r
.27009 .64065 m .25732 .63875 L .24417 .6932 L closepath p F P
0 g
s
.814 0 0 r
.28072 .64908 m .27009 .64065 L .24417 .6932 L closepath p F P
0 g
s
1 0 0 r
.01 w
.27174 .64196 m
.36023 .47755 L
s
.5 Mabswid
0 .837 0 r
.37475 .22047 m .35854 .22267 L .37499 .17487 L closepath p F P
0 g
s
0 .605 0 r
.38941 .22618 m .37475 .22047 L .37499 .17487 L closepath p F P
0 g
s
0 0 0 r
.39402 .2365 m .38941 .22618 L .37499 .17487 L closepath p F P
0 g
s
0 .984 0 r
.35854 .22267 m .3502 .23152 L .37499 .17487 L closepath p F P
0 g
s
0 .83 0 r
.38578 .24544 m .39402 .2365 L .37499 .17487 L closepath p F P
0 g
s
0 .128 0 r
.3502 .23152 m .35467 .24191 L .37499 .17487 L closepath p F P
0 g
s
0 .723 0 r
.36944 .2477 m .38578 .24544 L .37499 .17487 L closepath p F P
0 g
s
0 1 0 r
.01 w
.36023 .47755 m
.37146 .24742 L
s
.5 Mabswid
0 .562 0 r
.35467 .24191 m .36944 .2477 L .37499 .17487 L closepath p F P
0 g
s
gsave
.57209 .54793 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.32458 .61996 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.40881 .36549 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{261.313, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[BoxData[
    \("El producto vectorial w=u\[Times]v es ortogonal a u y a v"\)], "Print"]
}, Open  ]],

Cell["<<Graphics`Animation`", "Input",
  CellTags->"S5.29.1"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(SpinShow[graf]\), "\n", 
    \(\(SelectionMove[EvaluationNotebook[], All, GeneratedCell];\)\), "\n", 
    \(FrontEndTokenExecute["\<CellGroup\>"]\), "\n", 
    \(FrontEndTokenExecute["\<OpenCloseGroup\>"]\), "\n", 
    \(Clear[graf]\)}], "Input"],

Cell[CellGroupData[{

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.45351 .52747 m
.44228 .23499 L
s
.45303 .40819 m
.4449 .77298 L
s
.36339 .47576 m
.78204 .47576 L
s
.5 Mabswid
0 .714 0 r
.24591 .36574 m .24105 .37633 L .20018 .34353 L closepath p F P
0 g
s
0 .786 0 r
.25183 .35677 m .24591 .36574 L .20018 .34353 L closepath p F P
0 g
s
.529 0 0 r
.39361 .65398 m .40203 .65488 L .37827 .68962 L closepath p F P
0 g
s
.794 0 0 r
.38433 .65029 m .39361 .65398 L .37827 .68962 L closepath p F P
0 g
s
0 .518 0 r
.24105 .37633 m .24007 .38246 L .20018 .34353 L closepath p F P
0 g
s
.982 0 0 r
.37956 .64592 m .38433 .65029 L .37827 .68962 L closepath p F P
0 g
s
0 .731 0 r
.25542 .35462 m .25183 .35677 L .20018 .34353 L closepath p F P
0 g
s
0 0 0 r
.40203 .65488 m .40472 .65244 L .37827 .68962 L closepath p F P
0 g
s
0 0 0 r
.38213 .64342 m .37956 .64592 L .37827 .68962 L closepath p F P
0 g
s
0 .466 0 r
.24007 .38246 m .24359 .38047 L .20018 .34353 L closepath p F P
0 g
s
.929 0 0 r
.40472 .65244 m .40001 .64805 L .37827 .68962 L closepath p F P
0 g
s
0 .31 0 r
.25452 .36066 m .25542 .35462 L .20018 .34353 L closepath p F P
0 g
s
.537 0 0 r
.39062 .6443 m .38213 .64342 L .37827 .68962 L closepath p F P
0 g
s
.766 0 0 r
.40001 .64805 m .39062 .6443 L .37827 .68962 L closepath p F P
0 g
s
1 0 0 r
.01 w
.39341 .64542 m
.45152 .47576 L
s
.5 Mabswid
0 .627 0 r
.24359 .38047 m .2496 .37141 L .20018 .34353 L closepath p F P
0 g
s
0 .569 0 r
.2496 .37141 m .25452 .36066 L .20018 .34353 L closepath p F P
0 g
s
0 1 0 r
.01 w
.25029 .3699 m
.45152 .47576 L
s
.5 Mabswid
0 0 .768 r
.58022 .39955 m .57393 .38908 L .59634 .38085 L closepath p F P
0 g
s
0 0 .198 r
.57889 .41031 m .58022 .39955 L .59634 .38085 L closepath p F P
0 g
s
0 0 .957 r
.57393 .38908 m .56365 .38495 L .59634 .38085 L closepath p F P
0 g
s
0 0 .822 r
.57064 .41509 m .57889 .41031 L .59634 .38085 L closepath p F P
0 g
s
0 0 0 r
.56365 .38495 m .55534 .38961 L .59634 .38085 L closepath p F P
0 g
s
0 0 .945 r
.56027 .411 m .57064 .41509 L .59634 .38085 L closepath p F P
0 g
s
0 0 .471 r
.55534 .38961 m .55391 .40042 L .59634 .38085 L closepath p F P
0 g
s
0 0 .784 r
.55391 .40042 m .56027 .411 L .59634 .38085 L closepath p F P
0 g
s
0 0 1 r
.01 w
.45152 .47576 m
.55746 .40633 L
s
0 g
gsave
.5433 .43504 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.43806 .59589 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.3495 .41456 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00_@3oool200000?40oooo002n0?ooo`800000l03oool00;h0oooo0P00
003`0?ooo`00_P3oool200000?00oooo002n0?ooo`800000l03oool00;h0oooo0P00003`0?ooo`00
_P3oool200000?00oooo002n0?ooo`800000l03oool00;h0oooo0P00003`0?ooo`00_P3oool20000
0?00oooo002n0?ooo`800000l03oool00;h0oooo0P00003`0?ooo`00_P3oool200000?00oooo002n
0?ooo`800000l03oool00;h0oooo0P00003`0?ooo`00_P3oool200000?00oooo002n0?ooo`800000
l03oool00;h0oooo0P00003`0?ooo`00_P3oool200000?00oooo002n0?ooo`800000l03oool00;h0
oooo0P00003`0?ooo`00_P3oool200000?00oooo002n0?ooo`800000l03oool00;h0oooo0P00003`
0?ooo`00_P3oool200000?00oooo002n0?ooo`800000l03oool00;l0oooo0P00003_0?ooo`00_`3o
ool200000>l0oooo002o0?ooo`800000k`3oool00;l0oooo0P00003_0?ooo`00_`3oool200000>l0
oooo002o0?ooo`800000k`3oool00;l0oooo0P00003_0?ooo`00_`3oool200000>l0oooo002o0?oo
o`800000k`3oool00;l0oooo0P00003_0?ooo`00_`3oool200000>l0oooo002o0?ooo`800000k`3o
ool00;l0oooo0P00003_0?ooo`00_`3oool200000>l0oooo002o0?ooo`800000k`3oool00;l0oooo
0P00003_0?ooo`00_`3oool200000>l0oooo002o0?ooo`800000k`3oool00;l0oooo0P00003_0?oo
o`00_`3oool200000>l0oooo002o0?ooo`800000k`3oool005H0oooo0`00001V0?ooo`800000k`3o
ool005L0oooo2000001P0?ooo`800000k`3oool005P0oooo3@00001J0?ooo`800000k`3oool005T0
oooo10000002002A00<000000`00C`06000005@0oooo0P00003_0?ooo`00FP3oool200000003002P
00000000094000<009400`000006001?00@00000D@3oool200000>h0oooo001K0?ooo`80000000<0
0:000000000000001@00T@04000000D004l000<000000?ooo`3oool0C`3oool200000>h0oooo001L
0?ooo`8000000P00X002000000L009400`0000000`00C`0000000?ooo`1A0?ooo`800000kP3oool0
05d0oooo0P000003002P008000002000T@0200000580oooo0P00003^0?ooo`00GP3oool3000000<0
0:0000<00000002A0000T@001P00T@000`000000oooo0?ooo`1@0?ooo`800000kP3oool00600oooo
0P000003002P008000000`00T@03003o05<0oooo0P00003^0?ooo`00H@3oool2000000@00:000P00
00000`00T@000?l0003o0002003o0580oooo0P00003^0?ooo`00HP3oool2000000D00:001`00o`1@
0?ooo`800000kP3oool006<0oooo0P000004002P00T00?l0CP3oool200000>h0oooo001T0?ooo`<0
00000`00X0000`0000000?l0003o0007003o04`0oooo0P00003^0?ooo`00I@3oool01@00000007L0
00000000X00000000080oooo2P00o`1:0?ooo`800000kP3oool006H0oooo00<00000001g00000000
1@3oool:003o04P0oooo0P00003^0?ooo`00I`3oool00`000000oooo0?ooo`060?ooo`X00?l0AP3o
ool2000003P0oooo2000002^0?ooo`00LP3oool:003o04@0oooo0P00000`0?ooo`l00000[`3oool0
07@0oooo2P00o`120?ooo`800000;P3oool9000000<0001h1@00002_0?ooo`00MP3oool9003o0440
oooo0P00000]0?ooo`@000001P0007P3000000040000b0000000000000000;00oooo001h0?ooo`T0
0?l0?`3oool2000002d0oooo00<000000000N00007P01@0007P2000000<0003800<000000000l@00
0000/@3oool007X0oooo2@00o`0m0?ooo`800000;@3oool00`000000001h0000N0020000N0<00000
10000<P010000000003a00000000002a0?ooo`00O03oool9003o03/0oooo0P00000/0?ooo`040000
000007P0001h0000N08000001P000<P010000000003a00000000002b0?ooo`00O@3oool:003o03T0
oooo0P00000/0?ooo`040000000007P00000000000H000380P0000000`000?4000000000002c0?oo
o`00O`3oool:003o03L0oooo0P00000/0?ooo`8000001`000<P01P000000003a0000l@000000003B
00000;<0oooo00210?ooo`X00?l0=@3oool2000002d0oooo00<000000000o`000?l010000<P01P00
0000003a0000l@000000003B00000;@0oooo00230?ooo`X00?l0<`3oool2000002d0oooo0`000?l3
0000b006000000000?40003a000000000=800000]@3oool008D0oooo2P00o`050?ooo`060;Yb001b
^^X0oooo0?oDV`0009/0e?oo9P3oool4000002T0oooo1P000?l2000000<0003a00<000000000dP00
0000]@3oool008L0oooo2@00o`030?ooo`070?ooe02KLW80LW:j0?ooo`3DV`00001b0;[Zo`0V0?oo
o`@00000:03oool60000o`03000000000?40003a0080003a00<000000000dP000000]P3oool008T0
oooo2@00o`00203oool0omBK07:jjP2jLW80^^[D09/0V`2j^W80L[[Z9`3oool3000002H0oooo1`00
0?l2000000<0003a0`00002g0?ooo`00R`3oool8003o0007002K002Ke?l0j[Yb079bLP00Vm@0onZj
07:Ke00W0?ooo`<000009@3oool60000o`@0oooo1000002i0?ooo`00S@3oool6003o0008001b0000
jP000=@00000002Ke?l0oooD09/0V`3DoolV0?ooo`<000008`3oool70000ol80oooo002>0?ooo`@0
0?l000@009/00000000000000>X00P00o`000`2K00000000002Ke00V0?ooo`<000008P3oool60000
ol@0oooo002@0?ooo`X00?l09`3oool300000200oooo1`000?o50?ooo`00TP3oool:003o02D0oooo
0`00000N0?ooo`L0003oa`3oool009@0oooo2P00o`0S0?ooo`<000007@3oool70000olP0oooo002F
0?ooo`X00?l08@3oool3000001/0oooo1`000?l0203oool0^W8000000000000007:j0=BK00000000
L[[Z`P3oool009P0oooo2@00o`0P0?ooo`<000006P3oool60000o`80oooo00L0omBK001b^P3oool0
oooo0>ZjLP000000VmCo0<<0oooo002J0?ooo`T00?l07P3oool3000001P0oooo1`000?l30?ooo`03
0>ZjLP1b^^X0oooo0080oooo00<0e9/009_Do`3oool0`P3oool009`0oooo2@00o`0L0?ooo`<00000
5`3oool60000o`D0oooo00<0j[Yb07:jjP3oool00P3oool00`3DV`00VmCo0?ooo`320?ooo`00WP3o
ool9003o01X0oooo0`00000E0?ooo`L0003o1P3oool00`3Z^W80L[[Z0?ooo`020?ooo`030=BK002K
e?l0oooo0<80oooo002O0?ooo`X00?l0603oool3000001@0oooo1P000?l70?ooo`080>ZjLP000000
L[[Z0?ooo`3oj[X0LP000000002Ke?o30?ooo`00X@3oool:003o01H0oooo0`00000B0?ooo`L0003o
d`3oool00:<0oooo2P00o`0D0?ooo`<000004@3oool60000omD0oooo002U0?ooo`X00?l04P3oool3
000000l0oooo1`000?oF0?ooo`00Y`3oool:003o0100oooo0`00000>0?ooo`H0003of03oool00:T0
oooo2@00o`0?0?ooo`<00000303oool70000omT0oooo002[0?ooo`T00?l03@3oool3000000/0oooo
1P000?oK0?ooo`00[@3oool9003o00/0oooo0`0000090?ooo`L0003og03oool00:l0oooo2@00o`09
0?ooo`<000001`3oool70000omh0oooo002`0?ooo`X00?l01`3oool3000000H0oooo1`000?oO0?oo
o`00/P3oool:003o00D0oooo0`0000040?ooo`L0003oh@3oool00;@0oooo2P00o`030?ooo`<00000
0`3oool60000on<0oooo002f0?ooo`X00?l000D0oooo00000000000000000?ooo`070000on@0oooo
002h0?ooo`X00?l00P0000060000onH0oooo002j0?ooo`P00?l01`000?oW0?ooo`00_03oool5003o
00H0003oj@3oool009/0oooo8`000002003o00H0003oS000001N0?ooo`00V`3ooolU00000004003o
00000?l0003o0000ohh00000GP3oool00<00oooo00@0o`000000o`000?l00?l0k03oool00;l0oooo
1@3o003/0?ooo`00_`3oool40?l000030000003oool0oooo0>X0oooo002o0?ooo`@0o`0000<00000
0?ooo`3oool0jP3oool00;h0oooo1@3o00000`000000oooo0?ooo`3Z0?ooo`00_P3oool40?l00080
0000k03oool00;h0oooo103o000200000>`0oooo002m0?ooo`D0o`000P00003/0?ooo`00_@3oool4
0?l000<00000k03oool00;d0oooo103o000300000>`0oooo002l0?ooo`D0o`000`00003/0?ooo`00
_03oool40?l000040?ooo`000000000000000>`0oooo002l0?ooo`@0o`0000@0oooo000000000000
0000k03oool00;/0oooo1@3o0000103oool0000000000000003/0?ooo`00^`3oool40?l00080oooo
0`00003/0?ooo`00^P3oool50?l00080oooo0`00003/0?ooo`00^P3oool40?l000<0oooo0`00003/
0?ooo`00^P3oool40?l000<0oooo0`00003/0?ooo`00^@3oool50?l000<0oooo0`00003/0?ooo`00
^@3oool40?l000@0oooo0`00003/0?ooo`00^@3oool40?l000@0oooo1000003[0?ooo`00^03oool5
0?l000@0oooo1000003[0?ooo`00^03oool40?l000D0oooo0P00003]0?ooo`00^03oool40?l000D0
oooo0P00003]0?ooo`00]`3oool50?l000D0oooo0P00003]0?ooo`00]`3oool40?l000H0oooo0P00
003]0?ooo`00]`3oool40?l000H0oooo0P00003]0?ooo`00]P3oool50?l000H0oooo0P00003]0?oo
o`00]P3oool40?l000L0oooo0P00003]0?ooo`00]P3oool40?l000L0oooo0P00003]0?ooo`00]@3o
ool50?l000L0oooo0P00003]0?ooo`00]@3oool40?l000P0oooo0P00003]0?ooo`00]@3oool40?l0
00P0oooo0P00003]0?ooo`00]03oool50?l000P0oooo0P00003]0?ooo`00]03oool40?l000T0oooo
0P00003]0?ooo`00]03oool40?l000T0oooo0P00003]0?ooo`00/`3oool50?l000T0oooo0P00003]
0?ooo`00/`3oool40?l000X0oooo0P00003]0?ooo`00/`3oool40?l000X0oooo0P00003]0?ooo`00
/P3oool50?l000X0oooo0P00003]0?ooo`00/P3oool40?l000/0oooo0P00003]0?ooo`00/P3oool4
0?l000/0oooo0P00003]0?ooo`00/@3oool50?l000/0oooo0P00003]0?ooo`00/@3oool40?l000`0
oooo0P00003]0?ooo`00/@3oool40?l000`0oooo0P00003]0?ooo`00/03oool50?l000`0oooo0P00
003]0?ooo`00/03oool40?l000L0oooo00<0onZj0780002Ke?l00`3oool200000>d0oooo002`0?oo
o`@0o`001`3oool00`3Z^W80LW9b002Ke0020?ooo`800000kP3oool00:l0oooo1@3o00060?ooo`06
0?ooe02K09/0e?oo0;YbLP2jj_l0oooo0P00003^0?ooo`00[`3oool40?l000L0oooo00H0j[Yb07:j
jP3oool0omBK002Ke03oool200000>h0oooo002_0?ooo`@0o`001P3oool00`3oom@0V`2K0=Coo`02
0?ooo`040;YbLP2jj_l0000000000>h0oooo002^0?ooo`D0o`001@3oool01P3oj[X0LP0000000000
0000VkZj078000@00000kP3oool00:h0oooo103o000>0?ooo`800000kP3oool00:h0oooo103o000>
0?ooo`800000kP3oool00:d0oooo1@3o000>0?ooo`800000kP3oool00:d0oooo103o000?0?ooo`80
0000kP3oool00:`0oooo1@3o000?0?ooo`800000kP3oool00:`0oooo103o000@0?ooo`800000kP3o
ool00:`0oooo103o000@0?ooo`800000kP3oool00:/0oooo1@3o000@0?ooo`800000kP3oool00:/0
oooo103o000A0?ooo`800000kP3oool00:/0oooo103o000A0?ooo`800000kP3oool00:X0oooo1@3o
000A0?ooo`800000kP3oool00:X0oooo103o000B0?ooo`800000kP3oool00:X0oooo103o000B0?oo
o`800000kP3oool00:T0oooo1@3o000B0?ooo`800000kP3oool00:T0oooo103o000C0?ooo`800000
kP3oool00:T0oooo103o000C0?ooo`800000kP3oool00:P0oooo1@3o000C0?ooo`800000kP3oool0
0:P0oooo103o000D0?ooo`800000kP3oool00:@0oooo100000040?l001@0oooo0P00003^0?ooo`00
X`3oool200000080R@001@3o000D0?ooo`800000kP3oool00:<0oooo0P00000208T000@0o`000P00
000C0?ooo`800000kP3oool00:<0oooo0P00000208T00007000000340000o`000?l000000000k@00
0000000B0?ooo`800000kP3oool00:<0oooo0P00000208T00005000000340000a0000<@000000000
0P3]00000`000000oooo0?ooo`0?0?ooo`800000kP3oool00:<0oooo0P00000208T0000400000034
0000a00000000080k@0000<000000?ooo`3oool0403oool200000>h0oooo002S0?ooo`80000000<0
R@000000003400000P34000010000000k@000>d00000000B0?ooo`800000kP3oool00:<0oooo0P00
00001@29000000000<@00034000000000080k@0000<000000?ooo`3oool04@3oool200000>h0oooo
002S0?ooo`80000000L0R@00000000340000a0000000003]0000000001@0oooo0P00003^0?ooo`00
X`3oool20000000408T000000000a00000000080k@0000<000000?ooo`3oool04P3oool200000>h0
oooo002S0?ooo`0300000029000000000080a00000<000000>d0000000005@3oool200000>h0oooo
002S0?ooo`0700000029000000000<@000000000k@000000000F0?ooo`800000kP3oool00:<0oooo
00@0000008T000000000a0000P00000G0?ooo`800000kP3oool00:<0oooo00H0000008T000000000
00000>d00000000G0?ooo`800000kP3oool00:<0oooo0P0000000`34000000000000000H0?ooo`80
0000kP3oool00:<0oooo1000000I0?ooo`800000kP3oool00:<0oooo1000000I0?ooo`800000kP3o
ool00:<0oooo0`00000I0?ooo`800000k`3oool00:<0oooo0P00000J0?ooo`800000k`3oool00:<0
oooo0P00000J0?ooo`800000k`3oool00:<0oooo00<000000?ooo`3oool06@3oool200000>l0oooo
002o0?ooo`800000k`3oool00;l0oooo0P00003_0?ooo`00_`3oool200000>l0oooo002o0?ooo`80
0000k`3oool00;l0oooo0P00003_0?ooo`00_`3oool200000>l0oooo002o0?ooo`800000k`3oool0
0;l0oooo0P00003_0?ooo`00_`3oool200000>l0oooo002o0?ooo`800000k`3oool00;l0oooo0P00
003_0?ooo`00_`3oool200000>l0oooo002o0?ooo`800000k`3oool00;l0oooo0P00003_0?ooo`00
_`3oool200000>l0oooo002o0?ooo`800000k`3oool00;l0oooo0P00003_0?ooo`00_`3oool20000
0>l0oooo002o0?ooo`800000k`3oool00;l0oooo0P00003_0?ooo`00_`3oool200000>l0oooo002o
0?ooo`800000k`3oool00;l0oooo0P00003_0?ooo`00_`3oool200000>l0oooo002o0?ooo`800000
k`3oool00;l0oooo0P00003_0?ooo`00_`3oool200000>l0oooo002o0?ooo`800000k`3oool00;l0
oooo0P00003_0?ooo`00_`3oool200000>l0oooo002o0?ooo`800000k`3oool00;l0oooo0P00003_
0?ooo`00_`3oool200000>l0oooo002o0?ooo`800000k`3oool00;l0oooo0P00003_0?ooo`00_`3o
ool200000>l0oooo002n0?ooo`800000l03oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00001\
\>"],
  ImageRangeCache->{{{0, 431}, {431, 0}} -> {-5.00005*^-06, -5.00005*^-06, \
0.00348031, 0.00348031}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.33349 .45113 m
.73328 .51653 L
s
.40224 .5163 m
.50878 .23028 L
s
.42364 .3977 m
.41031 .76403 L
s
.5 Mabswid
.631 0 0 r
.34895 .63606 m .35824 .63821 L .33396 .67022 L closepath p F P
0 g
s
.864 0 0 r
.34061 .63106 m .34895 .63606 L .33396 .67022 L closepath p F P
0 g
s
0 0 0 r
.35824 .63821 m .36311 .63626 L .33396 .67022 L closepath p F P
0 g
s
.987 0 0 r
.33806 .62609 m .34061 .63106 L .33396 .67022 L closepath p F P
0 g
s
.947 0 0 r
.36311 .63626 m .36067 .6313 L .33396 .67022 L closepath p F P
0 g
s
.124 0 0 r
.34286 .62407 m .33806 .62609 L .33396 .67022 L closepath p F P
0 g
s
.82 0 0 r
.36067 .6313 m .35225 .62623 L .33396 .67022 L closepath p F P
0 g
s
1 0 0 r
.01 w
.3526 .62644 m
.42117 .46548 L
s
.5 Mabswid
.625 0 0 r
.35225 .62623 m .34286 .62407 L .33396 .67022 L closepath p F P
0 g
s
0 .783 0 r
.24491 .32042 m .23883 .33039 L .20806 .28985 L closepath p F P
0 g
s
0 .812 0 r
.25357 .31248 m .24491 .32042 L .20806 .28985 L closepath p F P
0 g
s
0 .68 0 r
.25984 .31115 m .25357 .31248 L .20806 .28985 L closepath p F P
0 g
s
0 .547 0 r
.23883 .33039 m .23887 .33663 L .20806 .28985 L closepath p F P
0 g
s
0 .369 0 r
.26002 .31731 m .25984 .31115 L .20806 .28985 L closepath p F P
0 g
s
0 .482 0 r
.23887 .33663 m .2451 .33544 L .20806 .28985 L closepath p F P
0 g
s
0 .627 0 r
.25389 .32742 m .26002 .31731 L .20806 .28985 L closepath p F P
0 g
s
0 .654 0 r
.2451 .33544 m .25389 .32742 L .20806 .28985 L closepath p F P
0 g
s
0 1 0 r
.01 w
.25377 .32752 m
.42117 .46548 L
s
.5 Mabswid
0 0 .758 r
.592 .41419 m .58766 .40292 L .62089 .39954 L closepath p F P
0 g
s
0 0 .334 r
.59012 .42456 m .592 .41419 L .62089 .39954 L closepath p F P
0 g
s
0 0 .956 r
.58766 .40292 m .57959 .39726 L .62089 .39954 L closepath p F P
0 g
s
0 0 .755 r
.58306 .428 m .59012 .42456 L .62089 .39954 L closepath p F P
0 g
s
0 0 0 r
.57959 .39726 m .57246 .40057 L .62089 .39954 L closepath p F P
0 g
s
0 0 .946 r
.57491 .42241 m .58306 .428 L .62089 .39954 L closepath p F P
0 g
s
0 0 .492 r
.57246 .40057 m .5705 .411 L .62089 .39954 L closepath p F P
0 g
s
0 0 .768 r
.5705 .411 m .57491 .42241 L .62089 .39954 L closepath p F P
0 g
s
0 0 1 r
.01 w
.42117 .46548 m
.57227 .41559 L
s
0 g
gsave
.54469 .44234 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.40176 .58418 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.34535 .38855 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00f`3oool00`000000oooo0?oo
o`3B0?ooo`00fP3oool300000=<0oooo003J0?ooo`800000e03oool00=X0oooo0P00003D0?ooo`00
f@3oool300000=@0oooo003I0?ooo`800000e@3oool00=P0oooo0`00003E0?ooo`00f03oool20000
0=H0oooo003H0?ooo`800000eP3oool00=L0oooo0`00003F0?ooo`00e`3oool200000=L0oooo003G
0?ooo`800000e`3oool00=H0oooo0`00003G0?ooo`00eP3oool200000=P0oooo003E0?ooo`<00000
f03oool00=D0oooo0P00003I0?ooo`00e@3oool200000=T0oooo003D0?ooo`<00000f@3oool00=@0
oooo0P00003J0?ooo`00e03oool200000=X0oooo003C0?ooo`<00000fP3oool00=<0oooo0P00003K
0?ooo`00dP3oool300000=/0oooo003B0?ooo`800000g03oool00=80oooo0P00003L0?ooo`00d@3o
ool300000=`0oooo001I0?ooo`800000MP3oool200000=d0oooo001J0?ooo`<00000M03oool20000
0=d0oooo001J0?ooo`D00000L@3oool300000=d0oooo001K0?ooo`H00000K`3oool200000=h0oooo
001K0?ooo`80000000<00:L000000000X0000`00001/0?ooo`<00000gP3oool005`0oooo0P000000
1000Y`000000002P0000X004000006T0oooo0P00003O0?ooo`00G@3oool200000003002W00000000
0:0000800:001000001W0?ooo`800000g`3oool005d0oooo00D00000001k000000000:L000000004
002P00@00000I03oool300000=l0oooo001N0?ooo`8000000P00Y`000`0000000:00002P0003002P
00@00000HP3oool200000>00oooo001O0?ooo`8000000P00Y`02000000D00:001000001P0?ooo`80
0000h03oool005l0oooo00<00000001k000000000`00Y`000`0000000:00002P0004002P00@00000
G@3oool300000>00oooo001P0?ooo`0300000000N`00000000<00:L000<00000002P0000X0001@00
X002000005d0oooo0P00003Q0?ooo`00H03oool01000000007/0001k00000003002W000300000000
X0000:0000H00:0000<000000?ooo`3oool0F@3oool300000>40oooo001Q0?ooo`0300000000N`00
000000@00:L000<00000002P0000X0001000X0000`000000oooo0?ooo`1J0?ooo`800000hP3oool0
0680oooo00<00000001k000000001000Y`02000000@00:0000<000000?ooo`3oool0FP3oool20000
0>80oooo001R0?ooo`0400000000N`0007/0000000D00:L000@00000002P0000o`000000G03oool3
00000>80oooo001S0?ooo`0400000000N`0007/0000000D00:L01000o`1K0?ooo`800000h`3oool0
06@0oooo00@00000001k0000N`0000000`00Y`06003o05X0oooo0P00003S0?ooo`00I03oool01000
000007/0001k00000003002W00L00?l0F03oool300000><0oooo001U0?ooo`0500000000N`0007/0
00000000Y`000P0000000`3oool00?l0003o0004003o05L0oooo0P00003T0?ooo`00I@3oool00`00
000007/0001k0002000000@0oooo1P00o`1E0?ooo`<00000i03oool006H0oooo0P0000070?ooo`L0
0?l0D`3oool200000>D0oooo001`0?ooo`L00?l0DP3oool200000>D0oooo001a0?ooo`L00?l0D03o
ool300000>D0oooo001c0?ooo`H00?l0C`3oool200000>H0oooo001d0?ooo`L00?l0C@3oool20000
0>H0oooo001e0?ooo`L00?l0B`3oool300000>H0oooo001f0?ooo`L00?l0BP3oool200000>L0oooo
001h0?ooo`H00?l0B03oool300000>L0oooo001i0?ooo`H00?l0A`3oool200000>P0oooo001j0?oo
o`L00?l0A@3oool200000>P0oooo001k0?ooo`L00?l0@`3oool300000>P0oooo001l0?ooo`L00?l0
@P3oool200000>T0oooo001n0?ooo`H00?l0@@3oool200000>T0oooo001o0?ooo`L00?l0?P3oool3
00000>T0oooo00200?ooo`L00?l0?@3oool200000>X0oooo00210?ooo`L00?l0>`3oool300000>X0
oooo00230?ooo`H00?l0>P3oool200000>/0oooo00240?ooo`H00?l0>@3oool200000>/0oooo0025
0?ooo`L00?l0=P3oool300000>/0oooo00260?ooo`L00?l01@3oool01P2jLP00L[[Z0?ooo`3oe9/0
002K0=CoobX0oooo0P00003/0?ooo`00Q`3oool7003o00<0oooo00L0oooD09]bLP1bL[X0oooo0=BK
00000780^^[o02X0oooo0P00003/0?ooo`00R@3oool6003o0080oooo00L0omBK07:jjP2jLW80^^[D
09/0V`2j^W80L[[Z02T0oooo0`00003/0?ooo`00RP3oool7003o00070=BK002Ke?l0j[Yb079bLP00
Vm@0onZj07:Ke00Y0?ooo`800000k@3oool008/0oooo1P00o`002000LP00^^[o0?oDV`000000VmCo
0?ooe02K09/0e?oo:03oool200000>d0oooo002<0?ooo`@00?l000T009/0000000000000^^[o0?oo
o`3oom@0V`0000000000Vm@09`3oool300000>d0oooo002>0?ooo`H00?l0;03oool200000>h0oooo
002?0?ooo`H00?l08@3oool2000000L0oooo0`00000f0?ooo`X00000[P3oool00900oooo1`00o`0N
0?ooo`800000203oool2000003D0oooo5P00002T0?ooo`00T@3oool7003o01d0oooo0P0000080?oo
o`800000=@3oool00`000000001m0000O@0<0000O@H00000Y@3oool00980oooo1`00o`0L0?ooo`80
00001`3oool3000003D0oooo00<000000000O@0007d0200007d40000008000340`00002V0?ooo`00
U03oool6003o01/0oooo0P0000070?ooo`800000=@3oool00`000000001m0000O@040000O@D00000
10000<@300000:P0oooo002E0?ooo`L00?l06@3oool2000000L0oooo0P00000e0?ooo`0300000000
07d0001m00@000001`000<@2000000030000lP000000oooo0:P0oooo002F0?ooo`L00?l0603oool2
000000H0oooo0`00000e0?ooo`03000000000?l0003o00T000340P0000000`000?8000000000002Z
0?ooo`00U`3oool7003o01L0oooo0P0000060?ooo`800000=03oool50000o`L000340P0000020000
lP030000003oool0oooo0:X0oooo002I0?ooo`H00?l05P3oool2000000D0oooo0`00000a0?ooo`T0
003o10000<@2000000<0003b00<000000?ooo`3oool0Z`3oool009X0oooo1P00o`0E0?ooo`800000
1@3oool2000002l0oooo30000?l20000a08000000`000?8200000:h0oooo002K0?ooo`L00?l04`3o
ool2000000D0oooo0P00000/0?ooo`d0003o00@000000000a0000000000010000?800`000000oooo
0?ooo`2^0?ooo`00W03oool7003o0180oooo0P0000040?ooo`<00000:03oool>0000o`<0oooo0P00
00050000lP030000003oool0oooo0:l0oooo002M0?ooo`L00?l04@3oool2000000@0oooo0P00000V
0?ooo`h0003o1`3oool200000080003b0P00002b0?ooo`00W`3oool6003o0100oooo0P0000040?oo
o`8000008`3oool>0000o``0oooo0P00002d0?ooo`00X03oool7003o00h0oooo0P0000030?ooo`<0
0000803oool>0000olD0oooo002Q0?ooo`L00?l03@3oool2000000<0oooo0P00000N0?ooo`d0003o
b@3oool00:80oooo1`00o`0<0?ooo`8000000P3oool3000001/0oooo3@000?l40?ooo`070;Yb0000
00000000001b^P3DV`00000007:jjP310?ooo`00Y03oool6003o00/0oooo0P0000020?ooo`800000
6@3oool=0000o`H0oooo00L0omBK001b^P3oool0oooo0>ZjLP000000VmCo0<80oooo002U0?ooo`H0
0?l02P3oool200000080oooo0P00000F0?ooo`d0003o2@3oool00`3Z^W80L[[Z0?ooo`020?ooo`03
0=BK002Ke?l0oooo0<40oooo002V0?ooo`L00?l0203oool2000000040?ooo`0000000000000001<0
oooo3@000?l<0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0e9/009_Do`3oool0`@3oool00:L0oooo
1`00o`070?ooo`80000000<0oooo0000000000004@3oool=0000o`l0oooo00<0j[Yb07:jjP3oool0
0P3oool00`3DV`00VmCo0?ooo`310?ooo`00Z03oool7003o00H0oooo0P0000000`3oool000000000
000>0?ooo`d0003o4@3oool0203Z^W80000007:jjP3oool0onZj078000000000VmCo`P3oool008h0
oooo0P00000J0?ooo`H00?l01@3oool5000000/0oooo3@000?oN0?ooo`00SP3oool8000001D0oooo
1`00o`030?ooo`@00000203oool>0000on40oooo002@0?ooo``00000403oool7003o0080oooo1000
00050?ooo`h0003oi03oool009H0oooo3000000;0?ooo`L00?l000@0oooo00000000000000000`3o
ool>0000onL0oooo002L0?ooo``000001`3oool6003o00<000003P000?oZ0?ooo`00XP3oool<0000
0080oooo1@00o`0=0000onh0oooo002X0?ooo`T000000P00o`0<0000oo40oooo002^0?ooo`@00000
00<00?l00000o`000?l01`000?od0?ooo`00/`3oool00`00o`00003o0000o`030000o`P00000k`3o
ool00;80oooo0P3o00020000o`030?l0003oool0oooo0080oooo3000003Y0?ooo`00/P3oool50?l0
00X0oooo3000003S0?ooo`00/@3oool50?l00140oooo3000003M0?ooo`00/@3oool50?l001L0oooo
3@00003F0?ooo`00/03oool50?l000030000003oool0oooo01/0oooo3@00003@0?ooo`00/03oool5
0?l000030000003oool0oooo0280oooo3000003:0?ooo`00/03oool40?l000800000:P3oool<0000
0<@0oooo002_0?ooo`D0o`000P00000`0?ooo``00000_P3oool00:l0oooo1@3o0002000003H0oooo
3@00002g0?ooo`00[P3oool50?l000030?ooo`000000000003`0oooo3@00002a0?ooo`00[P3oool5
0?l000030?ooo`000000000004<0oooo3000002[0?ooo`00[@3oool50?l00080oooo0P0000190?oo
o``00000Y@3oool00:d0oooo1@3o00020?ooo`800000C`3oool<000009l0oooo002]0?ooo`@0o`00
0`3oool2000005D0oooo3000002I0?ooo`00[03oool50?l000<0oooo0P00001K0?ooo`d00000TP3o
ool00:`0oooo1@3o00030?ooo`800000H@3oool=000008`0oooo002[0?ooo`D0o`00103oool20000
06P0oooo300000260?ooo`00Z`3oool50?l000@0oooo0P00001^0?ooo``00000P03oool00:X0oooo
1@3o00050?ooo`800000M03oool<000007X0oooo002Z0?ooo`D0o`001@3oool2000007X0oooo3000
001d0?ooo`00ZP3oool40?l000030000003oool0oooo00<0oooo0P0000200?ooo`L00000L`3oool0
0:T0oooo1@3o00060?ooo`800000QP3oool00`000000oooo0?ooo`1a0?ooo`00Z@3oool50?l000D0
oooo0P00003k0?ooo`00Z03oool50?l000H0oooo0P00003k0?ooo`00Z03oool50?l000H0oooo0P00
003k0?ooo`00Y`3oool50?l000L0oooo0P00003k0?ooo`00Y`3oool50?l000L0oooo0P00003k0?oo
o`00YP3oool50?l000P0oooo0P00003k0?ooo`00YP3oool50?l000P0oooo0P00003k0?ooo`00YP3o
ool40?l000T0oooo0P00003k0?ooo`00Y@3oool50?l000T0oooo0P00003k0?ooo`00Y@3oool50?l0
00T0oooo0P00003k0?ooo`00Y03oool50?l000X0oooo0P00003k0?ooo`00Y03oool50?l000X0oooo
0P00003k0?ooo`00X`3oool50?l000/0oooo0P00003k0?ooo`00X`3oool50?l000/0oooo0P00003k
0?ooo`00X`3oool40?l000`0oooo0P00003k0?ooo`00XP3oool50?l000`0oooo0P00003k0?ooo`00
XP3oool50?l000`0oooo0P00003k0?ooo`00X@3oool50?l000d0oooo0P00003k0?ooo`00X@3oool5
0?l000d0oooo0P00003k0?ooo`00X03oool50?l000h0oooo0P00003k0?ooo`00X03oool50?l000h0
oooo0P00003k0?ooo`00W`3oool50?l000l0oooo0P00003k0?ooo`00W`3oool50?l000l0oooo0P00
003k0?ooo`00W`3oool40?l00100oooo0P00003k0?ooo`00WP3oool50?l000P0oooo00<0onZj0780
002Ke?l01@3oool200000?/0oooo002N0?ooo`D0o`00203oool00`3Z^W80LW9b002Ke0050?ooo`80
0000n`3oool009d0oooo1@3o00080?ooo`050?ooe02K09/0e?oo0;YbLP2jj_l00`3oool200000?`0
oooo002M0?ooo`D0o`00203oool01@3Z^W80L[[Z0?ooo`3oe9/009_D00<0oooo0P00003l0?ooo`00
W03oool50?l000P0oooo00<0oooD09/0V`3Dool00P3oool0102jLW80^^[o0?ooo`3oool200000?`0
oooo002L0?ooo`D0o`001`3oool01P3oj[X0LP00000000000000VkZj07800080000000@0L[[Z0?oo
o`0000000000o03oool009`0oooo103o000B0?ooo`800000o03oool009/0oooo1@3o000B0?ooo`80
0000o03oool009/0oooo1@3o000B0?ooo`800000o03oool009X0oooo1@3o000C0?ooo`800000o03o
ool009X0oooo1@3o000C0?ooo`800000o03oool009T0oooo1@3o000D0?ooo`800000o03oool009T0
oooo1@3o000D0?ooo`800000o03oool009T0oooo103o000E0?ooo`800000o03oool009P0oooo1@3o
000E0?ooo`800000o03oool009P0oooo1@3o000E0?ooo`800000o03oool009L0oooo1@3o000F0?oo
o`800000o03oool009L0oooo1@3o000F0?ooo`800000o03oool009H0oooo1@3o000G0?ooo`800000
o03oool009H0oooo1@3o000G0?ooo`800000o03oool009<0oooo0P0000050?l001P0oooo0P00003l
0?ooo`00T@3oool30000000409l000000000000000000080o`00603oool200000?`0oooo002A0?oo
o`030000000O0000000000<0W`0000<000000?l0003oool0603oool200000?`0oooo002A0?ooo`80
00000`2O00000`000000o`000?l00002000001L0oooo0P00003l0?ooo`00T@3oool2000000<0W`00
00<000000=40003A00000P3A00000`000000oooo0?ooo`0D0?ooo`800000o03oool00940oooo0P00
000209l000030000003A0000d@000080d@000P00000F0?ooo`800000o03oool00900oooo00<00000
01l0000000000P2O00001@000000d@000=40003A000000000080lP0000<000000?ooo`3oool04`3o
ool200000?`0oooo002@0?ooo`050000000O0000000009l000000000103A00000`000000lP000000
000F0?ooo`800000o03oool00900oooo0P00000209l000070000003A0000d@000=4000000000lP00
0000000G0?ooo`800000o03oool00900oooo0P00000209l000060000003A0000d@000000003b0000
00005`3oool200000?d0oooo002@0?ooo`80000000L0W`000000003A0000d@000000003b00000000
01P0oooo0P00003m0?ooo`00T03oool20000000409l000000000d@000=40008000006@3oool20000
0?d0oooo002@0?ooo`<000000P3A0002000001X0oooo0P00003m0?ooo`00T03oool010000000W`00
0000003A0002000001/0oooo0P00003m0?ooo`00T03oool01P000000W`00000000000000lP000000
01/0oooo0P00003m0?ooo`00T03oool2000000030=4000000000000001`0oooo0P00003m0?ooo`00
S`3oool5000001d0oooo0P00003m0?ooo`00S`3oool4000001h0oooo0P00003m0?ooo`00S`3oool3
000001l0oooo0P00003m0?ooo`00S`3oool200000200oooo0P00003m0?ooo`00S`3oool00`000000
oooo0?ooo`0O0?ooo`800000o@3oool00;40oooo0P00003m0?ooo`00/@3oool200000?d0oooo002a
0?ooo`800000o@3oool00;40oooo0P00003m0?ooo`00/@3oool200000?d0oooo002a0?ooo`800000
o@3oool00;40oooo0P00003m0?ooo`00/@3oool200000?d0oooo002a0?ooo`800000o@3oool00;40
oooo0P00003m0?ooo`00/@3oool200000?d0oooo002a0?ooo`800000o@3oool00;40oooo0P00003m
0?ooo`00/@3oool200000?d0oooo002`0?ooo`800000oP3oool00;00oooo0P00003n0?ooo`00/03o
ool200000?h0oooo002`0?ooo`800000oP3oool00;00oooo0P00003n0?ooo`00/03oool200000?h0
oooo002`0?ooo`800000oP3oool00;00oooo0P00003n0?ooo`00/03oool200000?h0oooo002`0?oo
o`800000oP3oool00;00oooo0P00003n0?ooo`00/03oool200000?h0oooo002`0?ooo`800000oP3o
ool00;00oooo0P00003n0?ooo`00/03oool200000?h0oooo002`0?ooo`800000oP3oool00;00oooo
0P00003n0?ooo`00/03oool200000?h0oooo002`0?ooo`800000oP3oool00;00oooo0P00003n0?oo
o`00/03oool200000?h0oooo002`0?ooo`800000oP3oool00;00oooo0P00003n0?ooo`00/03oool2
00000?h0oooo002`0?ooo`800000oP3oool00;00oooo0P00003n0?ooo`00[`3oool200000?l0oooo
002_0?ooo`800000o`3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo
/@3oool00?l0oooo/@3oool00001\
\>"],
  ImageRangeCache->{{{0, 431}, {431, 0}} -> {-5.00005*^-06, -5.00005*^-06, \
0.00348031, 0.00348031}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.31345 .42183 m
.67319 .54775 L
s
.35586 .49732 m
.57448 .23829 L
s
.39868 .38243 m
.38076 .75097 L
s
.5 Mabswid
.718 0 0 r
.31233 .61201 m .32202 .61557 L .29855 .64491 L closepath p F P
0 g
s
.931 0 0 r
.30545 .6058 m .31233 .61201 L .29855 .64491 L closepath p F P
0 g
s
.22 0 0 r
.32202 .61557 m .32893 .61443 L .29855 .64491 L closepath p F P
0 g
s
.823 0 0 r
.3054 .60053 m .30545 .6058 L .29855 .64491 L closepath p F P
0 g
s
.907 0 0 r
.32893 .61443 m .32901 .60919 L .29855 .64491 L closepath p F P
0 g
s
0 0 .741 r
.59721 .43008 m .59506 .4184 L .63628 .42134 L closepath p F P
0 g
s
0 0 .4 r
.59494 .43998 m .59721 .43008 L .63628 .42134 L closepath p F P
0 g
s
0 0 .945 r
.59506 .4184 m .58972 .41167 L .63628 .42134 L closepath p F P
0 g
s
.344 0 0 r
.3123 .59931 m .3054 .60053 L .29855 .64491 L closepath p F P
0 g
s
0 0 .653 r
.58952 .44235 m .59494 .43998 L .63628 .42134 L closepath p F P
0 g
s
.873 0 0 r
.32901 .60919 m .32211 .60291 L .29855 .64491 L closepath p F P
0 g
s
0 0 0 r
.58972 .41167 m .58425 .41388 L .63628 .42134 L closepath p F P
0 g
s
.701 0 0 r
.32211 .60291 m .3123 .59931 L .29855 .64491 L closepath p F P
0 g
s
1 0 0 r
.01 w
.31988 .60209 m
.39537 .45051 L
s
.5 Mabswid
0 0 .947 r
.5841 .43569 m .58952 .44235 L .63628 .42134 L closepath p F P
0 g
s
0 0 .502 r
.58425 .41388 m .5819 .42385 L .63628 .42134 L closepath p F P
0 g
s
0 0 .758 r
.5819 .42385 m .5841 .43569 L .63628 .42134 L closepath p F P
0 g
s
0 0 1 r
.01 w
.39537 .45051 m
.58264 .42783 L
s
.5 Mabswid
0 .861 0 r
.26232 .27511 m .25538 .28419 L .23829 .23772 L closepath p F P
0 g
s
0 .836 0 r
.27332 .26876 m .26232 .27511 L .23829 .23772 L closepath p F P
0 g
s
0 .639 0 r
.28204 .26879 m .27332 .26876 L .23829 .23772 L closepath p F P
0 g
s
0 .488 0 r
.25538 .28419 m .25654 .29075 L .23829 .23772 L closepath p F P
0 g
s
0 .406 0 r
.28337 .27528 m .28204 .26879 L .23829 .23772 L closepath p F P
0 g
s
0 .5 0 r
.25654 .29075 m .26525 .2909 L .23829 .23772 L closepath p F P
0 g
s
0 .693 0 r
.27641 .28447 m .28337 .27528 L .23829 .23772 L closepath p F P
0 g
s
0 .684 0 r
.26525 .2909 m .27641 .28447 L .23829 .23772 L closepath p F P
0 g
s
0 1 0 r
.01 w
.27387 .28593 m
.39537 .45051 L
s
0 g
gsave
.54303 .44957 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.37094 .56734 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.35187 .36222 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.30523 .38942 m
.60537 .56867 L
s
.37981 .36314 m
.35819 .73441 L
s
.5 Mabswid
0 0 .726 r
.59571 .44608 m .59583 .43438 L .64181 .4445 L closepath p F P
0 g
s
0 0 .431 r
.59321 .45547 m .59571 .44608 L .64181 .4445 L closepath p F P
0 g
s
0 0 .923 r
.59583 .43438 m .59348 .42709 L .64181 .4445 L closepath p F P
0 g
s
0 0 0 r
.006 w
.31704 .47119 m
.49705 .34992 L
s
.49705 .34992 m
.63336 .25808 L
s
.5 Mabswid
.58976 .45709 m .59321 .45547 L .64181 .4445 L closepath p F P
0 g
s
0 0 0 r
.59348 .42709 m .59002 .42853 L .64181 .4445 L closepath p F P
0 g
s
0 0 .948 r
.58736 .44986 m .58976 .45709 L .64181 .4445 L closepath p F P
0 g
s
0 0 .504 r
.59002 .42853 m .58746 .43798 L .64181 .4445 L closepath p F P
0 g
s
0 0 .753 r
.58746 .43798 m .58736 .44986 L .64181 .4445 L closepath p F P
0 g
s
0 0 1 r
.01 w
.37583 .43158 m
.58743 .44186 L
s
.5 Mabswid
.406 0 0 r
.29594 .5879 m .30461 .58787 L .27476 .61477 L closepath p F P
0 g
s
.798 0 0 r
.2864 .58283 m .29594 .5879 L .27476 .61477 L closepath p F P
0 g
s
.984 0 0 r
.28151 .57559 m .2864 .58283 L .27476 .61477 L closepath p F P
0 g
s
.749 0 0 r
.30461 .58787 m .30737 .58272 L .27476 .61477 L closepath p F P
0 g
s
0 0 0 r
.28415 .57037 m .28151 .57559 L .27476 .61477 L closepath p F P
0 g
s
.92 0 0 r
.30737 .58272 m .30252 .57541 L .27476 .61477 L closepath p F P
0 g
s
.494 0 0 r
.29287 .57028 m .28415 .57037 L .27476 .61477 L closepath p F P
0 g
s
.77 0 0 r
.30252 .57541 m .29287 .57028 L .27476 .61477 L closepath p F P
0 g
s
1 0 0 r
.01 w
.29785 .57293 m
.37583 .43158 L
s
.5 Mabswid
0 .856 0 r
.31112 .22923 m .29852 .23349 L .29065 .19186 L closepath p F P
0 g
s
0 .61 0 r
.32176 .23113 m .31112 .22923 L .29065 .19186 L closepath p F P
0 g
s
0 .939 0 r
.29852 .23349 m .2912 .24146 L .29065 .19186 L closepath p F P
0 g
s
0 .387 0 r
.32424 .23814 m .32176 .23113 L .29065 .19186 L closepath p F P
0 g
s
0 0 0 r
.2912 .24146 m .2935 .24854 L .29065 .19186 L closepath p F P
0 g
s
0 .768 0 r
.31697 .24621 m .32424 .23814 L .29065 .19186 L closepath p F P
0 g
s
0 .522 0 r
.2935 .24854 m .30419 .25054 L .29065 .19186 L closepath p F P
0 g
s
0 .719 0 r
.30419 .25054 m .31697 .24621 L .29065 .19186 L closepath p F P
0 g
s
0 1 0 r
.01 w
.31071 .24833 m
.37583 .43158 L
s
0 g
gsave
.53849 .45625 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.34764 .54614 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.36919 .3375 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.31029 .35592 m
.53312 .57893 L
s
.36848 .34089 m
.34437 .71519 L
s
.28848 .43893 m
.68048 .28747 L
s
.5 Mabswid
0 0 .714 r
.58784 .46112 m .59013 .44975 L .6376 .46735 L closepath p F P
0 g
s
0 0 .446 r
.58529 .46999 m .58784 .46112 L .6376 .46735 L closepath p F P
0 g
s
0 0 .897 r
.59013 .44975 m .59085 .44242 L .6376 .46735 L closepath p F P
0 g
s
0 0 0 r
.58396 .47121 m .58529 .46999 L .6376 .46735 L closepath p F P
0 g
s
0 0 0 r
.59085 .44242 m .58954 .44344 L .6376 .46735 L closepath p F P
0 g
s
0 0 .949 r
.58464 .46392 m .58396 .47121 L .6376 .46735 L closepath p F P
0 g
s
0 0 .753 r
.58696 .45236 m .58464 .46392 L .6376 .46735 L closepath p F P
0 g
s
0 0 1 r
.01 w
.36405 .40973 m
.58613 .45651 L
s
.5 Mabswid
0 0 .501 r
.58954 .44344 m .58696 .45236 L .6376 .46735 L closepath p F P
0 g
s
.542 0 0 r
.28238 .55654 m .29238 .55792 L .26508 .58131 L closepath p F P
0 g
s
.871 0 0 r
.27363 .54996 m .28238 .55654 L .26508 .58131 L closepath p F P
0 g
s
.972 0 0 r
.27121 .54195 m .27363 .54996 L .26508 .58131 L closepath p F P
0 g
s
0 0 0 r
.29238 .55792 m .29785 .55325 L .26508 .58131 L closepath p F P
0 g
s
0 0 0 r
.2766 .53719 m .27121 .54195 L .26508 .58131 L closepath p F P
0 g
s
.955 0 0 r
.29785 .55325 m .29552 .54522 L .26508 .58131 L closepath p F P
0 g
s
.607 0 0 r
.2867 .53854 m .2766 .53719 L .26508 .58131 L closepath p F P
0 g
s
.836 0 0 r
.29552 .54522 m .2867 .53854 L .26508 .58131 L closepath p F P
0 g
s
1 0 0 r
.01 w
.28882 .54015 m
.36405 .40973 L
s
.5 Mabswid
0 .869 0 r
.36514 .19768 m .35193 .19949 L .36225 .15716 L closepath p F P
0 g
s
0 .591 0 r
.37687 .20182 m .36514 .19768 L .36225 .15716 L closepath p F P
0 g
s
0 .982 0 r
.35193 .19949 m .34488 .20624 L .36225 .15716 L closepath p F P
0 g
s
0 0 0 r
.38035 .20955 m .37687 .20182 L .36225 .15716 L closepath p F P
0 g
s
0 0 0 r
.34488 .20624 m .3482 .21403 L .36225 .15716 L closepath p F P
0 g
s
0 .852 0 r
.37341 .21639 m .38035 .20955 L .36225 .15716 L closepath p F P
0 g
s
0 .546 0 r
.3482 .21403 m .36004 .21827 L .36225 .15716 L closepath p F P
0 g
s
0 .757 0 r
.36004 .21827 m .37341 .21639 L .36225 .15716 L closepath p F P
0 g
s
0 1 0 r
.01 w
.36268 .21789 m
.36405 .40973 L
s
0 g
gsave
.53141 .46196 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.33371 .52167 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.39655 .31639 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.32922 .32374 m
.45952 .57839 L
s
.3658 .317 m
.3407 .69443 L
s
.5 Mabswid
0 0 .707 r
.57433 .47426 m .57858 .46354 L .62442 .48841 L closepath p F P
0 g
s
0 0 .45 r
.57189 .48264 m .57433 .47426 L .62442 .48841 L closepath p F P
0 g
s
0 0 .871 r
.57858 .46354 m .5822 .45664 L .62442 .48841 L closepath p F P
0 g
s
0 0 0 r
.57269 .4838 m .57189 .48264 L .62442 .48841 L closepath p F P
0 g
s
0 0 0 r
.006 w
.27272 .40206 m
.71254 .32343 L
s
.5 Mabswid
.5822 .45664 m .58308 .45762 L .62442 .48841 L closepath p F P
0 g
s
0 0 .951 r
.57632 .47694 m .57269 .4838 L .62442 .48841 L closepath p F P
0 g
s
0 0 .759 r
.58064 .46604 m .57632 .47694 L .62442 .48841 L closepath p F P
0 g
s
0 0 .49 r
.58308 .45762 m .58064 .46604 L .62442 .48841 L closepath p F P
0 g
s
0 0 1 r
.01 w
.3612 .38624 m
.57879 .4707 L
s
.5 Mabswid
.647 0 0 r
.28329 .52334 m .29402 .52636 L .27146 .54658 L closepath p F P
0 g
s
.93 0 0 r
.27602 .51532 m .28329 .52334 L .27146 .54658 L closepath p F P
0 g
s
0 0 0 r
.29402 .52636 m .30202 .52261 L .27146 .54658 L closepath p F P
0 g
s
.769 0 0 r
.27647 .50692 m .27602 .51532 L .27146 .54658 L closepath p F P
0 g
s
.949 0 0 r
.30202 .52261 m .30259 .51423 L .27146 .54658 L closepath p F P
0 g
s
0 .872 0 r
.4314 .17751 m .41881 .17677 L .4473 .13778 L closepath p F P
0 g
s
0 .582 0 r
.44319 .18404 m .4314 .17751 L .4473 .13778 L closepath p F P
0 g
s
0 0 0 r
.44738 .19262 m .44319 .18404 L .4473 .13778 L closepath p F P
0 g
s
.261 0 0 r
.28445 .50307 m .27647 .50692 L .27146 .54658 L closepath p F P
0 g
s
.9 0 0 r
.30259 .51423 m .29531 .5061 L .27146 .54658 L closepath p F P
0 g
s
0 .917 0 r
.41881 .17677 m .4127 .18231 L .4473 .13778 L closepath p F P
0 g
s
.7 0 0 r
.29531 .5061 m .28445 .50307 L .27146 .54658 L closepath p F P
0 g
s
1 0 0 r
.01 w
.29428 .50582 m
.3612 .38624 L
s
.5 Mabswid
0 .927 0 r
.44144 .19827 m .44738 .19262 L .4473 .13778 L closepath p F P
0 g
s
0 .127 0 r
.4127 .18231 m .41678 .19096 L .4473 .13778 L closepath p F P
0 g
s
0 .8 0 r
.42873 .1976 m .44144 .19827 L .4473 .13778 L closepath p F P
0 g
s
0 .574 0 r
.41678 .19096 m .42873 .1976 L .4473 .13778 L closepath p F P
0 g
s
0 1 0 r
.01 w
.3612 .38624 m
.42692 .19659 L
s
0 g
gsave
.52228 .46632 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.33066 .49535 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.43219 .30075 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.3615 .29553 m
.38758 .56705 L
s
.5 Mabswid
0 0 .705 r
.55619 .48473 m .56208 .47492 L .60352 .50644 L closepath p F P
0 g
s
0 0 .445 r
.55401 .49268 m .55619 .48473 L .60352 .50644 L closepath p F P
0 g
s
0 0 .849 r
.56208 .47492 m .56829 .46888 L .60352 .50644 L closepath p F P
0 g
s
0 0 0 r
.55684 .49412 m .55401 .49268 L .60352 .50644 L closepath p F P
0 g
s
0 0 .952 r
.5631 .4881 m .55684 .49412 L .60352 .50644 L closepath p F P
0 g
s
0 0 .77 r
.56909 .47813 m .5631 .4881 L .60352 .50644 L closepath p F P
0 g
s
0 0 .668 r
.56829 .46888 m .57122 .47016 L .60352 .50644 L closepath p F P
0 g
s
0 0 .467 r
.57122 .47016 m .56909 .47813 L .60352 .50644 L closepath p F P
0 g
s
0 0 1 r
.01 w
.36795 .36267 m
.56588 .48347 L
s
0 0 0 r
.006 w
.3724 .29306 m
.34806 .67349 L
s
.27191 .36267 m
.72809 .36267 L
s
.5 Mabswid
0 .581 0 r
.51485 .17986 m .50413 .17106 L .53767 .13623 L closepath p F P
0 g
s
0 .109 0 r
.51937 .18933 m .51485 .17986 L .53767 .13623 L closepath p F P
0 g
s
0 .863 0 r
.50413 .17106 m .49337 .16798 L .53767 .13623 L closepath p F P
0 g
s
0 .929 0 r
.51501 .19397 m .51937 .18933 L .53767 .13623 L closepath p F P
0 g
s
0 0 0 r
.49337 .16798 m .48883 .17248 L .53767 .13623 L closepath p F P
0 g
s
0 .845 0 r
.50419 .19097 m .51501 .19397 L .53767 .13623 L closepath p F P
0 g
s
0 .25 0 r
.48883 .17248 m .49329 .18203 L .53767 .13623 L closepath p F P
0 g
s
.728 0 0 r
.29983 .49058 m .31053 .49538 L .29486 .51313 L closepath p F P
0 g
s
.132 0 0 r
.31053 .49538 m .32064 .49297 L .29486 .51313 L closepath p F P
0 g
s
0 .605 0 r
.49329 .18203 m .50419 .19097 L .53767 .13623 L closepath p F P
0 g
s
0 1 0 r
.01 w
.36795 .36267 m
.49952 .18714 L
s
.5 Mabswid
.928 0 0 r
.29473 .48134 m .29983 .49058 L .29486 .51313 L closepath p F P
0 g
s
.844 0 0 r
.32064 .49297 m .32428 .48472 L .29486 .51313 L closepath p F P
0 g
s
0 0 0 r
.29826 .47303 m .29473 .48134 L .29486 .51313 L closepath p F P
0 g
s
.96 0 0 r
.32428 .48472 m .31924 .47541 L .29486 .51313 L closepath p F P
0 g
s
.448 0 0 r
.30843 .47054 m .29826 .47303 L .29486 .51313 L closepath p F P
0 g
s
.785 0 0 r
.31924 .47541 m .30843 .47054 L .29486 .51313 L closepath p F P
0 g
s
1 0 0 r
.01 w
.31427 .47317 m
.36795 .36267 L
s
0 g
gsave
.51171 .46907 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.3394 .4689 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.47344 .29206 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.40523 .27386 m
.32038 .54507 L
s
.5 Mabswid
0 0 .707 r
.53463 .49197 m .54177 .48326 L .57649 .52049 L closepath p F P
0 g
s
0 0 .429 r
.53283 .49955 m .53463 .49197 L .57649 .52049 L closepath p F P
0 g
s
0 0 .668 r
.53749 .50158 m .53283 .49955 L .57649 .52049 L closepath p F P
0 g
s
0 0 .953 r
.54594 .49676 m .53749 .50158 L .57649 .52049 L closepath p F P
0 g
s
0 0 .831 r
.54177 .48326 m .55013 .47843 L .57649 .52049 L closepath p F P
0 g
s
0 0 .786 r
.55317 .48791 m .54594 .49676 L .57649 .52049 L closepath p F P
0 g
s
0 0 .747 r
.55013 .47843 m .55489 .48032 L .57649 .52049 L closepath p F P
0 g
s
0 0 .414 r
.55489 .48032 m .55317 .48791 L .57649 .52049 L closepath p F P
0 g
s
0 0 1 r
.01 w
.3843 .34074 m
.54818 .49402 L
s
0 0 0 r
.006 w
.28746 .32343 m
.72728 .40206 L
s
.38827 .27082 m
.36655 .65392 L
s
.5 Mabswid
0 .588 0 r
.58509 .18979 m .57646 .17912 L .62423 .15274 L closepath p F P
0 g
s
0 .231 0 r
.58953 .20008 m .58509 .18979 L .62423 .15274 L closepath p F P
0 g
s
0 .844 0 r
.57646 .17912 m .56856 .17419 L .62423 .15274 L closepath p F P
0 g
s
0 0 0 r
.58715 .20403 m .58953 .20008 L .62423 .15274 L closepath p F P
0 g
s
0 0 0 r
.56856 .17419 m .56603 .17796 L .62423 .15274 L closepath p F P
0 g
s
0 .889 0 r
.57925 .19921 m .58715 .20403 L .62423 .15274 L closepath p F P
0 g
s
0 .342 0 r
.56603 .17796 m .57046 .18836 L .62423 .15274 L closepath p F P
0 g
s
0 .641 0 r
.57046 .18836 m .57925 .19921 L .62423 .15274 L closepath p F P
0 g
s
0 1 0 r
.01 w
.3843 .34074 m
.57369 .19234 L
s
.5 Mabswid
.775 0 0 r
.33194 .46089 m .34174 .46747 L .3348 .4838 L closepath p F P
0 g
s
.324 0 0 r
.34174 .46747 m .35329 .46677 L .3348 .4838 L closepath p F P
0 g
s
.585 0 0 r
.35329 .46677 m .35991 .45918 L .3348 .4838 L closepath p F P
0 g
s
.749 0 0 r
.32961 .45082 m .33194 .46089 L .3348 .4838 L closepath p F P
0 g
s
.996 0 0 r
.35991 .45918 m .35768 .44907 L .3348 .4838 L closepath p F P
0 g
s
.039 0 0 r
.33617 .44314 m .32961 .45082 L .3348 .4838 L closepath p F P
0 g
s
.865 0 0 r
.35768 .44907 m .34783 .4424 L .3348 .4838 L closepath p F P
0 g
s
1 0 0 r
.01 w
.34888 .44311 m
.3843 .34074 L
s
.5 Mabswid
.584 0 0 r
.34783 .4424 m .33617 .44314 L .3348 .4838 L closepath p F P
0 g
s
gsave
.5004 .47005 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.36002 .44431 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.51691 .29116 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.45711 .26093 m
.26125 .51286 L
s
.5 Mabswid
0 0 .713 r
.51101 .49559 m .51895 .4881 L .54507 .52989 L closepath p F P
0 g
s
0 0 .394 r
.50969 .50291 m .51101 .49559 L .54507 .52989 L closepath p F P
0 g
s
0 0 .767 r
.51586 .50578 m .50969 .50291 L .54507 .52989 L closepath p F P
0 g
s
0 0 .954 r
.52596 .50244 m .51586 .50578 L .54507 .52989 L closepath p F P
0 g
s
0 0 .764 r
.52893 .48476 m .53518 .48752 L .54507 .52989 L closepath p F P
0 g
s
0 0 .819 r
.51895 .4881 m .52893 .48476 L .54507 .52989 L closepath p F P
0 g
s
0 0 .807 r
.53398 .49484 m .52596 .50244 L .54507 .52989 L closepath p F P
0 g
s
0 0 .297 r
.53518 .48752 m .53398 .49484 L .54507 .52989 L closepath p F P
0 g
s
0 0 1 r
.01 w
.40946 .32222 m
.52669 .50175 L
s
0 0 0 r
.006 w
.31952 .28747 m
.71152 .43893 L
s
.5 Mabswid
0 .601 0 r
.64743 .21264 m .64161 .2007 L .69856 .18514 L closepath p F P
0 g
s
0 .32 0 r
.65136 .22358 m .64743 .21264 L .69856 .18514 L closepath p F P
0 g
s
0 .816 0 r
.64161 .2007 m .63724 .19463 L .69856 .18514 L closepath p F P
0 g
s
0 0 0 r
.65113 .22722 m .65136 .22358 L .69856 .18514 L closepath p F P
0 g
s
0 0 0 r
.63724 .19463 m .63691 .19808 L .69856 .18514 L closepath p F P
0 g
s
0 .928 0 r
.6468 .22129 m .65113 .22722 L .69856 .18514 L closepath p F P
0 g
s
0 .419 0 r
.63691 .19808 m .64087 .20917 L .69856 .18514 L closepath p F P
0 g
s
0 .68 0 r
.64087 .20917 m .6468 .22129 L .69856 .18514 L closepath p F P
0 g
s
0 1 0 r
.01 w
.40946 .32222 m
.64219 .21187 L
s
.5 Mabswid
0 0 0 r
.39811 .44642 m .4073 .44001 L .38897 .46146 L closepath p F P
0 g
s
0 0 0 r
.006 w
.40477 .42707 m
.4126 .25204 L
s
.40409 .44225 m
.40477 .42707 L
s
.5 Mabswid
.456 0 0 r
.38602 .44518 m .39811 .44642 L .38897 .46146 L closepath p F P
0 g
s
.74 0 0 r
.37804 .437 m .38602 .44518 L .38897 .46146 L closepath p F P
0 g
s
.942 0 0 r
.4073 .44001 m .40823 .42965 L .38897 .46146 L closepath p F P
0 g
s
0 0 0 r
.006 w
.39536 .63731 m
.40122 .50637 L
s
.40122 .50637 m
.40402 .44385 L
s
.5 Mabswid
.37884 .42661 m .37804 .437 L .38897 .46146 L closepath p F P
0 g
s
.939 0 0 r
.40823 .42965 m .40026 .42137 L .38897 .46146 L closepath p F P
0 g
s
.301 0 0 r
.38805 .42011 m .37884 .42661 L .38897 .46146 L closepath p F P
0 g
s
.693 0 0 r
.40026 .42137 m .38805 .42011 L .38897 .46146 L closepath p F P
0 g
s
1 0 0 r
.01 w
.39495 .42082 m
.40946 .32222 L
s
0 g
gsave
.48906 .4692 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.39159 .42362 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.55896 .29816 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.51279 .25808 m
.21384 .47119 L
s
.36664 .25808 m
.68296 .47119 L
s
.5 Mabswid
0 0 .724 r
.48673 .49541 m .495 .48922 L .51113 .53421 L closepath p F P
0 g
s
0 0 .321 r
.48598 .50257 m .48673 .49541 L .51113 .53421 L closepath p F P
0 g
s
0 0 .828 r
.49329 .5065 m .48598 .50257 L .51113 .53421 L closepath p F P
0 g
s
0 0 .811 r
.495 .48922 m .50599 .48755 L .51113 .53421 L closepath p F P
0 g
s
0 0 .954 r
.50442 .50483 m .49329 .5065 L .51113 .53421 L closepath p F P
0 g
s
0 0 .753 r
.50599 .48755 m .51334 .49138 L .51113 .53421 L closepath p F P
0 g
s
0 0 .83 r
.51273 .49854 m .50442 .50483 L .51113 .53421 L closepath p F P
0 g
s
0 0 .078 r
.51334 .49138 m .51273 .49854 L .51113 .53421 L closepath p F P
0 g
s
0 0 1 r
.01 w
.44178 .3087 m
.5022 .50516 L
s
.5 Mabswid
0 .618 0 r
.6966 .24581 m .69397 .23333 L .75443 .22946 L closepath p F P
0 g
s
0 .391 0 r
.69972 .25718 m .6966 .24581 L .75443 .22946 L closepath p F P
0 g
s
0 0 0 r
.70154 .26089 m .69972 .25718 L .75443 .22946 L closepath p F P
0 g
s
0 .783 0 r
.69397 .23333 m .69334 .22691 L .75443 .22946 L closepath p F P
0 g
s
0 .952 0 r
.70096 .25464 m .70154 .26089 L .75443 .22946 L closepath p F P
0 g
s
0 0 0 r
.69334 .22691 m .69512 .23042 L .75443 .22946 L closepath p F P
0 g
s
0 .725 0 r
.69829 .24196 m .70096 .25464 L .75443 .22946 L closepath p F P
0 g
s
0 1 0 r
.01 w
.44178 .3087 m
.69864 .2436 L
s
.5 Mabswid
0 .49 0 r
.69512 .23042 m .69829 .24196 L .75443 .22946 L closepath p F P
0 g
s
.068 0 0 r
.45176 .43396 m .4628 .42919 L .45317 .44851 L closepath p F P
0 g
s
.536 0 0 r
.44019 .43073 m .45176 .43396 L .45317 .44851 L closepath p F P
0 g
s
0 0 0 r
.006 w
.43904 .40317 m
.44382 .23835 L
s
.5 Mabswid
.688 0 0 r
.4628 .42919 m .46691 .41916 L .45317 .44851 L closepath p F P
0 g
s
0 0 0 r
.43481 .42134 m .44019 .43073 L .45317 .44851 L closepath p F P
0 g
s
0 0 0 r
.006 w
.43816 .43343 m
.43833 .4275 L
s
.43836 .4266 m
.43904 .40317 L
s
.5 Mabswid
.985 0 0 r
.46691 .41916 m .46162 .40969 L .45317 .44851 L closepath p F P
0 g
s
.016 0 0 r
.43883 .41124 m .43481 .42134 L .45317 .44851 L closepath p F P
0 g
s
0 0 0 r
.006 w
.43261 .62515 m
.43301 .61127 L
s
.43301 .61127 m
.43816 .43343 L
s
.5 Mabswid
.789 0 0 r
.46162 .40969 m .44997 .40639 L .45317 .44851 L closepath p F P
0 g
s
.477 0 0 r
.44997 .40639 m .43883 .41124 L .45317 .44851 L closepath p F P
0 g
s
1 0 0 r
.01 w
.44178 .3087 m
.44975 .40649 L
s
0 g
gsave
.47842 .46657 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.43203 .40872 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.59612 .31236 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
0 0 .739 r
.46324 .49144 m .47136 .48653 L .47658 .53327 L closepath p F P
0 g
s
0 0 .173 r
.4631 .49855 m .46324 .49144 L .47658 .53327 L closepath p F P
0 g
s
0 0 .841 r
.47112 .5037 m .4631 .49855 L .47658 .53327 L closepath p F P
0 g
s
0 0 .736 r
.48269 .48664 m .49071 .4917 L .47658 .53327 L closepath p F P
0 g
s
0 0 .809 r
.47136 .48653 m .48269 .48664 L .47658 .53327 L closepath p F P
0 g
s
0 0 .954 r
.48261 .50381 m .47112 .5037 L .47658 .53327 L closepath p F P
0 g
s
0 0 .162 r
.49071 .4917 m .49072 .49881 L .47658 .53327 L closepath p F P
0 g
s
0 0 .845 r
.49072 .49881 m .48261 .50381 L .47658 .53327 L closepath p F P
0 g
s
0 0 0 r
.006 w
.42552 .23829 m
.53342 .36614 L
s
.53342 .36614 m
.64414 .49732 L
s
0 0 1 r
.01 w
.47686 .50375 m
.47882 .30143 L
s
0 0 0 r
.006 w
.56733 .26564 m
.18203 .42145 L
s
.47956 .23099 m
.47546 .61859 L
s
.5 Mabswid
0 .641 0 r
.72926 .28586 m .7298 .27352 L .78845 .28088 L closepath p F P
0 g
s
0 .454 0 r
.73137 .2974 m .72926 .28586 L .78845 .28088 L closepath p F P
0 g
s
0 0 0 r
.73493 .30151 m .73137 .2974 L .78845 .28088 L closepath p F P
0 g
s
0 .749 0 r
.7298 .27352 m .7327 .26748 L .78845 .28088 L closepath p F P
0 g
s
0 .775 0 r
.73847 .28313 m .73789 .29565 L .78845 .28088 L closepath p F P
0 g
s
0 .561 0 r
.7363 .27141 m .73847 .28313 L .78845 .28088 L closepath p F P
0 g
s
0 0 0 r
.7327 .26748 m .7363 .27141 L .78845 .28088 L closepath p F P
0 g
s
0 .951 0 r
.73789 .29565 m .73493 .30151 L .78845 .28088 L closepath p F P
0 g
s
0 1 0 r
.01 w
.47882 .30143 m
.73842 .2842 L
s
.5 Mabswid
0 0 0 r
.52163 .42789 m .5286 .41878 L .52173 .44644 L closepath p F P
0 g
s
.291 0 0 r
.5097 .43075 m .52163 .42789 L .52173 .44644 L closepath p F P
0 g
s
.55 0 0 r
.49971 .4257 m .5097 .43075 L .52173 .44644 L closepath p F P
0 g
s
.918 0 0 r
.5286 .41878 m .5265 .40869 L .52173 .44644 L closepath p F P
0 g
s
0 0 0 r
.49749 .41563 m .49971 .4257 L .52173 .44644 L closepath p F P
0 g
s
.874 0 0 r
.5265 .40869 m .51649 .40353 L .52173 .44644 L closepath p F P
0 g
s
.273 0 0 r
.50443 .40642 m .49749 .41563 L .52173 .44644 L closepath p F P
0 g
s
.607 0 0 r
.51649 .40353 m .50443 .40642 L .52173 .44644 L closepath p F P
0 g
s
1 0 0 r
.01 w
.47882 .30143 m
.50952 .4052 L
s
0 g
gsave
.46917 .46231 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.4782 .40108 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.62552 .33239 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.49122 .23028 m
.59776 .5163 L
s
.5 Mabswid
0 0 .756 r
.44195 .48388 m .44941 .4802 L .44332 .5271 L closepath p F P
0 g
s
0 0 .067 r
.44243 .49106 m .44195 .48388 L .44332 .5271 L closepath p F P
0 g
s
0 0 .812 r
.44941 .4802 m .46043 .4821 L .44332 .5271 L closepath p F P
0 g
s
0 0 .827 r
.45069 .49753 m .44243 .49106 L .44332 .5271 L closepath p F P
0 g
s
0 0 .312 r
.46864 .48847 m .46926 .49565 L .44332 .5271 L closepath p F P
0 g
s
0 0 .722 r
.46043 .4821 m .46864 .48847 L .44332 .5271 L closepath p F P
0 g
s
0 0 .954 r
.46184 .49943 m .45069 .49753 L .44332 .5271 L closepath p F P
0 g
s
0 0 .833 r
.46926 .49565 m .46184 .49943 L .44332 .5271 L closepath p F P
0 g
s
0 0 1 r
.01 w
.45291 .49791 m
.5176 .3011 L
s
.5 Mabswid
0 .667 0 r
.74409 .32908 m .7475 .31747 L .8 .3346 L closepath p F P
0 g
s
0 .514 0 r
.7451 .34056 m .74409 .32908 L .8 .3346 L closepath p F P
0 g
s
0 .059 0 r
.75 .3453 m .7451 .34056 L .8 .3346 L closepath p F P
0 g
s
0 .831 0 r
.75947 .32866 m .75596 .34042 L .8 .3346 L closepath p F P
0 g
s
0 .717 0 r
.7475 .31747 m .75341 .31243 L .8 .3346 L closepath p F P
0 g
s
0 .638 0 r
.7584 .31702 m .75947 .32866 L .8 .3346 L closepath p F P
0 g
s
0 0 0 r
.75341 .31243 m .7584 .31702 L .8 .3346 L closepath p F P
0 g
s
0 .92 0 r
.75596 .34042 m .75 .3453 L .8 .3346 L closepath p F P
0 g
s
0 1 0 r
.01 w
.5176 .3011 m
.75914 .32976 L
s
0 0 0 r
.006 w
.61597 .28279 m
.16975 .36587 L
s
.51698 .23066 m
.52039 .61829 L
s
.5 Mabswid
.073 0 0 r
.57852 .43625 m .58769 .42855 L .58826 .45549 L closepath p F P
0 g
s
.449 0 0 r
.56678 .43712 m .57852 .43625 L .58826 .45549 L closepath p F P
0 g
s
0 0 0 r
.55925 .43064 m .56678 .43712 L .58826 .45549 L closepath p F P
0 g
s
0 0 0 r
.58769 .42855 m .58895 .41846 L .58826 .45549 L closepath p F P
0 g
s
.069 0 0 r
.56039 .42052 m .55925 .43064 L .58826 .45549 L closepath p F P
0 g
s
.935 0 0 r
.58895 .41846 m .58148 .41187 L .58826 .45549 L closepath p F P
0 g
s
.443 0 0 r
.56962 .41271 m .56039 .42052 L .58826 .45549 L closepath p F P
0 g
s
1 0 0 r
.01 w
.5176 .3011 m
.56894 .41328 L
s
.5 Mabswid
.713 0 0 r
.58148 .41187 m .56962 .41271 L .58826 .45549 L closepath p F P
0 g
s
gsave
.46193 .45669 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.52624 .40146 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.64518 .35648 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.55772 .23499 m
.54649 .52747 L
s
.5 Mabswid
0 .697 0 r
.7415 .37207 m .7473 .36162 L .79058 .38649 L closepath p F P
0 g
s
0 .576 0 r
.74145 .38328 m .7415 .37207 L .79058 .38649 L closepath p F P
0 g
s
0 .151 0 r
.74722 .38879 m .74145 .38328 L .79058 .38649 L closepath p F P
0 g
s
0 .891 0 r
.76141 .37474 m .7555 .38529 L .79058 .38649 L closepath p F P
0 g
s
0 .69 0 r
.7473 .36162 m .75553 .35799 L .79058 .38649 L closepath p F P
0 g
s
0 .721 0 r
.76141 .36338 m .76141 .37474 L .79058 .38649 L closepath p F P
0 g
s
0 0 0 r
.75553 .35799 m .76141 .36338 L .79058 .38649 L closepath p F P
0 g
s
0 .864 0 r
.7555 .38529 m .74722 .38879 L .79058 .38649 L closepath p F P
0 g
s
0 1 0 r
.01 w
.55493 .30775 m
.76046 .37643 L
s
.5 Mabswid
0 0 .768 r
.42419 .47313 m .43054 .47053 L .41326 .51598 L closepath p F P
0 g
s
0 0 .288 r
.42528 .48049 m .42419 .47313 L .41326 .51598 L closepath p F P
0 g
s
0 0 .712 r
.44055 .47414 m .44845 .48184 L .41326 .51598 L closepath p F P
0 g
s
0 0 .82 r
.43054 .47053 m .44055 .47414 L .41326 .51598 L closepath p F P
0 g
s
0 0 .805 r
.43327 .48831 m .42528 .48049 L .41326 .51598 L closepath p F P
0 g
s
0 0 .386 r
.44845 .48184 m .44967 .48921 L .41326 .51598 L closepath p F P
0 g
s
0 0 .954 r
.4434 .49192 m .43327 .48831 L .41326 .51598 L closepath p F P
0 g
s
0 0 .776 r
.44967 .48921 m .4434 .49192 L .41326 .51598 L closepath p F P
0 g
s
0 0 1 r
.01 w
.43255 .48762 m
.55493 .30775 L
s
0 0 0 r
.006 w
.55301 .23738 m
.56359 .62429 L
s
.6548 .30775 m
.18041 .30775 L
s
.5 Mabswid
.314 0 0 r
.62848 .45336 m .63898 .44739 L .6467 .47461 L closepath p F P
0 g
s
.557 0 0 r
.61795 .45239 m .62848 .45336 L .6467 .47461 L closepath p F P
0 g
s
0 0 0 r
.63898 .44739 m .64338 .43791 L .6467 .47461 L closepath p F P
0 g
s
0 0 0 r
.61349 .44499 m .61795 .45239 L .6467 .47461 L closepath p F P
0 g
s
.904 0 0 r
.64338 .43791 m .63905 .43043 L .6467 .47461 L closepath p F P
0 g
s
.279 0 0 r
.61782 .43544 m .61349 .44499 L .6467 .47461 L closepath p F P
0 g
s
.807 0 0 r
.63905 .43043 m .62844 .42938 L .6467 .47461 L closepath p F P
0 g
s
.567 0 0 r
.62844 .42938 m .61782 .43544 L .6467 .47461 L closepath p F P
0 g
s
1 0 0 r
.01 w
.55493 .30775 m
.62341 .43225 L
s
0 g
gsave
.45719 .45006 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.57203 .40982 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.65413 .38262 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.61892 .25187 m
.49297 .53051 L
s
.5 Mabswid
0 .732 0 r
.72319 .41195 m .73078 .40296 L .763 .43336 L closepath p F P
0 g
s
0 .644 0 r
.72217 .42275 m .72319 .41195 L .763 .43336 L closepath p F P
0 g
s
0 .214 0 r
.72836 .4291 m .72217 .42275 L .763 .43336 L closepath p F P
0 g
s
0 .947 0 r
.74593 .41814 m .73822 .42722 L .763 .43336 L closepath p F P
0 g
s
0 .084 0 r
.7406 .40097 m .74691 .40724 L .763 .43336 L closepath p F P
0 g
s
0 .669 0 r
.73078 .40296 m .7406 .40097 L .763 .43336 L closepath p F P
0 g
s
0 .799 0 r
.74691 .40724 m .74593 .41814 L .763 .43336 L closepath p F P
0 g
s
0 .796 0 r
.73822 .42722 m .72836 .4291 L .763 .43336 L closepath p F P
0 g
s
0 1 0 r
.01 w
.5878 .32072 m
.7436 .42089 L
s
.5 Mabswid
0 0 .752 r
.41116 .45977 m .41596 .45806 L .38822 .50041 L closepath p F P
0 g
s
0 0 .833 r
.41596 .45806 m .42432 .46321 L .38822 .50041 L closepath p F P
0 g
s
0 0 .407 r
.41282 .46744 m .41116 .45977 L .38822 .50041 L closepath p F P
0 g
s
0 0 .706 r
.42432 .46321 m .43142 .47218 L .38822 .50041 L closepath p F P
0 g
s
0 0 .785 r
.42002 .47657 m .41282 .46744 L .38822 .50041 L closepath p F P
0 g
s
0 0 .421 r
.43142 .47218 m .43316 .47984 L .38822 .50041 L closepath p F P
0 g
s
0 0 .953 r
.42847 .4817 m .42002 .47657 L .38822 .50041 L closepath p F P
0 g
s
0 0 .684 r
.43316 .47984 m .42847 .4817 L .38822 .50041 L closepath p F P
0 g
s
0 0 1 r
.01 w
.41781 .47377 m
.5878 .32072 L
s
0 0 0 r
.006 w
.58475 .25053 m
.60149 .63597 L
s
.68114 .3381 m
.2161 .25152 L
s
.5 Mabswid
.134 0 0 r
.67842 .47329 m .68542 .46494 L .69226 .50168 L closepath p F P
0 g
s
.481 0 0 r
.66753 .47742 m .67842 .47329 L .69226 .50168 L closepath p F P
0 g
s
.614 0 0 r
.65902 .47494 m .66753 .47742 L .69226 .50168 L closepath p F P
0 g
s
0 0 0 r
.68542 .46494 m .68443 .45718 L .69226 .50168 L closepath p F P
0 g
s
0 0 0 r
.65789 .46722 m .65902 .47494 L .69226 .50168 L closepath p F P
0 g
s
.892 0 0 r
.68443 .45718 m .67593 .45459 L .69226 .50168 L closepath p F P
0 g
s
.425 0 0 r
.6649 .45876 m .65789 .46722 L .69226 .50168 L closepath p F P
0 g
s
.665 0 0 r
.67593 .45459 m .6649 .45876 L .69226 .50168 L closepath p F P
0 g
s
1 0 0 r
.01 w
.5878 .32072 m
.66702 .45796 L
s
0 g
gsave
.45533 .44285 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.61176 .42533 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.65232 .40887 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.66951 .27902 m
.43978 .52533 L
s
.5 Mabswid
0 .656 0 r
.70039 .43915 m .71106 .43892 L .72067 .47296 L closepath p F P
0 g
s
0 .77 0 r
.69159 .44655 m .70039 .43915 L .72067 .47296 L closepath p F P
0 g
s
0 .72 0 r
.68974 .45683 m .69159 .44655 L .72067 .47296 L closepath p F P
0 g
s
0 .985 0 r
.71558 .45641 m .70668 .46388 L .72067 .47296 L closepath p F P
0 g
s
0 .174 0 r
.71106 .43892 m .71738 .44605 L .72067 .47296 L closepath p F P
0 g
s
0 .81 0 r
.71738 .44605 m .71558 .45641 L .72067 .47296 L closepath p F P
0 g
s
0 .243 0 r
.69596 .46403 m .68974 .45683 L .72067 .47296 L closepath p F P
0 g
s
0 .73 0 r
.70668 .46388 m .69596 .46403 L .72067 .47296 L closepath p F P
0 g
s
0 1 0 r
.01 w
.61371 .33885 m
.71072 .46049 L
s
.5 Mabswid
0 0 .437 r
.41868 .46002 m .42085 .46807 L .36992 .48118 L closepath p F P
0 g
s
0 0 .705 r
.41287 .4499 m .41868 .46002 L .36992 .48118 L closepath p F P
0 g
s
0 0 .852 r
.40675 .4435 m .41287 .4499 L .36992 .48118 L closepath p F P
0 g
s
0 0 .675 r
.40387 .4446 m .40675 .4435 L .36992 .48118 L closepath p F P
0 g
s
0 0 .46 r
.40599 .45267 m .40387 .4446 L .36992 .48118 L closepath p F P
0 g
s
0 0 .769 r
.4119 .46297 m .40599 .45267 L .36992 .48118 L closepath p F P
0 g
s
0 0 0 r
.42085 .46807 m .41807 .46934 L .36992 .48118 L closepath p F P
0 g
s
0 0 .952 r
.41807 .46934 m .4119 .46297 L .36992 .48118 L closepath p F P
0 g
s
0 0 1 r
.01 w
.40919 .45825 m
.61371 .33885 L
s
0 0 0 r
.006 w
.60981 .26889 m
.63118 .65222 L
s
.69373 .37121 m
.27657 .20252 L
s
.5 Mabswid
.345 0 0 r
.70346 .50376 m .71234 .49687 L .7219 .53395 L closepath p F P
0 g
s
.606 0 0 r
.69306 .50612 m .70346 .50376 L .7219 .53395 L closepath p F P
0 g
s
.59 0 0 r
.68715 .50256 m .69306 .50612 L .7219 .53395 L closepath p F P
0 g
s
0 0 0 r
.71234 .49687 m .71455 .48941 L .7219 .53395 L closepath p F P
0 g
s
.188 0 0 r
.68924 .49509 m .68715 .50256 L .7219 .53395 L closepath p F P
0 g
s
.951 0 0 r
.71455 .48941 m .70872 .48574 L .7219 .53395 L closepath p F P
0 g
s
.533 0 0 r
.6982 .48809 m .68924 .49509 L .7219 .53395 L closepath p F P
0 g
s
1 0 0 r
.01 w
.61371 .33885 m
.69699 .48903 L
s
.5 Mabswid
.751 0 0 r
.70872 .48574 m .6982 .48809 L .7219 .53395 L closepath p F P
0 g
s
gsave
.4565 .43554 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.64238 .44646 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.64046 .43346 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
0 0 0 r
.67579 .47802 m .67333 .48778 L .66711 .50383 L closepath p F P
0 g
s
0 .254 0 r
.6698 .47007 m .67579 .47802 L .66711 .50383 L closepath p F P
0 g
s
0 .648 0 r
.65891 .46855 m .6698 .47007 L .66711 .50383 L closepath p F P
0 g
s
0 .811 0 r
.64947 .47432 m .65891 .46855 L .66711 .50383 L closepath p F P
0 g
s
0 .982 0 r
.67333 .48778 m .66381 .4936 L .66711 .50383 L closepath p F P
0 g
s
0 .804 0 r
.64694 .48402 m .64947 .47432 L .66711 .50383 L closepath p F P
0 g
s
0 .212 0 r
.65286 .49203 m .64694 .48402 L .66711 .50383 L closepath p F P
0 g
s
0 .674 0 r
.66381 .4936 m .65286 .49203 L .66711 .50383 L closepath p F P
0 g
s
0 1 0 r
.01 w
.63093 .36053 m
.66443 .49322 L
s
0 0 0 r
.006 w
.6265 .29089 m
.65069 .67159 L
s
.69259 .40449 m
.35836 .16623 L
s
.5 Mabswid
0 0 .441 r
.41119 .44608 m .41366 .45459 L .35982 .45932 L closepath p F P
0 g
s
0 0 0 r
.006 w
.55279 .40958 m
.70572 .31357 L
s
.38953 .51207 m
.55279 .40958 L
s
.5 Mabswid
0 0 .708 r
.40708 .43502 m .41119 .44608 L .35982 .45932 L closepath p F P
0 g
s
0 0 .875 r
.40369 .42775 m .40708 .43502 L .35982 .45932 L closepath p F P
0 g
s
0 0 0 r
.41366 .45459 m .41303 .4556 L .35982 .45932 L closepath p F P
0 g
s
0 0 0 r
.40299 .42857 m .40369 .42775 L .35982 .45932 L closepath p F P
0 g
s
0 0 .484 r
.40545 .43711 m .40299 .42857 L .35982 .45932 L closepath p F P
0 g
s
0 0 .759 r
.40963 .44837 m .40545 .43711 L .35982 .45932 L closepath p F P
0 g
s
0 0 .951 r
.41303 .4556 m .40963 .44837 L .35982 .45932 L closepath p F P
0 g
s
0 0 1 r
.01 w
.40728 .44203 m
.63093 .36053 L
s
.5 Mabswid
.49 0 0 r
.71318 .53615 m .72315 .5309 L .73451 .56853 L closepath p F P
0 g
s
.707 0 0 r
.70401 .53695 m .71318 .53615 L .73451 .56853 L closepath p F P
0 g
s
.075 0 0 r
.72315 .5309 m .72815 .5242 L .73451 .56853 L closepath p F P
0 g
s
0 0 0 r
.70095 .53279 m .70401 .53695 L .73451 .56853 L closepath p F P
0 g
s
.91 0 0 r
.72815 .5242 m .72522 .51996 L .73451 .56853 L closepath p F P
0 g
s
.34 0 0 r
.70589 .52605 m .70095 .53279 L .73451 .56853 L closepath p F P
0 g
s
.832 0 0 r
.72522 .51996 m .71598 .52071 L .73451 .56853 L closepath p F P
0 g
s
.619 0 0 r
.71598 .52071 m .70589 .52605 L .73451 .56853 L closepath p F P
0 g
s
1 0 0 r
.01 w
.63093 .36053 m
.7118 .52292 L
s
0 g
gsave
.46068 .42864 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.66193 .47132 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.61984 .45493 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
0 0 0 r
.62517 .50194 m .62221 .5111 L .60569 .52508 L closepath p F P
0 g
s
0 .318 0 r
.61979 .49325 m .62517 .50194 L .60569 .52508 L closepath p F P
0 g
s
0 .919 0 r
.62221 .5111 m .6126 .51532 L .60569 .52508 L closepath p F P
0 g
s
0 .647 0 r
.60926 .49006 m .61979 .49325 L .60569 .52508 L closepath p F P
0 g
s
0 .854 0 r
.59969 .49422 m .60926 .49006 L .60569 .52508 L closepath p F P
0 g
s
0 .879 0 r
.59665 .50333 m .59969 .49422 L .60569 .52508 L closepath p F P
0 g
s
0 0 0 r
.60199 .51209 m .59665 .50333 L .60569 .52508 L closepath p F P
0 g
s
0 .632 0 r
.6126 .51532 m .60199 .51209 L .60569 .52508 L closepath p F P
0 g
s
0 1 0 r
.01 w
.60827 .51401 m
.63858 .38402 L
s
0 0 0 r
.006 w
.67876 .4357 m
.45455 .1473 L
s
.63398 .31475 m
.65909 .69246 L
s
.5 Mabswid
0 0 .436 r
.40961 .43122 m .41222 .44025 L .35903 .43618 L closepath p F P
0 g
s
0 0 0 r
.006 w
.54569 .4179 m
.72563 .35227 L
s
.34487 .49114 m
.54569 .4179 L
s
.5 Mabswid
0 0 .716 r
.40755 .41951 m .40961 .43122 L .35903 .43618 L closepath p F P
0 g
s
0 0 .901 r
.40721 .41185 m .40755 .41951 L .35903 .43618 L closepath p F P
0 g
s
0 0 0 r
.41222 .44025 m .41386 .44135 L .35903 .43618 L closepath p F P
0 g
s
0 0 0 r
.40883 .41274 m .40721 .41185 L .35903 .43618 L closepath p F P
0 g
s
0 0 .95 r
.41386 .44135 m .41356 .43373 L .35903 .43618 L closepath p F P
0 g
s
0 0 .495 r
.41147 .42183 m .40883 .41274 L .35903 .43618 L closepath p F P
0 g
s
0 0 .754 r
.41356 .43373 m .41147 .42183 L .35903 .43618 L closepath p F P
0 g
s
0 0 1 r
.01 w
.41224 .42625 m
.63858 .38402 L
s
.5 Mabswid
.294 0 0 r
.71833 .56442 m .72556 .55884 L .73057 .60272 L closepath p F P
0 g
s
.6 0 0 r
.70806 .56802 m .71833 .56442 L .73057 .60272 L closepath p F P
0 g
s
.791 0 0 r
.70065 .56756 m .70806 .56802 L .73057 .60272 L closepath p F P
0 g
s
0 0 0 r
.72556 .55884 m .7255 .55449 L .73057 .60272 L closepath p F P
0 g
s
0 0 0 r
.70044 .56327 m .70065 .56756 L .73057 .60272 L closepath p F P
0 g
s
.909 0 0 r
.7255 .55449 m .71809 .55397 L .73057 .60272 L closepath p F P
0 g
s
.453 0 0 r
.70767 .55762 m .70044 .56327 L .73057 .60272 L closepath p F P
0 g
s
.693 0 0 r
.71809 .55397 m .70767 .55762 L .73057 .60272 L closepath p F P
0 g
s
1 0 0 r
.01 w
.63858 .38402 m
.71109 .55642 L
s
0 g
gsave
.46762 .42264 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.66955 .49783 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.59211 .47215 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
0 0 0 r
.56851 .5171 m .56521 .52566 L .53958 .53625 L closepath p F P
0 g
s
0 .809 0 r
.56521 .52566 m .55596 .52838 L .53958 .53625 L closepath p F P
0 g
s
0 .372 0 r
.56398 .50773 m .56851 .5171 L .53958 .53625 L closepath p F P
0 g
s
0 .652 0 r
.55429 .50299 m .56398 .50773 L .53958 .53625 L closepath p F P
0 g
s
0 .894 0 r
.54505 .50563 m .55429 .50299 L .53958 .53625 L closepath p F P
0 g
s
0 .868 0 r
.54167 .51416 m .54505 .50563 L .53958 .53625 L closepath p F P
0 g
s
0 .054 0 r
.54618 .52361 m .54167 .51416 L .53958 .53625 L closepath p F P
0 g
s
0 .601 0 r
.55596 .52838 m .54618 .52361 L .53958 .53625 L closepath p F P
0 g
s
0 1 0 r
.01 w
.54832 .52465 m
.63661 .40759 L
s
0 0 0 r
.006 w
.72901 .3919 m
.30848 .46329 L
s
.65396 .46303 m
.5555 .14832 L
s
.63215 .33871 m
.65642 .7133 L
s
.5 Mabswid
.442 0 0 r
.69945 .59528 m .70826 .59101 L .71171 .63429 L closepath p F P
0 g
s
.691 0 0 r
.68954 .59731 m .69945 .59528 L .71171 .63429 L closepath p F P
0 g
s
.847 0 0 r
.68423 .59594 m .68954 .59731 L .71171 .63429 L closepath p F P
0 g
s
0 0 .418 r
.41425 .41645 m .41682 .42602 L .3681 .4133 L closepath p F P
0 g
s
0 0 .728 r
.41445 .40445 m .41425 .41645 L .3681 .4133 L closepath p F P
0 g
s
0 0 0 r
.70826 .59101 m .71085 .58697 L .71171 .63429 L closepath p F P
0 g
s
0 0 .927 r
.41731 .39691 m .41445 .40445 L .3681 .4133 L closepath p F P
0 g
s
0 0 0 r
.41682 .42602 m .42069 .42759 L .3681 .4133 L closepath p F P
0 g
s
.065 0 0 r
.68669 .59192 m .68423 .59594 L .71171 .63429 L closepath p F P
0 g
s
.976 0 0 r
.71085 .58697 m .70561 .58554 L .71171 .63429 L closepath p F P
0 g
s
0 0 0 r
.4212 .39829 m .41731 .39691 L .3681 .4133 L closepath p F P
0 g
s
.541 0 0 r
.69557 .58759 m .68669 .59192 L .71171 .63429 L closepath p F P
0 g
s
0 0 .948 r
.42069 .42759 m .42361 .42011 L .3681 .4133 L closepath p F P
0 g
s
.76 0 0 r
.70561 .58554 m .69557 .58759 L .71171 .63429 L closepath p F P
0 g
s
1 0 0 r
.01 w
.63661 .40759 m
.6962 .58746 L
s
.5 Mabswid
0 0 .498 r
.42383 .40791 m .4212 .39829 L .3681 .4133 L closepath p F P
0 g
s
0 0 .754 r
.42361 .42011 m .42383 .40791 L .3681 .4133 L closepath p F P
0 g
s
0 0 1 r
.01 w
.42376 .41212 m
.63661 .40759 L
s
0 g
gsave
.47687 .41797 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.66543 .52405 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.55914 .4843 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
0 .053 0 r
.50867 .52308 m .5052 .53108 L .47176 .53711 L closepath p F P
0 g
s
0 .684 0 r
.5052 .53108 m .49673 .53243 L .47176 .53711 L closepath p F P
0 g
s
0 .419 0 r
.50517 .51314 m .50867 .52308 L .47176 .53711 L closepath p F P
0 g
s
0 .661 0 r
.49676 .507 m .50517 .51314 L .47176 .53711 L closepath p F P
0 g
s
0 .927 0 r
.48828 .50824 m .49676 .507 L .47176 .53711 L closepath p F P
0 g
s
0 0 0 r
.48472 .51622 m .48828 .50824 L .47176 .53711 L closepath p F P
0 g
s
0 .182 0 r
.48822 .52627 m .48472 .51622 L .47176 .53711 L closepath p F P
0 g
s
0 .582 0 r
.49673 .53243 m .48822 .52627 L .47176 .53711 L closepath p F P
0 g
s
0 1 0 r
.01 w
.48804 .52575 m
.62562 .42965 L
s
0 0 0 r
.006 w
.62029 .48513 m
.65063 .16915 L
s
.62158 .36118 m
.64349 .73271 L
s
.71698 .42965 m
.28302 .42965 L
s
.5 Mabswid
.552 0 0 r
.66871 .62178 m .67847 .61894 L .68028 .66153 L closepath p F P
0 g
s
.773 0 0 r
.65971 .62243 m .66871 .62178 L .68028 .66153 L closepath p F P
0 g
s
.091 0 0 r
.67847 .61894 m .68335 .61554 L .68028 .66153 L closepath p F P
0 g
s
.821 0 0 r
.65668 .62049 m .65971 .62243 L .68028 .66153 L closepath p F P
0 g
s
.992 0 0 r
.68335 .61554 m .68044 .61356 L .68028 .66153 L closepath p F P
0 g
s
.254 0 0 r
.66148 .61708 m .65668 .62049 L .68028 .66153 L closepath p F P
0 g
s
.823 0 0 r
.68044 .61356 m .67135 .61419 L .68028 .66153 L closepath p F P
0 g
s
.615 0 0 r
.67135 .61419 m .66148 .61708 L .68028 .66153 L closepath p F P
0 g
s
1 0 0 r
.01 w
.62562 .42965 m
.66926 .6148 L
s
.5 Mabswid
0 0 .379 r
.42499 .40282 m .42734 .4129 L .38689 .39242 L closepath p F P
0 g
s
0 0 .743 r
.42751 .39093 m .42499 .40282 L .38689 .39242 L closepath p F P
0 g
s
0 0 .947 r
.43346 .38407 m .42751 .39093 L .38689 .39242 L closepath p F P
0 g
s
0 0 .696 r
.42734 .4129 m .43322 .41531 L .38689 .39242 L closepath p F P
0 g
s
0 0 0 r
.4394 .38631 m .43346 .38407 L .38689 .39242 L closepath p F P
0 g
s
0 0 .947 r
.43322 .41531 m .43925 .40852 L .38689 .39242 L closepath p F P
0 g
s
0 0 .494 r
.44182 .39646 m .4394 .38631 L .38689 .39242 L closepath p F P
0 g
s
0 0 .76 r
.43925 .40852 m .44182 .39646 L .38689 .39242 L closepath p F P
0 g
s
0 0 1 r
.01 w
.44089 .40084 m
.62562 .42965 L
s
0 g
gsave
.48779 .41499 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.65056 .54827 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.52291 .49084 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
0 0 0 r
.44495 .52724 m .43765 .52738 L .40516 .52767 L closepath p F P
0 g
s
0 .171 0 r
.44844 .51976 m .44495 .52724 L .40516 .52767 L closepath p F P
0 g
s
0 .464 0 r
.44613 .50933 m .44844 .51976 L .40516 .52767 L closepath p F P
0 g
s
0 .674 0 r
.43938 .50198 m .44613 .50933 L .40516 .52767 L closepath p F P
0 g
s
0 .944 0 r
.43207 .50199 m .43938 .50198 L .40516 .52767 L closepath p F P
0 g
s
0 0 0 r
.42849 .50945 m .43207 .50199 L .40516 .52767 L closepath p F P
0 g
s
0 .276 0 r
.4308 .52 m .42849 .50945 L .40516 .52767 L closepath p F P
0 g
s
0 .572 0 r
.43765 .52738 m .4308 .52 L .40516 .52767 L closepath p F P
0 g
s
0 1 0 r
.01 w
.43032 .51783 m
.60674 .4489 L
s
0 0 0 r
.006 w
.58007 .50102 m
.73054 .20695 L
s
.69152 .46329 m
.27099 .3919 L
s
.5 Mabswid
.64 0 0 r
.62864 .64273 m .63875 .64134 L .63893 .68321 L closepath p F P
0 g
s
.851 0 0 r
.62099 .64221 m .62864 .64273 L .63893 .68321 L closepath p F P
0 g
s
.304 0 0 r
.63875 .64134 m .6455 .63882 L .63893 .68321 L closepath p F P
0 g
s
0 0 0 r
.62027 .64005 m .62099 .64221 L .63893 .68321 L closepath p F P
0 g
s
0 0 0 r
.006 w
.60336 .38079 m
.61552 .62563 L
s
.5 Mabswid
.839 0 0 r
.6455 .63882 m .64493 .63663 L .63893 .68321 L closepath p F P
0 g
s
.392 0 0 r
.627 .6375 m .62027 .64005 L .63893 .68321 L closepath p F P
0 g
s
0 0 0 r
.006 w
.61552 .62563 m
.62167 .74957 L
s
.5 Mabswid
.884 0 0 r
.64493 .63663 m .63726 .63608 L .63893 .68321 L closepath p F P
0 g
s
.678 0 0 r
.63726 .63608 m .627 .6375 L .63893 .68321 L closepath p F P
0 g
s
1 0 0 r
.01 w
.60674 .4489 m
.63255 .63673 L
s
.5 Mabswid
0 0 .297 r
.44123 .39137 m .44317 .4019 L .41439 .37523 L closepath p F P
0 g
s
0 0 .759 r
.44595 .38 m .44123 .39137 L .41439 .37523 L closepath p F P
0 g
s
0 0 .957 r
.45461 .37436 m .44595 .38 L .41439 .37523 L closepath p F P
0 g
s
0 0 .786 r
.44317 .4019 m .45068 .40547 L .41439 .37523 L closepath p F P
0 g
s
0 0 0 r
.4622 .37779 m .45461 .37436 L .41439 .37523 L closepath p F P
0 g
s
0 0 .946 r
.45068 .40547 m .45943 .39989 L .41439 .37523 L closepath p F P
0 g
s
0 0 .482 r
.46422 .38838 m .4622 .37779 L .41439 .37523 L closepath p F P
0 g
s
0 0 .771 r
.45943 .39989 m .46422 .38838 L .41439 .37523 L closepath p F P
0 g
s
0 0 1 r
.01 w
.46209 .3935 m
.60674 .4489 L
s
0 g
gsave
.49958 .41392 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.62647 .5691 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.48543 .4915 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
0 .262 0 r
.39058 .50721 m .38724 .51424 L .34274 .50808 L closepath p F P
0 g
s
0 .502 0 r
.38724 .51424 m .38147 .51336 L .34274 .50808 L closepath p F P
0 g
s
0 .508 0 r
.38959 .49641 m .39058 .50721 L .34274 .50808 L closepath p F P
0 g
s
0 .692 0 r
.38486 .48807 m .38959 .49641 L .34274 .50808 L closepath p F P
0 g
s
0 .937 0 r
.37909 .48703 m .38486 .48807 L .34274 .50808 L closepath p F P
0 g
s
0 0 0 r
.37567 .49402 m .37909 .48703 L .34274 .50808 L closepath p F P
0 g
s
0 .348 0 r
.37666 .50497 m .37567 .49402 L .34274 .50808 L closepath p F P
0 g
s
0 .57 0 r
.38147 .51336 m .37666 .50497 L .34274 .50808 L closepath p F P
0 g
s
0 1 0 r
.01 w
.37638 .50191 m
.58145 .46427 L
s
0 0 0 r
.006 w
.53565 .51011 m
.78863 .25693 L
s
.65513 .49114 m
.27437 .35227 L
s
.5 Mabswid
.45 0 0 r
.59179 .65733 m .59997 .65588 L .59041 .6985 L closepath p F P
0 g
s
.717 0 0 r
.58186 .65732 m .59179 .65733 L .59041 .6985 L closepath p F P
0 g
s
.923 0 0 r
.5759 .65587 m .58186 .65732 L .59041 .6985 L closepath p F P
0 g
s
0 0 0 r
.59997 .65588 m .60164 .6538 L .59041 .6985 L closepath p F P
0 g
s
0 0 0 r
.006 w
.5922 .75009 m
.59269 .76298 L
s
.5 Mabswid
.57743 .65379 m .5759 .65587 L .59041 .6985 L closepath p F P
0 g
s
0 0 0 r
.006 w
.5789 .39647 m
.58806 .63997 L
s
.5 Mabswid
.941 0 0 r
.60164 .6538 m .59571 .65232 L .59041 .6985 L closepath p F P
0 g
s
.495 0 0 r
.58565 .65231 m .57743 .65379 L .59041 .6985 L closepath p F P
0 g
s
.736 0 0 r
.59571 .65232 m .58565 .65231 L .59041 .6985 L closepath p F P
0 g
s
0 0 0 r
.006 w
.58806 .63997 m
.5922 .75009 L
s
1 0 0 r
.01 w
.58145 .46427 m
.58865 .65231 L
s
.5 Mabswid
0 0 .762 r
.46848 .37256 m .46188 .38301 L .44871 .36326 L closepath p F P
0 g
s
0 0 .956 r
.47924 .36859 m .46848 .37256 L .44871 .36326 L closepath p F P
0 g
s
0 0 .135 r
.46188 .38301 m .46326 .3939 L .44871 .36326 L closepath p F P
0 g
s
0 0 0 r
.48791 .37345 m .47924 .36859 L .44871 .36326 L closepath p F P
0 g
s
0 0 .837 r
.46326 .3939 m .47186 .39887 L .44871 .36326 L closepath p F P
0 g
s
0 0 .456 r
.48938 .38438 m .48791 .37345 L .44871 .36326 L closepath p F P
0 g
s
0 0 .946 r
.47186 .39887 m .48271 .39494 L .44871 .36326 L closepath p F P
0 g
s
0 0 .787 r
.48271 .39494 m .48938 .38438 L .44871 .36326 L closepath p F P
0 g
s
0 0 1 r
.01 w
.48519 .39102 m
.58145 .46427 L
s
0 g
gsave
.51141 .41485 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.59505 .58549 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.44874 .48626 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
0 .553 0 r
.33837 .47471 m .33793 .48573 L .28762 .47878 L closepath p F P
0 g
s
0 .712 0 r
.33598 .46564 m .33837 .47471 L .28762 .47878 L closepath p F P
0 g
s
0 .336 0 r
.33793 .48573 m .33491 .49238 L .28762 .47878 L closepath p F P
0 g
s
0 .461 0 r
.33491 .49238 m .33103 .49072 L .28762 .47878 L closepath p F P
0 g
s
0 .904 0 r
.33212 .4638 m .33598 .46564 L .28762 .47878 L closepath p F P
0 g
s
0 .024 0 r
.32904 .4704 m .33212 .4638 L .28762 .47878 L closepath p F P
0 g
s
0 .408 0 r
.32858 .4816 m .32904 .4704 L .28762 .47878 L closepath p F P
0 g
s
0 .576 0 r
.33103 .49072 m .32858 .4816 L .28762 .47878 L closepath p F P
0 g
s
0 1 0 r
.01 w
.32872 .47819 m
.55145 .47502 L
s
0 0 0 r
.006 w
.48941 .51207 m
.82177 .31357 L
s
.29428 .31357 m
.49167 .43749 L
s
.49167 .43749 m
.61047 .51207 L
s
.5 Mabswid
.558 0 0 r
.54026 .66638 m .54941 .66612 L .53744 .70694 L closepath p F P
0 g
s
.788 0 0 r
.531 .66506 m .54026 .66638 L .53744 .70694 L closepath p F P
0 g
s
.97 0 0 r
.52697 .66294 m .531 .66506 L .53744 .70694 L closepath p F P
0 g
s
0 0 0 r
.54941 .66612 m .55315 .66444 L .53744 .70694 L closepath p F P
0 g
s
0 0 0 r
.006 w
.55817 .75951 m
.55848 .77233 L
s
.5 Mabswid
.059 0 0 r
.5306 .66123 m .52697 .66294 L .53744 .70694 L closepath p F P
0 g
s
.98 0 0 r
.55315 .66444 m .54921 .66229 L .53744 .70694 L closepath p F P
0 g
s
0 0 0 r
.006 w
.55425 .5935 m
.55817 .75951 L
s
.54985 .40743 m
.55425 .5935 L
s
.5 Mabswid
.578 0 0 r
.53984 .66096 m .5306 .66123 L .53744 .70694 L closepath p F P
0 g
s
.79 0 0 r
.54921 .66229 m .53984 .66096 L .53744 .70694 L closepath p F P
0 g
s
1 0 0 r
.01 w
.54022 .66101 m
.55145 .47502 L
s
.5 Mabswid
0 0 .724 r
.49345 .36924 m .48545 .37845 L .48724 .35763 L closepath p F P
0 g
s
0 0 .95 r
.50548 .36725 m .49345 .36924 L .48724 .35763 L closepath p F P
0 g
s
0 0 .112 r
.48545 .37845 m .48615 .38955 L .48724 .35763 L closepath p F P
0 g
s
0 0 0 r
.51457 .37367 m .50548 .36725 L .48724 .35763 L closepath p F P
0 g
s
0 0 .844 r
.48615 .38955 m .4952 .39605 L .48724 .35763 L closepath p F P
0 g
s
0 0 .396 r
.51536 .38479 m .51457 .37367 L .48724 .35763 L closepath p F P
0 g
s
0 0 .945 r
.4952 .39605 m .50732 .39408 L .48724 .35763 L closepath p F P
0 g
s
0 0 1 r
.01 w
.50719 .39411 m
.55145 .47502 L
s
.5 Mabswid
0 0 .808 r
.50732 .39408 m .51536 .38479 L .48724 .35763 L closepath p F P
0 g
s
gsave
.52241 .4177 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.55836 .59671 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.41487 .47533 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.51797 .41317 m
.52106 .77721 L
s
.4437 .50683 m
.83001 .37162 L
s
.5 Mabswid
0 .601 0 r
.29537 .44488 m .29344 .45597 L .24317 .44056 L closepath p F P
0 g
s
0 .735 0 r
.2956 .43541 m .29537 .44488 L .24317 .44056 L closepath p F P
0 g
s
0 .403 0 r
.29344 .45597 m .29091 .46233 L .24317 .44056 L closepath p F P
0 g
s
0 .852 0 r
.29398 .43308 m .2956 .43541 L .24317 .44056 L closepath p F P
0 g
s
0 .449 0 r
.29091 .46233 m .28925 .46017 L .24317 .44056 L closepath p F P
0 g
s
0 .144 0 r
.29143 .43936 m .29398 .43308 L .24317 .44056 L closepath p F P
0 g
s
0 .463 0 r
.28946 .45064 m .29143 .43936 L .24317 .44056 L closepath p F P
0 g
s
0 .588 0 r
.28925 .46017 m .28946 .45064 L .24317 .44056 L closepath p F P
0 g
s
0 1 0 r
.01 w
.29003 .44738 m
.51854 .48064 L
s
.5 Mabswid
.646 0 0 r
.48678 .66822 m .49644 .66925 L .48268 .70826 L closepath p F P
0 g
s
.858 0 0 r
.47862 .66572 m .48678 .66822 L .48268 .70826 L closepath p F P
0 g
s
.216 0 0 r
.49644 .66925 m .50203 .66821 L .48268 .70826 L closepath p F P
0 g
s
.918 0 0 r
.4767 .66319 m .47862 .66572 L .48268 .70826 L closepath p F P
0 g
s
.955 0 0 r
.50203 .66821 m .50024 .66568 L .48268 .70826 L closepath p F P
0 g
s
.278 0 0 r
.48224 .66211 m .4767 .66319 L .48268 .70826 L closepath p F P
0 g
s
.841 0 0 r
.50024 .66568 m .49202 .66314 L .48268 .70826 L closepath p F P
0 g
s
.647 0 0 r
.49202 .66314 m .48224 .66211 L .48268 .70826 L closepath p F P
0 g
s
1 0 0 r
.01 w
.48982 .66291 m
.51854 .48064 L
s
.5 Mabswid
0 0 .656 r
.5401 .37842 m .5313 .37047 L .52682 .35887 L closepath p F P
0 g
s
0 0 .947 r
.5313 .37047 m .51892 .37032 L .52682 .35887 L closepath p F P
0 g
s
0 0 0 r
.006 w
.43115 .38694 m
.56022 .52533 L
s
.33049 .27902 m
.43115 .38694 L
s
.5 Mabswid
0 0 .613 r
.51892 .37032 m .51013 .37807 L .52682 .35887 L closepath p F P
0 g
s
0 0 .265 r
.54015 .38958 m .5401 .37842 L .52682 .35887 L closepath p F P
0 g
s
0 0 .319 r
.51013 .37807 m .5101 .38922 L .52682 .35887 L closepath p F P
0 g
s
0 0 .83 r
.53137 .3974 m .54015 .38958 L .52682 .35887 L closepath p F P
0 g
s
0 0 .827 r
.5101 .38922 m .5189 .39725 L .52682 .35887 L closepath p F P
0 g
s
0 0 .945 r
.5189 .39725 m .53137 .3974 L .52682 .35887 L closepath p F P
0 g
s
0 0 1 r
.01 w
.51854 .48064 m
.5242 .39732 L
s
0 g
gsave
.5318 .42226 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.51852 .60228 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.3858 .45918 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 1 0 1 [
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
0 0 0 r
.006 w
[ ] 0 setdash
.50703 .53051 m
.38108 .25187 L
s
.48508 .41343 m
.48251 .77743 L
s
.40091 .49458 m
.8156 .42675 L
s
.5 Mabswid
0 .654 0 r
.26358 .408 m .26014 .41897 L .21287 .39478 L closepath p F P
0 g
s
0 .76 0 r
.26663 .39855 m .26358 .408 L .21287 .39478 L closepath p F P
0 g
s
0 .464 0 r
.26014 .41897 m .2583 .42514 L .21287 .39478 L closepath p F P
0 g
s
0 .79 0 r
.26752 .39608 m .26663 .39855 L .21287 .39478 L closepath p F P
0 g
s
0 .454 0 r
.2583 .42514 m .25914 .42285 L .21287 .39478 L closepath p F P
0 g
s
0 .236 0 r
.2657 .40217 m .26752 .39608 L .21287 .39478 L closepath p F P
0 g
s
0 .515 0 r
.26221 .41331 m .2657 .40217 L .21287 .39478 L closepath p F P
0 g
s
0 1 0 r
.01 w
.26304 .41068 m
.4846 .48089 L
s
.5 Mabswid
0 .605 0 r
.25914 .42285 m .26221 .41331 L .21287 .39478 L closepath p F P
0 g
s
.723 0 0 r
.43394 .66281 m .44365 .66516 L .42874 .70243 L closepath p F P
0 g
s
.925 0 0 r
.42729 .65928 m .43394 .66281 L .42874 .70243 L closepath p F P
0 g
s
.399 0 0 r
.44365 .66516 m .45082 .66499 L .42874 .70243 L closepath p F P
0 g
s
0 0 0 r
.42759 .65661 m .42729 .65928 L .42874 .70243 L closepath p F P
0 g
s
.774 0 0 r
.45082 .66499 m .45125 .66236 L .42874 .70243 L closepath p F P
0 g
s
.427 0 0 r
.43476 .6564 m .42759 .65661 L .42874 .70243 L closepath p F P
0 g
s
.889 0 0 r
.45125 .66236 m .4446 .65879 L .42874 .70243 L closepath p F P
0 g
s
.709 0 0 r
.4446 .65879 m .43476 .6564 L .42874 .70243 L closepath p F P
0 g
s
1 0 0 r
.01 w
.44002 .65768 m
.4846 .48089 L
s
.5 Mabswid
0 0 .745 r
.56253 .3873 m .5547 .37796 L .56418 .36686 L closepath p F P
0 g
s
0 0 .951 r
.5547 .37796 m .54292 .37571 L .56418 .36686 L closepath p F P
0 g
s
0 0 0 r
.56185 .39833 m .56253 .3873 L .56418 .36686 L closepath p F P
0 g
s
0 0 0 r
.54292 .37571 m .53404 .3819 L .56418 .36686 L closepath p F P
0 g
s
0 0 .842 r
.55301 .4046 m .56185 .39833 L .56418 .36686 L closepath p F P
0 g
s
0 0 .424 r
.53404 .3819 m .53328 .39295 L .56418 .36686 L closepath p F P
0 g
s
0 0 .945 r
.54115 .40238 m .55301 .4046 L .56418 .36686 L closepath p F P
0 g
s
0 0 .804 r
.53328 .39295 m .54115 .40238 L .56418 .36686 L closepath p F P
0 g
s
0 0 1 r
.01 w
.4846 .48089 m
.54019 .40124 L
s
0 g
gsave
.53892 .42819 -66 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.4777 .60201 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.36344 .43857 -66.0313 -10.4375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
69.063 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCacheValid->False]
}, Closed]]
}, Open  ]],

Cell[TextData[{
  "El producto ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x . \((y\[Times]z)\)\),
          FontWeight->"Bold"], TraditionalForm]]],
  " se llama ",
  StyleBox["triple producto escalar",
    FontWeight->"Bold"],
  " de los vectores ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x, y, z\),
          FontWeight->"Bold"], TraditionalForm]]],
  ". El volumen del paralelep\[IAcute]pedo determinado por los vectores ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(x, y, z\),
          FontWeight->"Bold"], TraditionalForm]]],
  " es igual a ",
  Cell[BoxData[
      FormBox[
        StyleBox[\( | x . \((y\[Times]z)\) | \),
          FontWeight->"Bold"], TraditionalForm]]],
  ". Podemos comprobarlo gr\[AAcute]ficamente."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(u = 1.5 {0.6, \(-0.3\), 1.2};\)\), "\n", 
    \(\(v = {1.5, 0.0, 0.0};\)\), "\n", 
    \(\(w = 1.5 {0.3, 1.2, 0.0};\)\), "\n", 
    \(\(vxw = Cross[v, w];\)\), "\n", 
    \(\[CapitalPi] = \((u . \((vxw)\)/vxw . vxw)\) vxw; \  (*\ 
      proyecci\[OAcute]n\ ortogonal\ de\ u\ sobre\ vxw\ *) \n
    Show[Graphics3D[{vector3D[u, Red,  .01], 
          Text["\<u\>", u/2 + {\(- .12\), 0, 0}], vector3D[v, Red,  .01], 
          Text["\<v\>", v/2 + {0,  .15, 0}], vector3D[w, Red,  .01], 
          Text["\<w\>", w/2 + {0, 0,  .15}], vector3D[vxw, Green,  .01], 
          Text["\<v\[Times]w\>",  .9  vxw + {\(- .3\), 0, 0}], 
          vector3D[\[CapitalPi], Blue,  .01], Line[{u, u + w, w}], 
          Text["\<\[CapitalPi]\>", \[CapitalPi]/2 + {\(- .2\), 0, 0}], 
          Line[{u, u + v, v}], Line[{w, v + w, v}], 
          Line[{v + w, u + v + w, u + v}], Line[{u + v + w, u + w}], 
          Line[{u, \[CapitalPi]}]}, Boxed -> False, PlotRange \[Rule] All, 
        TextStyle -> {FontFamily -> "\<Times\>", \ 
            FontSize -> 11}]];\), "\n", 
    \(Print["\<El volumen del paralelogramo determinado por los vectores u, v \
y w\nes igual al producto del \[AAcute]rea de la base por la altura.\nEl \
\[AAcute]rea de la base es igual a ||v\[Times]w||\nLa altura es igual a la \
norma del vector \[CapitalPi] que es\nla proyecci\[OAcute]n ortogonal del \
vector u sobre el vector v\[Times]w\n||\[CapitalPi]||=|u.(v\[Times]w)|/||v\
\[Times]w||\nPor tanto el volumen del paralelep\[IAcute]pedo es igual a |u.(v\
\[Times]w)|\>"]\ \), "\n", 
    \(Clear[u, v, w, vxw, \[CapitalPi]]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.03863 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0375237 1.09564 6.77626e-017 1.09564 [
[ 0 0 0 0 ]
[ 1 1.03863 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.03863 L
0 1.03863 L
closepath
clip
newpath
.5 Mabswid
[ ] 0 setdash
.719 0 0 r
.41965 .46935 m .4298 .45899 L .4746 .50405 L closepath p F P
0 g
s
.797 0 0 r
.41521 .48276 m .41965 .46935 L .4746 .50405 L closepath p F P
0 g
s
.799 0 0 r
.41907 .49146 m .41521 .48276 L .4746 .50405 L closepath p F P
0 g
s
.364 0 0 r
.42905 .4903 m .41907 .49146 L .4746 .50405 L closepath p F P
0 g
s
.796 0 0 r
.43932 .47986 m .42905 .4903 L .4746 .50405 L closepath p F P
0 g
s
.494 0 0 r
.4298 .45899 m .43978 .45769 L .4746 .50405 L closepath p F P
0 g
s
.912 0 0 r
.44377 .46631 m .43932 .47986 L .4746 .50405 L closepath p F P
0 g
s
.83 0 0 r
.43978 .45769 m .44377 .46631 L .4746 .50405 L closepath p F P
0 g
s
.4746 .50405 m
.59873 .71399 L
s
.4746 .50405 m
.74181 .41596 L
s
1 0 0 r
.01 w
.20466 .3279 m
.43862 .48057 L
s
0 g
.5 Mabswid
.74181 .41596 m
.91543 .623 L
s
.574 0 0 r
.43824 .2405 m .43205 .229 L .48409 .22238 L closepath p F P
0 g
s
.504 0 0 r
.44062 .25295 m .43824 .2405 L .48409 .22238 L closepath p F P
0 g
s
.052 0 0 r
.43781 .25915 m .44062 .25295 L .48409 .22238 L closepath p F P
0 g
s
.471 0 0 r
.43205 .229 m .42563 .22513 L .48409 .22238 L closepath p F P
0 g
s
.769 0 0 r
.4314 .25541 m .43781 .25915 L .48409 .22238 L closepath p F P
0 g
s
.523 0 0 r
.42563 .22513 m .42274 .23125 L .48409 .22238 L closepath p F P
0 g
s
.713 0 0 r
.42513 .24383 m .4314 .25541 L .48409 .22238 L closepath p F P
0 g
s
1 0 0 r
.01 w
.20466 .3279 m
.4255 .2445 L
s
.5 Mabswid
.662 0 0 r
.42274 .23125 m .42513 .24383 L .48409 .22238 L closepath p F P
0 g
s
.48409 .22238 m
.74181 .41596 L
s
.48409 .22238 m
.63146 .41845 L
s
.91543 .623 m
.59873 .71399 L
s
0 0 .414 r
.17656 .59621 m .19325 .5952 L .17488 .64557 L closepath p F P
0 g
s
0 0 .405 r
.16221 .59004 m .17656 .59621 L .17488 .64557 L closepath p F P
0 g
s
0 0 .15 r
.19325 .5952 m .20266 .58758 L .17488 .64557 L closepath p F P
0 g
s
0 0 0 r
.15857 .5802 m .16221 .59004 L .17488 .64557 L closepath p F P
0 g
s
0 0 .619 r
.20266 .58758 m .19923 .57772 L .17488 .64557 L closepath p F P
0 g
s
0 0 .602 r
.16791 .57246 m .15857 .5802 L .17488 .64557 L closepath p F P
0 g
s
0 0 .633 r
.19923 .57772 m .18481 .57142 L .17488 .64557 L closepath p F P
0 g
s
0 0 .622 r
.18481 .57142 m .16791 .57246 L .17488 .64557 L closepath p F P
0 g
s
0 1 0 r
.01 w
.18181 .5716 m
.20466 .3279 L
s
.5 Mabswid
0 .321 0 r
.16095 .74524 m .18691 .7438 L .1577 .82881 L closepath p F P
0 g
s
0 .508 0 r
.13851 .73641 m .16095 .74524 L .1577 .82881 L closepath p F P
0 g
s
.91543 .623 m
.63146 .41845 L
s
0 0 0 r
.18691 .7438 m .20154 .73288 L .1577 .82881 L closepath p F P
0 g
s
0 .533 0 r
.13261 .72227 m .13851 .73641 L .1577 .82881 L closepath p F P
0 g
s
0 .871 0 r
.20154 .73288 m .19617 .71868 L .1577 .82881 L closepath p F P
0 g
s
0 .261 0 r
.14708 .71107 m .13261 .72227 L .1577 .82881 L closepath p F P
0 g
s
.34 0 0 r
.27165 .51303 m .29153 .50836 L .29663 .53074 L closepath p F P
0 g
s
0 0 0 r
.29153 .50836 m .30344 .49258 L .29663 .53074 L closepath p F P
0 g
s
0 .64 0 r
.19617 .71868 m .17356 .70957 L .1577 .82881 L closepath p F P
0 g
s
.424 0 0 r
.25529 .50384 m .27165 .51303 L .29663 .53074 L closepath p F P
0 g
s
.91 0 0 r
.30344 .49258 m .30043 .4748 L .29663 .53074 L closepath p F P
0 g
s
0 .487 0 r
.17356 .70957 m .14708 .71107 L .1577 .82881 L closepath p F P
0 g
s
0 1 0 r
.01 w
.16885 .70983 m
.17488 .64557 L
s
.5 Mabswid
.103 0 0 r
.25207 .48604 m .25529 .50384 L .29663 .53074 L closepath p F P
0 g
s
.871 0 0 r
.30043 .4748 m .28411 .46542 L .29663 .53074 L closepath p F P
0 g
s
.451 0 0 r
.26402 .47007 m .25207 .48604 L .29663 .53074 L closepath p F P
0 g
s
.666 0 0 r
.28411 .46542 m .26402 .47007 L .29663 .53074 L closepath p F P
0 g
s
1 0 0 r
.01 w
.20466 .3279 m
.26864 .469 L
s
0 g
.5 Mabswid
.29663 .53074 m
.59873 .71399 L
s
.17488 .64557 m
.29663 .53074 L
s
.29663 .53074 m
.63146 .41845 L
s
gsave
.22406 .42967 -65.7813 -11.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(u) show
68.563 15.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.3579 .29573 -65.6563 -11.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
68.313 15.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.3444 .44373 -66.875 -11.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
70.750 15.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.10369 .78968 -73.1563 -11.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 15.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.125 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v) show
68.313 15.125 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(\\264) show
75.563 15.125 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w) show
83.313 15.125 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.15369 .49226 -67 -11.375 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 22.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 15.125 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.125 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(P) show
71.000 15.125 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 11.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{277.25, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006O0001[b000`400?l00000o`00003oo`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP0?ooo`00o`3ooonP
0?ooo`00o`3ooonP0?ooo`00_@3oool<00000=H0oooo002`0?ooo`d000000P250009000000030?oo
o`00000000000=@0oooo002`0?ooo`03000000250000Q@0000H0Q@001P0000030:T000D000000`3o
ool200000=<0oooo002_0?ooo`04000000250000Q@0008D000H000001P2Y0003000000030;H00000
0000000000D0oooo00<000000?ooo`000000dP3oool00:l0oooo1000000:0:T0008000000P2f0003
000000L0oooo00@000000?ooo`0000000000d03oool00:l0oooo00<000000:T0002Y0000202Y0003
000000<0]P0000<000000<@0000000002@3oool010000000oooo0?ooo`00003?0?ooo`00[`3oool0
0`000000Z@000:T000050:T000<00000102f0004000000/0oooo00@000000?ooo`3oool00000cP3o
ool00;00oooo00<000000:T0002Y00000P2Y0002000000H0]P0000<000000<@0000000003@3oool0
10000000oooo0?ooo`3oool200000<`0oooo002]0?ooo`<0o`0000<000000:T0000000000P000006
0;H00080000000<0a0000000003oool03P3oool00`000000oooo0?ooo`020?ooo`030000003oool0
oooo0<T0oooo002[0?ooo`D0o`000P0000000`3o0000]P000;H000050;H000040000003400000000
00000140oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`380?ooo`00Z03oool;0?l0
00D0]P000P0000000`34000000000?ooo`0C0?ooo`030000003oool0oooo0080oooo0P0000380?oo
o`00YP3oool;0?l000030000002f0000]P000080]P000P0000020<@000030000003oool0oooo01<0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`350?ooo`00X`3oool;0?l000<0oooo
00D000000;H0002f0000]P00000000030<@000030000003oool0oooo01D0oooo00<000000?ooo`3o
ool0103oool00`000000oooo0?ooo`340?ooo`00X03oool<0?l000H0oooo0`0000020<@000800000
6@3oool00`000000oooo0?ooo`040?ooo`800000a03oool009h0oooo2`3o00090?ooo`8000000P34
00000`000000oooo0?ooo`0J0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0`@3o
ool009/0oooo303o000=0?ooo`8000007@3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo0<00oooo002H0?ooo``0o`00<03oool00`000000oooo0?ooo`060?ooo`800000`03oool009H0
oooo2`3o000d0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0_@3oool009<0oooo
303o000g0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0_03oool00900oooo303o
000j0?ooo`030000003oool0oooo00P0oooo0P00002l0?ooo`00SP3oool;0?l003h0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`2i0?ooo`00R`3oool<0?l00440oooo00<000000?oo
o`3oool02@3oool00`000000oooo0?ooo`2h0?ooo`00R@3oool;0?l004D0oooo00<000000?ooo`3o
ool02@3oool200000;P0oooo00260?ooo`/0o`00B03oool00`000000oooo0?ooo`0;0?ooo`030000
003oool0oooo0;D0oooo00230?ooo``0o`00B`3oool00`000000oooo0?ooo`0;0?ooo`030000003o
ool0oooo0;@0oooo00210?ooo`/0o`00C`3oool00`000000oooo0?ooo`0;0?ooo`800000]03oool0
07h0oooo303o00080?ooo`030?oojP2jLY/0e?oo04L0oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`2a0?ooo`00N`3oool<0?l000/0oooo00<0omBK0000002Ke?l0A`3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo0;00oooo001i0?ooo`/0o`003@3oool01@3oonX0^W80
002K^P2jVkX0j_oo04L0oooo00<000000?ooo`3oool03@3oool200000;00oooo001f0?ooo``0o`00
3`3oool01@3oe9/0000009_Do`3Z^W80VmCo04P0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`2]0?ooo`00M03oool;0?l00180oooo00D0e9/0001b^P3Zool0oooD09^Ke0190?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool0[03oool00740oooo2`3o000D0?ooo`030?oZ
^P1b0000VmCo0080oooo00<0j[ZK0;[Zo`3oool0A`3oool00`000000oooo0?ooo`0?0?ooo`800000
[03oool006h0oooo303o000F0?ooo`030=BK000009/0e?oo0080oooo00<0onZj07:Ke03oool0B03o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0:T0oooo001/0?ooo`/0o`00603oool0
2@3DV`00000000000000L[X0j_oo0?ooe02K0000000007:jjP190?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0Z03oool006T0oooo303o001]0?ooo`030000003oool0oooo0100oooo
0P00002X0?ooo`00IP3oool<0?l00700oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`2U0?ooo`00I03oool;0?l007@0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`2T
0?ooo`00H@3oool<0?l007L0oooo00<000000?ooo`3oool04P3oool200000:@0oooo001N0?ooo``0
o`00N`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0:40oooo001L0?ooo`/0o`00
OP3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0:00oooo001I0?ooo``0o`00P@3o
ool00`000000oooo0?ooo`0D0?ooo`800000X03oool005L0oooo2`3o00250?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool0W@3oool005<0oooo303o00290?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool0W03oool00580oooo103o00000`00o`00o`000?l000040?l008/0
oooo00<000000?ooo`3oool05P3oool2000009`0oooo001B0?ooo`P0o`00S`3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo09T0oooo001B0?ooo`L0o`00T@3oool00`000000oooo0?oo
o`0G0?ooo`030000003oool0oooo09P0oooo001B0?ooo`03003o003o0000o`0000H0o`00T03oool0
0`000000oooo0?ooo`0G0?ooo`800000V03oool00580oooo00<00?l00?l0003o00001`3o002?0?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool0U@3oool00580oooo0P00o`0:0?l008h0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`2D0?ooo`00DP3oool2003o00/0o`00
SP3oool00`000000oooo0?ooo`0I0?ooo`800000U03oool00580oooo0`00o`0<0?l008d0oooo00<0
00000?ooo`3oool06P3oool00`000000oooo0?ooo`2A0?ooo`00DP3oool3003o00D0o`000P3oool7
0?l008/0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`2@0?ooo`00DP3oool4003o
00D0o`000P3oool70?l008/0oooo00<000000?ooo`3oool06`3oool200000900oooo001B0?ooo`@0
0?l01@3o00040?ooo`L0o`00RP3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo08d0
oooo001B0?ooo`@00?l000<0oooo0?l0003o00000`3o00050?ooo`H0o`00RP3oool00`000000oooo
0?ooo`0L0?ooo`030000003oool0oooo08`0oooo001B0?ooo`@00?l000<0oooo0?l0003o00000`3o
00060?ooo`L0o`00R03oool00`000000oooo0?ooo`0M0?ooo`800000S03oool00540oooo1000o`03
0?ooo`D0o`001`3oool60?l008P0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`29
0?ooo`00D@3oool4003o00<0oooo1@3o00080?ooo`L0o`00Q`3oool00`000000oooo0?ooo`0N0?oo
o`030000003oool0oooo08P0oooo001A0?ooo`@00?l0103oool40?l000X0oooo1P3o00270?ooo`03
0000003oool0oooo01h0oooo0P0000280?ooo`00D@3oool4003o00@0oooo1@3o000:0?ooo`L0o`00
Q@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo08D0oooo001A0?ooo`@00?l0103o
ool50?l000`0oooo1P3o00250?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0Q03o
ool00540oooo1000o`050?ooo`D0o`00303oool70?l008@0oooo00<000000?ooo`3oool0803oool2
000008@0oooo001A0?ooo`@00?l01@3oool50?l000h0oooo1`3o00230?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool0P@3oool00540oooo1000o`060?ooo`D0o`003P3oool70?l00880
oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`200?ooo`00D@3oool4003o00H0oooo
1@3o000@0?ooo`L0o`00P@3oool00`000000oooo0?ooo`0R0?ooo`800000P03oool00540oooo1000
o`070?ooo`D0o`004@3oool60?l00840oooo00<000000?ooo`3oool08`3oool00`000000oooo0?oo
o`1m0?ooo`00D@3oool4003o00L0oooo1@3o000B0?ooo`L0o`00P03oool00`000000oooo0?ooo`0S
0?ooo`030000003oool0oooo07`0oooo001@0?ooo`@00?l02@3oool50?l001<0oooo1P3o001o0?oo
o`030000003oool0oooo02@0oooo0P00001l0?ooo`00D03oool4003o00T0oooo1@3o000D0?ooo`L0
o`00OP3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo07T0oooo001@0?ooo`@00?l0
2P3oool50?l001D0oooo1P3o001n0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
N03oool00500oooo1000o`0:0?ooo`D0o`005P3oool70?l007d0oooo00<000000?ooo`3oool09@3o
ool2000007P0oooo001@0?ooo`@00?l02`3oool50?l001L0oooo1P3o001l0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool0M@3oool00500oooo1000o`0;0?ooo`D0o`00603oool70?l0
07/0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`1d0?ooo`00D03oool4003o00`0
oooo103o000J0?ooo`H0o`00N`3oool00`000000oooo0?ooo`0W0?ooo`800000M03oool00500oooo
1000o`0<0?ooo`D0o`006P3oool70?l007X0oooo00<000000?ooo`3oool0:03oool00`000000oooo
0?ooo`1a0?ooo`00D03oool4003o00`0oooo1@3o000L0?ooo`L0o`00N03oool00`000000oooo0?oo
o`0Y0?ooo`030000003oool0oooo0700oooo001@0?ooo`@00?l03@3oool50?l001`0oooo1`3o001h
0?ooo`030000003oool0oooo02T0oooo0P00001`0?ooo`00D03oool4003o00d0oooo1@3o000N0?oo
o`L0o`00M`3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo06d0oooo001?0?ooo`@0
0?l03`3oool50?l001l0oooo1P3o001g0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3o
ool0K03oool004l0oooo1000o`0?0?ooo`D0o`00803oool70?l007D0oooo00<000000?ooo`3oool0
:`3oool2000006`0oooo001?0?ooo`@00?l0403oool50?l00240oooo1P3o001e0?ooo`030000003o
ool0oooo02/0oooo0P00001[0?ooo`00C`3oool4003o00H0oooo00L0onZj07800000000007:j0=Bj
LP0009/0e?oo00<0oooo1@3o000R0?ooo`L0o`00L`3oool2000002T0oooo0`0000020?ooo`030000
003oool0oooo06P0oooo001?0?ooo`@00?l01P3oool0203DV`0007:j0>[oo`3oj[X0LP0000000000
09/0e?oo0`3oool50?l002<0oooo1P3o001_0?ooo`<000000P3oool2000002@0oooo0`0000060?oo
o`030000003oool0oooo06L0oooo001?0?ooo`@00?l01P3oool01`3DV`0009_D0?ooo`3oool0j[Yb
001b^P3Zool0103oool50?l002@0oooo1`3o001Z0?ooo`<000001`3oool00`000000oooo0?ooo`0N
0?ooo`<000002P3oool00`000000oooo0?ooo`1V0?ooo`00C`3oool4003o00D0oooo00<0oooZ0;Yb
0000Vm@00P3oool00`3Z^W8007:j0>[oo`050?ooo`D0o`009@3oool60?l006H0oooo0`00000;0?oo
o`030000003oool0oooo01X0oooo0`00000=0?ooo`030000003oool0oooo06H0oooo001?0?ooo`@0
0?l01@3oool00`3oonX0^W80002Ke0020?ooo`030>ZjLP00L[X0j_oo00D0oooo1@3o000V0?ooo`L0
o`00H@3oool3000000l0oooo0P00000G0?ooo`<000004@3oool00`000000oooo0?ooo`1U0?ooo`00
C`3oool4003o00D0oooo00<0oooZ0;Yb0000Vm@00P3oool00`3Z^W8007:j0>[oo`060?ooo`D0o`00
9`3oool60?l005d0oooo0`00000D0?ooo`030000003oool0oooo0140oooo0`00000E0?ooo`030000
003oool0oooo06@0oooo001?0?ooo`@00?l01@3oool00`3oonX0^W80002Ke0020?ooo`030>ZjLP00
L[X0j_oo00H0oooo1@3o000P0?ooo`080?oojP2jVkX0j_oo0?ooo`3oonX0^Y^j0>[oo`3oool70?l0
05P0oooo0`00000H0?ooo`8000003P3oool3000001T0oooo00<000000?ooo`3oool0H`3oool004l0
oooo1000o`040?ooo`090?ooe02K00000000002Ke03oool0e9/000000000L[X0j_oo00L0oooo103o
000P0?ooo`070?oZ^P1b0000VmCo0?ooo`3oj[X0LP0009_Do`030?ooo`L0o`00D`3oool3000001d0
oooo00<000000?ooo`3oool0203oool3000001d0oooo00<000000?ooo`3oool0HP3oool004h0oooo
1000o`0E0?ooo`D0o`007`3oool01`3Z^W8007:K09^je03oool0j[Yb001bLP1bVm@0103oool70?l0
0500oooo0P00000Q0?ooo`030000003oool0oooo00@0oooo0`00000Q0?ooo`030000003oool0oooo
0640oooo001>0?ooo`@00?l05@3oool50?l001h0oooo00T0oooZ0;Yb002Ke?l0j[ZK0;[ZjP2jLP00
VmCo0=BKV`3Dool01@3oool70?l004/0oooo0`00000T0?ooo`80000000@0oooo0000000000000000
903oool00`000000oooo0?ooo`1Q0?ooo`00CP3oool4003o01H0oooo1@3o000M0?ooo`090?oDV`00
09/0e?oo0?ooe02jVi/0LP2K0=Coo`3oj[X0^]Co00L0oooo1P3o00170?ooo`<000009`3oool30000
02P0oooo00<000000?ooo`3oool0H03oool004h0oooo1000o`0F0?ooo`D0o`007@3oool02P3DV`00
09_D0?ooo`3oool0e9/0002Ke03oool0oooZ0;ZK^P3Zool70?ooo`L0o`00@P3oool3000002L0oooo
0`0000030?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0G`3oool004h0oooo1000
o`0G0?ooo`D0o`006`3oool01`3oom@0V`0009_Do`3oool0oooD09/0002Ke?l00P3oool00`3Z^Y/0
^^[o0?ooo`080?ooo`H0o`00?P3oool3000002L0oooo0`0000070?ooo`8000009`3oool00`000000
oooo0?ooo`1N0?ooo`00CP3oool4003o01L0oooo1@3o000J0?ooo`0=0?oojP2jLP0000000000V`3D
om@0V`00000000000780^^[o0?oZ^P1b0000002K0=Coo`090?ooo`L0o`00>@3oool3000002L0oooo
0`00000<0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0G@3oool004h0oooo1000
o`0H0?ooo`D0o`00<@3oool60?l003D0oooo0`00000W0?ooo`<00000403oool2000002H0oooo00<0
00000?ooo`3oool0G03oool004h0oooo1000o`0H0?ooo`D0o`00<P3oool70?l00300oooo0`00000W
0?ooo`<000005@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo05`0oooo001>0?oo
o`@00?l06@3oool50?l003<0oooo1P3o000<0?ooo`8000007P3oool3000002L0oooo0`00000I0?oo
o`030000003oool0oooo02<0oooo00<000000?ooo`3oool0F`3oool004h0oooo1000o`0I0?ooo`D0
o`00=03oool70?l000L0oooo0`0000000`1n000000000000000J0?ooo`<000009`3oool3000001d0
oooo0P00000T0?ooo`030000003oool0oooo05X0oooo001>0?ooo`@00?l06P3oool50?l003D0oooo
1`3o00040?ooo`030000002h0000000000<0OP0000<000000?ooo`3oool05@3oool3000002L0oooo
0`00000R0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0F@3oool004h0oooo1000
o`0J0?ooo`D0o`00=P3oool70?l00080oooo00D000000;P0002h0000^0000000000207h000800000
4`3oool3000002L0oooo0`00000V0?ooo`8000008`3oool00`000000oooo0?ooo`1H0?ooo`00C@3o
ool4003o01`0oooo1@3o00020?ooo`800000<`3oool70?l000D0^00000<0000007h0001n00000P00
000?0?ooo`<000009`3oool3000002/0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?oo
o`1G0?ooo`00C@3oool4003o01`0oooo1@3o0002000000040:X0000000000000000003<0oooo1P3o
00050;P000040000001n00000000000000`0oooo0`00000W0?ooo`<00000;`3oool00`000000oooo
0?ooo`0P0?ooo`030000003oool0oooo05L0oooo001=0?ooo`@00?l0703oool00`000000o`000?l0
00020?l000<0ZP0000<000000=h0003N00000P00000b0?ooo`L0o`00102h000010000000j@000000
000000080?ooo`<000009`3oool3000003<0oooo0P00000Q0?ooo`030000003oool0oooo05H0oooo
001=0?ooo`@00?l06`3oool010000000L`000?l0003o00060:X000040000003N0000gP000=h00080
0000<@3oool00`000000o`000?l000040?l000<0^00000<000000>T0003Y00000P0000050?ooo`80
00009`3oool3000003P0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`1E0?ooo`00
C@3oool4003o01X0oooo00@0000007<0001c000000001`2Z00000`000000gP000=h000030=h00003
0000003oool0oooo02h0oooo00<000000<`0003o00001P3o00000`2h000000000>T000020>T00080
000000@0oooo00000000000000009P3oool3000003`0oooo0P00000P0?ooo`030000003oool0oooo
05@0oooo001=0?ooo`@00?l06@3oool00`000000L`0007<0000207<000030000002Z0000ZP0000@0
ZP0000<000000=h0003N00000`3N00000`000000oooo0?ooo`0^0?ooo`040000003<0000c0000<`0
00H0o`00103Y0003000002H0oooo0`0000110?ooo`030000003oool0oooo01h0oooo00<000000?oo
o`3oool0D`3oool003T0oooo00P0e9/000000000000000000000V`3Dool0oooD09/000<0000000<0
09_D0?ooo`3oool01P3oool4003o01T0oooo00<0000007<0001c00000P1c00000`000000ZP000:X0
00040:X000030000003N0000gP0000<0gP0000<000000?ooo`3oool0;@3oool00`000000c0000<`0
00030<`000H0o`000`0000000`3Y000000000000000S0?ooo`<00000A@3oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo0580oooo000j0?ooo`030?oDV`00000009_D00@0oooo00<0e9/0
0000002Ke?l02@3oool4003o01P0oooo00<0000007<0001c0000101c00000`000000ZP000:X00004
0:X000030000003N0000gP000080gP0000<000000?ooo`3oool0;@3oool2000000H0c00000<0o`00
0000000000000P0000040>T0008000007`3oool3000004T0oooo0P00000N0?ooo`030000003oool0
oooo0580oooo000j0?ooo`030?oZ^P1b0000L[[Z00@0oooo00<0j[Yb0000LP2jj_l02@3oool4003o
01L0oooo00<0000007<0001c00001@1c00000`000000ZP000:X000040:X000030000003N0000gP00
0080gP000P00000^0?ooo`040000003<0000000000000080c0000`0000020?l00080b`0000<00000
0>T0003Y00000P3Y00000`000000oooo0?ooo`0J0?ooo`<00000CP3oool00`000000oooo0?ooo`0L
0?ooo`030000003oool0oooo0540oooo000j0?ooo`030?oZ^P1b0000L[[Z00@0oooo00<0j[Yb0000
LP2jj_l02@3oool4003o01L0oooo0P00000707<000030000002Z0000ZP0000<0ZP0000<000000=h0
003N00000P3N0002000002h0oooo00<000000<`0003<00001@0000060</000030000003Y0000j@00
0080j@0000<000000?ooo`3oool05P3oool300000580oooo00<000000?ooo`3oool0703oool00`00
0000oooo0?ooo`1@0?ooo`00>P3oool00`3oj[X0LP0007:jjP040?ooo`030>ZjLP000780^^[o00T0
oooo1000o`0G0?ooo`030000000J0000000000H0L`0000<000000:X0002Z00000`2Z00000`000000
gP000=h000020=h000800000;P3oool3000000030<`0000000000000008000001`3;000200000080
j@000P00000D0?ooo`<00000EP3oool2000001d0oooo00<000000?ooo`3oool0C`3oool003X0oooo
00<0onZj0780001b^^X0103oool00`3Z^W80001b0;[Zo`080?ooo`@00?l0603oool0100000006P00
01X00000000607<000030000002Z0000ZP000080ZP0000<000000=h0003N00000P3N0002000002/0
oooo0`000000103oool0000000000000000405d000<000001P3;000010000000j@000>T00000000A
0?ooo`<00000F`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo04h0oooo000j0?oo
o`030?oZ^P1b0000L[[Z00@0oooo00<0j[Yb0000LP2jj_l0203oool4003o01P0oooo00D0000001X0
000J00006P000000000607<000030000002Z0000ZP000080ZP0000@000000=h0003N0000gP000P00
000X0?ooo`<000001`3oool4000000<0G@000`0000040</00080000000<0j@000000003oool0303o
ool3000005l0oooo0P00000L0?ooo`030000003oool0oooo04d0oooo000j0?ooo`030?oZ^P1b0000
L[[Z00@0oooo00<0j[Yb0000LP2jj_l0203oool4003o01T0oooo00D0000001X0000J00006P000000
000507<000030000002Z0000ZP000080ZP0000@000000=h0003N0000gP000P00000U0?ooo`<00000
3P3oool50000000405d0000000000000000000<0b`0000<000000>T0000000002@3oool3000006@0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`1=0?ooo`00>P3oool00`3oj[X0LP00
07:jjP040?ooo`030>ZjLP000780^^[o00P0oooo1000o`0I0?ooo`030000000J00006P0000806P00
00<0000007<0001c00000`1c00001@000000ZP000:X0002Z0000000000<0gP000P00000R0?ooo`<0
00005P3oool7000000040</0000000000000000000D0oooo0`00001X0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool0C03oool003X0oooo00<0onZj0780001b^^X0103oool00`3Z^W80
001b0;[Zo`080?ooo`@00?l06@3oool00`0000006P0001X0000301X000030000001c0000L`000080
L`0000D000000:X0002Z0000ZP00000000030=h000030000003oool0oooo01h0oooo0`00000N0?oo
o`H000000P3oool3000006`0oooo0P00000J0?ooo`030000003oool0oooo04/0oooo000j0?ooo`03
0?oDV`000000L[[Z00@0oooo00<0j[Yb0000002Ke?l0203oool4003o01T0oooo00<0000001X0000J
0000100J00000`000000L`0007<0000207<000060000002Z0000ZP000:X000000000gP000P00000M
0?ooo`<000009@3oool400000740oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`1:
0?ooo`00>@3oool00`3DV`0000000000000800000003002Ke03oool0oooo00D0oooo1000o`0J0?oo
o`8000001@0J00001@000000L`0007<0001c0000000000<0ZP0000@000000=h00000000000006P3o
ool3000002/0oooo00<000000?ooo`3oool0L03oool2000001T0oooo00<000000?ooo`3oool0B@3o
ool004`0oooo1000o`0L0?ooo`800000100J00001@000000L`0007<0001c000000000080ZP0000@0
00000=h00000000000005`3oool3000002h0oooo00<000000?ooo`3oool0LP3oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo04P0oooo001<0?ooo`@00?l07P3oool00`0000006P0001X0
000201X000080000001c0000L`0007<000000000ZP000000003N0002000001D0oooo0P00000b0?oo
o`030000003oool0oooo0780oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`180?oo
o`00C03oool4003o01l0oooo0P00000301X000070000001c0000L`000000002Z000000000=h00002
00000180oooo0`00000d0?ooo`030000003oool0oooo07<0oooo0P00000G0?ooo`030000003oool0
oooo04L0oooo001<0?ooo`@00?l08@3oool01@0000006P0001X0000J000000000080L`0000<00000
0:X0000000000P00000?0?ooo`<00000>03oool00`000000oooo0?ooo`1d0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool0AP3oool004/0oooo1000o`0S0?ooo`8000000P0J00001000
0000L`000000002Z0003000000`0oooo0`00000l0?ooo`030000003oool0oooo07@0oooo00<00000
0?ooo`3oool05@3oool00`000000oooo0?ooo`150?ooo`00B`3oool4003o02D0oooo0P0000000`0J
0000000007<00003000000X0oooo0`00000o0?ooo`030000003oool0oooo07D0oooo0P00000F0?oo
o`030000003oool0oooo04@0oooo001;0?ooo`@00?l09`3oool00`0000006P0000000003000000L0
oooo0`0000130?ooo`030000003oool0oooo07H0oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`130?ooo`00B`3oool4003o02P0oooo1@0000040?ooo`<00000AP3oool00`000000oooo
0?ooo`1g0?ooo`8000005@3oool00`000000oooo0?ooo`120?ooo`00B`3oool4003o02X0oooo0`00
0000103oool0000000000000001:0?ooo`030000003oool0oooo07P0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`120?ooo`00B`3oool4003o02`0oooo0P00001>0?ooo`030000003o
ool0oooo07P0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`110?ooo`00B`3oool4
003o02/0oooo00@000000?ooo`0000000000C@3oool00`000000oooo0?ooo`1i0?ooo`8000004`3o
ool00`000000oooo0?ooo`100?ooo`00B`3oool4003o02X0oooo00<000000?ooo`3oool00P3oool2
000004`0oooo00<000000?ooo`3oool0NP3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo03l0oooo001;0?ooo`@00?l0:@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
04T0oooo00<000000?ooo`3oool0N`3oool200000180oooo00<000000?ooo`3oool0?P3oool004/0
oooo1000o`0X0?ooo`030000003oool0oooo00L0oooo0P00001:0?ooo`030000003oool0oooo07`0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0m0?ooo`00B`3oool4003o02L0oooo
00<000000?ooo`3oool02P3oool2000004T0oooo00<000000?ooo`3oool0O03oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo03d0oooo001:0?ooo`@00?l09P3oool2000000l0oooo00<0
00000?ooo`3oool0AP3oool00`000000oooo0?ooo`1m0?ooo`800000403oool00`000000oooo0?oo
o`0l0?ooo`00BP3oool4003o02D0oooo00<000000?ooo`3oool0403oool2000004L0oooo00<00000
0?ooo`3oool0OP3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo03/0oooo001:0?oo
o`@00?l0903oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo04@0oooo00<000000?oo
o`3oool0O`3oool2000000l0oooo00<000000?ooo`3oool0>P3oool004X0oooo1000o`0S0?ooo`03
0000003oool0oooo01D0oooo0P0000150?ooo`030000003oool0oooo0800oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0i0?ooo`00BP3oool4003o0280oooo00<000000?ooo`3oool0
603oool2000004@0oooo00<000000?ooo`3oool0P03oool00`000000oooo0?ooo`0=0?ooo`030000
003oool0oooo03P0oooo001:0?ooo`@00?l08@3oool00`000000oooo0?ooo`0K0?ooo`030000003o
ool0oooo0440oooo00<000000?ooo`3oool0P@3oool2000000d0oooo00<000000?ooo`3oool0>03o
ool004X0oooo1000o`0P0?ooo`030000003oool0oooo01d0oooo0P0000120?ooo`030000003oool0
oooo0880oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0g0?ooo`00BP3oool4003o
01l0oooo00<000000?ooo`3oool0803oool200000400oooo00<000000?ooo`3oool0P`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo03H0oooo001:0?ooo`@00?l07P3oool00`000000
oooo0?ooo`0S0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0P`3oool2000000`0
oooo00<000000?ooo`3oool0=@3oool004X0oooo1000o`0M0?ooo`030000003oool0oooo02D0oooo
0P00000o0?ooo`030000003oool0oooo08@0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0d0?ooo`00BP3oool4003o01`0oooo00<000000?ooo`3oool0:03oool2000003d0oooo00<0
00000?ooo`3oool0Q@3oool2000000/0oooo00<000000?ooo`3oool0<`3oool004D0oooo10000004
003o00030000003oool0oooo01T0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0k
0?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0c
0?ooo`00A03oool2000000<0002O1000o`0010000:80000000000000000F0?ooo`800000;`3oool2
000003/0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo0380oooo00120?ooo`80000000<0002J0000000009l00P0009l4003o00@0002R0P00000C0?oo
o`030000003oool0oooo0340oooo0P00000j0?ooo`030000003oool0oooo08L0oooo0P0000090?oo
o`030000003oool0oooo0340oooo00110?ooo`050000000009X0002J0000VP0000001P0009l00`00
0000002R0000XP030000XP030000003oool0oooo0100oooo00<000000?ooo`3oool0=03oool00`00
0000oooo0?ooo`0h0?ooo`030000003oool0oooo08P0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0`0?ooo`00@@3oool01@000000002J0000VP0009X0000000D0002O00<000000000
XP000:800`000:800`000000002N0000000@0?ooo`030000003oool0oooo03H0oooo0P00000h0?oo
o`030000003oool0oooo08T0oooo0P0000080?ooo`030000003oool0oooo02l0oooo00120?ooo`04
0000000009X0002J000000D0002O00<000000000XP000:800`000:800`000000002N0000000?0?oo
o`030000003oool0oooo03T0oooo0P00000g0?ooo`030000003oool0oooo08X0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0^0?ooo`00@P3oool01@000000002J0000VP0009X00000
00@0002O00<000000000XP000:800`000:8010000000002N0000WP00000=0?ooo`030000003oool0
oooo03`0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`2;0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0;P3oool00480oooo00D000000000VP0009X0002J00000004
0000W`03000000000:80002R0080002R00@000000000WP0009h000003@3oool00`000000oooo0?oo
o`0n0?ooo`800000=@3oool00`000000oooo0?ooo`2;0?ooo`8000001P3oool00`000000oooo0?oo
o`0]0?ooo`00@P3oool01@000000002J0000VP0009X0000000@0002O00<000000000XP000:800P00
0:8010000000002N0000WP00000<0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool0
<`3oool00`000000oooo0?ooo`2<0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
;03oool004<0oooo00@000000000VP0009X00000100009l01@000000002R0000XP000:8000000080
002N00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`130?ooo`800000<`3oool00`000000
oooo0?ooo`2=0?ooo`8000001@3oool00`000000oooo0?ooo`0[0?ooo`00@`3oool010000000002J
0000VP0000040000W`05000000000:80002R0000XP0000000P0009h00`000000oooo0?ooo`090?oo
o`030000003oool0oooo04H0oooo0P00000b0?ooo`030000003oool0oooo08h0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0Z0?ooo`00@`3oool010000000002J0000VP0000040000
W`07000000000:80002R0000XP000000002N0000000;0?ooo`030000003oool0oooo04T0oooo00<0
00000?ooo`3oool0;`3oool00`000000oooo0?ooo`2?0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0:@3oool004<0oooo00@000000000VP0009X000000`0009l01@000000002R0000
XP000:8000000080002N00<000000?ooo`3oool01`3oool2000004d0oooo0P00000`0?ooo`030000
003oool0oooo08l0oooo0P0000030?ooo`030000003oool0oooo02T0oooo00140?ooo`0300000000
09X0000000<0002O00L000000000XP000:80002R0000000009h0000000T0oooo00<000000?ooo`3o
ool0C`3oool2000002l0oooo00<000000?ooo`3oool0T03oool01@000000oooo0?ooo`3oool00000
02X0oooo00140?ooo`030000000009X0000000<0002O00L000000000XP000:80002R0000000009h0
000000P0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0
oooo0940oooo00D000000?ooo`3oool0oooo0000000Y0?ooo`00A03oool00`000000002J00000003
0000W`06000000000:80002R0000000009h00000203oool00`000000oooo0?ooo`1D0?ooo`800000
;@3oool00`000000oooo0?ooo`2A0?ooo`8000000P3oool00`000000oooo0?ooo`0V0?ooo`00A03o
ool010000000002J0000VP0000020000W`06000000000:80002R0000000009h000001`3oool00`00
0000oooo0?ooo`1G0?ooo`800000:`3oool00`000000oooo0?ooo`2C0?ooo`040000003oool0oooo
000002L0oooo00150?ooo`030000000009X000000080002O00<000000000XP000:800P0000070?oo
o`030000003oool0oooo05X0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`2C0?oo
o`80000000<0oooo0000003oool09@3oool004D0oooo00<000000000VP0000000P0009l01@000000
002R0000000009h0000000H0oooo00<000000?ooo`3oool0G03oool2000002T0oooo00<000000?oo
o`3oool0U@3oool2000002H0oooo00150?ooo`050000000009X000000000W`0000000P000:820000
00H0oooo00<000000?ooo`3oool0G`3oool2000002P0oooo00<000000?ooo`3oool0U@3oool20000
02D0oooo00150?ooo`050000000009X000000000W`0000000P000:82000000D0oooo00<000000?oo
o`3oool0HP3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo09D0oooo0P00000T0?oo
o`00AP3oool2000000030000W`000000002R008000001@3oool00`000000oooo0?ooo`1T0?ooo`80
00009P3oool00`000000oooo0?ooo`2F0?ooo`8000008`3oool004H0oooo0P0000000`0009l00000
0000XP02000000@0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`0T0?ooo`030000
003oool0oooo0940oooo1000000U0?ooo`00AP3oool2000000040000W`0000000000000000@0oooo
00<000000?ooo`3oool0J@3oool2000002@0oooo00<000000?ooo`3oool0SP3oool3000002T0oooo
00160?ooo`80000000@0002O00000000000000000P3oool2000006h0oooo0P00000S0?ooo`030000
003oool0oooo08T0oooo1000000/0?ooo`00A`3oool010000000002O0000000000020?ooo`030000
003oool0oooo0700oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`250?ooo`<00000
<03oool004L0oooo100000000`3oool000000?ooo`1c0?ooo`8000008@3oool00`000000oooo0?oo
o`220?ooo`<00000<`3oool004L0oooo0`0000000`3oool000000?ooo`1f0?ooo`800000803oool0
0`000000oooo0?ooo`1m0?ooo`@00000=P3oool004L0oooo1000001j0?ooo`030000003oool0oooo
01d0oooo00<000000?ooo`3oool0NP3oool3000003X0oooo00170?ooo`800?l000<00000003o003o
ool0NP3oool2000001h0oooo00<000000?ooo`3oool0M@3oool4000003d0oooo00160?ooo`800?l0
00<00000003o003oool0O@3oool2000001d0oooo00<000000?ooo`3oool0L@3oool300000440oooo
00160?ooo`@00?l0P03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo06d0oooo1000
00140?ooo`00AP3oool4003o0840oooo0P00000K0?ooo`030000003oool0oooo06T0oooo0`000018
0?ooo`00AP3oool4003o08<0oooo0P00000I0?ooo`030000003oool0oooo06D0oooo1000001;0?oo
o`00AP3oool4003o08D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`1Q0?ooo`<0
0000C`3oool004H0oooo1000o`260?ooo`800000603oool00`000000oooo0?ooo`1M0?ooo`<00000
DP3oool004H0oooo1000o`280?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0F@3o
ool4000005D0oooo00160?ooo`@00?l0R@3oool2000001H0oooo00<000000?ooo`3oool0E@3oool3
000005T0oooo00160?ooo`@00?l0R`3oool2000001@0oooo00<000000?ooo`3oool0D@3oool40000
05`0oooo00160?ooo`@00?l0S@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo04d0
oooo0`00001P0?ooo`00AP3oool4003o08h0oooo0P00000C0?ooo`030000003oool0oooo04P0oooo
1000001S0?ooo`00AP3oool4003o0900oooo0P00000A0?ooo`030000003oool0oooo04D0oooo0`00
001W0?ooo`00AP3oool4003o0980oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`10
0?ooo`@00000JP3oool004H0oooo1000o`2C0?ooo`8000003`3oool00`000000oooo0?ooo`0m0?oo
o`<00000KP3oool004D0oooo1000o`2F0?ooo`8000003P3oool00`000000oooo0?ooo`0h0?ooo`@0
0000L@3oool004D0oooo1000o`2H0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
=03oool3000007D0oooo00150?ooo`@00?l0V@3oool2000000`0oooo00<000000?ooo`3oool0<@3o
ool3000007P0oooo00150?ooo`@00?l0V`3oool2000000/0oooo00<000000?ooo`3oool0;03oool4
000007/0oooo00150?ooo`@00?l0W@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
02T0oooo0`00001o0?ooo`00A@3oool4003o09h0oooo0P0000090?ooo`030000003oool0oooo02@0
oooo100000220?ooo`00A@3oool4003o0:00oooo0P0000080?ooo`030000003oool0oooo0200oooo
0`0000260?ooo`00A@3oool4003o0:80oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`0L0?ooo`@00000R@3oool004D0oooo1000o`2S0?ooo`8000001P3oool00`000000oooo0?ooo`0H
0?ooo`<00000S@3oool004D0oooo1000o`2U0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0503oool400000900oooo00150?ooo`@00?l0YP3oool2000000@0oooo00<000000?ooo`3o
ool0403oool3000009@0oooo00150?ooo`@00?l0Z03oool2000000<0oooo00<000000?ooo`3oool0
303oool3000009L0oooo00150?ooo`@00?l0ZP3oool010000000oooo0?ooo`00000:0?ooo`@00000
VP3oool004<0oooo0P000004003o00030000003oool0oooo0:P0oooo0P0000000`3oool000000?oo
o`050?ooo`<00000WP3oool003d0oooo1P0000000`00O0000?l0003o0002003o000400000000X`00
000000000:X0oooo0P0000020?ooo`@00000X@3oool003/0oooo0`000006001l00@00?l000@00000
002S0000X`000:<00P00002Z0?ooo`800000Y@3oool003X0oooo00@0000000120000@P0000002P00
O0000`0000000:<0002S0003002S00800000o`3ooom@0?ooo`00>03oool2000000<0048000<00000
001l0000O0001`00O0000`0000000:<0002S0006002S00800000o`3ooom>0?ooo`00=`3oool00`00
00000480001200030012000300000000O00007`000L007`000<00000002S0000X`001`00X`000`00
0000oooo0?ooo`3o0?oood`0oooo000g0?ooo`0300000000@P00048000<0048000<00000001l0000
O0001`00O0000`0000000:<0002S0006002S000300000000gP0000000?l0ooooC@3oool003L0oooo
00<0000000120000@P000`00@P000`00000007`0001l0007001l000300000000X`000:<000H00:<0
00<00000003N00000000o`3ooom=0?ooo`00>03oool00`0000000480001200030012000300000000
O00007`000H007`000<00000002S0000X`001P00X`000`0000000=h00000003o0?ooodd0oooo000h
0?ooo`0300000000@P00048000<0048000<00000001l0000O0001P00O0000`0000000:<0002S0005
002S000500000000gP000=h0003N00000000o`3ooom<0?ooo`00>03oool00`000000048000120003
0012000300000000O00007`000H007`000<00000002S0000X`001@00X`001@0000000=h0003N0000
gP0000000?l0ooooC03oool003P0oooo00<0000000120000@P000`00@P000`00000007`0001l0005
001l000300000000X`000:<000H00:<000D00000003N0000gP000=h00000003o0?oood`0oooo000i
0?ooo`0300000000@P0004800080048000<00000001l0000O0001@00O0000`0000000:<0002S0005
002S000500000000gP000=h0003N00000000o`3ooom=0?ooo`00>@3oool00`000000048000120002
0012000300000000O00007`000D007`000<00000002S0000X`001@00X`001@0000000=h0003N0000
gP0000000?l0ooooC@3oool003T0oooo00<0000000120000@P000P00@P000`00000007`0001l0005
001l000300000000X`000:<000@00:<000D00000003N0000gP000=h00000003o0?ooodh0oooo000i
0?ooo`0300000000@P0004800080048000<00000001l0000O0001@00O0000`0000000:<0002S0004
002S000500000000gP000=h0003N00000000o`3ooom>0?ooo`00>@3oool00`000000048000120002
0012000300000000O00007`000D007`000<00000002S0000X`001000X`00100000000=h0003N0000
003o0?ooodl0oooo000j0?ooo`0500000000@P0004800012000000001`00O0000`0000000:<0002S
0003002S000500000000gP000=h0003N00000000o`3ooom?0?ooo`00>P3oool01@00000004800012
0000@P00000000H007`000<00000002S0000X`001000X`00100000000=h0003N0000003o0?oooe00
oooo000j0?ooo`0500000000@P0004800012000000001P00O0000`0000000:<0002S0004002S0004
00000000gP000=h000000?l0ooooD03oool003X0oooo00<0000000120000@P000P00@P000`000000
07`0001l0003001l000300000000X`000:<000<00:<000@00000003N0000gP000000o`3ooomA0?oo
o`00>`3oool01@000000048000120000@P00000000D007`000<00000002S0000X`000`00X`001000
00000=h0003N0000003o0?oooe40oooo000k0?ooo`0500000000@P0004800012000000001@00O000
0`0000000:<0002S0003002S000300000000gP0000000?l0ooooDP3oool003/0oooo00D000000012
0000@P00048000000005001l000300000000X`000:<000800:<000@00000003N0000gP000000o`3o
oomB0?ooo`00>`3oool01@000000048000120000@P00000000D007`000<00000002S0000X`000P00
X`00100000000=h0003N0000003o0?oooe80oooo000l0?ooo`0400000000@P000480000000@007`0
00<00000002S0000X`000`00X`000`0000000=h00000003o0?oooe<0oooo000l0?ooo`0400000000
@P000480000000@007`000<00000002S0000X`000P00X`00100000000=h0003N0000003o0?oooe<0
oooo000l0?ooo`0400000000@P000480000000@007`000<00000002S0000X`000P00X`000`000000
0=h00000003o0?oooe@0oooo000l0?ooo`0400000000@P000480000000@007`000D00000002S0000
X`000:<000000002003N00030000003oool0oooo0?l0ooooDP3oool001d0oooo00<0oooZ0;YbV`3D
ool00`3oool00`3oonX0^W9b0;[Zo`050?ooo`030?oZ^P1bL[X0j_oo0080oooo00L0oooZ0;ZK^P3Z
ool0oooo0?oojP2jVkX0j_oo00D0oooo00@0000000120000@P0000001000O0001`0000000:<0002S
0000X`000000003N00000000o`3ooomE0?ooo`007@3oool00`3oe9/0000009_Do`040?ooo`030?oZ
^P1b0780^^[o00<0oooo00<0onZj0780LP2jj_l00`3oool01`3oj[X0LP0009_Do`3oool0onZj0780
002Ke?l01P3oool00`000000048000000004001l000700000000X`000:<0002S000000000=h00000
003o0?oooeD0oooo000L0?ooo`050?oojP2jLP0009^j0;ZK^P3Zool0103oool01`3oj[X0LP1b0;[Z
o`3oool0onZj0780LP2jj_l0103oool01`3Z^W8007:K09^je03oool0j[Yb001bLP1bVm@01P3oool0
0`000000048000000004001l000600000000X`000:<000000000gP000000o`3ooomF0?ooo`00703o
ool01@3oe9/0000009_Do`3Z^W80VmCo00D0oooo00D0onZj0780LP2je;X0LP1b0;[Zo`040?ooo`09
0?oojP2jLP00VmCo0>ZjV`2jj^X0^W8009_Do`3DVi/0e?oo00D0oooo00@0000000120000@P000000
0P00O0001`0000000:<0002S0000X`000000003N00000000o`3ooomF0?ooo`00703oool01@3DV`00
07:j0>[oo`3oom@0Vi_D00H0oooo00<0onZj0780LP2jj_l01@3oool02@3oe9/0002K0=Coo`3oom@0
^Y^K0780V`3Dool0onZj0;[Do`050?ooo`0400000000@P0004800000008007`000@00000002S0000
X`000:<00P00003o0?oooeL0oooo000K0?ooo`030?oZ^P1b0000VmCo0080oooo00<0j[ZK0;[Zo`3o
ool00`3oool01@3oj[X0LP1b0;[D^P1b0780^^[o00@0oooo00X0e9/0002Ke03oool0oooo0=BK0000
Vm@0oooo0?oojP2jVkX0j_oo1@3oool00`000000048000000002001l000600000000X`000:<00000
0000gP000000o`3ooomG0?ooo`006`3oool00`3DV`00002K0=Coo`020?ooo`030?oZ^P1bVm@0oooo
0080oooo00L0onZj0780LP2jj_l0oooo0?oZ^P1b0780^^[o0080oooo00L0oooD09/0002Ke?l0oooo
0?ooe02K0000VmCo0080oooo00<0j[ZK0;[Zo`3oool0103oool00`000000048000000002001l0003
00000000X`000:<000800000o`3ooomH0?ooo`006P3oool03@3DV`00000000000000L[X0j_oo0?oo
e02K0000000007:jjP3oool0onZj0780LP2jj_l00`3oool0403oj[X0LP1b0;[DjP3ZonX0^W800000
000009/0e?oD09/000000000001b0;[Zo`3oj[X0LP000000V`3Dool40?ooo`0300000000@P000000
008007`000<00000002S0000X`000P00003o0?oooeP0oooo000S0?ooo`030?oojP2jLW80^^[o00D0
oooo00<0onZj07:Ke03oool0403oool00`000000048000000002001l000500000000X`000000003N
00000000o`3ooomH0?ooo`00?P3oool00`000000048000000002001l000400000000X`0000000000
0?l0ooooF@3oool003l0oooo0P0000001000O0000000002S0000X`0200000?l0ooooF@3oool003l0
oooo0P0000000`00O0000000002S000200000?l0ooooFP3oool003l0oooo0P0000000`00O0000000
002S000200000?l0ooooFP3oool003l0oooo0P0000001000O000000000000000003o0?oooe/0oooo
00100?ooo`0300000000O000000000800000o`3ooomK0?ooo`00@03oool400000?l0ooooG03oool0
0400oooo1000003o0?oooe`0oooo00100?ooo`<00000o`3ooomM0?ooo`00@@3oool200000?l0oooo
G@3oool00440oooo00<000000?ooo`3oool0o`3ooomL0?ooo`00@@3oool00`000000oooo0?ooo`3o
0?oooe`0oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo003o
0?oooj00oooo003o0?oooj00oooo003o0?oooj00oooo0000\
\>"],
  ImageRangeCache->{{{0, 414.875}, {430.875, 0}} -> {0.0342154, \
-4.73988*^-06, 0.00330018, 0.00330018}}],

Cell[BoxData[
    \("El volumen del paralelogramo determinado por los vectores u, v y w\nes \
igual al producto del \[AAcute]rea de la base por la altura.\nEl \[AAcute]rea \
de la base es igual a ||v\[Times]w||\nLa altura es igual a la norma del \
vector \[CapitalPi] que es\nla proyecci\[OAcute]n ortogonal del vector u \
sobre el vector v\[Times]w\n||\[CapitalPi]||=|u.(v\[Times]w)|/||v\[Times]w||\n\
Por tanto el volumen del paralelep\[IAcute]pedo es igual a \
|u.(v\[Times]w)|"\)], "Print"]
}, Open  ]],

Cell[TextData[{
  "La siguiente gr\[AAcute]fica ilustra la forma de calcular la distancia de \
un punto ",
  Cell[BoxData[
      \(TraditionalForm\`p = \((1, 2, 3)\)\)]],
  " al plano \[CapitalPi] engendrado por los vectores ",
  Cell[BoxData[
      \(TraditionalForm\`x = \((1, 0, 1)\)\)]],
  " e ",
  Cell[BoxData[
      \(TraditionalForm\`y = \((1, 2, 0)\)\)]],
  " ."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(x = {1, 0, 1};\)\), "\n", 
    \(y = {1, 2, 0};  (*\ 
      los\ vectores\ x\ e\ y\ son\ una\ base\ del\ plano\ \[CapitalPi]\ *) \n
    y = y - \((y . x/x . x)\)*x\ ;  (*\ vector\ ortogonal\ a\ x\ *) \n
    v1 = x/norma[x]; 
    v2 = y/norma[y];  (*\ {v1, 
          v2}\ es\ una\ base\ ortonormal\ del\ plano\ \[CapitalPi]\ *) \n
    p = {1, 2, 3};\), "\n", 
    \(\(w1 = \((p . v1)\)*v1\ \ \  (*\ 
        proyecci\[OAcute]n\ ortogonal\ de\ p\ sobre\ v1\ *) ;\)\), "\n", 
    \(\(w2 = \((p . v2)\)*v2\ \ \  (*\ 
        proyecci\[OAcute]n\ ortogonal\ de\ p\ sobre\ v2\ *) ;\)\), "\n", 
    \(z = p - w1 - w2\ \ ;  (*\ 
      es\ un\ vector\ ortogonal\ a\ v1\ y\ a\ v2\ y, \ 
      por\ tanto\ es\ ortogonal\ al\ plano\ \[CapitalPi]\ *) \n
    Show[Graphics3D[{vector3D[2  v1, Red], vector3D[2  v2, Red], 
          vector3D[p, Blue], 
          vector3D[z, Green], {Magenta, \ 
            Line[{v1, 3  v1, 3 \((v1 + v2)\), 3  v2, v2}]}, 
          vector3D[w1 + w2, z, Green], vector3D[w1 + w2, Cyan], 
          Text["\<v1\>", v1 - {0, 0, 1}], 
          Text["\<v2\>", v2 + {0,  .8, \(- .1\)}], 
          Text["\<p\>", p + {0,  .12,  .12}], 
          Text["\<z\>", z - {0, \(- .25\), 3}], 
          Text["\<w1+w2\>", w1 + w2 - {0,  .3,  .1}], 
          Text["\<\[CapitalPi]\>", w1 + w2 + {0,  .3, 1}], 
          Text["\<Tz\>", p - {0, \(-0.1\), 3}]}, AspectRatio -> Automatic, 
        Ticks -> None, Boxed -> False, PlotRange -> All, 
        ViewPoint -> {0.767, \ \(-0.731\), \ 3.214}, 
        TextStyle -> {FontFamily -> "\<Times\>", \ 
            FontSize -> 12}]];\), "\n", 
    \(Print["\<{v1,v2} es una base ortonormal de \[CapitalPi]\nw1+w2 es la \
proyecci\[OAcute]n ortogonal de p sobre el plano \[CapitalPi]\nz=p-w1-w2 es \
un vector ortogonal a \[Pi]\nTz se obtiene por traslaci\[OAcute]n de z\nLa \
distancia del punto p al plano \[Pi] es igual a ||Tz||=||z||= \>", 
      norma[z]]\ \), "\n", 
    \(\tClear[x, y, v1, v2, w1, w2, z, p]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.09011 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.100545 1.19 -0.0998833 1.19 [
[ 0 0 0 0 ]
[ 1 1.09011 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 1.09011 L
0 1.09011 L
closepath
clip
newpath
1 0 1 r
.5 Mabswid
[ ] 0 setdash
.92418 .45155 m
.6487 .57573 L
s
.73 0 0 r
.46909 .50232 m .47412 .49078 L .52332 .5193 L closepath p F P
0 g
s
.758 0 0 r
.46862 .51162 m .46909 .50232 L .52332 .5193 L closepath p F P
0 g
s
.295 0 0 r
.47302 .51323 m .46862 .51162 L .52332 .5193 L closepath p F P
0 g
s
.716 0 0 r
.47975 .50612 m .47302 .51323 L .52332 .5193 L closepath p F P
0 g
s
.623 0 0 r
.47412 .49078 m .48081 .48366 L .52332 .5193 L closepath p F P
0 g
s
.829 0 0 r
.48484 .49446 m .47975 .50612 L .52332 .5193 L closepath p F P
0 g
s
0 0 0 r
.48081 .48366 m .48526 .48515 L .52332 .5193 L closepath p F P
0 g
s
.898 0 0 r
.48526 .48515 m .48484 .49446 L .52332 .5193 L closepath p F P
0 g
s
1 0 1 r
.52332 .5193 m
.6487 .57573 L
s
.39272 .46051 m
.4821 .50074 L
s
1 0 0 r
.007 w
.25656 .39922 m
.4821 .50074 L
s
.5 Mabswid
0 .334 0 r
.18872 .64122 m .20066 .64217 L .17218 .68906 L closepath p F P
0 g
s
0 .549 0 r
.17634 .63653 m .18872 .64122 L .17218 .68906 L closepath p F P
0 g
s
0 .734 0 r
.17071 .63081 m .17634 .63653 L .17218 .68906 L closepath p F P
0 g
s
0 0 0 r
.20066 .64217 m .20525 .63882 L .17218 .68906 L closepath p F P
0 g
s
0 .015 0 r
.17519 .62739 m .17071 .63081 L .17218 .68906 L closepath p F P
0 g
s
0 .836 0 r
.20525 .63882 m .19971 .63308 L .17218 .68906 L closepath p F P
0 g
s
0 .46 0 r
.18723 .62833 m .17519 .62739 L .17218 .68906 L closepath p F P
0 g
s
0 .628 0 r
.19971 .63308 m .18723 .62833 L .17218 .68906 L closepath p F P
0 g
s
0 1 0 r
.007 w
.1896 .62923 m
.25656 .39922 L
s
.5 Mabswid
.089 0 0 r
.39033 .31644 m .3835 .30403 L .40256 .29646 L closepath p F P
0 g
s
0 0 0 r
.38766 .32891 m .39033 .31644 L .40256 .29646 L closepath p F P
0 g
s
.219 0 0 r
.3835 .30403 m .37114 .29889 L .40256 .29646 L closepath p F P
0 g
s
.8 0 0 r
.377 .33418 m .38766 .32891 L .40256 .29646 L closepath p F P
0 g
s
.091 0 0 r
.37114 .29889 m .36044 .30407 L .40256 .29646 L closepath p F P
0 g
s
0 .372 .692 r
.6161 .371 m .614 .34861 L .68457 .35119 L closepath p F P
0 g
s
0 .022 .319 r
.60902 .38744 m .6161 .371 L .68457 .35119 L closepath p F P
0 g
s
0 .555 .903 r
.614 .34861 m .60392 .33314 L .68457 .35119 L closepath p F P
0 g
s
1 0 1 r
.70501 .34362 m
.92418 .45155 L
s
.648 0 0 r
.36457 .32908 m .377 .33418 L .40256 .29646 L closepath p F P
0 g
s
.388 0 0 r
.36044 .30407 m .35769 .31659 L .40256 .29646 L closepath p F P
0 g
s
.521 0 0 r
.35769 .31659 m .36457 .32908 L .40256 .29646 L closepath p F P
0 g
s
1 0 0 r
.007 w
.25656 .39922 m
.36223 .32484 L
s
1 0 1 r
.5 Mabswid
.40256 .29646 m
.48764 .23658 L
s
.32593 .35039 m
.36223 .32484 L
s
0 .912 .921 r
.59677 .38831 m .60902 .38744 L .68457 .35119 L closepath p F P
0 g
s
0 0 0 r
.60392 .33314 m .59163 .33365 L .68457 .35119 L closepath p F P
0 g
s
0 .694 .882 r
.5865 .37286 m .59677 .38831 L .68457 .35119 L closepath p F P
0 g
s
0 .331 .477 r
.59163 .33365 m .58436 .35011 L .68457 .35119 L closepath p F P
0 g
s
1 0 1 r
.48764 .23658 m
.70501 .34362 L
s
0 .52 .714 r
.58436 .35011 m .5865 .37286 L .68457 .35119 L closepath p F P
0 g
s
0 1 1 r
.007 w
.25656 .39922 m
.58551 .36231 L
s
.5 Mabswid
0 0 .318 r
.54096 .64739 m .56152 .62975 L .6134 .6738 L closepath p F P
0 g
s
0 0 .537 r
.56152 .62975 m .56963 .60491 L .6134 .6738 L closepath p F P
0 g
s
0 0 0 r
.51974 .64764 m .54096 .64739 L .6134 .6738 L closepath p F P
0 g
s
0 0 .433 r
.56963 .60491 m .56053 .58716 L .6134 .6738 L closepath p F P
0 g
s
0 0 .898 r
.51025 .63008 m .51974 .64764 L .6134 .6738 L closepath p F P
0 g
s
0 0 .307 r
.56053 .58716 m .53928 .58703 L .6134 .6738 L closepath p F P
0 g
s
0 0 .711 r
.51834 .60486 m .51025 .63008 L .6134 .6738 L closepath p F P
0 g
s
0 0 .552 r
.53928 .58703 m .51834 .60486 L .6134 .6738 L closepath p F P
0 g
s
0 0 1 r
.007 w
.25656 .39922 m
.52093 .60265 L
s
.5 Mabswid
0 .317 0 r
.62476 .62046 m .63906 .62148 L .6134 .6738 L closepath p F P
0 g
s
0 .537 0 r
.61164 .61516 m .62476 .62046 L .6134 .6738 L closepath p F P
0 g
s
0 .705 0 r
.60731 .60865 m .61164 .61516 L .6134 .6738 L closepath p F P
0 g
s
0 0 0 r
.63906 .62148 m .64626 .61763 L .6134 .6738 L closepath p F P
0 g
s
0 .121 0 r
.61439 .60472 m .60731 .60865 L .6134 .6738 L closepath p F P
0 g
s
0 .893 0 r
.64626 .61763 m .64206 .61109 L .6134 .6738 L closepath p F P
0 g
s
0 .453 0 r
.62882 .60573 m .61439 .60472 L .6134 .6738 L closepath p F P
0 g
s
0 1 0 r
.007 w
.62842 .6057 m
.68457 .35119 L
s
.5 Mabswid
0 .637 0 r
.64206 .61109 m .62882 .60573 L .6134 .6738 L closepath p F P
0 g
s
gsave
.33498 .30885 -68.9063 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v1) show
74.813 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.4828 .53641 -68.9063 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(v2) show
74.813 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.63041 .69667 -66 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(p) show
69.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.24543 .55049 -65.6563 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(z) show
68.313 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.64586 .31123 -81.5625 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w1) show
77.688 15.875 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(+) show
85.438 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(w2) show
100.125 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.73659 .43816 -67.3438 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(P) show
71.688 15.875 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.60555 .50821 -69.4063 -11.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 23.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Tz) show
75.813 15.875 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 12.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{264.188, 287.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006<0001[b000`400?l00000o`00003oo`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=
0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00`03oool20?l0olX0oooo002n0?ooo`80o`3o0P3o
ool20?l0olP0oooo002m0?ooo`030?l0o`3oool0oooo00@0oooo0P3o0?o60?ooo`00_03oool00`3o
0?l0oooo0?ooo`070?ooo`80o`3oa03oool00;X0oooo0P3o0?l<0?ooo`80o`3o`P3oool00;T0oooo
00<0o`3o0?ooo`3oool03P3oool20?l0ol00oooo002h0?ooo`030?l0o`3oool0oooo0140oooo0P3o
0?nn0?ooo`00]P3oool20?l0oaH0oooo0P3o0?nl0?ooo`00]@3oool00`3o0?l0oooo0?ooo`0H0?oo
o`80o`3o^P3oool00;<0oooo0P3o0?lM0?ooo`80o`3o^03oool00;80oooo00<0o`3o0?ooo`3oool0
7`3oool20?l0okH0oooo002a0?ooo`030?l0o`3oool0oooo0280oooo0P3o0?nd0?ooo`00[`3oool2
0?l0obL0oooo0P3o0?nb0?ooo`00[P3oool00`3o0?l0oooo0?ooo`0Y0?ooo`80o`3o/03oool00:d0
oooo00<0o`3o0?ooo`3oool0;03oool20?l0ojh0oooo002[0?ooo`80o`3o<@3oool20?l0oj`0oooo
002Z0?ooo`030?l0o`3oool0oooo03<0oooo0P3o0?nZ0?ooo`00Z03oool20?l0ocP0oooo0P3o0?nX
0?ooo`00Y`3oool00`3o0?l0oooo0?ooo`0j0?ooo`80o`3oYP3oool00:H0oooo00<0o`3o0?ooo`3o
ool0?@3oool20?l0oj@0oooo002T0?ooo`80o`3o@P3oool20?l0oj80oooo002S0?ooo`030?l0o`3o
ool0oooo04@0oooo0`3o0?nO0?ooo`00XP3oool00`3o0?l0oooo0?ooo`180?ooo`80o`3oW@3oool0
0:00oooo0P3o0?m=0?ooo`80o`3oV`3oool007h0oooo00<0oooZ0;YbV`3Dool01@3oool01P3DV`00
000000000000000007:j0>[oo`d0oooo1P0000000`3o0?l0oooo0?ooo`1?0?ooo`80o`3oV@3oool0
07h0oooo00<0omBK0000001b^^X01P3oool00`3oj[X0LP0009_Do`080?ooo`h00000AP3oool00`3o
j[X0Vk[Z0?ooo`020?ooo`030>ZjV`2jj_l0oooo00@0oooo00H0e9/00000000000000000001b^P3Z
ool60?ooo`030>ZjLP1b^^X0oooo00L0oooo00<0onZj09^jjP3oool00P3oool00`3Z^Y/0^^[o0?oo
o`020?ooo`030=BK00000000000000@0000000<0L[[Z0?ooo`3oool0L03oool007d0oooo00D0oooZ
0;Yb0000L[X0^Y^K0=Coo`050?ooo`030?oZ^P1b0000VmCo00H0oooo1`00000306<00080000000<0
Q@00000000000000A`3oool01`3DV`00002K0=Coo`3oool0oooD09/00000Vm@01P3oool0103oj[X0
LP0009/0o`3o0?l70?ooo`030>ZjLP1b^^X0oooo00L0oooo00L0e9/00000V`3Dool0oooo0?ooe02K
000009_D00@0oooo00<0j[Yb0000000000000`0000000`00L[X0j_oo0?ooo`1`0?ooo`00O@3oool0
1@3oj[X0LP0009_Do`3oe9/0L[[Z00D0oooo00<0onZj0780002Ke?l0103oool3000000L0H`000P00
00000`250000000000000002000004H0oooo00T0onZj0780001bVi/0Vk[Z0?ooo`3oe9/0001b079b
LP2jj_l01@3oool0103oj[X0LP0009_Do`3oool20?l0o`D0oooo00<0j[Yb07:jjP3oool01P3oool0
2@3oj[X0LP0007:KV`2K^^X0oooo0?oDV`000780LW9b0;[Zo`040?ooo`030>ZjLP1b^^X0oooo0080
oooo00<0j[ZK0;[Zo`3oool0L03oool007d0oooo00H0e9/0001b^P3Zool0oooZ0;YbV`3Dool40?oo
o`030?oZ^P1b0000VmCo00@0oooo00<0000006<0001S0000101S000300000080Q@0000@000000:D0
000000000000A`3oool02@3Z^W80002K0=Coo`3DVi/0e?oZ0;Yb0000Vm@0onZj09^jjP050?ooo`03
0?oZ^P1b0000VmCo00<0oooo0P3o0?l30?ooo`030>ZjLP1b^^X0oooo00H0oooo00T0j[Yb0000V`3D
ool0e9^K0=CojP2jLP0009_D0?oZ^P2K^^X01@3oool00`3Z^W80VmCo0?ooo`1d0?ooo`00O03oool0
0`3oj[X0LP0009_Do`020?ooo`030?oDV`1b^^X0oooo00<0oooo00<0onZj0780002Ke?l0103oool0
0`000000H`0006<0000206<000800000102500000`000000Y@000:D00002000004H0oooo00/0oooD
09/0001b^^X0oooo0?oZ^P2KVi/0LP1b0;[Zo`3oool0e9^K0=Coo`040?ooo`030?oZ^P1b0000VmCo
00@0oooo00<0e9/00000000000001P0000003P00Vm@0oooo0?ooo`3oom@0V`0007:jjP3oool0onZj
09^KV`1b0780^^[o0?ooo`3DVi/0e?oo1@3oool00`3DVg80^^[o0?ooo`1c0?ooo`00N`3oool0103o
onX0^W800000V`3Dool20?ooo`030?oojP2jLY/0e?oo00<0oooo00<0onZj0780002Ke?l00`3oool0
10000000H`0006<0001S0002000000D0Q@0000<000000:D0002U00000P0000170?ooo`070>ZjLP00
0780^^[o0?ooo`3oonX0^W80002Ke0020?ooo`030?oDV`1b^^X0oooo00<0oooo00<0onZj0780002K
e?l01`3oool00`3o0?l0jP1b07:jjP060?ooo`070>ZjLP000780^^[o0?ooo`3oonX0^W80002Ke002
0?ooo`030?oDV`1b^^X0oooo00@0oooo00<0oooZ0;YbV`3Dool0L`3oool007X0oooo00/0oooZ0;Yb
0000000000000000V`3Dool0oooZ0;Yb0000000007:j0>[oo`020?ooo`030?oZ^P1b0000VmCo00<0
oooo00@0000006<00000000000001P2500001P000000Y@000:D000000000c000000004H0oooo00<0
oooD09/00000Vm@00P3oool00`3oj[X0LP0009_Do`020?ooo`030?oojP2jLY/0e?oo00<0oooo00<0
onZj0780002Ke?l0203oool00`3Z^W80LP3Z0?l0o`040?ooo`030?ooe02K000009_D0080oooo00<0
onZj0780002Ke?l00P3oool00`3oonX0^W:K0=Coo`050?ooo`030?oDV`00Vm@0oooo0780oooo0027
0?ooo`030?oZ^P1b0000VmCo00<0oooo0P00000708D000040000002U0000Y@000:D000800000AP3o
ool01P3oonX0^W80000000000000L[[Z0?oDV`<0000000H0L[[Z0?ooo`3DV`000000001b^P3Zool2
0?ooo`030?oZ^P1b0000VmCo00P0oooo00<0j[Yb07:jjP3oool00P3o0?l00`3oool0oooZ0;Yb0002
0000000307:jjP3oe9/000000080000000H0L[[Z0?ooo`3DV`000000001b^P3Zool40?ooo`030?oo
e02K0780^^[o0780oooo00270?ooo`030?oZ^P1b0000VmCo00@0oooo00<0000008D0002500001025
00001`000000Y@000:D0002U000000000<`000000000E`3oool00`3oj[X0LP0009_Do`080?ooo`03
0>ZjLP1b^^X0oooo0080oooo0P3o0?lB0?ooo`030?ooe02K0000L[[Z0780oooo00250?ooo`050?oo
jP2jLP0000000000002Ke?l0103oool00`000000o`0008D0000208D0008000000`2U00000`000000
c0000000001H0?ooo`030?oZ^P1b0000VmCo00l0oooo0P3o0?l;0?ooo`030?oD^P2jj_l0oooo0080
oooo00<0onZj0780001b^^X0LP3oool008L0oooo00<0omBK0000002Ke?l0103oool01@3o0000o`3o
0?l000250000000000D0Y@0000<000000<`000000000EP3oool01@3oonX0^W80000000000000VmCo
0140oooo0P3o0?l90?ooo`080?oojP2jLW80^^[o0?ooo`3oom@0V`000000V`3Doomb0?ooo`00S03o
ool01P3o0000o`3o0?l0o`3o0000Q@00000000D0Y@0000<000000<`000000000F@3oool00`3oe9/0
000009_Do`0C0?ooo`80o`3o203oool01P3oonX0^W80000000000000002K0=Coog<0oooo002;0?oo
o`050?l0003o0?l0o`000?l0003oool00P0000040:D000040000003<0000c00000000740oooo0P3o
0?mo0?ooo`00R@3oool0103o0000o`3o0?l0o`3o00050?ooo`8000000P2U0003000005<0oooo1@00
000L0?ooo`80o`3oO@3oool008P0oooo00@0o`000?l0o`3o0000o`00203oool300000580oooo3000
000J0?ooo`80o`3oN`3oool008H0oooo00@0o`000?l0o`3o0?l0o`00GP3oool00`00000005Aj001D
NP02001DNPd000005`3oool20?l0ogT0oooo00250?ooo`040?l0003o0?l0o`000?l005l0oooo00<0
0000001DNP00E7X02000E7X;000001D0oooo0P3o0?mg0?ooo`00P`3oool0103o0000o`3o0?l0o`3o
001P0?ooo`0300000000E7X005Aj00l005Aj2P00000B0?ooo`<0o`3oM03oool00880oooo00@0o`00
0?l0o`3o0000o`00H@3oool00`00000005Aj001DNP0E001DNPT00000403oool20?l0og80oooo0021
0?ooo`80o`3o00<0o`000?ooo`3oool0H03oool00`00000005Aj001DNP0L001DNPL000003P3oool2
0?l0og00oooo001o0?ooo`040?l0003o0?l0o`000?l006<0oooo9`000002003o00d0oooo0P3o0?m^
0?ooo`00OP3oool40?l006@0oooo00<000000025]P00QKH07`00QKH5000000800?l03`3oool20?l0
of`0oooo001l0?ooo`@0o`00IP3oool00`00000008Ff0025]P0K0025]P@0000000D00;7Q00000000
000000000?ooo`02003o0140oooo0P3o0?mZ0?ooo`00N`3oool40?l006L0oooo00<000000025]P00
QKH05P00QKH5000000800;7Q100000030?ooo`800?l04`3oool20?l0ofP0oooo001i0?ooo`@0o`00
J@3oool00`0000000?oo0025]P0B0025]P@000001@00/N44000000D0oooo0P00o`0E0?ooo`80o`3o
IP3oool007P0oooo103o001R0?ooo`X00?oo3`00QKH4000000L00;7Q100000060?ooo`800?l0603o
ool20?l0of@0oooo001f0?ooo`@0o`00F`3ooolB003oo`0300000000QKH008Ff00P008Ff1@000008
002ah@D00000203oool2003o01X0oooo0P3o0?mR0?ooo`00M@3oool40?l005<0oooo4P00ool90?oo
o`0300000000QKH008Ff00@008Ff1000000;002ah@80000000<00>W[0000000000002P3oool2003o
01`0oooo0P3o0?mP0?ooo`00L`3oool40?l004/0oooo4`00oolB0?ooo`0300000000QKH008Ff00@0
00003@00/N4200000003003Yj`000000000000`0oooo0P00o`0N0?ooo`80o`3oGP3oool00780oooo
103o00130?oooa<00?oo6`3oool3000000h00;7Q0`0000000`00jN/000000000000>0?ooo`800?l0
803oool20?l0oe`0oooo001a0?ooo`<0o`00?03ooolB003oobH0oooo00<00000002ah@00/N402`00
/N42000000800>W[0P00000?0?ooo`800?l08`3oool20?l0oeX0oooo001_0?ooo`@0o`00<`3ooolC
003oobl0oooo00<00000002ah@00/N402@00/N42000000800>W[0P00000A0?ooo`800?l09@3oool2
0?l0oeP0oooo001^0?ooo`@0o`00:`3ooolC003oocT0oooo00<00000002ah@00/N401@00/N430000
00800>W[0P00000C0?ooo`800?l09`3oool20?l0oeH0oooo001/0?ooo`@0o`00903ooolB003ood@0
oooo00<00000002ah@00/N400P00/N42000000<00>W[0P00000E0?ooo`800?l0:@3oool20?l0oe@0
oooo001[0?ooo`@0o`00703ooolB003oodd0oooo00<00000002ah@00/N400P000003003Yj`800000
5P3oool2003o02`0oooo0P3o0?mB0?ooo`00J@3oool40?l001@0oooo4`00oomG0?ooo`L00000603o
ool2003o02h0oooo0P3o0?m@0?ooo`00J03oool40?l000`0oooo4`00oomo0?ooo`800?l0<03oool2
0?l0odh0oooo001V0?ooo`@0o`001@3ooolB003oohT0oooo0P00o`0b0?ooo`80o`3oC03oool006D0
oooo00<0003o003oo`00ool04000oonB0?ooo`800?l0=03oool20?l0odX0oooo001T0?ooo`<0003o
2000oonJ0?ooo`800?l0=`3oool20?l0odP0oooo001T0?ooo`03003oo`000?l0003o0080003o00<0
o`000?ooo`3oool0W@3oool2003o03T0oooo0P3o0?m60?ooo`00I03oool2003o00@0003o0`3o002L
0?ooo`800?l0>`3oool20?l0od@0oooo001S0?ooo`<00?l00P3oool30000o`@0o`00VP3oool2003o
03d0oooo0P3o0?m20?ooo`00H`3oool2003o00@0oooo0`000?l50?l009L0oooo0P00o`100?ooo`80
o`3o@03oool006<0oooo0P00o`050?ooo`@0003o1@3o002E0?ooo`800?l0@P3oool20?l0och0oooo
001S0?ooo`800?l01P3oool40000o`030?ooo`3o0000o`0000<0o`00T`3oool2003o04@0oooo0P3o
0?ll0?ooo`00HP3oool3003o00P0oooo0`000?l20?ooo`D0o`00T@3oool2003o04H0oooo0P3o0?lj
0?ooo`00HP3oool2003o00X0oooo10000?l20?ooo`H0o`00SP3oool2003o04P0oooo0P3o0?lh0?oo
o`00HP3oool2003o00/0oooo10000?l30?ooo`H0o`00R`3oool2003o04/0oooo0P3o0?lf0?ooo`00
H@3oool3003o00d0oooo0`000?l50?ooo`D0o`00R@3oool2003o04d0oooo0P3o0?ld0?ooo`00H@3o
ool2003o00l0oooo0`000?l60?ooo`D0o`00Q`3oool2003o01<0oooo00<0j[Yb0000000000000P00
00000`1b^^X0oooo0?oDV`040000000307:jjP3oool0oooo02d0oooo0P3o0?lb0?ooo`00H@3oool2
003o0100oooo10000?l60?ooo`D0o`00Q@3oool2003o01@0oooo00@0onZj0780000009/0e?oo0`3o
ool0103oom@0V`000000LP2jj_lb0?ooo`80o`3o<03oool00640oooo0P00o`0A0?ooo`@0003o1`3o
ool50?l008<0oooo0P00o`0D0?ooo`040?ooe02K000007:j0>[oo`<0oooo00@0oooZ0;Yb000009/0
e?oo=03oool20?l0obh0oooo001P0?ooo`<00?l04`3oool30000o`P0oooo1P3o001o0?ooo`800?l0
5@3oool0103oom@0V`00001b^P3Zool30?ooo`040?oojP2jLP00002K0=CoocH0oooo0P3o0?l/0?oo
o`00H03oool2003o01D0oooo10000?l80?ooo`H0o`00O@3oool2003o01D0oooo00@0oooD09/00000
L[X0j_oo0`3oool0103oonX0^W800000V`3Doolh0?ooo`80o`3o:P3oool00600oooo0P00o`0F0?oo
o`@0003o2P3oool50?l007/0oooo0P00o`0E0?ooo`040?ooe02K000007:j0>[oo`<0oooo00@0oooZ
0;Yb000009/0e?oo>P3oool20?l0obP0oooo001O0?ooo`<00?l0603oool30000o`/0oooo1@3o001i
0?ooo`800?l05@3oool0103oom@0V`00001b^P3Zool30?ooo`040?oojP2jLP00002K0=Cooc`0oooo
0P3o0?lV0?ooo`00G`3oool2003o01X0oooo0`000?l<0?ooo`D0o`00MP3oool2003o01H0oooo00@0
oooD09/00000L[X0j_oo0`3oool0103oonX0^W800000V`3Dooln0?ooo`80o`3o903oool005l0oooo
0P00o`0K0?ooo`@0003o303oool50?l007@0oooo0P00o`0F0?ooo`040?ooe02K000007:j0>[oo`<0
oooo00@0oooZ0;Yb000009/0e?oo@03oool20?l0ob80oooo001N0?ooo`<00?l0703oool40000o`d0
oooo1P3o001a0?ooo`800?l05P3oool0103oom@0V`00001b^P3Zool30?ooo`040?oojP2jLP00002K
0=Cood80oooo0P3o0?lP0?ooo`00GP3oool2003o01l0oooo0`000?l>0?ooo`H0o`00K`3oool2003o
01H0oooo00@0oooD09/00000L[X0j_oo0`3oool0103oonX0^W800000V`3Doom40?ooo`80o`3o7P3o
ool005h0oooo0P00o`0P0?ooo`@0003o3`3oool50?l006d0oooo0P00o`0F0?ooo`040?oZ^P1b0000
07:j0>[oo`<0oooo00@0oooZ0;Yb00000780^^[o@P3oool20?l0ob00oooo001N0?ooo`800?l08@3o
ool40000oa00oooo1@3o001Z0?ooo`800?l05P3oool00`3Z^W800000000000090000000307:jjP3o
ool0oooo03d0oooo0P3o0?lR0?ooo`00G@3oool3003o02<0oooo0`000?lA0?ooo`D0o`00J03oool2
003o0600oooo0P3o0?lT0?ooo`00G@3oool2003o02D0oooo0`000?lB0?ooo`D0o`00IP3oool2003o
05d0oooo0`3o0?lV0?ooo`00G@3oool2003o02H0oooo10000?lB0?ooo`H0o`00H`3oool2003o05/0
oooo0P3o0?lY0?ooo`00G03oool3003o02L0oooo10000?lC0?ooo`H0o`00H03oool2003o05X0oooo
0P3o0?l[0?ooo`00G03oool2003o02X0oooo0`000?lE0?ooo`D0o`00GP3oool2003o05P0oooo0P3o
0?l]0?ooo`00G03oool2003o02/0oooo10000?lE0?ooo`D0o`00G03oool2003o05H0oooo0P3o0?l_
0?ooo`00F`3oool3003o02`0oooo10000?lF0?ooo`D0o`00FP3oool2003o05<0oooo0`3o0?la0?oo
o`00F`3oool2003o02l0oooo0`000?lG0?ooo`D0o`00F03oool2003o0540oooo0P3o0?ld0?ooo`00
F`3oool2003o0300oooo0`000?lH0?ooo`H0o`00E03oool2003o0500oooo0P3o0?lf0?ooo`00F`3o
ool2003o0340oooo10000?lH0?ooo`H0o`00DP3oool2003o04h0oooo0P3o0?lh0?ooo`00FP3oool3
003o0380oooo10000?lJ0?ooo`D0o`00303oool200000480oooo0P00o`1;0?ooo`<0o`3o>P3oool0
05X0oooo0P00o`0e0?ooo`<0003o6`3oool50?l000T0oooo00@0000009l0000000000000@@3oool2
003o04T0oooo0P3o0?lm0?ooo`00FP3oool2003o03H0oooo10000?lK0?ooo`D0o`001P3oool01P00
0000W`0009l000000000i@0000000400oooo0P00o`170?ooo`80o`3o?`3oool005T0oooo0`00o`0g
0?ooo`@0003o703oool50?l000<0oooo00D0000009l0002O0000W`00000000020>D000030000003o
ool0oooo03`0oooo0P00o`160?ooo`80o`3o@@3oool005T0oooo0P00o`0j0?ooo`<0003o7@3oool6
0?l000050;X000000000000009l0000000000`3U00000`000000oooo0?ooo`0R0?ooo`030=BK0000
000000000080000000D009_D0?ooo`3oool0oooo0=BK00060000000307:jjP3oool0oooo00H0oooo
0P00o`140?ooo`80o`3o@`3oool005T0oooo0P00o`0k0?ooo`<0003o7P3oool60?l000030;X00000
00000000008000000P3U00000`000000oooo0?ooo`0R0?ooo`040?oojP2jLP0007:j0>[oo`@0oooo
00<0oooZ0;Yb0000Vm@00`3oool00`3oj[X0Vk[Z0?ooo`070?ooo`800?l0@@3oool30?l0odD0oooo
001H0?ooo`<00?l0?03oool40000oah0oooo00<000000?l0003o00000`3o00030=@000040000003U
0000i@00000002<0oooo00<0oooZ0;Yb0000Vm@01P3oool00`3oom@0V`0007:jjP020?ooo`030?oo
jP3De>X0oooo00L0oooo0P00o`0o0?ooo`80o`3oB03oool005P0oooo0P00o`0n0?ooo`@0003o7@3o
ool2000000030;X0003o0000o`000080o`000`3D0002000000030>D00000000000000240oooo00<0
oooZ0;Yb0000Vm@01`3oool00`3oj[X0LP0009_Do`0:0?ooo`800?l0?P3oool20?l0odX0oooo001H
0?ooo`800?l0@03oool30000oa`0oooo00<000000<80000000000P0000000`3o0000e0000=@00004
0=@000040000003U0000i@0000000200oooo00<0oooZ0;Yb0000Vm@0203oool00`3oe9/0001b0;[Z
o`090?ooo`800?l0?03oool20?l0od`0oooo001H0?ooo`800?l0@@3oool30000oa/0oooo00@00000
0<8000320000`P000P0000070=@00080000000<0i@000000003oool07P3oool00`3oonX0^W80002K
e0050?ooo`070?oZ^P2je?l0oooo0?ooo`3Z^W80002K0=Coo`080?ooo`800?l0>@3oool30?l0odh0
oooo001G0?ooo`<00?l0@P3oool40000oaT0oooo00@000000<800000000000000P2g0004000000D0
e00000<000000>D0000000007P3oool00`3oonX0^W80002Ke0050?ooo`030?ooe02j^^X0oooo0080
oooo00<0e9/0001b^P3Zool01`3oool2003o03L0oooo0P3o0?mA0?ooo`00E`3oool2003o04@0oooo
10000?lH0?ooo`D000001@2g0003000000<0e0000`00000M0?ooo`030?oojP2jLP0009_D00D0oooo
00<0oooD09/000000000100000000`00Vm@0oooo0?ooo`050?ooo`800?l0=@3oool20?l0oe<0oooo
001G0?ooo`800?l0AP3oool30000oa/0oooo1`0000020;L000<000000P3D0002000001`0oooo00<0
oooZ0;Yb0000Vm@04`3oool2003o03@0oooo0P3o0?mE0?ooo`00EP3oool3003o04L0oooo10000?lP
0?ooo`X000005`3oool01`3oe;X0^^[o0?ooo`3oool0oooZ0;Yb0000Vm@00`3oool00`3oe9/0VmCo
0?ooo`0=0?ooo`800?l0<P3oool20?l0oeL0oooo001F0?ooo`800?l0B@3oool40000obH0oooo0`00
00020?l0oaD0oooo00L0omBK001b^P3Zool0oooo0?oojP2jLP0009_D0080oooo00<0oooZ0;Yb002K
e?l03P3oool2003o02l0oooo0`3o0?mI0?ooo`00EP3oool2003o04/0oooo0`000?lZ0?ooo`80o`3o
4`3oool00`3oe9/00000000000080000000309_Do`3oool0oooo00`0oooo0P00o`0]0?ooo`80o`3o
G03oool005H0oooo0P00o`1<0?ooo`<0003o4@3oool00`3oonX0^W:K0=Coo`030?ooo`030=BK0000
0000000000@0000000<0L[[Z0?ooo`3oool02P3oool20?l0obX0oooo0P00o`0/0?ooo`80o`3oGP3o
ool005D0oooo0`00o`1=0?ooo`@0003o3`3oool00`3oe9/0000007:jjP040?ooo`030>ZjLP000000
000000<0000000<007:j0>[oo`3oool0303oool20?l0obP0oooo0P00o`0Z0?ooo`80o`3oH03oool0
05D0oooo0P00o`1?0?ooo`@0003o3@3oool01@3oonX0^W80001b^P2jVi/0e?oo00@0oooo00<0j[Yb
07:jjP3oool00P3oool00`3Z^Y/0^^[o0?ooo`0>0?ooo`<0o`3o9@3oool2003o02L0oooo0`3o0?mR
0?ooo`00E@3oool2003o0540oooo0`000?l<0?ooo`050?oZ^P1b0000VmCo0?oDV`1b^^X01@3oool0
0`3Z^W80VmCo0?ooo`0E0?ooo`80o`3o8`3oool2003o02D0oooo0P3o0?mU0?ooo`00E03oool3003o
0580oooo10000?l:0?ooo`060=BK0000L[X0j_oo0?oojP2jLY/0e?oo1@3oool00`3DVg80^^[o0?oo
o`0F0?ooo`80o`3o8@3oool2003o02<0oooo0P3o0?mW0?ooo`00E03oool2003o00L0oooo00<0e9/0
000000000000100000000`1b^^X0oooo0?ooo`130?ooo`@0003o203oool00`3oj[X0LP0009_Do`02
0?ooo`030?oDV`1b^^X0oooo00@0oooo00<0oooZ0;YbV`3Dool0603oool30?l0oad0oooo0P00o`0R
0?ooo`80o`3oJ@3oool005@0oooo0P00o`070?ooo`030?oojP2jLP0009_D00<0oooo00<0onZj09^j
jP3oool0AP3oool30000o`H0oooo00@0oooZ0;Yb000009/0e?oo0P3oool00`3oonX0^W:K0=Coo`05
0?ooo`030?oDV`00Vm@0oooo01X0oooo0P3o0?lK0?ooo`800?l0803oool20?l0of/0oooo001C0?oo
o`<00?l0203oool00`3oom@0V`0007:jjP020?ooo`030?oojP3De>X0oooo04L0oooo0`000?l40?oo
o`0;0?oojP2jLP0000000000000009/0e?oo0?oojP2jLP000000001b^P3Zool0103oool00`3oom@0
V`1b0;[Zo`0L0?ooo`80o`3o6@3oool2003o01d0oooo0`3o0?m]0?ooo`00D`3oool2003o00X0oooo
00<0onZj0780002Ke?l0C03oool40000oa40oooo00<0oooD09/0001b^^X07P3oool20?l0oaL0oooo
0P00o`0K0?ooo`80o`3oL03oool005<0oooo0P00o`0;0?ooo`030?oDV`000780^^[o04`0oooo1000
0?l;0?ooo`030?oD^P2jj_l0oooo0080oooo00<0onZj0780001b^^X0803oool30?l0oa@0oooo0P00
o`0I0?ooo`80o`3oLP3oool005<0oooo0P00o`080?ooo`070?oZ^P2je?l0oooo0?ooo`3Z^W80002K
0=Coo`1=0?ooo`<0003o2P3oool0203oonX0^W9b0;[Zo`3oool0oooD09/0000009/0e?oo8`3oool2
0?l0oa40oooo0P00o`0H0?ooo`80o`3oM03oool00580oooo0`00o`080?ooo`030?ooe02j^^X0oooo
0080oooo00<0e9/0001b^P3Zool0C@3oool40000o`T0oooo00H0oooZ0;Yb0000000000000000V`3D
oolV0?ooo`80o`3o3`3oool2003o01D0oooo0`3o0?mf0?ooo`00DP3oool2003o00T0oooo00<0oooD
09/000000000100000000`00Vm@0oooo0?ooo`1<0?ooo`@0003o=P3oool20?l0o`d0oooo0P00o`0C
0?ooo`80o`3oN@3oool00580oooo0P00o`1Q0?ooo`<0003o=`3oool30?l0o`X0oooo0P00o`0A0?oo
o`80o`3oN`3oool00540oooo0`00o`1R0?ooo`<0003o>@3oool20?l0o`L0oooo0P00o`0@0?ooo`80
o`3oO@3oool00540oooo0P00o`1T0?ooo`@0003o>@3oool20?l0o`D0oooo0P00o`0>0?ooo`80o`3o
O`3oool00540oooo0P00o`1U0?ooo`@0003o>P3oool30?l0o`80oooo0P00o`0;0?ooo`<0o`3oP@3o
ool00500oooo0`00o`1W0?ooo`<0003o?03oool20?l0o`800?l02@3oool20?l0oh@0oooo001@0?oo
o`800?l0J@3oool40000oc`0oooo0P00o`070?ooo`80o`3oQP3oool00500oooo0P00o`1Z0?ooo`@0
003o>P3oool2003o00030?ooo`3o0?l0o`3o00<0oooo0P3o0?n80?ooo`00D03oool2003o06`0oooo
0`000?li0?ooo`800?l00`3oool30?l0ohX0oooo001?0?ooo`<00?l0K@3oool30000ocP0oooo0P00
o`2@0?ooo`00C`3oool2003o06l0oooo10000?lf0?ooo`800?l0T03oool004l0oooo0P00o`1`0?oo
o`@0003o=03oool2003o0940oooo001>0?ooo`<00?l0LP3oool30000oc<0oooo0P00o`2A0?ooo`00
CP3oool2003o07@0oooo10000?l=0?ooo`T000006`3oool2003o0940oooo001>0?ooo`800?l0M@3o
ool40000o`/0oooo00<000000000S@0000001`0004h00`000000oooo0?ooo`0H0?ooo`800?l0T@3o
ool004d0oooo0`00o`1g0?ooo`<0003o203oool2000000<0002=00<000000000CP0004h0100004h0
0`000000oooo0?ooo`0H0?ooo`800?l0T@3oool004d0oooo0P00o`1i0?ooo`<0003o1P3oool00`00
0000002=0000S@040000S@030000000004h0001>00@0001>00<000000?ooo`3oool05P3oool2003o
0980oooo001=0?ooo`800?l0NP3oool40000o`<0oooo00<000000000S@0008d01@0008d00`000000
001>0000CP040000CP030000003oool0oooo01H0oooo0P00o`2B0?ooo`00C@3oool2003o07/0oooo
10000?l2000000T0002=00<000000000CP0004h0100004h00`000000oooo0?ooo`0E0?ooo`800?l0
TP3oool004`0oooo0`00o`1m0?ooo`<0003o2`0008d00`000000001>0000CP040000CP030000003o
ool0oooo01@0oooo0P00o`2B0?ooo`00C03oool2003o07h0oooo00<000000000o`0008d0300008d0
0`000000001>0000CP030000CP030000003oool0oooo00h0oooo2000002B0?ooo`00C03oool2003o
07h0oooo0`00000=0000S@030000000004h0001>00<0001>00<000000?ooo`3oool02`3oool30000
00@007<000<00?l000000000X`000P00002@0?ooo`00B`3oool3003o07d0oooo00D000000000]P00
0;H0002f0000000=0000S@030000000004h0001>00<0001>00<000000?ooo`3oool02P3oool00`00
000001h000000005001c000400000000X`000:<0002S00800000SP3oool004/0oooo0P00o`1n0?oo
o`03000000000;H0002f0080002f00<000000000S@0008d02`0008d00`000000001>0000CP020000
CP030000003oool0oooo00X0oooo00<00000000N000000001000L`000`0000000:<0002S0003002S
00800000S@3oool004/0oooo0P00o`1n0?ooo`03000000000;H0002f00<0002f0P00000;0000S@03
0000000004h0001>00<0001>00<000000?ooo`3oool02@3oool00`00000001h000000004001c0003
00000000X`000:<000800:<000<00000003T00000000S@3oool004/0oooo0P00o`1m0?ooo`030000
00000;H0002f00H0002f00<000000000S@0008d02@0008d00`000000001>0000CP020000CP030000
003oool0oooo00T0oooo00<00000000N000000001000L`000`0000000:<0002S0002002S00040000
0000i0000>@0000008`0oooo001:0?ooo`<00?l0O@3oool00`000000002f0000]P070000]P800000
2P0008d00`000000001>0000CP020000CP030000003oool0oooo00P0oooo00<00000000N00000000
1000L`001@0000000:<0002S0000X`00000000800>@000<000000?ooo`3oool0R`3oool004X0oooo
0P00o`1n0?ooo`03000000000;H0002f00T0002f00<000000000S@0008d0200008d00`000000001>
0000CP020000CP030000003oool0oooo00L0oooo00<00000000N000000000`00L`000`0000000:<0
002S0002002S000400000000i0000>@0000008d0oooo001:0?ooo`800?l0OP3oool00`000000002f
0000]P0:0000]P030000000008d0002=00P0002=00D000000000CP0004h0001>0000000:0?ooo`80
00000`00L`001@0000000:<0002S0000X`00000000800>@000<000000?ooo`3oool0S03oool004D0
oooo10000003003o07d0oooo00<000000000]P000;H030000;H2000000T0002=00D000000000CP00
04h0001>000000090?ooo`8000000`00L`001@0000000:<0002S0000X`00000000800>@000<00000
0?ooo`3oool0S03oool004<0oooo0`000004001e0003003o00000000000007`0oooo0P00000?0000
]P030000000008d0002=00H0002=00D000000000CP0004h0001>000000090?ooo`8000000`00L`00
100000000:<0002S00000002003T00030000003oool0oooo08d0oooo00130?ooo`03000000000`00
000000<007D000@00000002P0000X0000:000P00001k0?ooo`<000003P000;H2000000L0002=00D0
00000000CP0004h0001>000000080?ooo`8000000`00L`001P0000000:<0002S000000000>@00000
0900oooo00130?ooo`03000000000`00000000<007D000<00000002P0000X0000P00X003000007T0
oooo00<000000000i@000>D00`00000=0000]P030000000008d0002=00D0002=00D000000000CP00
04h0001>000000070?ooo`8000000P00L`001`0000000:<0002S0000X`000000003T00000000T03o
ool004<0oooo00<000000003000000000`00M@001@0000000:00002P0000X000000000<00=H000<0
00000?ooo`3oool0M`3oool00`000000003U0000i@020000i@80000030000;H00`000000002=0000
S@050000S@040000000004h0001>000000L0oooo0P000002001c000600000000X`000:<000000000
i0000000T@3oool004<0oooo00<000000003000000000`00M@001@0000000:00002P0000X0000000
00800=H000<000000?ooo`3oool0N03oool00`000000003U0000i@040000i@8000002`000;H20000
00H0002=00@000000000CP0004h000001P3oool20000008007<000H00000002S0000X`000000003T
0000002A0?ooo`00@`3oool00`00000000<000000002001e000500000000X0000:00002P00000000
0`00eP000`000000oooo0?ooo`1i0?ooo`03000000000>D0003U00D0003U0`00000:0000]P030000
000008d0002=00@0002=00@000000000CP0004h000001@3oool20000008007<000D00000002S0000
00000>@00000002B0?ooo`00@`3oool00`00000000<000000002001e000500000000X0000:00002P
000000000P00eP000`000000oooo0?ooo`1j0?ooo`03000000000>D0003U00P0003U0P0000090000
]P8000001@0008d00`000000001>000000050?ooo`80000000@007<000000000X`000:<00P00002C
0?ooo`00@`3oool00`00000000<000000002001e000400000000X0000:00000000800=H000<00000
0?ooo`3oool0O03oool2000000X0003U0`0000080000]P030000000008d0002=0080002=00@00000
0000CP0004h00000103oool200000006001c000000000:<000000000i0000000T`3oool004<0oooo
00<000000003000000000P00M@00100000000:00002P00000002003F00030000003oool0oooo07h0
oooo100000090000i@8000001`000;H2000000<0002=00<000000000CP000000103oool200000003
001c000000000:<000800000U03oool004<0oooo00D0000000030000000007D000000002002P0004
00000000eP000=H0000008D0oooo100000070000i@8000001`000;H01`000000002=0000S@0008d0
00000000CP0000000`3oool200000003001c000000000:<000800000U03oool004<0oooo00D00000
00030000000007D000000002002P000300000000eP00000008X0oooo0`0000060000i@<000001@00
0;H01`000000002=0000S@0008d000000000CP0000000P3oool200000004001c0000000000000000
09D0oooo00130?ooo`8000000P00M@000`0000000:0000000002003F00030000003oool0oooo08/0
oooo100000050000i@80000010000;H200000080002=0P0000030?ooo`80000000<00:<000000000
0000U@3oool004@0oooo00P00000001e0000M@000000002P000000000=H000000980oooo10000003
0000i@<000000`000;H00`000000002=0000S@0200000080oooo1000002F0?ooo`00A03oool00`00
000007D000000002002P00800000U`3oool400000080003U0P0000020000]P80000000@0002=0000
00000000oooo0`00002G0?ooo`00A03oool01`00000007D000000000X0000000003F00000000V`3o
ool3000000030000i@00000000000080002f0`000000103oool0000000000000002G0?ooo`00A03o
ool01000000007D000000000X002000009l0oooo2`00002H0?ooo`00A03oool01P00000007D00000
000000000=H000000:<0oooo1`00002H0?ooo`00A03oool200000003002P0000000000000:P0oooo
0P0000001P3oonX0^W80000000000000002K0=Cooi<0oooo00140?ooo`@00000[@3oool00`3DV`00
07:j0>[oo`2D0?ooo`00A03oool400000:d0oooo00<0e9/0001b^P3Zool0U03oool004@0oooo0`00
002^0?ooo`030=BK0000L[X0j_oo09@0oooo00140?ooo`800000[`3oool00`3DV`00079b07800002
0000000307:jjP3oool0oooo08l0oooo00140?ooo`800000[`3oool01`3DV`00000009_Do`3oool0
oooD09/0001b^^X0T03oool004@0oooo00<000000?ooo`3oool0[P3oool00`3DV`0007:j0>[oo`02
0?ooo`030?oDV`0009/0e?oo08l0oooo003e0?ooo`030=BK0000L[X0j_oo0080oooo00<0onZj0780
002Ke?l0S`3oool00?D0oooo00<0e9/0001b^P3Zool00P3oool00`3oj[X0LP0009_Do`2?0?ooo`00
m@3oool00`3DV`00002K0=Coo`020?ooo`030>ZjLP000780^^[o08l0oooo003c0?ooo`0:0?ooe02K
00000000001bLP1bL[X0j_oo0?oZ^P1b000007:j0>[oohl0oooo003d0?ooo`080?oojP2jLP0007:j
0>[Z^P1b000000000000V`3Doon@0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?ooo`00o`3ooon=0?oo
o`00\
\>"],
  ImageRangeCache->{{{0, 395.25}, {430.875, 0}} -> {0.0844874, 0.0839214, \
0.00318916, 0.00318916}}],

Cell[BoxData[
    InterpretationBox[\("{v1,v2} es una base ortonormal de \[CapitalPi]\n\
w1+w2 es la proyecci\[OAcute]n ortogonal de p sobre el plano \[CapitalPi]\n\
z=p-w1-w2 es un vector ortogonal a \[Pi]\nTz se obtiene por \
traslaci\[OAcute]n de z\nLa distancia del punto p al plano \[Pi] es igual a \
||Tz||=||z||= "\[InvisibleSpace]2.`\),
      SequenceForm[ 
      "{v1,v2} es una base ortonormal de \[CapitalPi]\nw1+w2 es la proyecci\
\[OAcute]n ortogonal de p sobre el plano \[CapitalPi]\nz=p-w1-w2 es un vector \
ortogonal a \[Pi]\nTz se obtiene por traslaci\[OAcute]n de z\nLa distancia \
del punto p al plano \[Pi] es igual a ||Tz||=||z||= ", 2.0],
      Editable->False]], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 6", "Exercise"],

Cell[TextData[{
  "a) Calcula el volumen del paralelep\[IAcute]pedo determinado por los \
vectores ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, 0, 6)\), \ \((2, 3, \(-8\))\), \ 
      \((8, \(-5\), 6)\)\)]],
  ".\nb) Calcula el volumen del paralelep\[IAcute]pedo con aristas \
concurrentes ",
  Cell[BoxData[
      FormBox[
        StyleBox[\(AB, \ AC, \ AD\),
          FontSlant->"Italic"], TraditionalForm]]],
  " siendo ",
  Cell[BoxData[
      \(TraditionalForm\`A = \((1, 1, 1)\), \ B = \ \((2, 0, 3)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`C = \((4, 1, 7)\), \ 
      D = \((3, \(-1\), \(-2\))\)\)]],
  "."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 7", "Exercise"],

Cell[TextData[{
  "Prueba que la m\[IAcute]nima distancia de un punto ",
  Cell[BoxData[
      \(TraditionalForm\`P = \((a, b, c)\)\)]],
  " al plano de ecuaci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`A\ x + B\ y + C\ z + D = 0\)]],
  " es igual a "
}], "ExerciseText"],

Cell[BoxData[
    \(TraditionalForm\`\(\(|\)\(A\ a\  + \ B\ b\  + C\ c\  + \ D\)\(|\)\)\/\(\
\(||\)\((A, B, C)\)\(||\)\(\ \)\)\)], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Sugerencia. Haz una traslaci\[OAcute]n. Ten en cuenta que el vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((A, B, C)\)\)]],
  " es ortogonal al plano."
}], "ExerciseText"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Curvas en el plano", "Section"],

Cell[TextData[{
  "En todo lo que sigue consideraremos funciones de una o varias variables \
con derivada continua o con derivadas parciales de primer orden continuas \
respectivamente.\nUna curva \[CapitalGamma] en el plano puede venir dada de \
tres formas:\n",
  StyleBox["a)",
    FontWeight->"Bold"],
  " Como la gr\[AAcute]fica de una funci\[OAcute]n ",
  Cell[BoxData[
      \(TraditionalForm\`f : I \[Rule] \[DoubleStruckCapitalR]\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  " es un intervalo de \[DoubleStruckCapitalR]: ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalGamma] = {\((x, f(x))\) : x \[Element] I}\)]],
  ".\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " De forma impl\[IAcute]cita como el conjunto de puntos donde se anula una \
funci\[OAcute]n de dos variables: ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              
              FormBox[\(\[CapitalGamma] = {
                    \((x, y)\) \[Element] \[DoubleStruckCapitalR]\^2\),
                "TraditionalForm"], ":", \(g(x, y)\)}], "=", "0"}], "}"}], 
        TraditionalForm]]],
  ".\n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " Por medio de ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] I\)]],
  " siendo ",
  Cell[BoxData[
      \(TraditionalForm\`I\)]],
  " un intervalo de \[DoubleStruckCapitalR]: ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[CapitalGamma] = 
        \(\[Gamma](I) = {\((x(t), y(t))\) : t \[Element] I}\)\)]],
  ".\nObserva que ",
  StyleBox["a)",
    FontWeight->"Bold"],
  " es un caso particular de ",
  StyleBox["b)",
    FontWeight->"Bold"],
  "  pues la gr\[AAcute]fica de una funci\[OAcute]n ",
  StyleBox["f ",
    FontSlant->"Italic"],
  "es el conjunto de puntos donde se anula la funci\[OAcute]n de dos \
variables ",
  Cell[BoxData[
      \(TraditionalForm\`g(x, y) = f(x) - y\)]],
  ", y tambi\[EAcute]n es un caso particular de ",
  StyleBox["c)",
    FontWeight->"Bold"],
  "  pues ",
  StyleBox["la gr\[AAcute]fica de una funci\[OAcute]n  ",
    FontWeight->"Bold"],
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["  tiene como ecuaciones param\[EAcute]tricas  ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](x) = \((x, f(x))\)\)],
    FontWeight->"Bold"],
  ". "
}], "Text"],

Cell[TextData[{
  "Para cada uno de estos casos ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " tiene un comando que permite representar la curva dada:\n\
Plot[f[x],{x,a,b},opciones]  representa la gr\[AAcute]fica de la funci\
\[OAcute]n",
  StyleBox[" f ",
    FontSlant->"Italic"],
  "en el intervalo [a,b].\nImplicitPlot[g(x,y)==0,{x,a,b},opciones] \
representa la gr\[AAcute]fica de la curva ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                
                FormBox[
                  \({\((x, y)\) \[Element] \[DoubleStruckCapitalR]\^2\),
                  "TraditionalForm"], ":", \(g(x, y)\)}], "=", "0"}], ",", 
            " ", \(a \[LessEqual] x \[LessEqual] b\)}], "}"}], 
        TraditionalForm]]],
  ".\nParametricPlot[{x[t],y[t]},{t,a,b},opciones]  representa la \
gr\[AAcute]fica de la curva de ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  " para  ",
  Cell[BoxData[
      \(TraditionalForm\`t \[Element] \([a, b]\)\)]],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(f[x_] := \(1\/5\) Cos[x\^2] \[ExponentialE]\^Sin[2\ x]\), "\n", 
    \(\(graf1 = 
        Plot[f[x], {x, \(-2\), 3}, \n
          PlotRange -> {{\(-2.1\), 3.5}, {\(- .5\),  .5}}, \n
          AspectRatio -> Automatic, \nPlotStyle -> Thickness[ .004], \n\t
          Ticks -> None, ImageSize -> {407, \ 73}];\)\), "\n", 
    \( (*\ La\ gr\[AAcute]fica\ de\ una\ funci\[OAcute]n\ *) \)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .17857 
%%ImageSize: 407 73 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.178571 0.0892857 0.178571 [
[ 0 0 0 0 ]
[ 1 .17857 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .08929 m
1 .08929 L
s
.375 0 m
.375 .17857 L
s
0 0 m
1 0 L
1 .17857 L
0 .17857 L
closepath
clip
newpath
.004 w
.01786 .03953 m
.02221 .03596 L
.02627 .03346 L
.0286 .03237 L
.03073 .0316 L
.0319 .03125 L
.03317 .03094 L
.03438 .03071 L
.03549 .03055 L
.03656 .03045 L
.03771 .03038 L
.03879 .03036 L
.03978 .03039 L
.04094 .03046 L
.0416 .03052 L
.04221 .03059 L
.04451 .03097 L
.04576 .03125 L
.04694 .03155 L
.04914 .03222 L
.05408 .03419 L
.06396 .03963 L
.07305 .04577 L
.09358 .06073 L
.11272 .07315 L
.1306 .08211 L
.14778 .0883 L
.15741 .09089 L
.1662 .0928 L
.18409 .09566 L
.1942 .09683 L
.20355 .09772 L
.24036 .10038 L
.27576 .10317 L
.29389 .10517 L
.31345 .10806 L
.33223 .11177 L
.35201 .11697 L
.37052 .12325 L
.38774 .13046 L
.42435 .14948 L
.44301 .15976 L
.45284 .16469 L
.46325 .16917 L
.47254 .17223 L
.47508 .17287 L
.47781 .17347 L
.48018 .17389 L
.48275 .17425 L
.48396 .17438 L
Mistroke
.48525 .1745 L
.48647 .17458 L
.48757 .17463 L
.48871 .17467 L
.48993 .17468 L
.49109 .17466 L
.49215 .17463 L
.49318 .17457 L
.49414 .1745 L
.49633 .17428 L
.49845 .17398 L
.50073 .17356 L
.5057 .17229 L
.5103 .17068 L
.51534 .16843 L
.52068 .1655 L
.53956 .1511 L
.575 .11363 L
.5947 .09311 L
.60332 .08532 L
.61274 .07795 L
.6213 .07239 L
.63044 .06772 L
.6355 .0657 L
.64009 .0642 L
.64471 .06301 L
.64906 .06217 L
.65131 .06183 L
.65341 .06158 L
.65572 .06137 L
.65701 .06128 L
.65819 .06122 L
.65943 .06117 L
.66057 .06114 L
.66116 .06113 L
.66182 .06112 L
.66251 .06112 L
.66315 .06113 L
.66433 .06115 L
.66542 .06118 L
.6666 .06123 L
.66786 .0613 L
.66992 .06145 L
.67214 .06165 L
.67612 .06213 L
.68086 .06288 L
.68517 .06371 L
.70313 .0684 L
.72262 .0749 L
.76095 .0887 L
Mistroke
.78001 .09487 L
.78934 .09748 L
.79786 .09954 L
.80663 .10126 L
.81067 .10189 L
.81496 .10243 L
.81736 .10267 L
.81952 .10284 L
.82057 .10292 L
.8217 .10298 L
.82277 .10303 L
.82376 .10307 L
.82492 .10311 L
.82553 .10312 L
.82619 .10313 L
.82688 .10314 L
.82753 .10314 L
.82875 .10313 L
.8299 .10311 L
.83096 .10308 L
.83212 .10303 L
.83335 .10296 L
.83559 .1028 L
.83794 .10256 L
.84214 .10199 L
.84667 .10112 L
.85162 .09988 L
.8605 .09682 L
.86876 .09302 L
.88795 .081 L
.90538 .06827 L
.91071 .06468 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{407, 73},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40009R0000KB000`400?l00000o`00003oi03oool0
0`000000oooo0?ooo`3o0?ooog`0oooo003T0?ooo`030000003oool0oooo0?l0ooooO03oool00>@0
oooo00<000000?ooo`3oool0o`3oooml0?ooo`00i03oool00`000000oooo0?ooo`3o0?ooog`0oooo
003T0?ooo`030000003oool0oooo0?l0ooooO03oool00>@0oooo00<000000?ooo`3oool0o`3oooml
0?ooo`00i03oool00`000000oooo0?ooo`3o0?ooog`0oooo003T0?ooo`030000003oool0oooo0?l0
ooooO03oool00>@0oooo00<000000?ooo`3oool0o`3oooml0?ooo`00i03oool00`000000oooo0?oo
o`3o0?ooog`0oooo003T0?ooo`030000003oool0oooo0?l0ooooO03oool00>@0oooo00<000000?oo
o`3oool0o`3oooml0?ooo`00i03oool00`000000oooo0?ooo`3o0?ooog`0oooo003T0?ooo`030000
003oool0oooo0?l0ooooO03oool00>@0oooo00<000000?ooo`3oool0o`3oooml0?ooo`00i03oool0
0`000000oooo0?ooo`3o0?ooog`0oooo003T0?ooo`030000003oool0oooo0?l0ooooO03oool00>@0
oooo00<000000?ooo`3oool0o`3oooml0?ooo`005P3oool400000<X0oooo00<000000?ooo`3oool0
o`3oooml0?ooo`004P3oool=00000<D0oooo00<000000?ooo`3oool0o`3oooml0?ooo`003`3oool8
000000030?ooo`000000000000P00000`P3oool00`000000oooo0?ooo`3o0?ooog`0oooo000>0?oo
o`D000002`3oool600000<00oooo00<000000?ooo`3oool0o`3oooml0?ooo`003@3oool300000140
oooo1@00002n0?ooo`030000003oool0oooo0?l0ooooO03oool000/0oooo1000000D0?ooo`D00000
_03oool00`000000oooo0?ooo`3o0?ooog`0oooo000:0?ooo`@000005`3oool400000;/0oooo00<0
00000?ooo`3oool0o`3oooml0?ooo`002`3oool00`000000oooo0?ooo`0I0?ooo`@00000^@3oool0
0`000000oooo0?ooo`3o0?ooog`0oooo000X0?ooo`@00000^03oool00`000000oooo0?ooo`3o0?oo
og`0oooo000Z0?ooo`@00000]P3oool00`000000oooo0?ooo`3o0?ooog`0oooo000[0?ooo`@00000
]@3oool00`000000oooo0?ooo`3o0?ooog`0oooo000]0?ooo`@00000/`3oool00`000000oooo0?oo
o`3o0?ooog`0oooo000^0?ooo`@00000/P3oool00`000000oooo0?ooo`3o0?ooog`0oooo000`0?oo
o`<00000/@3oool00`000000oooo0?ooo`3o0?ooog`0oooo000a0?ooo`@00000[`3oool00`000000
oooo0?ooo`3o0?ooog`0oooo000b0?ooo`@00000[P3oool00`000000oooo0?ooo`3o0?ooog`0oooo
000d0?ooo`<00000[@3oool00`000000oooo0?ooo`3o0?ooog`0oooo000e0?ooo`@00000Z`3oool0
0`000000oooo0?ooo`3o0?ooog`0oooo000f0?ooo`@00000ZP3oool00`000000oooo0?ooo`3o0?oo
og`0oooo000h0?ooo`@00000Z03oool00`000000oooo0?ooo`2U0?oooa000000aP3oool003T0oooo
1000002W0?ooo`030000003oool0oooo09h0oooo7@0000280?ooo`030000003oool0oooo03D0oooo
000k0?ooo`@00000Y@3oool00`000000oooo0?ooo`2L0?ooo`X000003P3oool:000008<0oooo1000
000f0?ooo`00?03oool500000:<0oooo00<000000?ooo`3oool0V@3oool6000001/0oooo2000001n
0?ooo`@00000=`3oool003h0oooo1@00002Q0?ooo`030000003oool0oooo09L0oooo1P00000Q0?oo
o`L00000NP3oool3000003T0oooo00100?ooo`@00000X03oool00`000000oooo0?ooo`2E0?ooo`D0
0000:03oool7000007@0oooo1000000j0?ooo`00@P3oool4000009h0oooo00<000000?ooo`3oool0
T`3oool5000002d0oooo1`00001`0?ooo`@00000>`3oool004<0oooo1@00002L0?ooo`030000003o
ool0oooo0940oooo1@00000b0?ooo`L00000J`3oool4000003d0oooo00150?ooo`D00000VP3oool0
0`000000oooo0?ooo`2@0?ooo`@00000=`3oool7000006L0oooo1000000n0?ooo`00A`3oool40000
09T0oooo00<000000?ooo`3oool0SP3oool4000003`0oooo1`00001S0?ooo`<00000@03oool004T0
oooo1000002G0?ooo`030000003oool0oooo08d0oooo100000100?ooo`L00000GP3oool400000440
oooo001:0?ooo`D00000U@3oool00`000000oooo0?ooo`2<0?ooo`<00000A@3oool7000005X0oooo
100000120?ooo`00C03oool5000009<0oooo00<000000?ooo`3oool0RP3oool4000004T0oooo1`00
001E0?ooo`@00000A03oool004h0oooo1@00002A0?ooo`030000003oool0oooo08T0oooo1000001=
0?ooo`H00000DP3oool4000004D0oooo001@0?ooo`H00000SP3oool00`000000oooo0?ooo`280?oo
o`<00000DP3oool6000004d0oooo100000170?ooo`00DP3oool6000008`0oooo00<000000?ooo`3o
ool0Q`3oool3000005D0oooo1`0000190?ooo`@00000B03oool005D0oooo1P0000290?ooo`030000
003oool0oooo08H0oooo0`00001I0?ooo`L00000A03oool4000004X0oooo003o00000?l00000H`00
00010?ooo`00FP3oool;000007l0oooo00<000000?ooo`3oool0Q03oool300000640oooo1P00000l
0?ooo`@00000C@3oool00600oooo2`00001i0?ooo`030000003oool0oooo08<0oooo0`00001U0?oo
o`H00000>03oool4000004h0oooo001U0?ooo`/00000M03oool00`000000oooo0?ooo`220?ooo`<0
0000J03oool700000380oooo1@00001@0?ooo`00J`3oool;000006h0oooo00<000000?ooo`3oool0
P@3oool3000006`0oooo2@00000[0?ooo`H00000D@3oool00700oooo5`00001M0?ooo`030000003o
ool0oooo0800oooo0`00001`0?ooo`/000008`3oool6000005@0oooo001f0?oooa`00000DP3oool0
0`000000oooo0?ooo`1o0?ooo`<00000M`3oool9000001d0oooo1P00001F0?ooo`00Q`3ooolF0000
04L0oooo00<000000?ooo`3oool0OP3oool3000007d0oooo1`00000D0?ooo`T00000F@3oool00980
oooo5P00000l0?ooo`030000003oool0oooo07d0oooo0`0000210?ooo``000001`3oool<000005/0
oooo002M0?oooaH00000<@3oool00`000000oooo0?ooo`1l0?ooo`<00000Q@3ooolF00000640oooo
002X0?oooa400000:`3oool00`000000oooo0?ooo`1k0?ooo`<00000SP3oool9000006H0oooo002c
0?ooo``000009@3oool00`000000oooo0?ooo`1j0?ooo`<00000oP3oool00;T0oooo3000000O0?oo
o`030000003oool0oooo07T0oooo0`00003o0?ooo`00_`3oool;000001X0oooo00<000000?ooo`3o
ool0N03oool300000?l0oooo0@3oool00<D0oooo2@00000F0?ooo`030000003oool0oooo07L0oooo
0`00003o0?ooo`80oooo003:0?ooo`P000004P3oool00`000000oooo0?ooo`1f0?ooo`<00000o`3o
ool30?ooo`00cP3oool8000000h0oooo00<000000?ooo`3oool0M@3oool300000?l0oooo103oool0
0=80oooo2000000:0?ooo`030000003oool0oooo07@0oooo0`00003o0?ooo`D0oooo003F0?ooo`L0
00001`3oool00`000000oooo0?ooo`1c0?ooo`<00000o`3oool60?ooo`00f@3oool7000000@0oooo
00<000000?ooo`3oool0LP3oool300000?l0oooo1`3oool00=`0oooo1`0000000`3oool000000?oo
o`1b0?ooo`<00000o`3oool80?ooo`00g`3oool600000780oooo0`00003o0?ooo`T0oooo003R0?oo
o`H00000KP3oool300000?l0oooo2P3oool00>@0oooo1P00001[0?ooo`<00000o`3oool;0?ooo`00
i03oool00`000000oooo0?ooo`06000006L0oooo0`00003o0?ooo``0oooo003T0?ooo`030000003o
ool0oooo0080oooo1P00001T0?ooo`<00000o`3oool=0?ooo`00i03oool00`000000oooo0?ooo`05
0?ooo`D00000HP3oool200000?l0oooo3P3oool00>@0oooo00<000000?ooo`3oool01`3oool40000
0600oooo0P00003o0?ooo`l0oooo003T0?ooo`030000003oool0oooo00T0oooo1000001M0?ooo`<0
0000o`3oool?0?ooo`00i03oool00`000000oooo0?ooo`0:0?ooo`D00000FP3oool300000?l0oooo
403oool00>@0oooo00<000000?ooo`3oool0303oool5000005L0oooo0`00003o0?oooa40oooo003T
0?ooo`030000003oool0oooo00h0oooo1@00001D0?ooo`<00000o`3ooolB0?ooo`00i03oool00`00
0000oooo0?ooo`0@0?ooo`D00000D@3oool300000?l0oooo4`3oool00>@0oooo00<000000?ooo`3o
ool04P3oool4000004l0oooo0`00003o0?oooa@0oooo003T0?ooo`030000003oool0oooo01@0oooo
1000001<0?ooo`<00000o`3ooolE0?ooo`00i03oool00`000000oooo0?ooo`0E0?ooo`D00000B@3o
ool300000?l0oooo5P3oool00>@0oooo00<000000?ooo`3oool05`3oool5000004H0oooo0`00003o
0?oooaL0oooo003T0?ooo`030000003oool0oooo01T0oooo1@0000130?ooo`<00000o`3ooolH0?oo
o`00i03oool00`000000oooo0?ooo`0K0?ooo`D00000@03oool300000?l0oooo6@3oool00>@0oooo
00<000000?ooo`3oool07@3oool5000003d0oooo0`00003o0?oooaX0oooo003T0?ooo`030000003o
ool0oooo01l0oooo1@00000i0?ooo`@00000o`3ooolK0?ooo`00i03oool00`000000oooo0?ooo`0Q
0?ooo`D00000=P3oool400000?l0oooo703oool00>@0oooo00<000000?ooo`3oool08`3oool50000
03<0oooo0`00003o0?oooah0oooo003T0?ooo`030000003oool0oooo02D0oooo1@00000`0?ooo`<0
0000o`3ooolO0?ooo`00i03oool00`000000oooo0?ooo`0W0?ooo`D00000;03oool400000?l0oooo
803oool00>@0oooo00<000000?ooo`3oool0:@3oool5000002T0oooo1000003o0?ooob40oooo003T
0?ooo`030000003oool0oooo02/0oooo1@00000V0?ooo`<00000o`3ooolS0?ooo`00i03oool00`00
0000oooo0?ooo`0]0?ooo`D000008@3oool500000?l0oooo903oool00>@0oooo00<000000?ooo`3o
ool0;`3oool5000001d0oooo1P00003o0?ooobD0oooo003T0?ooo`030000003oool0oooo0340oooo
1P00000I0?ooo`@00000o`3ooolX0?ooo`00i03oool00`000000oooo0?ooo`0c0?ooo`L000004`3o
ool500000?l0oooo:P3oool00>@0oooo00<000000?ooo`3oool0=P3oool8000000X0oooo2@00003o
0?ooob/0oooo003T0?ooo`030000003oool0oooo03T0oooo5@00003o0?ooobh0oooo003T0?ooo`03
0000003oool0oooo03d0oooo3000003o0?oooc<0oooo003T0?ooo`030000003oool0oooo0?l0oooo
O03oool00001\
\>"],
  ImageRangeCache->{{{0, 609.5}, {108.5, 0}} -> {-2.10877, -0.500006, \
0.0138249, 0.0138249}}]
}, Open  ]],

Cell[BoxData[
    \(\(\(<< \ Graphics`ImplicitPlot`\)\(\ \)\( (*\ 
      Hay\ que\ cargar\ este\ paquete\ para\ poder\ usar\ el\ comando\ *) \
\)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(g[x_, y_] := x\^2\/9 + y\^2\/3 - 1\n
    \(\(graf2 = ImplicitPlot[g[x, y] == 0, {x, \(-3\), 3}];\)\(\n\)
    \)\)\( (*\ 
      Una\ curva\ definida\ impl\[IAcute]citamente\ *) \)\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .57735 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.288675 0.15873 [
[.02381 .27618 -6 -9 ]
[.02381 .27618 6 0 ]
[.18254 .27618 -6 -9 ]
[.18254 .27618 6 0 ]
[.34127 .27618 -6 -9 ]
[.34127 .27618 6 0 ]
[.65873 .27618 -3 -9 ]
[.65873 .27618 3 0 ]
[.81746 .27618 -3 -9 ]
[.81746 .27618 3 0 ]
[.97619 .27618 -3 -9 ]
[.97619 .27618 3 0 ]
[.4875 .05058 -24 -4.5 ]
[.4875 .05058 0 4.5 ]
[.4875 .12994 -12 -4.5 ]
[.4875 .12994 0 4.5 ]
[.4875 .20931 -24 -4.5 ]
[.4875 .20931 0 4.5 ]
[.4875 .36804 -18 -4.5 ]
[.4875 .36804 0 4.5 ]
[.4875 .44741 -6 -4.5 ]
[.4875 .44741 0 4.5 ]
[.4875 .52677 -18 -4.5 ]
[.4875 .52677 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .57735 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .28868 m
.02381 .29493 L
s
[(-3)] .02381 .27618 0 1 Mshowa
.18254 .28868 m
.18254 .29493 L
s
[(-2)] .18254 .27618 0 1 Mshowa
.34127 .28868 m
.34127 .29493 L
s
[(-1)] .34127 .27618 0 1 Mshowa
.65873 .28868 m
.65873 .29493 L
s
[(1)] .65873 .27618 0 1 Mshowa
.81746 .28868 m
.81746 .29493 L
s
[(2)] .81746 .27618 0 1 Mshowa
.97619 .28868 m
.97619 .29493 L
s
[(3)] .97619 .27618 0 1 Mshowa
.125 Mabswid
.05556 .28868 m
.05556 .29243 L
s
.0873 .28868 m
.0873 .29243 L
s
.11905 .28868 m
.11905 .29243 L
s
.15079 .28868 m
.15079 .29243 L
s
.21429 .28868 m
.21429 .29243 L
s
.24603 .28868 m
.24603 .29243 L
s
.27778 .28868 m
.27778 .29243 L
s
.30952 .28868 m
.30952 .29243 L
s
.37302 .28868 m
.37302 .29243 L
s
.40476 .28868 m
.40476 .29243 L
s
.43651 .28868 m
.43651 .29243 L
s
.46825 .28868 m
.46825 .29243 L
s
.53175 .28868 m
.53175 .29243 L
s
.56349 .28868 m
.56349 .29243 L
s
.59524 .28868 m
.59524 .29243 L
s
.62698 .28868 m
.62698 .29243 L
s
.69048 .28868 m
.69048 .29243 L
s
.72222 .28868 m
.72222 .29243 L
s
.75397 .28868 m
.75397 .29243 L
s
.78571 .28868 m
.78571 .29243 L
s
.84921 .28868 m
.84921 .29243 L
s
.88095 .28868 m
.88095 .29243 L
s
.9127 .28868 m
.9127 .29243 L
s
.94444 .28868 m
.94444 .29243 L
s
.25 Mabswid
0 .28868 m
1 .28868 L
s
.5 .05058 m
.50625 .05058 L
s
[(-1.5)] .4875 .05058 1 0 Mshowa
.5 .12994 m
.50625 .12994 L
s
[(-1)] .4875 .12994 1 0 Mshowa
.5 .20931 m
.50625 .20931 L
s
[(-0.5)] .4875 .20931 1 0 Mshowa
.5 .36804 m
.50625 .36804 L
s
[(0.5)] .4875 .36804 1 0 Mshowa
.5 .44741 m
.50625 .44741 L
s
[(1)] .4875 .44741 1 0 Mshowa
.5 .52677 m
.50625 .52677 L
s
[(1.5)] .4875 .52677 1 0 Mshowa
.125 Mabswid
.5 .06645 m
.50375 .06645 L
s
.5 .08233 m
.50375 .08233 L
s
.5 .0982 m
.50375 .0982 L
s
.5 .11407 m
.50375 .11407 L
s
.5 .14582 m
.50375 .14582 L
s
.5 .16169 m
.50375 .16169 L
s
.5 .17756 m
.50375 .17756 L
s
.5 .19344 m
.50375 .19344 L
s
.5 .22518 m
.50375 .22518 L
s
.5 .24106 m
.50375 .24106 L
s
.5 .25693 m
.50375 .25693 L
s
.5 .2728 m
.50375 .2728 L
s
.5 .30455 m
.50375 .30455 L
s
.5 .32042 m
.50375 .32042 L
s
.5 .33629 m
.50375 .33629 L
s
.5 .35217 m
.50375 .35217 L
s
.5 .38391 m
.50375 .38391 L
s
.5 .39979 m
.50375 .39979 L
s
.5 .41566 m
.50375 .41566 L
s
.5 .43153 m
.50375 .43153 L
s
.5 .46328 m
.50375 .46328 L
s
.5 .47915 m
.50375 .47915 L
s
.5 .49502 m
.50375 .49502 L
s
.5 .5109 m
.50375 .5109 L
s
.5 .03471 m
.50375 .03471 L
s
.5 .01883 m
.50375 .01883 L
s
.5 .00296 m
.50375 .00296 L
s
.5 .54264 m
.50375 .54264 L
s
.5 .55852 m
.50375 .55852 L
s
.5 .57439 m
.50375 .57439 L
s
.25 Mabswid
.5 0 m
.5 .57735 L
s
0 0 m
1 0 L
1 .57735 L
0 .57735 L
closepath
clip
newpath
.5 Mabswid
.02381 .28862 m
.02544 .26597 L
.0303 .24342 L
.03838 .22118 L
.04961 .19941 L
.06392 .17824 L
.0812 .15782 L
.10135 .1383 L
.12422 .11981 L
.14966 .10247 L
.17748 .0864 L
.20752 .07172 L
.23955 .05851 L
.27336 .04688 L
.30872 .0369 L
.34538 .02864 L
.3831 .02216 L
.42162 .0175 L
.46068 .01469 L
.5 .01375 L
.53932 .01469 L
.57838 .0175 L
.6169 .02216 L
.65462 .02864 L
.69128 .0369 L
.72664 .04688 L
.76045 .05851 L
.79248 .07172 L
.82252 .0864 L
.85034 .10247 L
.87578 .11981 L
.89865 .1383 L
.9188 .15782 L
.93608 .17824 L
.95039 .19941 L
.96162 .22118 L
.9697 .24342 L
.97456 .26597 L
.97619 .28862 L
s
.02381 .28873 m
.02544 .31138 L
.0303 .33393 L
.03838 .35617 L
.04961 .37794 L
.06392 .39911 L
.0812 .41953 L
.10135 .43905 L
.12422 .45754 L
.14966 .47488 L
.17748 .49095 L
.20752 .50563 L
.23955 .51884 L
.27336 .53047 L
.30872 .54045 L
.34538 .54871 L
.3831 .55519 L
.42162 .55985 L
.46068 .56266 L
.5 .5636 L
.53932 .56266 L
.57838 .55985 L
.6169 .55519 L
.65462 .54871 L
.69128 .54045 L
.72664 .53047 L
.76045 .51884 L
.79248 .50563 L
.82252 .49095 L
.85034 .47488 L
.87578 .45754 L
.89865 .43905 L
.9188 .41953 L
.93608 .39911 L
.95039 .37794 L
.96162 .35617 L
.9697 .33393 L
.97456 .31138 L
.97619 .28873 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 166.25},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0000nB000`400?l00000o`00003oe`3oool0
0`000000oooo0?ooo`3F0?ooo`00e`3oool300000=H0oooo003G0?ooo`030000003oool0oooo0=H0
oooo003G0?ooo`030000003oool0oooo0=H0oooo003G0?ooo`030000003oool0oooo0=H0oooo003G
0?ooo`030000003oool0oooo0=H0oooo00320?ooob/00000``3oool00;X0oooo2000000E0?ooo`03
0000003oool0oooo01<0oooo2000002k0?ooo`00/P3oool8000001d0oooo0`00000K0?ooo`P00000
/`3oool00:X0oooo2000000U0?ooo`030000003oool0oooo02<0oooo2000002[0?ooo`00X@3oool9
000002d0oooo00<000000?ooo`3oool0:`3oool900000:80oooo002I0?ooo`P00000=P3oool00`00
0000oooo0?ooo`0d0?ooo`P00000VP3oool009<0oooo1P00000n0?ooo`030000003oool0oooo03`0
oooo1P00002D0?ooo`00S`3oool4000004@0oooo00<000000?ooo`3oool0@P3oool400000900oooo
002;0?ooo`@00000B03oool00`000000oooo0?ooo`160?ooo`@00000S03oool008L0oooo1000001<
0?ooo`<00000BP3oool4000008P0oooo00240?ooo`<00000D03oool00`000000oooo0?ooo`1>0?oo
o`<00000Q@3oool00800oooo1000001C0?ooo`030000003oool0oooo0540oooo100000210?ooo`00
O03oool4000003P0oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`020?ooo`030=BK
0000000009_D00D0oooo00D0e9/0000000000000000009_Do`070?ooo`030000003oool0oooo05D0
oooo1000001m0?ooo`00N03oool4000003l0oooo00<0^W9b0;[Zo`3oool01@3oool00`3DV`000000
002Ke0040?ooo`070=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`060?ooo`030000003oool0oooo
05T0oooo1000001i0?ooo`00M@3oool3000004<0oooo00<0^W9b0;[Zo`3oool04@3oool00`3oe9/0
09_D0?ooo`050?ooo`030000003oool0oooo05d0oooo1000001e0?ooo`00LP3oool3000004H0oooo
00<0^W9b0;[Zo`3oool04@3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0oooo0640oooo
0`00001b0?ooo`00K`3oool3000003d0oooo00<0^W800000000000000`0000000`00L[X0oooo0?oo
o`030?ooo`030;YbLP2jj_l0oooo0140oooo00<0^W8009_Do`3oool01@3oool4000006<0oooo0P00
001`0?ooo`00K03oool3000004`0oooo00<0^W9b0;[Zo`3oool0303oool00`3oom@0V`0000000002
0000000307:jjP3oool0oooo00D0oooo00<000000?ooo`3oool0IP3oool3000006d0oooo001Y0?oo
o`<00000C`3oool00`2jLW80^^[o0?ooo`0<0?ooo`030?ooe02K09/0e?oo00X0oooo00<000000?oo
o`3oool0J@3oool3000006X0oooo001V0?ooo`<00000C`3oool01@3Z^W800000001b^P2jLW80^^[o
00d0oooo00<0oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`1/0?ooo`<00000I`3oool006@0
oooo0P00001D0?ooo`030>ZjLP000780^^[o00d0oooo00<0oooD09/0000000000P0000000`0009/0
e?oo0?ooo`050?ooo`030000003oool0oooo06l0oooo0P00001U0?ooo`00HP3oool2000007<0oooo
00<000000?ooo`3oool0L@3oool2000006<0oooo001O0?ooo`<00000M@3oool00`000000oooo0?oo
o`1c0?ooo`<00000H03oool005d0oooo0P00001h0?ooo`<00000MP3oool2000005h0oooo001K0?oo
o`800000NP3oool00`000000oooo0?ooo`1h0?ooo`800000G03oool005P0oooo0`00001l0?ooo`03
0000003oool0oooo07X0oooo0`00001I0?ooo`00EP3oool2000007l0oooo00<000000?ooo`3oool0
O@3oool2000005L0oooo001D0?ooo`800000P@3oool00`000000oooo0?ooo`1o0?ooo`800000E@3o
ool00580oooo0P0000230?ooo`030000003oool0oooo0840oooo0P00001C0?ooo`00D03oool20000
08D0oooo00<000000?ooo`3oool0P`3oool200000540oooo001>0?ooo`800000Q`3oool3000008D0
oooo0P00001?0?ooo`00C03oool2000008T0oooo00<000000?ooo`3oool0Q`3oool2000004d0oooo
001:0?ooo`800000R`3oool00`000000oooo0?ooo`290?ooo`800000B`3oool004P0oooo0P00002=
0?ooo`030000003oool0oooo08/0oooo0P0000190?ooo`00A`3oool00`000000oooo0?ooo`2=0?oo
o`030000003oool0oooo08d0oooo00<000000?ooo`3oool0AP3oool004D0oooo0P00002@0?ooo`03
0000003oool0oooo08h0oooo0P0000160?ooo`00@`3oool200000980oooo0`00002@0?ooo`800000
A03oool00440oooo0P00002D0?ooo`030000003oool0oooo0980oooo0P0000120?ooo`00@03oool0
0`000000oooo0?ooo`2D0?ooo`030000003oool0oooo09@0oooo00<000000?ooo`3oool0?`3oool0
03h0oooo0P00002G0?ooo`030000003oool0oooo09D0oooo0P00000o0?ooo`00?@3oool00`000000
oooo0?ooo`2G0?ooo`030000003oool0oooo09L0oooo00<000000?ooo`3oool0?03oool003`0oooo
00<000000?ooo`3oool0V03oool00`000000oooo0?ooo`2H0?ooo`030000003oool0oooo03/0oooo
000j0?ooo`800000V`3oool00`000000oooo0?ooo`2I0?ooo`800000>`3oool003T0oooo00<00000
0?ooo`3oool0V`3oool3000009/0oooo00<000000?ooo`3oool0>03oool003P0oooo00<000000?oo
o`3oool0W03oool00`000000oooo0?ooo`2L0?ooo`030000003oool0oooo03L0oooo000f0?ooo`80
0000W`3oool00`000000oooo0?ooo`2M0?ooo`800000=`3oool003D0oooo00<000000?ooo`3oool0
W`3oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo03@0oooo000d0?ooo`030000003o
ool0oooo09<0oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`040?ooo`030000003o
ool0oooo0:00oooo00<000000?ooo`3oool0<`3oool003<0oooo00<000000?ooo`3oool0U`3oool0
0`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo0:40oooo00<000000?ooo`3oool0<P3oool0
0380oooo00<000000?ooo`3oool0V03oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo
0:80oooo00<000000?ooo`3oool0<@3oool00300oooo0P00002K0?ooo`030;YbLP2jj_l0oooo00L0
oooo1000002R0?ooo`800000<@3oool002l0oooo00<000000?ooo`3oool0S`3oool00`2jLP000000
0000000300000003001b^P3oool0oooo00<0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo
0?ooo`2U0?ooo`030000003oool0oooo02h0oooo000^0?ooo`030000003oool0oooo09`0oooo00<0
^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`2V0?ooo`030000003oool0oooo02d0oooo000]
0?ooo`030000003oool0oooo09d0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`2W
0?ooo`030000003oool0oooo02`0oooo000/0?ooo`030000003oool0oooo09/0oooo00D0j[Yb0000
0000L[X0^W9b0;[Zo`080?ooo`030000003oool0oooo0:P0oooo00<000000?ooo`3oool0:`3oool0
02/0oooo00<000000?ooo`3oool0WP3oool00`3Z^W80001b0;[Zo`080?ooo`030000003oool0oooo
0:T0oooo00<000000?ooo`3oool0:P3oool002X0oooo00<000000?ooo`3oool0ZP3oool00`000000
oooo0?ooo`2Z0?ooo`030000003oool0oooo02T0oooo000Y0?ooo`030000003oool0oooo0:/0oooo
0`00002[0?ooo`030000003oool0oooo02P0oooo000W0?ooo`800000[P3oool00`000000oooo0?oo
o`2/0?ooo`800000:03oool002H0oooo00<000000?ooo`3oool0[P3oool00`000000oooo0?ooo`2^
0?ooo`030000003oool0oooo02D0oooo000U0?ooo`030000003oool0oooo0:l0oooo00<000000?oo
o`3oool0[`3oool00`000000oooo0?ooo`0T0?ooo`00903oool00`000000oooo0?ooo`2`0?ooo`03
0000003oool0oooo0;00oooo00<000000?ooo`3oool08`3oool002<0oooo00<000000?ooo`3oool0
/@3oool00`000000oooo0?ooo`2a0?ooo`030000003oool0oooo0280oooo000R0?ooo`030000003o
ool0oooo0;80oooo00<000000?ooo`3oool0/P3oool00`000000oooo0?ooo`0Q0?ooo`008@3oool0
0`000000oooo0?ooo`2c0?ooo`<00000/`3oool00`000000oooo0?ooo`0P0?ooo`00803oool00`00
0000oooo0?ooo`2d0?ooo`030000003oool0oooo0;@0oooo00<000000?ooo`3oool07`3oool001l0
oooo00<000000?ooo`3oool0]@3oool00`000000oooo0?ooo`2e0?ooo`030000003oool0oooo01h0
oooo000O0?ooo`030000003oool0oooo0;D0oooo00<000000?ooo`3oool0]@3oool00`000000oooo
0?ooo`0N0?ooo`007P3oool00`000000oooo0?ooo`2f0?ooo`030000003oool0oooo0;H0oooo00<0
00000?ooo`3oool07@3oool001d0oooo00<000000?ooo`3oool0]`3oool00`000000oooo0?ooo`2g
0?ooo`030000003oool0oooo01`0oooo000L0?ooo`030000003oool0oooo0;P0oooo00<000000?oo
o`3oool0^03oool00`000000oooo0?ooo`0K0?ooo`006`3oool00`000000oooo0?ooo`2i0?ooo`<0
0000^@3oool00`000000oooo0?ooo`0J0?ooo`006P3oool00`000000oooo0?ooo`2j0?ooo`030000
003oool0oooo0;X0oooo00<000000?ooo`3oool06@3oool001X0oooo00<000000?ooo`3oool0^P3o
ool00`000000oooo0?ooo`2j0?ooo`030000003oool0oooo01T0oooo000I0?ooo`030000003oool0
oooo0;/0oooo00<000000?ooo`3oool0^`3oool00`000000oooo0?ooo`0H0?ooo`00603oool00`00
0000oooo0?ooo`2l0?ooo`030000003oool0oooo0;`0oooo00<000000?ooo`3oool05`3oool001P0
oooo00<000000?ooo`3oool0_03oool00`000000oooo0?ooo`2l0?ooo`030000003oool0oooo01L0
oooo000G0?ooo`030000003oool0oooo0;d0oooo0`00002m0?ooo`030000003oool0oooo01H0oooo
000F0?ooo`030000003oool0oooo0;h0oooo00<000000?ooo`3oool0_P3oool00`000000oooo0?oo
o`0E0?ooo`005P3oool00`000000oooo0?ooo`2n0?ooo`030000003oool0oooo0;h0oooo00<00000
0?ooo`3oool05@3oool001D0oooo00<000000?ooo`3oool0_`3oool00`000000oooo0?ooo`2o0?oo
o`030000003oool0oooo01@0oooo000D0?ooo`030000003oool0oooo0:80oooo00D0omBK00000000
0000000009_Do`050?ooo`030=BK0000000009_D00D0oooo00D0e9/0000000000000000009_Do`07
0?ooo`030000003oool0oooo0<00oooo00<000000?ooo`3oool04`3oool001@0oooo00<000000?oo
o`3oool0XP3oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo00<0e9/000000000Vm@0103o
ool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l01P3oool00`000000oooo0?ooo`300?ooo`03
0000003oool0oooo01<0oooo000C0?ooo`030000003oool0oooo0:80oooo00<0omBK002Ke03oool0
0P3oool00`3Z^W80L[[Z0?ooo`0?0?ooo`030?oDV`00Vm@0oooo00D0oooo00<000000?ooo`3oool0
`@3oool00`000000oooo0?ooo`0B0?ooo`004`3oool00`000000oooo0?ooo`2R0?ooo`030>ZjLP1b
^^X0oooo0080oooo00<0omBK002Ke03oool03`3oool00`3oe9/009_D0?ooo`050?ooo`@00000`03o
ool00`000000oooo0?ooo`0B0?ooo`004P3oool00`000000oooo0?ooo`2J0?ooo`030;Yb00000000
000000<0000000D007:j0?ooo`3oool0j[Yb07:jjP030?ooo`030?oDV`00Vm@0oooo00l0oooo00<0
^W8009_Do`3oool01@3oool00`000000oooo0?ooo`320?ooo`030000003oool0oooo0140oooo000B
0?ooo`030000003oool0oooo0:<0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0:
0?ooo`030?ooe02K000000000080000000<0L[[Z0?ooo`3oool01@3oool00`000000oooo0?ooo`32
0?ooo`030000003oool0oooo0140oooo000A0?ooo`030000003oool0oooo0:@0oooo00<0omBK07:j
jP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K09/0e?oo00X0oooo00<000000?oo
o`3oool0``3oool00`000000oooo0?ooo`0@0?ooo`004@3oool00`000000oooo0?ooo`2U0?ooo`06
0;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0
oooo0<<0oooo00<000000?ooo`3oool0403oool00100oooo00<000000?ooo`3oool0YP3oool01@3o
om@0V`00000000000780^^[o00`0oooo00<0oooD09/0000000000P0000000`0009/0e?oo0?ooo`05
0?ooo`030000003oool0oooo0<@0oooo00<000000?ooo`3oool03`3oool00100oooo00<000000?oo
o`3oool0a03oool00`000000oooo0?ooo`340?ooo`030000003oool0oooo00l0oooo000?0?ooo`03
0000003oool0oooo0<D0oooo0`0000350?ooo`030000003oool0oooo00h0oooo000?0?ooo`030000
003oool0oooo0<D0oooo00<000000?ooo`3oool0a@3oool00`000000oooo0?ooo`0>0?ooo`003`3o
ool00`000000oooo0?ooo`350?ooo`030000003oool0oooo0<D0oooo00<000000?ooo`3oool03P3o
ool000h0oooo00<000000?ooo`3oool0aP3oool00`000000oooo0?ooo`350?ooo`030000003oool0
oooo00h0oooo000>0?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`3oool0aP3oool00`00
0000oooo0?ooo`0=0?ooo`003P3oool00`000000oooo0?ooo`360?ooo`030000003oool0oooo0<H0
oooo00<000000?ooo`3oool03@3oool000h0oooo00<000000?ooo`3oool0aP3oool00`000000oooo
0?ooo`360?ooo`030000003oool0oooo00d0oooo000=0?ooo`030000003oool0oooo0<L0oooo0`00
00370?ooo`030000003oool0oooo00`0oooo000=0?ooo`030000003oool0oooo0<L0oooo00<00000
0?ooo`3oool0a`3oool00`000000oooo0?ooo`0<0?ooo`003@3oool00`000000oooo0?ooo`370?oo
o`030000003oool0oooo0<L0oooo00<000000?ooo`3oool0303oool000`0oooo00D0e9/000000000
0000000007:jjP0m0?ooo`030?ooe02K0000000000@0000000<0VmCo0?ooo`3oool0?03oool00`3o
e9/000000000000300000003002Ke03oool0oooo03X0oooo00<000000?ooo`3oool0?P3oool00`3o
e9/000000000000300000003002Ke03oool0oooo03X0oooo00<0oooD09/000000000100000000`2K
e?l0oooo0?ooo`0l0?ooo`@0000000<0L[[Z0?ooo`3oool0203oool000/0oooo00L0e9/00000003o
ool0oooo0?ooe02K0000L[[Z03d0oooo00<0e9/00000V`3Dool00P3oool00`3Z^Y/0^^[o0?ooo`10
0?ooo`030;YbLP2jj_l0oooo03d0oooo00<000000?ooo`3oool0@@3oool00`2jLW80^^[o0?ooo`0n
0?ooo`030=BK000009/0e?oo0080oooo00<0j[ZK0;[Zo`3oool0?03oool01`3DV`0009_D0000003o
ool0oooD09/0001b^^X02@3oool000`0oooo00H000000?ooo`3oool0oooo0?oDV`00Vm@n0?ooo`03
0?oDV`000780^^[o04@0oooo00<0^W9b0;[Zo`3oool0?@3oool00`000000oooo0?ooo`110?ooo`03
0;YbLP2jj_l0oooo03l0oooo00<0omBK0000LP2jj_l0@P3oool01@000000oooo0?ooo`3oe9/009_D
00T0oooo000<0?ooo`060000003oool0oooo0?oZ^P1b0780^^[o?`3oool00`3oj[X0LP0007:jjP13
0?ooo`030;YbLP2jj_l0oooo03d0oooo00<000000?ooo`3oool0@@3oool00`2jLW80^^[o0?ooo`10
0?ooo`030?oZ^P1b0000L[[Z0440oooo00D000000?ooo`3oj[X0LP1b0;[Zo`090?ooo`000P3oool0
0`2jLP0000000000000300000009001b^P3oool0oooo0?ooo`000000j[Yb000000000780^^[o03D0
oooo00<0^W800000000000000`0000000`00L[X0oooo0?ooo`040?ooo`030;Yb001b^^X0oooo03D0
oooo00<0^W800000000000000`0000000`00L[X0oooo0?ooo`030?ooo`030;YbLP2jj_l0oooo03d0
oooo0`0000110?ooo`030;YbLP2jj_l0oooo0480oooo00<0^W8007:jjP3oool0?`3oool200000003
0000LP2jj_l0oooo00T0oooo000<0?ooo`060000003oool0oooo0?oZ^P1b0780^^[o@P3oool00`2j
LY/0e?oo0?ooo`100?ooo`030;YbLP2jj_l0oooo03d0oooo00<000000?ooo`3oool0@@3oool00`2j
LW80^^[o0?ooo`130?ooo`030;YbV`3Dool0oooo03h0oooo00D000000?ooo`3oj[X0LP1b0;[Zo`09
0?ooo`002`3oool00`000000oooo0?ooo`020?ooo`030=BK002Ke?l0oooo03`0oooo00<0j[Yb09_D
o`3oool00P3oool00`3DV`00VmCo0?ooo`100?ooo`030;YbLP2jj_l0oooo03d0oooo00<000000?oo
o`3oool0@@3oool00`2jLW80^^[o0?ooo`0n0?ooo`030>ZjLP2Ke?l0oooo0080oooo00<0e9/009_D
o`3oool0?`3oool010000000oooo0=BK002Ke?l90?ooo`002`3oool01`000000001b0;[Zo`3oool0
onZj0780LP2jj_l0?@3oool01`3oe9/0002K0=Coo`3oool0omBK0000LP2jj_l0?P3oool01@3Z^W80
0000001b^P2jLW80^^[o03h0oooo00<000000?ooo`3oool0?P3oool01@3Z^W800000001b^P2jLW80
^^[o03l0oooo00L0omBK0000V`3Dool0oooo0?oDV`000780^^[o03d0oooo00L0omBK0000LP2jj_l0
00000?oZ^P1b0780^^[o00T0oooo000;0?ooo`030000003oj[X0LP000080000000<0VmCo0?ooo`3o
ool0?@3oool01@3oe9/00000000000000780^^[o0440oooo00<0j[Yb0000LP2jj_l0?P3oool00`00
0000oooo0?ooo`100?ooo`030>ZjLP000780^^[o0400oooo00D0omBK000000000000001b0;[Zo`0o
0?ooo`050?oZ^P1b000000000000002Ke?l02P3oool000/0oooo00<000000?ooo`3oool0b@3oool0
0`000000oooo0?ooo`390?ooo`030000003oool0oooo00X0oooo000;0?ooo`030000003oool0oooo
0<T0oooo0`0000390?ooo`030000003oool0oooo00X0oooo000;0?ooo`030000003oool0oooo0<T0
oooo00<000000?ooo`3oool0b@3oool00`000000oooo0?ooo`0:0?ooo`002`3oool00`000000oooo
0?ooo`390?ooo`030000003oool0oooo0<T0oooo00<000000?ooo`3oool02P3oool000X0oooo00<0
00000?ooo`3oool0bP3oool00`000000oooo0?ooo`3:0?ooo`030000003oool0oooo00T0oooo000:
0?ooo`030000003oool0oooo0<X0oooo00<000000?ooo`3oool0bP3oool00`000000oooo0?ooo`09
0?ooo`002P3oool00`000000oooo0?ooo`3:0?ooo`030000003oool0oooo0<X0oooo00<000000?oo
o`3oool02@3oool000X0oooo00<000000?ooo`3oool0bP3oool00`000000oooo0?ooo`3:0?ooo`03
0000003oool0oooo00T0oooo003o00000;0000000@3oool000X0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02`3o
ool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool02@3o
ool000X0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool0@@3oool00`00
0000oooo0?ooo`120?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool0@@3oool00`00
0000oooo0?ooo`120?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool02@3oool000X0
oooo00<000000?ooo`3oool0bP3oool00`000000oooo0?ooo`3:0?ooo`030000003oool0oooo00T0
oooo000:0?ooo`030000003oool0oooo0<X0oooo00<000000?ooo`3oool0b@3oool00`000000oooo
0?ooo`0:0?ooo`002`3oool00`000000oooo0?ooo`390?ooo`030000003oool0oooo0<T0oooo00<0
00000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool0b@3oool300000<T0oooo00<00000
0?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool0b@3oool00`000000oooo0?ooo`390?oo
o`030000003oool0oooo00X0oooo000;0?ooo`030000003oool0oooo0<T0oooo00<000000?ooo`3o
ool0b@3oool00`000000oooo0?ooo`0:0?ooo`002`3oool00`000000oooo0?ooo`390?ooo`030000
003oool0oooo0<T0oooo00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool0b@3o
ool00`000000oooo0?ooo`390?ooo`030000003oool0oooo00X0oooo000;0?ooo`030000003oool0
oooo0<T0oooo00<000000?ooo`3oool0b@3oool00`000000oooo0?ooo`0:0?ooo`00303oool00`00
0000oooo0?ooo`380?ooo`030000003oool0oooo0<P0oooo00<000000?ooo`3oool02`3oool000`0
oooo00<000000?ooo`3oool0b03oool300000<P0oooo00<000000?ooo`3oool02`3oool000`0oooo
00<000000?ooo`3oool0b03oool00`000000oooo0?ooo`380?ooo`030000003oool0oooo00/0oooo
000<0?ooo`030000003oool0oooo0<P0oooo00<000000?ooo`3oool0b03oool00`000000oooo0?oo
o`0;0?ooo`00303oool00`000000oooo0?ooo`380?ooo`030000003oool0oooo0<P0oooo00<00000
0?ooo`3oool02`3oool000d0oooo00<000000?ooo`3oool0a`3oool00`000000oooo0?ooo`370?oo
o`030000003oool0oooo00`0oooo000=0?ooo`030000003oool0oooo0<L0oooo00<000000?ooo`3o
ool0a`3oool00`000000oooo0?ooo`0<0?ooo`003@3oool00`000000oooo0?ooo`370?ooo`030000
003oool0oooo0<L0oooo00<000000?ooo`3oool0303oool000d0oooo00<000000?ooo`3oool0a`3o
ool300000<L0oooo00<000000?ooo`3oool0303oool000h0oooo00<000000?ooo`3oool0aP3oool0
0`000000oooo0?ooo`360?ooo`030000003oool0oooo00d0oooo000>0?ooo`030000003oool0oooo
0<H0oooo00<000000?ooo`3oool0aP3oool00`000000oooo0?ooo`0=0?ooo`003P3oool00`000000
oooo0?ooo`360?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`3oool03@3oool000l0oooo
00<000000?ooo`3oool0a@3oool00`000000oooo0?ooo`350?ooo`030000003oool0oooo00h0oooo
000?0?ooo`030000003oool0oooo0<D0oooo00<000000?ooo`3oool0a@3oool00`000000oooo0?oo
o`0>0?ooo`003`3oool00`000000oooo0?ooo`350?ooo`030000003oool0oooo0<D0oooo00<00000
0?ooo`3oool03P3oool00100oooo00<000000?ooo`3oool0a03oool300000<@0oooo00<000000?oo
o`3oool03`3oool00100oooo00<000000?ooo`3oool0a03oool00`000000oooo0?ooo`340?ooo`03
0000003oool0oooo00l0oooo000@0?ooo`030000003oool0oooo0<@0oooo00<000000?ooo`3oool0
``3oool00`000000oooo0?ooo`0@0?ooo`004@3oool00`000000oooo0?ooo`2U0?ooo`050?oDV`00
000000000000002Ke?l01@3oool00`3DV`000000002Ke0050?ooo`050=BK0000000000000000002K
e?l01`3oool00`000000oooo0?ooo`330?ooo`030000003oool0oooo0100oooo000A0?ooo`030000
003oool0oooo0:D0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?ooo`030=BK0000000009_D
00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo00H0oooo00<000000?ooo`3oool0`P3o
ool00`000000oooo0?ooo`0A0?ooo`004P3oool00`000000oooo0?ooo`2S0?ooo`030?oDV`00Vm@0
oooo0080oooo00<0j[Yb07:jjP3oool03`3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0
oooo0<80oooo00<000000?ooo`3oool04@3oool00180oooo00<000000?ooo`3oool0X`3oool00`3Z
^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0omBK002Ke03oool01@3oool40000
0<00oooo00<000000?ooo`3oool04P3oool001<0oooo00<000000?ooo`3oool0XP3oool00`3Z^W80
L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool01@3oool00`000000
oooo0?ooo`310?ooo`030000003oool0oooo0180oooo000C0?ooo`030000003oool0oooo0:80oooo
00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0:0?ooo`030?ooe02K0000000000800000
00<0L[[Z0?ooo`3oool01@3oool00`000000oooo0?ooo`300?ooo`030000003oool0oooo01<0oooo
000D0?ooo`030000003oool0oooo0:40oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?oo
o`0:0?ooo`030?ooe02K09/0e?oo00X0oooo00<000000?ooo`3oool0`03oool00`000000oooo0?oo
o`0C0?ooo`00503oool00`000000oooo0?ooo`2R0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo
2`3oool00`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3oool0
503oool001D0oooo00<000000?ooo`3oool0X@3oool01@3oom@0V`00000000000780^^[o00`0oooo
00<0oooD09/0000000000P0000000`0009/0e?oo0?ooo`050?ooo`030000003oool0oooo0;l0oooo
00<000000?ooo`3oool0503oool001H0oooo00<000000?ooo`3oool0_P3oool00`000000oooo0?oo
o`2n0?ooo`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo0;h0oooo0`00002n
0?ooo`030000003oool0oooo01D0oooo000G0?ooo`030000003oool0oooo0;d0oooo00<000000?oo
o`3oool0_@3oool00`000000oooo0?ooo`0F0?ooo`00603oool00`000000oooo0?ooo`2l0?ooo`03
0000003oool0oooo0;`0oooo00<000000?ooo`3oool05`3oool001P0oooo00<000000?ooo`3oool0
_03oool00`000000oooo0?ooo`2l0?ooo`030000003oool0oooo01L0oooo000I0?ooo`030000003o
ool0oooo0;/0oooo00<000000?ooo`3oool0^`3oool00`000000oooo0?ooo`0H0?ooo`006P3oool0
0`000000oooo0?ooo`2j0?ooo`030000003oool0oooo0;X0oooo00<000000?ooo`3oool06@3oool0
01X0oooo00<000000?ooo`3oool0^P3oool00`000000oooo0?ooo`2j0?ooo`030000003oool0oooo
01T0oooo000K0?ooo`030000003oool0oooo0;T0oooo0`00002i0?ooo`030000003oool0oooo01X0
oooo000L0?ooo`030000003oool0oooo0;P0oooo00<000000?ooo`3oool0^03oool00`000000oooo
0?ooo`0K0?ooo`007@3oool00`000000oooo0?ooo`2g0?ooo`030000003oool0oooo0;L0oooo00<0
00000?ooo`3oool0703oool001h0oooo00<000000?ooo`3oool0]P3oool00`000000oooo0?ooo`2f
0?ooo`030000003oool0oooo01d0oooo000O0?ooo`030000003oool0oooo0;D0oooo00<000000?oo
o`3oool0]@3oool00`000000oooo0?ooo`0N0?ooo`007`3oool00`000000oooo0?ooo`2e0?ooo`03
0000003oool0oooo0;D0oooo00<000000?ooo`3oool07P3oool00200oooo00<000000?ooo`3oool0
]03oool00`000000oooo0?ooo`2d0?ooo`030000003oool0oooo01l0oooo000Q0?ooo`030000003o
ool0oooo0;<0oooo0`00002c0?ooo`030000003oool0oooo0200oooo000R0?ooo`030000003oool0
oooo0;80oooo00<000000?ooo`3oool0/P3oool00`000000oooo0?ooo`0Q0?ooo`008`3oool00`00
0000oooo0?ooo`2a0?ooo`030000003oool0oooo0;40oooo00<000000?ooo`3oool08P3oool002@0
oooo00<000000?ooo`3oool0/03oool00`000000oooo0?ooo`2`0?ooo`030000003oool0oooo02<0
oooo000U0?ooo`030000003oool0oooo0:l0oooo00<000000?ooo`3oool0[`3oool00`000000oooo
0?ooo`0T0?ooo`009P3oool00`000000oooo0?ooo`2^0?ooo`030000003oool0oooo0:h0oooo00<0
00000?ooo`3oool09@3oool002L0oooo0P00002^0?ooo`030000003oool0oooo0:`0oooo0P00000X
0?ooo`00:@3oool00`000000oooo0?ooo`2[0?ooo`<00000Z`3oool00`000000oooo0?ooo`0X0?oo
o`00:P3oool00`000000oooo0?ooo`2Z0?ooo`030000003oool0oooo0:X0oooo00<000000?ooo`3o
ool0:@3oool002/0oooo00<000000?ooo`3oool0Z@3oool00`000000oooo0?ooo`2Y0?ooo`030000
003oool0oooo02X0oooo000/0?ooo`030000003oool0oooo09/0oooo00<0omBK0000000000000`00
00000`00Vm@0oooo0?ooo`040?ooo`030000003oool0oooo0:P0oooo00<000000?ooo`3oool0:`3o
ool002d0oooo00<000000?ooo`3oool0W@3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0
oooo0:L0oooo00<000000?ooo`3oool0;03oool002h0oooo00<000000?ooo`3oool0W03oool00`2j
LW80^^[o0?ooo`070?ooo`030000003oool0oooo0:H0oooo00<000000?ooo`3oool0;@3oool002l0
oooo00<000000?ooo`3oool0V`3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo0:D0
oooo00<000000?ooo`3oool0;P3oool00300oooo0P00002K0?ooo`030;YbLP2jj_l0oooo00L0oooo
1000002R0?ooo`800000<@3oool00380oooo00<000000?ooo`3oool0V03oool00`2jLW80^^[o0?oo
o`070?ooo`030000003oool0oooo0:80oooo00<000000?ooo`3oool0<@3oool003<0oooo00<00000
0?ooo`3oool0U`3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo0:40oooo00<00000
0?ooo`3oool0<P3oool003@0oooo00<000000?ooo`3oool0T`3oool01@3Z^W800000001b^P2jLW80
^^[o00P0oooo00<000000?ooo`3oool0X03oool00`000000oooo0?ooo`0c0?ooo`00=@3oool00`00
0000oooo0?ooo`2D0?ooo`030>ZjLP000780^^[o00P0oooo00<000000?ooo`3oool0W`3oool00`00
0000oooo0?ooo`0d0?ooo`00=P3oool2000009l0oooo00<000000?ooo`3oool0W@3oool2000003L0
oooo000h0?ooo`030000003oool0oooo09`0oooo0`00002L0?ooo`030000003oool0oooo03L0oooo
000i0?ooo`800000W03oool00`000000oooo0?ooo`2J0?ooo`800000>P3oool003/0oooo0P00002J
0?ooo`030000003oool0oooo09P0oooo0P00000l0?ooo`00?@3oool00`000000oooo0?ooo`2G0?oo
o`030000003oool0oooo09L0oooo00<000000?ooo`3oool0?03oool003h0oooo0P00002G0?ooo`03
0000003oool0oooo09D0oooo0P00000o0?ooo`00@03oool00`000000oooo0?ooo`2D0?ooo`030000
003oool0oooo09@0oooo00<000000?ooo`3oool0?`3oool00440oooo0P00002D0?ooo`030000003o
ool0oooo0980oooo0P0000120?ooo`00@`3oool200000980oooo0`00002@0?ooo`800000A03oool0
04D0oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`2?0?ooo`030000003oool0oooo
04@0oooo00160?ooo`800000S`3oool00`000000oooo0?ooo`2=0?ooo`800000A`3oool004P0oooo
0P00002=0?ooo`030000003oool0oooo08/0oooo0P0000190?ooo`00BP3oool2000008/0oooo00<0
00000?ooo`3oool0R@3oool2000004/0oooo001<0?ooo`030000003oool0oooo08P0oooo00<00000
0?ooo`3oool0R03oool00`000000oooo0?ooo`1;0?ooo`00C@3oool2000008P0oooo00<000000?oo
o`3oool0QP3oool2000004h0oooo001?0?ooo`800000QP3oool3000008@0oooo0P00001@0?ooo`00
D@3oool2000008@0oooo00<000000?ooo`3oool0PP3oool200000580oooo001C0?ooo`800000PP3o
ool00`000000oooo0?ooo`200?ooo`800000E03oool005D0oooo0P0000200?ooo`030000003oool0
oooo07h0oooo0P00001F0?ooo`00E`3oool2000007h0oooo00<000000?ooo`3oool0O03oool20000
05P0oooo001I0?ooo`800000O03oool00`000000oooo0?ooo`1j0?ooo`800000FP3oool005/0oooo
0`00001i0?ooo`030000003oool0oooo07L0oooo0`00001L0?ooo`00GP3oool2000007L0oooo0`00
001e0?ooo`800000G`3oool00600oooo0`00001d0?ooo`030000003oool0oooo0780oooo0`00001Q
0?ooo`00H`3oool300000740oooo00<000000?ooo`3oool0K`3oool3000006@0oooo001V0?ooo`<0
0000C`3oool00`3oe9/000000000000300000003002Ke03oool0oooo0080oooo00<0e9/000000000
Vm@01@3oool01@3DV`000000000000000000VmCo00L0oooo00<000000?ooo`3oool0K03oool30000
06L0oooo001Y0?ooo`<00000C`3oool00`2jLW80^^[o0?ooo`050?ooo`030=BK0000000009_D00@0
oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo00H0oooo00<000000?ooo`3oool0J@3oool3
000006X0oooo001/0?ooo`<00000C03oool00`2jLW80^^[o0?ooo`0A0?ooo`030?oDV`00Vm@0oooo
00D0oooo00<000000?ooo`3oool0I`3oool2000006d0oooo001_0?ooo`<00000B@3oool00`2jLW80
^^[o0?ooo`0A0?ooo`030?oDV`00Vm@0oooo00D0oooo00<000000?ooo`3oool0I03oool3000006l0
oooo001b0?ooo`<00000AP3oool00`2jLW80^^[o0?ooo`0A0?ooo`030;Yb002Ke?l0oooo00D0oooo
1000001P0?ooo`<00000LP3oool007D0oooo0`0000130?ooo`030;YbLP2jj_l0oooo00`0oooo00<0
oooD09/0000000000P0000000`1b^^X0oooo0?ooo`050?ooo`030000003oool0oooo05h0oooo0`00
001e0?ooo`00N03oool300000400oooo00<0^W9b0;[Zo`3oool0303oool00`3oom@0V`2K0=Coo`0:
0?ooo`030000003oool0oooo05/0oooo0`00001h0?ooo`00N`3oool3000003X0oooo00D0j[Yb0000
0000L[X0^W9b0;[Zo`0=0?ooo`030?ooe02K09/0e?oo00X0oooo00<000000?ooo`3oool0F03oool3
000007/0oooo001n0?ooo`<00000>@3oool00`3Z^W80001b0;[Zo`0=0?ooo`030?ooe02K00000000
0080000000<0002K0=Coo`3oool01@3oool00`000000oooo0?ooo`1D0?ooo`@00000OP3oool00840
oooo0`00001C0?ooo`030000003oool0oooo0540oooo0`0000220?ooo`00Q03oool4000004l0oooo
00<000000?ooo`3oool0C@3oool4000008D0oooo00280?ooo`D00000BP3oool3000004P0oooo1@00
00290?ooo`00S@3oool5000004D0oooo00<000000?ooo`3oool0@`3oool5000008h0oooo002B0?oo
o`D00000@03oool00`000000oooo0?ooo`0n0?ooo`D00000T`3oool009L0oooo1P00000j0?ooo`03
0000003oool0oooo03P0oooo1P00002H0?ooo`00W@3oool6000003@0oooo00<000000?ooo`3oool0
<P3oool6000009h0oooo002S0?ooo`H00000;P3oool00`000000oooo0?ooo`0/0?ooo`H00000Y03o
ool00:T0oooo2000000V0?ooo`<00000903oool800000:X0oooo002a0?ooo`d000006@3oool00`00
0000oooo0?ooo`0G0?ooo`d00000/P3oool00;h0oooo4@0000080?ooo`030000003oool0oooo00H0
oooo4@00002o0?ooo`00c`3ooolA00000=00oooo003G0?ooo`030000003oool0oooo0=H0oooo003G
0?ooo`030000003oool0oooo0=H0oooo003G0?ooo`030000003oool0oooo0=H0oooo003G0?ooo`<0
0000eP3oool00=L0oooo00<000000?ooo`3oool0eP3oool00001\
\>"],
  ImageRangeCache->{{{0, 431}, {248.375, 0}} -> {-3.1559, -1.81867, \
0.0219669, 0.0219669}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"graf3", "=", 
          RowBox[{
            StyleBox["ParametricPlot",
              FontSize->12], 
            StyleBox["[",
              FontSize->12], 
            RowBox[{
              StyleBox[\({Cos[3  t/5], Sin[2  t/5]}\),
                FontSize->12], ",", \({t, 0, 10  Pi}\), ",", "\n", "\t\t", 
              StyleBox[\(AspectRatio -> Automatic\),
                FontSize->12]}], 
            StyleBox["]",
              FontSize->12]}]}], 
        StyleBox[" ",
          FontSize->12], 
        StyleBox[";",
          FontSize->12]}], 
      "\n", \( (*\ 
        Una\ curva\ definida\ por\ sus\ ecuaciones\ param\[EAcute]tricas\ *) \
\)}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.5 0.476191 [
[.02381 .4875 -6 -9 ]
[.02381 .4875 6 0 ]
[.2619 .4875 -12 -9 ]
[.2619 .4875 12 0 ]
[.7381 .4875 -9 -9 ]
[.7381 .4875 9 0 ]
[.97619 .4875 -3 -9 ]
[.97619 .4875 3 0 ]
[.4875 .02381 -12 -4.5 ]
[.4875 .02381 0 4.5 ]
[.4875 .2619 -24 -4.5 ]
[.4875 .2619 0 4.5 ]
[.4875 .7381 -18 -4.5 ]
[.4875 .7381 0 4.5 ]
[.4875 .97619 -6 -4.5 ]
[.4875 .97619 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .5 m
.02381 .50625 L
s
[(-1)] .02381 .4875 0 1 Mshowa
.2619 .5 m
.2619 .50625 L
s
[(-0.5)] .2619 .4875 0 1 Mshowa
.7381 .5 m
.7381 .50625 L
s
[(0.5)] .7381 .4875 0 1 Mshowa
.97619 .5 m
.97619 .50625 L
s
[(1)] .97619 .4875 0 1 Mshowa
.125 Mabswid
.07143 .5 m
.07143 .50375 L
s
.11905 .5 m
.11905 .50375 L
s
.16667 .5 m
.16667 .50375 L
s
.21429 .5 m
.21429 .50375 L
s
.30952 .5 m
.30952 .50375 L
s
.35714 .5 m
.35714 .50375 L
s
.40476 .5 m
.40476 .50375 L
s
.45238 .5 m
.45238 .50375 L
s
.54762 .5 m
.54762 .50375 L
s
.59524 .5 m
.59524 .50375 L
s
.64286 .5 m
.64286 .50375 L
s
.69048 .5 m
.69048 .50375 L
s
.78571 .5 m
.78571 .50375 L
s
.83333 .5 m
.83333 .50375 L
s
.88095 .5 m
.88095 .50375 L
s
.92857 .5 m
.92857 .50375 L
s
.25 Mabswid
0 .5 m
1 .5 L
s
.5 .02381 m
.50625 .02381 L
s
[(-1)] .4875 .02381 1 0 Mshowa
.5 .2619 m
.50625 .2619 L
s
[(-0.5)] .4875 .2619 1 0 Mshowa
.5 .7381 m
.50625 .7381 L
s
[(0.5)] .4875 .7381 1 0 Mshowa
.5 .97619 m
.50625 .97619 L
s
[(1)] .4875 .97619 1 0 Mshowa
.125 Mabswid
.5 .07143 m
.50375 .07143 L
s
.5 .11905 m
.50375 .11905 L
s
.5 .16667 m
.50375 .16667 L
s
.5 .21429 m
.50375 .21429 L
s
.5 .30952 m
.50375 .30952 L
s
.5 .35714 m
.50375 .35714 L
s
.5 .40476 m
.50375 .40476 L
s
.5 .45238 m
.50375 .45238 L
s
.5 .54762 m
.50375 .54762 L
s
.5 .59524 m
.50375 .59524 L
s
.5 .64286 m
.50375 .64286 L
s
.5 .69048 m
.50375 .69048 L
s
.5 .78571 m
.50375 .78571 L
s
.5 .83333 m
.50375 .83333 L
s
.5 .88095 m
.50375 .88095 L
s
.5 .92857 m
.50375 .92857 L
s
.25 Mabswid
.5 0 m
.5 1 L
s
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
.5 Mabswid
.97619 .5 m
.97606 .50739 L
.97572 .51411 L
.97506 .52186 L
.97418 .52918 L
.97198 .54219 L
.9687 .55627 L
.964 .57172 L
.9578 .58801 L
.94358 .61696 L
.92484 .64637 L
.90371 .67338 L
.84362 .73237 L
.76743 .78805 L
.68735 .83409 L
.58537 .88088 L
.48676 .91674 L
.40088 .94155 L
.313 .96085 L
.26573 .96844 L
.24356 .97123 L
.22383 .97325 L
.20645 .97464 L
.19792 .97517 L
.18875 .97563 L
.17973 .97595 L
.17476 .97607 L
.17029 .97615 L
.16176 .97619 L
.15388 .97611 L
.1466 .97592 L
.13895 .97559 L
.13192 .97517 L
.12565 .97469 L
.11173 .97321 L
.10507 .97227 L
.09807 .97111 L
.08561 .96848 L
.07349 .96509 L
.0632 .96132 L
.05484 .95744 L
.04788 .95339 L
.04145 .94868 L
.03553 .94303 L
.03112 .93737 L
.02948 .93469 L
.02795 .93171 L
.02682 .92907 L
.02579 .9261 L
.02486 .92252 L
Mistroke
.02424 .91901 L
.0239 .91549 L
.02381 .91215 L
.02398 .90802 L
.02419 .9059 L
.02451 .90354 L
.0253 .89928 L
.0263 .8952 L
.02951 .88565 L
.03439 .87489 L
.04717 .85381 L
.063 .83315 L
.16048 .74039 L
.49805 .5013 L
.82652 .27016 L
.88953 .21615 L
.9342 .17018 L
.95205 .14732 L
.96417 .12786 L
.969 .11793 L
.97276 .10798 L
.97417 .103 L
.97515 .0985 L
.97557 .09596 L
.97586 .09369 L
.97608 .09112 L
.97618 .08873 L
.97613 .08511 L
.9758 .08133 L
.97522 .07787 L
.97448 .0748 L
.97333 .07131 L
.97175 .06765 L
.96799 .06134 L
.96286 .05526 L
.95606 .04936 L
.94919 .0448 L
.94046 .04027 L
.93205 .03682 L
.92227 .03361 L
.9105 .03062 L
.89877 .02834 L
.887 .02663 L
.87537 .0254 L
.86841 .02485 L
.8619 .02445 L
.85418 .02411 L
.8467 .02391 L
.83918 .02382 L
.8309 .02384 L
Mistroke
.82291 .02398 L
.81544 .02421 L
.80654 .02459 L
.79662 .02516 L
.778 .02658 L
.75788 .02861 L
.73571 .03137 L
.69411 .03788 L
.6078 .05627 L
.52608 .07919 L
.34731 .14874 L
.25471 .1982 L
.17941 .24915 L
.11786 .30313 L
.07317 .35644 L
.05367 .38803 L
.04004 .41729 L
.03425 .43362 L
.0317 .44226 L
.02938 .45146 L
.02769 .45949 L
.02617 .46837 L
.02512 .47645 L
.02441 .48404 L
.02398 .49144 L
.02381 .49935 L
.02392 .5068 L
.02424 .51358 L
.02491 .52155 L
.02541 .52604 L
.02596 .53018 L
.02877 .5458 L
.03255 .56077 L
.03793 .57715 L
.05259 .60995 L
.06932 .63792 L
.09127 .66739 L
.14069 .71872 L
.2102 .77319 L
.29908 .82696 L
.39297 .87185 L
.48208 .90629 L
.57121 .93412 L
.66453 .95652 L
.71328 .96533 L
.73384 .96838 L
.75573 .97115 L
.77445 .97309 L
.7938 .97466 L
.80418 .97529 L
Mistroke
.81342 .97572 L
.8225 .97601 L
.83089 .97616 L
.83858 .97619 L
.84665 .9761 L
.85408 .97589 L
.86072 .97561 L
.86827 .97516 L
.87625 .97452 L
.8901 .97297 L
.89726 .97191 L
.90352 .97081 L
.91667 .96791 L
.92776 .96468 L
.93721 .96115 L
.94515 .95744 L
.95259 .95308 L
.95822 .94895 L
.96342 .94417 L
.96803 .9386 L
.97141 .93302 L
.97304 .92943 L
.97427 .92591 L
.97512 .92264 L
.97576 .91897 L
.97611 .91529 L
.97619 .91182 L
.97601 .9079 L
.97551 .90366 L
.97483 .89987 L
.97398 .89626 L
.9713 .88778 L
.96713 .87797 L
.96224 .86866 L
.94753 .84645 L
.90282 .79653 L
.84371 .74384 L
.52156 .51438 L
.34112 .39293 L
.17045 .26772 L
.11033 .21602 L
.0621 .16577 L
.04547 .14371 L
.03897 .13342 L
.03396 .12425 L
.03002 .11561 L
.02728 .10809 L
.02614 .10419 L
.02516 .10007 L
.02441 .09583 L
Mistroke
.02398 .09193 L
.02381 .08796 L
.02391 .08443 L
.02432 .08048 L
.025 .07685 L
.02588 .0736 L
.02692 .07068 L
.03002 .06439 L
.03205 .06129 L
.03421 .05849 L
.04005 .05251 L
.04697 .04721 L
.05575 .04209 L
.06501 .03794 L
.07641 .034 L
.0897 .03057 L
.10328 .02801 L
.11026 .02698 L
.11709 .02615 L
.1235 .0255 L
.13049 .02493 L
.13833 .02444 L
.14578 .02411 L
.15401 .02389 L
.15878 .02383 L
.16331 .02381 L
.17178 .02388 L
.17614 .02396 L
.18102 .02409 L
.18977 .02442 L
.19817 .02484 L
.21762 .02621 L
.23946 .02831 L
.28143 .03385 L
.32196 .04083 L
.40331 .05908 L
.49232 .08507 L
.58167 .11762 L
.67394 .1591 L
.7541 .20356 L
.82012 .24879 L
.88441 .30546 L
.91213 .3368 L
.93639 .37092 L
.95294 .40111 L
.9645 .42977 L
.96937 .44631 L
.97269 .46151 L
.97405 .46991 L
.97464 .47436 L
Mistroke
.97516 .4791 L
.97556 .48365 L
.97584 .48778 L
.97615 .49584 L
.97619 .5 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00e`3oool00`000000oooo0?ooo`3F0?ooo`00e`3oool00`000000oooo0?ooo`3F0?ooo`00
e`3oool00`000000oooo0?ooo`3F0?ooo`00e`3oool00`000000oooo0?ooo`3F0?ooo`00e`3oool0
0`000000oooo0?ooo`3F0?ooo`00e`3oool00`000000oooo0?ooo`3F0?ooo`00bP3oool00`3oe9/0
00000000000300000003002Ke03oool0oooo00@0oooo00<000000?ooo`3oool0eP3oool00<d0oooo
00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`3F0?ooo`00c@3oool00`2jLW80^^[o0?oo
o`070?ooo`030000003oool0oooo0=H0oooo003=0?ooo`030;YbLP2jj_l0oooo00L0oooo00<00000
0?ooo`3oool0eP3oool003@0oooo9@00001X0?ooo`030;Yb00000000000000<0000000<007:j0?oo
o`3oool00`3oool00`2jLW80^^[o0?ooo`070?ooo`@00000N@3ooolX000003@0oooo000^0?ooo`H0
00009@3oool9000006/0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`1a0?ooo`T0
0000:03oool5000002l0oooo000Z0?ooo`@00000=03oool:00000640oooo00<0^W9b0;[Zo`3oool0
1`3oool00`000000oooo0?ooo`1X0?ooo`T00000=P3oool5000002X0oooo000T0?ooo`H00000@P3o
ool9000005D0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`080?ooo`030000003oool0oooo0640oooo
1`0000140?ooo`D000009@3oool00200oooo1000001A0?ooo`L00000D03oool00`3Z^W80001b0;[Z
o`080?ooo`030000003oool0oooo05/0oooo1P00001@0?ooo`@000008@3oool001h0oooo0P00001L
0?ooo`H00000E@3oool00`000000oooo0?ooo`1E0?ooo`H00000FP3oool3000001h0oooo000L0?oo
o`800000I03oool6000004l0oooo00<000000?ooo`3oool0C`3oool6000006<0oooo0P00000L0?oo
o`006P3oool2000006`0oooo1@00001:0?ooo`030000003oool0oooo04X0oooo1@00001[0?ooo`80
00006P3oool001P0oooo0P00001c0?ooo`@00000AP3oool00`000000oooo0?ooo`160?ooo`@00000
LP3oool2000001P0oooo000F0?ooo`800000N@3oool400000480oooo00<000000?ooo`3oool0@@3o
ool5000007P0oooo0P00000F0?ooo`00503oool2000007l0oooo1@00000m0?ooo`030000003oool0
oooo03`0oooo1@00001o0?ooo`800000503oool00180oooo0P0000260?ooo`@00000>@3oool00`00
0000oooo0?ooo`0g0?ooo`D00000QP3oool00`000000oooo0?ooo`0A0?ooo`004@3oool00`000000
oooo0?ooo`2:0?ooo`D00000=03oool00`000000oooo0?ooo`0c0?ooo`@00000S03oool00`000000
oooo0?ooo`0@0?ooo`00403oool00`000000oooo0?ooo`2@0?ooo`@00000<03oool00`000000oooo
0?ooo`0^0?ooo`D00000T@3oool00`000000oooo0?ooo`0?0?ooo`003`3oool00`000000oooo0?oo
o`2E0?ooo`@00000;03oool00`000000oooo0?ooo`0Z0?ooo`@00000U`3oool00`000000oooo0?oo
o`0>0?ooo`003P3oool00`000000oooo0?ooo`2J0?ooo`@00000:03oool00`000000oooo0?ooo`0V
0?ooo`@00000W03oool00`000000oooo0?ooo`0=0?ooo`003@3oool00`000000oooo0?ooo`2O0?oo
o`@00000903oool00`000000oooo0?ooo`0S0?ooo`<00000X@3oool00`000000oooo0?ooo`0<0?oo
o`00303oool00`000000oooo0?ooo`2T0?ooo`<000008@3oool00`000000oooo0?ooo`0O0?ooo`@0
0000Y03oool00`000000oooo0?ooo`0<0?ooo`00303oool00`000000oooo0?ooo`2W0?ooo`@00000
7@3oool00`000000oooo0?ooo`0L0?ooo`<00000Z@3oool00`000000oooo0?ooo`0;0?ooo`002`3o
ool00`000000oooo0?ooo`2/0?ooo`<000006P3oool00`000000oooo0?ooo`0H0?ooo`@00000[03o
ool00`000000oooo0?ooo`0;0?ooo`002`3oool00`000000oooo0?ooo`2_0?ooo`@000005P3oool3
000001D0oooo0`00002a0?ooo`030000003oool0oooo00X0oooo000;0?ooo`030000003oool0oooo
0;<0oooo1000000B0?ooo`030000003oool0oooo0140oooo1000002d0?ooo`030000003oool0oooo
00X0oooo000:0?ooo`030000003oool0oooo0;P0oooo0`00000?0?ooo`030000003oool0oooo00h0
oooo0`00002i0?ooo`030000003oool0oooo00T0oooo000:0?ooo`030000003oool0oooo0;/0oooo
1000000;0?ooo`030000003oool0oooo00X0oooo1000002l0?ooo`030000003oool0oooo00T0oooo
000:0?ooo`030000003oool0oooo0;l0oooo0`0000080?ooo`030000003oool0oooo00L0oooo0`00
00300?ooo`030000003oool0oooo00T0oooo000:0?ooo`030000003oool0oooo0<80oooo10000004
0?ooo`030000003oool0oooo00D0oooo0P0000330?ooo`030000003oool0oooo00T0oooo000:0?oo
o`030000003oool0oooo0<H0oooo0`0000000`3oool000000?ooo`030?ooo`<00000a@3oool00`00
0000oooo0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`390?ooo`<0000000<0oooo00000000
0000b03oool00`000000oooo0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`3:0?ooo`@00000
b@3oool00`000000oooo0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`370?ooo`@000000`3o
ool300000<H0oooo00<000000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool0a@3oool2
000000<0oooo00<000000?ooo`3oool0103oool300000<<0oooo00<000000?ooo`3oool02@3oool0
00X0oooo00<000000?ooo`3oool0`P3oool3000000D0oooo00<000000?ooo`3oool01`3oool20000
0<40oooo00<000000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool0`03oool2000000P0
oooo00<000000?ooo`3oool02@3oool300000;h0oooo00<000000?ooo`3oool02@3oool000X0oooo
00<000000?ooo`3oool0_@3oool3000000X0oooo00<000000?ooo`3oool0303oool300000;X0oooo
00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool0^P3oool2000000d0oooo00<0
00000?ooo`3oool03`3oool300000;L0oooo00<000000?ooo`3oool02P3oool000/0oooo00<00000
0?ooo`3oool0]`3oool3000000l0oooo00<000000?ooo`3oool04P3oool200000;D0oooo00<00000
0?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool0]03oool300000180oooo00<000000?oo
o`3oool0503oool300000;80oooo00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3o
ool0/P3oool2000001D0oooo00<000000?ooo`3oool05`3oool300000:h0oooo00<000000?ooo`3o
ool02`3oool000`0oooo00<000000?ooo`3oool0[P3oool3000001L0oooo00<000000?ooo`3oool0
6P3oool200000:`0oooo00<000000?ooo`3oool02`3oool000`0oooo00<000000?ooo`3oool0[03o
ool2000001X0oooo00<000000?ooo`3oool0703oool300000:P0oooo00<000000?ooo`3oool0303o
ool000`0oooo00<000000?ooo`3oool0Z@3oool3000001`0oooo00<000000?ooo`3oool07`3oool3
00000:D0oooo00<000000?ooo`3oool0303oool000d0oooo00<000000?ooo`3oool0YP3oool20000
01l0oooo0`00000R0?ooo`800000X`3oool00`000000oooo0?ooo`0<0?ooo`003@3oool00`000000
oooo0?ooo`2S0?ooo`<000008@3oool00`000000oooo0?ooo`0T0?ooo`800000X03oool00`000000
oooo0?ooo`0=0?ooo`003P3oool00`000000oooo0?ooo`2O0?ooo`<00000903oool00`000000oooo
0?ooo`0V0?ooo`800000WP3oool00`000000oooo0?ooo`0=0?ooo`003P3oool00`000000oooo0?oo
o`2M0?ooo`8000009`3oool00`000000oooo0?ooo`0X0?ooo`800000V`3oool00`000000oooo0?oo
o`0>0?ooo`003`3oool00`000000oooo0?ooo`2I0?ooo`<00000:@3oool00`000000oooo0?ooo`0Z
0?ooo`<00000V03oool00`000000oooo0?ooo`0>0?ooo`003`3oool00`000000oooo0?ooo`2G0?oo
o`800000;03oool00`000000oooo0?ooo`0]0?ooo`800000U@3oool00`000000oooo0?ooo`0?0?oo
o`00403oool00`000000oooo0?ooo`2C0?ooo`<00000;P3oool00`000000oooo0?ooo`0_0?ooo`80
0000T`3oool00`000000oooo0?ooo`0?0?ooo`004@3oool00`000000oooo0?ooo`2@0?ooo`800000
<@3oool00`000000oooo0?ooo`0a0?ooo`800000T03oool00`000000oooo0?ooo`0@0?ooo`004@3o
ool00`000000oooo0?ooo`2=0?ooo`<00000<`3oool00`000000oooo0?ooo`0c0?ooo`<00000S03o
ool00`000000oooo0?ooo`0A0?ooo`004P3oool00`000000oooo0?ooo`290?ooo`<00000=P3oool0
0`000000oooo0?ooo`0f0?ooo`800000RP3oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`00
0000oooo0?ooo`260?ooo`800000>@3oool00`000000oooo0?ooo`0h0?ooo`800000Q`3oool00`00
0000oooo0?ooo`0B0?ooo`00503oool00`000000oooo0?ooo`220?ooo`<00000>`3oool00`000000
oooo0?ooo`0j0?ooo`800000Q@3oool00`000000oooo0?ooo`0B0?ooo`00503oool00`000000oooo
0?ooo`200?ooo`800000?P3oool00`000000oooo0?ooo`0l0?ooo`800000PP3oool00`000000oooo
0?ooo`0C0?ooo`005@3oool00`000000oooo0?ooo`1m0?ooo`800000@03oool00`000000oooo0?oo
o`0n0?ooo`<00000OP3oool00`000000oooo0?ooo`0D0?ooo`005P3oool00`000000oooo0?ooo`1j
0?ooo`800000@P3oool00`000000oooo0?ooo`110?ooo`800000N`3oool00`000000oooo0?ooo`0E
0?ooo`005P3oool00`000000oooo0?ooo`1h0?ooo`800000A03oool00`000000oooo0?ooo`130?oo
o`800000N@3oool00`000000oooo0?ooo`0E0?ooo`005`3oool00`000000oooo0?ooo`1e0?ooo`80
0000AP3oool00`000000oooo0?ooo`150?ooo`800000MP3oool00`000000oooo0?ooo`0F0?ooo`00
603oool00`000000oooo0?ooo`1b0?ooo`800000B03oool00`000000oooo0?ooo`170?ooo`800000
L`3oool00`000000oooo0?ooo`0G0?ooo`006@3oool00`000000oooo0?ooo`1_0?ooo`800000BP3o
ool00`000000oooo0?ooo`190?ooo`800000L03oool00`000000oooo0?ooo`0H0?ooo`006@3oool0
0`000000oooo0?ooo`1]0?ooo`800000C03oool00`000000oooo0?ooo`1;0?ooo`800000K@3oool0
0`000000oooo0?ooo`0I0?ooo`006P3oool00`000000oooo0?ooo`1Z0?ooo`800000CP3oool30000
04d0oooo0P00001[0?ooo`030000003oool0oooo01T0oooo000K0?ooo`030000003oool0oooo06L0
oooo0P00001@0?ooo`030000003oool0oooo04l0oooo0P00001X0?ooo`030000003oool0oooo01X0
oooo000L0?ooo`030000003oool0oooo06@0oooo0P00001B0?ooo`030000003oool0oooo0540oooo
0P00001U0?ooo`030000003oool0oooo01/0oooo000M0?ooo`030000003oool0oooo0680oooo00<0
00000?ooo`3oool0DP3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo0640oooo00<0
00000?ooo`3oool0703oool001h0oooo00<000000?ooo`3oool0G`3oool2000005D0oooo00<00000
0?ooo`3oool0E03oool200000600oooo00<000000?ooo`3oool07@3oool001l0oooo00<000000?oo
o`3oool0G03oool2000005L0oooo00<000000?ooo`3oool0EP3oool2000005d0oooo00<000000?oo
o`3oool07P3oool00200oooo00<000000?ooo`3oool0F@3oool2000005T0oooo00<000000?ooo`3o
ool0F03oool2000005X0oooo00<000000?ooo`3oool07`3oool00240oooo00<000000?ooo`3oool0
EP3oool2000005/0oooo00<000000?ooo`3oool0FP3oool2000005L0oooo00<000000?ooo`3oool0
803oool00280oooo00<000000?ooo`3oool0D`3oool2000005d0oooo00<000000?ooo`3oool0G03o
ool2000005@0oooo00<000000?ooo`3oool08@3oool002<0oooo00<000000?ooo`3oool0D03oool2
000005l0oooo00<000000?ooo`3oool0GP3oool200000540oooo00<000000?ooo`3oool08P3oool0
02@0oooo00<000000?ooo`3oool0C@3oool200000640oooo00<000000?ooo`3oool0H03oool00`00
0000oooo0?ooo`1=0?ooo`030000003oool0oooo02<0oooo000T0?ooo`030000003oool0oooo04/0
oooo0P00001S0?ooo`030000003oool0oooo0640oooo0P00001<0?ooo`030000003oool0oooo02@0
oooo000U0?ooo`030000003oool0oooo04P0oooo0P00001U0?ooo`030000003oool0oooo06<0oooo
0P0000190?ooo`030000003oool0oooo02D0oooo000V0?ooo`030000003oool0oooo04D0oooo0P00
001W0?ooo`030000003oool0oooo06D0oooo0P0000170?ooo`030000003oool0oooo02D0oooo000W
0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`1W
0?ooo`800000A03oool00`000000oooo0?ooo`0V0?ooo`00:03oool00`000000oooo0?ooo`100?oo
o`800000JP3oool00`000000oooo0?ooo`1Y0?ooo`800000@@3oool00`000000oooo0?ooo`0W0?oo
o`00:@3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo06X0oooo00<000000?ooo`3o
ool0J`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo02P0oooo000Z0?ooo`030000
003oool0oooo03/0oooo0P00001]0?ooo`030000003oool0oooo06`0oooo0P00000l0?ooo`030000
003oool0oooo02T0oooo000[0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0K@3o
ool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0:P3o
ool002`0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0
oooo06l0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0[0?ooo`00;@3oool00`00
0000oooo0?ooo`0d0?ooo`800000L@3oool00`000000oooo0?ooo`1`0?ooo`800000=@3oool00`00
0000oooo0?ooo`0/0?ooo`00;P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo0740
oooo0`00001b0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0;@3oool002l0oooo
00<000000?ooo`3oool0;`3oool2000007@0oooo00<000000?ooo`3oool0L`3oool200000300oooo
00<000000?ooo`3oool0;P3oool00300oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?oo
o`1d0?ooo`030000003oool0oooo07D0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?oo
o`0_0?ooo`00<@3oool00`000000oooo0?ooo`0Z0?ooo`800000M`3oool00`000000oooo0?ooo`1f
0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0<03oool00380oooo0P00000Y0?oo
o`030000003oool0oooo07L0oooo00<000000?ooo`3oool0M`3oool2000002P0oooo0P00000c0?oo
o`00=03oool00`000000oooo0?ooo`0T0?ooo`800000NP3oool00`000000oooo0?ooo`1i0?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool0<`3oool003D0oooo00<000000?ooo`3oool0
8P3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo07X0oooo0P00000S0?ooo`030000
003oool0oooo03@0oooo000f0?ooo`030000003oool0oooo01l0oooo0P00001m0?ooo`030000003o
ool0oooo07`0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0e0?ooo`00=`3oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3oool0O@3oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo03H0oooo000h0?ooo`800000703oool00`00
0000oooo0?ooo`1n0?ooo`030000003oool0oooo07h0oooo0P00000L0?ooo`030000003oool0oooo
03L0oooo000j0?ooo`030000003oool0oooo01L0oooo0P0000210?ooo`030000003oool0oooo0800
oooo00<000000?ooo`3oool05`3oool2000003X0oooo000k0?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`210?ooo`8000005P3oool00`000000oooo
0?ooo`0j0?ooo`00?03oool00`000000oooo0?ooo`0B0?ooo`800000Q03oool00`000000oooo0?oo
o`230?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0>`3oool003d0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`240?ooo`030000003oool0oooo08@0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0l0?ooo`00?P3oool00`000000oooo0?ooo`0=0?oo
o`800000Q`3oool00`000000oooo0?ooo`250?ooo`8000003`3oool00`000000oooo0?ooo`0m0?oo
o`00?`3oool2000000`0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo0?ooo`270?ooo`03
0000003oool0oooo00X0oooo0P0000100?ooo`00@@3oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo08P0oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`080?ooo`030000
003oool0oooo0400oooo00120?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0J`3o
ool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/000000000Vm@01@3oool01@3DV`000000
000000000000VmCo00L0oooo00<000000?ooo`3oool0R@3oool00`000000oooo0?ooo`060?ooo`03
0000003oool0oooo0440oooo00130?ooo`030000003oool0oooo00<0oooo0P00001^0?ooo`060;Yb
V`3Dool0oooo0?ooe02K09/0e?oo103oool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0oooo
0?ooo`3oj[X0LP0009_Do`060?ooo`030000003oool0oooo08X0oooo0P0000050?ooo`030000003o
ool0oooo0480oooo00140?ooo`050000003oool0oooo0?ooo`000000K`3oool00`3oe9/009_D0?oo
o`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03oool01@3oool00`000000oooo0?oo
o`2<0?ooo`050000003oool0oooo0?ooo`000000A@3oool004D0oooo0`00001`0?ooo`030>ZjLP1b
^^X0oooo0080oooo00<0omBK002Ke03oool03`3oool00`3oe9/009_D0?ooo`050?ooo`@00000S03o
ool00`000000oooo000000160?ooo`00AP3oool2000006L0oooo00<0^W800000000000000`000000
1@00L[X0oooo0?ooo`3Z^W80L[[Z00<0oooo00<0omBK002Ke03oool03`3oool00`2jLP00VmCo0?oo
o`050?ooo`030000003oool0oooo08d0oooo0P0000170?ooo`00A@3oool010000000oooo0?ooo`00
001_0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool02P3oool00`3oom@0V`000000
00020000000307:jjP3oool0oooo00D0oooo00<000000?ooo`3oool0S03oool010000000oooo0?oo
o`0000160?ooo`00A03oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo06`0oooo00<0
omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K09/0e?oo00X0oooo00<0
00000?ooo`3oool0R`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04<0oooo0012
0?ooo`8000001P3oool2000006d0oooo00H0^W8009_Do`3oool0onZj0780V`3Dool;0?ooo`030?oo
e02K09/0e?oo00X0oooo00<000000?ooo`3oool0RP3oool00`000000oooo0?ooo`040?ooo`800000
@`3oool00440oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1Z0?ooo`050?ooe02K
000000000000LP2jj_l0303oool00`3oom@0V`0000000002000000030000V`3Dool0oooo00D0oooo
00<000000?ooo`3oool0R03oool2000000T0oooo00<000000?ooo`3oool0@03oool00400oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`270?ooo`030000003oool0oooo08L0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`0o0?ooo`00?`3oool00`000000oooo0?ooo`0<
0?ooo`800000Q`3oool00`000000oooo0?ooo`260?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool0?P3oool003h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`240?oo
o`030000003oool0oooo08@0oooo0P00000@0?ooo`030000003oool0oooo03d0oooo000l0?ooo`80
00004`3oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo08<0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0l0?ooo`00>`3oool00`000000oooo0?ooo`0D0?ooo`800000
P`3oool00`000000oooo0?ooo`210?ooo`8000005@3oool2000003`0oooo000j0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0P03oool00`000000oooo0?ooo`200?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0>@3oool003T0oooo00<000000?ooo`3oool06@3oool2
00000800oooo00<000000?ooo`3oool0OP3oool2000001/0oooo00<000000?ooo`3oool0>03oool0
03P0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`1m0?ooo`030000003oool0oooo
07d0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0g0?ooo`00=`3oool00`000000
oooo0?ooo`0N0?ooo`030000003oool0oooo07`0oooo00<000000?ooo`3oool0O03oool00`000000
oooo0?ooo`0N0?ooo`030000003oool0oooo03H0oooo000e0?ooo`8000008P3oool2000007`0oooo
00<000000?ooo`3oool0NP3oool200000280oooo00<000000?ooo`3oool0=@3oool003@0oooo00<0
00000?ooo`3oool0903oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo07T0oooo00<0
00000?ooo`3oool08`3oool2000003D0oooo000c0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool0N03oool00`000000oooo0?ooo`1g0?ooo`800000:03oool00`000000oooo0?ooo`0b
0?ooo`00<P3oool00`000000oooo0?ooo`0X0?ooo`800000N03oool00`000000oooo0?ooo`1f0?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool0<@3oool00340oooo00<000000?ooo`3o
ool0:`3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo07@0oooo0P00000]0?ooo`03
0000003oool0oooo0300oooo000`0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0
M03oool00`000000oooo0?ooo`1c0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0
;`3oool00300oooo00<000000?ooo`3oool0;P3oool2000007@0oooo0`00001b0?ooo`030000003o
ool0oooo0300oooo00<000000?ooo`3oool0;P3oool002l0oooo00<000000?ooo`3oool0<@3oool0
0`000000oooo0?ooo`1a0?ooo`030000003oool0oooo0700oooo0P00000d0?ooo`030000003oool0
oooo02d0oooo000^0?ooo`030000003oool0oooo03<0oooo0P00001a0?ooo`030000003oool0oooo
06l0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0]0?ooo`00;@3oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3oool0K@3oool2000003P0
oooo00<000000?ooo`3oool0;03oool002`0oooo00<000000?ooo`3oool0>03oool00`000000oooo
0?ooo`1]0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0>@3oool00`000000oooo
0?ooo`0[0?ooo`00:`3oool00`000000oooo0?ooo`0j0?ooo`800000K@3oool00`000000oooo0?oo
o`1[0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0:P3oool002/0oooo00<00000
0?ooo`3oool0?03oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo06T0oooo0P00000o
0?ooo`030000003oool0oooo02T0oooo000Z0?ooo`030000003oool0oooo03h0oooo00<000000?oo
o`3oool0J@3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo0400oooo00<000000?oo
o`3oool0:03oool002T0oooo00<000000?ooo`3oool0@03oool2000006T0oooo00<000000?ooo`3o
ool0IP3oool2000004@0oooo00<000000?ooo`3oool09`3oool002P0oooo00<000000?ooo`3oool0
@`3oool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo06D0oooo00<000000?ooo`3oool0
A03oool00`000000oooo0?ooo`0W0?ooo`009`3oool00`000000oooo0?ooo`150?ooo`800000IP3o
ool00`000000oooo0?ooo`1S0?ooo`800000B03oool00`000000oooo0?ooo`0V0?ooo`009P3oool0
0`000000oooo0?ooo`180?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool0HP3oool0
0`000000oooo0?ooo`190?ooo`030000003oool0oooo02D0oooo000V0?ooo`030000003oool0oooo
04T0oooo00<000000?ooo`3oool0HP3oool00`000000oooo0?ooo`1Q0?ooo`030000003oool0oooo
04/0oooo00<000000?ooo`3oool0903oool002D0oooo00<000000?ooo`3oool0B`3oool200000680
oooo00<000000?ooo`3oool0G`3oool2000004l0oooo00<000000?ooo`3oool08`3oool002@0oooo
00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo05h0oooo
00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`0S0?ooo`008`3oool00`000000oooo0?oo
o`1@0?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool0G03oool2000005<0oooo00<0
00000?ooo`3oool08P3oool00280oooo00<000000?ooo`3oool0DP3oool2000005h0oooo00<00000
0?ooo`3oool0F`3oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo0240oooo000Q0?oo
o`030000003oool0oooo05D0oooo00<000000?ooo`3oool0F`3oool00`000000oooo0?ooo`1J0?oo
o`030000003oool0oooo05H0oooo00<000000?ooo`3oool0803oool00240oooo00<000000?ooo`3o
ool0EP3oool2000005/0oooo00<000000?ooo`3oool0F03oool2000005T0oooo00<000000?ooo`3o
ool0803oool00200oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?ooo`1H0?ooo`030000
003oool0oooo05L0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`0O0?ooo`007`3o
ool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo05L0oooo0`00001E0?ooo`800000GP3o
ool00`000000oooo0?ooo`0N0?ooo`007P3oool00`000000oooo0?ooo`1M0?ooo`800000E`3oool0
0`000000oooo0?ooo`1D0?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool07P3oool0
01h0oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo
0580oooo0P00001R0?ooo`030000003oool0oooo01d0oooo000M0?ooo`030000003oool0oooo0640
oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo06<0
oooo00<000000?ooo`3oool0703oool001d0oooo00<000000?ooo`3oool0HP3oool2000005<0oooo
00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`1U0?ooo`030000003oool0oooo01/0oooo
000L0?ooo`030000003oool0oooo06D0oooo00<000000?ooo`3oool0D03oool00`000000oooo0?oo
o`1>0?ooo`800000J03oool00`000000oooo0?ooo`0K0?ooo`00703oool00`000000oooo0?ooo`1V
0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`1Y
0?ooo`030000003oool0oooo01X0oooo000K0?ooo`030000003oool0oooo06P0oooo0P00001?0?oo
o`030000003oool0oooo04/0oooo0P00001]0?ooo`030000003oool0oooo01T0oooo000J0?ooo`03
0000003oool0oooo06/0oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`1:0?ooo`03
0000003oool0oooo06d0oooo00<000000?ooo`3oool06@3oool001X0oooo00<000000?ooo`3oool0
K03oool2000004`0oooo00<000000?ooo`3oool0B03oool200000740oooo00<000000?ooo`3oool0
603oool001T0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`190?ooo`030000003o
ool0oooo04L0oooo00<000000?ooo`3oool0L@3oool00`000000oooo0?ooo`0H0?ooo`006@3oool0
0`000000oooo0?ooo`1`0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0AP3oool0
0`000000oooo0?ooo`1c0?ooo`030000003oool0oooo01L0oooo000H0?ooo`030000003oool0oooo
0780oooo0P0000180?ooo`030000003oool0oooo04@0oooo0P00001f0?ooo`030000003oool0oooo
01L0oooo000H0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool0A@3oool00`000000
oooo0?ooo`130?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool05P3oool001L0oooo
00<000000?ooo`3oool0MP3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo0440oooo
0P00001j0?ooo`030000003oool0oooo01H0oooo000F0?ooo`030000003oool0oooo07P0oooo0P00
00140?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0N`3oool00`000000oooo0?oo
o`0E0?ooo`005P3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo0440oooo00<00000
0?ooo`3oool0?`3oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo01D0oooo000E0?oo
o`030000003oool0oooo07`0oooo0P0000110?ooo`030000003oool0oooo03d0oooo0P0000200?oo
o`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0oooo07h0oooo00<000000?ooo`3o
ool0?P3oool00`000000oooo0?ooo`0l0?ooo`030000003oool0oooo0800oooo00<000000?ooo`3o
ool0503oool001@0oooo00<000000?ooo`3oool0P03oool2000003h0oooo00<000000?ooo`3oool0
>P3oool2000008@0oooo00<000000?ooo`3oool04`3oool001@0oooo00<000000?ooo`3oool0PP3o
ool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0Q03o
ool00`000000oooo0?ooo`0C0?ooo`004`3oool00`000000oooo0?ooo`240?ooo`800000>`3oool3
000003L0oooo0P0000280?ooo`030000003oool0oooo0180oooo000C0?ooo`030000003oool0oooo
08H0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo
08P0oooo00<000000?ooo`3oool04P3oool00180oooo00<000000?ooo`3oool0R03oool2000003P0
oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`2:0?ooo`030000003oool0oooo0140
oooo000B0?ooo`030000003oool0oooo08X0oooo00<000000?ooo`3oool0=@3oool00`000000oooo
0?ooo`0c0?ooo`800000S@3oool00`000000oooo0?ooo`0A0?ooo`004@3oool00`000000oooo0?oo
o`2<0?ooo`800000=@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo08d0oooo00<0
00000?ooo`3oool04@3oool00140oooo00<000000?ooo`3oool0SP3oool00`000000oooo0?ooo`0b
0?ooo`030000003oool0oooo0300oooo0P00002A0?ooo`030000003oool0oooo0100oooo000A0?oo
o`030000003oool0oooo08l0oooo0P00000b0?ooo`030000003oool0oooo02l0oooo00<000000?oo
o`3oool0T@3oool00`000000oooo0?ooo`0@0?ooo`00403oool00`000000oooo0?ooo`2B0?ooo`03
0000003oool0oooo02l0oooo00<000000?ooo`3oool0;@3oool2000009@0oooo00<000000?ooo`3o
ool0403oool00100oooo00<000000?ooo`3oool0T`3oool00`000000oooo0?ooo`0^0?ooo`030000
003oool0oooo02`0oooo00<000000?ooo`3oool0U@3oool00`000000oooo0?ooo`0?0?ooo`003`3o
ool00`000000oooo0?ooo`2E0?ooo`800000;P3oool00`000000oooo0?ooo`0[0?ooo`030000003o
ool0oooo09H0oooo00<000000?ooo`3oool03`3oool000l0oooo00<000000?ooo`3oool0U`3oool0
0`000000oooo0?ooo`0[0?ooo`030000003oool0oooo02T0oooo0P00002J0?ooo`030000003oool0
oooo00h0oooo000>0?ooo`030000003oool0oooo09T0oooo0P00000[0?ooo`030000003oool0oooo
02P0oooo00<000000?ooo`3oool0VP3oool00`000000oooo0?ooo`0>0?ooo`003P3oool00`000000
oooo0?ooo`2K0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool09P3oool2000009d0
oooo00<000000?ooo`3oool03P3oool000h0oooo00<000000?ooo`3oool0W03oool2000002P0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`2N0?ooo`030000003oool0oooo00d0oooo
000=0?ooo`030000003oool0oooo09l0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?oo
o`0T0?ooo`030000003oool0oooo09l0oooo00<000000?ooo`3oool03@3oool000d0oooo00<00000
0?ooo`3oool0X03oool2000002D0oooo00<000000?ooo`3oool08P3oool200000:80oooo00<00000
0?ooo`3oool03@3oool000d0oooo00<000000?ooo`3oool0XP3oool00`000000oooo0?ooo`0R0?oo
o`030000003oool0oooo0240oooo00<000000?ooo`3oool0XP3oool00`000000oooo0?ooo`0=0?oo
o`003@3oool00`000000oooo0?ooo`2S0?ooo`8000008P3oool00`000000oooo0?ooo`0O0?ooo`80
0000YP3oool00`000000oooo0?ooo`0<0?ooo`00303oool00`000000oooo0?ooo`2V0?ooo`030000
003oool0oooo01l0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`2V0?ooo`030000
003oool0oooo00`0oooo000<0?ooo`030000003oool0oooo0:L0oooo0P00000O0?ooo`030000003o
ool0oooo01`0oooo0P00002Y0?ooo`030000003oool0oooo00`0oooo000<0?ooo`030000003oool0
oooo0:T0oooo00<000000?ooo`3oool0703oool3000001/0oooo00<000000?ooo`3oool0ZP3oool0
0`000000oooo0?ooo`0;0?ooo`00303oool00`000000oooo0?ooo`2Z0?ooo`800000703oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo0:/0oooo00<000000?ooo`3oool02`3oool000/0
oooo00<000000?ooo`3oool0[@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0
oooo0P00002^0?ooo`030000003oool0oooo00/0oooo000;0?ooo`030000003oool0oooo0:h0oooo
0P00000I0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0[`3oool00`000000oooo
0?ooo`0:0?ooo`002`3oool600000003002Ke03oool0oooo05D0oooo00D0omBK0000000000000000
09_Do`050?ooo`030=BK0000000009_D00D0oooo00D0e9/0000000000000000009_Do`0n0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool05@3oool200000440oooo00D0omBK00000000
0000000009_Do`050?ooo`030=BK0000000009_D00D0oooo00D0e9/0000000000000000009_Do`1H
0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool01P3oool000/0oooo00D000000?oo
o`3oool0^W9b0;[Zo`1I0?ooo`060;YbV`3Dool0oooo0?ooe02K09/0e?oo103oool00`3DV`000000
002Ke0040?ooo`070=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`0n0?ooo`8000005P3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo0440oooo00H0^W:K0=Coo`3oool0oooD09/0V`3D
ool40?ooo`030=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo05T0
oooo00<000000;YbLP2jj_l02P3oool000/0oooo00D000000?ooo`3oool0^W9b0;[Zo`1H0?ooo`03
0?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3oool03`3oool00`3oe9/009_D0?ooo`0o0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`110?ooo`03
0?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3oool03`3oool00`3oe9/009_D0?ooo`1H0?ooo`03
0000002jLW80^^[o00X0oooo000;0?ooo`050000003oool0oooo0;YbLP2jj_l0F03oool00`3Z^W80
L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0omBK002Ke03oool0@03oool2000001<0
oooo00<000000?ooo`3oool04@3oool2000004@0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/0
09_D0?ooo`0?0?ooo`030?oDV`00Vm@0oooo05P0oooo00<000000;YbLP2jj_l02P3oool00080oooo
00<0^W800000000000000`0000001000L[X0oooo0?ooo`0000020?ooo`030;YbLP2jj_l0oooo04h0
oooo00<0^W800000000000000`0000001@00L[X0oooo0?ooo`3Z^W80L[[Z00<0oooo00<0omBK002K
e03oool03`3oool00`2jLP00VmCo0?ooo`120?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`140?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002K
e03oool03`3oool00`2jLP00VmCo0?ooo`1H0?ooo`030000002jLW80^^[o00X0oooo000:0?ooo`06
0000003oool0oooo0?ooo`2jLW80^^[oF03oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0
oooo00X0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`130?ooo`800000403oool0
0`000000oooo0?ooo`0>0?ooo`800000A`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0
oooo00X0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`1H0?ooo`030000002jLW80
^^[o00X0oooo000:0?ooo`060000003oool0oooo0?ooo`2jLW80^^[oF03oool00`3oe9/0L[[Z0?oo
o`020?ooo`030>ZjLP1b^^X0oooo00X0oooo00<0oooD09/0V`3Dool0BP3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0A`3oool00`3oe9/0L[[Z0?oo
o`020?ooo`030>ZjLP1b^^X0oooo00X0oooo00<0oooD09/0V`3Dool0GP3oool00`000000^^[o0?oo
o`090?ooo`002P3oool01P000000j[Yb00000000L[X0^W9b0;[ZoeT0oooo00H0^W8009_Do`3oool0
onZj0780V`3Dool;0?ooo`030?ooe02K09/0e?oo04/0oooo0P00000=0?ooo`030000003oool0oooo
00/0oooo0P00001;0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Co
o`1K0?ooo`050>ZjLP00000007:j0000002jj_l02P3oool000X0oooo00H000000?ooo`3oool0j[Yb
0000LP2jj_mI0?ooo`050?ooe02K000000000000LP2jj_l0303oool00`3oom@0V`00000000020000
00030000V`3Dool0oooo04P0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0:0?oo
o`030000003oool0oooo04/0oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K0000
00000080000000<0002K0=Coo`3oool0F03oool00`3Z^W8000000;[Zo`0:0?ooo`002P3oool00`00
0000oooo0?ooo`2n0?ooo`8000002P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
0;h0oooo00<000000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool0`03oool00`000000
oooo0?ooo`070?ooo`030000003oool0oooo00L0oooo0P0000310?ooo`030000003oool0oooo00T0
oooo000:0?ooo`030000003oool0oooo0<40oooo00<000000?ooo`3oool01P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo0<40oooo00<000000?ooo`3oool02@3oool000X0oooo00<0
00000?ooo`3oool0`P3oool2000000H0oooo00<000000?ooo`3oool0103oool200000<@0oooo00<0
00000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool0a03oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0a03oool00`000000oooo0?ooo`09
0?ooo`002P3oool00`000000oooo0?ooo`350?ooo`8000000`3oool010000000oooo0?ooo`3oool2
00000<L0oooo00<000000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool0a`3oool01000
0000oooo0?ooo`0000020?ooo`030000003oool0oooo0<L0oooo00<000000?ooo`3oool02@3oool0
00X0oooo00<000000?ooo`3oool0b03oool3000000030?ooo`000000oooo0<T0oooo00<000000?oo
o`3oool02@3oool00?l00000/00000010?ooo`002P3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0A0?ooo`@00000
4P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0?0?ooo`80000000D0
oooo0000003oool0oooo0000000A0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00T0oooo000:0?ooo`030000003o
ool0oooo06<0oooo00<000000?ooo`3oool0H03oool01@000000oooo0?ooo`3oool0000000<0oooo
0P00001Q0?ooo`030000003oool0oooo06<0oooo00<000000?ooo`3oool02@3oool000X0oooo00<0
00000?ooo`3oool0a@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool0a03oool00`000000oooo0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`33
0?ooo`8000001@3oool00`000000oooo0?ooo`040?ooo`800000a03oool00`000000oooo0?ooo`09
0?ooo`002P3oool00`000000oooo0?ooo`320?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`310?ooo`030000003oool0oooo00T0oooo000:0?ooo`03
0000003oool0oooo0<00oooo0P0000080?ooo`030000003oool0oooo00L0oooo0P0000310?ooo`03
0000003oool0oooo00T0oooo000:0?ooo`030000003oool0oooo0;l0oooo00<000000?ooo`3oool0
203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0;h0oooo00<000000?ooo`3oool0
2@3oool000X0oooo00<000000?ooo`3oool0_P3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0_@3oool00`000000oooo0?ooo`090?ooo`002P3oool0
0`000000oooo0?ooo`2l0?ooo`800000303oool00`000000oooo0?ooo`0;0?ooo`800000_@3oool0
0`000000oooo0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`2k0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`2i0?ooo`030000003oool0oooo
00X0oooo000:0?ooo`030000003oool0oooo0;T0oooo0P00000?0?ooo`030000003oool0oooo00h0
oooo0P00002i0?ooo`030000003oool0oooo00X0oooo000;0?ooo`030000003oool0oooo0;L0oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0;H0oooo
00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool0]@3oool200000180oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`2e0?ooo`030000003oool0oooo00X0oooo000;
0?ooo`030000003oool0oooo0;@0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0B
0?ooo`800000]@3oool00`000000oooo0?ooo`0:0?ooo`002`3oool00`000000oooo0?ooo`2c0?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`2a0?oo
o`030000003oool0oooo00/0oooo000<0?ooo`030000003oool0oooo0;00oooo0P00000F0?ooo`03
0000003oool0oooo01D0oooo0P00002a0?ooo`030000003oool0oooo00/0oooo000<0?ooo`030000
003oool0oooo0:l0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo0:h0oooo00<000000?ooo`3oool02`3oool000`0oooo00<000000?ooo`3oool0[@3o
ool2000001T0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`2]0?ooo`030000003o
ool0oooo00/0oooo000<0?ooo`030000003oool0oooo0:`0oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`0I0?ooo`800000[@3oool00`000000oooo0?ooo`0;0?ooo`00303oool00`00
0000oooo0?ooo`2[0?ooo`030000003oool0oooo01X0oooo0`00000K0?ooo`030000003oool0oooo
0:T0oooo00<000000?ooo`3oool0303oool000d0oooo00<000000?ooo`3oool0Z03oool2000001d0
oooo00<000000?ooo`3oool0703oool200000:T0oooo00<000000?ooo`3oool0303oool000d0oooo
00<000000?ooo`3oool0Y`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo01h0oooo
00<000000?ooo`3oool0YP3oool00`000000oooo0?ooo`0<0?ooo`003@3oool00`000000oooo0?oo
o`2U0?ooo`800000803oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0:D0oooo00<0
00000?ooo`3oool0303oool000h0oooo00<000000?ooo`3oool0X`3oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0oooo0200oooo0P00002U0?ooo`030000003oool0oooo00`0oooo000>0?oo
o`030000003oool0oooo0:80oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0R0?oo
o`030000003oool0oooo0:40oooo00<000000?ooo`3oool03@3oool000h0oooo00<000000?ooo`3o
ool0X03oool2000002@0oooo00<000000?ooo`3oool08`3oool200000:40oooo00<000000?ooo`3o
ool03@3oool000l0oooo00<000000?ooo`3oool0WP3oool00`000000oooo0?ooo`0T0?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool0WP3oool00`000000oooo0?ooo`0=0?ooo`003`3o
ool00`000000oooo0?ooo`2L0?ooo`8000009`3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo09d0oooo00<000000?ooo`3oool03@3oool000l0oooo00<000000?ooo`3oool0V`3oool0
0`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02L0oooo0P00002L0?ooo`030000003oool0
oooo00h0oooo000?0?ooo`030000003oool0oooo09X0oooo00<000000?ooo`3oool0:03oool00`00
0000oooo0?ooo`0Y0?ooo`030000003oool0oooo09T0oooo00<000000?ooo`3oool03P3oool00100
oooo00<000000?ooo`3oool0U`3oool2000002/0oooo00<000000?ooo`3oool0:P3oool2000009T0
oooo00<000000?ooo`3oool03P3oool00100oooo00<000000?ooo`3oool0UP3oool00`000000oooo
0?ooo`0[0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0U@3oool00`000000oooo
0?ooo`0?0?ooo`00403oool00`000000oooo0?ooo`2D0?ooo`800000;P3oool00`000000oooo0?oo
o`0]0?ooo`800000U@3oool00`000000oooo0?ooo`0?0?ooo`004@3oool00`000000oooo0?ooo`2B
0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`2A
0?ooo`030000003oool0oooo0100oooo000A0?ooo`030000003oool0oooo0940oooo00<000000?oo
o`3oool0;`3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0900oooo00<000000?oo
o`3oool0403oool00180oooo00<000000?ooo`3oool0SP3oool200000380oooo00<000000?ooo`3o
ool0<@3oool2000008l0oooo00<000000?ooo`3oool04@3oool00180oooo00<000000?ooo`3oool0
S@3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0
S03oool00`000000oooo0?ooo`0A0?ooo`004`3oool00`000000oooo0?ooo`2:0?ooo`800000=@3o
ool00`000000oooo0?ooo`0d0?ooo`800000R`3oool00`000000oooo0?ooo`0B0?ooo`004`3oool0
0`000000oooo0?ooo`290?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0=P3oool0
0`000000oooo0?ooo`280?ooo`030000003oool0oooo0180oooo000C0?ooo`030000003oool0oooo
08L0oooo0P00000h0?ooo`<00000=`3oool00`000000oooo0?ooo`260?ooo`030000003oool0oooo
01<0oooo000D0?ooo`030000003oool0oooo08D0oooo00<000000?ooo`3oool0>03oool00`000000
oooo0?ooo`0h0?ooo`800000QP3oool00`000000oooo0?ooo`0C0?ooo`00503oool00`000000oooo
0?ooo`240?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0>P3oool00`000000oooo
0?ooo`220?ooo`030000003oool0oooo01@0oooo000E0?ooo`030000003oool0oooo0840oooo0P00
000l0?ooo`030000003oool0oooo03/0oooo0P0000220?ooo`030000003oool0oooo01@0oooo000E
0?ooo`030000003oool0oooo0800oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0m
0?ooo`030000003oool0oooo07h0oooo00<000000?ooo`3oool05@3oool001H0oooo00<000000?oo
o`3oool0O@3oool2000003l0oooo00<000000?ooo`3oool0?P3oool00`000000oooo0?ooo`1m0?oo
o`030000003oool0oooo01D0oooo000F0?ooo`030000003oool0oooo07`0oooo00<000000?ooo`3o
ool0?`3oool00`000000oooo0?ooo`0o0?ooo`800000O03oool00`000000oooo0?ooo`0F0?ooo`00
5`3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0
@@3oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo01H0oooo000G0?ooo`030000003o
ool0oooo07P0oooo0P0000130?ooo`030000003oool0oooo0480oooo0P00001h0?ooo`030000003o
ool0oooo01L0oooo000H0?ooo`030000003oool0oooo07H0oooo00<000000?ooo`3oool0@`3oool0
0`000000oooo0?ooo`140?ooo`030000003oool0oooo07D0oooo00<000000?ooo`3oool05`3oool0
01P0oooo00<000000?ooo`3oool0M03oool2000004H0oooo00<000000?ooo`3oool0A@3oool00`00
0000oooo0?ooo`1c0?ooo`030000003oool0oooo01P0oooo000I0?ooo`030000003oool0oooo0780
oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`160?ooo`800000L`3oool00`000000
oooo0?ooo`0H0?ooo`006@3oool00`000000oooo0?ooo`1a0?ooo`030000003oool0oooo04L0oooo
00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo01T0oooo
000J0?ooo`030000003oool0oooo06h0oooo0P00001:0?ooo`030000003oool0oooo04T0oooo0P00
001_0?ooo`030000003oool0oooo01T0oooo000K0?ooo`030000003oool0oooo06`0oooo00<00000
0?ooo`3oool0BP3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo06/0oooo00<00000
0?ooo`3oool06P3oool001/0oooo00<000000?ooo`3oool0JP3oool2000004d0oooo00<000000?oo
o`3oool0C03oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo01/0oooo000L0?ooo`03
0000003oool0oooo06P0oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`1=0?ooo`80
0000J@3oool00`000000oooo0?ooo`0K0?ooo`00703oool00`000000oooo0?ooo`1W0?ooo`030000
003oool0oooo04h0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`1U0?ooo`030000
003oool0oooo01`0oooo000M0?ooo`030000003oool0oooo06@0oooo0P00001A0?ooo`030000003o
ool0oooo0500oooo0P00001T0?ooo`030000003oool0oooo01d0oooo000N0?ooo`030000003oool0
oooo0680oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0
oooo0640oooo00<000000?ooo`3oool07@3oool001l0oooo00<000000?ooo`3oool0G`3oool20000
05@0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo
01h0oooo000O0?ooo`030000003oool0oooo05h0oooo00<000000?ooo`3oool0E03oool3000005@0
oooo0P00001O0?ooo`030000003oool0oooo01h0oooo000P0?ooo`030000003oool0oooo05`0oooo
00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo05/0oooo
00<000000?ooo`3oool07`3oool00240oooo00<000000?ooo`3oool0F@3oool2000005P0oooo00<0
00000?ooo`3oool0E`3oool2000005X0oooo00<000000?ooo`3oool0803oool00280oooo00<00000
0?ooo`3oool0E`3oool00`000000oooo0?ooo`1H0?ooo`030000003oool0oooo05T0oooo00<00000
0?ooo`3oool0EP3oool00`000000oooo0?ooo`0Q0?ooo`008P3oool00`000000oooo0?ooo`1E0?oo
o`800000F`3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo05D0oooo00<000000?oo
o`3oool08@3oool002<0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`1K0?ooo`03
0000003oool0oooo05/0oooo0P00001D0?ooo`030000003oool0oooo0280oooo000T0?ooo`030000
003oool0oooo0500oooo0P00001N0?ooo`030000003oool0oooo05d0oooo00<000000?ooo`3oool0
D03oool00`000000oooo0?ooo`0S0?ooo`009@3oool00`000000oooo0?ooo`1>0?ooo`030000003o
ool0oooo05h0oooo00<000000?ooo`3oool0GP3oool2000004l0oooo00<000000?ooo`3oool0903o
ool002D0oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0
oooo0600oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`0T0?ooo`009P3oool00`00
0000oooo0?ooo`1:0?ooo`800000HP3oool00`000000oooo0?ooo`1Q0?ooo`030000003oool0oooo
04X0oooo00<000000?ooo`3oool09@3oool002L0oooo00<000000?ooo`3oool0B03oool00`000000
oooo0?ooo`1R0?ooo`030000003oool0oooo0680oooo0P0000190?ooo`030000003oool0oooo02H0
oooo000X0?ooo`030000003oool0oooo04D0oooo0P00001U0?ooo`030000003oool0oooo06@0oooo
00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0W0?ooo`00:@3oool00`000000oooo0?oo
o`130?ooo`030000003oool0oooo06D0oooo00<000000?ooo`3oool0I@3oool2000004D0oooo00<0
00000?ooo`3oool09`3oool002X0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`1V
0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0X
0?ooo`00:`3oool00`000000oooo0?ooo`0n0?ooo`800000J@3oool00`000000oooo0?ooo`1X0?oo
o`030000003oool0oooo03l0oooo00<000000?ooo`3oool0:@3oool002`0oooo00<000000?ooo`3o
ool0?03oool00`000000oooo0?ooo`1Y0?ooo`030000003oool0oooo06T0oooo0P00000n0?ooo`03
0000003oool0oooo02X0oooo000]0?ooo`030000003oool0oooo03T0oooo0P00001/0?ooo`030000
003oool0oooo06/0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0[0?ooo`00;P3o
ool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0K03o
ool2000003T0oooo00<000000?ooo`3oool0;03oool002l0oooo00<000000?ooo`3oool0=@3oool0
0`000000oooo0?ooo`1]0?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3oool0=@3oool0
0`000000oooo0?ooo`0]0?ooo`00<03oool00`000000oooo0?ooo`0b0?ooo`800000L03oool00`00
0000oooo0?ooo`1_0?ooo`800000=03oool00`000000oooo0?ooo`0^0?ooo`00<@3oool00`000000
oooo0?ooo`0`0?ooo`030000003oool0oooo0700oooo0`00001a0?ooo`030000003oool0oooo0300
oooo00<000000?ooo`3oool0;`3oool00340oooo00<000000?ooo`3oool0;P3oool2000007<0oooo
00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo0300oooo
000b0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0L`3oool00`000000oooo0?oo
o`1c0?ooo`800000;@3oool00`000000oooo0?ooo`0a0?ooo`00<`3oool00`000000oooo0?ooo`0Z
0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool0M@3oool00`000000oooo0?ooo`0Y
0?ooo`030000003oool0oooo0380oooo000d0?ooo`030000003oool0oooo02L0oooo0P00001g0?oo
o`030000003oool0oooo07H0oooo0P00000X0?ooo`030000003oool0oooo03<0oooo000e0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`1h0?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool0=03oool003H0oooo00<000000?ooo`3oool0
8P3oool2000007X0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`0Q0?ooo`800000
=`3oool003L0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`1j0?ooo`030000003o
ool0oooo07X0oooo0P00000P0?ooo`030000003oool0oooo03L0oooo000h0?ooo`030000003oool0
oooo01h0oooo00<000000?ooo`3oool0N`3oool00`000000oooo0?ooo`1l0?ooo`030000003oool0
oooo01`0oooo00<000000?ooo`3oool0>03oool003T0oooo00<000000?ooo`3oool06`3oool20000
07h0oooo00<000000?ooo`3oool0O@3oool2000001/0oooo00<000000?ooo`3oool0>@3oool003X0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo07l0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0j0?ooo`00>`3oool00`000000oooo
0?ooo`0F0?ooo`800000P@3oool00`000000oooo0?ooo`200?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool0>`3oool003`0oooo00<000000?ooo`3oool0503oool00`000000oooo0?oo
o`210?ooo`030000003oool0oooo0840oooo0P00000D0?ooo`030000003oool0oooo03`0oooo000m
0?ooo`030000003oool0oooo0140oooo0P0000240?ooo`030000003oool0oooo08<0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0m0?ooo`00?P3oool200000100oooo00<000000?oo
o`3oool0Q03oool00`000000oooo0?ooo`240?ooo`8000003`3oool00`000000oooo0?ooo`0n0?oo
o`00@03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo08D0oooo00<000000?ooo`3o
ool0QP3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo03l0oooo00110?ooo`030000
003oool0oooo00T0oooo0P0000280?ooo`030000003oool0oooo08L0oooo00<000000?ooo`3oool0
2@3oool00`000000oooo0?ooo`100?ooo`00@P3oool00`000000oooo0?ooo`070?ooo`030000003o
ool0oooo06X0oooo00D0omBK000000000000000009_Do`050?ooo`030=BK0000000009_D00D0oooo
00D0e9/0000000000000000009_Do`070?ooo`030000003oool0oooo08P0oooo0P0000080?ooo`03
0000003oool0oooo0440oooo00130?ooo`8000001@3oool2000006d0oooo00H0^W:K0=Coo`3oool0
oooD09/0V`3Dool40?ooo`030=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b
0000VmCo00H0oooo00<000000?ooo`3oool0RP3oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0480oooo00150?ooo`050000003oool0oooo0?ooo`000000KP3oool00`3oe9/009_D0?oo
o`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03oool01@3oool00`000000oooo0?oo
o`2;0?ooo`8000000P3oool2000004D0oooo00160?ooo`030000003oool0000006l0oooo00<0j[Yb
07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030?oDV`00Vm@0oooo00D0oooo00<00000
0?ooo`3oool0S@3oool2000004L0oooo00160?ooo`800000L03oool00`3Z^W80L[[Z0?ooo`020?oo
o`030?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool01@3oool4000008`0oooo0P0000170?oo
o`00A@3oool00`000000oooo0?ooo`02000006h0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/0
09_D0?ooo`0:0?ooo`030?ooe02K000000000080000000<0L[[Z0?ooo`3oool01@3oool00`000000
oooo0?ooo`2;0?ooo`8000000P3oool2000004D0oooo00140?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0J`3oool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo00X0oooo
00<0oooD09/0V`3Dool02P3oool00`000000oooo0?ooo`2:0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0@P3oool004<0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?oo
o`1[0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Coo`0:0?ooo`03
0000003oool0oooo08T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`110?ooo`00
@P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo06X0oooo00D0oooD09/000000000
001b0;[Zo`0<0?ooo`030?ooe02K000000000080000000<0002K0=Coo`3oool01@3oool00`000000
oooo0?ooo`270?ooo`8000002P3oool00`000000oooo0?ooo`100?ooo`00@@3oool00`000000oooo
0?ooo`090?ooo`800000R03oool00`000000oooo0?ooo`260?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0?`3oool00400oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`250?ooo`030000003oool0oooo08@0oooo0P00000?0?ooo`800000?`3oool003l0oooo00<00000
0?ooo`3oool03P3oool00`000000oooo0?ooo`240?ooo`030000003oool0oooo08<0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0l0?ooo`00?P3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo08<0oooo00<000000?ooo`3oool0PP3oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo03/0oooo000m0?ooo`030000003oool0oooo0180oooo0P0000230?ooo`03
0000003oool0oooo0800oooo0P00000G0?ooo`030000003oool0oooo03X0oooo000l0?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool0P03oool00`000000oooo0?ooo`1o0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0>@3oool003X0oooo0P00000I0?ooo`030000003o
ool0oooo07l0oooo00<000000?ooo`3oool0OP3oool00`000000oooo0?ooo`0J0?ooo`030000003o
ool0oooo03P0oooo000i0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0OP3oool0
0`000000oooo0?ooo`1l0?ooo`8000007P3oool00`000000oooo0?ooo`0g0?ooo`00>03oool00`00
0000oooo0?ooo`0L0?ooo`800000OP3oool00`000000oooo0?ooo`1k0?ooo`030000003oool0oooo
01l0oooo00<000000?ooo`3oool0=P3oool003L0oooo00<000000?ooo`3oool07`3oool00`000000
oooo0?ooo`1k0?ooo`030000003oool0oooo07T0oooo0P00000S0?ooo`800000=P3oool003H0oooo
00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0oooo07P0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0c0?ooo`00=@3oool00`000000oooo0?oo
o`0S0?ooo`800000NP3oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo02L0oooo00<0
00000?ooo`3oool0<P3oool003@0oooo00<000000?ooo`3oool09P3oool2000007P0oooo00<00000
0?ooo`3oool0M@3oool2000002/0oooo00<000000?ooo`3oool0<@3oool003<0oooo00<000000?oo
o`3oool0:@3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo07@0oooo00<000000?oo
o`3oool0;03oool00`000000oooo0?ooo`0`0?ooo`00<P3oool00`000000oooo0?ooo`0[0?ooo`80
0000M@3oool00`000000oooo0?ooo`1c0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3o
ool0;`3oool00340oooo00<000000?ooo`3oool0;P3oool2000007<0oooo0`00001a0?ooo`800000
<P3oool00`000000oooo0?ooo`0^0?ooo`00<03oool00`000000oooo0?ooo`0a0?ooo`030000003o
ool0oooo0700oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`0c0?ooo`800000;P3o
ool002l0oooo00<000000?ooo`3oool0<`3oool200000700oooo00<000000?ooo`3oool0KP3oool2
000003P0oooo00<000000?ooo`3oool0:`3oool002h0oooo00<000000?ooo`3oool0=P3oool20000
06h0oooo00<000000?ooo`3oool0K03oool2000003/0oooo00<000000?ooo`3oool0:P3oool002d0
oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`1[0?ooo`030000003oool0oooo06/0
oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0Y0?ooo`00;03oool00`000000oooo
0?ooo`0k0?ooo`800000J`3oool00`000000oooo0?ooo`1Y0?ooo`800000@03oool00`000000oooo
0?ooo`0X0?ooo`00:`3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo06P0oooo00<0
00000?ooo`3oool0I`3oool2000004<0oooo00<000000?ooo`3oool09`3oool002X0oooo00<00000
0?ooo`3oool0@03oool2000006P0oooo00<000000?ooo`3oool0I@3oool2000004H0oooo00<00000
0?ooo`3oool09P3oool002T0oooo00<000000?ooo`3oool0@`3oool2000006H0oooo00<000000?oo
o`3oool0I03oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo02D0oooo000X0?ooo`03
0000003oool0oooo04H0oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`1R0?ooo`80
0000B`3oool00`000000oooo0?ooo`0T0?ooo`009`3oool00`000000oooo0?ooo`180?ooo`800000
H`3oool00`000000oooo0?ooo`1P0?ooo`800000CP3oool00`000000oooo0?ooo`0S0?ooo`009@3o
ool2000004d0oooo0P00001Q0?ooo`030000003oool0oooo05l0oooo00<000000?ooo`3oool0CP3o
ool00`000000oooo0?ooo`0S0?ooo`00903oool00`000000oooo0?ooo`1?0?ooo`030000003oool0
oooo05h0oooo00<000000?ooo`3oool0G@3oool200000580oooo00<000000?ooo`3oool08P3oool0
02<0oooo00<000000?ooo`3oool0D@3oool2000005h0oooo00<000000?ooo`3oool0F`3oool20000
05D0oooo00<000000?ooo`3oool08@3oool00280oooo00<000000?ooo`3oool0E03oool2000005`0
oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo0200
oooo000Q0?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool0F@3oool00`000000oooo
0?ooo`1H0?ooo`800000FP3oool00`000000oooo0?ooo`0O0?ooo`00803oool00`000000oooo0?oo
o`1I0?ooo`800000F@3oool00`000000oooo0?ooo`1F0?ooo`800000G@3oool00`000000oooo0?oo
o`0N0?ooo`007`3oool00`000000oooo0?ooo`1L0?ooo`800000E`3oool00`000000oooo0?ooo`1D
0?ooo`800000H03oool00`000000oooo0?ooo`0M0?ooo`007P3oool00`000000oooo0?ooo`1O0?oo
o`800000E@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo0640oooo00<000000?oo
o`3oool0703oool001d0oooo00<000000?ooo`3oool0HP3oool2000005<0oooo00<000000?ooo`3o
ool0D@3oool2000006D0oooo00<000000?ooo`3oool06`3oool001`0oooo00<000000?ooo`3oool0
I@3oool200000540oooo00<000000?ooo`3oool0C`3oool2000006P0oooo00<000000?ooo`3oool0
6P3oool001/0oooo00<000000?ooo`3oool0J03oool2000004l0oooo0`00001=0?ooo`800000JP3o
ool00`000000oooo0?ooo`0J0?ooo`006P3oool00`000000oooo0?ooo`1[0?ooo`800000C@3oool0
0`000000oooo0?ooo`1;0?ooo`800000K@3oool00`000000oooo0?ooo`0I0?ooo`006@3oool00`00
0000oooo0?ooo`1^0?ooo`800000B`3oool00`000000oooo0?ooo`190?ooo`800000L03oool00`00
0000oooo0?ooo`0H0?ooo`00603oool00`000000oooo0?ooo`1a0?ooo`<00000B03oool00`000000
oooo0?ooo`170?ooo`800000L`3oool00`000000oooo0?ooo`0G0?ooo`005`3oool00`000000oooo
0?ooo`1e0?ooo`800000AP3oool00`000000oooo0?ooo`150?ooo`800000MP3oool00`000000oooo
0?ooo`0F0?ooo`005`3oool00`000000oooo0?ooo`1g0?ooo`800000A03oool00`000000oooo0?oo
o`120?ooo`<00000N@3oool00`000000oooo0?ooo`0E0?ooo`005P3oool00`000000oooo0?ooo`1j
0?ooo`800000@P3oool00`000000oooo0?ooo`100?ooo`800000O@3oool00`000000oooo0?ooo`0D
0?ooo`005@3oool00`000000oooo0?ooo`1m0?ooo`800000@03oool00`000000oooo0?ooo`0n0?oo
o`800000O`3oool00`000000oooo0?ooo`0D0?ooo`00503oool00`000000oooo0?ooo`200?ooo`80
0000?P3oool00`000000oooo0?ooo`0l0?ooo`800000PP3oool00`000000oooo0?ooo`0C0?ooo`00
4`3oool00`000000oooo0?ooo`230?ooo`800000?03oool00`000000oooo0?ooo`0j0?ooo`800000
Q03oool00`000000oooo0?ooo`0C0?ooo`004`3oool00`000000oooo0?ooo`250?ooo`<00000>@3o
ool00`000000oooo0?ooo`0g0?ooo`<00000Q`3oool00`000000oooo0?ooo`0B0?ooo`004P3oool0
0`000000oooo0?ooo`290?ooo`800000=`3oool00`000000oooo0?ooo`0e0?ooo`800000R`3oool0
0`000000oooo0?ooo`0A0?ooo`004P3oool00`000000oooo0?ooo`2;0?ooo`800000=@3oool00`00
0000oooo0?ooo`0c0?ooo`800000S@3oool00`000000oooo0?ooo`0A0?ooo`004@3oool00`000000
oooo0?ooo`2>0?ooo`800000<`3oool00`000000oooo0?ooo`0a0?ooo`800000T03oool00`000000
oooo0?ooo`0@0?ooo`00403oool00`000000oooo0?ooo`2A0?ooo`800000<@3oool00`000000oooo
0?ooo`0_0?ooo`800000TP3oool00`000000oooo0?ooo`0@0?ooo`00403oool00`000000oooo0?oo
o`2C0?ooo`800000;`3oool00`000000oooo0?ooo`0/0?ooo`<00000U@3oool00`000000oooo0?oo
o`0?0?ooo`003`3oool00`000000oooo0?ooo`2F0?ooo`<00000;03oool00`000000oooo0?ooo`0Z
0?ooo`800000V03oool00`000000oooo0?ooo`0?0?ooo`003`3oool00`000000oooo0?ooo`2I0?oo
o`800000:P3oool00`000000oooo0?ooo`0X0?ooo`800000V`3oool00`000000oooo0?ooo`0>0?oo
o`003P3oool00`000000oooo0?ooo`2L0?ooo`<000009`3oool00`000000oooo0?ooo`0V0?ooo`80
0000W@3oool00`000000oooo0?ooo`0>0?ooo`003@3oool00`000000oooo0?ooo`2P0?ooo`800000
9@3oool00`000000oooo0?ooo`0T0?ooo`800000X03oool00`000000oooo0?ooo`0=0?ooo`003@3o
ool00`000000oooo0?ooo`2R0?ooo`<000008P3oool300000240oooo0`00002R0?ooo`030000003o
ool0oooo00d0oooo000<0?ooo`030000003oool0oooo0:H0oooo0P00000P0?ooo`030000003oool0
oooo01h0oooo0`00002V0?ooo`030000003oool0oooo00`0oooo000<0?ooo`030000003oool0oooo
0:P0oooo0`00000M0?ooo`030000003oool0oooo01`0oooo0P00002Y0?ooo`030000003oool0oooo
00`0oooo000<0?ooo`030000003oool0oooo0:/0oooo0P00000K0?ooo`030000003oool0oooo01T0
oooo0`00002/0?ooo`030000003oool0oooo00/0oooo000;0?ooo`030000003oool0oooo0:h0oooo
0`00000H0?ooo`030000003oool0oooo01H0oooo0`00002_0?ooo`030000003oool0oooo00/0oooo
000;0?ooo`030000003oool0oooo0;40oooo0`00000E0?ooo`030000003oool0oooo01@0oooo0P00
002b0?ooo`030000003oool0oooo00/0oooo000;0?ooo`030000003oool0oooo0;@0oooo0P00000C
0?ooo`030000003oool0oooo0140oooo0`00002e0?ooo`030000003oool0oooo00X0oooo000:0?oo
o`030000003oool0oooo0;L0oooo0`00000@0?ooo`030000003oool0oooo00h0oooo0`00002h0?oo
o`030000003oool0oooo00X0oooo000:0?ooo`030000003oool0oooo0;X0oooo0P00000>0?ooo`03
0000003oool0oooo00`0oooo0P00002l0?ooo`030000003oool0oooo00T0oooo000:0?ooo`030000
003oool0oooo0;`0oooo0`00000;0?ooo`030000003oool0oooo00T0oooo0`00002n0?ooo`030000
003oool0oooo00T0oooo000:0?ooo`030000003oool0oooo0;l0oooo0P0000090?ooo`030000003o
ool0oooo00H0oooo0`0000310?ooo`030000003oool0oooo00T0oooo000:0?ooo`030000003oool0
oooo0<40oooo0`0000060?ooo`030000003oool0oooo00@0oooo0P0000340?ooo`030000003oool0
oooo00T0oooo000:0?ooo`030000003oool0oooo0<@0oooo0`0000030?ooo`040000003oool0oooo
0?ooo`<00000aP3oool00`000000oooo0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`370?oo
o`L00000b@3oool00`000000oooo0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`390?ooo`D0
0000b@3oool00`000000oooo0?ooo`090?ooo`002P3oool00`000000oooo0?ooo`360?ooo`<00000
00<0oooo0000003oool00P3oool300000<H0oooo00<000000?ooo`3oool02@3oool000X0oooo00<0
00000?ooo`3oool0``3oool3000000@0oooo00<000000?ooo`3oool0103oool300000<<0oooo00<0
00000?ooo`3oool02@3oool000X0oooo00<000000?ooo`3oool0_`3oool4000000L0oooo00<00000
0?ooo`3oool01`3oool400000;l0oooo00<000000?ooo`3oool02@3oool000X0oooo00<000000?oo
o`3oool0^`3oool4000000/0oooo00<000000?ooo`3oool02`3oool300000;`0oooo00<000000?oo
o`3oool02@3oool000X0oooo00<000000?ooo`3oool0^03oool3000000l0oooo00<000000?ooo`3o
ool03P3oool300000;P0oooo00<000000?ooo`3oool02P3oool000/0oooo00<000000?ooo`3oool0
/`3oool400000180oooo00<000000?ooo`3oool04@3oool300000;D0oooo00<000000?ooo`3oool0
2P3oool000/0oooo00<000000?ooo`3oool0[`3oool4000001H0oooo0`00000D0?ooo`@00000/@3o
ool00`000000oooo0?ooo`0:0?ooo`00303oool00`000000oooo0?ooo`2Z0?ooo`@000006P3oool0
0`000000oooo0?ooo`0H0?ooo`<00000[@3oool00`000000oooo0?ooo`0;0?ooo`00303oool00`00
0000oooo0?ooo`2W0?ooo`<000007P3oool00`000000oooo0?ooo`0K0?ooo`<00000ZP3oool00`00
0000oooo0?ooo`0;0?ooo`00303oool00`000000oooo0?ooo`2S0?ooo`@000008@3oool00`000000
oooo0?ooo`0N0?ooo`@00000Y@3oool00`000000oooo0?ooo`0<0?ooo`003@3oool00`000000oooo
0?ooo`2N0?ooo`@000009@3oool00`000000oooo0?ooo`0R0?ooo`@00000X@3oool00`000000oooo
0?ooo`0<0?ooo`003P3oool00`000000oooo0?ooo`2I0?ooo`@00000:@3oool00`000000oooo0?oo
o`0V0?ooo`@00000W03oool00`000000oooo0?ooo`0=0?ooo`003`3oool00`000000oooo0?ooo`2D
0?ooo`@00000;@3oool00`000000oooo0?ooo`0Z0?ooo`@00000U`3oool00`000000oooo0?ooo`0>
0?ooo`00403oool00`000000oooo0?ooo`2?0?ooo`@00000<@3oool00`000000oooo0?ooo`0^0?oo
o`@00000T@3oool200000140oooo000A0?ooo`030000003oool0oooo08X0oooo1000000e0?ooo`03
0000003oool0oooo0380oooo1000002<0?ooo`030000003oool0oooo0140oooo000B0?ooo`800000
QP3oool4000003T0oooo00<000000?ooo`3oool0=P3oool4000008L0oooo00<000000?ooo`3oool0
4P3oool001@0oooo00<000000?ooo`3oool0OP3oool5000003d0oooo00<000000?ooo`3oool0>P3o
ool400000880oooo00<000000?ooo`3oool04`3oool001D0oooo0P00001j0?ooo`@00000@P3oool0
0`000000oooo0?ooo`0n0?ooo`@00000O03oool2000001H0oooo000G0?ooo`030000003oool0oooo
07<0oooo100000160?ooo`030000003oool0oooo0480oooo1@00001f0?ooo`030000003oool0oooo
01H0oooo000H0?ooo`800000K`3oool4000004X0oooo00<000000?ooo`3oool0A`3oool5000006l0
oooo0P00000I0?ooo`006P3oool3000006H0oooo1P00001>0?ooo`030000003oool0oooo04`0oooo
1P00001V0?ooo`<000006`3oool001d0oooo1000001L0?ooo`H00000E03oool00`000000oooo0?oo
o`1B0?ooo`D00000GP3oool3000001h0oooo000Q0?ooo`800000D`3oool7000005X0oooo00<00000
0?ooo`3oool0E`3oool7000005D0oooo0P00000Q0?ooo`008`3oool4000004L0oooo2000001D0?oo
o`030?oDV`000000000000<0000000<009_D0?ooo`3oool0103oool00`000000oooo0?ooo`1N0?oo
o`T00000B03oool4000002<0oooo000W0?ooo`D00000>@3oool9000005l0oooo00<0^W9b0;[Zo`3o
ool01`3oool00`000000oooo0?ooo`1W0?ooo`P00000>03oool8000002L0oooo000/0?ooo`L00000
:P3oool8000006P0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`1_0?ooo`T00000
:`3oool4000002l0oooo000c0?ooobX00000L03oool00`2jLW80^^[o0?ooo`070?ooo`@00000M`3o
ool[000003<0oooo003=0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool0eP3oool0
0<d0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`3F0?ooo`00c@3oool00`2jLW80
^^[o0?ooo`070?ooo`030000003oool0oooo0=H0oooo003:0?ooo`050>ZjLP00000007:j0;YbLP2j
j_l0203oool00`000000oooo0?ooo`3F0?ooo`00c03oool00`3Z^W80001b0;[Zo`080?ooo`030000
003oool0oooo0=H0oooo003G0?ooo`030000003oool0oooo0=H0oooo003G0?ooo`030000003oool0
oooo0=H0oooo003G0?ooo`030000003oool0oooo0=H0oooo003G0?ooo`030000003oool0oooo0=H0
oooo003G0?ooo`030000003oool0oooo0=H0oooo0000\
\>"],
  ImageRangeCache->{{{0, 431}, {431, 0}} -> {-1.05001, -1.05001, 0.00730865, \
0.00730865}}]
}, Open  ]],

Cell["\<\
Las curvas planas m\[AAcute]s sencillas son las c\[OAcute]nicas que se \
definen como el conjunto de puntos donde se anula una funci\[OAcute]n polin\
\[OAcute]mica de grado dos con dos variables.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(ImplicitPlot[
        2\ x\ *y\  - \ x\^2 + y\^2 - 4 == 0, {x, \(-5\), 5}];\)\(\ \)\( (*\ 
      una\ hip\[EAcute]rbola\ *) \)\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 2.46969 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.0952381 1.23485 0.0952381 [
[.11905 1.22235 -6 -9 ]
[.11905 1.22235 6 0 ]
[.30952 1.22235 -6 -9 ]
[.30952 1.22235 6 0 ]
[.69048 1.22235 -3 -9 ]
[.69048 1.22235 3 0 ]
[.88095 1.22235 -3 -9 ]
[.88095 1.22235 3 0 ]
[.4875 .28247 -18 -4.5 ]
[.4875 .28247 0 4.5 ]
[.4875 .75866 -12 -4.5 ]
[.4875 .75866 0 4.5 ]
[.4875 1.71104 -6 -4.5 ]
[.4875 1.71104 0 4.5 ]
[.4875 2.18723 -12 -4.5 ]
[.4875 2.18723 0 4.5 ]
[ 0 0 0 0 ]
[ 1 2.46969 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11905 1.23485 m
.11905 1.2411 L
s
[(-4)] .11905 1.22235 0 1 Mshowa
.30952 1.23485 m
.30952 1.2411 L
s
[(-2)] .30952 1.22235 0 1 Mshowa
.69048 1.23485 m
.69048 1.2411 L
s
[(2)] .69048 1.22235 0 1 Mshowa
.88095 1.23485 m
.88095 1.2411 L
s
[(4)] .88095 1.22235 0 1 Mshowa
.125 Mabswid
.16667 1.23485 m
.16667 1.2386 L
s
.21429 1.23485 m
.21429 1.2386 L
s
.2619 1.23485 m
.2619 1.2386 L
s
.35714 1.23485 m
.35714 1.2386 L
s
.40476 1.23485 m
.40476 1.2386 L
s
.45238 1.23485 m
.45238 1.2386 L
s
.54762 1.23485 m
.54762 1.2386 L
s
.59524 1.23485 m
.59524 1.2386 L
s
.64286 1.23485 m
.64286 1.2386 L
s
.7381 1.23485 m
.7381 1.2386 L
s
.78571 1.23485 m
.78571 1.2386 L
s
.83333 1.23485 m
.83333 1.2386 L
s
.07143 1.23485 m
.07143 1.2386 L
s
.02381 1.23485 m
.02381 1.2386 L
s
.92857 1.23485 m
.92857 1.2386 L
s
.97619 1.23485 m
.97619 1.2386 L
s
.25 Mabswid
0 1.23485 m
1 1.23485 L
s
.5 .28247 m
.50625 .28247 L
s
[(-10)] .4875 .28247 1 0 Mshowa
.5 .75866 m
.50625 .75866 L
s
[(-5)] .4875 .75866 1 0 Mshowa
.5 1.71104 m
.50625 1.71104 L
s
[(5)] .4875 1.71104 1 0 Mshowa
.5 2.18723 m
.50625 2.18723 L
s
[(10)] .4875 2.18723 1 0 Mshowa
.125 Mabswid
.5 .3777 m
.50375 .3777 L
s
.5 .47294 m
.50375 .47294 L
s
.5 .56818 m
.50375 .56818 L
s
.5 .66342 m
.50375 .66342 L
s
.5 .85389 m
.50375 .85389 L
s
.5 .94913 m
.50375 .94913 L
s
.5 1.04437 m
.50375 1.04437 L
s
.5 1.13961 m
.50375 1.13961 L
s
.5 1.33009 m
.50375 1.33009 L
s
.5 1.42532 m
.50375 1.42532 L
s
.5 1.52056 m
.50375 1.52056 L
s
.5 1.6158 m
.50375 1.6158 L
s
.5 1.80628 m
.50375 1.80628 L
s
.5 1.90151 m
.50375 1.90151 L
s
.5 1.99675 m
.50375 1.99675 L
s
.5 2.09199 m
.50375 2.09199 L
s
.5 .18723 m
.50375 .18723 L
s
.5 .09199 m
.50375 .09199 L
s
.5 2.28247 m
.50375 2.28247 L
s
.5 2.3777 m
.50375 2.3777 L
s
.25 Mabswid
.5 0 m
.5 2.46969 L
s
0 0 m
1 0 L
1 2.46969 L
0 2.46969 L
closepath
clip
newpath
.5 Mabswid
.02381 1.01118 m
.02544 1.01177 L
.0303 1.01352 L
.03838 1.01642 L
.04961 1.02042 L
.06392 1.02547 L
.0812 1.0315 L
.10135 1.03841 L
.12422 1.04609 L
.14966 1.05438 L
.17748 1.06308 L
.20752 1.07195 L
.23955 1.08063 L
.27336 1.08864 L
.30872 1.09528 L
.34538 1.09947 L
.3831 1.09953 L
.42162 1.09284 L
.46068 1.07574 L
.5 1.04437 L
.53932 .99709 L
.57838 .93609 L
.6169 .86574 L
.65462 .79024 L
.69128 .71272 L
.72664 .63536 L
.76045 .55973 L
.79248 .48698 L
.82252 .41805 L
.85034 .35369 L
.87578 .29453 L
.89865 .24111 L
.9188 .19391 L
.93608 .15331 L
.95039 .11964 L
.96162 .09318 L
.9697 .07413 L
.97456 .06264 L
.97619 .0588 L
s
.02381 2.41089 m
.02544 2.40705 L
.0303 2.39556 L
.03838 2.37651 L
.04961 2.35005 L
.06392 2.31639 L
.0812 2.27579 L
.10135 2.22858 L
.12422 2.17517 L
.14966 2.11601 L
.17748 2.05164 L
.20752 1.98271 L
.23955 1.90997 L
.27336 1.83433 L
.30872 1.75698 L
.34538 1.67946 L
.3831 1.60396 L
.42162 1.53361 L
.46068 1.4726 L
.5 1.42532 L
.53932 1.39395 L
.57838 1.37685 L
.6169 1.37016 L
.65462 1.37022 L
.69128 1.37441 L
.72664 1.38105 L
.76045 1.38907 L
.79248 1.39775 L
.82252 1.40661 L
.85034 1.41532 L
.87578 1.4236 L
.89865 1.43128 L
.9188 1.43819 L
.93608 1.44422 L
.95039 1.44928 L
.96162 1.45328 L
.9697 1.45617 L
.97456 1.45792 L
.97619 1.45851 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{116.563, 287.813},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002^0001[b000`400?l00000o`00003o[P3oool0
05H0oooo00<000000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo
00<000000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo00<00000
0?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3o
ool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3o
ool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0D03oool00`00
0000oooo0?ooo`020?ooo`00EP3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0oooo00<0
oooo001F0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool00`3oool005H0oooo00<0
00000?ooo`3oool0C`3oool00`000000oooo0?ooo`030?ooo`00EP3oool00`000000oooo0?ooo`1>
0?ooo`030000003oool0oooo00@0oooo001F0?ooo`030000003oool0oooo04h0oooo00<000000?oo
o`3oool0103oool005H0oooo0P00001?0?ooo`030000003oool0oooo00@0oooo001F0?ooo`030000
003oool0oooo04d0oooo00<000000?ooo`3oool01@3oool005H0oooo00<000000?ooo`3oool0C@3o
ool00`000000oooo0?ooo`050?ooo`00EP3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0
oooo00H0oooo001F0?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool01P3oool005H0
oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`070?ooo`00EP3oool00`000000oooo
0?ooo`1;0?ooo`030000003oool0oooo00L0oooo001F0?ooo`030000003oool0oooo04X0oooo00<0
00000?ooo`3oool0203oool005H0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`08
0?ooo`00EP3oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo00T0oooo001F0?ooo`03
0000003oool0oooo04T0oooo00<000000?ooo`3oool02@3oool005H0oooo00<000000?ooo`3oool0
B@3oool00`000000oooo0?ooo`090?ooo`00EP3oool00`000000oooo0?ooo`180?ooo`030000003o
ool0oooo00X0oooo001F0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool02P3oool0
05H0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`0;0?ooo`00EP3oool00`000000
oooo0?ooo`170?ooo`030000003oool0oooo00/0oooo001F0?ooo`800000A`3oool00`000000oooo
0?ooo`0<0?ooo`00EP3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo00`0oooo001F
0?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0303oool005H0oooo00<000000?oo
o`3oool0A@3oool00`000000oooo0?ooo`0=0?ooo`00EP3oool00`000000oooo0?ooo`150?ooo`03
0000003oool0oooo00d0oooo001F0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0
3P3oool005H0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0>0?ooo`00EP3oool0
0`000000oooo0?ooo`140?ooo`030000003oool0oooo00h0oooo001F0?ooo`030000003oool0oooo
04<0oooo00<000000?ooo`3oool03`3oool005H0oooo00<000000?ooo`3oool0@`3oool00`000000
oooo0?ooo`0?0?ooo`00EP3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo00l0oooo
001F0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0403oool005H0oooo00<00000
0?ooo`3oool0@P3oool00`000000oooo0?ooo`0@0?ooo`00@`3oool00`3oe9/00000000000030000
0005002Ke03oool0oooo0?ooo`3oe9/00`0000000`2Ke?l0oooo0?ooo`020?ooo`030000003oool0
oooo0440oooo00<000000?ooo`3oool04@3oool004H0oooo00<0^W9b0;[Zo`3oool0103oool01P2j
LY/0e?oo0?ooo`3oom@0V`2K0=Coo`<0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?oo
o`0A0?ooo`00AP3oool00`2jLW80^^[o0?ooo`030?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb
07:jjP3oool00P3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo0140oooo00160?oo
o`030;YbLP2jj_l0oooo00<0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`020?oo
o`030000003oool0oooo0400oooo00<000000?ooo`3oool04P3oool003X0oooo00<0^W8000000000
00000`0000000`00L[X0oooo0?ooo`030?ooo`030;YbLP2jj_l0oooo00<0oooo00<0j[Yb07:jjP3o
ool00P3oool00`3oe9/009_D0?ooo`020?ooo`800000@@3oool00`000000oooo0?ooo`0B0?ooo`00
AP3oool00`2jLW80^^[o0?ooo`030?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool0
0P3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo01<0oooo00160?ooo`030;YbLP2j
j_l0oooo00<0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`020?ooo`030000003o
ool0oooo03l0oooo00<000000?ooo`3oool04`3oool004<0oooo00D0j[Yb00000000L[X0^W9b0;[Z
o`050?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo0`3oool00`000000oooo0?ooo`0n0?ooo`03
0000003oool0oooo01@0oooo00150?ooo`030>ZjLP000780^^[o00D0oooo00D0oooD09/000000000
001b0;[Zo`040?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0503oool005H0oooo
00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`0E0?ooo`00EP3oool00`000000oooo0?oo
o`0m0?ooo`030000003oool0oooo01D0oooo001F0?ooo`030000003oool0oooo03`0oooo00<00000
0?ooo`3oool05P3oool005H0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0F0?oo
o`00EP3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo01L0oooo001F0?ooo`030000
003oool0oooo03/0oooo00<000000?ooo`3oool05`3oool005H0oooo00<000000?ooo`3oool0>P3o
ool00`000000oooo0?ooo`0H0?ooo`00EP3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0
oooo01P0oooo001F0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool0603oool005H0
oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0I0?ooo`00EP3oool00`000000oooo
0?ooo`0i0?ooo`030000003oool0oooo01T0oooo001F0?ooo`800000>@3oool00`000000oooo0?oo
o`0J0?ooo`00EP3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo01X0oooo001F0?oo
o`030000003oool0oooo03L0oooo00<000000?ooo`3oool06`3oool005H0oooo00<000000?ooo`3o
ool0=`3oool00`000000oooo0?ooo`0K0?ooo`00EP3oool00`000000oooo0?ooo`0f0?ooo`030000
003oool0oooo01`0oooo001F0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0703o
ool005H0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?ooo`0M0?ooo`00EP3oool00`00
0000oooo0?ooo`0e0?ooo`030000003oool0oooo01d0oooo001F0?ooo`030000003oool0oooo03D0
oooo00<000000?ooo`3oool07@3oool005H0oooo00<000000?ooo`3oool0=03oool00`000000oooo
0?ooo`0N0?ooo`00EP3oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01h0oooo001F
0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool07`3oool005H0oooo00<000000?oo
o`3oool0<`3oool00`000000oooo0?ooo`0O0?ooo`00EP3oool00`000000oooo0?ooo`0b0?ooo`03
0000003oool0oooo0200oooo001F0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0
803oool005H0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0P0?ooo`00EP3oool0
0`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0240oooo001F0?ooo`800000<P3oool00`00
0000oooo0?ooo`0Q0?ooo`00EP3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo0280
oooo001F0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool08P3oool005H0oooo00<0
00000?ooo`3oool0<03oool00`000000oooo0?ooo`0R0?ooo`00EP3oool00`000000oooo0?ooo`0_
0?ooo`030000003oool0oooo02<0oooo001F0?ooo`030000003oool0oooo02l0oooo00<000000?oo
o`3oool08`3oool005H0oooo00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0T0?ooo`00
EP3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo02@0oooo001F0?ooo`030000003o
ool0oooo02h0oooo00<000000?ooo`3oool0903oool005H0oooo00<000000?ooo`3oool0;@3oool0
0`000000oooo0?ooo`0U0?ooo`00EP3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo
02D0oooo001F0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool09@3oool005H0oooo
00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0V0?ooo`00EP3oool00`000000oooo0?oo
o`0/0?ooo`030000003oool0oooo02H0oooo001F0?ooo`030000003oool0oooo02/0oooo00<00000
0?ooo`3oool09`3oool005H0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0W0?oo
o`00EP3oool2000002`0oooo00<000000?ooo`3oool09`3oool005H0oooo00<000000?ooo`3oool0
:P3oool00`000000oooo0?ooo`0X0?ooo`00EP3oool00`000000oooo0?ooo`0Z0?ooo`030000003o
ool0oooo02P0oooo001F0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0:@3oool0
05H0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0Y0?ooo`00EP3oool00`000000
oooo0?ooo`0X0?ooo`030000003oool0oooo02X0oooo001F0?ooo`030000003oool0oooo02P0oooo
00<000000?ooo`3oool0:P3oool005H0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?oo
o`0[0?ooo`00EP3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02/0oooo001F0?oo
o`030000003oool0oooo02H0oooo00<000000?ooo`3oool0;03oool005H0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0/0?ooo`00EP3oool00`000000oooo0?ooo`0U0?ooo`030000
003oool0oooo02d0oooo001F0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0;@3o
ool005H0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0]0?ooo`00EP3oool00`00
0000oooo0?ooo`0T0?ooo`030000003oool0oooo02h0oooo001F0?ooo`030000003oool0oooo02@0
oooo00<000000?ooo`3oool0;P3oool005H0oooo00<000000?ooo`3oool08`3oool00`000000oooo
0?ooo`0_0?ooo`00EP3oool2000002@0oooo00<000000?ooo`3oool0;`3oool005H0oooo00<00000
0?ooo`3oool08P3oool00`000000oooo0?ooo`0`0?ooo`00EP3oool00`000000oooo0?ooo`0R0?oo
o`030000003oool0oooo0300oooo001F0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3o
ool0<@3oool005H0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0a0?ooo`00EP3o
ool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0380oooo001F0?ooo`030000003oool0
oooo0200oooo00<000000?ooo`3oool0<P3oool005H0oooo00<000000?ooo`3oool07`3oool00`00
0000oooo0?ooo`0c0?ooo`00EP3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo03<0
oooo001F0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0=03oool005H0oooo00<0
00000?ooo`3oool07P3oool00`000000oooo0?ooo`0d0?ooo`00EP3oool00`000000oooo0?ooo`0M
0?ooo`030000003oool0oooo03D0oooo001F0?ooo`030000003oool0oooo01d0oooo00<000000?oo
o`3oool0=@3oool004d0oooo00D0e9/0000000000000000009_Do`040?ooo`030000003oool0oooo
01`0oooo00<000000?ooo`3oool0=P3oool004`0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000
VmCo00<0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0f0?ooo`00D@3oool00`3o
e9/009_D0?ooo`020?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0=`3oool00540
oooo00<0omBK002Ke03oool00P3oool2000001`0oooo00<000000?ooo`3oool0=`3oool004<0oooo
00<0^W800000000000000`0000000`00L[X0oooo0?ooo`050?ooo`030;Yb002Ke?l0oooo0080oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0h0?ooo`00C03oool00`3oom@0V`000000
00020000000307:jjP3oool0oooo0080oooo00<000000?ooo`3oool06P3oool00`000000oooo0?oo
o`0h0?ooo`00C03oool00`3oom@0V`2K0=Coo`070?ooo`030000003oool0oooo01T0oooo00<00000
0?ooo`3oool0>@3oool004`0oooo00<0oooD09/0V`3Dool01`3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo03T0oooo001<0?ooo`030?ooe02K000000000080000000<0002K0=Coo`3o
ool00P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03X0oooo001F0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0>P3oool005H0oooo00<000000?ooo`3oool0603o
ool00`000000oooo0?ooo`0j0?ooo`00EP3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo03/0oooo001F0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0>`3oool005H0
oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0l0?ooo`00EP3oool00`000000oooo
0?ooo`0F0?ooo`030000003oool0oooo03`0oooo001F0?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool0?@3oool005H0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0m
0?ooo`00EP3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo03h0oooo001F0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool0?P3oool005H0oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0o0?ooo`00EP3oool2000001@0oooo00<000000?ooo`3oool0?`3o
ool005H0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`100?ooo`00EP3oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo0400oooo001F0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool0@@3oool005H0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`110?ooo`00EP3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0480oooo001F
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0@P3oool005H0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`130?ooo`00EP3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo04@0oooo001F0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
A03oool005H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`150?ooo`00EP3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo04D0oooo001F0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0AP3oool005H0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`160?ooo`00EP3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo04L0oooo
001F0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0B03oool005H0oooo0P00000;
0?ooo`030000003oool0oooo04P0oooo001F0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0B@3oool005H0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`1:0?ooo`00
EP3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo04X0oooo001F0?ooo`030000003o
ool0oooo00L0oooo00<000000?ooo`3oool0B`3oool005H0oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`1;0?ooo`00EP3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
04`0oooo001F0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0C@3oool005H0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`1=0?ooo`00EP3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo04h0oooo001F0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0C`3oool000@0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo0500oooo00050?ooo`800000C`3oool01@000000oooo0?ooo`3oool00000
05<0oooo00070?ooo`<00000C03oool010000000oooo0?ooo`00001D0?ooo`002P3oool3000004T0
oooo00@000000?ooo`3oool00000E03oool000d0oooo0`0000160?ooo`030000003oool0000005D0
oooo000@0?ooo`<00000@`3oool2000005H0oooo000C0?ooo`@00000?`3oool2000005H0oooo000G
0?ooo`800000?03oool2000005L0oooo000I0?ooo`<00000>03oool00`000000oooo0000001G0?oo
o`00703oool4000003<0oooo00@000000?ooo`3oool00000E`3oool00200oooo0`00000_0?ooo`05
0000003oool0oooo0?ooo`000000E`3oool002<0oooo1000000Z0?ooo`030000003oool0oooo0080
oooo00<000000?ooo`3oool0E@3oool002L0oooo1000000T0?ooo`8000001@3oool00`000000oooo
0?ooo`1E0?ooo`00:`3oool3000001d0oooo100000070?ooo`030000003oool0oooo05D0oooo000^
0?ooo`@000005P3oool3000000/0oooo00<000000?ooo`3oool0E@3oool00380oooo1`00000;0?oo
o`@000003P3oool00`000000oooo0?ooo`1E0?ooo`00>@3oool;00000180oooo00<000000?ooo`3o
ool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3o
ool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0
oooo00<000000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo0P00
001F0?ooo`00EP3oool00`000000oooo0?ooo`1E0?ooo`005`3oool01@3oj[X0LP00000000000000
VmCo01T0oooo00<0oooD09/000000000100000000`2Ke?l0oooo0?ooo`0G0?ooo`030000003oool0
oooo01X0oooo00<0oooD09/000000000100000000`2Ke?l0oooo0?ooo`0J0?ooo`050?oZ^P1b0000
00000000002Ke?l04P3oool001T0oooo00<0e9/009_Do`3oool06P3oool00`3DV`00002K0=Coo`02
0?ooo`030>ZjV`2jj_l0oooo01P0oooo00<000000?ooo`3oool06`3oool00`3DV`00002K0=Coo`02
0?ooo`030>ZjV`2jj_l0oooo01d0oooo00<0e9/009_Do`3oool04P3oool001T0oooo00<0e9/009_D
o`3oool06`3oool00`3oe9/0001b0;[Zo`0L0?ooo`030000003oool0oooo01`0oooo00<0omBK0000
LP2jj_l08@3oool00`3DV`00VmCo0?ooo`0B0?ooo`005@3oool00`3Z^W8000000000000300000003
09_Do`3oool0oooo01X0oooo00<0onZj0780001b^^X06`3oool00`000000oooo0?ooo`0M0?ooo`03
0?oZ^P1b0000L[[Z01`0oooo00<0j[Yb0000000000000`0000000`2Ke?l0oooo0?ooo`0@0?ooo`00
303oool00`2jLP0000000000000300000009001b^P3oool0oooo0?oDV`0009/0e?oo0?ooo`3DV`00
VmCo0180oooo00<0^W800000000000000`0000000`00L[X0oooo0?ooo`040?ooo`030;Yb001b^^X0
oooo01T0oooo00<000000?ooo`3oool07`3oool00`2jLP00L[[Z0?ooo`0J0?ooo`060?oDV`0009/0
e?oo0?ooo`3DV`00VmCo4`3oool001H0oooo00D0j[Yb002Ke03oool0e9/009_Do`0P0?ooo`030;Yb
V`3Dool0oooo01P0oooo00<000000?ooo`3oool0803oool00`2jLY/0e?oo0?ooo`0J0?ooo`050>Zj
LP00Vm@0oooo0=BK002Ke?l04`3oool001L0oooo00@0^W8007:jjP3DV`00VmCo6`3oool00`3Z^W80
VmCo0?ooo`020?ooo`030=BK002Ke?l0oooo01P0oooo00<000000?ooo`3oool06`3oool00`3Z^W80
VmCo0?ooo`020?ooo`030=BK002Ke?l0oooo01/0oooo00@0^W8007:jjP3DV`00VmCo4`3oool001L0
oooo00@0onZj0780LP1bLP00VmCo6`3oool01`3oe9/0002K0=Coo`3oool0omBK0000LP2jj_l06@3o
ool00`000000oooo0?ooo`0K0?ooo`070?oDV`0009/0e?oo0?ooo`3oe9/0001b0;[Zo`0L0?ooo`04
0?oZ^P1b0780LW8009_Doa<0oooo000H0?ooo`030?oDV`000000VmCo01`0oooo00D0omBK00000000
0000001b0;[Zo`0J0?ooo`030000003oool0oooo01`0oooo00D0omBK000000000000001b0;[Zo`0N
0?ooo`030?oDV`000000VmCo01<0oooo001F0?ooo`030000003oool0oooo05D0oooo001F0?ooo`03
0000003oool0oooo05D0oooo001F0?ooo`030000003oool0oooo05D0oooo001F0?ooo`030000003o
ool0oooo05D0oooo001F0?ooo`030000003oool0oooo05D0oooo002^00000000103oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool005H0oooo
00<000000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo00<00000
0?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3o
ool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3o
ool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0
oooo00<000000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo00<0
00000?ooo`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo00<000000?oo
o`3oool0E@3oool005H0oooo00<000000?ooo`3oool0E@3oool005H0oooo0P00001F0?ooo`00EP3o
ool00`000000oooo0?ooo`1E0?ooo`00EP3oool00`000000oooo0?ooo`1E0?ooo`00EP3oool00`00
0000oooo0?ooo`1E0?ooo`00EP3oool00`000000oooo0?ooo`1E0?ooo`00EP3oool00`000000oooo
0?ooo`1E0?ooo`00EP3oool00`000000oooo0?ooo`1E0?ooo`00EP3oool00`000000oooo0?ooo`0?
0?oooa800000=03oool005H0oooo00<000000?ooo`3oool02P3oool500000180oooo0`00000a0?oo
o`00EP3oool00`000000oooo0?ooo`080?ooo`8000006P3oool4000002d0oooo001F0?ooo`030000
003oool0oooo00H0oooo0P00000P0?ooo`H000009`3oool005H0oooo00<000000?ooo`3oool0103o
ool2000002P0oooo1000000S0?ooo`00EP3oool00`000000oooo0?ooo`020?ooo`800000;P3oool2
00000240oooo001F0?ooo`050000003oool0oooo0?ooo`000000<P3oool3000001h0oooo001F0?oo
o`040000003oool0oooo000003H0oooo0P00000L0?ooo`00EP3oool3000003T0oooo1000000H0?oo
o`00EP3oool2000003h0oooo1000000D0?ooo`00E@3oool2000004<0oooo1000000@0?ooo`00E03o
ool00`000000oooo000000170?ooo`8000003P3oool005@0oooo00<000000?ooo`000000B@3oool2
000000`0oooo001C0?ooo`040000003oool0oooo000004/0oooo100000080?ooo`00DP3oool01@00
0000oooo0?ooo`3oool0000004l0oooo0P0000060?ooo`00D@3oool00`000000oooo0?ooo`020?oo
o`030000003oool0oooo04l0oooo0P0000040?ooo`00D@3oool00`000000oooo0?ooo`020?ooo`03
0000003oool0oooo05D0oooo001@0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
E@3oool004l0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`1E0?ooo`00C`3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo05D0oooo001>0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0E@3oool004d0oooo00<000000?ooo`3oool01P3oool00`000000
oooo0?ooo`1E0?ooo`00C@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo05D0oooo
001<0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0E@3oool004`0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`1E0?ooo`00B`3oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo05D0oooo001:0?ooo`030000003oool0oooo00T0oooo0P00001F0?ooo`00
BP3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo05D0oooo00190?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0E@3oool004P0oooo00<000000?ooo`3oool02`3oool0
0`000000oooo0?ooo`1E0?ooo`00B03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
05D0oooo00170?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0E@3oool004L0oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1E0?ooo`00AP3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo05D0oooo00150?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool0E@3oool004D0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`1E0?oo
o`00A03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo05D0oooo00140?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool0E@3oool004<0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`1E0?ooo`00@`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo05D0oooo00120?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0E@3oool00480
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`1E0?ooo`00@@3oool00`000000oooo
0?ooo`0B0?ooo`800000EP3oool00440oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`1E0?ooo`00@03oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo05D0oooo00100?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool0E@3oool003l0oooo00<000000?ooo`3o
ool0503oool00`000000oooo0?ooo`1E0?ooo`00?`3oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo05D0oooo000n0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0E@3o
ool003h0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`1E0?ooo`00?@3oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo05D0oooo000m0?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool0E@3oool003`0oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`1E0?ooo`00?03oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo05D0oooo000k
0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0E@3oool003/0oooo00<000000?oo
o`3oool03`3oool01@3DV`000000000000000000VmCo00@0oooo00<000000?ooo`3oool0E@3oool0
03X0oooo00<000000?ooo`3oool03`3oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l00`3o
ool00`000000oooo0?ooo`1E0?ooo`00>P3oool00`000000oooo0?ooo`0D0?ooo`030?oDV`00Vm@0
oooo0080oooo00<000000?ooo`3oool0E@3oool003T0oooo00<000000?ooo`3oool05@3oool00`3o
e9/009_D0?ooo`020?ooo`030000003oool0oooo05D0oooo000i0?ooo`030000003oool0oooo01D0
oooo00<0^W8009_Do`3oool00P3oool2000005H0oooo000h0?ooo`030000003oool0oooo0140oooo
00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`020?ooo`030000003oool0oooo05D0oooo
000h0?ooo`030000003oool0oooo0140oooo00<0oooD09/0V`3Dool01`3oool00`000000oooo0?oo
o`1E0?ooo`00=`3oool00`000000oooo0?ooo`0B0?ooo`030?ooe02K09/0e?oo00L0oooo00<00000
0?ooo`3oool0E@3oool003L0oooo00<000000?ooo`3oool04P3oool00`3oom@0V`00000000020000
00030000V`3Dool0oooo0080oooo00<000000?ooo`3oool0E@3oool003H0oooo00<000000?ooo`3o
ool07@3oool00`000000oooo0?ooo`1E0?ooo`00=P3oool00`000000oooo0?ooo`0M0?ooo`030000
003oool0oooo05D0oooo000e0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0E@3o
ool003D0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`1E0?ooo`00=@3oool00`00
0000oooo0?ooo`0N0?ooo`030000003oool0oooo05D0oooo000d0?ooo`030000003oool0oooo01l0
oooo00<000000?ooo`3oool0E@3oool003@0oooo00<000000?ooo`3oool07`3oool00`000000oooo
0?ooo`1E0?ooo`00<`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo05D0oooo000c
0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0E@3oool00380oooo00<000000?oo
o`3oool08@3oool00`000000oooo0?ooo`1E0?ooo`00<P3oool00`000000oooo0?ooo`0Q0?ooo`03
0000003oool0oooo05D0oooo000a0?ooo`030000003oool0oooo0280oooo0P00001F0?ooo`00<@3o
ool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo05D0oooo000`0?ooo`030000003oool0
oooo02<0oooo00<000000?ooo`3oool0E@3oool00300oooo00<000000?ooo`3oool08`3oool00`00
0000oooo0?ooo`1E0?ooo`00;`3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo05D0
oooo000_0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0E@3oool002l0oooo00<0
00000?ooo`3oool0903oool00`000000oooo0?ooo`1E0?ooo`00;P3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo05D0oooo000^0?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool0E@3oool002d0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`1E0?ooo`00
;@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo05D0oooo000/0?ooo`030000003o
ool0oooo02L0oooo00<000000?ooo`3oool0E@3oool002`0oooo00<000000?ooo`3oool09`3oool0
0`000000oooo0?ooo`1E0?ooo`00:`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo
05D0oooo000[0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0E@3oool002X0oooo
00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`1E0?ooo`00:P3oool00`000000oooo0?oo
o`0Y0?ooo`030000003oool0oooo05D0oooo000Y0?ooo`030000003oool0oooo02X0oooo0P00001F
0?ooo`00:@3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo05D0oooo000Y0?ooo`03
0000003oool0oooo02X0oooo00<000000?ooo`3oool0E@3oool002P0oooo00<000000?ooo`3oool0
:`3oool00`000000oooo0?ooo`1E0?ooo`00:03oool00`000000oooo0?ooo`0[0?ooo`030000003o
ool0oooo05D0oooo000W0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0E@3oool0
02L0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`1E0?ooo`009`3oool00`000000
oooo0?ooo`0/0?ooo`030000003oool0oooo05D0oooo000V0?ooo`030000003oool0oooo02d0oooo
00<000000?ooo`3oool0E@3oool002H0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?oo
o`1E0?ooo`009P3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo05D0oooo000U0?oo
o`030000003oool0oooo02h0oooo00<000000?ooo`3oool0E@3oool002D0oooo00<000000?ooo`3o
ool0;P3oool00`000000oooo0?ooo`1E0?ooo`00903oool00`000000oooo0?ooo`0_0?ooo`030000
003oool0oooo05D0oooo000T0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0E@3o
ool002<0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`1E0?ooo`008`3oool00`00
0000oooo0?ooo`0`0?ooo`030000003oool0oooo05D0oooo000R0?ooo`030000003oool0oooo0340
oooo0P00001F0?ooo`008P3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo05D0oooo
000Q0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0E@3oool00240oooo00<00000
0?ooo`3oool0<P3oool00`000000oooo0?ooo`1E0?ooo`00803oool00`000000oooo0?ooo`0c0?oo
o`030000003oool0oooo05D0oooo000P0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3o
ool0E@3oool001l0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`1E0?ooo`007`3o
ool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo05D0oooo000N0?ooo`030000003oool0
oooo03D0oooo00<000000?ooo`3oool0E@3oool001h0oooo00<000000?ooo`3oool0=@3oool00`00
0000oooo0?ooo`1E0?ooo`007P3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo05D0
oooo000M0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0E@3oool001d0oooo00<0
00000?ooo`3oool0=P3oool00`000000oooo0?ooo`1E0?ooo`007@3oool00`000000oooo0?ooo`0f
0?ooo`030000003oool0oooo05D0oooo000L0?ooo`030000003oool0oooo03L0oooo00<000000?oo
o`3oool0E@3oool001`0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`1E0?ooo`00
6`3oool00`000000oooo0?ooo`0h0?ooo`800000EP3oool001/0oooo00<000000?ooo`3oool0>03o
ool00`000000oooo0?ooo`1E0?ooo`006`3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0
oooo05D0oooo000J0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0E@3oool001X0
oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`1E0?ooo`006P3oool00`000000oooo
0?ooo`0i0?ooo`030000003oool0oooo05D0oooo000I0?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool0E@3oool001T0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`1E
0?ooo`00603oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo05D0oooo000H0?ooo`03
0000003oool0oooo03/0oooo00<000000?ooo`3oool0E@3oool001L0oooo00<000000?ooo`3oool0
?03oool00`000000oooo0?ooo`1E0?ooo`005`3oool00`000000oooo0?ooo`0l0?ooo`030000003o
ool0oooo05D0oooo000F0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0E@3oool0
01H0oooo00<000000?ooo`3oool0:P3oool00`3oe9/000000000000300000005002Ke03oool0oooo
0?ooo`3oe9/00`0000000`2Ke?l0oooo0?ooo`020?ooo`030000003oool0oooo05D0oooo000E0?oo
o`030000003oool0oooo02h0oooo00<0^W9b0;[Zo`3oool0103oool01P2jLY/0e?oo0?ooo`3oom@0
V`2K0=Coo`<0oooo00<000000?ooo`3oool0E@3oool001D0oooo00<000000?ooo`3oool0;P3oool0
0`2jLW80^^[o0?ooo`030?ooo`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3oool00P3oool0
0`000000oooo0?ooo`1E0?ooo`005@3oool00`000000oooo0?ooo`0^0?ooo`030;YbLP2jj_l0oooo
00<0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`020?ooo`030000003oool0oooo
05D0oooo000D0?ooo`030000003oool0oooo02l0oooo00<0^W9b0;[Zo`3oool00`3oool00`3Z^W80
L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo0080oooo0P00001F0?ooo`00503oool00`000000oooo
0?ooo`0_0?ooo`030;YbLP2jj_l0oooo00<0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D
0?ooo`020?ooo`030000003oool0oooo05D0oooo000C0?ooo`030000003oool0oooo0300oooo00<0
^W9b0;[Zo`3oool00`3oool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo0080oooo00<0
00000?ooo`3oool0E@3oool001<0oooo00<000000?ooo`3oool0;@3oool01@3Z^W800000001b^P2j
LW80^^[o00D0oooo00H0^W8009_Do`3oool0onZj0780V`3Dool30?ooo`030000003oool0oooo05D0
oooo000B0?ooo`030000003oool0oooo0300oooo00<0j[Yb0000LP2jj_l01@3oool01@3oom@0V`00
000000000780^^[o00@0oooo00<000000?ooo`3oool0E@3oool00180oooo00<000000?ooo`3oool0
@@3oool00`000000oooo0?ooo`1E0?ooo`004@3oool00`000000oooo0?ooo`120?ooo`030000003o
ool0oooo05D0oooo000A0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0E@3oool0
0140oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`1E0?ooo`00403oool00`000000
oooo0?ooo`130?ooo`030000003oool0oooo05D0oooo000@0?ooo`030000003oool0oooo04<0oooo
00<000000?ooo`3oool0E@3oool000l0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?oo
o`1E0?ooo`003`3oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo05D0oooo000?0?oo
o`030000003oool0oooo04@0oooo00<000000?ooo`3oool0E@3oool000h0oooo00<000000?ooo`3o
ool0A@3oool00`000000oooo0?ooo`1E0?ooo`003P3oool00`000000oooo0?ooo`150?ooo`030000
003oool0oooo05D0oooo000>0?ooo`030000003oool0oooo04D0oooo0P00001F0?ooo`003@3oool0
0`000000oooo0?ooo`160?ooo`030000003oool0oooo05D0oooo000=0?ooo`030000003oool0oooo
04H0oooo00<000000?ooo`3oool0E@3oool000`0oooo00<000000?ooo`3oool0A`3oool00`000000
oooo0?ooo`1E0?ooo`00303oool00`000000oooo0?ooo`170?ooo`030000003oool0oooo05D0oooo
000;0?ooo`030000003oool0oooo04P0oooo00<000000?ooo`3oool0E@3oool000/0oooo00<00000
0?ooo`3oool0B03oool00`000000oooo0?ooo`1E0?ooo`002P3oool00`000000oooo0?ooo`190?oo
o`030000003oool0oooo05D0oooo000:0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3o
ool0E@3oool000T0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`1E0?ooo`002@3o
ool00`000000oooo0?ooo`1:0?ooo`030000003oool0oooo05D0oooo00080?ooo`030000003oool0
oooo04/0oooo00<000000?ooo`3oool0E@3oool000P0oooo00<000000?ooo`3oool0B`3oool00`00
0000oooo0?ooo`1E0?ooo`00203oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo05D0
oooo00070?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool0E@3oool000L0oooo00<0
00000?ooo`3oool0C03oool00`000000oooo0?ooo`1E0?ooo`001P3oool00`000000oooo0?ooo`1=
0?ooo`030000003oool0oooo05D0oooo00060?ooo`030000003oool0oooo04d0oooo0P00001F0?oo
o`001P3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo05D0oooo00050?ooo`030000
003oool0oooo04h0oooo00<000000?ooo`3oool0E@3oool000D0oooo00<000000?ooo`3oool0CP3o
ool00`000000oooo0?ooo`1E0?ooo`00103oool00`000000oooo0?ooo`1?0?ooo`030000003oool0
oooo05D0oooo00040?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0E@3oool000@0
oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`1E0?ooo`00EP3oool00`000000oooo
0?ooo`1E0?ooo`00EP3oool00`000000oooo0?ooo`1E0?ooo`00EP3oool00`000000oooo0?ooo`1E
0?ooo`00EP3oool00`000000oooo0?ooo`1E0?ooo`00EP3oool00`000000oooo0?ooo`1E0?ooo`00
EP3oool00`000000oooo0?ooo`1E0?ooo`00EP3oool00`000000oooo0?ooo`1E0?ooo`00EP3oool0
0`000000oooo0?ooo`1E0?ooo`00EP3oool00`000000oooo0?ooo`1E0?ooo`00EP3oool00`000000
oooo0?ooo`1E0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 173.813}, {430.688, 0}} -> {-5.25005, -13.0091, \
0.0906158, 0.0906158}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Recta tangente en un punto de una curva plana", "Subsection"],

Cell["\<\
El c\[AAcute]lculo de la recta tangente depende de c\[OAcute]mo venga dada la \
curva. Consideremos los tres casos posibles.\
\>", "Text"],

Cell[TextData[{
  StyleBox["a)",
    FontWeight->"Bold"],
  " La tangente en un punto",
  Cell[BoxData[
      \(TraditionalForm\`\(\ 
      \((a, b)\) = \((a, f(a))\) \[Element] \[CapitalGamma]\)\)]],
  " es la recta de ecuaci\[OAcute]n cartesiana ",
  Cell[BoxData[
      \(TraditionalForm\`y - b = f\ ' \((a)\) \((x - a)\)\)]],
  ". El vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((1, f\ ' \((a)\))\)\)]],
  " es tangente a \[CapitalGamma] en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " y el vector ",
  Cell[BoxData[
      \(TraditionalForm\`\((f\ ' \((a)\), \(-1\))\)\)]],
  " es ortogonal a \[CapitalGamma] en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  ".\n",
  StyleBox["b)",
    FontWeight->"Bold"],
  " La tangente en un punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\) \[Element] \[CapitalGamma]\)]],
  " es la recta de ecuaci\[OAcute]n impl\[IAcute]cita ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]\[Del]\(g(a, b)\) \[VerticalSeparator] 
            \((x - a, y - b)\)\[RightAngleBracket] = 0\)]],
  ". Se supone que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(g(a, b)\) \[NotEqual] \ \((0, 0)\)\)]],
  " pues en otro caso, la tangente en ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  " no est\[AAcute] definida. El vector gradiente ",
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(g(a, b)\)\)]],
  " es ortogonal a \[CapitalGamma] en el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\((a, b)\)\)]],
  ".\n",
  StyleBox["c)",
    FontWeight->"Bold"],
  " Supuesto que ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{"\[Gamma]", 
                FormBox[\(' \((t\_0\)\),
                  "TraditionalForm"]}], ")"}],
            "TraditionalForm"], "\[NotEqual]", \((0, 0)\)}], 
        TraditionalForm]]],
  ", la tangente a \[Gamma] en ",
  Cell[BoxData[
      \(TraditionalForm\`t\_0\)]],
  " (suele decirse, aunque no es del todo correcto, vector tangente a \
\[CapitalGamma] en el punto ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(\[Gamma](t\_0\),
              "TraditionalForm"], ")"}], ")"}], TraditionalForm]]],
  " es la recta de ecuaciones param\[EAcute]tricas ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              RowBox[{
                FormBox[\(\((x, y)\) = \(\[Gamma](t\_0\)\),
                  "TraditionalForm"], ")"}], " ", "+", " ", 
              RowBox[{"t", " ", "\[Gamma]", 
                FormBox[\(' \((t\_0\)\),
                  "TraditionalForm"]}]}], ")"}], " "}], TraditionalForm]]],
  ". El vector ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              RowBox[{"\[Gamma]", 
                FormBox[\(' \((t\_0\)\),
                  "TraditionalForm"]}], ")"}],
            "TraditionalForm"], "=", 
          FormBox[
            RowBox[{
              RowBox[{
                FormBox[
                  RowBox[{
                    RowBox[{
                      FormBox[\((x' \((t\_0\)\),
                        "TraditionalForm"], ")"}], ",", \(y' \((t\_0\)\)}],
                  "TraditionalForm"], ")"}], ")"}],
            "TraditionalForm"]}], TraditionalForm]]],
  " es tangente a \[Gamma] en ",
  Cell[BoxData[
      \(TraditionalForm\`t\_0\)]],
  " (suele decirse, aunque no es del todo correcto, vector tangente a \
\[CapitalGamma] en ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            FormBox[\(\[Gamma](t\_0\),
              "TraditionalForm"], ")"}], ")"}], TraditionalForm]]],
  ". En los puntos en los que el vector derivada es el vector cero no est\
\[AAcute] definida la tangente."
}], "Text"],

Cell["Las siguientes gr\[AAcute]ficas ilustran estos conceptos.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(vectgnte1 = 
        Graphics[\n\t\tTable[{{Hue[ .65], 
                vector2D[{x, f[x]}, {1, \(f'\)[x]}]}, {Hue[0], 
                PointSize[ .012], Point[{x, f[x]}]}}, {x, \(-1.8\), 
              2.3,  .5}]\n\t\t\t\t\t];\)\), "\n", 
    \(\(Show[{graf1, vectgnte1}, ImageSize -> {407, \ 73}];\)\), "\n", 
    \(Clear[f, graf1, vectgnte1]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .17857 
%%ImageSize: 407 73 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.375 0.178571 0.0892857 0.178571 [
[ 0 0 0 0 ]
[ 1 .17857 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .08929 m
1 .08929 L
s
.375 0 m
.375 .17857 L
s
0 0 m
1 0 L
1 .17857 L
0 .17857 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
.004 w
.01786 .03953 m
.02221 .03596 L
.02627 .03346 L
.0286 .03237 L
.03073 .0316 L
.0319 .03125 L
.03317 .03094 L
.03438 .03071 L
.03549 .03055 L
.03656 .03045 L
.03771 .03038 L
.03879 .03036 L
.03978 .03039 L
.04094 .03046 L
.0416 .03052 L
.04221 .03059 L
.04451 .03097 L
.04576 .03125 L
.04694 .03155 L
.04914 .03222 L
.05408 .03419 L
.06396 .03963 L
.07305 .04577 L
.09358 .06073 L
.11272 .07315 L
.1306 .08211 L
.14778 .0883 L
.15741 .09089 L
.1662 .0928 L
.18409 .09566 L
.1942 .09683 L
.20355 .09772 L
.24036 .10038 L
.27576 .10317 L
.29389 .10517 L
.31345 .10806 L
.33223 .11177 L
.35201 .11697 L
.37052 .12325 L
.38774 .13046 L
.42435 .14948 L
.44301 .15976 L
.45284 .16469 L
.46325 .16917 L
.47254 .17223 L
.47508 .17287 L
.47781 .17347 L
.48018 .17389 L
.48275 .17425 L
.48396 .17438 L
Mistroke
.48525 .1745 L
.48647 .17458 L
.48757 .17463 L
.48871 .17467 L
.48993 .17468 L
.49109 .17466 L
.49215 .17463 L
.49318 .17457 L
.49414 .1745 L
.49633 .17428 L
.49845 .17398 L
.50073 .17356 L
.5057 .17229 L
.5103 .17068 L
.51534 .16843 L
.52068 .1655 L
.53956 .1511 L
.575 .11363 L
.5947 .09311 L
.60332 .08532 L
.61274 .07795 L
.6213 .07239 L
.63044 .06772 L
.6355 .0657 L
.64009 .0642 L
.64471 .06301 L
.64906 .06217 L
.65131 .06183 L
.65341 .06158 L
.65572 .06137 L
.65701 .06128 L
.65819 .06122 L
.65943 .06117 L
.66057 .06114 L
.66116 .06113 L
.66182 .06112 L
.66251 .06112 L
.66315 .06113 L
.66433 .06115 L
.66542 .06118 L
.6666 .06123 L
.66786 .0613 L
.66992 .06145 L
.67214 .06165 L
.67612 .06213 L
.68086 .06288 L
.68517 .06371 L
.70313 .0684 L
.72262 .0749 L
.76095 .0887 L
Mistroke
.78001 .09487 L
.78934 .09748 L
.79786 .09954 L
.80663 .10126 L
.81067 .10189 L
.81496 .10243 L
.81736 .10267 L
.81952 .10284 L
.82057 .10292 L
.8217 .10298 L
.82277 .10303 L
.82376 .10307 L
.82492 .10311 L
.82553 .10312 L
.82619 .10313 L
.82688 .10314 L
.82753 .10314 L
.82875 .10313 L
.8299 .10311 L
.83096 .10308 L
.83212 .10303 L
.83335 .10296 L
.83559 .1028 L
.83794 .10256 L
.84214 .10199 L
.84667 .10112 L
.85162 .09988 L
.8605 .09682 L
.86876 .09302 L
.88795 .081 L
.90538 .06827 L
.91071 .06468 L
Mfstroke
0 .1 1 r
.5 Mabswid
.05357 .03396 m
.23214 .11352 L
s
% Start of user PostScript
-1.8 -0.309819 -0.8 0.135732 MAarrowhead1
% End of user PostScript
1 0 0 r
.012 w
.05357 .03396 Mdot
0 .1 1 r
.5 Mabswid
.14286 .08675 m
.32143 .14616 L
s
% Start of user PostScript
-1.3 -0.014204 -0.3 0.318479 MAarrowhead1
% End of user PostScript
1 0 0 r
.012 w
.14286 .08675 Mdot
0 .1 1 r
.5 Mabswid
.23214 .09983 m
.41071 .11177 L
s
% Start of user PostScript
-0.8 0.0590401 0.2 0.125925 MAarrowhead1
% End of user PostScript
1 0 0 r
.012 w
.23214 .09983 Mdot
0 .1 1 r
.5 Mabswid
.32143 .10951 m
.5 .14399 L
s
% Start of user PostScript
-0.3 0.113252 0.7 0.306327 MAarrowhead1
% End of user PostScript
1 0 0 r
.012 w
.32143 .10951 Mdot
0 .1 1 r
.5 Mabswid
.41071 .14196 m
0 0 rlineto s
.41071 .14196 m
.47868 .17857 L
s
% Start of user PostScript
0.2 0.294988 1.2 0.83367 MAarrowhead1
% End of user PostScript
1 0 0 r
.012 w
.41071 .14196 Mdot
0 .1 1 r
.5 Mabswid
.5 .17371 m
.67857 .13936 L
s
% Start of user PostScript
0.7 0.472757 1.7 0.280435 MAarrowhead1
% End of user PostScript
1 0 0 r
.012 w
.5 .17371 Mdot
0 .1 1 r
.5 Mabswid
.58929 .09844 m
0 0 rlineto s
.58929 .09844 m
.68668 0 L
s
% Start of user PostScript
1.2 0.051255 2.2 -0.959452 MAarrowhead1
% End of user PostScript
1 0 0 r
.012 w
.58929 .09844 Mdot
0 .1 1 r
.5 Mabswid
.67857 .0625 m
.85714 .09088 L
s
% Start of user PostScript
1.7 -0.150023 2.7 0.00895087 MAarrowhead1
% End of user PostScript
1 0 0 r
.012 w
.67857 .0625 Mdot
0 .1 1 r
.5 Mabswid
.76786 .09104 m
.94643 .15014 L
s
% Start of user PostScript
2.2 0.00982796 3.2 0.340811 MAarrowhead1
% End of user PostScript
1 0 0 r
.012 w
.76786 .09104 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{407, 73},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40009R0000KB000`400?l00000o`00003oi03oool0
0`000000oooo0?ooo`3o0?ooog`0oooo003T0?ooo`030000003oool0oooo0;X0oooo00<001Wo0?oo
o`3oool0_P3oool00>@0oooo00<000000?ooo`3oool0^@3oool00`006Ol0oooo0?ooo`2o0?ooo`00
i03oool00`000000oooo0?ooo`2h0?ooo`03000Io`3oool0oooo0<00oooo003T0?ooo`030000003o
ool0oooo0;L0oooo00<001Wo0?ooo`3oool0`@3oool00>@0oooo00<000000?ooo`3oool0]P3oool0
0`006Ol0oooo0?ooo`320?ooo`00i03oool00`000000oooo0?ooo`2e0?ooo`03000Io`3oool0oooo
0<<0oooo003T0?ooo`030000003oool0oooo0;@0oooo00<001Wo0?ooo`3oool0a03oool00>@0oooo
00<000000?ooo`3oool0/`3oool00`006Ol0oooo0?ooo`350?ooo`00i03oool00`000000oooo0?oo
o`2b0?ooo`03000Io`3oool0oooo0<H0oooo003T0?ooo`030000003oool0oooo0;40oooo00<001Wo
0?ooo`3oool0a`3oool00>@0oooo00<000000?ooo`3oool0/03oool00`006Ol0oooo0?ooo`380?oo
o`00i03oool00`000000oooo0?ooo`2_0?ooo`03000Io`3oool0oooo0<T0oooo003T0?ooo`030000
003oool0oooo0:h0oooo00<001Wo0?ooo`3oool0bP3oool00>@0oooo00<000000?ooo`3oool0[@3o
ool00`006Ol0oooo0?ooo`3;0?ooo`00i03oool00`000000oooo0?ooo`2/0?ooo`03000Io`3oool0
oooo0<`0oooo003T0?ooo`030000003oool0oooo0:/0oooo00<001Wo0?ooo`3oool0c@3oool00>@0
oooo00<000000?ooo`3oool0ZP3oool00`006Ol0oooo0?ooo`3>0?ooo`005P3oool4000000H0oooo
0`3o00310?ooo`030000003oool0oooo0:T0oooo00<001Wo0?ooo`3oool0c`3oool00180oooo3@00
00050?l00<00oooo00<000000?ooo`3oool0Z03oool00`006Ol0oooo0?ooo`3@0?ooo`003`3oool8
000000030?ooo`000000000000@000001`3o002o0?ooo`030000003oool0oooo0:L0oooo00<001Wo
0?ooo`3oool0d@3oool000h0oooo1@00000;0?ooo`L0o`00_`3oool00`000000oooo0?ooo`2V0?oo
o`03000Io`3oool0oooo0=80oooo000=0?ooo`<000003P3oool70?l000030000003oool0oooo0;`0
oooo00<000000?ooo`3oool0Y@3oool00`006Ol0oooo0?ooo`3C0?ooo`002`3oool400000100oooo
1@3o00001000000001Wo000Io`00002l0?ooo`030000003oool0oooo0:@0oooo00<001Wo0?ooo`3o
ool0e03oool000X0oooo1000000B0?ooo`<0o`000P3oool20000008001Wo^`3oool00`000000oooo
0?ooo`2S0?ooo`03000Io`3oool0oooo0=D0oooo000;0?ooo`030000003oool0oooo01T0oooo0P00
0003000IokP0oooo00<000000?ooo`3oool0XP3oool00`006Ol0oooo0?ooo`3F0?ooo`00:03oool4
0000008001Wo]P3oool00`000000oooo0?ooo`2Q0?ooo`03000Io`3oool0oooo0=L0oooo000Z0?oo
o`@000000P006Ond0?ooo`030000003oool0oooo0:00oooo00<001Wo0?ooo`3oool0f03oool002/0
oooo10000000103oool001Wo000Io`006Ona0?ooo`030000003oool0oooo09l0oooo00<001Wo0?oo
o`3oool0f@3oool002d0oooo100000020?ooo`8001Wo[`3oool00`000000oooo0?ooo`2N0?ooo`03
000Io`3oool0oooo0=X0oooo000^0?ooo`@000000`3oool2000Iojd0oooo00<000000?ooo`3oool0
W@3oool00`006Ol0oooo0?ooo`3K0?ooo`00<03oool3000000@0oooo0P006On[0?ooo`030000003o
ool0oooo09d0oooo00<001Wo0?ooo`3oool0f`3oool00340oooo100000040?ooo`<001WoZ03oool0
0`000000oooo0?ooo`2L0?ooo`03000Io`3oool0oooo0=`0oooo000b0?ooo`@000001P3oool2000I
ojH0oooo00<000000?ooo`3oool0V`3oool00`006Ol0oooo0?ooo`3M0?ooo`00=03oool3000000L0
oooo0P006OnT0?ooo`030000003oool0oooo09X0oooo00<001Wo0?ooo`3oool0gP3oool003D0oooo
100000070?ooo`8001WoXP3oool00`000000oooo0?ooo`2I0?ooo`03000Io`3oool0oooo01T0oooo
0`3o00330?ooo`00=P3oool4000000P0oooo0`006OnO0?ooo`030000003oool0oooo09P0oooo00<0
01Wo0?ooo`3oool06@3oool50?l00<80oooo000h0?ooo`@000002@3oool2000Ioid0oooo00<00000
0?ooo`3oool0U`3oool00`006Ol0oooo0?ooo`0;0?ooo`h000001`3o00310?ooo`00>@3oool40000
00X0oooo0P006OnK0?ooo`030000003oool0oooo09H0oooo00<001Wo0?ooo`3oool01@3ooolE0000
00L0o`0000<000000?ooo`3oool0QP3oool00`000000oooo0?ooo`0e0?ooo`00>`3oool4000000X0
oooo0`006OnH0?ooo`030000003oool0oooo09D0oooo00<001Wo0?ooo`3oool0103oool:000000d0
oooo1`3o0006000Ioh40oooo1000000f0?ooo`00?03oool5000000/0oooo0P006OnF0?ooo`030000
003oool0oooo09@0oooo00<001Wo0?ooo`3oool00P3oool6000001D0oooo1@3o00000`3oool00000
00000004000000H001WoNP3oool4000003L0oooo000n0?ooo`D000002`3oool2000Ioi@0oooo00<0
00000?ooo`3oool0T`3oool010006Ol0oooo0?ooo`3oool6000001P0oooo0`3o00060?ooo`L00000
00<0oooo000Io`006Ol01@006Omb0?ooo`<00000>@3oool00400oooo1000000<0?ooo`8001WoTP3o
ool00`000000oooo0?ooo`2B0?ooo`03000Io`3oool0oooo00D00000:03oool7000000@0oooo1P00
6OmZ0?ooo`@00000>P3oool00480oooo1000000<0?ooo`<001WoS`3oool00`000000oooo0?ooo`2A
0?ooo`03000Io`3oool0000000@00000;@3oool7000000L0oooo1P006Ol/0?ooo`8001Wo=@3oool4
000003/0oooo00130?ooo`D000003@3oool2000Iohd0oooo00<000000?ooo`3oool0T03oool00`00
6Ol000000000000300000380oooo1`00000:0?ooo`L001Wo9@3oool4000Ioc40oooo1000000m0?oo
o`00A@3oool5000000d0oooo0P006On;0?ooo`030000003oool0oooo08l0oooo00<001Wo00000000
00000P00000g0?ooo`L000003P3oool6000Ioal0oooo1`006Ol]0?ooo`@00000?P3oool004L0oooo
1000000>0?ooo`8001WoR@3oool00`000000oooo0?ooo`2>0?ooo`04000Io`0000000000000003`0
oooo1`00000A0?ooo`H001Wo6@3oool9000IobX0oooo0`0000100?ooo`00B@3oool4000000h0oooo
0`006On60?ooo`030000003oool0oooo08d0oooo00@001Wo0000000000000000@03oool7000001@0
oooo1`006OlA0?ooo``001Wo9P3oool400000440oooo001:0?ooo`D000003`3oool2000Ioh@0oooo
00<000000?ooo`3oool0S03oool00`006Ol00000000000150?ooo`L00000603oool6000Io`/0oooo
3`006OlR0?ooo`@00000@P3oool004`0oooo1@00000?0?ooo`8001WoPP3oool00`000000oooo0?oo
o`2:0?ooo`04000000006Ol00000000004T0oooo1`00000K0?ooo`L001Wo103ooolA000Ioah0oooo
100000140?ooo`00CP3oool5000000<0oooo0`3o00090?ooo`8001Wo4@3oool00`006Ol0oooo0?oo
o`1/0?ooo`030000003oool0oooo08T0oooo00@00000000Io`0000000000C@3oool600000200oooo
60006OlJ0?ooo`@00000A@3oool00500oooo1@0000050?l000X0oooo0`006Ol>0?ooo`8001WoK@3o
ool00`000000oooo0?ooo`280?ooo`03000000006Ol000000580oooo1P00000Q0?oooaH001Wo5P3o
ool4000004L0oooo001B0?ooo`8000001`3o000<0?ooo`8001Wo2`3oool5000Iof/0oooo00<00000
0?ooo`3oool0Q`3oool00`00000001Wo0000001E0?ooo`L000001@3oool30?l001H0oooo60006OlC
0?ooo`@00000B03oool005@0oooo1`3o000>0?ooo`8001Wo2@3oool6000IofX0oooo00<000000?oo
o`3oool0QP3oool00`00000001Wo0000001I0?ooo`L0000000<0oooo0?l0003o00000`3o000E0?oo
oa/001Wo3P3oool4000004X0oooo001D000000L0o`0000<001Wo0000000000003@000003000Io`D0
000020006Oob00000003000Io`0000000000060000001`3o000D000001d001WoF@0000010?ooo`00
E@3oool50?l0008000000`006Ol6000000T0oooo0P006Ol30?ooo`X001WoI`3oool00`000000oooo
0?ooo`240?ooo`03000000006Ol000000640oooo00<000000?l0003o00001@3o000C0?ooob0001Wo
1`3oool4000004d0oooo001F0?ooo`<0o`001P3oool3000Io`T000001@3oool>000IofH0oooo00<0
00000?ooo`3oool0P`3oool00`00000001Wo0000001S0?ooo`L0o`0000<001Wo0?ooo`3oool0403o
oolJ000Io``0oooo1000001>0?ooo`00HP3oool3000Io`/000000P3oool=000IofD0oooo00<00000
0?ooo`3oool0OP3oool30?l000040?ooo`00000001Wo000006D0oooo1@3o0002000000<001Wo3`3o
ool@000Ioa<0oooo1@00001@0?ooo`00I@3oool3000Io`<0oooo1`00000?000Io`/0oooo0`3o001=
0?ooo`8001Wo1P3oool00`000000oooo0?ooo`1m0?ooo`D0o`0000<001Wo0000003oool0IP3oool3
0?l00080oooo10000003000Io`8000002P3oool6000Ioa/0oooo1P00001A0?ooo`00J03oool3000I
o`D0oooo00<00000000Io`006Ol03`006Ol5000000@0oooo1@3o001<0?ooo`D001Wo0`3oool00`00
0000oooo0?ooo`1l0?ooo`L0o`00L03oool4000000<001Wo1000000S0?ooo`H00000E03oool006/0
oooo0`006Ol30?oooa8001Wo1`0000070?l000030000003oool0oooo04P0oooo20006Ol00`000000
oooo0?ooo`1l0?ooo`L0o`00MP3oool01000000001Wo000Io`006Ol5000001d0oooo1P00001F0?oo
o`00KP3ooolG000Io`80oooo0`0000070?l000D001Wo1`00000o0?ooo`/001WoO03oool70?l007X0
oooo0`006Ol5000001@0oooo2@00001I0?ooo`00L03ooolF000Io`@0oooo1`3o00000`3oool00000
000000020000010001Wo0P00000d0?ooo`h001WoNP3oool50?l007h0oooo0`006Ol:000000L0oooo
3000001K0?ooo`00K`3ooolH000Io`@0oooo1@3o000=0?ooo`T000003`006OlW0?oooa4001WoMP3o
ool2000000<0o`00PP3oool3000Ioa@00000H@3oool006l0oooo6P006Ol30?ooo`<0o`006@3oool=
000000h001Wo0`3o000F0?oooa@001WoLP3oool3000008P0oooo0`006Ol30?ooo`T00000IP3oool0
07<0oooo5`006OlY0?ooo``000000`3oool50?l000d001Wo203ooolG000Iofh0oooo0`00002<0?oo
o`<001WoK`3oool007T0oooo4P006Ol^0?ooo`P000001`3o000<0?ooob8001WoJP3oool300000900
oooo0`006Om/0?ooo`00O`3oool>000Ioc80oooo0P0000070?l0008000004@3ooolN000IofH0oooo
0`00002D0?ooo`<001WoJ@3oool008<0oooo2`006Olc0?ooo`L0o`001@006Ol00`000000oooo0?oo
o`0;0?ooob0001WoH`3oool3000009P0oooo0`006OmV0?ooo`00QP3oool3000Io`80oooo10006Olc
0?ooo`D0o`000`3oool3000000D001Wo2@3ooolL000IofH0oooo0`00002L0?ooo`<001WoH`3oool0
08T0oooo0`006Olg0?ooo`<0o`00203oool4000000D001Wo103ooolF000Iof/0oooo0`00002P0?oo
o`<001WoH03oool008`0oooo10006Om20?ooo`D0000050006Om`0?ooo`<00000Y03oool3000Ioed0
oooo002@0?ooo`<001Wo5P3oool00`006Ol0oooo0?ooo`0Z0?ooo`D000002P006Ome0?ooo`<00000
Z03oool3000IoeX0oooo002C0?ooo`<001Wo4`3oool3000Iobd0oooo0P000004000Io`030000003o
ool0oooo00H001WoL@3oool300000:`0oooo10006OmF0?ooo`00UP3oool3000Io`l0oooo1@006Ol_
0?ooo`L0000000<0oooo0000003oool00P3oool5000IobL0oooo0P006Om20?ooo`<00000/@3oool3
000IoaH0oooo00<001Wo0?ooo`3oool0>P3oool009T0oooo0`006Ol<0?ooo`L001Wo<03oool60000
00P0oooo1@006OlR0?ooo`@001Wo?`3oool300000;D0oooo0`006OlC0?ooo`<001Wo>P3oool009`0
oooo0`006Ol90?ooo`T001Wo<@3oool6000000X0oooo1P006OlL0?ooo`H001Wo?03oool300000;T0
oooo0`006Ol?0?ooo`D001Wo>@3oool009l0oooo0`006Ol60?ooo`X001Wo<P3oool6000000h0oooo
1@006OlF0?ooo`T001Wo>@3oool300000;d0oooo0`006Ol<0?ooo`L001Wo=`3oool00:80oooo0`00
6Ol20?ooo`d001Wo<03oool00`000000oooo0?ooo`0600000100oooo1P006Ol@0?ooo`/001Wo=P3o
ool300000<40oooo0`006Ol90?ooo`T001Wo=@3oool00:D0oooo40006Ol_0?ooo`030000003oool0
oooo0080oooo1P00000D0?ooo`D001Wo2`3oool=000Ioc<0oooo0`0000350?ooo`<001Wo1@3oool;
000Ioc@0oooo002W0?oooa0001Wo;@3oool00`000000oooo0?ooo`050?ooo`D000005`3oool5000I
o`H0oooo3`006Ola0?ooo`800000b@3oool3000Io`80oooo3@006Olb0?ooo`00YP3ooolC000Iob/0
oooo00<000000?ooo`3oool01`3oool4000001/0oooo60006Ol]0?ooo`800000c@3oool@000Ioc40
oooo002V0?oooa@001Wo:P3oool00`000000oooo0?ooo`090?ooo`@000007P3ooolE000IobX0oooo
0`00003>0?oooa4001Wo;`3oool00:H0oooo5P006OlX0?ooo`030000003oool0oooo00X0oooo1@00
00030?ooo`<0o`005P3ooolG000IobL0oooo0`00000Z0?ooo`P001WoW@3ooolC000Iobd0oooo002V
0?oooaL001Wo9`3oool00`000000oooo0?ooo`0<0?ooo`D000001@3o000E0?oooaT001Wo903oool3
000002/0oooo60006On=0?oooa@001Wo;03oool00:D0oooo6P006OlU0?ooo`030000003oool0oooo
00h0oooo0P0000070?l001@0oooo6`006OlQ0?ooo`<00000;03ooolQ000Ioh<0oooo5`006OlZ0?oo
o`00Y@3ooolL000Iob<0oooo00<000000?ooo`3oool0403oool70?l001@0oooo7@006OlN0?ooo`<0
0000;P3ooolN000IohD0oooo60006OlY0?ooo`00Z`3ooolG000Iob80oooo00<000000?ooo`3oool0
403oool70?l001<0oooo80006OlK0?ooo`<00000;`3ooolL000IohL0oooo6P006OlW0?ooo`00]@3o
ool?000Iob00oooo00<000000?ooo`3oool04@3oool50?l0008001Wo4P3ooolH000Iob80oooo0`00
000`0?oooaX001WoR03ooolM000IobD0oooo002o0?ooo`H001Wo7`3oool00`000000oooo0?ooo`0B
0?ooo`<0o`000`000002000Ioa00oooo20006Ola0?ooo`<00000<@3ooolH000IohX0oooo7P006OlT
0?ooo`00i03oool00`000000oooo0?ooo`0G0?ooo`<000000P006Om60?ooo`<00000<P3ooolE000I
oiD0oooo60006OlR0?ooo`00i03oool00`000000oooo0?ooo`0I0?ooo`<000000P006Om30?ooo`<0
0000<@3ooolE000IojL0oooo2@006OlQ0?ooo`00i03oool00`000000oooo0?ooo`0K0?ooo`<00000
0P006Om00?ooo`<00000;@3oool5000Io`<0oooo40006OoC0?ooo`00i03oool00`000000oooo0?oo
o`0M0?ooo`<0000000<001Wo0000003oool0?03oool3000002P0oooo1P006Ol80?ooo`h001Woe@3o
ool00>@0oooo00<000000?ooo`3oool07`3oool20000008001Wo00<000000?ooo`3oool0=`3oool4
000002@0oooo1@006Ol>0?ooo``001Woe`3oool00>@0oooo00<000000?ooo`3oool08@3oool20000
008001Wo00<000000?ooo`3oool0=03oool400000200oooo1@006OlC0?ooo`T001WofP3oool00>@0
oooo00<000000?ooo`3oool08`3oool20000008001Wo00<000000?ooo`3oool0<@3oool3000001d0
oooo1@006OlI0?ooo`H001Wog03oool00>@0oooo00<000000?ooo`3oool09@3oool20000008001Wo
00<000000?ooo`3oool0;P3oool3000001T0oooo1@006OlN0?ooo`@001WogP3oool00>@0oooo00<0
00000?ooo`3oool09`3oool20000008001Wo00<000000?ooo`3oool0:P3oool4000001@0oooo1P00
6OlS0?ooo`8001Woh03oool00>@0oooo00<000000?ooo`3oool0:@3oool20000008001Wo00<00000
0?ooo`3oool09`3oool400000100oooo1@006Ooo0?ooo``0oooo003T0?ooo`030000003oool0oooo
02/0oooo0P000002000Io`030000003oool0oooo02@0oooo0`00000=0?ooo`D001Woo`3ooolA0?oo
o`00i03oool00`000000oooo0?ooo`0]0?ooo`80000000<001Wo0000000000008@3oool5000000T0
oooo1@006Ooo0?oooaH0oooo003T0?ooo`030000003oool0oooo02l0oooo00<00000000Io`006Ol0
0P00000M0?ooo`H000001@3oool5000Iool0oooo6`3oool00>@0oooo00<000000?ooo`3oool0<@3o
ool00`00000001Wo000Io`03000001T0oooo100000020?ooo`H001Woo`3ooolP0?ooo`00i03oool0
0`000000oooo0?ooo`0c0?ooo`03000000006Ol001Wo00@000003P3oool30?l00080oooo10000005
000Iool0oooo9P3oool00>@0oooo00<000000?ooo`3oool0=P3oool2000Io`H000002@3oool50?l0
00D001Woo`3oool[0?ooo`00i03oool00`000000oooo0?ooo`0h0?ooo`8001Wo300000070?l00003
0000003oool0oooo0?l0oooo;03oool00>@0oooo00<000000?ooo`3oool0>P3oool2000Io`030?oo
o`000000000000L000001`3o003o0?ooobl0oooo003T0?ooo`030000003oool0oooo03`0oooo00<0
01Wo0?ooo`3oool01`3oool70?l00?l0oooo;`3oool00001\
\>"],
  ImageRangeCache->{{{0, 609.5}, {108.5, 0}} -> {-2.10877, -0.500006, \
0.0138249, 0.0138249}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(gradg[x_, y_] = {D[g[x, y], x], D[g[x, y], y]};\)\), "\n", 
    \(puntos = 
      Union[graf2[\([1, 1, 1, 1, 1, 1]\)], 
        graf2[\([1, 1, 1, 2, 1, 1]\)]];  (*\ 
      as\[IAcute]\ obtengo\ una\ lista\ con\ los\ puntos\ de\ la\ \
gr\[AAcute]fica\ *) \n
    vectores = puntos /. {x_, y_} -> vector2D[{x, y}, gradg[x, y]];\n (*\ 
      vectores\ gradiente\ con\ base\ en\ los\ puntos\ *) \), "\n", 
    \(\(vectortgnal2 = 
        Graphics[\[IndentingNewLine]Table[{{Hue[ .65], 
                vectores[\([k]\)]}, {Hue[0], PointSize[ .015], 
                Point[puntos[\([k]\)]]}}, {k, 1, 
              Length[puntos]}]\[IndentingNewLine]\t\t\t\t\t];\)\), "\n", 
    \(\(Show[{graf2, vectortgnal2}];\)\), "\n", 
    \(Clear[graf2, puntos, vectores, vectortgnal2, g, gradg]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .7873 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.12987 0.393648 0.12987 [
[.11039 .38115 -6 -9 ]
[.11039 .38115 6 0 ]
[.24026 .38115 -6 -9 ]
[.24026 .38115 6 0 ]
[.37013 .38115 -6 -9 ]
[.37013 .38115 6 0 ]
[.62987 .38115 -3 -9 ]
[.62987 .38115 3 0 ]
[.75974 .38115 -3 -9 ]
[.75974 .38115 3 0 ]
[.88961 .38115 -3 -9 ]
[.88961 .38115 3 0 ]
[.4875 .00404 -12 -4.5 ]
[.4875 .00404 0 4.5 ]
[.4875 .13391 -12 -4.5 ]
[.4875 .13391 0 4.5 ]
[.4875 .26378 -12 -4.5 ]
[.4875 .26378 0 4.5 ]
[.4875 .52352 -6 -4.5 ]
[.4875 .52352 0 4.5 ]
[.4875 .65339 -6 -4.5 ]
[.4875 .65339 0 4.5 ]
[.4875 .78326 -6 -4.5 ]
[.4875 .78326 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .7873 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.11039 .39365 m
.11039 .3999 L
s
[(-3)] .11039 .38115 0 1 Mshowa
.24026 .39365 m
.24026 .3999 L
s
[(-2)] .24026 .38115 0 1 Mshowa
.37013 .39365 m
.37013 .3999 L
s
[(-1)] .37013 .38115 0 1 Mshowa
.62987 .39365 m
.62987 .3999 L
s
[(1)] .62987 .38115 0 1 Mshowa
.75974 .39365 m
.75974 .3999 L
s
[(2)] .75974 .38115 0 1 Mshowa
.88961 .39365 m
.88961 .3999 L
s
[(3)] .88961 .38115 0 1 Mshowa
.125 Mabswid
.13636 .39365 m
.13636 .3974 L
s
.16234 .39365 m
.16234 .3974 L
s
.18831 .39365 m
.18831 .3974 L
s
.21429 .39365 m
.21429 .3974 L
s
.26623 .39365 m
.26623 .3974 L
s
.29221 .39365 m
.29221 .3974 L
s
.31818 .39365 m
.31818 .3974 L
s
.34416 .39365 m
.34416 .3974 L
s
.3961 .39365 m
.3961 .3974 L
s
.42208 .39365 m
.42208 .3974 L
s
.44805 .39365 m
.44805 .3974 L
s
.47403 .39365 m
.47403 .3974 L
s
.52597 .39365 m
.52597 .3974 L
s
.55195 .39365 m
.55195 .3974 L
s
.57792 .39365 m
.57792 .3974 L
s
.6039 .39365 m
.6039 .3974 L
s
.65584 .39365 m
.65584 .3974 L
s
.68182 .39365 m
.68182 .3974 L
s
.70779 .39365 m
.70779 .3974 L
s
.73377 .39365 m
.73377 .3974 L
s
.78571 .39365 m
.78571 .3974 L
s
.81169 .39365 m
.81169 .3974 L
s
.83766 .39365 m
.83766 .3974 L
s
.86364 .39365 m
.86364 .3974 L
s
.08442 .39365 m
.08442 .3974 L
s
.05844 .39365 m
.05844 .3974 L
s
.03247 .39365 m
.03247 .3974 L
s
.00649 .39365 m
.00649 .3974 L
s
.91558 .39365 m
.91558 .3974 L
s
.94156 .39365 m
.94156 .3974 L
s
.96753 .39365 m
.96753 .3974 L
s
.99351 .39365 m
.99351 .3974 L
s
.25 Mabswid
0 .39365 m
1 .39365 L
s
.5 .00404 m
.50625 .00404 L
s
[(-3)] .4875 .00404 1 0 Mshowa
.5 .13391 m
.50625 .13391 L
s
[(-2)] .4875 .13391 1 0 Mshowa
.5 .26378 m
.50625 .26378 L
s
[(-1)] .4875 .26378 1 0 Mshowa
.5 .52352 m
.50625 .52352 L
s
[(1)] .4875 .52352 1 0 Mshowa
.5 .65339 m
.50625 .65339 L
s
[(2)] .4875 .65339 1 0 Mshowa
.5 .78326 m
.50625 .78326 L
s
[(3)] .4875 .78326 1 0 Mshowa
.125 Mabswid
.5 .03001 m
.50375 .03001 L
s
.5 .05599 m
.50375 .05599 L
s
.5 .08196 m
.50375 .08196 L
s
.5 .10793 m
.50375 .10793 L
s
.5 .15988 m
.50375 .15988 L
s
.5 .18586 m
.50375 .18586 L
s
.5 .21183 m
.50375 .21183 L
s
.5 .2378 m
.50375 .2378 L
s
.5 .28975 m
.50375 .28975 L
s
.5 .31573 m
.50375 .31573 L
s
.5 .3417 m
.50375 .3417 L
s
.5 .36767 m
.50375 .36767 L
s
.5 .41962 m
.50375 .41962 L
s
.5 .4456 m
.50375 .4456 L
s
.5 .47157 m
.50375 .47157 L
s
.5 .49754 m
.50375 .49754 L
s
.5 .54949 m
.50375 .54949 L
s
.5 .57547 m
.50375 .57547 L
s
.5 .60144 m
.50375 .60144 L
s
.5 .62741 m
.50375 .62741 L
s
.5 .67936 m
.50375 .67936 L
s
.5 .70534 m
.50375 .70534 L
s
.5 .73131 m
.50375 .73131 L
s
.5 .75728 m
.50375 .75728 L
s
.25 Mabswid
.5 0 m
.5 .7873 L
s
0 0 m
1 0 L
1 .7873 L
0 .7873 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
.5 Mabswid
.11039 .3936 m
.11172 .37507 L
.1157 .35662 L
.12231 .33843 L
.1315 .32061 L
.14321 .30329 L
.15735 .28659 L
.17383 .27062 L
.19254 .25549 L
.21335 .2413 L
.23612 .22815 L
.2607 .21614 L
.2869 .20533 L
.31457 .19582 L
.3435 .18765 L
.37349 .18089 L
.40436 .17559 L
.43587 .17177 L
.46783 .16947 L
.5 .16871 L
.53217 .16947 L
.56413 .17177 L
.59564 .17559 L
.62651 .18089 L
.6565 .18765 L
.68543 .19582 L
.7131 .20533 L
.7393 .21614 L
.76388 .22815 L
.78665 .2413 L
.80746 .25549 L
.82617 .27062 L
.84265 .28659 L
.85679 .30329 L
.8685 .32061 L
.87769 .33843 L
.8843 .35662 L
.88828 .37507 L
.88961 .3936 L
s
.11039 .39369 m
.11172 .41222 L
.1157 .43067 L
.12231 .44887 L
.1315 .46669 L
.14321 .48401 L
.15735 .50071 L
.17383 .51668 L
.19254 .53181 L
.21335 .546 L
.23612 .55914 L
.2607 .57116 L
.2869 .58196 L
.31457 .59148 L
.3435 .59964 L
.37349 .6064 L
.40436 .61171 L
.43587 .61552 L
.46783 .61782 L
.5 .61859 L
.53217 .61782 L
.56413 .61552 L
.59564 .61171 L
.62651 .6064 L
.6565 .59964 L
.68543 .59148 L
.7131 .58196 L
.7393 .57116 L
.76388 .55914 L
.78665 .546 L
.80746 .53181 L
.82617 .51668 L
.84265 .50071 L
.85679 .48401 L
.8685 .46669 L
.87769 .44887 L
.8843 .43067 L
.88828 .41222 L
.88961 .39369 L
s
0 .1 1 r
.11039 .3936 m
.02381 .39357 L
s
% Start of user PostScript
-3. -0.00034641 -3.66667 -0.00057735 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.11039 .3936 Mdot
0 .1 1 r
.5 Mabswid
.11039 .39369 m
.02381 .39372 L
s
% Start of user PostScript
-3. 0.00034641 -3.66667 0.00057735 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.11039 .39369 Mdot
0 .1 1 r
.5 Mabswid
.11172 .37507 m
.02544 .36269 L
s
% Start of user PostScript
-2.98975 -0.143032 -3.65414 -0.238387 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.11172 .37507 Mdot
0 .1 1 r
.5 Mabswid
.11172 .41222 m
.02544 .42461 L
s
% Start of user PostScript
-2.98975 0.143032 -3.65414 0.238387 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.11172 .41222 Mdot
0 .1 1 r
.5 Mabswid
.1157 .35662 m
.0303 .33194 L
s
% Start of user PostScript
-2.95908 -0.285086 -3.61666 -0.475144 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.1157 .35662 Mdot
0 .1 1 r
.5 Mabswid
.1157 .43067 m
.0303 .45535 L
s
% Start of user PostScript
-2.95908 0.285086 -3.61666 0.475144 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.1157 .43067 Mdot
0 .1 1 r
.5 Mabswid
.12231 .33843 m
.03838 .30161 L
s
% Start of user PostScript
-2.9082 -0.425193 -3.55447 -0.708656 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.12231 .33843 Mdot
0 .1 1 r
.5 Mabswid
.12231 .44887 m
.03838 .48568 L
s
% Start of user PostScript
-2.9082 0.425193 -3.55447 0.708656 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.12231 .44887 Mdot
0 .1 1 r
.5 Mabswid
.1315 .32061 m
.04961 .27192 L
s
% Start of user PostScript
-2.83745 -0.562396 -3.468 -0.937327 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.1315 .32061 Mdot
0 .1 1 r
.5 Mabswid
.1315 .46669 m
.04961 .51538 L
s
% Start of user PostScript
-2.83745 0.562396 -3.468 0.937327 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.1315 .46669 Mdot
0 .1 1 r
.5 Mabswid
.14321 .30329 m
.06392 .24305 L
s
% Start of user PostScript
-2.74732 -0.695757 -3.35784 -1.15959 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.14321 .30329 Mdot
0 .1 1 r
.5 Mabswid
.14321 .48401 m
.06392 .54424 L
s
% Start of user PostScript
-2.74732 0.695757 -3.35784 1.15959 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.14321 .48401 Mdot
0 .1 1 r
.5 Mabswid
.15735 .28659 m
.0812 .21521 L
s
% Start of user PostScript
-2.63842 -0.824365 -3.22474 -1.37394 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.15735 .28659 Mdot
0 .1 1 r
.5 Mabswid
.15735 .50071 m
.0812 .57208 L
s
% Start of user PostScript
-2.63842 0.824365 -3.22474 1.37394 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.15735 .50071 Mdot
0 .1 1 r
.5 Mabswid
.17383 .27062 m
.10135 .1886 L
s
% Start of user PostScript
-2.5115 -0.947342 -3.06961 -1.5789 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.17383 .27062 Mdot
0 .1 1 r
.5 Mabswid
.17383 .51668 m
.10135 .5987 L
s
% Start of user PostScript
-2.5115 0.947342 -3.06961 1.5789 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.17383 .51668 Mdot
0 .1 1 r
.5 Mabswid
.19254 .25549 m
.12422 .16338 L
s
% Start of user PostScript
-2.36742 -1.06385 -2.89352 -1.77308 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.19254 .25549 Mdot
0 .1 1 r
.5 Mabswid
.19254 .53181 m
.12422 .62392 L
s
% Start of user PostScript
-2.36742 1.06385 -2.89352 1.77308 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.19254 .53181 Mdot
0 .1 1 r
.5 Mabswid
.21335 .2413 m
.14966 .13973 L
s
% Start of user PostScript
-2.20717 -1.17309 -2.69765 -1.95514 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.21335 .2413 Mdot
0 .1 1 r
.5 Mabswid
.21335 .546 m
.14966 .64756 L
s
% Start of user PostScript
-2.20717 1.17309 -2.69765 1.95514 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.21335 .546 Mdot
0 .1 1 r
.5 Mabswid
.23612 .22815 m
.17748 .11782 L
s
% Start of user PostScript
-2.03184 -1.27431 -2.48337 -2.12385 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.23612 .22815 Mdot
0 .1 1 r
.5 Mabswid
.23612 .55914 m
.17748 .66947 L
s
% Start of user PostScript
-2.03184 1.27431 -2.48337 2.12385 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.23612 .55914 Mdot
0 .1 1 r
.5 Mabswid
.2607 .21614 m
.20752 .0978 L
s
% Start of user PostScript
-1.84264 -1.36683 -2.25211 -2.27805 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.2607 .21614 Mdot
0 .1 1 r
.5 Mabswid
.2607 .57116 m
.20752 .6895 L
s
% Start of user PostScript
-1.84264 1.36683 -2.25211 2.27805 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.2607 .57116 Mdot
0 .1 1 r
.5 Mabswid
.2869 .20533 m
.23955 .07979 L
s
% Start of user PostScript
-1.64084 -1.45001 -2.00548 -2.41669 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.2869 .20533 Mdot
0 .1 1 r
.5 Mabswid
.2869 .58196 m
.23955 .7075 L
s
% Start of user PostScript
-1.64084 1.45001 -2.00548 2.41669 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.2869 .58196 Mdot
0 .1 1 r
.5 Mabswid
.31457 .19582 m
.27336 .06393 L
s
% Start of user PostScript
-1.42784 -1.52329 -1.74514 -2.53882 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.31457 .19582 Mdot
0 .1 1 r
.5 Mabswid
.31457 .59148 m
.27336 .72337 L
s
% Start of user PostScript
-1.42784 1.52329 -1.74514 2.53882 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.31457 .59148 Mdot
0 .1 1 r
.5 Mabswid
.3435 .18765 m
.30872 .05032 L
s
% Start of user PostScript
-1.20509 -1.58617 -1.47288 -2.64361 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.3435 .18765 Mdot
0 .1 1 r
.5 Mabswid
.3435 .59964 m
.30872 .73697 L
s
% Start of user PostScript
-1.20509 1.58617 -1.47288 2.64361 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.3435 .59964 Mdot
0 .1 1 r
.5 Mabswid
.37349 .18089 m
.34538 .03906 L
s
% Start of user PostScript
-0.974098 -1.6382 -1.19056 -2.73034 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.37349 .18089 Mdot
0 .1 1 r
.5 Mabswid
.37349 .6064 m
.34538 .74824 L
s
% Start of user PostScript
-0.974098 1.6382 -1.19056 2.73034 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.37349 .6064 Mdot
0 .1 1 r
.5 Mabswid
.40436 .17559 m
.3831 .03022 L
s
% Start of user PostScript
-0.736456 -1.67905 -0.900113 -2.79842 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.40436 .17559 Mdot
0 .1 1 r
.5 Mabswid
.40436 .61171 m
.3831 .75708 L
s
% Start of user PostScript
-0.736456 1.67905 -0.900113 2.79842 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.40436 .61171 Mdot
0 .1 1 r
.5 Mabswid
.43587 .17177 m
.42162 .02386 L
s
% Start of user PostScript
-0.493784 -1.70843 -0.603513 -2.84738 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.43587 .17177 Mdot
0 .1 1 r
.5 Mabswid
.43587 .61552 m
.42162 .76344 L
s
% Start of user PostScript
-0.493784 1.70843 -0.603513 2.84738 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.43587 .61552 Mdot
0 .1 1 r
.5 Mabswid
.46783 .16947 m
.46068 .02003 L
s
% Start of user PostScript
-0.247738 -1.72613 -0.302791 -2.87689 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.46783 .16947 Mdot
0 .1 1 r
.5 Mabswid
.46783 .61782 m
.46068 .76727 L
s
% Start of user PostScript
-0.247738 1.72613 -0.302791 2.87689 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.46783 .61782 Mdot
0 .1 1 r
.5 Mabswid
.5 .16871 m
.5 .01875 L
s
% Start of user PostScript
0 -1.73205 0 -2.88675 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.5 .16871 Mdot
0 .1 1 r
.5 Mabswid
.5 .61859 m
.5 .76855 L
s
% Start of user PostScript
0 1.73205 0 2.88675 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.5 .61859 Mdot
0 .1 1 r
.5 Mabswid
.53217 .16947 m
.53932 .02003 L
s
% Start of user PostScript
0.247738 -1.72613 0.302791 -2.87689 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.53217 .16947 Mdot
0 .1 1 r
.5 Mabswid
.53217 .61782 m
.53932 .76727 L
s
% Start of user PostScript
0.247738 1.72613 0.302791 2.87689 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.53217 .61782 Mdot
0 .1 1 r
.5 Mabswid
.56413 .17177 m
.57838 .02386 L
s
% Start of user PostScript
0.493784 -1.70843 0.603513 -2.84738 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.56413 .17177 Mdot
0 .1 1 r
.5 Mabswid
.56413 .61552 m
.57838 .76344 L
s
% Start of user PostScript
0.493784 1.70843 0.603513 2.84738 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.56413 .61552 Mdot
0 .1 1 r
.5 Mabswid
.59564 .17559 m
.6169 .03022 L
s
% Start of user PostScript
0.736456 -1.67905 0.900113 -2.79842 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.59564 .17559 Mdot
0 .1 1 r
.5 Mabswid
.59564 .61171 m
.6169 .75708 L
s
% Start of user PostScript
0.736456 1.67905 0.900113 2.79842 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.59564 .61171 Mdot
0 .1 1 r
.5 Mabswid
.62651 .18089 m
.65462 .03906 L
s
% Start of user PostScript
0.974098 -1.6382 1.19056 -2.73034 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.62651 .18089 Mdot
0 .1 1 r
.5 Mabswid
.62651 .6064 m
.65462 .74824 L
s
% Start of user PostScript
0.974098 1.6382 1.19056 2.73034 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.62651 .6064 Mdot
0 .1 1 r
.5 Mabswid
.6565 .18765 m
.69128 .05032 L
s
% Start of user PostScript
1.20509 -1.58617 1.47288 -2.64361 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.6565 .18765 Mdot
0 .1 1 r
.5 Mabswid
.6565 .59964 m
.69128 .73697 L
s
% Start of user PostScript
1.20509 1.58617 1.47288 2.64361 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.6565 .59964 Mdot
0 .1 1 r
.5 Mabswid
.68543 .19582 m
.72664 .06393 L
s
% Start of user PostScript
1.42784 -1.52329 1.74514 -2.53882 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.68543 .19582 Mdot
0 .1 1 r
.5 Mabswid
.68543 .59148 m
.72664 .72337 L
s
% Start of user PostScript
1.42784 1.52329 1.74514 2.53882 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.68543 .59148 Mdot
0 .1 1 r
.5 Mabswid
.7131 .20533 m
.76045 .07979 L
s
% Start of user PostScript
1.64084 -1.45001 2.00548 -2.41669 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.7131 .20533 Mdot
0 .1 1 r
.5 Mabswid
.7131 .58196 m
.76045 .7075 L
s
% Start of user PostScript
1.64084 1.45001 2.00548 2.41669 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.7131 .58196 Mdot
0 .1 1 r
.5 Mabswid
.7393 .21614 m
.79248 .0978 L
s
% Start of user PostScript
1.84264 -1.36683 2.25211 -2.27805 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.7393 .21614 Mdot
0 .1 1 r
.5 Mabswid
.7393 .57116 m
.79248 .6895 L
s
% Start of user PostScript
1.84264 1.36683 2.25211 2.27805 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.7393 .57116 Mdot
0 .1 1 r
.5 Mabswid
.76388 .22815 m
.82252 .11782 L
s
% Start of user PostScript
2.03184 -1.27431 2.48337 -2.12385 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.76388 .22815 Mdot
0 .1 1 r
.5 Mabswid
.76388 .55914 m
.82252 .66947 L
s
% Start of user PostScript
2.03184 1.27431 2.48337 2.12385 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.76388 .55914 Mdot
0 .1 1 r
.5 Mabswid
.78665 .2413 m
.85034 .13973 L
s
% Start of user PostScript
2.20717 -1.17309 2.69765 -1.95514 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.78665 .2413 Mdot
0 .1 1 r
.5 Mabswid
.78665 .546 m
.85034 .64756 L
s
% Start of user PostScript
2.20717 1.17309 2.69765 1.95514 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.78665 .546 Mdot
0 .1 1 r
.5 Mabswid
.80746 .25549 m
.87578 .16338 L
s
% Start of user PostScript
2.36742 -1.06385 2.89352 -1.77308 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.80746 .25549 Mdot
0 .1 1 r
.5 Mabswid
.80746 .53181 m
.87578 .62392 L
s
% Start of user PostScript
2.36742 1.06385 2.89352 1.77308 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.80746 .53181 Mdot
0 .1 1 r
.5 Mabswid
.82617 .27062 m
.89865 .1886 L
s
% Start of user PostScript
2.5115 -0.947342 3.06961 -1.5789 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.82617 .27062 Mdot
0 .1 1 r
.5 Mabswid
.82617 .51668 m
.89865 .5987 L
s
% Start of user PostScript
2.5115 0.947342 3.06961 1.5789 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.82617 .51668 Mdot
0 .1 1 r
.5 Mabswid
.84265 .28659 m
.9188 .21521 L
s
% Start of user PostScript
2.63842 -0.824365 3.22474 -1.37394 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.84265 .28659 Mdot
0 .1 1 r
.5 Mabswid
.84265 .50071 m
.9188 .57208 L
s
% Start of user PostScript
2.63842 0.824365 3.22474 1.37394 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.84265 .50071 Mdot
0 .1 1 r
.5 Mabswid
.85679 .30329 m
.93608 .24305 L
s
% Start of user PostScript
2.74732 -0.695757 3.35784 -1.15959 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.85679 .30329 Mdot
0 .1 1 r
.5 Mabswid
.85679 .48401 m
.93608 .54424 L
s
% Start of user PostScript
2.74732 0.695757 3.35784 1.15959 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.85679 .48401 Mdot
0 .1 1 r
.5 Mabswid
.8685 .32061 m
.95039 .27192 L
s
% Start of user PostScript
2.83745 -0.562396 3.468 -0.937327 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.8685 .32061 Mdot
0 .1 1 r
.5 Mabswid
.8685 .46669 m
.95039 .51538 L
s
% Start of user PostScript
2.83745 0.562396 3.468 0.937327 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.8685 .46669 Mdot
0 .1 1 r
.5 Mabswid
.87769 .33843 m
.96162 .30161 L
s
% Start of user PostScript
2.9082 -0.425193 3.55447 -0.708656 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.87769 .33843 Mdot
0 .1 1 r
.5 Mabswid
.87769 .44887 m
.96162 .48568 L
s
% Start of user PostScript
2.9082 0.425193 3.55447 0.708656 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.87769 .44887 Mdot
0 .1 1 r
.5 Mabswid
.8843 .35662 m
.9697 .33194 L
s
% Start of user PostScript
2.95908 -0.285086 3.61666 -0.475144 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.8843 .35662 Mdot
0 .1 1 r
.5 Mabswid
.8843 .43067 m
.9697 .45535 L
s
% Start of user PostScript
2.95908 0.285086 3.61666 0.475144 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.8843 .43067 Mdot
0 .1 1 r
.5 Mabswid
.88828 .37507 m
.97456 .36269 L
s
% Start of user PostScript
2.98975 -0.143032 3.65414 -0.238387 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.88828 .37507 Mdot
0 .1 1 r
.5 Mabswid
.88828 .41222 m
.97456 .42461 L
s
% Start of user PostScript
2.98975 0.143032 3.65414 0.238387 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.88828 .41222 Mdot
0 .1 1 r
.5 Mabswid
.88961 .3936 m
.97619 .39357 L
s
% Start of user PostScript
3. -0.00034641 3.66667 -0.00057735 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.88961 .3936 Mdot
0 .1 1 r
.5 Mabswid
.88961 .39369 m
.97619 .39372 L
s
% Start of user PostScript
3. 0.00034641 3.66667 0.00057735 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.88961 .39369 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 226.688},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001E2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00b`3oool01@3DV`0000000000
00000000L[[Z0>00oooo003:0?ooo`070=BK0000Vm@0oooo0?ooo`3oom@0V`0007:jjP3O0?ooo`00
c`3oool00`3oe9/009_D0?ooo`050?ooo`030000003oool0oooo0=H0oooo003>0?ooo`030?oZ^P1b
0780^^[o00H0oooo1000003E0?ooo`00`@3oool00`2jLP0000000000000300000003001b^P3oool0
oooo0080oooo00@0j[Yb000000000780^^[o1`3oool00`000000oooo0?ooo`3F0?ooo`00cP3oool0
0`3oj[X0LP1b0;[Zo`060?ooo`030000003oool0oooo0=H0oooo003?0?ooo`030=BK002Ke?l0oooo
00D0oooo00<000000?ooo`3oool0eP3oool00<X0oooo00L0omBK0000LP2jj_l0oooo0?oZ^P1b0780
^^[o00H0oooo00<000000?ooo`3oool0eP3oool00</0oooo00D0onZj078000000000000009_Do`07
0?ooo`030000003oool0oooo0=H0oooo003G0?ooo`03000Io`3oool0oooo0=H0oooo00370?ooo`03
000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?ooo`360?ooo`00
a`3oool00`006Ol0oooo0?ooo`0=0?ooo`03000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool0
aP3oool00;H0oooo00<001Wo0?ooo`3oool03P3oool2000Io`d0oooo0`006Ol=0?ooo`8001Wo403o
ool00`006Ol0oooo0?ooo`2e0?ooo`00]P3oool00`006Ol0oooo0?ooo`0=0?ooo`<001Wo3@3oool3
000Io`d0oooo0`006Ol?0?ooo`03000Io`3oool0oooo0;D0oooo002V0?ooo`03000Io`3oool0oooo
00d0oooo0P006Ol>0?ooo`<001Wo3@3oool3000Io`030000003oool0oooo00X0oooo0`006Ol>0?oo
o`8001Wo3`3oool00`006Ol0oooo0?ooo`2U0?ooo`00YP3oool00`006Ol0oooo0?ooo`0=0?ooo`80
01Wo3P3oool3000Io`d0oooo0`006Ol=0?ooo`<001Wo3P3oool2000Io`l0oooo00<001Wo0?ooo`3o
ool0Y@3oool00:H0oooo0P006Ol=0?ooo`<001Wo3P3oool4000Io`/0oooo1@006Ol;0?ooo`@001Wo
3@3oool4000Io`d0oooo0P006OnW0?ooo`00YP3oool2000Io`d0oooo10006Ol<0?ooo`D001Wo2`3o
ool5000Io`/0oooo1@006Ol<0?ooo`@001Wo3@3oool2000IojL0oooo002F0?ooo`03000Io`3oool0
oooo00d0oooo0`006Ol<0?ooo`@001Wo303oool5000Io`/0oooo1@006Ol;0?ooo`D001Wo303oool4
000Io``0oooo0`006Ol?0?ooo`03000Io`3oool0oooo09D0oooo002F0?ooo`8001Wo3P3oool3000I
o``0oooo10006Ol<0?ooo`H001Wo2P3oool5000Io`X0oooo1P006Ol;0?ooo`D001Wo303oool3000I
o`h0oooo0P006OnG0?ooo`00UP3oool2000Io`d0oooo10006Ol<0?ooo`D001Wo2`3oool6000Io`T0
oooo1`006Ol90?ooo`H001Wo2`3oool5000Io``0oooo10006Ol=0?ooo`8001WoU`3oool009H0oooo
0`006Ol<0?ooo`D001Wo2`3oool5000Io`X0oooo1`006Ol90?ooo`L001Wo2@3oool7000Io`T0oooo
1P006Ol;0?ooo`D001Wo303oool3000IoiL0oooo002F0?ooo`<001Wo303oool5000Io`/0oooo1@00
6Ol:0?ooo`L001Wo2@3oool7000Io`T0oooo1`006Ol90?ooo`H001Wo2`3oool5000Io``0oooo0`00
6OnG0?ooo`00Q`3oool00`006Ol0oooo0?ooo`0<0?ooo`@001Wo2`3oool6000Io`T0oooo1`006Ol9
0?ooo`P001Wo203oool7000Io`P0oooo20006Ol90?ooo`L001Wo2@3oool6000Io`/0oooo10006Ol>
0?ooo`03000Io`3oool0oooo08H0oooo00270?ooo`8001Wo3@3oool4000Io`/0oooo1P006Ol90?oo
o`L001Wo2@3oool8000Io`L0oooo2@006Ol70?ooo`P001Wo203oool8000Io`T0oooo1P006Ol;0?oo
o`@001Wo3@3oool2000IohP0oooo00270?ooo`8001Wo3@3oool5000Io`X0oooo1P006Ol90?ooo`P0
01Wo1`3oool9000Io`L0oooo2@006Ol70?ooo`T001Wo1`3oool8000Io`T0oooo1P006Ol:0?ooo`D0
01Wo3@3oool2000IohP0oooo00270?ooo`<001Wo303oool5000Io`X0oooo1`006Ol80?ooo`P001Wo
1`3oool:000Io`H0oooo2@006Ol60?ooo`X001Wo1P3oool9000Io`P0oooo1`006Ol:0?ooo`D001Wo
303oool3000IohP0oooo00270?ooo`<001Wo303oool6000Io`T0oooo1`006Ol80?ooo`P001Wo1`3o
ool:000Io`H0oooo2@006Ol60?ooo`X001Wo1P3oool9000Io`P0oooo1`006Ol90?ooo`H001Wo303o
ool3000IohP0oooo001h0?ooo`03000Io`3oool0oooo00`0oooo10006Ol;0?ooo`H001Wo2@3oool8
000Io`L0oooo2@006Ol60?ooo`X001Wo1@3oool;000Io`D0oooo2P006Ol60?ooo`T001Wo1`3oool8
000Io`T0oooo1P006Ol;0?ooo`@001Wo3P3oool00`006Ol0oooo0?ooo`1g0?ooo`00N03oool2000I
o`d0oooo10006Ol:0?ooo`P001Wo203oool8000Io`L0oooo2@006Ol50?ooo`/001Wo1@3oool;000I
o`D0oooo2`006Ol40?ooo`X001Wo1`3oool8000Io`P0oooo20006Ol:0?ooo`@001Wo3@3oool2000I
ogT0oooo001h0?ooo`8001Wo3@3oool5000Io`T0oooo20006Ol80?ooo`P001Wo1P3oool:000Io`D0
oooo30006Ol40?ooo`/001Wo103oool<000Io`@0oooo2`006Ol60?ooo`P001Wo203oool8000Io`T0
oooo1@006Ol=0?ooo`8001WoN@3oool007P0oooo0`006Ol<0?ooo`D001Wo2@3oool9000Io`H0oooo
2P006Ol50?ooo`/001Wo103oool<000Io`T0oooo00<001Wo0?ooo`3oool01`3oool<000Io`<0oooo
30006Ol50?ooo`X001Wo1P3oool9000Io`T0oooo1@006Ol<0?ooo`<001WoN@3oool007P0oooo1000
6Ol;0?ooo`H001Wo203oool9000Io`H0oooo2P006Ol50?ooo`/001Wo2P3oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool01`3oool<000Io`D0oooo2P00
6Ol60?ooo`T001Wo203oool6000Io`/0oooo10006Omi0?ooo`00N03oool4000Io`/0oooo1P006Ol8
0?ooo`X001Wo1@3oool;000Io`@0oooo1P006Ol?0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo
0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0=0?ooo`H001Wo103oool;000Io`D0oooo2P006Ol8
0?ooo`H001Wo2`3oool4000IogT0oooo001i0?ooo`@001Wo2P3oool7000Io`L0oooo2P006Ol50?oo
o`/001Wo2@3oool00`006Ol0oooo0?ooo`0=0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?oo
o`3oool0303oool00`006Ol0oooo0?ooo`0=0?ooo`03000Io`3oool0oooo00L0oooo2`006Ol50?oo
o`X001Wo1`3oool7000Io`X0oooo10006Omj0?ooo`00JP3oool00`006Ol0oooo0?ooo`0<0?ooo`@0
01Wo2P3oool7000Io`L0oooo2`006Ol40?ooo`P001Wo303oool00`006Ol0oooo0?ooo`0=0?ooo`03
000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0=0?ooo`03
000Io`3oool0oooo00X0oooo20006Ol40?ooo`/001Wo1`3oool7000Io`X0oooo10006Ol>0?ooo`03
000Io`3oool0oooo06T0oooo001Z0?ooo`8001Wo3@3oool5000Io`T0oooo20006Ol60?ooo`/001Wo
103oool3000Io`80oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0=0?ooo`03000I
o`3oool0oooo00`0oooo00<001Wo000000000000303oool00`006Ol0oooo0?ooo`0=0?ooo`03000I
o`3oool0oooo00`0oooo00<001Wo0?ooo`3oool00`006Ol40?ooo`/001Wo1P3oool8000Io`T0oooo
1@006Ol=0?ooo`8001WoJ`3oool006X0oooo0P006Ol=0?ooo`H001Wo203oool8000Io`H0oooo3000
6Ol80?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00H0oooo30006Ol60?ooo`P001Wo203oool6000Io`d0oooo0P00
6Om[0?ooo`00JP3oool3000Io``0oooo1P006Ol80?ooo`T001Wo1@3oool9000Io``0oooo00<001Wo
0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo
0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo
0?ooo`3oool02P3oool9000Io`D0oooo2@006Ol80?ooo`H001Wo303oool3000Iof/0oooo001[0?oo
o`<001Wo2`3oool7000Io`L0oooo2@006Ol50?ooo`<001Wo0P3oool00`006Ol0oooo0?ooo`0=0?oo
o`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?oo
o`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?oo
o`03000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool00`006Ol50?ooo`T001Wo1`3oool7000I
o`/0oooo0`006Om/0?ooo`00J`3oool3000Io`/0oooo20006Ol60?ooo`X001Wo2@3oool00`006Ol0
oooo0?ooo`0=0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0
oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0
oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool01`3oool:000Io`H0
oooo20006Ol;0?ooo`<001WoK03oool006/0oooo10006Ol:0?ooo`P001Wo1P3oool:000Io`X0oooo
00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo
00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00d0oooo
00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00P0oooo
2P006Ol60?ooo`P001Wo2P3oool4000Iof`0oooo001M0?ooo`03000Io`3oool0oooo00/0oooo1@00
6Ol90?ooo`T001Wo1@3oool;000Io`T0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00L0oooo2`006Ol50?ooo`T001Wo2@3oool5000Io`d0oooo00<0
01Wo0?ooo`3oool0G03oool005d0oooo0P006Ol<0?ooo`D001Wo2@3oool9000Io`D0oooo20006Ol<
0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0=
0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0=
0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0:
0?ooo`P001Wo1@3oool9000Io`T0oooo1@006Ol<0?ooo`8001WoGP3oool005d0oooo0`006Ol;0?oo
o`H001Wo203oool:000Io`@0oooo0`006Ol30?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?oo
o`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00d0oooo00<001Wo0?oo
o`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00d0oooo00<001Wo0?oo
o`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00@001Wo0?oo
o`3oool0oooo0`006Ol40?ooo`X001Wo203oool6000Io`/0oooo0`006OmN0?ooo`00GP3oool2000I
o`/0oooo1`006Ol80?ooo`X001Wo2@3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo
00d0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0=0?ooo`03000Io`3oool0oooo
00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0=0?ooo`03000Io`3oool0oooo
00/0oooo00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo
00L0oooo2P006Ol80?ooo`L001Wo2`3oool2000Ioel0oooo001N0?ooo`<001Wo2`3oool6000Io`P0
oooo2P006Ol90?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0
oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0
oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0
oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool01`3oool:000Io`P0
oooo1P006Ol;0?ooo`<001WoG`3oool005h0oooo10006Ol:0?ooo`L001Wo1`3oool;000Io`P0oooo
00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`000000000000/0oooo
00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo
00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`060?ooo`/001Wo1`3oool7000Io`X0oooo
10006OmO0?ooo`00GP3oool5000Io`T0oooo20006Ol60?ooo`T001Wo2`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00T0oooo2@006Ol60?ooo`P001Wo2@3oool5000Ioel0oooo001N
0?ooo`D001Wo2@3oool8000Io`H0oooo1P006Ol>0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo
0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo
0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo
0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo
0?ooo`3oool0303oool6000Io`H0oooo20006Ol90?ooo`D001WoG`3oool005h0oooo1P006Ol80?oo
o`T001Wo1@3oool2000Io`<0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?oo
o`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?oo
o`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?oo
o`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?oo
o`03000Io`3oool0oooo00`0oooo00@001Wo0?ooo`3oool0oooo0P006Ol50?ooo`T001Wo203oool6
000Ioel0oooo001@0?ooo`03000Io`3oool0oooo00`0oooo1P006Ol70?ooo`X001Wo2P3oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`00
6Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`00
6Ol0oooo0?ooo`080?ooo`X001Wo1`3oool6000Io`h0oooo00<001Wo0?ooo`3oool0C`3oool00500
oooo0P006Ol=0?ooo`L001Wo1P3oool:000Io`X0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0
oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0
oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0
oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0
oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0203oool:000Io`H0
oooo1`006Ol=0?ooo`8001WoD@3oool00500oooo0`006Ol<0?ooo`L001Wo1`3oool:000Io`T0oooo
00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo
00<001Wo0?ooo`3oool01`3oool:000Io`L0oooo1`006Ol<0?ooo`8001WoDP3oool00540oooo0`00
6Ol;0?ooo`P001Wo1P3oool8000Io``0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`2K0000000000@0000000<0VmCo0?ooo`3oool0103oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0:0?ooo`P001Wo1P3oool8000Io`/0oooo0`006OmB0?ooo`00D@3oool4000Io`X0oooo2@006Ol5
0?ooo`H001Wo3P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo
0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00@001Wo
0=BK000009/0e?oo0P3oool00`3Z^Y/0^^[o0?ooo`050?ooo`03000Io`3oool0oooo00/0oooo00<0
01Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<0
01Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo1P00
6Ol50?ooo`T001Wo2P3oool4000Ioe80oooo001A0?ooo`D001Wo2P3oool9000Io`@0oooo0P006Ol3
0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;
0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<
0?ooo`05000Io`3oool0omBK0000LP2jj_l02@3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`04000Io`3o
ool0oooo0?ooo`8001Wo103oool9000Io`X0oooo1@006OmB0?ooo`00D@3oool6000Io`T0oooo2@00
6Ol90?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0<0?ooo`06000Io`3oool0oooo0?oZ^P1b0000L[[Z203oool010006Ol0000000000000000:0?oo
o`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?oo
o`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?oo
o`03000Io`3oool0oooo00L0oooo2@006Ol90?ooo`D001WoD`3oool00580oooo1P006Ol80?ooo`X0
01Wo2@3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3o
ool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3o
ool00`3oool00`2jLP0000000000000300000003001b^P3oool001Wo00@0oooo00<0^W8007:jjP3o
ool01P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3o
ool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3o
ool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00L0oooo2P006Ol80?ooo`H0
01WoD`3oool00580oooo1P006Ol80?ooo`/001Wo203oool00`006Ol0oooo0?ooo`0<0?ooo`03000I
o`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000I
o`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`030?ooo`030;Yb
V`3Dool0oooo00D0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000I
o`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000I
o`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`060?ooo`/001Wo
1`3oool7000Ioe<0oooo00150?ooo`03000Io`3oool0oooo00X0oooo1`006Ol70?ooo`X001Wo2P3o
ool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3o
ool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3o
ool00`006Ol0j[Yb09_Do`030?ooo`030=BK002Ke?l0oooo00D0oooo00<001Wo0?ooo`3oool02`3o
ool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3o
ool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3o
ool00`006Ol0oooo0?ooo`080?ooo`X001Wo1`3oool6000Io`d0oooo00<001Wo0?ooo`3oool0A03o
ool004D0oooo0P006Ol;0?ooo`P001Wo1P3oool8000Io``0oooo00<001Wo0?ooo`3oool0303oool0
0`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool0
0`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00P001Wo0?oDV`0009/0e?oo0?oo
o`3oe9/0001b0;[Zo`H0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03
000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03
000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0:0?ooo`P0
01Wo1P3oool7000Io``0oooo0P006Om60?ooo`00AP3oool2000Io`/0oooo20006Ol60?ooo`H001Wo
3@3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0
2`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0
303oool01P006Ol0omBK000000000000001b0;[Zo`L0oooo00<001Wo0?ooo`3oool02P3oool00`00
6Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`00
6Ol0oooo0?ooo`0;0?ooo`H001Wo1P3oool8000Io`/0oooo0P006Om70?ooo`00AP3oool3000Io`X0
oooo2@006Ol50?ooo`<001Wo0P3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00X0
oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00`0
oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00<0
01Wo1@3oool9000Io`X0oooo0`006Om70?ooo`00AP3oool4000Io`T0oooo2P006Ol40?ooo`03000I
o`3oool0oooo00<0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000I
o`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000I
o`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0:0?ooo`03000I
o`3oool0oooo00X0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000I
o`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000I
o`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`030?ooo`03000I
o`3oool0oooo0080oooo2@006Ol:0?ooo`@001WoA`3oool004H0oooo1@006Ol80?ooo`/001Wo2@3o
ool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3o
ool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3o
ool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02P3o
ool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02`3o
ool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3o
ool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00L0oooo2P006Ol90?ooo`@001WoB03o
ool004L0oooo1@006Ol80?ooo`/001Wo2@3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0
oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0
oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0
oooo00X0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0
oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0
oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0
oooo00L0oooo2`006Ol80?ooo`D001WoB03oool004L0oooo1P006Ol70?ooo``001Wo203oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`00
6Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`00
6Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02P3oool00`00
6Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`00
6Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00H0oooo2`006Ol80?ooo`H001WoB03oool004L0
oooo1`006Ol60?ooo`/001Wo2@3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00X0
oooo00<001Wo0000000000002P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00L0
oooo2P006Ol70?ooo`L001WoB03oool004P0oooo1`006Ol50?ooo`T001Wo303oool00`006Ol0oooo
0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo
0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo
0?ooo`0;0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo
0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo
0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo
0?ooo`0;0?ooo`03000Io`3oool0oooo00X0oooo20006Ol60?ooo`L001WoB@3oool003X0oooo00<0
01Wo0?ooo`3oool02`3oool8000Io`D0oooo1P006Ol>0?ooo`03000Io`3oool0oooo00/0oooo00<0
01Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<0
01Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00X0oooo0P3o
000;0?ooo`80o`00303oool20?l000`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool6000Io`D0oooo2000
6Ol=0?ooo`03000Io`3oool0oooo03T0oooo000j0?ooo`8001Wo303oool9000Io`@0oooo10006Ol2
0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;
0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0:
0?ooo`03000Io`3oool0oooo00/0oooo0P3o000:0?ooo`@0o`002@3oool40?l000X0oooo103o000:
0?ooo`80o`003@3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo
0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo
0?ooo`3oool0303oool00`006Ol0oooo0?ooo`03000Io`D0oooo2@006Ol<0?ooo`8001Wo>`3oool0
03/0oooo0`006Ol;0?ooo`T001Wo0`3oool2000Io`@0oooo00<001Wo0?ooo`3oool0303oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`00
6Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02@3oool40?l0
00D0oooo0`0000060?l000L000001P3o0008000000H0o`000`0000050?ooo`@0o`002`3oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`00
6Ol0oooo0?ooo`020?ooo`03000Io`3oool0oooo0080oooo2@006Ol;0?ooo`<001Wo?03oool003/0
oooo10006Ol:0?ooo`X001Wo2@3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00X0
oooo00<001Wo0?ooo`3oool02P3oool20?l000T0oooo00<000000?l0003o0000103o0004000000<0
oooo1P3o00070?ooo`H0o`00203oool60?l000<0oooo100000060?l000030000003oool0oooo00H0
oooo0P3o000=0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0
oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0
oooo0?ooo`070?ooo`X001Wo2P3oool4000Ioc`0oooo000l0?ooo`@001Wo2@3oool;000Io`P0oooo
00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00T0oooo
103o00020?ooo`H0000000<0oooo0?l0003o0000103o00080?ooo`@0o`002@3oool40?l000X0oooo
103o00080?ooo`H0o`0000<0oooo000000000000100000000`3oool0o`000?l000020?l000`0oooo
00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00L0oooo
2`006Ol90?ooo`@001Wo?@3oool003`0oooo1P006Ol70?ooo``001Wo203oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00X0oooo0P3o00080?ooo`H0o`0000<000000?ooo`3oool01P3o
ool40?l000X0oooo0P3o000;0?ooo`80o`00303oool20?l000X0oooo103o00080?ooo`H0o`0000<0
00000?ooo`3oool01P3oool20?l000`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?oo
o`060?ooo`/001Wo203oool6000Iocd0oooo000l0?ooo`L001Wo1`3oool:000Io`X0oooo00<001Wo
0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo
0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`090?ooo`@0o`0000<0oooo00000000000010000006
0?l000X0oooo0P3o000I0?ooo`030000003oool0oooo01L0oooo0P3o00090?ooo`H0o`0000<0oooo
000000000000100000000`3oool0o`000?l000020?l000/0oooo00<001Wo0?ooo`3oool02P3oool0
0`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool0
0`006Ol0oooo0?ooo`080?ooo`X001Wo1`3oool7000Iocd0oooo000m0?ooo`L001Wo1P3oool8000I
o``0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo
00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`080?ooo`H0o`001`3oool40?l0
02H0oooo00<000000?ooo`3oool08`3oool40?l000P0oooo1P3o000:0?ooo`03000Io`3oool0oooo
00X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo
00/0oooo00<001Wo0?ooo`3oool02P3oool8000Io`H0oooo1`006Oln0?ooo`00?@3oool9000Io`@0
oooo1`006Ol>0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0
oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00X0oooo0P3o00060?ooo`<000001P3o00080?ooo`80
o`009`3oool00`000000oooo0?ooo`0T0?ooo`80o`002@3oool60?l000<000001P3oool20?l000`0
oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool0303oool7000Io`@0oooo2@006Oln0?ooo`00?P3oool9000Io`@0oooo
0`006Ol30?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo
0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0203oool40?l000030?oo
o`000000000000800000103oool40?l00380oooo0`00000`0?ooo`@0o`00103oool4000000030?oo
o`3o0000o`000080o`002P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`04000Io`3oool0oooo0?ooo`<0
01Wo103oool9000Iocl0oooo000`0?ooo`03000Io`3oool0oooo00/0oooo2P006Ol30?ooo`03000I
o`3oool0oooo00<0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000I
o`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`070?ooo`H0o`00
2@3oool20?l003<0oooo00<000000?ooo`3oool0<@3oool20?l000T0oooo1P3o00090?ooo`03000I
o`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000I
o`3oool0oooo00`0oooo00<001Wo0?ooo`3oool00`3oool010006Ol0oooo0?ooo`3oool:000Io`d0
oooo00<001Wo0?ooo`3oool0;`3oool00340oooo0P006Ol;0?ooo``001Wo203oool00`006Ol0oooo
0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo
0?ooo`0:0?ooo`80o`001P3oool2000000H0o`00?P3oool00`000000oooo0?ooo`0l0?ooo`H0o`00
0P0000060?ooo`80o`00303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`060?ooo``001Wo2`3oool2000Ioc80oooo
000a0?ooo`<001Wo2`3oool<000Io`P0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02@3oool40?l000030?ooo`00
00000000008000000`3oool40?l003l0oooo00<000000?ooo`3oool0?@3oool40?l000<0oooo1000
00000`3oool0o`000?l000020?l000/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool01P3oool<000Io`/0oooo0`00
6Olb0?ooo`00<P3oool3000Io`X0oooo3@006Ol70?ooo`03000Io`3oool0oooo00/0oooo00<001Wo
0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00P0oooo1P3o0008
0?ooo`80o`00@03oool00`000000oooo0?ooo`0n0?ooo`80o`00203oool60?l000X0oooo00<001Wo
0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo
0?ooo`3oool01@3oool=000Io`X0oooo0`006Olc0?ooo`00<P3oool5000Io`T0oooo2`006Ol90?oo
o`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0;0?oo
o`03000Io`3oool0oooo00H0oooo00<000000?l0003o0000103o001:0?ooo`030000003oool0oooo
04P0oooo1P3o00000`000000oooo0?ooo`060?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?oo
o`3oool02P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00L0oooo2`006Ol90?oo
o`D001Wo<`3oool003<0oooo1@006Ol80?ooo`X001Wo2P3oool00`006Ol0oooo0?ooo`0;0?ooo`03
000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool20?l000@0oooo0`0000020?ooo`@0
o`00B`3oool00`000000oooo0?ooo`190?ooo`@0o`000P3oool3000000<0oooo0P3o00000`006Ol0
oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0
oooo0?ooo`080?ooo`X001Wo203oool5000Ioc@0oooo000c0?ooo`H001Wo1`3oool8000Io`d0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00T0oooo
103o0003000000H0oooo0P3o001<0?ooo`030000003oool0oooo04X0oooo0P3o00060?ooo`800000
103o000<0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo
0?ooo`0;0?ooo`P001Wo1`3oool6000Ioc@0oooo000d0?ooo`L001Wo1P3oool7000Io`h0oooo00<0
01Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00L0oooo1P3o
001F0?ooo`030000003oool0oooo05<0oooo1P3o000:0?ooo`03000Io`3oool0oooo00X0oooo00<0
01Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`L001Wo1P3oool7000IocD0oooo000d
0?ooo`P001Wo1@3oool5000Io`80oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;
0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool01`3oool60?l005H0oooo00<00000
0?ooo`3oool0D`3oool60?l000030000003oool0oooo00L0oooo00<001Wo0?ooo`3oool02P3oool0
0`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool01@006Ol5
0?ooo`P001Wo=@3oool003D0oooo2@006Ol40?ooo`8001Wo103oool00`006Ol0oooo0?ooo`0<0?oo
o`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool20?l000D0oooo0P0000000`3o
ool0o`000?l000020?l005L0oooo00<000000?ooo`3oool0E03oool40?l00080oooo0P0000040?oo
o`80o`0000<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo
00/0oooo00<001Wo0?ooo`3oool00`3oool2000Io`@0oooo2@006Olf0?ooo`00=@3oool:000Io`<0
oooo00<001Wo0?ooo`3oool0103oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00X0
oooo00<001Wo0?ooo`3oool02@3oool40?l00080oooo0P0000040?ooo`80o`00F03oool3000005D0
oooo0P3o00050?ooo`80000000<0oooo0?l0003o00000P3o000<0?ooo`03000Io`3oool0oooo00X0
oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`040?ooo`04000Io`3oool0oooo0?oo
o`X001Wo=P3oool002P0oooo00<001Wo0?ooo`3oool02`3oool:000Io`X0oooo00<001Wo0?ooo`3o
ool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00L0oooo1P3o00000`000000
oooo0?ooo`1N0?ooo`030000003oool0oooo05h0oooo1P3o000:0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`080?ooo`X001Wo3@3oool00`006Ol0
oooo0?ooo`0W0?ooo`00:@3oool2000Io`/0oooo30006Ol90?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`070?ooo`H0o`00H@3oool00`000000oooo
0?ooo`1N0?ooo`H0o`002P3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool01`3oool<000Io`/0oooo0P006OlZ0?ooo`00:@3oool4000Io`X0oooo3000
6Ol90?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`070?ooo`@0o`00HP3oool00`000000oooo0?ooo`1O0?ooo`@0o`0000<000000?ooo`3oool01`3o
ool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool01`3o
ool<000Io`X0oooo10006OlZ0?ooo`00:P3oool5000Io`P0oooo2`006Ol:0?ooo`03000Io`3oool0
oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0o`000?l000050?ooo`80000000<0oooo
0?l0003o0000H`3oool00`000000oooo0?ooo`1P0?ooo`80o`000P3oool2000000D0oooo0P3o0000
0`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0203oool;
000Io`P0oooo1@006Ol[0?ooo`00:`3oool5000Io`P0oooo2@006Ol<0?ooo`03000Io`3oool0oooo
00/0oooo00<001Wo0?ooo`3oool02@3oool40?l00080oooo0P00001X0?ooo`030000003oool0oooo
06H0oooo0P0000020?ooo`@0o`002`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo
00X0oooo2@006Ol80?ooo`D001Wo;03oool002/0oooo1`006Ol60?ooo`L001Wo3`3oool00`006Ol0
oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00P0oooo1P3o00000`000000oooo0?ooo`1X0?ooo`03
0000003oool0oooo06P0oooo00<000000?l0003o0000103o000:0?ooo`03000Io`3oool0oooo00X0
oooo00<001Wo0?ooo`3oool03@3oool7000Io`H0oooo1`006Ol/0?ooo`00;03oool8000Io`D0oooo
1@006Ol00`3oool001Wo0?ooo`0>0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool0
1`3oool60?l006/0oooo00<000000?ooo`3oool0J@3oool60?l000T0oooo00<001Wo0?ooo`3oool0
2P3oool00`006Ol0oooo0?ooo`0=0?ooo`03000Io`3oool001Wo00@001Wo1@3oool8000Iobd0oooo
000/0?ooo`T001Wo103oool4000Io`<0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00L0oooo103o001/0?ooo`030000003oool0oooo06X0oooo103o
00090?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool010006Ol0oooo0?oo
o`3oool4000Io`@0oooo2@006Ol]0?ooo`00;@3oool:000Io`<0oooo00<001Wo0?ooo`3oool0103o
ool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool01@3o
ool2000000030?ooo`3o0000o`0006d0oooo00<000000?ooo`3oool0J`3oool20?l000030?ooo`00
0000000000L0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3o
ool0oooo00@0oooo00@001Wo0?ooo`3oool0oooo2P006Ol^0?ooo`00;P3oool;000Io`T0oooo00<0
01Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3o0000o`000080oooo0P00
001b0?ooo`030000003oool0oooo0700oooo0P0000020?ooo`80o`0000<001Wo0?ooo`3oool02P3o
ool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00L0oooo2`006Ol_0?ooo`00;P3oool=
000Io`P0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`090?ooo`@0o`0000<00000
0?ooo`3oool0LP3oool300000780oooo00<000000?l0003o00000P3o000;0?ooo`03000Io`3oool0
oooo00`0oooo00<001Wo0?ooo`3oool01P3oool=000Iobl0oooo000_0?ooo`d001Wo1`3oool00`00
6Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00P0oooo1P3o001d0?ooo`030000003oool0oooo
0780oooo1P3o000:0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool01@3oool=000I
oc00oooo000Q0?ooo`8001Wo3@3oool;000Io`T0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0
oooo0?ooo`070?ooo`H0o`00M03oool00`000000oooo0?ooo`1b0?ooo`H0o`002@3oool00`006Ol0
oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00L0oooo2`006Ol=0?ooo`8001Wo8P3oool00280oooo
0`006Ol;0?ooo`X001Wo2`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00D0oooo
0P0000040?l007D0oooo00<000000?ooo`3oool0L`3oool40?l0008000001`3oool00`006Ol0oooo
0?ooo`0<0?ooo`03000Io`3oool0oooo00T0oooo2P006Ol;0?ooo`<001Wo8`3oool002<0oooo1000
6Ol:0?ooo`P001Wo3@3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00<0oooo00@0
00000?ooo`3oool0oooo0P3o001f0?ooo`030000003oool0oooo07@0oooo0P3o00030?ooo`030000
003oool0oooo00<0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`P001Wo
2P3oool4000Iob@0oooo000S0?ooo`H001Wo203oool8000Io`h0oooo00<001Wo0?ooo`3oool02`3o
ool00`006Ol0o`000?l000020?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool0NP3o
ool00`000000oooo0?ooo`020?l00003000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303o
ool8000Io`P0oooo1P006OlT0?ooo`00903oool7000Io`L0oooo1P006Ol00`3oool001Wo0?ooo`0=
0?ooo`03000Io`3oool0oooo00X0oooo103o00000`000000oooo0?ooo`1k0?ooo`030000003oool0
oooo07/0oooo00<000000?l0003o00000P3o000<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo
0?ooo`006Ol01@006Ol70?ooo`L001Wo9@3oool002D0oooo2@006Ol50?ooo`@001Wo0`3oool00`00
6Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00P0oooo1P3o001`0?ooo`030?oDV`0000000000
00<0000000<009_D0?ooo`3oool0103oool00`000000oooo0?ooo`1k0?ooo`H0o`002P3oool00`00
6Ol0oooo0?ooo`0<0?ooo`04000Io`3oool0oooo0?ooo`@001Wo1@3oool9000IobH0oooo000V0?oo
o`X001Wo0`3oool3000Io`D0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`070?oo
o`H0o`00L`3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo07/0oooo1P3o00090?oo
o`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool00`3oool3000Io`<0oooo2P006OlW0?oo
o`009P3oool<000Io`80oooo00<001Wo0?ooo`3oool01@3oool00`006Ol0oooo0?ooo`0<0?ooo`03
000Io`3oool0oooo00L0oooo103o001d0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3o
ool0O03oool40?l000T0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`050?ooo`03
000Io`3oool0oooo00`001Wo9`3oool002L0oooo3@006Ol90?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool01P3oool010000000oooo0?l0003o001e0?ooo`030;YbLP2jj_l0oooo00L0
oooo00<000000?ooo`3oool0O@3oool20?l000030?ooo`000000oooo00L0oooo00<001Wo0?ooo`3o
ool02`3oool00`006Ol0oooo0?ooo`070?ooo`d001Wo:03oool002P0oooo3P006Ol80?ooo`03000I
o`3oool0oooo00/0oooo00@001Wo0?ooo`3o0000o`000P3oool2000006d0oooo00<0^W8000000000
00000`0000000`00L[X0oooo0?ooo`030?ooo`030;YbLP2jj_l0oooo00L0oooo100000200?ooo`80
00000P3oool20?l000030?ooo`006Ol0oooo00`0oooo00<001Wo0?ooo`3oool01P3oool>000IobT0
oooo000Y0?ooo``001Wo2P3oool00`006Ol0oooo0?ooo`0;0?ooo`@0o`0000<000000?ooo`3oool0
N@3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo08<0oooo00<000000?l0003o0000
0P3o000=0?ooo`03000Io`3oool0oooo00P0oooo30006OlZ0?ooo`00:@3oool;000Io``0oooo0P00
6Ol:0?ooo`H0o`00N`3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo08<0oooo1P3o
000:0?ooo`8001Wo303oool;000IobX0oooo000K0?ooo`8001Wo3@3oool9000Io`l0oooo00<001Wo
0?ooo`3oool01`3oool60?l007P0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`080?ooo`030000003o
ool0oooo08<0oooo1P3o00090?ooo`03000Io`3oool0oooo00d0oooo2@006Ol=0?ooo`8001Wo703o
ool001`0oooo10006Ol;0?ooo`P001Wo403oool00`006Ol0oooo0?ooo`070?ooo`@0o`00N`3oool0
0`3Z^W80001b0;[Zo`080?ooo`030000003oool0oooo08@0oooo103o00090?ooo`03000Io`3oool0
oooo00h0oooo20006Ol:0?ooo`D001Wo7@3oool001d0oooo1`006Ol80?ooo`H001Wo00<0oooo000I
o`006Ol03`3oool00`006Ol0oooo0?ooo`060?ooo`030000003o0000o`0008L0oooo00<000000?oo
o`3oool0Q@3oool20?l000030000003oool0oooo00H0oooo00<001Wo0?ooo`3oool03@3oool2000I
o`030?ooo`006Ol001Wo00@001Wo203oool7000Ioah0oooo000N0?ooo`T001Wo1@3oool5000Io`@0
oooo00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?ooo`030?ooo`800000RP3oool00`000000
oooo0?ooo`280?ooo`8000001@3oool00`006Ol0oooo0?ooo`0=0?ooo`03000Io`3oool0oooo0080
oooo1@006Ol40?ooo`X001Wo7`3oool001l0oooo2`006Ol30?ooo`<001Wo1P3oool00`006Ol0oooo
0?ooo`0=0?ooo`05000Io`3o0000o`000?ooo`000000S03oool00`000000oooo0?ooo`2:0?ooo`05
0000003oool0o`000?l000006Ol03`3oool00`006Ol0oooo0?ooo`040?ooo`<001Wo0P3oool<000I
ob00oooo000P0?ooo`l001Wo203oool2000Io`d0oooo103o002=0?ooo`030000003oool0oooo08/0
oooo103o000=0?ooo`8001Wo203oool?000Iob40oooo000Q0?ooo`l001Wo2@3oool00`006Ol0oooo
0?ooo`090?ooo`H0o`00S03oool00`000000oooo0?ooo`2:0?ooo`H0o`002`3oool00`006Ol0oooo
0?ooo`060?oooa0001Wo8P3oool00280oooo3@006Ol;0?ooo`03000Io`3oool0oooo00P0oooo1P3o
002<0?ooo`030000003oool0oooo08X0oooo1P3o000:0?ooo`03000Io`3oool0oooo00P0oooo3P00
6OlS0?ooo`008`3oool<000Io``0oooo0P006Ol90?ooo`@0o`00S@3oool3000008/0oooo103o0009
0?ooo`8001Wo2`3oool=000Iob@0oooo000T0?ooo`X001Wo3`3oool00`006Ol0oooo0?ooo`050?oo
o`040000003oool0o`000?l008h0oooo00<000000?ooo`3oool0S03oool20?l000030?ooo`000000
oooo00H0oooo00<001Wo0?ooo`3oool0303oool;000IobD0oooo000U0?ooo`T001Wo403oool00`00
6Ol0oooo0?ooo`040?ooo`030000003oool0oooo08l0oooo00<000000?ooo`3oool0S`3oool00`00
0000oooo0?ooo`040?ooo`03000Io`3oool0oooo00h0oooo2@006OlV0?ooo`009P3oool9000Ioa00
oooo0P006Ol20?l000030?ooo`000000oooo0940oooo00<000000?ooo`3oool0T03oool010000000
o`000?l0003oool2000Ioa00oooo2@006OlW0?ooo`009`3oool6000Io`80oooo0P006Ol?0?ooo`@0
o`00T`3oool00`000000oooo0?ooo`2@0?ooo`@0o`00403oool2000Io`80oooo1P006OlX0?ooo`00
5P3oool4000Io`h0oooo10006Ol50?ooo`03000Io`3oool0oooo00/0oooo1P3o002B0?ooo`030000
003oool0oooo08l0oooo1P3o000>0?ooo`03000Io`3oool0oooo00<0oooo10006Ol>0?ooo`@001Wo
5`3oool001L0oooo2P006Ol80?ooo`<001Wo1P3oool2000Io`/0oooo1P3o002B0?ooo`030000003o
ool0oooo08l0oooo1P3o000<0?ooo`8001Wo1P3oool3000Io`P0oooo2P006OlH0?ooo`00603oool@
000Io`80oooo00<001Wo0?ooo`3oool01`3oool2000Io`X0oooo103o002C0?ooo`030000003oool0
oooo0900oooo103o000;0?ooo`8001Wo2@3oool00`006Ol0oooo0?ooo`0@000IoaT0oooo000J0?oo
oa8001Wo2P3oool2000Io`P0oooo00<000000?l0003o0000U03oool00`000000oooo0?ooo`2A0?oo
o`80o`0000<0oooo0000003oool01`3oool2000Io`X0oooo4P006OlK0?ooo`006`3ooolA000Io``0
oooo00<001Wo0?ooo`3oool0103oool00`000000oooo0?ooo`2E0?ooo`030000003oool0oooo09D0
oooo00<000000?ooo`3oool0103oool00`006Ol0oooo0?ooo`0:0?oooa4001Wo703oool001`0oooo
3`006Ol>0?ooo`8001Wo00@0oooo0?l0003o00000000V03oool3000009H0oooo0P3o00020?ooo`80
01Wo3P3oool?000Ioad0oooo000N0?ooo`d001Wo403oool40?l009P0oooo00<000000?ooo`3oool0
U@3oool40?l00003000Io`3oool0oooo00h0oooo3@006OlO0?ooo`007`3oool;000Ioa00oooo1P3o
002G0?ooo`030000003oool0oooo09@0oooo1P3o000A0?ooo`/001Wo803oool00200oooo2P006Ol@
0?ooo`H0o`00U`3oool00`000000oooo0?ooo`2D0?ooo`H0o`004@3oool:000Iob40oooo000R0?oo
o`/001Wo3P3oool40?l009P0oooo00<000000?ooo`3oool0U@3oool40?l000l0oooo2`006OlS0?oo
o`008`3oool6000Io`@0oooo0P006Ol<0?ooo`030000003o0000o`0009T0oooo00<000000?ooo`3o
ool0UP3oool20?l000030000003oool0oooo00/0oooo0P006Ol40?ooo`H001Wo903oool002@0oooo
1@006Ol60?ooo`8001Wo2P3oool00`000000oooo0?ooo`2I0?ooo`030000003oool0oooo09T0oooo
00<000000?ooo`3oool0203oool2000Io`H0oooo1@006OlU0?ooo`004`3oool;000Io`P0oooo0P00
6Ol90?ooo`<001Wo1P3oool00`000000oooo0?ooo`2J0?ooo`030000003oool0oooo09T0oooo00<0
00000?ooo`3oool01@3oool3000Io`T0oooo0P006Ol80?ooo`/001Wo503oool001@0oooo5@006Ol;
0?ooo`8001Wo0`3oool20?l009`0oooo00<000000?ooo`3oool0VP3oool20?l000<0oooo0P006Ol;
0?oooaD001Wo5@3oool001H0oooo4`006Ol=0?ooo`8001Wo103o002K0?ooo`030000003oool0oooo
09T0oooo103o0002000Io`d0oooo4`006OlG0?ooo`00603oool@000Io`l0oooo1P3o002J0?ooo`03
0000003oool0oooo09P0oooo1P3o000?0?oooa0001Wo6@3oool001T0oooo3`006Ol?0?ooo`H0o`00
VP3oool3000009P0oooo1P3o000?0?ooo`l001Wo6P3oool001/0oooo3@006Ol@0?ooo`@0o`00V`3o
ool00`000000oooo0?ooo`2I0?ooo`@0o`00403oool=000Ioa`0oooo000L0?ooo``001Wo403oool0
0`000000o`000?l0002L0?ooo`030000003oool0oooo09X0oooo0P3o00000`000000oooo0?ooo`0>
0?ooo``001Wo7@3oool001h0oooo2@006Ol0103oool001Wo000Io`006Ol<0?ooo`030000003oool0
oooo09d0oooo00<000000?ooo`3oool0W03oool00`000000oooo0?ooo`0;0?ooo`<001Wo00<0oooo
000Io`006Ol01`006OlO0?ooo`00803oool7000Io`@0oooo10006Ol70?ooo`80o`00W`3oool00`00
0000oooo0?ooo`2M0?ooo`80o`001`3oool4000Io`@0oooo1`006OlQ0?ooo`008@3oool6000Io`P0
oooo0`006Ol30?ooo`@0o`0000<0000007:jjP3oool0;`3oool00`3oom@0V`000000000400000003
09_Do`3oool0oooo02d0oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`0/0?ooo`03
0000003oool0oooo0300oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`0/0?ooo`03
0?ooe02K0000000000@0000000<0VmCo0?ooo`3oool0;@3oool40?l000030000001b^^X0oooo00<0
01Wo203oool6000Iob80oooo000S0?ooo`<001Wo303oool2000Io`H0o`0000<0V`0007:jjP3oool0
;`3oool00`3DV`00002K0=Coo`020?ooo`030>ZjV`2jj_l0oooo0340oooo00<0^W9b0;[Zo`3oool0
;`3oool00`000000oooo0?ooo`0c0?ooo`030;YbLP2jj_l0oooo0300oooo00<0e9/00000V`3Dool0
0P3oool00`3Z^Y/0^^[o0?ooo`0]0?ooo`H0o`000P006Ol<0?ooo`<001Wo903oool00240oooo1P00
6Ol=0?ooo`H0o`0000<0omBK002Ke03oool0<03oool00`3oe9/0001b0;[Zo`0e0?ooo`030;YbLP2j
j_l0oooo02l0oooo00<000000?ooo`3oool0<`3oool00`2jLW80^^[o0?ooo`0a0?ooo`030?oDV`00
0780^^[o0340oooo1P3o00000`3oe9/009_D0?ooo`0:0?ooo`H001Wo8P3oool001L0oooo40006Ol>
0?ooo`@0o`0000<0onZj0780LP2jj_l0<P3oool00`3oj[X0LP0007:jjP0d0?ooo`030;YbLP2jj_l0
oooo02l0oooo00<000000?ooo`3oool0<`3oool00`2jLW80^^[o0?ooo`0b0?ooo`030?oZ^P1b0000
L[[Z0340oooo103o00000`3oj[X0LP1b0;[Zo`0;0?oooa0001Wo603oool00140oooo5P006Ol50?oo
o`030;Yb00000000000000<0000000@007:j0?ooo`3oool0oooo0P3o00000`000000001b0;[Zo`0X
0?ooo`030;Yb00000000000000<0000000<007:j0?ooo`3oool0103oool00`2jLP00L[[Z0?ooo`0V
0?ooo`030;Yb00000000000000<0000000<007:j0?ooo`3oool00`3oool00`2jLW80^^[o0?ooo`0_
0?ooo`030000003oool0oooo03<0oooo00<0^W9b0;[Zo`3oool0=03oool00`2jLP00L[[Z0?ooo`0`
0?ooo`80o`0000<000000000LP2jj_l0303ooolF000Ioa80oooo000C0?oooa@001Wo3`3oool01P00
0000oooo0?ooo`3oj[X0LP1b0;[ZocD0oooo00<0^W:K0=Coo`3oool0<@3oool00`2jLW80^^[o0?oo
o`0_0?ooo`030000003oool0oooo03<0oooo00<0^W9b0;[Zo`3oool0=@3oool00`2jLY/0e?oo0?oo
o`0`0?ooo`050000003oool0onZj0780LP2jj_l02`3ooolD000Ioa@0oooo000E0?oooa8001Wo3P3o
ool00`000000oooo0?ooo`020?ooo`030=BK002Ke?l0oooo02l0oooo00<0j[Yb09_Do`3oool00P3o
ool00`3DV`00VmCo0?ooo`0a0?ooo`030;YbLP2jj_l0oooo02l0oooo0`00000c0?ooo`030;YbLP2j
j_l0oooo0300oooo00<0j[Yb09_Do`3oool00P3oool00`3DV`00VmCo0?ooo`0a0?ooo`040000003o
ool0e9/009_Do`/0oooo4P006OlF0?ooo`00603ooolC000Io`T0oooo0P3o00001P000780^^[o0?oo
o`3oj[X0LP1b0;[Zoc00oooo00L0omBK0000V`3Dool0oooo0?oDV`000780^^[o02l0oooo00D0j[Yb
00000000L[X0^W9b0;[Zo`0`0?ooo`030000003oool0oooo0300oooo00D0j[Yb00000000L[X0^W9b
0;[Zo`0a0?ooo`070?oDV`0009/0e?oo0?ooo`3oe9/0001b0;[Zo`0_0?ooo`030?oDV`000780^^[o
0080o`0000<0LP1b0;[Zo`3oool01P3ooolC000IoaT0oooo000J0?ooo``001Wo1@3oool7000Io`03
0?ooo`3o0000o`000080o`0000@0LP00000000000000VmCo<P3oool01@3oe9/00000000000000780
^^[o0380oooo00<0j[Yb0000LP2jj_l0<03oool00`000000oooo0?ooo`0b0?ooo`030>ZjLP000780
^^[o0380oooo00D0omBK000000000000001b0;[Zo`0a0?ooo`030?oZ^P3o0000o`000080o`0000<0
oooo000Io`006Ol01@006Ol50?ooo``001Wo6`3oool001d0oooo2@006Ol<0?ooo`H0o`00W`3oool0
0`000000oooo0?ooo`2M0?ooo`H0o`00303oool9000Ioah0oooo000O0?ooo`L001Wo303oool60?l0
09l0oooo00<000000?ooo`3oool0W@3oool60?l000`0oooo1`006OlP0?ooo`008P3oool4000Io`d0
oooo103o002P0?ooo`030000003oool0oooo09h0oooo103o000=0?ooo`@001Wo8`3oool002<0oooo
0`006Ol>0?ooo`80o`00X@3oool00`000000oooo0?ooo`2O0?ooo`80o`003P3oool3000Iob@0oooo
000O0?ooo`L001Wo3P3oool00`000000oooo0?ooo`2P0?ooo`030000003oool0oooo09l0oooo00<0
00000?ooo`3oool03@3oool7000Iob00oooo000K0?ooo`/001Wo3P3oool00`000000oooo0?ooo`2P
0?ooo`030000003oool0oooo0:00oooo00<000000?ooo`3oool0303oool;000Ioa`0oooo000G0?oo
o`l001Wo3P3oool20?l00:40oooo00<000000?ooo`3oool0W`3oool20?l000h0oooo3`006OlH0?oo
o`004`3ooolC000Io`d0oooo103o002P0?ooo`030000003oool0oooo09h0oooo103o000=0?oooa<0
01Wo503oool000H0oooo2P00000R000Io`H0o`00o`000010000000H0o`008P006Ol:000000L0oooo
00090?ooo`030000003oool0oooo00L0oooo4`006Ol30?ooo`030000003oool0oooo00H0oooo1P3o
00070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool60?l000P0oooo00@0
00000?ooo`3oool0oooo4`006Ol90?ooo`030000003oool0oooo00P0oooo00090?ooo`030000003o
ool0oooo00P0oooo00<000000?ooo`3oool03`006Ol30?ooo`030000003oool0oooo00L0oooo103o
00080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01P3oool40?l000T0oooo00@0
00000?ooo`3oool0oooo3`006Ol20?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0
203oool001/0oooo2`006Ol>0?ooo`80o`00=@3oool00`000000oooo0?ooo`0c0?ooo`030000003o
ool0oooo03<0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0d0?ooo`030000003o
ool0oooo0380oooo0P3o000>0?ooo`/001Wo703oool001l0oooo1`006Ol>0?ooo`030000003oool0
oooo0:00oooo00<000000?ooo`3oool0W`3oool00`000000oooo0?ooo`0=0?ooo`L001Wo803oool0
02<0oooo0`006Ol>0?ooo`80o`00X@3oool00`000000oooo0?ooo`2O0?ooo`80o`003P3oool3000I
ob@0oooo000R0?ooo`@001Wo3@3oool40?l00:00oooo00<000000?ooo`3oool0WP3oool40?l000d0
oooo10006OlS0?ooo`007`3oool7000Io``0oooo1P3o002O0?ooo`030000003oool0oooo09d0oooo
1P3o000<0?ooo`L001Wo803oool001d0oooo2@006Ol<0?ooo`H0o`00W`3oool00`000000oooo0?oo
o`2M0?ooo`H0o`00303oool9000Ioah0oooo000J0?ooo``001Wo1@3oool7000Io`030?ooo`3o0000
o`000080o`00X03oool00`000000oooo0?ooo`2N0?ooo`@0o`0000<0oooo000Io`006Ol01@006Ol5
0?ooo``001Wo6`3oool001P0oooo4`006Ol90?ooo`80o`00X@3oool00`000000oooo0?ooo`2O0?oo
o`80o`002@3ooolC000IoaT0oooo000E0?oooa8001Wo3P3oool00`000000oooo0?ooo`2O0?ooo`<0
0000W`3oool00`000000oooo0?ooo`0<0?oooa8001Wo5P3oool001<0oooo50006Ol?0?ooo`030000
003oool0oooo09h0oooo00<000000?ooo`3oool0WP3oool00`000000oooo0?ooo`0=0?oooa@001Wo
503oool00140oooo5P006Ol?0?ooo`80o`00W`3oool00`000000oooo0?ooo`2M0?ooo`80o`003`3o
oolF000Ioa80oooo000G0?oooa0001Wo3P3oool40?l009h0oooo00<000000?ooo`3oool0W03oool4
0?l000h0oooo40006OlH0?ooo`008@3oool6000Io`d0oooo1P3o002M0?ooo`030000003oool0oooo
09/0oooo1P3o000=0?ooo`H001Wo8P3oool002<0oooo0`006Ol<0?ooo`8001Wo1P3o002M0?ooo`03
0000003oool0oooo09/0oooo1P3o0002000Io``0oooo0`006OlT0?ooo`008@3oool6000Io`P0oooo
0`006Ol30?ooo`@0o`00WP3oool00`000000oooo0?ooo`2L0?ooo`@0o`000`3oool3000Io`P0oooo
1P006OlR0?ooo`00803oool7000Io`@0oooo10006Ol70?ooo`80o`00W`3oool00`000000oooo0?oo
o`2M0?ooo`80o`001`3oool4000Io`@0oooo1`006OlQ0?ooo`007P3oool9000Io`040?ooo`006Ol0
01Wo000Io``0oooo00<000000?ooo`3oool0W@3oool00`000000oooo0?ooo`2L0?ooo`030000003o
ool0oooo00/0oooo0`006Ol00`3oool001Wo000Io`07000Ioal0oooo000M0?ooo`/001Wo403oool0
0`000000oooo0?ooo`2L0?ooo`030000003oool0oooo09`0oooo00<000000?ooo`3oool03P3oool;
000Ioah0oooo000K0?ooo`d001Wo403oool00`000000o`000?l0002L0?ooo`030000003oool0oooo
09X0oooo0P3o00000`000000oooo0?ooo`0>0?ooo`d001Wo703oool001T0oooo3`006Ol@0?ooo`@0
o`00V`3oool3000009T0oooo103o000@0?ooo`l001Wo6P3oool001P0oooo40006Ol?0?ooo`H0o`00
VP3oool00`000000oooo0?ooo`2H0?ooo`H0o`003`3oool@000IoaT0oooo000F0?oooa<001Wo3@3o
ool00`006Ol0o`000?l000040?l009X0oooo00<000000?ooo`3oool0V03oool60?l00003000Io`3o
ool0oooo00/0oooo4`006OlG0?ooo`00503ooolE000Io`/0oooo0P006Ol20?ooo`@0o`00V`3oool0
0`000000oooo0?ooo`2I0?ooo`@0o`000P3oool2000Io`/0oooo5@006OlE0?ooo`004`3oool;000I
o`P0oooo0P006Ol90?ooo`<001Wo1@3oool20?l009`0oooo00<000000?ooo`3oool0V@3oool00`00
0000o`000?l000050?ooo`<001Wo2@3oool2000Io`P0oooo2`006OlD0?ooo`00903oool5000Io`H0
oooo0P006Ol:0?ooo`030000003oool0oooo09T0oooo00<000000?ooo`3oool0V@3oool00`000000
oooo0?ooo`080?ooo`8001Wo1P3oool5000IobD0oooo000S0?ooo`H001Wo103oool2000Io``0oooo
00<000000?l0003o0000V@3oool00`000000oooo0?ooo`2F0?ooo`80o`0000<000000?ooo`3oool0
2`3oool2000Io`@0oooo1P006OlT0?ooo`008P3oool;000Io`h0oooo103o002H0?ooo`030000003o
ool0oooo09D0oooo103o000?0?ooo`/001Wo8`3oool00200oooo2P006Ol@0?ooo`H0o`00U`3oool0
0`000000oooo0?ooo`2D0?ooo`H0o`004@3oool:000Iob40oooo000O0?ooo`/001Wo403oool60?l0
09L0oooo00<000000?ooo`3oool0U03oool60?l00140oooo2`006OlP0?ooo`007P3oool=000Ioa00
oooo103o002H0?ooo`030000003oool0oooo09D0oooo103o00000`006Ol0oooo0?ooo`0>0?ooo`d0
01Wo7`3oool001`0oooo3`006Ol>0?ooo`8001Wo00@0oooo0?l0003o00000000V03oool3000009H0
oooo0P3o00020?ooo`8001Wo3P3oool?000Ioad0oooo000K0?oooa4001Wo303oool00`006Ol0oooo
0?ooo`040?ooo`030000003oool0oooo09D0oooo00<000000?ooo`3oool0U@3oool00`000000oooo
0?ooo`040?ooo`03000Io`3oool0oooo00X0oooo4@006OlL0?ooo`006P3ooolB000Io`X0oooo0P00
6Ol80?ooo`030000003o0000o`0009@0oooo00<000000?ooo`3oool0T@3oool20?l000030?ooo`00
0000oooo00L0oooo0P006Ol:0?oooa8001Wo6`3oool001P0oooo40006Ol20?ooo`03000Io`3oool0
oooo00L0oooo0P006Ol:0?ooo`@0o`00T`3oool00`000000oooo0?ooo`2@0?ooo`@0o`002`3oool2
000Io`T0oooo00<001Wo0?ooo`3oool040006OlI0?ooo`005`3oool:000Io`P0oooo0`006Ol60?oo
o`8001Wo2`3oool60?l00980oooo00<000000?ooo`3oool0S`3oool60?l000`0oooo0P006Ol60?oo
o`<001Wo203oool:000IoaP0oooo000F0?ooo`@001Wo3P3oool4000Io`D0oooo00<001Wo0?ooo`3o
ool02`3oool60?l00980oooo00<000000?ooo`3oool0S`3oool60?l000h0oooo00<001Wo0?ooo`3o
ool00`3oool4000Io`h0oooo10006OlG0?ooo`009`3oool6000Io`80oooo0P006Ol?0?ooo`@0o`00
T`3oool00`000000oooo0?ooo`2@0?ooo`@0o`00403oool2000Io`80oooo1P006OlX0?ooo`009P3o
ool9000Ioa00oooo0P006Ol20?l000030?ooo`000000oooo0940oooo00<000000?ooo`3oool0T03o
ool010000000o`000?l0003oool2000Ioa00oooo2@006OlW0?ooo`009@3oool9000Ioa00oooo00<0
01Wo0?ooo`3oool0103oool00`000000oooo0?ooo`2?0?ooo`030000003oool0oooo08l0oooo00<0
00000?ooo`3oool0103oool00`006Ol0oooo0?ooo`0>0?ooo`T001Wo9P3oool002@0oooo2P006Ol?
0?ooo`03000Io`3oool0oooo00D0oooo00@000000?ooo`3o0000o`00SP3oool00`000000oooo0?oo
o`2<0?ooo`80o`0000<0oooo0000003oool01P3oool00`006Ol0oooo0?ooo`0<0?ooo`/001Wo9@3o
ool002<0oooo30006Ol<0?ooo`8001Wo2@3oool40?l008d0oooo0`00002;0?ooo`@0o`002@3oool2
000Io`/0oooo3@006OlT0?ooo`008P3oool=000Io`/0oooo00<001Wo0?ooo`3oool0203oool60?l0
08`0oooo00<000000?ooo`3oool0RP3oool60?l000X0oooo00<001Wo0?ooo`3oool0203oool>000I
ob<0oooo000Q0?ooo`l001Wo2@3oool00`006Ol0oooo0?ooo`090?ooo`H0o`00S03oool00`000000
oooo0?ooo`2:0?ooo`H0o`002`3oool00`006Ol0oooo0?ooo`060?oooa0001Wo8P3oool00200oooo
3`006Ol80?ooo`8001Wo3@3oool40?l008d0oooo00<000000?ooo`3oool0R`3oool40?l000d0oooo
0P006Ol80?ooo`l001Wo8@3oool001l0oooo30006Ol20?ooo`<001Wo1P3oool00`006Ol0oooo0?oo
o`0=0?ooo`05000Io`3o0000o`000?ooo`000000S03oool00`000000oooo0?ooo`2:0?ooo`050000
003oool0o`000?l000006Ol03`3oool00`006Ol0oooo0?ooo`040?ooo`<001Wo0P3oool<000Iob00
oooo000N0?ooo`T001Wo1@3oool5000Io`@0oooo00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo
0?ooo`030?ooo`800000RP3oool00`000000oooo0?ooo`280?ooo`8000001@3oool00`006Ol0oooo
0?ooo`0=0?ooo`03000Io`3oool0oooo0080oooo1@006Ol40?ooo`X001Wo7`3oool001d0oooo1`00
6Ol80?ooo`H001Wo00<0oooo000Io`006Ol03`3oool00`006Ol0oooo0?ooo`060?ooo`030000003o
0000o`0008L0oooo00<000000?ooo`3oool0Q@3oool20?l000030000003oool0oooo00H0oooo00<0
01Wo0?ooo`3oool03@3oool2000Io`030?ooo`006Ol001Wo00@001Wo203oool7000Ioah0oooo000L
0?ooo`D001Wo2P3oool8000Ioa00oooo00<001Wo0?ooo`3oool01`3oool40?l008H0oooo00<00000
0?ooo`3oool0Q03oool40?l000T0oooo00<001Wo0?ooo`3oool03P3oool8000Io`X0oooo1@006OlM
0?ooo`006`3oool2000Io`d0oooo2@006Ol?0?ooo`03000Io`3oool0oooo00L0oooo1P3o001h0?oo
o`030?oDV`000000000000<0000000<009_D0?ooo`3oool0103oool00`000000oooo0?ooo`230?oo
o`H0o`002@3oool00`006Ol0oooo0?ooo`0=0?ooo`T001Wo3@3oool2000Ioa`0oooo000Y0?ooo`/0
01Wo3@3oool00`006Ol0oooo0?ooo`080?ooo`H0o`00N`3oool00`2jLW80^^[o0?ooo`070?ooo`03
0000003oool0oooo08<0oooo1P3o000:0?ooo`03000Io`3oool0oooo00/0oooo2`006OlZ0?ooo`00
:@3oool<000Io`X0oooo0P006Ol<0?ooo`@0o`0000<000000?ooo`3oool0N@3oool00`2jLW80^^[o
0?ooo`070?ooo`030000003oool0oooo08<0oooo00<000000?l0003o00000P3o000<0?ooo`8001Wo
2P3oool<000IobX0oooo000X0?ooo`h001Wo203oool00`006Ol0oooo0?ooo`0;0?ooo`04000Io`3o
ool0o`000?l00080oooo00<000000?ooo`3oool0N03oool00`2jLW80^^[o0?ooo`070?ooo`@00000
P@3oool00`000000oooo0?ooo`020?l000030?ooo`006Ol0oooo00`0oooo00<001Wo0?ooo`3oool0
1P3oool>000IobT0oooo000W0?ooo`d001Wo2@3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo00D0oooo0P0000000`3oool0o`000?l0001e0?ooo`030;YbLP2jj_l0oooo00L0oooo00<0
00000?ooo`3oool0O@3oool20?l000030?ooo`000000000000L0oooo00<001Wo0?ooo`3oool02`3o
ool00`006Ol0oooo0?ooo`070?ooo`d001Wo:03oool002H0oooo30006Ol20?ooo`03000Io`3oool0
oooo00D0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`070?ooo`@0o`00M03oool0
0`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo07`0oooo103o00090?ooo`03000Io`3oool0
oooo00`0oooo00<001Wo0?ooo`3oool01@3oool00`006Ol0oooo0?ooo`0<000IobL0oooo000V0?oo
o`X001Wo0`3oool3000Io`D0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`070?oo
o`H0o`00L`3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo07/0oooo1P3o00090?oo
o`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool00`3oool3000Io`<0oooo2P006OlW0?oo
o`009@3oool9000Io`D0oooo10006Ol30?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3o
ool0203oool60?l00700oooo00D0j[Yb00000000L[X0^W9b0;[Zo`080?ooo`030000003oool0oooo
07/0oooo1P3o000:0?ooo`03000Io`3oool0oooo00`0oooo00@001Wo0?ooo`3oool0oooo10006Ol5
0?ooo`T001Wo9P3oool002@0oooo20006Ol60?ooo`H001Wo00<0oooo000Io`3oool03@3oool00`00
6Ol0oooo0?ooo`0:0?ooo`@0o`00L`3oool00`3Z^W80001b0;[Zo`080?ooo`030000003oool0oooo
07`0oooo103o000<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`006Ol01@006Ol60?oo
o`P001Wo9@3oool002<0oooo1P006Ol80?ooo`P001Wo3P3oool00`006Ol0oooo0?ooo`0;0?ooo`04
000Io`3o0000o`000?ooo`800000O03oool00`000000oooo0?ooo`1j0?ooo`80000000@0oooo0?l0
003o000001Wo3@3oool00`006Ol0oooo0?ooo`0<0?ooo`P001Wo203oool6000Iob@0oooo000S0?oo
o`@001Wo2P3oool8000Io`d0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`030?oo
o`040000003oool0oooo0?ooo`80o`00MP3oool00`000000oooo0?ooo`1d0?ooo`80o`000`3oool0
0`000000oooo0?ooo`030?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool8
000Io`X0oooo10006OlT0?ooo`008P3oool3000Io`/0oooo2P006Ol;0?ooo`03000Io`3oool0oooo
00`0oooo00<001Wo0?ooo`3oool01@3oool00`000000oooo0?l000030?l007D0oooo00<000000?oo
o`3oool0L`3oool40?l000030?ooo`000000oooo00H0oooo00<001Wo0?ooo`3oool0303oool00`00
6Ol0oooo0?ooo`090?ooo`X001Wo2`3oool3000Iob<0oooo000Q0?ooo`8001Wo3@3oool;000Io`T0
oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`070?ooo`H0o`00M03oool00`000000
oooo0?ooo`1b0?ooo`H0o`002@3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00L0
oooo2`006Ol=0?ooo`8001Wo8P3oool002l0oooo3@006Ol70?ooo`03000Io`3oool0oooo00`0oooo
00<001Wo0?ooo`3oool0203oool60?l007@0oooo00<000000?ooo`3oool0LP3oool60?l000X0oooo
00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`050?ooo`d001Wo<03oool002h0oooo3@00
6Ol80?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02@3oool40?l007D0oooo0`00
001c0?ooo`@0o`002`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00H0oooo3@00
6Ol_0?ooo`00;P3oool;000Io`T0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0:
0?ooo`04000Io`3o0000o`000?ooo`800000L`3oool00`000000oooo0?ooo`1a0?ooo`80000000@0
oooo0?l0003o000001Wo303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00L0oooo
2`006Ol_0?ooo`00;@3oool:000Io`<0oooo00<001Wo0?ooo`3oool0103oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool0103oool200000080oooo0P3o
001]0?ooo`030000003oool0oooo06/0oooo0P3o00020?ooo`8000001P3oool00`006Ol0oooo0?oo
o`0:0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0103oool010006Ol0oooo0?oo
o`3oool:000Iobh0oooo000/0?ooo`T001Wo103oool3000Io`@0oooo00<001Wo0?ooo`3oool0303o
ool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00H0oooo00<000000?l0003o00000P3o
001/0?ooo`030000003oool0oooo06X0oooo103o00000`000000oooo0?ooo`060?ooo`03000Io`3o
ool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`020?ooo`<001Wo103o
ool9000Iobd0oooo000/0?ooo`P001Wo1@3oool4000Io`80oooo00<001Wo0?ooo`3oool03@3oool0
0`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00L0oooo1P3o001[0?ooo`030000003oool0
oooo06T0oooo1P3o00090?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool03@3oool0
0`006Ol0oooo0?ooo`04000Io`D0oooo20006Ol]0?ooo`00:`3oool7000Io`H0oooo1`006Ol?0?oo
o`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool0203oool60?l006/0oooo00<000000?oo
o`3oool0J@3oool60?l000X0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0=0?oo
o`L001Wo1P3oool7000Iob`0oooo000[0?ooo`D001Wo203oool8000Io`d0oooo00<001Wo0?ooo`3o
ool02`3oool00`006Ol0oooo0?ooo`090?ooo`@0o`0000<0oooo000000000000J@3oool00`000000
oooo0?ooo`1W0?ooo`80000000<0oooo0?l0003o00000P3o000;0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool02`3oool8000Io`P0oooo1@006Ol/0?ooo`00:P3oool5000Io`P0oooo
2P006Ol;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0o`00
0?l000040?ooo`8000000P3oool20?l006<0oooo00<000000?ooo`3oool0H03oool20?l000<0oooo
0P0000040?ooo`80o`0000<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000I
o`3oool0oooo00T0oooo2P006Ol80?ooo`D001Wo:`3oool002T0oooo10006Ol:0?ooo`/001Wo2P3o
ool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool01P3o
ool00`000000o`000?l000020?l00680oooo00<000000?ooo`3oool0G`3oool40?l000800000203o
ool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool0203o
ool;000Io`X0oooo10006OlZ0?ooo`00:@3oool2000Io`/0oooo3@006Ol80?ooo`03000Io`3oool0
oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`070?ooo`H0o`00H@3oool0
0`000000oooo0?ooo`1N0?ooo`H0o`002P3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0
oooo00/0oooo00<001Wo0?ooo`3oool01P3oool=000Io`/0oooo0P006OlZ0?ooo`00:03oool00`00
6Ol0oooo0?ooo`0;0?ooo``001Wo203oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo
00/0oooo00<001Wo0?ooo`3oool01`3oool60?l000030000003oool0oooo05h0oooo00<000000?oo
o`3oool0GP3oool60?l000X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?oo
o`03000Io`3oool0oooo00H0oooo30006Ol=0?ooo`03000Io`3oool0oooo02L0oooo000e0?ooo`/0
01Wo0P3oool00`006Ol0oooo0?ooo`040?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3o
ool02P3oool00`006Ol0oooo0?ooo`090?ooo`@0o`000P3oool2000000@0oooo0P3o001H0?ooo`<0
0000E@3oool20?l000D0oooo0P0000000`3oool0o`000?l000020?l000`0oooo00<001Wo0?ooo`3o
ool02P3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00@0oooo00<001Wo0?ooo`3o
ool02`006Olf0?ooo`00=@3oool:000Io`<0oooo0P006Ol40?ooo`03000Io`3oool0oooo00`0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`80o`001@3oool2000000030?oo
o`3o0000o`000080o`00E`3oool00`000000oooo0?ooo`1D0?ooo`@0o`000P3oool2000000@0oooo
0P3o00000`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0
2`3oool00`006Ol0oooo0?ooo`030?ooo`8001Wo0`3oool:000IocH0oooo000d0?ooo`T001Wo103o
ool5000Io`80oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo00X0oooo00<001Wo0?ooo`3oool01`3oool60?l005H0oooo00<000000?ooo`3oool0D`3o
ool60?l000030000003oool0oooo00L0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool01@006Ol40?ooo`T001Wo=@3o
ool003@0oooo20006Ol50?ooo`L001Wo3P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0
oooo00X0oooo00<001Wo0?ooo`3oool01`3oool60?l005H0oooo00<000000?ooo`3oool0D`3oool6
0?l000X0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0
oooo00`0oooo1`006Ol50?ooo`P001Wo=@3oool003<0oooo1`006Ol60?ooo`P001Wo3@3oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02@3oool40?l0
00<000001P3oool20?l004`0oooo00<000000?ooo`3oool0BP3oool20?l000H0oooo0P0000040?l0
00`0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo
00/0oooo20006Ol60?ooo`L001Wo=03oool003<0oooo1P006Ol70?ooo`X001Wo2P3oool00`006Ol0
oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool20?l000@0
oooo0`0000020?ooo`@0o`00B`3oool00`000000oooo0?ooo`190?ooo`@0o`000P3oool3000000<0
oooo0P3o00000`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3o
ool02`3oool00`006Ol0oooo0?ooo`080?ooo`X001Wo1`3oool6000Ioc@0oooo000b0?ooo`D001Wo
2@3oool;000Io`T0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000I
o`3oool0oooo00/0oooo00<001Wo0?ooo`3oool01P3oool00`000000o`000?l000040?l004X0oooo
00<000000?ooo`3oool0B03oool60?l000030000003oool0oooo00H0oooo00<001Wo0?ooo`3oool0
2`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0
1`3oool;000Io`T0oooo1@006Olc0?ooo`00<P3oool4000Io`T0oooo3@006Ol70?ooo`03000Io`3o
ool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3o
ool0oooo00P0oooo1P3o001:0?ooo`030000003oool0oooo04P0oooo1P3o000:0?ooo`03000Io`3o
ool0oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo00D0oooo3@006Ol90?ooo`@001Wo<`3oool00340oooo0`006Ol;0?ooo``001Wo203oool0
0`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool0
0`006Ol0oooo0?ooo`090?ooo`@0o`00100000050?ooo`80o`00@03oool00`000000oooo0?ooo`0n
0?ooo`80o`001@3oool4000000@0o`002`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0
oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`060?ooo``001Wo2`3oool3
000Ioc80oooo000a0?ooo`8001Wo2`3oool<000Io`P0oooo00<001Wo0?ooo`3oool02`3oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool20?l0
00D0oooo100000040?l003l0oooo00<000000?ooo`3oool0?@3oool40?l000@000001@3oool20?l0
00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo
00/0oooo00<001Wo0?ooo`3oool01P3oool<000Io`/0oooo0P006Olb0?ooo`00<03oool00`006Ol0
oooo0?ooo`0;0?ooo`X001Wo0`3oool00`006Ol0oooo0?ooo`030?ooo`03000Io`3oool0oooo00`0
oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool01`3oool60?l000T0oooo0P3o000c0?ooo`030000003oool0oooo0340
oooo0P3o00090?ooo`H0o`002@3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00X0
oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00<0
oooo00@001Wo0?ooo`3oool0oooo2P006Ol=0?ooo`03000Io`3oool0oooo02l0oooo000n0?ooo`T0
01Wo103oool3000Io`<0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03
000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`070?ooo`H0
o`000`0000050?ooo`@0o`00<P3oool300000300oooo103o00050?ooo`<000001P3o00090?ooo`03
000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03
000Io`3oool0oooo00/0oooo00@001Wo0?ooo`3oool0oooo0`006Ol40?ooo`T001Wo?`3oool003d0
oooo2@006Ol40?ooo`L001Wo3P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`090?ooo`@0o`00103oool4000000H0
o`00<@3oool00`000000oooo0?ooo`0_0?ooo`H0o`00100000040?ooo`@0o`002`3oool00`006Ol0
oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0
oooo0?ooo`0<0?ooo`L001Wo103oool9000Ioch0oooo000m0?ooo`L001Wo1P3oool8000Io``0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool02P3oool20?l000T0oooo1P3o00080?ooo`80o`009`3oool00`000000oooo
0?ooo`0T0?ooo`80o`002@3oool60?l000T0oooo0P3o000<0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00X0oooo
20006Ol60?ooo`L001Wo?P3oool003`0oooo1`006Ol70?ooo`X001Wo2P3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0:0?ooo`03000Io`3oool0oooo00T0oooo103o00000`3oool0000000000004000000030?ooo`3o
0000o`000080o`002`3oool20?l001T0oooo00<000000?ooo`3oool05`3oool20?l000X0oooo103o
00020?ooo`H0000000<0oooo0?l0003o00000P3o000;0?ooo`03000Io`3oool0oooo00X0oooo00<0
01Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<0
01Wo0?ooo`3oool0203oool:000Io`L0oooo1`006Olm0?ooo`00?03oool6000Io`L0oooo30006Ol8
0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0;
0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool20?l000P0oooo1P3o0000
0`000000oooo0?ooo`060?ooo`@0o`002P3oool20?l000`0oooo00<000000?ooo`3oool02P3oool2
0?l000X0oooo103o00080?ooo`H0o`0000<000000?ooo`3oool01P3oool20?l000`0oooo00<001Wo
0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo
0?ooo`3oool0303oool00`006Ol0oooo0?ooo`060?ooo`/001Wo203oool6000Iocd0oooo000l0?oo
o`@001Wo2@3oool;000Io`P0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?oo
o`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0:0?oo
o`03000Io`3oool0oooo00P0oooo1P3o00000`3oool0000000000004000000030?ooo`3o0000o`00
00@0o`00203oool40?l000X0oooo0P3o000;0?ooo`@0o`00203oool60?l000030?ooo`0000000000
00@000001P3o000;0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02P3oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`00
6Ol0oooo0?ooo`070?ooo`/001Wo2@3oool4000Iocd0oooo000k0?ooo`@001Wo2P3oool:000Io`T0
oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00T0
oooo103o00080?ooo`030000003o0000o`0000@0o`000`0000040?ooo`H0o`00203oool40?l000T0
oooo1P3o00040?ooo`<000001P3o00000`000000oooo0?ooo`050?ooo`@0o`00303oool00`006Ol0
oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0
oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool01`3oool:000Io`X0
oooo10006Oll0?ooo`00>`3oool3000Io`/0oooo2@006Ol30?ooo`03000Io`3oool0oooo00<0oooo
00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00X0oooo
0P3o000;0?ooo`@0o`00103oool4000000H0o`001`0000060?l000P000001P3o0004000000@0oooo
103o000:0?ooo`80o`003@3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo
00<001Wo0?ooo`3oool00P3oool00`006Ol0oooo0?ooo`020?ooo`T001Wo2`3oool3000Ioc`0oooo
000j0?ooo`8001Wo303oool9000Io`@0oooo0`006Ol30?ooo`03000Io`3oool0oooo00`0oooo00<0
01Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<0
01Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo0P3o
000:0?ooo`@0o`00203oool60?l000T0oooo103o000:0?ooo`80o`003@3oool00`006Ol0oooo0?oo
o`0:0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?oo
o`03000Io`D0oooo2@006Ol<0?ooo`8001Wo>`3oool003X0oooo00<001Wo0?ooo`3oool02`3oool8
000Io`D0oooo1P006Ol>0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool0
0`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool0
0`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00X0oooo0P3o000:0?ooo`@0o`002`3oool2
0?l000`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0
oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0
oooo00/0oooo00<001Wo0?ooo`3oool0303oool6000Io`D0oooo20006Ol=0?ooo`03000Io`3oool0
oooo03T0oooo00180?ooo`L001Wo1@3oool8000Io`d0oooo00<001Wo0?ooo`3oool02`3oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`00
6Ol0oooo0?ooo`090?ooo`80o`00303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo
00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo
00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo
00X0oooo20006Ol60?ooo`L001WoB@3oool004L0oooo1`006Ol60?ooo`X001Wo2P3oool00`006Ol0
oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0
oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0
oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0000000000002P3oool00`006Ol0
oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0
oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0
oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00L0oooo2P006Ol70?ooo`L001WoB03oool004L0oooo
1P006Ol70?ooo``001Wo203oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00X0oooo
00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00X0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00H0oooo
2`006Ol80?ooo`H001WoB03oool004L0oooo1@006Ol80?ooo`/001Wo2@3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00L0oooo2`006Ol80?ooo`D001WoB03oool004H0oooo1@006Ol8
0?ooo`/001Wo2@3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo
0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo
0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo
0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00X0oooo00<001Wo
0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo
0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00L0oooo2P006Ol9
0?ooo`@001WoB03oool004H0oooo10006Ol90?ooo`X001Wo103oool00`006Ol0oooo0?ooo`030?oo
o`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?oo
o`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?oo
o`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0:0?oo
o`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?oo
o`03000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?oo
o`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool00`3oool00`006Ol0oooo0?ooo`020?oo
o`T001Wo2P3oool4000IodL0oooo00160?ooo`<001Wo2P3oool9000Io`D0oooo0`006Ol20?ooo`03
000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03
000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03
000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0:0?ooo`03
000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03
000Io`3oool0oooo00X0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03
000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool00`006Ol50?ooo`T001Wo2P3oool3000IodL0
oooo00160?ooo`8001Wo2`3oool8000Io`H0oooo1P006Ol=0?ooo`03000Io`3oool0oooo00`0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00X0oooo
00<001Wo0?ooo`3oool02P3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo
00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`H001Wo1P3oool8000Io`/0oooo
0P006Om70?ooo`00A@3oool2000Io`/0oooo20006Ol60?ooo`P001Wo303oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0V`000000
00040000000309_Do`3oool0oooo00@0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?oo
o`0:0?ooo`P001Wo1P3oool7000Io``0oooo0P006Om60?ooo`00A@3oool00`006Ol0oooo0?ooo`0:
0?ooo`L001Wo1`3oool:000Io`X0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<
0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;
0?ooo`03000Io`3oool0oooo00/0oooo00@001Wo0=BK000009/0e?oo0P3oool00`3Z^Y/0^^[o0?oo
o`050?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0203oool:000Io`L0oooo1P00
6Ol=0?ooo`03000Io`3oool0oooo04@0oooo001B0?ooo`H001Wo203oool;000Io`P0oooo00<001Wo
0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo
0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00D001Wo
0?ooo`3oe9/0001b0;[Zo`090?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3o
ool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3o
ool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool01P3o
ool;000Io`L0oooo1`006OmC0?ooo`00DP3oool6000Io`P0oooo2P006Ol90?ooo`03000Io`3oool0
oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0
oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`06000Io`3oool0
oooo0?oZ^P1b0000L[[Z203oool010006Ol0000000000000000:0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0
oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00L0
oooo2P006Ol80?ooo`H001WoD`3oool00540oooo1P006Ol90?ooo`T001Wo2@3oool00`006Ol0oooo
0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo
0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo
0?ooo`020?ooo`030;Yb001b^^X0oooo00H0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo
0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo
0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo
0?ooo`070?ooo`T001Wo2@3oool5000Ioe<0oooo001A0?ooo`D001Wo2P3oool9000Io`@0oooo0P00
6Ol30?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00<0oooo00<0^W:K0=Coo`3oool01@3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?oo
o`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?oo
o`0<0?ooo`04000Io`3oool0oooo0?ooo`8001Wo103oool9000Io`X0oooo1@006OmB0?ooo`00D@3o
ool4000Io`X0oooo2@006Ol50?ooo`H001Wo3P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo00`0oooo00<001Wo0>ZjLP2Ke?l00`3oool00`3DV`00VmCo0?ooo`050?ooo`03000Io`3o
ool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo00`0oooo1P006Ol50?ooo`T001Wo2P3oool4000Ioe80oooo001A0?ooo`<001Wo2`3oool8
000Io`H0oooo20006Ol<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool0
0`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool0
20006Ol0omBK0000V`3Dool0oooo0?oDV`000780^^[o1P3oool00`006Ol0oooo0?ooo`0;0?ooo`03
000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03
000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0:0?ooo`P0
01Wo1P3oool8000Io`/0oooo0`006OmB0?ooo`00D03oool3000Io``0oooo1`006Ol70?ooo`X001Wo
2@3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0
303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oe9/0
0P0000000`000780^^[o0?ooo`060?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0
303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0
2`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00L0oooo2P006Ol70?ooo`L001Wo
303oool2000Ioe80oooo001@0?ooo`8001Wo3@3oool7000Io`H0oooo2P006Ol:0?ooo`03000Io`3o
ool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3o
ool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3o
ool0oooo00P0oooo2P006Ol60?ooo`L001Wo3@3oool2000Ioe40oooo001@0?ooo`03000Io`3oool0
oooo00`0oooo1P006Ol70?ooo`X001Wo2P3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0
oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0
oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0
oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0
oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`080?ooo`X001Wo1`3oool6
000Io`h0oooo00<001Wo0?ooo`3oool0C`3oool005h0oooo1P006Ol80?ooo`T001Wo1@3oool2000I
o`<0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo
00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo
00/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo
00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo
00`0oooo00@001Wo0?ooo`3oool0oooo0P006Ol50?ooo`T001Wo203oool6000Ioel0oooo001N0?oo
o`D001Wo2@3oool8000Io`H0oooo1P006Ol>0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?oo
o`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?oo
o`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?oo
o`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?oo
o`3oool0303oool6000Io`H0oooo20006Ol90?ooo`D001WoG`3oool005h0oooo1@006Ol90?ooo`P0
01Wo1P3oool9000Io`/0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03
000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03
000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03
000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`090?ooo`T0
01Wo1P3oool8000Io`T0oooo1@006OmO0?ooo`00GP3oool4000Io`X0oooo1`006Ol70?ooo`/001Wo
203oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0
2`3oool00`006Ol0oooo0?ooo`0=0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo000000000000
2`3oool00`006Ol0oooo0?ooo`0=0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool0
303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00H0oooo2`006Ol70?ooo`L001Wo
2P3oool4000Ioel0oooo001N0?ooo`<001Wo2`3oool6000Io`P0oooo2P006Ol90?ooo`03000Io`3o
ool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo00d0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo00d0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3o
ool0oooo00`0oooo00<001Wo0?ooo`3oool01`3oool:000Io`P0oooo1P006Ol;0?ooo`<001WoG`3o
ool005h0oooo0P006Ol;0?ooo`L001Wo203oool:000Io`T0oooo00<001Wo0?ooo`3oool02`3oool0
0`006Ol0oooo0?ooo`0=0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool03@3oool0
0`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool03@3oool0
0`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool02`3oool0
0`006Ol0oooo0?ooo`070?ooo`X001Wo203oool7000Io`/0oooo0P006OmO0?ooo`00G@3oool3000I
o`/0oooo1P006Ol80?ooo`X001Wo103oool3000Io`<0oooo00<001Wo0?ooo`3oool02`3oool00`00
6Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool03@3oool00`00
6Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool03@3oool00`00
6Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02`3oool01000
6Ol0oooo0?ooo`3oool3000Io`@0oooo2P006Ol80?ooo`H001Wo2`3oool3000Ioeh0oooo001M0?oo
o`8001Wo303oool5000Io`T0oooo2@006Ol50?ooo`P001Wo303oool00`006Ol0oooo0?ooo`0<0?oo
o`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?ooo`0;0?oo
o`03000Io`3oool0oooo00/0oooo00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?ooo`0<0?oo
o`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool02P3oool8000Io`D0oooo2@006Ol90?oo
o`D001Wo303oool2000Ioeh0oooo001M0?ooo`03000Io`3oool0oooo00/0oooo1@006Ol90?ooo`T0
01Wo1@3oool;000Io`T0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03
000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0;0?ooo`03
000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03
000Io`3oool0oooo00L0oooo2`006Ol50?ooo`T001Wo2@3oool5000Io`d0oooo00<001Wo0?ooo`3o
ool0G03oool006/0oooo10006Ol:0?ooo`P001Wo1P3oool:000Io`X0oooo00<001Wo0?ooo`3oool0
303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0
303oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool0
303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00P0oooo2P006Ol60?ooo`P001Wo
2P3oool4000Iof`0oooo001[0?ooo`<001Wo2`3oool8000Io`H0oooo2P006Ol90?ooo`03000Io`3o
ool0oooo00d0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3o
ool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3o
ool0oooo00`0oooo00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?ooo`070?ooo`X001Wo1P3o
ool8000Io`/0oooo0`006Om/0?ooo`00J`3oool3000Io`/0oooo1`006Ol70?ooo`T001Wo1@3oool3
000Io`80oooo00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0
oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0
oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0=0?ooo`03000Io`3oool0
oooo00<001Wo1@3oool9000Io`L0oooo1`006Ol;0?ooo`<001WoK03oool006X0oooo0`006Ol<0?oo
o`H001Wo203oool9000Io`D0oooo2@006Ol<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?oo
o`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?oo
o`3oool0303oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00X0oooo2@006Ol50?oo
o`T001Wo203oool6000Io``0oooo0`006Om[0?ooo`00JP3oool2000Io`d0oooo1P006Ol80?ooo`P0
01Wo1P3oool<000Io`P0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0=0?ooo`03
000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0=0?ooo`03
000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool01P3oool<000Io`H0oooo20006Ol80?ooo`H0
01Wo3@3oool2000Iof/0oooo001Z0?ooo`8001Wo3@3oool5000Io`T0oooo20006Ol60?ooo`/001Wo
103oool3000Io`80oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`0=0?ooo`03000I
o`3oool0oooo00`0oooo00<001Wo000000000000303oool00`006Ol0oooo0?ooo`0=0?ooo`03000I
o`3oool0oooo00`0oooo00<001Wo0?ooo`3oool00`006Ol40?ooo`/001Wo1P3oool8000Io`T0oooo
1@006Ol=0?ooo`8001WoJ`3oool006X0oooo00<001Wo0?ooo`3oool0303oool4000Io`X0oooo1`00
6Ol70?ooo`/001Wo103oool8000Io``0oooo00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?oo
o`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?oo
o`0:0?ooo`P001Wo103oool;000Io`L0oooo1`006Ol:0?ooo`@001Wo3P3oool00`006Ol0oooo0?oo
o`1Y0?ooo`00N@3oool4000Io`X0oooo1`006Ol70?ooo`X001Wo1@3oool;000Io`T0oooo00<001Wo
0?ooo`3oool03@3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo
0?ooo`3oool03@3oool00`006Ol0oooo0?ooo`070?ooo`/001Wo1@3oool:000Io`L0oooo1`006Ol:
0?ooo`@001WoNP3oool007P0oooo10006Ol;0?ooo`H001Wo203oool:000Io`D0oooo2`006Ol40?oo
o`H001Wo3`3oool00`006Ol0oooo0?ooo`0<0?ooo`03000Io`3oool0oooo00`0oooo00<001Wo0?oo
o`3oool03@3oool6000Io`@0oooo2`006Ol50?ooo`X001Wo203oool6000Io`/0oooo10006Omi0?oo
o`00N03oool4000Io`/0oooo1P006Ol80?ooo`T001Wo1P3oool:000Io`D0oooo2`006Ol:0?ooo`03
000Io`3oool0oooo00`0oooo00<001Wo0?ooo`3oool0303oool00`006Ol0oooo0?ooo`070?ooo``0
01Wo1@3oool:000Io`H0oooo2@006Ol80?ooo`H001Wo2`3oool4000IogT0oooo001h0?ooo`<001Wo
303oool5000Io`T0oooo2@006Ol60?ooo`X001Wo1@3oool;000Io`@0oooo1`006Ol>0?ooo`03000I
o`3oool0oooo00`0oooo1`006Ol30?ooo``001Wo1@3oool:000Io`H0oooo2@006Ol90?ooo`D001Wo
303oool3000IogT0oooo001h0?ooo`8001Wo3@3oool5000Io`T0oooo20006Ol80?ooo`P001Wo1P3o
ool:000Io`D0oooo30006Ol40?ooo`/001Wo103oool<000Io`@0oooo2`006Ol60?ooo`P001Wo203o
ool8000Io`T0oooo1@006Ol=0?ooo`8001WoN@3oool007P0oooo0P006Ol=0?ooo`@001Wo2P3oool8
000Io`P0oooo20006Ol70?ooo`T001Wo1@3oool<000Io`@0oooo2`006Ol40?ooo``001Wo103oool:
000Io`L0oooo20006Ol80?ooo`P001Wo2P3oool4000Io`d0oooo0P006Omi0?ooo`00N03oool00`00
6Ol0oooo0?ooo`0<0?ooo`@001Wo2`3oool6000Io`T0oooo20006Ol70?ooo`T001Wo1P3oool:000I
o`D0oooo2`006Ol50?ooo`X001Wo1P3oool9000Io`L0oooo20006Ol90?ooo`H001Wo2`3oool4000I
o`h0oooo00<001Wo0?ooo`3oool0M`3oool008L0oooo0`006Ol<0?ooo`H001Wo2@3oool7000Io`P0
oooo20006Ol70?ooo`X001Wo1P3oool9000Io`H0oooo2P006Ol60?ooo`T001Wo203oool7000Io`T0
oooo1P006Ol<0?ooo`<001WoR03oool008L0oooo0`006Ol<0?ooo`D001Wo2P3oool7000Io`P0oooo
20006Ol70?ooo`X001Wo1P3oool9000Io`H0oooo2P006Ol60?ooo`T001Wo203oool7000Io`X0oooo
1@006Ol<0?ooo`<001WoR03oool008L0oooo0P006Ol=0?ooo`D001Wo2P3oool6000Io`T0oooo2000
6Ol70?ooo`T001Wo1`3oool9000Io`H0oooo2P006Ol70?ooo`P001Wo2@3oool6000Io`X0oooo1@00
6Ol=0?ooo`8001WoR03oool008L0oooo0P006Ol=0?ooo`@001Wo2`3oool6000Io`T0oooo1`006Ol9
0?ooo`P001Wo1`3oool9000Io`L0oooo20006Ol80?ooo`P001Wo2@3oool6000Io`/0oooo10006Ol=
0?ooo`8001WoR03oool008L0oooo00<001Wo0?ooo`3oool0303oool4000Io`/0oooo1P006Ol90?oo
o`L001Wo2@3oool8000Io`P0oooo1`006Ol80?ooo`P001Wo2@3oool7000Io`T0oooo1P006Ol;0?oo
o`@001Wo3P3oool00`006Ol0oooo0?ooo`260?ooo`00UP3oool3000Io``0oooo1@006Ol;0?ooo`D0
01Wo2P3oool8000Io`P0oooo1`006Ol80?ooo`P001Wo2@3oool6000Io`/0oooo1@006Ol<0?ooo`<0
01WoU`3oool009H0oooo0`006Ol<0?ooo`D001Wo2`3oool5000Io`X0oooo1`006Ol90?ooo`L001Wo
2@3oool7000Io`T0oooo1P006Ol;0?ooo`D001Wo303oool3000IoiL0oooo002F0?ooo`8001Wo3@3o
ool4000Io``0oooo1@006Ol;0?ooo`H001Wo2@3oool7000Io`T0oooo1P006Ol;0?ooo`D001Wo303o
ool4000Io`d0oooo0P006OnG0?ooo`00UP3oool2000Io`h0oooo0`006Ol<0?ooo`@001Wo303oool6
000Io`X0oooo1@006Ol:0?ooo`H001Wo2`3oool5000Io``0oooo0`006Ol>0?ooo`8001WoU`3oool0
09H0oooo00<001Wo0?ooo`3oool03@3oool3000Io``0oooo10006Ol<0?ooo`D001Wo2`3oool5000I
o`/0oooo1@006Ol<0?ooo`@001Wo303oool3000Io`l0oooo00<001Wo0?ooo`3oool0U@3oool00:H0
oooo0P006Ol=0?ooo`@001Wo303oool5000Io`/0oooo1@006Ol;0?ooo`D001Wo303oool4000Io`d0
oooo0P006OnW0?ooo`00YP3oool2000Io`d0oooo0`006Ol>0?ooo`@001Wo2`3oool5000Io`/0oooo
10006Ol=0?ooo`@001Wo3@3oool2000IojL0oooo002V0?ooo`03000Io`3oool0oooo00d0oooo0P00
6Ol>0?ooo`<001Wo3@3oool3000Io``0oooo10006Ol>0?ooo`8001Wo3`3oool00`006Ol0oooo0?oo
o`2U0?ooo`00YP3oool00`006Ol0oooo0?ooo`0=0?ooo`8001Wo3P3oool3000Io`d0oooo0`006Ol0
0`000000oooo0?ooo`0:0?ooo`<001Wo3P3oool2000Io`l0oooo00<001Wo0?ooo`3oool0Y@3oool0
0;H0oooo00<001Wo0?ooo`3oool03@3oool3000Io`d0oooo0`006Ol=0?ooo`<001Wo3`3oool00`00
6Ol0oooo0?ooo`2e0?ooo`00]P3oool00`006Ol0oooo0?ooo`0>0?ooo`8001Wo3@3oool3000Io`d0
oooo0P006Ol@0?ooo`03000Io`3oool0oooo0;D0oooo00370?ooo`03000Io`3oool0oooo00d0oooo
00<001Wo0?ooo`3oool03@3oool00`006Ol0oooo0?ooo`360?ooo`00a`3oool00`006Ol0oooo0?oo
o`0=0?ooo`03000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool0aP3oool00=L0oooo00<001Wo
0?ooo`3oool0eP3oool00=L0oooo00<000000?ooo`3oool0eP3oool00</0oooo00D0e9/000000000
0000000007:jjP070?ooo`030000003oool0oooo0=H0oooo003:0?ooo`070=BK0000Vm@0oooo0?oo
o`3oom@0V`0007:jjP060?ooo`030000003oool0oooo0=H0oooo003?0?ooo`030?oDV`00Vm@0oooo
00D0oooo00<000000?ooo`3oool0eP3oool00<h0oooo00<0onZj0780LP2jj_l01P3oool00`000000
oooo0?ooo`3F0?ooo`00c03oool0103Z^W8000000000LP2jj_l70?ooo`@00000e@3oool00<h0oooo
00<0onZj0780LP2jj_l01P3oool00`000000oooo0?ooo`3F0?ooo`00c`3oool00`3DV`00VmCo0?oo
o`3N0?ooo`00bP3oool01`3oe9/0001b0;[Zo`3oool0onZj0780LP2jj_l0g`3oool00</0oooo00D0
onZj078000000000000009_Do`3P0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 431}, {339, 0}} -> {-3.97239, -3.12444, 0.02765, \
0.02765}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
    RowBox[{
      RowBox[{
        RowBox[{\(\[Gamma][t_]\), "=", 
          StyleBox[\({Cos[3  t/5], Sin[2  t/5]}\),
            FontSize->12]}], 
        StyleBox[";",
          FontSize->12], 
        "\n", \(vectgnte3 = 
          Graphics[\n\t\tTable[{{Hue[ .65], 
                  vector2D[\[Gamma][t], \(\[Gamma]'\)[t]]}, {Hue[0], 
                  PointSize[ .015], Point[\[Gamma][t]]}}, {t, 0, 10  \[Pi], 
                2. }]\[IndentingNewLine]\t\t\t\t\t]\), ";"}], 
      "\t\t\t\t\t\t\t\t\t\t\t"}], "\n", \(Show[{graf3, 
          vectgnte3}];\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .90503 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.49523 0.412559 0.455652 0.412559 [
[.08267 .44315 -6 -9 ]
[.08267 .44315 6 0 ]
[.28895 .44315 -12 -9 ]
[.28895 .44315 12 0 ]
[.70151 .44315 -9 -9 ]
[.70151 .44315 9 0 ]
[.90779 .44315 -3 -9 ]
[.90779 .44315 3 0 ]
[.48273 .04309 -12 -4.5 ]
[.48273 .04309 0 4.5 ]
[.48273 .24937 -24 -4.5 ]
[.48273 .24937 0 4.5 ]
[.48273 .66193 -18 -4.5 ]
[.48273 .66193 0 4.5 ]
[.48273 .86821 -6 -4.5 ]
[.48273 .86821 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .90503 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08267 .45565 m
.08267 .4619 L
s
[(-1)] .08267 .44315 0 1 Mshowa
.28895 .45565 m
.28895 .4619 L
s
[(-0.5)] .28895 .44315 0 1 Mshowa
.70151 .45565 m
.70151 .4619 L
s
[(0.5)] .70151 .44315 0 1 Mshowa
.90779 .45565 m
.90779 .4619 L
s
[(1)] .90779 .44315 0 1 Mshowa
.125 Mabswid
.12393 .45565 m
.12393 .4594 L
s
.16518 .45565 m
.16518 .4594 L
s
.20644 .45565 m
.20644 .4594 L
s
.24769 .45565 m
.24769 .4594 L
s
.33021 .45565 m
.33021 .4594 L
s
.37146 .45565 m
.37146 .4594 L
s
.41272 .45565 m
.41272 .4594 L
s
.45397 .45565 m
.45397 .4594 L
s
.53649 .45565 m
.53649 .4594 L
s
.57774 .45565 m
.57774 .4594 L
s
.619 .45565 m
.619 .4594 L
s
.66025 .45565 m
.66025 .4594 L
s
.74277 .45565 m
.74277 .4594 L
s
.78402 .45565 m
.78402 .4594 L
s
.82528 .45565 m
.82528 .4594 L
s
.86653 .45565 m
.86653 .4594 L
s
.04141 .45565 m
.04141 .4594 L
s
.00016 .45565 m
.00016 .4594 L
s
.94905 .45565 m
.94905 .4594 L
s
.9903 .45565 m
.9903 .4594 L
s
.25 Mabswid
0 .45565 m
1 .45565 L
s
.49523 .04309 m
.50148 .04309 L
s
[(-1)] .48273 .04309 1 0 Mshowa
.49523 .24937 m
.50148 .24937 L
s
[(-0.5)] .48273 .24937 1 0 Mshowa
.49523 .66193 m
.50148 .66193 L
s
[(0.5)] .48273 .66193 1 0 Mshowa
.49523 .86821 m
.50148 .86821 L
s
[(1)] .48273 .86821 1 0 Mshowa
.125 Mabswid
.49523 .08435 m
.49898 .08435 L
s
.49523 .1256 m
.49898 .1256 L
s
.49523 .16686 m
.49898 .16686 L
s
.49523 .20812 m
.49898 .20812 L
s
.49523 .29063 m
.49898 .29063 L
s
.49523 .33188 m
.49898 .33188 L
s
.49523 .37314 m
.49898 .37314 L
s
.49523 .4144 m
.49898 .4144 L
s
.49523 .49691 m
.49898 .49691 L
s
.49523 .53816 m
.49898 .53816 L
s
.49523 .57942 m
.49898 .57942 L
s
.49523 .62068 m
.49898 .62068 L
s
.49523 .70319 m
.49898 .70319 L
s
.49523 .74444 m
.49898 .74444 L
s
.49523 .7857 m
.49898 .7857 L
s
.49523 .82696 m
.49898 .82696 L
s
.49523 .00184 m
.49898 .00184 L
s
.25 Mabswid
.49523 0 m
.49523 .90503 L
s
0 0 m
1 0 L
1 .90503 L
0 .90503 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
.5 Mabswid
.90779 .45565 m
.90768 .46205 L
.90738 .46787 L
.90681 .47459 L
.90605 .48093 L
.90414 .4922 L
.9013 .5044 L
.89723 .51778 L
.89185 .5319 L
.87953 .55699 L
.8633 .58246 L
.845 .60586 L
.79294 .65697 L
.72692 .70521 L
.65755 .7451 L
.56919 .78563 L
.48376 .8167 L
.40935 .8382 L
.33322 .85492 L
.29227 .86149 L
.27306 .86391 L
.25596 .86567 L
.2409 .86687 L
.23352 .86733 L
.22557 .86772 L
.21776 .868 L
.21345 .86811 L
.20958 .86817 L
.20219 .86821 L
.19536 .86814 L
.18905 .86797 L
.18242 .86769 L
.17633 .86733 L
.1709 .86691 L
.15884 .86563 L
.15308 .86482 L
.14701 .86381 L
.13622 .86153 L
.12571 .85859 L
.1168 .85533 L
.10956 .85196 L
.10352 .84845 L
.09795 .84438 L
.09282 .83948 L
.08901 .83457 L
.08758 .83225 L
.08626 .82968 L
.08528 .82738 L
.08438 .82481 L
.08358 .82171 L
Mistroke
.08305 .81867 L
.08275 .81562 L
.08267 .81273 L
.08282 .80915 L
.083 .80731 L
.08327 .80527 L
.08396 .80158 L
.08483 .79804 L
.08761 .78976 L
.09184 .78045 L
.10291 .76218 L
.11662 .74428 L
.20108 .66392 L
.49354 .45678 L
.77812 .25652 L
.83271 .20973 L
.87141 .1699 L
.88687 .1501 L
.89737 .13324 L
.90156 .12464 L
.90481 .11602 L
.90604 .1117 L
.90689 .1078 L
.90725 .1056 L
.9075 .10364 L
.90769 .10141 L
.90778 .09934 L
.90774 .0962 L
.90745 .09293 L
.90695 .08993 L
.9063 .08727 L
.90531 .08425 L
.90394 .08107 L
.90068 .07561 L
.89624 .07034 L
.89035 .06523 L
.8844 .06128 L
.87683 .05735 L
.86954 .05436 L
.86108 .05159 L
.85088 .04899 L
.84071 .04702 L
.83052 .04554 L
.82044 .04447 L
.81441 .04399 L
.80877 .04365 L
.80209 .04335 L
.7956 .04318 L
.78909 .0431 L
.78191 .04312 L
Mistroke
.77499 .04324 L
.76852 .04344 L
.76081 .04377 L
.75221 .04426 L
.73608 .0455 L
.71865 .04725 L
.69944 .04964 L
.66341 .05528 L
.58862 .07121 L
.51783 .09107 L
.36294 .15133 L
.28272 .19418 L
.21748 .23832 L
.16415 .28509 L
.12543 .33128 L
.10854 .35865 L
.09673 .38399 L
.09172 .39814 L
.08951 .40562 L
.0875 .41359 L
.08603 .42055 L
.08472 .42825 L
.08381 .43525 L
.08319 .44183 L
.08282 .44824 L
.08267 .45508 L
.08276 .46155 L
.08305 .46741 L
.08362 .47432 L
.08406 .47821 L
.08453 .4818 L
.08697 .49534 L
.09025 .5083 L
.0949 .52249 L
.10761 .55091 L
.1221 .57514 L
.14112 .60067 L
.18393 .64514 L
.24416 .69234 L
.32116 .73892 L
.40251 .77781 L
.47971 .80765 L
.55692 .83176 L
.63778 .85117 L
.68001 .8588 L
.69783 .86144 L
.71679 .86384 L
.73301 .86553 L
.74977 .86688 L
.75876 .86743 L
Mistroke
.76677 .8678 L
.77464 .86805 L
.78191 .86818 L
.78857 .86821 L
.79556 .86813 L
.802 .86795 L
.80775 .86771 L
.81429 .86732 L
.82121 .86677 L
.8332 .86542 L
.83941 .8645 L
.84483 .86355 L
.85622 .86104 L
.86583 .85824 L
.87402 .85518 L
.8809 .85196 L
.88734 .84819 L
.89222 .84461 L
.89672 .84047 L
.90072 .83564 L
.90365 .83081 L
.90506 .8277 L
.90613 .82465 L
.90686 .82181 L
.90742 .81864 L
.90772 .81545 L
.90779 .81244 L
.90763 .80905 L
.9072 .80537 L
.90661 .80209 L
.90587 .79896 L
.90355 .79161 L
.89994 .78312 L
.8957 .77505 L
.88296 .75581 L
.84422 .71255 L
.79301 .66691 L
.51391 .46811 L
.35758 .36289 L
.20972 .25441 L
.15763 .20962 L
.11584 .16608 L
.10143 .14697 L
.0958 .13806 L
.09146 .13011 L
.08805 .12263 L
.08567 .11611 L
.08469 .11273 L
.08384 .10916 L
.08319 .10548 L
Mistroke
.08282 .10211 L
.08267 .09867 L
.08275 .09561 L
.08311 .09219 L
.0837 .08904 L
.08447 .08623 L
.08536 .0837 L
.08805 .07825 L
.08981 .07557 L
.09168 .07314 L
.09674 .06796 L
.10274 .06337 L
.11035 .05893 L
.11837 .05533 L
.12824 .05192 L
.13975 .04895 L
.15152 .04673 L
.15757 .04584 L
.16349 .04512 L
.16904 .04456 L
.17509 .04406 L
.18189 .04364 L
.18834 .04335 L
.19547 .04316 L
.19961 .04311 L
.20353 .04309 L
.21087 .04315 L
.21465 .04322 L
.21887 .04333 L
.22645 .04362 L
.23373 .04399 L
.25058 .04517 L
.26951 .04699 L
.30587 .05179 L
.34098 .05783 L
.41146 .07365 L
.48858 .09617 L
.56598 .12437 L
.64593 .1603 L
.71537 .19882 L
.77257 .23801 L
.82828 .2871 L
.85229 .31426 L
.87331 .34382 L
.88764 .36997 L
.89766 .3948 L
.90188 .40914 L
.90475 .4223 L
.90594 .42959 L
.90644 .43344 L
Mistroke
.90689 .43754 L
.90724 .44148 L
.90748 .44506 L
.90775 .45204 L
.90779 .45565 L
Mfstroke
0 .1 1 r
.90779 .45565 m
.90779 .62068 L
s
% Start of user PostScript
1. 0 1. 0.4 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.90779 .45565 Mdot
0 .1 1 r
.5 Mabswid
.64472 .7516 m
.41401 .86658 L
s
% Start of user PostScript
0.362358 0.717356 -0.196866 0.996039 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.64472 .7516 Mdot
0 .1 1 r
.5 Mabswid
.19101 .86804 m
.02381 .86322 L
s
% Start of user PostScript
-0.737394 0.999574 -1.14267 0.987894 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.19101 .86804 Mdot
0 .1 1 r
.5 Mabswid
.12526 .73432 m
.2348 .61263 L
s
% Start of user PostScript
-0.896758 0.675463 -0.631246 0.380506 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.12526 .73432 Mdot
0 .1 1 r
.5 Mabswid
.53133 .43157 m
.77791 .26683 L
s
% Start of user PostScript
0.087499 -0.0583741 0.685198 -0.457692 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.53133 .43157 Mdot
0 .1 1 r
.5 Mabswid
.89136 .14343 m
.96052 .03556 L
s
% Start of user PostScript
0.96017 -0.756802 1.12782 -1.01826 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.89136 .14343 Mdot
0 .1 1 r
.5 Mabswid
.74621 .04467 m
.54975 .05911 L
s
% Start of user PostScript
0.608351 -0.996165 0.132151 -0.961165 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.74621 .04467 Mdot
0 .1 1 r
.5 Mabswid
.28099 .19522 m
.06945 .3232 L
s
% Start of user PostScript
-0.519289 -0.631267 -1.03205 -0.32104 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.28099 .19522 Mdot
0 .1 1 r
.5 Mabswid
.08899 .50374 m
.13214 .66763 L
s
% Start of user PostScript
-0.984688 0.116549 -0.880092 0.513823 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.08899 .50374 Mdot
0 .1 1 r
.5 Mabswid
.41506 .78309 m
.65787 .88348 L
s
% Start of user PostScript
-0.19433 0.793668 0.394232 1.03701 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.41506 .78309 Mdot
0 .1 1 r
.5 Mabswid
.84337 .86382 m
.97619 .83981 L
s
% Start of user PostScript
0.843854 0.989358 1.1658 0.931158 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.84337 .86382 Mdot
0 .1 1 r
.5 Mabswid
.8277 .69696 m
.68115 .56312 L
s
% Start of user PostScript
0.805884 0.584917 0.45064 0.26048 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.8277 .69696 Mdot
0 .1 1 r
.5 Mabswid
.38804 .38373 m
.149 .22123 L
s
% Start of user PostScript
-0.259817 -0.174327 -0.839212 -0.568202 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.38804 .38373 Mdot
0 .1 1 r
.5 Mabswid
.08507 .11412 m
.0584 .02155 L
s
% Start of user PostScript
-0.994178 -0.827826 -1.05883 -1.05222 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.08507 .11412 Mdot
0 .1 1 r
.5 Mabswid
.30517 .05168 m
.52488 .08518 L
s
% Start of user PostScript
-0.460679 -0.979178 0.0718616 -0.897976 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.30517 .05168 Mdot
0 .1 1 r
.5 Mabswid
.76765 .23428 m
.95355 .37354 L
s
% Start of user PostScript
0.660317 -0.536573 1.11091 -0.199031 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.76765 .23428 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 260.625},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001QR000`400?l00000o`00003oe@3oool3
00000=P0oooo003E0?ooo`030000003oool0oooo0=P0oooo003E0?ooo`030000003oool0oooo0=P0
oooo003E0?ooo`030000003oool0oooo0=P0oooo003E0?ooo`030000003oool0oooo0=P0oooo003E
0?ooo`030000003oool0oooo0=P0oooo003E0?ooo`030000003oool0oooo0=P0oooo003E0?ooo`03
0000003oool0oooo0=P0oooo003E0?ooo`030000003oool0oooo0=P0oooo000I0?ooo`03000Io`3o
ool0oooo0;T0oooo00<000000?ooo`3oool0f03oool001T0oooo0P006Onj0?ooo`030000003oool0
oooo0=P0oooo000I0?ooo`8001Wo^P3oool00`000000oooo0?ooo`3H0?ooo`006@3oool3000IokT0
oooo00<000000?ooo`3oool0f03oool001T0oooo0`006Oni0?ooo`030000003oool0oooo0=P0oooo
000I0?ooo`@001Wo^03oool00`000000oooo0?ooo`3H0?ooo`006@3oool4000Ioj/0oooo00<0omBK
0000000000000`0000000`00Vm@0oooo0?ooo`040?ooo`030000003oool0oooo0<D0oooo00<001Wo
0?ooo`3oool0403oool001T0oooo1@006On]0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?oo
o`3oool0J03oool20?l005X0oooo0P006OlB0?ooo`006@3oool6000Ioj`0oooo00<0^W9b0;[Zo`3o
ool01`3oool00`000000oooo0?ooo`1W0?ooo`@0o`00F03oool2000Ioa<0oooo000I0?ooo`H001Wo
;P3ooolF000006P0oooo00<0^W9b0;[Zo`3oool01`3oool4000002L0oooo0P006Oll0?ooo`H0o`00
0P3ooolG000003d0oooo0`006OlC0?ooo`006@3oool7000Iob<0oooo2P00000F0?ooo`d00000C`3o
ool00`2jLP0000000000000300000003001b^P3oool0oooo00<0oooo00<0^W9b0;[Zo`3oool01`3o
ool00`000000oooo0?ooo`0U0?ooo`D001Wo>03oool4000Io`H0o`000P00000G0?ooo`/00000<@3o
ool4000Ioa<0oooo000I0?ooo`L001Wo7`3oool4000002d0oooo2000000:0?ooo`80o`00A`3oool0
0`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo0280oooo20006OlZ0?ooo`h001Wo1@3oool4
0?l002D0oooo1000000/0?ooo`@001Wo503oool001T0oooo20006OlI0?ooo`D00000>@3oool80000
00030?ooo`3o0000o`000080o`00AP3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo
01l0oooo2`006OlL0?ooo`h001Wo1P00000>0?ooo`80o`00:P3oool5000002H0oooo1@006OlD0?oo
o`006@3oool9000Ioa@0oooo100000160?ooo`H0o`0000<001Wo0?ooo`3oool0?`3oool01@3Z^W80
0000001b^P2jLW80^^[o00P0oooo00<000000?ooo`3oool0703oool>000Io`h0oooo3P006Ol40?oo
o`P00000A`3oool400000240oooo1P006OlD0?ooo`006@3oool9000Ioa40oooo0`00001:0?ooo`H0
o`0000<0oooo000Io`006Ol01@006Ol00`000000oooo0?ooo`0i0?ooo`030>ZjLP000780^^[o00P0
oooo00<000000?ooo`3oool06@3ooolO000Io`/0oooo1`00001C0?ooo`<00000703oool7000IoaD0
oooo000I0?ooo`X001Wo3P3oool2000004h0oooo103o00090?ooo`H001Wo00<000000?ooo`3oool0
?P3oool00`000000oooo0?ooo`0F0?oooaD001Wo503oool4000005d0oooo0P00000I0?ooo`P001Wo
5@3oool001T0oooo2P006Ol<0?ooo`800000D@3oool20?l00100oooo1`006Olj0?ooo`030000003o
ool0oooo01@0oooo5`006Ol?0?ooo`D00000H`3oool2000001H0oooo2@006OlE0?ooo`006@3oool;
000Io`T0oooo0P00001Z0?ooo`8000001`006Olc0?ooo`030000003oool0oooo01L0oooo50006Ol;
0?ooo`@00000JP3oool2000001<0oooo2@006OlF0?ooo`006@3oool;000Io`P0oooo00<000000?oo
o`3oool0K`3oool4000000L001Wo;03oool00`000000oooo0?ooo`0M0?ooo`h001Wo1P3oool50000
0700oooo00<000000?ooo`3oool03`3oool:000IoaH0oooo000I0?ooo``001Wo1@3oool2000007H0
oooo100000030?ooo`L001Wo7@3oool2000Io`H0oooo00<000000?ooo`3oool08P3oool9000Io`03
0?ooo`000000000000<00000MP3oool00`000000oooo0?ooo`0=0?ooo`/001Wo5P3oool001T0oooo
2P006Ol60?ooo`030000003oool0oooo07X0oooo1@0000050?ooo`H001Wo5`3oool4000Io`@0oooo
00<000000?ooo`3oool0:03oool3000Io`030000003oool0oooo07X0oooo0P00000<0?ooo`/001Wo
5`3oool001T0oooo1`006Ol80?ooo`030000003oool0oooo0800oooo100000070?ooo`L001Wo403o
ool7000Io`030?ooo`000000oooo02D0oooo100000220?ooo`030000003oool0oooo00P0oooo3000
6OlG0?ooo`006@3oool2000Io`@0oooo00<001Wo0?ooo`3oool01@3oool00`000000oooo0?ooo`25
0?ooo`@000002P3oool7000Io`T0oooo2P006OlR0?ooo`<00000Q`3oool00`000000oooo0?ooo`08
0?ooo`/001Wo5`3oool001l0oooo00<001Wo0?ooo`3oool0103oool00`000000oooo0?ooo`2:0?oo
o`<000003P3oool7000Io`80oooo30006OlL0?ooo`@00000R`3oool00`000000oooo0?ooo`090?oo
o`P001Wo603oool00200oooo00<001Wo0?ooo`3oool00`3oool00`000000oooo0?ooo`2=0?ooo`@0
00004@3ooolA000IoaH0oooo0`00002?0?ooo`030000003oool0oooo00X0oooo1`006OlH0?ooo`00
803oool00`006Ol0oooo0?ooo`020?ooo`030000003oool0oooo0980oooo0`00000?0?oooa<001Wo
403oool3000009<0oooo00<000000?ooo`3oool02@3oool00`006Ol0oooo000Io`04000IoaP0oooo
000P0?ooo`03000Io`3oool0oooo0080oooo00<000000?ooo`3oool0U@3oool3000000`0oooo5@00
6Ol:0?ooo`@00000UP3oool00`000000oooo0?ooo`080?ooo`04000Io`3oool0oooo0?ooo`<001Wo
6@3oool00200oooo00D001Wo0?ooo`3oool0oooo0000002K0?ooo`@00000203ooolG000Io`D0oooo
0`00002K0?ooo`030000003oool0oooo00L0oooo00<001Wo0?ooo`3oool00`3oool00`006Ol0oooo
0?ooo`0G0?ooo`008@3oool010006Ol0oooo0?ooo`00002O0?ooo`<000001@3ooolA000Io`P0oooo
0`00002N0?ooo`030000003oool0oooo00H0oooo00<001Wo0?ooo`3oool07P3oool00240oooo00@0
01Wo0?ooo`3oool00000XP3oool300000080oooo1P006Ol30?ooo`030000003oool0oooo00T0oooo
1000002Q0?ooo`030000003oool0oooo00D0oooo00<001Wo0?ooo`3oool07`3oool00240oooo00<0
01Wo0?ooo`000000YP3oool4000000L0oooo00<000000?ooo`3oool01P3oool300000:D0oooo00<0
00000?ooo`3oool01@3oool00`006Ol0oooo0?ooo`0O0?ooo`008P3oool00`006Ol000000?ooo`2Y
0?ooo`<00000103oool00`000000oooo0?ooo`040?ooo`800000Z@3oool00`000000oooo0?ooo`03
0?ooo`03000Io`3oool0oooo0200oooo000R0?ooo`03000Io`000000oooo0:`0oooo0`0000000`3o
ool000000?ooo`020?ooo`<00000Z`3oool00`000000oooo0?ooo`030?ooo`03000Io`3oool0oooo
0200oooo000R0?ooo`03000Io`000000oooo0:l0oooo1@00002^0?ooo`030000003oool0oooo0080
oooo00<001Wo0?ooo`3oool08@3oool00280oooo00<001Wo0000003oool0[`3oool2000000030?oo
o`00000000000:h0oooo00D000000?ooo`3oool0oooo000Io`0T0?ooo`008`3oool00`006Ol0oooo
0?ooo`2[0?ooo`<0000000<0oooo0000003oool00P3oool300000:/0oooo00D000000?ooo`3oool0
oooo000Io`0T0?ooo`008`3oool00`006Ol0oooo0?ooo`2Y0?ooo`800000103oool00`000000oooo
0?ooo`040?ooo`<00000Y`3oool01@000000oooo0?ooo`3oool001Wo02D0oooo000S0?ooo`03000I
o`3o0000o`000:H0oooo0`0000060?ooo`030000003oool0oooo00L0oooo0`00002T0?ooo`040000
003oool0oooo000IobH0oooo000S0?ooo`@0o`00X`3oool2000000T0oooo00<000000?ooo`3oool0
2P3oool200000:80oooo00@000000?ooo`3oool001Wo9P3oool00280oooo1P3o002O0?ooo`<00000
2`3oool00`000000oooo0?ooo`0<0?ooo`<00000W`3oool00`000000oooo000Io`0W0?ooo`008P3o
ool60?l009`0oooo0`00000>0?ooo`030000003oool0oooo00l0oooo0`00002K0?ooo`040000003o
ool0oooo000IobL0oooo000S0?ooo`@0o`00V`3oool200000140oooo00<000000?ooo`3oool04P3o
ool3000009P0oooo00<000000?ooo`006Ol0:03oool002@0oooo0P3o002I0?ooo`<000004`3oool0
0`000000oooo0?ooo`0E0?ooo`800000UP3oool00`00000001Wo0?ooo`0X0?ooo`009P3oool00`00
0000oooo0?ooo`2D0?ooo`8000005P3oool00`000000oooo0?ooo`0G0?ooo`<00000TP3oool00`00
0000oooo000Io`0Y0?ooo`009P3oool00`000000oooo0?ooo`2A0?ooo`<00000603oool00`000000
oooo0?ooo`0J0?ooo`<00000S`3oool00`00000001Wo0?ooo`0Y0?ooo`009P3oool00`000000oooo
0?ooo`2?0?ooo`8000006`3oool3000001d0oooo0P00002<0?ooo`03000000006Ol0oooo02X0oooo
000W0?ooo`030000003oool0oooo08/0oooo0`00000M0?ooo`030000003oool0oooo01l0oooo0P00
002:0?ooo`03000000006Ol0oooo02X0oooo000W0?ooo`030000003oool0oooo08P0oooo0`00000P
0?ooo`030000003oool0oooo0240oooo0P0000270?ooo`03000000006Ol0oooo02/0oooo000X0?oo
o`030000003oool0oooo08D0oooo0P00000S0?ooo`030000003oool0oooo02<0oooo0P0000250?oo
o`03000000006Ol0oooo02/0oooo000X0?ooo`030000003oool0oooo0880oooo0`00000U0?ooo`03
0000003oool0oooo02D0oooo0`0000210?ooo`03000000006Ol0oooo02`0oooo000Y0?ooo`030000
003oool0oooo07l0oooo0P00000X0?ooo`030000003oool0oooo02P0oooo0P00001m0?ooo`80o`00
00<001Wo0?ooo`3oool0;03oool002T0oooo00<000000?ooo`3oool0O03oool3000002X0oooo00<0
00000?ooo`3oool0:P3oool2000007X0oooo103o000^0?ooo`00:P3oool00`000000oooo0?ooo`1i
0?ooo`800000;@3oool00`000000oooo0?ooo`0/0?ooo`800000M`3oool60?l002d0oooo000Z0?oo
o`030000003oool0oooo07H0oooo0`00000_0?ooo`030000003oool0oooo02h0oooo0P00001e0?oo
o`H0o`00;@3oool002/0oooo00<000000?ooo`3oool0LP3oool300000380oooo00<000000?ooo`3o
ool0<03oool2000007@0oooo103o000^0?ooo`00;03oool00`000000oooo0?ooo`1_0?ooo`800000
=@3oool00`000000oooo0?ooo`0b0?ooo`<00000L@3oool00`000000o`000?l0000_0?ooo`00;03o
ool00`000000oooo0?ooo`1]0?ooo`800000=`3oool00`000000oooo0?ooo`0e0?ooo`800000KP3o
ool00`000000oooo0?ooo`0`0?ooo`00;@3oool00`000000oooo0?ooo`1Z0?ooo`800000>@3oool0
0`000000oooo0?ooo`0g0?ooo`800000J`3oool00`000000oooo0?ooo`0a0?ooo`00;P3oool00`00
0000oooo0?ooo`1W0?ooo`800000>`3oool00`000000oooo0?ooo`0i0?ooo`800000J@3oool00`00
0000oooo0?ooo`0a0?ooo`00;`3oool00`000000oooo0?ooo`1T0?ooo`800000?@3oool00`000000
oooo0?ooo`0k0?ooo`800000IP3oool00`000000oooo0?ooo`0b0?ooo`00;`3oool00`000000oooo
0?ooo`1R0?ooo`800000?`3oool00`000000oooo0?ooo`0m0?ooo`800000H`3oool00`000000oooo
0?ooo`0c0?ooo`00<03oool00`000000oooo0?ooo`1O0?ooo`800000@@3oool00`000000oooo0?oo
o`0o0?ooo`800000H03oool00`000000oooo0?ooo`0d0?ooo`00<@3oool00`000000oooo0?ooo`1L
0?ooo`800000@`3oool300000440oooo0P00001N0?ooo`030000003oool0oooo03@0oooo000b0?oo
o`030000003oool0oooo05T0oooo0P0000150?ooo`030000003oool0oooo04<0oooo0P00001K0?oo
o`030000003oool0oooo03D0oooo000c0?ooo`030000003oool0oooo05H0oooo0P0000170?ooo`03
0000003oool0oooo04D0oooo0P00001H0?ooo`030000003oool0oooo03H0oooo000d0?ooo`030000
003oool0oooo05<0oooo0P0000190?ooo`030000003oool0oooo04L0oooo0P00001E0?ooo`030000
003oool0oooo03L0oooo000e0?ooo`030000003oool0oooo0500oooo0P00001;0?ooo`030000003o
ool0oooo04T0oooo0P00001B0?ooo`030000003oool0oooo03P0oooo000f0?ooo`030000003oool0
oooo04d0oooo0P00001=0?ooo`030000003oool0oooo04/0oooo0P00001?0?ooo`030000003oool0
oooo03T0oooo000g0?ooo`030000003oool0oooo04X0oooo0P00001?0?ooo`030000003oool0oooo
04d0oooo00<000000?ooo`3oool0B`3oool00`000000oooo0?ooo`0j0?ooo`00>03oool00`000000
oooo0?ooo`170?ooo`800000D@3oool00`000000oooo0?ooo`1>0?ooo`800000BP3oool00`000000
oooo0?ooo`0k0?ooo`00>@3oool00`000000oooo0?ooo`140?ooo`800000D`3oool00`000000oooo
0?ooo`1@0?ooo`800000A`3oool00`000000oooo0?ooo`0l0?ooo`00>P3oool00`000000oooo0?oo
o`110?ooo`800000E@3oool00`000000oooo0?ooo`1B0?ooo`800000A03oool00`000000oooo0?oo
o`0m0?ooo`00>P3oool00`000000oooo0?ooo`0k0?ooo`80o`000P3oool2000005L0oooo00<00000
0?ooo`3oool0E03oool200000440oooo00<000000?ooo`3oool0?P3oool003/0oooo00<000000?oo
o`3oool0>@3oool40?l000030000003oool0oooo05L0oooo00<000000?ooo`3oool0EP3oool20000
03h0oooo00<000000?ooo`3oool0?`3oool003`0oooo00<000000?ooo`3oool0=`3oool60?l005T0
oooo00<000000?ooo`3oool0F03oool2000003/0oooo00<000000?ooo`3oool0@03oool003d0oooo
00<000000?ooo`3oool0=P3oool60?l005T0oooo00<000000?ooo`3oool0FP3oool2000003P0oooo
00<000000?ooo`3oool0@@3oool003h0oooo00<000000?ooo`3oool0=@3oool00`000000o`000?l0
00020?l005X0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`0d0?ooo`030000003o
ool0oooo0480oooo000o0?ooo`030000003oool0oooo0380oooo00@00000000Io`006Ol0oooo0P3o
001K0?ooo`030000003oool0oooo05d0oooo0P00000c0?ooo`030000003oool0oooo04<0oooo0010
0?ooo`030000003oool0oooo0300oooo00<00000000Io`3oool0G`3oool00`000000oooo0?ooo`1O
0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0A03oool00440oooo00<000000?oo
o`3oool0;@3oool00`00000001Wo000Io`1Q0?ooo`030000003oool0oooo0600oooo00<000000?oo
o`3oool0;@3oool00`000000oooo0?ooo`150?ooo`00@P3oool00`000000oooo0?ooo`0[0?ooo`80
01WoH`3oool300000640oooo0P00000/0?ooo`030000003oool0oooo04H0oooo00130?ooo`030000
003oool0oooo02P0oooo00<00000000Io`3oool0I03oool00`000000oooo0?ooo`1S0?ooo`030000
003oool0oooo02P0oooo00<000000?ooo`3oool0A`3oool004@0oooo00<000000?ooo`3oool09P3o
ool2000IofH0oooo00<000000?ooo`3oool0I03oool2000002L0oooo00<000000?ooo`3oool0B03o
ool004D0oooo0P00000T0?ooo`8001WoJ03oool00`000000oooo0?ooo`1V0?ooo`030000003oool0
oooo02<0oooo00<000000?ooo`3oool0B@3oool004L0oooo00<000000?ooo`3oool0803oool00`00
6Ol000000?ooo`1X0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool0803oool20000
04`0oooo00180?ooo`030000003oool0oooo01d0oooo0P006Om[0?ooo`030000003oool0oooo06P0
oooo0P00000O0?ooo`030000003oool0oooo04`0oooo00100?ooo`8001Wo1`3oool00`000000oooo
0?ooo`0J0?ooo`8001Wo00<000000?ooo`3oool0JP3oool00`000000oooo0?ooo`1Z0?ooo`030000
003oool0oooo01/0oooo00<000000?ooo`3oool0C@3oool00440oooo0`006Ol60?ooo`030000003o
ool0oooo01P0oooo00<001Wo0000003oool0K@3oool00`000000oooo0?ooo`1[0?ooo`8000006P3o
ool00`000000oooo0?ooo`1>0?ooo`00@P3oool5000Io`@0oooo0P00000F0?ooo`8001Wo00<00000
0?ooo`3oool0K@3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool0C`3oool004<0oooo1`006Ol30?ooo`030000003oool0oooo0140oooo0P006Ol00`00
0000oooo0?ooo`1_0?ooo`030000003oool0oooo06h0oooo0P0000020?ooo`80o`004@3oool00`00
0000oooo0?ooo`1@0?ooo`00A03oool8000Io`80oooo00<000000?ooo`3oool03`3oool00`006Ol0
00000000001b0?ooo`030000003oool0oooo0700oooo00<000000?l0003o00000P3o000?0?ooo`03
0000003oool0oooo0540oooo00150?ooo`X001Wo00<000000?ooo`3oool0303oool2000Io`030000
003oool0oooo0780oooo00<000000?ooo`3oool0L03oool60?l000`0oooo0P00001D0?ooo`00AP3o
ool<000Io`X0oooo0P006Ol2000007D0oooo00<000000?ooo`3oool0L03oool60?l000/0oooo00<0
00000?ooo`3oool0E03oool004L0oooo3@006Ol70?ooo`03000Io`3oool0000007L0oooo00<00000
0?ooo`3oool0L@3oool40?l000/0oooo00<000000?ooo`3oool0E@3oool004L0oooo3`006Ol30?oo
o`8001Wo00<0oooo0000003oool0M`3oool00`000000oooo0?ooo`1b0?ooo`80o`000P006Ol90?oo
o`030000003oool0oooo05H0oooo00180?ooo`d001Wo0P3oool2000Io`80oooo00<000000?ooo`3o
ool0F@3oool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/000000000Vm@01@3oool01@3D
V`000000000000000000VmCo00L0oooo00<000000?ooo`3oool0MP3oool00`006Ol0oooo0?ooo`05
0?ooo`030000003oool0oooo05L0oooo00190?ooo`/001Wo00<0oooo000000006Ol00P3oool20000
05`0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?ooo`030=BK0000000009_D00@0oooo00L0
e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo00H0oooo00<000000?ooo`3oool0M`3oool00`006Ol0
oooo0?ooo`030?ooo`030000003oool0oooo05P0oooo001:0?ooo``001Wo00<000000?ooo`000000
G@3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03oool0
1@3oool00`000000oooo0?ooo`1h0?ooo`8001Wo0P3oool00`000000oooo0?ooo`1I0?ooo`00B`3o
ool9000Io`<0oooo0P00001M0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool03`3o
ool00`3oe9/009_D0?ooo`050?ooo`@00000N@3oool00`006Ol000000?ooo`1K0?ooo`00C03oool6
000Io`050?ooo`006Ol0oooo0?ooo`0000000P3oool00`000000oooo0?ooo`1A0?ooo`030;Yb0000
0000000000<0000000D007:j0?ooo`3oool0j[Yb07:jjP030?ooo`030?oDV`00Vm@0oooo00l0oooo
00<0^W8009_Do`3oool01@3oool00`000000oooo0?ooo`1i0?ooo`030000003oool001Wo05`0oooo
001=0?ooo`@001Wo0`3oool2000Io`@0oooo00<000000?ooo`3oool0F@3oool00`3Z^W80L[[Z0?oo
o`020?ooo`030?oDV`00Vm@0oooo00X0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo0?oo
o`050?ooo`030000003oool0oooo07P0oooo00@000000?ooo`3oool0oooo0P006OmJ0?ooo`00C@3o
ool4000Io`<0oooo00<000000?ooo`006Ol0103oool2000005T0oooo00<0omBK07:jjP3oool00P3o
ool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K09/0e?oo00X0oooo00<000000?ooo`3oool0M`3o
ool00`000000oooo0?ooo`030?ooo`03000000006Ol0oooo05P0oooo001<0?ooo`04000Io`3oool0
oooo000Io`<0oooo00@000000?ooo`3oool0oooo0P006Ol40?ooo`030000003oool0oooo05L0oooo
00H0^W8009_Do`3oool0onZj0780V`3Dool;0?ooo`030?ooe02K09/0e?oo00X0oooo00<000000?oo
o`3oool0M@3oool2000000L0oooo00<00000000Io`3oool0E`3oool004X0oooo0P006Ol50?ooo`80
00001P3oool00`006Ol0oooo0?ooo`020?ooo`030000003oool0oooo05H0oooo00D0oooD09/00000
0000001b0;[Zo`0<0?ooo`030?ooe02K000000000080000000<0002K0=Coo`3oool01@3oool00`00
0000oooo0?ooo`1d0?ooo`030000003oool0oooo00P0oooo00<00000000Io`006Ol0EP3oool004P0
oooo0P006Ol60?ooo`030000003oool0oooo00L0oooo0P006Ol30?ooo`800000M03oool00`000000
oooo0?ooo`1b0?ooo`800000303oool200000003000Io`3oool0oooo05<0oooo00160?ooo`8001Wo
1`3oool00`000000oooo0?ooo`0:0?ooo`03000Io`3oool0oooo0080oooo00<000000?ooo`3oool0
L@3oool00`000000oooo0?ooo`1a0?ooo`030000003oool0oooo00h0oooo00<00000000Io`3oool0
D`3oool004D0oooo00<001Wo0?ooo`3oool01P3oool00`000000oooo0?ooo`0<0?ooo`8001Wo0`3o
ool00`000000oooo0?ooo`1`0?ooo`030000003oool0oooo0700oooo00<000000?ooo`3oool00`3o
ool2000Io`/0oooo00<00000000Io`006Ol0DP3oool004<0oooo0P006Ol80?ooo`030000003oool0
oooo00l0oooo00@001Wo0?ooo`3oool0oooo0P00001`0?ooo`030000003oool0oooo06h0oooo0P00
00030?ooo`@001Wo3@3oool00`000000oooo000Io`1A0?ooo`00@@3oool2000Io`T0oooo00<00000
0?ooo`3oool04@3oool2000Io`<0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`1]
0?ooo`030000003oool0oooo00H001Wo3`3oool00`000000oooo000Io`1@0?ooo`00@03oool00`00
6Ol0oooo0?ooo`080?ooo`030000003oool0oooo01@0oooo00D001Wo0?ooo`3oool0oooo0000001^
0?ooo`030000003oool0oooo06/0oooo0P000008000Ioa40oooo00@000000?ooo`006Ol001WoCP3o
ool003h0oooo0P006Ol90?ooo`800000603oool2000Io`80oooo0P00001/0?ooo`030000003oool0
oooo06X0oooo2P006OlC0?ooo`040000003oool0oooo000Iodd0oooo000l0?ooo`8001Wo2P3oool0
0`000000oooo0?ooo`0J0?ooo`05000Io`3oool0oooo0?ooo`000000J`3oool00`000000oooo0?oo
o`1W0?ooo``001Wo5@3oool2000000030?ooo`006Ol0oooo04/0oooo000k0?ooo`03000Io`3oool0
oooo00T0oooo00<000000?ooo`3oool0703oool010006Ol0oooo0?ooo`3oool2000006T0oooo00<0
00000?ooo`3oool0I03oool>000IoaP0oooo00@000000?ooo`006Ol001WoBP3oool003T0oooo0P00
6Ol;0?ooo`030000003oool0oooo01h0oooo0P006Ol30?ooo`030000003oool0oooo06H0oooo00<0
00000?ooo`3oool0HP3oool?000IoaX0oooo00@000000?ooo`3oool001WoB@3oool002d0oooo00<0
01Wo0?ooo`3oool01`3oool2000Io``0oooo00<000000?ooo`3oool08@3oool01@006Ol0oooo0?oo
o`3oool0000006L0oooo00<000000?ooo`3oool0H`3oool=000Ioa`0oooo00@000000?ooo`3oool0
01WoB03oool002`0oooo0`006Ol70?ooo`03000Io`3oool0oooo00/0oooo00<000000?ooo`3oool0
8`3oool2000Io`80oooo0P00001U0?ooo`030000003oool0oooo06<0oooo3@006OlM0?ooo`030000
003oool0oooo008001WoAP3oool002/0oooo10006Ol50?ooo`8001Wo3P3oool00`000000oooo0?oo
o`0U0?ooo`05000Io`3oool0oooo0?ooo`000000I03oool300000640oooo0P0000000`3oool001Wo
000Io`09000Ioal0oooo00D000000?ooo`3oool0oooo000Io`150?ooo`00:P3oool6000Io`80oooo
0P006Ol?0?ooo`030000003oool0oooo02L0oooo0P006Ol20?ooo`030000003oool0oooo0640oooo
00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`020?ooo`T001Wo8@3oool01@000000oooo
0?ooo`3oool001Wo04@0oooo000Y0?ooo`T001Wo403oool00`000000oooo0?ooo`0Z0?ooo`03000I
o`3oool0oooo00800000H@3oool00`000000oooo0?ooo`1N0?ooo`8000001@3oool8000Iob<0oooo
00@000000?ooo`3oool0oooo0P006Om20?ooo`00:03oool9000Ioa00oooo00<000000?ooo`3oool0
;03oool2000Io`80oooo00<000000?ooo`3oool0GP3oool00`000000oooo0?ooo`1M0?ooo`030000
003oool0oooo00<0oooo0P006Ol00`3oool001Wo000Io`04000IobD0oooo00<000000?ooo`3oool0
0P3oool00`006Ol0oooo0?ooo`0o0?ooo`009`3oool;000Io`h0oooo00<000000?ooo`3oool0;`3o
ool010006Ol0oooo0?ooo`00001O0?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool0
0`3oool00`006Ol0oooo0?ooo`020?ooo`@001Wo9P3oool00`000000oooo0?ooo`030?ooo`03000I
o`3oool0oooo03h0oooo000V0?ooo`d001Wo3@3oool00`000000oooo0?ooo`0`0?ooo`8001Wo00<0
oooo000000000000G@3oool00`000000oooo0?ooo`1J0?ooo`800000103oool2000Io`D0oooo0`00
6OlX0?ooo`030000003oool0oooo00<0oooo0P006Oln0?ooo`009@3oool>000Io``0oooo00<00000
0?ooo`3oool0<`3oool010006Ol0oooo0?ooo`00001L0?ooo`030000003oool0oooo05T0oooo00<0
00000?ooo`3oool00`3oool00`006Ol0oooo0?ooo`060?ooo`03000Io`3oool0oooo02P0oooo00<0
00000?ooo`3oool0103oool00`006Ol0oooo0?ooo`0k0?ooo`00903oool@000Io`X0oooo00<00000
0?ooo`3oool0=@3oool2000Io`030?ooo`000000oooo05X0oooo00<000000?ooo`3oool0E`3oool2
000000@0oooo0P006Ole0?ooo`030000003oool0oooo00@0oooo00<001Wo0?ooo`3oool0>P3oool0
02<0oooo3`006Ol;0?ooo`030000003oool0oooo03P0oooo00@001Wo0?ooo`0000000000F@3oool0
0`000000oooo0?ooo`1F0?ooo`030000003oool0oooo00<0oooo00<001Wo0?ooo`3oool0=P3oool0
0`000000oooo0?ooo`040?ooo`8001Wo>P3oool00280oooo3@006Ol=0?ooo`030000003oool0oooo
03X0oooo0P006Ol00`3oool000000?ooo`1G0?ooo`030000003oool0oooo05@0oooo0P0000040?oo
o`8001Wo>P3oool00`000000oooo0?ooo`050?ooo`03000Io`3oool0oooo03L0oooo000Q0?ooo`/0
01Wo403oool00`000000oooo0?ooo`0l0?ooo`04000Io`3oool00000000005H0oooo00<000000?oo
o`3oool0D`3oool00`000000oooo0?ooo`030?ooo`03000Io`3oool0oooo03/0oooo00<000000?oo
o`3oool01@3oool00`006Ol0oooo0?ooo`0f0?ooo`00803oool9000Ioa80oooo00<000000?ooo`3o
ool0?P3oool2000Io`030?ooo`000000oooo05@0oooo00<000000?ooo`3oool0DP3oool00`000000
oooo0?ooo`020?ooo`8001Wo?`3oool00`000000oooo0?ooo`050?ooo`8001Wo=P3oool001l0oooo
1P006OlE0?ooo`030000003oool0oooo0440oooo00<001Wo0?ooo`000000E03oool00`000000oooo
0?ooo`1@0?ooo`800000103oool00`006Ol0oooo0?ooo`0o0?ooo`030000003oool0oooo00L0oooo
00<001Wo0?ooo`3oool0<`3oool001h0oooo10006OlG0?ooo`030000003oool0oooo04<0oooo0P00
6Ol200000580oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`020?ooo`8001Wo@`3o
ool00`000000oooo0?ooo`070?ooo`03000Io`3oool0oooo0380oooo000M0?ooo`8001Wo6@3oool0
0`000000oooo0?ooo`160?ooo`03000Io`3oool000000540oooo00<000000?ooo`3oool0C@3oool2
000000@0oooo00<001Wo0?ooo`3oool0A03oool00`000000oooo0?ooo`070?ooo`8001Wo<P3oool0
03P0oooo00<000000?ooo`3oool0A`3oool00`006Ol0oooo0000001@0?ooo`030000003oool0oooo
04`0oooo00<000000?ooo`3oool00P3oool2000IodL0oooo00<000000?ooo`3oool02@3oool00`00
6Ol0oooo0?ooo`0_0?ooo`00=`3oool00`000000oooo0?ooo`190?ooo`8001Wo0P00001>0?ooo`03
0000003oool0oooo04X0oooo0P0000040?ooo`03000Io`3oool0oooo04P0oooo00<000000?ooo`3o
ool02@3oool00`006Ol0oooo0?ooo`0^0?ooo`00=P3oool00`000000oooo0?ooo`1<0?ooo`03000I
o`3oool0000004d0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`020?ooo`8001Wo
C03oool00`000000oooo0?ooo`090?ooo`8001Wo;P3oool003D0oooo00<000000?ooo`3oool0CP3o
ool2000Io`030000003oool0oooo04X0oooo0`0000180?ooo`030000003oool0oooo0080oooo00<0
01Wo0?ooo`3oool0C@3oool00`000000oooo0?ooo`0:0?ooo`03000Io`3oool0oooo00L0oooo00<0
01Wo0?ooo`3oool08@3oool003D0oooo00<000000?ooo`3oool0D03oool00`006Ol000000000001:
0?ooo`030000003oool0oooo04H0oooo0P0000030?ooo`8001WoD03oool00`000000oooo0?ooo`0;
0?ooo`03000Io`3oool0oooo00D0oooo0`006OlR0?ooo`00=03oool00`000000oooo0?ooo`1B0?oo
o`8001Wo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo
0080oooo00<001Wo0?ooo`3oool0D@3oool00`000000oooo0?ooo`0;0?ooo`8001Wo1@3oool4000I
ob40oooo000c0?ooo`030000003oool0oooo05D0oooo00<001Wo000000000000A`3oool00`000000
oooo0?ooo`130?ooo`8000000`3oool2000IoeD0oooo00<000000?ooo`3oool0303oool010006Ol0
oooo0?ooo`3oool5000Iob40oooo000c0?ooo`030000003oool0oooo05H0oooo0P006Ol00`000000
oooo0?ooo`140?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool00P3oool00`006Ol0
oooo0?ooo`1E0?ooo`030000003oool0oooo00d0oooo00<001Wo0?ooo`006Ol01P006OlP0?ooo`00
<P3oool00`000000oooo0?ooo`1I0?ooo`03000Io`000000oooo04@0oooo00<000000?ooo`3oool0
@03oool2000000<0oooo0P006OmI0?ooo`030000003oool0oooo00d0oooo2@006OlO0?ooo`00<@3o
ool00`000000oooo0?ooo`1K0?ooo`8001Wo00<000000?ooo`3oool0@@3oool00`000000oooo0?oo
o`0o0?ooo`030000003oool0oooo0080oooo00<001Wo0?ooo`3oool0FP3oool00`000000oooo0?oo
o`0<0?ooo`X001Wo7P3oool00340oooo00<000000?ooo`3oool0G@3oool00`006Ol000000?ooo`11
0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool00P3oool00`006Ol0oooo0?ooo`1K
0?ooo`030000003oool0oooo00/0oooo2`006OlN0?ooo`00<03oool00`000000oooo0?ooo`1O0?oo
o`8001Wo@@3oool00`000000oooo0?ooo`0l0?ooo`8000000`3oool2000Ioel0oooo00<000000?oo
o`3oool02P3oool<000Ioad0oooo000_0?ooo`030000003oool0oooo0680oooo00<001Wo0000003o
ool0?P3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo0080oooo00<001Wo0?ooo`3o
ool0G`3oool00`000000oooo0?ooo`090?ooo`h001Wo703oool002l0oooo00<000000?ooo`3oool0
H`3oool2000Ioch0oooo00<000000?ooo`3oool0>@3oool2000000<0oooo0P006OmS0?ooo`030000
003oool0oooo00X0oooo3@006OlK0?ooo`00;P3oool00`000000oooo0?ooo`1V0?ooo`03000Io`3o
ool0oooo03/0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`020?ooo`03000Io`3o
ool0oooo06<0oooo00<000000?ooo`3oool0303oool<000IoaX0oooo000^0?ooo`030000003oool0
oooo06L0oooo0P006Olk0?ooo`030000003oool0oooo03H0oooo0P0000030?ooo`8001WoI`3oool0
0`000000oooo0?ooo`0=0?ooo`X001Wo6P3oool002d0oooo00<000000?ooo`3oool0JP3oool00`00
6Ol0oooo0?ooo`0h0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool00P3oool00`00
6Ol0oooo0?ooo`1W0?ooo`030000003oool0oooo00l0oooo2@006OlI0?ooo`00;@3oool00`000000
oooo0?ooo`1[0?ooo`03000Io`000000oooo03L0oooo00<000000?ooo`3oool0=03oool010000000
oooo0?ooo`3oool2000Iof/0oooo00<000000?ooo`3oool0403oool8000IoaP0oooo000/0?ooo`03
0000003oool0oooo06d0oooo0P006Olg0?ooo`030000003oool0oooo0380oooo0P0000030?ooo`03
000Io`3oool0oooo06/0oooo00<000000?ooo`3oool04`3oool6000IoaL0oooo000/0?ooo`030000
003oool0oooo06l0oooo00<001Wo0000003oool0=03oool00`000000oooo0?ooo`0a0?ooo`040000
003oool0oooo0?ooo`8001WoK`3oool00`000000oooo0?ooo`0D0?ooo`@001Wo5`3oool002/0oooo
00<000000?ooo`3oool0L@3oool2000Ioc@0oooo0`00000_0?ooo`8000000`3oool00`006Ol0oooo
0?ooo`1_0?ooo`030000003oool0oooo01H0oooo0`006OlF0?ooo`00:`3oool00`000000oooo0?oo
o`1c0?ooo`03000Io`000000oooo0340oooo00<000000?ooo`3oool0;P3oool010000000oooo0?oo
o`3oool2000Iog<0oooo00<000000?ooo`3oool05`3oool2000IoaD0oooo000Z0?ooo`030000003o
ool0oooo07D0oooo0P006Ola0?ooo`030000003oool0oooo02`0oooo0P0000030?ooo`03000Io`3o
ool0oooo07<0oooo00<000000?ooo`3oool0;P3oool002X0oooo00<000000?ooo`3oool0M`3oool0
10006Ol000000?l0003o000]0?ooo`030000003oool0oooo02/0oooo00@000000?ooo`3oool0oooo
0P006Omf0?ooo`030000003oool0oooo02h0oooo000Y0?ooo`030000003oool0oooo07T0oooo103o
000/0?ooo`030000003oool0oooo02X0oooo00D000000?ooo`3oool0oooo000Io`1i0?ooo`030000
003oool0oooo02d0oooo000Y0?ooo`030000003oool0oooo07P0oooo1P3o000[0?ooo`030000003o
ool0oooo02P0oooo0P0000020?ooo`8001WoNP3oool00`000000oooo0?ooo`0]0?ooo`00:@3oool0
0`000000oooo0?ooo`1h0?ooo`H0o`00:`3oool00`000000oooo0?ooo`0W0?ooo`050000003oool0
oooo0?ooo`006Ol0O@3oool00`000000oooo0?ooo`0/0?ooo`00:03oool00`000000oooo0?ooo`1j
0?ooo`@0o`0000<0oooo000000000000:@3oool00`000000oooo0?ooo`0U0?ooo`8000000P3oool2
000Iogh0oooo00<000000?ooo`3oool0;03oool002P0oooo00<000000?ooo`3oool0N`3oool20?l0
00@0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0T0?ooo`050000003oool0oooo
0?ooo`006Ol0P03oool00`000000oooo0?ooo`0/0?ooo`00:03oool00`000000oooo0?ooo`220?oo
o`8000009P3oool00`000000oooo0?ooo`0R0?ooo`8000000P3oool2000Ioh80oooo00<000000?oo
o`3oool0:`3oool002L0oooo00<000000?ooo`3oool0Q@3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo0240oooo00D000000?ooo`3oool0oooo000Io`240?ooo`030000003oool0oooo
02/0oooo000W0?ooo`030000003oool0oooo08H0oooo0P00000S0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool00P006On50?ooo`030000003oool0oooo02/0oooo000W0?ooo`030000
003oool0oooo08P0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0N0?ooo`800000
0P3oool00`006Ol0oooo0?ooo`260?ooo`030000003oool0oooo02X0oooo000V0?ooo`030000003o
ool0oooo08X0oooo0P00000P0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool00P00
6On90?ooo`030000003oool0oooo02X0oooo000V0?ooo`030000003oool0oooo08`0oooo00<00000
0?ooo`3oool07@3oool00`000000oooo0?ooo`0K0?ooo`8000000P3oool00`006Ol0oooo0?ooo`29
0?ooo`030000003oool0oooo02X0oooo000V0?ooo`030000003oool0oooo08d0oooo0P00000M0?oo
o`030000003oool0oooo01X0oooo00<000000?ooo`3oool00P006On=0?ooo`030000003oool0oooo
02T0oooo000U0?ooo`030000003oool0oooo0900oooo00<000000?ooo`3oool06P3oool00`000000
oooo0?ooo`0H0?ooo`8000000P3oool00`006Ol0oooo0?ooo`2=0?ooo`030000003oool0oooo02T0
oooo000U0?ooo`030000003oool0oooo0940oooo0P00000J0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool00P006On@0?ooo`030000003oool0oooo02T0oooo000T0?ooo`030?oDV`00
0000000000<0000000<009_D0?ooo`3oool0B03oool01@3oe9/00000000000000000VmCo00D0oooo
00<0e9/000000000Vm@01@3oool01@3DV`000000000000000000VmCo02l0oooo00<000000?ooo`3o
ool05`3oool3000001H0oooo00@000000?ooo`3oool001Wo<03oool01@3oe9/00000000000000000
VmCo00D0oooo00<0e9/000000000Vm@01@3oool01@3DV`000000000000000000VmCo04X0oooo00<0
omBK0000000000000`0000000`00Vm@0oooo0?ooo`0T0?ooo`009@3oool010000000oooo0;YbLP2j
j_m<0?ooo`060;YbV`3Dool0oooo0?ooe02K09/0e?oo103oool00`3DV`000000002Ke0040?ooo`07
0=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`0_0?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool0503oool2000000030?ooo`006Ol001Wo0340oooo00H0^W:K0=Coo`3oool0oooD09/0
V`3Dool40?ooo`030=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo
04X0oooo00@000000?ooo`2jLW80^^[o:03oool002D0oooo00@000000?ooo`2jLW80^^[oB`3oool0
0`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03oool0;`3oool2
000001H0oooo00<000000?ooo`3oool04`3oool010000000oooo0?ooo`006Olb0?ooo`030?oDV`00
Vm@0oooo0080oooo00<0j[Yb07:jjP3oool03`3oool00`3oe9/009_D0?ooo`1:0?ooo`030000002j
LW80^^[o02P0oooo000U0?ooo`040000003oool0^W9b0;[Zod/0oooo00<0j[Yb07:jjP3oool00P3o
ool00`3oe9/009_D0?ooo`0?0?ooo`030?oDV`00Vm@0oooo0340oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0A0?ooo`80000000<0oooo000Io`006Ol0<`3oool00`3Z^W80L[[Z0?oo
o`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0omBK002Ke03oool0BP3oool00`000000^W9b0;[Z
o`0X0?ooo`006`3oool00`2jLP0000000000000300000008001b^P3oool0oooo0?ooo`000000oooo
0;YbLP2jj_m20?ooo`030;Yb00000000000000<0000000D007:j0?ooo`3oool0j[Yb07:jjP030?oo
o`030?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool0<P3oool2000001<0oooo00<000000?oo
o`3oool0403oool010000000oooo0?ooo`006Ole0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK
002Ke03oool03`3oool00`2jLP00VmCo0?ooo`1:0?ooo`030000002jLW80^^[o02P0oooo000T0?oo
o`050000003oool0oooo0;YbLP2jj_l0B`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0
oooo00X0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`0d0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0303oool20?l00080000000<0oooo000Io`006Ol0=P3oool0
0`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00X0oooo00<0oooD09/0000000000P000000
0`1b^^X0oooo0?ooo`1:0?ooo`030000002jLW80^^[o02P0oooo000T0?ooo`050000003oool0oooo
0;YbLP2jj_l0B`3oool00`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo00X0oooo00<0oooD
09/0V`3Dool0>P3oool200000100oooo00<000000?ooo`3oool02`3oool40?l000030?ooo`006Ol0
oooo03L0oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?ooo`0:0?ooo`030?ooe02K09/0
e?oo0500oooo00<000000;[Zo`3oool09`3oool002@0oooo0P0000000`00L[X0^W9b0;[Zo`1<0?oo
o`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Coo`0l0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool02P3oool60?l003X0oooo00H0^W8009_Do`3oool0onZj
0780V`3Dool;0?ooo`030?ooe02K09/0e?oo04d0oooo00D0j[Yb00000000L[X000000;[Zo`0X0?oo
o`00903oool01@000000oooo0>ZjLP000780^^[o04`0oooo00D0oooD09/000000000001b0;[Zo`0<
0?ooo`030?ooe02K000000000080000000<0002K0=Coo`3oool0>03oool2000000d0oooo00<00000
0?ooo`3oool02P3oool60?l003X0oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K
000000000080000000<0002K0=Coo`3oool0BP3oool00`3Z^W8000000;[Zo`0X0?ooo`00903oool0
0`000000oooo0?ooo`2Q0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?l000030?l009l0oooo00<000000?ooo`3oool09`3oool002@0oooo00<000000?oo
o`3oool0XP3oool2000000X0oooo00<000000?ooo`3oool01`3oool2000000<0oooo0P3o002P0?oo
o`030000003oool0oooo02L0oooo000S0?ooo`030000003oool0oooo0:D0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0:D0oooo00<000000?ooo`3o
ool09`3oool002<0oooo00<000000?ooo`3oool0YP3oool2000000L0oooo00<000000?ooo`3oool0
103oool200000:P0oooo00<000000?ooo`3oool09`3oool002<0oooo00<000000?ooo`3oool0Z03o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0Z@3o
ool00`000000oooo0?ooo`0V0?ooo`008`3oool00`000000oooo0?ooo`2Y0?ooo`800000103oool0
0`000000oooo0?ooo`020?ooo`030000003oool0oooo0:X0oooo00<000000?ooo`3oool09P3oool0
02<0oooo00<000000?ooo`3oool0Z`3oool01@000000oooo0?ooo`3oool000000080oooo0P00002]
0?ooo`030000003oool0oooo02H0oooo000S0?ooo`030000003oool0oooo0:`0oooo0P000000103o
ool000000?ooo`00002^0?ooo`80o`00:03oool002<0oooo00<000000?ooo`3oool0[P3oool30000
0:h0oooo103o000W0?ooo`00o`000025000000H0o`009@0000010?ooo`0000<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00`0oooo0P000000103oool00000
0?ooo`00000?0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0<0?ooo`H0o`003P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00<0
oooo000S0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0DP3oool01@000000oooo
0?ooo`3oool000000080oooo0P00001D0?ooo`030000003oool0oooo05@0oooo103o000W0?ooo`00
8`3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0
0P3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0540oooo00<000000?ooo`3oool0
E@3oool20?l002P0oooo000S0?ooo`030000003oool0oooo0:P0oooo0P0000050?ooo`030000003o
ool0oooo00<0oooo0P00002Z0?ooo`03000Io`3oool0oooo02H0oooo000S0?ooo`030000003oool0
oooo0:L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo0:L0oooo00<001Wo0?ooo`3oool09P3oool002<0oooo00<000000?ooo`3oool0Y@3oool20000
00P0oooo00<000000?ooo`3oool01P3oool200000:L0oooo00<001Wo0?ooo`3oool09P3oool002@0
oooo00<000000?ooo`3oool0X`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool0X`3oool00`00000001Wo0?ooo`0W0?ooo`00903oool00`000000oooo
0?ooo`2R0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo
0?ooo`2R0?ooo`03000000006Ol0oooo02L0oooo000T0?ooo`030000003oool0oooo0:00oooo0P00
000<0?ooo`030000003oool0oooo00X0oooo0P00002R0?ooo`03000000006Ol0oooo02L0oooo000T
0?ooo`030000003oool0oooo09l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo09l0oooo00<00000000Io`3oool09`3oool002@0oooo00<000000?oo
o`3oool0W@3oool2000000l0oooo00<000000?ooo`3oool03@3oool2000009l0oooo00<00000000I
o`3oool09`3oool002@0oooo00<000000?ooo`3oool0W03oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0W03oool00`00000001Wo0?ooo`0W0?ooo`00
903oool00`000000oooo0?ooo`2K0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`2K0?ooo`03000000006Ol0oooo02L0oooo000T0?ooo`030000003o
ool0oooo09T0oooo0P00000C0?ooo`030000003oool0oooo0140oooo0P00002J0?ooo`030000003o
ool001Wo02P0oooo000U0?ooo`030000003oool0oooo09L0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo09L0oooo00<000000?ooo`006Ol0:03oool0
02D0oooo00<000000?ooo`3oool0U@3oool2000001H0oooo00<000000?ooo`3oool0503oool20000
09L0oooo00<000000?ooo`006Ol0:03oool002D0oooo00<000000?ooo`3oool0U03oool00`000000
oooo0?ooo`0F0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0U03oool00`000000
oooo000Io`0X0?ooo`009@3oool20?l009@0oooo00<000000?ooo`3oool05`3oool3000001L0oooo
00<000000?ooo`3oool0T`3oool00`000000oooo000Io`0X0?ooo`00903oool40?l00940oooo0P00
000J0?ooo`030000003oool0oooo01P0oooo0P00002B0?ooo`040000003oool0oooo000IobP0oooo
000S0?ooo`H0o`00S`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01X0oooo00<0
00000?ooo`3oool0S`3oool010000000oooo0?ooo`006OlX0?ooo`008`3oool60?l008d0oooo0P00
000M0?ooo`030000003oool0oooo01/0oooo0P00002?0?ooo`040000003oool0oooo000IobP0oooo
000T0?ooo`@0o`00S@3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo01d0oooo00<0
00000?ooo`3oool0S03oool010000000oooo0?ooo`006OlX0?ooo`009@3oool20?l00003000Io`3o
ool0oooo08X0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0N0?ooo`030000003o
ool0oooo08X0oooo00D000000?ooo`3oool0oooo000Io`0X0?ooo`009P3oool00`00000001Wo0?oo
o`290?ooo`8000008@3oool00`000000oooo0?ooo`0O0?ooo`800000RP3oool01@000000oooo0?oo
o`3oool001Wo02P0oooo000W0?ooo`03000Io`3oool0oooo08L0oooo00<000000?ooo`3oool08@3o
ool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo08L0oooo00D000000?ooo`3oool0oooo
000Io`0X0?ooo`009`3oool00`006Ol0oooo0?ooo`250?ooo`800000903oool00`000000oooo0?oo
o`0R0?ooo`030000003oool0oooo08D0oooo00<000000?ooo`3oool00P3oool00`006Ol0oooo0?oo
o`0V0?ooo`009`3oool00`00000001Wo0?ooo`240?ooo`030000003oool0oooo02@0oooo00<00000
0?ooo`3oool08`3oool2000008D0oooo00<000000?ooo`3oool00P3oool00`006Ol0oooo0?ooo`0V
0?ooo`00:03oool00`006Ol0oooo0?ooo`220?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool09@3oool00`000000oooo0?ooo`220?ooo`030000003oool0oooo0080oooo00<001Wo0?oo
o`3oool09P3oool002P0oooo00<001Wo0?ooo`3oool0P03oool2000002P0oooo00<000000?ooo`3o
ool09P3oool200000840oooo00<000000?ooo`3oool00`3oool00`006Ol0oooo0?ooo`0V0?ooo`00
:03oool00`006Ol0oooo0?ooo`1o0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0
:03oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo00<0oooo00<001Wo0?ooo`3oool0
9P3oool002T0oooo00<001Wo0?ooo`3oool0O03oool2000002/0oooo00<000000?ooo`3oool0:@3o
ool00`000000oooo0?ooo`1m0?ooo`030000003oool0oooo00<0oooo00<001Wo0?ooo`3oool09P3o
ool002T0oooo00<001Wo0?ooo`3oool0N`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0
oooo02X0oooo0P00001l0?ooo`030000003oool0oooo00@0oooo00<001Wo0?ooo`3oool09P3oool0
02T0oooo00<001Wo0000003oool0NP3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo
02`0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`040?ooo`03000Io`3oool0oooo
02H0oooo000Z0?ooo`03000Io`3oool0oooo07L0oooo0P00000_0?ooo`030000003oool0oooo02d0
oooo0P00001i0?ooo`030000003oool0oooo00@0oooo00<001Wo0?ooo`3oool09P3oool002X0oooo
00<001Wo0000003oool0MP3oool00`000000oooo0?ooo`0_0?ooo`<00000;`3oool00`000000oooo
0?ooo`1e0?ooo`030000003oool0oooo00D0oooo00<001Wo0?ooo`3oool09P3oool002X0oooo00<0
01Wo0000003oool0M03oool200000380oooo00<000000?ooo`3oool0<03oool00`000000oooo0?oo
o`1d0?ooo`030000003oool0oooo00D0oooo00<001Wo0?ooo`3oool09P3oool002X0oooo00<001Wo
0?ooo`000000L`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo0340oooo0P00001c
0?ooo`030000003oool0oooo00H0oooo00<001Wo0?ooo`3oool09P3oool002/0oooo00<001Wo0000
003oool0L@3oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?oo
o`3oool0L03oool00`000000oooo0?ooo`060?ooo`03000Io`3oool0oooo02H0oooo000[0?ooo`03
000Io`3oool0000006l0oooo0P00000f0?ooo`030000003oool0oooo03@0oooo0P00001_0?ooo`03
0000003oool0oooo00L0oooo00<001Wo0?ooo`3oool09P3oool002/0oooo00<001Wo0?ooo`000000
KP3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0
K03oool00`000000oooo0?ooo`070?ooo`03000Io`3oool0oooo02H0oooo000[0?ooo`04000Io`3o
ool0oooo000006/0oooo0P00000i0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0
JP3oool00`000000oooo0?ooo`080?ooo`03000Io`3oool0oooo02H0oooo000/0?ooo`04000Io`3o
ool0oooo000006T0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0h0?ooo`800000
JP3oool00`000000oooo0?ooo`080?ooo`03000Io`3oool0oooo02H0oooo000/0?ooo`04000Io`3o
ool0oooo000006P0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo06H0oooo00<000000?ooo`3oool02@3oool00`006Ol0oooo0?ooo`0V0?ooo`00;03o
ool01@006Ol0oooo0?ooo`3oool0000006D0oooo0P00000m0?ooo`030000003oool0oooo03/0oooo
0P00001V0?ooo`030000003oool0oooo00T0oooo00<001Wo0?ooo`3oool09P3oool002d0oooo00@0
01Wo0?ooo`3oool00000I03oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo03d0oooo
00<000000?ooo`3oool0HP3oool00`000000oooo0?ooo`0:0?ooo`03000Io`3oool0oooo02H0oooo
000]0?ooo`05000Io`3oool0oooo0?ooo`000000H@3oool200000400oooo00<000000?ooo`3oool0
?P3oool00`000000oooo0?ooo`0<0?ooo`03000Io`3oool0oooo0580oooo00<000000?ooo`3oool0
2P3oool00`006Ol0oooo0?ooo`0V0?ooo`00;@3oool00`006Ol0oooo0?ooo`020?ooo`030000003o
ool0oooo05d0oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`0o0?ooo`8000003@3o
ool2000Ioe40oooo00<000000?ooo`3oool02`3oool00`006Ol0oooo0?ooo`0V0?ooo`00;@3oool0
0`006Ol0oooo0?ooo`020?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool0@@3oool0
0`000000oooo0?ooo`110?ooo`030000003oool0oooo00X0oooo10006Om>0?ooo`030000003oool0
oooo00`0oooo00<001Wo0?ooo`3oool09P3oool002h0oooo00<001Wo0?ooo`3oool00P3oool00`00
0000oooo0?ooo`1I0?ooo`800000A03oool00`000000oooo0?ooo`120?ooo`8000002`3oool5000I
od`0oooo00<000000?ooo`3oool01P3oool<000Iob<0oooo000^0?ooo`03000Io`3oool0oooo0080
oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`140?ooo`030000003oool0oooo04@0
oooo00<000000?ooo`3oool02@3oool6000IodT0oooo00<000000?ooo`3oool01`3oool<000Iob<0
oooo000^0?ooo`03000Io`3oool0oooo00<0oooo00<000000?ooo`3oool0E@3oool2000004L0oooo
00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`080?ooo`L001WoB03oool00`000000oooo
0?ooo`080?ooo`/001Wo8`3oool002h0oooo00<001Wo0?ooo`3oool0103oool00`000000oooo0?oo
o`1C0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0AP3oool2000000T0oooo2000
6Om50?ooo`030000003oool0oooo00T0oooo2P006OlT0?ooo`00;`3oool00`006Ol0oooo0?ooo`03
0?ooo`030000003oool0oooo0580oooo00<000000?ooo`3oool0B03oool3000004P0oooo00<00000
0?ooo`3oool01P3oool:000Iod80oooo00<000000?ooo`3oool02P3oool:000Iob@0oooo000_0?oo
o`03000Io`3oool0oooo00@0oooo00<000000?ooo`3oool0C`3oool2000004/0oooo00<000000?oo
o`3oool0B@3oool2000000L0oooo2`006Om00?ooo`030000003oool0oooo00X0oooo2P006OlT0?oo
o`00;`3oool00`006Ol0oooo0?ooo`050?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3o
ool0B`3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo00D0oooo30006Olm0?ooo`03
0000003oool0oooo00`0oooo2@006OlT0?ooo`00;`3oool00`006Ol0oooo0?ooo`060?ooo`030000
003oool0oooo04X0oooo0P00001>0?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool0
103oool>000IocX0oooo00<000000?ooo`3oool03@3oool8000IobD0oooo000`0?ooo`03000Io`3o
ool0oooo00D0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?ooo`1>0?ooo`030000003o
ool0oooo04d0oooo0P0000050?ooo`h001Wo>03oool00`000000oooo0?ooo`0>0?ooo`P001Wo9@3o
ool00300oooo00<001Wo0?ooo`3oool01P3oool00`000000oooo0?ooo`170?ooo`030000003oool0
oooo04l0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`030?ooo``001Wo>@3oool0
0`000000oooo0?ooo`0>0?ooo`P001Wo9@3oool00300oooo00<001Wo0?ooo`3oool01`3oool00`00
0000oooo0?ooo`140?ooo`800000DP3oool00`000000oooo0?ooo`1@0?ooo`8000000`3oool;000I
ocT0oooo00<000000?ooo`3oool0403oool7000IobD0oooo000a0?ooo`03000Io`3oool0oooo00L0
oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo0580
oooo00@000000?ooo`3oool0oooo2@006Oli0?ooo`030000003oool0oooo0140oooo1P006OlV0?oo
o`00<@3oool00`006Ol0oooo0?ooo`070?ooo`030000003oool0oooo0400oooo0P00001E0?ooo`03
0000003oool0oooo05<0oooo00<000000?ooo`3oool020006Oli0?ooo`030000003oool0oooo0180
oooo1P006OlV0?ooo`00<@3oool00`006Ol0oooo0?ooo`080?ooo`030000003oool0oooo03h0oooo
00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`1D0?ooo`80000000<0oooo000Io`006Ol0
10006Ol00`3oool001Wo0?ooo`0f0?ooo`030000003oool0oooo01@0oooo1@006OlV0?ooo`00<@3o
ool00`006Ol0oooo0?ooo`090?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0EP3o
ool00`000000oooo0?ooo`1F0?ooo`030000003oool001Wo00<001Wo0`3oool2000IocD0oooo00<0
00000?ooo`3oool0503oool5000IobH0oooo000b0?ooo`03000Io`3oool0oooo00T0oooo00<00000
0?ooo`3oool0>@3oool2000005T0oooo00<000000?ooo`3oool0E`3oool01000000001Wo000Io`00
6Ol60?ooo`03000Io`3oool0oooo0340oooo00<000000?ooo`3oool05@3oool5000IobH0oooo000b
0?ooo`03000Io`3oool0oooo00X0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`1I
0?ooo`030000003oool0oooo05T0oooo00<001Wo0?ooo`3oool01P3oool00`006Ol0oooo0?ooo`0_
0?ooo`030000003oool0oooo01H0oooo10006OlW0?ooo`00<P3oool00`006Ol0oooo0?ooo`0;0?oo
o`030000003oool0oooo03@0oooo0P00001L0?ooo`030000003oool0oooo05X0oooo00<000000?oo
o`3oool01P3oool00`006Ol0oooo0?ooo`0]0?ooo`030000003oool0oooo01P0oooo0`006OlW0?oo
o`00<P3oool00`006Ol0oooo0?ooo`0<0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3o
ool0G03oool00`000000oooo0?ooo`1K0?ooo`8000001`3oool00`006Ol0oooo0?ooo`0[0?ooo`03
0000003oool0oooo01T0oooo0`006OlW0?ooo`00<`3oool00`006Ol0oooo0?ooo`0<0?ooo`030000
003oool0oooo0200oooo00<001Wo0?ooo`3oool03@3oool00`000000oooo0?ooo`1M0?ooo`030000
003oool0oooo05d0oooo00<000000?ooo`3oool01@3oool00`006Ol0oooo0?ooo`0Y0?ooo`030000
003oool0oooo01X0oooo0`006OlW0?ooo`00<`3oool010006Ol0oooo0?ooo`3oool2000Io`X0oooo
00<000000?ooo`3oool07@3oool2000Io`h0oooo0P00001P0?ooo`030000003oool0oooo05h0oooo
00<000000?ooo`3oool01@3oool00`006Ol0oooo0?ooo`0W0?ooo`030000003oool0oooo01/0oooo
0P006OlX0?ooo`00<`3oool6000Io`/0oooo00<000000?ooo`3oool06`3oool3000Io`d0oooo00<0
00000?ooo`3oool0H03oool00`000000oooo0?ooo`1O0?ooo`8000001P3oool00`006Ol0oooo0?oo
o`0U0?ooo`030000003oool0oooo01d0oooo00<001Wo0?ooo`3oool09P3oool00300oooo2@006Ol<
0?ooo`030000003oool0oooo01P0oooo10006Ol<0?ooo`800000H`3oool300000640oooo00<00000
0?ooo`3oool0103oool00`006Ol0oooo0?ooo`0S0?ooo`030000003oool0oooo01h0oooo00<001Wo
0?ooo`3oool09P3oool002h0oooo2`006Ol<0?ooo`030000003oool0oooo01H0oooo1P006Ol;0?oo
o`030000003oool0oooo06<0oooo00<000000?ooo`3oool0HP3oool2000000D0oooo00<001Wo0?oo
o`3oool08@3oool00`000000oooo0?ooo`180?ooo`00;`3oool:000Io`d0oooo00<000000?ooo`3o
ool0503oool6000Io`/0oooo00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`1T0?ooo`03
0000003oool0oooo00<0oooo00<001Wo0?ooo`3oool07`3oool00`000000oooo0?ooo`190?ooo`00
;`3oool:000Io`h0oooo00<000000?ooo`3oool04@3oool8000Io`T0oooo0P00001W0?ooo`030000
003oool0oooo06D0oooo00<000000?ooo`3oool00`3oool00`006Ol0oooo0?ooo`0M0?ooo`030000
003oool0oooo04X0oooo000`0?ooo`T001Wo3`3oool00`000000oooo0?ooo`0?0?ooo`P001Wo2@3o
ool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo06H0oooo0P0000040?ooo`8001Wo703o
ool00`000000oooo0?ooo`1;0?ooo`00<03oool9000Ioa00oooo00<000000?ooo`3oool0303oool9
000Io`P0oooo0P00001Z0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool00`3oool0
0`006Ol0oooo0?ooo`0G0?ooo`800000CP3oool00340oooo20006OlA0?ooo`030000003oool0oooo
00T0oooo2`006Ol70?ooo`030000003oool0oooo06X0oooo00<000000?ooo`3oool0J@3oool20000
00@0oooo00<001Wo0?ooo`3oool05@3oool00`000000oooo0?ooo`1>0?ooo`00<@3oool8000Ioa80
oooo00<000000?ooo`3oool01`3oool;000Io`L0oooo00<000000?ooo`3oool0J`3oool00`000000
oooo0?ooo`1[0?ooo`030000003oool0oooo0080oooo00<001Wo0?ooo`3oool04`3oool00`000000
oooo0?ooo`1?0?ooo`00<P3oool7000Ioa<0oooo00<000000?ooo`3oool0103oool=000Io`D0oooo
0P00001^0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool00P3oool00`006Ol0oooo
0?ooo`0A0?ooo`030000003oool0oooo0500oooo000c0?ooo`H001Wo503oool00`000000oooo0?oo
o`020?ooo`d001Wo1@3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo06d0oooo0P00
00030?ooo`03000Io`3oool0oooo00l0oooo00<000000?ooo`3oool0D@3oool003<0oooo1`006OlD
0?ooo`030000003oool0oooo0080oooo2`006Ol40?ooo`800000L@3oool00`000000oooo0?ooo`1_
0?ooo`050000003oool0oooo0?ooo`006Ol03`3oool00`000000oooo0?ooo`1B0?ooo`00=03oool6
000IoaD0oooo00<000000?ooo`3oool00P3oool:000Io`<0oooo00<000000?ooo`3oool0L@3oool0
0`000000oooo0?ooo`1`0?ooo`8000000P3oool00`006Ol0oooo0?ooo`0;0?ooo`030000003oool0
oooo05<0oooo000d0?ooo`H001Wo5P3oool00`000000oooo0?ooo`020?ooo`P001Wo0`3oool00`00
0000oooo0?ooo`1b0?ooo`030000003oool0oooo0780oooo00@000000?ooo`3oool001Wo2`3oool0
0`000000oooo0?ooo`1D0?ooo`00=@3oool5000IoaL0oooo0P0000030?ooo`L001Wo00<0oooo0000
00000000M@3oool00`000000oooo0?ooo`1c0?ooo`040000003oool0oooo000Io`T0oooo00<00000
0?ooo`3oool0E@3oool003H0oooo10006OlI0?ooo`050000003oool0oooo000Io`3oool010006Ol0
0`3oool000000?ooo`1H0?ooo`050?oDV`00000000000000002Ke?l01@3oool00`3DV`000000002K
e0050?ooo`050=BK0000000000000000002Ke?l01`3oool00`000000oooo0?ooo`1d0?ooo`800000
00<0oooo000Io`3oool01P3oool00`000000oooo0?ooo`1F0?ooo`00=P3oool4000IoaX0oooo00<0
0000000Io`3oool00P3oool3000Io`030000003oool0oooo05P0oooo00H0^W:K0=Coo`3oool0oooD
09/0V`3Dool40?ooo`030=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000
VmCo00H0oooo00<000000?ooo`3oool0MP3oool00`000000oooo000Io`050?ooo`030000003oool0
oooo05L0oooo000g0?ooo`<001Wo6P3oool00`006Ol00000000000030?ooo`03000Io`3oool0oooo
05T0oooo00<0omBK002Ke03oool00P3oool00`3Z^W80L[[Z0?ooo`0?0?ooo`030?oDV`00Vm@0oooo
00D0oooo00<000000?ooo`3oool0M`3oool20000008001Wo0P3oool00`000000oooo0?ooo`1H0?oo
o`00=`3oool3000IoaT0oooo00L001Wo0?ooo`3oool0oooo0000003oool0000005`0oooo00<0j[Yb
07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?0?ooo`030?oDV`00Vm@0oooo00D0oooo00<00000
0?ooo`3oool0N@3oool010000000oooo000Io`00001K0?ooo`00>03oool2000IoaP0oooo00<001Wo
0?ooo`3oool00P3oool2000005d0oooo00<0j[Yb07:jjP3oool00P3oool00`3oe9/009_D0?ooo`0?
0?ooo`030;Yb002Ke?l0oooo00D0oooo1000001i0?ooo`030000003oool001Wo05/0oooo000h0?oo
o`8001Wo5`3oool00`006Ol0oooo0?ooo`020?ooo`030000003oool0oooo00800000F`3oool00`3Z
^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00X0oooo00<0oooD09/0000000000P0000000`1b
^^X0oooo0?ooo`050?ooo`030000003oool0oooo07T0oooo00D000000?ooo`0000000000000Io`1J
0?ooo`00>@3oool00`006Ol0oooo0?ooo`0D0?ooo`03000Io`3oool0oooo0080oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`1H0?ooo`030?oDV`1b^^X0oooo0080oooo00<0j[Yb07:j
jP3oool02P3oool00`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0oooo07L0oooo0P0000040?oo
o`03000000006Ol0oooo05P0oooo001?0?ooo`03000Io`3oool0oooo0080oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`1H0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool0
0`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0oooo07H0oooo00<000000?ooo`3oool01@3oool0
0`00000001Wo0?ooo`1G0?ooo`00CP3oool00`006Ol0oooo0?ooo`020?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0E`3oool01@3oom@0V`00000000000780^^[o00`0oooo00<0oooD
09/0000000000P0000000`0009/0e?oo0?ooo`050?ooo`030000003oool0oooo07@0oooo0P000009
0?ooo`03000000006Ol0oooo05H0oooo001=0?ooo`03000Io`3oool0oooo0080oooo00<000000?oo
o`3oool02@3oool2000007D0oooo00<000000?ooo`3oool0L`3oool00`000000oooo0?ooo`0:0?oo
o`03000000006Ol0oooo05D0oooo001=0?ooo`05000Io`3oool0oooo0?ooo`0000003P3oool00`00
0000oooo0?ooo`1b0?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool0303oool00`00
000001Wo0?ooo`1D0?ooo`00C03oool01@006Ol0oooo0?ooo`3oool000000100oooo00<000000?oo
o`3oool0L@3oool00`000000oooo0?ooo`1`0?ooo`800000403oool00`00000001Wo0?ooo`1C0?oo
o`00B`3oool01@006Ol0oooo0?ooo`3oool000000180oooo0P00001a0?ooo`030000003oool0oooo
06l0oooo00<000000?ooo`3oool04P3oool00`006Ol0oooo0?ooo`1A0?ooo`00BP3oool01@006Ol0
oooo0?ooo`3oool0000001D0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?ooo`1]0?oo
o`8000005P3oool2000Ioe40oooo00190?ooo`03000Io`3oool0oooo008000005`3oool00`000000
oooo0?ooo`1]0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool05`3oool00`000000
01Wo0?ooo`1?0?ooo`00B03oool010006Ol0oooo0?ooo`00000J0?ooo`800000K@3oool00`000000
oooo0?ooo`1[0?ooo`030000003oool0oooo01T0oooo00<00000000Io`3oool0CP3oool004L0oooo
00@001Wo0?ooo`3oool000007@3oool00`000000oooo0?ooo`1Z0?ooo`030000003oool0oooo06T0
oooo0P00000M0?ooo`03000000006Ol0oooo04d0oooo00160?ooo`04000Io`3oool0oooo000001l0
oooo00<000000?ooo`3oool0J@3oool00`000000oooo0?ooo`1X0?ooo`030000003oool0oooo01h0
oooo00<00000000Io`3oool00P3o001:0?ooo`00A@3oool010006Ol0oooo0?ooo`00000Q0?ooo`80
0000J@3oool00`000000oooo0?ooo`1V0?ooo`8000008P3oool00`000000o`000?l000020?l004T0
oooo00140?ooo`04000Io`3oool0oooo000002@0oooo0P00001W0?ooo`030000003oool0oooo06D0
oooo00<000000?ooo`3oool08P3oool60?l004P0oooo00140?ooo`03000Io`3oool0000002L0oooo
00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`1T0?ooo`030000003oool0oooo02<0oooo
1P3o00180?ooo`00@`3oool00`006Ol0oooo0000000Y0?ooo`800000I03oool00`000000oooo0?oo
o`1R0?ooo`8000009`3oool40?l004T0oooo00120?ooo`03000Io`3oool0000002`0oooo0P00001R
0?ooo`<00000H@3oool00`000000oooo0?ooo`0X0?ooo`80o`0000<0oooo0000003oool0A`3oool0
0440oooo00<001Wo0?ooo`000000;`3oool00`000000oooo0?ooo`1O0?ooo`030000003oool0oooo
05l0oooo0P00000_0?ooo`030000003oool0oooo04D0oooo00100?ooo`03000Io`3oool000000340
oooo0P00001O0?ooo`030000003oool0oooo05d0oooo0P00000b0?ooo`030000003oool0oooo04@0
oooo000o0?ooo`03000Io`3oool0000003@0oooo0P00001M0?ooo`030000003oool0oooo05`0oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`130?ooo`00?P3oool00`006Ol0oooo0000
000g0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0FP3oool2000003L0oooo00<0
00000?ooo`3oool0@P3oool003d0oooo00<001Wo0?ooo`000000>@3oool2000005X0oooo00<00000
0?ooo`3oool0F03oool2000003X0oooo00<000000?ooo`3oool0@@3oool003`0oooo00<001Wo0?oo
o`000000?03oool00`000000oooo0?ooo`1G0?ooo`030000003oool0oooo05L0oooo00<000000?oo
o`3oool0>`3oool00`000000oooo0?ooo`100?ooo`00>`3oool00`006Ol0oooo0000000n0?ooo`80
0000E`3oool00`000000oooo0?ooo`1E0?ooo`800000?`3oool00`000000oooo0?ooo`0o0?ooo`00
>`3oool00`006Ol000000?ooo`100?ooo`800000E@3oool00`000000oooo0?ooo`1C0?ooo`800000
@P3oool00`000000oooo0?ooo`0n0?ooo`00>P3oool00`006Ol000000?ooo`130?ooo`030000003o
ool0oooo0580oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`130?ooo`030000003o
ool0oooo03d0oooo000i0?ooo`03000Io`3oool0oooo04D0oooo0P00001B0?ooo`030000003oool0
oooo0500oooo0P0000170?ooo`030000003oool0oooo03`0oooo000e0?ooo`80o`0000<0oooo000I
o`3oool0B@3oool200000500oooo00<000000?ooo`3oool0CP3oool2000004X0oooo00<000000?oo
o`3oool0>`3oool003@0oooo103o001=0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3o
ool0C@3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo03X0oooo000c0?ooo`H0o`00
C@3oool2000004d0oooo00<000000?ooo`3oool0B`3oool2000004h0oooo00<000000?ooo`3oool0
>P3oool003<0oooo1P3o001?0?ooo`800000B`3oool00`000000oooo0?ooo`190?ooo`800000D@3o
ool00`000000oooo0?ooo`0i0?ooo`00=03oool40?l00580oooo0P0000190?ooo`030000003oool0
oooo04P0oooo00<000000?ooo`3oool0DP3oool00`000000oooo0?ooo`0h0?ooo`00<`3oool01000
0000oooo0?l0003o001E0?ooo`800000A`3oool00`000000oooo0?ooo`160?ooo`800000EP3oool0
0`000000oooo0?ooo`0g0?ooo`00<P3oool00`000000oooo0?ooo`1I0?ooo`800000A@3oool30000
04@0oooo0P00001I0?ooo`030000003oool0oooo03H0oooo000a0?ooo`030000003oool0oooo05`0
oooo0P0000130?ooo`030000003oool0oooo03d0oooo0P3o00030?ooo`800000G03oool00`000000
oooo0?ooo`0e0?ooo`00<03oool00`000000oooo0?ooo`1O0?ooo`800000@@3oool00`000000oooo
0?ooo`0l0?ooo`@0o`000P00001O0?ooo`030000003oool0oooo03@0oooo000`0?ooo`030000003o
ool0oooo0640oooo0P00000o0?ooo`030000003oool0oooo03/0oooo1P3o001Q0?ooo`030000003o
ool0oooo03<0oooo000_0?ooo`030000003oool0oooo06@0oooo0P00000m0?ooo`030000003oool0
oooo03/0oooo1P3o001R0?ooo`030000003oool0oooo0380oooo000^0?ooo`030000003oool0oooo
06L0oooo0P00000k0?ooo`030000003oool0oooo03T0oooo0P006Ol00`000000o`000?l000020?l0
06@0oooo00<000000?ooo`3oool0<@3oool002d0oooo00<000000?ooo`3oool0JP3oool2000003T0
oooo00<000000?ooo`3oool0=`3oool2000Io`@0oooo0P3o001V0?ooo`030000003oool0oooo0300
oooo000]0?ooo`030000003oool0oooo06`0oooo0P00000g0?ooo`030000003oool0oooo03D0oooo
0P006Om^0?ooo`030000003oool0oooo0300oooo000/0?ooo`030000003oool0oooo06l0oooo0P00
000e0?ooo`030000003oool0oooo03<0oooo0P006Oma0?ooo`030000003oool0oooo02l0oooo000[
0?ooo`030000003oool0oooo0780oooo0P00000c0?ooo`030000003oool0oooo0340oooo0P006Omc
0?ooo`030000003oool0oooo02l0oooo000[0?ooo`030000003oool0oooo07@0oooo0P00000a0?oo
o`030000003oool0oooo02h0oooo00<00000000Io`006Ol0MP3oool00`000000oooo0?ooo`0^0?oo
o`00:P3oool00`000000oooo0?ooo`1g0?ooo`800000;`3oool00`000000oooo0?ooo`0/0?ooo`03
000000006Ol001Wo07T0oooo00<000000?ooo`3oool0;@3oool002T0oooo00<000000?ooo`3oool0
NP3oool2000002d0oooo00<000000?ooo`3oool0:P3oool00`00000001Wo000Io`1k0?ooo`030000
003oool0oooo02d0oooo000Y0?ooo`030000003oool0oooo07`0oooo0P00000[0?ooo`030000003o
ool0oooo02P0oooo00<00000000Io`006Ol0OP3oool00`000000oooo0?ooo`0/0?ooo`00:03oool0
0`000000oooo0?ooo`1o0?ooo`800000:@3oool00`000000oooo0?ooo`0U0?ooo`8000000P006On0
0?ooo`030000003oool0oooo02`0oooo000X0?ooo`030000003oool0oooo0840oooo0`0000030?oo
o`80o`008@3oool00`000000oooo0?ooo`0S0?ooo`8000000P006On30?ooo`030000003oool0oooo
02/0oooo000W0?ooo`030000003oool0oooo08D0oooo0P0000040?l00200oooo00<000000?ooo`3o
ool08@3oool20000008001WoQ@3oool00`000000oooo0?ooo`0[0?ooo`009P3oool00`000000oooo
0?ooo`270?ooo`H0o`007`3oool00`000000oooo0?ooo`0O0?ooo`8000000P006On80?ooo`030000
003oool0oooo02X0oooo000V0?ooo`030000003oool0oooo08L0oooo1P3o000O0?ooo`<00000703o
ool30000008001WoRP3oool00`000000oooo0?ooo`0Z0?ooo`009@3oool00`000000oooo0?ooo`29
0?ooo`@0o`0000@0oooo000Io`006Ol001Wo703oool00`000000oooo0?ooo`0I0?ooo`<0000000<0
oooo000Io`006Ol0S@3oool00`000000oooo0?ooo`0Y0?ooo`009@3oool00`000000oooo0?ooo`2:
0?ooo`80o`001@3oool2000IoaX0oooo00<000000?ooo`3oool05P3oool300000080oooo0P006On?
0?ooo`030000003oool0oooo02T0oooo000U0?ooo`030000003oool0oooo09<0oooo0P006Ol00`00
0000oooo0?ooo`0E0?ooo`030000003oool0oooo01@0oooo0P0000030?ooo`8001WoTP3oool00`00
0000oooo0?ooo`0X0?ooo`00903oool00`000000oooo0?ooo`2F0?ooo`<001Wo00<000000?ooo`3o
ool04P3oool00`000000oooo0?ooo`0A0?ooo`<000000`3oool2000Ioi@0oooo00<000000?ooo`3o
ool0:03oool002@0oooo00<000000?ooo`3oool0V@3oool2000Io`030000003oool0oooo0100oooo
00<000000?ooo`3oool03P3oool3000000@0oooo0P006OnG0?ooo`030000003oool0oooo02L0oooo
000T0?ooo`030000003oool0oooo09/0oooo0`006Ol00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00/0oooo0`0000050?ooo`8001WoV@3oool00`000000oooo0?ooo`0W0?ooo`00903oool0
0`000000oooo0?ooo`2N0?ooo`8001Wo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`08
0?ooo`<000001P3oool2000Ioi/0oooo00<000000?ooo`3oool09`3oool002<0oooo00<000000?oo
o`3oool0X@3oool3000Io`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool30000
00L0oooo0P006OnM0?ooo`030000003oool0oooo02L0oooo000S0?ooo`030000003oool0oooo0:@0
oooo0P006Ol00`000000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo0`0000080?ooo`80
01WoW`3oool00`000000oooo0?ooo`0W0?ooo`008`3oool00`000000oooo0?ooo`2V0?ooo`<001Wo
00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`02000000T0oooo0P006OnR0?ooo`030000
003oool0oooo02H0oooo000S0?ooo`030000003oool0oooo0:T0oooo0P006Ol3000000040?ooo`00
00000000000000T0oooo0P006OnT0?ooo`030000003oool0oooo02H0oooo000S0?ooo`030000003o
ool0oooo0:/0oooo0P006Ol4000000P0oooo0P006OnV0?ooo`030000003oool0oooo02H0oooo000S
0?ooo`030000003oool0oooo0:T0oooo0`0000001@3oool001Wo000Io`006Ol0oooo00<000000`3o
ool2000IojP0oooo00<000000?ooo`3oool09P3oool002<0oooo00<000000?ooo`3oool0YP3oool3
000000H0oooo00<00000000Io`006Ol00P3oool01000000001Wo000Io`00002Y0?ooo`030000003o
ool0oooo02H0oooo000S0?ooo`030000003oool0oooo0:<0oooo0`0000090?ooo`030000003oool0
oooo00<001Wo0`3oool300000:D0oooo00<000000?ooo`3oool09`3oool002@0oooo00<000000?oo
o`3oool0WP3oool4000000`0oooo00@000000?ooo`006Ol001Wo0P3oool2000Io`@0oooo1000002Q
0?ooo`030000003oool0oooo02L0oooo000T0?ooo`030000003oool0oooo09/0oooo0`00000@0?oo
o`8001Wo1P3oool3000Io`D0oooo0`00002N0?ooo`030000003oool0oooo02L0oooo000T0?ooo`03
0000003oool0oooo09P0oooo0`00000A0?ooo`8001Wo0`0000080?ooo`8001Wo1P3oool3000009/0
oooo00<000000?ooo`3oool09`3oool002D0oooo00<000000?ooo`3oool0U03oool300000180oooo
0P006Ol20?ooo`030000003oool0oooo00X0oooo0`006Ol60?ooo`@00000UP3oool00`000000oooo
0?ooo`0X0?ooo`009@3oool00`000000oooo0?ooo`2A0?ooo`<000004`3oool2000Io`@0oooo00<0
00000?ooo`3oool03@3oool2000Io`P0oooo1000002B0?ooo`030000003oool0oooo02P0oooo000V
0?ooo`030000003oool0oooo08`0oooo1000000:0?ooo`03000Io`3oool0oooo00L0oooo0P006Ol6
0?ooo`030000003oool0oooo00l0oooo0P006Ol:0?ooo`@00000S@3oool00`000000oooo0?ooo`0Y
0?ooo`009`3oool00`000000oooo0?ooo`280?ooo`<000003@3oool3000Io`H0oooo0P006Ol80?oo
o`030000003oool0oooo0140oooo0`006Ol;0?ooo`@00000R@3oool00`000000oooo0?ooo`070?oo
o`/001Wo5`3oool002P0oooo00<000000?ooo`3oool0P`3oool4000000h0oooo1@006Ol40?ooo`80
01Wo2P3oool00`000000oooo0?ooo`0D0?ooo`8001Wo3@3oool4000008@0oooo00<000000?ooo`3o
ool0203ooolG000Io`/0oooo000Y0?ooo`030000003oool0oooo07d0oooo1@00000A0?ooo`L001Wo
00<0oooo000Io`006Ol0303oool00`000000oooo0?ooo`0F0?ooo`<001Wo3P3oool5000007h0oooo
00<000000?ooo`3oool02@3ooolF000Io``0oooo000Z0?ooo`030000003oool0oooo07P0oooo1000
000E0?ooo`T001Wo3P3oool00`000000oooo0?ooo`0I0?ooo`8001Wo4@3oool4000007P0oooo0P00
000=0?oooa<001Wo3P3oool002/0oooo00<000000?ooo`3oool0LP3oool5000001P0oooo2P006Ol>
0?ooo`030000003oool0oooo01/0oooo0`006OlB0?ooo`@00000L`3oool00`000000oooo0?ooo`0=
0?oooa4001Wo403oool002`0oooo00<000000?ooo`3oool0K03oool5000001`0oooo2`006Ol>0?oo
o`030000003oool0oooo01h0oooo0P006OlD0?ooo`@00000KP3oool00`000000oooo0?ooo`0<0?oo
oa4001Wo4P3oool002d0oooo0P00001X0?ooo`@000007`3oool>000Io`d0oooo00<000000?ooo`3o
ool0803oool3000IoaD0oooo1@00001W0?ooo`8000002P3oool5000Io`80oooo3@006OlD0?ooo`00
7P3oool3000Io`h0oooo0P00001Q0?ooo`D000008P3oool?000Io`d0oooo00<000000?ooo`3oool0
8`3oool2000Io``0oooo00<001Wo0?ooo`3oool02@3oool500000600oooo0P0000070?ooo`D001Wo
1`3oool;000IoaH0oooo000H0?ooo`T001Wo403oool3000005T0oooo1@00000V0?oooa4001Wo303o
ool00`000000oooo0?ooo`0U0?ooo`8001Wo2P3oool3000Io`h0oooo1000001I0?ooo`<00000103o
ool5000Io``0oooo2@006OlH0?ooo`004`3oool>000Ioa<0oooo0`00001@0?ooo`H00000:P3oool?
000Io`l0oooo00<000000?ooo`3oool09`3oool3000Io`H0oooo1@006OlA0?ooo`D00000A`3oool2
0?l000P0oooo0`0000000`3oool001Wo000Io`04000Ioa80oooo1P006OlJ0?ooo`003@3ooolD000I
oaH0oooo0P0000180?ooo`H00000;`3oool<000Io`H0oooo00<0omBK0000000000000`0000000`00
Vm@0oooo0?ooo`040?ooo`030000003oool0oooo02X0oooo0P006Ol40?ooo`H001Wo5@3oool60000
0400oooo103o00050?ooo`03000000006Ol001Wo00<001Wo603oool4000Ioa`0oooo000:0?oooaL0
01Wo603oool4000001@0oooo0P3o000W0?ooo`L00000<`3oool:000Io`d0oooo00<0^W9b0;[Zo`3o
ool01`3oool00`000000oooo0?ooo`0/0?ooo``001Wo6@3oool7000003P0oooo1P3o0005000Ioad0
oooo0P006OlN0?ooo`00303ooolR000Io`l0oooo1P00000=0?ooo`@0o`007P3oool8000003T0oooo
1P006OlB0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool0;`3oool:000Ioal0oooo
3`00000V0?ooo`<000001P3o00000`000000oooo0?ooo`0o0?ooo`00403oool@000Io`h0oooo6000
6Ol9000000H0o`002`3ooolB00000400oooo0`006OlF0?ooo`030;YbLP2jj_l0oooo00L0oooo00<0
00000?ooo`3oool0;`3oool;000Iobd0oooo3@00000?0?ooo`X00000103oool40?l004<0oooo000C
0?ooo`d001Wo9P3oool9000Io`H0o`002`00001[0?ooo`030;YbLP2jj_l0oooo00L0oooo1000000]
0?ooo`h001Wo>03oool?000000l0oooo0P3o00140?ooo`005`3oool9000Ioc00oooo103o001g0?oo
o`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool0;P3oool?000Ioi/0oooo000J0?ooo`H0
01Wo<@3oool20?l007P0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0]0?oooa80
01WoV@3oool001h0oooo0P006OnX0?ooo`050>ZjLP00000007:j0;YbLP2jj_l0203oool00`000000
oooo0?ooo`0]0?oooa<001WoV03oool00<X0oooo00<0j[Yb0000LP2jj_l0203oool00`000000oooo
0?ooo`0a0?oooa0001WoU`3oool00=D0oooo00<000000?ooo`3oool0>03oool;000IoiD0oooo003E
0?ooo`030000003oool0oooo0400oooo10006OnD0?ooo`00e@3oool00`000000oooo0?ooo`3H0?oo
o`00e@3oool00`000000oooo0?ooo`3H0?ooo`00e@3oool00`000000oooo0?ooo`3H0?ooo`00e@3o
ool00`000000oooo0?ooo`3H0?ooo`00e@3oool00`000000oooo0?ooo`3H0?ooo`00e@3oool00`00
0000oooo0?ooo`3H0?ooo`00e@3oool00`000000oooo0?ooo`3H0?ooo`00e@3oool00`000000oooo
0?ooo`3H0?ooo`00e@3oool00`000000oooo0?ooo`3H0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 431}, {389.938, 0}} -> {-1.2008, -1.10446, \
0.00843874, 0.00843874}}]
}, Open  ]],

Cell[TextData[{
  "Podemos interpretar una curva ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  " como la trayectoria que recorre un m\[OAcute]vil cuyo vector de posici\
\[OAcute]n en el instante ",
  StyleBox["t",
    FontSlant->"Italic"],
  " viene dado por ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  ". En tal caso, el vector derivada, ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma]' \((t)\) = \((x' \((t)\), y' \((t)\))\)\)]],
  "  es la ",
  StyleBox["velocidad",
    FontWeight->"Bold"],
  " del m\[OAcute]vil en el instante ",
  StyleBox["t",
    FontSlant->"Italic"],
  " y la norma eucl\[IAcute]dea de dicho vector, ",
  Cell[BoxData[
      \(TraditionalForm
      \`\(\( || \[Gamma]'\) \((t)\) || \) = 
        \@\(x' \((t)\)\^2 + y' \((t)\)\^2\)\)]],
  " es la ",
  StyleBox["rapidez",
    FontWeight->"Bold"],
  " o ",
  StyleBox["celeridad",
    FontWeight->"Bold"],
  " del m\[OAcute]vil en el instante ",
  StyleBox["t.",
    FontSlant->"Italic"],
  " La distancia recorrida por el m\[OAcute]vil desde el instante ",
  Cell[BoxData[
      \(TraditionalForm\`t = a\)]],
  " hasta el instante ",
  Cell[BoxData[
      \(TraditionalForm\`t = b\)]],
  " se obtiene, como es natural, integrando la rapidez y viene dada por ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_a\%b\(\( || \[Gamma]'\) \((t)\) || 
          \[DifferentialD]t\)\)]],
  ". Dicho de otra forma: la ",
  StyleBox["longitud de la curva",
    FontWeight->"Bold"],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  ", donde ",
  Cell[BoxData[
      \(TraditionalForm\`a \[LessEqual] t \[LessEqual] b\)]],
  ", viene dada por ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Integral]\_a\%b\(\( || \[Gamma]'\) \((t)\) || 
          \[DifferentialD]t\)\)]],
  "."
}], "Text"],

Cell[TextData[{
  "Una curva ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((x(t), y(t))\)\)]],
  " se dice que es ",
  StyleBox["suave",
    FontWeight->"Bold"],
  " si tiene derivada ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[Gamma]' \((t)\) = \((x' \((t)\), y' \((t)\))\)\)]],
  " continua y que no se anula nunca. En tal caso se define el ",
  StyleBox["vector",
    FontWeight->"Bold"],
  " ",
  StyleBox["tangente unitario",
    FontWeight->"Bold"],
  " como"
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["T",
            FontWeight->"Bold",
            FontSlant->"Italic"], \((t)\)}], "=", 
        \(\(\[Gamma]' \((t)\)\)\/\(\( || \[Gamma]' \((t)\) || \)\ \)\)}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "Como ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]T(t)\  | \ T(t)\[RightAngleBracket] = 1\)]],
  ", se deduce que ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[LeftAngleBracket]T' \((t)\)\  | \ T(t)\[RightAngleBracket] = 0\)]],
  ", es decir, supuesto que ",
  Cell[BoxData[
      \(TraditionalForm\`T' \((t)\) \[NotEqual] \((0, 0)\)\)]],
  ", el vector ",
  Cell[BoxData[
      \(TraditionalForm\`T' \((t)\)\)]],
  " es ortogonal al vector tangente. Se define por ello el ",
  StyleBox["vector normal unitario",
    FontWeight->"Bold"],
  " a la curva como "
}], "Text"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          StyleBox["N",
            FontWeight->"Bold",
            FontSlant->"Italic"], \((t)\)}], "=", 
        FractionBox[
          RowBox[{
            StyleBox[\(T'\),
              FontWeight->"Bold",
              FontSlant->"Italic"], \((t)\)}], 
          RowBox[{
            RowBox[{"||", 
              RowBox[{
                StyleBox[\(T'\),
                  FontWeight->"Bold",
                  FontSlant->"Italic"], \((t)\)}], "||"}], " "}]]}], 
      TextForm]], "Text",
  TextAlignment->Center],

Cell["Es f\[AAcute]cil definir comandos que calculen dichos vectores.", "Text"],

Cell[BoxData[{
    \(\(tgtunit[func_, 
          t_] = \(func'\)[t]\/\@\(\(func'\)[t] . \(func'\)[t]\);\)\), "\n", 
    \(normalunit[func_, t_] := 
      Module[{s}, normaliza[D[tgtunit[func, s], s]] /. s -> t]\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(vectgnteunit = 
        Graphics[\n\t\tTable[{{Hue[ .65], 
                vector2D[\[Gamma][t], tgtunit[\[Gamma], t]]}, {Hue[0], 
                PointSize[ .015], Point[\[Gamma][t]]}}, {t, 0, 10  \[Pi], 
              5. }]];\)\), "\n", 
    \(\(vectnormalunit = 
        Graphics[\n\t\tTable[{Hue[ .25], 
              vector2D[\[Gamma][t], normalunit[\[Gamma], t]]}, {t, 0, 
              10  \[Pi], 5. }]];\)\), "\n", 
    \(\(Show[{graf3, vectgnteunit, vectnormalunit}];\)\), "\n", 
    \(Clear[graf3, vectgnteunit, vectnormalunit, vectgnte3]\)}], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .7767 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.455863 0.284658 0.473551 0.284658 [
[.02888 .46105 -12 -9 ]
[.02888 .46105 12 0 ]
[.1712 .46105 -6 -9 ]
[.1712 .46105 6 0 ]
[.31353 .46105 -12 -9 ]
[.31353 .46105 12 0 ]
[.59819 .46105 -9 -9 ]
[.59819 .46105 9 0 ]
[.74052 .46105 -3 -9 ]
[.74052 .46105 3 0 ]
[.88285 .46105 -9 -9 ]
[.88285 .46105 9 0 ]
[.44336 .04656 -24 -4.5 ]
[.44336 .04656 0 4.5 ]
[.44336 .18889 -12 -4.5 ]
[.44336 .18889 0 4.5 ]
[.44336 .33122 -24 -4.5 ]
[.44336 .33122 0 4.5 ]
[.44336 .61588 -18 -4.5 ]
[.44336 .61588 0 4.5 ]
[.44336 .75821 -6 -4.5 ]
[.44336 .75821 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .7767 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02888 .47355 m
.02888 .4798 L
s
[(-1.5)] .02888 .46105 0 1 Mshowa
.1712 .47355 m
.1712 .4798 L
s
[(-1)] .1712 .46105 0 1 Mshowa
.31353 .47355 m
.31353 .4798 L
s
[(-0.5)] .31353 .46105 0 1 Mshowa
.59819 .47355 m
.59819 .4798 L
s
[(0.5)] .59819 .46105 0 1 Mshowa
.74052 .47355 m
.74052 .4798 L
s
[(1)] .74052 .46105 0 1 Mshowa
.88285 .47355 m
.88285 .4798 L
s
[(1.5)] .88285 .46105 0 1 Mshowa
.125 Mabswid
.05734 .47355 m
.05734 .4773 L
s
.08581 .47355 m
.08581 .4773 L
s
.11427 .47355 m
.11427 .4773 L
s
.14274 .47355 m
.14274 .4773 L
s
.19967 .47355 m
.19967 .4773 L
s
.22814 .47355 m
.22814 .4773 L
s
.2566 .47355 m
.2566 .4773 L
s
.28507 .47355 m
.28507 .4773 L
s
.342 .47355 m
.342 .4773 L
s
.37047 .47355 m
.37047 .4773 L
s
.39893 .47355 m
.39893 .4773 L
s
.4274 .47355 m
.4274 .4773 L
s
.48433 .47355 m
.48433 .4773 L
s
.51279 .47355 m
.51279 .4773 L
s
.54126 .47355 m
.54126 .4773 L
s
.56973 .47355 m
.56973 .4773 L
s
.62666 .47355 m
.62666 .4773 L
s
.65512 .47355 m
.65512 .4773 L
s
.68359 .47355 m
.68359 .4773 L
s
.71206 .47355 m
.71206 .4773 L
s
.76899 .47355 m
.76899 .4773 L
s
.79745 .47355 m
.79745 .4773 L
s
.82592 .47355 m
.82592 .4773 L
s
.85438 .47355 m
.85438 .4773 L
s
.00041 .47355 m
.00041 .4773 L
s
.91132 .47355 m
.91132 .4773 L
s
.93978 .47355 m
.93978 .4773 L
s
.96825 .47355 m
.96825 .4773 L
s
.99671 .47355 m
.99671 .4773 L
s
.25 Mabswid
0 .47355 m
1 .47355 L
s
.45586 .04656 m
.46211 .04656 L
s
[(-1.5)] .44336 .04656 1 0 Mshowa
.45586 .18889 m
.46211 .18889 L
s
[(-1)] .44336 .18889 1 0 Mshowa
.45586 .33122 m
.46211 .33122 L
s
[(-0.5)] .44336 .33122 1 0 Mshowa
.45586 .61588 m
.46211 .61588 L
s
[(0.5)] .44336 .61588 1 0 Mshowa
.45586 .75821 m
.46211 .75821 L
s
[(1)] .44336 .75821 1 0 Mshowa
.125 Mabswid
.45586 .07503 m
.45961 .07503 L
s
.45586 .10349 m
.45961 .10349 L
s
.45586 .13196 m
.45961 .13196 L
s
.45586 .16043 m
.45961 .16043 L
s
.45586 .21736 m
.45961 .21736 L
s
.45586 .24582 m
.45961 .24582 L
s
.45586 .27429 m
.45961 .27429 L
s
.45586 .30276 m
.45961 .30276 L
s
.45586 .35969 m
.45961 .35969 L
s
.45586 .38815 m
.45961 .38815 L
s
.45586 .41662 m
.45961 .41662 L
s
.45586 .44508 m
.45961 .44508 L
s
.45586 .50202 m
.45961 .50202 L
s
.45586 .53048 m
.45961 .53048 L
s
.45586 .55895 m
.45961 .55895 L
s
.45586 .58741 m
.45961 .58741 L
s
.45586 .64435 m
.45961 .64435 L
s
.45586 .67281 m
.45961 .67281 L
s
.45586 .70128 m
.45961 .70128 L
s
.45586 .72974 m
.45961 .72974 L
s
.45586 .0181 m
.45961 .0181 L
s
.25 Mabswid
.45586 0 m
.45586 .7767 L
s
0 0 m
1 0 L
1 .7767 L
0 .7767 L
closepath
clip
newpath
% Start of user PostScript
/mathtops {
gsave
MBeginOrig
moveto
MEndOrig
currentpoint
grestore
} bind def
/MAtocoords {
mathtops 4 2 roll mathtops
4 copy pop pop
3 -1 roll sub
/arry exch def
exch sub
/arrx exch def
arrx dup mul
arry dup mul
add sqrt
/arrl exch def
translate
} bind def
/MAarrowhead1 {
gsave
MAtocoords
arrl 0. eq
{ 0 0 Mdot }
{
[ arrx arrl div
arry arrl div
-1 arry mul arrl div
arrx arrl div
0 0 ]
concat
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto fill
-0.05 0.0125 moveto 0 0 lineto
-0.05 -0.0125 lineto
-0.05 0.0125 lineto stroke
} ifelse
grestore
} def
% End of user PostScript
.5 Mabswid
.74052 .47355 m
.74044 .47797 L
.74024 .48198 L
.73985 .48662 L
.73932 .49099 L
.738 .49877 L
.73604 .50719 L
.73323 .51642 L
.72953 .52616 L
.72103 .54347 L
.70983 .56105 L
.69719 .57719 L
.66128 .61246 L
.61573 .64574 L
.56786 .67326 L
.5069 .70123 L
.44795 .72267 L
.39661 .7375 L
.34408 .74904 L
.31582 .75357 L
.30257 .75524 L
.29077 .75645 L
.28038 .75728 L
.27528 .7576 L
.2698 .75787 L
.26441 .75806 L
.26144 .75814 L
.25877 .75818 L
.25367 .75821 L
.24896 .75816 L
.2446 .75805 L
.24003 .75785 L
.23583 .7576 L
.23208 .75731 L
.22376 .75643 L
.21978 .75587 L
.2156 .75517 L
.20815 .7536 L
.2009 .75157 L
.19475 .74932 L
.18976 .747 L
.18559 .74458 L
.18175 .74176 L
.17821 .73838 L
.17558 .735 L
.17459 .7334 L
.17368 .73162 L
.173 .73004 L
.17239 .72826 L
.17183 .72612 L
Mistroke
.17146 .72403 L
.17126 .72192 L
.1712 .71992 L
.17131 .71746 L
.17143 .71619 L
.17162 .71478 L
.17209 .71223 L
.17269 .70979 L
.17461 .70408 L
.17753 .69765 L
.18517 .68505 L
.19463 .6727 L
.2529 .61725 L
.45469 .47433 L
.65105 .33615 L
.68872 .30387 L
.71542 .27639 L
.72609 .26273 L
.73333 .25109 L
.73622 .24516 L
.73847 .23921 L
.73931 .23623 L
.7399 .23354 L
.74015 .23202 L
.74032 .23067 L
.74045 .22913 L
.74051 .2277 L
.74049 .22554 L
.74029 .22328 L
.73994 .22121 L
.7395 .21937 L
.73881 .21729 L
.73786 .2151 L
.73562 .21133 L
.73255 .20769 L
.72849 .20417 L
.72438 .20144 L
.71916 .19873 L
.71413 .19667 L
.70829 .19475 L
.70126 .19296 L
.69424 .1916 L
.6872 .19058 L
.68025 .18984 L
.67609 .18951 L
.6722 .18928 L
.66759 .18907 L
.66311 .18895 L
.65862 .1889 L
.65367 .18891 L
Mistroke
.64889 .18899 L
.64443 .18913 L
.63911 .18936 L
.63318 .1897 L
.62205 .19055 L
.61002 .19176 L
.59677 .19341 L
.5719 .1973 L
.5203 .2083 L
.47146 .22199 L
.36459 .26357 L
.30923 .29314 L
.26422 .3236 L
.22743 .35586 L
.20071 .38774 L
.18906 .40662 L
.18091 .42411 L
.17745 .43387 L
.17592 .43903 L
.17454 .44453 L
.17352 .44933 L
.17262 .45464 L
.17199 .45947 L
.17156 .46401 L
.17131 .46843 L
.17121 .47316 L
.17127 .47762 L
.17146 .48167 L
.17186 .48643 L
.17216 .48912 L
.17249 .49159 L
.17417 .50093 L
.17643 .50988 L
.17964 .51967 L
.18841 .53927 L
.19841 .556 L
.21153 .57361 L
.24107 .6043 L
.28263 .63686 L
.33575 .669 L
.39188 .69583 L
.44515 .71642 L
.49843 .73306 L
.55422 .74645 L
.58336 .75172 L
.59565 .75354 L
.60873 .75519 L
.61992 .75636 L
.63149 .75729 L
.6377 .75767 L
Mistroke
.64322 .75792 L
.64865 .7581 L
.65367 .75819 L
.65826 .75821 L
.66308 .75815 L
.66753 .75803 L
.67149 .75786 L
.67601 .75759 L
.68078 .75721 L
.68906 .75628 L
.69334 .75565 L
.69708 .75499 L
.70494 .75326 L
.71157 .75133 L
.71722 .74922 L
.72197 .747 L
.72641 .74439 L
.72978 .74193 L
.73288 .73907 L
.73564 .73574 L
.73767 .7324 L
.73864 .73026 L
.73937 .72815 L
.73988 .7262 L
.74026 .724 L
.74047 .7218 L
.74052 .71973 L
.74041 .71739 L
.74012 .71485 L
.73971 .71258 L
.7392 .71043 L
.7376 .70536 L
.7351 .69949 L
.73218 .69393 L
.72339 .68065 L
.69666 .65081 L
.66132 .61931 L
.46875 .48215 L
.36089 .40955 L
.25886 .3347 L
.22293 .30379 L
.19409 .27375 L
.18415 .26057 L
.18027 .25442 L
.17727 .24893 L
.17492 .24377 L
.17328 .23927 L
.17259 .23694 L
.17201 .23448 L
.17156 .23194 L
Mistroke
.17131 .22962 L
.17121 .22724 L
.17126 .22513 L
.17151 .22277 L
.17192 .2206 L
.17244 .21866 L
.17306 .21691 L
.17492 .21315 L
.17613 .2113 L
.17742 .20963 L
.18091 .20605 L
.18505 .20288 L
.1903 .19982 L
.19584 .19734 L
.20265 .19499 L
.21059 .19293 L
.21871 .1914 L
.22288 .19079 L
.22697 .19029 L
.2308 .1899 L
.23497 .18956 L
.23967 .18927 L
.24411 .18907 L
.24903 .18894 L
.25189 .1889 L
.2546 .18889 L
.25966 .18893 L
.26227 .18898 L
.26518 .18906 L
.27041 .18926 L
.27543 .18951 L
.28706 .19033 L
.30012 .19158 L
.32521 .19489 L
.34944 .19906 L
.39806 .20997 L
.45127 .22551 L
.50468 .24497 L
.55984 .26976 L
.60776 .29634 L
.64722 .32338 L
.68566 .35726 L
.70222 .37599 L
.71673 .39639 L
.72662 .41443 L
.73353 .43157 L
.73644 .44146 L
.73843 .45054 L
.73924 .45557 L
.73959 .45822 L
Mistroke
.7399 .46105 L
.74014 .46378 L
.74031 .46624 L
.7405 .47106 L
.74052 .47355 L
Mfstroke
0 .1 1 r
.74052 .47355 m
.74052 .75821 L
s
% Start of user PostScript
1. 0 1. 1. MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.74052 .47355 Mdot
0 .1 1 r
.5 Mabswid
.17405 .73239 m
.04499 .47867 L
s
% Start of user PostScript
-0.989992 0.909297 -1.44338 0.0179815 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.17405 .73239 Mdot
0 .1 1 r
.5 Mabswid
.72918 .25812 m
.88283 .01849 L
s
% Start of user PostScript
0.96017 -0.756802 1.49995 -1.59861 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.72918 .25812 Mdot
0 .1 1 r
.5 Mabswid
.1965 .39401 m
.04241 .63336 L
s
% Start of user PostScript
-0.91113 -0.279415 -1.45246 0.561394 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.1965 .39401 Mdot
0 .1 1 r
.5 Mabswid
.69607 .75518 m
.97619 .70454 L
s
% Start of user PostScript
0.843854 0.989358 1.8279 0.811465 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.69607 .75518 Mdot
0 .1 1 r
.5 Mabswid
.23961 .31869 m
.02381 .13306 L
s
% Start of user PostScript
-0.759688 -0.544021 -1.5178 -1.19615 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.23961 .31869 Mdot
0 .1 1 r
.5 Mabswid
.64383 .32081 m
.87165 .49148 L
s
% Start of user PostScript
0.660317 -0.536573 1.46066 0.0629692 MAarrowhead1
% End of user PostScript
1 0 0 r
.015 w
.64383 .32081 Mdot
.5 1 0 r
.5 Mabswid
.74052 .47355 m
.45586 .47355 L
s
% Start of user PostScript
1. 0 0 0 MAarrowhead1
% End of user PostScript
.17405 .73239 m
.42777 .60333 L
s
% Start of user PostScript
-0.989992 0.909297 -0.0986765 0.455915 MAarrowhead1
% End of user PostScript
.72918 .25812 m
.48956 .10447 L
s
% Start of user PostScript
0.96017 -0.756802 0.118362 -1.29658 MAarrowhead1
% End of user PostScript
.1965 .39401 m
.43585 .54811 L
s
% Start of user PostScript
-0.91113 -0.279415 -0.0703206 0.261915 MAarrowhead1
% End of user PostScript
.69607 .75518 m
.64543 .47506 L
s
% Start of user PostScript
0.843854 0.989358 0.66596 0.0053085 MAarrowhead1
% End of user PostScript
.23961 .31869 m
.42525 .10289 L
s
% Start of user PostScript
-0.759688 -0.544021 -0.107559 -1.30213 MAarrowhead1
% End of user PostScript
.64383 .32081 m
.47316 .54863 L
s
% Start of user PostScript
0.660317 -0.536573 0.0607746 0.26377 MAarrowhead1
% End of user PostScript
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 223.688},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001Cb000`400?l00000o`00003oo`3ooona
0?ooo`00o`3ooona0?ooo`00a`3oool00`000000oooo0?ooo`3V0?ooo`00a`3oool00`000000oooo
0?ooo`3V0?ooo`00a`3oool00`000000oooo0?ooo`3V0?ooo`00a`3oool00`000000oooo0?ooo`3V
0?ooo`00a`3oool00`000000oooo0?ooo`3V0?ooo`00a`3oool00`000000oooo0?ooo`3V0?ooo`00
a`3oool00`000000oooo0?ooo`3V0?ooo`00a`3oool00`000000oooo0?ooo`3V0?ooo`00a`3oool3
00000;<0oooo00<001Wo0?ooo`3oool0<03oool00<L0oooo00<000000?ooo`3oool0/P3oool2000I
oc80oooo00370?ooo`030000003oool0oooo0;40oooo0P006Olc0?ooo`00a`3oool00`000000oooo
0?ooo`2`0?ooo`<001Wo<`3oool00<L0oooo00<000000?ooo`3oool0[`3oool4000Ioc<0oooo0037
0?ooo`030000003oool0oooo0:h0oooo10006Old0?ooo`00a`3oool00`000000oooo0?ooo`2]0?oo
o`D001Wo=03oool00<L0oooo00<000000?ooo`3oool0[03oool6000Ioc@0oooo002X0?ooo`030?oD
V`000000000000<0000000<009_D0?ooo`3oool00P3oool00`3DV`000000002Ke0050?ooo`050=BK
0000000000000000002Ke?l01`3oool00`000000oooo0?ooo`2Z0?ooo`L001Wo=@3oool00:/0oooo
00<0^W9b0;[Zo`3oool01@3oool00`3DV`000000002Ke0040?ooo`070=BK0000Vm@0oooo0?ooo`3o
j[X0LP0009_Do`060?ooo`030000003oool0oooo0:T0oooo20006Ole0?ooo`00Z`3oool00`2jLW80
^^[o0?ooo`0A0?ooo`030?oDV`00Vm@0oooo00D0oooo00<000000?ooo`3oool0Z03oool9000IocD0
oooo002[0?ooo`030;YbLP2jj_l0oooo0140oooo00<0omBK002Ke03oool01@3oool00`000000oooo
0?ooo`2W0?ooo`T001Wo=P3oool009l0oooo00<0^W800000000000000`0000000`00L[X0oooo0?oo
o`030?ooo`030;YbLP2jj_l0oooo0140oooo00<0^W8009_Do`3oool01@3oool400000:D0oooo2P00
6Olf0?ooo`00Z`3oool00`2jLW80^^[o0?ooo`0<0?ooo`030?ooe02K000000000080000000<0L[[Z
0?ooo`3oool01@3oool00`000000oooo0?ooo`2U0?ooo`/001Wo=P3oool00:/0oooo00<0^W9b0;[Z
o`3oool0303oool00`3oom@0V`2K0=Coo`0:0?ooo`030000003oool0oooo0:@0oooo2`006Olg0?oo
o`00Z03oool01@3Z^W800000001b^P2jLW80^^[o00d0oooo00<0oooD09/0V`3Dool02P3oool00`00
0000oooo0?ooo`2S0?ooo``001Wo=`3oool00:X0oooo00<0j[Yb0000LP2jj_l03@3oool00`3oom@0
V`0000000002000000030000V`3Dool0oooo00D0oooo00<000000?ooo`3oool0Y03oool;000IocL0
oooo00370?ooo`030000003oool0oooo0:H0oooo20006Olh0?ooo`00a`3oool00`000000oooo0?oo
o`2W0?ooo`L001Wo>03oool00<L0oooo00<000000?ooo`3oool0Y`3oool00`006Ol0oooo000Io`04
000IocP0oooo00370?ooo`030000003oool0oooo0:H0oooo00@001Wo0?ooo`3oool0oooo0`006Oli
0?ooo`00a`3oool00`000000oooo0?ooo`2U0?ooo`03000Io`3oool0oooo00@0oooo00<001Wo0?oo
o`3oool0=`3oool00<L0oooo00<000000?ooo`3oool0Y@3oool00`006Ol0oooo0?ooo`0n0?ooo`00
a`3oool00`000000oooo0?ooo`2T0?ooo`03000Io`3oool0oooo03l0oooo00370?ooo`<00000X`3o
ool00`006Ol0oooo0?ooo`100?ooo`00a`3oool00`000000oooo0?ooo`2S0?ooo`03000Io`3oool0
oooo0400oooo00370?ooo`030000003oool0oooo0:80oooo00<001Wo0?ooo`3oool0@@3oool00<L0
oooo00<000000?ooo`3oool0XP3oool00`006Ol0oooo0?ooo`110?ooo`00a`3oool00`000000oooo
0?ooo`2Q0?ooo`03000Io`3oool0oooo0480oooo00370?ooo`030000003oool0oooo0:00oooo00<0
01Wo0?ooo`3oool0@`3oool00<L0oooo00<000000?ooo`3oool0X03oool00`006Ol0oooo0?ooo`13
0?ooo`00a`3oool00`000000oooo0?ooo`2O0?ooo`03000Io`3oool0oooo04@0oooo00370?ooo`03
0000003oool0oooo09h0oooo00<001Wo0?ooo`3oool0A@3oool00<L0oooo00<000000?ooo`3oool0
WP3oool00`006Ol0oooo0?ooo`150?ooo`00a`3oool00`000000oooo0?ooo`2M0?ooo`03000Io`3o
ool0oooo04H0oooo00370?ooo`030000003oool0oooo09`0oooo00<001Wo0?ooo`3oool0A`3oool0
0;X0oooo00<0Ool00?ooo`3oool02P3oool3000009`0oooo00<001Wo0?ooo`3oool0A`3oool00;P0
oooo0P1oo`0=0?ooo`030000003oool0oooo00/0oooo0P1oo`2>0?ooo`03000Io`3oool0oooo04P0
oooo002g0?ooo`<0Ool03@3oool00`000000oooo0?ooo`0<0?ooo`@0Ool0RP3oool00`006Ol0oooo
0?ooo`190?ooo`00]P3oool307oo00h0oooo00<000000?ooo`3oool03@3oool607oo08L0oooo00<0
01Wo0?ooo`3oool0B@3oool00;@0oooo1@1oo`0>0?ooo`030000003oool0oooo00h0oooo201oo`23
0?ooo`03000Io`3oool0oooo04X0oooo002c0?ooo`D0Ool03`3oool00`000000oooo0?ooo`0?0?oo
o`X0Ool0O`3oool00`006Ol0oooo0?ooo`1;0?ooo`00/P3oool607oo00l0oooo00<000000?ooo`3o
ool0403oool<07oo07`0oooo00<001Wo0?ooo`3oool0B`3oool00;00oooo1`1oo`0@0?ooo`030000
003oool0oooo0140oooo3P1oo`1h0?ooo`03000Io`3oool0oooo04`0oooo002_0?ooo`P0Ool0403o
ool00`000000oooo0?ooo`0B0?ooo`l0Ool0MP3oool00`006Ol0oooo0?ooo`1<0?ooo`00[@3oool9
07oo0140oooo00<000000?ooo`3oool04P3oool>07oo07H0oooo00<001Wo0?ooo`3oool0C@3oool0
0:`0oooo2P1oo`0A0?ooo`030000003oool0oooo01<0oooo3@1oo`1e0?ooo`03000Io`3oool0oooo
04h0oooo002[0?ooo`X0Ool04P3oool00`000000oooo0?ooo`0D0?ooo`/0Ool0MP3oool00`006Ol0
oooo0?ooo`1>0?ooo`00Z@3oool<07oo0180oooo0`00000E0?ooo`T0Ool0MP3oool00`006Ol0oooo
0?ooo`1?0?ooo`003`3oool00`006Ol0oooo0?ooo`2F0?ooo``0Ool04`3oool00`000000oooo0?oo
o`0F0?ooo`T0Ool0M03oool00`006Ol0oooo0?ooo`1@0?ooo`00403oool2000IoiL0oooo2`1oo`0C
0?ooo`030000003oool0oooo01L0oooo1P1oo`020?ooo`80Ool0LP3oool00`006Ol0oooo0?ooo`1@
0?ooo`00403oool4000IoiH0oooo2@1oo`0D0?ooo`030000003oool0oooo01P0oooo101oo`050?oo
o`0307oo003oool0oooo06h0oooo00<001Wo0?ooo`3oool0D@3oool00140oooo1@006OnF0?ooo`L0
Ool0503oool00`000000oooo0?ooo`0I0?ooo`<0Ool01P3oool207oo06d0oooo00<001Wo0?ooo`3o
ool0DP3oool00180oooo1P006OnC0?ooo`0307oo003oool0Ool000@0Ool05@3oool00`000000oooo
0?ooo`0J0?ooo`0307oo003oool0oooo00L0oooo00<0Ool00?ooo`3oool0JP3oool00`006Ol0oooo
0?ooo`1B0?ooo`004`3oool7000Ioi40oooo00<0Ool00?ooo`3oool0101oo`0E0?ooo`030000003o
ool0oooo02D0oooo0P1oo`1Y0?ooo`03000Io`3oool0oooo05<0oooo000C0?ooo`T001WoSP3oool0
0`1oo`00oooo0?ooo`030?ooo`0307oo003oool0oooo01@0oooo00<000000?ooo`3oool09`3oool2
07oo06H0oooo00<001Wo0?ooo`3oool0E03oool001@0oooo2P006On;0?ooo`0307oo003oool0oooo
01/0oooo00<000000?ooo`3oool0:@3oool00`1oo`00oooo0?ooo`1S0?ooo`03000Io`3oool0oooo
05@0oooo000E0?ooo`/001WoR03oool00`1oo`00oooo0?ooo`0L0?ooo`030000003oool0oooo02X0
oooo0P1oo`1R0?ooo`03000Io`3oool0oooo05D0oooo000E0?ooo`d001WoQ@3oool00`1oo`00oooo
0?ooo`0M0?ooo`030000003oool0oooo02`0oooo00<0Ool00?ooo`3oool0GP3oool00`006Ol0oooo
0?ooo`1F0?ooo`005P3oool>000Ioh80oooo00<0Ool00?ooo`3oool07P3oool00`000000oooo0?oo
o`0]0?ooo`80Ool0GP3oool00`006Ol0oooo0?ooo`1F0?ooo`005`3oool<000Ioh80oooo00<0Ool0
0?ooo`3oool07`3oool3000002l0oooo00<0Ool00?ooo`3oool0FP3oool00`006Ol0oooo0?ooo`1G
0?ooo`00603oool:000Ioh<0oooo00<0Ool00?ooo`3oool07`3oool00`000000oooo0?ooo`0`0?oo
o`80Ool0FP3oool00`006Ol0oooo0?ooo`1G0?ooo`00603oool9000Ioh<0oooo00<0Ool00?ooo`3o
ool0803oool00`000000oooo0?ooo`0b0?ooo`80Ool0E`3oool00`006Ol0oooo0?ooo`1H0?ooo`00
6@3oool7000Ioh<0oooo00<0Ool00?ooo`3oool08@3oool00`000000oooo0?ooo`0d0?ooo`0307oo
003oool0oooo05<0oooo00<001Wo0?ooo`3oool0F@3oool001X0oooo20006On00?ooo`0307oo003o
ool0oooo0280oooo00<000000?ooo`3oool0=@3oool207oo05<0oooo00<001Wo0?ooo`3oool0F@3o
ool001/0oooo10006Ol30?ooo`03000Io`3oool0oooo07`0oooo00<0Ool00?ooo`3oool08`3oool0
0`000000oooo0?ooo`0g0?ooo`0307oo003oool0oooo04l0oooo00<001Wo0?ooo`3oool0FP3oool0
01/0oooo0`006Ol50?ooo`03000Io`3oool0oooo07X0oooo00<0Ool00?ooo`3oool0903oool00`00
0000oooo0?ooo`0h0?ooo`80Ool0CP3oool00`006Ol0oooo0?ooo`1K0?ooo`00703oool00`006Ol0
oooo0?ooo`050?ooo`03000Io`3oool0oooo07P0oooo00<0Ool00?ooo`3oool09@3oool00`000000
oooo0?ooo`0j0?ooo`0307oo003oool0oooo04/0oooo00<001Wo0?ooo`3oool0F`3oool002D0oooo
00<001Wo0?ooo`3oool0M`3oool00`1oo`00oooo0?ooo`0U0?ooo`030000003oool0oooo03/0oooo
0P1oo`1:0?ooo`03000Io`3oool0oooo05`0oooo000V0?ooo`03000Io`3oool0oooo07D0oooo00<0
Ool00?ooo`3oool06@3oool00`3oe9/000000000000300000003002Ke03oool0oooo00@0oooo00<0
00000?ooo`3oool0?@3oool00`1oo`00oooo0?ooo`160?ooo`03000Io`3oool0oooo05d0oooo000W
0?ooo`8001WoM03oool00`1oo`00oooo0?ooo`0M0?ooo`030;YbLP2jj_l0oooo00L0oooo00<00000
0?ooo`3oool0?P3oool207oo04H0oooo00<001Wo0?ooo`3oool0G@3oool002T0oooo00<001Wo0?oo
o`3oool0L03oool00`1oo`00oooo0?ooo`0N0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?oo
o`3oool0@03oool207oo04<0oooo00<001Wo0?ooo`3oool0GP3oool002X0oooo00<001Wo0?ooo`3o
ool0@03oool:000002@0oooo00<0Ool00?ooo`3oool07`3oool00`2jLW80^^[o0?ooo`070?ooo`@0
0000@@3oool00`1oo`00oooo0?ooo`0:0?ooo`T00000;03oool00`006Ol0oooo0?ooo`1O0?ooo`00
:`3oool00`006Ol0oooo0?ooo`0c0?ooo``000002P3oool;000001P0oooo00<0Ool00?ooo`3oool0
503oool00`2jLP0000000000000300000003001b^P3oool0oooo00<0oooo00<0^W9b0;[Zo`3oool0
1`3oool00`000000oooo0?ooo`120?ooo`030000001oo`00Ool000X000002@3oool9000002<0oooo
00<001Wo0?ooo`3oool0G`3oool002`0oooo00<001Wo0?ooo`3oool0;`3oool300000240oooo2@00
000>0?ooo`0307oo003oool0oooo0240oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?oo
o`0g0?ooo`/000000`3oool00`1oo`00oooo0?ooo`0I0?ooo`H00000703oool00`006Ol0oooo0?oo
o`1P0?ooo`00;@3oool00`006Ol0oooo0?ooo`0[0?ooo`<00000;@3oool8000000H0oooo00<0Ool0
0?ooo`3oool08@3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo0340oooo1P00000?
0?ooo`80Ool07`3oool3000001P0oooo00<001Wo0?ooo`3oool0H@3oool002h0oooo0P006OlX0?oo
o`<00000>03oool50000000307oo003oool0oooo01l0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`08
0?ooo`030000003oool0oooo02`0oooo1@00000G0?ooo`0307oo003oool0oooo01l0oooo0P00000F
0?ooo`03000Io`3oool0oooo0640oooo000`0?ooo`03000Io`3oool0oooo02<0oooo0P00000o0?oo
o`0307oo00000000000000<000007`3oool00`3Z^W80001b0;[Zo`080?ooo`030000003oool0oooo
02P0oooo1000000M0?ooo`80Ool08@3oool2000001<0oooo00<001Wo0?ooo`3oool0HP3oool00340
oooo00<001Wo0?ooo`3oool0803oool200000400oooo00<0Ool00?ooo`3oool0103oool5000002D0
oooo00<000000?ooo`3oool0903oool4000002<0oooo0P1oo`0Q0?ooo`8000004@3oool00`006Ol0
oooo0?ooo`1R0?ooo`00<P3oool00`006Ol0oooo0?ooo`0N0?ooo`030000003oool0oooo03l0oooo
00<0Ool00?ooo`3oool02P3oool6000001l0oooo00<000000?ooo`3oool07`3oool5000002T0oooo
00<0Ool00?ooo`3oool0803oool2000000h0oooo00<001Wo0?ooo`3oool0H`3oool003<0oooo00<0
01Wo0?ooo`3oool0703oool00`000000oooo0?ooo`0o0?ooo`0307oo003oool0oooo0140oooo1@00
000J0?ooo`030000003oool0oooo01/0oooo1000000_0?ooo`80Ool08P3oool2000000/0oooo00<0
01Wo0?ooo`3oool0I03oool003@0oooo00<001Wo0?ooo`3oool06P3oool00`000000oooo0?ooo`0o
0?ooo`0307oo003oool0oooo01L0oooo1000000F0?ooo`030000003oool0oooo01L0oooo1000000e
0?ooo`0307oo003oool0oooo0200oooo00<000000?ooo`3oool02@3oool00`006Ol0oooo0?ooo`1T
0?ooo`00=@3oool2000IoaT0oooo00<000000?ooo`3oool0?`3oool00`1oo`00oooo0?ooo`0L0?oo
o`<000004`3oool00`000000oooo0?ooo`0C0?ooo`@00000>P3oool207oo0240oooo00<000000?oo
o`3oool01`3oool00`006Ol0oooo0?ooo`1U0?ooo`00=`3oool00`006Ol0oooo0?ooo`0F0?ooo`03
0000003oool0oooo03l0oooo00<0Ool00?ooo`3oool07`3oool300000100oooo00<000000?ooo`3o
ool03`3oool400000400oooo00<0Ool00?ooo`3oool07P3oool00`000000oooo0?ooo`060?ooo`03
000Io`3oool0oooo06H0oooo000h0?ooo`03000Io`3oool0oooo01@0oooo00<000000?ooo`3oool0
?`3oool00`1oo`00oooo0?ooo`0S0?ooo`<000003@3oool00`000000oooo0?ooo`0;0?ooo`@00000
A@3oool207oo01l0oooo00<000000?ooo`3oool01@3oool00`006Ol0oooo0?ooo`1V0?ooo`00>@3o
ool00`006Ol0oooo0?ooo`0C0?ooo`030000003oool0oooo03h0oooo00<0Ool00?ooo`3oool09`3o
ool4000000T0oooo0`0000070?ooo`@00000B`3oool207oo01d0oooo0P0000050?ooo`03000Io`3o
ool0oooo06L0oooo000j0?ooo`03000Io`3oool0oooo0140oooo00<000000?ooo`3oool0?P3oool0
0`1oo`00oooo0?ooo`0/0?ooo`<000001P3oool00`000000oooo0?ooo`030?ooo`@00000D@3oool0
0`1oo`00oooo0?ooo`0K0?ooo`030000003oool0oooo0080oooo00<001Wo0?ooo`3oool0J03oool0
03/0oooo00<001Wo0?ooo`3oool0403oool00`000000oooo0?ooo`0m0?ooo`0307oo003oool0oooo
0300oooo0`0000030?ooo`040000003oool0oooo0?ooo`800000EP3oool207oo01/0oooo00<00000
0?ooo`3oool00P3oool00`006Ol0oooo0?ooo`1X0?ooo`00?03oool00`006Ol0oooo0?ooo`0?0?oo
o`030000003oool0oooo03`0oooo00<0Ool00?ooo`3oool0=03oool7000005X0oooo00<0Ool00?oo
o`3oool0603oool01@000000oooo0?ooo`3oool001Wo06/0oooo000m0?ooo`8001Wo3`3oool00`00
0000oooo0?ooo`0k0?ooo`0307oo003oool0oooo03L0oooo1000001L0?ooo`80Ool0603oool01000
0000oooo0?ooo`006Om/0?ooo`00?`3oool00`006Ol0oooo0?ooo`0<0?ooo`030000003oool0oooo
03/0oooo00<0Ool00?ooo`3oool0=03oool3000000040?ooo`000000oooo0?ooo`<00000F`3oool0
0`1oo`00oooo0?ooo`0E0?ooo`040000003oool0oooo000Iof`0oooo00100?ooo`03000Io`3oool0
oooo00/0oooo00<000000?ooo`3oool0>P3oool00`1oo`00oooo0?ooo`0b0?ooo`<00000103oool0
0`000000oooo0?ooo`030?ooo`<00000F@3oool207oo01D0oooo00<000000?ooo`006Ol0K@3oool0
0440oooo00<001Wo0?ooo`3oool02P3oool00`000000oooo0?ooo`0i0?ooo`0307oo003oool0oooo
0340oooo0P0000070?ooo`030000003oool0oooo00H0oooo0P00001I0?ooo`80Ool04`3oool00`00
000001Wo0?ooo`1]0?ooo`00@P3oool00`006Ol0oooo0?ooo`0:0?ooo`030000003oool0oooo03L0
oooo00<0Ool00?ooo`3oool0;`3oool3000000T0oooo00<000000?ooo`3oool0203oool3000005P0
oooo00<0Ool00?ooo`3oool0403oool00`00000001Wo0?ooo`1]0?ooo`00@`3oool00`006Ol0oooo
0?ooo`090?ooo`030000003oool0oooo03H0oooo00<0Ool00?ooo`3oool0;P3oool2000000`0oooo
00<000000?ooo`3oool02`3oool3000005H0oooo0P1oo`0?0?ooo`03000000006Ol0oooo06h0oooo
00140?ooo`8001Wo2@3oool00`000000oooo0?ooo`0e0?ooo`0307oo003oool0oooo02`0oooo0`00
000>0?ooo`030000003oool0oooo00h0oooo0`00001E0?ooo`0307oo003oool0oooo00/0oooo00<0
00000?ooo`006Ol0K`3oool004H0oooo00<001Wo0?ooo`3oool01`3oool00`000000oooo0?ooo`0c
0?ooo`0307oo003oool0oooo02/0oooo0P00000A0?ooo`030000003oool0oooo0140oooo0`00001C
0?ooo`80Ool02`3oool00`00000001Wo0?ooo`1_0?ooo`00A`3oool00`006Ol0oooo0?ooo`060?oo
o`030000003oool0oooo03<0oooo00<0Ool00?ooo`3oool0:03oool3000001<0oooo0`00000D0?oo
o`800000D`3oool00`1oo`00oooo0?ooo`080?ooo`03000Io`3oool0oooo06l0oooo00180?ooo`03
000Io`3oool0oooo00H0oooo00<000000?ooo`3oool0<@3oool00`1oo`00oooo0?ooo`0W0?ooo`80
00005P3oool00`000000oooo0?ooo`0F0?ooo`800000DP3oool207oo00L0oooo00<00000000Io`3o
ool0L03oool004T0oooo00<001Wo0?ooo`3oool01@3oool00`000000oooo0?ooo`0`0?ooo`0307oo
003oool0oooo02D0oooo0`00000H0?ooo`030000003oool0oooo01P0oooo0P00001B0?ooo`80Ool0
1@3oool00`006Ol0oooo0?ooo`1`0?ooo`00BP3oool00`006Ol0oooo0?ooo`050?ooo`030000003o
ool0oooo02h0oooo00<0Ool00?ooo`3oool08`3oool3000001/0oooo00<000000?ooo`3oool06P3o
ool200000580oooo00<0Ool00?ooo`3oool00P3o001c0?ooo`00B`3oool2000Io`H0oooo00<00000
0?ooo`3oool0;03oool00`1oo`00oooo0?ooo`0R0?ooo`8000007P3oool00`000000oooo0?ooo`0L
0?ooo`800000D@3oool207oo00<0o`00LP3oool004d0oooo00<001Wo0?ooo`3oool00`3oool00`00
0000oooo0?ooo`0[0?ooo`0307oo003oool0oooo0200oooo0`00000P0?ooo`030000003oool0oooo
01h0oooo0P00001?0?ooo`80o`0000@0Ool00?l0003o0000o`00L@3oool004h0oooo00<001Wo0?oo
o`3oool00`3oool00`000000oooo0?ooo`0Y0?ooo`0307oo003oool0oooo01l0oooo0P00000S0?oo
o`030000003oool0oooo0200oooo0P00001=0?ooo`H0o`00L@3oool004l0oooo00<001Wo0?ooo`3o
ool00`3oool00`000000oooo0?ooo`0X0?ooo`0307oo003oool0oooo01d0oooo0P00000U0?ooo`03
0000003oool0oooo0280oooo0P00001<0?ooo`@0o`00LP3oool00500oooo00<001Wo0?ooo`3oool0
0P3oool00`000000oooo0?ooo`0W0?ooo`0307oo003oool0oooo01`0oooo0P00000W0?ooo`030000
003oool0oooo02@0oooo0P0000190?ooo`040000003oool0o`000?l007<0oooo001A0?ooo`03000I
o`3oool0oooo0080oooo00<000000?ooo`3oool09@3oool00`1oo`00oooo0?ooo`0K0?ooo`800000
:@3oool00`000000oooo0?ooo`0V0?ooo`800000AP3oool00`000000oooo0?ooo`1e0?ooo`00DP3o
ool2000Io`<0oooo00<000000?ooo`3oool08`3oool00`1oo`00oooo0?ooo`0J0?ooo`800000:`3o
ool00`000000oooo0?ooo`0X0?ooo`800000@`3oool00`000000oooo0?ooo`1f0?ooo`00E03oool0
10006Ol0oooo0?ooo`00000T0?ooo`0307oo003oool0oooo01X0oooo00<000000?ooo`3oool0:`3o
ool00`000000oooo0?ooo`0Z0?ooo`800000@@3oool00`000000oooo0?ooo`1f0?ooo`00E@3oool0
10006Ol0oooo0?ooo`00000R0?ooo`0307oo003oool0oooo01T0oooo0P00000^0?ooo`<00000;03o
ool2000003h0oooo00<000000?ooo`3oool0M`3oool005H0oooo00@001Wo0?ooo`3oool00000803o
ool00`1oo`00oooo0?ooo`0H0?ooo`800000<03oool00`000000oooo0?ooo`0^0?ooo`800000>`3o
ool00`000000oooo0?ooo`1h0?ooo`00E`3oool010006Ol0oooo0?ooo`00000O0?ooo`0307oo003o
ool0oooo01H0oooo0P00000b0?ooo`030000003oool0oooo0300oooo0P00000h0?ooo`030000003o
ool0oooo07T0oooo001H0?ooo`04000Io`3oool0oooo000001d0oooo00<0Ool00?ooo`3oool05@3o
ool2000003@0oooo00<000000?ooo`3oool0<P3oool2000003D0oooo00<000000?ooo`3oool0NP3o
ool005T0oooo0P006Ol00`3oool000000?ooo`0J0?ooo`0307oo003oool0oooo01D0oooo00<00000
0?ooo`3oool0=03oool00`000000oooo0?ooo`0d0?ooo`800000<P3oool00`000000oooo0?ooo`1k
0?ooo`00F`3oool00`006Ol0oooo0000000I0?ooo`0307oo003oool0oooo01@0oooo0P00000g0?oo
o`030000003oool0oooo03H0oooo0P00000_0?ooo`030000003oool0oooo07`0oooo001L0?ooo`03
000Io`3oool0000001L0oooo00<0Ool00?ooo`3oool04`3oool2000003T0oooo00<000000?ooo`3o
ool0>03oool2000002`0oooo00<000000?ooo`3oool0O@3oool005d0oooo00<001Wo0?ooo`000000
5@3oool00`1oo`00oooo0?ooo`0B0?ooo`800000>`3oool00`000000oooo0?ooo`0j0?ooo`800000
:@3oool00`000000oooo0?ooo`1n0?ooo`00GP3oool00`006Ol0oooo0000000C0?ooo`0307oo003o
ool0oooo0180oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`0l0?ooo`8000009P3o
ool00`000000oooo0?ooo`1o0?ooo`00G`3oool00`006Ol0oooo0000000B0?ooo`0307oo003oool0
oooo0100oooo0P00000n0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool08P3oool0
0`000000oooo0?ooo`200?ooo`00H03oool2000Io`030000003oool0oooo00h0oooo00<0Ool00?oo
o`3oool0403oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo03l0oooo00<000000?oo
o`3oool0803oool00`000000oooo0?ooo`210?ooo`00HP3oool00`006Ol000000?ooo`0=0?ooo`03
07oo003oool0oooo00l0oooo0P0000110?ooo`030000003oool0oooo0400oooo0P00000O0?ooo`03
0000003oool0oooo0880oooo001S0?ooo`03000Io`000000oooo00/0oooo00<0Ool00?ooo`3oool0
3`3oool00`000000oooo0?ooo`110?ooo`<00000@P3oool00`000000oooo0?ooo`0K0?ooo`030000
003oool0oooo08<0oooo001T0?ooo`03000Io`000000oooo00T0oooo00<0Ool00?ooo`3oool03P3o
ool2000004@0oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`0I0?ooo`030000003o
ool0oooo08@0oooo001U0?ooo`03000Io`000000oooo00L0oooo00<0Ool00?ooo`3oool03P3oool0
0`000000oooo0?ooo`140?ooo`030000003oool0oooo04@0oooo0P00000H0?ooo`030000003oool0
oooo08D0oooo001V0?ooo`03000Io`000000000000D0oooo00<0Ool00?ooo`3oool03P3oool00`00
0000oooo0?ooo`150?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`260?ooo`00I`3oool2000Io`030000003o0000o`000080oooo00<0Ool00?ooo`3o
ool0303oool2000004P0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`0A0?ooo`80
0000R@3oool006T0oooo103o00000`1oo`00oooo0?ooo`0<0?ooo`030000003oool0oooo04P0oooo
00<000000?ooo`3oool0B03oool200000080oooo0P3o000<0?ooo`030000003oool0oooo08T0oooo
001X0?ooo`@0o`0000<0Ool00?l0003oool02`3oool2000004/0oooo00<000000?ooo`3oool0BP3o
ool00`000000o`000?l000020?l000X0oooo00<000000?ooo`3oool0RP3oool006P0oooo0`3o0000
0`1oo`00o`000?l0000;0?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool0BP3oool6
0?l000P0oooo00<000000?ooo`3oool0R`3oool006T0oooo103o00000`000000oooo0?ooo`070?oo
o`800000<03oool01@3oe9/00000000000000000VmCo00D0oooo00<0e9/000000000Vm@01@3oool0
1@3DV`000000000000000000VmCo00L0oooo00<000000?ooo`3oool0BP3oool30?l0000307oo003o
0000o`0000L0oooo00<000000?ooo`3oool0S03oool006X0oooo0P3o00020?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0<03oool01P2jLY/0e?oo0?ooo`3oom@0V`2K0=Coo`@0oooo
00<0e9/000000000Vm@0103oool01`3DV`0009_D0?ooo`3oool0onZj0780002Ke?l01P3oool00`00
0000oooo0?ooo`1;0?ooo`050?l0001oo`00o`000?l000006Ol01P3oool00`000000oooo0?ooo`2=
0?ooo`00K`3oool2000000@0oooo00<000000?ooo`3oool0<03oool00`3oe9/009_D0?ooo`020?oo
o`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002Ke03oool01@3oool00`000000oooo0?ooo`1;0?oo
o`0607oo003o0000o`000?ooo`00000001Wo103oool00`000000oooo0?ooo`2>0?ooo`00L@3oool0
10000000oooo00000000000c0?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool03`3o
ool00`3oe9/009_D0?ooo`050?ooo`030000003oool0oooo04/0oooo00<0Ool00?ooo`3oool00P3o
ool00`00000001Wo0?ooo`0200000940oooo001b0?ooo`030000003oool0oooo02X0oooo00<0^W80
0000000000000`0000001@00L[X0oooo0?ooo`3Z^W80L[[Z00<0oooo00<0omBK002Ke03oool03`3o
ool00`2jLP00VmCo0?ooo`050?ooo`@00000B@3oool00`1oo`00oooo0?ooo`050?ooo`8001WoTP3o
ool00740oooo00<000000?ooo`000000=03oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00Vm@0
oooo00X0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`050?ooo`030000003oool0
oooo04T0oooo00<0Ool00?ooo`3oool01@3oool010000000oooo000000006OnA0?ooo`00L03oool0
10000000oooo0?ooo`3oool200000380oooo00<0omBK07:jjP3oool00P3oool00`3Z^W80L[[Z0?oo
o`0:0?ooo`030?ooe02K09/0e?oo00X0oooo00<000000?ooo`3oool0B03oool00`1oo`00oooo0?oo
o`050?ooo`060000003oool0oooo0?ooo`00000001WoT03oool006l0oooo00<000000?ooo`3oool0
103oool00`000000oooo0?ooo`0`0?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3o
om@0V`2K0=Coo`0:0?ooo`030000003oool0oooo04P0oooo00<0Ool00?ooo`3oool00`3oool20000
00D0oooo00<00000000Io`006Ol0SP3oool006d0oooo0P0000080?ooo`030000003oool0oooo02l0
oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K000000000080000000<0002K0=Co
o`3oool01@3oool00`000000oooo0?ooo`170?ooo`0307oo003oool0oooo00<0oooo00<000000?oo
o`3oool01P3oool200000003000Io`3oool0oooo08/0oooo001/0?ooo`030000003oool0oooo00T0
oooo0P00001=0?ooo`030000003oool0oooo04H0oooo00<0Ool00?ooo`3oool00`3oool00`000000
oooo0?ooo`090?ooo`03000000006Ol0oooo08/0oooo001[0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`150?ooo`0307oo003oool0oooo0080oooo
0P00000=0?ooo`03000000006Ol001Wo08X0oooo001Z0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool0B@3oool00`000000oooo0?ooo`150?ooo`0507oo003oool0oooo0?ooo`000000
403oool00`000000oooo000Io`290?ooo`00J03oool200000180oooo0P0000190?ooo`030000003o
ool0oooo04@0oooo00<0Ool00?ooo`3oool00P00000B0?ooo`030000003oool001Wo08P0oooo001W
0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`13
0?ooo`0407oo003oool0oooo000001D0oooo0P000002000IohH0oooo001V0?ooo`030000003oool0
oooo01H0oooo0P0000160?ooo`030000003oool0oooo0480oooo00@0Ool00?ooo`3oool00000603o
ool00`000000oooo000Io`250?ooo`00I@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo04<0oooo00<000000?ooo`3oool0@P3oool00`1oo`0000000000000J0?ooo`030000003oool0
01Wo08@0oooo001T0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0@P3oool30000
0440oooo00<0Ool00000003oool0703oool010000000oooo000Io`006On20?ooo`00I03oool00`00
0000oooo0?ooo`0L0?ooo`800000@P3oool00`000000oooo0?ooo`100?ooo`0307oo00000000oooo
01h0oooo00@000000?ooo`3oool001WoP@3oool006<0oooo00<000000?ooo`3oool07`3oool00`00
0000oooo0?ooo`0o0?ooo`030000003oool0oooo03l0oooo00<0Ool00?ooo`3oool0803oool01000
0000oooo0?ooo`006On00?ooo`00HP3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo
03h0oooo00<000000?ooo`3oool0?P3oool00`000000Ool00?ooo`0Q0?ooo`040000003oool0oooo
0?ooo`8001WoOP3oool00640oooo00<000000?ooo`3oool08`3oool2000003h0oooo00<000000?oo
o`3oool0?03oool20000000307oo003oool0oooo0280oooo00<000000?ooo`3oool00P3oool00`00
6Ol0oooo0?ooo`1k0?ooo`00H03oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo03/0
oooo00<000000?ooo`3oool0>`3oool00`000000oooo07oo000V0?ooo`030000003oool0oooo0080
oooo00<001Wo0?ooo`3oool0NP3oool00600oooo00<000000?ooo`3oool09`3oool2000003/0oooo
00<000000?ooo`3oool0>@3oool2000000030?ooo`1oo`00oooo02L0oooo00<000000?ooo`3oool0
0P3oool2000IogX0oooo001O0?ooo`030000003oool0oooo02X0oooo00<000000?ooo`3oool0>03o
ool00`000000oooo0?ooo`0h0?ooo`050000003oool0oooo0?ooo`1oo`00:@3oool00`000000oooo
0?ooo`030?ooo`03000Io`3oool0oooo07L0oooo001N0?ooo`030000003oool0oooo02`0oooo00<0
00000?ooo`3oool0=`3oool00`000000oooo0?ooo`0f0?ooo`8000000`3oool00`1oo`00oooo0?oo
o`0Y0?ooo`030000003oool0oooo00<0oooo0P006Omg0?ooo`00G@3oool00`000000oooo0?ooo`0^
0?ooo`800000=`3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo0080oooo00<0Ool0
0?ooo`3oool0:P3oool00`000000oooo0?ooo`050?ooo`03000Io`3oool0oooo07@0oooo001M0?oo
o`030000003oool0oooo0300oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0d0?oo
o`030000003oool0oooo0080oooo00<0Ool00?ooo`3oool0;03oool00`000000oooo0?ooo`050?oo
o`03000Io`3oool0oooo07<0oooo001L0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3o
ool0<`3oool00`000000oooo0?ooo`0b0?ooo`800000103oool00`1oo`00oooo0?ooo`0^0?ooo`03
0000003oool0oooo00D0oooo0P006Omc0?ooo`00F03oool20?l000030?ooo`000000oooo03D0oooo
0P00000c0?ooo`<00000<@3oool00`000000oooo0?ooo`040?ooo`0307oo003oool0oooo02h0oooo
00<000000?ooo`3oool01`3oool00`006Ol0oooo0?ooo`1`0?ooo`00E`3oool40?l003T0oooo00<0
00000?ooo`3oool0<03oool00`000000oooo0?ooo`0_0?ooo`8000001P3oool00`1oo`00oooo0?oo
o`0`0?ooo`030000003oool0oooo00L0oooo00<001Wo0?ooo`3oool0K`3oool005H0oooo1P3o000i
0?ooo`800000<03oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo00D0oooo00<0Ool0
0?ooo`3oool0<P3oool00`000000oooo0?ooo`070?ooo`8001WoK`3oool005H0oooo0`3o00000`1o
o`00o`000?l0000k0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0;@3oool00`00
0000oooo0?ooo`050?ooo`0307oo003oool0oooo03<0oooo00<000000?ooo`3oool02@3oool00`00
6Ol0oooo0?ooo`1/0?ooo`00E`3oool30?l00080Ool0?03oool00`000000oooo0?ooo`0/0?ooo`03
0000003oool0oooo02/0oooo0P0000080?ooo`0307oo003oool0oooo03@0oooo00<000000?ooo`3o
ool02@3oool00`006Ol0oooo0?ooo`1[0?ooo`00F03oool20?l00080oooo00<0Ool00?ooo`3oool0
>P3oool2000002`0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`070?ooo`0307oo
003oool0oooo03H0oooo00<000000?ooo`3oool02@3oool2000Iof/0oooo001G0?ooo`03000Io`3o
ool0oooo00<0oooo0P1oo`0l0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0:03o
ool2000000T0oooo00<0Ool00?ooo`3oool0=`3oool00`000000oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo06P0oooo001F0?ooo`03000Io`000000oooo00H0oooo0P1oo`0k0?ooo`030000003oool0
oooo02P0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`080?ooo`0307oo003oool0
oooo03T0oooo00<000000?ooo`3oool02`3oool00`006Ol0oooo0?ooo`1W0?ooo`00EP3oool00`00
6Ol0oooo0?ooo`080?ooo`0307oo003oool0oooo03T0oooo0P00000X0?ooo`030000003oool0oooo
02H0oooo00<000000?ooo`3oool02@3oool00`1oo`00oooo0?ooo`0i0?ooo`030000003oool0oooo
00`0oooo0P006OmW0?ooo`00E@3oool00`006Ol0oooo0?ooo`0:0?ooo`80Ool0>`3oool00`000000
oooo0?ooo`0U0?ooo`030000003oool0oooo02@0oooo0P00000;0?ooo`0307oo003oool0oooo03/0
oooo00<000000?ooo`3oool03@3oool00`006Ol0oooo0?ooo`1T0?ooo`00E03oool00`006Ol00000
0?ooo`0=0?ooo`0307oo003oool0oooo03T0oooo0P00000U0?ooo`030000003oool0oooo02<0oooo
00<000000?ooo`3oool02P3oool00`1oo`00oooo0?ooo`0l0?ooo`030000003oool0oooo00h0oooo
00<001Wo0?ooo`3oool0H`3oool005@0oooo00<001Wo0?ooo`3oool03P3oool207oo03/0oooo00<0
00000?ooo`3oool08P3oool00`000000oooo0?ooo`0Q0?ooo`800000303oool00`1oo`00oooo0?oo
o`0n0?ooo`030000003oool0oooo00h0oooo0P006OmS0?ooo`00D`3oool00`006Ol000000?ooo`0A
0?ooo`0307oo003oool0oooo03T0oooo0P00000R0?ooo`<00000803oool00`000000oooo0?ooo`0<
0?ooo`0307oo003oool0oooo03h0oooo00<000000?ooo`3oool0403oool00`006Ol0oooo0?ooo`1P
0?ooo`00DP3oool00`006Ol000000?ooo`0C0?ooo`80Ool0>`3oool00`000000oooo0?ooo`0O0?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool0303oool00`1oo`00oooo0?ooo`100?oo
o`030000003oool0oooo0100oooo00<001Wo0?ooo`3oool0G`3oool00580oooo00<001Wo0000003o
ool05@3oool207oo03X0oooo0P00000O0?ooo`030000003oool0oooo01d0oooo0P00000>0?ooo`03
07oo003oool0oooo0440oooo00<000000?ooo`3oool04@3oool2000Ioel0oooo001A0?ooo`03000I
o`000000oooo01P0oooo00<0Ool00?ooo`3oool0>@3oool00`000000oooo0?ooo`0L0?ooo`030000
003oool0oooo01`0oooo00<000000?ooo`3oool03@3oool00`1oo`00oooo0?ooo`120?ooo`030000
003oool0oooo01<0oooo00<001Wo0?ooo`3oool0G03oool00540oooo00<001Wo0000003oool06@3o
ool207oo03X0oooo0P00000L0?ooo`030000003oool0oooo01X0oooo0P00000@0?ooo`0307oo003o
ool0oooo04<0oooo00<000000?ooo`3oool04`3oool00`006Ol0oooo0?ooo`1K0?ooo`00D03oool0
0`006Ol0oooo0000000L0?ooo`0307oo003oool0oooo03T0oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`0I0?ooo`030000003oool0oooo00l0oooo00<0Ool00?ooo`3oool0A03oool0
0`000000oooo0?ooo`0D0?ooo`8001WoF`3oool004l0oooo00<001Wo0?ooo`0000007P3oool207oo
03X0oooo0P00000I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool03`3oool00`1o
o`00oooo0?ooo`160?ooo`030000003oool0oooo01D0oooo00<001Wo0?ooo`3oool0F03oool000X0
oooo00<0omBK0000000000000`0000000`00Vm@0oooo0?ooo`020?ooo`030=BK0000000009_D00D0
oooo00D0e9/0000000000000000009_Do`0]0?ooo`03000Io`000000000000<0000000<009_D0?oo
o`3oool06P3oool00`1oo`00oooo0?ooo`0?0?ooo`050?oDV`00000000000000002Ke?l01@3oool0
0`3DV`000000002Ke0050?ooo`050=BK0000000000000000002Ke?l04`3oool00`000000oooo0?oo
o`0F0?ooo`030000003oool0oooo01H0oooo0P00000A0?ooo`0307oo003oool0oooo0080oooo00D0
omBK000000000000000009_Do`050?ooo`030=BK0000000009_D00D0oooo00D0e9/0000000000000
000009_Do`0^0?ooo`H0000000<009_D0?ooo`3oool0403oool00`006Ol0oooo0?ooo`0G0?ooo`03
0?oDV`000000000000<0000000<009_D0?ooo`3oool00P3oool00`3DV`000000002Ke0050?ooo`05
0=BK0000000000000000002Ke?l0:03oool000d0oooo00<0^W9b0;[Zo`3oool01@3oool00`3DV`00
0000002Ke0040?ooo`070=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`0[0?ooo`06000Io`3oool0
oooo0000002jLW80^^[o7`3oool207oo00l0oooo00H0^W:K0=Coo`3oool0oooD09/0V`3Dool40?oo
o`030=BK0000000009_D00@0oooo00L0e9/0002Ke03oool0oooo0?oZ^P1b0000VmCo01<0oooo0P00
000F0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0403oool00`1oo`00oooo0?oo
o`030?ooo`060;YbV`3Dool0oooo0?ooe02K09/0e?oo103oool00`3DV`000000002Ke0040?ooo`07
0=BK0000Vm@0oooo0?ooo`3oj[X0LP0009_Do`0]0?ooo`050000003oool0oooo0;YbLP2jj_l05@3o
ool2000IoaX0oooo00<0^W9b0;[Zo`3oool01@3oool00`3DV`000000002Ke0040?ooo`070=BK0000
Vm@0oooo0?ooo`3oj[X0LP0009_Do`0W0?ooo`003@3oool00`2jLW80^^[o0?ooo`0A0?ooo`030?oD
V`00Vm@0oooo02T0oooo00L001Wo0?ooo`3oool000000?ooo`2jLW80^^[o0240oooo0P1oo`0<0?oo
o`030?oDV`00Vm@0oooo0080oooo00<0j[Yb07:jjP3oool03`3oool00`3oe9/009_D0?ooo`0D0?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool04`3oool2000001<0oooo00<0Ool00?oo
o`3oool00P3oool00`3oe9/009_D0?ooo`020?ooo`030>ZjLP1b^^X0oooo00l0oooo00<0omBK002K
e03oool0;03oool01@000000oooo0?ooo`2jLW80^^[o01L0oooo00<001Wo0?ooo`3oool05`3oool0
0`2jLW80^^[o0?ooo`0A0?ooo`030?oDV`00Vm@0oooo02H0oooo000=0?ooo`030;YbLP2jj_l0oooo
0140oooo00<0omBK002Ke03oool0:@3oool01`006Ol0oooo0?ooo`000000oooo0;YbLP2jj_l08`3o
ool00`1oo`00oooo0?ooo`090?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool03`3o
ool00`3oe9/009_D0?ooo`0E0?ooo`8000004`3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo0180oooo00<0Ool00?ooo`3oool00`3oool00`3Z^W80L[[Z0?ooo`020?ooo`030?oDV`00
Vm@0oooo00l0oooo00<0omBK002Ke03oool0;@3oool010000000oooo0;YbLP2jj_lH0?ooo`8001Wo
5`3oool00`2jLW80^^[o0?ooo`0A0?ooo`030?oDV`00Vm@0oooo02H0oooo00000`3oool0^W800000
000400000003001b^P3oool0oooo00<0oooo00<0^W9b0;[Zo`3oool04@3oool00`2jLP00VmCo0?oo
o`0R0?ooo`030;Yb00000000000000<0000000@001Wo0?ooo`3oool000000P3oool00`2jLW80^^[o
0?ooo`0S0?ooo`80Ool000<0^W800000000000000`0000001@00L[X0oooo0?ooo`3Z^W80L[[Z00<0
oooo00<0omBK002Ke03oool03`3oool00`2jLP00VmCo0?ooo`0G0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0403oool2000001@0oooo00<0Ool00?ooo`3oool0103oool00`3Z^W80
L[[Z0?ooo`020?ooo`030?oDV`00Vm@0oooo00l0oooo00<0^W8009_Do`3oool0;@3oool010000000
oooo0;YbLP2jj_lJ0?ooo`03000Io`3oool0oooo01@0oooo00<0^W9b0;[Zo`3oool04@3oool00`2j
LP00VmCo0?ooo`0V0?ooo`003@3oool00`2jLW80^^[o0?ooo`0<0?ooo`030?ooe02K000000000080
000000<0L[[Z0?ooo`3oool09`3oool01@006Ol0oooo0?ooo`3oool000000080oooo00<0^W9b0;[Z
o`3oool09@3oool00`1oo`00oooo0?ooo`060?ooo`030>ZjLP1b^^X0oooo0080oooo00<0omBK002K
e03oool02P3oool00`3oom@0V`00000000020000000307:jjP3oool0oooo01P0oooo00<000000?oo
o`3oool03`3oool3000000l0oooo00<000000?ooo`3oool04`3oool00`1oo`00oooo0?ooo`050?oo
o`030>ZjLP1b^^X0oooo0080oooo00<0omBK002Ke03oool02P3oool00`3oom@0V`00000000020000
000307:jjP3oool0oooo02d0oooo00@000000?ooo`2jLW80^^[o6`3oool00`006Ol0oooo0?ooo`0C
0?ooo`030;YbLP2jj_l0oooo00`0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`0V
0?ooo`003@3oool00`2jLW80^^[o0?ooo`0<0?ooo`030?ooe02K09/0e?oo02`0oooo00D001Wo0?oo
o`3oool0oooo000000020?ooo`030;YbLP2jj_l0oooo02H0oooo0P1oo`060?ooo`030?oDV`1b^^X0
oooo0080oooo00<0j[Yb07:jjP3oool02P3oool00`3oom@0V`2K0=Coo`0N0?ooo`8000003`3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01@0oooo00<0Ool00?ooo`3oool01@3oool0
0`3oe9/0L[[Z0?ooo`020?ooo`030>ZjLP1b^^X0oooo00X0oooo00<0oooD09/0V`3Dool0<P3oool0
10000000oooo0;YbLP2jj_lL0?ooo`8001Wo4`3oool00`2jLW80^^[o0?ooo`0<0?ooo`030?ooe02K
09/0e?oo02/0oooo000:0?ooo`050>ZjLP00000007:j0;YbLP2jj_l03@3oool00`3oom@0V`2K0=Co
o`0[0?ooo`03000Io`3oool0oooo0080oooo0P0000000`00L[X0^W9b0;[Zo`0Y0?ooo`0307oo003o
ool0oooo00@0oooo00H0^W8009_Do`3oool0onZj0780V`3Dool;0?ooo`030?ooe02K09/0e?oo0200
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<0?ooo`8000005P3oool00`1oo`00
oooo0?ooo`070?ooo`060;Yb002Ke?l0oooo0?oZ^P1b09/0e?oo2`3oool00`3oom@0V`2K0=Coo`0a
0?ooo`050>ZjLP00000000000;YbLP2jj_l07P3oool00`006Ol0oooo0?ooo`0=0?ooo`050>ZjLP00
000007:j0;YbLP2jj_l03@3oool00`3oom@0V`2K0=Coo`0[0?ooo`00303oool00`3Z^W80001b0;[Z
o`0=0?ooo`030?ooe02K000000000080000000<0002K0=Coo`3oool09@3oool00`006Ol0oooo0?oo
o`030?ooo`050000003oool0j[Yb0000LP2jj_l0:P3oool207oo00@0oooo00D0oooD09/000000000
001b0;[Zo`0<0?ooo`030?ooe02K000000000080000000<0002K0=Coo`3oool0703oool2000000`0
oooo00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0E0?ooo`0307oo003oool0oooo00P0
oooo00D0oooD09/000000000001b0;[Zo`0<0?ooo`030?ooe02K000000000080000000<0002K0=Co
o`3oool0;P3oool00`000000001b0;[Zo`0O0?ooo`03000Io`3oool0oooo00H0oooo00<001Wo0?oo
o`3oool01@3oool00`3Z^W80001b0;[Zo`0=0?ooo`030?ooe02K000000000080000000<0002K0=Co
o`3oool09P3oool004T0oooo00<001Wo0?ooo`3oool00`3oool00`000000oooo0?ooo`0^0?ooo`80
Ool0>@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo0P00000G0?ooo`03
07oo003oool0oooo0500oooo00<000000?ooo`3oool0803oool2000Io`D0oooo0`006Om40?ooo`00
B03oool00`006Ol0oooo0?ooo`030?ooo`030000003oool0oooo0340oooo00<0Ool00?ooo`3oool0
=`3oool2000000T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0G0?ooo`0307oo
003oool0oooo0540oooo00<000000?ooo`3oool08@3oool00`006Ol0oooo0?ooo`020?ooo`@001Wo
@`3oool004L0oooo00<001Wo0?ooo`3oool0103oool00`000000oooo0?ooo`0b0?ooo`80Ool0>@3o
ool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool05`3o
ool00`1oo`00oooo0?ooo`1B0?ooo`030000003oool0oooo0280oooo00<001Wo0?ooo`3oool01@00
6Om30?ooo`00A`3oool00`006Ol0oooo0?ooo`040?ooo`030000003oool0oooo03@0oooo00<0Ool0
0?ooo`3oool0=`3oool2000000H0oooo00<000000?ooo`3oool01@3oool2000000T0oooo0`1oo`0=
0?ooo`0307oo003oool0oooo05<0oooo00<000000?ooo`3oool08`3oool8000Iod80oooo00160?oo
o`03000Io`3oool0oooo00D0oooo00<000000?ooo`3oool0=@3oool207oo03T0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo00D0oooo1`1oo`0<0?oo
o`0307oo003oool0oooo05@0oooo00<000000?ooo`3oool0903oool8000Iod40oooo00150?ooo`03
000Io`3oool0oooo00H0oooo00<000000?ooo`3oool0=`3oool00`1oo`00oooo0?ooo`0g0?ooo`80
00000`3oool00`000000oooo0?ooo`020?ooo`800000103oool;07oo00`0oooo00<0Ool00?ooo`3o
ool0E03oool00`000000oooo0?ooo`0S0?ooo`X001Wo@03oool004D0oooo00<001Wo0?ooo`3oool0
1P3oool00`000000oooo0?ooo`0h0?ooo`80Ool0>@3oool010000000oooo0?ooo`0000030?ooo`03
0000003oool0oooo00l0Ool02`3oool00`1oo`00oooo0?ooo`1D0?ooo`80o`00903oool<000Iocl0
oooo00140?ooo`03000Io`3oool0oooo00L0oooo00<000000?ooo`3oool0>P3oool00`1oo`00oooo
0?ooo`0g0?ooo`<000000P3ooolC07oo00X0oooo00<0Ool00?ooo`3oool0E03oool40?l002<0oooo
3@006Oln0?ooo`001@3oooln00000003000Io`000000000004H000000P1oo`0i000007X0Ool00P3o
000Q000000h001Wo?@0000010?ooo`001@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00T0oooo00<00000000Io`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool00P1oo`070?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo0P00000D
07oo0080oooo00<000000?ooo`3oool0103oool00`1oo`00oooo0?ooo`020?ooo`030000003oool0
oooo00X0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00D0oooo00D0Ool00?ooo`3oool0oooo0000000;0?ooo`030000003oool0oooo00T0oooo00<0
00000?ooo`3oool01P3oool60?l000T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`090?ooo`030000003oool001Wo00`001Wo2P3oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`4000000@3o
ool10?ooo`001@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<001Wo
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool00P3oool00`1oo`00oooo0?ooo`040?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00L0oooo0`000002
0?ooo`030000003oool0oooo0100Ool00P3oool00`000000oooo0?ooo`030?ooo`0307oo003oool0
oooo00<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool01@3oool01@1oo`00oooo0?ooo`3oool0000000/0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`070?ooo`@0o`002P3oool00`000000oooo0?oo
o`090?ooo`030000003oool0oooo00T0oooo00@000000?ooo`3oool0oooo30006Ol90?ooo`030000
003oool0oooo00T0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo00T0oooo0@0000010?ooo`40oooo000B0?ooo`030000003oool0oooo00<0oooo00<0
01Wo0?ooo`3oool09P3oool00`006Ol0oooo0?ooo`0:0?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool00`3oool207oo0340oooo00@000000?ooo`3oool000000`3oool2000000<0oooo
3@1oo`070?ooo`0307oo003oool0oooo01d0oooo00<000000?ooo`3oool04@3oool207oo02D0oooo
0P3o000Z0?ooo`X001Wo203oool00`000000oooo0?ooo`0`0?ooo`00603oool2000IobL0oooo00<0
01Wo0?ooo`3oool02P3oool00`000000oooo0?ooo`120?ooo`0307oo003oool0oooo02d0oooo00D0
00000?ooo`3oool0oooo000000050?ooo`030000003oool0oooo00@0oooo2@1oo`060?ooo`0307oo
003oool0oooo0380oooo0P1oo`0V0?ooo`03000Io`3oool0oooo02X0oooo2@006Olj0?ooo`00603o
ool3000IobD0oooo00<001Wo0?ooo`3oool02`3oool00`000000oooo0?ooo`130?ooo`80Ool0:`3o
ool2000000@0oooo00<000000?ooo`3oool0103oool2000000L0oooo1P1oo`060?ooo`0307oo003o
ool0oooo0380oooo0`1oo`0U0?ooo`03000Io`3oool0oooo02d0oooo1`006Oli0?ooo`006@3oool3
000Iob@0oooo00<001Wo0?ooo`3oool02`3oool00`000000oooo0?ooo`150?ooo`0307oo003oool0
oooo02L0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00P0oooo0P1oo`050?ooo`0307oo003oool0oooo03<0oooo0`1oo`0U0?ooo`03000Io`3oool0
oooo02l0oooo1@006Oli0?ooo`006@3oool4000Iob80oooo00<001Wo0?ooo`3oool0303oool00`00
0000oooo0?ooo`160?ooo`80Ool09@3oool2000000L0oooo00<000000?ooo`3oool01`3oool00`00
0000oooo0?ooo`0=0?ooo`0307oo003oool0oooo03<0oooo1@1oo`0T0?ooo`03000Io`3oool0oooo
0380oooo0`006Olh0?ooo`006@3oool5000Iob00oooo00<001Wo0?ooo`3oool03P3oool00`000000
oooo0?ooo`170?ooo`80Ool08P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00P0
oooo0P00000<0?ooo`0307oo003oool0oooo03@0oooo1@1oo`0T0?ooo`03000Io`3oool0oooo03@0
oooo0P006Olg0?ooo`006@3oool6000Ioal0oooo00<001Wo0?ooo`3oool03P3oool00`000000oooo
0?ooo`190?ooo`0307oo003oool0oooo01h0oooo00<000000?ooo`3oool0203oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo00P0oooo00<0Ool00?ooo`3oool0=@3oool607oo02<0oooo
00<001Wo0?ooo`3oool0K@3oool001X0oooo1P006OlM0?ooo`03000Io`3oool0oooo00l0oooo00<0
00000?ooo`3oool0BP3oool207oo01`0oooo0P00000;0?ooo`030000003oool0oooo00/0oooo0P00
00080?ooo`0307oo003oool0oooo03D0oooo1P1oo`0R0?ooo`03000000006Ol0oooo06h0oooo000J
0?ooo`H001Wo703oool00`006Ol0oooo0?ooo`0@0?ooo`030000003oool0oooo04`0oooo00<0Ool0
0?ooo`3oool0603oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0103oool00`1oo`00oooo0?ooo`0f0?ooo`H0Ool08P3oool00`00000001Wo0?ooo`1^
0?ooo`006P3oool7000Ioa/0oooo00<001Wo0?ooo`3oool0403oool00`000000oooo0?ooo`1=0?oo
o`80Ool05P3oool2000000h0oooo00<000000?ooo`3oool03@3oool00`1oo`0000000?ooo`030?oo
o`0307oo003oool0oooo03L0oooo1`1oo`0Q0?ooo`03000000006Ol0oooo06h0oooo000J0?ooo`P0
01Wo6@3oool00`006Ol0oooo0?ooo`0A0?ooo`030000003oool0oooo04l0oooo00<0Ool00?ooo`3o
ool04P3oool00`000000oooo0?ooo`0>0?ooo`<000003@3oool207oo0080000000<0oooo07oo003o
ool0>@3oool707oo0200oooo00<000000?ooo`006Ol0K`3oool001/0oooo20006OlG0?ooo`03000I
o`3oool0oooo0180oooo00<000000?ooo`3oool0D03oool207oo0100oooo0P00000A0?ooo`030000
003oool0oooo00`0oooo101oo`000`3oool0000007oo000j0?ooo`P0Ool07`3oool00`000000oooo
000Io`1_0?ooo`006`3oool9000IoaH0oooo00<001Wo0?ooo`3oool04`3oool00`000000oooo0?oo
o`1A0?ooo`80Ool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00`0oooo1P1o
o`02000003T0oooo201oo`0O0?ooo`030000003oool001Wo06l0oooo000K0?ooo`X001Wo503oool0
0`006Ol0oooo0?ooo`0D0?ooo`030000003oool0oooo05<0oooo00<0Ool00?ooo`3oool01`3oool0
0`1oo`00oooo0000000D0?ooo`030000003oool0oooo00/0oooo201oo`000`3oool000000?ooo`0g
0?ooo`T0Ool07P3oool00`000000oooo000Io`1_0?ooo`006`3oool;000Ioa80oooo00<001Wo0?oo
o`3oool05@3oool00`000000oooo0?ooo`1D0?ooo`80Ool01P3oool307oo01D0oooo00<000000?oo
o`3oool02`3oool907oo00030?ooo`000000oooo03H0oooo2@1oo`0M0?ooo`040000003oool0oooo
000Iofl0oooo000L0?ooo`/001Wo4@3oool00`006Ol0oooo0?ooo`0F0?ooo`030000003oool0oooo
05D0oooo00<0Ool00?ooo`3oool00`3oool407oo01@0oooo00<000000?ooo`3oool02P3oool;07oo
00030?ooo`000000000003@0oooo2`1oo`0L0?ooo`040000003oool0oooo000Iofl0oooo000L0?oo
o``001Wo3`3oool00`006Ol0oooo0?ooo`0G0?ooo`030000003oool0oooo05H0oooo0P1oo`000`3o
ool0000007oo000507oo01<0oooo00<000000?ooo`3oool02P3oool<07oo0080oooo00<000000?oo
o`3oool0<@3oool;07oo01`0oooo00@000000?ooo`3oool001WoK`3oool001`0oooo2`006Ol?0?oo
o`03000Io`3oool0oooo01T0oooo00<000000?ooo`3oool0E`3oool907oo0180oooo00<000000?oo
o`3oool02@3oool<07oo00@0oooo0P00000a0?ooo``0Ool06P3oool01@000000oooo0?ooo`3oool0
01Wo06l0oooo000L0?ooo`T001Wo4@3oool00`006Ol0oooo0?ooo`0I0?ooo`030000003oool0oooo
05H0oooo00<000000?ooo`1oo`00201oo`0A0?ooo`030000003oool0oooo00T0oooo2`1oo`070?oo
o`030000003oool0oooo02h0oooo301oo`0J0?ooo`050000003oool0oooo0?ooo`006Ol0K`3oool0
01d0oooo1P006OlB0?ooo`03000Io`3oool0oooo01/0oooo00<000000?ooo`3oool0D`3oool20000
00030?ooo`1oo`00Ool000T0Ool0403oool00`000000oooo0?ooo`080?ooo`X0Ool02P3oool00`00
0000oooo0?ooo`0]0?ooo`T0Ool0703oool00`000000oooo0?ooo`020?ooo`03000Io`3oool0oooo
06d0oooo000M0?ooo`@001Wo00<0oooo000Io`3oool0403oool00`006Ol0oooo0?ooo`0L0?ooo`03
0000003oool0oooo0580oooo00<000000?ooo`3oool03@1oo`0?0?ooo`030000003oool0oooo00P0
oooo2@1oo`0<0?ooo`800000;@3oool307oo00<0oooo00<0Ool00?ooo`3oool0703oool00`000000
oooo0?ooo`020?ooo`03000Io`3oool0oooo06d0oooo000M0?ooo`8001Wo103oool00`006Ol0oooo
0?ooo`0>0?ooo`03000Io`3oool0oooo01`0oooo00<000000?ooo`3oool0D03oool2000000<0oooo
3@1oo`0?0?ooo`030000003oool0oooo00P0oooo201oo`0?0?ooo`030000003oool0oooo0300oooo
00<0Ool00?ooo`3oool0703oool00`000000oooo0?ooo`020?ooo`03000Io`3oool0oooo06d0oooo
000S0?ooo`03000Io`3oool0oooo00d0oooo00<001Wo0?ooo`3oool07P3oool00`000000oooo0?oo
o`1>0?ooo`030000003oool0oooo0080oooo3`1oo`0>0?ooo`<000001`3oool707oo0180oooo0P00
000`0?ooo`0307oo003oool0oooo01/0oooo00<000000?ooo`3oool00`3oool00`006Ol0oooo0?oo
o`1]0?ooo`00903oool00`006Ol0oooo0?ooo`0;0?ooo`03000Io`3oool0oooo01l0oooo00<00000
0?ooo`3oool0C@3oool00`000000oooo0?ooo`050?ooo`h0Ool03@3oool00`000000oooo0?ooo`07
0?ooo`H0Ool05@3oool00`000000oooo0?ooo`0]0?ooo`0307oo003oool0oooo01/0oooo00<00000
0?ooo`3oool00`3oool00`006Ol0oooo0?ooo`1]0?ooo`00903oool00`006Ol0oooo0?ooo`0;0?oo
o`03000Io`3oool0oooo0200oooo00<000000?ooo`3oool0BP3oool2000000/0oooo301oo`0<0?oo
o`030000003oool0oooo00H0oooo1P1oo`0G0?ooo`030000003oool0oooo02d0oooo00<0Ool00?oo
o`3oool06@3oool00`000000oooo0?ooo`040?ooo`03000Io`3oool0oooo06d0oooo000U0?ooo`03
000Io`3oool0oooo00T0oooo00<001Wo0?ooo`3oool08@3oool00`000000oooo0?ooo`190?ooo`03
0000003oool0oooo00h0oooo2P1oo`0;0?ooo`030000003oool0oooo00H0oooo101oo`0J0?ooo`80
0000;@3oool00`1oo`00oooo0?ooo`0I0?ooo`030000003oool0oooo00@0oooo00<001Wo0?ooo`3o
ool0K@3oool002D0oooo00<001Wo0?ooo`3oool0203oool00`006Ol0oooo0?ooo`0S0?ooo`030000
003oool0oooo04H0oooo0P00000D0?ooo`P0Ool02P3oool00`000000oooo0?ooo`050?ooo`@0Ool0
7@3oool00`000000oooo0?ooo`0Z0?ooo`0307oo003oool0oooo01P0oooo00<000000?ooo`3oool0
1@3oool00`006Ol0oooo0?ooo`1]0?ooo`009P3oool00`006Ol0oooo0?ooo`070?ooo`03000Io`3o
ool0oooo02<0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0G0?ooo`H0Ool02@3o
ool00`000000oooo0?ooo`050?ooo`<0Ool07`3oool2000002X0oooo00<0Ool00?ooo`3oool0603o
ool00`000000oooo0?ooo`050?ooo`03000Io`3oool0oooo06d0oooo000V0?ooo`03000Io`3oool0
oooo00H0oooo00<001Wo0?ooo`3oool09@3oool00`000000oooo0?ooo`130?ooo`030000003oool0
oooo01/0oooo101oo`080?ooo`030000003oool0oooo00@0oooo0P1oo`0S0?ooo`030000003oool0
oooo02L0oooo00<0Ool00?ooo`3oool05`3oool00`000000oooo0?ooo`060?ooo`03000Io`3oool0
oooo06d0oooo000W0?ooo`03000Io`3oool0oooo00D0oooo00<001Wo0?ooo`3oool09@3oool00`00
0000oooo0?ooo`110?ooo`8000008@3oool207oo00L0oooo00<000000?ooo`3oool0103oool00`1o
o`00oooo0?ooo`0S0?ooo`030000003oool0oooo02H0oooo00<0Ool00?ooo`3oool05`3oool00`00
0000oooo0?ooo`060?ooo`03000Io`3oool0oooo06d0oooo000W0?ooo`03000Io`3oool0oooo00@0
oooo00<001Wo0?ooo`3oool09`3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo02X0
oooo00<000000?ooo`3oool0:`3oool2000002L0oooo00<0Ool00?ooo`3oool05@3oool00`000000
oooo0?ooo`070?ooo`03000Io`3oool0oooo06d0oooo000X0?ooo`03000Io`3oool0oooo0080oooo
00<001Wo0?ooo`3oool0:@3oool00`000000oooo0?ooo`0l0?ooo`800000;@3oool00`000000oooo
0?ooo`0]0?ooo`030000003oool0oooo02@0oooo00<0Ool00?ooo`3oool0503oool00`000000oooo
0?ooo`080?ooo`03000Io`3oool0oooo06d0oooo000X0?ooo`03000Io`3oool0oooo0080oooo00<0
01Wo0?ooo`3oool0:@3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo02d0oooo00<0
00000?ooo`3oool0;P3oool00`000000oooo0?ooo`0S0?ooo`0307oo003oool0oooo01@0oooo00<0
00000?ooo`3oool0203oool00`006Ol0oooo0?ooo`1]0?ooo`00:@3oool010006Ol0oooo0?ooo`00
6Ol]0?ooo`030000003oool0oooo03P0oooo0P00000`0?ooo`030000003oool0oooo02l0oooo0P00
000S0?ooo`0307oo003oool0oooo01<0oooo00<000000?ooo`3oool02@3oool00`006Ol0oooo0?oo
o`1]0?ooo`00:@3oool00`006Ol0oooo000Io`0_0?ooo`030000003oool0oooo03H0oooo00<00000
0?ooo`3oool0<03oool300000340oooo00<000000?ooo`3oool0803oool00`1oo`00oooo0?ooo`0C
0?ooo`030000003oool0oooo00T0oooo00<001Wo0?ooo`3oool0K@3oool002X0oooo0P006Ol_0?oo
o`030000003oool0oooo03D0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0b0?oo
o`8000008@3oool00`1oo`00oooo0?ooo`0A0?ooo`030000003oool0oooo00X0oooo00<001Wo0?oo
o`3oool0K@3oool002X0oooo00<001Wo0?ooo`3oool0;`3oool00`000000oooo0?ooo`0b0?ooo`80
0000=03oool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01h0oooo00<0Ool00?ooo`3o
ool0403oool00`000000oooo0?ooo`0;0?ooo`03000Io`3oool0oooo06d0oooo000Y0?ooo`03000I
o`3oool001Wo0340oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0d0?ooo`030000
003oool0oooo03D0oooo00<000000?ooo`3oool07@3oool00`1oo`00oooo0?ooo`0@0?ooo`030000
003oool0oooo00/0oooo00<001Wo0?ooo`3oool0K@3oool002T0oooo00<001Wo0?ooo`006Ol0<P3o
ool00`000000oooo0?ooo`0]0?ooo`800000=`3oool00`000000oooo0?ooo`0f0?ooo`8000007@3o
ool00`1oo`00oooo0?ooo`0?0?ooo`030000003oool0oooo00`0oooo00<001Wo0?ooo`3oool0K@3o
ool002P0oooo00D001Wo0?ooo`3oool0oooo000Io`0a0?ooo`030000003oool0oooo02`0oooo00<0
00000?ooo`3oool0=`3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo01X0oooo00<0
Ool00?ooo`3oool03P3oool00`000000oooo0?ooo`0=0?ooo`03000Io`3oool0oooo06d0oooo000W
0?ooo`03000Io`3oool0oooo0080oooo00<001Wo0?ooo`3oool0<03oool00`000000oooo0?ooo`0Z
0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0>@3oool2000001X0oooo00<0Ool0
0?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`03000Io`3oool0oooo06d0oooo000W0?oo
o`03000Io`3oool0oooo00<0oooo00<001Wo0?ooo`3oool0<03oool00`000000oooo0?ooo`0W0?oo
o`800000>`3oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo01P0oooo00<0Ool00?oo
o`3oool0303oool00`000000oooo0?ooo`0>0?ooo`03000Io`3oool0oooo06d0oooo000V0?ooo`03
000Io`3oool0oooo00@0oooo00<001Wo0?ooo`3oool0<@3oool00`000000oooo0?ooo`0U0?ooo`03
0000003oool0oooo03/0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`0G0?ooo`03
07oo003oool0oooo00/0oooo00<000000?ooo`3oool03`3oool00`006Ol0oooo0?ooo`1]0?ooo`00
9@3oool00`006Ol0oooo0?ooo`060?ooo`03000Io`3oool0oooo0340oooo00<000000?ooo`3oool0
8P3oool2000003h0oooo00<000000?ooo`3oool0?@3oool2000001L0oooo00<0Ool00?ooo`3oool0
2P3oool00`000000oooo0?ooo`0@0?ooo`03000Io`3oool0oooo06d0oooo000U0?ooo`03000Io`3o
ool0oooo00H0oooo00<001Wo0?ooo`3oool0<P3oool00`000000oooo0?ooo`0P0?ooo`030000003o
ool0oooo03h0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`0D0?ooo`0307oo003o
ool0oooo00T0oooo00<000000?ooo`3oool04@3oool00`006Ol0oooo0?ooo`1]0?ooo`007P3oool0
0`006Ol0oooo0?ooo`030?ooo`03000Io`3oool0oooo00P0oooo00<001Wo0?ooo`3oool0<P3oool0
0`000000oooo0?ooo`0N0?ooo`030000003oool0oooo03l0oooo00<000000?ooo`3oool0@03oool2
000001@0oooo00<0Ool00?ooo`3oool0203oool00`000000oooo0?ooo`0B0?ooo`03000Io`3oool0
oooo06d0oooo000N0?ooo`<001Wo0P3oool00`006Ol0oooo0?ooo`090?ooo`03000Io`3oool0oooo
03<0oooo00<000000?ooo`3oool06`3oool200000480oooo0`0000120?ooo`030000003oool0oooo
0140oooo00<0Ool00?ooo`3oool01`3oool00`000000oooo0?ooo`0C0?ooo`03000Io`3oool0oooo
06d0oooo000M0?ooo`L001Wo303oool00`006Ol0oooo0?ooo`0c0?ooo`030000003oool0oooo01T0
oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo0140
oooo00<0Ool00?ooo`3oool01@3oool00`000000oooo0?ooo`0D0?ooo`03000Io`3oool0oooo06d0
oooo000M0?ooo`P001Wo2`3oool00`006Ol0oooo0?ooo`0d0?ooo`030000003oool0oooo01H0oooo
0P0000150?ooo`030000003oool0oooo04@0oooo0P00000A0?ooo`0307oo003oool0oooo00@0oooo
00<000000?ooo`3oool05@3oool00`006Ol0oooo0?ooo`1]0?ooo`007@3oool:000Io`X0oooo00<0
01Wo0?ooo`3oool0=03oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo04D0oooo00<0
00000?ooo`3oool0AP3oool00`000000oooo0?ooo`0>0?ooo`0307oo003oool0oooo00<0oooo00<0
00000?ooo`3oool05P3oool00`006Ol0oooo0?ooo`1]0?ooo`00703oool<000Io`T0oooo00<001Wo
0?ooo`3oool0=@3oool00`000000oooo0?ooo`0A0?ooo`800000B03oool00`000000oooo0?ooo`17
0?ooo`8000003P3oool0101oo`00oooo0?ooo`3oool2000001T0oooo00<001Wo0?ooo`3oool0K@3o
ool001`0oooo2`006Ol;0?ooo`03000Io`3oool0oooo03D0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`180?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3oool02`3oool0
101oo`00oooo0?ooo`00000K0?ooo`03000Io`3oool0oooo06d0oooo000L0?ooo`X001Wo303oool0
0`006Ol0oooo0?ooo`0f0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0B@3oool0
0`000000oooo0?ooo`1:0?ooo`030000003oool0oooo00/0oooo00<0Ool00000003oool06`3oool0
0`006Ol0oooo0?ooo`1]0?ooo`006`3oool:000Io`h0oooo00<001Wo0?ooo`3oool0=P3oool00`00
0000oooo0?ooo`0:0?ooo`800000?P3oool307oo00/0oooo00<000000?ooo`3oool0B`3oool20000
00/0oooo00<0Ool00?ooo`3oool06`3oool00`006Ol0oooo0?ooo`1]0?ooo`006`3oool9000Io`l0
oooo00<001Wo0?ooo`3oool0=`3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo03X0
oooo1P1oo`0<0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool01`3oool00`000000
Ool00?ooo`0L0?ooo`03000Io`3oool0oooo06d0oooo000J0?ooo`T001Wo4@3oool00`006Ol0oooo
0?ooo`0g0?ooo`8000001P3oool200000340oooo00D0omBK000000000000000009_Do`030?ooo`T0
Ool000<0oooo0=BK000000000P0000000`2Ke?l0oooo0?ooo`050?ooo`030000003oool0oooo04h0
oooo0P0000060?ooo`030000003oool0Ool001d0oooo00<001Wo0?ooo`3oool0K@3oool001X0oooo
20006OlC0?ooo`03000Io`3oool0oooo03P0oooo00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0a0?ooo`040;YbV`3Dool0oooo0?ooe0`0Ool000<0oooo0=BK0000Vm@00P3oool00`3oj[X0
LP0009_Do`060?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool00P3oool010000000
oooo0?ooo`1oo`0M0?ooo`03000Io`3oool0oooo06d0oooo000J0?ooo`L001Wo503oool00`006Ol0
oooo0?ooo`0i0?ooo`040000003oool0oooo000003<0oooo00<0omBK07oo001oo`003@1oo`070?oo
o`030?oDV`00Vm@0oooo00D0oooo00<000000?ooo`3oool0D@3oool010000000oooo0?ooo`000003
0?ooo`0307oo003oool0oooo01/0oooo00<001Wo0?ooo`3oool0K@3oool001T0oooo1`006OlF0?oo
o`03000Io`3oool0oooo03T0oooo0P00000b0?oooa00Ool02@3oool00`3oe9/009_D0?ooo`050?oo
o`@00000D@3oool2000000D0oooo00<0Ool00?ooo`3oool06P3oool00`006Ol0oooo0?ooo`1]0?oo
o`006@3oool5000IoaP0oooo00<001Wo0?ooo`3oool0>03oool00`000000oooo0000000c0?ooo`h0
Ool02P3oool00`2jLP00VmCo0?ooo`050?ooo`030000003oool0oooo0540oooo00@000000?ooo`3o
ool00000103oool00`1oo`00oooo0?ooo`0J0?ooo`03000Io`3oool0oooo06d0oooo000I0?ooo`@0
01Wo6P3oool00`006Ol0oooo0?ooo`0f0?ooo`040000003oool0oooo0?ooo`800000<@3oool=07oo
00H0oooo00<0oooD09/0000000000P0000000`1b^^X0oooo0?ooo`050?ooo`030000003oool0oooo
0500oooo00<000000?ooo`3oool00P3oool01@000000oooo0?ooo`3oool0Ool001`0oooo00<001Wo
0?ooo`3oool0K@3oool001P0oooo10006OlK0?ooo`03000Io`3oool0oooo03D0oooo00<000000?oo
o`3oool0103oool00`000000oooo0?ooo`0_0?ooo`/0Ool01`3oool00`3oom@0V`2K0=Coo`0:0?oo
o`030000003oool0oooo04h0oooo0P0000060?ooo`040000003oool0oooo07oo01`0oooo00<001Wo
0?ooo`3oool0K@3oool001P0oooo0`006OlM0?ooo`03000Io`3oool0oooo03<0oooo00<000000?oo
o`3oool01P3oool00`000000oooo0?ooo`0^0?ooo`X0Ool0203oool00`3oom@0V`2K0=Coo`0:0?oo
o`030000003oool0oooo04d0oooo00<000000?ooo`3oool01`3oool00`000000oooo07oo000L0?oo
o`03000Io`3oool0oooo06d0oooo000H0?ooo`8001Wo7P3oool00`006Ol0oooo0?ooo`0b0?ooo`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0;03oool:07oo00T0oooo00<0oooD09/00000
00000P0000000`0009/0e?oo0?ooo`050?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3o
ool02@3oool00`000000Ool00?ooo`0K0?ooo`03000Io`3oool0oooo06d0oooo000G0?ooo`8001Wo
803oool00`006Ol0oooo0?ooo`0`0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
:@3oool207oo0080oooo1`1oo`0G0?ooo`030000003oool0oooo04X0oooo0P00000=0?ooo`030000
001oo`00oooo01X0oooo00<001Wo0?ooo`3oool0K@3oool001L0oooo00<001Wo0?ooo`3oool07`3o
ool00`006Ol0oooo0?ooo`0^0?ooo`8000003P3oool2000002L0oooo0P1oo`050?ooo`@0Ool06@3o
ool00`000000oooo0?ooo`190?ooo`030000003oool0oooo00h0oooo00<0Ool00?ooo`3oool06@3o
ool00`006Ol0oooo0?ooo`1]0?ooo`00>P3oool00`006Ol0oooo0?ooo`0/0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool08P3oool207oo00L0oooo0`1oo`0J0?ooo`030000003oool0
oooo04P0oooo00<000000?ooo`3oool03`3oool00`1oo`0000000000000I0?ooo`03000Io`3oool0
oooo06d0oooo000j0?ooo`03000Io`3oool0oooo02/0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`0O0?ooo`80Ool02P3oool00`1oo`00oooo0?ooo`0I0?ooo`030000003oool0oooo
04H0oooo0P00000B0?ooo`0407oo003oool0oooo000001P0oooo00<001Wo0?ooo`3oool0K@3oool0
03/0oooo00<001Wo0?ooo`3oool0:@3oool00`000000oooo0?ooo`0D0?ooo`8000007@3oool207oo
02P0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`0B0?ooo`0507oo003oool0oooo
0?ooo`0000005`3oool00`006Ol0oooo0?ooo`1]0?ooo`00>`3oool00`006Ol0oooo0?ooo`0X0?oo
o`030000003oool0oooo01L0oooo0P00000I0?ooo`80Ool0:P3oool00`000000oooo0?ooo`140?oo
o`030000003oool0oooo01@0oooo00D0Ool00?ooo`3oool0oooo0000000F0?ooo`03000Io`3oool0
oooo06d0oooo000l0?ooo`03000Io`3oool0oooo02H0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`0D0?ooo`80Ool0;03oool300000480oooo0P00000G0?ooo`0307oo003oool0oooo
0080oooo00<000000?ooo`3oool04`3oool00`006Ol0oooo0?ooo`1]0?ooo`00?03oool00`006Ol0
oooo0?ooo`0U0?ooo`030000003oool0oooo01`0oooo0P00000B0?ooo`80Ool0;P3oool00`000000
oooo0?ooo`110?ooo`030000003oool0oooo01L0oooo00<0Ool00?ooo`3oool00`3oool00`000000
oooo0?ooo`0B0?ooo`03000Io`3oool0oooo06d0oooo000m0?ooo`03000Io`3oool0oooo02<0oooo
00<000000?ooo`3oool07`3oool2000000h0oooo0P1oo`0`0?ooo`030000003oool0oooo03l0oooo
0P00000J0?ooo`0307oo003oool0oooo00@0oooo00<000000?ooo`3oool04@3oool00`006Ol0oooo
0?ooo`1]0?ooo`00?@3oool00`006Ol0oooo0?ooo`0R0?ooo`030000003oool0oooo0280oooo00<0
00000?ooo`3oool02@3oool207oo0380oooo00<000000?ooo`3oool0?@3oool2000001`0oooo00<0
Ool00?ooo`3oool01@3oool00`000000oooo0?ooo`0@0?ooo`03000Io`3oool0oooo06d0oooo000n
0?ooo`03000Io`3oool0oooo0200oooo00<000000?ooo`3oool0903oool2000000L0oooo0P1oo`0d
0?ooo`030000003oool0oooo03/0oooo0P00000N0?ooo`0307oo003oool0oooo00H0oooo00<00000
0?ooo`3oool03`3oool00`006Ol0oooo0?ooo`1]0?ooo`00?P3oool00`006Ol0oooo0?ooo`0O0?oo
o`030000003oool0oooo02L0oooo00<000000?ooo`3oool00P3oool207oo03H0oooo00<000000?oo
o`3oool0>@3oool200000240oooo00<0Ool00?ooo`3oool01P3oool00`000000oooo0?ooo`0>0?oo
o`03000Io`3oool0oooo06d0oooo000o0?ooo`03000Io`3oool0oooo01`0oooo0P00000[0?ooo`80
00000P1oo`0h0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool08@3oool00`1oo`00
oooo0?ooo`070?ooo`030000003oool0oooo00d0oooo00<001Wo0?ooo`3oool0K@3oool003l0oooo
00<001Wo0?ooo`3oool06`3oool00`000000oooo0?ooo`0[0?ooo`80Ool00P00000h0?ooo`030000
003oool0oooo03H0oooo0P00000T0?ooo`0307oo003oool0oooo00P0oooo00<000000?ooo`3oool0
303oool00`006Ol0oooo0?ooo`1]0?ooo`00@03oool00`006Ol0oooo0?ooo`0I0?ooo`030000003o
ool0oooo02X0oooo0P1oo`040?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0=03o
ool2000002H0oooo00<0Ool00?ooo`3oool02@3oool00`000000oooo0?ooo`0;0?ooo`03000Io`3o
ool0oooo06d0oooo00100?ooo`03000Io`3oool0oooo01P0oooo00<000000?ooo`3oool0:@3oool2
07oo00L0oooo0P00000e0?ooo`030000003oool0oooo0380oooo0P00000X0?ooo`0307oo003oool0
oooo00X0oooo00<000000?ooo`3oool02P3oool00`006Ol0oooo0?ooo`1]0?ooo`00@@3oool00`00
6Ol0oooo0?ooo`0F0?ooo`030000003oool0oooo02T0oooo00<0Ool00?ooo`3oool02@3oool20000
03<0oooo00<000000?ooo`3oool0<03oool2000002X0oooo00<0Ool00?ooo`3oool02P3oool00`00
0000oooo0?ooo`0:0?ooo`03000Io`3oool0oooo06d0oooo00110?ooo`03000Io`3oool0oooo01D0
oooo00<000000?ooo`3oool0:03oool207oo00h0oooo0P00000a0?ooo`030000003oool0oooo02h0
oooo0P00000]0?ooo`0307oo003oool0oooo00X0oooo00<000000?ooo`3oool02@3oool00`006Ol0
oooo0?ooo`1]0?ooo`00@P3oool00`006Ol0oooo0?ooo`0C0?ooo`030000003oool0oooo02L0oooo
0P1oo`0B0?ooo`800000;`3oool3000002`0oooo0P00000_0?ooo`0307oo003oool0oooo00/0oooo
00<000000?ooo`3oool0203oool00`006Ol0oooo0?ooo`1]0?ooo`00@P3oool00`006Ol0oooo0?oo
o`0B0?ooo`030000003oool0oooo02H0oooo0P1oo`0F0?ooo`800000;@3oool00`000000oooo0?oo
o`0Z0?ooo`800000<@3oool00`1oo`00oooo0?ooo`0<0?ooo`030000003oool0oooo00L0oooo00<0
01Wo0?ooo`3oool0K@3oool004<0oooo00<001Wo0?ooo`3oool0403oool00`000000oooo0?ooo`0U
0?ooo`80Ool06P3oool2000002/0oooo00<000000?ooo`3oool0:03oool2000003<0oooo00<0Ool0
0?ooo`3oool03@3oool00`000000oooo0?ooo`060?ooo`03000Io`3oool0oooo06d0oooo00130?oo
o`03000Io`3oool0oooo0100oooo00<000000?ooo`3oool08`3oool207oo01h0oooo0P00000Y0?oo
o`030000003oool0oooo02H0oooo0P00000e0?ooo`0307oo003oool0oooo00h0oooo00<000000?oo
o`3oool01@3oool00`006Ol0oooo0?ooo`1]0?ooo`00A03oool00`006Ol0oooo0?ooo`0>0?ooo`03
0000003oool0oooo0280oooo0P1oo`0R0?ooo`8000009`3oool00`000000oooo0?ooo`0T0?ooo`80
0000>03oool00`1oo`00oooo0?ooo`0>0?ooo`030000003oool0oooo00@0oooo00<001Wo0?ooo`3o
ool0K@3oool004@0oooo00<001Wo0?ooo`3oool03@3oool00`000000oooo0?ooo`0Q0?ooo`80Ool0
9P3oool3000002@0oooo00<000000?ooo`3oool08P3oool2000003X0oooo00<0Ool00?ooo`3oool0
3`3oool00`000000oooo0?ooo`030?ooo`03000Io`3oool0oooo06d0oooo00150?ooo`03000Io`3o
ool0oooo00/0oooo00<000000?ooo`3oool0803oool207oo02/0oooo0P00000R0?ooo`030000003o
ool0oooo01l0oooo0`00000l0?ooo`0307oo003oool0oooo0100oooo00<000000?ooo`3oool00P3o
ool00`006Ol0oooo0?ooo`1]0?ooo`00A@3oool00`006Ol0oooo0?ooo`0;0?ooo`030000003oool0
oooo01h0oooo0P1oo`0_0?ooo`800000803oool00`000000oooo0?ooo`0M0?ooo`800000?`3oool0
0`1oo`00oooo0?ooo`0@0?ooo`030000003oool0oooo0080oooo00<001Wo0?ooo`3oool0K@3oool0
04H0oooo00<001Wo0?ooo`3oool02@3oool00`000000oooo0?ooo`0M0?ooo`80Ool0<`3oool20000
01h0oooo00<000000?ooo`3oool06`3oool200000440oooo00<0Ool00?ooo`3oool04@3oool01@00
0000oooo0?ooo`3oool001Wo06l0oooo00160?ooo`03000Io`3oool0oooo00T0oooo00<000000?oo
o`3oool06`3oool207oo03L0oooo0P00000L0?ooo`030000003oool0oooo01T0oooo0P0000130?oo
o`0307oo003oool0oooo0180oooo00@000000?ooo`3oool001WoK`3oool004L0oooo00<001Wo0?oo
o`3oool01`3oool00`000000oooo0?ooo`0J0?ooo`80Ool0>`3oool3000001T0oooo00<000000?oo
o`3oool05`3oool2000004H0oooo00<0Ool00?ooo`3oool04@3oool010000000oooo0?ooo`006Om_
0?ooo`00A`3oool00`006Ol0oooo0?ooo`070?ooo`030000003oool0oooo01P0oooo0P1oo`100?oo
o`8000005`3oool00`000000oooo0?ooo`0E0?ooo`800000B03oool00`1oo`00oooo0?ooo`0B0?oo
o`030000003oool001Wo06l0oooo00180?ooo`03000Io`3oool0oooo00D0oooo00<000000?ooo`3o
ool05`3oool207oo04@0oooo0`00000D0?ooo`<000004P3oool3000004X0oooo00<0Ool00?ooo`3o
ool04P3oool00`000000oooo000Io`1=0?ooo`H001Wo703oool004P0oooo00<001Wo0?ooo`3oool0
1@3oool00`000000oooo0?ooo`0E0?ooo`80Ool0B@3oool200000180oooo00<000000?ooo`3oool0
3`3oool3000004d0oooo00<0Ool00?ooo`3oool04P3oool00`000000oooo000Io`1=0?oooa4001Wo
4@3oool004T0oooo00<001Wo0?ooo`3oool00`3oool00`000000oooo0?ooo`0D0?ooo`80Ool0C@3o
ool3000000l0oooo00<000000?ooo`3oool03@3oool200000500oooo00<0Ool00?ooo`3oool04`3o
ool00`00000001Wo0?ooo`1<0?oooaL001Wo2`3oool004T0oooo00<001Wo0?ooo`3oool00`3oool0
0`000000oooo0?ooo`0B0?ooo`80Ool0DP3oool3000000`0oooo00<000000?ooo`3oool02P3oool3
00000580oooo00<0Ool00?ooo`3oool03`3oool;000IodT0oooo50006Ol=0?ooo`00BP3oool00`00
6Ol0oooo0?ooo`020?ooo`030000003oool0oooo0100oooo0P1oo`1G0?ooo`8000002P3oool00`00
0000oooo0?ooo`070?ooo`<00000EP3oool00`1oo`00oooo0?ooo`0>0?ooo`/001WoB@3ooolB000I
o`l0oooo001:0?ooo`05000Io`3oool0oooo0?ooo`0000004@3oool207oo05/0oooo0`0000070?oo
o`030000003oool0oooo00@0oooo0`00001I0?ooo`0307oo003oool0oooo00h0oooo2`006Om90?oo
oa0001Wo4@3oool004/0oooo00@001Wo0?ooo`3oool000003`3oool207oo0600oooo0P0000050?oo
o`040000003oool0oooo0?ooo`<00000G03oool00`1oo`00oooo0?ooo`0?0?ooo`T001WoAP3ooolB
000Ioa<0oooo001;0?ooo`04000Io`3oool0oooo000000d0oooo0P1oo`1T0?ooo`<000000P3oool0
10000000oooo00000000001O0?ooo`0307oo003oool0oooo00l0oooo2@006Om00?ooo`H001Wo103o
ool<000IoaD0oooo001<0?ooo`03000Io`3oool0000000/0oooo0P1oo`1Y0?ooo`@00000H@3oool0
0`1oo`00oooo0?ooo`0?0?ooo`T001Wo>`3oool5000Io`X0oooo2@006OlH0?ooo`00C03oool00`00
6Ol0oooo000000090?ooo`80Ool0J@3oool3000000030?ooo`000000000000800000H03oool00`1o
o`00oooo0?ooo`0>0?ooo`T001Wo=@3oool6000Ioa00oooo1P006OlJ0?ooo`00C@3oool00`006Ol0
00000?ooo`060?ooo`80Ool0J03oool3000000@0oooo00@000000?ooo`3oool0oooo0`00001M0?oo
o`0307oo003oool0oooo00l0oooo1`006Ol`0?ooo`H001Wo5P3oool4000Ioa`0oooo001=0?ooo`04
000Io`000000o`000?l000<0oooo0P1oo`1W0?ooo`<000001`3oool00`000000oooo0?ooo`040?oo
o`@00000F@3oool00`1oo`00oooo0?ooo`0?0?ooo`L001Wo:`3oool5000Ioa`0oooo0P006OlN0?oo
o`00CP3oool40?l00080Ool0IP3oool3000000X0oooo0`0000080?ooo`<00000EP3oool00`1oo`00
oooo0?ooo`0?0?ooo`L001Wo9@3oool6000Iod40oooo001=0?ooo`<0o`000P1oo`000`3o0000oooo
0?ooo`1Q0?ooo`@000003@3oool00`000000oooo0?ooo`0;0?ooo`<00000D`3oool00`1oo`00oooo
0?ooo`0?0?ooo`L001Wo7`3oool6000IodL0oooo001=0?ooo`80o`0000@0Ool00?l0003o0000o`00
H03oool300000140oooo00<000000?ooo`3oool03P3oool300000500oooo00<0Ool00?ooo`3oool0
3`3oool6000Ioa/0oooo1@006Om=0?ooo`00CP3oool40?l005h0oooo0`00000D0?ooo`030000003o
ool0oooo0140oooo1000001=0?ooo`0307oo003oool0oooo00l0oooo1@006OlE0?ooo`H001WoDP3o
ool004l0oooo0P3o00000`000000oooo0?ooo`1H0?ooo`@000005`3oool00`000000oooo0?ooo`0E
0?ooo`@00000B@3oool00`1oo`00oooo0?ooo`0>0?ooo`03000000006Ol001Wo00<001Wo3`3oool6
000IoeP0oooo001B0?ooo`030000003oool0oooo05<0oooo1000000K0?ooo`030000003oool0oooo
01T0oooo100000150?ooo`0307oo003oool0oooo00d0oooo00<000000?ooo`006Ol010006Ol:0?oo
o`D001WoGP3oool005<0oooo00<000000?ooo`3oool0CP3oool4000001l0oooo00<000000?ooo`3o
ool07@3oool400000440oooo00<0Ool00?ooo`3oool03@3oool00`000000oooo000Io`04000Io`@0
oooo1P006OmS0?ooo`00E03oool00`000000oooo0?ooo`180?ooo`D000008`3oool00`000000oooo
0?ooo`0Q0?ooo`@00000?@3oool00`1oo`00oooo0?ooo`0;0?ooo`8000000`3oool8000IofT0oooo
001E0?ooo`800000A03oool4000002P0oooo00<000000?ooo`3oool09@3oool5000003P0oooo00<0
Ool00?ooo`3oool02@3oool200000080oooo1P006Om^0?ooo`00E`3oool3000003`0oooo1@00000O
0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool0103oool00`000000oooo0?ooo`0Z
0?ooo`H00000<`3oool00`1oo`00o`000?ooo`060?ooo`H001Wo0`3oool3000Iofh0oooo001J0?oo
o`<00000<`3oool6000002L0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`0`0?oo
o`H00000;03oool0103o0000Ool00?l0003o0006000Io`T0oooo0`006Om^0?ooo`00G@3oool50000
0280oooo3000000]0?ooo`030;YbLP2jj_l0oooo00L0oooo00<000000?ooo`3oool0=P3oool;0000
0200oooo0P3o0000101oo`00o`000?l0003o000?0?ooo`03000Io`3oool0oooo06d0oooo001R0?oo
o``00000203oool>000003T0oooo00<0^W9b0;[Zo`3oool01`3oool00`000000oooo0?ooo`110?oo
o`l000001`3oool:000000H0o`003`3oool00`006Ol0oooo0?ooo`1]0?ooo`00KP3oool8000004L0
oooo00<0^W9b0;[Zo`3oool01`3oool4000004l0oooo1`00000;0?ooo`@0o`00403oool00`006Ol0
oooo0?ooo`1]0?ooo`00_@3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo06<0oooo
0P3o00210?ooo`00_@3oool00`2jLW80^^[o0?ooo`070?ooo`030000003oool0oooo0>H0oooo002j
0?ooo`050>ZjLP00000007:j0;YbLP2jj_l0203oool00`000000oooo0?ooo`3V0?ooo`00_03oool0
0`3Z^W80001b0;[Zo`080?ooo`030000003oool0oooo0>H0oooo00370?ooo`030000003oool0oooo
0>H0oooo00370?ooo`030000003oool0oooo0>H0oooo00370?ooo`030000003oool0oooo0>H0oooo
003o0?oook40oooo003o0?oook40oooo0000\
\>"],
  ImageRangeCache->{{{0, 431}, {334.5, 0}} -> {-1.64869, -1.68087, 0.0123907, \
0.0123907}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 8", "Exercise"],

Cell["\<\
Calcula las rectas tangente y normal a la elipse de ecuaci\[OAcute]n \
\>", "ExerciseText"],

Cell[BoxData[
    FormBox[
      RowBox[{
        RowBox[{
          FractionBox[
            SuperscriptBox[
              StyleBox["x",
                FontWeight->"Bold",
                FontSlant->"Italic"], "2"], 
            RowBox[{
              SuperscriptBox[
                StyleBox["a",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], "2"], " "}]], 
          StyleBox["+",
            FontWeight->"Bold"], 
          FractionBox[
            SuperscriptBox[
              StyleBox["y",
                FontWeight->"Bold",
                FontSlant->"Italic"], "2"], 
            RowBox[{
              SuperscriptBox[
                StyleBox["b",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], "2"], " "}]]}], 
        StyleBox["=",
          FontWeight->"Bold"], "1"}], TextForm]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  Cell[BoxData[
      FormBox[
        RowBox[{"(", 
          RowBox[{
            RowBox[{
              StyleBox["a",
                FontWeight->"Bold"], ">", "0"}], ",", " ", 
            RowBox[{
              StyleBox["b",
                FontWeight->"Bold"], ">", "0"}]}], ")"}], TraditionalForm]]],
  " en un punto gen\[EAcute]rico (u,v) de la misma."
}], "ExerciseText"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 9", "Exercise"],

Cell[TextData[{
  "Sea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((t\^3 - t, t\^2 - t)\)\)]],
  ". Representa gr\[AAcute]ficamente la curva \[Gamma] para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-3\) \[LessEqual] t \[LessEqual] 3\)]],
  ". Calcula la recta tangente a \[Gamma] para ",
  Cell[BoxData[
      \(TraditionalForm\`t = 0\)]],
  " y para ",
  Cell[BoxData[
      \(TraditionalForm\`t = 1\)]],
  ". Observa que ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](0) = \(\[Gamma](1) = \((0, 0)\)\)\)]],
  ". Comprueba que \[Gamma] es una curva suave. Observa que la expresi\
\[OAcute]n \"tangente a \[Gamma] en (0,0)\" es ambigua porque la curva pasa \
dos veces por (0,0) y, en cada caso, lo hace con distinta velocidad."
}], "ExerciseText"],

Cell["\<\
El siguiente ejercicio pone de manifiesto que la forma geom\[EAcute]trica de \
una curva no proporciona informaci\[OAcute]n sobre la derivabilidad de la \
misma ni sobre su longitud. Lo importante de una curva es c\[OAcute]mo se \
recorre dicha curva, es decir, la funci\[OAcute]n que la define.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejercicio 10", "Exercise"],

Cell[TextData[{
  "a) Sea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((t, \( | t | \))\)\)]],
  ". Representa gr\[AAcute]ficamente la curva \[Gamma] para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) \[LessEqual] t \[LessEqual] 1\)]],
  ". Calcula la recta tangente a \[Gamma] para un valor ",
  Cell[BoxData[
      \(TraditionalForm\`t < 0\)]],
  " y para un valor ",
  Cell[BoxData[
      \(TraditionalForm\`t > 0\)]],
  ". \[DownQuestion]Es \[Gamma] derivable en ",
  Cell[BoxData[
      \(TraditionalForm\`t = 0\)]],
  "?\nb) Sea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((t\^3, t\^2 | t | )\)\)]],
  ". Representa gr\[AAcute]ficamente la curva \[Gamma] para ",
  Cell[BoxData[
      \(TraditionalForm\`\(-1\) \[LessEqual] t \[LessEqual] 1\)]],
  ". Calcula la recta tangente a \[Gamma] para un valor ",
  Cell[BoxData[
      \(TraditionalForm\`t < 0\)]],
  " y para un valor ",
  Cell[BoxData[
      \(TraditionalForm\`t > 0\)]],
  ". \[DownQuestion]Es \[Gamma] derivable en ",
  Cell[BoxData[
      \(TraditionalForm\`t = 0\)]],
  "? \[DownQuestion]Es \[Gamma] una curva suave?\nc) Sea ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](t) = \((cos\ t, \ sen\ t)\)\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`\[Lambda](t) = \((cos\ 3  t, \ sen\ 3  t)\)\)]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ". Representa gr\[AAcute]ficamente las curva \[Gamma] y \[Lambda]. Calcula \
el vector derivada y la rapidez de cada curva. Calcula la longitud de \
\[Gamma] y la de \[Lambda].\nd) Sea ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          RowBox[{
            RowBox[{
              FormBox[\(\[Gamma](t) = \((cos\^3\)\),
                "TraditionalForm"], "t"}], ",", " ", 
            RowBox[{
              FormBox[\(sen\^3\),
                "TraditionalForm"], "t"}]}], ")"}], TraditionalForm]]],
  " donde ",
  Cell[BoxData[
      \(TraditionalForm\`0 \[LessEqual] t \[LessEqual] 2  \[Pi]\)]],
  ". Representa gr\[AAcute]ficamente la curva \[Gamma]. \[DownQuestion]Tiene \
\[Gamma] derivada continua? \[DownQuestion]Es \[Gamma] una curva suave? \
Calcula la longitud de \[Gamma]."
}], "ExerciseText"],

Cell[TextData[{
  "Si ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y)\)]],
  " es un campo escalar de dos variables, las curvas de ecuaci\[OAcute]n impl\
\[IAcute]cita ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = c\)]],
  " o, lo que es igual ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) - c = 0\)]],
  ", donde ",
  StyleBox["c",
    FontSlant->"Italic"],
  " es una constante, se llaman ",
  StyleBox["curvas de nivel",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". De lo dicho antes, se sigue que ",
  StyleBox["el vector gradiente ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\(\[Del]\)\(f(x, y)\)\(\ \)\)\)],
    FontWeight->"Bold"],
  StyleBox["es ortogonal en todo punto ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\((x, y)\)\)],
    FontWeight->"Bold"],
  StyleBox[" (en el que ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\[Del]\(f(x, y)\) \[NotEqual] \((0, 0)\)\)],
    FontWeight->"Bold"],
  StyleBox[") a la curva de nivel que pasa por dicho punto",
    FontWeight->"Bold"],
  ". Podemos representar varias curvas de nivel de una funci\[OAcute]n usando \
el comando"
}], "Text"],

Cell["\"ContourPlot[f[x,y],{x,xmin,xmax},{y,ymin,ymax},opciones]\"", "Text",
  TextAlignment->Center],

Cell[TextData[{
  "que representa curvas de nivel, ",
  Cell[BoxData[
      \(TraditionalForm\`f(x, y) = c\)]],
  ", para una sucesi\[OAcute]n de valores de ",
  StyleBox["c",
    FontSlant->"Italic"],
  " igualmente espaciados. Con la opci\[OAcute]n \"Contours\[Rule]{valores}\" \
puedes especificar para qu\[EAcute] valores de ",
  StyleBox["c",
    FontSlant->"Italic"],
  " quieres que se representen las curvas de nivel ."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(ContourPlot[x^2/4 + y^2/9, {x, \(-2\), 2}, {y, \(-3\), 3}, 
        Contours -> Table[c, {c,  .1, 1,  .2}], AspectRatio -> Automatic, 
        ContourShading -> False, PlotPoints -> 25, Axes -> True, 
        AxesOrigin -> {0, 0}, Frame -> False];\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.5 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% ContourGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.240385 0.75 0.240385 [
[.01923 .7375 -6 -9 ]
[.01923 .7375 6 0 ]
[.25962 .7375 -6 -9 ]
[.25962 .7375 6 0 ]
[.74038 .7375 -3 -9 ]
[.74038 .7375 3 0 ]
[.98077 .7375 -3 -9 ]
[.98077 .7375 3 0 ]
[.4875 .02885 -12 -4.5 ]
[.4875 .02885 0 4.5 ]
[.4875 .26923 -12 -4.5 ]
[.4875 .26923 0 4.5 ]
[.4875 .50962 -12 -4.5 ]
[.4875 .50962 0 4.5 ]
[.4875 .99038 -6 -4.5 ]
[.4875 .99038 0 4.5 ]
[.4875 1.23077 -6 -4.5 ]
[.4875 1.23077 0 4.5 ]
[.4875 1.47115 -6 -4.5 ]
[.4875 1.47115 0 4.5 ]
[ 0 0 0 0 ]
[ 1 1.5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.01923 .75 m
.01923 .75625 L
s
[(-2)] .01923 .7375 0 1 Mshowa
.25962 .75 m
.25962 .75625 L
s
[(-1)] .25962 .7375 0 1 Mshowa
.74038 .75 m
.74038 .75625 L
s
[(1)] .74038 .7375 0 1 Mshowa
.98077 .75 m
.98077 .75625 L
s
[(2)] .98077 .7375 0 1 Mshowa
.125 Mabswid
.06731 .75 m
.06731 .75375 L
s
.11538 .75 m
.11538 .75375 L
s
.16346 .75 m
.16346 .75375 L
s
.21154 .75 m
.21154 .75375 L
s
.30769 .75 m
.30769 .75375 L
s
.35577 .75 m
.35577 .75375 L
s
.40385 .75 m
.40385 .75375 L
s
.45192 .75 m
.45192 .75375 L
s
.54808 .75 m
.54808 .75375 L
s
.59615 .75 m
.59615 .75375 L
s
.64423 .75 m
.64423 .75375 L
s
.69231 .75 m
.69231 .75375 L
s
.78846 .75 m
.78846 .75375 L
s
.83654 .75 m
.83654 .75375 L
s
.88462 .75 m
.88462 .75375 L
s
.93269 .75 m
.93269 .75375 L
s
.25 Mabswid
0 .75 m
1 .75 L
s
.5 .02885 m
.50625 .02885 L
s
[(-3)] .4875 .02885 1 0 Mshowa
.5 .26923 m
.50625 .26923 L
s
[(-2)] .4875 .26923 1 0 Mshowa
.5 .50962 m
.50625 .50962 L
s
[(-1)] .4875 .50962 1 0 Mshowa
.5 .99038 m
.50625 .99038 L
s
[(1)] .4875 .99038 1 0 Mshowa
.5 1.23077 m
.50625 1.23077 L
s
[(2)] .4875 1.23077 1 0 Mshowa
.5 1.47115 m
.50625 1.47115 L
s
[(3)] .4875 1.47115 1 0 Mshowa
.125 Mabswid
.5 .07692 m
.50375 .07692 L
s
.5 .125 m
.50375 .125 L
s
.5 .17308 m
.50375 .17308 L
s
.5 .22115 m
.50375 .22115 L
s
.5 .31731 m
.50375 .31731 L
s
.5 .36538 m
.50375 .36538 L
s
.5 .41346 m
.50375 .41346 L
s
.5 .46154 m
.50375 .46154 L
s
.5 .55769 m
.50375 .55769 L
s
.5 .60577 m
.50375 .60577 L
s
.5 .65385 m
.50375 .65385 L
s
.5 .70192 m
.50375 .70192 L
s
.5 .79808 m
.50375 .79808 L
s
.5 .84615 m
.50375 .84615 L
s
.5 .89423 m
.50375 .89423 L
s
.5 .94231 m
.50375 .94231 L
s
.5 1.03846 m
.50375 1.03846 L
s
.5 1.08654 m
.50375 1.08654 L
s
.5 1.13462 m
.50375 1.13462 L
s
.5 1.18269 m
.50375 1.18269 L
s
.5 1.27885 m
.50375 1.27885 L
s
.5 1.32692 m
.50375 1.32692 L
s
.5 1.375 m
.50375 1.375 L
s
.5 1.42308 m
.50375 1.42308 L
s
.25 Mabswid
.5 0 m
.5 1.5 L
s
0 0 m
1 0 L
1 1.5 L
0 1.5 L
closepath
clip
newpath
.5 Mabswid
.41987 .07651 m
.45994 .06852 L
.5 .06588 L
.54006 .06852 L
.58013 .07651 L
.61777 .08894 L
.62019 .09003 L
.66026 .10946 L
.70032 .13536 L
.71806 .14904 L
.74038 .16857 L
.77931 .20913 L
.78045 .21047 L
.82051 .26325 L
.8245 .26923 L
.85969 .32933 L
.86058 .33104 L
.88762 .38942 L
.90064 .42291 L
.90976 .44952 L
.92703 .50962 L
.93998 .56971 L
.94071 .57334 L
.94899 .62981 L
.95432 .6899 L
.95608 .75 L
.95432 .8101 L
.94899 .87019 L
.94071 .92666 L
.93998 .93029 L
.92703 .99038 L
.90976 1.05048 L
.90064 1.07709 L
.88762 1.11058 L
.86058 1.16896 L
.85969 1.17067 L
.8245 1.23077 L
.82051 1.23675 L
.78045 1.28953 L
.77931 1.29087 L
.74038 1.33143 L
.71806 1.35096 L
.70032 1.36464 L
.66026 1.39054 L
.62019 1.40997 L
.61777 1.41106 L
.58013 1.42349 L
.54006 1.43148 L
.5 1.43412 L
.45994 1.43148 L
Mistroke
.41987 1.42349 L
.38223 1.41106 L
.37981 1.40997 L
.33974 1.39054 L
.29968 1.36464 L
.28194 1.35096 L
.25962 1.33143 L
.22069 1.29087 L
.21955 1.28953 L
.17949 1.23675 L
.1755 1.23077 L
.14031 1.17067 L
.13942 1.16896 L
.11238 1.11058 L
.09936 1.07709 L
.09024 1.05048 L
.07297 .99038 L
.06002 .93029 L
.05929 .92666 L
.05101 .87019 L
.04568 .8101 L
.04392 .75 L
.04568 .6899 L
.05101 .62981 L
.05929 .57334 L
.06002 .56971 L
.07297 .50962 L
.09024 .44952 L
.09936 .42291 L
.11238 .38942 L
.13942 .33104 L
.14031 .32933 L
.1755 .26923 L
.17949 .26325 L
.21955 .21047 L
.22069 .20913 L
.25962 .16857 L
.28194 .14904 L
.29968 .13536 L
.33974 .10946 L
.37981 .09003 L
.38223 .08894 L
.41987 .07651 L
Mfstroke
.5 .14664 m
.53583 .14904 L
.54006 .14964 L
.58013 .15872 L
.62019 .17418 L
.66026 .19658 L
.67843 .20913 L
.70032 .22675 L
.74038 .26623 L
.74305 .26923 L
.78045 .31744 L
.78837 .32933 L
.82051 .38542 L
.82251 .38942 L
.84883 .44952 L
.86058 .48235 L
.86895 .50962 L
.88388 .56971 L
.89419 .62981 L
.90024 .6899 L
.90064 .69625 L
.90224 .75 L
.90064 .80375 L
.90024 .8101 L
.89419 .87019 L
.88388 .93029 L
.86895 .99038 L
.86058 1.01765 L
.84883 1.05048 L
.82251 1.11058 L
.82051 1.11458 L
.78837 1.17067 L
.78045 1.18256 L
.74305 1.23077 L
.74038 1.23377 L
.70032 1.27325 L
.67843 1.29087 L
.66026 1.30342 L
.62019 1.32582 L
.58013 1.34128 L
.54006 1.35036 L
.53583 1.35096 L
.5 1.35336 L
.46417 1.35096 L
.45994 1.35036 L
.41987 1.34128 L
.37981 1.32582 L
.33974 1.30342 L
.32157 1.29087 L
.29968 1.27325 L
Mistroke
.25962 1.23377 L
.25695 1.23077 L
.21955 1.18256 L
.21163 1.17067 L
.17949 1.11458 L
.17749 1.11058 L
.15117 1.05048 L
.13942 1.01765 L
.13105 .99038 L
.11612 .93029 L
.10581 .87019 L
.09976 .8101 L
.09936 .80375 L
.09776 .75 L
.09936 .69625 L
.09976 .6899 L
.10581 .62981 L
.11612 .56971 L
.13105 .50962 L
.13942 .48235 L
.15117 .44952 L
.17749 .38942 L
.17949 .38542 L
.21163 .32933 L
.21955 .31744 L
.25695 .26923 L
.25962 .26623 L
.29968 .22675 L
.32157 .20913 L
.33974 .19658 L
.37981 .17418 L
.41987 .15872 L
.45994 .14964 L
.46417 .14904 L
.5 .14664 L
Mfstroke
.74038 1.11058 m
.74038 1.11058 L
.74038 1.11058 L
s
.74038 .38942 m
.74038 .38942 L
s
.41987 .25441 m
.45994 .24359 L
.5 .24003 L
.54006 .24359 L
.58013 .25441 L
.61396 .26923 L
.62019 .27299 L
.66026 .30023 L
.69225 .32933 L
.70032 .33796 L
.74038 .38942 L
.74038 .38942 L
.77469 .44952 L
.78045 .46163 L
.79985 .50962 L
.81801 .56971 L
.82051 .57906 L
.83039 .62981 L
.83761 .6899 L
.83998 .75 L
.83761 .8101 L
.83039 .87019 L
.82051 .92094 L
.81801 .93029 L
.79985 .99038 L
.78045 1.03837 L
.77469 1.05048 L
.74038 1.11058 L
.74038 1.11058 L
.70032 1.16204 L
.69225 1.17067 L
.66026 1.19977 L
.62019 1.22701 L
.61396 1.23077 L
.58013 1.24559 L
.54006 1.25641 L
.5 1.25997 L
.45994 1.25641 L
.41987 1.24559 L
.38604 1.23077 L
.37981 1.22701 L
.33974 1.19977 L
.30775 1.17067 L
.29968 1.16204 L
.25962 1.11058 L
.25962 1.11058 L
.22531 1.05048 L
.21955 1.03837 L
.20015 .99038 L
.18199 .93029 L
Mistroke
.17949 .92094 L
.16961 .87019 L
.16239 .8101 L
.16002 .75 L
.16239 .6899 L
.16961 .62981 L
.17949 .57906 L
.18199 .56971 L
.20015 .50962 L
.21955 .46163 L
.22531 .44952 L
.25962 .38942 L
.25962 .38942 L
.29968 .33796 L
.30775 .32933 L
.33974 .30023 L
.37981 .27299 L
.38604 .26923 L
.41987 .25441 L
Mfstroke
.41987 .37368 m
.45994 .35953 L
.5 .35493 L
.54006 .35953 L
.58013 .37368 L
.60848 .38942 L
.62019 .39849 L
.66026 .43649 L
.67104 .44952 L
.70032 .49344 L
.709 .50962 L
.73434 .56971 L
.74038 .58728 L
.75088 .62981 L
.76032 .6899 L
.76338 .75 L
.76032 .8101 L
.75088 .87019 L
.74038 .91272 L
.73434 .93029 L
.709 .99038 L
.70032 1.00656 L
.67104 1.05048 L
.66026 1.06351 L
.62019 1.10151 L
.60848 1.11058 L
.58013 1.12632 L
.54006 1.14047 L
.5 1.14507 L
.45994 1.14047 L
.41987 1.12632 L
.39152 1.11058 L
.37981 1.10151 L
.33974 1.06351 L
.32896 1.05048 L
.29968 1.00656 L
.291 .99038 L
.26566 .93029 L
.25962 .91272 L
.24912 .87019 L
.23968 .8101 L
.23662 .75 L
.23968 .6899 L
.24912 .62981 L
.25962 .58728 L
.26566 .56971 L
.291 .50962 L
.29968 .49344 L
.32896 .44952 L
.33974 .43649 L
Mistroke
.37981 .39849 L
.39152 .38942 L
.41987 .37368 L
Mfstroke
.41987 .55585 m
.45994 .52952 L
.5 .52159 L
.54006 .52952 L
.58013 .55585 L
.59401 .56971 L
.62019 .60899 L
.62943 .62981 L
.64699 .6899 L
.65227 .75 L
.64699 .8101 L
.62943 .87019 L
.62019 .89101 L
.59401 .93029 L
.58013 .94415 L
.54006 .97048 L
.5 .97841 L
.45994 .97048 L
.41987 .94415 L
.40599 .93029 L
.37981 .89101 L
.37057 .87019 L
.35301 .8101 L
.34773 .75 L
.35301 .6899 L
.37057 .62981 L
.37981 .60899 L
.40599 .56971 L
.41987 .55585 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{192, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0001/2000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00T@3oool00`000000oooo0?ooo`2<0?ooo`00T@3o
ool00`000000oooo0?ooo`2<0?ooo`00T@3oool00`000000oooo0?ooo`2<0?ooo`00T@3oool00`00
0000oooo0?ooo`2<0?ooo`00T@3oool00`000000oooo0?ooo`2<0?ooo`00QP3oool01@3DV`000000
000000000000L[[Z00H0oooo00<000000?ooo`3oool0S03oool008D0oooo00L0e9/0002Ke03oool0
oooo0?ooe02K0000L[[Z00D0oooo00<000000?ooo`3oool0S03oool008X0oooo00<0omBK002Ke03o
ool0103oool00`000000oooo0?ooo`2<0?ooo`00R@3oool00`3oj[X0LP1b0;[Zo`050?ooo`030000
003oool0oooo08`0oooo001l0?ooo`030;Yb00000000000000<0000000<007:j0?ooo`3oool00P3o
ool0103Z^W8000000000LP2jj_l60?ooo`<00000S03oool008T0oooo00<0onZj0780LP2jj_l01@3o
ool00`000000oooo0?ooo`2<0?ooo`00RP3oool00`3DV`00VmCo0?ooo`040?ooo`030000003oool0
oooo08`0oooo00250?ooo`070?oDV`000780^^[o0?ooo`3oj[X0LP1b0;[Zo`050?ooo`030000003o
ool0oooo08`0oooo00260?ooo`050?oZ^P1b000000000000002Ke?l01P3oool00`000000oooo0?oo
o`2<0?ooo`00T@3oool00`000000oooo0?ooo`2<0?ooo`00T@3oool00`000000oooo0?ooo`2<0?oo
o`00T@3oool00`000000oooo0?ooo`2<0?ooo`00T@3oool00`000000oooo0?ooo`2<0?ooo`00T@3o
ool00`000000oooo0?ooo`2<0?ooo`00S03oool;000008T0oooo00230?ooo`T000001@3oool00`00
0000oooo0?ooo`030?ooo`P00000P@3oool007d0oooo1P00000>0?ooo`030000003oool0oooo00/0
oooo1P00001k0?ooo`00N@3oool4000001@0oooo0P00000B0?ooo`@00000M`3oool007H0oooo0`00
000H0?ooo`030000003oool0oooo01D0oooo0`00001d0?ooo`00M03oool2000001/0oooo00<00000
0?ooo`3oool0603oool200000780oooo001a0?ooo`<000007@3oool00`000000oooo0?ooo`0J0?oo
o`<00000K`3oool006h0oooo0`00000P0?ooo`030000003oool0oooo01d0oooo1000001[0?ooo`00
K03oool2000002<0oooo00<000000?ooo`3oool08@3oool2000006T0oooo001Z0?ooo`8000009@3o
ool00`000000oooo0?ooo`0S0?ooo`800000I`3oool006L0oooo0`00000W0?ooo`030000003oool0
oooo02D0oooo0P00001U0?ooo`00I@3oool2000002X0oooo00<000000?ooo`3oool09`3oool20000
06<0oooo001S0?ooo`800000;03oool00`000000oooo0?ooo`0Y0?ooo`800000H@3oool00640oooo
0P00000^0?ooo`030000003oool0oooo02/0oooo0P00001O0?ooo`00H03oool00`000000oooo0?oo
o`0^0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0G03oool005l0oooo00<00000
0?ooo`3oool0;`3oool00`000000oooo0?ooo`0^0?ooo`800000G03oool005d0oooo0P00000b0?oo
o`030000003oool0oooo0300oooo00<000000?ooo`3oool0F@3oool005`0oooo00<000000?ooo`3o
ool0<P3oool200000380oooo0P00001I0?ooo`00F`3oool00`000000oooo0?ooo`0c0?ooo`030000
003oool0oooo03<0oooo00<000000?ooo`3oool0EP3oool005T0oooo0P00000f0?ooo`030000003o
ool0oooo03@0oooo0P00001F0?ooo`00F03oool00`000000oooo0?ooo`0f0?ooo`030000003oool0
oooo03H0oooo00<000000?ooo`3oool0D`3oool005L0oooo00<000000?ooo`3oool0=`3oool00`00
0000oooo0?ooo`0g0?ooo`030000003oool0oooo0580oooo001E0?ooo`800000>P3oool00`000000
oooo0?ooo`0h0?ooo`800000DP3oool005@0oooo00<000000?ooo`3oool0=P3oool9000003P0oooo
00<000000?ooo`3oool0C`3oool005<0oooo00<000000?ooo`3oool0;@3oool:000000@0oooo00<0
00000?ooo`3oool00P3oool900000300oooo00<000000?ooo`3oool0CP3oool00580oooo00<00000
0?ooo`3oool0:03oool6000000h0oooo00<000000?ooo`3oool02`3oool6000002/0oooo00<00000
0?ooo`3oool0C@3oool00540oooo00<000000?ooo`3oool09@3oool4000001@0oooo00<000000?oo
o`3oool04@3oool4000002P0oooo00<000000?ooo`3oool0C03oool004l0oooo0P00000V0?ooo`80
0000603oool00`000000oooo0?ooo`0E0?ooo`8000009`3oool2000004`0oooo001>0?ooo`030000
003oool0oooo02@0oooo0P00000J0?ooo`030000003oool0oooo01L0oooo0P00000W0?ooo`030000
003oool0oooo04T0oooo001=0?ooo`030000003oool0oooo02<0oooo0P00000L0?ooo`030000003o
ool0oooo01T0oooo0`00000U0?ooo`030000003oool0oooo04P0oooo001<0?ooo`030000003oool0
oooo0280oooo0P00000N0?ooo`8000007@3oool2000002@0oooo00<000000?ooo`3oool0A`3oool0
04/0oooo00<000000?ooo`3oool08@3oool200000200oooo00<000000?ooo`3oool07P3oool20000
02<0oooo00<000000?ooo`3oool0AP3oool004X0oooo00<000000?ooo`3oool0803oool200000280
oooo00<000000?ooo`3oool0803oool200000280oooo00<000000?ooo`3oool0A@3oool004T0oooo
00<000000?ooo`3oool07`3oool2000002@0oooo00<000000?ooo`3oool08P3oool200000240oooo
00<000000?ooo`3oool0A03oool004P0oooo00<000000?ooo`3oool07P3oool2000002H0oooo00<0
00000?ooo`3oool0903oool200000200oooo00<000000?ooo`3oool0@`3oool004L0oooo00<00000
0?ooo`3oool07@3oool2000002P0oooo00<000000?ooo`3oool09P3oool2000001h0oooo00<00000
0?ooo`3oool0@`3oool004L0oooo00<000000?ooo`3oool06`3oool2000002X0oooo00<000000?oo
o`3oool0:03oool2000001d0oooo00<000000?ooo`3oool0@P3oool004H0oooo00<000000?ooo`3o
ool06P3oool2000002`0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo0440oooo00150?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0
;03oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0
@03oool004@0oooo00<000000?ooo`3oool06@3oool2000002l0oooo00<000000?ooo`3oool0;03o
ool2000001`0oooo00<000000?ooo`3oool0?`3oool004<0oooo00<000000?ooo`3oool06@3oool0
0`000000oooo0?ooo`0_0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool06P3oool0
0`000000oooo0?ooo`0n0?ooo`00@@3oool2000001/0oooo00<000000?ooo`3oool0<03oool00`00
0000oooo0?ooo`0_0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0?@3oool00400
oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0300
oooo0P00000K0?ooo`030000003oool0oooo03`0oooo00100?ooo`030000003oool0oooo01T0oooo
00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01T0oooo
00<000000?ooo`3oool0>`3oool003l0oooo00<000000?ooo`3oool0603oool2000003D0oooo0P00
000d0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0>`3oool003h0oooo00<00000
0?ooo`3oool0603oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo03@0oooo0P00000I
0?ooo`030000003oool0oooo03X0oooo000m0?ooo`030000003oool0oooo01P0oooo00<000000?oo
o`3oool0=P3oool00`000000oooo0?ooo`0f0?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool0>@3oool003d0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0g0?ooo`03
0000003oool0oooo03L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0h0?ooo`00
?03oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0
>03oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03L0oooo000k0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0=03oool;000003H0oooo00<000000?ooo`3oool05P3o
ool00`000000oooo0?ooo`0g0?ooo`00>P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0
oooo02d0oooo200000050?ooo`030000003oool0oooo00<0oooo1`00000`0?ooo`030000003oool0
oooo01H0oooo00<000000?ooo`3oool0=P3oool003X0oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`0[0?ooo`<000003@3oool00`000000oooo0?ooo`0:0?ooo`<00000;P3oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo03D0oooo000i0?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool0:P3oool200000100oooo00<000000?ooo`3oool03@3oool2000002d0
oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0d0?ooo`00>03oool00`000000oooo
0?ooo`0F0?ooo`030000003oool0oooo02P0oooo0`00000B0?ooo`030000003oool0oooo00l0oooo
0`00000[0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0<`3oool003L0oooo00<0
00000?ooo`3oool05P3oool00`000000oooo0?ooo`0V0?ooo`<00000203oool00`3oom@0V`000000
00040000000309_Do`3oool0oooo00<0oooo00<000000?ooo`3oool04P3oool3000002T0oooo00<0
00000?ooo`3oool05@3oool00`000000oooo0?ooo`0c0?ooo`00=`3oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo02D0oooo0P00000<0?ooo`030=BK000009/0e?oo0080oooo00<0j[ZK
0;[Zo`3oool0103oool00`000000oooo0?ooo`0E0?ooo`800000:03oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo0380oooo000f0?ooo`030000003oool0oooo01D0oooo00<000000?oo
o`3oool08`3oool3000000l0oooo00<0omBK0000LP2jj_l0203oool00`000000oooo0?ooo`0G0?oo
o`<000009P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0340oooo000e0?ooo`03
0000003oool0oooo01D0oooo00<000000?ooo`3oool08P3oool2000001<0oooo00<0onZj0780001b
^^X01`3oool00`000000oooo0?ooo`0J0?ooo`8000009@3oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo0340oooo000e0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0
8@3oool2000000X0oooo00<0^W800000000000000`0000000`00L[X0oooo0?ooo`040?ooo`030;Yb
001b^^X0oooo00D0oooo0`00000L0?ooo`800000903oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo0300oooo000d0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool08@3o
ool00`000000oooo0?ooo`0H0?ooo`030;YbV`3Dool0oooo00@0oooo00<000000?ooo`3oool07P3o
ool2000002<0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0_0?ooo`00=03oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0200oooo0P00000F0?ooo`030>ZjLP2Ke?l0
oooo0080oooo00<0e9/009_Do`3oool0103oool00`000000oooo0?ooo`0P0?ooo`8000008P3oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo02l0oooo000c0?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0F0?ooo`070?oDV`0009/0e?oo
0?ooo`3oe9/0001b0;[Zo`050?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool07`3o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo02h0oooo000c0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool07P3oool2000001X0oooo00D0omBK000000000000001b0;[Z
o`060?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo02h0oooo000b0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool07P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02@0oooo0P00000P
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0;@3oool00340oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0M0?ooo`800000:03oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo01h0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0/0?oo
o`00<@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool0:03oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`0/0?ooo`00<03oool00`000000oooo0?ooo`0B0?ooo`030000
003oool0oooo01`0oooo0P00000[0?ooo`030000003oool0oooo02P0oooo0P00000N0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool0:`3oool00300oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0:P3o
ool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0:`3o
ool002l0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo02`0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0
oooo0180oooo00<000000?ooo`3oool0:P3oool002l0oooo00<000000?ooo`3oool04@3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0;03oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0:P3oool002h0
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo02h0
oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0180
oooo00<000000?ooo`3oool0:@3oool002d0oooo00<000000?ooo`3oool04@3oool00`000000oooo
0?ooo`0J0?ooo`800000<@3oool2000002l0oooo0P00000L0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool0:03oool002d0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0<03oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0:03oool002`0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0380oooo00<00000
0?ooo`3oool0<@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0180oooo00<00000
0?ooo`3oool09`3oool002`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0I0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool09`3oool002/0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3o
ool0<`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3o
ool09P3oool002/0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0H0?ooo`030000
003oool0oooo03D0oooo00<000000?ooo`3oool0=03oool2000001X0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0V0?ooo`00:P3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0f0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0U0?ooo`00:P3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0=`3oool0
0`000000oooo0?ooo`0g0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0U0?ooo`00:@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo
01L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0T0?ooo`00:@3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0>03oool00`000000
oooo0?ooo`0h0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0T0?ooo`00:03oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0S0?ooo`00:03oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0=@3oool;000003L0oooo00<0
00000?ooo`3oool05P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo02<0oooo000W
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0]
0?ooo`P000001@3oool00`000000oooo0?ooo`030?ooo`L00000<03oool00`000000oooo0?ooo`0F
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool08P3oool002L0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo02/0oooo0`00000=0?oo
o`030000003oool0oooo00X0oooo0`00000^0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0R0?ooo`009P3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo01H0oooo00<000000?ooo`3oool0:P3oool200000100oooo0P00000>0?ooo`80
0000;@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool08@3oool002H0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo02P0oooo0`00000B0?ooo`030000003oool0oooo00l0oooo0`00000[0?ooo`030000
003oool0oooo01D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0Q0?ooo`009@3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool09P3o
ool2000001D0oooo00<000000?ooo`3oool04P3oool2000002T0oooo00<000000?ooo`3oool05P3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0200oooo000U0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0U0?ooo`8000005`3oool0
0`000000oooo0?ooo`0D0?ooo`800000:03oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool0803oool002@0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0E0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`0F0?ooo`8000009`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool07`3oool002@0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo02@0oooo0P00000J0?ooo`030000003oool0oooo01P0
oooo0P00000V0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0O0?ooo`008`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool08P3oool2000001`0oooo00<000000?ooo`3oool06P3oool2000002@0oooo
00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01h0oooo
000S0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?oo
o`0R0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0703oool00`000000oooo0?oo
o`0R0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0N0?ooo`008`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo00<00000
0?ooo`3oool08@3oool2000001l0oooo00<000000?ooo`3oool07@3oool2000002<0oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01h0oooo000R0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0P0?oo
o`030000003oool0oooo01l0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0P0?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M0?oo
o`008P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3o
ool0803oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool07@3oool00240oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo01l0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0Q0?ooo`030000
003oool0oooo01l0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo01d0oooo000Q0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool08P3o
ool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0L0?ooo`00803oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0
oooo02<0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0703oool00200oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0903oool20000
02D0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
00l0oooo00<000000?ooo`3oool0703oool001l0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0C0?ooo`030000003oool0oooo01d0oooo0P00000W0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool06`3oool001l0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0D0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool09`3oool00`000000oooo
0?ooo`0V0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo01/0oooo000O0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo02P0oooo00<0
00000?ooo`3oool09`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0K0?ooo`007P3oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0Y
0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool06P3oool001h0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01/0oooo00<000000?oo
o`3oool0:P3oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo01`0oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01X0oooo000N0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0K0?ooo`03
0000003oool0oooo02/0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0L0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0J0?ooo`00
7P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0
6P3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0
6`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
6@3oool001d0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo01X0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0[0?ooo`030000003o
ool0oooo01`0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo01T0oooo000M0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`0J0?ooo`030000003oool0oooo02d0oooo00<000000?ooo`3oool0;03oool0
0`000000oooo0?ooo`0K0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0H0?ooo`007@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo
02d0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool0603oool001d0oooo00<000000?ooo`3oool03P3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0;`3oool00`000000
oooo0?ooo`0^0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo01P0oooo000L0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo02l0oooo
00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0G0?ooo`00703oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool06P3oool00`000000oooo0?oo
o`0`0?ooo`800000<03oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool03P3oool00`000000oooo0?ooo`0G0?ooo`00703oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0a
0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool05`3oool001`0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01X0oooo00<000000?oo
o`3oool0<@3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01T0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01L0oooo000K0?ooo`03
0000003oool0oooo00h0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo0380oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0I0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0F0?ooo`00
6`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
603oool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0
6@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
5P3oool001/0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0c0?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo01H0oooo000J0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0=03oool0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0E0?ooo`006P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo
03@0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool05@3oool001X0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=@3oool00`000000
oooo0?ooo`0e0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool04@3oool00`000000
oooo0?ooo`0>0?ooo`030000003oool0oooo01D0oooo000I0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo03H0oooo
00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0140oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0D0?ooo`006@3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0603oool00`000000oooo0?oo
o`0Z0?ooo`030?oDV`000000000000<0000000<009_D0?ooo`3oool00`3oool00`000000oooo0?oo
o`0f0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0>0?ooo`030000003oool0oooo01@0oooo000I0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo02h0oooo00<0^W9b
0;[Zo`3oool01P3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo01L0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01@0oooo000I0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo02h0oooo00<0^W9b0;[Zo`3oool01P3oool00`000000oooo0?ooo`0g0?oo
o`030000003oool0oooo01L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo01@0oooo000H0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo02l0oooo00<0^W9b0;[Zo`3o
ool01P3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01<0oooo000H0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo02<0oooo00<0^W800000000000000`0000000`00L[X0oooo0?ooo`030?ooo`030;Yb
LP2jj_l0oooo00H0oooo0`00000h0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01<0oooo000H0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo02l0oooo00<0^W9b0;[Zo`3oool01P3oool00`000000oooo0?ooo`0h0?ooo`030000003o
ool0oooo01L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo01<0oooo000H0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0300oooo00<0^W9b0;[Zo`3oool01P3oool0
0`000000oooo0?ooo`0i0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo01<0oooo000G0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo
02d0oooo00D0j[Yb00000000L[X0^W9b0;[Zo`060?ooo`<00000>P3oool00`000000oooo0?ooo`0G
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0B
0?ooo`005`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0140oooo00<000000?oo
o`3oool05P3oool00`000000oooo0?ooo`0`0?ooo`030>ZjLP000780^^[o0080oooo100000000`3o
ool000000?ooo`04000003L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool04P3oool001L0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool0<@3oool4000000D0oooo00<000000?ooo`3oool00`3oool4000003<0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool04P3oool001L0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool0;`3oool3000000T0oooo00<000000?ooo`3oool0
1`3oool200000340oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool04P3oool001H0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0;@3o
ool2000000`0oooo00<000000?ooo`3oool02@3oool200000300oooo00<000000?ooo`3oool05P3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool04P3o
ool001H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo01D0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00/0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0B0?ooo`005P3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool05P3oool00`00
0000oooo0?ooo`0[0?ooo`8000003`3oool00`000000oooo0?ooo`0<0?ooo`800000;P3oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0A0?ooo`005P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0Z0?ooo`8000004@3oool00`000000
oooo0?ooo`0>0?ooo`800000;03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`005@3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0Y0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0Z0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo0140oooo000E0?ooo`030000003oool0oooo00d0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02P0oooo0P00
000D0?ooo`030000003oool0oooo0140oooo0P00000Z0?ooo`030000003oool0oooo01H0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0140oooo000E
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0503oool2000001@0oooo00<00000
0?ooo`3oool09`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0A0?ooo`005@3oool00`000000oooo0?ooo`0=0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0W0?oo
o`030000003oool0oooo01D0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0W0?oo
o`030000003oool0oooo01D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo0140oooo000D0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool0403oool001@0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0G0?ooo`030000
003oool0oooo01H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0@0?ooo`00503o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0100oooo000D0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0D0?ooo`030000003oool0
oooo02@0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0
oooo02@0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool03`3oool001@0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0903oool00`00
0000oooo0?ooo`0I0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool09@3oool00`00
0000oooo0?ooo`0E0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0?0?ooo`00503oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo01X0
oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo01D0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0
oooo000D0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0D0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`0J0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool001<0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool08`3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo01/0oooo00<0
00000?ooo`3oool08`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`004`3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0R
0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0S
0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00h0oooo000C0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo02<0oooo00<000000?oo
o`3oool0703oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0280oooo00<000000?oo
o`3oool05@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03P3oool001<0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0M0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`00
4`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
503oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0
7P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo000C0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo0240oooo00<000000?ooo`3oool07P3oool2000001l0oooo00<000000?ooo`3oool08@3o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0>0?ooo`004`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0
oooo01l0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00h0oooo000C0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0803oool00`00
0000oooo0?ooo`0O0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03P3oool00180
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0100
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`004P3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0O0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0803oool00`000000oooo
0?ooo`0P0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00d0oooo000B0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool0503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool03@3oool00180oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0R
0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=
0?ooo`004P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool0503oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0280oooo00<000000?oo
o`3oool08@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo000B0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0Q0?ooo`03
0000003oool0oooo0200oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00180oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0
7P3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0
7`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0=0?ooo`004P3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0O0?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0P0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00d0oooo000B0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool08`3oool0
0`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool0
0140oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
01@0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo
0280oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`004@3oool00`000000
oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`0N0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool08`3oool00`000000
oooo0?ooo`0O0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo000A0?ooo`030000003oool0oooo00`0oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo01h0oooo
00<000000?ooo`3oool0903oool2000002@0oooo00<000000?ooo`3oool07`3oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0<0?ooo`004@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool0503oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo02@0oooo00<0
00000?ooo`3oool08`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo000A
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0C
0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0T
0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00140oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool07P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo02@0oooo00<000000?oo
o`3oool07`3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0<0?ooo`004@3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0N0?ooo`03
0000003oool0oooo02D0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0O0?ooo`03
0000003oool0oooo0180oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00`0oooo000A0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0
9P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
303oool00100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo02D0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`00403oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool0
0`000000oooo0?ooo`0N0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00/0oooo000@0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo
01h0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
01l0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool02`3oool00100oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`0W0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool07P3oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`000000
oooo0?ooo`0;0?ooo`00403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02L0oooo
00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00/0oooo
00090?ooo`030?ooe02K0000000000D000003P3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo01<0oooo00<000000?ooo`3oool0103oool00`3oe9/000000000000300000003002Ke03o
ool0oooo0100oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0V0?ooo`030000003o
ool0oooo01@0oooo00<0omBK0000000000000`0000001@00Vm@0oooo0?ooo`3oool0000001@0oooo
00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0=0?ooo`050000003oool0oooo0?ooe02K
00001@0000000`2Ke?l0oooo0?ooo`010?ooo`002P3oool00`3DV`00002K0=Coo`020?ooo`030>Zj
V`000000oooo00d0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo00L0oooo00<0^W9b0;[Zo`3oool04`3oool00`000000oooo0?ooo`0W0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool05`3oool00`2jLW80^^[o0?ooo`040?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0=0?ooo`070000
003oool0oooo0?ooo`3DV`00002K0=Coo`020?ooo`030>ZjV`2jj_l0oooo0080oooo000;0?ooo`03
0?oDV`000780^^[o0080oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool01`3oool00`2jLW80^^[o0?ooo`0C0?ooo`03
0000003oool0oooo02L0oooo0P00000W0?ooo`030000003oool0oooo01L0oooo00<0^W9b0;[Zo`3o
ool0103oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool03@3oool00`000000oooo0?ooo`020?ooo`030?oDV`000780^^[o00H0oooo000<0?ooo`050?oZ
^P1b0000L[[Z0?ooo`0000003P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool01`3oool00`2jLW80^^[o0?ooo`0C0?ooo`030000003oool0oooo02L0
oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0G0?ooo`030;YbLP2jj_l0oooo00@0
oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00d0
oooo00<000000?ooo`3oool00`3oool00`3oj[X0LP0007:jjP050?ooo`0000<0oooo0;Yb00000000
100000000`00L[X0oooo0?ooo`040?ooo`030;Yb001b^^X0000000h0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0A0?ooo`030;Yb00000000000000<0000000<007:j0?ooo`3oool0
0`3oool00`2jLW80^^[o0?ooo`0C0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0
9`3oool00`000000oooo0?ooo`0F0?ooo`030;YbLP2jj_l0oooo00@0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
1@3oool00`2jLP00L[[Z0?ooo`030?ooo`003`3oool00`2jLY/000000?ooo`0=0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`070?ooo`030;YbLP2j
j_l0oooo01<0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0W0?ooo`030000003o
ool0oooo01H0oooo00<0^W9b0;[Zo`3oool0103oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`060?ooo`030;YbV`3D
ool0oooo0080oooo000:0?ooo`030>ZjLP2Ke?l0oooo0080oooo00<0e9/00000003oool03@3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool01`3oool0
0`2jLW80^^[o0?ooo`0C0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool09`3oool0
0`000000oooo0?ooo`0F0?ooo`030;YbLP2jj_l0oooo00@0oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00d0oooo00H000000?ooo`3oool0oooo0>Zj
LP2Ke?l30?ooo`030=BK002Ke?l0oooo0080oooo000:0?ooo`070?oDV`0009/0e?oo0?ooo`3oe9/0
001b0000000>0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`040?ooo`050>ZjLP00000007:j0;YbLP2jj_l0503oool00`000000oooo0?ooo`0W0?oo
o`030000003oool0oooo02L0oooo00<000000?ooo`3oool04`3oool01@3Z^W800000001b^P2jLW80
^^[o00D0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo00d0oooo00/000000?ooo`3oool0oooo0?oDV`0009/0e?oo0?ooo`3oe9/0001b0;[Zo`030?oo
o`002`3oool01P3oe9/00000000000000780^^[o000000h0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00L0oooo00<0j[Yb0000LP2jj_l04`3oool0
0`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool05@3oool0
0`3Z^W80001b0;[Zo`050?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0080oooo00D0omBK000000000000001b0;[Z
o`040?ooo`00403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool04`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02P0oooo00<00000
0?ooo`3oool09`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo000@0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0C0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0W0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00100oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool07@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3o
ool07@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0;0?ooo`00403oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0M0?ooo`030000
003oool0oooo02P0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0L0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00/0oooo000@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0:03o
ool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool00100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0
oooo02P0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`00403oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0:03oool00`00
0000oooo0?ooo`0L0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo00030?ooool000007P00000000T0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`090?ooo`8000003@3oool00`000000oooo
0?ooo`040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`090?ooo`030000003oool0000000d0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`0;0?ooo`030000003oool0000000X0oooo00<000000?ooo`3oool02`3oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool2000000`0oooo
00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0103oool00`000000oooo0?ooo`040?ooo`002@3oool00`000000oooo0?oo
o`040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0C0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0X0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0103oool00100oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool07@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02P0oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00l0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`00403oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00h0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0M0?oo
o`030000003oool0oooo02P0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0L0?oo
o`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo00/0oooo000@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool0:03oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool02`3oool00100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0X0?ooo`030000
003oool0oooo02L0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0;0?ooo`00403o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool09`3o
ool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00/0oooo000@0?ooo`030000003oool0
oooo00`0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo01d0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0W0?ooo`030000003oool0
oooo01d0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool02`3oool00100oooo00<000000?ooo`3oool0303oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool07@3oool00`00
0000oooo0?ooo`0W0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool07@3oool00`00
0000oooo0?ooo`0B0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0;0?ooo`00403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02L0
oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo0180
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00/0
oooo000@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool09`3oool00`000000oooo
0?ooo`0W0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool00100oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02L0oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`00403oool00`000000oooo0?ooo`0<
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0M
0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0N
0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00/0oooo000@0?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01d0oooo00<000000?oo
o`3oool09`3oool2000002L0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?oo
o`00403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3o
ool09P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00/0oooo000@0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo01d0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool00100oooo00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool07@3o
ool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool07P3o
ool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0;0?ooo`00403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0
oooo0180oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo00/0oooo000@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool09P3oool00`00
0000oooo0?ooo`0U0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool02`3oool00100
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo02D0
oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0;0?ooo`00403oool00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0M0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool09@3oool00`000000oooo
0?ooo`0N0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo00/0oooo000A0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01d0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo01h0oooo00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0303oool00140oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0U
0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0B
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0<
0?ooo`004@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo02D0oooo00<000000?oo
o`3oool0903oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo000A0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo01h0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0T0?ooo`03
0000003oool0oooo01l0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool0303oool00140oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0
7P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0
7`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0<0?ooo`004@3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0N0?ooo`030000003o
ool0oooo02@0oooo0P00000T0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0303o
ool00140oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0
oooo02<0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`004@3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0O0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool08P3oool00`00
0000oooo0?ooo`0P0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0=0?ooo`030000003oool0oooo00`0oooo000B0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01l0
oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0200
oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0
oooo00<000000?ooo`3oool03@3oool00180oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool07`3oool00`000000oooo
0?ooo`0S0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool0803oool00`000000oooo
0?ooo`0B0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0=0?ooo`004P3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo00<0
00000?ooo`3oool0503oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo02<0oooo00<0
00000?ooo`3oool08P3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo01<0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00d0oooo000B
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0D
0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0Q
0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0@
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03@3oool00180oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo00<000000?oo
o`3oool07`3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo0240oooo00<000000?oo
o`3oool0803oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0100oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0=0?ooo`004P3oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0O0?ooo`03
0000003oool0oooo0280oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0P0?ooo`03
0000003oool0oooo01<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo00d0oooo000B0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
3`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0
8@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0
503oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
3@3oool00180oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0?0?ooo`030000003o
ool0oooo01@0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0Q0?ooo`030000003o
ool0oooo0200oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0D0?ooo`030000003o
ool0oooo00l0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0=0?ooo`004P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0503oool0
0`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool0803oool0
0`000000oooo0?ooo`0P0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00h0oooo000C0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo
0200oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool03P3oool001<0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool08@3oool00`000000
oooo0?ooo`0O0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`0>0?ooo`004`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo01h0oooo
0P00000O0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool03P3oool001<0oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01@0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo01h0oooo00<0
00000?ooo`3oool08@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0100oooo00<0
00000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`004`3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0R
0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0R
0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0=
0?ooo`030000003oool0oooo00h0oooo000C0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo02<0oooo00<000000?oo
o`3oool0703oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0280oooo00<000000?oo
o`3oool05@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool03P3oool001<0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0?0?ooo`03
0000003oool0oooo01D0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0L0?ooo`03
0000003oool0oooo01/0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`0D0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0>0?ooo`00
4`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
503oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0
6`3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00l0oooo000D0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0D0?ooo`030000003o
ool0oooo02<0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`0J0?ooo`030000003o
ool0oooo02@0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo00`0oooo00<000000?ooo`3oool03`3oool001@0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0903oool0
0`000000oooo0?ooo`0J0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0903oool0
0`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`0?0?ooo`00503oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00l0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0T0?ooo`030000003oool0oooo
01T0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
01D0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00l0oooo000D0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0H0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool03`3oool001@0oooo
00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01@0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0@0?ooo`00503oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0503oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0V0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0<0?ooo`030000003oool0oooo0100oooo000D0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool05P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool05@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool0403oool001D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0E0?oo
o`030000003oool0oooo01@0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0E0?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0A0?oo
o`005@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3o
ool05@3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo01@0oooo0P00000D0?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool04@3oool001D0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
:03oool2000001@0oooo00<000000?ooo`3oool04@3oool2000002X0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
4@3oool001D0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo01D0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0E0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`005P3oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool05@3oool0
0`000000oooo0?ooo`0Z0?ooo`8000004@3oool00`000000oooo0?ooo`0>0?ooo`800000;03oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`0A0?ooo`005P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0[0?ooo`8000003`3oool00`00
0000oooo0?ooo`0<0?ooo`800000;P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`005P3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool05@3oool00`000000
oooo0?ooo`0]0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0]0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo0180oooo000F0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo02d0oooo
0P00000<0?ooo`030000003oool0oooo00T0oooo0P00000`0?ooo`030000003oool0oooo01H0oooo
00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0180oooo
000G0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0F0?ooo`030000003oool0oooo02l0oooo0P00000:0?ooo`030000003oool0oooo00L0oooo0P00
000a0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo0180oooo000G0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool04@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0300oooo10000006
0?ooo`030000003oool0oooo00<0oooo1000000c0?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool0403oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0180oooo000G0?oo
o`030000003oool0oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo03@0oooo100000020?ooo`030000003oool0000000<00000=`3oool00`00
0000oooo0?ooo`0F0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool03P3oool00`00
0000oooo0?ooo`0B0?ooo`005`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0140
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0]0?ooo`030?oDV`000000000000<0
000000@009_D0?ooo`3oool0oooo1000000j0?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0180oooo000H0?ooo`03
0000003oool0oooo00d0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo0300oooo00<0^W9b0;[Zo`3oool01P3oool00`000000oooo0?ooo`0i0?ooo`03
0000003oool0oooo01L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0=0?ooo`03
0000003oool0oooo01<0oooo000H0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo02l0oooo00<0^W9b0;[Zo`3oool0
1P3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01<0oooo000H0?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0G0?ooo`030000003o
ool0oooo02l0oooo00<0^W9b0;[Zo`3oool01P3oool3000003P0oooo00<000000?ooo`3oool05`3o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04`3o
ool001P0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo01L0oooo00<000000?ooo`3oool0;`3oool00`2jLW80^^[o0?ooo`060?ooo`030000003oool0
oooo03P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo00h0oooo00<000000?ooo`3oool04`3oool001T0oooo00<000000?ooo`3oool03@3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0;P3oool00`2j
LW80^^[o0?ooo`060?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool05`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0503oool001T0
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01L0
oooo00<000000?ooo`3oool0;P3oool00`2jLW80^^[o0?ooo`060?ooo`030000003oool0oooo03L0
oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00h0
oooo00<000000?ooo`3oool0503oool001T0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`0A0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0:P3oool01@3Z^W800000
001b^P2jLW80^^[o00L0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0G0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0D0?ooo`00
6@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
5`3oool00`000000oooo0?ooo`0/0?ooo`030>ZjLP000780^^[o00L0oooo00<000000?ooo`3oool0
=P3oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0D0?ooo`006P3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0e0?ooo`030000003o
ool0oooo03D0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0A0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool05@3oool001X0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0=@3oool0
0`000000oooo0?ooo`0d0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01D0oooo000J0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
03@0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo
0140oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0E0?ooo`006`3oool00`000000
oooo0?ooo`0=0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`0c0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0603oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool05P3oool001/0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo01P0oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01T0oooo
00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01H0oooo
000K0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?oo
o`0I0?ooo`030000003oool0oooo0380oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?oo
o`0I0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0F0?ooo`00703oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0140oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo0340oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool05`3oool001`0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0A0?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo01T0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo01L0oooo000L0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0300oooo0P00000`0?ooo`03
0000003oool0oooo01X0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo01L0oooo000L0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
4P3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0
;P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0G0?ooo`007@3oool00`000000oooo0?ooo`0>0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0_0?ooo`030000003o
ool0oooo02h0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo00h0oooo00<000000?ooo`3oool0603oool001d0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0;P3oool0
0`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool04P3oool0
0`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01P0oooo000M0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo
02d0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0H0?ooo`007@3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool06P3oool00`000000
oooo0?ooo`0]0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0703oool00`000000
oooo0?ooo`0B0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool06@3oool001h0oooo
00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01X0oooo
00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo01/0oooo
00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo01T0oooo
000N0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?oo
o`0K0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool03P3oool00`000000oooo0?oo
o`0J0?ooo`007P3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool06`3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo02T0oooo00<00000
0?ooo`3oool0703oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00h0oooo00<00000
0?ooo`3oool06P3oool001h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0D0?oo
o`030000003oool0oooo01/0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0X0?oo
o`030000003oool0oooo01`0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0?0?oo
o`030000003oool0oooo01X0oooo000O0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3o
ool04`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3o
ool09`3oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0K0?ooo`007`3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo01@0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0W0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0C0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool06`3oool001l0oooo00<000000?ooo`3oool0403o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool09P3o
ool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01/0oooo000P0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0M0?ooo`8000009P3oool2
000002D0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0
oooo00l0oooo00<000000?ooo`3oool0703oool00200oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0C0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool08`3oool00`00
0000oooo0?ooo`0S0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`0?0?ooo`030000003oool0oooo01`0oooo000Q0?ooo`030000003oool0oooo00l0
oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0280
oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo01<0
oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0L0?ooo`008@3oool00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool07`3oool00`000000oooo
0?ooo`0Q0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool07`3oool00`000000oooo
0?ooo`0D0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool07@3oool00280oooo00<0
00000?ooo`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool0803oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01d0oooo000R
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0M
0?ooo`008`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01@0oooo00<000000?oo
o`3oool08@3oool2000001l0oooo00<000000?ooo`3oool07@3oool2000002<0oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01h0oooo000S0?ooo`03
0000003oool0oooo00l0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0R0?ooo`03
0000003oool0oooo01`0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`0R0?ooo`03
0000003oool0oooo01@0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0N0?ooo`00
8`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0
8P3oool2000001`0oooo00<000000?ooo`3oool06P3oool2000002@0oooo00<000000?ooo`3oool0
5@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01h0oooo000T0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0T0?ooo`030000003o
ool0oooo01T0oooo00<000000?ooo`3oool0603oool2000002H0oooo00<000000?ooo`3oool0503o
ool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01l0oooo000T0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0T0?ooo`8000006@3oool0
0`000000oooo0?ooo`0F0?ooo`8000009`3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool07`3oool002D0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0E0?ooo`030000003oool0oooo02D0oooo0P00000G0?ooo`030000003oool0oooo
01@0oooo0P00000X0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0403oool00`00
0000oooo0?ooo`0P0?ooo`009@3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool09P3oool2000001D0oooo00<000000?ooo`3oool04P3oool2000002T0
oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0200
oooo000V0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0X0?ooo`<000004P3oool00`000000oooo0?ooo`0?0?ooo`<00000:`3oool00`000000oooo
0?ooo`0E0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool08@3oool002H0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo02X0oooo0P00
000@0?ooo`8000003P3oool2000002d0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`0@0?ooo`030000003oool0oooo0240oooo000W0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool05P3oool00`000000oooo0?ooo`0[0?ooo`<000003@3oool00`000000oooo0?ooo`0:
0?ooo`<00000;P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool08P3oool002L0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0G0?oo
o`030000003oool0oooo02d0oooo1`0000060?ooo`030000003oool0oooo00<0oooo1`00000`0?oo
o`030000003oool0oooo01H0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0R0?oo
o`00:03oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3o
ool0=03oool<000003L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0@0?ooo`03
0000003oool0oooo02<0oooo000X0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo03T0oooo00<000000?ooo`3oool0
5P3oool00`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02<0oooo000Y0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0h0?ooo`030000003o
ool0oooo03P0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo02@0oooo000Y0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0g0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool05`3oool0
0`000000oooo0?ooo`0A0?ooo`030000003oool0oooo02@0oooo000Z0?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo
03L0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo
02D0oooo000Z0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0f0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo02D0oooo000[0?ooo`030000003oool0oooo0100oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo03@0oooo
0P00000J0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool09P3oool002/0oooo00<0
00000?ooo`3oool04@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03@0oooo00<0
00000?ooo`3oool0<`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0140oooo00<0
00000?ooo`3oool09P3oool002`0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`0I
0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool09`3oool002`0oooo00<000000?oo
o`3oool04@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0380oooo00<000000?oo
o`3oool0<@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo0180oooo00<000000?oo
o`3oool09`3oool002d0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0J0?ooo`03
0000003oool0oooo0340oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0J0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0:03oool002d0oooo00<000000?ooo`3oool0
4@3oool00`000000oooo0?ooo`0J0?ooo`800000<@3oool2000002l0oooo0P00000L0?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool0:03oool002h0oooo00<000000?ooo`3oool04@3o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0;@3o
ool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0:@3o
ool002l0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo02d0oooo00<000000?ooo`3oool0;03oool00`000000oooo0?ooo`0K0?ooo`030000003oool0
oooo0180oooo00<000000?ooo`3oool0:P3oool002l0oooo00<000000?ooo`3oool04P3oool00`00
0000oooo0?ooo`0K0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0:`3oool00`00
0000oooo0?ooo`0L0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3oool0:P3oool00300
oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo02/0
oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo0180
oooo00<000000?ooo`3oool0:`3oool00300oooo00<000000?ooo`3oool04P3oool00`000000oooo
0?ooo`0L0?ooo`800000:`3oool00`000000oooo0?ooo`0X0?ooo`8000007P3oool00`000000oooo
0?ooo`0C0?ooo`030000003oool0oooo02/0oooo000a0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo02L0oooo00<0
00000?ooo`3oool07@3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo02`0oooo000a
0?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool07@3oool2000002P0oooo00<00000
0?ooo`3oool09P3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo01<0oooo00<00000
0?ooo`3oool0;03oool00380oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0N0?oo
o`030000003oool0oooo02D0oooo00<000000?ooo`3oool0903oool200000200oooo00<000000?oo
o`3oool04`3oool00`000000oooo0?ooo`0]0?ooo`00<`3oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo01h0oooo0P00000U0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool07`3oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo02h0oooo000c0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0E0?ooo`030?oo
e02K0000000000@0000000<0VmCo0?ooo`3oool00`3oool00`000000oooo0?ooo`0R0?ooo`030000
003oool0oooo01l0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0^0?ooo`00=03o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo0200oooo0P00000F0?ooo`030=BK0000
09/0e?oo0080oooo00<0j[ZK0;[Zo`3oool0103oool00`000000oooo0?ooo`0P0?ooo`8000008P3o
ool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo02l0oooo000d0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0D0?ooo`030?oDV`000780
^^[o00P0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool0;`3oool003D0oooo00<000000?ooo`3oool0503oool00`00
0000oooo0?ooo`0Q0?ooo`8000005@3oool00`3oj[X0LP0007:jjP070?ooo`<00000703oool30000
02<0oooo00<000000?ooo`3oool0503oool00`000000oooo0?ooo`0`0?ooo`00=@3oool00`000000
oooo0?ooo`0E0?ooo`030000003oool0oooo0280oooo0P00000E0?ooo`030;Yb001b^^X0oooo00D0
oooo00<000000?ooo`3oool06P3oool2000002D0oooo00<000000?ooo`3oool0503oool00`000000
oooo0?ooo`0a0?ooo`00=P3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo02<0oooo
0`00000C0?ooo`030;YbV`3Dool0oooo00@0oooo00<000000?ooo`3oool05`3oool3000002H0oooo
00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0a0?ooo`00=`3oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo02D0oooo0P00000<0?ooo`030>ZjLP2Ke?l0oooo0080oooo00<0
e9/009_Do`3oool0103oool00`000000oooo0?ooo`0E0?ooo`800000:03oool00`000000oooo0?oo
o`0E0?ooo`030000003oool0oooo0380oooo000g0?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool09P3oool3000000T0oooo00L0omBK0000V`3Dool0oooo0?oDV`000780^^[o00D0oooo
00<000000?ooo`3oool04P3oool3000002T0oooo00<000000?ooo`3oool05@3oool00`000000oooo
0?ooo`0c0?ooo`00>03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo02P0oooo0`00
00070?ooo`050?oDV`00000000000000LP2jj_l01P3oool00`000000oooo0?ooo`0?0?ooo`<00000
:`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03<0oooo000i0?ooo`030000003o
ool0oooo01H0oooo00<000000?ooo`3oool0:P3oool200000100oooo00<000000?ooo`3oool03@3o
ool2000002d0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0d0?ooo`00>P3oool0
0`000000oooo0?ooo`0F0?ooo`030000003oool0oooo02/0oooo0`00000=0?ooo`030000003oool0
oooo00X0oooo0`00000^0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool0=@3oool0
03X0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0]0?ooo`L000001P3oool00`00
0000oooo0?ooo`030?ooo`L00000<03oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo
03H0oooo000k0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0<`3oool<000003H0
oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0g0?ooo`00?03oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0>03oool00`000000oooo
0?ooo`0G0?ooo`030000003oool0oooo03L0oooo000m0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool0=`3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo01L0oooo00<0
00000?ooo`3oool0>03oool003d0oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`0f
0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`0i
0?ooo`00?P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03D0oooo00<000000?oo
o`3oool0=03oool2000001T0oooo00<000000?ooo`3oool0>P3oool003l0oooo00<000000?ooo`3o
ool0603oool00`000000oooo0?ooo`0d0?ooo`800000=03oool00`000000oooo0?ooo`0H0?ooo`03
0000003oool0oooo03/0oooo00100?ooo`030000003oool0oooo01P0oooo0P00000d0?ooo`030000
003oool0oooo0380oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`0k0?ooo`00@03o
ool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0<03o
ool2000001/0oooo00<000000?ooo`3oool0?03oool00440oooo0P00000K0?ooo`030000003oool0
oooo0300oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0
oooo03d0oooo00130?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0;`3oool00`00
0000oooo0?ooo`0^0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0?P3oool004@0
oooo00<000000?ooo`3oool06@3oool2000002l0oooo00<000000?ooo`3oool0;03oool2000001`0
oooo00<000000?ooo`3oool0?`3oool004D0oooo00<000000?ooo`3oool06P3oool00`000000oooo
0?ooo`0/0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3oool06`3oool00`000000oooo
0?ooo`100?ooo`00AP3oool00`000000oooo0?ooo`0J0?ooo`030000003oool0oooo02/0oooo00<0
00000?ooo`3oool0:P3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0440oooo0017
0?ooo`030000003oool0oooo01X0oooo0P00000[0?ooo`030000003oool0oooo02P0oooo0P00000M
0?ooo`030000003oool0oooo0480oooo00170?ooo`030000003oool0oooo01`0oooo0P00000Y0?oo
o`030000003oool0oooo02H0oooo0P00000N0?ooo`030000003oool0oooo04<0oooo00180?ooo`03
0000003oool0oooo01d0oooo0P00000W0?ooo`030000003oool0oooo02@0oooo0P00000P0?ooo`03
0000003oool0oooo04<0oooo00190?ooo`030000003oool0oooo01h0oooo0P00000U0?ooo`030000
003oool0oooo0280oooo0P00000Q0?ooo`030000003oool0oooo04@0oooo001:0?ooo`030000003o
ool0oooo01l0oooo0P00000S0?ooo`030000003oool0oooo0200oooo0P00000R0?ooo`030000003o
ool0oooo04D0oooo001;0?ooo`030000003oool0oooo0200oooo0`00000P0?ooo`030000003oool0
oooo01h0oooo0P00000S0?ooo`030000003oool0oooo04H0oooo001<0?ooo`030000003oool0oooo
0280oooo0P00000N0?ooo`8000007@3oool2000002@0oooo00<000000?ooo`3oool0A`3oool004d0
oooo00<000000?ooo`3oool08`3oool2000001`0oooo00<000000?ooo`3oool06P3oool2000002D0
oooo00<000000?ooo`3oool0B03oool004h0oooo00<000000?ooo`3oool0903oool2000001X0oooo
00<000000?ooo`3oool05`3oool3000002H0oooo00<000000?ooo`3oool0B@3oool004l0oooo00<0
00000?ooo`3oool09@3oool2000001P0oooo00<000000?ooo`3oool05@3oool2000002P0oooo00<0
00000?ooo`3oool0BP3oool00500oooo0P00000W0?ooo`@00000503oool00`000000oooo0?ooo`0A
0?ooo`@00000:03oool2000004d0oooo001B0?ooo`030000003oool0oooo02P0oooo1P00000>0?oo
o`030000003oool0oooo00/0oooo1P00000[0?ooo`030000003oool0oooo04d0oooo001C0?ooo`03
0000003oool0oooo02d0oooo2@0000050?ooo`030000003oool0oooo00<0oooo2000000`0?ooo`03
0000003oool0oooo04h0oooo001D0?ooo`030000003oool0oooo03D0oooo2`00000g0?ooo`030000
003oool0oooo04l0oooo001E0?ooo`800000>P3oool00`000000oooo0?ooo`0h0?ooo`800000DP3o
ool005L0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0
oooo0580oooo001H0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`1C0?ooo`00F@3oool2000003H0oooo00<000000?ooo`3oool0=03oool2000005H0
oooo001K0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0<`3oool00`000000oooo
0?ooo`1F0?ooo`00G03oool00`000000oooo0?ooo`0b0?ooo`800000<P3oool2000005T0oooo001M
0?ooo`800000<P3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo05T0oooo001O0?oo
o`030000003oool0oooo02l0oooo00<000000?ooo`3oool0;P3oool2000005`0oooo001P0?ooo`03
0000003oool0oooo02h0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`1L0?ooo`00
H@3oool2000002h0oooo00<000000?ooo`3oool0:`3oool2000005l0oooo001S0?ooo`800000;03o
ool00`000000oooo0?ooo`0Y0?ooo`800000H@3oool006D0oooo0P00000Z0?ooo`030000003oool0
oooo02L0oooo0P00001S0?ooo`00I`3oool2000002P0oooo00<000000?ooo`3oool09@3oool20000
06D0oooo001Y0?ooo`<000009@3oool00`000000oooo0?ooo`0S0?ooo`800000I`3oool006`0oooo
0P00000S0?ooo`030000003oool0oooo0240oooo0P00001Y0?ooo`00KP3oool300000200oooo00<0
00000?ooo`3oool07@3oool4000006/0oooo001a0?ooo`<000007@3oool00`000000oooo0?ooo`0J
0?ooo`<00000K`3oool007@0oooo0P00000K0?ooo`030000003oool0oooo01P0oooo0P00001b0?oo
o`00MP3oool3000001P0oooo00<000000?ooo`3oool05@3oool3000007@0oooo001i0?ooo`@00000
503oool200000180oooo1000001g0?ooo`00O@3oool6000000h0oooo00<000000?ooo`3oool02`3o
ool6000007/0oooo00230?ooo`P000001P3oool00`000000oooo0?ooo`030?ooo`P00000P@3oool0
08/0oooo300000290?ooo`00T@3oool00`000000oooo0?ooo`2<0?ooo`00T@3oool00`000000oooo
0?ooo`2<0?ooo`00T@3oool00`000000oooo0?ooo`2<0?ooo`00T@3oool00`000000oooo0?ooo`2<
0?ooo`00T@3oool00`000000oooo0?ooo`2<0?ooo`00T@3oool00`000000oooo0?ooo`2<0?ooo`00
QP3oool01@3DV`000000000000000000L[[Z00H0oooo00<000000?ooo`3oool0S03oool008D0oooo
00L0e9/0002Ke03oool0oooo0?ooe02K0000L[[Z00D0oooo00<000000?ooo`3oool0S03oool008X0
oooo00<0omBK002Ke03oool0103oool00`000000oooo0?ooo`2<0?ooo`00R@3oool00`3oj[X0LP1b
0;[Zo`050?ooo`<00000S03oool008L0oooo00@0j[Yb000000000780^^[o1P3oool00`000000oooo
0?ooo`2<0?ooo`00R@3oool00`3oj[X0LP1b0;[Zo`050?ooo`030000003oool0oooo08`0oooo002:
0?ooo`030=BK002Ke?l0oooo00@0oooo00<000000?ooo`3oool0S03oool008D0oooo00L0omBK0000
LP2jj_l0oooo0?oZ^P1b0780^^[o00D0oooo00<000000?ooo`3oool0S03oool008H0oooo00D0onZj
078000000000000009_Do`060?ooo`030000003oool0oooo08`0oooo002A0?ooo`030000003oool0
oooo08`0oooo002A0?ooo`030000003oool0oooo08`0oooo002A0?ooo`030000003oool0oooo08`0
oooo002A0?ooo`030000003oool0oooo08`0oooo003o0?ooob40oooo003o0?ooob40oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {431, 0}} -> {-2.13211, -3.16276, 0.0220146, \
0.0220146}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Curvas param\[EAcute]tricas en el espacio. Velocidad, aceleraci\[OAcute]n, \
curvatura.\
\>", "Section"],

Cell[TextData[{
  "Las definiciones que hemos dado antes para curvas param\[EAcute]trica en \
el plano pueden generalizarse sin esfuerzo a curvas param\[EAcute]tricas en ",
  
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  ". Como en las aplicaciones f\[IAcute]sicas el caso ",
  Cell[BoxData[
      \(TraditionalForm\`n = 3\)]],
  " tiene especial importancia, consideraremos en lo que sigue curvas en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " aunque la mayor\[IAcute]a de los conceptos que vamos a estudiar se \
generalizan f\[AAcute]cilmente a ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^n\)]],
  ". \nPor definici\[OAcute]n, una curva en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " es una aplicaci\[OAcute]n continua ",
  Cell[BoxData[
      FormBox[
        RowBox[{\(\[Gamma] : \([a, b]\)\), "\[Rule]", 
          FormBox[\(\[DoubleStruckCapitalR]\^3\),
            "TraditionalForm"]}], TraditionalForm]]],
  ". La funci\[OAcute]n \[Gamma] debe ser de la forma"
}], "Text"],

Cell[TextData[Cell[BoxData[
    FormBox[
      RowBox[{\(\[Gamma](t)\), "=", 
        RowBox[{\((x(t), y(t), z(t))\), "=", 
          RowBox[{
            RowBox[{\(x(t)\), 
              StyleBox["i",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(y(t)\), 
              StyleBox["j",
                FontWeight->"Bold"]}], "+", 
            RowBox[{\(z(t)\), 
              StyleBox["k",
                FontWeight->"Bold"]}]}]}]}], TraditionalForm]]]], "Text",
  TextAlignment->Center],

Cell[TextData[{
  "En lo que sigue supondremos que las funciones ",
  Cell[BoxData[
      \(TraditionalForm\`x(t), \ y(t), \ z(t)\)]],
  " son derivables con derivada continua en el intervalo ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  ". El punto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](a)\)]],
  " se llama punto inicial de la curva u origen y el punto ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](b)\)]],
  " se llama punto final o extremo. Cuando ",
  Cell[BoxData[
      \(TraditionalForm\`\[Gamma](a) = \[Gamma](b)\)]],
  " se dice que la curva es cerrada. Una curva se dice que es ",
  StyleBox["simple",
    FontWeight->"Bold"],
  " si pasa una sola vez por cada uno de sus puntos, es decir si no se corta \
a s\[IAcute] misma o, lo que es igual, la funci\[OAcute]n \[Gamma] es \
inyectiva en ",
  Cell[BoxData[
      \(TraditionalForm\`\([a, b]\)\)]],
  ", o sea,",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \[Gamma](u) \[NotEqual] \[Gamma](v)\)\)]],
  " siempre que ",
  Cell[BoxData[
      \(TraditionalForm\`u, v \[Element] \([a, b]\)\)]],
  " y ",
  Cell[BoxData[
      \(TraditionalForm\`u \[NotEqual] v\)]],
  ". Una curva cerrada se dice que es simple si \[Gamma] es inyectiva en",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \([a, \(b[\)\)\)\)]],
  ". Una curva cerrada y simple se llama una curva de Jordan."
}], "Text"],

Cell[TextData[{
  "El comando ParametricPlot3D[{X[t],Y[t],Z[t]},{t,tmin,tmax},opciones] sirve \
para representar curvas en ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleStruckCapitalR]\^3\)]],
  " dadas por sus ecuaciones param\[EAcute]tricas. ",
  "Si a\[NTilde]ades al final una funci\[OAcute]n de color, como en el \
siguiente ejemplo donde se usa la funci\[OAcute]n de color \"Hue[ ]\", los \
puntos de la curva se colorean variando los colores de forma continua. Tambi\
\[EAcute]n puedes controlar el grosor de la l\[IAcute]nea con \"Thickness[ \
]\"."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\(\(helice = 
          ParametricPlot3D[{3  Cos[t], 3  Sin[t], 
              t, {Hue[t/3  \[Pi]], Thickness[ .01]}}, {t, 0, 3  \[Pi]}, 
            Ticks \[Rule] None]\) \);\)\( (*\ 
      una\ h\[EAcute]lice\ circular\ *) \)\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.39134 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.18971 1.41289 7.80626e-017 1.41289 [
[ 0 0 0 0 ]
[ 1 1.39134 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.3832 1.39134 m
1 1.24307 L
s
0 1.09879 m
.3832 1.39134 L
s
.08541 .22749 m
0 1.09879 L
s
.08541 .22749 m
0 1.09879 L
s
0 1.09879 m
.3832 1.39134 L
s
.3832 1.39134 m
.4028 .57475 L
s
.4028 .57475 m
.08541 .22749 L
s
.65448 0 m
.92449 .39685 L
s
.92449 .39685 m
1 1.24307 L
s
1 1.24307 m
.68419 .9 L
s
.68419 .9 m
.65448 0 L
s
.08541 .22749 m
0 1.09879 L
s
0 1.09879 m
.68419 .9 L
s
.68419 .9 m
.65448 0 L
s
.65448 0 m
.08541 .22749 L
s
.4028 .57475 m
.92449 .39685 L
s
.92449 .39685 m
1 1.24307 L
s
1 1.24307 m
.3832 1.39134 L
s
.3832 1.39134 m
.4028 .57475 L
s
0 0 m
1 0 L
1 1.39134 L
0 1.39134 L
closepath
clip
newpath
1 .004 0 r
.01 w
.59689 .64358 m
.56142 .65805 L
s
1 0 .797 r
.63117 .62641 m
.59689 .64358 L
s
1 .804 0 r
.56142 .65805 m
.52522 .66979 L
s
.403 0 1 r
.66378 .6066 m
.63117 .62641 L
s
.396 1 0 r
.52522 .66979 m
.48876 .67879 L
s
0 .397 1 r
.69429 .58426 m
.66378 .6066 L
s
0 1 .404 r
.48876 .67879 m
.45252 .68507 L
s
0 1 .803 r
.72224 .55951 m
.69429 .58426 L
s
0 .795 1 r
.45252 .68507 m
.41698 .68868 L
s
0 1 .002 r
.74723 .53251 m
.72224 .55951 L
s
.005 0 1 r
.41698 .68868 m
.38262 .68969 L
s
.798 1 0 r
.76884 .50347 m
.74723 .53251 L
s
.805 0 1 r
.38262 .68969 m
.34991 .68822 L
s
1 .402 0 r
.7867 .47262 m
.76884 .50347 L
s
1 0 .395 r
.34991 .68822 m
.31933 .68439 L
s
1 0 .398 r
.80048 .44023 m
.7867 .47262 L
s
.801 0 1 r
.80989 .40663 m
.80048 .44023 L
s
1 .405 0 r
.31933 .68439 m
.29134 .67838 L
s
.001 0 1 r
.81468 .37215 m
.80989 .40663 L
s
.794 1 0 r
.29134 .67838 m
.26638 .67038 L
s
0 .799 1 r
.81468 .33719 m
.81468 .37215 L
s
0 1 .006 r
.26638 .67038 m
.24491 .66061 L
s
0 1 .401 r
.80979 .30214 m
.81468 .33719 L
s
.4 1 0 r
.79999 .26746 m
.80979 .30214 L
s
0 1 .806 r
.24491 .66061 m
.22732 .64934 L
s
1 .8 0 r
.78533 .23359 m
.79999 .26746 L
s
0 .394 1 r
.22732 .64934 m
.21399 .63687 L
s
.407 0 1 r
.21399 .63687 m
.20527 .62351 L
s
1 0 .793 r
.20527 .62351 m
.20142 .60963 L
s
1 .007 0 r
.20142 .60963 m
.20267 .59561 L
s
.015 0 1 r
.57956 1.18338 m
.5396 1.19796 L
s
0 .785 1 r
.61855 1.16639 m
.57956 1.18338 L
s
0 1 .415 r
.65604 1.147 m
.61855 1.16639 L
s
.816 0 1 r
.5396 1.19796 m
.49917 1.2101 L
s
.385 1 0 r
.69156 1.12527 m
.65604 1.147 L
s
1 0 .384 r
.49917 1.2101 m
.45878 1.21986 L
s
1 .815 0 r
.7246 1.10126 m
.69156 1.12527 L
s
1 .416 0 r
.45878 1.21986 m
.41895 1.22726 L
s
1 .014 0 r
.7547 1.0751 m
.7246 1.10126 L
s
1 .807 0 r
.20267 .59561 m
.20917 .58186 L
s
.784 1 0 r
.41895 1.22726 m
.3802 1.23238 L
s
1 0 .786 r
.78139 1.04692 m
.7547 1.0751 L
s
.414 0 1 r
.80423 1.0169 m
.78139 1.04692 L
s
0 1 .017 r
.3802 1.23238 m
.34306 1.23531 L
s
.392 1 0 r
.20917 .58186 m
.22096 .5688 L
s
0 .386 1 r
.82281 .98525 m
.80423 1.0169 L
s
0 1 .817 r
.34306 1.23531 m
.30803 1.23618 L
s
0 1 .813 r
.83678 .95221 m
.82281 .98525 L
s
0 1 .408 r
.22096 .5688 m
.23801 .55686 L
s
0 .383 1 r
.30803 1.23618 m
.27563 1.23512 L
s
0 1 .013 r
.84581 .91808 m
.83678 .95221 L
s
.417 0 1 r
.27563 1.23512 m
.24637 1.23231 L
s
0 .792 1 r
.23801 .55686 m
.26015 .54648 L
s
.787 1 0 r
.84963 .88317 m
.84581 .91808 L
s
1 .413 0 r
.84807 .84785 m
.84963 .88317 L
s
1 0 .782 r
.24637 1.23231 m
.22075 1.22793 L
s
.008 0 1 r
.26015 .54648 m
.28712 .53808 L
s
1 0 .388 r
.84102 .81249 m
.84807 .84785 L
s
.809 0 1 r
.28712 .53808 m
.31854 .53206 L
s
.812 0 1 r
.82847 .77752 m
.84102 .81249 L
s
1 0 .391 r
.31854 .53206 m
.35391 .52878 L
s
.012 0 1 r
.81052 .74336 m
.82847 .77752 L
s
1 .409 0 r
.35391 .52878 m
.39262 .52854 L
s
0 .788 1 r
.78738 .71045 m
.81052 .74336 L
s
0 1 .411 r
.75937 .67924 m
.78738 .71045 L
s
.791 1 0 r
.39262 .52854 m
.43396 .5316 L
s
.389 1 0 r
.72694 .65013 m
.75937 .67924 L
s
0 1 .01 r
.43396 .5316 m
.47716 .53814 L
s
1 .811 0 r
.69065 .62353 m
.72694 .65013 L
s
0 1 .81 r
.47716 .53814 m
.52135 .54825 L
s
1 .011 0 r
.65117 .59978 m
.69065 .62353 L
s
0 .39 1 r
.52135 .54825 m
.56567 .56196 L
s
1 0 .79 r
.60923 .57918 m
.65117 .59978 L
s
.41 0 1 r
.56567 .56196 m
.60923 .57918 L
s
0 g
.25 Mabswid
.65448 0 m
.92449 .39685 L
s
.92449 .39685 m
1 1.24307 L
s
1 1.24307 m
.68419 .9 L
s
.68419 .9 m
.65448 0 L
s
.08541 .22749 m
0 1.09879 L
s
0 1.09879 m
.68419 .9 L
s
.68419 .9 m
.65448 0 L
s
.65448 0 m
.08541 .22749 L
s
0 1.09879 m
.3832 1.39134 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{206.938, 287.875},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004f0001[b000`400?l00000o`00003ob@3oool2
000006/0oooo00370?ooo`80000000<0oooo000000000000JP3oool00<@0oooo0`0000030?ooo`80
0000JP3oool00<80oooo0P0000060?ooo`030000003oool0000006T0oooo002o0?ooo`<00000203o
ool010000000oooo0?ooo`00001X0?ooo`00_@3oool2000000/0oooo00@000000?ooo`3oool00000
J03oool00;X0oooo0`00000=0?ooo`050000003oool0oooo0?ooo`000000I`3oool00;P0oooo0P00
000@0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0I03oool00;D0oooo0`00000B
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool0I03oool00;<0oooo0P00000E0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0H`3oool00;00oooo0`00000G0?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0HP3oool00:h0oooo0P00000J0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0H@3oool00:/0oooo0`00000L0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0H@3oool00:T0oooo0P00000O0?ooo`030000003oool0
oooo00H0oooo00<000000?ooo`3oool0H03oool00:H0oooo0`00000Q0?ooo`030000003oool0oooo
00L0oooo00<000000?ooo`3oool0G`3oool00:@0oooo0P00000T0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0G`3oool00:40oooo0`00000W0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0GP3oool009l0oooo0P00000Z0?ooo`030000003oool0oooo00P0oooo00<0
00000?ooo`3oool0G@3oool009`0oooo0`00000/0?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool0G@3oool009T0oooo0`00000_0?ooo`030000003oool0oooo00T0oooo00<000000?oo
o`3oool0G03oool009L0oooo0P00000b0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3o
ool0F`3oool009@0oooo0`00000d0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0
F`3oool00980oooo0P00000g0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0FP3o
ool008l0oooo0`00000i0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0F@3oool0
08d0oooo0P00000l0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0F@3oool008X0
oooo0`00000n0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0F03oool008P0oooo
0P0000110?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0E`3oool008D0oooo0`00
00130?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0E`3oool008<0oooo0P000016
0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0EP3oool00800oooo0`0000180?oo
o`030000003oool0oooo0100oooo00<000000?ooo`3oool0E@3oool007h0oooo0P00001;0?ooo`03
0000003oool0oooo0100oooo00<000000?ooo`3oool0E@3oool007/0oooo0`00001=0?ooo`030000
003oool0oooo0140oooo00<000000?ooo`3oool0E03oool007T0oooo0P00001@0?ooo`030000003o
ool0oooo0180oooo00<000000?ooo`3oool0D`3oool007H0oooo0`00001B0?ooo`030000003oool0
oooo01<0oooo00<000000?ooo`3oool0DP3oool007@0oooo0P00001E0?ooo`030000003oool0oooo
01<0oooo00<000000?ooo`3oool0DP3oool00740oooo0`00001G0?ooo`030000003oool0oooo01@0
oooo00<000000?ooo`3oool0D@3oool006l0oooo0P00001J0?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool0D03oool006`0oooo0`00001L0?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool0D03oool006X0oooo0P00001O0?ooo`030000003oool0oooo01H0oooo00<00000
0?ooo`3oool0C`3oool006L0oooo0`00001Q0?ooo`030000003oool0oooo01L0oooo00<000000?oo
o`3oool0CP3oool006D0oooo0P00001T0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0CP3oool00680oooo0`00001V0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0
C@3oool00600oooo0P00001Y0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0C03o
ool005d0oooo0`00001[0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool0C03oool0
05/0oooo0P00001^0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0B`3oool005P0
oooo0`00001`0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0BP3oool005H0oooo
0P00001c0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0BP3oool005<0oooo0`00
001f0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0B@3oool00540oooo0P00001i
0?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0B03oool004h0oooo0`00001k0?oo
o`030000003oool0oooo01`0oooo00<000000?ooo`3oool0B03oool004`0oooo0P00001n0?ooo`03
0000003oool0oooo01d0oooo00<000000?ooo`3oool0A`3oool004T0oooo0`0000200?ooo`030000
003oool0oooo01h0oooo00<000000?ooo`3oool0AP3oool004L0oooo0P0000230?ooo`030000003o
ool0oooo01l0oooo00<000000?ooo`3oool0A@3oool004@0oooo0`0000250?ooo`030000003oool0
oooo01l0oooo00<000000?ooo`3oool0A@3oool00440oooo0`0000280?ooo`030000003oool0oooo
0200oooo00<000000?ooo`3oool0A03oool003l0oooo0P00002;0?ooo`030000003oool0oooo0240
oooo00<000000?ooo`3oool0@`3oool003`0oooo0`00002=0?ooo`030000003oool0oooo0240oooo
00<000000?ooo`3oool0@`3oool003X0oooo0P00002@0?ooo`030000003oool0oooo0280oooo00<0
00000?ooo`3oool0@P3oool003L0oooo0`00002B0?ooo`030000003oool0oooo02<0oooo00<00000
0?ooo`3oool0@@3oool003D0oooo0P00002E0?ooo`030000003oool0oooo02<0oooo00<000000?oo
o`3oool0@@3oool00380oooo0`00002G0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3o
ool0@03oool00300oooo0P00002J0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0
?`3oool002d0oooo0`00002L0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0?`3o
ool002/0oooo0P00002O0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0?P3oool0
02P0oooo0`00002Q0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0?@3oool002H0
oooo0P00002T0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0?@3oool002<0oooo
0`00002V0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0?03oool00240oooo0P00
002Y0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0>`3oool001h0oooo0`00002[
0?ooo`030000003oool0oooo02T0oooo00<000000?ooo`3oool0>`3oool001`0oooo0P00002^0?oo
o`030000003oool0oooo02X0oooo00<000000?ooo`3oool0>P3oool001X0oooo0P00002`0?ooo`03
0000003oool0oooo02/0oooo00<000000?ooo`3oool0>@3oool001X0oooo0P00002`0?ooo`030000
003oool0oooo0280oooo0`3oc0060?ooo`030000003oool0oooo03T0oooo000J0?ooo`030000003o
ool000000:l0oooo00<000000?ooo`3oool08P3oool30?o<00L0oooo00<000000?ooo`3oool0>03o
ool001X0oooo00@000000?ooo`3oool00000[P3oool00`000000oooo0?ooo`0R0?ooo`@0ol`01`3o
ool00`000000oooo0?ooo`0g0?ooo`006P3oool01@000000oooo0?ooo`3oool000000:d0oooo00<0
00000?ooo`3oool08`3oool30?o<00P0oooo00<000000?ooo`3oool0=P3oool001X0oooo00<00000
0?ooo`3oool00P3oool00`000000oooo0?ooo`2Z0?ooo`030000003oool0oooo02<0oooo103oc007
0?ooo`030000003oool0oooo03H0oooo000I0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0ZP3oool00`000000oooo0?ooo`0T0?ooo`<0ol`0203oool00`000000oooo0?ooo`0e0?oo
o`006@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0:T0oooo00<000000?ooo`3o
ool0903oool30?o<00T0oooo00<000000?ooo`3oool0=03oool001T0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`2Y0?ooo`030000003oool0oooo02<0oooo103oc0080?ooo`030000
003oool0oooo03@0oooo000I0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0Z03o
ool00`000000oooo0?ooo`0T0?ooo`<0ol`02@3oool00`000000oooo0?ooo`0c0?ooo`006@3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo0:L0oooo00<000000?ooo`3oool0903oool4
0?o<00T0oooo00<000000?ooo`3oool0<P3oool001T0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`2V0?ooo`030000003oool0oooo02D0oooo0`3oc0090?ooo`030000003oool0oooo
0380oooo000I0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0Y@3oool00`000000
oooo0?ooo`0U0?ooo`@0ol`02@3oool00`000000oooo0?ooo`0a0?ooo`006@3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo0:@0oooo00<000000?ooo`3oool09P3oool30?o<00X0oooo
00<000000?ooo`3oool0<03oool001T0oooo00<000000?ooo`3oool02`3oool00`000000oooo0?oo
o`2S0?ooo`030000003oool0oooo02H0oooo0`3oc00:0?ooo`030000003oool0oooo0300oooo000I
0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0XP3oool00`000000oooo0?ooo`0V
0?ooo`@0I_l02P3oool00`000000oooo0?ooo`0_0?ooo`00603oool00`000000oooo0?ooo`0>0?oo
o`030000003oool0oooo0:40oooo00<000000?ooo`3oool09`3oool306Ko00/0oooo00<000000?oo
o`3oool0;P3oool001P0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`2Q0?ooo`03
0000003oool0oooo02L0oooo0`1Vo`0;0?ooo`030000003oool0oooo02h0oooo000H0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool0X03oool00`000000oooo0?ooo`0W0?ooo`@0I_l0
2`3oool00`000000oooo0?ooo`0]0?ooo`00603oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo09l0oooo00<000000?ooo`3oool0:03oool306Ko00`0oooo00<000000?ooo`3oool0;03o
ool001P0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`2N0?ooo`030000003oool0
oooo02P0oooo0`1Vo`0<0?ooo`030000003oool0oooo02`0oooo000H0?ooo`030000003oool0oooo
0180oooo00<000000?ooo`3oool0W@3oool00`000000oooo0?ooo`0X0?ooo`@0I_l0303oool00`00
0000oooo0?ooo`0[0?ooo`00603oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo09`0
oooo00<000000?ooo`3oool0:@3oool306Ko00d0oooo00<000000?ooo`3oool0:P3oool001P0oooo
00<000000?ooo`3oool0503oool00`000000oooo0?ooo`2K0?ooo`030000003oool0oooo02T0oooo
0`1Vo`0>0?ooo`030000003oool0oooo02T0oooo000H0?ooo`030000003oool0oooo01D0oooo00<0
00000?ooo`3oool0VP3oool00`000000oooo0?ooo`0Y0?ooo`<0I_l03P3oool00`000000oooo0?oo
o`0Y0?ooo`00603oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo09T0oooo00<00000
0?ooo`3oool0:@3oool3003oIPl0oooo00<000000?ooo`3oool0:03oool001L0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`2H0?ooo`030000003oool0oooo02X0oooo0`00ofH?0?oo
o`030000003oool0oooo02L0oooo000G0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool0V03oool00`000000oooo0?ooo`0Z0?ooo`<00?mV3`3oool00`000000oooo0?ooo`0W0?ooo`00
5`3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0oooo09L0oooo00<000000?ooo`3oool0
:P3oool3003oIQ00oooo00<000000?ooo`3oool09P3oool001L0oooo00<000000?ooo`3oool06P3o
ool00`000000oooo0?ooo`2F0?ooo`030000003oool0oooo02X0oooo0`00ofHA0?ooo`030000003o
ool0oooo02D0oooo000G0?ooo`030000003oool0oooo01/0oooo00<000000?ooo`3oool0U@3oool0
0`000000oooo0?ooo`0Z0?ooo`<00?mV4@3oool00`000000oooo0?ooo`0U0?ooo`005`3oool00`00
0000oooo0?ooo`0L0?ooo`030000003oool0oooo09@0oooo00<000000?ooo`3oool0:P3oool3003o
IQ80oooo00<000000?ooo`3oool0903oool001L0oooo00<000000?ooo`3oool07@3oool00`000000
oooo0?ooo`2C0?ooo`030000003oool0oooo02/0oooo0`00ofHB0?ooo`030000003oool0oooo02<0
oooo000G0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0TP3oool00`000000oooo
0?ooo`0[0?ooo`<00?mV4P3oool00`000000oooo0?ooo`0S0?ooo`005`3oool00`000000oooo0?oo
o`0O0?ooo`030000003oool0oooo0940oooo00<000000?ooo`3oool0:`3oool3003oIQ<0oooo00<0
00000?ooo`3oool08P3oool001L0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`2@
0?ooo`030000003oool0oooo02/0oooo0`00ofHD0?ooo`030000003oool0oooo0240oooo000G0?oo
o`030000003oool0oooo0240oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`0[0?oo
o`<00<co503oool00`000000oooo0?ooo`0Q0?ooo`005P3oool00`000000oooo0?ooo`0S0?ooo`03
0000003oool0oooo08h0oooo00<000000?ooo`3oool0:`3oool3003<oaD0oooo00<000000?ooo`3o
ool0803oool001H0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`2>0?ooo`030000
003oool0oooo02/0oooo0`00c?lF0?ooo`030000003oool0oooo01l0oooo000F0?ooo`030000003o
ool0oooo02@0oooo00<000000?ooo`3oool0SP3oool00`000000oooo0?ooo`0Z0?ooo`<00<co5P3o
ool00`000000oooo0?ooo`0O0?ooo`005P3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0
oooo08d0oooo00<000000?ooo`3oool0:P3oool3003<oaL0oooo00<000000?ooo`3oool07P3oool0
01H0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`2<0?ooo`030000003oool0oooo
02X0oooo0`00c?lH0?ooo`030000003oool0oooo01d0oooo000F0?ooo`030000003oool0oooo02L0
oooo00<000000?ooo`3oool0R`3oool00`000000oooo0?ooo`0Z0?ooo`<00<co603oool00`000000
oooo0?ooo`0M0?ooo`005P3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo08X0oooo
00<000000?ooo`3oool0:P3oool3003<oaT0oooo00<000000?ooo`3oool0703oool001H0oooo00<0
00000?ooo`3oool0:@3oool00`000000oooo0?ooo`290?ooo`030000003oool0oooo02X0oooo0`00
c?lJ0?ooo`030000003oool0oooo01/0oooo000F0?ooo`030000003oool0oooo02X0oooo00<00000
0?ooo`3oool0R03oool00`000000oooo0?ooo`0Z0?ooo`<00<co6`3oool00`000000oooo0?ooo`0J
0?ooo`005P3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo08L0oooo00<000000?oo
o`3oool0:P3oool3003<oa/0oooo00<000000?ooo`3oool06P3oool001D0oooo00<000000?ooo`3o
ool0;@3oool00`000000oooo0?ooo`260?ooo`030000003oool0oooo02X0oooo0`000?lL0?ooo`03
0000003oool0oooo01T0oooo000E0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0
Q@3oool00`000000oooo0?ooo`0Y0?ooo`<0003o7P3oool00`000000oooo0?ooo`0H0?ooo`005@3o
ool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo08D0oooo00<000000?ooo`3oool0:@3o
ool30000oah0oooo00<000000?ooo`3oool0603oool001D0oooo00<000000?ooo`3oool0;`3oool0
0`000000oooo0?ooo`240?ooo`030000003oool0oooo02T0oooo0`000?lO0?ooo`030000003oool0
oooo01L0oooo000E0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool0P`3oool00`00
0000oooo0?ooo`0Y0?ooo`<0003o803oool00`000000oooo0?ooo`0F0?ooo`005@3oool00`000000
oooo0?ooo`0a0?ooo`030000003oool0oooo0880oooo00<000000?ooo`3oool0:@3oool30000ob00
oooo00<000000?ooo`3oool05P3oool001D0oooo00<000000?ooo`3oool0<P3oool00`000000oooo
0?ooo`210?ooo`030000003oool0oooo02T0oooo0`000?lP0?ooo`8000005`3oool001D0oooo00<0
00000?ooo`3oool0<`3oool00`000000oooo0?ooo`200?ooo`030000003oool0oooo02P0oooo0`00
0?lN0?ooo`<0000000<0oooo0000003oool05P3oool001D0oooo00<000000?ooo`3oool0=03oool0
0`000000oooo0?ooo`1o0?ooo`030000003oool0oooo02P0oooo0`000?lK0?ooo`<00000103oool0
0`000000oooo0?ooo`0E0?ooo`005@3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo
07h0oooo00<000000?ooo`3oool0:03oool30000oaP0oooo0`0000070?ooo`030000003oool0oooo
01D0oooo000E0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0O@3oool00`000000
oooo0?ooo`0X0?ooo`<0003o5@3oool3000000X0oooo00<000000?ooo`3oool05@3oool001@0oooo
00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo02L0oooo
103=0?lB0?ooo`<000003@3oool00`000000oooo0?ooo`0E0?ooo`00503oool00`000000oooo0?oo
o`0i0?ooo`030000003oool0oooo07/0oooo00<000000?ooo`3oool09`3oool30<d0oa00oooo0`00
000A0?ooo`030000003oool0oooo01@0oooo000D0?ooo`030000003oool0oooo03T0oooo00<00000
0?ooo`3oool0N`3oool00`000000oooo0?ooo`0W0?ooo`<0c@3o3@3oool3000001@0oooo00<00000
0?ooo`3oool0503oool001@0oooo00<000000?ooo`3oool0>P3oool00`000000oooo0?ooo`1j0?oo
o`030000003oool0oooo02H0oooo103=0?l:0?ooo`<000005`3oool00`000000oooo0?ooo`0D0?oo
o`00503oool00`000000oooo0?ooo`0k0?ooo`030000003oool0oooo07T0oooo00<000000?ooo`3o
ool09P3oool30<d0o`T0oooo0P00000J0?ooo`030000003oool0oooo01@0oooo000D0?ooo`030000
003oool0oooo03`0oooo00<000000?ooo`3oool0N03oool00`000000oooo0?ooo`0V0?ooo`<0c@3o
1P3oool3000001`0oooo00<000000?ooo`3oool0503oool001@0oooo00<000000?ooo`3oool0?@3o
ool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo02D0oooo103=0?l30?ooo`<000007`3o
ool00`000000oooo0?ooo`0D0?ooo`00503oool00`000000oooo0?ooo`0n0?ooo`030000003oool0
oooo07H0oooo00<000000?ooo`3oool09@3oool30<d0o`040?ooo`000000000000000280oooo00<0
00000?ooo`3oool0503oool001@0oooo00<000000?ooo`3oool0?`3oool00`000000oooo0?ooo`1e
0?ooo`030000003oool0oooo02D0oooo0`3=0?l00`000000oooo0?ooo`0S0?ooo`030000003oool0
oooo01@0oooo000D0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0M03oool00`00
0000oooo0?ooo`0S0?ooo`030000003o06D0c@3o0080c@3o9P3oool00`000000oooo0?ooo`0D0?oo
o`004`3oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo07<0oooo00<000000?ooo`3o
ool0803oool3000000040?ooo`3o06D0o`1U0?l0IBL0oooo00<000000?ooo`3oool0503oool001<0
oooo00<000000?ooo`3oool0@`3oool00`000000oooo0?ooo`1b0?ooo`030000003oool0oooo01d0
oooo0`0000040?ooo`<0o`1U9`3oool00`000000oooo0?ooo`0D0?ooo`004`3oool00`000000oooo
0?ooo`140?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool06@3oool3000000H0oooo
103o06DW0?ooo`030000003oool0oooo01@0oooo000C0?ooo`030000003oool0oooo04@0oooo00<0
00000?ooo`3oool0LP3oool00`000000oooo0?ooo`0F0?ooo`<000002@3oool30?l0IBT0oooo00<0
00000?ooo`3oool04`3oool001<0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`1a
0?ooo`030000003oool0oooo01<0oooo0`00000;0?ooo`@0o`1U:@3oool00`000000oooo0?ooo`0C
0?ooo`004`3oool00`000000oooo0?ooo`160?ooo`030000003oool0oooo0700oooo00<000000?oo
o`3oool0403oool3000000h0oooo0`3o06DZ0?ooo`030000003oool0oooo01<0oooo000C0?ooo`03
0000003oool0oooo04L0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`0=0?ooo`<0
00004@3oool30?l0IBX0oooo00<000000?ooo`3oool04`3oool001<0oooo00<000000?ooo`3oool0
B03oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo00X0oooo0`00000C0?ooo`@0o`1U
:P3oool00`000000oooo0?ooo`0C0?ooo`004`3oool00`000000oooo0?ooo`190?ooo`030000003o
ool0oooo06d0oooo00<000000?ooo`3oool01`3oool3000001H0oooo0`3o06D[0?ooo`030000003o
ool0oooo01<0oooo000C0?ooo`030000003oool0oooo04X0oooo00<000000?ooo`3oool0K03oool0
0`000000oooo0?ooo`040?ooo`<00000603oool0103oIP00o`1U0?l0I@3o06D[0?ooo`030000003o
ool0oooo01<0oooo000B0?ooo`030000003oool0oooo04`0oooo00<000000?ooo`3oool0J`3oool0
10000000oooo0?ooo`3oool3000001X0oooo103oIP0/0?ooo`030000003oool0oooo01<0oooo000B
0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3oool0JP3oool4000001d0oooo0`3oIP0]
0?ooo`030000003oool0oooo01<0oooo000B0?ooo`030000003oool0oooo04h0oooo00<000000?oo
o`3oool0J03oool2000001l0oooo103oIP0]0?ooo`030000003oool0oooo01<0oooo000B0?ooo`03
0000003oool0oooo04h0oooo00<000000?ooo`3oool0I@3oool3000000030?ooo`000000oooo01h0
oooo0`3oIP0^0?ooo`030000003oool0oooo01<0oooo000B0?ooo`030000003oool0oooo04l0oooo
00<000000?ooo`3oool0H@3oool3000000@0oooo00<000000?ooo`3oool0703oool40?mV02l0oooo
00<000000?ooo`3oool04P3oool00180oooo00<000000?ooo`3oool0D03oool00`000000oooo0?oo
o`1M0?ooo`<000001`3oool00`000000oooo0?ooo`0L0?ooo`<0ofH0<03oool00`000000oooo0?oo
o`0B0?ooo`004P3oool00`000000oooo0?ooo`1A0?ooo`030000003oool0oooo05T0oooo0`00000:
0?ooo`030000003oool0oooo01/0oooo103oIP0`0?ooo`030000003oool0oooo0180oooo000B0?oo
o`030000003oool0oooo0580oooo00<000000?ooo`3oool0E@3oool3000000d0oooo00<000000?oo
o`3oool06P3oool40?mV0340oooo00<000000?ooo`3oool04P3oool00180oooo00<000000?ooo`3o
ool0D`3oool00`000000oooo0?ooo`1A0?ooo`<00000403oool00`000000oooo0?ooo`0J0?ooo`<0
ofH0<P3oool00`000000oooo0?ooo`0B0?ooo`004P3oool00`000000oooo0?ooo`1D0?ooo`030000
003oool0oooo04d0oooo0`00000C0?ooo`030000003oool0oooo01T0oooo00@0c?l00?mV003oIP00
ofH0<P3oool00`000000oooo0?ooo`0B0?ooo`004P3oool00`000000oooo0?ooo`1E0?ooo`030000
003oool0oooo04T0oooo0`00000F0?ooo`030000003oool0oooo01P0oooo103<o`0c0?ooo`030000
003oool0oooo0180oooo000A0?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3oool0A@3o
ool3000001T0oooo00<000000?ooo`3oool0603oool30<co03@0oooo00<000000?ooo`3oool04P3o
ool00140oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`110?ooo`<00000703oool0
0`000000oooo0?ooo`0G0?ooo`@0c?l0=03oool00`000000oooo0?ooo`0B0?ooo`004@3oool00`00
0000oooo0?ooo`1I0?ooo`030000003oool0oooo03d0oooo0`00000O0?ooo`030000003oool0oooo
01H0oooo103<o`0e0?ooo`030000003oool0oooo0180oooo000A0?ooo`030000003oool0oooo05@0
oooo103o06@<0?mX00P0b_l0:P3oool300000280oooo00<000000?ooo`3oool05P3oool30<co03H0
oooo00<000000?ooo`3oool04P3oool00140oooo00<000000?ooo`3oool0C03oool00`3?0?l0o`1T
0?l0I0090?l0I0`0ofP03@3:o`05003o0Qd0oooo0`00000U0?ooo`030000003oool0oooo01D0oooo
103<o`0g0?ooo`030000003oool0oooo0140oooo000A0?ooo`030000003oool0oooo04L0oooo1P3?
0?l;0?l0I0`0ofP03@3:o`0;003o0Q@0oooo0`00000X0?ooo`030000003oool0oooo01@0oooo103<
o`0h0?ooo`030000003oool0oooo0140oooo000A0?ooo`030000003oool0oooo04<0oooo2P3?0?l7
0?l0I0P0oooo00<000000?ooo`3oool03@3oool50<[o00d00?l21000oll;0?ooo`<00000:`3oool0
0`000000oooo0?ooo`0C0?ooo`04003o003<o`00c?l00<co03T0oooo00<000000?ooo`3oool04@3o
ool00140oooo00<000000?ooo`3oool0@03oool30080o`T0c`3o4@3oool00`000000oooo0?ooo`0F
0?ooo`P00?l22000oll40?ooo`<00000;P3oool00`000000oooo0?ooo`0B0?ooo`800?l00`3<o`0i
0?ooo`030000003oool0oooo0140oooo000A0?ooo`030000003oool0oooo03d0oooo1P020?l40<l0
oaL0oooo00<000000?ooo`3oool06`3oool2003o0Pd00?o?<03oool00`000000oooo0?ooo`0A0?oo
o`@00?l0>`3oool00`000000oooo0?ooo`0A0?ooo`004@3oool00`000000oooo0?ooo`0k0?ooo`T0
0P3o6`3oool00`000000oooo0?ooo`0P0?ooo`X00?o?0`00Hol/0?ooo`030000003oool0oooo0100
oooo1000o`0l0?ooo`030000003oool0oooo0140oooo000@0?ooo`030000003oool0oooo03T0oooo
0`00b_l60080oal0oooo00<000000?ooo`3oool07`3oool200000080oooo1P00oll6001SobT0oooo
00<000000?ooo`3oool03`3oool4003o03d0oooo00<000000?ooo`3oool04@3oool00100oooo00<0
00000?ooo`3oool0=`3oool5003:o`<00P3o8`3oool00`000000oooo0?ooo`0K0?ooo`<000002@3o
ool00`00oll006?o001So`07001SobL0oooo00<000000?ooo`3oool03@3oool4003o03h0oooo00<0
00000?ooo`3oool04@3oool00100oooo00<000000?ooo`3oool0=@3oool8003:obH0oooo00<00000
0?ooo`3oool05`3oool3000000l0oooo2P00HolT0?ooo`030000003oool0oooo00`0oooo1000o`0o
0?ooo`030000003oool0oooo0140oooo000@0?ooo`030000003oool0oooo03@0oooo00<00?mX003:
o`00b_l00`00b_lZ0?ooo`030000003oool0oooo01<0oooo0`00000E0?ooo`X006?o8@3oool00`00
0000oooo0?ooo`0;0?ooo`@00?l0@03oool00`000000oooo0?ooo`0A0?ooo`00403oool00`000000
oooo0?ooo`0c0?ooo`800?mX0`00b_l/0?ooo`030000003oool0oooo0100oooo0`00000K0?ooo`H0
06?o0`1X0?lO0?ooo`030000003oool0oooo00X0oooo1000o`000`00old0oooo0?ooo`0n0?ooo`03
0000003oool0oooo0140oooo000@0?ooo`030000003oool0oooo0340oooo00<0I?l0003oJ000ofP0
0P00ofP_0?ooo`030000003oool0oooo00`0oooo0`00000Q0?ooo`<006?o1P1X0?lL0?ooo`030000
003oool0oooo00T0oooo0P00old2003o0480oooo00<000000?ooo`3oool04@3oool00100oooo00<0
00000?ooo`3oool0<03oool5003oJ340oooo00<000000?ooo`3oool0203oool3000002L0oooo201X
0?lJ0?ooo`030000003oool0oooo00P0oooo1000ole40?ooo`030000003oool0oooo0100oooo000@
0?ooo`030000003oool0oooo02l0oooo1@00ofPc0?ooo`030000003oool0oooo00@0oooo0`00000/
0?ooo`T0J03o5`3oool00`000000oooo0?ooo`070?ooo`@00?o=A@3oool00`000000oooo0?ooo`0@
0?ooo`00403oool00`000000oooo0?ooo`0^0?ooo`80I?l00P00ofPf0?ooo`030000003oool0oooo
00<00000<P3oool906P0oa@0oooo00<000000?ooo`3oool01P3oool4003ocDH0oooo00<000000?oo
o`3oool0403oool00100oooo00<000000?ooo`3oool0;@3oool406Co03P0oooo0P00000g0?ooo`T0
J03o4P3oool00`000000oooo0?ooo`050?ooo`@00?o=A`3oool00`000000oooo0?ooo`0@0?ooo`00
403oool00`000000oooo0?ooo`0/0?ooo`@0I?l0>@3oool00`000000oooo0?ooo`0i0?ooo`H0J03o
0P3o0<X@0?ooo`030000003oool0oooo00@0oooo1000ole80?ooo`030000003oool0oooo0100oooo
000?0?ooo`030000003oool0oooo02`0oooo101To`0j0?ooo`030000003oool0oooo03`0oooo0`1X
0?l40?l0bPh0oooo00<000000?ooo`3oool00P3oool5003ocDT0oooo00<000000?ooo`3oool0403o
ool000l0oooo00<000000?ooo`3oool0;03oool0103ocP00I?l006Co003ocP0j0?ooo`030000003o
ool0oooo03h0oooo203o0<X;0?ooo`040000003oool0oooo0?ooo`D00?o=BP3oool00`000000oooo
0?ooo`0@0?ooo`003`3oool00`000000oooo0?ooo`0/0?ooo`<0olh0>`3oool00`000000oooo0?oo
o`100?ooo`P0o`3:2@3oool00`000000oooo0?ooo`02001Uo`800?o=00<006Go0?ooo`3oool0B@3o
ool00`000000oooo0?ooo`0@0?ooo`003`3oool00`000000oooo0?ooo`0[0?ooo`@0olh0>`3oool0
0`000000oooo0?ooo`120?ooo`P0o`3:1`3oool00`00000006Go001Uo`03001Uodd0oooo00<00000
0?ooo`3oool0403oool000l0oooo00<000000?ooo`3oool0:`3oool30?o>03`0oooo00<000000?oo
o`3oool0A@3oool70?l0bPD0oooo00<00000001Uo`00IOl00P00IOm>0?ooo`030000003oool0oooo
0100oooo000?0?ooo`030000003oool0oooo02/0oooo0`3ocP0l0?ooo`030000003oool0oooo04L0
oooo1@3o0<X01P3o0P00oooo0?ooo`3oool006Go000000<006GoC`3oool00`000000oooo0?ooo`0@
0?ooo`003`3oool00`000000oooo0?ooo`0[0?ooo`<0o`40?03oool00`000000oooo0?ooo`190?oo
o`<0o`3:0`3o0P02001Uo`0300000000IOl0oooo0540oooo00<000000?ooo`3oool03`3oool000l0
oooo00<000000?ooo`3oool0:`3oool30?l103`0oooo00<000000?ooo`3oool0B`3oool50?l20003
001Uo`000000oooo0580oooo00<000000?ooo`3oool03`3oool000l0oooo00<000000?ooo`3oool0
:`3oool30?l103`0oooo00<000000?ooo`3oool0C03oool50?l200030000003oool0oooo0540oooo
00<000000?ooo`3oool03`3oool000l0oooo00<000000?ooo`3oool0:`3oool30?l103`0oooo00<0
00000?ooo`3oool0BP3oool306L0o`06001Uo`3o0P00o`800?l200000000o`80DP3oool00`000000
oooo0?ooo`0?0?ooo`003P3oool00`000000oooo0?ooo`0/0?ooo`<0o`3;?03oool00`000000oooo
0?ooo`180?ooo`H0I`3o00@0oooo0?l2003o0P0000000`3o0P1@0?ooo`030000003oool0oooo00l0
oooo000>0?ooo`030000003oool0oooo02d0oooo0`3o0</k0?ooo`030000003oool0oooo04H0oooo
1`1W0?l40?ooo`030000003o0P00o`800080o`80C`3oool00`000000oooo0?ooo`0?0?ooo`003P3o
ool00`000000oooo0?ooo`0]0?ooo`<0o`3;>`3oool00`000000oooo0?ooo`150?ooo`H0I`3o1P3o
ool00`000000o`800?l200040?l204d0oooo00<000000?ooo`3oool03`3oool000h0oooo00<00000
0?ooo`3oool0;@3oool30?l0bc/0oooo00<000000?ooo`3oool0@`3oool606L0o`P0oooo00<00000
0?ooo`3oool0103o0P000`3oc`00oooo0?ooo`1:0?ooo`030000003oool0oooo00l0oooo000>0?oo
o`030000003oool0oooo02d0oooo0`3o0</00`1X0?l0oooo0?ooo`0h0?ooo`030000003oool0oooo
0440oooo0P3o0<`406L0o`X0oooo00@000000?ooo`3oool0oooo0`3o0P020?o?04/0oooo00<00000
0?ooo`3oool03`3oool000h0oooo00<000000?ooo`3oool0;P3oool406P0ocT0oooo00<000000?oo
o`3oool0?P3oool50?l0c0<0I`3o2`3oool00`000000oooo0?ooo`030?ooo`D0oll0B@3oool00`00
0000oooo0?ooo`0?0?ooo`003P3oool00`000000oooo0?ooo`0_0?ooo`<0J03o>@3oool00`000000
oooo0?ooo`0l0?ooo`P0o`3<3@3oool00`000000oooo0?ooo`040?ooo`D0oll0B03oool00`000000
oooo0?ooo`0?0?ooo`003P3oool00`000000oooo0?ooo`0_0?ooo`04001To`1X0?l0J03o06P0ocP0
oooo00<000000?ooo`3oool0>P3oool80?l0c0l0oooo00<000000?ooo`3oool01@3oool60?o?04L0
oooo00<000000?ooo`3oool03P3oool000h0oooo00<000000?ooo`3oool0<03oool306P0o`03001T
o`3oool0oooo03D0oooo00<000000?ooo`3oool0>03oool70?l0c180oooo00<000000?ooo`3oool0
1`3oool50?o?04H0oooo00<000000?ooo`3oool03P3oool000h0oooo00<000000?ooo`3oool0<@3o
ool0101X0?l006Co001To`00I?le0?ooo`030000003oool0oooo03H0oooo0`3o0@050?l0c1@0oooo
00<000000?ooo`3oool0203oool50?o?04D0oooo00<000000?ooo`3oool03P3oool000d0oooo00<0
00000?ooo`3oool0<`3oool4001To`03003ocP3oool0oooo0340oooo00<000000?ooo`3oool0<`3o
ool60?l100<0o`3<5P3oool00`000000oooo0?ooo`0:0?ooo`D0oll0@`3oool00`000000oooo0?oo
o`0>0?ooo`003@3oool00`000000oooo0?ooo`0d0?ooo`@006Co00<00?o>0?ooo`3oool0<03oool0
0`000000oooo0?ooo`0`0?ooo`X0o`406@3oool00`000000oooo0?ooo`0:0?ooo`@0oll000<0Hol0
0?ooo`3oool0@03oool00`000000oooo0?ooo`0>0?ooo`003@3oool00`000000oooo0?ooo`0e0?oo
o`<006Co0`00olh`0?ooo`030000003oool0oooo02h0oooo0`3oc@060?l101`0oooo00<000000?oo
o`3oool02`3oool30?o?0080Hol0@@3oool00`000000oooo0?ooo`0>0?ooo`003@3oool00`000000
oooo0?ooo`0f0?ooo`03001To`00olh00?o>00@00?o>;P3oool00`000000oooo0?ooo`0[0?ooo`H0
old00`3o0@0O0?ooo`030000003oool0oooo00d0oooo101So`100?ooo`030000003oool0oooo00h0
oooo000=0?ooo`030000003oool0oooo03P0oooo1@00olh2003o0B`0oooo00<000000?ooo`3oool0
:03oool90?o=0280oooo00<000000?ooo`3oool03P3oool406?o03l0oooo00<000000?ooo`3oool0
3P3oool000d0oooo00<000000?ooo`3oool0>P3oool3003ocPD00?l1:@3oool00`000000oooo0?oo
o`0U0?ooo`X0old0903oool00`000000oooo0?ooo`0?0?ooo`@0Hol0?P3oool00`000000oooo0?oo
o`0>0?ooo`003@3oool00`000000oooo0?ooo`0l0?ooo`P00?l19`3oool00`000000oooo0?ooo`0S
0?ooo`<0IOl01P3oc@0W0?ooo`030000003oool0oooo0100oooo101So`0m0?ooo`030000003oool0
oooo00h0oooo000=0?ooo`030000003oool0oooo03h0oooo1P00o`430<_o02@0oooo00<000000?oo
o`3oool07`3oool706Go00<0old0:P3oool00`000000oooo0?ooo`0A0?ooo`@0Hol0?03oool00`00
0000oooo0?ooo`0>0?ooo`003@3oool00`000000oooo0?ooo`110?ooo`<00?l11P3;o`0Q0?ooo`03
0000003oool0oooo01/0oooo2`1Uo`0]0?ooo`030000003oool0oooo0180oooo101So`000`00ofT0
oooo0?ooo`0h0?ooo`030000003oool0oooo00h0oooo000=0?ooo`030000003oool0oooo04<0oooo
2@3;o`000`3oI`00oooo0?ooo`0L0?ooo`030000003oool0oooo01L0oooo1000ofL806Go0300oooo
00<000000?ooo`3oool04`3oool506?o03X0oooo00<000000?ooo`3oool03@3oool000d0oooo00<0
00000?ooo`3oool0AP3oool60<_o00@0ofL06`3oool00`000000oooo0?ooo`0A0?ooo`X00?mW101U
o`0d0?ooo`030000003oool0oooo01@0oooo1@1So`0i0?ooo`030000003oool0oooo00d0oooo000<
0?ooo`030000003oool0oooo04X0oooo0`3;o`080?mW00<0o`1U503oool00`000000oooo0?ooo`09
0?ooo`L00<_o2`00ofLh0?ooo`030000003oool0oooo01H0oooo0P1So`000`00ofT0oooo0?ooo`0g
0?ooo`030000003oool0oooo00d0oooo000<0?ooo`030000003oool0oooo04h0oooo1`3oI`0:0?l0
I@X0cP3o2`010?l;003;o`L00?mW?03oool00`000000oooo0?ooo`0F0?ooo`@00?mY>03oool00`00
0000oooo0?ooo`0=0?ooo`00303oool00`000000oooo0?ooo`1A0?ooo`@0ofL02P3o06D:0<h0o`/0
0@3o2`00bol00`00ofL0oooo0?ooo`100?ooo`030000003oool0oooo01L0oooo1000ofTg0?ooo`03
0000003oool0oooo00d0oooo000<0?ooo`030000003oool0oooo05P0oooo1`3o06D:0<h0o`/00@3o
1000bom:0?ooo`030000003oool0oooo01P0oooo1000ofTf0?ooo`030000003oool0oooo00d0oooo
000<0?ooo`030000003oool0oooo06`0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?oo
o`0I0?ooo`@00?mY=@3oool00`000000oooo0?ooo`0=0?ooo`00303oool00`000000oooo0?ooo`1/
0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool06P3oool4003oJC@0oooo00<00000
0?ooo`3oool03@3oool000`0oooo00<000000?ooo`3oool0K03oool00`000000oooo0?ooo`1C0?oo
o`030000003oool0oooo01/0oooo1000ofTc0?ooo`030000003oool0oooo00d0oooo000<0?ooo`03
0000003oool0oooo06`0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0L0?ooo`@0
0?mY<P3oool00`000000oooo0?ooo`0=0?ooo`00303oool00`000000oooo0?ooo`1/0?ooo`030000
003oool0oooo05<0oooo00<000000?ooo`3oool07@3oool3003oJ@030039o`3oool0oooo02l0oooo
00<000000?ooo`3oool03@3oool000`0oooo00<000000?ooo`3oool0K03oool00`000000oooo0?oo
o`1C0?ooo`030000003oool0oooo01h0oooo0`00ofTb0?ooo`030000003oool0oooo00`0oooo000;
0?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0N
0?ooo`<00?mY00<00<Wo0?ooo`3oool0;`3oool00`000000oooo0?ooo`0<0?ooo`002`3oool00`00
0000oooo0?ooo`1]0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool07`3oool01000
ofT00<Wo0039o`00bOl`0?ooo`030000003oool0oooo00`0oooo000;0?ooo`030000003oool0oooo
06d0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`0P0?ooo`<00<Wo<03oool00`00
0000oooo0?ooo`0<0?ooo`002`3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo05<0
oooo00<000000?ooo`3oool0803oool40039obl0oooo00<000000?ooo`3oool0303oool000/0oooo
00<000000?ooo`3oool0K@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo0240oooo
1000bOl^0?ooo`030000003oool0oooo00`0oooo000;0?ooo`030000003oool0oooo06d0oooo00<0
00000?ooo`3oool0D`3oool00`000000oooo0?ooo`0R0?ooo`@00<Wo;@3oool00`000000oooo0?oo
o`0<0?ooo`002`3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo05<0oooo00<00000
0?ooo`3oool08`3oool30039obd0oooo00<000000?ooo`3oool0303oool000/0oooo00<000000?oo
o`3oool0K@3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo02<0oooo1000bOl/0?oo
o`030000003oool0oooo00`0oooo000;0?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3o
ool0D`3oool00`000000oooo0?ooo`0T0?ooo`@00<Wo:`3oool00`000000oooo0?ooo`0<0?ooo`00
2`3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool0
9@3oool30039ob/0oooo00<000000?ooo`3oool0303oool000X0oooo00<000000?ooo`3oool0KP3o
ool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo02D0oooo0`00bOl00`030?l0oooo0?oo
o`0Y0?ooo`030000003oool0oooo00/0oooo000:0?ooo`030000003oool0oooo06h0oooo00<00000
0?ooo`3oool0E03oool00`000000oooo0?ooo`0U0?ooo`@00`3o:P3oool00`000000oooo0?ooo`0;
0?ooo`002P3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo05@0oooo00<000000?oo
o`3oool09P3oool300<0obX0oooo00<000000?ooo`3oool02`3oool000X0oooo00<000000?ooo`3o
ool0KP3oool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo02H0oooo10030?lY0?ooo`03
0000003oool0oooo00/0oooo000:0?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3oool0
E03oool00`000000oooo0?ooo`0W0?ooo`<00`3o:@3oool00`000000oooo0?ooo`0;0?ooo`002P3o
ool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool09`3o
ool400<0obP0oooo00<000000?ooo`3oool02`3oool000X0oooo00<000000?ooo`3oool0KP3oool0
0`000000oooo0?ooo`1D0?ooo`030000003oool0oooo02P0oooo0`030?lX0?ooo`030000003oool0
oooo00/0oooo000:0?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3oool0E03oool00`00
0000oooo0?ooo`0X0?ooo`@00`3o9`3oool00`000000oooo0?ooo`0;0?ooo`002P3oool00`000000
oooo0?ooo`1^0?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0:@3oool400<0obH0
oooo00<000000?ooo`3oool02`3oool000X0oooo00<000000?ooo`3oool0KP3oool00`000000oooo
0?ooo`1D0?ooo`030000003oool0oooo02X0oooo0`030?lV0?ooo`030000003oool0oooo00/0oooo
000:0?ooo`030000003oool0oooo06d0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?oo
o`0Z0?ooo`<00`3o00<0c`3o0?ooo`3oool08`3oool00`000000oooo0?ooo`0;0?ooo`002@3oool0
0`000000oooo0?ooo`1^0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0:`3oool3
0<l0obD0oooo00<000000?ooo`3oool02`3oool000T0oooo00<000000?ooo`3oool0KP3oool00`00
0000oooo0?ooo`1E0?ooo`030000003oool0oooo02/0oooo0`3?0?lV0?ooo`030000003oool0oooo
00X0oooo00090?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3oool0E@3oool00`000000
oooo0?ooo`0[0?ooo`@0c`3o9@3oool00`000000oooo0?ooo`0:0?ooo`002@3oool00`000000oooo
0?ooo`1^0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0;03oool30<l0obD0oooo
00<000000?ooo`3oool02P3oool000T0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?oo
o`1E0?ooo`030000003oool0oooo02`0oooo0`3?0?lU0?ooo`030000003oool0oooo00X0oooo0009
0?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0/
0?ooo`@0c`3o903oool00`000000oooo0?ooo`0:0?ooo`002@3oool00`000000oooo0?ooo`1^0?oo
o`030000003oool0oooo05D0oooo00<000000?ooo`3oool0;@3oool30<l0ob@0oooo00<000000?oo
o`3oool02P3oool000T0oooo00<000000?ooo`3oool0KP3oool00`000000oooo0?ooo`1E0?ooo`03
0000003oool0oooo02d0oooo0`3?0?lT0?ooo`030000003oool0oooo00X0oooo00090?ooo`030000
003oool0oooo06h0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0]0?ooo`@0c`3o
8`3oool00`000000oooo0?ooo`0:0?ooo`002@3oool00`000000oooo0?ooo`1^0?ooo`030000003o
ool0oooo05D0oooo00<000000?ooo`3oool0;P3oool30<l0ob<0oooo00<000000?ooo`3oool02P3o
ool000P0oooo00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0
oooo02h0oooo0`3?0?lS0?ooo`030000003oool0oooo00X0oooo00080?ooo`030000003oool0oooo
06l0oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`0^0?ooo`<0o`1S8`3oool00`00
0000oooo0?ooo`0:0?ooo`00203oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo05D0
oooo00<000000?ooo`3oool0;`3oool30?l0Hb<0oooo00<000000?ooo`3oool02@3oool000P0oooo
00<000000?ooo`3oool0K`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo02l0oooo
0`3o06<S0?ooo`030000003oool0oooo00T0oooo00080?ooo`030000003oool0oooo06l0oooo00<0
00000?ooo`3oool0E@3oool00`000000oooo0?ooo`0_0?ooo`<0o`1S8`3oool00`000000oooo0?oo
o`090?ooo`00203oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo05D0oooo00<00000
0?ooo`3oool0;`3oool30?l0Hb<0oooo00<000000?ooo`3oool02@3oool000P0oooo00<000000?oo
o`3oool0K`3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo02l0oooo0`3o06<S0?oo
o`030000003oool0oooo00T0oooo00080?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3o
ool0E@3oool00`000000oooo0?ooo`0_0?ooo`<0o`1S8`3oool00`000000oooo0?ooo`090?ooo`00
203oool00`000000oooo0?ooo`1_0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0
<03oool30?l0Hb80oooo00<000000?ooo`3oool02@3oool000P0oooo00<000000?ooo`3oool0K`3o
ool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo0300oooo0`3o06<R0?ooo`030000003o
ool0oooo00T0oooo00080?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool0E@3oool0
0`000000oooo0?ooo`0`0?ooo`<0o`1S8P3oool00`000000oooo0?ooo`090?ooo`001`3oool00`00
0000oooo0?ooo`1`0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0;`3oool30?l0
Hb80oooo00<000000?ooo`3oool02@3oool000L0oooo00<000000?ooo`3oool0L03oool00`000000
oooo0?ooo`1F0?ooo`030000003oool0oooo02l0oooo0`3oJ@0R0?ooo`030000003oool0oooo00T0
oooo00070?ooo`030000003oool0oooo0700oooo00<000000?ooo`3oool0EP3oool00`000000oooo
0?ooo`0_0?ooo`<0ofT08`3oool00`000000oooo0?ooo`080?ooo`001`3oool00`000000oooo0?oo
o`1`0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0;`3oool30?mY02<0oooo00<0
00000?ooo`3oool0203oool000L0oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`1F
0?ooo`030000003oool0oooo02l0oooo0`3oJ@0S0?ooo`030000003oool0oooo00P0oooo00070?oo
o`030000003oool0oooo0700oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`0_0?oo
o`<0ofT08`3oool00`000000oooo0?ooo`080?ooo`001`3oool00`000000oooo0?ooo`1`0?ooo`03
0000003oool0oooo05H0oooo00<000000?ooo`3oool0;`3oool30?mY02<0oooo00<000000?ooo`3o
ool0203oool000L0oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`1F0?ooo`030000
003oool0oooo02l0oooo0`3oJ@0S0?ooo`030000003oool0oooo00P0oooo00070?ooo`030000003o
ool0oooo0700oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`0_0?ooo`<0ofT08`3o
ool00`000000oooo0?ooo`080?ooo`001`3oool00`000000oooo0?ooo`1`0?ooo`030000003oool0
oooo05H0oooo00<000000?ooo`3oool0;`3oool30?mY02<0oooo00<000000?ooo`3oool0203oool0
00H0oooo00<000000?ooo`3oool0L@3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo
02l0oooo0`3oJ@0S0?ooo`030000003oool0oooo00P0oooo00060?ooo`030000003oool0oooo0740
oooo00<000000?ooo`3oool0EP3oool00`000000oooo0?ooo`0_0?ooo`<0ofT08`3oool00`000000
oooo0?ooo`080?ooo`001P3oool00`000000oooo0?ooo`1a0?ooo`030000003oool0oooo05H0oooo
00<000000?ooo`3oool0;`3oool30<Wo02<0oooo00<000000?ooo`3oool0203oool000H0oooo00<0
00000?ooo`3oool0L@3oool00`000000oooo0?ooo`1F0?ooo`030000003oool0oooo02l0oooo0`39
o`0S0?ooo`030000003oool0oooo00P0oooo00060?ooo`030000003oool0oooo0740oooo00<00000
0?ooo`3oool0EP3oool00`000000oooo0?ooo`0_0?ooo`<0bOl0903oool00`000000oooo0?ooo`07
0?ooo`001P3oool00`000000oooo0?ooo`1a0?ooo`030000003oool0oooo05D0oooo0P00000a0?oo
o`<0bOl0903oool00`000000oooo0?ooo`070?ooo`001P3oool00`000000oooo0?ooo`1a0?ooo`03
0000003oool0oooo0540oooo100000020?ooo`030000003oool0oooo02d0oooo0`39o`0U0?ooo`03
0000003oool0oooo00L0oooo00060?ooo`030000003oool0oooo0740oooo00<000000?ooo`3oool0
CP3oool3000000L0oooo00<000000?ooo`3oool0;03oool30<Wo02D0oooo00<000000?ooo`3oool0
1`3oool000H0oooo00<000000?ooo`3oool0L@3oool00`000000oooo0?ooo`1;0?ooo`<000002`3o
ool00`000000oooo0?ooo`0[0?ooo`<0bOl09@3oool00`000000oooo0?ooo`070?ooo`001P3oool0
0`000000oooo0?ooo`1a0?ooo`030000003oool0oooo04L0oooo1000000?0?ooo`030000003oool0
oooo02X0oooo0`39o`0U0?ooo`030000003oool0oooo00L0oooo00050?ooo`030000003oool0oooo
0740oooo00<000000?ooo`3oool0A@3oool3000001@0oooo00<000000?ooo`3oool0:@3oool30<Wo
02D0oooo00<000000?ooo`3oool01`3oool000D0oooo00<000000?ooo`3oool0L@3oool00`000000
oooo0?ooo`110?ooo`@00000603oool00`000000oooo0?ooo`0X0?ooo`<0bOl09@3oool00`000000
oooo0?ooo`070?ooo`001@3oool00`000000oooo0?ooo`1a0?ooo`030000003oool0oooo03h0oooo
0`00000L0?ooo`030000003oool0oooo02P0oooo0`39o`0U0?ooo`030000003oool0oooo00L0oooo
00050?ooo`030000003oool0oooo0740oooo00<000000?ooo`3oool0>`3oool300000200oooo00<0
00000?ooo`3oool09P3oool4003o0bD0oooo00<000000?ooo`3oool01`3oool000D0oooo00<00000
0?ooo`3oool0L@3oool00`000000oooo0?ooo`0g0?ooo`@00000903oool00`000000oooo0?ooo`0U
0?ooo`<00?l39P3oool00`000000oooo0?ooo`070?ooo`001@3oool00`000000oooo0?ooo`1a0?oo
o`030000003oool0oooo03@0oooo0`00000Y0?ooo`030000003oool0oooo02@0oooo0`00o`<W0?oo
o`030000003oool0oooo00H0oooo00050?ooo`030000003oool0oooo0740oooo00<000000?ooo`3o
ool0<03oool4000002d0oooo00<000000?ooo`3oool08P3oool4003o0bL0oooo00<000000?ooo`3o
ool01P3oool000D0oooo00<000000?ooo`3oool0L@3oool00`000000oooo0?ooo`0]0?ooo`<00000
<P3oool00`000000oooo0?ooo`0Q0?ooo`<00?l3:03oool00`000000oooo0?ooo`060?ooo`001@3o
ool00`000000oooo0?ooo`1a0?ooo`030000003oool0oooo02X0oooo0`00000f0?ooo`030000003o
ool0oooo0200oooo0`00o`<X0?ooo`030000003oool0oooo00H0oooo00050?ooo`030000003oool0
oooo0740oooo00<000000?ooo`3oool09P3oool4000003X0oooo00<000000?ooo`3oool07P3oool4
003o0bP0oooo00<000000?ooo`3oool01P3oool000D0oooo00<000000?ooo`3oool0L@3oool00`00
0000oooo0?ooo`0S0?ooo`<00000?`3oool00`000000oooo0?ooo`0M0?ooo`<00?l3:@3oool00`00
0000oooo0?ooo`060?ooo`00103oool00`000000oooo0?ooo`1b0?ooo`030000003oool0oooo01l0
oooo100000130?ooo`030000003oool0oooo01`0oooo0`00o`<Y0?ooo`030000003oool0oooo00H0
oooo00040?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool0703oool3000004P0oooo
00<000000?ooo`3oool06P3oool01000om000?l3003o0`00o`<Y0?ooo`030000003oool0oooo00H0
oooo00040?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool06@3oool3000004`0oooo
00<000000?ooo`3oool06@3oool3003od2X0oooo00<000000?ooo`3oool01P3oool000@0oooo00<0
00000?ooo`3oool0LP3oool00`000000oooo0?ooo`0E0?ooo`@00000D03oool00`000000oooo0?oo
o`0H0?ooo`<00?o@:P3oool00`000000oooo0?ooo`060?ooo`00103oool00`000000oooo0?ooo`1b
0?ooo`030000003oool0oooo0180oooo0`00001D0?ooo`030000003oool0oooo01L0oooo1000om0Z
0?ooo`030000003oool0oooo00H0oooo00040?ooo`030000003oool0oooo0780oooo00<000000?oo
o`3oool03P3oool4000005P0oooo00<000000?ooo`3oool05P3oool3003od2`0oooo00<000000?oo
o`3oool01@3oool000@0oooo00<000000?ooo`3oool0LP3oool00`000000oooo0?ooo`0;0?ooo`<0
0000G@3oool00`000000oooo0?ooo`0E0?ooo`<00?o@;03oool00`000000oooo0?ooo`050?ooo`00
103oool00`000000oooo0?ooo`1b0?ooo`030000003oool0oooo00P0oooo0`00001Q0?ooo`030000
003oool0oooo01<0oooo1000om0/0?ooo`030000003oool0oooo00D0oooo00040?ooo`030000003o
ool0oooo0780oooo00<000000?ooo`3oool0103oool4000006D0oooo00<000000?ooo`3oool04P3o
ool3003od2d0oooo00<000000?ooo`3oool01@3oool000@0oooo00<000000?ooo`3oool0LP3oool0
10000000oooo0?ooo`3oool3000006X0oooo00<000000?ooo`3oool04@3oool3003od2d0oooo00<0
00000?ooo`3oool01@3oool000<0oooo00<000000?ooo`3oool0L`3oool4000006h0oooo00<00000
0?ooo`3oool03`3oool4003od2d0oooo00<000000?ooo`3oool01@3oool000<0oooo00<000000?oo
o`3oool0L03oool400000780oooo00<000000?ooo`3oool03P3oool3003od2h0oooo00<000000?oo
o`3oool01@3oool000<0oooo00<000000?ooo`3oool0K@3oool3000000<0oooo00<000000?ooo`3o
ool0L@3oool00`000000oooo0?ooo`0<0?ooo`04001Ro`00om000?o@003od2h0oooo00<000000?oo
o`3oool01@3oool000<0oooo00<000000?ooo`3oool0J@3oool4000000H0oooo00<000000?ooo`3o
ool0LP3oool00`000000oooo0?ooo`0:0?ooo`@006;o;`3oool00`000000oooo0?ooo`050?ooo`00
0`3oool00`000000oooo0?ooo`1V0?ooo`<000002P3oool00`000000oooo0?ooo`1c0?ooo`030000
003oool0oooo00T0oooo0`00H_l`0?ooo`030000003oool0oooo00D0oooo00030?ooo`030000003o
ool0oooo0680oooo1000000=0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool01`3o
ool4001Roc00oooo00<000000?ooo`3oool01@3oool000<0oooo00<000000?ooo`3oool0G`3oool3
00000140oooo00<000000?ooo`3oool0M@3oool00`000000oooo0?ooo`050?ooo`@006;o<@3oool0
0`000000oooo0?ooo`050?ooo`000`3oool00`000000oooo0?ooo`1K0?ooo`@00000503oool00`00
0000oooo0?ooo`1f0?ooo`030000003oool0oooo00@0oooo0`00H_lc0?ooo`030000003oool0oooo
00@0oooo00030?ooo`030000003oool0oooo05P0oooo0`00000H0?ooo`030000003oool0oooo07H0
oooo00<000000?ooo`3oool00`3oool4001Roc<0oooo00<000000?ooo`3oool0103oool000<0oooo
00<000000?ooo`3oool0E@3oool3000001/0oooo00<000000?ooo`3oool0M`3oool010000000oooo
0?ooo`3oool4001Roc@0oooo00<000000?ooo`3oool0103oool000<0oooo00<000000?ooo`3oool0
D@3oool4000001h0oooo00<000000?ooo`3oool0N03oool00`000000oooo0?ooo`03001RocD0oooo
00<000000?ooo`3oool0103oool00080oooo00<000000?ooo`3oool0C`3oool300000280oooo00<0
00000?ooo`3oool0N@3oool00`000000J@3o001Ro`02001RocD0oooo00<000000?ooo`3oool0103o
ool00080oooo00<000000?ooo`3oool0B`3oool4000002D0oooo00<000000?ooo`3oool0N@3oool0
101Y0?l0000006T0o`1Y0?lf0?ooo`030000003oool0oooo00@0oooo00020?ooo`030000003oool0
oooo04P0oooo0`00000Y0?ooo`030000003oool0oooo07T0oooo0P1Y0?l00`000000oooo0?ooo`0e
0?ooo`030000003oool0oooo00@0oooo00020?ooo`030000003oool0oooo04D0oooo0`00000/0?oo
o`030000003oool0oooo07P0oooo101Y0?l00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo
00@0oooo00020?ooo`030000003oool0oooo0440oooo1000000_0?ooo`030000003oool0oooo07L0
oooo101Y0?l20?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0103oool00080oooo
00<000000?ooo`3oool0?P3oool3000003<0oooo00<000000?ooo`3oool0MP3oool406T0o`@0oooo
00<000000?ooo`3oool0<P3oool00`000000oooo0?ooo`040?ooo`000P3oool00`000000oooo0?oo
o`0j0?ooo`@00000=P3oool00`000000oooo0?ooo`1f0?ooo`<0J@3o1P3oool00`000000oooo0?oo
o`0a0?ooo`030000003oool0oooo00@0oooo00020?ooo`030000003oool0oooo03L0oooo0`00000j
0?ooo`030000003oool0oooo07D0oooo101Y0?l70?ooo`030000003oool0oooo0340oooo00<00000
0?ooo`3oool00`3oool00080oooo00<000000?ooo`3oool0=03oool3000003d0oooo00<000000?oo
o`3oool0M03oool406T0o`T0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`030?oo
o`000P3oool00`000000oooo0?ooo`0`0?ooo`@00000@03oool00`000000oooo0?ooo`1c0?ooo`04
0?l0b@1Y0?l0J@3o06T0o`/0oooo00<000000?ooo`3oool0;`3oool00`000000oooo0?ooo`030?oo
o`0000<0oooo0000003oool0;`3oool3000004<0oooo00<000000?ooo`3oool0L`3oool20?l0b@<0
J@3o2`3oool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo00<0oooo00000`3oool00000
0?ooo`0[0?ooo`@00000AP3oool00`000000oooo0?ooo`1b0?ooo`@0o`393P3oool00`000000oooo
0?ooo`0^0?ooo`030000003oool0oooo00<0oooo00000`3oool000000?ooo`0X0?ooo`<00000BP3o
ool00`000000oooo0?ooo`1a0?ooo`@0o`39403oool00`000000oooo0?ooo`0]0?ooo`030000003o
ool0oooo00<0oooo00000`3oool000000?ooo`0U0?ooo`<00000C@3oool00`000000oooo0?ooo`1`
0?ooo`@0o`394P3oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo00<0oooo00000`3o
ool000000?ooo`0Q0?ooo`@00000D03oool00`000000oooo0?ooo`1_0?ooo`@0o`39503oool00`00
0000oooo0?ooo`0[0?ooo`030000003oool0oooo00<0oooo00000`3oool000000?ooo`0N0?ooo`<0
0000E03oool00`000000oooo0?ooo`1^0?ooo`@0o`395P3oool00`000000oooo0?ooo`0Z0?ooo`03
0000003oool0oooo00<0oooo00000`3oool000000?ooo`0J0?ooo`@00000E`3oool00`000000oooo
0?ooo`1]0?ooo`@0o`39603oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0oooo00<0oooo
00000`3oool000000?ooo`0G0?ooo`<00000F`3oool00`000000oooo0?ooo`1/0?ooo`@0o`396P3o
ool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo00<0oooo00000`3oool000000?ooo`0D
0?ooo`<00000GP3oool00`000000oooo0?ooo`1[0?ooo`80o`<00P3o0<TL0?ooo`030000003oool0
oooo02P0oooo00<000000?ooo`3oool00P3oool000030?ooo`000000oooo0100oooo1000001Q0?oo
o`030000003oool0oooo06X0oooo103o0`0N0?ooo`030000003oool0oooo02L0oooo00<000000?oo
o`3oool00P3oool000030000003oool0oooo00d0oooo0`00001U0?ooo`030000003oool0oooo06T0
oooo103o0`0P0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool00P3oool000030000
003oool0oooo00T0oooo1000001X0?ooo`030000003oool0oooo06P0oooo103o0`0R0?ooo`030000
003oool0oooo02D0oooo00<000000?ooo`3oool00P3oool000030000003oool0oooo00H0oooo0`00
001/0?ooo`030000003oool0oooo06L0oooo103o0`0T0?ooo`030000003oool0oooo02@0oooo00<0
00000?ooo`3oool00P3oool000030000003oool0oooo00<0oooo0`00001_0?ooo`030000003oool0
oooo06H0oooo103o0`0U0?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool00P3oool0
00030000003oool0000000<00000LP3oool00`000000oooo0?ooo`1U0?ooo`@0o`<09`3oool00`00
0000oooo0?ooo`0S0?ooo`030000003oool0oooo0080oooo0002000007H0oooo00<000000?ooo`3o
ool0I03oool40?l302T0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`020?ooo`00
00<0oooo0000003oool0M@3oool00`000000oooo0?ooo`1S0?ooo`@0o`<0:`3oool00`000000oooo
0?ooo`0Q0?ooo`030000003oool0oooo0080oooo00020?ooo`800000M03oool00`000000oooo0?oo
o`1Q0?ooo`<0om000P3o0`000`3od000oooo0?ooo`0Z0?ooo`030000003oool0oooo0200oooo00<0
00000?ooo`3oool00P3oool000@0oooo00<000000?ooo`3oool0L@3oool00`000000oooo0?ooo`1O
0?ooo`H0om00;`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo0080oooo00050?oo
o`030000003oool0oooo0700oooo00<000000?ooo`3oool0GP3oool60?o@0340oooo00<000000?oo
o`3oool07P3oool00`000000oooo0?ooo`020?ooo`001P3oool200000700oooo00<000000?ooo`3o
ool0G03oool60?o@03@0oooo00<000000?ooo`3oool07P3oool00`000000oooo0?ooo`010?ooo`00
203oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo05/0oooo1@3od00g0?ooo`030000
003oool0oooo01d0oooo00<000000?ooo`3oool00@3oool000T0oooo00<000000?ooo`3oool0K03o
ool00`000000oooo0?ooo`1I0?ooo`H0om00>@3oool00`000000oooo0?ooo`0L0?ooo`030000003o
ool0oooo0040oooo000:0?ooo`800000K03oool00`000000oooo0?ooo`1H0?ooo`0306;o003od000
om000080om00?03oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo0040oooo000<0?oo
o`030000003oool0oooo06T0oooo00<000000?ooo`3oool0EP3oool306;o00<0om00?P3oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo0040oooo000=0?ooo`030000003oool0oooo06P0
oooo00<000000?ooo`3oool0E03oool606;o0440oooo00<000000?ooo`3oool06@3oool00`000000
oooo0?ooo`010?ooo`003P3oool2000006P0oooo00<000000?ooo`3oool0D`3oool606;o0480oooo
00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`010?ooo`00403oool00`000000oooo0?oo
o`1U0?ooo`030000003oool0oooo0540oooo1P1Ro`150?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool00@3oool00140oooo00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`1@
0?ooo`D0H_l0B03oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0040oooo000B0?oo
o`800000I03oool00`000000oooo0?ooo`1>0?ooo`H0H_l0BP3oool00`000000oooo0?ooo`0F0?oo
o`030000003oool0oooo0040oooo000D0?ooo`030000003oool0oooo0640oooo00<000000?ooo`3o
ool0C03oool2003oJP@0H_l0C@3oool00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0040
oooo000E0?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool0BP3oool4003oJP<0H_l0
C`3oool00`000000oooo0?ooo`0E0?ooo`4000000@3oool10?ooo`005P3oool00`000000oooo0?oo
o`1O0?ooo`030000003oool0oooo04T0oooo1P00ofYB0?ooo`030000003oool0oooo01@0oooo0@00
00010?ooo`40oooo000G0?ooo`800000G`3oool00`000000oooo0?ooo`170?ooo`H00?mZE@3oool0
0`000000oooo0?ooo`0C0?ooo`4000000@3oool10?ooo`006@3oool00`000000oooo0?ooo`1L0?oo
o`030000003oool0oooo04D0oooo1P00ofYH0?ooo`030000003oool0oooo0180oooo0@0000010?oo
o`40oooo000J0?ooo`030000003oool0oooo05/0oooo00<000000?ooo`3oool0@`3oool7003oJUX0
oooo00<000000?ooo`3oool04@3oool100000040oooo0@3oool001/0oooo0P00001K0?ooo`030000
003oool0oooo0400oooo0`00b?l5003oJUd0oooo00<000000?ooo`3oool0403oool100000040oooo
0@3oool001d0oooo00<000000?ooo`3oool0F03oool00`000000oooo0?ooo`0n0?ooo`D00<So0`00
ofYP0?ooo`030000003oool0oooo00l0oooo0@0000010?ooo`40oooo000N0?ooo`030000003oool0
oooo05L0oooo00<000000?ooo`3oool0?03oool80038of<0oooo00<000000?ooo`3oool03P3oool1
00000040oooo0@3oool001l0oooo0P00001G0?ooo`030000003oool0oooo03T0oooo2000b?mW0?oo
o`030000003oool0oooo00d0oooo0@0000010?ooo`40oooo000Q0?ooo`030000003oool0oooo05@0
oooo00<000000?ooo`3oool0=P3oool00`030?l00<So0038o`060038ofT0oooo00<000000?ooo`3o
ool03@3oool100000040oooo0@3oool00280oooo00<000000?ooo`3oool0D`3oool00`000000oooo
0?ooo`0c0?ooo`@00`3o1P00b?m/0?ooo`030000003oool0oooo00`0oooo0@0000010?ooo`40oooo
000S0?ooo`800000DP3oool00`000000oooo0?ooo`0a0?ooo`L00`3o0`00b?m`0?ooo`030000003o
ool0oooo00`0oooo0@0000010?ooo`009@3oool00`000000oooo0?ooo`1?0?ooo`030000003oool0
oooo02h0oooo2P030?md0?ooo`030000003oool0oooo00/0oooo0@0000010?ooo`009P3oool00`00
0000oooo0?ooo`1>0?ooo`030000003oool0oooo02X0oooo103@0?l700<0ogP0oooo00<000000?oo
o`3oool02P3oool100000040oooo000W0?ooo`030000003oool0oooo04d0oooo00<000000?ooo`3o
ool09`3oool70=00o`@00`3oO03oool00`000000oooo0?ooo`090?ooo`4000000@3oool002P0oooo
0P00001=0?ooo`030000003oool0oooo02D0oooo2@3@0?l00`030?l0oooo0?ooo`1n0?ooo`030000
003oool0oooo00P0oooo0@0000010?ooo`00:P3oool00`000000oooo0?ooo`1:0?ooo`030000003o
ool0oooo0280oooo2@3@0?n50?ooo`030000003oool0oooo00L0oooo0@0000010?ooo`00:`3oool0
0`000000oooo0?ooo`190?ooo`030000003oool0oooo01h0oooo103o06860=00ohT0oooo00<00000
0?ooo`3oool01P3oool100000040oooo000/0?ooo`800000B@3oool00`000000oooo0?ooo`0J0?oo
o`P0o`1R103@0?n<0?ooo`030000003oool0oooo00D0oooo0@0000010?ooo`00;P3oool00`000000
oooo0?ooo`160?ooo`030000003oool0oooo01H0oooo303o06800`3@0?l0oooo0?ooo`2>0?ooo`03
0000003oool0oooo00@0oooo0@0000010?ooo`00;`3oool00`000000oooo0?ooo`150?ooo`030000
003oool0oooo0140oooo103oJP090?l0HYH0oooo00<000000?ooo`3oool00`3oool100000040oooo
000`0?ooo`800000A@3oool00`000000oooo0?ooo`0=0?ooo`P0ofX01@3o06:K0?ooo`030000003o
ool0oooo0080oooo0@0000010?ooo`00<P3oool00`000000oooo0?ooo`120?ooo`030000003oool0
oooo00X0oooo2`3oJP000`3o0680oooo0?ooo`2M0?ooo`030000003ooo