/*
 * Decompiled with CFR 0.152.
 */
package com.trl;

import com.trl.EstimationPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RunningWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    private EstimationPanel[] panels = null;
    private JTextField weightText = null;
    private JPanel[] helpPanels = null;
    private static final double[] conversionRate = new double[]{2.0, 3.75, 2.078, 2.222222, 2.1};

    public RunningWindow() {
        super("Running - Training JuanRL");
        this.setSize(new Dimension(950, 390));
        this.setPreferredSize(new Dimension(950, 390));
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.getContentPane().setBackground(new Color(16771752));
        this.setLayout(null);
        this.createHelpPanels();
        JLabel weightIcon = new JLabel();
        try {
            weightIcon.setIcon(new ImageIcon(ImageIO.read(new File("weight.png"))));
            weightIcon.setToolTipText("Peso");
        }
        catch (IOException e) {
            weightIcon.setText("Peso:");
            e.printStackTrace();
        }
        weightIcon.setBounds(10, 10, weightIcon.getPreferredSize().width, weightIcon.getPreferredSize().height);
        this.add(weightIcon);
        this.weightText = new JTextField();
        this.weightText.setPreferredSize(new Dimension(100, this.weightText.getPreferredSize().height));
        this.weightText.setBounds(70, 30, this.weightText.getPreferredSize().width, this.weightText.getPreferredSize().height);
        this.weightText.setHorizontalAlignment(4);
        this.add(this.weightText);
        JLabel kgLabel = new JLabel("Kg");
        kgLabel.setBounds(180, 35, kgLabel.getPreferredSize().width, kgLabel.getPreferredSize().height);
        this.add(kgLabel);
        JButton aboutButton = new JButton();
        try {
            aboutButton.setIcon(new ImageIcon(ImageIO.read(new File("about.png"))));
            aboutButton.setToolTipText("Acerca de...");
            aboutButton.setContentAreaFilled(false);
            aboutButton.setOpaque(false);
        }
        catch (IOException e) {
            aboutButton.setText("Acerca de");
            e.printStackTrace();
        }
        aboutButton.setBounds(880, 10, aboutButton.getPreferredSize().width, aboutButton.getPreferredSize().height);
        aboutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(RunningWindow.this, "Aplicaci\u00f3n desarrollada por Tom\u00e1s Ruiz-L\u00f3pez\npara Training Juan RL. \nhttp://trainingjuanrl.wordpress.com \nhttp://www.ugr.es/~tomruiz \n(C) 2012. Todos los derechos reservados", "Running", 1);
            }
        });
        this.add(aboutButton);
        JButton helpButton = new JButton();
        try {
            helpButton.setIcon(new ImageIcon(ImageIO.read(new File("help.png"))));
            helpButton.setToolTipText("Ayuda");
            helpButton.setContentAreaFilled(false);
            helpButton.setOpaque(false);
        }
        catch (IOException e) {
            aboutButton.setText("Ayuda");
            e.printStackTrace();
        }
        helpButton.setBounds(810, 10, helpButton.getPreferredSize().width, helpButton.getPreferredSize().height);
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RunningWindow.this.help();
            }
        });
        this.add(helpButton);
        JLabel runnerIcon = new JLabel();
        try {
            runnerIcon.setIcon(new ImageIcon(ImageIO.read(new File("runner.png"))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        runnerIcon.setBounds(15, 80, runnerIcon.getPreferredSize().width, runnerIcon.getPreferredSize().height);
        this.add(runnerIcon);
        String[] str = new String[]{"800 m", "1.500 m", "5.000 m", "10.000 m", "Media Marat\u00f3n", "Marat\u00f3n"};
        this.panels = new EstimationPanel[str.length];
        int i = 0;
        while (i < str.length) {
            JButton flag = new JButton();
            flag.setContentAreaFilled(false);
            flag.setOpaque(false);
            flag.setToolTipText(str[i]);
            try {
                flag.setIcon(new ImageIcon(ImageIO.read(new File("flag.png"))));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            flag.setBounds(150 + 116 * i, 80, flag.getPreferredSize().width, flag.getPreferredSize().height);
            this.add(flag);
            EstimationPanel ep = this.panels[i] = new EstimationPanel(str[i], 230, 170);
            ep.setBounds(100 + 116 * i, 180, 230, 170);
            if (i != 0) {
                ep.setVisible(false);
            }
            this.add(ep);
            final int p = i++;
            flag.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    int j = 0;
                    while (j < RunningWindow.this.panels.length) {
                        RunningWindow.this.panels[j].setVisible(false);
                        ++j;
                    }
                    RunningWindow.this.panels[p].setVisible(true);
                }
            });
            ep.setFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    RunningWindow.this.updatePanels(p);
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            ep.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RunningWindow.this.updatePanels(p);
                }
            });
        }
        JPanel floor = new JPanel();
        floor.setPreferredSize(new Dimension(950, 30));
        floor.setBackground(new Color(9374218));
        floor.setBounds(0, 140, 950, 30);
        this.add(floor);
        JPanel sky = new JPanel();
        sky.setPreferredSize(new Dimension(950, 100));
        sky.setBackground(new Color(9032182));
        sky.setBounds(0, 70, 950, 100);
        this.add(sky);
    }

    private void updatePanels(int p) {
        double newScore;
        int j = 0;
        while (j < this.panels.length) {
            if (j != p) {
                this.panels[j].clearScoreText();
            }
            ++j;
        }
        double score = this.panels[p].getScore();
        double[] length = new double[]{0.8, 1.5, 5.0, 10.0, 21.097, 42.195};
        double[] speed = new double[this.panels.length];
        double[] timeMin = new double[this.panels.length];
        double prevScore = score;
        int j2 = p + 1;
        while (j2 < this.panels.length) {
            newScore = prevScore * conversionRate[j2 - 1];
            speed[j2] = length[j2] / (newScore / 3600.0);
            timeMin[j2] = newScore / 60.0;
            this.panels[j2].setTimeEstimation(this.fromScoreToText(newScore));
            prevScore = newScore;
            ++j2;
        }
        prevScore = score;
        j2 = p - 1;
        while (j2 >= 0) {
            newScore = prevScore / conversionRate[j2];
            speed[j2] = length[j2] / (newScore / 3600.0);
            timeMin[j2] = newScore / 60.0;
            this.panels[j2].setTimeEstimation(this.fromScoreToText(newScore));
            prevScore = newScore;
            --j2;
        }
        this.panels[p].setTimeEstimation(this.fromScoreToText(score));
        speed[p] = length[p] / (score / 3600.0);
        timeMin[p] = score / 60.0;
        try {
            double weight = Double.parseDouble(this.weightText.getText());
            int j3 = 0;
            while (j3 < this.panels.length) {
                double cal = Math.round(speed[j3] * weight * 0.0175 * timeMin[j3]);
                this.panels[j3].setCaloriesEstimation(cal);
                ++j3;
            }
        }
        catch (Exception e) {
            return;
        }
    }

    private String fromScoreToText(double seg) {
        String time = "";
        if (seg > 3600.0) {
            int h = (int)Math.floor(seg / 3600.0);
            seg -= (double)(h * 3600);
            time = String.valueOf(time) + h + " h ";
        }
        if (seg > 60.0) {
            int m = (int)Math.floor(seg / 60.0);
            seg -= (double)(m * 60);
            time = String.valueOf(time) + m + " min ";
        }
        if (Math.round(seg) > 0L) {
            time = String.valueOf(time) + Math.round(seg) + " seg";
        }
        return time;
    }

    private void createHelpPanels() {
        this.helpPanels = new JPanel[5];
        JPanel p1 = new JPanel();
        p1.setBackground(new Color(12381522));
        p1.setBorder(BorderFactory.createLineBorder(new Color(7640620)));
        p1.setLayout(null);
        JLabel l1 = new JLabel("Introduce tu peso...");
        l1.setBounds(10, 10, l1.getPreferredSize().width, l1.getPreferredSize().height);
        p1.setPreferredSize(new Dimension(l1.getPreferredSize().width + 20, l1.getPreferredSize().height + 20));
        p1.add(l1);
        p1.setBounds(80, 55, p1.getPreferredSize().width, p1.getPreferredSize().height);
        this.add(p1);
        this.helpPanels[0] = p1;
        JPanel p5 = new JPanel();
        p5.setBackground(new Color(12381522));
        p5.setBorder(BorderFactory.createLineBorder(new Color(7640620)));
        p5.setLayout(null);
        JLabel l5 = new JLabel("...selecciona una competici\u00f3n...");
        l5.setBounds(10, 10, l5.getPreferredSize().width, l5.getPreferredSize().height);
        p5.setPreferredSize(new Dimension(l5.getPreferredSize().width + 20, l5.getPreferredSize().height + 20));
        p5.add(l5);
        p5.setBounds(300, 50, p5.getPreferredSize().width, p5.getPreferredSize().height);
        this.add(p5);
        this.helpPanels[1] = p5;
        JPanel p2 = new JPanel();
        p2.setBackground(new Color(12381522));
        p2.setBorder(BorderFactory.createLineBorder(new Color(7640620)));
        p2.setLayout(null);
        JLabel l2 = new JLabel("...introduce tu marca...");
        l2.setBounds(10, 10, l2.getPreferredSize().width, l2.getPreferredSize().height);
        p2.setPreferredSize(new Dimension(l2.getPreferredSize().width + 20, l2.getPreferredSize().height + 20));
        p2.add(l2);
        p2.setBounds(266, 250, p2.getPreferredSize().width, p2.getPreferredSize().height);
        this.add(p2);
        this.helpPanels[2] = p2;
        JPanel p3 = new JPanel();
        p3.setBackground(new Color(12381522));
        p3.setBorder(BorderFactory.createLineBorder(new Color(7640620)));
        p3.setLayout(null);
        JLabel l3 = new JLabel("...pulsa aceptar...");
        l3.setBounds(10, 10, l3.getPreferredSize().width, l3.getPreferredSize().height);
        p3.setPreferredSize(new Dimension(l3.getPreferredSize().width + 20, l3.getPreferredSize().height + 20));
        p3.add(l3);
        p3.setBounds(346, 310, p3.getPreferredSize().width, p3.getPreferredSize().height);
        this.add(p3);
        this.helpPanels[3] = p3;
        JPanel p4 = new JPanel();
        p4.setBackground(new Color(12381522));
        p4.setBorder(BorderFactory.createLineBorder(new Color(7640620)));
        p4.setLayout(null);
        JLabel l4 = new JLabel("...y pulsa en las banderas para ver tus marcas.");
        l4.setBounds(10, 10, l4.getPreferredSize().width, l4.getPreferredSize().height);
        p4.setPreferredSize(new Dimension(l4.getPreferredSize().width + 20, l4.getPreferredSize().height + 20));
        p4.add(l4);
        p4.setBounds(300, 50, p4.getPreferredSize().width, p4.getPreferredSize().height);
        this.add(p4);
        this.helpPanels[4] = p4;
        int i = 0;
        while (i < this.helpPanels.length) {
            this.helpPanels[i].setVisible(false);
            ++i;
        }
    }

    private void delay(int t) {
        try {
            Thread.sleep(t);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void help() {
        Thread t = new Thread(){

            @Override
            public void run() {
                RunningWindow.this.weightText.setText("");
                RunningWindow.this.helpPanels[0].setVisible(true);
                RunningWindow.this.delay(500);
                RunningWindow.this.weightText.setText("80");
                RunningWindow.this.delay(2500);
                RunningWindow.this.helpPanels[0].setVisible(false);
                RunningWindow.this.helpPanels[1].setVisible(true);
                RunningWindow.this.delay(500);
                int i = 0;
                while (i < RunningWindow.this.panels.length) {
                    RunningWindow.this.panels[i].setVisible(false);
                    ++i;
                }
                RunningWindow.this.panels[1].clearScoreText();
                RunningWindow.this.panels[1].setSelectedUnit(0);
                RunningWindow.this.panels[1].setVisible(true);
                RunningWindow.this.delay(2500);
                RunningWindow.this.helpPanels[1].setVisible(false);
                RunningWindow.this.helpPanels[2].setVisible(true);
                RunningWindow.this.delay(500);
                RunningWindow.this.panels[1].setSelectedUnit(1);
                RunningWindow.this.delay(1000);
                RunningWindow.this.panels[1].setScoreText("2.5");
                RunningWindow.this.delay(2500);
                RunningWindow.this.helpPanels[2].setVisible(false);
                RunningWindow.this.helpPanels[3].setVisible(true);
                RunningWindow.this.delay(1000);
                RunningWindow.this.updatePanels(1);
                RunningWindow.this.delay(2000);
                RunningWindow.this.helpPanels[3].setVisible(false);
                RunningWindow.this.helpPanels[4].setVisible(true);
                RunningWindow.this.delay(1000);
                RunningWindow.this.panels[1].setVisible(false);
                i = 0;
                while (i < RunningWindow.this.panels.length) {
                    RunningWindow.this.panels[i].setHighlighted(true);
                    RunningWindow.this.panels[i].setVisible(true);
                    RunningWindow.this.delay(2500);
                    RunningWindow.this.panels[i].setVisible(false);
                    RunningWindow.this.panels[i].setHighlighted(false);
                    i += 2;
                }
                RunningWindow.this.panels[1].setVisible(true);
                RunningWindow.this.helpPanels[4].setVisible(false);
            }
        };
        t.start();
    }
}

