/*
 * Decompiled with CFR 0.152.
 */
package com.trl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class EstimationPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel timeEstimation = null;
    private JLabel caloriesEstimation = null;
    private JTextField scoreText = null;
    private JComboBox unitCombo = null;
    private JButton okButton = null;

    public EstimationPanel(String title, int w, int h) {
        this.setBackground(new Color(16109922));
        this.setPreferredSize(new Dimension(w, h));
        this.setBorder(BorderFactory.createLineBorder(new Color(14263040)));
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        Font boldFont = new Font("Arial", 1, 14);
        JLabel titleLabel = new JLabel(title);
        titleLabel.setFont(boldFont);
        titleLabel.setPreferredSize(new Dimension(w, titleLabel.getPreferredSize().height));
        titleLabel.setHorizontalAlignment(0);
        this.add(titleLabel);
        JLabel scoreLabel = new JLabel("Tu marca:");
        this.scoreText = new JTextField();
        this.scoreText.setPreferredSize(new Dimension(70, this.scoreText.getPreferredSize().height));
        this.scoreText.setHorizontalAlignment(4);
        this.unitCombo = new JComboBox<String>(new String[]{"seg", "min", "h"});
        this.add(scoreLabel);
        this.add(this.scoreText);
        this.add(this.unitCombo);
        this.timeEstimation = new JLabel("Marca estimada: - seg");
        this.timeEstimation.setBackground(new Color(16642347));
        this.caloriesEstimation = new JLabel("Calor\u00edas estimadas: - Kcal");
        this.caloriesEstimation.setBackground(new Color(16642347));
        this.add(this.timeEstimation);
        this.add(this.caloriesEstimation);
        this.okButton = new JButton();
        try {
            this.okButton.setIcon(new ImageIcon(ImageIO.read(new File("ok.png"))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.okButton.setOpaque(false);
        this.okButton.setContentAreaFilled(false);
        this.add(this.okButton);
        layout.putConstraint("North", (Component)titleLabel, 10, "North", (Component)this);
        layout.putConstraint("West", (Component)titleLabel, 0, "West", (Component)this);
        layout.putConstraint("North", (Component)scoreLabel, 10, "South", (Component)titleLabel);
        layout.putConstraint("West", (Component)scoreLabel, 10, "West", (Component)this);
        layout.putConstraint("Baseline", (Component)this.scoreText, 0, "South", (Component)scoreLabel);
        layout.putConstraint("West", (Component)this.scoreText, 10, "East", (Component)scoreLabel);
        layout.putConstraint("Baseline", (Component)this.unitCombo, 0, "South", (Component)scoreLabel);
        layout.putConstraint("West", (Component)this.unitCombo, 5, "East", (Component)this.scoreText);
        layout.putConstraint("North", (Component)this.timeEstimation, 10, "South", (Component)scoreLabel);
        layout.putConstraint("West", (Component)this.timeEstimation, 10, "West", (Component)this);
        layout.putConstraint("North", (Component)this.caloriesEstimation, 10, "South", (Component)this.timeEstimation);
        layout.putConstraint("West", (Component)this.caloriesEstimation, 10, "West", (Component)this);
        layout.putConstraint("North", (Component)this.okButton, 10, "South", (Component)this.caloriesEstimation);
        layout.putConstraint("West", (Component)this.okButton, (w - 70) / 2, "West", (Component)this);
    }

    public void setTimeEstimation(String t) {
        this.timeEstimation.setText("Marca estimada: " + t);
    }

    public void setCaloriesEstimation(double cal) {
        this.caloriesEstimation.setText("Calor\u00edas estimadas: " + cal + " Kcal");
    }

    public void setFocusListener(FocusListener listener) {
        this.scoreText.addFocusListener(listener);
    }

    public double getScore() {
        try {
            double score = Double.parseDouble(this.scoreText.getText());
            int unit = this.unitCombo.getSelectedIndex();
            if (unit == 0) {
                return score;
            }
            if (unit == 1) {
                return score * 60.0;
            }
            return score * 3600.0;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public void clearScoreText() {
        this.scoreText.setText("");
    }

    public void setActionListener(ActionListener listener) {
        this.okButton.addActionListener(listener);
    }

    public void setSelectedUnit(int unit) {
        this.unitCombo.setSelectedIndex(unit);
    }

    public void setScoreText(String text) {
        this.scoreText.setText(text);
    }

    public void setHighlighted(boolean h) {
        this.timeEstimation.setOpaque(h);
        this.caloriesEstimation.setOpaque(h);
    }
}

