/*
 * Decompiled with CFR 0.152.
 */
package com.trl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class MetabolismWindow
extends JFrame {
    private static final long serialVersionUID = 1L;

    public MetabolismWindow() {
        super("C\u00e1lculo del Metabolismo Basal");
        this.setSize(new Dimension(500, 375));
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        final JRadioButton manButton = new JRadioButton();
        JLabel manLabel = new JLabel();
        try {
            manLabel.setIcon(new ImageIcon(ImageIO.read(new File("man.png"))));
            manLabel.setToolTipText("Hombre");
        }
        catch (IOException e) {
            manLabel.setText("Hombre");
            e.printStackTrace();
        }
        manButton.setSelected(true);
        JRadioButton womanButton = new JRadioButton();
        JLabel womanLabel = new JLabel();
        try {
            womanLabel.setIcon(new ImageIcon(ImageIO.read(new File("woman.png"))));
            womanLabel.setToolTipText("Mujer");
        }
        catch (IOException e) {
            manButton.setText("Mujer");
            e.printStackTrace();
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(manButton);
        bg.add(womanButton);
        JLabel weightLabel = new JLabel("Peso (kg): ");
        JLabel greaseLabel = new JLabel("Peso graso (%): ");
        JLabel heightLabel = new JLabel("Altura (cm): ");
        JLabel ageLabel = new JLabel("Edad (a\u00f1os): ");
        final JTextField weightText = new JTextField();
        weightText.setText("0");
        weightText.setPreferredSize(new Dimension(350, (int)weightText.getPreferredSize().getHeight()));
        weightText.setHorizontalAlignment(4);
        final JTextField greaseText = new JTextField();
        greaseText.setText("0");
        greaseText.setPreferredSize(new Dimension(350, (int)weightText.getPreferredSize().getHeight()));
        greaseText.setHorizontalAlignment(4);
        final JTextField heightText = new JTextField();
        heightText.setText("0");
        heightText.setPreferredSize(new Dimension(350, (int)weightText.getPreferredSize().getHeight()));
        heightText.setHorizontalAlignment(4);
        final JTextField ageText = new JTextField();
        ageText.setText("0");
        ageText.setPreferredSize(new Dimension(350, (int)weightText.getPreferredSize().getHeight()));
        ageText.setHorizontalAlignment(4);
        final JLabel imcLabel = new JLabel("IMC: ");
        final JLabel mbLabel = new JLabel("Metabolismo Basal: ");
        JButton computeButton = new JButton();
        computeButton.setText("Calcular");
        computeButton.setPreferredSize(new Dimension(460, (int)computeButton.getPreferredSize().getHeight()));
        computeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                boolean manSelected = manButton.isSelected();
                float weight = 0.0f;
                float grease = 0.0f;
                float height = 0.0f;
                float age = 0.0f;
                try {
                    weight = Float.parseFloat(weightText.getText());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(MetabolismWindow.this, "El peso introducido no es correcto.\nSi desea incluir decimales, utilice el punto como separador decimal.", "Metabolismo Basal", 0);
                    return;
                }
                try {
                    grease = Float.parseFloat(greaseText.getText());
                }
                catch (Exception e) {
                    grease = 0.0f;
                }
                try {
                    height = Float.parseFloat(heightText.getText());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(MetabolismWindow.this, "La altura introducida no es correcta.", "Metabolismo Basal", 0);
                    return;
                }
                try {
                    age = Float.parseFloat(ageText.getText());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(MetabolismWindow.this, "La edad introducida no es correcta.", "Metabolismo Basal", 0);
                    return;
                }
                if (weight <= 0.0f) {
                    JOptionPane.showMessageDialog(MetabolismWindow.this, "El peso debe ser mayor a 0 kg.", "Metabolismo Basal", 0);
                    return;
                }
                if (grease < 0.0f || grease > 100.0f) {
                    JOptionPane.showMessageDialog(MetabolismWindow.this, "El peso de grasa debe indicarse en %.", "Metabolismo Basal", 0);
                    return;
                }
                if (height <= 0.0f) {
                    JOptionPane.showMessageDialog(MetabolismWindow.this, "La altura debe ser mayor a 0 cm.", "Metabolismo Basal", 0);
                    return;
                }
                if (age <= 0.0f) {
                    JOptionPane.showMessageDialog(MetabolismWindow.this, "La edad debe ser mayor a 0 a\u00f1os.", "Metabolismo Basal", 0);
                    return;
                }
                float imc = weight / (height * height / 10000.0f);
                float mb = 0.0f;
                weight = (100.0f - grease) * weight / 100.0f;
                if (imc > 25.0f) {
                    weight = 22.5f * height * height / 10000.0f;
                }
                mb = manSelected ? 66.4f + 13.75f * weight + 5.003f * height - 6.775f * age : 655.1f + 9.6f * weight + 1.85f * height - 4.676f * age;
                imcLabel.setText("IMC: " + imc + " kg/m^2");
                mbLabel.setText("Metabolismo Basal: " + mb + " Kcal");
            }
        });
        JButton creditsButton = new JButton();
        creditsButton.setText("?");
        creditsButton.setPreferredSize(new Dimension(35, 35));
        creditsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane.showMessageDialog(MetabolismWindow.this, "Aplicaci\u00f3n desarrollada por Tom\u00e1s Ruiz-L\u00f3pez\npara Training Juan RL. \nhttp://trainingjuanrl.wordpress.com \nhttp://www.ugr.es/~tomruiz \n(C) 2012. Todos los derechos reservados", "Metabolismo Basal", 1);
            }
        });
        this.add(manButton);
        this.add(womanButton);
        this.add(manLabel);
        this.add(womanLabel);
        this.add(weightLabel);
        this.add(greaseLabel);
        this.add(heightLabel);
        this.add(ageLabel);
        this.add(weightText);
        this.add(greaseText);
        this.add(heightText);
        this.add(ageText);
        this.add(computeButton);
        this.add(imcLabel);
        this.add(mbLabel);
        this.add(creditsButton);
        layout.putConstraint("North", (Component)manButton, 20, "North", (Component)this);
        layout.putConstraint("North", (Component)womanButton, 20, "North", (Component)this);
        layout.putConstraint("North", (Component)manLabel, 20, "North", (Component)this);
        layout.putConstraint("North", (Component)womanLabel, 20, "North", (Component)this);
        layout.putConstraint("West", (Component)manButton, 150, "West", (Component)this);
        layout.putConstraint("West", (Component)manLabel, 5, "East", (Component)manButton);
        layout.putConstraint("West", (Component)womanButton, 20, "East", (Component)manLabel);
        layout.putConstraint("West", (Component)womanLabel, 5, "East", (Component)womanButton);
        layout.putConstraint("North", (Component)weightLabel, 20, "South", (Component)manLabel);
        layout.putConstraint("North", (Component)greaseLabel, 10, "South", (Component)weightLabel);
        layout.putConstraint("North", (Component)heightLabel, 10, "South", (Component)greaseLabel);
        layout.putConstraint("North", (Component)ageLabel, 10, "South", (Component)heightLabel);
        layout.putConstraint("West", (Component)weightLabel, 20, "West", (Component)this);
        layout.putConstraint("West", (Component)greaseLabel, 0, "West", (Component)weightLabel);
        layout.putConstraint("West", (Component)heightLabel, 0, "West", (Component)weightLabel);
        layout.putConstraint("West", (Component)ageLabel, 0, "West", (Component)weightLabel);
        layout.putConstraint("Baseline", (Component)weightText, 0, "Baseline", (Component)weightLabel);
        layout.putConstraint("Baseline", (Component)greaseText, 0, "Baseline", (Component)greaseLabel);
        layout.putConstraint("Baseline", (Component)heightText, 0, "Baseline", (Component)heightLabel);
        layout.putConstraint("Baseline", (Component)ageText, 0, "Baseline", (Component)ageLabel);
        layout.putConstraint("West", (Component)greaseText, 10, "East", (Component)greaseLabel);
        layout.putConstraint("West", (Component)weightText, 0, "West", (Component)greaseText);
        layout.putConstraint("West", (Component)heightText, 0, "West", (Component)greaseText);
        layout.putConstraint("West", (Component)ageText, 0, "West", (Component)greaseText);
        layout.putConstraint("North", (Component)computeButton, 20, "South", (Component)ageText);
        layout.putConstraint("West", (Component)computeButton, 20, "West", (Component)this);
        layout.putConstraint("North", (Component)imcLabel, 20, "South", (Component)computeButton);
        layout.putConstraint("North", (Component)mbLabel, 10, "South", (Component)imcLabel);
        layout.putConstraint("West", (Component)imcLabel, 20, "West", (Component)this);
        layout.putConstraint("West", (Component)mbLabel, 20, "West", (Component)this);
        layout.putConstraint("Baseline", (Component)creditsButton, 0, "Baseline", (Component)mbLabel);
        layout.putConstraint("West", (Component)creditsButton, 450, "West", (Component)this);
    }
}

