#ifndef CUAGL_VENTANA3D_H
#define CUAGL_VENTANA3D_H

#include <stream.h>
#include <GL/glut.h>
#include <Ventana.H>
#include <Modelo3D.H>


namespace VDE
{

class Ventana3D : public Ventana
{

 private:
 
   double anguloH , 
          anguloV ;

   bool drawBox ;
 
 protected:

   virtual void redibujar() ; 
   
   virtual void cambioTamano
   (
      int width,
      int height
   ) ; 
   
   virtual bool teclado
   ( 
      unsigned char k, 
      int x, 
      int y
   ) ;
   
   virtual void tecladoEspecial
   ( 
      int k, 
      int x, 
      int y
   ) ;

   virtual void enEspera() ;
    
   Modelo3D * modelo ;
      
                 
 public: 

   Ventana3D
   ( 
      Modelo3D *    modelo ,
      const char *  p_titulo,
      unsigned int  p_nPixelsX = 256 ,
      unsigned int  p_nPixelsY = 256 
   ) 
   throw
   (
      ErrorVentana
   ) ;
   
   virtual ~Ventana3D() ;
   
     
} ; // class Ventana3D

} ; // namespace CuaGl

#endif // CUAGL_VENTANA3D_H

