#include <math.h>
#include <Ventana3D.H>

namespace VDE
{

#define DBG 0

Ventana3D::Ventana3D
( 
   Modelo3D *    p_modelo ,
   const char *  p_titulo,
   unsigned int  p_nPixelsX = 256 ,
   unsigned int  p_nPixelsY = 256 
) 
throw
(
   ErrorVentana
) 
:  Ventana( p_titulo, p_nPixelsX, p_nPixelsY ) ,
   anguloH( 0.0 ) ,
   anguloV( 0.0 ) ,
   drawBox( false ),
   modelo( p_modelo )

{
   if (DBG) cout << "en 'Ventana3D::Ventana3D" << endl << flush ;
}

// ********************************************



bool Ventana3D::teclado
( 
   unsigned char k, 
   int x, 
   int y
)
{

   
   if (DBG) cout << endl
                 << "** entra Ventana3D::teclado" << endl 
                 << "** llamando a Ventana::teclado" << endl << flush ;
	
   if ( Ventana::teclado(k,x,y) )
   if ( k == 'r' || k == 'R' )
   {
       anguloH = 0.0 ;
       anguloV = 0.0 ;
       glutPostRedisplay() ;
   }
   else if ( k == 'b' || k == 'B' )
   {
       drawBox = ! drawBox ;
       glutPostRedisplay() ;
   }
   else
       modelo->KeyPressEvent(k) ;

   if (DBG) cout << "tecla=[" << ((unsigned int)k) << "]" << endl << flush ;
   
   return false ;
   
   
}

// ********************************************


void Ventana3D::tecladoEspecial
( 
   int k, 
   int x, 
   int y
)
{
   if (DBG) cout << endl
                 << "** entra Ventana3D::tecladoEspecial" << endl << flush ;
        
	
   static const unsigned int nPasos = 100 ;	
   static const double dAngulo = 360.0/(double)nPasos ;
   
   bool redisplay = true ;
   	
   switch( k )
   {
      case GLUT_KEY_UP :
      
           anguloV += dAngulo ;
           break ; 
	   
      case GLUT_KEY_DOWN :
      
           anguloV -= dAngulo ;
           break ;
	   
      case GLUT_KEY_LEFT :
      
           anguloH -= dAngulo ;
           break ; 
	   
      case GLUT_KEY_RIGHT :
      
           anguloH += dAngulo ;	
           break ; 
	   
      default :     
           redisplay = false ;	   
   
   }	
   
   if ( redisplay )
       glutPostRedisplay() ;
   
   
   if (DBG) cout << "tecla=[" << ((unsigned int)k) << "]" << endl << flush ;
}

// **************************************************************

void Ventana3D::enEspera()
{
   modelo->CallBackDesocupado() ;
}

// **************************************************************

inline double max( double a, double b ) { return (a>b) ? a:b ; }

inline double signo( double x ) { return (x>0.0) ? 1.0 : -1.0 ; } 

// ***************************************************************


       
void dibujarCaja
( 
   double c[3] ,
   double d[3] 
)
{

   glPushAttrib( GL_LIGHTING_BIT ) ;

   glDisable( GL_LIGHTING ) ;
   glDisable( GL_TEXTURE_2D ) ;
   glColor3d( 1.0,1.0,1.0 ) ;
   glShadeModel(GL_FLAT ) ;
   glEnable(GL_DEPTH_TEST) ;

	  
   double m = max(max(d[0],d[1]),d[2]) ;
      
   double dd = m/70.0 ;
   
   glPushMatrix() ;
   
   glTranslated( c[0], c[1], c[2] ) ; 
   
   for( int e = 0 ; e < 3 ; e++ )
   for( double a = -1.0 ; a <= 1.0 ; a+=2.0 )
   for( double b = -1.0 ; b <= 1.0 ; b+=2.0 )
   {
      int e1 = (e+1)%3 ,
          e2 = (e+2)%3 ;
	  
      double ac[3], ad[3]  ;
      
      ac[e]  = 0.0 ;
      ac[e1] = a*d[e1] ;
      ac[e2] = b*d[e2] ;
      
      ad[e]  = 2.0*d[e]+dd ;
      ad[e1] = dd ;
      ad[e2] = dd ;
      
      glPushMatrix() ;
   
         glTranslated( ac[0], ac[1], ac[2] ) ;
         glScaled( ad[0], ad[1], ad[2] ) ;
	 
	 glColor3d( 0.7, 0.7, 0.8 ) ;
         glutSolidCube( 1.0 ) ;
	 
	 glColor3d(1.0,1.0,1.0) ;
	 glutWireCube( 1.0 ) ;
   
      glPopMatrix() ; 	 
         
   }
   
   glPopMatrix() ;
   
   glPopAttrib() ;
   
}


// ********************************************

void Ventana3D::redibujar() 
{
    
    if (DBG) cout << "entra 'Ventana3D::redibujar' ...." << endl << flush ;
    
    Caja caja = modelo->LeerCajaEnglobante() ;
    
    double cx = 0.5 * (caja.x0 + caja.x1 ) ,
           cy = 0.5 * (caja.y0 + caja.y1 ) ,
	   cz = 0.5 * (caja.z0 + caja.z1 ) ;
    
    
    double dx = caja.x1-caja.x0   ,
           dy = caja.y1-caja.y0   ,
	   dz = caja.z1-caja.z0   ;
	   
    double maxDim = (dx > dy) ? 
                       ( (dx>dz) ? dx:dz ) : 
		       ( (dy>dz) ? dy:dz ) ;
    
    double nx = (double) nPixelsX ,
	   ny = (double) nPixelsY ;
    
    const double near = 1.0 ;
    const double far  = near+dz+maxDim ;
     
    double escala = 1.0 , 
           fx     = 1.0 , 
	   fy     = 1.0 ;
       
    if ( dy*nx < dx*ny )  // ===  dy/dx < ny/nx 
    {
        // ajustar ancho de la caja al ancho del viewport
        
	fy = ny / nx ;
	escala = 1.0/dx ;
	
	if (DBG) cout << "-- ajuste de ancho" << endl ;
    }
    else
    {
        // ajustar alto de la caja al alto del viewport
        
	fx = nx / ny  ;
	escala =  1.0/dy ;
	
	if (DBG) cout << "-- ajuste de alto" << endl ;
    }
    
    
    // Establecer el volumen (piramidal) de vision
    // y el viewport
    
    static const double e = 0.1 ;  
          // (el plano de rec. frontal estara a 1/10 de 
	  //  la distancia a la caja englobante)
    
    glMatrixMode( GL_PROJECTION ) ;
    glLoadIdentity() ;
    
    glViewport( 0,0, nPixelsX, nPixelsY ) ;
    
    glFrustum( -0.5*fx*e, 0.5*fx*e, 
               -0.5*fy*e, 0.5*fy*e, 
	       near*e, far ) ;
    

    // Establecer la transformacion de vista
    // (tener en cuenta las transformaciones en el orden contrario!)
    


    // 3. alinear la cara delantera con el plano
    //    de recorte frontal.
    
    glTranslated( 0.0, 0.0, -near ) ;
    
    // 2. escalar la caja de forma que bien el alto, bien el ancho,
    //    tengan longitud 1.0
    
    glScaled( escala,escala,escala ) ;
    
    // 1. poner el centro de la cara delantera de la caja en
    //    el origen de coordenadas
    
    glTranslated( -cx, -cy, -caja.z1 ) ;
    
       
    if (DBG) cout << "escala = " << escala << " inv. = " << 1.0/escala << endl 
                  << "fx = " << fx << " fy = " << fy << endl 
		  << "dx = " << dx << " dy = " << dy << endl  
		  << "dx/dy = " << dx/dy << endl 
		  << "fx/fy = " << fx/fy << " nx/ny = "<< nx/ny << endl << flush ;
    
    
    // *****************************************
    // limpiar capa auxiliar
    
    
    glClearColor( 0.0, 0.0, 0.0, 0.0 ) ;
    glClearDepth( far ) ;
    
    glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT ) ;
    glEnable(GL_DEPTH_TEST) ;
    
   
    // ************************************
    // dibujar el modelo en la capa auxiliar

    glMatrixMode( GL_MODELVIEW ) ;
    glLoadIdentity() ;

    modelo->SetLights() ;
        
    glPushMatrix() ;
    
       // hacer las rotaciones entorno al centro de la caja
       // segun las teclas pulsadas
       
       glTranslated( cx, cy, cz ) ;
    
       glRotated( anguloV, 1.0, 0.0,0.0 ) ;
       glRotated( anguloH, 0.0, 1.0, 0.0 ) ;
       
       glTranslated( -cx, -cy, -cz ) ;

       if ( drawBox )
       {
          double
             c[3] = {cx,cy,cz} ,
             d[3] = {dx/2.0,dy/2.0,dz/2.0} ;

          dibujarCaja( c,d ) ;
       }

       if (DBG) cout << "voy a dibujar" << endl ;
        
       modelo->Dibujar() ;
       
       if (DBG) cout  << "ya he dibujado" << endl ;

    glPopMatrix() ;
    
    
    if (DBG) cout << "yata!" << endl << flush;
    
    
    // ****************************************
    // intercambiar capa auxliar y capa visible
    // (muestra los contenidos de la capa auxiliar)
    
    glutSwapBuffers() ;
    
}


// ********************************************
   
void Ventana3D::cambioTamano
(
   int width,
   int height
) 
{

}

// ********************************************

Ventana3D::~Ventana3D()
{
    cout << "entra 'Ventana3D::~Ventana3D'" << endl << flush ;
    destruir() ;
}


} ; // namespace VDE
