#ifndef CUAGL_VENTANA_H
#define CUAGL_VENTANA_H

#include <stream.h>
#include <GL/glut.h>


namespace VDE

{

class ErrorVentana ;

class Ventana
{

 protected:

   // ****************************************
   // identificador de ventana 
   // proporcionado por 'glut' al abrirla

   int ident ; 


   // ***************************************
   // titulo de la ventana    

   const char * titulo ; 


   // *****************************************
   // numero de pixels en X y en Y

   unsigned int nPixelsX, nPixelsY ;   


   // *****************************************   
   // indica si GLUT ha sido ya inicializado o no
   
   static bool glutInicializado ; 
   
   
   // ****************************************
   // numero total de ventanas actualmente creadas
   
   static unsigned long int numVentanas  ;
   
   
   // ****************************************
   // array estatico con punteros a todas las ventanas
   // actualmente definidas
   
   static const unsigned int maxVentanas = 1000 ;
   
   static Ventana * tablaVentanas[maxVentanas] ;
   
 
   // ****************************************
   // destruye la ventana 'glut' asociada
   // disminuye 'numVentanas'
   
   void destruir() ;


   // ****************************************
   // Lista de funciones 'callback' (estaticas) 
   // que siempre instala el constructor.
   //
   // Cada una de estas funciones obtiene un
   // puntero al objeto Ventana donde se ha producido
   // el evento que genero el callback. Despues llama
   // al metodo correspondiente de dicho objeto.
   
   static void cb_teclado
   (
      unsigned char k, 
      int x, 
      int y
   ) ;
   
   static void cb_tecladoEspecial
   ( 
      int k, 
      int x, 
      int y
   ) ;
   
   static void cb_redibujar() ;
   
   static void cb_cambioTamano
   (
      int width,
      int height
   ) ;

   static void cb_enEspera() ;
   
   // *******************************************
   
 protected:

   // *****************************************
   // rellena la ventana de negro. 
  
   
   void Rellenar() ;
   
   // ***************************************
   // lista de callbacks que se pueden redefinir
   // en clases derivadas
   
   // no hace nada
   
   virtual void redibujar() ; 
   
   // al pulsar 'esc' se destruye la ventana
   // al destruir ultima ventana se aborta el programa
   
   virtual bool teclado
   (
      unsigned char k, 
      int x, 
      int y
   ) ;
   
   virtual void tecladoEspecial
   ( 
      int k, 
      int x, 
      int y
   ) ;
   
   virtual void cambioTamano
   (
      int width,
      int height
   ) ; 

   virtual void enEspera() ;
   
   

   // ****************************************
   
                  
 public: 


   // *****************************************
   // creacion de un ventana, dando el titulo

   Ventana
   ( 
      const char * p_titulo,
      unsigned int p_nPixelsX = 256,
      unsigned int p_nPixelsY = 256 
   ) 
   throw
   (
      ErrorVentana
   );
   
   
   // ****************************************
   // cierra la ventana en la pantalla

   virtual ~Ventana() ;
   
} ;

// *********************************************

class ErrorVentana
{
    private:

    const char * msg ,
               * nombre ;

    public:

    ErrorVentana
    (
       const char * p_msg ,
       const char * p_nombre
    ) ;
        

    void imprimeMensaje() ;       
} ;


} ; // namespace VDE

#endif // CUAGL_VENTANA_H



