#include "Ventana.H"
#include <GL/glut.h>
#include <GL/gl.h>


namespace VDE
{

bool Ventana::glutInicializado = false ;

unsigned long int Ventana::numVentanas = 0 ;

Ventana * VDE::Ventana::tablaVentanas[VDE::Ventana::maxVentanas] ;

#define DBG 0

// ****************************************************

#define VentanaActual()   (tablaVentanas[glutGetWindow()])

// ****************************************************

Ventana::Ventana
( 
   const char * p_titulo,   
   unsigned int p_nPixelsX = 256,
   unsigned int p_nPixelsY = 256  
) 
throw
(
   ErrorVentana
)
:  
   titulo   ( p_titulo   ) ,
   nPixelsX ( p_nPixelsX ) ,
   nPixelsY ( p_nPixelsY )
   
{
   int argc = 1 ;
   char * argv [1] = { "Ventana" } ;
   
   if ( ! glutInicializado ) 
   {
   
      if (DBG) cout << "inicializando glut ..."  ;
      
      glutInit(&argc,argv) ;
      glutInitDisplayMode( GLUT_RGB | GLUT_DEPTH | GLUT_DOUBLE ) ;
      
      glutInicializado = true ;
      
      if (DBG) cout << " hecho" << endl << flush ;
   }
   
   if (DBG) cout << "creando ventana (" << titulo << ") .... " ;
    
   if ( numVentanas >= maxVentanas-1 )
      throw ErrorVentana("Imposible crear ventana (ya hay demasiadas)",titulo) ;
  
   glutInitWindowSize( nPixelsX, nPixelsY ) ;

   ident =  glutCreateWindow( titulo ) ;
   
   

   if ( ident == 0 )
      throw ErrorVentana("Imposible crear ventana (error de 'glut')",titulo) ;

   numVentanas ++ ;
   
   tablaVentanas[ident] = this ;
   
   glutSetWindow( ident ) ;
  
   // instalar todos los callbacks
  
   glutDisplayFunc  ( cb_redibujar    ) ;
   glutKeyboardFunc ( cb_teclado      ) ;
   glutSpecialFunc  ( cb_tecladoEspecial ) ;
   glutReshapeFunc  ( cb_cambioTamano ) ;
   glutIdleFunc     ( cb_enEspera ) ;
   
   
   if (DBG) 
      cout << endl << 
      "hecho (ident=" << ident << "," << "this=" << this << " numVentana=" << numVentanas << ")" 
      << endl << flush ;
}

// ********************************************************

void Ventana::destruir()
{
   if (DBG) cout << endl 
                 << "** entra Ventana::destruir.." << endl 
                 << "** destruyendo ventana (" << titulo << ")" << endl
		 << "** ident == " << ident << endl
		 << "** glutGetWindow() == " << glutGetWindow() << endl ;
   
   
   glutDestroyWindow( ident ) ;
   
   tablaVentanas[ident] = NULL ;
   
   numVentanas -- ;
   
   if (DBG) cout << "** hecho (quedan " << numVentanas << ") " << endl << flush ;
   
}

// *********************************************************



Ventana::~Ventana()
{
    if (DBG) cout << "en 'Ventana::~Ventana' " << endl << flush ;
    destruir() ;
}



// ********************************************************

void Ventana::Rellenar()
{

    if (DBG) cout << "rellenando ventana (" << ident << ") ... " ;
    
    glClearColor( 0.0, 0.0, 0.0, 0.0 ) ;
    glClearDepth( 0.0 ) ;
    
    glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT ) ;
    
    glColor3f( 1.0,1.0,1.0) ;
    
    glRectf( 10.0,10.0,110.0,110.0 ) ;
    
    
  
    glutSwapBuffers() ;
    
    if (DBG) cout << "hecho" << endl << flush ;
}

// ************************************************

void Ventana::cb_redibujar()  
{
    if (DBG) cout << endl << "** entra cb_redibujar" << endl << flush ;
    
    VentanaActual()->redibujar() ;	 
}

void Ventana::redibujar()
{
    if (DBG) cout << "entra redibujar" << endl << flush ;

    Rellenar() ;
}

// ****************************************************

void Ventana::cb_teclado
( 
   unsigned char k, 
   int x, 
   int y
)
{  bool  b ;
   if (DBG) cout << endl 
                 << "** entra cb_teclado. k= [" << ((unsigned int)k) << "]" << endl
		 << "** ventana = [" << glutGetWindow() << "]" << endl 
		 << "** llamando a 'Ventana::teclado'" << endl << flush ;
		 
   b= VentanaActual()->teclado(k,x,y) ;
}

bool Ventana::teclado
( 
   unsigned char k, 
   int x, 
   int y
)
{
   bool res = true ;
   
   if (DBG) cout << "** entra Ventana::teclado ..." << endl ;
   
   if ( k==27 )
   {
      if (DBG) cout << "** escape: destruyendo...." << endl << flush ;
      destruir() ;
   
      res = false ;
         
      if ( numVentanas == 0 )
         exit(0) ;
   }
   
   return res ;
}

// ****************************************************

void Ventana::cb_tecladoEspecial
( 
   int k, 
   int x, 
   int y
)
{
   if (DBG) cout << endl 
                 << "** entra cb_tecladoEspecial k= [" << ((unsigned int)k) << "]" << endl
		 << "ventana = [" << glutGetWindow() << "]" << endl 
		 << "llamando a 'tecladoEspecial'" << endl << flush ;
		 
   VentanaActual()->tecladoEspecial(k,x,y) ;
}

void Ventana::tecladoEspecial
( 
   int k, 
   int x, 
   int y
)
{
   // nada
}

// *********************************************************

void Ventana::cb_cambioTamano
(
   int width,
   int height
)
{
   Ventana * ventana = VentanaActual() ;
   
   ventana->nPixelsX = width ;
   ventana->nPixelsY = height ;
   
   if (DBG) cout << endl
                 << "** callback cambio de tamano (" << glutGetWindow() << ")" << endl
                 << "nuevo tam x = " << width << " y = " << height << endl << flush ;	
   
   ventana->cambioTamano( width, height ) ;
}

void Ventana::cambioTamano
(
   int width,
   int height
)
{

   //glMatrixMode( GL_PROJECTION ) ;
   
   //glViewport(0,0,width,height) ;  
        // ver pagina 21 del manual de glut
}

// ***************************************************

void Ventana::cb_enEspera()
{
   if (DBG) cout << "** entra cb_enEspera .." << endl << flush ;
   
   Ventana * v = VentanaActual() ;
   
   if ( v!= NULL )
      VentanaActual()->enEspera() ;
}

void Ventana::enEspera()
{
   //static unsigned long int c = 0 ;

   //cout << c++ << endl ;
}

// *********************************************************

ErrorVentana::ErrorVentana
(
   const char * p_msg ,
   const char * p_nombre
)
:  msg( p_msg ) ,
   nombre( p_nombre )
{
   // vacio 
}

// *********************************************************

void ErrorVentana::imprimeMensaje()
{
   cout << flush ;
   
   cerr << "Error de ventana     : " << msg << endl 
        << "Nombre de la ventana : " << nombre << endl 
        << flush ;
}

// *********************************************************

} // namespace VDE


