//***************************************************************
//***
//***   File:     Vector.H
//***   Function: Declarations of Vector
//***
//***   
//***************************************************************

#ifndef  VECTOR_HPP
#define  VECTOR_HPP


//*************************************************************

template<class Scalar, int N>
class Vector
{
  protected:
    
  Scalar c[N]  ;
        
         // array of values at each component of the vector

  public:

  Vector
  (
       Scalar cx,
       Scalar cy,
       Scalar cz
  ) ;

  Vector
  (
      Scalar coords[N]
  ) ;


        
         // builds a Vector, explicitly giving its components

  Vector() ;
         
  Vector<Scalar,N> & operator *=
  (
      const Matrix4x4<Scalar> & m
  ) ;
  
         // aplies 'm' to the receiver and returns a
         // reference to the modified receiver 


  Scalar & operator[]
  (
      Axis axis
  ) ;

  Scalar & operator[]
  (
      unsigned i
  ) ;

  Scalar operator()
  (
      Axis axis
  )
      const ;

  Scalar operator()
  (
      unsigned i
  )
      const ;
  
         // returns the component of the receiver in the axis 'axis'  or in the position 'i'
         
  Vector<Scalar,N> & operator *=
  (
      const Transform<Scalar> & t
  ) ;
  
         // applies 't' to the receiver and returns a
         // reference to the modified receiver
         
  Vector<Scalar,N> operator *
  (
      const Transform<Scalar> &t
  )
      const ;
  
         // applies 't' to the reciver, and returns a
         // copy of the result.  

  bool IsValid
  ( )
      const ;

         // check if any of the components of the receiver
         // is an invalid floating value, and in this
         // case returns false. In any other case returns
         // true.   
  

  Vector<Scalar,N> & operator +=
  (
      const Vector<Scalar,N> & v
  ) ;

         // adds 'v' to the receiver, returns a reference to the
         // modified receiver (impl. of  v += v )

  Vector<Scalar,N> operator +
  (
      const Vector<Scalar,N> &v
  )
      const ;

         // adds the receiver and 'v', then returns a copy of the
         // result (impl. of v= v+v )

  Vector<Scalar,N> & operator -=
  (
      const Vector<Scalar,N> &v
  ) ;

         // subtracts 'v' to the receiver, return a reference to the
         // modified receiver (impl of v -= v )

  Vector<Scalar,N> operator -
  (
      const Vector<Scalar,N> &v
  )
      const ;

         // substract 'v' from the receiver, then returns a
         // copy of the result (impl. of v= v-v )

  Scalar operator |
  (
      const Vector<Scalar,N> &v
  )
      const ;

         // performs inner product between the receiver and 'v'
         // then returns the result (impl of t= v|v )

  Vector<Scalar,N> & operator *=
  (
      Scalar t
  ) ;

         // performs external product of the receiver and 't'
         // then returns a reference to the modified receiver

  Vector<Scalar,N> operator *
  (
      Scalar t
  )
      const  ;

        // performs external product between the receiver ant 't'
        // then returns a copy of the result ( impl. of  v= v*t )

  Vector<Scalar,N> operator *
  (
      const Vector<Scalar,N> & v
  )
      const ;

        // performs cross product of the receiver and 'v'
        // then returns a copy of the result



  Scalar Module
  ( )
      const ;

         // It returns the vector module.

  Vector<Scalar,N> Normalized
  ( )
      const ;

         // It returns a normalized copy of the reciever
} ;

template<class Scalar, int N>
std::ostream &  operator <<
(
    std::ostream & os ,
    const Vector<Scalar,N> & v
) ;

#endif  // VECTOR_HPP
