
//*****************************************************************
//***
//***   File:     Vector.C
//***
//*****************************************************************



#define impl_un(o)   { for( unsigned i = 0 ; i<N ; i++ )  { c[i] o v(i) ; } }



template<class Scalar, int N>
Vector<Scalar,N>::Vector
(
  Scalar cx,
  Scalar cy,
  Scalar cz
)
{

  c[X]= cx ;

  if ( N > 1 )
  {
     c[Y]= cy ;

     if ( N > 2 )
        c[Z]= cz ;
  }

}

template<class Scalar, int N>
Vector<Scalar,N>::Vector
(
  Scalar coords[N]
)
{

  for( int i=0 ; i < N ; i++ )
     c[i] = coords[i] ;

}




template<class Scalar, int N>
Vector<Scalar,N>::Vector
( )
{

}


template<class Scalar, int N>
Scalar & Vector<Scalar,N>::operator[]
(
   Axis axis
)
{
   return c[(int)axis] ;
}

template<class Scalar, int N>
Scalar & Vector<Scalar,N>::operator[]
(
   unsigned i
)
{
   return c[i] ;
}

template<class Scalar, int N>
Scalar Vector<Scalar,N>::operator()
(
   Axis axis
)
   const
{
   return c[(int)axis] ;
}

template<class Scalar, int N>
Scalar Vector<Scalar,N>::operator()
(
   unsigned i
)
   const
{
   return c[i] ;
}

template<class Scalar, int N>
Vector<Scalar,N> & Vector<Scalar,N>::operator *=
(
   const Matrix4x4<Scalar> & m
)
{
   Scalar res[4],
          cext[4] = {1.0,1.0,1.0,1.0} ;

   unsigned imax = ( N>4 ) ? 4 : N ;

   for( unsigned i=0 ; i < imax ; i++ )
      cext[i] = c[i] ;


   //
   // Multiplicacion por la izquierda del vector  por la matriz
   // (se considera el vector como vector fila de 1 fila x 4 columnas )
   // se obtiene de nuevo un vector de 1 fila x 4 columnas
   //

   for( unsigned j= 0 ; j<4 ; j++ )
   {
      Scalar tmp= 0.0 ;

      for( unsigned i= 0 ; i<4 ; i++ )
      {
         tmp += cext[i] * m.Get(i,j) ;
      }

      res[j]= tmp ;
   }

   for( unsigned i= 0 ; i<imax ; i++ )
     c[i]= res[i] ;

   return *this ;
}

template<class Scalar, int N>
Vector<Scalar,N> & Vector<Scalar,N>::operator *=
(
   const Transform<Scalar> & t
)
{
   return (*this) *= t.GetMDir() ;
}

template<class Scalar, int N>
Vector<Scalar,N> Vector<Scalar,N>::operator *
(
   const Transform<Scalar> & t
)
   const
{
   Vector<Scalar,N> res= *this ;
   return res *= t ;
}

template<class Scalar, int N>
bool Vector<Scalar,N>::IsValid() const

{
   Axis i ;

   for( unsigned int i=0 ; i < N ; i++ )
   {
      if ( !IsNumber( c[i] ) )
         return false ;
   }

   return true ;

}




//*************************************************************

template<class Scalar, int N>
Vector<Scalar,N> & Vector<Scalar,N>::operator +=
(
   const Vector &v
)
{
   impl_un(+=) ;
   return *this ;
}

template<class Scalar, int N>
Vector<Scalar,N> Vector<Scalar,N>::operator +
(
  const Vector & v
)
  const
{
  Vector res(*this) ;
  return res += v ;
}

template<class Scalar, int N>
Vector<Scalar,N> & Vector<Scalar,N>::operator -=
(
   const Vector &v
)
{
   impl_un(-=) ;
   return *this ;
}

template<class Scalar, int N>
Vector<Scalar,N> Vector<Scalar,N>::operator -
(
   const Vector &v
)
   const
{
   Vector<Scalar,N> res(*this) ;
   return res -= v ;
}

template<class Scalar, int N>
Scalar Vector<Scalar,N>::operator |
(
   const Vector & v
)
   const
{
   Scalar res = Scalar(0.0) ;

   for( unsigned i= 0 ; i < N ; i++ )
   {
       res = res  + c[i]*v(i) ;
   }

   return res ;
}

template<class Scalar, int N>
Vector<Scalar,N> & Vector<Scalar,N>::operator *=
(
   Scalar t
)
{
   for( unsigned i= 0 ; i < N ; i++ )
   {
       c[i] *= t ;
   }

   return *this ;
}

template<class Scalar, int N>
Vector<Scalar,N> Vector<Scalar,N>::operator *
(
   Scalar t
)
   const
{
   Vector res(*this) ;
   return res *= t ;
}

template<class Scalar, int N>
Vector<Scalar,N> operator *
(
   Scalar t,
   const Vector<Scalar,N> & v
)
{
   Vector<Scalar,N> res(v) ;
   return res *= t ;
}

template<class Scalar, int N>
Vector<Scalar,N> Vector<Scalar,N>::operator *
(
   const Vector &v
)
   const
{
   return Vector( c[Y]*v(Z) - c[Z]*v(Y),
                  c[Z]*v(X) - c[X]*v(Z),
                  c[X]*v(Y) - c[Y]*v(X) ) ;
}

#define SQR(x) ((x)*(x))

template<class Scalar, int N>
Scalar Vector<Scalar,N>::Module
()
   const
{
   return sqrt ( SQR(c[X]) + SQR(c[Y]) + SQR(c[Z]) ) ;
}

template<class Scalar, int N>
Vector<Scalar,N> Vector<Scalar,N>::Normalized
()
   const
{
   Scalar mod= 1.0 / Module() ;
   return (*this)*mod ;
}

template<class Scalar, int N>
std::ostream &  operator <<
(
    std::ostream & os ,
    const Vector<Scalar,N> & v
)
{
    os << "(" << v(0) ;

    for( unsigned i=1 ; i < N ; i++ )
    {
        os << "," << v(i) ;
    }

    os << ")" ;

    return os ;
}








