
/*******************************************************
***
***   Fichero: TRANSFORM.H++
***   Funcion: Declarations of MATRIX4x4 and TRANSFORM classes
***
*** Date      Author     Action
***---------------------------------------
*** 21/5/96   J.Carlos   Identity Transform constructor added
 * 2002-06-17:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 * 
***
*******************************************************/

#ifndef  GRF_TRANSFORM_HPP
#define  GRF_TRANSFORM_HPP


typedef enum { X=0,Y=1,Z=2,W=3 } Axis ;


template<class Scalar, int N> class Vector ;

//*************************************************************

template<class Scalar>
class Matrix4x4
{
   protected:

   Scalar a[4][4] ;

        // array of values of the matrix
        // A[i][j] is the value at row number 'i', column number 'j'

   public:

   Matrix4x4
   (
       Scalar ca00, Scalar ca01, Scalar ca02, Scalar ca03,
       Scalar ca10, Scalar ca11, Scalar ca12, Scalar ca13,
       Scalar ca20, Scalar ca21, Scalar ca22, Scalar ca23,
       Scalar ca30, Scalar ca31, Scalar ca32, Scalar ca33
   ) ;

        // constructor, we explicitly give every entry
        // parameter. 'caij' is copied to 'a[i][j]'



   void operator *=
   (
        const Matrix4x4<Scalar> & M
   ) ;

        // composes M with the receiver, and returns a reference
        // to the modified receiver (does receiver = receiver * M )


   inline Scalar Get
   (
       const unsigned  & i ,
       const unsigned  & j
   )
       const
   {
       return a[i][j] ;
   }



} ;

template<class Scalar>
std::ostream & operator <<
(
   std::ostream & os ,
   const Matrix4x4<Scalar> & m
) ;

//*********************************************************************

template<class Scalar>
class Transform

//  Linear transformations operating on Vectors with 3 or 4 components ??
//  We store the arrays modelling direct and inverse transform.
//


{   protected:

    Matrix4x4<Scalar> mDir, mInv ;

       // Matrix modeling direct and inverse transformation

    public:

    Transform
    (
         const Matrix4x4<Scalar> &  cMDir ,
         const Matrix4x4<Scalar> &  cMInv
    ) ;

       // constructor, we explicitly give direct and inverse Matrixes

   Transform( ) ;

       // Identity transformation constructor


    void operator *=
    (
       const Transform<Scalar> &t
    ) ;

       // compose the receiver and 't',  store the result
       // at the receiver, and return a reference to it.

    Transform<Scalar> operator *
    (
       const Transform<Scalar> & t
    )
       const ;

       // compose the receiver and 't', and return a copy
       // of the result

    Transform<Scalar> Inverse
    ( )
       const ;

       // returns a copy of the inverse of the receiver.


    const Matrix4x4<Scalar> & GetMDir
    ( )
       const ;


    const Matrix4x4<Scalar> & GetMInv
    ( )
       const ;

    Vector<Scalar,3>  TrNormalVector
    (
       const Vector<Scalar,3> & vNormal
    )
       const ;


} ;


template<class Scalar>
Transform<Scalar> TRotation
(
        Axis   a ,
        Scalar rad
) ;

     // builds a rotation about axis 'a' of 'rad' radians

template<class Scalar>
Transform<Scalar> TTranslation
(
       const Vector<Scalar,3> &v
) ;

       // builds a translation

template<class Scalar>
Transform<Scalar> TScale
(
       const Vector<Scalar,3> &v
) ;

       // builds a scaling transformation

template<class Scalar>
Transform<Scalar> TPerspective
(
       Scalar d
) ;

       // builds a perspective transform with focus is at (0,0,-d),
       // the viewplane is in the Z=0 plane.


template<class Scalar>
void TrError
(
    const char * msg
) ;




#endif // GRF_TRANSFORM_HPP

