/* 2002-06-17:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 

// #define Error(msg) { cerr << (msg) ; exit(1) ; }

//*******************************************
//**
//**  class MATRIX4x4
//**
//*******************************************

template<class Scalar>
Matrix4x4<Scalar>::Matrix4x4
(
    Scalar ca00, Scalar ca01, Scalar ca02, Scalar ca03,
    Scalar ca10, Scalar ca11, Scalar ca12, Scalar ca13,
    Scalar ca20, Scalar ca21, Scalar ca22, Scalar ca23,
    Scalar ca30, Scalar ca31, Scalar ca32, Scalar ca33
)
{
    a[0][0] = ca00 ; a[0][1] = ca01 ; a[0][2] = ca02 ; a[0][3] = ca03 ;
    a[1][0] = ca10 ; a[1][1] = ca11 ; a[1][2] = ca12 ; a[1][3] = ca13 ;
    a[2][0] = ca20 ; a[2][1] = ca21 ; a[2][2] = ca22 ; a[2][3] = ca23 ;
    a[3][0] = ca30 ; a[3][1] = ca31 ; a[3][2] = ca32 ; a[3][3] = ca33 ;
}

//*******************************************

template<class Scalar>
void Matrix4x4<Scalar>::operator *=
(
    const Matrix4x4 &m
)
{
    Scalar res[4][4] ;

    int i,j ;

    for( i= 0 ; i<4 ; i++ )
    for( j= 0 ; j<4 ; j++ ) 
    {
       Scalar tmp= 0.0 ;

       for( int k= 0 ; k<4 ; k++ )
          tmp += a[i][k] * m.a[k][j] ;

       res[i][j]= tmp ;
    }
    
    for( i= 0 ; i<4 ; i++ )
    for( j= 0 ; j<4 ; j++ )
       a[i][j]= res[i][j] ;
}

//*******************************************

template<class Scalar>
std::ostream & operator <<
(
   std::ostream & os ,
   const Matrix4x4<Scalar> & m
)
{

   for( unsigned irow = 0 ; irow < 4 ; irow++ )
   {
      os << endl << " | " ;

      for( unsigned icol = 0 ; icol < 4 ; icol++ )
      {
         os << m.Get(irow,icol) ;
         if ( icol < 3 )
            os << " , " ;
      }

      os << " | " ;
   }

   os << endl << flush ;

   return os ;
}

//*******************************************


//*******************************************
//**
//**  class TRANSFORM
//**
//*******************************************

template<class Scalar>
Transform<Scalar>::Transform
(
   const Matrix4x4<Scalar> &cMDir,
   const Matrix4x4<Scalar> &cMInv
)

:  mDir(cMDir),
   mInv(cMInv)
{
}

//*******************************************

template<class Scalar>
Transform<Scalar>::Transform( )

:  mDir
   (   Matrix4x4<Scalar>
       (
          1,  0,  0,  0,
          0,  1,  0,  0,
          0,  0,  1,  0,
          0,  0,  0,  1
       )
   ),
   mInv
   (
       Matrix4x4<Scalar>
       (
          1,  0,  0,  0,
          0,  1,  0,  0,
          0,  0,  1,  0,
          0,  0,  0,  1
       )
   )
{
}


//*******************************************

template<class Scalar>
Transform<Scalar> TRotation
(
   Axis   axis,
   Scalar rad
)
{  

   Scalar c= (Scalar) cos((double)rad) ,
          s= (Scalar) sin((double)rad) ;

   switch ( axis )
   {
     case X :
        return Transform<Scalar>
               (  Matrix4x4<Scalar>
                  (  1,  0,  0,  0,
                     0,  c,  s,  0,
                     0, -s,  c,  0,
                     0,  0,  0,  1   
                  ),                   
                  Matrix4x4<Scalar>
                  (  1,  0,  0,  0,
                     0,  c, -s,  0,
                     0,  s,  c,  0,
                     0,  0,  0,  1  
                  ) 
               ) ;  
     case Y :
        return Transform<Scalar>
               (  Matrix4x4<Scalar>
                  (  c,  0, -s,  0,
                     0,  1,  0,  0,
                     s,  0,  c,  0,
                     0,  0,  0,  1   
                  ),                   
                  Matrix4x4<Scalar>
                  (  c,  0,  s,  0,
                     0,  1,  0,  0,
                    -s,  0,  c,  0,
                     0,  0,  0,  1  
                  ) 
               ) ;       
     case Z :
        return Transform<Scalar>
               (  Matrix4x4<Scalar>
                  (  c,  s,  0,  0,
                    -s,  c,  0,  0,
                     0,  0,  1,  0,
                     0,  0,  0,  1 
                  ),                   
                  Matrix4x4<Scalar>
                  (  c, -s,  0,  0,
                     s,  c,  0,  0,
                     0,  0,  1,  0,
                     0,  0,  0,  1  
                  ) 
               ) ;
      default :
         TrError<Scalar>("Invalid parameter in call to TRotation (use either X,Y or Z axis)");
   }

   return  Transform<Scalar>() ;

}
           //*******************************************

template<class Scalar>
Transform<Scalar> TTranslation
(
  const Vector<Scalar,3> & v
)
{     
  return Transform<Scalar>
         ( Matrix4x4<Scalar>
           (    1,    0,    0,  0,
                0,    1,    0,  0,
                0,    0,    1,  0,
             v(X), v(Y), v(Z),  1
           ) ,
           Matrix4x4<Scalar>
           (    1,    0,    0,  0,
                0,    1,    0,  0,
                0,    0,    1,  0,
            -v(X),-v(Y),-v(Z),  1
           ) 
         ) ;
}

//*********************************************************************

template<class Scalar>
Transform<Scalar> TScale
(
   const Vector<Scalar,3> & v
)
{

  if ( v(X) == 0.0 || v(Y) == 0.0 || v(Z) == 0.0 )
  {
     TrError<Scalar>("Invalid parameter in call to TScale (a component is cero)");
  }
  
  return Transform<Scalar>
         ( Matrix4x4<Scalar>
           ( v(X),    0,    0,  0,
                0, v(Y),    0,  0,
                0,    0, v(Z),  0,
                0,    0,    0,  1.0
           ) ,
           Matrix4x4<Scalar>
           (  1.0/v(X),        0,        0,  0,
                     0, 1.0/v(Y),        0,  0,
                     0,        0, 1.0/v(Z),  0,
                     0,        0,        0,  1.0
           ) 
         ) ;

}

//********************************************************************

template<class Scalar>
const Matrix4x4<Scalar> & Transform<Scalar>::GetMDir
()
  const
{
  return mDir ;
}

//********************************************************************

template<class Scalar>
const Matrix4x4<Scalar> & Transform<Scalar>::GetMInv
()
  const
{
  return mInv ;
}

//*********************************************************************

template<class Scalar>
Transform<Scalar> TPerspective
(
  Scalar d
)
{

  return Transform<Scalar>
         ( Matrix4x4<Scalar>
           (    1,  0,  0,  0,
                0,  1,  0,  0,
                0,  0,  1,  d,
                0,  0,  0,  1
           ) ,
           Matrix4x4<Scalar>
           (    1,  0,  0,  0,
                0,  1,  0,  0,
                0,  0,  1, -d,   // revisar esto !!
                0,  0,  0,  1
           ) 
         ) ;



}

//*********************************************************************

template<class Scalar>
void Transform<Scalar>::operator *=
(
   const Transform<Scalar> & t
)
{
   mDir *= t.GetMDir() ;
   
   Matrix4x4<Scalar>  newMInv= t.GetMInv() ;
   
   newMInv *= mInv ;  
   mInv     = newMInv ;
}

//*********************************************************************

template<class Scalar>
Transform<Scalar> Transform<Scalar>::operator *
(
   const Transform<Scalar> & t
)
   const
{
   Transform<Scalar> res= *this ;
   
   res *= t ;

   return res ;
}

//*********************************************************************

template<class Scalar>
Transform<Scalar> Transform<Scalar>::Inverse
( )
   const
{  
   
   Matrix4x4<Scalar>  newMInv = mDir ;
   Matrix4x4<Scalar>  newMDir = mInv ;

   return Transform<Scalar>(newMDir,newMInv) ;
}

//*********************************************************************

template<class Scalar>
Vector<Scalar,3>  Transform<Scalar>::TrNormalVector
(
    const Vector<Scalar,3> & vNormal
)
    const
{
    Scalar res[3] ;

    // multiplicacion por la derecha del vector columna
    // es decir: res = matriz * vector
    // se usa la matriz inversa
    // esto sirve para transformar vectores

    for( int i= 0 ; i < 3 ; i++ )
    {
       res[i]= 0.0 ;

       for( int j= 0 ; j < 3 ; j++ )
          res[i] += vNormal(j) * mInv.Get(i,j) ;
    }

    return (Vector<Scalar,3>(res[0],res[1],res[2])).Normalized() ;

}

//**********************************************************************


template<class Scalar>
void TrError
(
    const char * msg
)
{
    std::cerr << std::endl << msg << std::endl << std::flush ;
    exit(1) ;
}
