/* 2002-06-17:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 

#ifndef GRF_TOKEN_H
#define GRF_TOKEN_H


#include <string>
#include <iostream>

namespace GRF
{

typedef enum
{
    tkBegin,
    tkClosePar,
    tkComma,
    tkClusterId,
    tkDef,
    tkEnd,
    tkEndOfInput,
    tkEqual,
    tkErroneous,
    tkFaces,
    tkIdentifier,
    tkIrad,
    tkInclude,
    tkLight,
    tkLiteral,
    tkMesh,
    tkNormal,
    tkNumericInteger,
    tkNumericDouble,
    tkOpenPar,
    tkRGB,
    tkRotation,
    tkScale,
    tkTexture,
    tkTranslation,
    tkTransform ,
    tkUnassigned,
    tkUV,
    tkVertexs
}
    TokenType ;

class Token
{
   private:

   double     lastDouble ;
   long       lastInteger ;
   std::string     lastString ;
   TokenType  type ;
   std::istream *  isp ;



   void ReadNumericToken
   (
      char ich
   ) ;

   void ReadAlphaToken
   (
      char ich
   ) ;

   void ReadLiteral() ;

   void SkipInput() ;

   public :
   
   Token()  ;

   Token
   (
     std::istream & is
   ) ;

   ~Token() ;

   void ReadFrom
   (
     std::istream & is
   ) ;

   double ValueDouble() ;
   long   ValueInteger() ;
   std::string ValueString() ;

   TokenType Type() ;

   friend std::istream & operator >>
   (
      std::istream & is,
      Token & tk
   ) ;

   static bool lexDebug ;

} ; // class Token
   
   
} ; // namespace GRF
   
#endif // GRF_TOKEN_H
