/* 2002-06-17:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 
#include <Token.H>
#include <cctype>
#include <string>
#include <ParserError.H>
#include <math.h>



namespace GRF
{

 bool Token::lexDebug = false ;


 Token::Token
 ()
 : type(tkUnassigned)
 , isp(NULL)
 {

 }

 Token::Token
 (
    std::istream & is
 )
 {
    ReadFrom(is) ;
 }


 void Token::ReadNumericToken
 (
    char ich
 )
 {
    char   ch     = ich ;
    bool   expPos = true ;
    double exp    = double(0.0) ;

    type = tkNumericInteger ;

    bool positive = true ;
    long v = 0L ;
    double vd = 0.0 ;

    if ( ch == '-' )
    {
       positive = false ;
       ch = isp->get() ; if (lexDebug) std::cout << ch ;
    }

    if ( ! isdigit(ch) )
       throw ParserError("digit expected inmediatelly after '-'",
                         "Token::ReadNumericToken");


    while( isdigit(ch) )
    {
       v = v*10 + ( int(ch) - int('0') ) ;
       ch = isp->get() ; if (lexDebug) std::cout << ch ;
    }


    if ( ch == '.' )
    {
       double m = 0.1 ;

       ch = isp->get() ; if (lexDebug) std::cout << ch ;

       if ( ! isdigit(ch) )
          throw ParserError("digits expected inmediatelly after '.'",
                            "Token::ReadNumericToken");

       type = tkNumericDouble ;

       while( isdigit(ch) )
       {
          vd = vd + m*double( int(ch) - int('0') ) ;
          m  = m/(double)10.0 ;
          ch = isp->get() ; if (lexDebug) std::cout << ch ;
       }

       if ( ch == 'e' || ch == 'E' )
       {

          ch = isp->get() ; if (lexDebug) std::cout << ch ;

          if ( ch == '+' )
             expPos = true ;
          else if ( ch == '-' )
              expPos = false ;
          else
              throw ParserError("'+' o '-' expected after 'e' or 'E'","Token::ReadNumericToken") ;

          ch = isp->get() ; if ( lexDebug ) std::cout << ch ;

          if ( ! isdigit(ch) )
              throw ParserError("digit expected after '+' or '-'","Token::ReadNumericToken") ;

          while( isdigit(ch) )
          {
              exp = (exp*10.0) + (double)( int(ch)-int('0') ) ;
              ch = isp->get() ; if   ( lexDebug ) std::cout << ch ;
          }

       }
    }

    if ( ! isp->eof() )
       isp->putback(ch) ;

    if ( type == tkNumericInteger && exp != double(0.0) )
    {
       lastInteger = v ;
       lastDouble  = double(v) + vd ;
    }
    else
    {

        double r = double(v) + vd ,
               f = pow(double(10.0),exp) ;

        //cout << "[exp: lastDouble==" << r << "*10^" << exp << "]" ;

        if ( expPos )
           lastDouble = r*f ;
        else
           lastDouble = r/f ;

        lastInteger = int(lastDouble) ;
    }

    if ( ! positive )
    {
       lastInteger = -lastInteger ;
       lastDouble  = -lastDouble ;
    }

    if ( type == tkNumericInteger )
    {
       if (lexDebug) std::cout << "[integer,v=" << lastInteger << "]" 
			       << std::endl ;
    }
    else
    if ( type == tkNumericDouble )
    {
       if (lexDebug) std::cout << "[double,v=" <<  lastDouble << "]" 
			       << std::endl ;
    }
    else
    {
       if (lexDebug) std::cout << "[!!!error!!]" ;
       throw ParserError("internal error. unreachable point reached ;)",
                         "Token::ReadNumericToken");
    }
 }

 void Token::ReadAlphaToken
 (
    char ich
 )
 {

    char ch = ich ;
    std::string s = "" ;

    while( isalpha(ch) || isdigit(ch) )  // (isalnum valdria...)
    {
        s += ch ;
        ch = isp->get() ; if (lexDebug) std::cout << ch ;
    }

    if ( ! isp->eof() )
       isp->putback(ch) ;

    if ( s == "begin" )
    {
       type = tkBegin ;
       if (lexDebug) std::cout << "[begin]" << std::endl ;
    }
    else if ( s == "end" )
    {
       type = tkEnd ;
       if (lexDebug) std::cout << "[end]" << std::endl ;
    }
    else if ( s == "mesh" )
    {
       type = tkMesh ;
       if (lexDebug) std::cout << "[mesh]" << std::endl ;
    }
    else if ( s == "vertexs" )
    {
       type = tkVertexs ;
       if (lexDebug) std::cout << "[vertexs]" << std::endl ;
    }
    else if ( s == "vertex" )
    {
       type = tkVertexs ;
       if (lexDebug) std::cout << "[vertex]" << std::endl ;
    }
    else if ( s == "faces" )
    {
       type = tkFaces ;
       if (lexDebug) std::cout << "[faces]" << std::endl ;
    }
    else if ( s == "face" )
    {
       type = tkFaces ;
       if (lexDebug) std::cout << "[face]" << std::endl ;
    }
    else if ( s == "normal" )
    {
       type = tkNormal ;
       if (lexDebug) std::cout << "[normal]" << std::endl ;
    }
    else if ( s == "light" )
    {
       type = tkLight ;
       if (lexDebug) std::cout << "[light]" << std::endl ;
    }
    else if ( s == "rgb" )
    {
       type = tkRGB ;
       if (lexDebug) std::cout << "[rgb]" << std::endl ;
    }
    else if ( s == "include" )
    {
       type = tkInclude ;
       if (lexDebug) std::cout << "[include]" << std::endl ;
    }
    else if ( s == "irad" )
    {
       type = tkIrad ;
       if (lexDebug) std::cout << "[irad]" << std::endl ;
    }
    else if ( s == "clusterid" )
    {
       type = tkClusterId ;
       if (lexDebug) std::cout << "[clusterid]" << std::endl ;
    }
    else if ( s == "transform" )
    {
       type = tkTransform ;
       if (lexDebug) std::cout << "[transform]" << std::endl ;
    }
    else if ( s == "scale" )
    {
       type = tkScale ;
       if (lexDebug) std::cout << "[scale]" << std::endl ;
    }
    else if ( s == "translation" )
    {
       type = tkTranslation ;
       if (lexDebug) std::cout << "[translation]" << std::endl ;
    }
    else if ( s == "rotation" )
    {
       type = tkRotation ;
       if (lexDebug) std::cout << "[rotation]" << std::endl ;
    }
    else if ( s == "def" )
    {
       type = tkDef ;
       if (lexDebug) std::cout << "[def]" << std::endl ;
    }
    else if ( s == "texture" )
    {
       type = tkTexture ;
       if (lexDebug) std::cout << "[texture]" << std::endl ;
    }
    else if ( s == "uv" )
    {
       type = tkUV ;
       if (lexDebug) std::cout << "[uv]" << std::endl ;
    }
    else
    {
       type = tkIdentifier ;
       lastString = s ;

       if (lexDebug) std::cout << "[ident,s=" << s << "]" << std::endl ;
    }
 }

 void Token::SkipInput()
 {
    if ( isp->eof() )
       return ;

    char ch = isp->get() ;

    while( isspace(ch) )
       ch = isp->get() ;

    if ( ch == '/' )
    {
       ch = isp->get() ;

       if ( ch == '/' )
       {
           isp->ignore(30000,'\n') ;
           SkipInput() ;
       }
       else
       {
           isp->putback(ch);
           isp->putback('/') ;
       }
    }
    else
       if ( ! isp->eof() )
          isp->putback(ch) ;
 }

 void Token::ReadLiteral()
 {
    std::string s = "" ;
    char ch ;

    ch = isp->get() ;  if ( lexDebug ) std::cout << ch ;

    while( ch != '"' )
    {
        if ( isp->eof() )
           throw ParserError("end of file found before literal termination","Token::ReadLiteral") ;
        else
        {
           s = s + ch ;
           ch = isp->get() ;
           if ( lexDebug ) std::cout << ch ;
        }
    }

    type = tkLiteral ;

    lastString = s ;

    if ( lexDebug ) std::cout << "[string,v='" << lastString << "']" 
			      << std::endl ;


 }

 void Token::ReadFrom
 (
    std::istream & is
 )
 {
    isp = & is ;
    char ch ;

    SkipInput() ;

    if ( isp->eof() )
    {
    	type = tkEndOfInput ;
    	if (lexDebug) std::cout << "[eof]" << std::endl ;
    	return ;
    }

    ch = isp->get() ; if (lexDebug) std::cout << ch ;

    if ( isdigit(ch) || ch == '-' )
    {
        ReadNumericToken(ch) ;
    }
    else if ( isalpha(ch) )
    {
        ReadAlphaToken(ch) ;
    }
    else if ( ch == ',' )
    {
        type = tkComma ;
        if (lexDebug) std::cout << "[comma]" << std::endl ;
    }
    else if ( ch == '(' )
    {
        type = tkOpenPar ;
        if (lexDebug) std::cout << "[openPar]" << std::endl ;
    }
    else if ( ch == ')' )
    {
        type = tkClosePar ;
        if (lexDebug) std::cout << "[closePar]" << std::endl ;
    }
    else if ( ch == '"' )
    {
        ReadLiteral() ;
    }
    else if ( ch == '=' )
    {
        type = tkEqual ;
        if (lexDebug) std::cout << "[equal]" << std::endl ;
    }
    else
    {
        std::string s = "character '" ;

        s += ch ;
        s += "' not recognized." ;

        throw ParserError(s,"Token::ReadFrom");
    }
 }

std::istream & operator >>
 (
    std::istream & is,
    Token & tk
 )
 {
    tk.ReadFrom(is) ;
    return is ;
 }


 Token::~Token
 ()
 {

 }


 double Token::ValueDouble
 ()
 {
    return lastDouble ;
 }

 long int Token::ValueInteger
 ()
 {
    return lastInteger ;
 }

 std::string Token::ValueString()
 {
    return lastString ;
 }



 TokenType Token::Type
 ()
 {
    return type ;
 }

} ; // namespace GRF
   

