/* 2002-06-17:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 

#include <Test1.H>
#include <iostream>
#include <GRFParser.H>
#include <ParserError.H>


#include <Face.H>
#include <GRFVertex.H>


int Test1
(
   int    argc ,
   char * argv[]
)
{
   using namespace GRF ;

   if ( argc < 2 )
   {
      std::cerr << "error: la sintaxis es: grf <fichero>....."
           << std::endl << std::flush ;
      return 1 ;
   }

   std::cout << "grf parser and viewer ver 1.0 (apr-2001)" << std::flush ;

   try
   {
      for( int i = 1 ; i < argc ; i++ )
      {
         Parser parser(argv[i]) ;

         //const Vertex * v ;

         std::cout << std::endl << "** dumping vertexs:" << std::flush ;

         for( unsigned j=0 ; j < parser.NVertexs() ; j++ )
         {
            double p[3] ;

            parser.GetVertex(j)->GetPosition(p) ;

            std::cout << std::endl << "v[" << j << "] = (" << p[0] << "," << p[1] << "," << p[2] << ")"
                 << std::flush ;
         }

         std::cout << std::endl << "** dumping faces:" << std::flush ;

         for( unsigned j=0 ; j < parser.NFaces() ; j++ )
         {
            const Face * f = parser.GetFace(j) ;

            std::cout << std::endl << "f[" << j << "] = {" ;

            for( unsigned k=0 ; k < f->NVertexs() ; k++ )
            {
               if ( k>0 ) std::cout << "," ;

               std::cout << f->GetVertexIndex(k) ;
            }
            std::cout << "}" << std::flush ;

         }
      }
   }
   catch( ParserError e )
   {
      std::cerr <<      e
           << std::endl << "          program interrupted."
           << std::endl
           << std::flush ;

      exit(1) ;
   }

   std::cout << std::endl << std::flush ;

   return 0 ;
}
