//***************************************************************
//***
//***   File:     ParserError.H
//***   Function: Declaration Error class for parser.
//***
//***   20-Abr-01      Carlos      Creation.
/* 2002-06-17:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 
//***   
//***************************************************************

#ifndef  GRF_PARSERERROR_H
#define  GRF_PARSERERROR_H

#include <stdlib.h>
#include <string>


namespace GRF
{

//**********************************

class ParserError
{
   const std::string msg ;
   const std::string where ;
   
   public:
   
   ParserError
   ( 
      const std::string & _msg  , 
      const std::string & _where
   )  ;

   friend std::ostream & operator << 
   (
      std::ostream & os,
      const ParserError & error
   ) ;

   const std::string & GetMessage() const { return msg ; }
   const std::string & GetWhere()   const { return where ; }

} ;  // class ParserError


} // namespace GRF
         
#endif // GRF_PARSERERROR_H
