//***************************************************************
//***
//***   File:     ParserError.C
//***   Function: Declarations of several utility types in VDE namespace
//***
//***   20-Abr-01      Carlos      Creation.
/* 2002-06-17:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 
//***   
//***************************************************************



#include <stdlib.h>
#include <string>
#include <iostream>
#include <ParserError.H>

namespace GRF
{

ParserError::ParserError
(
   const std::string & _msg  ,
   const std::string & _where
)
:  msg(_msg),
   where(_where)
{}
   
std::ostream & operator <<
(
   std::ostream & os,
   const ParserError & error
)
{
   return os
      << std::endl << "** error: " << error.msg
      << std::endl << "          (" << error.where << ")"
      << std::flush ;
}

} ;


         

