#ifndef GRF_MODELOGRF_H
#define GRF_MODELOGRF_H

#include <Modelo3D.H>
#include <GRFParser.H>
#include <GL/glut.h>




namespace GRF
{


class ModeloGRF : public Modelo3D
{
   Parser * parser ;


   Caja bBox ;

   void DrawNormals() ;
   void DrawLightSources() ;
   void DrawModelFaces() ;

   void DrawPoints() ;
   void DrawWireframe() ;
   void DrawSolidFlatShaded();
   void DrawSolidSmoothShaded();
   void DrawIradiance();

   void GetFaceNormal
   (
      const Face * f ,
      double n[3]
   ) ;

   const Vertex * GetVertex
   (
      const Face * f,
      int          iv
   )  ;

   bool maxColorComputed ;
   double maxColor ;

   double GetMaxColor() ;

   public:

   ModeloGRF( const char * fileName ) ;

   virtual Caja LeerCajaEnglobante() ;
   virtual void Dibujar() ;
   virtual void SetLights()  ;
   virtual void CallBackDesocupado() ;
   virtual void KeyPressEvent( unsigned char ch ) ;

   virtual void GetModelInfo( std::ostream & os ) const ;

   const Parser * GetParser() const { return parser ; }

   void SaveAs( const char * fileName ) ;
} ;

} ;

#endif  // ifndef  GRF_MODELOGRF_H
