#ifndef GRF_MODELO3D_H
#define GRF_MODELO3D_H

#include <iostream>


namespace GRF
{


struct Caja
{
   double  x0, y0, z0 ,
           x1, y1, z1 ;
} ;


typedef enum
{
  rsPoints,
  rsWireframe,
  rsSolidFlatShaded,
  rsIradiance,
  rsSolidSmoothShaded
}
  RenderStyleType ;

//************************************************

struct Params
{
   bool            drawBox ;
   double          anguloH ;
   double          anguloV ;
   double          desplZ ;
   double          focalDis ;

   RenderStyleType renderStyle ;
   RenderStyleType dragRenderStyle ;

   bool            reverseNormals ;
   bool            reverseFacesOrientation ;
   bool            drawNormals ;
   double          gamma ;

   double          shiftX ;
   double          shiftY ;

   double          viewScaleX ; // output parameter, not input:
   double          viewScaleY ; // factor for going from NDC to WC in viewport
}  ;



class Modelo3D
{
   protected:

   Params params ;

   public:

   Modelo3D() ;

   void Draw
   (
      unsigned nPixelsX,
      unsigned nPixelsY
   ) ;

   Params * GetParams() { return & params ; }

   virtual Caja LeerCajaEnglobante() = 0 ;
   virtual void Dibujar() = 0 ;
   virtual void SetLights() = 0  ;
   virtual void CallBackDesocupado() = 0 ;
   virtual void KeyPressEvent(unsigned char ch) = 0 ;

   virtual void GetModelInfo( std::ostream & os ) const = 0 ;

   protected:

   void DrawBox
   (
      double c[3] ,
      double d[3]
   )  ;


} ;

} // namespace GRF

#endif  // ifndef GRF_MODELO3D_H
