

#include <stream.h>
#include <GL/glut.h>
#include <Modelo3D.H>
#include <math.h>

#define DBG false


namespace GRF
{

inline double max( double a, double b ) { return (a<b) ? b : a ; }


void Modelo3D::Draw
(
   unsigned nPixelsX,
   unsigned nPixelsY
)
{
    if (DBG) cout << "entra 'Ventana3D::redibujar' ...." << endl << flush ;

    Caja caja = LeerCajaEnglobante() ;

    double cx = 0.5 * (caja.x0 + caja.x1 ) ,
           cy = 0.5 * (caja.y0 + caja.y1 ) ,
	   cz = 0.5 * (caja.z0 + caja.z1 ) ;


    double dx = caja.x1-caja.x0   ,
           dy = caja.y1-caja.y0   ,
	   dz = caja.z1-caja.z0   ;

    double nx = (double) nPixelsX ,
	   ny = (double) nPixelsY ;

    double diag = sqrt(dx*dx+dy*dy+dz*dz);

    const double focalDis = params.focalDis ;           // focal distance (distance to viewplane)
    const double farCP    = focalDis+diag ; // distance from observer to far clipping plane
    const double nearCP   = focalDis*0.1 ;  // distance from observer to near clipping plane

    double scale  ;
    double wx  ,
	   wy  ;


    if ( dy < dx )
    {
       scale = 1.0/dx ;  // box width in NDC is 1.0
    }
    else
    {
       scale = 1.0/dy ;  // box height in NDC is 1.0
    }

    if ( dy/dx < ny/nx )
    {
       // adjust box width to viewport width
       wx = dx*scale ;
       wy = wx*(ny/nx) ;
    }
    else
    {
       // adjust box height to viewport heigh
       wy = dy*scale ;
       wx = wy*(nx/ny) ;
    }


    {
       double f = 1.0-params.desplZ/focalDis ;

       f = fabs(f) ; // ?

       params.viewScaleX = wx*f ;
       params.viewScaleY = wy*f ;
    }

    // Establecer el volumen (piramidal) de vision
    // y el viewport


    glMatrixMode( GL_PROJECTION ) ;
    glLoadIdentity() ;

    glViewport( 0,0, nPixelsX, nPixelsY ) ;

    // 6. establecer la piramide de vista
    //
    //    Nota: el factor 'fac' no deforma la piramide,
    //    pero sirve para poner el plano de recorte frontal
    //    donde queremos

    const double fac = nearCP / focalDis ;

    glFrustum( -0.5*wx*fac, 0.5*wx*fac,
               -0.5*wy*fac, 0.5*wy*fac,
	       focalDis*fac, farCP ) ;  // focalDis*fac == nearCP

    // 5. apply translation in the viewplane

    glTranslated( params.shiftX, params.shiftY, 0.0 ) ;

    // 4. acercar el modelo al observador (solo si params.desplZ > 0)
    //

    glTranslated( 0.0, 0.0,  params.desplZ ) ;

    // 3. siturar la cara delantera en el plano de vision
    //

    glTranslated( 0.0, 0.0, -focalDis);

    // 2. escalar la caja de forma que bien el alto, bien el ancho,
    //    tengan longitud 1.0

    glScaled( scale, scale, scale ) ;

    // 1. poner el centro de la cara delantera de la caja en
    //    el origen de coordenadas

    glTranslated( -cx, -cy, -caja.z1 ) ;




    // *****************************************
    // limpiar capa auxiliar


    glClearColor( 0.0, 0.0, 0.0, 0.0 ) ;
    glClearDepth( farCP ) ;

    glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT ) ;
    glEnable(GL_DEPTH_TEST) ;


    // ************************************
    // dibujar el modelo en la capa auxiliar

    glMatrixMode( GL_MODELVIEW ) ;
    glLoadIdentity() ;

    SetLights() ;

    glPushMatrix() ;

       // hacer las rotaciones entorno al centro de la caja
       // segun las teclas pulsadas

       glTranslated( cx, cy, cz ) ;

       glRotated( params.anguloV, 1.0, 0.0,0.0 ) ;
       glRotated( params.anguloH, 0.0, 1.0, 0.0 ) ;

       //glScaled( params.scaleFactor, params.scaleFactor, params.scaleFactor );

       glTranslated( -cx, -cy, -cz ) ;

       if ( params.drawBox )
       {
          double c[3] = {cx,cy,cz} ;
          double d[3] = {dx/2.0,dy/2.0,dz/2.0} ;

          DrawBox( c,d ) ;
       }

       if (DBG) cout << "voy a dibujar" << endl ;

       Dibujar() ;

       if (DBG) cout  << "ya he dibujado" << endl ;

    glPopMatrix() ;


    if (DBG) cout << "yata!" << endl << flush;


    // ****************************************
    // intercambiar capa auxliar y capa visible
    // (muestra los contenidos de la capa auxiliar)

    //glutSwapBuffers() ;

}

#define BEG            glBegin( GL_POLYGON )
#define END            glEnd()
#define V(i)           glVertex3fv( pos[i] )
#define N2             glNormal3f( nx,ny,nz  )
#define F(i0,i1,i2,i3) { BEG ; N2 ; V(i3) ; N2 ; V(i2) ; N2 ; V(i1) ; N2 ; V(i0) ; END ; }
#define N(x,y,z)       { nx=x ; ny=y ; nz=z ; }

void DrawCube()
{
   GLfloat pos[8][4] =
          { { -0.5, -0.5, -0.5 },
            {  0.5, -0.5, -0.5 },
            { -0.5,  0.5, -0.5 },
            {  0.5,  0.5, -0.5 },
            { -0.5, -0.5,  0.5 },
            {  0.5, -0.5,  0.5 },
            { -0.5,  0.5,  0.5 },
            {  0.5,  0.5,  0.5 }
          } ;


   GLfloat nx,ny,nz ;

   N(0,0, 1) ; F(0,1,3,2) ;
   N(0,0,-1) ; F(4,6,7,5) ;

   N(-1,0,0) ; F(0,2,6,4) ;
   N( 1,0,0) ; F(1,5,7,3) ;

   N(0,-1,0) ; F(0,4,5,1) ;
   N(0, 1,0) ; F(2,3,7,6) ;
}


void Modelo3D::DrawBox
(
   double c[3] ,
   double d[3]
)
{

   glPushAttrib( GL_LIGHTING_BIT ) ;

   GLfloat redColor[] = { 1.0, 0.0, 0.0, 1.0 } ;
   GLfloat red8Color[] = { 0.8, 0.0, 0.0, 1.0 } ;
   GLfloat red2Color[] = { 0.2, 0.0, 0.0, 1.0 } ;

   GLfloat cyan5Color[] = { 0.0, 0.5, 0.5, 1.0 } ;
   GLfloat cyan2Color[] = { 0.0, 0.2, 0.2, 1.0 } ;

   GLfloat whiteColor[]  = { 1.0, 1.0, 1.0, 1.0 } ;
   GLfloat white5Color[] = { 0.5, 0.5, 0.5, 1.0 } ;
   GLfloat grayColor[]   = { 0.5, 0.5, 0.5, 1.0 } ;
   GLfloat gray2Color[]  = { 0.2, 0.2, 0.2, 1.0 } ;
   GLfloat blackColor[]  = { 0.0, 0.0, 0.0, 1.0 } ;



    glLightModeli( GL_LIGHT_MODEL_TWO_SIDE, 1 ) ;

    glEnable(GL_LIGHTING) ;
    glEnable(GL_LIGHT0) ;
    glDisable(GL_LIGHT1) ;
    glDisable(GL_LIGHT2);

    glShadeModel(GL_FLAT);
    glPolygonMode( GL_FRONT_AND_BACK, GL_FILL ) ;

    GLfloat pos0[] = {  1.0, 1.0, 1.0,  1.0 } ;



    glLightfv(GL_LIGHT0, GL_POSITION, pos0 ) ;
    glLightfv(GL_LIGHT0, GL_DIFFUSE,  whiteColor ) ;
    glLightfv(GL_LIGHT0, GL_SPECULAR, whiteColor ) ;
    glLightfv(GL_LIGHT0, GL_AMBIENT,  whiteColor ) ;

    glMaterialfv( GL_FRONT, GL_DIFFUSE, whiteColor ) ;
    glMaterialfv( GL_FRONT, GL_SPECULAR, blackColor ) ;
    glMaterialfv( GL_FRONT, GL_AMBIENT,  cyan2Color ) ;

    glMaterialfv( GL_BACK, GL_DIFFUSE, whiteColor ) ;
    glMaterialfv( GL_BACK, GL_SPECULAR, blackColor ) ;
    glMaterialfv( GL_BACK, GL_AMBIENT,  cyan2Color ) ;


   double m = max(max(d[0],d[1]),d[2]) ;

   double dd = m/70.0 ;

   glPushMatrix() ;

   glTranslated( c[0], c[1], c[2] ) ;

   for( int e = 0 ; e < 3 ; e++ )
   for( double a = -1.0 ; a <= 1.0 ; a+=2.0 )
   for( double b = -1.0 ; b <= 1.0 ; b+=2.0 )
   {
      int e1 = (e+1)%3 ,
          e2 = (e+2)%3 ;

      double ac[3], ad[3]  ;

      ac[e]  = 0.0 ;
      ac[e1] = a*d[e1] ;
      ac[e2] = b*d[e2] ;

      ad[e]  = 2.0*d[e]+dd ;
      ad[e1] = dd ;
      ad[e2] = dd ;

      glPushMatrix() ;

         glTranslated( ac[0], ac[1], ac[2] ) ;
         glScaled( ad[0], ad[1], ad[2] ) ;

         DrawCube() ;

      glPopMatrix() ;

   }

   glPopMatrix() ;

   glPopAttrib() ;

}


Modelo3D::Modelo3D()
{
   params.drawBox                  = false ;
   params.reverseNormals           = false ;
   params.reverseFacesOrientation  = false ;
   params.drawNormals              = false ;

   params.anguloH                  = 0.0 ;
   params.anguloV                  = 0.0 ;
   params.desplZ                   = 0.0 ;
   params.focalDis                 = 1.0 ;

   params.renderStyle              = rsSolidSmoothShaded ;
   params.dragRenderStyle          = rsPoints ;


   params.gamma                    = 1.0 ;

   params.shiftX                   = 0.0 ;
   params.shiftY                   = 0.0 ;

   params.viewScaleX                = 1.0 ;
   params.viewScaleY                = 1.0 ;
}

} // namespace VDE
