/* 2002-06-17:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 

#include <iostream>
#include <GRFViewer.H>
#include <FL/Fl.H>


#define COMPILATION_DATE_STRING "March,02 2002"

int main
(
   int    argc ,
   char * argv[]
)
{
   //using namespace GRF ;

   int           result  = 1     ;
   int           base    = 1     ;
   bool          verbose = false ;

   if ( argc < 2 )
   {
      std::cerr << "error: la sintaxis es: grf <fichero>....."
           << std::endl << std::flush ;
      return 1 ;
   }


   if ( strcmp( argv[base], "-d" ) == 0 )
   {
      verbose = true ;
      GRF::Token::lexDebug = true ;
      base ++ ;
   }

   std::cout << "grf parser and viewer ver 1.0 (compiled: " << COMPILATION_DATE_STRING << ")" << std::endl << std::flush ;

   try
   {
      GRF::Viewer * viewers[argc-base] ;

      for( int i= base ; i < argc ; i++ )
      {
         viewers[i-1] = new GRF::Viewer(argv[i],verbose) ;

         if ( viewers[i-1] == NULL )
              throw GRF::ParserError("'new' failed cannot create 'viewer[..]'","main function");
      }

      result = Fl::run() ;

   }
   catch( GRF::ParserError e )
   {
      std::cerr << e
           << std::endl
           << std::endl << "program interrupted."
           << std::endl
           << std::flush ;
   }

   return result ;
}
