
#include <iostream>
#include <GRFParser.H>
#include <ParserError.H>
#include <ModeloGRF.H>
#include <Ventana3D.H>

#define COMPILATION_DATE_STRING "13-dic-2001"



int main_desactivado
(
   int    argc ,
   char * argv[]
)
{
   using namespace GRF ;

   ModeloGRF ** model = NULL ;
   Ventana3D * window = NULL ;

   if ( argc < 2 )
   {
      cerr << "error: la sintaxis es: grf <fichero>....."
           << endl << flush ;
      return 1 ;
   }

   int base = 1 ;

   Token::lexDebug = false ;

   if ( strcmp( argv[base], "-d" ) == 0 )
   {
      Token::lexDebug = true ;
      base ++ ;
   }

   cout << "grf parser and viewer ver 1.0 (compiled: " << COMPILATION_DATE_STRING << ")" << flush ;

   try
   {
      model = new (ModeloGRF *) [argc-base] ;

      if ( model == NULL )
         throw ParserError("cannot create model array","main function");

      for( int i=base ; i < argc ; i++ )
      {
         model[i-1] = new ModeloGRF(argv[i]) ;

         if ( model[i-1] == NULL )
              throw ParserError("canot create 'ModeloGRF'","main function");

         window = new Ventana3D(model[i-1],argv[i],600,600) ;

         if ( window == NULL )
              throw ParserError("cannot create window","main function");
      }

      glutMainLoop() ;

   }
   catch( ParserError e )
   {
      cerr <<      e
           << endl << "          program interrupted."
           << endl
           << flush ;
   }

   if ( window != NULL )
      delete window ;

   if ( model != NULL )
      delete model ;

   cout << endl << flush ;

   return 0 ;
}
