//***************************************************************
//***
//***   File:     Light.C
//***   Function: Implementation of class 'Light'
//***
//***   15-May-01      Carlos      Creation.
//***   
//***************************************************************

#include <Light.H>

namespace GRF
{

//**********************************


  Light::Light()
  {
      for( int i=0 ; i < 3 ; i++ )
      {
         org[i] = 0.0 ;
         edge0[i] = 0.0 ;
         edge1[i] = 0.0 ;
      }

      edge0[0] = 1.0 ;
      edge1[2] = 1.0 ;
  }

  Light::Light
  (
     const double _org[3],
     const double _edge0[3],
     const double _edge1[3],
     const double _rgb[3]
  )
  {
      for( int i=0 ; i < 3 ; i++ )
      {
         org[i]   = _org[i]   ;
         edge0[i] = _edge0[i] ;
         edge1[i] = _edge1[i] ;
         rgb[i]   = _rgb[i] ;
      }

  }

  void Light::GetOrigin
  (
     double _origin[3]
  )
     const
  {
     for( int i=0 ; i< 3 ; i++ )
     {
        _origin[i] = org[i] ;
     }
  }

  void Light::GetEdge0
  (
     double _edge0[3]
  )
     const
  {
     for( int i=0 ; i< 3 ; i++ )
     {
        _edge0[i] = edge0[i] ;
     }
  }

  void Light::GetEdge1
  (
     double _edge1[3]
  )
     const
  {
     for( int i=0 ; i< 3 ; i++ )
     {
        _edge1[i] = edge1[i] ;
     }
  }


  void Light::GetRGB
  (
     double _rgb[3]
  )
     const
  {
     for( int i=0 ; i< 3 ; i++ )
     {
        _rgb[i] = rgb[i] ;
     }
  }


} // namespace GRF
         

