

#include <InfoWindow.H>

#include <Fl/Fl.H>

#include <strstream>



namespace GRF
{

void InfoWindow_CloseButtonCallback
(
    Fl_Widget * widget,
    void *      data
)
{
    //Fl_Button *  button = (Fl_Button *) widget ;
    InfoWindow * window = (InfoWindow *) data ;
    Viewer *     viewer = window->GetViewer() ;

    viewer->CloseInfoWindow() ;
}

//******************************************************

namespace IWDimensions
{
  const int
    wx          = 400 ,
    wy          = 300 ,
    marginx     = 10 ,
    marginy     = 10 ,
    buttonswy   = 25 ,
    buttonswx   = 80 ,
    buttonsysep = 10 ;

  const int
    textwx       = wx-2*marginx ,
    textwy       = wy-2*marginy-buttonswy-buttonsysep ,
    closebuttonx = wx-marginx-buttonswx  ,
    buttonsy     = wy-marginy-buttonswy ;

  const int
    defFont  = FL_HELVETICA_BOLD_ITALIC,
    defColor = fl_color_cube(0,0,2);
}  ;

//*******************************************************


InfoWindow::InfoWindow
(
    Viewer * _viewer
)
:   Fl_Window( IWDimensions::wx,IWDimensions::wy,"grf model info")
,   viewer(_viewer)
{

   using namespace IWDimensions ;

   this->begin() ;

      Fl_Button * closeButton = new Fl_Button(closebuttonx,buttonsy,buttonswx,buttonswy,"Close") ;

      if ( closeButton == NULL )
         throw ParserError("cannot create close button widget","InfoWindow::InfoWindow");

      Fl_Multiline_Output * text = new Fl_Multiline_Output(marginx,marginy,textwx,textwy,NULL);

      if ( text == NULL )
         throw ParserError("cannot create text output widget","InfoWindow::InfoWindow");

   this->end() ;


   text->textfont(FL_SCREEN);
   text->box( FL_SHADOW_BOX );

   closeButton->labelfont( defFont ) ;
   closeButton->labelcolor( defColor );
   closeButton->box( FL_ROUND_UP_BOX ) ;
   closeButton->user_data( (void *)this ) ;
   closeButton->callback( InfoWindow_CloseButtonCallback ) ;

   const int bufferCapacity = 8*1024 ;

   buffer = new char [bufferCapacity] ;

   if ( buffer == NULL )
      throw ParserError("cannot create buffer","InfoWindow::InfoWindow");

   std::ostrstream os(buffer,bufferCapacity);

   viewer->PrintInfo(os) ;

   text->insert( os.str() ) ;

   resizable(text);
   show() ;
}

//********************************************

InfoWindow::~InfoWindow()
{
    delete [] buffer ;
}

//*******************************************

int InfoWindow::handle
(
    int eventType
)
{
    if ( Fl::event_key(FL_Escape) )
    {
       GetViewer()->CloseInfoWindow() ;
       return 1 ;
    }

    return Fl_Window::handle(eventType) ;
}




//*******************************************

} // namespace GRF
