//*************************************************************
//**
//**  File :     ImageWriter.H
//**  Function : Declaration of class "ImageWriter"
/* 2002-06-17:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 
//**
//*************************************************************

#ifndef IMAGEWRITER_HPP
#define IMAGEWRITER_HPP

#include <string>
#include <stdio.h>
#include <ImageLoader.H>


namespace IL
{

typedef unsigned char byte ;

class ImageWriter
{

   public:

   ImageWriter
   (
       const std::string &  _fileName,
       unsigned        _sizeX,
       unsigned        _sizeY
   ) ;

   ~ImageWriter() ;


   void SetPixel
   (
       unsigned ix,
       unsigned iy,
       byte     rgb[3]
   ) ;

   void Write() ;

   void SwapRGB() ;

   private:

   std::string  fileName ;
   unsigned int sizeX ;
   unsigned int sizeY ;
   byte * data ;

   TargaFileHeader header ;

   unsigned long dataSize ;

   public:

   void * GetPixels() { return (void *)data ; }

} ;  // class ImageWriter

} ; // namespace IL


#endif // IMAGEWRITER_H

