//*************************************************************
//**
//**  File :     ImageLoader.H
//**  Function : Declaration of namespace "ImageLoader"
/* 2002-06-17:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 
//**
//*************************************************************

#ifndef IMAGELOADER_HPP
#define IMAGELOADER_HPP

#include <string>
#include <stdio.h>


namespace IL
{

typedef struct
{

      unsigned char IDLength;		// length of Identifier String
      unsigned char CoMapType;      	// 0 = no map
      unsigned char ImgType;   		// image type uncompressed true color
	// COLOR MAP SPECIFICATION
      unsigned char Index_lo;
      unsigned char Index_hi;		// index of first color map entry
      unsigned char Length_lo;
      unsigned char Length_hi;          // number of entries in color map
      unsigned char CoSize;             // size of color map entry (15,16,24,32)
        // IMAGE SPECIFICATIONS
      unsigned char X_org_lo;
      unsigned char X_org_hi;		// x origin of image
      unsigned char Y_org_lo;
      unsigned char Y_org_hi;		// y origin of image
      unsigned char Width_lo;
      unsigned char Width_hi;	        // width of image
      unsigned char Height_lo;
      unsigned char Height_hi;    	// height of image
      unsigned char PixelSize;		// pixel size (8,16,24,32)
      unsigned char Descriptor;		// image descriptor (usually 0 for non-interlaced)
}
      TargaFileHeader ;


//****************************************************

typedef unsigned char byte ;

//*********************************************************

class ImageLoader
{

   private:

   TargaFileHeader header;

   FILE* file ;            // file being readed, null if no file loaded or already closed
   std::string fileName ;  // name of file readed, being readed or to read
   bool imageLoaded ;      // true only if an image has been loaded, false otherwise
   byte * data ;           // image pixels, null if no file readed
   unsigned int xSize ;    // number of pixels columns in image
   unsigned int ySize ;    // number of pixels rows in image

   //***************************************************

   void LoadTargaHeader() ;

   void OpenFile() ;

   void LoadData() ;

   void Init() ;

   void ExecConvert
   (
      const std::string & srcFileName,
      const std::string & destFileName
   ) ;

   void CheckAndConvert() ;

   public:

   ImageLoader
   (
       const std::string & targetFileName
   ) ;

       // open and read a file

   ImageLoader () ;

       // create object, but do not read any file

   void LoadImage
   (
       const std::string & targetFileName
   ) ;

       // open and read a file
       // returns true if succ

   bool ImageLoaded() const ;

       // returns true if any file has been
       // succesfully loaded, false otherwise

   unsigned int XSize() const ;

       // return number of columns in image

   unsigned int YSize() const ;

       // return number of rows in image

   void GetPixel
   (
       unsigned int x,
       unsigned int y,
       unsigned char pixel[3]
   )
       const ;

   void Close() ;

       // closes an image

   ~ImageLoader() ;

} ;  // class ImageLoader

} ; // namespace IL


#endif // IMAGELOADER_H

