//*************************************************
//
//  file:     GRFViewer.H
//  function: header for class 'GRFViewer'
//
//**********************************************


#ifndef GRF_VIEWER_H
#define GRF_VIEWER_H

#include <string>
#include <ModeloGRF.H>
#include <ParserError.H>
#include <InfoWindow.H>
#include <GRFAboutWindow.H>
#include <GRFGirtOptsWindow.H>

#include <Fl/Fl.H>
#include <Fl/Fl_Window.H>
#include <Fl/Fl_Roller.H>
#include <Fl/Fl_Slider.H>
#include <Fl/Fl_Choice.H>
#include <Fl/Fl_Button.H>


namespace GRF
{

class GLDrawingArea ;
class InfoWindow ;
class AboutWindow ;

class Viewer
{
   public : // methods

   Viewer( const char * _fileName,
           bool         _verbose = true
         )  ;

   ~Viewer() ;

   void ReDraw() ;
   void LoadModel( const char* _fileName ) ;
   void PrintInfo( std::ostream & os )  ;
   void DisplayErrorWindow( const ParserError & err )  ;
   void DisplayInfoWindow() ;
   void DisplayAboutWindow() ;
   void CloseInfoWindow() ;
   void CloseAboutWindow() ;
   void SaveImage() ;
   void ResetWidgets() ;
   void OpenFile() ;
   void SaveAs() ;
   void LoadCamera() ;
   void SaveCamera() ;
   void Compare() ;
   void CompareWith( const Parser * parser2 ) ;

   void RunGirt() ;
   void EditGirtOpts() ;
   void LoadGirtOpts() ;
   void SaveGirtOpts() ;
   void CloseGirtOptsWindow() ;

   //****************************************

   private: // methods



   void DestroyWidgets() ;
   void CreateWidgets() ;


   //****************************************

   private: // data

   const char*      fileName ;
   bool             verbose  ;

   ModeloGRF*       model   ;

   Fl_Roller*       rollerV  ;
   Fl_Roller*       rollerH  ;
   Fl_Slider*       desplZSlider ;
   Fl_Slider*       focalDisSlider ;
   Fl_Slider*       gammaSlider ;

   GLDrawingArea*   glArea      ;
   Fl_Window*       mainWindow  ;

   InfoWindow*      infoWindow ;
   AboutWindow*     aboutWindow ;
   GirtOptsWindow*  girtOptsWindow ;  

   public:

   Params * GetParams()    { return model->GetParams() ; }
   ModeloGRF* GetModel()   { return model ; }
   Fl_Roller* GetRollerV() { return rollerV ; }
   Fl_Roller* GetRollerH() { return rollerH ; }
   Fl_Slider* GetGammaSlider() { return gammaSlider ; }

   int idx[200] ;

} ; // class GRFViewer



} ; // namespace GRF

#endif // GRF_VIEWER_H
