//***************************************************************
//***
//***   File:     Vertex.H
//***   Function: Declaration of class 'Vertex'
//***
//***   24-Abr-01      Carlos      Creation.
//***   
//***************************************************************

#ifndef  GRF_VERTEX_H
#define  GRF_VERTEX_H

namespace GRF
{

//**********************************

class Vertex
{

   double p[3] ;  // position
   double n[3] ;  // normal
   double t[2] ;       // texture coordinates
   double c[3] ;     // color (irradiance)

   #define NORMAL_MASK      ((unsigned char)0x01)
   #define TEXTCOORDS_MASK  ((unsigned char)0x02)
   #define IRADIANCE_MASK   ((unsigned char)0x04)

   unsigned char flags ;

   public:
   
   Vertex() ;

   void GetPosition
   (
       double rp[3]
   )
       const ;

   void SetPosition
   (
       double np[3]
   ) ;

   void GetNormal
   (
       double rn[3]
   )
       const ;

   void SetNormal
   (
       double nn[3]
   ) ;

   bool HasNormal
   ()  const ;

   void GetIradiance
   (
       double rc[3]
   )
       const ;

   void SetIradiance
   (
       double nc[3]
   ) ;

   bool HasIradiance
   ()
       const ;

   void GetTextCoords
   (
       double rt[2]
   )
       const ;

   void SetTextCoords
   (
       double nt[2]
   ) ;

   bool HasTextCoords
   ()
       const ;

} ;  // class Vertex


} // namespace GRF
         
#endif // GRF_VERTEX_H
