//***************************************************************
//***
//***   File:     Vertex.C
//***   Function: Implementation of class 'Vertex'
//***
//***   24-Abr-01      Carlos      Creation.
//***
//***************************************************************

#include <GRFVertex.H>

namespace GRF
{


 Vertex::Vertex()
 : flags(0)
 {
 }

 void Vertex::GetPosition
 (
    double rp[3]
 )
    const
 {
    rp[0] = p[0] ;
    rp[1] = p[1] ;
    rp[2] = p[2] ;
 }

 void Vertex::SetPosition
 (
    double np[3]
 )
 {
    p[0] = np[0] ;
    p[1] = np[1] ;
    p[2] = np[2] ;
 }

 void Vertex::GetNormal
 (
    double rn[3]
 )
    const
 {
    rn[0] = n[0] ;
    rn[1] = n[1] ;
    rn[2] = n[2] ;
 }

 void Vertex::SetNormal
 (
    double nn[3]
 )
 {
    n[0] = nn[0] ;
    n[1] = nn[1] ;
    n[2] = nn[2] ;

    flags |= NORMAL_MASK ;

 }

 bool Vertex::HasNormal
 ()
    const
 {
    return bool( flags & NORMAL_MASK ) ;
 }

 void Vertex::GetTextCoords
 (
    double rt[2]
 )
    const
 {
    rt[0] = t[0] ;
    rt[1] = t[1] ;


 }

 void Vertex::SetTextCoords
 (
    double nt[2]
 )
 {
    t[0] = nt[0] ;
    t[1] = nt[1] ;

    flags |= TEXTCOORDS_MASK ;
 }

 bool Vertex::HasTextCoords
 ()
    const
 {
    return bool( flags & TEXTCOORDS_MASK ) ;
 }

 void Vertex::GetIradiance
 (
    double rc[3]
 )
    const
 {
    rc[0] = c[0] ;
    rc[1] = c[1] ;
    rc[2] = c[2] ;
 }

 void Vertex::SetIradiance
 (
    double nc[3]
 )
 {
    c[0] = nc[0] ;
    c[1] = nc[1] ;
    c[2] = nc[2] ;

    flags |= IRADIANCE_MASK ;
 }

 bool Vertex::HasIradiance
 ()
    const
 {
    return bool( flags & IRADIANCE_MASK ) ;
 }
} // namespace GRF


