//***************************************************************
//***
//***   File:     GRFTexture.H
//***   Function: Declaration of class 'Texture'
//***
//***   2-Nov-01      Carlos      Creation.
//***   
/* 2002-06-17:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 
//***************************************************************

#ifndef  GRF_TEXTURE_H
#define  GRF_TEXTURE_H

#include <vector>

namespace GRF
{

//**********************************

class Texture
{
   public:

   Texture
   (
      const std::string & _fileName
   )  ;

   void GetRGB
   (
      double u,
      double v,
      double rgb[3]
   )
      const ;


   const std::string & GetFileName
   ()
      const ;

   void GL_ActivateTexture
   ()
      const ;

   void GL_SetTextureCoordinates
   (
      double u ,
      double v
   )
      const ;



   //**********************************

   private:

   std::string fileName ;

   double factorx, factory ;

   unsigned long
       nxTex, nyTex ,
       nxImg, nyImg ;

   unsigned char * pixels ;  // pixels expanded to 2^n x 2^m size

} ;  // class Texture


} ; // namespace GRF

#endif // GRF_TEXTURE_H
