

#include <GRFGirtOptsWindow.H>
#include <GRFViewer.H>

#include <Fl/Fl.H>
#include <Fl/Fl_Input.H>
#include <Fl/Fl_Int_Input.H>
#include <Fl/Fl_Float_Input.H>
#include <Fl/Fl_Output.H>

#include <strstream>



namespace GRF
{

void GirtOptsWindow_CloseButtonCallback
(
    Fl_Widget * widget,
    void *      data
)
{

    GirtOptsWindow * win = (GirtOptsWindow *) data ;

    win->CloseButtonCallback() ;
}

//******************************************************

namespace GirtOptsWindowAttributes
{
  const int

    leftMargin       =  15 ,
    rightMargin      =  15 ,
    topMargin        =  15 ,
    bottomMargin     =  10 ,

    fieldLabelWidthX = 110 ,
    fieldSpacingX    =  1  ,
    fieldInputWidthX = 100 ,

    fieldHeightY     =  22 ,
    fieldSpacingY    =   3 ,
    numFields        =   3 ,

    cbSizeX          =  80 ,
    cbSizeY          =  25 ,

    defFont          = FL_HELVETICA_BOLD_ITALIC ,
    defColor         = fl_color_cube(0,0,2) ,

    fieldWidthX      = fieldLabelWidthX + fieldSpacingX + fieldInputWidthX ,
    windowSizeX      = leftMargin + fieldWidthX + rightMargin ,
    windowSizeY      = topMargin + numFields*fieldHeightY + (numFields-1)*fieldSpacingY  + bottomMargin +
                       cbSizeY + bottomMargin ,

    cbOrgX           = windowSizeX - rightMargin  - cbSizeX ,
    cbOrgY           = windowSizeY - bottomMargin - cbSizeY ;

  const int
    inputType[numFields] = { FL_FLOAT_INPUT
                           , FL_INT_INPUT
                           , FL_INT_INPUT
                           };

  const char *
    fLabel[numFields] = { "Radius         "
                        , "Num. particles "
                        , "Num. passes    "
                        } ;

}


//*******************************************************


GirtOptsWindow::GirtOptsWindow
(
    Viewer * _viewer
)
:   Fl_Window( GirtOptsWindowAttributes::windowSizeX,
               GirtOptsWindowAttributes::windowSizeY,
               "Girt options")
,   viewer(_viewer)
{

   using namespace GirtOptsWindowAttributes ;

   Fl_Input * inputWidget[numFields] ;
   Fl_Output * labelWidget[numFields] ;

   this->begin() ;

      Fl_Button * closeButton = new Fl_Button(cbOrgX,cbOrgY,cbSizeX,cbSizeY,"Accept") ;

      if ( closeButton == NULL )
         throw ParserError("new failed: cannot create close button widget","GirtOptsWindow::GirtOptsWindow");

      for( int i = 0 ; i < numFields ; i++ )
      {
          const int  inputOrgX = leftMargin + fieldLabelWidthX + fieldSpacingX ,
                     orgY = topMargin + (i*(fieldHeightY+fieldSpacingY));


          labelWidget[i] = new Fl_Output(leftMargin,orgY,fieldLabelWidthX,fieldHeightY,NULL);
          inputWidget[i] = new Fl_Input(inputOrgX,orgY,fieldInputWidthX,fieldHeightY,NULL);

          if ( inputWidget[i] == NULL || labelWidget[i] == NULL )
             throw ParserError("new failed: cannot create input widgets","GirtOptsWindow::GirtOptsWindow");

          labelWidget[i]->value(fLabel[i]);
          labelWidget[i]->textfont( defFont ) ;
          labelWidget[i]->textcolor( defColor );
          labelWidget[i]->box( FL_FLAT_BOX ) ;
          labelWidget[i]->color( FL_GRAY ) ;

          inputWidget[i]->type(inputType[i]);
      }

   this->end() ;

   closeButton->labelfont( defFont ) ;
   closeButton->labelcolor( defColor );
   closeButton->box( FL_ROUND_UP_BOX ) ;
   closeButton->user_data( (void *)this ) ;
   closeButton->callback( GirtOptsWindow_CloseButtonCallback ) ;


   show() ;
}

//********************************************

GirtOptsWindow::~GirtOptsWindow()
{

}

//*******************************************

void GirtOptsWindow::CloseButtonCallback()
{
    viewer->CloseGirtOptsWindow() ;
}

//*******************************************

int GirtOptsWindow::handle
(
    int eventType
)
{
    if ( Fl::event_key(FL_Escape) )
    {
       viewer->CloseGirtOptsWindow() ;
       return 1 ;
    }

    return Fl_Window::handle(eventType) ;
}


} // namespace GRF
