/* 2002-09-24:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 

#ifndef GRF_DIFFMODEL_H
#define GRF_DIFFMODEL_H

#include <GL/glut.h>
#include <Modelo3D.H>
#include <GRFParser.H>



namespace GRF
{

class DiffModel

  : public Modelo3D

{
   const Parser * parser1 ;
   const Parser * parser2 ;

   double
     maxIradiance1[3] ,
     maxIradiance2[3] ,
     avgIradiance1[3] ,
     avgIradiance2[3] ,

     maxAbsDiff[3] ,
     avgAbsDiff[3] ,
     maxAbsDiff3   ,

     avgIradiance3 ;



   bool differencesComputed ;

   Caja bBox ;

   void DrawModelFaces() ;

   void GetFaceNormal
   (
       const Face * f ,
       double n[3]
   ) ;


   void ComputeDifferences() ;
   void ComputeBoundingBox() ;


   public:

   DiffModel
   (
       const Parser * parser1 ,
       const Parser * parser2
   ) ;

   virtual Caja LeerCajaEnglobante() ;
   virtual void Dibujar() ;
   virtual void SetLights()  ;
   virtual void CallBackDesocupado() ;
   virtual void KeyPressEvent( unsigned char ch ) ;

   void GetModelInfo( std::ostream & os ) const ;

   void WriteDifferences() ;
} ;

} ;



#endif  // ifndef GRF_DIFFMODEL_H
