#include <GRFDiffModel.H>
#include <ParserError.H>
#include <values.h>
#include <math.h>
#include <Chrono.H>

#include <GL/gl.h>


namespace GRF
{

DiffModel::DiffModel
(
  const Parser * _parser1 ,
  const Parser * _parser2
)
: parser1(_parser1)
, parser2(_parser2)
, differencesComputed( false )
{


  if ( parser1 == NULL || parser2 == NULL )
     throw ParserError("'parser1' and/or 'parser2' are NULL","DiffModel::DiffModel") ;


  if ( parser1->NVertexs() != parser2->NVertexs() )
     throw ParserError("different number of vertexs","DiffModel::DiffModel");

  if ( parser1->NFaces() != parser2->NFaces() )
     throw ParserError("different number of faces","DiffModel::DiffModel");

  if ( parser1->NLights() != parser2->NLights() )
     throw ParserError("different number of lights sources","DiffModel::DiffModel");


  std::cout << std::endl << "pair of grf models created."
       << std::endl << "n.vertexs (1) == " << parser1->NVertexs()
       << std::endl << "n.vertexs (2) == " << parser2->NVertexs()
       << std::endl << std::flush ;


  ComputeBoundingBox() ;
  ComputeDifferences() ;
  //WriteDifferences() ;
}

void DiffModel::ComputeBoundingBox()
{

  unsigned long iv ;

  bBox.x0 = bBox.y0 = bBox.z0 =  MAXDOUBLE ;
  bBox.x1 = bBox.y1 = bBox.z1 =  MINDOUBLE ;

  double p[3], p2[3] ;

  for( iv=0 ; iv < parser1->NVertexs() ; iv++ )
  {
     parser1->GetVertex(iv)->GetPosition(p) ;

     if ( p[0] < bBox.x0 ) bBox.x0 = p[0] ;
     if ( p[1] < bBox.y0 ) bBox.y0 = p[1] ;
     if ( p[2] < bBox.z0 ) bBox.z0 = p[2] ;

     if ( p[0] > bBox.x1 ) bBox.x1 = p[0] ;
     if ( p[1] > bBox.y1 ) bBox.y1 = p[1] ;
     if ( p[2] > bBox.z1 ) bBox.z1 = p[2] ;

     parser2->GetVertex(iv)->GetPosition(p2) ;

     for( int ic = 0 ; ic < 3 ; ic++ )
     {
        if ( p[ic] != p2[ic] )
           throw ParserError("found differences in vertexs position","DiffModel::DiffModel");
     }
  }

  std::cout << std::endl << "diff. model bounding box computed:"
       << std::endl << "  min = (" << bBox.x0 << "," << bBox.y0 << "," << bBox.z0 << ")"
       << std::endl << "  max = (" << bBox.x1 << "," << bBox.y1 << "," << bBox.z1 << ")"
       << std::flush ;
}



void DiffModel::KeyPressEvent
(
   unsigned char ch
)
{
   // aadir cosas aqui

   // activar si queremos redibujar:
   // glutPostRedisplay() ;
}

Caja DiffModel::LeerCajaEnglobante()
{
  return bBox ;
}

namespace LocalColorDefs
{
  bool lighting = true ;

  GLfloat redColor[] = { 1.0, 0.0, 0.0, 1.0 } ;
  GLfloat red8Color[] = { 0.8, 0.0, 0.0, 1.0 } ;
  GLfloat red2Color[] = { 0.2, 0.0, 0.0, 1.0 } ;

  GLfloat cyan5Color[] = { 0.0, 0.5, 0.5, 1.0 } ;
  GLfloat cyan2Color[] = { 0.0, 0.2, 0.2, 1.0 } ;

  GLfloat whiteColor[] = { 1.0, 1.0, 1.0, 1.0 } ;
  GLfloat grayColor[] = { 0.5, 0.5, 0.5, 0.5 } ;
  GLfloat gray2Color[] = { 0.2, 0.2, 0.2, 0.2 } ;

  GLfloat blackColor[] = { 0.0 ,0.0, 0.0 ,0.0 } ;
} ;

using namespace LocalColorDefs ;

void DiffModel::SetLights()
{

    glLightModeli( GL_LIGHT_MODEL_TWO_SIDE, 1 ) ;

    glEnable(GL_LIGHTING) ;
    glEnable(GL_LIGHT0) ;
    glEnable(GL_LIGHT1) ;


    GLfloat pos0[] = {  1.0,  1.0,  1.0 , 0.0 } ;
    GLfloat pos1[] = { -1.0, -1.0, -1.0,  0.0 } ;


    glLightfv(GL_LIGHT0, GL_POSITION, pos0 ) ;
    glLightfv(GL_LIGHT0, GL_DIFFUSE,  whiteColor ) ;
    glLightfv(GL_LIGHT0, GL_SPECULAR, blackColor ) ;
    glLightfv(GL_LIGHT0, GL_AMBIENT,  whiteColor ) ;

    glLightfv(GL_LIGHT1, GL_POSITION, pos1 ) ;
    glLightfv(GL_LIGHT1, GL_DIFFUSE,  whiteColor ) ;
    glLightfv(GL_LIGHT1, GL_SPECULAR, blackColor ) ;
    glLightfv(GL_LIGHT1, GL_AMBIENT,  blackColor ) ;



    //std::cout << "DiffModel::SetLights" << std::endl << std::flush ;
}




void DiffModel::DrawModelFaces()
{
    const Vertex * v1, * v2 ;
    const Face * f1, * f2 ;




    double p[3], n[3]  ;

    glDisable( GL_LIGHTING ) ;

    glPolygonMode( GL_FRONT_AND_BACK, GL_FILL ) ;
    glShadeModel( GL_SMOOTH ) ;



    /**
    glMaterialfv( GL_BACK, GL_SPECULAR, blackColor ) ;
    glMaterialfv( GL_BACK, GL_DIFFUSE,  cyan05 ) ;
    glMaterialfv( GL_BACK, GL_AMBIENT,  cyan02 ) ;

    glMaterialfv( GL_FRONT, GL_SPECULAR, blackColor ) ;
    glMaterialfv( GL_FRONT, GL_DIFFUSE,  whiteColor ) ;
    glMaterialfv( GL_FRONT, GL_AMBIENT,  blackColor ) ;
    **/


    for( unsigned long i = 0 ; i < parser1->NFaces() ; i++ )
    {
       f1 = parser1->GetFace(i) ;
       f2 = parser2->GetFace(i) ;


       glBegin(GL_POLYGON);


       for( unsigned long j=0 ; j < f1->NVertexs() ; j++ )
       {
          double vertexIradiance1[3]  ,
                 vertexIradiance2[3]  ;

          GLdouble vertexColor[3] ;

          v1 = parser1->GetVertex( f1->GetVertexIndex(j) ) ;
          v2 = parser2->GetVertex( f2->GetVertexIndex(j) ) ;

          v1->GetIradiance(vertexIradiance1) ;
          v2->GetIradiance(vertexIradiance2) ;

          double f[3] = {1.0,1.0,1.0} ;

          if ( maxAbsDiff3 > 0.0 )
          {
              for( int i=0 ; i< 3 ; i++ )
              {
                 f[i] = fabs(vertexIradiance1[i] - vertexIradiance2[i]) / maxAbsDiff3 ;
              }

              double err = ( f[0] > f[1] ) ? f[0] : f[1] ;

              if ( f[2] > err ) err = f[2] ;

              err *= 2.0 ;
              if ( err > 1.0 ) err = 1.0 ;


              f[0] = 1.0  ;
              f[1] = 1.0 - err ;
              f[2] = 1.0 - err ;

              //std::cout << std::endl << "err=" << err ;
          }

          for( int i=0 ; i < 3 ; i++ )
          {
              vertexColor[i] = GLdouble(f[i]) ; //GLdouble( 0.2 + 0.8*f[i] ) ;
          }

          //std::cout << std::endl << "color=(" << vertexColor[0] << "," << vertexColor[1] << "," << vertexColor[2] << ")" ;



          if ( v1->HasNormal() )
          {
              v1->GetNormal( n ) ;

              double ln = sqrt( n[0]*n[0] + n[1]*n[1] + n[2]*n[2] ) ;

              n[0] /= ln ;
              n[1] /= ln ;
              n[2] /= ln ;

              double v[3] = { 1,1,1 } ;

              double lv = sqrt( v[0]*v[0] + v[1]*v[1] + v[2]*v[2] ) ;

              v[0] /= lv ;
              v[1] /= lv ;
              v[2] /= lv ;

              double
                nv1 =   n[0]*v[0] + n[1]*v[1] + n[2]*v[2] ,
                nv2 = - n[0]*v[0] + n[1]*v[1] - n[2]*v[2] ;

              nv1 = ( nv1 > 0.3 ) ? nv1 : 0.3 ;
              nv2 = ( nv2 > 0.3 ) ? nv2 : 0.3 ;

              nv1 = sqrt(nv1) ;
              nv2 = sqrt(nv2) ;

              double nv = ( nv1 > nv2 ) ? nv1 : nv2 ;

              for( int i=0 ; i<3 ; i++ )
              {
                  vertexColor[i] *= GLdouble(nv) ;
              }
          }

          v1->GetPosition( p ) ;

          glColor3dv( vertexColor ) ;
          glVertex3dv( p ) ;

       }

       glEnd();

    }

}


void DiffModel::Dibujar()
{
    Chrono chrono ;

    //std::cout << std::endl << "drawing ....." << std::flush ;

    chrono.Run() ;

    DrawModelFaces() ;

    chrono.Stop() ;

    //std::cout << "end, this took " << chrono.GetSeconds() << " seconds." << std::flush  ;
}



inline double cuad( double x ) { return x*x ; }



void DiffModel::CallBackDesocupado()
{
   static long unsigned int c = 0 ;

   c++ ;

   if ( c == 1000000 )
   {
       //std::cout << std::endl << "hola!" << std::flush ;
       c= 0 ;
   }

}

void DiffModel::ComputeDifferences()
{
  double c1[3], c2[3] ;

  if ( differencesComputed )
     return ;


  unsigned long nv = parser1->NVertexs() ;

  double sumAbsDiff[3],
         sumIradiance1[3],
         sumIradiance2[3] ;

  for( int i=0 ; i < 3 ; i++ )
  {
     maxIradiance1[i] = 0.0 ;
     maxIradiance2[i] = 0.0 ;
     sumIradiance1[i] = 0.0 ;
     sumIradiance2[i] = 0.0 ;
     maxAbsDiff[i]    = 0.0 ;
     sumAbsDiff[i]    = 0.0 ;
  }

  for( unsigned long iv = 0 ; iv < nv ; iv++ )
  {
     const Vertex
        * v1 = parser1->GetVertex( iv ) ,
        * v2 = parser2->GetVertex( iv ) ;

     if ( v1->HasIradiance() != v2->HasIradiance() )
        throw ParserError("found vertex with irradiance in just one model","comparing irradiance information");

     if ( ! v1->HasIradiance() )
        continue ;  // assume both iradiances are 0

     v1->GetIradiance( c1 ) ;
     v2->GetIradiance( c2 ) ;

     for( int i=0 ; i<3 ; i++ )
     {
        if ( c1[i] > maxIradiance1[i] )
           maxIradiance1[i] = c1[i] ;

        if ( c2[i] > maxIradiance2[i] )
           maxIradiance2[i] = c2[i] ;

        double absDiff = fabs( c1[i] - c2[i] ) ;

        if ( absDiff > maxAbsDiff[i] )
           maxAbsDiff[i] = absDiff ;

        sumAbsDiff[i] += absDiff ;

        sumIradiance1[i] += c1[i] ;
        sumIradiance2[i] += c2[i] ;
     }

  }

  avgIradiance3 = 0.0 ;
  maxAbsDiff3 = 0.0 ;

  for( int i=0 ; i<3 ; i++ )
  {
     avgAbsDiff[i]    = sumAbsDiff[i] / double(nv) ;
     avgIradiance1[i] = sumIradiance1[i] / double(nv) ;
     avgIradiance2[i] = sumIradiance2[i] / double(nv) ;

     avgIradiance3 += 0.5*( avgIradiance1[i] + avgIradiance2[i] ) ;

     if ( maxAbsDiff[i] > maxAbsDiff3 )
        maxAbsDiff3 = maxAbsDiff[i] ;
  }

  avgIradiance3 /= 3.0 ;




  differencesComputed = true ;
  return ;
}

inline double max3( double a, double b, double c )
{
   double tmp = a>b ? a : b ;

   return tmp > c ? tmp : c ;
}

inline double avg3( double a, double b, double c )
{
   return (1.0/3.0) * (a+b+c) ;
}

inline double percen( double base100, double value )
{
   if ( base100 > 0.0 )
      return double(100.0) * ( value / base100 ) ;
   else
      return -1.0 ;
}

void DiffModel::WriteDifferences()
{
   double
      avgI1 = avg3( avgIradiance1[0], avgIradiance1[1], avgIradiance1[2] ) ,
      avgI2 = avg3( avgIradiance2[0], avgIradiance2[1], avgIradiance2[2] ) ;

   std::cout << std::endl << "max iradiance (1)           = " << max3( maxIradiance1[0], maxIradiance1[1], maxIradiance1[2] )
        << std::endl << "max iradiance (2)           = " << max3( maxIradiance2[0], maxIradiance2[1], maxIradiance2[2] )
        << std::endl << ""
        << std::endl << "average irradiance (1)      = " << avgI1
        << std::endl << "   red                      = " << avgIradiance1[0]
        << std::endl << "   green                    = " << avgIradiance1[1]
        << std::endl << "   blue                     = " << avgIradiance1[2]
        << std::endl << ""
        << std::endl << "average irradiance (2)      = " << avgI2
                                                    << " ( " << percen( avgI1, avgI2 ) << " % ) "
        << std::endl << "   red                      = " << avgIradiance2[0]
                                                    << " ( " << percen( avgIradiance1[0], avgIradiance2[0] ) << " % )"
        << std::endl << "   green                    = " << avgIradiance2[1]
                                                    << " ( " << percen( avgIradiance1[1], avgIradiance2[1] ) << " % )"
        << std::endl << "   blue                     = " << avgIradiance2[2]
                                                    << " ( " << percen( avgIradiance1[2], avgIradiance2[2] ) << " % )"
        << std::endl << ""
        << std::endl << "average absolute diferences = " << avg3( avgAbsDiff[0], avgAbsDiff[1], avgAbsDiff[2] )
        << std::endl << "   red                      = " << avgAbsDiff[0]
        << std::endl << "   green                    = " << avgAbsDiff[1]
        << std::endl << "   blue                     = " << avgAbsDiff[2]
        << std::endl << ""
        << std::endl << "maximun absolute diference  = " << maxAbsDiff3
        << std::endl << std::flush ;

}

void DiffModel::GetModelInfo( std::ostream & os ) const
{

}


} ; // namespace GRF


