

#include <GRFAboutWindow.H>
#include <GRFViewer.H>

#include <Fl/Fl.H>

#include <strstream>



namespace GRF
{

void AboutWindow_CloseButtonCallback
(
    Fl_Widget * widget,
    void *      data
)
{

    AboutWindow * aboutWindow = (AboutWindow *) data ;

    aboutWindow->CloseButtonCallback() ;
}

//******************************************************

const int
    wx = 400 ,
    wy = 123 ,
    marginx = 10 ,
    marginy = 10 ,
    leftWx = 100 ,
    buttonswy = 25 ,
    buttonswx = 80 ,
    buttonsysep = 10 ;

const int
  textwx = wx-2*marginx-leftWx ,
  textwy = wy-2*marginy-buttonswy-buttonsysep ,
  closebuttonx = wx-marginx-buttonswx  ,
  buttonsy = wy-marginy-buttonswy ;

const int defFont = FL_HELVETICA_BOLD_ITALIC ;
const int defColor = fl_color_cube(0,0,2);

//*******************************************************


AboutWindow::AboutWindow
(
    Viewer * _viewer
)
:   Fl_Window( wx,wy,"About")
,   viewer(_viewer)
{

   this->begin() ;

      Fl_Button * closeButton = new Fl_Button(closebuttonx,buttonsy,buttonswx,buttonswy,"Close") ;

      if ( closeButton == NULL )
         throw ParserError("cannot create close button widget","AboutWindow::AboutWindow");

      Fl_Multiline_Output * text = new Fl_Multiline_Output(marginx+leftWx,marginy,textwx,textwy,NULL);

      if ( text == NULL )
         throw ParserError("cannot create text output widget","AboutWindow::AboutWindow");

   this->end() ;


   //text->textfont(FL_SCREEN);

   text->box(FL_FLAT_BOX);
   text->color(FL_GRAY);

   text->insert("GRF Parser and Viewer\n");
   text->insert("Version January 2002\n");
   text->insert("Carlos Urea-Almagro (almagro@ugr.es)\n");
   text->insert("Univ. of Granada");

   closeButton->labelfont( defFont ) ;
   closeButton->labelcolor( defColor );
   closeButton->box( FL_ROUND_UP_BOX ) ;
   closeButton->user_data( (void *)this ) ;
   closeButton->callback( AboutWindow_CloseButtonCallback ) ;



   resizable(text);
   show() ;
}

//********************************************

AboutWindow::~AboutWindow()
{

}

//*******************************************

void AboutWindow::CloseButtonCallback()
{
    viewer->CloseAboutWindow() ;
}

//*******************************************

int AboutWindow::handle
(
    int eventType
)
{
    if ( Fl::event_key(FL_Escape) )
    {
       viewer->CloseAboutWindow() ;
       return 1 ;
    }

    return Fl_Window::handle(eventType) ;
}


} // namespace GRF
