//***************************************************************
//***
//***   File:     Face.H
//***   Function: Declaration of class 'Face'
//***
//***   24-Abr-01      Carlos      Creation.
//***   
/* 2002-06-17:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 
//***************************************************************

#ifndef  GRF_FACE_H
#define  GRF_FACE_H

#include <vector>

namespace GRF
{

//**********************************

class Face
{
  private:

  std::vector<unsigned long> v ;
  unsigned long nVertexs ;

  long textureNumber ;

  double rgbColor[3] ;

  public:

  Face
  (
     const std::vector<unsigned long> & _v ,
     long                          _textureNumber ,
     double                        _rgbColor[3]
  )  ;

  unsigned long GetVertexIndex
  (
     unsigned iv
  )
     const ;


  void GetColor
  (
     double rgbCol[3]
  )
     const ;

  unsigned long NVertexs
  ()
     const ;

  long GetTextureNumber
  ()
     const ;
 

} ;  // class Face


} // namespace GRF

#endif // GRF_FACE_H
