//***************************************************************
//***
//***   File:     Face.C
//***   Function: Implementation of class 'Face'
//***
//***   24-Abr-01      Carlos      Creation.
/* 2002-06-17:
 * Replaced all references to variables defined in namespace std, which
 * were used with no prefix, with std::<reference>
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 

//***   
//***************************************************************

#include <Face.H>

namespace GRF
{

//**********************************


  Face::Face
  (
     const std::vector<unsigned long> & _v ,
     long                          _textureNumber ,
     double                        _rgbColor[3]
  )
  {
     nVertexs = _v.size() ;

     for( unsigned i= 0 ; i < nVertexs ; i++ )
     {
        v.push_back( _v[i] ) ;
     }

     if ( _rgbColor != NULL )
     {
        for( unsigned i= 0 ; i < 3 ; i++ )
        {
           rgbColor[i] = _rgbColor[i] ;
        }
     }
     else
     {
        rgbColor[0] = 1.0 ;
        rgbColor[1] = 0.0 ;
        rgbColor[2] = 0.0 ;
     }

     textureNumber = _textureNumber ;


  }

  unsigned long Face::GetVertexIndex
  (
     unsigned iv
  )
     const
  {
     return v[iv] ;
  }

  unsigned long Face::NVertexs
  (
  )
     const
  {
     return nVertexs ;
  }

  void Face::GetColor
  (
     double _rgbColor[3]
  )
     const
  {
     for( int i=0 ; i< 3 ; i++ )
     {
        _rgbColor[i] = rgbColor[i] ;
     }
  }

  long Face::GetTextureNumber
  ()
     const
  {
     return textureNumber ;
  }



} // namespace GRF
         

