// file: Chrono.H
// Code written by Carlos Urea-Almagro (almagro@ugr.es) - Jun 2001. 
// latest version, more info: http://lsi.ugr.es/~curena/soft/chrono
/* 2002-06-12:
 * Replaced all occurrences of ostream with std::ostream 
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 
#ifndef CHRONO_H
#define CHRONO_H

#include <sys/times.h>
#include <iostream>

typedef enum  { stopped, running } ChronoStatusType ;

class Chrono
{

 public:

   Chrono() ;

   void Reset() ;  // stop (only if running) and then set to cero
   void Run() ;    // start running (if stopped, else this does nothing)
   void Stop() ;   // stop (if running, else this does nothing).

   double GetSeconds() const ;
                   // returns total (user+sys) seconds, if stopped, (-1) if running


   friend std::ostream & operator << ( std::ostream & os, const Chrono & chrono ) ;
                   // prints complete process time info on 'os'

 protected:

   ChronoStatusType state ;

 private:

   struct tms accumTime ;
     // accumulated time for all previous
     // runs before current one, if any.
     // this is set to cero by 'reset'
     // (and also at constructor).

   struct tms currentRunStartTime ;
     // process time when 'run' was
     // called for the last time
     // 'currentTime - lastRunTime' is added to 'prevTime'
     // when 'stop' is called

} ;

#endif
