// file: Chrono.C
// Code written by Carlos Urea-Almagro (almagro@ugr.es) - Jun 2001. 
// latest version, more info: http://lsi.ugr.es/~curena/soft/chrono
/* 2002-06-12:
 * Replaced all occurrences of cout, endl, flush with std::cout, std::endl,
 * std::flush
 * in order to compile with gcc 3.1.1, which no longer has 
 * "using namespace standard"
 * Rubn J. Garca Hernndez
 */ 
#include <Chrono.H>
#include <time.h>
#include <math.h>


Chrono::Chrono()
{
   Reset() ;
}

void Chrono::Reset()
{
   state = stopped ;

   accumTime.tms_utime = (clock_t) 0 ;
   accumTime.tms_stime = (clock_t) 0 ;
}

void Chrono::Run()
{
   if ( state == stopped )
   {
      times(&currentRunStartTime) ;
      state = running ;
   }
}

void Chrono::Stop()
{
  struct tms currentTime ;

  times(&currentTime);

  if ( state == stopped )
     return ;

  state = stopped ;

  if ( currentTime.tms_utime == ((clock_t)-1) ||
       currentTime.tms_stime == ((clock_t)-1) )
  {
     std::cout << "oh! oh! - he encontrado un '((clock_t)-1)'" << std::endl << std::flush ;
     exit(1) ;
  }

  long long udiff, sdiff ;

  udiff = (long long)currentTime.tms_utime - (long long)currentRunStartTime.tms_utime ;
  sdiff = (long long)currentTime.tms_stime - (long long)currentRunStartTime.tms_stime ;

  if ( (udiff < (long long)0) || (sdiff < (long long)0) )
  {
     std::cout << "oh! oh!" << std::endl << std::flush ;
     exit(1) ;
  }

  struct tms diff ;

  diff.tms_utime = (clock_t) udiff ;
  diff.tms_stime = (clock_t) sdiff ;

  accumTime.tms_utime += diff.tms_utime ;
  accumTime.tms_stime += diff.tms_stime ;

}

const double tups = (double)100.0 ;
    // number of time units per second
    //  (units returned by 'times' function)
    //  see file: '/usr/include/sys/time.h'


double Chrono::GetSeconds() const
{
    long long total = accumTime.tms_utime + accumTime.tms_stime ;

    return (double)total / tups ;
}


std::ostream & operator << ( std::ostream & os, const Chrono & chrono )
{

  double secondsTotalDec = chrono.GetSeconds() ;


  double secondsTotal = floor( secondsTotalDec ) ;
  double minutesTotal = floor( secondsTotal / (double)60.0 ) ;
  double hoursTotal   = floor( minutesTotal / (double)60.0 ) ;

  double seconds = secondsTotal - ( (double)60.0 * minutesTotal ) ;
  double minutes = minutesTotal - ( (double)60.0 * hoursTotal ) ;


  os << hoursTotal << "h "
     << minutes << "m "
     << seconds << "s ( total "
     << secondsTotalDec << "s = "
     << ((double)chrono.accumTime.tms_utime/tups) << "u + "
     << ((double)chrono.accumTime.tms_stime/tups) << "s )" ;


  if ( chrono.state == running )
     os << " (running!)" ;

  return os ;

}




