%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Mamern class for LaTeX files                  %%
%%                                                                %%
%% The regular article class commands still exist and may be used.%%
%% 10pt, 11pt and twocolumn options are disabled.                 %%
%%                                                                %%
%% \maketitle make the first page automatically                   %%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{Mamern07}[2007/07/11-13 Mamern07 abstract class]

\DeclareOption{10pt}{\OptionNotUsed}
\DeclareOption{11pt}{\OptionNotUsed}
\DeclareOption{twocolumn}{\OptionNotUsed}
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{article}}

\DeclareOption{dvips}{%
  \PassOptionsToPackage{dvips}{hyperref}}
\DeclareOption{pdftex}{%
  \PassOptionsToPackage{pdftex}{hyperref}}
\DeclareOption{dvipdfm}{%
  \PassOptionsToPackage{dvipdfm}{hyperref}}
\DeclareOption{dvips}{%
  \PassOptionsToPackage{dvips}{graphicx}}
\DeclareOption{pdftex}{%
  \PassOptionsToPackage{pdftex}{graphicx}}
\DeclareOption{dvipdfm}{%
  \PassOptionsToPackage{dvipdfm}{graphicx}}

\newenvironment{thm}[1]{\vspace{0.3cm}\textbf{#1}}

\ProcessOptions\relax

\LoadClass[a4paper,12pt,twoside]{article}

\RequirePackage{hyperref}
\RequirePackage{calc}
\RequirePackage{indentfirst}
\RequirePackage{url}
\RequirePackage{graphicx}
\RequirePackage{times}
\RequirePackage{amssymb}

%% Title
\renewcommand{\maketitle}{%
 \newpage
 \thispagestyle{plain}
 %\begin{minipage}[t][30mm][t]{155mm}
 \begin{minipage}[t][26mm][t]{155mm}
  \begin{flushleft}
   \scriptsize International Conference  on Approximation\\
   Methods and Numerical Modelling in\\
   Environment and Natural Resources\\
   Granada (Spain), July 11-13, 2007
  \end{flushleft}
 \end{minipage}
 \begin{center}%
  {%3
   \fontsize{14}{16}\selectfont
   \bfseries
   \Large{\@title}
   \par
  }%3
  \vspace{18pt}%
  {%4
\fontsize{12}{14}\selectfont
   \bfseries\@author
   \par
  }%4
  \vspace{14pt}%
  {%5
\fontsize{11}{12}\selectfont
   \def\and{\\\vspace{14pt}}
   \normalfont\@address
   \par
  }%5
 \end{center}
 \vspace{18pt}%
 \noindent\textbf{Keywords:\space}\@keywords
 \par
 \vspace{18pt}%
 \noindent\textbf{Abstract.\space}{\textit\@abstract}
 \par
 \vspace{1cm}
 
}% End of \@maketitle

\def\author{\@ifnextchar[{\@getshortauthor}{\@getauthor}}
\def\@getauthor#1{\gdef\@author{#1}\gdef\@shortauthor{#1}}
\def\@getshortauthor[#1]#2{\gdef\@shortauthor{#1}\gdef\@author{#2}}

\newcommand{\address}[1]{\gdef\@address{#1}}

\newcommand{\keywords}[1]{\gdef\@keywords{#1}}

\renewcommand{\abstract}[1]{\gdef\@abstract{#1}}

\newcommand{\heading}[1]{\gdef\@heading{#1}}
\newcommand{\oddheading}[1]{\gdef\@oddheading{#1}}
\newcommand{\evenheading}[1]{\gdef\@evenheading{#1}}


\def\ps@myheadings{
\renewcommand{\@oddhead}{\parbox[t][11.5pt][t]{\textwidth}{\centering
        \normalfont
        \fontsize{10}{10}\selectfont\@title\\\vspace{-.2cm}
       \rule{\textwidth}{1pt}}}
\renewcommand{\@oddfoot}{\hfil \textrm{\thepage}\hfil}
\renewcommand{\@evenhead}{\parbox[t][11.5pt][t]{\textwidth}{\centering
        \normalfont
        \fontsize{10}{10}\selectfont\@evenheading\\\vspace{-.2cm}
       \rule{\textwidth}{1pt}}}
\renewcommand{\@evenfoot}{\hfil \textrm{\thepage}\hfil}}


\def\sectionLevel{1}
\def\sectionIndent{0pt}
\def\sectionSpaceBefore{12pt}
\def\sectionSpaceAfter{6pt}
\def\sectionStyle{\large\bfseries}



\renewcommand{\section}{%
  \@startsection{section}{\sectionLevel}{\sectionIndent}{\sectionSpaceBefore}%
                {\sectionSpaceAfter}{\sectionStyle}}%



\def\sectionLevel{2}
\def\subsectionIndent{15pt}
\def\sectionSpaceBefore{12pt}
\def\sectionSpaceAfter{6pt}
\def\subsectionStyle{\normalsize\bfseries}

\renewcommand{\subsection}{%
  \@startsection{subsection}{\sectionLevel}{\subsectionIndent}{\sectionSpaceBefore}%
                {\sectionSpaceAfter}{\subsectionStyle}}%

\renewcommand{\@makecaption}[2]{%
  \vskip\abovecaptionskip
  \sbox\@tempboxa{\normalsize\fontsize{10}{12}\selectfont #1: #2}%
  \ifdim \wd\@tempboxa >\hsize
    \normalsize\fontsize{10}{12}\selectfont #1: #2\par
  \else
    \global \@minipagefalse
    \hb@xt@\hsize{\hfil\box\@tempboxa\hfil}%
  \fi
  \vskip\belowcaptionskip}

\renewenvironment{thebibliography}[1]
  {\bigskip
  \section*{\MakeUppercase\refname\@mkboth{\MakeUppercase\refname}{\MakeUppercase\refname}}%
  \list{\@biblabel{\@arabic\c@enumiv}}%
        {\settowidth\labelwidth{\@biblabel{#1}}%
         \leftmargin\labelwidth
         \advance\leftmargin\labelsep
         \@openbib@code
         \usecounter{enumiv}%
         \let\p@enumiv\@empty
         \renewcommand\theenumiv{\@arabic\c@enumiv}}%
   \sloppy
   \clubpenalty4000
   \@clubpenalty \clubpenalty
   \widowpenalty4000%
   \sfcode`\.\@m}
  {\def\@noitemerr
   {\@latex@warning{The `thebibliography' environment is empty}}%
   \endlist}
\setlength{\oddsidemargin}{0mm}
\setlength{\evensidemargin}{0mm}
\setlength{\topmargin}{-10mm}
%\setlength{\textheight}{210mm}
\setlength{\textheight}{240mm}
\setlength{\textwidth}{160mm}
\setlength{\textfloatsep}{12pt}
\setlength{\abovedisplayskip}{6pt}
\setlength{\belowdisplayskip}{6pt}
\setlength{\parindent}{5mm}
\setlength{\abovecaptionskip}{6pt}
\setlength{\belowcaptionskip}{6pt}
\setlength{\itemsep}{0pt}

\AtBeginDocument{%
  \pagestyle{myheadings}
  \maketitle
  \let\maketitle\relax
}

\endinput
