(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    231014,       4629]
NotebookOptionsPosition[    227152,       4504]
NotebookOutlinePosition[    227544,       4521]
CellTagsIndexPosition[    227501,       4518]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Superficies", "Title",
 CellChangeTimes->{{3.6871526196906967`*^9, 3.687152622194121*^9}}],

Cell[CellGroupData[{

Cell["\<\
Representaci\[OAcute]n de distintos tipos de superficies\
\>", "Section",
 CellChangeTimes->{{3.687152675619287*^9, 3.687152688676157*^9}}],

Cell[CellGroupData[{

Cell["Grafos", "Subsection",
 CellChangeTimes->{{3.687154067293725*^9, 3.6871540686875668`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], "*", 
   RowBox[{
    RowBox[{"z", "^", "2"}], "/", "7"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"f", "[", 
      RowBox[{"u", ",", "v"}], "]"}], ",", "v"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "X", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "30"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6871541321433687`*^9, 3.68715428016076*^9}, {
  3.687154311555813*^9, 3.68715431944943*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Superficies Tubulares", "Subsection",
 CellChangeTimes->{{3.687152702096903*^9, 3.687152706004499*^9}}],

Cell["\<\
Recordamos que, dada \[Alpha] (t) curva regular y  r < m\[IAcute]n (R (t)), \
se puede definir la superficie que envuelve de forma tubular a \[Alpha] como \
aquella que tiene por parametrizaci\[OAcute]n :
   X (u, v) = \[Alpha] (u) + r cos (v) N (u) + r sen (v) T (u).
   
Primero creamos los elementos que necesitamos de la curva \[Alpha]\
\>", "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
  3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
  3.687153619815096*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"norma", "[", "z_", "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{"z", ".", "z"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"alpha", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"3", "*", 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{"3", "*", 
      RowBox[{"Sin", "[", "u", "]"}]}], ",", "u"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"T1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"alpha", ",", "u"}], "]"}], "/", 
     RowBox[{"norma", "[", 
      RowBox[{"D", "[", 
       RowBox[{"alpha", ",", "u"}], "]"}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B1", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Cross", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"alpha", ",", "u"}], "]"}], ",", 
       RowBox[{"D", "[", 
        RowBox[{"alpha", ",", 
         RowBox[{"{", 
          RowBox[{"u", ",", "2"}], "}"}]}], "]"}]}], "]"}], "/", 
     RowBox[{"norma", "[", 
      RowBox[{"Cross", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"alpha", ",", "u"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"alpha", ",", 
          RowBox[{"{", 
           RowBox[{"u", ",", "2"}], "}"}]}], "]"}]}], "]"}], "]"}]}], "//", 
    "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"N1", "=", 
   RowBox[{"Cross", "[", 
    RowBox[{"B1", ",", "T1"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.687152745341494*^9, 3.687152849622143*^9}, {
  3.68715307453388*^9, 3.6871533129046926`*^9}, {3.687153347146969*^9, 
  3.68715334789959*^9}, {3.6871538225957623`*^9, 3.68715383716253*^9}, {
  3.687249020897237*^9, 3.6872490561595*^9}}],

Cell["\<\
Veamos (dibuj\[AAcute]ndolo) la evoluci\[OAcute]n del radio de curvatura.\
\>", "Text",
 CellChangeTimes->{{3.6871535505196877`*^9, 3.687153581703155*^9}, 
   3.687153957963027*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"curvat", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"norma", "[", 
      RowBox[{"Cross", "[", 
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{"alpha", ",", "u"}], "]"}], ",", 
        RowBox[{"D", "[", 
         RowBox[{"alpha", ",", 
          RowBox[{"{", 
           RowBox[{"u", ",", "2"}], "}"}]}], "]"}]}], "]"}], "]"}], "/", 
     RowBox[{"norma", "[", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"alpha", ",", "u"}], "]"}], "^", "3"}], "]"}]}], "//", 
    "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", 
    RowBox[{"1", "/", "curvat"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.687153415147293*^9, 3.687153542712597*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", ".5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"alpha", "+", 
    RowBox[{"r", "*", 
     RowBox[{"Cos", "[", "v", "]"}], "*", "N1"}], "+", 
    RowBox[{"r", "*", 
     RowBox[{"Sin", "[", "v", "]"}], "*", "B1"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "X", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"3", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"ViewPoint", "->", 
    RowBox[{"{", 
     RowBox[{"4.5", ",", " ", 
      RowBox[{"-", "7.5"}], ",", " ", "1.5"}], "}"}]}], ",", 
   RowBox[{"PlotPoints", "\[Rule]", "30"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6871533274701*^9, 3.6871533526152143`*^9}, {
  3.687153638747849*^9, 3.687153740941605*^9}, {3.6871538047443533`*^9, 
  3.687153816401846*^9}, {3.687153847458601*^9, 3.687153911971528*^9}, {
  3.687153981518818*^9, 3.687154040991942*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Superficies de traslaci\[OAcute]n", "Subsection",
 CellChangeTimes->{{3.687152702096903*^9, 3.687152706004499*^9}, {
  3.687154355298809*^9, 3.687154360448944*^9}}],

Cell["\<\
Partimos de dos curvas, \[Alpha] y \[Beta] y buscamos sus puntos de corte.\
\>", "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.687154448453834*^9, 3.687154466660152*^9}, 
   3.687154502111658*^9}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{"a", "=", "2"}], ";", 
  RowBox[{"b", "=", "3"}], ";"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"alpha", "[", "u_", "]"}], ":=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{
      RowBox[{"u", "^", "2"}], "/", "a"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"beta", "[", "v_", "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{"0", ",", 
    RowBox[{"v", "-", "1"}], ",", " ", 
    RowBox[{
     RowBox[{"-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"v", "-", "1"}], ")"}], "^", "2"}]}], "/", "b"}]}], 
   "}"}]}], "\n", 
 RowBox[{"ss", "=", 
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"alpha", "[", "u", "]"}], "\[Equal]", 
     RowBox[{"beta", "[", "v", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "v"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.687152745341494*^9, 3.687152849622143*^9}, {
  3.68715307453388*^9, 3.6871533129046926`*^9}, {3.687153347146969*^9, 
  3.68715334789959*^9}, {3.6871538225957623`*^9, 3.68715383716253*^9}, {
  3.687154380987227*^9, 3.687154432693677*^9}, {3.687154470647028*^9, 
  3.687154479071671*^9}, {3.6871545424367456`*^9, 3.6871545504026747`*^9}}],

Cell["\<\
El punto de corte es P=\[Alpha](0)=\[Beta](1)=(0,0,0).
La parametrizaci\[OAcute]n es:
X(u,v) = \[Alpha](u)+\[Beta](v)-P\
\>", "Text",
 CellChangeTimes->{{3.6871535505196877`*^9, 3.687153581703155*^9}, 
   3.687153957963027*^9, {3.687154522672947*^9, 3.687154536887228*^9}, {
   3.6871545784343653`*^9, 3.6871546426504793`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{
    RowBox[{"alpha", "[", "u", "]"}], "/.", 
    RowBox[{"ss", "[", 
     RowBox[{"[", "1", "]"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"X", "=", 
  RowBox[{
   RowBox[{"alpha", "[", "u", "]"}], "+", 
   RowBox[{"beta", "[", "v", "]"}], "-", "P"}]}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"alpha", "[", "u", "]"}], ",", 
     RowBox[{"beta", "[", "v", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "X", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "1"}], ",", "3"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6871533274701*^9, 3.6871533526152143`*^9}, {
  3.687153638747849*^9, 3.687153740941605*^9}, {3.6871538047443533`*^9, 
  3.687153816401846*^9}, {3.687153847458601*^9, 3.687153911971528*^9}, {
  3.687153981518818*^9, 3.687154040991942*^9}, {3.687154671270812*^9, 
  3.6871548756531677`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Superficies de revoluci\[OAcute]n", "Subsection",
 CellChangeTimes->{{3.687152702096903*^9, 3.687152706004499*^9}, {
  3.687154895197155*^9, 3.6871548986272173`*^9}}],

Cell["\<\
Partimos de una funci\[OAcute]n y = f(z) >0 y la giramos en torno al eje OZ\
\>", "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
  3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
  3.687153619815096*^9}, {3.687154988246519*^9, 3.687154991574291*^9}, {
  3.687155161316621*^9, 3.6871551927900953`*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", "z_", "]"}], ":=", 
   RowBox[{"2", "+", 
    RowBox[{
     RowBox[{"Cos", "[", "z", "]"}], "*", 
     RowBox[{"Sin", "[", 
      RowBox[{"2", "z"}], "]"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"Cos", "[", "u", "]"}], "*", 
      RowBox[{"f", "[", "v", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", "u", "]"}], "*", 
      RowBox[{"f", "[", "v", "]"}]}], ",", "v"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "X", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "8"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.687152745341494*^9, 3.687152849622143*^9}, {
   3.68715307453388*^9, 3.6871533129046926`*^9}, {3.687153347146969*^9, 
   3.68715334789959*^9}, {3.6871538225957623`*^9, 3.68715383716253*^9}, {
   3.6871549983236847`*^9, 3.687155066196164*^9}, {3.687155100014189*^9, 
   3.687155136934029*^9}, {3.68715519872091*^9, 3.687155287028051*^9}, 
   3.68724919490219*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Superficies regladas ", "Subsection",
 CellChangeTimes->{{3.687152702096903*^9, 3.687152706004499*^9}, {
   3.687154895197155*^9, 3.6871548986272173`*^9}, {3.687156702468655*^9, 
   3.6871567038585997`*^9}, {3.6871567729430323`*^9, 3.687156782205453*^9}, 
   3.687157455367036*^9}],

Cell["\<\
A partir de curva \[Alpha](u), y  direcci\[OAcute]n generatriz: w(u) ya \
tenemos nuestra parametrizaci\[OAcute]n:
X(u,v) = \[Alpha](u)+v w(u)
Vamos a hacer la del paraboloide hiperb\[OAcute]lico (silla de montar) z=kxy:\
\
\>", "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
  3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
  3.687153619815096*^9}, {3.687154988246519*^9, 3.687154991574291*^9}, {
  3.687155161316621*^9, 3.6871551927900953`*^9}, {3.6871568185114403`*^9, 
  3.687156976342205*^9}, {3.687157014646411*^9, 3.68715703682257*^9}, {
  3.687157094224833*^9, 3.687157166811138*^9}, {3.6871575404029207`*^9, 
  3.687157596882226*^9}, {3.687157845541642*^9, 3.687157855635563*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", 
   RowBox[{"1", "/", "4"}]}], ";", "  ", 
  RowBox[{"alpha", "=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "0"}], "}"}]}], ";", "   ", 
  RowBox[{"w", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"1", "/", "k"}], ",", "u"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"X", "=", " ", 
   RowBox[{"alpha", "+", 
    RowBox[{"v", " ", "w"}]}]}], ";"}], "\n", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<Ecuaci\[OAcute]n de la superficie regladas x(u,v) = \>\"", ",", "X"}], 
  "]"}], "\n", 
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "X", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "5"}], ",", "5"}], "}"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.687152745341494*^9, 3.687152849622143*^9}, {
   3.68715307453388*^9, 3.6871533129046926`*^9}, {3.687153347146969*^9, 
   3.68715334789959*^9}, {3.6871538225957623`*^9, 3.68715383716253*^9}, {
   3.6871549983236847`*^9, 3.687155066196164*^9}, {3.687155100014189*^9, 
   3.687155136934029*^9}, {3.68715519872091*^9, 3.687155287028051*^9}, 
   3.687156809999312*^9, {3.687156984361763*^9, 3.687157007665745*^9}, {
   3.6871570434235363`*^9, 3.687157072348402*^9}, {3.6871571722239532`*^9, 
   3.687157200863303*^9}, {3.687157233850286*^9, 3.6871573082680893`*^9}, {
   3.6871573501281853`*^9, 3.687157372565317*^9}, {3.687157561909029*^9, 
   3.6871575622533007`*^9}, {3.6871576376080217`*^9, 
   3.6871577164539623`*^9}, {3.687157751845539*^9, 3.6871577987896547`*^9}, {
   3.687249124399055*^9, 3.687249127972039*^9}, {3.6872491862412033`*^9, 
   3.687249186901775*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Superficies regladas (conos)", "Subsection",
 CellChangeTimes->{{3.687152702096903*^9, 3.687152706004499*^9}, {
  3.687154895197155*^9, 3.6871548986272173`*^9}, {3.687156702468655*^9, 
  3.6871567038585997`*^9}, {3.6871567729430323`*^9, 3.687156782205453*^9}}],

Cell[TextData[{
 "A partir de un v\[EAcute]rtice P  y una curva \[Alpha](u), tomamos como \
direcci\[OAcute]n generatriz: w(u) = \[Alpha](u)-P yya tenemos nuestra \
parametrizaci\[OAcute]n:\nX(u,v) = \[Alpha](u)+v w(u)   (\[OAcute] tambi\
\[EAcute]n ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "2"], TraditionalForm]]],
 "(u,v) = p + v w(u)) (v\[EAcute]ase)."
}], "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
  3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
  3.687153619815096*^9}, {3.687154988246519*^9, 3.687154991574291*^9}, {
  3.687155161316621*^9, 3.6871551927900953`*^9}, {3.6871568185114403`*^9, 
  3.687156976342205*^9}, {3.687157014646411*^9, 3.68715703682257*^9}, {
  3.687157094224833*^9, 3.687157166811138*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"alpha", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "u", "]"}], ",", 
     RowBox[{
      RowBox[{"Sin", "[", 
       RowBox[{"2", "u"}], "]"}], 
      RowBox[{"Cos", "[", "u", "]"}]}], ",", 
     RowBox[{"1", "-", 
      RowBox[{"Cos", "[", "u", "]"}], "-", 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"alpha", "-", "P"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"X", "=", " ", 
   RowBox[{"P", " ", "+", " ", 
    RowBox[{"v", "  ", "w"}]}]}], ";"}], "\n", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<Ecuaci\[OAcute]n de la superficie c\[OAcute]nica x(u,v) = \>\"", ",", 
   "X"}], "]"}], "\n", 
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "X", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", 
     RowBox[{"2", " ", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "2"}], ",", "4"}], "}"}], ",", 
   RowBox[{"AxesLabel", "->", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.687152745341494*^9, 3.687152849622143*^9}, {
   3.68715307453388*^9, 3.6871533129046926`*^9}, {3.687153347146969*^9, 
   3.68715334789959*^9}, {3.6871538225957623`*^9, 3.68715383716253*^9}, {
   3.6871549983236847`*^9, 3.687155066196164*^9}, {3.687155100014189*^9, 
   3.687155136934029*^9}, {3.68715519872091*^9, 3.687155287028051*^9}, 
   3.687156809999312*^9, {3.687156984361763*^9, 3.687157007665745*^9}, {
   3.6871570434235363`*^9, 3.687157072348402*^9}, {3.6871571722239532`*^9, 
   3.687157200863303*^9}, {3.687157233850286*^9, 3.6871573082680893`*^9}, {
   3.6871573501281853`*^9, 3.687157372565317*^9}}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Geometr\[IAcute]a de superficies (primera y segunda forma fundamental)\
\>", "Section",
 CellChangeTimes->{{3.687152675619287*^9, 3.687152688676157*^9}, {
  3.687157890703683*^9, 3.687157929758257*^9}, {3.687158993876594*^9, 
  3.6871589956442738`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Primera forma fundamental a partir de una parametrizaci\[OAcute]n\
\>", "Subsection",
 CellChangeTimes->{{3.687154067293725*^9, 3.6871540686875668`*^9}, {
  3.687157982578437*^9, 3.687157994552815*^9}, {3.687158395919002*^9, 
  3.687158411375712*^9}, {3.6871589704830103`*^9, 3.687158991956066*^9}, {
  3.687164054468052*^9, 3.6871640672183847`*^9}}],

Cell[TextData[{
 "Dada S = {X(u,v), (u,v)\[Element]U\[Subset]",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["R", "2"], TraditionalForm]]],
 "} la primera forma fundamental (sus componentes respecto de ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "u"], TraditionalForm]]],
 "y ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "v"], TraditionalForm]]],
 ") son\nE = |",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "u"], TraditionalForm]]],
 "|^2\nF = < ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "u"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "v"], TraditionalForm]]],
 ">\nG = |",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "v"], TraditionalForm]]],
 "|^2\nLo escribmos sobre un ejemplo, el toro (hecho en clase):"
}], "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9, {
   3.687164081547243*^9, 3.687164301538795*^9}, 3.687164487210298*^9}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"r", "*", 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "*", 
      RowBox[{"Cos", "[", "v", "]"}]}], ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"r", "*", 
         RowBox[{"Cos", "[", "u", "]"}]}]}], ")"}], "*", 
      RowBox[{"Sin", "[", "v", "]"}]}], ",", 
     RowBox[{"r", "*", 
      RowBox[{"Sin", "[", "u", "]"}]}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"EE", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"X", ",", "u"}], "]"}], ".", 
     RowBox[{"D", "[", 
      RowBox[{"X", ",", "u"}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FF", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"X", ",", "u"}], "]"}], ".", 
    RowBox[{"D", "[", 
     RowBox[{"X", ",", "v"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GG", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"X", ",", "v"}], "]"}], ".", 
     RowBox[{"D", "[", 
      RowBox[{"X", ",", "v"}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<La primera forma fundamental del toro en la parametrizaci\[OAcute]n \
X(u,v) es: \\n I(u,v) = \>\"", ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"EE", ",", "FF"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"FF", ",", "GG"}], "}"}]}], "}"}], "//", "MatrixForm"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6871541321433687`*^9, 3.68715428016076*^9}, {
  3.687154311555813*^9, 3.68715431944943*^9}, {3.687158126624386*^9, 
  3.6871581425224733`*^9}, {3.687158189212406*^9, 3.687158334238686*^9}, {
  3.687164305248124*^9, 3.6871644555265636`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
\[CapitalAAcute]rea de una superficie en param\[EAcute]tricas\
\>", "Subsection",
 CellChangeTimes->{{3.687154067293725*^9, 3.6871540686875668`*^9}, {
  3.687157982578437*^9, 3.687157994552815*^9}, {3.687158395919002*^9, 
  3.687158411375712*^9}, {3.6871589704830103`*^9, 3.687158991956066*^9}, {
  3.687164498074534*^9, 3.6871644984343147`*^9}}],

Cell[TextData[{
 "Partimos de una superficie que se construye mediante combinaciones convexas \
del segmento ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["ab", "_"], TraditionalForm]]],
 " y el ",
 Cell[BoxData[
  FormBox[
   OverscriptBox["cd", "_"], TraditionalForm]]],
 " "
}], "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"a", "=", 
    RowBox[{"{", 
     RowBox[{"2", ",", "0", ",", "4"}], "}"}]}], ";"}], 
  " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "4", ",", "3"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "2"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"segmento1", "=", 
   RowBox[{
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", "u"}], ")"}]}], " ", "+", " ", 
    RowBox[{"b", " ", "u"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"segmento2", "=", 
   RowBox[{
    RowBox[{"c", " ", "u"}], " ", "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "u"}], ")"}], " ", "d"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"Simplify", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "v"}], ")"}], "*", "segmento1"}], " ", "+", " ", 
     RowBox[{"v", "*", "segmento2"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<Parametrizaci\[OAcute]n del la superficie x(u,v)=\>\"", ",", "X"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "X", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "0", ",", "1"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6871541321433687`*^9, 3.68715428016076*^9}, {
  3.687154311555813*^9, 3.68715431944943*^9}, {3.687158126624386*^9, 
  3.6871581425224733`*^9}, {3.687158189212406*^9, 3.687158334238686*^9}, {
  3.6871917951531563`*^9, 3.6871917995041656`*^9}}],

Cell[TextData[{
 "Calculamos er \[AAcute]rea desde la definici\[OAcute]n: A=",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{"|", 
     RowBox[{
      SubscriptBox["X", "u"], "\[Times]", 
      SubscriptBox["X", "v"]}], "|", 
     RowBox[{"\[DifferentialD]", 
      RowBox[{"(", "uv", ")"}]}]}]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, {3.687158354791798*^9, 
   3.687158390782116*^9}, {3.6871645176844873`*^9, 3.687164520892857*^9}, 
   3.6871684720120907`*^9, {3.687168504316386*^9, 3.687168559036696*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Cross", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"X", ",", "u"}], "]"}], ",", 
     RowBox[{"D", "[", 
      RowBox[{"X", ",", "v"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"area", "=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"n", ".", "n"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.6871584210135717`*^9, 3.6871584885828867`*^9}, {
  3.6871587015478277`*^9, 3.687158799936469*^9}, {3.687164524465722*^9, 
  3.687164568985786*^9}, {3.6871685624235086`*^9, 3.687168701403719*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
\[CapitalAAcute]rea de una superficie pasando por la primera forma \
fundamental E, F y G \
\>", "Subsection",
 CellChangeTimes->{{3.687154067293725*^9, 3.6871540686875668`*^9}, {
   3.687157982578437*^9, 3.687157994552815*^9}, {3.687158395919002*^9, 
   3.687158411375712*^9}, {3.6871589704830103`*^9, 3.687158991956066*^9}, {
   3.687164498074534*^9, 3.6871644984343147`*^9}, 3.687168820863306*^9, {
   3.6871688834079037`*^9, 3.687168900152577*^9}}],

Cell[TextData[{
 "Usamos el mismo ejemplo anterior, determinamos la primera forma fundamental \
y calculamos el \[CapitalAAcute]rea aplicando la f\[OAcute]rmula de clase a \
partir de la parametrizaci\[OAcute]n: A=",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{"EG", "-", 
       SuperscriptBox["F", "2"]}]], 
     RowBox[{"\[DifferentialD]", 
      RowBox[{"(", "uv", ")"}]}]}]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9, {
   3.687168846230668*^9, 3.6871688798802032`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"EE", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"X", ",", "u"}], "]"}], ".", 
    RowBox[{"D", "[", 
     RowBox[{"X", ",", "u"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FF", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"X", ",", "u"}], "]"}], ".", 
    RowBox[{"D", "[", 
     RowBox[{"X", ",", "v"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GG", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"X", ",", "v"}], "]"}], ".", 
    RowBox[{"D", "[", 
     RowBox[{"X", ",", "v"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"area", "=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"EE", "*", "GG"}], "-", 
       RowBox[{"FF", "^", "2"}]}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "0", ",", "1"}], "}"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.6871584210135717`*^9, 3.6871584885828867`*^9}, {
  3.6871587015478277`*^9, 3.687158799936469*^9}, {3.687164524465722*^9, 
  3.687164568985786*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\[CapitalAAcute]rea de una superficie grafo", "Subsection",
 CellChangeTimes->{{3.687154067293725*^9, 3.6871540686875668`*^9}, {
  3.687157982578437*^9, 3.687157994552815*^9}, {3.687158395919002*^9, 
  3.687158411375712*^9}, {3.687158940780237*^9, 3.687158963610888*^9}, {
  3.687164809198995*^9, 3.687164813517763*^9}}],

Cell[TextData[{
 "Dada la superficie (B\[OAcute]veda de Viviani) cuya ecuaci\[OAcute]n impl\
\[IAcute]cita es la de una esfera de radio 2r \n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SuperscriptBox["x", "2"], "+", 
     SuperscriptBox["y", "2"], "+", 
     SuperscriptBox["z", "2"]}], "=", 
    RowBox[{"4", 
     SuperscriptBox["r", "2"]}]}], TraditionalForm]]],
 "\npero restringida a {z > 0} y  conjunto de valores en el disco: U={(x,y) \
tal que (x-r)^2+y^2 < r^2}.\nLo nuevo aqu\[IAcute] es parametrizar U: ya que \
\nx \[Element] (1-r,1+r)   y \[Element]",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        SuperscriptBox["r", "2"], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"x", "-", "r"}], ")"}], "2"]}]]}], ",", " ", 
     SqrtBox[
      RowBox[{
       SuperscriptBox["r", "2"], "-", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"x", "-", "r"}], ")"}], "2"]}]]}], ")"}], 
   TraditionalForm]]],
 ", \nVamos a representarla para r = 1 como grafo (despejando la z) y a \
calcular su \[AAcute]rea."
}], "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9, {
   3.687164825078883*^9, 3.687165126712359*^9}, {3.687165225220295*^9, 
   3.687165230932207*^9}, {3.6871660244430027`*^9, 3.687166076698462*^9}, {
   3.687166113534837*^9, 3.687166169122862*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
   RowBox[{"Sqrt", "[", 
    RowBox[{
     RowBox[{"4", 
      RowBox[{"r", "^", "2"}]}], "-", 
     RowBox[{"x", "^", "2"}], "-", 
     RowBox[{"y", "^", "2"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", 
     RowBox[{"f", "[", 
      RowBox[{"x", ",", "y"}], "]"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"r", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"Evaluate", "[", "X", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"1", "-", "r"}], ",", 
     RowBox[{"1", "+", "r"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"r", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "r"}], ")"}], "^", "2"}]}], "]"}]}], ",", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       RowBox[{"r", "^", "2"}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"x", "-", "r"}], ")"}], "^", "2"}]}], "]"}]}], "}"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6871541321433687`*^9, 3.68715428016076*^9}, {
  3.687154311555813*^9, 3.68715431944943*^9}, {3.687158126624386*^9, 
  3.6871581425224733`*^9}, {3.687158189212406*^9, 3.687158334238686*^9}, {
  3.687165067226132*^9, 3.6871650688497467`*^9}, {3.687165144327043*^9, 
  3.687165245376074*^9}, {3.687165416472769*^9, 3.687165445704301*^9}, {
  3.6871655409571342`*^9, 3.687165546827113*^9}, {3.687165966194655*^9, 
  3.68716601017949*^9}, {3.6871660809263783`*^9, 3.687166087486598*^9}, {
  3.687166183760851*^9, 3.687166314606286*^9}}],

Cell[TextData[{
 "Y calculamos el \[CapitalAAcute]rea aplicando la f\[OAcute]rmula de clase a \
partir de la parametrizaci\[OAcute]n: A=",
 Cell[BoxData[
  FormBox[
   RowBox[{"\[Integral]", 
    RowBox[{
     SqrtBox[
      RowBox[{
       RowBox[{"1", "+"}], "|", 
       RowBox[{"\[Del]", "f"}], "|", 
       RowBox[{"^", "2"}]}]], 
     RowBox[{"\[DifferentialD]", 
      RowBox[{"(", "xy", ")"}]}]}]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
  3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
  3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
  3.6871581492865763`*^9, 3.687158185121842*^9}, {3.687158354791798*^9, 
  3.687158390782116*^9}, {3.687158503996757*^9, 3.6871585082902107`*^9}, {
  3.687158626056671*^9, 3.687158695001994*^9}, {3.687165641089209*^9, 
  3.6871656662110243`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"r", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"integrando", "=", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{"1", "+", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"x", ",", "y"}], "]"}], ",", "x"}], "]"}], "^", "2"}], "+", 
      
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{
         RowBox[{"f", "[", 
          RowBox[{"x", ",", "y"}], "]"}], ",", "y"}], "]"}], "^", "2"}]}], 
     "]"}], "//", "Simplify"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"area", "=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"Evaluate", "[", "integrando", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"1", "-", "r"}], ",", 
      RowBox[{"1", "+", "r"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", 
       RowBox[{"Sqrt", "[", 
        RowBox[{
         RowBox[{"r", "^", "2"}], "-", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"x", "-", "r"}], ")"}], "^", "2"}]}], "]"}]}], ",", 
      RowBox[{"Sqrt", "[", 
       RowBox[{
        RowBox[{"r", "^", "2"}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"x", "-", "r"}], ")"}], "^", "2"}]}], "]"}]}], "}"}]}], 
   "]"}]}]}], "Input",
 CellChangeTimes->{{3.687158532682712*^9, 3.687158614416088*^9}, {
  3.6871656842405357`*^9, 3.687165857486021*^9}, {3.687165959403755*^9, 
  3.687165962497533*^9}, {3.687166331369445*^9, 3.687166341728429*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Aplicaci\[OAcute]n de Gauss y segunda forma fundamental a partir de una \
parametrizaci\[OAcute]n\
\>", "Subsection",
 CellChangeTimes->{{3.687154067293725*^9, 3.6871540686875668`*^9}, {
  3.687157982578437*^9, 3.687157994552815*^9}, {3.687158395919002*^9, 
  3.687158411375712*^9}, {3.6871589704830103`*^9, 3.687158991956066*^9}, {
  3.687164054468052*^9, 3.6871640672183847`*^9}, {3.687169007326894*^9, 
  3.687169032629444*^9}, {3.687169345872752*^9, 3.687169346496793*^9}}],

Cell[TextData[{
 "Dada S = {X(u,v), (u,v)\[Element]U\[Subset]",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["R", "2"], TraditionalForm]]],
 "} recordamos que la aplicaci\[OAcute]n de Gauss es la que asigna el vector \
normal:\n\n",
 Cell[BoxData[
  FormBox[
   RowBox[{"N", "=", 
    FractionBox[
     RowBox[{
      SubscriptBox["X", "u"], "\[Times]", 
      SubscriptBox["X", "v"]}], 
     RowBox[{"|", 
      RowBox[{
       SubscriptBox["X", "u"], "\[Times]", 
       SubscriptBox["X", "v"]}], "|"}]]}], TraditionalForm]]],
 "\n\ny las componentes de II son ( respecto de ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "u"], TraditionalForm]]],
 "y ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "v"], TraditionalForm]]],
 ")\n\ne = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"<", "N"}], ",", 
    RowBox[{
     SubscriptBox["X", "uu"], ">"}]}], TraditionalForm]]],
 "\nf = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"<", "N"}], ",", 
    RowBox[{
     SubscriptBox["X", "uv"], ">"}]}], TraditionalForm]]],
 "\ng = ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"<", "N"}], ",", 
    RowBox[{
     SubscriptBox["X", "vv"], ">"}]}], TraditionalForm]]],
 "\n\nmientras que la matriz de -",
 Cell[BoxData[
  FormBox[
   SubscriptBox["D", "p"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "N respecto de la base B= { ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "u"], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["X", "v"], TraditionalForm]]],
 "} es\n\n- ",
 Cell[BoxData[
  TagBox[
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", "\[NoBreak]", GridBox[{
        {"E", "F"},
        {"F", "G"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], 
     RowBox[{"-", "1"}]], 
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {"e", "f"},
       {"f", "g"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}]}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{{3.6871696783797007`*^9, 3.6871696824219217`*^9}}],
 "\nLo aplicamos sobre un paraboloide hiperb\[OAcute]lico"
}], "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9, {
   3.687164081547243*^9, 3.687164301538795*^9}, 3.687164487210298*^9, {
   3.687169066617251*^9, 3.6871691660980864`*^9}, {3.6871692396527843`*^9, 
   3.6871693107945147`*^9}, {3.687169364089346*^9, 3.687169373441286*^9}, {
   3.687191929595669*^9, 3.687192039961638*^9}, {3.687246225045643*^9, 
   3.687246237508317*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "\"\<Global`*\>\"", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"{", 
    RowBox[{"u", ",", "v", ",", 
     RowBox[{
      RowBox[{"u", "^", "2"}], "-", 
      RowBox[{"v", "^", "2"}]}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"n", "=", 
   RowBox[{"Cross", "[", 
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"X", ",", "u"}], "]"}], ",", 
     RowBox[{"D", "[", 
      RowBox[{"X", ",", "v"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"NN", "=", 
   RowBox[{"n", "/", 
    RowBox[{"Sqrt", "[", 
     RowBox[{"n", ".", "n"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Funci\[OAcute]n de Gauss N(u,v) = \>\"", ",", "NN"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ee", "=", 
   RowBox[{
    RowBox[{"NN", ".", 
     RowBox[{"D", "[", 
      RowBox[{"X", ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "2"}], "}"}]}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ff", "=", 
   RowBox[{"NN", ".", 
    RowBox[{"D", "[", 
     RowBox[{"X", ",", "u", ",", "v"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gg", "=", 
   RowBox[{
    RowBox[{"NN", ".", 
     RowBox[{"D", "[", 
      RowBox[{"X", ",", 
       RowBox[{"{", 
        RowBox[{"v", ",", "2"}], "}"}]}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Matriz de II(u,v) = \>\"", ",", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ee", ",", "ff"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ff", ",", "gg"}], "}"}]}], "}"}], "//", "MatrixForm"}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.6871541321433687`*^9, 3.68715428016076*^9}, {
   3.687154311555813*^9, 3.68715431944943*^9}, {3.687158126624386*^9, 
   3.6871581425224733`*^9}, {3.687158189212406*^9, 3.687158334238686*^9}, {
   3.687164305248124*^9, 3.6871644555265636`*^9}, {3.687169356477221*^9, 
   3.687169568453574*^9}, {3.687169603696822*^9, 3.687169682017346*^9}, 
   3.687191882218669*^9, {3.687191915234779*^9, 3.687191916154739*^9}, {
   3.6871921485715837`*^9, 3.6871921631950483`*^9}, {3.6871925800980186`*^9, 
   3.68719259452175*^9}}],

Cell["Las matrices correspondientes a I e II son", "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9, {
   3.687164081547243*^9, 3.687164301538795*^9}, 3.687164487210298*^9, {
   3.687169066617251*^9, 3.6871691660980864`*^9}, {3.6871692396527843`*^9, 
   3.6871693107945147`*^9}, {3.687169364089346*^9, 3.687169373441286*^9}, {
   3.6871698289007063`*^9, 3.6871698451145763`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"EE", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"X", ",", "u"}], "]"}], ".", 
     RowBox[{"D", "[", 
      RowBox[{"X", ",", "u"}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"FF", "=", 
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{"X", ",", "u"}], "]"}], ".", 
    RowBox[{"D", "[", 
     RowBox[{"X", ",", "v"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"GG", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"D", "[", 
      RowBox[{"X", ",", "v"}], "]"}], ".", 
     RowBox[{"D", "[", 
      RowBox[{"X", ",", "v"}], "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matriz1", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"EE", ",", "FF"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"FF", ",", "GG"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"auxiliar", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"ee", ",", "ff"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"ff", ",", "gg"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"matriz2", "=", 
   RowBox[{
    RowBox[{"Inverse", "[", 
     RowBox[{"-", "matriz1"}], "]"}], ".", "auxiliar"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Matriz de I(u,v) = \>\"", ",", 
   RowBox[{"matriz1", "//", "MatrixForm"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Matriz de -DN(u,v) = \>\"", ",", 
   RowBox[{"matriz2", "//", "MatrixForm"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6871698481246767`*^9, 3.687169924337469*^9}, {
  3.687192119789*^9, 3.687192127028788*^9}, {3.6871922038895063`*^9, 
  3.68719229019247*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Curvatura de Gauss, curvatura media\
\>", "Subsection",
 CellChangeTimes->{{3.687154067293725*^9, 3.6871540686875668`*^9}, {
   3.687157982578437*^9, 3.687157994552815*^9}, {3.687158395919002*^9, 
   3.687158411375712*^9}, {3.6871589704830103`*^9, 3.687158991956066*^9}, {
   3.687164054468052*^9, 3.6871640672183847`*^9}, {3.687169007326894*^9, 
   3.687169032629444*^9}, {3.687169345872752*^9, 3.687169346496793*^9}, {
   3.687169707199336*^9, 3.687169722494052*^9}, {3.687192765586235*^9, 
   3.687192768041802*^9}, 3.687192960054367*^9}],

Cell[TextData[{
 "Recordamos las definiciones \n-",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["k", "1"], "y", " ", 
    SubscriptBox["k", "2"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " son, cambiados de signo, los autovalores de la matriz de -DN\n-K = \
curvatura de Gauss = det (matriz -DN)  =  ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["k", "1"], 
    SubscriptBox["k", "2"]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ",\n-H = curvatura media = - ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "traza (matriz -DN)  =  ",
 Cell[BoxData[
  FormBox[
   FractionBox[
    RowBox[{
     SubscriptBox["k", "1"], "+", " ", 
     SubscriptBox["k", "2"]}], "2"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "."
}], "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9, {
   3.687164081547243*^9, 3.687164301538795*^9}, 3.687164487210298*^9, {
   3.687169066617251*^9, 3.6871691660980864`*^9}, {3.6871692396527843`*^9, 
   3.6871693107945147`*^9}, {3.687169364089346*^9, 3.687169373441286*^9}, {
   3.687192323467391*^9, 3.687192549823634*^9}}],

Cell[BoxData[{
 RowBox[{"KK", "=", 
  RowBox[{
   RowBox[{"Det", "[", "matriz2", "]"}], "//", 
   "Simplify"}]}], "\[IndentingNewLine]", 
 RowBox[{"HH", "=", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"matriz2", "[", 
        RowBox[{"[", 
         RowBox[{"1", ",", "1"}], "]"}], "]"}], "+", 
       RowBox[{"matriz2", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "2"}], "]"}], "]"}]}], ")"}]}], "/", "2"}], "//", 
   "Simplify"}]}]}], "Input",
 CellChangeTimes->{{3.6871541321433687`*^9, 3.68715428016076*^9}, {
  3.687154311555813*^9, 3.68715431944943*^9}, {3.687158126624386*^9, 
  3.6871581425224733`*^9}, {3.687158189212406*^9, 3.687158334238686*^9}, {
  3.687164305248124*^9, 3.6871644555265636`*^9}, {3.687169356477221*^9, 
  3.687169568453574*^9}, {3.687169603696822*^9, 3.687169682017346*^9}, {
  3.687192633117235*^9, 3.687192748116448*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"k1", ",", "k2"}], "}"}], "=", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Eigenvalues", "[", "matriz2", "]"}]}], "//", "Simplify"}]}], 
  ";"}], "\[IndentingNewLine]", "k1", "\[IndentingNewLine]", "k2"}], "Input",
 CellChangeTimes->{{3.687192754454927*^9, 3.6871927938111362`*^9}, {
   3.6871929201445723`*^9, 3.6871929542300386`*^9}, 3.6871938927479753`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Clasificaci\[OAcute]n de puntos", "Subsection",
 CellChangeTimes->{{3.687154067293725*^9, 3.6871540686875668`*^9}, {
  3.687157982578437*^9, 3.687157994552815*^9}, {3.687158395919002*^9, 
  3.687158411375712*^9}, {3.6871589704830103`*^9, 3.687158991956066*^9}, {
  3.687164054468052*^9, 3.6871640672183847`*^9}, {3.687169007326894*^9, 
  3.687169032629444*^9}, {3.687169345872752*^9, 3.687169346496793*^9}, {
  3.687169707199336*^9, 3.687169722494052*^9}, {3.687192765586235*^9, 
  3.687192768041802*^9}, {3.6871928145465927`*^9, 3.687192824232141*^9}, {
  3.687192963349041*^9, 3.687192965699193*^9}, {3.687193850073695*^9, 
  3.687193850633191*^9}}],

Cell["\<\
Recordamos que K caracteriza los puntos
-K < 0 punto hiperb\[OAcute]lico (dos direcciones perpendiculares con \
curvaturas opuestas, tipo silla de montar)
-K > 0 punto el\[IAcute]ptico (en todas las direcciones, las curvas est\
\[AAcute]n \[OpenCurlyDoubleQuote]hacia el mismo \
lado\[CloseCurlyDoubleQuote], tipo elipsoide)
-K = 0 punto parab\[OAcute]lico (tipo cilindro) que puede ser plano si H = 0 \
tambi\[EAcute]n.

Se dice umbilical cuando k1 = k2 (el\[IAcute]ptico pero con igual curvatura \
en todas direcciones, tipo esfera)
\
\>", "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9, {
   3.687164081547243*^9, 3.687164301538795*^9}, 3.687164487210298*^9, {
   3.687169066617251*^9, 3.6871691660980864`*^9}, {3.6871692396527843`*^9, 
   3.6871693107945147`*^9}, {3.687169364089346*^9, 3.687169373441286*^9}, {
   3.687192323467391*^9, 3.687192549823634*^9}, {3.6871932406515493`*^9, 
   3.687193318831128*^9}, {3.687193950579946*^9, 3.687194078445218*^9}, {
   3.687194186364176*^9, 3.687194344252604*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"P", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"u", "->", "1"}], ",", 
     RowBox[{"v", "->", "1"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Punto P = \>\"", ",", 
   RowBox[{"X", "/.", "P"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Curvatura de Gauss K en P = \>\"", ",", 
   RowBox[{"KK", "/.", "P"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Curvatura media H en P = \>\"", ",", 
   RowBox[{"HH", "/.", "P"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<curvatura principal k1 en P = \>\"", ",", 
   RowBox[{"k1", "/.", "P"}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<curvatura principal k2 en P = \>\"", ",", 
   RowBox[{"k2", "/.", "P"}]}], "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.68716957691817*^9, 3.687169599211091*^9}, {
   3.6871929761964893`*^9, 3.687193193776067*^9}, 3.6871932936210423`*^9, {
   3.687194615658824*^9, 3.687194638062776*^9}}],

Cell["\<\
En este caso, K<0, tenemos un punto no umbilical (hiperb\[OAcute]lico), por \
lo que podemos calcular sus direcciones principales:\
\>", "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9, {
   3.687164081547243*^9, 3.687164301538795*^9}, 3.687164487210298*^9, {
   3.687169066617251*^9, 3.6871691660980864`*^9}, {3.6871692396527843`*^9, 
   3.6871693107945147`*^9}, {3.687169364089346*^9, 3.687169373441286*^9}, {
   3.687192323467391*^9, 3.687192549823634*^9}, {3.6871932406515493`*^9, 
   3.687193318831128*^9}, {3.687193354953624*^9, 3.6871934102717743`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Direcciones principales, indicatriz de Dupin, direcci\[OAcute]n \
asint\[OAcute]tica\
\>", "Subsection",
 CellChangeTimes->{{3.687154067293725*^9, 3.6871540686875668`*^9}, {
  3.687157982578437*^9, 3.687157994552815*^9}, {3.687158395919002*^9, 
  3.687158411375712*^9}, {3.6871589704830103`*^9, 3.687158991956066*^9}, {
  3.687164054468052*^9, 3.6871640672183847`*^9}, {3.687169007326894*^9, 
  3.687169032629444*^9}, {3.687169345872752*^9, 3.687169346496793*^9}, {
  3.687169707199336*^9, 3.687169722494052*^9}, {3.687192765586235*^9, 
  3.687192768041802*^9}, {3.6871928145465927`*^9, 3.687192824232141*^9}, {
  3.687192963349041*^9, 3.687192965699193*^9}, {3.687193833926374*^9, 
  3.687193842185418*^9}, {3.6871953591132917`*^9, 3.687195365135231*^9}}],

Cell["\<\
Las direcciones principales son:\
\>", "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9, {
   3.687164081547243*^9, 3.687164301538795*^9}, 3.687164487210298*^9, {
   3.687169066617251*^9, 3.6871691660980864`*^9}, {3.6871692396527843`*^9, 
   3.6871693107945147`*^9}, {3.687169364089346*^9, 3.687169373441286*^9}, {
   3.687192323467391*^9, 3.687192549823634*^9}, {3.6871932406515493`*^9, 
   3.687193318831128*^9}, {3.687193354953624*^9, 3.6871934102717743`*^9}, {
   3.6872497920716352`*^9, 3.6872497968393803`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"v1", ",", "v2"}], "}"}], "=", 
   RowBox[{"-", 
    RowBox[{"Eigenvectors", "[", 
     RowBox[{"matriz2", "/.", "P"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<Direcci\[OAcute]n principal v1 en P respecto de la base {Xu, Xv}= \
\>\"", ",", "v1"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Direcci\[OAcute]n principal v1 en P = \>\"", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"v1", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{"X", ",", "u"}], "]"}]}], "/.", "P"}], ")"}], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"v1", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{"X", ",", "v"}], "]"}]}], "/.", "P"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{
  "\"\<Direcci\[OAcute]n principal v2 en P respecto de la base {Xu, Xv}= \
\>\"", ",", "v2"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Direcci\[OAcute]n principal v1 en P = \>\"", ",", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"v2", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{"X", ",", "u"}], "]"}]}], "/.", "P"}], ")"}], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"v2", "[", 
        RowBox[{"[", "2", "]"}], "]"}], "*", 
       RowBox[{"D", "[", 
        RowBox[{"X", ",", "v"}], "]"}]}], "/.", "P"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.68719341251612*^9, 3.687193429625458*^9}, {
  3.687193460516962*^9, 3.687193517826413*^9}, {3.6871935777824697`*^9, 
  3.687193581660349*^9}, {3.6871936471629543`*^9, 3.687193799671544*^9}}],

Cell[TextData[{
 "La indicatriz de Dupin son las c\[OAcute]nicas en ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["T", "p"], TraditionalForm]]],
 "S de coordenadas (a,b) cumpliendo:\n",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["k", "1"], 
      SuperscriptBox["a", "2"]}], "+", 
     RowBox[{
      SubscriptBox["k", "2"], 
      SuperscriptBox["b", "2"]}]}], "=", "1"}], TraditionalForm]]],
 ", ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["k", "1"], 
      SuperscriptBox["a", "2"]}], "+", 
     RowBox[{
      SubscriptBox["k", "2"], 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{"-", "1"}]}], TraditionalForm]]],
 "\nDejamos como ejercicio el representarla."
}], "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9, {
   3.687164081547243*^9, 3.687164301538795*^9}, 3.687164487210298*^9, {
   3.687169066617251*^9, 3.6871691660980864`*^9}, {3.6871692396527843`*^9, 
   3.6871693107945147`*^9}, {3.687169364089346*^9, 3.687169373441286*^9}, {
   3.687192323467391*^9, 3.687192549823634*^9}, {3.6871932406515493`*^9, 
   3.687193318831128*^9}, {3.687193354953624*^9, 3.6871934102717743`*^9}, {
   3.687194850344664*^9, 3.687194919891427*^9}, {3.687194960540586*^9, 
   3.6871949906187553`*^9}, {3.687195371798161*^9, 3.6871953894426928`*^9}, {
   3.687249828435713*^9, 3.687249828920676*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "2"}], " ", 
    RowBox[{"(", 
     RowBox[{"k1", "/.", "P"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"b", "^", "2"}], 
    RowBox[{"(", 
     RowBox[{"k2", "/.", "P"}], ")"}]}]}], "\[Equal]", 
  RowBox[{"-", "1"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"a", "^", "2"}], " ", 
    RowBox[{"(", 
     RowBox[{"k1", "/.", "P"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"b", "^", "2"}], 
    RowBox[{"(", 
     RowBox[{"k2", "/.", "P"}], ")"}]}]}], "\[Equal]", "1"}]}], "Input",
 CellChangeTimes->{{3.687195059194421*^9, 3.687195060592795*^9}}],

Cell[TextData[{
 "En este caso, K<0, y las direcciones asint\[OAcute]ticas (vectores con \
curvatura normal cero) tienen sentido precisamente en puntos \
hiperb\[OAcute]licos (o parab\[OAcute]licos).\nEn t\[EAcute]rminos de la \
segunda forma es ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["II", "p"], TraditionalForm]]],
 "(w) = 0 (en coordenadas respecto de {Xu,Xv} ser\[AAcute]:\n",
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"a", "b"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{3.687195512934675*^9}],
 Cell[BoxData[
  TagBox[
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"e", "f"},
      {"f", "g"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]]],
  CellChangeTimes->{3.687195512934675*^9}],
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", "\[NoBreak]", GridBox[{
      {"a"},
      {"b"}
     },
     GridBoxAlignment->{
      "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
        "RowsIndexed" -> {}},
     GridBoxSpacings->{"Columns" -> {
         Offset[0.27999999999999997`], {
          Offset[0.7]}, 
         Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
         Offset[0.2], {
          Offset[0.4]}, 
         Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}], "=", "0"}]],
  CellChangeTimes->{3.687195512934675*^9, 3.6871956910059147`*^9}],
 "."
}], "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9, {
   3.687164081547243*^9, 3.687164301538795*^9}, 3.687164487210298*^9, {
   3.687169066617251*^9, 3.6871691660980864`*^9}, {3.6871692396527843`*^9, 
   3.6871693107945147`*^9}, {3.687169364089346*^9, 3.687169373441286*^9}, {
   3.687192323467391*^9, 3.687192549823634*^9}, {3.6871932406515493`*^9, 
   3.687193318831128*^9}, {3.687193354953624*^9, 3.6871934102717743`*^9}, {
   3.687194850344664*^9, 3.687194919891427*^9}, {3.687194960540586*^9, 
   3.6871949906187553`*^9}, {3.687195371798161*^9, 3.687195469213779*^9}, {
   3.687195516716236*^9, 3.6871957436564417`*^9}, {3.6872497810813913`*^9, 
   3.687249782498095*^9}, {3.6872498485475903`*^9, 3.6872498713867483`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"matrizII", "=", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"ee", ",", "ff"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"ff", ",", "gg"}], "}"}]}], "}"}], "/.", "P"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"asin", "=", 
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}], ".", "matrizII", ".", 
       RowBox[{"{", 
        RowBox[{"a", ",", "b"}], "}"}]}], "\[Equal]", "0"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "/.", 
  RowBox[{"asin", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], "/.", 
  RowBox[{"asin", "[", 
   RowBox[{"[", "2", "]"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.687195768060672*^9, 3.687195877840989*^9}, {
  3.6871959116754704`*^9, 3.687195942538864*^9}}],

Cell["\<\
En este caso, las direcciones asint\[OAcute]ticas son dos (las \
as\[IAcute]ntotas de la indicatriz de Dupin), en las direcciones w1 = (1,-1) \
y w2 = (1,1). En coordenadas cartesianas, ser\[IAcute]an (dejamos libre el \
valor de a)\
\>", "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9, {
   3.687164081547243*^9, 3.687164301538795*^9}, 3.687164487210298*^9, {
   3.687169066617251*^9, 3.6871691660980864`*^9}, {3.6871692396527843`*^9, 
   3.6871693107945147`*^9}, {3.687169364089346*^9, 3.687169373441286*^9}, {
   3.687192323467391*^9, 3.687192549823634*^9}, {3.6871932406515493`*^9, 
   3.687193318831128*^9}, {3.687193354953624*^9, 3.6871934102717743`*^9}, {
   3.687194850344664*^9, 3.687194919891427*^9}, {3.687194960540586*^9, 
   3.6871949906187553`*^9}, {3.687195371798161*^9, 3.687195469213779*^9}, {
   3.687195516716236*^9, 3.6871957436564417`*^9}, {3.6871959049133167`*^9, 
   3.687195907327526*^9}, {3.687195947822098*^9, 3.687196024629369*^9}, {
   3.687196152923993*^9, 3.687196159656925*^9}, {3.687249775075088*^9, 
   3.68724977528018*^9}, {3.68724990710846*^9, 3.687249907740242*^9}}],

Cell[BoxData[{
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Direcci\[OAcute]n asint\[OAcute]tica w1 en P = \>\"", ",", 
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"X", ",", "u"}], "]"}], "/.", "P"}], ")"}]}], "-", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"D", "[", 
        RowBox[{"X", ",", "v"}], "]"}]}], "/.", "P"}], ")"}]}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Print", "[", 
  RowBox[{"\"\<Direcci\[OAcute]n asint\[OAcute]tica w2 en P = \>\"", ",", 
   RowBox[{
    RowBox[{"a", "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"D", "[", 
        RowBox[{"X", ",", "u"}], "]"}], "/.", "P"}], ")"}]}], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "*", 
       RowBox[{"D", "[", 
        RowBox[{"X", ",", "v"}], "]"}]}], "/.", "P"}], ")"}]}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.687194724715303*^9, 3.687194800812787*^9}, {
   3.6871952705403357`*^9, 3.687195273939653*^9}, 3.6871955118993187`*^9, {
   3.687195682212504*^9, 3.687195690067318*^9}, {3.687195761994028*^9, 
   3.687195763121237*^9}, {3.687196057882936*^9, 3.687196128856141*^9}, 
   3.687249914287809*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Ejercicio", "Subsection",
 CellChangeTimes->{{3.687154067293725*^9, 3.6871540686875668`*^9}, {
  3.687157982578437*^9, 3.687157994552815*^9}, {3.687158395919002*^9, 
  3.687158411375712*^9}, {3.6871589704830103`*^9, 3.687158991956066*^9}, {
  3.687164054468052*^9, 3.6871640672183847`*^9}, {3.687169007326894*^9, 
  3.687169032629444*^9}, {3.687169345872752*^9, 3.687169346496793*^9}, {
  3.687169707199336*^9, 3.687169722494052*^9}, {3.687192765586235*^9, 
  3.687192768041802*^9}, {3.6871928145465927`*^9, 3.687192824232141*^9}, {
  3.687192963349041*^9, 3.687192965699193*^9}, {3.687193833926374*^9, 
  3.687193842185418*^9}, {3.6871953591132917`*^9, 3.687195365135231*^9}, {
  3.687246257164843*^9, 3.687246258858642*^9}}],

Cell["\<\
a) Determina una parametrizaci\[OAcute]n para la superficie que resulta de \
rotar la curva

               \[Alpha](t) = (2+cos(t), sen(t) , t)

en torno al eje OZ.
b) Dib\[UAcute]jala
c) Verifica que una de sus curvaturas principales no cambia de signo, y la \
otra s\[IAcute].
d) Determina un punto el\[IAcute]ptico, uno parab\[OAcute]lico, uno hiperb\
\[OAcute]lico y uno umbilical.
\
\>", "Text",
 CellChangeTimes->{{3.6871528601071777`*^9, 3.687152864189335*^9}, {
   3.687152897233983*^9, 3.687153056933524*^9}, {3.687153600615385*^9, 
   3.687153619815096*^9}, {3.6871580691407433`*^9, 3.687158116380591*^9}, {
   3.6871581492865763`*^9, 3.687158185121842*^9}, 3.687158354791798*^9, {
   3.687164081547243*^9, 3.687164301538795*^9}, 3.687164487210298*^9, {
   3.687169066617251*^9, 3.6871691660980864`*^9}, {3.6871692396527843`*^9, 
   3.6871693107945147`*^9}, {3.687169364089346*^9, 3.687169373441286*^9}, {
   3.687192323467391*^9, 3.687192549823634*^9}, {3.6871932406515493`*^9, 
   3.687193318831128*^9}, {3.687193354953624*^9, 3.6871934102717743`*^9}, {
   3.687194850344664*^9, 3.687194919891427*^9}, {3.687194960540586*^9, 
   3.6871949906187553`*^9}, {3.687195371798161*^9, 3.687195469213779*^9}, {
   3.687195516716236*^9, 3.6871957436564417`*^9}, {3.6871959049133167`*^9, 
   3.687195907327526*^9}, {3.687195947822098*^9, 3.687196024629369*^9}, {
   3.687196152923993*^9, 3.687196159656925*^9}, {3.6872462737499437`*^9, 
   3.687246443409799*^9}, {3.687246621153645*^9, 3.687246627488044*^9}, {
   3.687248435551951*^9, 3.687248437337407*^9}}],

Cell[CellGroupData[{

Cell["Posible soluci\[OAcute]n :", "Subsubsection",
 CellChangeTimes->{{3.687248918166191*^9, 3.687248922658091*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx0fXlcT837fnuyVnYee6WIlJ10DiFJZRchsiZZsqVkSfY9ZUtIIRVKJNF7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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNnXUYFVXXxefOnblzZwbExlYM7O4O7HxtMVFBUbGwMcEOFLtRMbCwW7FQ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         "]], 
        Polygon3DBox[CompressedData["
1:eJwtnGXY8zbShZ3ksWMnb5mZmWHLW2ZmZmZmZnjLzNx+ZWZmZmbmLXO37bbf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         "]], 
        Polygon3DBox[CompressedData["
1:eJwl1nuQz1UYx/Gvrb3xT2oadJNLKtdcCikpuSyLdpdda93L2o0kUkLltrKE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         
         "]]}]}, {}, {}, {}, {}}, {{}, {}, {}, {Line3DBox[CompressedData["
1:eJwVzj0vw1EYhvGnmiLRjRJiYK3GKNWBwdpFtyYS0g9QiU6duqiExdCkdiPx
8gmwYGg3pJPZImlsJSF+/+HKdT/3c87JWa7tV+qpiNjGdCbiCcPxiGduTkV8
yb2kQx8t3RL/Ij0R8ceHuox8hjHnPzjNXZ7BY9JnI+Z1eSxgzb2Oe+vJbF/i
RX7Xbcg72ETb3Nev4Bq7uk/e4yO7K3kVB+ZjNHCir3i/KxeTf/GpLjcZMYsL
8xxf8pv9Fu6Q8scb3Y98ywVnvuURsnb3urL8wHXvn3vzRa7qXnmAf36jK3c=

       "]], Line3DBox[CompressedData["
1:eJwVzb9LwlEUhvEjlN+gH1OCZQTOFY0i2GKtQeTW0GB7LrU0tQW1NujsnJX/
gNQgGEguGTg01yAIjRX0cXh4n/Pee8/NV2uHp6mIOMDybEQPk3TEi7yYj/jm
r9MOA1zq8jL0M0nEuznFE95Amn/KRNZlBl3kzBtYQ8H7W+9KPOdsR67LD12Z
H2MX/em+hYhN+YCqbixP5JW793wbZ+ZrnONGX7G/zovOvswNnp2LWMEdX5Ut
OXS+hw4ezUv++uNtvuXOL//Bov5Jt8+fZc3+pr1v/Eg3lCP8A6cyKjo=
       "]], 
      Line3DBox[{1301, 1485, 1778, 1486, 2939, 1781, 1491, 1521, 1492, 1314, 
       1540, 1798, 3032, 1541, 1801, 869, 1088, 868, 1206, 970, 2995, 1580, 
       1566, 1336, 1600, 1821, 1601, 1824, 3039, 1606, 1633, 989, 2766, 990, 
       922, 1108, 921, 3069, 1840, 1655, 1675, 3007, 1656, 1364, 1690, 1850, 
       3050, 1691, 2075, 1238, 1239, 1015, 1018, 954, 2819, 1159, 1158, 2046, 
       1731, 3018, 1870, 1732, 1392, 2980, 1752, 1883, 1753, 1757}], 
      Line3DBox[CompressedData["
1:eJwVzz9LQmEYhvFHQj1ark2ZSHNDY7QmtBVBW5M0Jy1BfYY+QR0/QoMaBLno
YAqB/RkyMci9LaK1fg0X1/3c7/O+nFOtN/aPMxGxh+VsxDO+cxEvi5B/5Ff+
wrVuwmtI9Ek+YqoryEU5RRNl8xVfopREDHlhKWLE684q2PTGNt+6X9HX5CrP
zTvyER7NY+TdfeIObnDqrM1duy3ewJnuAj3dOR94P+UtZ5+6prziW8pYRU3/
hsn/P6CHPkZ27+xm7AR+dQPzg35XvpdPvD3jse5Q9y5/4A+oIy5w
       "]], 
      Line3DBox[{8, 575, 2519, 23, 276, 2290, 38, 602, 2546, 53, 327, 68, 
       2107, 350, 83, 2121, 643, 98, 2136, 399, 2376, 113, 428, 2394, 128, 
       451, 2415, 143, 692, 2623, 158, 711, 173, 2154, 510, 188, 2168, 732, 
       203, 2182, 745, 218}], 
      Line3DBox[{257, 255, 2528, 584, 259, 2946, 1319, 304, 2555, 611, 307, 
       627, 2571, 336, 1341, 2966, 377, 652, 2585, 380, 2599, 668, 408, 2613, 
       682, 437, 2957, 1369, 469, 2854, 1262, 493, 720, 2640, 496, 1290, 1182,
        2833, 528, 1397, 2983, 552, 555}], Line3DBox[CompressedData["
1:eJwVzj8vQ2EYhvFHQnuSShWJwUaJLo3wAWq0Ie1mEpu0qc3UpBKLSbqZ1eIL
oFabmqydqv4kEkk3gxj8znDlut/7Oe/znqXD42pzIiL2sDgVMcRvJuKVW7mI
P/ld/sEHznQlzuvz2YgZLvA15uQvnucuL+AJk9MRy7oNFFFx/9KeHXnVfJfX
eKSrykeo4UWXuFvmB9R1Y27wuW978ibazh2c4kK/b/+VvGX27dxN300iVnCb
vsl3PDDfxiPunWe9lZj15HXOIoOCvp/+k++e+cT+G3tH8oHujT/xDwR9KQQ=

       "]], 
      Line3DBox[{1307, 1506, 1787, 1507, 2941, 1790, 1512, 1527, 1513, 1321, 
       1552, 1807, 3034, 1553, 1810, 897, 1095, 896, 1213, 977, 2996, 1586, 
       1573, 1343, 1616, 1830, 1617, 1833, 3043, 1622, 1642, 1003, 2785, 1004,
        943, 1122, 942, 3072, 1843, 1666, 1681, 3009, 1667, 1371, 1699, 1856, 
       3053, 1700, 2086, 1273, 1274, 1029, 1032, 961, 2840, 1194, 1193, 2057, 
       1740, 3020, 1876, 1741, 1399, 2985, 1764, 1889, 1765, 1769}], 
      Line3DBox[CompressedData["
1:eJwV0D1LAlAYhuG3wcqUIMqtJZASV/sBtbUFkbg0uaura1B/oN/gx+YcpQ7Z
UlFCH5O6ahREY0vU5XBzP+d5zzkczla5dlRdiIhDbCYipvhdjHhLRczkP/mD
f9DRfXIeG/q1pYiRLiOvyy20kbVucgOryxH3nEhHPHDBbBt77jjmS+dz+qKc
5xJX8CI/I+ncK3fRw6nZNfedu+JdnOkucKM75xN3N3nf7EvXkr/lHW/J4UAe
z9+OCQa4xZ29XXvT9qSwgifrR33RfCjX3T3joa6se5//D/4BbpUvsQ==
       "]], 
      Line3DBox[CompressedData["
1:eJwVzz9LQgEUhvHjUEkFOdnU4BTRUvRnryWcRAdpacmcAoVqaRKLWloSF5si
XKxFIhqcQvoCfYC+QUKEQ0hLvzs8vOd9zrnce3OH9VItFRFFnE9FDFCeiRjP
RXxMRxzrL8hz6+mIb35NVrlnrJh/7AZuf+0uzReo2PXRNO8i424BB9wj3t1u
8W3PFfRu8m7uWq8jrz/gj+u5q3Fn8hR7/Ox8xL080fftttFxu8PdYZH/1Df5
Db2NZXOVf+WPkv/hWqiYs3YteYtV7ib5fnehT8xLuMITN5JDZNDAyLNv8kv+
A8AMK98=
       "]], Line3DBox[CompressedData["
1:eJwVzitLw3EYxfFnQR2YtjKTYBMxumFeXFFWhgaDYRpEV1QwLexSTLqiyTCQ
LRlMA0FkL0DfgDAYCMJAvMAQg59/+HKec87zuyztHpUPUxGxgbOZiAEqcxEv
sxE38xEH/D1Ksg/+QV7lv/iVdMQn/cZU19O1zGM00UDWzq08Q3ec62Not6Dr
yDf5bvKurM3XUOLf+L6dHt6xLT+lo+R+3Qk9xpZ8HVeyonPXWJDnZWvmDpbN
P/oc3de9Yg9VXOLPzgVdpee4s5vif82LaGGS/BsZPOvrSea+R/qEf60AL6g=

       "]], Line3DBox[CompressedData["
1:eJwVzj1IwlEUhvFT0Ae0WUNN0RjSKA6NjS7VFEQELVFS0ZYFgpM6BBK6JAQO
QaCrk+ASQasNrULQFLRZREH+/sPDe9/n3HO5Kwdn26cTEbGJq6mIHnZmIl6m
I1pzESd6Fzmuz91xh/qXnp6NGMlv/PAd86rzOyooY8GdB35e7ttrI8s3uC3n
qr17WdHPkXPumP/xbfmBPf5SviVv8wV5gV1+Hbfchr0mlvgsd8Nl9AZW9UXU
uLz5EMc4Sv6Bf3fqck2+unMtJ/VfuYwiV5afeEYKA66UOO8+yieMAe1tL8s=

       "]], Line3DBox[CompressedData["
1:eJwVzi9LQ3EUh/EzwT/sCsbFzWFeMIpRVMQwFmyCyIQFnWDdXVkSp4YFi6LD
YNGggitaxVcgDIOwlyAKNvFzw8M53+ece39ndnu/1sxFRBXpeMQLNicjfpKI
z4mIA3mAKvfFvXEN+RFjUxHP8sx0xLF5F3X+Hkf6ZZTsFLHF3eHVPxb5S99t
yDfZm9yJnGJdvsYf92SvxbXVFKt84q2+2pJ3zNZwbneJu0CZH8kr/IJ8hoq+
yQ/4PXWe62E3u8/sKrsHFe4UD/YSOW82Jx9mt3Pf6gcK6OCW+7Xzrh/iH2kp
K+Q=
       "]], 
      Line3DBox[{1405, 1469, 1886, 1760, 2981, 1395, 1463, 1873, 3058, 1736, 
       1385, 1175, 1176, 2829, 832, 1075, 831, 1256, 1255, 1377, 1453, 3014, 
       1853, 1695, 1367, 1447, 3005, 1678, 1661, 1357, 3048, 932, 1115, 802, 
       1060, 2796, 801, 1638, 1612, 2972, 1349, 1437, 1827, 1609, 1339, 1431, 
       1583, 3062, 772, 1045, 771, 883, 882, 1327, 1423, 2994, 1804, 1547, 
       1317, 1417, 1524, 1501, 1304, 3027, 1411, 1784, 1497, 1499}], 
      Line3DBox[CompressedData["
1:eJwVzjFLQnEUhvEjZQXlB2hUolH8ANHYEkY4tQUuRkMaNN8KnESzhqBF0yWa
XIxqao32xqgkaHRryKV+Dg/v/33OOZebLVdLB6mI2EaSjnjC7nzEaC7iZjHi
SH9EiXvhrrl9fXYhIo8ZpDHh78zb9r5xhhZyZkM+K8vuBni2u27W43f0pn4r
23qCLe8H8z/+Xo6xx5/Ir+n3+WOZoMIX0eE23HWxwm9yl9yafoXC9B9wwR2a
f6KGKvrImPVkwe45Mt5L3Kr3qZuG/MEHlvHK1eWvnTf5jn/dKi0d
       "]]}, {
      Line3DBox[{2098, 2265, 2508, 1407, 2507, 2266, 2510, 3024, 2190, 2509, 
       2268, 2512, 3025, 2191, 2511, 2876, 2937, 2514, 2192, 2513, 2877, 2938,
        2516, 2193, 2515, 2879, 2939, 2518, 2194, 2517, 3026, 2271, 2520, 
       2195, 2519, 2272, 2522, 2858, 2987, 2521, 2274, 2524, 3027, 2196, 2523,
        2276, 2526, 3028, 2197, 2525, 2278, 2528, 2198, 2527, 2881, 2940, 
       2530, 2199, 2529, 2882, 2941, 2532, 2200, 2531, 3029, 2281, 2533, 2201,
        2282}], 
      Line3DBox[{2099, 2267, 2859, 2986, 2284, 2269, 1414, 2285, 2270, 2942, 
       2202, 2286, 2878, 2943, 2203, 2287, 2880, 2944, 2204, 2288, 1492, 2205,
        2289, 2989, 2273, 2206, 2290, 2275, 2860, 2988, 2291, 2277, 1417, 
       2292, 2279, 2945, 2207, 2293, 2280, 2946, 2208, 2294, 2883, 2947, 2209,
        2295, 1513, 2210, 2296, 2990, 2283, 2211, 2297}], 
      Line3DBox[{2100, 2298, 2535, 2861, 2991, 2534, 2299, 2537, 2862, 2992, 
       2536, 2300, 2539, 3030, 2212, 2538, 2884, 2948, 2541, 2213, 2540, 3031,
        2301, 2543, 2214, 2542, 3032, 2302, 2545, 2215, 2544, 3033, 2303, 
       2547, 2216, 2546, 2304, 2549, 2863, 2993, 2548, 2305, 2551, 2864, 2994,
        2550, 2306, 2553, 1424, 2552, 2307, 2555, 2217, 2554, 1551, 2557, 
       2218, 2556, 3034, 2308, 2559, 2219, 2558, 3035, 2309, 2560, 2220, 
       2310}], Line3DBox[{2115, 2335, 2336, 3036, 2114, 2337, 1589, 2116, 
       2339, 2962, 2890, 2117, 2892, 2963, 2341, 2118, 2894, 2964, 2343, 2119,
        1600, 2345, 2120, 2999, 2347, 2348, 2121, 2350, 2351, 3041, 2122, 
       2353, 1609, 2123, 2355, 2965, 2900, 2124, 2357, 2966, 2358, 2125, 2903,
        2967, 2360, 2126, 1616, 2363, 2127, 3000, 2365, 2366, 2128}], 
      Line3DBox[CompressedData["
1:eJwV0dcynHEcBuC/E1a5BYTod2EIos64BC3qOiKZcexykEKUA7236L0L0csd
5NmDZ/b99n1/883OZtR11kbjQgg91EZCGE8KYZIJUqnnL0kpIfTpCxNDmPI8
wzRpdCTbcCP32xTZzMrzzJFONNZzKw/YFNssyEss0qv74LOBf3y3+WSzLK8Q
7/1dNhlyI3f8sCmxWZXXWSOTJu75qS/Vd7tLcL/huz985AsP/LIps9mUt9ki
i2YeSXY3aPPZZsfzHrtk08ITQ/py/b58yAE5dMZ+L8/yb5sKmyP5hGNyaeWF
YX2l/lQ+I+K9X93myW28MmJTZXMuX3JBPu28Maqv1n9zl+j+2ndXFMT+I94Z
s6mx+Q/rxE27
       "]], 
      Line3DBox[{2143, 2368, 2588, 1623, 2142, 2367, 2587, 3043, 2905, 2141, 
       2364, 2586, 3042, 2904, 2140, 2362, 2585, 2361, 2139, 2902, 2973, 2584,
        2359, 2138, 2901, 2972, 2583, 2356, 2137, 2899, 2971, 2582, 2354, 
       2136, 2352, 2581, 3040, 2898, 2135, 2349, 2580, 3039, 2897, 2134, 2346,
        2579, 3038, 2896, 2133, 2344, 2578, 3037, 2895, 2132, 2893, 2970, 
       2577, 2342, 2131, 2891, 2969, 2576, 2340, 2129, 2889, 2968, 2575, 2338,
        2370}], Line3DBox[CompressedData["
1:eJwVz0dKRGEQReFyZtqEY3N2GdKIiog0D8WZgmNzanNuc9ZdtLbZregejN8b
HG7VPfXDe1XJaGakJCISZEsjpsojplGNcTRWRHyhsyxiwj6JGozpPlDwJsPN
6GZRi2/9nLzjurh58wIW9XVp4p7r5nLmJeS4ermMItfDrZh/9KuyAWt44Hq5
gn7dvpF+IzbxyPVxW+ZtNGEnTbe/6Od27XtoRh6f+ifvBrh9+wFa8Kc/lM9c
ljsyH6MVJ3jRJ/pT81n6D+7b5DleuUHuwhyVEZeyHVd444a4ovtr+w06cIt3
bpj7B5GIOKI=
       "]], 
      Line3DBox[{2145, 2385, 2867, 3001, 2409, 2387, 2868, 3002, 2410, 2389, 
       2953, 2247, 2411, 2906, 2954, 2248, 2412, 2907, 2955, 2249, 2413, 3007,
        2393, 2250, 2414, 3008, 2395, 2251, 2415, 2397, 2869, 3004, 2416, 
       2399, 2870, 3005, 2417, 2401, 2956, 2252, 2418, 2403, 2957, 2253, 2419,
        2908, 2958, 2254, 2420, 3009, 2406, 2255, 2421, 3010, 2408, 2256, 
       2422}], Line3DBox[{2146, 2423, 2802, 2871, 3011, 2617, 2424, 2845, 
       2872, 3012, 2618, 2425, 2846, 1451, 2619, 2909, 2959, 2847, 2257, 2620,
        3049, 2426, 2848, 2258, 2621, 3050, 2427, 2849, 2259, 2622, 3051, 
       2428, 2850, 2260, 2623, 2429, 2851, 2873, 3013, 2624, 2430, 2852, 2874,
        3014, 2625, 2431, 2853, 2875, 3015, 2626, 2432, 2854, 2261, 2627, 
       3052, 2433, 2855, 2262, 2628, 3053, 2434, 2856, 2263, 2629, 3054, 2435,
        2803, 2264, 2147}], 
      Line3DBox[{501, 1131, 499, 1278, 1864, 723, 1276, 497, 1274, 721, 1271, 
       495, 2085, 1269, 719, 1266, 493, 1264, 717, 1261, 2082, 491, 1259, 715,
        1256, 489, 1254, 713, 1862, 1251, 487, 1249, 711, 1246, 485, 1244, 
       1861, 709, 1241, 483, 1239, 707, 1236, 481, 2074, 1234, 705, 1231, 
       479}], Line3DBox[{2162, 2464, 2804, 2465, 2857, 3055, 2161, 2466, 2805,
        2467, 3056, 2163, 2468, 2809, 2974, 2911, 2164, 2912, 3084, 2812, 
       2469, 2165, 2913, 3085, 2815, 2470, 2166, 3018, 2471, 2818, 2472, 2167,
        3019, 2473, 2821, 2474, 2168, 2475, 2824, 2476, 3057, 2169, 2477, 
       2827, 2478, 3058, 2170, 2479, 2830, 2975, 2914, 2171, 2480, 2833, 2481,
        2172, 2915, 3088, 2836, 2482, 2173, 3020, 2483, 2839, 2484, 2174, 
       3021, 2485, 2842, 2486, 2175}], 
      Line3DBox[{2189, 2506, 2505, 3023, 2188, 2504, 2985, 2924, 2187, 2503, 
       2984, 2923, 2186, 2502, 2983, 2501, 2185, 2922, 2982, 2500, 2184, 2921,
        2981, 2499, 2183, 3060, 2498, 2497, 2182, 2496, 2495, 3022, 2181, 
       2494, 2980, 2920, 2180, 2493, 2979, 2919, 2179, 2492, 2978, 2918, 2178,
        2917, 2977, 2491, 2177, 2916, 2976, 2489, 2176, 3059, 2488, 2487, 
       2490}], Line3DBox[{316, 853, 286, 849, 1558, 314, 1083, 289, 1939, 855,
        317, 1085, 291, 1941, 859, 319, 1086, 2023, 293, 863, 321, 1087, 2024,
        295, 867, 323, 1088, 297, 871, 325, 1565, 1089, 299, 875, 327, 1090, 
       301, 879, 1568, 329, 1091, 303, 883, 331, 1092, 305, 1953, 887, 333, 
       1093, 307, 891, 335, 1094, 2025, 309, 895, 337, 1095, 311, 899, 339, 
       1572, 1096, 313, 903, 341}], Line3DBox[CompressedData["
1:eJwVz8dRw1AUBdDnbEm2yTnMUAQ5LwhrhpztAqAAmoBSwIFcFqw5LP6cq3u/
NPZc6/7gLhcRTWc2iXhIIyrMscpDdrOI+WrEs5zo8kz5oz+SF2wvzHQFPup3
nGN50dbmrud8LaIo19w74ZKtw6lyRIl1/SmX9V22vdPQleU+nnHFVvCdntyv
q3CA51y1vXLQc5VDvGDPd9Zsb/KwLuEIf/WX8rrtnaO6lE/6PedK3rB9cMyW
cZzX3NR/ct+9ot9TkydsN9yyfbFjm9TV//8jb7ltK7n/LU/rGpxhky3nD8H7
IR0=
       "]], 
      Line3DBox[{476, 1128, 473, 1216, 1858, 699, 1219, 474, 2066, 1221, 701, 
       1224, 477, 2068, 1226, 703, 1229, 2071}], Line3DBox[CompressedData["
1:eJwV0MVKBFAYhuEzKMY4NoqiG2/GbvcuxO6OWdvdHSs7L0NvyETxmcXH+8UP
B05Z21DzYCSEEKeL9BCuoiF80CxfjnP4kRHCMLWnhXCpe6d5fQUu4Kftkx+k
DjfX+E2Ltkpcwi83P/wQdbq5wV9q1UdiIVTxy+7+cJi63NxisGfZV2zV8ipG
dCN8t5s7TJLX9DX8OibLo3yPfYx/pRTasNXqNzFVHuN73dxjurylr+O3MSpn
e3cE+9w86GP8jq2e38VMeZzvtz9itrynb+D38VvOoQl5wM0T5skHtkb+EPPl
ycTf2Z+xQM717pGtST7GQt1U4u/cvGCRfKJv5k+xWJ5O/Jt9nH+jEjqztejP
sVSe4eP0Dw7KPfU=
       "]]}}},
   VertexNormals->CompressedData["
1:eJx0fXlcTV37fqYosyhERCophURUSyGEJEOjMqYySyQVQskQJVIphSIVJUXK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    "]],
  Axes->True,
  ImageSize->{176.96033432547443`, Automatic},
  PlotRange->{{-2.9999999999997553`, 2.9999999999994533`}, {-2.99999999999968,
    2.99999999999968}, {0., 11.999999142857142`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.687247768044415*^9, {3.687247807861052*^9, 3.6872478183413057`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Punto el\[IAcute]ptico P = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox["5"], ",", "0", ",", 
     FractionBox["\[Pi]", "2"]}], "}"}], 
   "\[InvisibleSpace]", "\<\" con curvaturas principales \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox["1", "3"]}], "\[InvisibleSpace]", "\<\" y \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox["4", "27"]}]}],
  SequenceForm[
  "Punto el\[IAcute]ptico P = ", {5^Rational[1, 2], 0, Rational[1, 2] Pi}, 
   " con curvaturas principales ", 
   Rational[-1, 3], " y ", 
   Rational[-4, 27]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.687247371756373*^9, 3.687247406650037*^9}, {
   3.687247486691237*^9, 3.687247491952837*^9}, 3.6872475235236683`*^9, {
   3.687247587566863*^9, 3.687247692304894*^9}, {3.687247732324046*^9, 
   3.68724774058215*^9}, 3.687247790892961*^9, {3.6872483315402412`*^9, 
   3.6872483562266903`*^9}, 3.68724847229005*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Punto hiperb\[OAcute]lico P = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"1", ",", "0", ",", "\[Pi]"}], "}"}], 
   "\[InvisibleSpace]", "\<\" con curvaturas principales \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", "1"}], "\[InvisibleSpace]", "\<\" y \"\>", 
   "\[InvisibleSpace]", "2"}],
  SequenceForm[
  "Punto hiperb\[OAcute]lico P = ", {1, 0, Pi}, 
   " con curvaturas principales ", -1, " y ", 2],
  Editable->False]], "Print",
 CellChangeTimes->{{3.687247371756373*^9, 3.687247406650037*^9}, {
   3.687247486691237*^9, 3.687247491952837*^9}, 3.6872475235236683`*^9, {
   3.687247587566863*^9, 3.687247692304894*^9}, {3.687247732324046*^9, 
   3.68724774058215*^9}, 3.687247790892961*^9, {3.6872483315402412`*^9, 
   3.6872483562266903`*^9}, 3.687248472291013*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Punto parab\[OAcute]lico P = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox["3"], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "\[Pi]"}], "3"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" con curvaturas principales \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["6"]]}], "\[InvisibleSpace]", "\<\" y \"\>", "\[InvisibleSpace]",
    "0"}],
  SequenceForm[
  "Punto parab\[OAcute]lico P = ", {3^Rational[1, 2], 0, Rational[-2, 3] Pi}, 
   " con curvaturas principales ", -6^Rational[-1, 2], " y ", 0],
  Editable->False]], "Print",
 CellChangeTimes->{{3.687247371756373*^9, 3.687247406650037*^9}, {
   3.687247486691237*^9, 3.687247491952837*^9}, 3.6872475235236683`*^9, {
   3.687247587566863*^9, 3.687247692304894*^9}, {3.687247732324046*^9, 
   3.68724774058215*^9}, 3.687247790892961*^9, {3.6872483315402412`*^9, 
   3.6872483562266903`*^9}, 3.687248472293141*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Punto umbilical P = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{
     SqrtBox["7"], ",", "0", ",", 
     RowBox[{"-", 
      FractionBox["\[Pi]", "3"]}]}], "}"}], 
   "\[InvisibleSpace]", "\<\" con curvaturas principales \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["10"]]}], "\[InvisibleSpace]", "\<\" y \"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"-", 
    FractionBox["1", 
     SqrtBox["10"]]}]}],
  SequenceForm[
  "Punto umbilical P = ", {7^Rational[1, 2], 0, Rational[-1, 3] Pi}, 
   " con curvaturas principales ", -10^Rational[-1, 2], 
   " y ", -10^Rational[-1, 2]],
  Editable->False]], "Print",
 CellChangeTimes->{{3.687247371756373*^9, 3.687247406650037*^9}, {
   3.687247486691237*^9, 3.687247491952837*^9}, 3.6872475235236683`*^9, {
   3.687247587566863*^9, 3.687247692304894*^9}, {3.687247732324046*^9, 
   3.68724774058215*^9}, 3.687247790892961*^9, {3.6872483315402412`*^9, 
   3.6872483562266903`*^9}, 3.6872484722940483`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{916, 753},
WindowMargins->{{8, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 96, 1, 76, "Title"],
Cell[CellGroupData[{
Cell[688, 27, 149, 3, 67, "Section"],
Cell[CellGroupData[{
Cell[862, 34, 96, 1, 34, "Subsection"],
Cell[961, 37, 887, 27, 73, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[1885, 69, 109, 1, 26, "Subsection"],
Cell[1997, 72, 529, 10, 86, "Text"],
Cell[2529, 84, 1833, 55, 103, "Input"],
Cell[4365, 141, 191, 4, 26, "Text"],
Cell[4559, 147, 856, 26, 43, "Input"],
Cell[5418, 175, 1071, 28, 58, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[6526, 208, 170, 2, 26, "Subsection"],
Cell[6699, 212, 338, 6, 26, "Text"],
Cell[7040, 220, 1265, 36, 88, "Input"],
Cell[8308, 258, 337, 7, 56, "Text"],
Cell[8648, 267, 1351, 37, 88, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[10036, 309, 172, 2, 26, "Subsection"],
Cell[10211, 313, 362, 6, 26, "Text"],
Cell[10576, 321, 1272, 34, 73, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[11885, 360, 287, 4, 26, "Subsection"],
Cell[12175, 366, 751, 13, 56, "Text"],
Cell[12929, 381, 1863, 44, 88, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[14829, 430, 266, 3, 26, "Subsection"],
Cell[15098, 435, 785, 15, 41, "Text"],
Cell[15886, 452, 1971, 51, 133, "Input"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17906, 509, 263, 5, 67, "Section"],
Cell[CellGroupData[{
Cell[18194, 518, 360, 6, 34, "Subsection"],
Cell[18557, 526, 1140, 35, 89, "Text"],
Cell[19700, 563, 1973, 61, 118, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[21710, 629, 356, 6, 28, "Subsection"],
Cell[22069, 637, 579, 15, 30, "Text"],
Cell[22651, 654, 1968, 60, 163, "Input"],
Cell[24622, 716, 787, 17, 32, "Text"],
Cell[25412, 735, 805, 21, 43, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[26254, 761, 462, 8, 28, "Subsection"],
Cell[26719, 771, 804, 18, 62, "Text"],
Cell[27526, 791, 1189, 36, 73, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[28752, 832, 326, 4, 28, "Subsection"],
Cell[29081, 838, 1633, 42, 118, "Text"],
Cell[30717, 882, 1865, 50, 88, "Input"],
Cell[32585, 934, 900, 21, 43, "Text"],
Cell[33488, 957, 1524, 46, 58, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[35049, 1008, 487, 8, 27, "Subsection"],
Cell[35539, 1018, 3497, 107, 261, "Text"],
Cell[39039, 1127, 2306, 66, 148, "Input"],
Cell[41348, 1195, 626, 8, 26, "Text"],
Cell[41977, 1205, 1802, 58, 133, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[43816, 1268, 551, 9, 26, "Subsection"],
Cell[44370, 1279, 1410, 38, 85, "Text"],
Cell[45783, 1319, 910, 23, 43, "Input"],
Cell[46696, 1344, 426, 10, 58, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[47159, 1359, 657, 9, 26, "Subsection"],
Cell[47819, 1370, 1271, 23, 116, "Text"],
Cell[49093, 1395, 1083, 24, 118, "Input"],
Cell[50179, 1421, 818, 12, 26, "Text"]
}, Closed]],
Cell[CellGroupData[{
Cell[51034, 1438, 766, 12, 26, "Subsection"],
Cell[51803, 1452, 774, 12, 26, "Text"],
Cell[52580, 1466, 1898, 55, 103, "Input"],
Cell[54481, 1523, 1631, 41, 61, "Text"],
Cell[56115, 1566, 643, 22, 43, "Input"],
Cell[56761, 1590, 3237, 77, 76, "Text"],
Cell[60001, 1669, 1065, 34, 73, "Input"],
Cell[61069, 1705, 1362, 20, 41, "Text"],
Cell[62434, 1727, 1205, 33, 43, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[63676, 1765, 732, 10, 26, "Subsection"],
Cell[64411, 1777, 1571, 29, 146, "Text"],
Cell[CellGroupData[{
Cell[66007, 1810, 117, 1, 24, "Subsubsection"],
Cell[66127, 1813, 157029, 2584, 295, "Output"],
Cell[CellGroupData[{
Cell[223181, 4401, 1002, 24, 40, "Print"],
Cell[224186, 4427, 838, 17, 20, "Print"],
Cell[225027, 4446, 1010, 23, 43, "Print"],
Cell[226040, 4471, 1048, 26, 43, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
