(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    903970,      40176]*)
(*NotebookOutlinePosition[    904942,      40207]*)
(*  CellTagsIndexPosition[    904898,      40203]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["CURVAS", "Subsection"]], "Title",
  CellChangeTimes -> {3.492180376609375*^9, {3.685603478337912*^9, \
3.685603478424404*^9}}],

Cell[CellGroupData[{

Cell["Curvas PLANAS", "Section",
  CellChangeTimes -> {{3.685606329799803*^9, 3.68560634340769*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Traza de curvas planas en forma impl\[IAcute]cita", \
"Subsubsection"]], "Subsection",
  CellChangeTimes -> {{3.6856034991870317`*^9, 3.6856035003025703`*^9}, \
{3.685605904034265*^9, 3.6856059049964943`*^9}, {3.6856065134216137`*^9, \
3.6856065142355633`*^9}, {3.6856084332192507`*^9, 3.685608433734516*^9}}],

Cell["\<\
Comenzamos con un trazado b\[AAcute]sico de una elipse.
Ejercicio: Calcula su centro y dibuja sus ejes.\
\>", "Text",
  CellChangeTimes -> {{3.685603791567236*^9, 3.685603825738256*^9}, \
{3.685603956998713*^9, 3.685604010892329*^9}, {3.685604856888465*^9, \
3.685604863759769*^9}}],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\n", 
    \(Needs["\<Graphics`ImplicitPlot`\>"]\), "\n", 
    \(f[x_, y_] := x^2 + 4  y^2 - 4  x - 8  y + 7\), "\n", 
    \(ImplicitPlot[
      f[x, y] \[Equal] 0, {x, 0, 4}, {y, 0, 2}]\), "\[IndentingNewLine]", 
    \(\(("\<{x,0,4},{y,0,2} define el rango m\[AAcute]ximo de los ejes \
coordenados.\>")\)\)}], "Input",
  CellChangeTimes -> {3.685603513893895*^9, {3.685603833407852*^9, \
3.685603953137751*^9}, {3.685603996979679*^9, 3.685603998543861*^9}, \
{3.6856043713166018`*^9, 3.685604384135099*^9}, {3.6856047344361753`*^9, \
3.685604828762298*^9}, {3.685605102541917*^9, 3.685605151668202*^9}, \
3.6856063788796873`*^9}],

Cell["\<\
Completando cuadrados, observamos que f[x, y] = (x - 2)^2 + 4 (y - \
1)^2 - 1. Pintamos los ejes.\
\>", "Text",
  CellChangeTimes -> {{3.685604438038924*^9, 3.685604477597623*^9}, \
{3.685604520158362*^9, 3.6856045245107813`*^9}, {3.685604839328637*^9, \
3.685604839863587*^9}}],

Cell[BoxData[
    \(\((\((x\  - \ 2)\)^2\  + \ 4\ \((y\  - \ 1)\)^2\  - \ 1)\)\  - \ 
        f[x, \ y]\  // \ Expand\)], "Input",
  CellChangeTimes -> {{3.685604993543454*^9, 3.685604996227517*^9}, \
3.685606378882783*^9, {3.685606476346321*^9, 3.6856064763481073`*^9}}],

Cell[BoxData[
    \(ImplicitPlot[{f[x, \ y]\  == \ 1, \ x\  == \ 2, \ y\  == \ 1}, \ {x, \ 
        0, \ 4}, \ {y, \ \(-0\), \ 2}]\)], "Input",
  CellChangeTimes -> {{3.6856042704785213`*^9, 3.6856043612028913`*^9}, \
{3.685604489604817*^9, 3.6856045546388474`*^9}, {3.685604902104785*^9, \
3.6856049052314587`*^9}, {3.68560502983642*^9, 3.6856050415100327`*^9}, \
{3.6856053189350443`*^9, 3.685605360386044*^9}, 3.6856063788840647`*^9, \
{3.685606476351452*^9, 3.6856064763539886`*^9}}],

Cell["\<\
Veamos algunas variantes.
Thickness[0.005] da grosor a la curva. 
Dashing[{0.04,0.02}] dibuja la curva a trazos, el primer n\[UAcute]mero \
indica la longitud de los trazos  negros. \
\>", "Text",
  CellChangeTimes -> {{3.685604438038924*^9, 3.685604477597623*^9}, \
{3.685604520158362*^9, 3.6856045245107813`*^9}, {3.685604839328637*^9, \
3.685604839863587*^9}, {3.685605063527129*^9, 3.6856050685896893`*^9}, \
{3.68560517974715*^9, 3.685605191881126*^9}}],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\n", 
    \(f[x_, y_] := x^2 + y^2\), "\n", 
    \(g[x_, y_] := x - 4  y^2\), "\n", 
    \(ImplicitPlot[{f[x, y] \[Equal] 1, g[x, y] \[Equal] 0}, {x, \(-1.5\), 
        1.5}, {y, \(-1\), 1}, 
      PlotStyle \[Rule] {{Thickness[0.005], 
            Dashing[{0.04, 0.02}]}, {Thickness[
              0.019]}}]\), "\[IndentingNewLine]", 
    \(\)}], "Input",
  CellChangeTimes -> {3.685603513893895*^9, {3.685605077532242*^9, \
3.685605077850473*^9}, {3.685605214519677*^9, 3.68560522078924*^9}, \
{3.685605250844993*^9, 3.685605251384313*^9}, 3.685606378886443*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Traza de curvas planas en param\[EAcute]tricas ", \
"Subsubsection"]], "Subsection",
  CellChangeTimes -> {3.685605910957656*^9, {3.685606516051189*^9, \
3.6856065168352013`*^9}, {3.6856084359830647`*^9, 3.685608436598751*^9}}],

Cell["Comenzamos con un trazado b\[AAcute]sico.", "Text",
  CellChangeTimes -> {{3.685603774036499*^9, 3.68560378373326*^9}, \
3.68560528784177*^9}],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\n", 
    \(alpha1[t_] := {4  E^\((\(-t\))\) Cos[3  t], 
        4  E^\((\(-t\))\) Sin[3  t]}\), "\n", 
    \(ParametricPlot[alpha1[t], {t, 0, \ Pi}\ ]\)}], "Input",
  CellChangeTimes -> {{3.685603640611148*^9, 3.685603758166849*^9}, \
{3.685605291153056*^9, 3.685605307208197*^9}, {3.685605369259153*^9, \
3.6856053713720922`*^9}, {3.685605453073208*^9, 3.685605475374742*^9}}],

Cell["\<\
Observamos su movimiento, fijamos la ventana con \
PlotRange\[Rule]{{-2,4},{-1,3}} y dibujamos intervalos de tiempo cada vez \
mayores.
Prueba a hacerlo con Do o For.\
\>", "Text",
  CellChangeTimes -> {{3.685603774036499*^9, 3.68560378373326*^9}, \
3.68560528784177*^9, {3.685605394882568*^9, 3.685605406383677*^9}, \
{3.685605507202362*^9, 3.685605548425939*^9}, {3.685605749501852*^9, \
3.685605757227784*^9}}],

Cell[BoxData[{
    \(\(ParametricPlot[alpha1[t], {t, 0, 1}, 
        PlotRange \[Rule] {{\(-2\), 4}, {\(-1\), 3}}];\)\), "\n", 
    \(\(ParametricPlot[alpha1[t], {t, 0, 2}, 
        PlotRange \[Rule] {{\(-2\), 4}, {\(-1\), 3}}];\)\), "\n", 
    \(\(ParametricPlot[alpha1[t], {t, 0, 3}, 
        PlotRange \[Rule] {{\(-2\), 4}, {\(-1\), 3}}];\)\), "\n", 
    \(\(ParametricPlot[alpha1[t], {t, 0, 4}, 
        PlotRange \[Rule] {{\(-2\), 4}, {\(-1\), 3}}];\)\)}], "Input",
  CellChangeTimes -> {{3.685605438407598*^9, 3.685605438752228*^9}, \
{3.6856054899999037`*^9, 3.68560550137193*^9}, {3.6856055507642117`*^9, \
3.685605611645834*^9}, {3.685605662101247*^9, 3.685605718953081*^9}}],

Cell["\<\
Veamos algunas variantes.
Thickness[0.005] da grosor a la curva. 
Dashing[{0.04,0.02}] dibuja la curva a trazos, el primer n\[UAcute]mero \
indica la longitud de los trazos  negros. \
\>", "Text",
  CellChangeTimes -> {{3.685604438038924*^9, 3.685604477597623*^9}, \
{3.685604520158362*^9, 3.6856045245107813`*^9}, {3.685604839328637*^9, \
3.685604839863587*^9}, {3.685605063527129*^9, 3.6856050685896893`*^9}, \
{3.68560517974715*^9, 3.685605191881126*^9}}],

Cell[BoxData[{
    \(\(\(Clear["\<Global`*\>"]\)\(\n\)
    \)\), "\n", 
    \(alpha1[t_] := {E^\((\(-t\))\)*Cos[3  t], 
        E^\((\(-t\))\)*Sin[3  t]}\), "\n", 
    \(alpha2[t_] := {\(-E^\((\(-t\))\)\)*Sin[3  t], 
        E^\((\(-t\))\)*Cos[3  t]}\), "\n", 
    \(\(ParametricPlot[Evaluate[{alpha1[t], alpha2[t]}], {t, 1, \ 4  Pi}, 
        AspectRatio \[Rule] Automatic\ ];\)\), "\n", 
    \(\(ParametricPlot[{alpha1[t], alpha2[t]}, {t, 1, 4  Pi}\ , 
        PlotRange \[Rule] All];\)\), "\n", 
    \(\(ParametricPlot[{alpha1[t], alpha2[t]}, {t, 1, 4  Pi}\ , 
        PlotRange \[Rule] {{\(- .1\), 0.1}, {\(- .05\), 0.15}}, 
        AspectRatio \[Rule] Automatic];\)\)}], "Input",
  CellChangeTimes -> {{3.685603640611148*^9, 3.6856036970468407`*^9}, \
{3.685606014984749*^9, 3.68560610277113*^9}, {3.685606136427828*^9, \
3.685606202538992*^9}, {3.685606234989785*^9, 3.685606294484849*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Vector tangente y normal ", "Subsubsection"]], \
"Subsection",
  CellChangeTimes -> {3.685605910957656*^9, {3.685606516051189*^9, \
3.6856065168352013`*^9}, {3.6856084359830647`*^9, 3.685608436598751*^9}, \
{3.6856203867066603`*^9, 3.685620416799171*^9}, {3.685620486266809*^9, \
3.685620530177698*^9}, {3.68562195686178*^9, 3.685621959380312*^9}, \
{3.685623010783279*^9, 3.685623012831394*^9}, 3.6856237189718103`*^9}],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\[IndentingNewLine]", 
    \(alpha[
        t_] := \((Sin[3  t] + 4)\)*{Cos[t], 
          Sin[t]}\), "\[IndentingNewLine]", 
    \(traza = 
      ParametricPlot[alpha[t], {t, \(-Pi\), Pi}, 
        PlotStyle -> Dashing[{0.02}]]\)}], "Input",
  CellChangeTimes -> {{3.685620577803667*^9, 3.6856206866661177`*^9}, \
{3.685620949867936*^9, 3.685621013349968*^9}, {3.685621190235589*^9, \
3.685621198201236*^9}, {3.685621515342474*^9, 3.685621519014732*^9}}],

Cell["\<\
Vector tangente y vector normal (previa comprobaci\[OAcute]n de que \
N(t) apunta en la misma direcci\[OAcute]n que T\[CloseCurlyQuote](t)).\
\>", \
"Text",
  CellChangeTimes -> {{3.6856207129747458`*^9, 3.685620724973321*^9}, \
{3.685620774020887*^9, 3.685620776930646*^9}, {3.685622301773122*^9, \
3.68562253641819*^9}, {3.6856225930266333`*^9, 3.685622612011215*^9}, \
{3.685622648159897*^9, 3.68562270374971*^9}}],

Cell[BoxData[{
    \(T1[t_] := \(alpha'\)[t]/Sqrt[\(alpha'\)[t] . \(alpha'\)[t]] // 
        Simplify\), "\[IndentingNewLine]", 
    \(N1[t_] := \(T1'\)[t]/Sqrt[\(T1'\)[t] . \(T1'\)[t]] // 
        Simplify\), "\[IndentingNewLine]", 
    \(T1[t] . N1[t] // Simplify\)}], "Input",
  CellChangeTimes -> {{3.68562073393187*^9, 3.685620797960215*^9}, \
{3.6856210778874073`*^9, 3.6856211691802483`*^9}}],

Cell["Representaciones gr\[AAcute]ficas", "Text",
  CellChangeTimes -> {{3.6856207129747458`*^9, 3.685620724973321*^9}, \
{3.685620774020887*^9, 3.685620776930646*^9}, {3.685621255583207*^9, \
3.685621261013219*^9}}],

Cell[BoxData[{
    StyleBox[\(<< Graphics`PlotField`\),
      FontWeight->"Bold"], "\[IndentingNewLine]", \(tangentes = 
        ListPlotVectorField[Table[{alpha[i], T1[i]}, {i, \(-Pi\), Pi, 0.4}], 
          AspectRatio \[Rule] 
            Automatic];\), "\[IndentingNewLine]", \(normales = 
        ListPlotVectorField[Table[{alpha[i], N1[i]}, {i, \(-Pi\), Pi, 0.4}], 
          AspectRatio \[Rule] 
            Automatic];\), "\[IndentingNewLine]", \(diedro = 
      Show[traza, tangentes, normales]\)}], "Input",
  CellChangeTimes -> {{3.6856212721125727`*^9, 3.6856213493023033`*^9}, \
{3.685621416526099*^9, 3.685621461346128*^9}, {3.6856214977188807`*^9, \
3.6856214995727797`*^9}, {3.685621584989111*^9, 3.685621596354385*^9}, \
{3.685621646983479*^9, 3.68562165567159*^9}, {3.6856217631943073`*^9, \
3.685621769458544*^9}, {3.685621805132104*^9, 3.685621825001671*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Curvatura PLANA (usando Module)", "Subsubsection"]], \
"Subsection",
  CellChangeTimes -> {3.685605910957656*^9, {3.685606516051189*^9, \
3.6856065168352013`*^9}, {3.6856084359830647`*^9, 3.685608436598751*^9}, \
{3.6856203867066603`*^9, 3.685620416799171*^9}, {3.685620486266809*^9, \
3.685620530177698*^9}, 3.6856219631409683`*^9, {3.685623005135605*^9, \
3.685623007111836*^9}, {3.685623101387278*^9, 3.685623113671339*^9}}],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\[IndentingNewLine]", 
    \(\(alpha[t_] := \((Sin[3  t] + 4)\)*{Cos[t], Sin[t]};\)\)}], "Input",
  CellChangeTimes -> {{3.685620577803667*^9, 3.6856206866661177`*^9}, \
{3.685620949867936*^9, 3.685621013349968*^9}, {3.685621190235589*^9, \
3.685621198201236*^9}, {3.685621515342474*^9, 3.685621519014732*^9}, \
3.685622012909422*^9, {3.685623282306899*^9, 3.685623288304057*^9}}],

Cell["\<\
Para la curvatura, n\[OAcute]tese:
sabemos que dT/ds = k N,   y que  ds/dt = |\[Alpha]\[CloseCurlyQuote]|
entonces
dT/dt  = k  N  |\[Alpha]\[CloseCurlyQuote]| 
y tomando m\[OAcute]dulos
k = |dT/dt| / |\[Alpha]\[CloseCurlyQuote]|\
\>", "Text",
  CellChangeTimes -> {{3.6856207129747458`*^9, 3.685620724973321*^9}, \
{3.685620774020887*^9, 3.685620776930646*^9}, {3.6856220415238943`*^9, \
3.685622050593745*^9}, {3.68562271502182*^9, 3.685622828741111*^9}, \
{3.685622867224207*^9, 3.685622912540415*^9}, {3.685622992608115*^9, \
3.685622994887136*^9}}],

Cell[BoxData[{
    StyleBox[\(curvatura2D[alpha_, t_] := 
        Module[{T1, k}, \n\ \ \ \ T1[t] = 
            D[alpha[t], t]/
              Sqrt[D[alpha[t], t] . D[alpha[t], t]]; \n\ \ \ \ k = 
            Sqrt[D[T1[t], t] . D[T1[t], t]]/
                Sqrt[D[alpha[t], t] . D[alpha[t], t]] // 
              Simplify; \n\ \ \ \ Return[k]]\),
      FontWeight->"Bold"], "\[IndentingNewLine]", 
    StyleBox[\(curvatura2D[alpha, t]\),
      FontWeight->"Bold"]}], "Input",
  CellChangeTimes -> {{3.6856220258242483`*^9, 3.685622027614563*^9}, \
{3.685622067760975*^9, 3.6856220710174017`*^9}, {3.685622232500803*^9, \
3.685622233937358*^9}, {3.6856229335165777`*^9, 3.6856229850222483`*^9}, \
{3.6856231809207897`*^9, 3.685623218853273*^9}, {3.685623362595484*^9, \
3.685623368195002*^9}}],

Cell[BoxData[
    \(Plot[Evaluate[curvatura2D[alpha, t]], {t, \(-Pi\), Pi}]\)], "Input",
  CellChangeTimes -> {{3.6856231454143476`*^9, 3.685623163573949*^9}, \
{3.685623223146358*^9, 3.6856232479525337`*^9}, {3.685623383382922*^9, \
3.68562343154727*^9}, {3.685623473919394*^9, 3.685623477468566*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Determinar una curva plana a partir su \
ecuaci\[OAcute]n intr\[IAcute]nseca", "Subsubsection"]], "Subsection",
  CellChangeTimes -> {{3.685614423406983*^9, 3.685614426092739*^9}}],

Cell[TextData[{
  "Se trata de encontrar una curva  p.p.a. cuya curvatura en funci\[OAcute]n \
de la longitud de arco s sea  k(s). \nComo k(s)=|\[Alpha]\[CloseCurlyQuote]\
\[CloseCurlyQuote](s)|, se trata, m\[AAcute]s o menos, de integrar dos veces.\
\nPrimero se define \[Theta](s)=",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\(k(s)\) \[DifferentialD]s\)]],
  " y se busca \[Alpha] tal que \
\[Alpha]\[CloseCurlyQuote](s)=(cos(\[Theta](s)),sen(\[Theta](s))) que, \
obviamente, tiene norma 1 y cumple |\[Alpha]\[CloseCurlyQuote]\
\[CloseCurlyQuote](s)=k(s). Por lo tanto la curva plana buscada es \
\[Alpha](s)=",
  Cell[BoxData[
      \(TraditionalForm\`\[Integral]\((cos(\[Theta](s)), 
            sen(\[Theta](s)))\) \[DifferentialD]s\)]],
  " es la curva buscada.\nEn el ejemplo, adem\[AAcute]s, lo haremos en funci\
\[OAcute]n de un par\[AAcute]metro: a."
}], "Text",
  CellChangeTimes -> {{3.6856144324569902`*^9, 3.68561454090133*^9}, \
{3.685614657736171*^9, 3.685614673549415*^9}, {3.685614705452602*^9, \
3.685614829027396*^9}, {3.685614967445578*^9, 3.68561515244254*^9}, \
{3.6856153263574553`*^9, 3.6856153424971447`*^9}}],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\n", 
    \(\(k = 1/Sqrt[2\ a\ s];\)\), "\n", 
    \(theta = Integrate[k, s] // PowerExpand\), "\[IndentingNewLine]", 
    \(alpha := 
      Integrate[{Cos[theta], Sin[theta]}, s] // 
        Simplify\), "\[IndentingNewLine]", 
    \(Print["\<La curva con curvatura\>", k, "\< es \[Alpha](s) = \>", 
      alpha]\)}], "Input",
  CellChangeTimes -> {{3.685614482094998*^9, 3.6856145004289722`*^9}, \
{3.6856145553152113`*^9, 3.685614566216507*^9}, {3.685615162318809*^9, \
3.685615298467359*^9}, {3.685615365834783*^9, 3.685615416712775*^9}}],

Cell["Verificaci\[OAcute]n", "Text",
  CellChangeTimes -> {{3.6856144324569902`*^9, 3.68561454090133*^9}, \
{3.685614657736171*^9, 3.685614673549415*^9}, {3.685614705452602*^9, \
3.685614829027396*^9}, {3.685614967445578*^9, 3.68561515244254*^9}, \
{3.6856153263574553`*^9, 3.6856153424971447`*^9}, {3.685615436591097*^9, \
3.685615440524478*^9}}],

Cell[BoxData[{
    \(D[alpha, s] . D[alpha, s] // Simplify\), "\[IndentingNewLine]", 
    \(Sqrt[D[alpha, {s, 2}] . D[alpha, {s, 2}]] // Simplify\)}], "Input",
  CellChangeTimes -> {{3.685615445199182*^9, 3.685615491094492*^9}}],

Cell["Representaci\[OAcute]n para a=3.", "Text",
  CellChangeTimes -> {{3.6856144324569902`*^9, 3.68561454090133*^9}, \
{3.685614657736171*^9, 3.685614673549415*^9}, {3.685614705452602*^9, \
3.685614829027396*^9}, {3.685614967445578*^9, 3.68561515244254*^9}, \
{3.6856153263574553`*^9, 3.6856153424971447`*^9}, {3.685615436591097*^9, \
3.685615440524478*^9}, {3.6856155120603657`*^9, 3.6856155265860863`*^9}}],

Cell[BoxData[{
    \(\(a = 3;\)\), "\n", 
    \(ParametricPlot[Evaluate[alpha], {s, 0.001, 35}, 
      AspectRatio \[Rule] Automatic]\)}], "Input",
  CellChangeTimes -> {{3.685614482094998*^9, 3.6856145004289722`*^9}, \
3.685614913168086*^9, {3.6856152739589987`*^9, 3.685615277824727*^9}, \
{3.6856155206002493`*^9, 3.685615551877467*^9}, {3.685615590926999*^9, \
3.685615623019002*^9}}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Curvas en el ESPACIO", "Section",
  CellChangeTimes -> {{3.685606329799803*^9, 3.6856063618232117`*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Curvas parametrizadas", "Subsubsection"]], \
"Subsection",
  CellChangeTimes -> {{3.6856059194534073`*^9, 3.685605923595993*^9}, \
{3.685606571014675*^9, 3.685606624634354*^9}, {3.685608028772184*^9, \
3.6856080292227917`*^9}}],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\n", 
    \(alpha[t_] := {r*Cos[t/r], r*Sin[t/r], 
        2\ r\ Sin[t/\((2  r)\)]}\)}], "Input",
  CellChangeTimes -> {{3.6856066328897*^9, 3.685606634462924*^9}, \
{3.685617618662261*^9, 3.685617647930963*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Comprobaci\[OAcute]n de que la curva est\[AAcute] \
contenida en sendas superficies", "Subsubsection"]], "Subsubsection",
  CellChangeTimes -> {{3.685607966267693*^9, 3.685607969506546*^9}, \
{3.685608105725596*^9, 3.6856081065715733`*^9}}],

Cell[TextData[{
  "Veamos que la curva est\[AAcute] contenide en el cilindro ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 = r\^2\)]],
  " y en la esfera ",
  Cell[BoxData[
      \(TraditionalForm\`x\^2 + y\^2 + z\^2 = 4  r\^2\)]]
}], "Text",
  CellChangeTimes -> {{3.685607979275393*^9, 3.6856079921381617`*^9}}],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.21889 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.113888 1.26977 -1.11022e-16 1.26977 [
[ 0 0 0 0 ]
[ 1 1.21889 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08675 .23534 m
0 .93143 L
s
0 .93143 m
.39083 1.21889 L
s
.39083 1.21889 m
.40952 .57731 L
s
.40952 .57731 m
.08675 .23534 L
s
.6625 0 m
.92567 .40454 L
s
.92567 .40454 m
1 1.07561 L
s
1 1.07561 m
.69405 .72426 L
s
.69405 .72426 m
.6625 0 L
s
.08675 .23534 m
0 .93143 L
s
0 .93143 m
.69405 .72426 L
s
.69405 .72426 m
.6625 0 L
s
.6625 0 m
.08675 .23534 L
s
.40952 .57731 m
.92567 .40454 L
s
.92567 .40454 m
1 1.07561 L
s
1 1.07561 m
.39083 1.21889 L
s
.39083 1.21889 m
.40952 .57731 L
s
0 0 m
1 0 L
1 1.21889 L
0 1.21889 L
closepath
clip
newpath
.5 Mabswid
.696 .576 .716 r
.54285 .54523 m .55216 .57317 L .52737 .57435 L p F P
0 g
s
.696 .576 .716 r
.52737 .57435 m .52287 .56084 L .54285 .54523 L p F P
0 g
s
.709 .583 .712 r
.52737 .57435 m .52287 .56084 L .5079 .57422 L closepath p F P
0 g
s
.695 .566 .705 r
.53368 .59496 m .52737 .57435 L .55216 .57317 L p F P
0 g
s
.709 .573 .701 r
.52737 .57435 m .53368 .59496 L .5267 .60177 L p F P
0 g
s
.709 .573 .701 r
.5079 .57422 m .52737 .57435 L p .5267 .60177 L F P
0 g
s
.709 .573 .701 r
.50291 .57909 m .5079 .57422 L p .5267 .60177 L F P
0 g
s
.716 .586 .708 r
.50291 .57909 m .5079 .57422 L .50121 .57397 L closepath p F P
0 g
s
.716 .595 .72 r
.51712 .5448 m .52287 .56084 L .5079 .57422 L p F P
0 g
s
.716 .595 .72 r
.49706 .54403 m .51712 .5448 L p .5079 .57422 L F P
0 g
s
.716 .595 .72 r
.49207 .54849 m .49706 .54403 L p .5079 .57422 L F P
0 g
s
.716 .595 .72 r
.5079 .57422 m .50121 .57397 L .49207 .54849 L p F P
0 g
s
.709 .573 .701 r
.5267 .60177 m .50981 .60166 L .50291 .57909 L p F P
0 g
s
.721 .58 .696 r
.50981 .60166 m .50291 .57909 L .48374 .60022 L closepath p F P
0 g
s
.729 .593 .704 r
.50121 .57397 m .50291 .57909 L .48374 .60022 L p F P
0 g
s
.702 .588 .725 r
.54251 .54428 m .54285 .54523 L .52287 .56084 L p F P
0 g
s
.702 .588 .725 r
.52287 .56084 m .51712 .5448 L .54251 .54428 L p F P
0 g
s
.729 .593 .704 r
.47308 .57144 m .50121 .57397 L p .48374 .60022 L F P
0 g
s
.728 .602 .716 r
.49207 .54849 m .50121 .57397 L .47308 .57144 L p F P
0 g
s
.689 .554 .697 r
.53558 .60159 m .53368 .59496 L .55366 .57808 L p F P
0 g
s
.695 .566 .705 r
.55216 .57317 m .55366 .57808 L .53368 .59496 L p F P
0 g
s
.702 .562 .693 r
.53558 .60159 m .53368 .59496 L .5267 .60177 L closepath p F P
0 g
s
.701 .551 .681 r
.5267 .60177 m .53558 .60159 L p .51669 .62748 L F P
0 g
s
.701 .551 .681 r
.51669 .62748 m .51371 .61583 L .5267 .60177 L p F P
0 g
s
.709 .563 .687 r
.51371 .61583 m .5267 .60177 L .50981 .60166 L closepath p F P
0 g
s
.722 .57 .683 r
.50981 .60166 m .51371 .61583 L .50454 .62716 L p F P
0 g
s
.722 .57 .683 r
.48374 .60022 m .50981 .60166 L p .50454 .62716 L F P
0 g
s
.688 .543 .684 r
.53558 .60159 m .55991 .59989 L p .5558 .62604 L F P
0 g
s
.688 .543 .684 r
.5558 .62604 m .5421 .62698 L .53558 .60159 L p F P
0 g
s
.689 .554 .697 r
.55366 .57808 m .55991 .59989 L .53558 .60159 L p F P
0 g
s
.701 .551 .681 r
.53558 .60159 m .5421 .62698 L .51669 .62748 L p F P
0 g
s
.681 .557 .709 r
.55366 .57808 m .562 .57211 L .55216 .57317 L closepath p F P
0 g
s
.682 .568 .721 r
.562 .57211 m .55216 .57317 L .54285 .54523 L p F P
0 g
s
.675 .546 .7 r
.55991 .59989 m .55366 .57808 L .562 .57211 L p F P
0 g
s
.702 .597 .736 r
.53204 .51689 m .54251 .54428 L .51712 .5448 L p F P
0 g
s
.702 .597 .736 r
.51712 .5448 m .51204 .53156 L .53204 .51689 L p F P
0 g
s
.715 .604 .731 r
.51712 .5448 m .51204 .53156 L .49706 .54403 L closepath p F P
0 g
s
.682 .568 .721 r
.54285 .54523 m .54451 .54411 L p .562 .57211 L F P
0 g
s
.688 .58 .73 r
.54285 .54523 m .54451 .54411 L .54251 .54428 L closepath p F P
0 g
s
.688 .59 .74 r
.54451 .54411 m .54251 .54428 L .53204 .51689 L p F P
0 g
s
.714 .559 .677 r
.51669 .62748 m .51371 .61583 L .50454 .62716 L closepath p F P
0 g
s
.682 .568 .721 r
.54451 .54411 m .56619 .54176 L p .562 .57211 L F P
0 g
s
.683 .578 .731 r
.56619 .54176 m .56289 .53251 L .54451 .54411 L closepath p F P
0 g
s
.688 .59 .74 r
.55446 .51038 m .56289 .53251 L .54451 .54411 L p F P
0 g
s
.688 .59 .74 r
.54039 .5116 m .55446 .51038 L p .54451 .54411 L F P
0 g
s
.688 .59 .74 r
.53204 .51689 m .54039 .5116 L p .54451 .54411 L F P
0 g
s
.728 .602 .716 r
.47308 .57144 m .47206 .5686 L .49207 .54849 L p F P
0 g
s
.723 .609 .729 r
.49207 .54849 m .49706 .54403 L .49013 .54349 L closepath p F P
0 g
s
.736 .615 .724 r
.49207 .54849 m .47206 .5686 L .46115 .5406 L p F P
0 g
s
.736 .615 .724 r
.49013 .54349 m .49207 .54849 L p .46115 .5406 L F P
0 g
s
.722 .617 .739 r
.5039 .51182 m .51204 .53156 L .49706 .54403 L p F P
0 g
s
.722 .617 .739 r
.49417 .51106 m .5039 .51182 L p .49706 .54403 L F P
0 g
s
.722 .617 .739 r
.48117 .52189 m .49417 .51106 L p .49706 .54403 L F P
0 g
s
.722 .617 .739 r
.49706 .54403 m .49013 .54349 L .48117 .52189 L p F P
0 g
s
.675 .546 .7 r
.562 .57211 m .57559 .5704 L p .55991 .59989 L F P
0 g
s
.676 .557 .712 r
.57559 .5704 m .5737 .56432 L .562 .57211 L closepath p F P
0 g
s
.682 .568 .721 r
.56619 .54176 m .5737 .56432 L .562 .57211 L p F P
0 g
s
.722 .57 .683 r
.4829 .60125 m .48374 .60022 L p .50454 .62716 L F P
0 g
s
.73 .583 .69 r
.4829 .60125 m .48374 .60022 L .48257 .60012 L closepath p F P
0 g
s
.729 .593 .704 r
.48374 .60022 m .48257 .60012 L .47308 .57144 L p F P
0 g
s
.742 .59 .686 r
.48257 .60012 m .4829 .60125 L .46638 .62405 L p F P
0 g
s
.742 .59 .686 r
.45298 .59611 m .48257 .60012 L p .46638 .62405 L F P
0 g
s
.741 .599 .699 r
.47308 .57144 m .48257 .60012 L .45298 .59611 L p F P
0 g
s
.722 .57 .683 r
.50454 .62716 m .48979 .62636 L .4829 .60125 L p F P
0 g
s
.733 .577 .68 r
.48979 .62636 m .4829 .60125 L .46638 .62405 L closepath p F P
0 g
s
.673 .534 .687 r
.56455 .61788 m .55991 .59989 L .58322 .59699 L p F P
0 g
s
.675 .546 .7 r
.57559 .5704 m .58322 .59699 L .55991 .59989 L p F P
0 g
s
.688 .543 .684 r
.55991 .59989 m .56455 .61788 L .5558 .62604 L p F P
0 g
s
.736 .615 .724 r
.46115 .5406 m .46198 .53976 L .49013 .54349 L p F P
0 g
s
.734 .623 .734 r
.49013 .54349 m .48117 .52189 L .46198 .53976 L closepath p F P
0 g
s
.709 .61 .745 r
.53011 .51219 m .53204 .51689 L .51204 .53156 L p F P
0 g
s
.709 .61 .745 r
.51204 .53156 m .5039 .51182 L .53011 .51219 L p F P
0 g
s
.741 .599 .699 r
.46992 .571 m .47308 .57144 L p .45298 .59611 L F P
0 g
s
.739 .607 .711 r
.47308 .57144 m .47206 .5686 L .46992 .571 L closepath p F P
0 g
s
.748 .621 .718 r
.46115 .5406 m .47206 .5686 L .46992 .571 L p F P
0 g
s
.7 .539 .666 r
.51669 .62748 m .5421 .62698 L p .53356 .65154 L F P
0 g
s
.7 .539 .666 r
.53356 .65154 m .5221 .65176 L .51669 .62748 L p F P
0 g
s
.713 .548 .663 r
.51669 .62748 m .5221 .65176 L .49556 .65107 L p F P
0 g
s
.713 .548 .663 r
.50454 .62716 m .51669 .62748 L p .49556 .65107 L F P
0 g
s
.741 .599 .699 r
.45298 .59611 m .45197 .59303 L .46992 .571 L p F P
0 g
s
.75 .613 .706 r
.45197 .59303 m .46992 .571 L .44222 .56601 L closepath p F P
0 g
s
.748 .621 .718 r
.44104 .563 m .46115 .5406 L p .46992 .571 L F P
0 g
s
.748 .621 .718 r
.46992 .571 m .44222 .56601 L .44104 .563 L p F P
0 g
s
.713 .548 .663 r
.49556 .65107 m .49368 .64256 L .50454 .62716 L p F P
0 g
s
.722 .559 .669 r
.49368 .64256 m .50454 .62716 L .48979 .62636 L closepath p F P
0 g
s
.686 .53 .669 r
.54455 .6379 m .5558 .62604 L .5421 .62698 L closepath p F P
0 g
s
.7 .539 .666 r
.5421 .62698 m .54455 .6379 L .53356 .65154 L p F P
0 g
s
.662 .549 .716 r
.57559 .5704 m .5737 .56432 L .59383 .55318 L p F P
0 g
s
.667 .56 .725 r
.58872 .5378 m .59383 .55318 L .5737 .56432 L p F P
0 g
s
.667 .56 .725 r
.5737 .56432 m .56619 .54176 L .58872 .5378 L p F P
0 g
s
.659 .537 .704 r
.57559 .5704 m .59791 .56623 L p .59718 .59441 L F P
0 g
s
.659 .537 .704 r
.59718 .59441 m .58322 .59699 L .57559 .5704 L p F P
0 g
s
.662 .549 .716 r
.59383 .55318 m .59791 .56623 L .57559 .5704 L p F P
0 g
s
.668 .57 .735 r
.58302 .5218 m .58872 .5378 L .56619 .54176 L p F P
0 g
s
.668 .57 .735 r
.56619 .54176 m .56289 .53251 L .58302 .5218 L p F P
0 g
s
.734 .567 .665 r
.48979 .62636 m .49368 .64256 L .48864 .65061 L p F P
0 g
s
.734 .567 .665 r
.46638 .62405 m .48979 .62636 L p .48864 .65061 L F P
0 g
s
.673 .534 .687 r
.58322 .59699 m .5846 .60228 L .56455 .61788 L p F P
0 g
s
.667 .524 .68 r
.56629 .62511 m .56455 .61788 L .5846 .60228 L p F P
0 g
s
.681 .533 .677 r
.56629 .62511 m .56455 .61788 L .5558 .62604 L closepath p F P
0 g
s
.679 .52 .663 r
.5558 .62604 m .56629 .62511 L p .54729 .65097 L F P
0 g
s
.679 .52 .663 r
.54729 .65097 m .54455 .6379 L .5558 .62604 L p F P
0 g
s
.694 .603 .75 r
.53204 .51689 m .54039 .5116 L .53011 .51219 L closepath p F P
0 g
s
.673 .582 .745 r
.57729 .50672 m .58302 .5218 L .56289 .53251 L p F P
0 g
s
.673 .582 .745 r
.56289 .53251 m .55446 .51038 L .57729 .50672 L p F P
0 g
s
.657 .524 .69 r
.5846 .60228 m .59718 .59441 L .58322 .59699 L closepath p F P
0 g
s
.693 .529 .66 r
.54729 .65097 m .54455 .6379 L .53356 .65154 L closepath p F P
0 g
s
.665 .511 .666 r
.57133 .64888 m .56629 .62511 L .58937 .62191 L p F P
0 g
s
.667 .524 .68 r
.5846 .60228 m .58937 .62191 L .56629 .62511 L p F P
0 g
s
.679 .52 .663 r
.56629 .62511 m .57133 .64888 L .54729 .65097 L p F P
0 g
s
.694 .611 .759 r
.54039 .5116 m .53011 .51219 L .52121 .49164 L p F P
0 g
s
.708 .618 .754 r
.52121 .49164 m .53011 .51219 L .5039 .51182 L p F P
0 g
s
.708 .618 .754 r
.5039 .51182 m .50118 .50557 L .52121 .49164 L p F P
0 g
s
.721 .624 .749 r
.5039 .51182 m .50118 .50557 L .49417 .51106 L closepath p F P
0 g
s
.652 .514 .683 r
.58937 .62191 m .5846 .60228 L .59718 .59441 L p F P
0 g
s
.73 .631 .749 r
.48117 .52189 m .49417 .51106 L .47523 .50868 L closepath p F P
0 g
s
.742 .637 .743 r
.47523 .50868 m .48117 .52189 L .46198 .53976 L p F P
0 g
s
.689 .598 .75 r
.55446 .51038 m .5521 .50452 L .54039 .5116 L closepath p F P
0 g
s
.694 .611 .759 r
.54129 .47944 m .5521 .50452 L .54039 .5116 L p F P
0 g
s
.694 .611 .759 r
.52121 .49164 m .54129 .47944 L p .54039 .5116 L F P
0 g
s
.745 .63 .732 r
.46115 .5406 m .46198 .53976 L .46069 .53952 L closepath p F P
0 g
s
.742 .637 .743 r
.461 .50604 m .47523 .50868 L p .46198 .53976 L F P
0 g
s
.742 .637 .743 r
.45012 .51616 m .461 .50604 L p .46198 .53976 L F P
0 g
s
.742 .637 .743 r
.46198 .53976 m .46069 .53952 L .45012 .51616 L p F P
0 g
s
.757 .635 .726 r
.46115 .5406 m .44104 .563 L .42999 .53716 L p F P
0 g
s
.757 .635 .726 r
.46069 .53952 m .46115 .5406 L p .42999 .53716 L F P
0 g
s
.742 .59 .686 r
.46638 .62405 m .46109 .62334 L .45298 .59611 L p F P
0 g
s
.753 .596 .682 r
.45007 .59559 m .45298 .59611 L .46109 .62334 L p F P
0 g
s
.752 .605 .695 r
.45298 .59611 m .45197 .59303 L .45007 .59559 L closepath p F P
0 g
s
.761 .618 .701 r
.45007 .59559 m .45197 .59303 L .44222 .56601 L p F P
0 g
s
.757 .635 .726 r
.42999 .53716 m .43359 .53315 L .46069 .53952 L p F P
0 g
s
.754 .642 .737 r
.46069 .53952 m .45012 .51616 L .43359 .53315 L closepath p F P
0 g
s
.726 .555 .66 r
.49556 .65107 m .49368 .64256 L .48864 .65061 L closepath p F P
0 g
s
.734 .567 .665 r
.46277 .62979 m .46638 .62405 L p .48864 .65061 L F P
0 g
s
.743 .579 .671 r
.46277 .62979 m .46638 .62405 L .46109 .62334 L closepath p F P
0 g
s
.728 .638 .758 r
.49024 .48227 m .50118 .50557 L .49417 .51106 L p F P
0 g
s
.728 .638 .758 r
.47019 .49802 m .49024 .48227 L p .49417 .51106 L F P
0 g
s
.728 .638 .758 r
.49417 .51106 m .47523 .50868 L .47019 .49802 L p F P
0 g
s
.763 .61 .688 r
.42141 .58923 m .45007 .59559 L .43485 .61873 L p F P
0 g
s
.761 .618 .701 r
.43915 .56532 m .42141 .58923 L .45007 .59559 L p F P
0 g
s
.761 .618 .701 r
.44222 .56601 m .43915 .56532 L p .45007 .59559 L F P
0 g
s
.753 .596 .682 r
.46109 .62334 m .43485 .61873 L .45007 .59559 L p F P
0 g
s
.699 .526 .65 r
.52455 .6648 m .53356 .65154 L .5221 .65176 L closepath p F P
0 g
s
.713 .535 .647 r
.5221 .65176 m .52455 .6648 L .5187 .67476 L p F P
0 g
s
.713 .535 .647 r
.49556 .65107 m .5221 .65176 L p .5187 .67476 L F P
0 g
s
.715 .632 .764 r
.52121 .49164 m .50118 .50557 L .49024 .48227 L p F P
0 g
s
.674 .591 .754 r
.57225 .49413 m .57729 .50672 L .55446 .51038 L p F P
0 g
s
.674 .591 .754 r
.55446 .51038 m .5521 .50452 L .57225 .49413 L p F P
0 g
s
.755 .586 .667 r
.46109 .62334 m .46277 .62979 L .45323 .6466 L p F P
0 g
s
.755 .586 .667 r
.43485 .61873 m .46109 .62334 L p .45323 .6466 L F P
0 g
s
.692 .516 .645 r
.53356 .65154 m .54729 .65097 L p .52628 .67478 L F P
0 g
s
.692 .516 .645 r
.52628 .67478 m .52455 .6648 L .53356 .65154 L p F P
0 g
s
.646 .54 .719 r
.59791 .56623 m .59383 .55318 L .6141 .54424 L p F P
0 g
s
.65 .55 .728 r
.61018 .53245 m .6141 .54424 L .59383 .55318 L p F P
0 g
s
.65 .55 .728 r
.59383 .55318 m .58872 .5378 L .61018 .53245 L p F P
0 g
s
.713 .535 .647 r
.5187 .67476 m .49985 .67428 L .49556 .65107 L p F P
0 g
s
.725 .543 .644 r
.48864 .65061 m .49556 .65107 L .49985 .67428 L p F P
0 g
s
.643 .527 .707 r
.60475 .59001 m .59791 .56623 L .61927 .56081 L p F P
0 g
s
.659 .537 .704 r
.59791 .56623 m .60475 .59001 L .59718 .59441 L p F P
0 g
s
.646 .54 .719 r
.6141 .54424 m .61927 .56081 L .59791 .56623 L p F P
0 g
s
.677 .506 .647 r
.55132 .67376 m .54729 .65097 L .57133 .64888 L p F P
0 g
s
.692 .516 .645 r
.54729 .65097 m .55132 .67376 L .52628 .67478 L p F P
0 g
s
.734 .567 .665 r
.48864 .65061 m .46723 .64852 L .46277 .62979 L p F P
0 g
s
.745 .574 .662 r
.46723 .64852 m .46277 .62979 L .45323 .6466 L closepath p F P
0 g
s
.652 .514 .683 r
.59718 .59441 m .6055 .59278 L p .58937 .62191 L F P
0 g
s
.655 .527 .696 r
.6055 .59278 m .60475 .59001 L .59718 .59441 L closepath p F P
0 g
s
.653 .561 .739 r
.60328 .51302 m .61018 .53245 L .58872 .5378 L p F P
0 g
s
.653 .561 .739 r
.58872 .5378 m .58302 .5218 L .60328 .51302 L p F P
0 g
s
.758 .626 .713 r
.44222 .56601 m .44104 .563 L .43915 .56532 L closepath p F P
0 g
s
.679 .604 .764 r
.57225 .49413 m .5521 .50452 L .54129 .47944 L p F P
0 g
s
.725 .543 .644 r
.49985 .67428 m .47706 .67277 L .48864 .65061 L p F P
0 g
s
.734 .555 .649 r
.46723 .64852 m .48864 .65061 L .47706 .67277 L p F P
0 g
s
.767 .64 .72 r
.43915 .56532 m .44104 .563 L .42999 .53716 L p F P
0 g
s
.648 .5 .668 r
.58937 .62191 m .61157 .61761 L p .60836 .64305 L F P
0 g
s
.648 .5 .668 r
.60836 .64305 m .59446 .64571 L .58937 .62191 L p F P
0 g
s
.652 .514 .683 r
.6055 .59278 m .61157 .61761 L .58937 .62191 L p F P
0 g
s
.665 .511 .666 r
.58937 .62191 m .59446 .64571 L .57133 .64888 L p F P
0 g
s
.771 .633 .708 r
.41289 .55802 m .43915 .56532 L .42141 .58923 L p F P
0 g
s
.767 .64 .72 r
.42999 .53716 m .41289 .55802 L .43915 .56532 L p F P
0 g
s
.74 .643 .752 r
.47523 .50868 m .47019 .49802 L .461 .50604 L closepath p F P
0 g
s
.657 .573 .749 r
.5989 .50146 m .60328 .51302 L .58302 .5218 L p F P
0 g
s
.657 .573 .749 r
.58302 .5218 m .57729 .50672 L .5989 .50146 L p F P
0 g
s
.639 .518 .699 r
.6055 .59278 m .60475 .59001 L .62505 .58083 L p F P
0 g
s
.643 .527 .707 r
.61927 .56081 m .62505 .58083 L .60475 .59001 L p F P
0 g
s
.635 .504 .685 r
.61157 .61761 m .6055 .59278 L .62681 .58732 L p F P
0 g
s
.639 .518 .699 r
.62505 .58083 m .62681 .58732 L .6055 .59278 L p F P
0 g
s
.7 .626 .77 r
.53904 .47457 m .54129 .47944 L .52121 .49164 L p F P
0 g
s
.7 .626 .77 r
.52121 .49164 m .5135 .4751 L .53904 .47457 L p F P
0 g
s
.715 .632 .764 r
.5135 .4751 m .52121 .49164 L p .49024 .48227 L F P
0 g
s
.705 .525 .643 r
.52628 .67478 m .52455 .6648 L .5187 .67476 L closepath p F P
0 g
s
.661 .496 .65 r
.57133 .64888 m .59446 .64571 L p .57735 .67142 L F P
0 g
s
.661 .496 .65 r
.57735 .67142 m .57542 .67169 L .57133 .64888 L p F P
0 g
s
.677 .506 .647 r
.57133 .64888 m .57542 .67169 L .55132 .67376 L p F P
0 g
s
.734 .555 .649 r
.47706 .67277 m .47195 .67228 L .46723 .64852 L p F P
0 g
s
.746 .562 .646 r
.45323 .6466 m .46723 .64852 L .47195 .67228 L p F P
0 g
s
.659 .583 .759 r
.59251 .48547 m .5989 .50146 L .57729 .50672 L p F P
0 g
s
.659 .583 .759 r
.57729 .50672 m .57225 .49413 L .59251 .48547 L p F P
0 g
s
.751 .653 .752 r
.45012 .51616 m .461 .50604 L .4429 .50154 L closepath p F P
0 g
s
.748 .658 .762 r
.45911 .47642 m .47019 .49802 L .461 .50604 L p F P
0 g
s
.748 .658 .762 r
.43899 .49398 m .45911 .47642 L p .461 .50604 L F P
0 g
s
.748 .658 .762 r
.461 .50604 m .4429 .50154 L .43899 .49398 L p F P
0 g
s
.763 .657 .746 r
.4429 .50154 m .45012 .51616 L .43359 .53315 L p F P
0 g
s
.736 .653 .768 r
.49024 .48227 m .47019 .49802 L .45911 .47642 L p F P
0 g
s
.765 .6 .673 r
.43165 .62433 m .43485 .61873 L .42972 .61761 L closepath p F P
0 g
s
.763 .61 .688 r
.42077 .59019 m .42141 .58923 L p .43485 .61873 L F P
0 g
s
.763 .61 .688 r
.43485 .61873 m .42972 .61761 L .42077 .59019 L p F P
0 g
s
.755 .586 .667 r
.43165 .62433 m .43485 .61873 L p .45323 .6466 L F P
0 g
s
.746 .562 .646 r
.47195 .67228 m .44294 .66834 L .45323 .6466 L p F P
0 g
s
.756 .575 .651 r
.43667 .64373 m .45323 .6466 L .44294 .66834 L p F P
0 g
s
.755 .586 .667 r
.45323 .6466 m .43667 .64373 L .43165 .62433 L p F P
0 g
s
.689 .501 .628 r
.52928 .69663 m .52628 .67478 L .55132 .67376 L p F P
0 g
s
.703 .511 .626 r
.5187 .67476 m .52628 .67478 L .52928 .69663 L p F P
0 g
s
.703 .511 .626 r
.52928 .69663 m .50862 .6966 L .5187 .67476 L p F P
0 g
s
.712 .521 .63 r
.49985 .67428 m .5187 .67476 L .50862 .6966 L p F P
0 g
s
.766 .651 .735 r
.42999 .53716 m .43359 .53315 L .42721 .53124 L closepath p F P
0 g
s
.763 .657 .746 r
.43396 .49882 m .4429 .50154 L p .43359 .53315 L F P
0 g
s
.763 .657 .746 r
.41881 .51438 m .43396 .49882 L p .43359 .53315 L F P
0 g
s
.763 .657 .746 r
.43359 .53315 m .42721 .53124 L .41881 .51438 L p F P
0 g
s
.663 .596 .77 r
.58445 .46655 m .59251 .48547 L .57225 .49413 L p F P
0 g
s
.663 .596 .77 r
.57225 .49413 m .56262 .47167 L .58445 .46655 L p F P
0 g
s
.679 .604 .764 r
.56262 .47167 m .57225 .49413 L p .54129 .47944 L F P
0 g
s
.777 .656 .728 r
.42721 .53124 m .42999 .53716 L .41289 .55802 L p F P
0 g
s
.63 .53 .722 r
.61927 .56081 m .6141 .54424 L .63453 .53751 L p F P
0 g
s
.633 .54 .732 r
.6306 .52569 m .63453 .53751 L .6141 .54424 L p F P
0 g
s
.633 .54 .732 r
.6141 .54424 m .61018 .53245 L .6306 .52569 L p F P
0 g
s
.712 .521 .63 r
.50862 .6966 m .50305 .69646 L .49985 .67428 L p F P
0 g
s
.725 .53 .627 r
.49985 .67428 m .50305 .69646 L .47523 .69463 L p F P
0 g
s
.725 .53 .627 r
.47706 .67277 m .49985 .67428 L p .47523 .69463 L F P
0 g
s
.631 .489 .67 r
.61595 .63787 m .61157 .61761 L .63293 .6122 L p F P
0 g
s
.635 .504 .685 r
.62681 .58732 m .63293 .6122 L .61157 .61761 L p F P
0 g
s
.648 .5 .668 r
.61157 .61761 m .61595 .63787 L .60836 .64305 L p F P
0 g
s
.776 .606 .668 r
.42972 .61761 m .43165 .62433 L .42305 .64084 L p F P
0 g
s
.776 .606 .668 r
.40764 .6119 m .42972 .61761 L p .42305 .64084 L F P
0 g
s
.773 .615 .683 r
.42972 .61761 m .42077 .59019 L .40764 .6119 L closepath p F P
0 g
s
.774 .625 .695 r
.42077 .59019 m .42141 .58923 L .42031 .58893 L closepath p F P
0 g
s
.771 .633 .708 r
.40971 .5623 m .41289 .55802 L p .42141 .58923 L F P
0 g
s
.771 .633 .708 r
.42141 .58923 m .42031 .58893 L .40971 .5623 L p F P
0 g
s
.715 .632 .764 r
.49024 .48227 m .50153 .4744 L .5135 .4751 L p F P
0 g
s
.722 .648 .775 r
.49024 .48227 m .50153 .4744 L .48529 .47254 L closepath p F P
0 g
s
.736 .653 .768 r
.48529 .47254 m .49024 .48227 L p .45911 .47642 L F P
0 g
s
.679 .604 .764 r
.54129 .47944 m .55389 .4729 L .56262 .47167 L p F P
0 g
s
.685 .619 .776 r
.54129 .47944 m .55389 .4729 L .53904 .47457 L closepath p F P
0 g
s
.63 .53 .722 r
.63453 .53751 m .63973 .55413 L .61927 .56081 L p F P
0 g
s
.626 .517 .71 r
.62505 .58083 m .61927 .56081 L .63973 .55413 L p F P
0 g
s
.636 .552 .743 r
.62369 .50619 m .6306 .52569 L .61018 .53245 L p F P
0 g
s
.636 .552 .743 r
.61018 .53245 m .60328 .51302 L .62369 .50619 L p F P
0 g
s
.644 .484 .652 r
.59576 .65283 m .60836 .64305 L .59446 .64571 L closepath p F P
0 g
s
.661 .496 .65 r
.59446 .64571 m .59576 .65283 L .57735 .67142 L p F P
0 g
s
.784 .629 .689 r
.42031 .58893 m .42077 .59019 L .40764 .6119 L p F P
0 g
s
.765 .592 .663 r
.43667 .64373 m .43165 .62433 L .42305 .64084 L closepath p F P
0 g
s
.784 .629 .689 r
.39662 .58147 m .42031 .58893 L p .40764 .6119 L F P
0 g
s
.781 .637 .703 r
.42031 .58893 m .40971 .5623 L .39662 .58147 L closepath p F P
0 g
s
.674 .491 .63 r
.55132 .67376 m .57542 .67169 L p .56195 .69498 L F P
0 g
s
.674 .491 .63 r
.56195 .69498 m .5544 .69562 L .55132 .67376 L p F P
0 g
s
.689 .501 .628 r
.55132 .67376 m .5544 .69562 L .52928 .69663 L p F P
0 g
s
.7 .632 .778 r
.53044 .45677 m .53904 .47457 L .5135 .4751 L p F P
0 g
s
.7 .632 .778 r
.5135 .4751 m .51031 .46856 L .53044 .45677 L p F P
0 g
s
.713 .638 .772 r
.5135 .4751 m .51031 .46856 L .50153 .4744 L closepath p F P
0 g
s
.685 .626 .783 r
.55389 .4729 m .53904 .47457 L .53044 .45677 L p F P
0 g
s
.626 .517 .71 r
.63973 .55413 m .64553 .57421 L .62505 .58083 L p F P
0 g
s
.777 .656 .728 r
.40931 .52504 m .42721 .53124 L p .41289 .55802 L F P
0 g
s
.773 .661 .739 r
.42721 .53124 m .41881 .51438 L .40931 .52504 L closepath p F P
0 g
s
.623 .507 .701 r
.62681 .58732 m .62505 .58083 L .64553 .57421 L p F P
0 g
s
.64 .564 .754 r
.61932 .49459 m .62369 .50619 L .60328 .51302 L p F P
0 g
s
.64 .564 .754 r
.60328 .51302 m .5989 .50146 L .61932 .49459 L p F P
0 g
s
.72 .653 .783 r
.49934 .44762 m .51031 .46856 L .50153 .4744 L p F P
0 g
s
.72 .653 .783 r
.47922 .46105 m .49934 .44762 L p .50153 .4744 L F P
0 g
s
.72 .653 .783 r
.50153 .4744 m .48529 .47254 L .47922 .46105 L p F P
0 g
s
.725 .53 .627 r
.47523 .69463 m .4734 .68167 L .47706 .67277 L p F P
0 g
s
.734 .541 .631 r
.4734 .68167 m .47706 .67277 L .47195 .67228 L closepath p F P
0 g
s
.618 .493 .688 r
.63293 .6122 m .62681 .58732 L .6473 .58071 L p F P
0 g
s
.623 .507 .701 r
.64553 .57421 m .6473 .58071 L .62681 .58732 L p F P
0 g
s
.64 .477 .646 r
.59841 .6683 m .59576 .65283 L .60836 .64305 L p F P
0 g
s
.656 .488 .644 r
.59841 .6683 m .59576 .65283 L .57735 .67142 L closepath p F P
0 g
s
.747 .55 .628 r
.47195 .67228 m .4734 .68167 L .46889 .69397 L p F P
0 g
s
.747 .55 .628 r
.44294 .66834 m .47195 .67228 L p .46889 .69397 L F P
0 g
s
.756 .575 .651 r
.44294 .66834 m .44197 .66818 L .43667 .64373 L p F P
0 g
s
.767 .581 .647 r
.42305 .64084 m .43667 .64373 L .44197 .66818 L p F P
0 g
s
.658 .479 .631 r
.57569 .6735 m .57735 .67142 L .57542 .67169 L closepath p F P
0 g
s
.674 .491 .63 r
.57542 .67169 m .57569 .6735 L .56195 .69498 L p F P
0 g
s
.759 .663 .755 r
.4429 .50154 m .43899 .49398 L .43396 .49882 L closepath p F P
0 g
s
.643 .574 .763 r
.61293 .47854 m .61932 .49459 L .5989 .50146 L p F P
0 g
s
.643 .574 .763 r
.5989 .50146 m .59251 .48547 L .61293 .47854 L p F P
0 g
s
.706 .648 .789 r
.53044 .45677 m .51031 .46856 L .49934 .44762 L p F P
0 g
s
.781 .649 .716 r
.40971 .5623 m .41289 .55802 L .40692 .55598 L closepath p F P
0 g
s
.777 .656 .728 r
.39849 .5382 m .40931 .52504 L p .41289 .55802 L F P
0 g
s
.777 .656 .728 r
.41289 .55802 m .40692 .55598 L .39849 .5382 L p F P
0 g
s
.652 .472 .627 r
.57735 .67142 m .59841 .6683 L p .57836 .69332 L F P
0 g
s
.652 .472 .627 r
.57836 .69332 m .57569 .6735 L .57735 .67142 L p F P
0 g
s
.68 .612 .773 r
.56262 .47167 m .56147 .46909 L .55389 .4729 L closepath p F P
0 g
s
.685 .626 .783 r
.55065 .44654 m .56147 .46909 L .55389 .4729 L p F P
0 g
s
.685 .626 .783 r
.53044 .45677 m .55065 .44654 L p .55389 .4729 L F P
0 g
s
.64 .477 .646 r
.60836 .64305 m .61666 .64138 L p .59841 .6683 L F P
0 g
s
.644 .492 .662 r
.61666 .64138 m .61595 .63787 L .60836 .64305 L closepath p F P
0 g
s
.668 .483 .625 r
.57836 .69332 m .57569 .6735 L .56195 .69498 L closepath p F P
0 g
s
.733 .659 .776 r
.48529 .47254 m .47922 .46105 L .46816 .46931 L closepath p F P
0 g
s
.736 .653 .768 r
.45911 .47642 m .46816 .46931 L .48529 .47254 L p F P
0 g
s
.791 .653 .71 r
.40692 .55598 m .40971 .5623 L .39662 .58147 L p F P
0 g
s
.628 .481 .664 r
.61666 .64138 m .61595 .63787 L .63631 .62772 L p F P
0 g
s
.631 .489 .67 r
.63293 .6122 m .63631 .62772 L .61595 .63787 L p F P
0 g
s
.665 .604 .777 r
.58176 .46051 m .58445 .46655 L .56262 .47167 L p F P
0 g
s
.665 .604 .777 r
.56262 .47167 m .56147 .46909 L .58176 .46051 L p F P
0 g
s
.737 .539 .625 r
.47523 .69463 m .4734 .68167 L .46889 .69397 L closepath p F P
0 g
s
.622 .465 .647 r
.62058 .66389 m .61666 .64138 L .63801 .63593 L p F P
0 g
s
.628 .481 .664 r
.63631 .62772 m .63801 .63593 L .61666 .64138 L p F P
0 g
s
.64 .477 .646 r
.61666 .64138 m .62058 .66389 L .59841 .6683 L p F P
0 g
s
.669 .618 .789 r
.58176 .46051 m .56147 .46909 L .55065 .44654 L p F P
0 g
s
.791 .653 .71 r
.38996 .54949 m .40692 .55598 L p .39662 .58147 L F P
0 g
s
.787 .659 .722 r
.40692 .55598 m .39849 .5382 L .38996 .54949 L closepath p F P
0 g
s
.646 .587 .774 r
.60488 .45955 m .61293 .47854 L .59251 .48547 L p F P
0 g
s
.646 .587 .774 r
.59251 .48547 m .58445 .46655 L .60488 .45955 L p F P
0 g
s
.756 .675 .772 r
.45911 .47642 m .43899 .49398 L .42773 .47408 L p F P
0 g
s
.768 .679 .764 r
.43396 .49882 m .43899 .49398 L .42773 .47408 L p F P
0 g
s
.767 .581 .647 r
.44197 .66818 m .41374 .66227 L .42305 .64084 L p F P
0 g
s
.779 .595 .651 r
.40284 .63568 m .42305 .64084 L .41374 .66227 L p F P
0 g
s
.776 .606 .668 r
.40013 .62622 m .40764 .6119 L p .42305 .64084 L F P
0 g
s
.776 .606 .668 r
.42305 .64084 m .40284 .63568 L .40013 .62622 L p F P
0 g
s
.772 .674 .755 r
.43396 .49882 m .41881 .51438 L .40749 .49375 L p F P
0 g
s
.772 .674 .755 r
.40749 .49375 m .41111 .49003 L .43396 .49882 L p F P
0 g
s
.768 .679 .764 r
.42773 .47408 m .41111 .49003 L .43396 .49882 L p F P
0 g
s
.612 .477 .673 r
.63631 .62772 m .63293 .6122 L .65348 .60567 L p F P
0 g
s
.618 .493 .688 r
.6473 .58071 m .65348 .60567 L .63293 .6122 L p F P
0 g
s
.744 .67 .779 r
.45911 .47642 m .46816 .46931 L .45283 .4652 L closepath p F P
0 g
s
.756 .675 .772 r
.45283 .4652 m .45911 .47642 L p .42773 .47408 L F P
0 g
s
.788 .62 .674 r
.40013 .62622 m .40764 .6119 L .39421 .60773 L closepath p F P
0 g
s
.784 .629 .689 r
.38914 .59376 m .39662 .58147 L p .40764 .6119 L F P
0 g
s
.784 .629 .689 r
.40764 .6119 m .39421 .60773 L .38914 .59376 L p F P
0 g
s
.747 .55 .628 r
.44229 .67009 m .44294 .66834 L p .46889 .69397 L F P
0 g
s
.758 .562 .632 r
.44229 .67009 m .44294 .66834 L .44197 .66818 L closepath p F P
0 g
s
.635 .46 .628 r
.6014 .68994 m .59841 .6683 L .62058 .66389 L p F P
0 g
s
.652 .472 .627 r
.59841 .6683 m .6014 .68994 L .57836 .69332 L p F P
0 g
s
.687 .485 .608 r
.52928 .69663 m .5544 .69562 L p .55273 .71673 L F P
0 g
s
.687 .485 .608 r
.55273 .71673 m .5313 .71758 L .52928 .69663 L p F P
0 g
s
.701 .496 .607 r
.52928 .69663 m .5313 .71758 L .5051 .71754 L p F P
0 g
s
.701 .496 .607 r
.50862 .6966 m .52928 .69663 L p .5051 .71754 L F P
0 g
s
.783 .678 .748 r
.40931 .52504 m .41881 .51438 L .40749 .49375 L p F P
0 g
s
.701 .496 .607 r
.5051 .71754 m .50438 .70966 L .50862 .6966 L p F P
0 g
s
.71 .505 .61 r
.50438 .70966 m .50862 .6966 L .50305 .69646 L closepath p F P
0 g
s
.769 .569 .629 r
.44197 .66818 m .44229 .67009 L .43584 .68919 L p F P
0 g
s
.769 .569 .629 r
.41374 .66227 m .44197 .66818 L p .43584 .68919 L F P
0 g
s
.74 .675 .787 r
.46809 .44165 m .47922 .46105 L .46816 .46931 L p F P
0 g
s
.74 .675 .787 r
.44792 .45673 m .46809 .44165 L p .46816 .46931 L F P
0 g
s
.74 .675 .787 r
.46816 .46931 m .45283 .4652 L .44792 .45673 L p F P
0 g
s
.724 .515 .608 r
.50305 .69646 m .50438 .70966 L .50219 .71742 L p F P
0 g
s
.724 .515 .608 r
.47523 .69463 m .50305 .69646 L p .50219 .71742 L F P
0 g
s
.612 .519 .725 r
.63973 .55413 m .63453 .53751 L .65517 .53299 L p F P
0 g
s
.614 .53 .736 r
.65002 .51748 m .65517 .53299 L .63453 .53751 L p F P
0 g
s
.614 .53 .736 r
.63453 .53751 m .6306 .52569 L .65002 .51748 L p F P
0 g
s
.69 .641 .795 r
.55065 .44654 m .53044 .45677 L .51952 .43575 L p F P
0 g
s
.706 .648 .789 r
.49934 .44762 m .51952 .43575 L .53044 .45677 L p F P
0 g
s
.607 .505 .713 r
.64553 .57421 m .63973 .55413 L .65929 .54616 L p F P
0 g
s
.612 .519 .725 r
.65517 .53299 m .65929 .54616 L .63973 .55413 L p F P
0 g
s
.619 .542 .746 r
.6443 .50131 m .65002 .51748 L .6306 .52569 L p F P
0 g
s
.619 .542 .746 r
.6306 .52569 m .62369 .50619 L .6443 .50131 L p F P
0 g
s
.758 .557 .625 r
.44543 .69082 m .44229 .67009 L .43584 .68919 L closepath p F P
0 g
s
.747 .55 .628 r
.46889 .69397 m .44543 .69082 L .44229 .67009 L p F P
0 g
s
.671 .473 .61 r
.55572 .70871 m .56195 .69498 L .5544 .69562 L closepath p F P
0 g
s
.687 .485 .608 r
.5544 .69562 m .55572 .70871 L .55273 .71673 L p F P
0 g
s
.788 .673 .737 r
.40931 .52504 m .39849 .5382 L .38712 .51663 L p F P
0 g
s
.788 .673 .737 r
.38712 .51663 m .38776 .51586 L .40931 .52504 L p F P
0 g
s
.783 .678 .748 r
.40749 .49375 m .38776 .51586 L .40931 .52504 L p F P
0 g
s
.727 .67 .794 r
.49934 .44762 m .47922 .46105 L .46809 .44165 L p F P
0 g
s
.796 .646 .696 r
.38914 .59376 m .39662 .58147 L .38188 .5759 L closepath p F P
0 g
s
.791 .653 .71 r
.37793 .56703 m .38996 .54949 L p .39662 .58147 L F P
0 g
s
.791 .653 .71 r
.39662 .58147 m .38188 .5759 L .37793 .56703 L p F P
0 g
s
.605 .496 .704 r
.6473 .58071 m .64553 .57421 L .66624 .57015 L p F P
0 g
s
.607 .505 .713 r
.65929 .54616 m .66624 .57015 L .64553 .57421 L p F P
0 g
s
.664 .466 .607 r
.56195 .69498 m .57836 .69332 L p .55645 .71652 L F P
0 g
s
.664 .466 .607 r
.55645 .71652 m .55572 .70871 L .56195 .69498 L p F P
0 g
s
.621 .554 .758 r
.63857 .48607 m .6443 .50131 L .62369 .50619 L p F P
0 g
s
.621 .554 .758 r
.62369 .50619 m .61932 .49459 L .63857 .48607 L p F P
0 g
s
.724 .515 .608 r
.50219 .71742 m .47726 .7158 L .47523 .69463 L p F P
0 g
s
.736 .525 .606 r
.46889 .69397 m .47523 .69463 L .47726 .7158 L p F P
0 g
s
.61 .469 .666 r
.63801 .63593 m .63631 .62772 L .6569 .62122 L p F P
0 g
s
.612 .477 .673 r
.65348 .60567 m .6569 .62122 L .63631 .62772 L p F P
0 g
s
.599 .481 .69 r
.65348 .60567 m .6473 .58071 L .667 .57295 L p F P
0 g
s
.605 .496 .704 r
.66624 .57015 m .667 .57295 L .6473 .58071 L p F P
0 g
s
.648 .596 .782 r
.60219 .45348 m .60488 .45955 L .58445 .46655 L p F P
0 g
s
.648 .596 .782 r
.58445 .46655 m .58176 .46051 L .60219 .45348 L p F P
0 g
s
.736 .525 .606 r
.47726 .7158 m .46362 .71441 L .46889 .69397 L p F P
0 g
s
.747 .535 .609 r
.44543 .69082 m .46889 .69397 L .46362 .71441 L p F P
0 g
s
.798 .676 .73 r
.38996 .54949 m .39849 .5382 L .38712 .51663 L p F P
0 g
s
.625 .565 .767 r
.63353 .47335 m .63857 .48607 L .61932 .49459 L p F P
0 g
s
.625 .565 .767 r
.61932 .49459 m .61293 .47854 L .63353 .47335 L p F P
0 g
s
.648 .454 .607 r
.58041 .71412 m .57836 .69332 L .6014 .68994 L p F P
0 g
s
.664 .466 .607 r
.57836 .69332 m .58041 .71412 L .55645 .71652 L p F P
0 g
s
.786 .611 .664 r
.40284 .63568 m .40013 .62622 L .39646 .63383 L closepath p F P
0 g
s
.797 .625 .669 r
.39421 .60773 m .38341 .60398 L p .39646 .63383 L F P
0 g
s
.797 .625 .669 r
.39646 .63383 m .40013 .62622 L .39421 .60773 L p F P
0 g
s
.793 .634 .684 r
.39421 .60773 m .38914 .59376 L .38341 .60398 L closepath p F P
0 g
s
.753 .679 .779 r
.45283 .4652 m .44792 .45673 L .44204 .46159 L closepath p F P
0 g
s
.756 .675 .772 r
.42773 .47408 m .44204 .46159 L .45283 .4652 L p F P
0 g
s
.604 .452 .649 r
.642 .65849 m .63801 .63593 L .65861 .62945 L p F P
0 g
s
.61 .469 .666 r
.6569 .62122 m .65861 .62945 L .63801 .63593 L p F P
0 g
s
.622 .465 .647 r
.63801 .63593 m .642 .65849 L .62058 .66389 L p F P
0 g
s
.712 .664 .801 r
.51952 .43575 m .49934 .44762 L .48828 .42813 L p F P
0 g
s
.727 .67 .794 r
.46809 .44165 m .48828 .42813 L .49934 .44762 L p F P
0 g
s
.652 .61 .794 r
.60219 .45348 m .58176 .46051 L .57098 .43786 L p F P
0 g
s
.669 .618 .789 r
.55065 .44654 m .57098 .43786 L .58176 .46051 L p F P
0 g
s
.779 .595 .651 r
.41374 .66227 m .40892 .66105 L .40284 .63568 L p F P
0 g
s
.788 .601 .647 r
.39646 .63383 m .40284 .63568 L .40892 .66105 L p F P
0 g
s
.617 .447 .629 r
.62366 .68556 m .62058 .66389 L .642 .65849 L p F P
0 g
s
.635 .46 .628 r
.62058 .66389 m .62366 .68556 L .6014 .68994 L p F P
0 g
s
.805 .649 .69 r
.38341 .60398 m .38914 .59376 L .38188 .5759 L p F P
0 g
s
.715 .506 .605 r
.5051 .71754 m .50438 .70966 L .50219 .71742 L closepath p F P
0 g
s
.803 .67 .717 r
.38996 .54949 m .37793 .56703 L .36651 .5442 L p F P
0 g
s
.803 .67 .717 r
.36651 .5442 m .36939 .54002 L .38996 .54949 L p F P
0 g
s
.798 .676 .73 r
.38712 .51663 m .36939 .54002 L .38996 .54949 L p F P
0 g
s
.674 .633 .802 r
.56395 .42411 m .57098 .43786 L .55065 .44654 L p F P
0 g
s
.674 .633 .802 r
.55065 .44654 m .54142 .42861 L .56395 .42411 L p F P
0 g
s
.69 .641 .795 r
.54142 .42861 m .55065 .44654 L p .51952 .43575 L F P
0 g
s
.627 .578 .779 r
.62395 .45064 m .63353 .47335 L .61293 .47854 L p F P
0 g
s
.627 .578 .779 r
.61293 .47854 m .60488 .45955 L .62395 .45064 L p F P
0 g
s
.592 .464 .674 r
.6569 .62122 m .65348 .60567 L .67323 .59798 L p F P
0 g
s
.599 .481 .69 r
.667 .57295 m .67323 .59798 L .65348 .60567 L p F P
0 g
s
.68 .477 .605 r
.55645 .71652 m .55572 .70871 L .55273 .71673 L closepath p F P
0 g
s
.747 .535 .609 r
.46362 .71441 m .4476 .71228 L .44543 .69082 L p F P
0 g
s
.758 .544 .606 r
.43584 .68919 m .44543 .69082 L .4476 .71228 L p F P
0 g
s
.788 .601 .647 r
.40892 .66105 m .38791 .65502 L .39646 .63383 L p F P
0 g
s
.8 .615 .651 r
.37282 .62573 m .39646 .63383 L .38791 .65502 L p F P
0 g
s
.797 .625 .669 r
.38341 .60398 m .37282 .62573 L .39646 .63383 L p F P
0 g
s
.769 .569 .629 r
.41076 .67095 m .41374 .66227 L p .43584 .68919 L F P
0 g
s
.781 .583 .632 r
.41076 .67095 m .41374 .66227 L .40892 .66105 L closepath p F P
0 g
s
.765 .693 .782 r
.44204 .46159 m .42773 .47408 L .41634 .45581 L p F P
0 g
s
.777 .696 .774 r
.41634 .45581 m .42773 .47408 L .41111 .49003 L p F P
0 g
s
.629 .441 .608 r
.60354 .71076 m .6014 .68994 L .62366 .68556 L p F P
0 g
s
.648 .454 .607 r
.6014 .68994 m .60354 .71076 L .58041 .71412 L p F P
0 g
s
.805 .649 .69 r
.38188 .5759 m .37429 .57276 L p .38341 .60398 L F P
0 g
s
.8 .656 .704 r
.38188 .5759 m .37793 .56703 L .37429 .57276 L closepath p F P
0 g
s
.765 .693 .782 r
.41634 .45581 m .42056 .45212 L .44204 .46159 L p F P
0 g
s
.761 .696 .79 r
.4366 .43885 m .42056 .45212 L .44204 .46159 L p F P
0 g
s
.761 .696 .79 r
.44204 .46159 m .44792 .45673 L .4366 .43885 L p F P
0 g
s
.791 .589 .629 r
.40892 .66105 m .38791 .65502 L p .40697 .68302 L F P
0 g
s
.791 .589 .629 r
.40697 .68302 m .41076 .67095 L .40892 .66105 L p F P
0 g
s
.782 .693 .765 r
.40749 .49375 m .41111 .49003 L .40272 .48594 L closepath p F P
0 g
s
.777 .696 .774 r
.39601 .4753 m .41634 .45581 L p .41111 .49003 L F P
0 g
s
.777 .696 .774 r
.41111 .49003 m .40272 .48594 L .39601 .4753 L p F P
0 g
s
.809 .641 .674 r
.36169 .5951 m .38341 .60398 L .37282 .62573 L p F P
0 g
s
.805 .649 .69 r
.37429 .57276 m .36169 .5951 L .38341 .60398 L p F P
0 g
s
.793 .695 .757 r
.40272 .48594 m .40749 .49375 L .38776 .51586 L p F P
0 g
s
.748 .692 .798 r
.46809 .44165 m .44792 .45673 L .4366 .43885 L p F P
0 g
s
.758 .544 .606 r
.4476 .71228 m .43098 .70949 L .43584 .68919 L p F P
0 g
s
.77 .556 .609 r
.413 .68447 m .43584 .68919 L .43098 .70949 L p F P
0 g
s
.769 .569 .629 r
.43584 .68919 m .413 .68447 L .41076 .67095 L p F P
0 g
s
.69 .641 .795 r
.51952 .43575 m .53218 .42931 L .54142 .42861 L p F P
0 g
s
.696 .658 .808 r
.51952 .43575 m .53218 .42931 L .51609 .42965 L closepath p F P
0 g
s
.712 .664 .801 r
.51609 .42965 m .51952 .43575 L p .48828 .42813 L F P
0 g
s
.683 .467 .587 r
.5313 .71758 m .55273 .71673 L .5488 .73701 L p F P
0 g
s
.683 .467 .587 r
.5488 .73701 m .53234 .73766 L .5313 .71758 L p F P
0 g
s
.699 .479 .586 r
.5313 .71758 m .53234 .73766 L .50604 .73761 L p F P
0 g
s
.699 .479 .586 r
.50604 .73761 m .5051 .71754 L .5313 .71758 L p F P
0 g
s
.713 .49 .585 r
.50219 .71742 m .5051 .71754 L .50604 .73761 L p F P
0 g
s
.713 .49 .585 r
.50604 .73761 m .49921 .73734 L .50219 .71742 L p F P
0 g
s
.722 .499 .586 r
.47726 .7158 m .50219 .71742 L .49921 .73734 L p F P
0 g
s
.593 .508 .728 r
.65929 .54616 m .65517 .53299 L .67606 .53071 L p F P
0 g
s
.594 .518 .739 r
.66846 .50779 m .67606 .53071 L .65517 .53299 L p F P
0 g
s
.594 .518 .739 r
.65517 .53299 m .65002 .51748 L .66846 .50779 L p F P
0 g
s
.586 .493 .715 r
.65929 .54616 m .67799 .53688 L p .67408 .5696 L F P
0 g
s
.586 .493 .715 r
.67408 .5696 m .66624 .57015 L .65929 .54616 L p F P
0 g
s
.593 .508 .728 r
.67606 .53071 m .67799 .53688 L .65929 .54616 L p F P
0 g
s
.6 .531 .75 r
.66514 .49838 m .66846 .50779 L .65002 .51748 L p F P
0 g
s
.6 .531 .75 r
.65002 .51748 m .6443 .50131 L .66514 .49838 L p F P
0 g
s
.591 .457 .667 r
.65861 .62945 m .6569 .62122 L .67776 .61839 L p F P
0 g
s
.592 .464 .674 r
.67323 .59798 m .67776 .61839 L .6569 .62122 L p F P
0 g
s
.812 .673 .71 r
.37429 .57276 m .37793 .56703 L .36651 .5442 L p F P
0 g
s
.676 .46 .585 r
.55273 .71673 m .55645 .71652 L .55752 .73651 L p F P
0 g
s
.676 .46 .585 r
.55752 .73651 m .5488 .73701 L .55273 .71673 L p F P
0 g
s
.66 .447 .586 r
.55752 .73651 m .55645 .71652 L .58041 .71412 L p F P
0 g
s
.631 .587 .787 r
.6228 .44803 m .62395 .45064 L .60488 .45955 L p F P
0 g
s
.631 .587 .787 r
.60488 .45955 m .60219 .45348 L .6228 .44803 L p F P
0 g
s
.779 .576 .626 r
.413 .68447 m .41076 .67095 L .40697 .68302 L closepath p F P
0 g
s
.601 .542 .761 r
.6567 .47587 m .66514 .49838 L .6443 .50131 L p F P
0 g
s
.601 .542 .761 r
.6443 .50131 m .63857 .48607 L .6567 .47587 L p F P
0 g
s
.734 .688 .806 r
.48828 .42813 m .46809 .44165 L .45684 .42369 L p F P
0 g
s
.748 .692 .798 r
.4366 .43885 m .45684 .42369 L .46809 .44165 L p F P
0 g
s
.586 .485 .706 r
.667 .57295 m .66624 .57015 L .67408 .5696 L closepath p F P
0 g
s
.722 .499 .586 r
.49921 .73734 m .47817 .73599 L .47726 .7158 L p F P
0 g
s
.735 .509 .585 r
.46362 .71441 m .47726 .7158 L .47817 .73599 L p F P
0 g
s
.579 .468 .692 r
.67323 .59798 m .667 .57295 L .67408 .5696 L p F P
0 g
s
.799 .691 .746 r
.38712 .51663 m .38776 .51586 L .38616 .51502 L closepath p F P
0 g
s
.793 .695 .757 r
.39155 .47996 m .40272 .48594 L p .38776 .51586 L F P
0 g
s
.793 .695 .757 r
.37555 .49785 m .39155 .47996 L p .38776 .51586 L F P
0 g
s
.793 .695 .757 r
.38776 .51586 m .38616 .51502 L .37555 .49785 L p F P
0 g
s
.597 .433 .63 r
.64515 .6802 m .642 .65849 L .66267 .65206 L p F P
0 g
s
.604 .452 .649 r
.65861 .62945 m .66267 .65206 L .642 .65849 L p F P
0 g
s
.617 .447 .629 r
.642 .65849 m .64515 .6802 L .62366 .68556 L p F P
0 g
s
.809 .694 .738 r
.38616 .51502 m .38712 .51663 L .36939 .54002 L p F P
0 g
s
.817 .666 .696 r
.35449 .56307 m .37429 .57276 L .36169 .5951 L p F P
0 g
s
.812 .673 .71 r
.36651 .5442 m .35449 .56307 L .37429 .57276 L p F P
0 g
s
.695 .662 .814 r
.53218 .42931 m .51609 .42965 L .50852 .41655 L p F P
0 g
s
.712 .664 .801 r
.48828 .42813 m .48996 .42714 L .51609 .42965 L p F P
0 g
s
.71 .668 .807 r
.51609 .42965 m .50852 .41655 L .48996 .42714 L closepath p F P
0 g
s
.584 .438 .65 r
.66267 .65206 m .65861 .62945 L .67851 .62193 L p F P
0 g
s
.591 .457 .667 r
.67776 .61839 m .67851 .62193 L .65861 .62945 L p F P
0 g
s
.633 .601 .799 r
.6228 .44803 m .60219 .45348 L .59145 .43075 L p F P
0 g
s
.652 .61 .794 r
.57098 .43786 m .59145 .43075 L .60219 .45348 L p F P
0 g
s
.655 .625 .808 r
.58444 .41693 m .59145 .43075 L .57098 .43786 L p F P
0 g
s
.655 .625 .808 r
.57098 .43786 m .56395 .42411 L .58444 .41693 L p F P
0 g
s
.809 .694 .738 r
.36926 .50547 m .38616 .51502 L p .36939 .54002 L F P
0 g
s
.803 .698 .749 r
.38616 .51502 m .37555 .49785 L .36926 .50547 L closepath p F P
0 g
s
.69 .647 .802 r
.54142 .42861 m .53978 .42554 L .53218 .42931 L closepath p F P
0 g
s
.695 .662 .814 r
.52884 .40641 m .53978 .42554 L .53218 .42931 L p F P
0 g
s
.695 .662 .814 r
.50852 .41655 m .52884 .40641 L p .53218 .42931 L F P
0 g
s
.606 .555 .771 r
.65434 .46991 m .6567 .47587 L .63857 .48607 L p F P
0 g
s
.606 .555 .771 r
.63857 .48607 m .63353 .47335 L .65434 .46991 L p F P
0 g
s
.735 .509 .585 r
.47817 .73599 m .46082 .73423 L .46362 .71441 L p F P
0 g
s
.746 .519 .586 r
.4476 .71228 m .46362 .71441 L .46082 .73423 L p F P
0 g
s
.788 .699 .766 r
.40272 .48594 m .39601 .4753 L .39155 .47996 L closepath p F P
0 g
s
.674 .64 .808 r
.56016 .41691 m .56395 .42411 L .54142 .42861 L p F P
0 g
s
.674 .64 .808 r
.54142 .42861 m .53978 .42554 L .56016 .41691 L p F P
0 g
s
.61 .426 .609 r
.62589 .70641 m .62366 .68556 L .64515 .6802 L p F P
0 g
s
.629 .441 .608 r
.62366 .68556 m .62589 .70641 L .60354 .71076 L p F P
0 g
s
.642 .434 .586 r
.58158 .73413 m .58041 .71412 L .60354 .71076 L p F P
0 g
s
.66 .447 .586 r
.58041 .71412 m .58158 .73413 L .55752 .73651 L p F P
0 g
s
.719 .682 .814 r
.48828 .42813 m .48996 .42714 L .48735 .42664 L closepath p F P
0 g
s
.734 .688 .806 r
.48735 .42664 m .48828 .42813 L p .45684 .42369 L F P
0 g
s
.678 .656 .82 r
.56016 .41691 m .53978 .42554 L .52884 .40641 L p F P
0 g
s
.77 .556 .609 r
.43098 .70949 m .41539 .70629 L .413 .68447 L p F P
0 g
s
.78 .563 .606 r
.40697 .68302 m .413 .68447 L .41539 .70629 L p F P
0 g
s
.716 .686 .819 r
.49741 .39882 m .50852 .41655 L .48996 .42714 L p F P
0 g
s
.716 .686 .819 r
.4771 .41046 m .49741 .39882 L p .48996 .42714 L F P
0 g
s
.716 .686 .819 r
.48996 .42714 m .48735 .42664 L .4771 .41046 L p F P
0 g
s
.607 .567 .783 r
.64361 .44435 m .65434 .46991 L .63353 .47335 L p F P
0 g
s
.607 .567 .783 r
.63058 .44658 m .64361 .44435 L p .63353 .47335 L F P
0 g
s
.607 .567 .783 r
.63353 .47335 m .62395 .45064 L .63058 .44658 L p F P
0 g
s
.579 .468 .692 r
.67408 .5696 m .68724 .56923 L p .67323 .59798 L F P
0 g
s
.579 .476 .701 r
.68724 .56923 m .67408 .5696 L .68582 .56386 L closepath p F P
0 g
s
.586 .493 .715 r
.67799 .53688 m .68582 .56386 L .67408 .5696 L p F P
0 g
s
.734 .688 .806 r
.45684 .42369 m .46317 .41944 L .48735 .42664 L p F P
0 g
s
.731 .691 .812 r
.48735 .42664 m .4771 .41046 L .46317 .41944 L closepath p F P
0 g
s
.571 .45 .676 r
.67323 .59798 m .69222 .58912 L p .68569 .61871 L F P
0 g
s
.571 .45 .676 r
.68569 .61871 m .67776 .61839 L .67323 .59798 L p F P
0 g
s
.579 .468 .692 r
.68724 .56923 m .69222 .58912 L .67323 .59798 L p F P
0 g
s
.746 .519 .586 r
.46082 .73423 m .44852 .73261 L .4476 .71228 L p F P
0 g
s
.758 .529 .585 r
.43098 .70949 m .4476 .71228 L .44852 .73261 L p F P
0 g
s
.791 .589 .629 r
.38791 .65502 m .38129 .67572 L .40697 .68302 L p F P
0 g
s
.804 .604 .632 r
.3711 .64933 m .38791 .65502 L .38129 .67572 L p F P
0 g
s
.8 .615 .651 r
.36795 .63767 m .37282 .62573 L p .38791 .65502 L F P
0 g
s
.8 .615 .651 r
.38791 .65502 m .3711 .64933 L .36795 .63767 L p F P
0 g
s
.78 .563 .606 r
.41539 .70629 m .40242 .70321 L .40697 .68302 L p F P
0 g
s
.793 .576 .608 r
.38129 .67572 m .40697 .68302 L .40242 .70321 L p F P
0 g
s
.809 .694 .738 r
.35488 .52439 m .36926 .50547 L p .36939 .54002 L F P
0 g
s
.809 .694 .738 r
.36939 .54002 m .36168 .53573 L .35488 .52439 L p F P
0 g
s
.815 .689 .725 r
.36651 .5442 m .36939 .54002 L .36168 .53573 L closepath p F P
0 g
s
.814 .632 .656 r
.36795 .63767 m .37282 .62573 L .36302 .62178 L closepath p F P
0 g
s
.809 .641 .674 r
.35688 .6049 m .36169 .5951 L p .37282 .62573 L F P
0 g
s
.809 .641 .674 r
.37282 .62573 m .36302 .62178 L .35688 .6049 L p F P
0 g
s
.623 .419 .586 r
.60482 .73078 m .60354 .71076 L .62589 .70641 L p F P
0 g
s
.642 .434 .586 r
.60354 .71076 m .60482 .73078 L .58158 .73413 L p F P
0 g
s
.824 .691 .717 r
.35449 .56307 m .36651 .5442 L .36168 .53573 L p F P
0 g
s
.657 .632 .813 r
.58066 .4097 m .58444 .41693 L .56395 .42411 L p F P
0 g
s
.657 .632 .813 r
.56395 .42411 m .56016 .41691 L .58066 .4097 L p F P
0 g
s
.775 .712 .793 r
.41634 .45581 m .42056 .45212 L .40913 .44541 L closepath p F P
0 g
s
.787 .715 .784 r
.41634 .45581 m .39601 .4753 L .38436 .45873 L p F P
0 g
s
.787 .715 .784 r
.40913 .44541 m .41634 .45581 L p .38436 .45873 L F P
0 g
s
.769 .714 .801 r
.42513 .42243 m .4366 .43885 L .42056 .45212 L p F P
0 g
s
.769 .714 .801 r
.40478 .43927 m .42513 .42243 L p .42056 .45212 L F P
0 g
s
.769 .714 .801 r
.42056 .45212 m .40913 .44541 L .40478 .43927 L p F P
0 g
s
.823 .659 .679 r
.35688 .6049 m .36169 .5951 L .3505 .5897 L closepath p F P
0 g
s
.817 .666 .696 r
.34548 .57893 m .35449 .56307 L p .36169 .5951 L F P
0 g
s
.817 .666 .696 r
.36169 .5951 m .3505 .5897 L .34548 .57893 L p F P
0 g
s
.758 .529 .585 r
.44852 .73261 m .42831 .72925 L .43098 .70949 L p F P
0 g
s
.77 .54 .586 r
.41539 .70629 m .43098 .70949 L .42831 .72925 L p F P
0 g
s
.7 .68 .827 r
.52884 .40641 m .50852 .41655 L .49741 .39882 L p F P
0 g
s
.798 .717 .776 r
.39155 .47996 m .39601 .4753 L .38436 .45873 L p F P
0 g
s
.575 .418 .63 r
.66591 .67382 m .66267 .65206 L .68264 .6446 L p F P
0 g
s
.584 .438 .65 r
.67851 .62193 m .68264 .6446 L .66267 .65206 L p F P
0 g
s
.597 .433 .63 r
.66267 .65206 m .66591 .67382 L .64515 .6802 L p F P
0 g
s
.679 .447 .563 r
.53234 .73766 m .5488 .73701 L .54893 .75622 L p F P
0 g
s
.679 .447 .563 r
.54893 .75622 m .5324 .75687 L .53234 .73766 L p F P
0 g
s
.695 .46 .563 r
.53234 .73766 m .5324 .75687 L .50596 .75683 L p F P
0 g
s
.695 .46 .563 r
.50596 .75683 m .50604 .73761 L .53234 .73766 L p F P
0 g
s
.804 .715 .766 r
.39155 .47996 m .37555 .49785 L .36381 .48097 L p F P
0 g
s
.804 .715 .766 r
.36381 .48097 m .37474 .46876 L .39155 .47996 L p F P
0 g
s
.798 .717 .776 r
.38436 .45873 m .37474 .46876 L .39155 .47996 L p F P
0 g
s
.71 .472 .563 r
.49921 .73734 m .50604 .73761 L .50596 .75683 L p F P
0 g
s
.756 .711 .81 r
.45684 .42369 m .4366 .43885 L .42513 .42243 L p F P
0 g
s
.589 .411 .609 r
.64747 .70108 m .64515 .6802 L .66591 .67382 L p F P
0 g
s
.61 .426 .609 r
.64515 .6802 m .64747 .70108 L .62589 .70641 L p F P
0 g
s
.573 .496 .73 r
.67799 .53688 m .67606 .53071 L .68838 .53069 L closepath p F P
0 g
s
.572 .505 .741 r
.68838 .53069 m .67606 .53071 L .66846 .50779 L p F P
0 g
s
.71 .472 .563 r
.50596 .75683 m .4991 .75656 L .49921 .73734 L p F P
0 g
s
.72 .48 .562 r
.47817 .73599 m .49921 .73734 L .4991 .75656 L p F P
0 g
s
.565 .48 .717 r
.68582 .56386 m .67799 .53688 L .68838 .53069 L p F P
0 g
s
.633 .601 .799 r
.59145 .43075 m .61208 .42519 L .6228 .44803 L p F P
0 g
s
.636 .616 .813 r
.60294 .40703 m .61208 .42519 L .59145 .43075 L p F P
0 g
s
.636 .616 .813 r
.59145 .43075 m .58444 .41693 L .60294 .40703 L p F P
0 g
s
.571 .444 .668 r
.67851 .62193 m .67776 .61839 L .68569 .61871 L closepath p F P
0 g
s
.612 .577 .791 r
.62395 .45064 m .6228 .44803 L .63058 .44658 L closepath p F P
0 g
s
.672 .441 .562 r
.5488 .73701 m .55752 .73651 L .5577 .75573 L p F P
0 g
s
.672 .441 .562 r
.5577 .75573 m .54893 .75622 L .5488 .73701 L p F P
0 g
s
.572 .505 .741 r
.66846 .50779 m .68447 .49752 L p .68838 .53069 L F P
0 g
s
.579 .52 .753 r
.66846 .50779 m .66514 .49838 L .68447 .49752 L closepath p F P
0 g
s
.562 .424 .65 r
.68264 .6446 m .67851 .62193 L .68569 .61871 L p F P
0 g
s
.654 .427 .562 r
.5577 .75573 m .55752 .73651 L .58158 .73413 L p F P
0 g
s
.613 .591 .804 r
.63058 .44658 m .6228 .44803 L .61208 .42519 L p F P
0 g
s
.822 .636 .651 r
.36302 .62178 m .35148 .61675 L p .36447 .64688 L F P
0 g
s
.822 .636 .651 r
.36447 .64688 m .36795 .63767 L .36302 .62178 L p F P
0 g
s
.818 .645 .668 r
.36302 .62178 m .35688 .6049 L .35148 .61675 L closepath p F P
0 g
s
.579 .53 .765 r
.68447 .49752 m .66514 .49838 L .6567 .47587 L p F P
0 g
s
.824 .691 .717 r
.36168 .53573 m .35123 .52956 L p .35449 .56307 L F P
0 g
s
.818 .696 .73 r
.36168 .53573 m .35488 .52439 L .35123 .52956 L closepath p F P
0 g
s
.66 .648 .827 r
.58066 .4097 m .56016 .41691 L .54927 .3977 L p F P
0 g
s
.678 .656 .82 r
.52884 .40641 m .54927 .3977 L .56016 .41691 L p F P
0 g
s
.809 .62 .647 r
.3711 .64933 m .36795 .63767 L .36447 .64688 L closepath p F P
0 g
s
.72 .48 .562 r
.4991 .75656 m .47796 .75521 L .47817 .73599 L p F P
0 g
s
.734 .492 .562 r
.46082 .73423 m .47817 .73599 L .47796 .75521 L p F P
0 g
s
.814 .716 .757 r
.36926 .50547 m .37555 .49785 L .36381 .48097 L p F P
0 g
s
.556 .461 .703 r
.68724 .56923 m .68582 .56386 L .70372 .55335 L p F P
0 g
s
.565 .48 .717 r
.69725 .53109 m .70372 .55335 L .68582 .56386 L p F P
0 g
s
.565 .48 .717 r
.68838 .53069 m .69725 .53109 L p .68582 .56386 L F P
0 g
s
.742 .707 .819 r
.45684 .42369 m .46317 .41944 L .44974 .41338 L closepath p F P
0 g
s
.756 .711 .81 r
.44974 .41338 m .45684 .42369 L p .42513 .42243 L F P
0 g
s
.831 .662 .673 r
.35148 .61675 m .35688 .6049 L .3505 .5897 L p F P
0 g
s
.804 .604 .632 r
.38129 .67572 m .37633 .67406 L .3711 .64933 L p F P
0 g
s
.813 .61 .628 r
.36447 .64688 m .3711 .64933 L .37633 .67406 L p F P
0 g
s
.557 .454 .693 r
.69222 .58912 m .68724 .56923 L .70861 .57169 L p F P
0 g
s
.556 .461 .703 r
.70372 .55335 m .70861 .57169 L .68724 .56923 L p F P
0 g
s
.602 .404 .585 r
.62726 .72646 m .62589 .70641 L .64747 .70108 L p F P
0 g
s
.623 .419 .586 r
.62589 .70641 m .62726 .72646 L .60482 .73078 L p F P
0 g
s
.83 .685 .702 r
.35449 .56307 m .34548 .57893 L .33381 .55728 L p F P
0 g
s
.83 .685 .702 r
.33381 .55728 m .33648 .55261 L .35449 .56307 L p F P
0 g
s
.824 .691 .717 r
.35123 .52956 m .33648 .55261 L .35449 .56307 L p F P
0 g
s
.77 .54 .586 r
.42831 .72925 m .41634 .72682 L .41539 .70629 L p F P
0 g
s
.781 .549 .584 r
.40242 .70321 m .41539 .70629 L .41634 .72682 L p F P
0 g
s
.821 .713 .746 r
.36926 .50547 m .35488 .52439 L .34304 .5071 L p F P
0 g
s
.821 .713 .746 r
.34304 .5071 m .35288 .49418 L .36926 .50547 L p F P
0 g
s
.814 .716 .757 r
.36381 .48097 m .35288 .49418 L .36926 .50547 L p F P
0 g
s
.738 .709 .824 r
.4658 .39412 m .4771 .41046 L .46317 .41944 L p F P
0 g
s
.738 .709 .824 r
.44546 .40727 m .4658 .39412 L p .46317 .41944 L F P
0 g
s
.738 .709 .824 r
.46317 .41944 m .44974 .41338 L .44546 .40727 L p F P
0 g
s
.734 .492 .562 r
.47796 .75521 m .46053 .75346 L .46082 .73423 L p F P
0 g
s
.745 .501 .562 r
.44852 .73261 m .46082 .73423 L .46053 .75346 L p F P
0 g
s
.636 .412 .561 r
.58187 .75336 m .58158 .73413 L .60482 .73078 L p F P
0 g
s
.654 .427 .562 r
.58158 .73413 m .58187 .75336 L .5577 .75573 L p F P
0 g
s
.579 .53 .765 r
.6567 .47587 m .6666 .46893 L p .68447 .49752 L F P
0 g
s
.586 .543 .774 r
.6567 .47587 m .65434 .46991 L .6666 .46893 L closepath p F P
0 g
s
.608 .581 .797 r
.64361 .44435 m .63058 .44658 L .64138 .43938 L closepath p F P
0 g
s
.613 .591 .804 r
.63291 .42121 m .64138 .43938 L .63058 .44658 L p F P
0 g
s
.613 .591 .804 r
.61208 .42519 m .63291 .42121 L p .63058 .44658 L F P
0 g
s
.562 .424 .65 r
.68569 .61871 m .69902 .62042 L p .68264 .6446 L F P
0 g
s
.561 .429 .657 r
.69902 .62042 m .68569 .61871 L .69762 .61322 L closepath p F P
0 g
s
.571 .45 .676 r
.69222 .58912 m .69762 .61322 L .68569 .61871 L p F P
0 g
s
.683 .673 .834 r
.54927 .3977 m .52884 .40641 L .5178 .3886 L p F P
0 g
s
.7 .68 .827 r
.49741 .39882 m .5178 .3886 L .52884 .40641 L p F P
0 g
s
.585 .555 .787 r
.6666 .46893 m .65434 .46991 L .64361 .44435 L p F P
0 g
s
.831 .662 .673 r
.3505 .5897 m .34208 .58538 L p .35148 .61675 L F P
0 g
s
.825 .669 .689 r
.3505 .5897 m .34548 .57893 L .34208 .58538 L closepath p F P
0 g
s
.793 .576 .608 r
.37837 .68835 m .38129 .67572 L p .40242 .70321 L F P
0 g
s
.807 .591 .61 r
.37837 .68835 m .38129 .67572 L .37633 .67406 L closepath p F P
0 g
s
.813 .61 .628 r
.37633 .67406 m .35828 .66745 L .36447 .64688 L p F P
0 g
s
.827 .625 .631 r
.34342 .63782 m .36447 .64688 L .35828 .66745 L p F P
0 g
s
.822 .636 .651 r
.35148 .61675 m .34342 .63782 L .36447 .64688 L p F P
0 g
s
.723 .704 .832 r
.49741 .39882 m .4771 .41046 L .4658 .39412 L p F P
0 g
s
.638 .623 .819 r
.60133 .40392 m .60294 .40703 L .58444 .41693 L p F P
0 g
s
.638 .623 .819 r
.58444 .41693 m .58066 .4097 L .60133 .40392 L p F P
0 g
s
.547 .434 .677 r
.69762 .61322 m .69222 .58912 L .71046 .57906 L p F P
0 g
s
.557 .454 .693 r
.70861 .57169 m .71046 .57906 L .69222 .58912 L p F P
0 g
s
.745 .501 .562 r
.46053 .75346 m .44817 .75185 L .44852 .73261 L p F P
0 g
s
.758 .512 .561 r
.42831 .72925 m .44852 .73261 L .44817 .75185 L p F P
0 g
s
.781 .717 .792 r
.40913 .44541 m .40478 .43927 L .4026 .44125 L closepath p F P
0 g
s
.787 .715 .784 r
.38436 .45873 m .4026 .44125 L .40913 .44541 L p F P
0 g
s
.684 .441 .548 r
.64911 .38761 m .66018 .38738 L .66102 .40937 L p F P
0 g
s
.684 .441 .548 r
.66102 .40937 m .64988 .40961 L .64911 .38761 L p F P
0 g
s
.703 .455 .547 r
.63367 .38716 m .64911 .38761 L .64988 .40961 L p F P
0 g
s
.649 .413 .548 r
.66102 .40937 m .66018 .38738 L .68441 .38457 L p F P
0 g
s
.795 .562 .585 r
.37939 .69673 m .40242 .70321 L .39984 .72294 L p F P
0 g
s
.793 .576 .608 r
.40242 .70321 m .37939 .69673 L .37837 .68835 L p F P
0 g
s
.781 .549 .584 r
.41634 .72682 m .39984 .72294 L .40242 .70321 L p F P
0 g
s
.703 .455 .547 r
.64988 .40961 m .63436 .40916 L .63367 .38716 L p F P
0 g
s
.735 .481 .545 r
.60984 .38431 m .63367 .38716 L .63436 .40916 L p F P
0 g
s
.564 .488 .728 r
.69725 .53109 m .68838 .53069 L .69571 .52608 L closepath p F P
0 g
s
.572 .505 .741 r
.68624 .49751 m .69571 .52608 L .68838 .53069 L p F P
0 g
s
.572 .505 .741 r
.68447 .49752 m .68624 .49751 L p .68838 .53069 L F P
0 g
s
.83 .714 .738 r
.35123 .52956 m .35488 .52439 L .34304 .5071 L p F P
0 g
s
.836 .653 .655 r
.33217 .60696 m .35148 .61675 L .34342 .63782 L p F P
0 g
s
.831 .662 .673 r
.34208 .58538 m .33217 .60696 L .35148 .61675 L p F P
0 g
s
.816 .597 .607 r
.37633 .67406 m .35828 .66745 L p .37675 .69591 L F P
0 g
s
.816 .597 .607 r
.37675 .69591 m .37837 .68835 L .37633 .67406 L p F P
0 g
s
.566 .394 .608 r
.66832 .69474 m .66591 .67382 L .68596 .66641 L p F P
0 g
s
.589 .411 .609 r
.66591 .67382 m .66832 .69474 L .64747 .70108 L p F P
0 g
s
.575 .418 .63 r
.68264 .6446 m .68596 .66641 L .66591 .67382 L p F P
0 g
s
.838 .687 .695 r
.34208 .58538 m .34548 .57893 L .33381 .55728 L p F P
0 g
s
.552 .402 .63 r
.68596 .66641 m .68264 .6446 L .70192 .63607 L p F P
0 g
s
.562 .424 .65 r
.69902 .62042 m .70192 .63607 L .68264 .6446 L p F P
0 g
s
.615 .396 .56 r
.60522 .75003 m .60482 .73078 L .62726 .72646 L p F P
0 g
s
.636 .412 .561 r
.60482 .73078 m .60522 .75003 L .58187 .75336 L p F P
0 g
s
.837 .711 .724 r
.33516 .51822 m .35123 .52956 L .33648 .55261 L p F P
0 g
s
.83 .714 .738 r
.34304 .5071 m .33516 .51822 L .35123 .52956 L p F P
0 g
s
.735 .481 .545 r
.63436 .40916 m .62663 .40824 L p .60984 .38431 L F P
0 g
s
.735 .481 .545 r
.62663 .40824 m .62491 .40759 L .60984 .38431 L F
.62523 .40808 m .62348 .40737 L .62323 .40696 L F
.62491 .40759 m .62323 .40696 L .60984 .38431 L F
.62523 .40808 m .62323 .40696 L .62491 .40759 L F
.62379 .40791 m .62308 .40755 L .60984 .38431 L F
.61027 .40207 m .60984 .38431 L p .62325 .40784 L F P
0 g
s
.761 .503 .542 r
.60423 .3832 m .60984 .38431 L .61027 .40205 L p F P
0 g
s
.619 .629 .839 r
.6092 .40165 m .60896 .40143 L .60921 .40155 L F
.60797 .40118 m .60751 .40074 L .6092 .40165 L F
.761 .503 .542 r
.6046 .39936 m .60423 .3832 L p .60909 .40149 L F P
0 g
s
.618 .614 .824 r
.60294 .40703 m .60133 .40392 L .60913 .40229 L closepath p F P
0 g
s
.641 .639 .833 r
.56982 .3904 m .58211 .38692 L p .60133 .40392 L F P
0 g
s
.788 .525 .538 r
.58194 .3769 m .60423 .3832 L .60456 .39778 L p F P
0 g
s
.788 .525 .538 r
.60456 .39778 m .60459 .39899 L p .60216 .39662 L F P
0 g
s
.788 .525 .538 r
.60216 .39662 m .58194 .3769 L .60456 .39778 L F
.6038 .39856 m .58194 .3769 L .60459 .39899 L F
.59602 .39439 m .58194 .3769 L .6046 .39936 L F
.641 .639 .833 r
.59603 .39439 m .60133 .40392 L p .58211 .38692 L F P
0 g
s
.619 .629 .839 r
.60913 .40229 m .60133 .40392 L .59603 .39439 L p F P
0 g
s
.641 .639 .833 r
.60133 .40392 m .58066 .4097 L .56982 .3904 L p F P
0 g
s
.788 .525 .538 r
.60473 .40521 m .58231 .39893 L .58194 .3769 L p F P
0 g
s
.643 .657 .848 r
.56982 .3904 m .56173 .37706 L p .57687 .38438 L F P
0 g
s
.643 .657 .848 r
.58211 .38692 m .58092 .38725 L p .57687 .38438 L F P
0 g
s
.643 .657 .848 r
.58092 .38725 m .56982 .3904 L p .57687 .38438 L F P
0 g
s
.842 .569 .527 r
.55961 .36737 m .56867 .37163 L .56876 .37863 L p F P
0 g
s
.842 .569 .527 r
.56188 .37375 m .55961 .36737 L .56876 .37863 L F
.822 .553 .532 r
.56867 .37163 m .58194 .3769 L .58211 .38692 L p F P
0 g
s
.822 .553 .532 r
.5737 .38169 m .56867 .37163 L .58211 .38692 L F
.643 .657 .848 r
.56173 .37706 m .55903 .37259 L p .56252 .37476 L F P
0 g
s
.643 .657 .848 r
.56252 .37476 m .56876 .37863 L .56617 .37805 L F
.56252 .37476 m .56617 .37805 L .56173 .37706 L F
.664 .665 .842 r
.56982 .3904 m .54927 .3977 L .53829 .37979 L p F P
0 g
s
.664 .665 .842 r
.53829 .37979 m .55891 .3724 L .56982 .3904 L p F P
0 g
s
.667 .684 .857 r
.55891 .3724 m .53829 .37979 L .52722 .36318 L p F P
0 g
s
.667 .684 .857 r
.52722 .36318 m .54175 .35793 L p .55397 .37096 L F P
0 g
s
.67 .705 .874 r
.52722 .36318 m .51603 .34787 L p .53657 .35292 L F P
0 g
s
.923 .643 .492 r
.53264 .34821 m .54174 .3561 L .54175 .35793 L p F P
0 g
s
.67 .705 .874 r
.54175 .35793 m .52722 .36318 L p .53657 .35292 L F P
0 g
s
.67 .705 .874 r
.53315 .35208 m .52716 .34381 L .53657 .35292 L F
.51603 .34787 m .52716 .34381 L p .53315 .35208 L F P
0 g
s
.687 .692 .849 r
.50666 .37208 m .52722 .36318 L .53829 .37979 L p F P
0 g
s
.692 .713 .865 r
.52722 .36318 m .50666 .37208 L .49539 .35686 L p F P
0 g
s
.692 .713 .865 r
.49539 .35686 m .51603 .34787 L .52722 .36318 L p F P
0 g
s
.672 .728 .891 r
.51603 .34787 m .50472 .33386 L p .52195 .33732 L F P
0 g
s
.966 .687 .452 r
.5244 .34037 m .51801 .33213 L .52435 .33995 L F
.51589 .32939 m .51872 .33292 L p .51801 .33213 L F P
0 g
s
.966 .687 .452 r
.51872 .33292 m .52435 .33995 L p .51801 .33213 L F P
0 g
s
.674 .752 .91 r
.50472 .33386 m .49326 .32115 L p .51062 .32386 L F P
0 g
s
.966 .687 .452 r
.51608 .32999 m .51589 .32939 L .5244 .34037 L F
.672 .728 .891 r
.52716 .34381 m .51603 .34787 L p .52195 .33732 L F P
0 g
s
.696 .735 .881 r
.51603 .34787 m .49539 .35686 L .48398 .34294 L p F P
0 g
s
.696 .735 .881 r
.48398 .34294 m .50472 .33386 L .51603 .34787 L p F P
0 g
s
.672 .728 .891 r
.51949 .33682 m .51589 .32976 L .52195 .33732 L F
.50472 .33386 m .51589 .32976 L p .51949 .33682 L F P
0 g
s
.674 .778 .928 r
.49326 .32115 m .48163 .30977 L p .50594 .31248 L F P
0 g
s
.989 .723 .376 r
.50798 .31387 m .51293 .32359 L p .51238 .32272 L F P
0 g
s
.674 .752 .91 r
.51062 .32386 m .51275 .3242 L .51589 .32976 L F
.51589 .32976 m .50472 .33386 L p .51062 .32386 L F P
0 g
s
.989 .723 .376 r
.50859 .31682 m .50811 .3145 L .51589 .32976 L F
.51589 .32939 m .51589 .32976 L p .51238 .32272 L F P
0 g
s
.989 .723 .376 r
.51293 .32359 m .51589 .32939 L p .51238 .32272 L F P
0 g
s
.989 .723 .376 r
.50811 .3145 m .50798 .31387 L .51589 .32976 L F
.674 .752 .91 r
.5142 .31341 m .52557 .3262 L p .51275 .3242 L F P
0 g
s
.942 .715 .244 r
.50348 .29684 m .50798 .31387 L .50797 .31527 L p F P
0 g
s
.942 .715 .244 r
.5076 .31416 m .50348 .29684 L .50797 .31527 L F
.674 .752 .91 r
.49326 .32115 m .50797 .31571 L p .51032 .32382 L F P
0 g
s
.674 .778 .928 r
.50594 .31248 m .50697 .3126 L .50797 .31571 L F
.50797 .31571 m .49326 .32115 L p .50594 .31248 L F P
0 g
s
.942 .715 .244 r
.50432 .30435 m .5041 .30236 L .50797 .31571 L F
.5041 .30236 m .50348 .29684 L .5076 .31416 L F
.50697 .31227 m .5076 .31416 L .50797 .31571 L F
.5041 .30236 m .5076 .31416 L .50697 .31227 L F
.643 .768 .939 r
.50348 .30205 m .50345 .30169 L .50358 .30207 L F
.50268 .30193 m .50345 .30169 L p .50348 .30205 L F P
0 g
s
.78 .625 .063 r
.50304 .28892 m .50348 .29684 L .50345 .30169 L p F P
0 g
s
.674 .778 .928 r
.48163 .30977 m .50268 .30193 L .50353 .30277 L p F P
0 g
s
.674 .778 .928 r
.50353 .30277 m .50395 .30319 L p .50416 .31228 L F P
0 g
s
.674 .778 .928 r
.50416 .31228 m .50395 .30319 L .50697 .3126 L F
.48163 .30977 m .50353 .30277 L .50416 .31228 L F
.643 .768 .939 r
.50395 .30319 m .50268 .30193 L p .50358 .30207 L F P
0 g
s
.638 .795 .958 r
.50268 .30193 m .49099 .29178 L p .50014 .29282 L F P
0 g
s
.942 .715 .244 r
.50345 .30169 m .50345 .30164 L p .50347 .30172 L F P
0 g
s
.942 .715 .244 r
.50345 .30164 m .50348 .29684 L p .50432 .30435 L F P
0 g
s
.942 .715 .244 r
.5079 .3361 m .50345 .30164 L .50432 .30435 L F
.638 .795 .958 r
.50014 .29282 m .50278 .29312 L .50301 .296 L F
.50272 .29974 m .50301 .296 L .50345 .30169 L F
.50014 .29282 m .50301 .296 L .50272 .29974 L F
.78 .625 .063 r
.50313 .29709 m .50304 .28892 L .50345 .30169 L F
.638 .795 .958 r
.50345 .30169 m .50268 .30193 L p .50014 .29282 L F P
0 g
s
.78 .625 .063 r
.50337 .31912 m .50293 .31123 L .50301 .296 L p F P
0 g
s
.78 .625 .063 r
.50301 .296 m .50304 .28892 L p .50314 .29766 L F P
0 g
s
.78 .625 .063 r
.50337 .31912 m .50301 .296 L .50314 .29766 L F
0 0 .048 r
.50367 .27777 m .50304 .28892 L .50301 .296 L p F P
0 g
s
0 0 .048 r
.50338 .29118 m .50339 .29074 L .50301 .296 L F
.50339 .29074 m .50367 .27777 L .50306 .2946 L F
.50339 .29074 m .50306 .2946 L .50301 .296 L F
.638 .795 .958 r
.5123 .28528 m .52388 .29552 L p .50322 .29317 L F P
0 g
s
.638 .795 .958 r
.50326 .29273 m .5123 .28528 L .50322 .29317 L F
0 0 .048 r
.50362 .28793 m .50367 .27777 L p .50338 .29118 L F P
0 g
s
.638 .795 .958 r
.5026 .29088 m .5123 .28528 L .50278 .29312 L F
.5024 .2883 m .50362 .28793 L p .5026 .29088 L F P
0 g
s
.638 .795 .958 r
.50362 .28793 m .5123 .28528 L p .5026 .29088 L F P
0 g
s
0 0 .323 r
.50985 .25614 m .5081 .26029 L .50804 .27673 L p F P
0 g
s
0 0 .323 r
.50847 .27611 m .50985 .25614 L .50804 .27673 L F
.586 .807 .984 r
.50635 .28079 m .5123 .28528 L p .50859 .27594 L F P
0 g
s
.586 .807 .984 r
.50848 .27567 m .50804 .27673 L .50859 .27594 L F
.50804 .27673 m .50635 .28079 L .50859 .27594 L F
.52578 .27409 m .50879 .27564 L .5123 .28528 L F
.50879 .27564 m .50859 .27594 L .5123 .28528 L F
0 0 .221 r
.5081 .26029 m .50367 .27777 L .50363 .28732 L p F P
0 g
s
0 0 .221 r
.50378 .28695 m .5081 .26029 L .50363 .28732 L F
.5056 .28219 m .5081 .26029 L .50362 .28793 L F
.629 .822 .974 r
.50635 .28079 m .5123 .28528 L p .50483 .28476 L F P
0 g
s
0 0 .221 r
.50552 .28297 m .5056 .28219 L .50362 .28793 L F
.50363 .28732 m .50362 .28793 L p .50378 .28695 L F P
0 g
s
.629 .822 .974 r
.5123 .28528 m .50362 .28793 L p .5039 .2847 L F P
0 g
s
.78 .625 .063 r
.50314 .29766 m .50313 .29709 L .50345 .30169 L F
.638 .795 .958 r
.52388 .29552 m .50345 .30169 L p .50278 .29312 L F P
0 g
s
0 0 .221 r
.50356 .30011 m .50802 .28268 L .50804 .27673 L p F P
0 g
s
0 0 .221 r
.50804 .27673 m .5081 .26029 L p .50555 .28272 L F P
0 g
s
0 0 .221 r
.50356 .30011 m .50804 .27673 L .50555 .28272 L F
0 0 .323 r
.50979 .2742 m .50985 .25614 L p .5085 .27576 L F P
0 g
s
.571 .813 .99 r
.50961 .27446 m .52578 .27409 L p .50979 .27421 L F P
0 g
s
0 0 .323 r
.50848 .276 m .50971 .27431 L .5085 .27576 L F
.50971 .27431 m .50979 .2742 L .5085 .27576 L F
.50847 .27611 m .50961 .27446 L .50848 .276 L F
.50961 .27446 m .50979 .2742 L .50848 .276 L F
.586 .807 .984 r
.52578 .27409 m .50954 .27446 L p .50848 .27567 L F P
0 g
s
.586 .807 .984 r
.50954 .27446 m .50898 .27447 L p .50858 .27543 L F P
0 g
s
.586 .807 .984 r
.50954 .27446 m .50858 .27543 L .50848 .27567 L F
.036 0 .392 r
.51984 .23949 m .50985 .25614 L .50979 .2742 L p F P
0 g
s
.545 .835 .998 r
.50979 .27421 m .52213 .27144 L p .51365 .27094 L F P
0 g
s
.036 0 .392 r
.50979 .2742 m .50979 .27421 L p .51129 .27268 L F P
0 g
s
.036 0 .392 r
.5112 .27302 m .51129 .27268 L .50979 .27421 L F
.51129 .27268 m .51984 .23949 L .50979 .2742 L F
.571 .813 .99 r
.52578 .27409 m .52213 .27144 L .50979 .27421 L p F P
0 g
s
.036 0 .392 r
.51983 .26194 m .51984 .23949 L p .51144 .27211 L F P
0 g
s
.036 0 .392 r
.5112 .27302 m .51538 .26928 L .51144 .27211 L F
.51516 .26966 m .51538 .26928 L p .5112 .27302 L F P
0 g
s
.036 0 .392 r
.51538 .26928 m .51983 .26194 L p .51144 .27211 L F P
0 g
s
.545 .835 .998 r
.5103 .26453 m .48858 .26945 L p .51365 .27094 L F P
0 g
s
.545 .835 .998 r
.52213 .27144 m .51675 .2683 L p .51365 .27094 L F P
0 g
s
.48 .808 1 r
.54391 .26819 m .52213 .27144 L .51675 .2683 L p F P
0 g
s
.48 .808 1 r
.51983 .2661 m .54391 .26819 L .51675 .2683 L F
.195 .049 .444 r
.52536 .26331 m .52541 .26309 L .51983 .2661 L F
.52541 .26309 m .52829 .25197 L .52029 .26533 L F
.52541 .26309 m .52029 .26533 L .51983 .2661 L F
.52829 .25197 m .51983 .26194 L .51983 .2661 L p F P
0 g
s
.643 .768 .939 r
.52388 .29552 m .53529 .30708 L p .50358 .30207 L F P
0 g
s
.643 .768 .939 r
.50345 .30169 m .52388 .29552 L p .50358 .30207 L F P
0 g
s
.6 .782 .968 r
.54523 .29055 m .52388 .29552 L .5123 .28528 L p F P
0 g
s
.6 .782 .968 r
.5123 .28528 m .53376 .28024 L .54523 .29055 L p F P
0 g
s
.586 .807 .984 r
.5123 .28528 m .53376 .28024 L .52578 .27409 L p F P
0 g
s
.036 0 .392 r
.50978 .27854 m .50971 .30123 L p .51873 .26621 L F P
0 g
s
.036 0 .392 r
.51983 .26194 m .51638 .26764 L p .51873 .26621 L F P
0 g
s
.036 0 .392 r
.51638 .26764 m .50978 .27854 L p .51873 .26621 L F P
0 g
s
.195 .049 .444 r
.52824 .22949 m .51984 .23949 L .51983 .26194 L p F P
0 g
s
.195 .049 .444 r
.51983 .26194 m .52829 .25197 L .52824 .22949 L p F P
0 g
s
.036 0 .392 r
.50971 .30123 m .51983 .28468 L .51983 .2661 L p F P
0 g
s
.036 0 .392 r
.51983 .2661 m .51983 .26194 L p .51852 .26704 L F P
0 g
s
.036 0 .392 r
.50971 .30123 m .51983 .2661 L .51852 .26704 L F
.48 .808 1 r
.53221 .26122 m .54391 .26819 L p .52069 .26567 L F P
0 g
s
.48 .808 1 r
.52152 .26525 m .53221 .26122 L .52069 .26567 L F
.195 .049 .444 r
.52831 .26181 m .52829 .25197 L p .52536 .26331 L F P
0 g
s
.48 .808 1 r
.5222 .26441 m .53221 .26122 L .52048 .26564 L F
.52517 .26229 m .52831 .26181 L p .5222 .26441 L F P
0 g
s
.48 .808 1 r
.52831 .26181 m .53221 .26122 L p .5222 .26441 L F P
0 g
s
.265 .102 .464 r
.53514 .24514 m .52829 .25197 L .52831 .26181 L p F P
0 g
s
.434 .816 .99 r
.52831 .26181 m .53221 .26122 L p .53006 .26116 L F P
0 g
s
.265 .102 .464 r
.53159 .26059 m .53163 .2604 L .53021 .26101 L F
.53116 .26075 m .53021 .26101 L .52831 .26181 L F
.53159 .26059 m .53021 .26101 L .53116 .26075 L F
.353 .773 .977 r
.53221 .26122 m .54186 .26049 L .53397 .25999 L p F P
0 g
s
.353 .773 .977 r
.53116 .26075 m .53221 .26122 L p .53397 .25999 L F P
0 g
s
.48 .808 1 r
.52069 .26567 m .54391 .26819 L .51983 .2661 L F
.538 .788 .99 r
.55361 .27695 m .52578 .27409 L .53376 .28024 L closepath p F P
0 g
s
.514 .79 .995 r
.55361 .27695 m .55543 .27668 L p .52213 .27144 L F P
0 g
s
.514 .79 .995 r
.52213 .27144 m .52578 .27409 L .55361 .27695 L p F P
0 g
s
.514 .79 .995 r
.55543 .27668 m .54391 .26819 L .52213 .27144 L p F P
0 g
s
.265 .102 .464 r
.53163 .2604 m .53514 .24514 L .52831 .26181 L F
.434 .816 .99 r
.52876 .25965 m .50078 .26029 L p .53006 .26116 L F P
0 g
s
.434 .816 .99 r
.53221 .26122 m .53116 .26075 L p .53006 .26116 L F P
0 g
s
.434 .816 .99 r
.53116 .26075 m .52876 .25965 L p .53006 .26116 L F P
0 g
s
.408 .772 .994 r
.53221 .26122 m .54391 .26819 L p .55958 .26272 L F P
0 g
s
.408 .772 .994 r
.55958 .26272 m .54186 .26049 L .53221 .26122 L p F P
0 g
s
.457 .247 .505 r
.55351 .25441 m .57395 .24337 L p .56562 .25745 L F P
0 g
s
.529 .302 .515 r
.57395 .24337 m .59652 .23486 L p .57911 .25968 L F P
0 g
s
.529 .302 .515 r
.57419 .25884 m .57395 .24337 L p .57911 .25968 L F P
0 g
s
0 .513 .767 r
.56899 .258 m .57147 .25869 L p .58013 .25986 L F P
0 g
s
.529 .302 .515 r
.57911 .25968 m .59652 .23486 L .58837 .26127 L F
0 .513 .767 r
.58236 .26016 m .57419 .25884 L .58013 .25986 L F
.57419 .25884 m .56899 .258 L .58013 .25986 L F
0 .42 .697 r
.59951 .26408 m .61849 .26904 L .59621 .26305 L p F P
0 g
s
.529 .302 .515 r
.59652 .23486 m .59702 .25804 L .5896 .26081 L p F P
0 g
s
.529 .302 .515 r
.5896 .26081 m .58879 .26111 L p .58894 .26059 L F P
0 g
s
.529 .302 .515 r
.58894 .26059 m .59652 .23486 L .5896 .26081 L F
.58844 .26102 m .59652 .23486 L .58879 .26111 L F
0 .42 .697 r
.59136 .26179 m .59951 .26408 L p .59621 .26305 L F P
0 g
s
.527 .723 .963 r
.56679 .28704 m .57801 .29876 L p .59554 .29238 L F P
0 g
s
.509 .745 .98 r
.58174 .28563 m .55638 .27752 L .56679 .28704 L closepath p F P
0 g
s
.527 .723 .963 r
.59554 .29238 m .58174 .28563 L .56679 .28704 L p F P
0 g
s
.483 .741 .985 r
.58174 .28563 m .58857 .28515 L p .55543 .27668 L F P
0 g
s
.483 .741 .985 r
.55543 .27668 m .55638 .27752 L .58174 .28563 L p F P
0 g
s
.422 .711 .984 r
.61063 .28528 m .58857 .28515 L .57732 .27511 L p F P
0 g
s
.483 .741 .985 r
.58857 .28515 m .57732 .27511 L .55543 .27668 L p F P
0 g
s
.451 .76 .995 r
.57732 .27511 m .55543 .27668 L .54391 .26819 L p F P
0 g
s
.422 .711 .984 r
.57732 .27511 m .59948 .27518 L .61063 .28528 L p F P
0 g
s
.381 .724 .989 r
.57732 .27511 m .59948 .27518 L .59456 .27143 L p F P
0 g
s
.381 .724 .989 r
.56592 .26657 m .57732 .27511 L p .59456 .27143 L F P
0 g
s
.451 .76 .995 r
.54391 .26819 m .56592 .26657 L .57732 .27511 L p F P
0 g
s
.232 .651 .958 r
.606 .27568 m .62196 .27761 L p .5882 .26696 L F P
0 g
s
.232 .651 .958 r
.5882 .26696 m .59456 .27143 L .606 .27568 L p F P
0 g
s
.381 .724 .989 r
.59456 .27143 m .57814 .26658 L .56592 .26657 L p F P
0 g
s
.329 .729 .981 r
.57814 .26658 m .55958 .26272 L .56592 .26657 L closepath p F P
0 g
s
.322 .706 .981 r
.5882 .26696 m .57814 .26658 L .59456 .27143 L closepath p F P
0 g
s
.254 .7 .958 r
.57814 .26658 m .5882 .26696 L p .55435 .25992 L F P
0 g
s
.254 .7 .958 r
.55435 .25992 m .55958 .26272 L .57814 .26658 L p F P
0 g
s
.232 .651 .958 r
.62196 .27761 m .6108 .26965 L .5882 .26696 L p F P
0 g
s
.155 .635 .924 r
.5882 .26696 m .6108 .26965 L .60687 .26748 L p F P
0 g
s
.155 .635 .924 r
.57677 .26073 m .5882 .26696 L p .60687 .26748 L F P
0 g
s
.254 .7 .958 r
.5882 .26696 m .57677 .26073 L .55435 .25992 L p F P
0 g
s
.155 .635 .924 r
.60687 .26748 m .58715 .26196 L .57677 .26073 L p F P
0 g
s
.069 .602 .862 r
.58715 .26196 m .57147 .25869 L .57677 .26073 L closepath p F P
0 g
s
.039 .568 .861 r
.59951 .26408 m .58715 .26196 L .60687 .26748 L closepath p F P
0 g
s
0 .513 .767 r
.58715 .26196 m .59951 .26408 L .59136 .26179 L p F P
0 g
s
0 .513 .767 r
.58818 .26124 m .58715 .26196 L .59136 .26179 L F
.57147 .25869 m .58715 .26196 L p .58834 .26113 L F P
0 g
s
0 .513 .767 r
.58854 .26099 m .58236 .26016 L .58834 .26113 L F
.58236 .26016 m .57147 .25869 L .58834 .26113 L F
.174 .677 .909 r
.57147 .25869 m .56276 .25772 L .55435 .25992 L F
.557 .765 .975 r
.55638 .27752 m .55361 .27695 L .53376 .28024 L p F P
0 g
s
.539 .766 .981 r
.55543 .27668 m .55361 .27695 L .55638 .27752 L closepath p F P
0 g
s
.408 .772 .994 r
.54391 .26819 m .56592 .26657 L .55958 .26272 L p F P
0 g
s
.174 .677 .909 r
.55435 .25992 m .57677 .26073 L .57147 .25869 L p F P
0 g
s
.457 .247 .505 r
.56457 .25772 m .55351 .25441 L .56546 .25772 L F
.55354 .25769 m .55354 .25703 L p .56457 .25772 L F P
0 g
s
.457 .247 .505 r
.55354 .25703 m .55351 .25441 L p .56457 .25772 L F P
0 g
s
.457 .247 .505 r
.56546 .25772 m .56289 .25701 L .56562 .25745 L F
.56289 .25701 m .55351 .25441 L .56562 .25745 L F
.369 .181 .489 r
.5533 .23159 m .55351 .25441 L .54884 .25787 L p F P
0 g
s
.174 .677 .909 r
.54893 .25786 m .55435 .25992 L p .56029 .25744 L F P
0 g
s
.277 .744 .945 r
.54186 .26049 m .55435 .25992 L p .54254 .25874 L F P
0 g
s
.557 .765 .975 r
.53376 .28024 m .54523 .29055 L p .55638 .27752 L F P
0 g
s
.349 .756 .982 r
.55435 .25992 m .54186 .26049 L .55958 .26272 L closepath p F P
0 g
s
.277 .744 .945 r
.55435 .25992 m .54893 .25786 L p .54254 .25874 L F P
0 g
s
.369 .181 .489 r
.53533 .29101 m .53524 .26792 L .54883 .25788 L p F P
0 g
s
.369 .181 .489 r
.54883 .25788 m .55351 .25441 L p .55201 .25744 L F P
0 g
s
.369 .181 .489 r
.53533 .29101 m .54883 .25788 L .55201 .25744 L F
.5396 .25914 m .5533 .23159 L .54883 .25788 L F
.265 .102 .464 r
.5352 .25924 m .53514 .24514 L p .53162 .26045 L F P
0 g
s
.265 .102 .464 r
.53159 .26059 m .53232 .26032 L .53162 .26045 L F
.53232 .26032 m .5352 .25924 L .53162 .26045 L F
.277 .744 .945 r
.53397 .25999 m .54186 .26049 L p .5367 .25954 L F P
0 g
s
.369 .181 .489 r
.5352 .25974 m .53514 .24514 L p .5396 .25914 L F P
0 g
s
.277 .744 .945 r
.53646 .25949 m .5352 .25974 L .5367 .25954 L F
.5352 .25974 m .53397 .25999 L .5367 .25954 L F
.369 .181 .489 r
.53514 .24514 m .5533 .23159 L p .5396 .25914 L F P
0 g
s
.277 .744 .945 r
.53646 .25949 m .54186 .26049 L .54102 .25858 L F
.369 .181 .489 r
.53524 .26792 m .5352 .25974 L p .5396 .25914 L F P
0 g
s
.265 .102 .464 r
.52834 .27473 m .5352 .25924 L .53159 .26059 L F
.277 .744 .945 r
.5203 .25651 m .52876 .25965 L .53397 .25999 L p F P
0 g
s
.265 .102 .464 r
.5352 .25974 m .5352 .25924 L p .53496 .25979 L F P
0 g
s
.277 .744 .945 r
.5203 .25651 m .53397 .25999 L .53646 .25949 L F
.54259 .25546 m .5203 .25651 L p .54254 .25874 L F P
0 g
s
.369 .181 .489 r
.54884 .25787 m .54883 .25788 L p .54883 .25787 L F P
0 g
s
.369 .181 .489 r
.54883 .25787 m .5533 .23159 L .54884 .25787 L F
.277 .744 .945 r
.54893 .25786 m .54259 .25546 L p .54254 .25874 L F P
0 g
s
.369 .181 .489 r
.55373 .27754 m .53533 .29101 L p .55224 .25698 L F P
0 g
s
.369 .181 .489 r
.55351 .25441 m .55354 .25703 L p .55224 .25698 L F P
0 g
s
.369 .181 .489 r
.55354 .25703 m .55373 .27754 L p .55224 .25698 L F P
0 g
s
.055 .606 .831 r
.56516 .25693 m .55046 .25574 L .56209 .25737 L p F P
0 g
s
.055 .606 .831 r
.56209 .25737 m .56457 .25772 L p .56475 .25748 L F P
0 g
s
.055 .606 .831 r
.56516 .25693 m .56209 .25737 L .56475 .25748 L F
.56457 .25772 m .57147 .25869 L .56899 .258 L p F P
0 g
s
.174 .677 .909 r
.57147 .25869 m .56457 .25772 L p .56276 .25772 L F P
0 g
s
.457 .247 .505 r
.5743 .26653 m .55373 .27754 L p .56546 .25772 L F P
0 g
s
.457 .247 .505 r
.56546 .25772 m .56562 .25745 L .56588 .25773 L F
.56546 .25772 m .56588 .25773 L .5743 .26653 L F
.57395 .24337 m .57419 .25884 L p .56562 .25745 L F P
0 g
s
.457 .247 .505 r
.57419 .25884 m .5743 .26653 L p .56562 .25745 L F P
0 g
s
.174 .677 .909 r
.56276 .25772 m .55965 .25771 L .55435 .25992 L F
.457 .247 .505 r
.55373 .27754 m .55354 .25769 L p .56546 .25772 L F P
0 g
s
.055 .606 .831 r
.56899 .258 m .56516 .25693 L p .56457 .25772 L F P
0 g
s
.174 .677 .909 r
.55046 .25574 m .54259 .25546 L p .56276 .25772 L F P
0 g
s
.174 .677 .909 r
.56457 .25772 m .55046 .25574 L p .56276 .25772 L F P
0 g
s
.529 .302 .515 r
.57466 .28999 m .5743 .26653 L .58837 .26127 L p F P
0 g
s
0 .481 .799 r
.62545 .27144 m .61849 .26904 L .59951 .26408 L p F P
0 g
s
0 .366 .677 r
.62265 .27046 m .61849 .26904 L .62545 .27144 L closepath p F P
0 g
s
.313 0 0 r
.61849 .26904 m .62265 .27046 L p .59824 .26372 L F P
0 g
s
.313 0 0 r
.59818 .26371 m .61849 .26904 L .59824 .26372 L F
.5968 .26325 m .61849 .26904 L .59798 .26366 L F
.59621 .26305 m .61849 .26904 L p .5968 .26325 L F P
0 g
s
0 .481 .799 r
.59951 .26408 m .60687 .26748 L p .62545 .27144 L F P
0 g
s
.355 .675 .977 r
.62831 .28668 m .61063 .28528 L .59948 .27518 L p F P
0 g
s
.355 .675 .977 r
.59948 .27518 m .606 .27568 L .62831 .28668 L p F P
0 g
s
.305 .682 .976 r
.606 .27568 m .59456 .27143 L .59948 .27518 L closepath p F P
0 g
s
.055 .564 .881 r
.61651 .27079 m .60687 .26748 L .6108 .26965 L closepath p F P
0 g
s
0 .481 .799 r
.60687 .26748 m .61651 .27079 L p .62545 .27144 L F P
0 g
s
.588 .348 .521 r
.59753 .28153 m .59714 .26337 L p .60928 .26731 L F P
0 g
s
.529 .302 .515 r
.58837 .26127 m .5896 .26081 L p .59362 .26217 L F P
0 g
s
.529 .302 .515 r
.57466 .28999 m .58837 .26127 L .59362 .26217 L F
.57466 .28999 m .59362 .26217 L .59403 .26231 L F
.58879 .26111 m .58837 .26127 L p .58844 .26102 L F P
0 g
s
0 .513 .767 r
.59136 .26179 m .58854 .26099 L p .58818 .26124 L F P
0 g
s
.507 .719 .968 r
.58857 .28515 m .58174 .28563 L .59554 .29238 L closepath p F P
0 g
s
.529 .302 .515 r
.59702 .25804 m .59753 .28153 L .57466 .28999 L p F P
0 g
s
.297 .652 .97 r
.62196 .27761 m .606 .27568 L .62831 .28668 L p F P
0 g
s
.139 .59 .927 r
.6407 .28139 m .62196 .27761 L .6108 .26965 L p F P
0 g
s
.139 .59 .927 r
.6108 .26965 m .61651 .27079 L .6407 .28139 L p F P
0 g
s
.588 .348 .521 r
.62251 .27563 m .59753 .28153 L p .60928 .26731 L F P
0 g
s
.313 0 0 r
.62265 .27046 m .61605 .26951 L p .59824 .26372 L F P
0 g
s
0 .481 .799 r
.61651 .27079 m .6338 .27532 L .62545 .27144 L p F P
0 g
s
.027 .525 .875 r
.6407 .28139 m .64482 .28247 L .6338 .27532 L p F P
0 g
s
.027 .525 .875 r
.6338 .27532 m .61651 .27079 L .6407 .28139 L p F P
0 g
s
0 .444 .818 r
.6674 .29041 m .64482 .28247 L .6338 .27532 L p F P
0 g
s
0 .444 .818 r
.6338 .27532 m .64473 .27915 L .6674 .29041 L p F P
0 g
s
.402 0 0 r
.64257 .27918 m .62265 .27046 L .61605 .26951 L p F P
0 g
s
.402 0 0 r
.64257 .27918 m .61605 .26951 L .62241 .27216 L F
.64257 .27918 m .62241 .27216 L .62745 .27417 L F
0 .393 .733 r
.64473 .27915 m .62545 .27144 L .6338 .27532 L closepath p F P
0 g
s
.323 0 0 r
.62545 .27144 m .64473 .27915 L p .64906 .28177 L F P
0 g
s
.323 0 0 r
.62265 .27046 m .62545 .27144 L p .64906 .28177 L F P
0 g
s
.323 0 0 r
.64906 .28177 m .64257 .27918 L .62265 .27046 L p F P
0 g
s
.637 .387 .522 r
.62912 .27483 m .62251 .27563 L p .62492 .27316 L F P
0 g
s
.637 .387 .522 r
.62251 .27563 m .62241 .27216 L p .62492 .27316 L F P
0 g
s
.588 .348 .521 r
.60928 .26731 m .61605 .26951 L .62251 .27563 L F
.62239 .27157 m .62241 .27216 L p .61605 .26951 L F P
0 g
s
.588 .348 .521 r
.62241 .27216 m .62251 .27563 L p .61605 .26951 L F P
0 g
s
.402 0 0 r
.61138 .26884 m .61359 .26981 L .62776 .27439 L p F P
0 g
s
.477 .673 .95 r
.61833 .30975 m .63258 .30992 L .62166 .29686 L p F P
0 g
s
.424 .646 .95 r
.65477 .31182 m .63258 .30992 L .62166 .29686 L p F P
0 g
s
.424 .646 .95 r
.62166 .29686 m .64392 .2987 L .65477 .31182 L p F P
0 g
s
.394 .662 .967 r
.62166 .29686 m .64392 .2987 L .63984 .29435 L p F P
0 g
s
.394 .662 .967 r
.61063 .28528 m .62166 .29686 L p .63984 .29435 L F P
0 g
s
.394 .662 .967 r
.63984 .29435 m .62831 .28668 L .61063 .28528 L p F P
0 g
s
.297 .652 .97 r
.62831 .28668 m .63299 .28726 L .62196 .27761 L p F P
0 g
s
.212 .6 .948 r
.62196 .27761 m .63299 .28726 L p .64938 .28627 L F P
0 g
s
.212 .6 .948 r
.64938 .28627 m .6407 .28139 L .62196 .27761 L p F P
0 g
s
.637 .387 .522 r
.62319 .29945 m .62251 .27563 L .62912 .27483 L p F P
0 g
s
.402 0 0 r
.62912 .27483 m .64257 .27918 L p .62745 .27417 L F P
0 g
s
.469 0 0 r
.64631 .28123 m .64257 .27918 L .64906 .28177 L closepath p F P
0 g
s
.526 0 0 r
.64257 .27918 m .64631 .28123 L .64305 .28139 L p F P
0 g
s
.273 .6 .951 r
.64633 .29907 m .66658 .30326 L p .63299 .28726 L F P
0 g
s
.273 .6 .951 r
.63299 .28726 m .63984 .29435 L .64633 .29907 L p F P
0 g
s
.348 .644 .965 r
.63299 .28726 m .62831 .28668 L .63984 .29435 L closepath p F P
0 g
s
.273 .6 .951 r
.66658 .30326 m .65574 .2919 L .63299 .28726 L p F P
0 g
s
.212 .6 .948 r
.63299 .28726 m .65574 .2919 L .64938 .28627 L p F P
0 g
s
.119 .551 .919 r
.64482 .28247 m .6407 .28139 L .64938 .28627 L closepath p F P
0 g
s
.637 .387 .522 r
.62319 .29945 m .62912 .27483 L .64147 .28064 L F
.526 0 0 r
.64022 .28006 m .64257 .27918 L .64305 .28139 L F
.33 .627 .959 r
.64633 .29907 m .63984 .29435 L .64392 .2987 L closepath p F P
0 g
s
.125 .543 .919 r
.66077 .29332 m .64938 .28627 L .65574 .2919 L closepath p F P
0 g
s
.019 .479 .875 r
.64938 .28627 m .66077 .29332 L p .66904 .29143 L F P
0 g
s
.019 .479 .875 r
.64482 .28247 m .64938 .28627 L p .66904 .29143 L F P
0 g
s
.019 .479 .875 r
.66904 .29143 m .6674 .29041 L .64482 .28247 L p F P
0 g
s
0 .335 .713 r
.65727 .28464 m .64473 .27915 L .6674 .29041 L p F P
0 g
s
.323 0 0 r
.64473 .27915 m .65727 .28464 L .64906 .28177 L p F P
0 g
s
0 .335 .713 r
.6674 .29041 m .66814 .29073 L .65727 .28464 L p F P
0 g
s
0 .245 .637 r
.6887 .30173 m .66814 .29073 L .65727 .28464 L p F P
0 g
s
0 .245 .637 r
.65727 .28464 m .66723 .28996 L .6887 .30173 L p F P
0 g
s
.409 0 0 r
.66723 .28996 m .64906 .28177 L .65727 .28464 L closepath p F P
0 g
s
.019 .479 .875 r
.66077 .29332 m .67895 .29974 L .66904 .29143 L p F P
0 g
s
0 .405 .824 r
.68614 .30291 m .66904 .29143 L .67895 .29974 L closepath p F P
0 g
s
0 .303 .734 r
.66814 .29073 m .66904 .29143 L p .69652 .30698 L F P
0 g
s
0 .39 .802 r
.66814 .29073 m .6674 .29041 L .66904 .29143 L closepath p F P
0 g
s
0 .303 .734 r
.69652 .30698 m .6887 .30173 L .66814 .29073 L p F P
0 g
s
.541 0 0 r
.64906 .28177 m .66723 .28996 L p .67763 .29857 L F P
0 g
s
.541 0 0 r
.64631 .28123 m .64906 .28177 L p .67763 .29857 L F P
0 g
s
.541 0 0 r
.67763 .29857 m .66177 .29143 L .64631 .28123 L p F P
0 g
s
.637 .387 .522 r
.6504 .29618 m .62319 .29945 L p .64156 .28054 L F P
0 g
s
.586 .012 0 r
.64631 .28123 m .66177 .29143 L .66099 .29114 L p F P
0 g
s
.106 .5 .904 r
.67895 .29974 m .66077 .29332 L .67734 .30634 L p F P
0 g
s
.194 .55 .931 r
.65574 .2919 m .66077 .29332 L .67734 .30634 L p F P
0 g
s
.678 .419 .522 r
.66285 .2959 m .65981 .29052 L .66099 .29114 L F
.66285 .2959 m .66099 .29114 L .66164 .29154 L F
.66271 .2922 m .66285 .2959 L p .66164 .29154 L F P
0 g
s
.672 .134 0 r
.66177 .29143 m .66271 .2922 L p .66189 .2917 L F P
0 g
s
.678 .419 .522 r
.66164 .29154 m .66162 .29148 L .66271 .2922 L F
.194 .55 .931 r
.67734 .30634 m .66658 .30326 L .65574 .2919 L p F P
0 g
s
.651 .095 0 r
.66177 .29143 m .67763 .29857 L .67275 .2987 L p F P
0 g
s
.7 .435 .521 r
.6687 .29607 m .66285 .2959 L .66271 .2922 L p F P
0 g
s
.651 .095 0 r
.66618 .29445 m .66177 .29143 L .67275 .2987 L F
.66271 .2922 m .66177 .29143 L p .66618 .29445 L F P
0 g
s
.299 .544 .917 r
.70162 .33492 m .68805 .33094 L .67734 .31628 L p F P
0 g
s
.299 .544 .917 r
.67734 .31628 m .69095 .32021 L .70162 .33492 L p F P
0 g
s
.252 .55 .929 r
.69095 .32021 m .67734 .31628 L .66658 .30326 L p F P
0 g
s
.252 .55 .929 r
.66658 .30326 m .67734 .30634 L .69095 .32021 L p F P
0 g
s
.7 .435 .521 r
.66285 .2959 m .6687 .29607 L p .68131 .32058 L F P
0 g
s
.7 .435 .521 r
.68131 .32058 m .6687 .29607 L .66963 .29668 L F
.18 .509 .912 r
.68968 .31072 m .67734 .30634 L .69095 .32021 L p F P
0 g
s
.106 .5 .904 r
.67734 .30634 m .68968 .31072 L .67895 .29974 L p F P
0 g
s
.096 .452 .884 r
.68968 .31072 m .7021 .31621 L .71536 .33026 L p F P
0 g
s
.014 .435 .865 r
.7021 .31621 m .68968 .31072 L .67895 .29974 L p F P
0 g
s
.014 .435 .865 r
.67895 .29974 m .68614 .30291 L .7021 .31621 L p F P
0 g
s
.694 .152 0 r
.7007 .31671 m .68204 .30555 L .67763 .29857 L F
.241 .509 .906 r
.70036 .32359 m .69095 .32021 L .70162 .33492 L p F P
0 g
s
.18 .509 .912 r
.69095 .32021 m .70036 .32359 L .68968 .31072 L p F P
0 g
s
.096 .452 .884 r
.71536 .33026 m .70036 .32359 L .68968 .31072 L p F P
0 g
s
.079 .402 .857 r
.72597 .34503 m .73455 .3497 L .72396 .3349 L p F P
0 g
s
.079 .402 .857 r
.72396 .3349 m .71536 .33026 L .72597 .34503 L p F P
0 g
s
.166 .461 .886 r
.70036 .32359 m .71536 .33026 L .72597 .34503 L p F P
0 g
s
0 .341 .821 r
.74599 .35699 m .73455 .3497 L .72396 .3349 L p F P
0 g
s
0 .382 .842 r
.71536 .33026 m .72396 .3349 L .71336 .32226 L p F P
0 g
s
0 .382 .842 r
.71336 .32226 m .7021 .31621 L .71536 .33026 L p F P
0 g
s
.782 .279 0 r
.70647 .32353 m .71231 .32358 L p .73279 .34463 L F P
0 g
s
.754 .236 0 r
.70647 .32353 m .7007 .31671 L .71231 .32358 L closepath p F P
0 g
s
.736 .464 .517 r
.68131 .32058 m .68059 .30454 L p .69216 .31266 L F P
0 g
s
.763 .262 .02 r
.7007 .31671 m .70647 .32353 L .70589 .32374 L p F P
0 g
s
.763 .262 .02 r
.70073 .31958 m .7007 .31671 L .70589 .32374 L F
.736 .464 .517 r
.70571 .3236 m .68131 .32058 L p .69216 .31266 L F P
0 g
s
.763 .262 .02 r
.6916 .31221 m .7007 .31671 L p .70073 .31958 L F P
0 g
s
.736 .464 .517 r
.70818 .3239 m .68059 .30454 L .70767 .3234 L F
.7 .435 .521 r
.68059 .30454 m .68131 .32058 L p .66939 .29619 L F P
0 g
s
.241 .509 .906 r
.70162 .33492 m .71101 .33832 L .70036 .32359 L p F P
0 g
s
.29 .504 .891 r
.71101 .33832 m .70162 .33492 L .70939 .35042 L p F P
0 g
s
.337 .536 .901 r
.68805 .33094 m .70162 .33492 L .70939 .35042 L p F P
0 g
s
.166 .461 .886 r
.72597 .34503 m .71101 .33832 L .70036 .32359 L p F P
0 g
s
.736 .464 .517 r
.68131 .32058 m .70574 .3236 L p .70947 .34838 L F P
0 g
s
.736 .464 .517 r
.70947 .34838 m .70574 .3236 L .70602 .32386 L F
.787 .298 .049 r
.70589 .32374 m .70647 .32353 L .70829 .32594 L p F P
0 g
s
.736 .464 .517 r
.70829 .32594 m .70947 .34838 L p .70599 .32363 L F P
0 g
s
.782 .279 0 r
.73279 .34463 m .71952 .33626 L p .70647 .32353 L F P
0 g
s
.498 .299 .54 r
.72939 .39418 m .72813 .37213 L .74771 .36243 L p F P
0 g
s
.431 .249 .532 r
.74909 .38451 m .74771 .36243 L .76582 .35033 L p F P
0 g
s
.498 .299 .54 r
.74771 .36243 m .74909 .38451 L .72939 .39418 L p F P
0 g
s
.074 .36 .83 r
.73455 .3497 m .74599 .35699 L .75417 .37241 L p F P
0 g
s
0 .251 .76 r
.74833 .35206 m .73542 .34217 L .74599 .35699 L p F P
0 g
s
0 .341 .821 r
.72396 .3349 m .73542 .34217 L .74599 .35699 L p F P
0 g
s
0 .312 .794 r
.73542 .34217 m .72396 .3349 L .71336 .32226 L p F P
0 g
s
0 .206 .71 r
.73542 .34217 m .74833 .35206 L .73781 .33975 L p F P
0 g
s
0 .206 .71 r
.73781 .33975 m .72242 .32799 L .73542 .34217 L p F P
0 g
s
0 .312 .794 r
.71336 .32226 m .72242 .32799 L .73542 .34217 L p F P
0 g
s
0 .271 .742 r
.72242 .32799 m .71336 .32226 L .70273 .31179 L p F P
0 g
s
0 .13 .645 r
.7523 .35551 m .74833 .35206 L .73781 .33975 L p F P
0 g
s
0 .15 .63 r
.72242 .32799 m .73781 .33975 L .73389 .3361 L p F P
0 g
s
0 .15 .63 r
.70697 .31446 m .72242 .32799 L p .73389 .3361 L F P
0 g
s
0 .271 .742 r
.70273 .31179 m .70697 .31446 L .72242 .32799 L p F P
0 g
s
.431 .249 .532 r
.76582 .35033 m .76733 .37245 L .74909 .38451 L p F P
0 g
s
0 0 .514 r
.73952 .34122 m .7523 .35551 L .76621 .37018 L p F P
0 g
s
0 .13 .645 r
.73781 .33975 m .73952 .34122 L .7523 .35551 L p F P
0 g
s
0 .15 .63 r
.73389 .3361 m .72419 .32761 L .70697 .31446 L p F P
0 g
s
0 .072 .559 r
.73952 .34122 m .73389 .3361 L .73781 .33975 L closepath p F P
0 g
s
0 0 .514 r
.76621 .37018 m .75341 .35588 L .73952 .34122 L p F P
0 g
s
.584 .066 0 r
.73389 .3361 m .73952 .34122 L .75341 .35588 L p F P
0 g
s
.584 .066 0 r
.72733 .33055 m .73389 .3361 L p .75341 .35588 L F P
0 g
s
.517 0 0 r
.72733 .33055 m .72419 .32761 L .73389 .3361 L closepath p F P
0 g
s
.605 .057 0 r
.72419 .32761 m .72733 .33055 L .71687 .32475 L p F P
0 g
s
0 .251 .76 r
.74599 .35699 m .75888 .3669 L .74833 .35206 L p F P
0 g
s
0 .18 .706 r
.76285 .37036 m .75888 .3669 L .74833 .35206 L p F P
0 g
s
.431 .249 .532 r
.7505 .40686 m .74909 .38451 L .76733 .37245 L p F P
0 g
s
.353 .193 .52 r
.77448 .36627 m .76733 .37245 L .76885 .39484 L p F P
0 g
s
.431 .249 .532 r
.76733 .37245 m .76885 .39484 L .7505 .40686 L p F P
0 g
s
.353 .193 .52 r
.76885 .39484 m .77605 .38868 L .77448 .36627 L p F P
0 g
s
.302 .156 .51 r
.78356 .35713 m .77448 .36627 L .77605 .38868 L p F P
0 g
s
0 .058 .602 r
.7523 .35551 m .76285 .37036 L .77674 .38504 L p F P
0 g
s
0 .18 .706 r
.74833 .35206 m .7523 .35551 L .76285 .37036 L p F P
0 g
s
.353 .193 .52 r
.77292 .34413 m .76582 .35033 L .76733 .37245 L p F P
0 g
s
.353 .193 .52 r
.76733 .37245 m .77448 .36627 L .77292 .34413 L p F P
0 g
s
0 .058 .602 r
.77674 .38504 m .76621 .37018 L .7523 .35551 L p F P
0 g
s
.713 .207 0 r
.73833 .34215 m .75341 .35588 L p .75972 .36636 L F P
0 g
s
.584 .066 0 r
.75341 .35588 m .73833 .34215 L .72733 .33055 L p F P
0 g
s
.657 .122 0 r
.73833 .34215 m .72733 .33055 L .71687 .32475 L p F P
0 g
s
.76 .25 0 r
.72092 .32903 m .73833 .34215 L .75025 .35776 L p F P
0 g
s
.657 .122 0 r
.71687 .32475 m .72092 .32903 L .73833 .34215 L p F P
0 g
s
.713 .207 0 r
.75972 .36636 m .75025 .35776 L .73833 .34215 L p F P
0 g
s
.704 .166 0 r
.72092 .32903 m .71231 .32358 L .71687 .32475 L closepath p F P
0 g
s
.76 .25 0 r
.75025 .35776 m .73279 .34463 L .72092 .32903 L p F P
0 g
s
.782 .279 0 r
.71231 .32358 m .72092 .32903 L .73279 .34463 L p F P
0 g
s
.074 .36 .83 r
.75417 .37241 m .74516 .36663 L .73455 .3497 L p F P
0 g
s
0 .284 .785 r
.75888 .3669 m .74599 .35699 L .75417 .37241 L p F P
0 g
s
.833 .36 .032 r
.73279 .34463 m .75025 .35776 L p .74452 .36201 L F P
0 g
s
.833 .36 .032 r
.74348 .36091 m .73279 .34463 L .74452 .36201 L F
.498 .299 .54 r
.73067 .41649 m .72939 .39418 L .74909 .38451 L p F P
0 g
s
.498 .299 .54 r
.74909 .38451 m .7505 .40686 L .73067 .41649 L p F P
0 g
s
.431 .249 .532 r
.75192 .42949 m .7505 .40686 L .76885 .39484 L p F P
0 g
s
.26 .419 .832 r
.73938 .37662 m .7558 .3857 L p .76319 .40506 L F P
0 g
s
.212 .418 .846 r
.73938 .37662 m .7558 .3857 L .74516 .36663 L p F P
0 g
s
.26 .419 .832 r
.7558 .3857 m .76205 .39809 L .76319 .40506 L p F P
0 g
s
.198 .38 .818 r
.76205 .39809 m .7558 .3857 L .75999 .38841 L closepath p F P
0 g
s
.143 .372 .827 r
.75999 .38841 m .7558 .3857 L .74516 .36663 L p F P
0 g
s
.353 .193 .52 r
.77605 .38868 m .76885 .39484 L .77039 .41751 L p F P
0 g
s
.431 .249 .532 r
.76885 .39484 m .77039 .41751 L .75192 .42949 L p F P
0 g
s
.353 .193 .52 r
.77039 .41751 m .77764 .41138 L .77605 .38868 L p F P
0 g
s
.302 .156 .51 r
.7852 .37957 m .77605 .38868 L .77764 .41138 L p F P
0 g
s
.061 .308 .793 r
.75417 .37241 m .75999 .38841 L .77709 .40171 L p F P
0 g
s
.143 .372 .827 r
.74516 .36663 m .75417 .37241 L .75999 .38841 L p F P
0 g
s
.061 .308 .793 r
.76949 .38425 m .75417 .37241 L p .77709 .40171 L F P
0 g
s
0 .284 .785 r
.75417 .37241 m .76949 .38425 L .75888 .3669 L p F P
0 g
s
.835 .543 .496 r
.75677 .38762 m .74184 .35916 L .74485 .36237 L F
.85 .389 .06 r
.75333 .36292 m .75967 .37452 L .74624 .36399 L p F P
0 g
s
.85 .389 .06 r
.74485 .36237 m .75333 .36292 L p .74624 .36399 L F P
0 g
s
0 .221 .743 r
.77118 .38573 m .76949 .38425 L .75888 .3669 L p F P
0 g
s
.302 .156 .51 r
.77605 .38868 m .7852 .37957 L .78356 .35713 L p F P
0 g
s
.302 .156 .51 r
.77764 .41138 m .78685 .4023 L .7852 .37957 L p F P
0 g
s
0 .114 .664 r
.76285 .37036 m .77118 .38573 L .78504 .40043 L p F P
0 g
s
0 .221 .743 r
.75888 .3669 m .76285 .37036 L .77118 .38573 L p F P
0 g
s
0 .114 .664 r
.78504 .40043 m .77674 .38504 L .76285 .37036 L p F P
0 g
s
0 0 .464 r
.77397 .38031 m .76621 .37018 L .77674 .38504 L p F P
0 g
s
.633 .151 0 r
.76621 .37018 m .77397 .38031 L .76356 .36913 L p F P
0 g
s
.633 .151 0 r
.76356 .36913 m .75341 .35588 L .76621 .37018 L p F P
0 g
s
0 0 .464 r
.77674 .38504 m .7845 .39517 L .77397 .38031 L p F P
0 g
s
.684 .208 0 r
.77787 .3859 m .77397 .38031 L .76356 .36913 L p F P
0 g
s
.713 .207 0 r
.75341 .35588 m .76356 .36913 L .75972 .36636 L p F P
0 g
s
.684 .208 0 r
.76356 .36913 m .76523 .37154 L .77787 .3859 L p F P
0 g
s
.749 .256 0 r
.76523 .37154 m .75972 .36636 L .76356 .36913 L closepath p F P
0 g
s
.834 .37 0 r
.75972 .36636 m .76523 .37154 L .77447 .38836 L p F P
0 g
s
.834 .37 0 r
.75333 .36292 m .75972 .36636 L p .77447 .38836 L F P
0 g
s
.812 .336 0 r
.75333 .36292 m .75025 .35776 L .75972 .36636 L closepath p F P
0 g
s
0 .225 .743 r
.78021 .40467 m .77709 .40171 L .7735 .39172 L closepath p F P
0 g
s
.061 .308 .793 r
.77709 .40171 m .7735 .39172 L .76949 .38425 L p F P
0 g
s
.302 .156 .51 r
.78685 .4023 m .77764 .41138 L .77925 .43436 L p F P
0 g
s
.19 .076 .484 r
.79855 .38686 m .78685 .4023 L .78853 .42531 L p F P
0 g
s
.302 .156 .51 r
.77925 .43436 m .78853 .42531 L .78685 .4023 L p F P
0 g
s
.19 .076 .484 r
.78853 .42531 m .80031 .40993 L .79855 .38686 L p F P
0 g
s
0 .161 .701 r
.79115 .41632 m .78021 .40467 L .7735 .39172 L p F P
0 g
s
0 .161 .701 r
.7735 .39172 m .77118 .38573 L p .79115 .41632 L F P
0 g
s
0 .252 .761 r
.7735 .39172 m .76949 .38425 L .77118 .38573 L closepath p F P
0 g
s
0 .161 .701 r
.77118 .38573 m .78504 .40043 L .79115 .41632 L p F P
0 g
s
.891 .465 .118 r
.75967 .37452 m .77447 .38836 L .78183 .40609 L p F P
0 g
s
.834 .37 0 r
.77447 .38836 m .75967 .37452 L .75333 .36292 L p F P
0 g
s
.891 .465 .118 r
.78183 .40609 m .76838 .39357 L p .75967 .37452 L F P
0 g
s
.19 .076 .484 r
.79681 .36408 m .7852 .37957 L .78685 .4023 L p F P
0 g
s
.19 .076 .484 r
.78685 .4023 m .79855 .38686 L .79681 .36408 L p F P
0 g
s
0 0 .553 r
.78504 .40043 m .79519 .41369 L .7845 .39517 L p F P
0 g
s
0 0 .553 r
.7845 .39517 m .77674 .38504 L .78504 .40043 L p F P
0 g
s
.794 .338 0 r
.76523 .37154 m .77787 .3859 L .78713 .40272 L p F P
0 g
s
.794 .338 0 r
.78713 .40272 m .77447 .38836 L .76523 .37154 L p F P
0 g
s
.19 .076 .484 r
.80031 .40993 m .78853 .42531 L .79022 .44862 L p F P
0 g
s
.19 .076 .484 r
.79022 .44862 m .80209 .43329 L .80031 .40993 L p F P
0 g
s
.069 0 .449 r
.80255 .40602 m .80031 .40993 L .80209 .43329 L p F P
0 g
s
.069 0 .449 r
.80209 .43329 m .80436 .4294 L .80255 .40602 L p F P
0 g
s
.069 0 .449 r
.80436 .4294 m .80209 .43329 L .8039 .45695 L p F P
0 g
s
0 .047 .615 r
.78504 .40043 m .79115 .41632 L .80306 .43194 L p F P
0 g
s
0 .047 .615 r
.79519 .41369 m .78504 .40043 L p .80306 .43194 L F P
0 g
s
.875 .45 .035 r
.77447 .38836 m .78713 .40272 L .79453 .42043 L p F P
0 g
s
.282 .336 .742 r
.78847 .4607 m .79367 .4756 L .79101 .48561 L p F P
0 g
s
.228 .301 .732 r
.79367 .4756 m .78847 .4607 L .79525 .46729 L closepath p F P
0 g
s
.19 .076 .484 r
.80209 .43329 m .79022 .44862 L .7908 .45655 L p F P
0 g
s
.18 .29 .741 r
.79525 .46729 m .78847 .4607 L .78687 .45647 L p F P
0 g
s
.18 .29 .741 r
.79525 .46729 m .78687 .45647 L .78938 .45652 L F
.302 .156 .51 r
.78853 .42531 m .77925 .43436 L .78063 .45402 L p F P
0 g
s
.282 .336 .742 r
.79101 .48561 m .77952 .45395 L .77996 .45398 L F
.302 .156 .51 r
.79022 .44862 m .78853 .42531 L p .78187 .45347 L F P
0 g
s
.302 .156 .51 r
.7824 .45365 m .79022 .44862 L .78187 .45347 L F
.78436 .45427 m .79022 .44862 L p .7824 .45365 L F P
0 g
s
.302 .156 .51 r
.78415 .45425 m .7824 .45365 L .78172 .45409 L F
.78436 .45427 m .7824 .45365 L .78415 .45425 L F
.18 .29 .741 r
.78687 .45647 m .78631 .455 L p .78938 .45652 L F P
0 g
s
.302 .156 .51 r
.78172 .45409 m .78853 .42531 L .78063 .45402 L F
.18 .29 .741 r
.78938 .45652 m .78631 .455 L .78907 .45595 L F
.282 .336 .742 r
.79101 .48561 m .77996 .45398 L .78847 .4607 L F
.77996 .45398 m .78009 .45398 L .78847 .4607 L F
.78063 .45402 m .78847 .4607 L p .78009 .45398 L F P
0 g
s
.282 .336 .742 r
.77514 .471 m .77952 .45395 L p .79101 .48561 L F P
0 g
s
.314 .341 .73 r
.785 .50129 m .77561 .47234 L .79101 .48561 L closepath p F P
0 g
s
.282 .336 .742 r
.79101 .48561 m .77561 .47234 L .77514 .471 L p F P
0 g
s
.302 .156 .51 r
.79022 .44862 m .78436 .45427 L p .78882 .45456 L F P
0 g
s
.242 .33 .755 r
.78631 .455 m .78847 .4607 L .78063 .45402 L p F P
0 g
s
.302 .156 .51 r
.78436 .45427 m .78088 .45763 L p .78882 .45456 L F P
0 g
s
.302 .156 .51 r
.78172 .45409 m .7824 .45365 L .78187 .45347 L F
.78088 .45763 m .78436 .45427 L p .78172 .45409 L F P
0 g
s
.353 .193 .52 r
.77565 .45284 m .77957 .45377 L .77925 .43436 L F
.78063 .45402 m .78062 .45387 L p .77957 .45377 L F P
0 g
s
.353 .193 .52 r
.78062 .45387 m .77925 .43436 L p .77957 .45377 L F P
0 g
s
.431 .249 .532 r
.77039 .41751 m .77196 .44047 L .75789 .44949 L p F P
0 g
s
.431 .249 .532 r
.75505 .44892 m .77039 .41751 L .75789 .44949 L F
.498 .299 .54 r
.7505 .40686 m .75192 .42949 L .73196 .43909 L p F P
0 g
s
.483 .476 .773 r
.72975 .44988 m .74069 .4792 L .71851 .47266 L p F P
0 g
s
.449 .456 .773 r
.7431 .48015 m .74069 .4792 L .72975 .44988 L p F P
0 g
s
.449 .456 .773 r
.72975 .44988 m .75234 .45862 L p .7431 .48015 L F P
0 g
s
.498 .299 .54 r
.73196 .43909 m .75192 .42949 L p .7427 .44553 L F P
0 g
s
.498 .299 .54 r
.74087 .4453 m .73196 .43909 L .7427 .44553 L F
.73226 .44428 m .73196 .43909 L p .74227 .44628 L F P
0 g
s
.498 .496 .785 r
.71657 .46746 m .70768 .44498 L .72882 .44962 L closepath p F P
0 g
s
.557 .343 .545 r
.70932 .42381 m .73067 .41649 L p .71484 .43992 L F P
0 g
s
.49 .506 .801 r
.72882 .44962 m .70768 .44498 L .7046 .43769 L p F P
0 g
s
.49 .506 .801 r
.72882 .44962 m .7046 .43769 L .71009 .43888 L F
.7169 .44147 m .71009 .43888 L .71453 .43985 L F
.72882 .44962 m .71009 .43888 L .7169 .44147 L F
.553 .528 .781 r
.68869 .449 m .69678 .4694 L .67541 .46848 L p F P
0 g
s
.527 .513 .784 r
.71304 .4716 m .69678 .4694 L .68869 .449 L p F P
0 g
s
.527 .513 .784 r
.68869 .449 m .69355 .44316 L p .71304 .4716 L F P
0 g
s
.527 .513 .784 r
.69355 .44316 m .70768 .44498 L p .71304 .4716 L F P
0 g
s
.521 .524 .799 r
.70768 .44498 m .69355 .44316 L .69912 .43514 L p F P
0 g
s
.606 .381 .548 r
.70009 .43543 m .7003 .43517 L .7007 .43561 L F
.70932 .42381 m .71009 .43888 L p .7003 .43517 L F P
0 g
s
.521 .524 .799 r
.70415 .43663 m .70768 .44498 L p .69912 .43514 L F P
0 g
s
.557 .343 .545 r
.71009 .43888 m .70932 .42381 L p .71484 .43992 L F P
0 g
s
.606 .381 .548 r
.6864 .42885 m .70932 .42381 L p .7003 .43517 L F P
0 g
s
.49 .506 .801 r
.71453 .43985 m .71009 .43888 L .70186 .43119 L F
.7046 .43769 m .70415 .43663 L p .71009 .43888 L F P
0 g
s
.49 .506 .801 r
.70415 .43663 m .70186 .43119 L p .71009 .43888 L F P
0 g
s
.553 .528 .781 r
.67541 .46848 m .67349 .46366 L .68869 .449 L p F P
0 g
s
.562 .542 .79 r
.686 .44254 m .68869 .449 L .67349 .46366 L p F P
0 g
s
.538 .529 .793 r
.68869 .449 m .686 .44254 L .69355 .44316 L closepath p F P
0 g
s
.533 .54 .808 r
.69355 .44316 m .686 .44254 L .68071 .43061 L p F P
0 g
s
.649 .413 .548 r
.6854 .40657 m .6864 .42885 L .68016 .42956 L p F P
0 g
s
.56 .555 .805 r
.686 .44254 m .66467 .44255 L p .67158 .42683 L F P
0 g
s
.649 .413 .548 r
.68016 .42956 m .68014 .42956 L p .66819 .4249 L F P
0 g
s
.649 .413 .548 r
.66757 .42556 m .66819 .4249 L .68014 .42956 L F
.66819 .4249 m .6854 .40657 L .68016 .42956 L F
.56 .555 .805 r
.68027 .4296 m .686 .44254 L p .67158 .42683 L F P
0 g
s
.533 .54 .808 r
.68071 .43061 m .68027 .4296 L p .68509 .43168 L F P
0 g
s
.533 .54 .808 r
.68509 .43168 m .68027 .4296 L .68488 .43139 L F
.69355 .44316 m .68071 .43061 L .68509 .43168 L F
.585 .555 .787 r
.64361 .44435 m .66467 .44255 L p .6666 .46893 L F P
0 g
s
.585 .568 .801 r
.65709 .42555 m .66467 .44255 L .64361 .44435 L p F P
0 g
s
.585 .555 .787 r
.66467 .44255 m .67349 .46366 L .6666 .46893 L p F P
0 g
s
.562 .542 .79 r
.67349 .46366 m .66467 .44255 L .686 .44254 L p F P
0 g
s
.56 .555 .805 r
.66467 .44255 m .66361 .42429 L .67158 .42683 L F
.66467 .44255 m .65709 .42555 L .65954 .42274 L p F P
0 g
s
.684 .441 .548 r
.64988 .40961 m .66102 .40937 L .66156 .42356 L p F P
0 g
s
.684 .441 .548 r
.66156 .42356 m .66156 .42364 L p .66146 .42352 L F P
0 g
s
.684 .441 .548 r
.66146 .42352 m .64988 .40961 L .66156 .42356 L F
.65622 .42125 m .64988 .40961 L .66156 .42364 L F
.568 .567 .812 r
.65954 .42274 m .65709 .42555 L .65491 .42086 L p F P
0 g
s
.56 .555 .805 r
.66467 .44255 m .65961 .42302 L .66362 .42457 L F
.65961 .42302 m .65954 .42274 L .66156 .42364 L F
.65961 .42302 m .66156 .42364 L .66362 .42457 L F
.649 .413 .548 r
.66102 .40937 m .6854 .40657 L p .66757 .42556 L F P
0 g
s
.649 .413 .548 r
.66156 .42364 m .66102 .40937 L p .66757 .42556 L F P
0 g
s
.56 .555 .805 r
.65954 .42274 m .66327 .41847 L p .66362 .42457 L F P
0 g
s
.649 .413 .548 r
.66187 .43163 m .66156 .42364 L p .66757 .42556 L F P
0 g
s
.585 .568 .801 r
.64361 .44435 m .64138 .43938 L .65709 .42555 L p F P
0 g
s
.684 .441 .548 r
.65022 .41924 m .64988 .40961 L p .65614 .42111 L F P
0 g
s
.703 .455 .547 r
.63436 .40916 m .64988 .40961 L .65022 .41924 L p F P
0 g
s
.591 .58 .809 r
.65709 .42555 m .64138 .43938 L p .653 .4204 L F P
0 g
s
.591 .594 .823 r
.65022 .41924 m .6472 .41958 L p .64449 .41743 L F P
0 g
s
.591 .594 .823 r
.64357 .41671 m .65022 .41924 L .64449 .41743 L F
.703 .455 .547 r
.63834 .41471 m .63792 .41412 L .65022 .41924 L F
.63792 .41412 m .63436 .40916 L .65022 .41924 L F
.591 .594 .823 r
.6472 .41958 m .63291 .42121 L .62763 .41063 L p F P
0 g
s
.591 .594 .823 r
.63448 .41324 m .6472 .41958 L .62763 .41063 L F
.684 .441 .548 r
.65626 .42133 m .65022 .41924 L .65614 .42111 L F
.591 .58 .809 r
.64138 .43938 m .63291 .42121 L .6472 .41958 L p F P
0 g
s
.591 .58 .809 r
.6472 .41958 m .65397 .41882 L p .65193 .42215 L F P
0 g
s
.591 .58 .809 r
.64138 .43938 m .6472 .41958 L .65193 .42215 L F
.614 .605 .819 r
.63291 .42121 m .61208 .42519 L p .61961 .40622 L F P
0 g
s
.614 .605 .819 r
.62709 .40955 m .63291 .42121 L p .61961 .40622 L F P
0 g
s
.614 .605 .819 r
.60913 .40229 m .61027 .40207 L p .61208 .42519 L F P
0 g
s
.614 .605 .819 r
.61027 .40207 m .62219 .39973 L p .61961 .40622 L F P
0 g
s
.614 .605 .819 r
.61208 .42519 m .61027 .40207 L .61961 .40622 L F
.735 .481 .545 r
.61037 .40631 m .62325 .40784 L p .63505 .43143 L F P
0 g
s
.735 .481 .545 r
.62325 .40784 m .62616 .40819 L p .6266 .40934 L F P
0 g
s
.735 .481 .545 r
.63505 .43143 m .62325 .40784 L .6266 .40934 L F
.62616 .40819 m .63436 .40916 L .63446 .41269 L p F P
0 g
s
.591 .594 .823 r
.62763 .41063 m .62709 .40955 L p .63448 .41324 L F P
0 g
s
.735 .481 .545 r
.63446 .41269 m .63505 .43143 L p .62616 .40819 L F P
0 g
s
.703 .455 .547 r
.65067 .43187 m .63505 .43143 L .63448 .41324 L p F P
0 g
s
.703 .455 .547 r
.63448 .41324 m .63436 .40916 L p .63834 .41471 L F P
0 g
s
.735 .481 .545 r
.62663 .40824 m .62523 .40808 L p .62491 .40759 L F P
0 g
s
.591 .594 .823 r
.62709 .40955 m .62219 .39973 L p .6472 .41958 L F P
0 g
s
.703 .455 .547 r
.65067 .43187 m .63448 .41324 L .63834 .41471 L F
.591 .594 .823 r
.62219 .39973 m .65022 .41924 L .64357 .41671 L F
.703 .455 .547 r
.65022 .41924 m .65067 .43187 L p .63834 .41471 L F P
0 g
s
.591 .58 .809 r
.653 .4204 m .6531 .42023 L .65332 .42053 L F
.653 .4204 m .65332 .42053 L .65709 .42555 L F
.65397 .41882 m .65491 .42086 L p .6531 .42023 L F P
0 g
s
.591 .58 .809 r
.65491 .42086 m .65709 .42555 L p .6531 .42023 L F P
0 g
s
.684 .441 .548 r
.66187 .43163 m .65022 .41924 L .65626 .42133 L F
.66187 .43163 m .65067 .43187 L .65022 .41924 L p F P
0 g
s
.591 .594 .823 r
.65397 .41882 m .65022 .41924 L p .62219 .39973 L F P
0 g
s
.568 .567 .812 r
.65397 .41882 m .66327 .41847 L .65954 .42274 L p F P
0 g
s
.684 .441 .548 r
.66156 .42364 m .66187 .43163 L p .65622 .42125 L F P
0 g
s
.568 .567 .812 r
.65491 .42086 m .65397 .41882 L p .65954 .42274 L F P
0 g
s
.649 .413 .548 r
.66273 .45417 m .66187 .43163 L .68014 .42956 L p F P
0 g
s
.606 .381 .548 r
.70013 .43538 m .68645 .4299 L .7003 .43517 L F
.68655 .43204 m .68645 .4299 L p .70013 .43538 L F P
0 g
s
.606 .381 .548 r
.68645 .4299 m .6864 .42885 L p .7003 .43517 L F P
0 g
s
.606 .381 .548 r
.6864 .42885 m .6854 .40657 L .70817 .40152 L p F P
0 g
s
.606 .381 .548 r
.70817 .40152 m .70932 .42381 L .6864 .42885 L p F P
0 g
s
.533 .54 .808 r
.6753 .41839 m .69694 .42005 L p .69472 .43522 L F P
0 g
s
.533 .54 .808 r
.69355 .44316 m .68488 .43139 L .69472 .43522 L F
.649 .413 .548 r
.68445 .43093 m .68027 .4296 L .6864 .42885 L F
.68016 .42956 m .6864 .42885 L p .68027 .4296 L F P
0 g
s
.649 .413 .548 r
.6864 .42885 m .68742 .45139 L .66273 .45417 L p F P
0 g
s
.533 .54 .808 r
.68488 .43139 m .6753 .41839 L .69472 .43522 L F
.649 .413 .548 r
.68014 .42956 m .68016 .42956 L p .68027 .4296 L F P
0 g
s
.649 .413 .548 r
.66273 .45417 m .68014 .42956 L .68445 .43093 L F
.56 .555 .805 r
.66327 .41847 m .6753 .41839 L p .67158 .42683 L F P
0 g
s
.56 .555 .805 r
.66361 .42429 m .66327 .41847 L .67158 .42683 L F
.6753 .41839 m .68027 .4296 L p .67158 .42683 L F P
0 g
s
.649 .413 .548 r
.68014 .42956 m .66187 .43163 L p .66757 .42556 L F P
0 g
s
.533 .54 .808 r
.68027 .4296 m .6753 .41839 L p .68488 .43139 L F P
0 g
s
.533 .54 .808 r
.69694 .42005 m .70186 .43119 L .69355 .44316 L p F P
0 g
s
.606 .381 .548 r
.68742 .45139 m .68655 .43204 L p .70013 .43538 L F P
0 g
s
.606 .381 .548 r
.71009 .43888 m .71047 .44637 L p .7003 .43517 L F P
0 g
s
.521 .524 .799 r
.69912 .43514 m .70186 .43119 L .70415 .43663 L p F P
0 g
s
.527 .513 .784 r
.70768 .44498 m .71657 .46746 L .71304 .4716 L p F P
0 g
s
.606 .381 .548 r
.71047 .44637 m .68742 .45139 L p .70009 .43543 L F P
0 g
s
.606 .381 .548 r
.70009 .43543 m .7007 .43561 L .71047 .44637 L F
.557 .343 .545 r
.71484 .43992 m .73067 .41649 L .72377 .44186 L F
.49 .506 .801 r
.70186 .43119 m .70699 .42164 L p .72256 .4416 L F P
0 g
s
.49 .506 .801 r
.72882 .44962 m .71453 .43985 L .72256 .4416 L F
.71453 .43985 m .70186 .43119 L .72256 .4416 L F
.457 .487 .801 r
.72711 .44356 m .72666 .44249 L p .73129 .44409 L F P
0 g
s
.557 .343 .545 r
.73067 .41649 m .73196 .43909 L .72417 .44173 L p F P
0 g
s
.557 .343 .545 r
.72384 .44162 m .73067 .41649 L .72417 .44173 L F
.457 .487 .801 r
.72666 .44249 m .73115 .44387 L .73129 .44409 L F
.557 .343 .545 r
.72417 .44173 m .73196 .43909 L p .72928 .44306 L F P
0 g
s
.557 .343 .545 r
.72915 .44326 m .72666 .44249 L .72928 .44306 L F
.72666 .44249 m .72417 .44173 L .72928 .44306 L F
.49 .506 .801 r
.7293 .44876 m .72882 .44962 L p .726 .44235 L F P
0 g
s
.49 .506 .801 r
.72666 .44249 m .7293 .44876 L p .726 .44235 L F P
0 g
s
.49 .506 .801 r
.72882 .44962 m .72256 .4416 L .726 .44235 L F
.457 .487 .801 r
.73129 .44409 m .7293 .44876 L .72711 .44356 L p F P
0 g
s
.557 .343 .545 r
.71165 .46922 m .72417 .44173 L .72915 .44326 L F
.49 .506 .801 r
.71897 .42419 m .72666 .44249 L p .726 .44235 L F P
0 g
s
.557 .343 .545 r
.70932 .42381 m .70817 .40152 L .72939 .39418 L p F P
0 g
s
.557 .343 .545 r
.72939 .39418 m .73067 .41649 L .70932 .42381 L p F P
0 g
s
.49 .506 .801 r
.70699 .42164 m .71897 .42419 L p .726 .44235 L F P
0 g
s
.557 .343 .545 r
.72377 .44186 m .72417 .44173 L p .72408 .44193 L F P
0 g
s
.557 .343 .545 r
.72417 .44173 m .72377 .44186 L p .72384 .44162 L F P
0 g
s
.49 .506 .801 r
.72256 .4416 m .70699 .42164 L .726 .44235 L F
.557 .343 .545 r
.71165 .46922 m .71047 .44637 L .72377 .44186 L p F P
0 g
s
.557 .343 .545 r
.71165 .46922 m .72377 .44186 L .72408 .44193 L F
.498 .299 .54 r
.73196 .43909 m .73067 .41649 L .7505 .40686 L p F P
0 g
s
.457 .487 .801 r
.73135 .44393 m .73129 .44409 L p .73115 .44387 L F P
0 g
s
.436 .463 .789 r
.75234 .45862 m .72975 .44988 L p .73308 .4446 L F P
0 g
s
.514 .494 .772 r
.71851 .47266 m .71304 .4716 L .71657 .46746 L closepath p F P
0 g
s
.483 .476 .773 r
.72882 .44962 m .72975 .44988 L p .71851 .47266 L F P
0 g
s
.483 .476 .773 r
.71851 .47266 m .71657 .46746 L .72882 .44962 L p F P
0 g
s
.473 .485 .79 r
.72975 .44988 m .72882 .44962 L .7293 .44876 L closepath p F P
0 g
s
.557 .343 .545 r
.73196 .43909 m .73226 .44428 L p .72924 .44312 L F P
0 g
s
.436 .463 .789 r
.7374 .42976 m .74145 .43129 L p .72975 .44988 L F P
0 g
s
.436 .463 .789 r
.72975 .44988 m .7293 .44876 L .7374 .42976 L p F P
0 g
s
.557 .343 .545 r
.73327 .46196 m .71165 .46922 L p .72924 .44312 L F P
0 g
s
.557 .343 .545 r
.73226 .44428 m .73327 .46196 L p .72924 .44312 L F P
0 g
s
.436 .463 .789 r
.73308 .4446 m .73316 .44446 L .73363 .44481 L F
.73308 .4446 m .73363 .44481 L .75234 .45862 L F
.457 .487 .801 r
.71897 .42419 m .7374 .42976 L .73135 .44393 L p F P
0 g
s
.457 .487 .801 r
.73115 .44387 m .71897 .42419 L .73135 .44393 L F
.72666 .44249 m .71897 .42419 L p .73115 .44387 L F P
0 g
s
.557 .343 .545 r
.72377 .44186 m .71047 .44637 L p .71484 .43992 L F P
0 g
s
.557 .343 .545 r
.71047 .44637 m .71009 .43888 L p .71484 .43992 L F P
0 g
s
.498 .299 .54 r
.74227 .44628 m .74087 .4453 L .7427 .44553 L F
.436 .463 .789 r
.74786 .44739 m .75234 .45862 L p .73316 .44446 L F P
0 g
s
.498 .299 .54 r
.73327 .46196 m .73226 .44428 L p .74227 .44628 L F P
0 g
s
.397 .439 .787 r
.75449 .45966 m .74942 .44864 L .75314 .44901 L F
.498 .299 .54 r
.75192 .42949 m .75314 .44901 L p .74257 .44577 L F P
0 g
s
.397 .439 .787 r
.75449 .45966 m .75234 .45862 L .74145 .43129 L p F P
0 g
s
.498 .299 .54 r
.75336 .4524 m .73327 .46196 L p .74257 .44577 L F P
0 g
s
.431 .249 .532 r
.75492 .44919 m .75505 .44892 L .75789 .44949 L F
.397 .439 .787 r
.75789 .44949 m .75759 .45038 L p .75314 .44901 L F P
0 g
s
.397 .439 .787 r
.75759 .45038 m .75449 .45966 L p .75314 .44901 L F P
0 g
s
.431 .249 .532 r
.75336 .4524 m .75192 .42949 L .77039 .41751 L p F P
0 g
s
.397 .439 .787 r
.74942 .44864 m .74145 .43129 L .75789 .44949 L F
.498 .299 .54 r
.75314 .44901 m .75336 .4524 L p .74257 .44577 L F P
0 g
s
.436 .463 .789 r
.74145 .43129 m .74786 .44739 L p .73316 .44446 L F P
0 g
s
.397 .439 .787 r
.74145 .43129 m .76088 .44056 L .75789 .44949 L p F P
0 g
s
.431 .249 .532 r
.75789 .44949 m .75336 .4524 L p .75492 .44919 L F P
0 g
s
.368 .408 .771 r
.75449 .45966 m .77486 .47179 L p .76557 .45103 L F P
0 g
s
.368 .408 .771 r
.75789 .44949 m .75449 .45966 L p .76557 .45103 L F P
0 g
s
.428 .429 .758 r
.76346 .49021 m .7431 .48015 L .75352 .46179 L closepath p F P
0 g
s
.389 .405 .756 r
.76563 .49152 m .76346 .49021 L .75352 .46179 L p F P
0 g
s
.389 .405 .756 r
.75449 .45966 m .77486 .47179 L .76563 .49152 L p F P
0 g
s
.389 .405 .756 r
.75352 .46179 m .75449 .45966 L p .76563 .49152 L F P
0 g
s
.414 .434 .772 r
.75352 .46179 m .75234 .45862 L .75449 .45966 L closepath p F P
0 g
s
.431 .249 .532 r
.75481 .47559 m .75336 .4524 L .75923 .44863 L p F P
0 g
s
.431 .249 .532 r
.75923 .44863 m .77196 .44047 L p .76675 .45112 L F P
0 g
s
.431 .249 .532 r
.76669 .45125 m .75923 .44863 L .76675 .45112 L F
.75905 .44972 m .75923 .44863 L .76669 .45125 L F
.368 .408 .771 r
.76453 .4427 m .76088 .44056 L p .76557 .45103 L F P
0 g
s
.368 .408 .771 r
.77486 .47179 m .76764 .45144 L .76557 .45103 L F
.322 .379 .765 r
.76828 .45271 m .76782 .45148 L p .77282 .45314 L F P
0 g
s
.322 .379 .765 r
.77514 .471 m .76828 .45271 L p .77282 .45314 L F P
0 g
s
.368 .408 .771 r
.77486 .47179 m .77514 .471 L .76782 .45148 L p F P
0 g
s
.431 .249 .532 r
.77196 .44047 m .77282 .45314 L p .76675 .45112 L F P
0 g
s
.368 .408 .771 r
.77486 .47179 m .76782 .45148 L .76764 .45144 L F
.431 .249 .532 r
.77282 .45314 m .77354 .46371 L p .76675 .45112 L F P
0 g
s
.368 .408 .771 r
.76782 .45148 m .76453 .4427 L p .76764 .45144 L F P
0 g
s
.431 .249 .532 r
.77354 .46371 m .75481 .47559 L p .76669 .45125 L F P
0 g
s
.431 .249 .532 r
.76669 .45125 m .76675 .45112 L .76684 .45128 L F
.76669 .45125 m .76684 .45128 L .77354 .46371 L F
.322 .379 .765 r
.77957 .45377 m .77919 .45525 L p .77282 .45314 L F P
0 g
s
.322 .379 .765 r
.77919 .45525 m .77514 .471 L p .77282 .45314 L F P
0 g
s
.368 .408 .771 r
.76764 .45144 m .76453 .4427 L .76557 .45103 L F
.431 .249 .532 r
.75481 .47559 m .75905 .44972 L .76669 .45125 L F
.282 .336 .742 r
.77992 .45385 m .78063 .45402 L .78009 .45398 L F
.77996 .45398 m .77992 .45385 L .78009 .45398 L F
.353 .193 .52 r
.77354 .46371 m .78063 .45402 L .77565 .45284 L F
.77925 .43436 m .77196 .44047 L .77354 .46371 L p F P
0 g
s
.322 .379 .765 r
.77282 .45314 m .76453 .4427 L .77957 .45377 L F
.76782 .45148 m .76453 .4427 L p .77282 .45314 L F P
0 g
s
.368 .408 .771 r
.76088 .44056 m .75789 .44949 L p .76557 .45103 L F P
0 g
s
.322 .379 .765 r
.76453 .4427 m .7797 .45323 L .77957 .45377 L p F P
0 g
s
.242 .33 .755 r
.7797 .45323 m .78123 .44156 L .78631 .455 L p F P
0 g
s
.302 .156 .51 r
.78063 .45402 m .78088 .45763 L p .78172 .45409 L F P
0 g
s
.242 .33 .755 r
.78063 .45402 m .7797 .45323 L p .78631 .455 L F P
0 g
s
.302 .156 .51 r
.78088 .45763 m .78253 .48119 L p .78862 .4554 L F P
0 g
s
.302 .156 .51 r
.78862 .4554 m .78882 .45456 L .78726 .45516 L F
.78862 .4554 m .78726 .45516 L .78088 .45763 L F
.18 .29 .741 r
.79525 .46729 m .78907 .45595 L .79064 .45649 L F
.79589 .4583 m .79525 .46729 L p .79064 .45649 L F P
0 g
s
.302 .156 .51 r
.78253 .48119 m .79194 .47222 L .7908 .45655 L p F P
0 g
s
.302 .156 .51 r
.7908 .45655 m .79022 .44862 L p .78854 .45577 L F P
0 g
s
.302 .156 .51 r
.78253 .48119 m .7908 .45655 L .78854 .45577 L F
.19 .076 .484 r
.796 .45665 m .80209 .43329 L .79133 .45547 L F
.796 .45665 m .79133 .45547 L .7908 .45655 L F
.113 .225 .702 r
.79525 .46729 m .80795 .48256 L p .7992 .45746 L F P
0 g
s
.113 .225 .702 r
.796 .45665 m .79525 .46729 L p .7992 .45746 L F P
0 g
s
.172 .245 .698 r
.79367 .4756 m .79525 .46729 L p .80438 .50062 L F P
0 g
s
.172 .245 .698 r
.79525 .46729 m .80795 .48256 L .80438 .50062 L p F P
0 g
s
.19 .076 .484 r
.80389 .45681 m .80209 .43329 L p .79666 .45414 L F P
0 g
s
.19 .076 .484 r
.79934 .45588 m .80389 .45681 L .79666 .45414 L F
.79937 .45672 m .80389 .45681 L .79636 .45528 L F
.8039 .45695 m .80389 .45681 L p .8027 .45834 L F P
0 g
s
.19 .076 .484 r
.80279 .45837 m .8039 .45695 L p .8027 .45834 L F P
0 g
s
.113 .225 .702 r
.80795 .48256 m .80262 .45833 L .7992 .45746 L F
.18 .29 .741 r
.796 .45665 m .79589 .4583 L p .79484 .45663 L F P
0 g
s
.18 .29 .741 r
.79064 .45649 m .78162 .43538 L .79589 .4583 L F
.113 .225 .702 r
.80795 .48256 m .80288 .45839 L .80262 .45833 L F
.19 .076 .484 r
.79194 .47222 m .8027 .45834 L .796 .45665 L F
.8027 .45834 m .80389 .45681 L .796 .45665 L F
.113 .225 .702 r
.80795 .48256 m .80855 .47467 L .80288 .45839 L p F P
0 g
s
0 0 .394 r
.81292 .43649 m .80618 .45308 L .80665 .4592 L p F P
0 g
s
.042 .176 .679 r
.80872 .46515 m .80855 .47467 L .80376 .46092 L p F P
0 g
s
.042 .176 .679 r
.80376 .46092 m .8045 .46047 L .80872 .46515 L F
.80304 .45885 m .8033 .45888 L .80872 .46515 L F
0 .143 .671 r
.80872 .46515 m .80405 .45895 L p .8063 .46041 L F P
0 g
s
.042 .176 .679 r
.80405 .45895 m .80872 .46515 L p .8033 .45888 L F P
0 g
s
.042 .176 .679 r
.80288 .45839 m .80405 .45895 L .8033 .45888 L F
.069 0 .449 r
.80665 .4592 m .80618 .45308 L p .80608 .45914 L F P
0 g
s
0 .143 .671 r
.80872 .46515 m .80589 .4596 L .80648 .45981 L F
.069 0 .449 r
.80618 .45308 m .8039 .45695 L .80405 .45895 L p F P
0 g
s
.069 0 .449 r
.80607 .45966 m .80608 .45914 L .80405 .45895 L F
.80608 .45914 m .80618 .45308 L .80405 .45895 L F
.042 .176 .679 r
.80376 .46092 m .80304 .45885 L p .8045 .46047 L F P
0 g
s
.274 .296 .702 r
.79101 .48561 m .79996 .49525 L p .79734 .51953 L F P
0 g
s
.233 .285 .712 r
.79996 .49525 m .79101 .48561 L .79367 .4756 L closepath p F P
0 g
s
.172 .245 .698 r
.80438 .50062 m .79996 .49525 L .79367 .4756 L p F P
0 g
s
.19 .076 .484 r
.79194 .47222 m .79368 .49612 L p .80348 .45858 L F P
0 g
s
.19 .076 .484 r
.8039 .45695 m .80292 .45821 L p .80348 .45858 L F P
0 g
s
.042 .176 .679 r
.80304 .45885 m .80288 .45839 L p .8033 .45888 L F P
0 g
s
.19 .076 .484 r
.80292 .45821 m .79194 .47222 L p .80348 .45858 L F P
0 g
s
.069 0 .449 r
.8039 .45695 m .80618 .45308 L .80436 .4294 L p F P
0 g
s
.19 .076 .484 r
.79368 .49612 m .80573 .48092 L .8039 .45695 L p F P
0 g
s
0 .143 .671 r
.80223 .45653 m .79592 .44009 L p .80589 .4596 L F P
0 g
s
0 .143 .671 r
.8063 .46041 m .80519 .45935 L .80589 .4596 L F
.80519 .45935 m .80223 .45653 L .80589 .4596 L F
.80405 .45895 m .80223 .45653 L p .8063 .46041 L F P
0 g
s
.069 0 .449 r
.80405 .45895 m .80573 .48092 L p .80607 .45966 L F P
0 g
s
.069 0 .449 r
.80607 .45966 m .80665 .4592 L .80608 .45914 L F
0 .143 .671 r
.80823 .46042 m .80872 .46515 L p .80653 .45992 L F P
0 g
s
0 .143 .671 r
.80653 .45992 m .80648 .45981 L .8067 .45988 L F
.80653 .45992 m .8067 .45988 L .80823 .46042 L F
0 .04 .599 r
.80872 .46515 m .81856 .48166 L p .8112 .46052 L F P
0 g
s
0 0 .394 r
.80733 .45939 m .81045 .45694 L .80665 .4592 L F
0 .04 .599 r
.80814 .45963 m .80872 .46515 L p .8112 .46052 L F P
0 g
s
0 0 .394 r
.81017 .45927 m .81045 .45694 L .8067 .45988 L F
.81045 .45694 m .81292 .43649 L .80665 .4592 L F
.81104 .41274 m .80436 .4294 L .80618 .45308 L p F P
0 g
s
0 0 .394 r
.80618 .45308 m .81292 .43649 L .81104 .41274 L p F P
0 g
s
0 .143 .671 r
.79511 .4327 m .80695 .44832 L .80823 .46042 L p F P
0 g
s
0 0 .394 r
.80665 .4592 m .8067 .45988 L p .80733 .45939 L F P
0 g
s
.069 0 .449 r
.80662 .45986 m .80665 .4592 L .80607 .45966 L F
.8067 .45988 m .80665 .4592 L p .80662 .45986 L F P
0 g
s
0 .143 .671 r
.80648 .45981 m .79511 .4327 L .80823 .46042 L F
0 .09 .621 r
.80855 .47467 m .80872 .46515 L p .81817 .4989 L F P
0 g
s
0 .09 .621 r
.80872 .46515 m .81856 .48166 L .81817 .4989 L p F P
0 g
s
0 0 .394 r
.8067 .45988 m .80803 .47707 L p .81017 .45927 L F P
0 g
s
.031 .144 .65 r
.81388 .49166 m .80795 .48256 L .80855 .47467 L closepath p F P
0 g
s
0 .09 .621 r
.81817 .4989 m .81388 .49166 L .80855 .47467 L p F P
0 g
s
0 0 .394 r
.81483 .46054 m .81292 .43649 L p .8103 .4582 L F P
0 g
s
0 0 .394 r
.81333 .46043 m .81483 .46054 L .8103 .4582 L F
.81445 .46146 m .81483 .46054 L p .81006 .46019 L F P
0 g
s
0 .04 .599 r
.81262 .46459 m .81491 .4616 L .8112 .46052 L F
.81856 .48166 m .81491 .4616 L .81262 .46459 L F
0 0 .198 r
.81759 .44196 m .81697 .44974 L .81794 .46177 L p F P
0 g
s
0 0 .198 r
.8181 .46214 m .81759 .44196 L .81794 .46177 L F
.81854 .46474 m .81759 .44196 L .81816 .46456 L F
0 0 .286 r
.81697 .44974 m .81494 .45998 L p .81514 .46027 L F P
0 g
s
0 0 .379 r
.81654 .46349 m .81599 .46148 L p .81699 .464 L F P
0 g
s
0 0 .379 r
.82428 .48244 m .81668 .46385 L .81699 .464 L F
.81668 .46385 m .81654 .46349 L .81699 .464 L F
.81803 .4645 m .81599 .46148 L .81795 .46426 L F
.82428 .48244 m .81699 .464 L .81803 .4645 L F
.81699 .464 m .81599 .46148 L .81803 .4645 L F
0 0 .501 r
.81685 .46484 m .81856 .48166 L .82642 .49907 L p F P
0 g
s
0 0 .501 r
.81751 .46629 m .81685 .46484 L p .82642 .49907 L F P
0 g
s
0 0 .501 r
.82642 .49907 m .8259 .49385 L .81751 .46629 L p F P
0 g
s
0 0 .451 r
.8259 .49385 m .81751 .46629 L .82428 .48244 L closepath p F P
0 g
s
0 0 .379 r
.82428 .48244 m .81751 .46629 L .81654 .46349 L p F P
0 g
s
0 0 .198 r
.81946 .46518 m .81759 .44196 L p .81854 .46474 L F P
0 g
s
0 0 .56 r
.81491 .4616 m .81685 .46484 L p .81575 .46222 L F P
0 g
s
0 0 .56 r
.81575 .46222 m .81544 .46146 L .81491 .4616 L F
0 0 .286 r
.8159 .46135 m .81552 .46081 L .81519 .46124 L F
.81571 .46139 m .81519 .46124 L .81491 .4616 L F
.8159 .46135 m .81519 .46124 L .81571 .46139 L F
.81689 .46276 m .81692 .45899 L .81552 .46081 L F
.81692 .45899 m .81697 .44974 L .81491 .4616 L F
.81504 .42564 m .81292 .43649 L .81483 .46054 L p F P
0 g
s
0 0 .286 r
.81483 .46054 m .81697 .44974 L .81504 .42564 L p F P
0 g
s
0 0 .507 r
.80615 .43709 m .81252 .44864 L .81599 .46148 L p F P
0 g
s
0 0 .507 r
.81599 .46148 m .81654 .46349 L .81571 .46139 L p F P
0 g
s
0 0 .507 r
.81571 .46139 m .80615 .43709 L p .81599 .46148 L F P
0 g
s
0 0 .286 r
.81483 .46054 m .81491 .4616 L p .81514 .46027 L F P
0 g
s
0 0 .286 r
.81494 .45998 m .81483 .46054 L p .81514 .46027 L F P
0 g
s
.106 .176 .654 r
.80795 .48256 m .80438 .50062 L .81485 .51683 L p F P
0 g
s
.106 .176 .654 r
.81388 .49166 m .80795 .48256 L p .81485 .51683 L F P
0 g
s
0 0 .394 r
.80803 .47707 m .8099 .50136 L p .81472 .46146 L F P
0 g
s
0 0 .394 r
.81483 .46054 m .81451 .46131 L p .81472 .46146 L F P
0 g
s
0 0 .394 r
.81451 .46131 m .80803 .47707 L p .81472 .46146 L F P
0 g
s
.106 .176 .654 r
.81485 .51683 m .81745 .50408 L .81388 .49166 L p F P
0 g
s
.036 .128 .632 r
.81745 .50408 m .81388 .49166 L .81817 .4989 L closepath p F P
0 g
s
0 0 .394 r
.8099 .50136 m .81676 .48491 L .81483 .46054 L p F P
0 g
s
0 0 .56 r
.81544 .46146 m .80306 .43194 L .81491 .4616 L F
.80615 .43709 m .80306 .43194 L p .81685 .46484 L F P
0 g
s
0 0 .56 r
.81685 .46484 m .81654 .46349 L .80615 .43709 L p F P
0 g
s
0 0 .286 r
.81689 .46276 m .8159 .46135 L .81491 .4616 L F
0 .04 .599 r
.81856 .48166 m .81685 .46484 L .81491 .4616 L p F P
0 g
s
0 0 .437 r
.81751 .46629 m .81685 .46484 L .81654 .46349 L closepath p F P
0 g
s
0 0 .286 r
.81491 .4616 m .81676 .48491 L p .81689 .46276 L F P
0 g
s
0 0 .198 r
.81794 .46177 m .81816 .46456 L p .8181 .46214 L F P
0 g
s
0 0 .379 r
.82026 .46754 m .82428 .48244 L p .81795 .46426 L F P
0 g
s
0 0 .286 r
.81676 .48491 m .81893 .47416 L .81697 .44974 L p F P
0 g
s
0 0 .198 r
.81565 .41783 m .81504 .42564 L .81697 .44974 L p F P
0 g
s
0 0 .198 r
.81697 .44974 m .81759 .44196 L .81565 .41783 L p F P
0 g
s
0 0 .379 r
.81992 .46628 m .82026 .46754 L p .81959 .46591 L F P
0 g
s
0 0 .379 r
.81795 .46426 m .81252 .44864 L .82026 .46754 L F
.81252 .44864 m .81946 .46518 L p .81959 .46591 L F P
0 g
s
0 0 .198 r
.81893 .47416 m .81956 .46641 L .81946 .46518 L p F P
0 g
s
0 0 .198 r
.81893 .47416 m .81946 .46518 L .81854 .46474 L F
0 0 .226 r
.81992 .46628 m .82428 .48244 L .82979 .50091 L p F P
0 g
s
0 0 .543 r
.81856 .48166 m .81817 .4989 L .82596 .51628 L p F P
0 g
s
0 0 .543 r
.82596 .51628 m .82642 .49907 L .81856 .48166 L p F P
0 g
s
0 0 .198 r
.81956 .46641 m .81893 .47416 L .82091 .4989 L p F P
0 g
s
0 0 .226 r
.82979 .50091 m .82545 .48479 L .81992 .46628 L p F P
0 g
s
0 0 .198 r
.82091 .4989 m .82155 .49118 L .81956 .46641 L p F P
0 g
s
0 0 .284 r
.80612 .43288 m .81252 .44864 L .81946 .46518 L p F P
0 g
s
.774 .572 .001 r
.8171 .44936 m .81514 .42484 L p .81941 .46505 L F P
0 g
s
.774 .572 .001 r
.81933 .46482 m .8171 .44936 L p .81941 .46505 L F P
0 g
s
.774 .572 .001 r
.81946 .46518 m .81956 .46641 L p .81938 .46477 L F P
0 g
s
.774 .572 .001 r
.81938 .46477 m .81514 .42484 L .81946 .46518 L F
0 0 .284 r
.81354 .45055 m .80612 .43288 L p .81941 .46503 L F P
0 g
s
0 0 .284 r
.81992 .46628 m .81933 .46482 L p .81941 .46503 L F P
0 g
s
0 0 .284 r
.81933 .46482 m .81354 .45055 L p .81941 .46503 L F P
0 g
s
0 0 .284 r
.81941 .46503 m .80612 .43288 L .81946 .46518 L F
0 0 .198 r
.81816 .46456 m .81893 .47416 L p .81854 .46474 L F P
0 g
s
.771 .444 0 r
.81354 .45055 m .81933 .46482 L p .81894 .46607 L F P
0 g
s
.774 .572 .001 r
.81956 .46641 m .82155 .49118 L p .81889 .46621 L F P
0 g
s
0 0 .379 r
.81599 .46148 m .81252 .44864 L p .81795 .46426 L F P
0 g
s
.771 .444 0 r
.81854 .46734 m .81354 .45055 L p .81894 .46607 L F P
0 g
s
.774 .572 .001 r
.82155 .49118 m .81909 .47421 L .81854 .46734 L p F P
0 g
s
.774 .572 .001 r
.81854 .46734 m .8171 .44936 L p .81857 .46315 L F P
0 g
s
.774 .572 .001 r
.82155 .49118 m .81854 .46734 L .81857 .46315 L F
0 0 .497 r
.80615 .43709 m .80306 .43194 L .79927 .42203 L closepath p F P
0 g
s
.859 .498 0 r
.80508 .43525 m .81354 .45055 L .81854 .46734 L p F P
0 g
s
.943 .669 .206 r
.81065 .43338 m .8171 .44936 L .81854 .46734 L p F P
0 g
s
.943 .669 .206 r
.81854 .46734 m .81909 .47421 L p .81745 .46627 L F P
0 g
s
0 .039 .568 r
.81817 .4989 m .81745 .50408 L .82397 .53025 L p F P
0 g
s
.025 .092 .596 r
.82319 .53398 m .82397 .53025 L .81745 .50408 L p F P
0 g
s
0 .039 .568 r
.82397 .53025 m .82596 .51628 L .81817 .4989 L p F P
0 g
s
0 0 .286 r
.81893 .47416 m .81676 .48491 L .81871 .5096 L p F P
0 g
s
0 0 .286 r
.81871 .5096 m .82091 .4989 L .81893 .47416 L p F P
0 g
s
0 0 .198 r
.82155 .49118 m .82091 .4989 L .82291 .52397 L p F P
0 g
s
0 0 .198 r
.82291 .52397 m .82356 .51629 L .82155 .49118 L p F P
0 g
s
.774 .572 .001 r
.81909 .47421 m .82155 .49118 L .82356 .51629 L p F P
0 g
s
.774 .572 .001 r
.82356 .51629 m .82111 .49939 L .81909 .47421 L p F P
0 g
s
0 0 .56 r
.80306 .43194 m .80695 .44832 L .81491 .4616 L p F P
0 g
s
0 0 .394 r
.81006 .46019 m .81333 .46043 L .8103 .4582 L F
.80803 .47707 m .81445 .46146 L p .81006 .46019 L F P
0 g
s
0 .04 .599 r
.81491 .4616 m .80695 .44832 L p .8112 .46052 L F P
0 g
s
.931 .601 .151 r
.8106 .45383 m .81749 .46624 L p .8155 .46792 L F P
0 g
s
.943 .669 .206 r
.81909 .47421 m .82111 .49939 L p .81474 .46858 L F P
0 g
s
.931 .601 .151 r
.8135 .46962 m .8106 .45383 L p .8155 .46792 L F P
0 g
s
.943 .669 .206 r
.81261 .4583 m .81627 .46728 L p .81474 .46858 L F P
0 g
s
.943 .669 .206 r
.81627 .46728 m .81909 .47421 L p .81474 .46858 L F P
0 g
s
.166 .201 .653 r
.81003 .53203 m .81485 .51683 L .80438 .50062 L p F P
0 g
s
0 0 .394 r
.81676 .48491 m .8099 .50136 L .8118 .52598 L p F P
0 g
s
.1 .13 .605 r
.81003 .53203 m .81485 .51683 L p .81722 .55242 L F P
0 g
s
.1 .13 .605 r
.81485 .51683 m .82319 .53398 L .81722 .55242 L p F P
0 g
s
.025 .092 .596 r
.81745 .50408 m .81485 .51683 L .82319 .53398 L p F P
0 g
s
0 0 .394 r
.8118 .52598 m .81871 .5096 L .81676 .48491 L p F P
0 g
s
.943 .669 .206 r
.82111 .49939 m .8146 .48356 L .8135 .46962 L p F P
0 g
s
.943 .669 .206 r
.8135 .46962 m .81261 .4583 L p .81408 .46541 L F P
0 g
s
.943 .669 .206 r
.82111 .49939 m .8135 .46962 L .81408 .46541 L F
0 .04 .599 r
.80695 .44832 m .80814 .45963 L p .8112 .46052 L F P
0 g
s
0 .1 .652 r
.79115 .41632 m .79511 .4327 L .80695 .44832 L p F P
0 g
s
.954 .611 .232 r
.80001 .43903 m .80167 .44135 L p .80015 .43935 L F P
0 g
s
.954 .611 .232 r
.80167 .44135 m .8106 .45383 L p .80015 .43935 L F P
0 g
s
.954 .611 .232 r
.8106 .45383 m .8135 .46962 L p .80015 .43935 L F P
0 g
s
.976 .672 .347 r
.80202 .44351 m .81261 .4583 L .8135 .46962 L p F P
0 g
s
.976 .672 .347 r
.8135 .46962 m .8146 .48356 L p .80768 .46153 L F P
0 g
s
.954 .611 .232 r
.81152 .46687 m .80001 .43903 L .8135 .46962 L F
.069 0 .449 r
.80573 .48092 m .80662 .45986 L .80607 .45966 L F
0 .143 .671 r
.79592 .44009 m .79511 .4327 L p .80648 .45981 L F P
0 g
s
0 .143 .671 r
.80589 .4596 m .79592 .44009 L .80648 .45981 L F
.069 0 .449 r
.80573 .48092 m .80803 .47707 L .8067 .45988 L p F P
0 g
s
.069 0 .449 r
.80573 .48092 m .8067 .45988 L .80662 .45986 L F
.042 .176 .679 r
.80288 .45839 m .80223 .45653 L .80405 .45895 L p F P
0 g
s
.976 .672 .347 r
.8146 .48356 m .80395 .46883 L .80289 .45486 L p F P
0 g
s
.954 .611 .232 r
.81152 .46687 m .8037 .45599 L .80001 .43903 L F
.976 .672 .347 r
.8146 .48356 m .80289 .45486 L .80768 .46153 L F
.954 .611 .232 r
.80289 .45486 m .80001 .43903 L p .80455 .45993 L F P
0 g
s
.976 .672 .347 r
.80289 .45486 m .80202 .44351 L p .80768 .46153 L F P
0 g
s
.954 .611 .232 r
.81418 .47329 m .80455 .45993 L p .8037 .45599 L F P
0 g
s
.954 .611 .232 r
.81418 .47329 m .8037 .45599 L .81152 .46687 L F
.80455 .45993 m .80355 .45854 L .80289 .45486 L p F P
0 g
s
0 .198 .719 r
.78021 .40467 m .79115 .41632 L .79511 .4327 L p F P
0 g
s
0 .1 .652 r
.80695 .44832 m .80306 .43194 L .79115 .41632 L p F P
0 g
s
.875 .45 .035 r
.79453 .42043 m .78183 .40609 L .77447 .38836 L p F P
0 g
s
.926 .54 .176 r
.78183 .40609 m .79453 .42043 L .80001 .43903 L p F P
0 g
s
.121 .274 .748 r
.79108 .42839 m .7805 .41828 L p .79649 .44969 L F P
0 g
s
.121 .274 .748 r
.79649 .44969 m .79592 .44009 L .79108 .42839 L p F P
0 g
s
.048 .254 .75 r
.7805 .41828 m .79108 .42839 L .78021 .40467 L p F P
0 g
s
.05 .226 .725 r
.79592 .44009 m .79108 .42839 L .79511 .4327 L closepath p F P
0 g
s
0 .198 .719 r
.79511 .4327 m .79108 .42839 L .78021 .40467 L p F P
0 g
s
.926 .54 .176 r
.80001 .43903 m .78968 .42742 L p .78183 .40609 L F P
0 g
s
.945 .637 .424 r
.78727 .42989 m .78677 .42297 L p .78802 .42489 L F P
0 g
s
.926 .54 .176 r
.78677 .42297 m .78183 .40609 L p .78968 .42742 L F P
0 g
s
.038 .198 .702 r
.80223 .45653 m .79649 .44969 L .79592 .44009 L closepath p F P
0 g
s
.953 .607 .295 r
.78968 .42742 m .80001 .43903 L .80289 .45486 L p F P
0 g
s
.945 .637 .424 r
.79789 .4397 m .79374 .43587 L p .78959 .41451 L F P
0 g
s
.945 .637 .424 r
.79374 .43587 m .78727 .42989 L p .78813 .4242 L F P
0 g
s
.945 .637 .424 r
.79374 .43587 m .78813 .4242 L .78959 .41451 L F
.113 .225 .702 r
.80288 .45839 m .80223 .45653 L p .80262 .45833 L F P
0 g
s
.19 .076 .484 r
.79636 .45528 m .79934 .45588 L .79666 .45414 L F
.796 .45665 m .79937 .45672 L .79636 .45528 L F
.113 .225 .702 r
.80223 .45653 m .79649 .44969 L p .7992 .45746 L F P
0 g
s
.113 .225 .702 r
.80262 .45833 m .80223 .45653 L .7992 .45746 L F
.19 .076 .484 r
.79194 .47222 m .80279 .45837 L p .8027 .45834 L F P
0 g
s
.18 .29 .741 r
.78162 .43538 m .79649 .44969 L .796 .45665 L p F P
0 g
s
.113 .225 .702 r
.79649 .44969 m .796 .45665 L p .7992 .45746 L F P
0 g
s
.121 .274 .748 r
.7805 .41828 m .78162 .43538 L .79649 .44969 L p F P
0 g
s
.945 .637 .424 r
.78727 .42989 m .80202 .44351 L .80395 .46883 L p F P
0 g
s
.953 .607 .295 r
.78728 .42473 m .78968 .42742 L p .80355 .45854 L F P
0 g
s
.953 .607 .295 r
.80289 .45486 m .80355 .45854 L p .78968 .42742 L F P
0 g
s
.926 .54 .176 r
.78968 .42742 m .78728 .42473 L .78677 .42297 L p F P
0 g
s
.945 .637 .424 r
.78874 .42014 m .78802 .42489 L .78633 .41691 L F
.78677 .42297 m .78633 .41691 L p .78802 .42489 L F P
0 g
s
.945 .637 .424 r
.78959 .41451 m .78874 .42014 L .78545 .40485 L F
.78633 .41691 m .78545 .40485 L p .78874 .42014 L F P
0 g
s
.908 .528 .094 r
.8106 .45383 m .80001 .43903 L .79453 .42043 L p F P
0 g
s
.945 .637 .424 r
.80202 .44351 m .79789 .4397 L p .78959 .41451 L F P
0 g
s
.976 .672 .347 r
.80768 .46153 m .80202 .44351 L .8135 .46962 L F
.954 .611 .232 r
.81329 .47115 m .81152 .46687 L .8135 .46962 L F
.8135 .46962 m .81418 .47329 L p .81329 .47115 L F P
0 g
s
.931 .601 .151 r
.82267 .4885 m .81418 .47329 L .8135 .46962 L p F P
0 g
s
.931 .601 .151 r
.82267 .4885 m .8135 .46962 L .8155 .46792 L F
.859 .498 0 r
.81819 .46697 m .80508 .43525 L .81854 .46734 L F
0 0 .435 r
.81252 .44864 m .80615 .43709 L .79927 .42203 L p F P
0 g
s
0 0 .435 r
.79927 .42203 m .79685 .41609 L p .81252 .44864 L F P
0 g
s
0 0 .435 r
.79685 .41609 m .80612 .43288 L .81252 .44864 L p F P
0 g
s
.753 .37 0 r
.79767 .41757 m .80612 .43288 L .81354 .45055 L p F P
0 g
s
.753 .37 0 r
.81354 .45055 m .80508 .43525 L .79767 .41757 L p F P
0 g
s
.859 .498 0 r
.8106 .45383 m .80508 .43525 L p .81819 .46697 L F P
0 g
s
.859 .498 0 r
.81749 .46624 m .8106 .45383 L p .81819 .46697 L F P
0 g
s
.943 .669 .206 r
.81261 .4583 m .81065 .43338 L p .81744 .46619 L F P
0 g
s
.943 .669 .206 r
.81909 .47421 m .81465 .4633 L p .81744 .46619 L F P
0 g
s
.943 .669 .206 r
.81465 .4633 m .81261 .4583 L p .81744 .46619 L F P
0 g
s
.943 .669 .206 r
.81745 .46627 m .81749 .46624 L .81854 .46734 L F
.859 .498 0 r
.81907 .46909 m .81749 .46624 L p .81819 .46697 L F P
0 g
s
.931 .601 .151 r
.81907 .46909 m .82267 .4885 L p .8155 .46792 L F P
0 g
s
.931 .601 .151 r
.81749 .46624 m .81907 .46909 L p .8155 .46792 L F P
0 g
s
.943 .669 .206 r
.81745 .46627 m .81744 .46619 L .81749 .46624 L F
.81744 .46619 m .81065 .43338 L .81854 .46734 L F
.859 .498 0 r
.81854 .46782 m .81819 .46697 L .81854 .46734 L F
.81854 .46734 m .81907 .46909 L p .81854 .46782 L F P
0 g
s
.771 .444 0 r
.82545 .48479 m .81907 .46909 L .81854 .46734 L p F P
0 g
s
.771 .444 0 r
.82545 .48479 m .81854 .46734 L .81894 .46607 L F
.774 .572 .001 r
.81889 .46621 m .81851 .46255 L .81922 .46517 L F
.81889 .46621 m .81922 .46517 L .81956 .46641 L F
.8171 .44936 m .81933 .46482 L p .81851 .46255 L F P
0 g
s
.774 .572 .001 r
.81933 .46482 m .81956 .46641 L p .81851 .46255 L F P
0 g
s
.774 .572 .001 r
.81956 .46641 m .81933 .46482 L p .81941 .46505 L F P
0 g
s
0 0 .284 r
.81955 .46539 m .81941 .46503 L .81946 .46518 L F
.771 .444 0 r
.81992 .46628 m .82545 .48479 L p .81894 .46607 L F P
0 g
s
0 0 .379 r
.81946 .46518 m .81992 .46628 L p .81959 .46591 L F P
0 g
s
0 0 .284 r
.81946 .46518 m .81992 .46628 L p .81955 .46539 L F P
0 g
s
.771 .444 0 r
.81933 .46482 m .81992 .46628 L p .81894 .46607 L F P
0 g
s
.774 .572 .001 r
.81514 .42484 m .81759 .44196 L .81941 .46456 L p F P
0 g
s
.774 .572 .001 r
.81941 .46456 m .81946 .46518 L p .8194 .4646 L F P
0 g
s
.774 .572 .001 r
.8194 .4646 m .81514 .42484 L .81941 .46456 L F
.18 .29 .741 r
.79484 .45663 m .78162 .43538 L .796 .45665 L F
.78631 .455 m .78123 .44156 L p .78907 .45595 L F P
0 g
s
.18 .29 .741 r
.78123 .44156 m .78162 .43538 L p .79064 .45649 L F P
0 g
s
.18 .29 .741 r
.78907 .45595 m .78123 .44156 L .79064 .45649 L F
.282 .336 .742 r
.7797 .45323 m .78063 .45402 L p .77992 .45385 L F P
0 g
s
.353 .193 .52 r
.77354 .46371 m .78088 .45763 L .78063 .45402 L p F P
0 g
s
.282 .336 .742 r
.77952 .45395 m .7797 .45323 L p .77996 .45398 L F P
0 g
s
.19 .076 .484 r
.7908 .45655 m .79194 .47222 L p .796 .45665 L F P
0 g
s
.9 .597 .465 r
.78545 .40485 m .76838 .39357 L p .76493 .36765 L F P
0 g
s
.9 .597 .465 r
.76838 .39357 m .7666 .39239 L .76652 .39115 L p F P
0 g
s
.891 .465 .118 r
.76838 .39357 m .76742 .39232 L .75967 .37452 L F
.76652 .39115 m .75967 .37452 L p .76768 .39291 L F P
0 g
s
.9 .597 .465 r
.76652 .39115 m .76493 .36765 L p .76838 .39357 L F P
0 g
s
.891 .465 .118 r
.76838 .39357 m .76768 .39291 L p .76742 .39232 L F P
0 g
s
.891 .465 .118 r
.76768 .39291 m .76698 .39226 L .76652 .39115 L p F P
0 g
s
.889 .469 .185 r
.75967 .37452 m .76652 .39115 L p .75827 .3806 L F P
0 g
s
.857 .562 .487 r
.76573 .39014 m .76555 .38967 L .76652 .39115 L F
.76555 .38967 m .75517 .36286 L .76652 .39115 L F
.75517 .36286 m .76493 .36765 L .76652 .39115 L p F P
0 g
s
.857 .562 .487 r
.76652 .39115 m .7666 .39239 L p .76573 .39014 L F P
0 g
s
.353 .193 .52 r
.77764 .41138 m .77039 .41751 L .77196 .44047 L p F P
0 g
s
.353 .193 .52 r
.77196 .44047 m .77925 .43436 L .77764 .41138 L p F P
0 g
s
.131 .324 .79 r
.76205 .39809 m .75999 .38841 L p .7805 .41828 L F P
0 g
s
.131 .324 .79 r
.75999 .38841 m .77709 .40171 L .7805 .41828 L p F P
0 g
s
.857 .562 .487 r
.7666 .39239 m .75677 .38762 L .75614 .37788 L p F P
0 g
s
.857 .562 .487 r
.7666 .39239 m .75614 .37788 L .76573 .39014 L F
.889 .469 .185 r
.74624 .36399 m .75967 .37452 L p .75823 .38081 L F P
0 g
s
.857 .562 .487 r
.75614 .37788 m .75517 .36286 L p .76573 .39014 L F P
0 g
s
.835 .543 .496 r
.75677 .38762 m .74485 .36237 L .74624 .36399 L F
.75598 .37535 m .75614 .37788 L p .74624 .36399 L F P
0 g
s
.835 .543 .496 r
.75614 .37788 m .75677 .38762 L p .74624 .36399 L F P
0 g
s
.833 .36 .032 r
.74314 .36081 m .74263 .36001 L .74431 .36217 L F
.74263 .36001 m .73279 .34463 L .74348 .36091 L F
.74263 .36001 m .74348 .36091 L .74431 .36217 L F
.26 .419 .832 r
.74204 .39199 m .73938 .37662 L p .76319 .40506 L F P
0 g
s
.212 .418 .846 r
.74516 .36663 m .73397 .3605 L .73938 .37662 L p F P
0 g
s
.153 .413 .856 r
.73397 .3605 m .74516 .36663 L .73455 .3497 L p F P
0 g
s
.835 .543 .496 r
.75677 .38762 m .74215 .38167 L .74071 .35796 L p F P
0 g
s
.835 .543 .496 r
.75677 .38762 m .74071 .35796 L .74184 .35916 L F
.833 .36 .032 r
.74411 .36232 m .74264 .36122 L .74071 .35796 L p F P
0 g
s
.833 .36 .032 r
.74071 .35796 m .73279 .34463 L p .74314 .36081 L F P
0 g
s
.833 .36 .032 r
.74411 .36232 m .74071 .35796 L .74314 .36081 L F
.328 .497 .873 r
.71432 .36669 m .73227 .37336 L .72164 .35491 L p F P
0 g
s
.328 .497 .873 r
.72164 .35491 m .70939 .35042 L .71432 .36669 L p F P
0 g
s
.307 .458 .848 r
.74204 .39199 m .73227 .37336 L .73938 .37662 L closepath p F P
0 g
s
.269 .461 .864 r
.73938 .37662 m .73227 .37336 L .72164 .35491 L p F P
0 g
s
.29 .504 .891 r
.70939 .35042 m .72164 .35491 L .71101 .33832 L p F P
0 g
s
.269 .461 .864 r
.72164 .35491 m .73397 .3605 L .73938 .37662 L p F P
0 g
s
.223 .463 .878 r
.73397 .3605 m .72164 .35491 L .71101 .33832 L p F P
0 g
s
.153 .413 .856 r
.73455 .3497 m .72597 .34503 L .73397 .3605 L p F P
0 g
s
.223 .463 .878 r
.71101 .33832 m .72597 .34503 L .73397 .3605 L p F P
0 g
s
.797 .512 .507 r
.71579 .34966 m .73926 .35649 L p .74215 .38167 L F P
0 g
s
.797 .512 .507 r
.74215 .38167 m .73926 .35649 L .73952 .35675 L F
.835 .373 .109 r
.71952 .33626 m .73279 .34463 L .74071 .35796 L p F P
0 g
s
.797 .512 .507 r
.74071 .35796 m .74215 .38167 L p .7395 .35655 L F P
0 g
s
.782 .279 0 r
.71952 .33626 m .71662 .3337 L .70647 .32353 L F
.797 .512 .507 r
.7395 .35655 m .71579 .34966 L .71484 .33213 L p F P
0 g
s
.797 .512 .507 r
.7395 .35655 m .71484 .33213 L .73023 .34571 L F
.782 .279 0 r
.71859 .33567 m .71258 .33 L .70647 .32353 L F
.797 .512 .507 r
.71484 .33213 m .71458 .32743 L p .73023 .34571 L F P
0 g
s
.766 .488 .513 r
.71484 .33213 m .71579 .34966 L p .70898 .32659 L F P
0 g
s
.782 .279 0 r
.71859 .33567 m .717 .33468 L p .71339 .33085 L F P
0 g
s
.782 .279 0 r
.71484 .33213 m .71339 .33085 L .71258 .33 L F
.71859 .33567 m .71339 .33085 L .71484 .33213 L F
.835 .373 .109 r
.71297 .33213 m .71952 .33626 L p .74264 .36122 L F P
0 g
s
.835 .373 .109 r
.74071 .35796 m .74264 .36122 L p .71952 .33626 L F P
0 g
s
.797 .512 .507 r
.73926 .35649 m .7395 .35655 L p .73952 .35675 L F P
0 g
s
.797 .512 .507 r
.7395 .35655 m .74064 .35689 L .74071 .35796 L p F P
0 g
s
.835 .543 .496 r
.74071 .35796 m .74064 .35689 L p .74184 .35916 L F P
0 g
s
.889 .469 .185 r
.74329 .36268 m .74411 .36232 L p .75823 .38081 L F P
0 g
s
.889 .469 .185 r
.76698 .39226 m .76167 .38563 L .75823 .38081 L F
.76167 .38563 m .74329 .36268 L .75823 .38081 L F
.74411 .36232 m .74624 .36399 L p .75614 .37788 L F P
0 g
s
.889 .469 .185 r
.75823 .38081 m .74982 .3698 L .75614 .37788 L F
.74982 .3698 m .74411 .36232 L .75614 .37788 L F
.76698 .39226 m .75823 .38081 L .75827 .3806 L F
.76652 .39115 m .76698 .39226 L p .75827 .3806 L F P
0 g
s
.835 .543 .496 r
.7559 .37411 m .75598 .37535 L p .74624 .36399 L F P
0 g
s
.835 .543 .496 r
.74624 .36399 m .74485 .36237 L .74582 .36339 L F
.74624 .36399 m .74582 .36339 L .7559 .37411 L F
.85 .389 .06 r
.74624 .36399 m .74411 .36232 L .74485 .36237 L p F P
0 g
s
.833 .36 .032 r
.75025 .35776 m .75333 .36292 L .74411 .36232 L p F P
0 g
s
.835 .543 .496 r
.74064 .35689 m .75517 .36286 L .7559 .37411 L p F P
0 g
s
.835 .543 .496 r
.74184 .35916 m .74064 .35689 L .7559 .37411 L F
.833 .36 .032 r
.74431 .36217 m .74348 .36091 L .74452 .36201 L F
.74411 .36232 m .74314 .36081 L .74431 .36217 L F
.797 .512 .507 r
.74064 .35689 m .7395 .35655 L p .71446 .32519 L F P
0 g
s
.797 .512 .507 r
.71458 .32743 m .71446 .32519 L p .7395 .35655 L F P
0 g
s
.797 .512 .507 r
.71446 .32519 m .73915 .33244 L .74051 .35479 L p F P
0 g
s
.797 .512 .507 r
.74051 .35479 m .74064 .35689 L p .73461 .34958 L F P
0 g
s
.797 .512 .507 r
.73461 .34958 m .71446 .32519 L .74051 .35479 L F
.782 .279 0 r
.71952 .33626 m .71859 .33567 L p .71662 .3337 L F P
0 g
s
.782 .279 0 r
.70829 .32594 m .70647 .32353 L p .71258 .33 L F P
0 g
s
.766 .488 .513 r
.71579 .34966 m .70829 .32594 L .70898 .32659 L F
.782 .279 0 r
.717 .33468 m .70829 .32594 L .71258 .33 L F
.766 .488 .513 r
.71579 .34966 m .70947 .34838 L .70829 .32594 L p F P
0 g
s
.766 .488 .513 r
.70829 .32594 m .70818 .3239 L p .70898 .32659 L F P
0 g
s
.766 .488 .513 r
.7148 .33143 m .71484 .33213 L p .70895 .3265 L F P
0 g
s
.766 .488 .513 r
.70898 .32659 m .70895 .3265 L .71484 .33213 L F
.70818 .3239 m .71446 .32519 L .7148 .33143 L p F P
0 g
s
.766 .488 .513 r
.70895 .3265 m .70818 .3239 L .7148 .33143 L F
.787 .298 .049 r
.71297 .33213 m .70079 .32562 L .70574 .32379 L p F P
0 g
s
.787 .298 .049 r
.70574 .32379 m .70589 .32374 L p .7064 .32435 L F P
0 g
s
.787 .298 .049 r
.71297 .33213 m .70574 .32379 L .7064 .32435 L F
.70829 .32594 m .71297 .33213 L p .70589 .32374 L F P
0 g
s
.736 .464 .517 r
.70574 .3236 m .70599 .32363 L p .70602 .32386 L F P
0 g
s
.736 .464 .517 r
.70599 .32363 m .70818 .3239 L .70829 .32594 L p F P
0 g
s
.782 .279 0 r
.717 .33468 m .71297 .33213 L .70829 .32594 L p F P
0 g
s
.763 .262 .02 r
.67753 .30525 m .6916 .31221 L p .70079 .32562 L F P
0 g
s
.763 .262 .02 r
.70079 .32562 m .6916 .31221 L .70073 .31958 L F
0 .35 .802 r
.70273 .31179 m .68614 .30291 L .7021 .31621 L p F P
0 g
s
0 .303 .734 r
.68614 .30291 m .70273 .31179 L .69652 .30698 L p F P
0 g
s
0 .303 .734 r
.66904 .29143 m .68614 .30291 L p .69652 .30698 L F P
0 g
s
0 .173 .604 r
.69207 .30394 m .6887 .30173 L .69652 .30698 L closepath p F P
0 g
s
.472 0 0 r
.6887 .30173 m .69207 .30394 L .68138 .29927 L p F P
0 g
s
.472 0 0 r
.68138 .29927 m .66723 .28996 L .6887 .30173 L p F P
0 g
s
0 .35 .802 r
.7021 .31621 m .71336 .32226 L .70273 .31179 L p F P
0 g
s
.543 0 0 r
.7062 .31473 m .69207 .30394 L .68138 .29927 L p F P
0 g
s
.662 .11 0 r
.68568 .30256 m .7062 .31473 L p .71231 .32358 L F P
0 g
s
.543 0 0 r
.68138 .29927 m .68568 .30256 L .7062 .31473 L p F P
0 g
s
.599 .028 0 r
.68568 .30256 m .67763 .29857 L .68138 .29927 L closepath p F P
0 g
s
.662 .11 0 r
.71231 .32358 m .7007 .31671 L .68568 .30256 L p F P
0 g
s
.694 .152 0 r
.67763 .29857 m .68568 .30256 L .7007 .31671 L p F P
0 g
s
.694 .152 0 r
.7007 .31671 m .67753 .30525 L .67066 .29875 L p F P
0 g
s
.736 .464 .517 r
.70767 .3234 m .6916 .31221 L .68022 .29642 L F
.694 .152 0 r
.68204 .30555 m .6815 .30518 L .67763 .29857 L F
.67275 .2987 m .67763 .29857 L p .68155 .30526 L F P
0 g
s
.736 .464 .517 r
.68059 .30454 m .68053 .30328 L p .6916 .31221 L F P
0 g
s
.541 0 0 r
.66723 .28996 m .68138 .29927 L .67763 .29857 L p F P
0 g
s
.736 .464 .517 r
.68053 .30328 m .68022 .29642 L p .6916 .31221 L F P
0 g
s
.736 .464 .517 r
.70818 .3239 m .70571 .3236 L p .69216 .31266 L F P
0 g
s
.763 .262 .02 r
.70589 .32374 m .70079 .32562 L p .70073 .31958 L F P
0 g
s
.694 .152 0 r
.68204 .30555 m .68155 .30526 L .6815 .30518 L F
.7 .435 .521 r
.6805 .30263 m .68059 .30454 L p .66935 .29609 L F P
0 g
s
.7 .435 .521 r
.66939 .29619 m .66935 .29609 L .68059 .30454 L F
.694 .152 0 r
.67066 .29875 m .67275 .2987 L p .68155 .30526 L F P
0 g
s
.651 .095 0 r
.66271 .2922 m .66618 .29445 L .6724 .2987 L F
.7 .435 .521 r
.6687 .29607 m .66935 .29609 L p .66963 .29668 L F P
0 g
s
.7 .435 .521 r
.66935 .29609 m .68022 .29642 L .6805 .30263 L p F P
0 g
s
.672 .134 0 r
.66271 .2922 m .67066 .29875 L p .66201 .29179 L F P
0 g
s
.672 .134 0 r
.66189 .2917 m .66271 .2922 L .66201 .29179 L F
.651 .095 0 r
.67275 .2987 m .6724 .2987 L p .66618 .29445 L F P
0 g
s
.7 .435 .521 r
.66935 .29609 m .6687 .29607 L p .66271 .2922 L F P
0 g
s
.7 .435 .521 r
.68022 .29642 m .66935 .29609 L p .6619 .27206 L F P
0 g
s
.7 .435 .521 r
.66271 .2922 m .6619 .27206 L p .66935 .29609 L F P
0 g
s
.361 .58 .926 r
.67113 .32733 m .68805 .33094 L .67734 .31628 L p F P
0 g
s
.361 .58 .926 r
.67734 .31628 m .66038 .31271 L .67113 .32733 L p F P
0 g
s
.398 .601 .929 r
.65477 .31182 m .66038 .31271 L .67113 .32733 L p F P
0 g
s
.322 .592 .942 r
.66038 .31271 m .67734 .31628 L .66658 .30326 L p F P
0 g
s
.322 .592 .942 r
.66658 .30326 m .64633 .29907 L .66038 .31271 L p F P
0 g
s
.7 .435 .521 r
.68131 .32058 m .66382 .32006 L .66285 .2959 L p F P
0 g
s
.672 .134 0 r
.67066 .29875 m .66575 .30036 L p .6619 .29173 L F P
0 g
s
.672 .134 0 r
.6619 .29173 m .66189 .2917 L .66201 .29179 L F
.6619 .29173 m .66201 .29179 L .67066 .29875 L F
.637 .387 .522 r
.65 .28533 m .6504 .29618 L p .64156 .28054 L F P
0 g
s
.586 .012 0 r
.66099 .29114 m .65714 .28911 L .64631 .28123 L F
.678 .419 .522 r
.66285 .2959 m .6504 .29618 L .65 .28533 L p F P
0 g
s
.678 .419 .522 r
.66285 .2959 m .65 .28533 L .65981 .29052 L F
.586 .012 0 r
.64305 .28139 m .64631 .28123 L p .65885 .29034 L F P
0 g
s
.678 .419 .522 r
.65 .28533 m .64953 .27234 L p .65981 .29052 L F P
0 g
s
.586 .012 0 r
.65885 .29034 m .63572 .28174 L .64259 .28141 L p F P
0 g
s
.586 .012 0 r
.64259 .28141 m .64305 .28139 L p .65 .28533 L F P
0 g
s
.586 .012 0 r
.65885 .29034 m .64259 .28141 L .65 .28533 L F
.368 .615 .946 r
.66038 .31271 m .65477 .31182 L .64392 .2987 L p F P
0 g
s
.368 .615 .946 r
.64392 .2987 m .64633 .29907 L .66038 .31271 L p F P
0 g
s
.678 .419 .522 r
.6504 .29618 m .66285 .2959 L .66382 .32006 L p F P
0 g
s
.672 .134 0 r
.63572 .28174 m .66099 .29114 L p .66575 .30036 L F P
0 g
s
.672 .134 0 r
.66099 .29114 m .66177 .29143 L p .66189 .2917 L F P
0 g
s
.672 .134 0 r
.66575 .30036 m .66099 .29114 L .66189 .2917 L F
.678 .419 .522 r
.66164 .29154 m .66099 .29114 L .66162 .29148 L F
.6627 .29205 m .66271 .2922 L p .66162 .29148 L F P
0 g
s
.651 .095 0 r
.6724 .2987 m .67066 .29875 L .66271 .2922 L p F P
0 g
s
.586 .012 0 r
.66099 .29114 m .65885 .29034 L p .65714 .28911 L F P
0 g
s
.678 .419 .522 r
.64953 .27234 m .6619 .27206 L .6627 .29205 L p F P
0 g
s
.678 .419 .522 r
.65981 .29052 m .64953 .27234 L .6627 .29205 L F
.637 .387 .522 r
.64953 .27234 m .65 .28533 L p .64156 .28054 L F P
0 g
s
.526 0 0 r
.64305 .28139 m .63572 .28174 L p .64022 .28006 L F P
0 g
s
.526 0 0 r
.61359 .26981 m .64257 .27918 L p .63572 .28174 L F P
0 g
s
.637 .387 .522 r
.64147 .28064 m .62912 .27483 L .6421 .27999 L F
.62912 .27483 m .64953 .27234 L p .6421 .27999 L F P
0 g
s
.402 0 0 r
.62776 .27439 m .62912 .27483 L p .62634 .2738 L F P
0 g
s
.402 0 0 r
.62745 .27417 m .62634 .2738 L .62912 .27483 L F
.62634 .2738 m .61138 .26884 L .62776 .27439 L F
.637 .387 .522 r
.64867 .24883 m .64953 .27234 L .62912 .27483 L p F P
0 g
s
.637 .387 .522 r
.62492 .27316 m .64867 .24883 L .62912 .27483 L F
.402 0 0 r
.62634 .2738 m .62241 .27216 L .61138 .26884 L F
.61605 .26951 m .61558 .26944 L p .62241 .27216 L F P
0 g
s
.402 0 0 r
.61558 .26944 m .61138 .26884 L p .62241 .27216 L F P
0 g
s
.402 0 0 r
.62745 .27417 m .62241 .27216 L .62634 .2738 L F
.637 .387 .522 r
.62183 .25213 m .64867 .24883 L p .62492 .27316 L F P
0 g
s
.637 .387 .522 r
.62241 .27216 m .62183 .25213 L p .62492 .27316 L F P
0 g
s
.588 .348 .521 r
.62183 .25213 m .62239 .27157 L p .61605 .26951 L F P
0 g
s
.588 .348 .521 r
.60928 .26731 m .60966 .26685 L .61605 .26951 L F
.60966 .26685 m .62183 .25213 L .61605 .26951 L F
.313 0 0 r
.59798 .26366 m .59824 .26372 L .61463 .26931 L F
.61605 .26951 m .61463 .26931 L p .59824 .26372 L F P
0 g
s
.313 0 0 r
.61138 .26884 m .58806 .26092 L p .59798 .26366 L F P
0 g
s
.313 0 0 r
.61463 .26931 m .61138 .26884 L p .59798 .26366 L F P
0 g
s
.529 .302 .515 r
.59403 .26231 m .59362 .26217 L .59407 .26225 L F
.588 .348 .521 r
.59702 .25804 m .62183 .25213 L p .60928 .26731 L F P
0 g
s
.588 .348 .521 r
.59714 .26337 m .59702 .25804 L p .60928 .26731 L F P
0 g
s
.313 0 0 r
.59798 .26366 m .59818 .26371 L .59824 .26372 L F
.58806 .26092 m .5968 .26325 L .59798 .26366 L F
.529 .302 .515 r
.59407 .26225 m .59362 .26217 L .59702 .25804 L F
.5896 .26081 m .59702 .25804 L p .59362 .26217 L F P
0 g
s
0 .42 .697 r
.59621 .26305 m .58854 .26099 L .59136 .26179 L p F P
0 g
s
.313 0 0 r
.58806 .26092 m .58854 .26099 L .59621 .26305 L p F P
0 g
s
.313 0 0 r
.58806 .26092 m .59621 .26305 L .5968 .26325 L F
.529 .302 .515 r
.58837 .26127 m .5743 .26653 L p .57911 .25968 L F P
0 g
s
.529 .302 .515 r
.5743 .26653 m .57419 .25884 L p .57911 .25968 L F P
0 g
s
0 .513 .767 r
.56516 .25693 m .5685 .25786 L p .58854 .26099 L F P
0 g
s
0 .513 .767 r
.5685 .25786 m .56899 .258 L p .57181 .25843 L F P
0 g
s
0 .513 .767 r
.58854 .26099 m .5685 .25786 L .57181 .25843 L F
.58854 .26099 m .56899 .258 L .58236 .26016 L F
.174 .677 .909 r
.56276 .25772 m .56029 .25744 L .55965 .25771 L F
.54259 .25546 m .54893 .25786 L p .56029 .25744 L F P
0 g
s
.277 .744 .945 r
.54117 .25892 m .54186 .26049 L .54254 .25874 L F
.369 .181 .489 r
.54883 .25788 m .53524 .26792 L p .5396 .25914 L F P
0 g
s
.277 .744 .945 r
.54102 .25858 m .54117 .25892 L .54254 .25874 L F
.5203 .25651 m .53646 .25949 L .54102 .25858 L F
.265 .102 .464 r
.52834 .27473 m .53524 .26792 L .5352 .25974 L p F P
0 g
s
.265 .102 .464 r
.52834 .27473 m .5352 .25974 L .53496 .25979 L F
.52831 .26181 m .52834 .27473 L p .53159 .26059 L F P
0 g
s
.353 .773 .977 r
.53397 .25999 m .52876 .25965 L .53116 .26075 L p F P
0 g
s
.434 .816 .99 r
.52981 .26115 m .52831 .26181 L .53006 .26116 L F
.195 .049 .444 r
.51983 .28468 m .52834 .27473 L .52831 .26181 L p F P
0 g
s
.195 .049 .444 r
.51983 .28468 m .52831 .26181 L .52536 .26331 L F
.48 .808 1 r
.52048 .26564 m .52152 .26525 L .52069 .26567 L F
.5103 .26453 m .52517 .26229 L p .52048 .26564 L F P
0 g
s
.434 .816 .99 r
.50078 .26029 m .5103 .26453 L .52517 .26229 L p F P
0 g
s
.434 .816 .99 r
.52517 .26229 m .52831 .26181 L p .52614 .26169 L F P
0 g
s
.434 .816 .99 r
.50078 .26029 m .52517 .26229 L .52614 .26169 L F
.50078 .26029 m .52831 .26181 L .52981 .26115 L F
.48 .808 1 r
.52048 .26564 m .52069 .26567 L .51983 .2661 L F
.195 .049 .444 r
.51983 .2661 m .51983 .28468 L p .52536 .26331 L F P
0 g
s
.545 .835 .998 r
.51675 .2683 m .5103 .26453 L p .51365 .27094 L F P
0 g
s
.036 0 .392 r
.50978 .27854 m .51516 .26966 L p .5112 .27302 L F P
0 g
s
.48 .808 1 r
.51675 .2683 m .5103 .26453 L p .52048 .26564 L F P
0 g
s
.545 .835 .998 r
.51259 .27088 m .50979 .27421 L .51365 .27094 L F
.036 0 .392 r
.50979 .27421 m .50978 .27854 L p .5112 .27302 L F P
0 g
s
0 0 .323 r
.50802 .28268 m .50978 .27854 L .50979 .2742 L p F P
0 g
s
0 0 .323 r
.50802 .28268 m .50979 .2742 L .50847 .27611 L F
.545 .835 .998 r
.50861 .27448 m .50979 .27421 L p .48858 .26945 L F P
0 g
s
.545 .835 .998 r
.48858 .26945 m .50979 .27421 L .51259 .27088 L F
.571 .813 .99 r
.50979 .27421 m .50861 .27448 L .50961 .27446 L p F P
0 g
s
.586 .807 .984 r
.50861 .27448 m .50054 .2764 L p .50848 .27567 L F P
0 g
s
.586 .807 .984 r
.50898 .27447 m .50861 .27448 L p .50848 .27567 L F P
0 g
s
.629 .822 .974 r
.47911 .28297 m .50054 .2764 L .50635 .28079 L p F P
0 g
s
.629 .822 .974 r
.47911 .28297 m .50635 .28079 L .50483 .28476 L F
0 0 .221 r
.50362 .28793 m .50356 .30011 L p .50552 .28297 L F P
0 g
s
0 0 .323 r
.50804 .27673 m .50802 .28268 L p .50847 .27611 L F P
0 g
s
.586 .807 .984 r
.50879 .27564 m .50848 .27567 L .50859 .27594 L F
.50054 .2764 m .50635 .28079 L p .50848 .27567 L F P
0 g
s
.78 .625 .063 r
.50345 .30169 m .50337 .31912 L p .50314 .29766 L F P
0 g
s
.942 .715 .244 r
.5079 .3361 m .50337 .31912 L .50345 .30169 L p F P
0 g
s
.942 .715 .244 r
.5079 .3361 m .50345 .30169 L .50347 .30172 L F
0 0 .048 r
.50293 .31123 m .50356 .30011 L .50362 .28793 L p F P
0 g
s
0 0 .048 r
.50293 .31123 m .50362 .28793 L .50338 .29118 L F
.638 .795 .958 r
.50278 .29312 m .50326 .29273 L .50322 .29317 L F
.629 .822 .974 r
.49099 .29178 m .47911 .28297 L p .5039 .2847 L F P
0 g
s
.629 .822 .974 r
.50362 .28793 m .49099 .29178 L p .5039 .2847 L F P
0 g
s
.638 .795 .958 r
.49099 .29178 m .5024 .2883 L p .50278 .29312 L F P
0 g
s
0 0 .048 r
.50301 .296 m .50293 .31123 L p .50338 .29118 L F P
0 g
s
.674 .778 .928 r
.50395 .30319 m .5142 .31341 L p .50697 .3126 L F P
0 g
s
.942 .715 .244 r
.50797 .31571 m .5079 .3361 L p .50432 .30435 L F P
0 g
s
.942 .715 .244 r
.50797 .31527 m .50797 .31571 L p .5076 .31416 L F P
0 g
s
.989 .723 .376 r
.50797 .31571 m .50798 .31387 L p .50859 .31682 L F P
0 g
s
.674 .778 .928 r
.5142 .31341 m .50797 .31571 L p .50697 .3126 L F P
0 g
s
.643 .768 .939 r
.53529 .30708 m .5142 .31341 L .50395 .30319 L p F P
0 g
s
.643 .768 .939 r
.50358 .30207 m .53529 .30708 L .50395 .30319 L F
.674 .752 .91 r
.51032 .32382 m .50797 .31571 L .51275 .3242 L F
.50797 .31571 m .5142 .31341 L p .51275 .3242 L F P
0 g
s
.989 .723 .376 r
.51586 .35157 m .5079 .3361 L .50797 .31571 L p F P
0 g
s
.989 .723 .376 r
.51586 .35157 m .50797 .31571 L .50859 .31682 L F
.51589 .32976 m .51586 .35157 L p .50859 .31682 L F P
0 g
s
.966 .687 .452 r
.51589 .32976 m .51589 .32939 L p .51608 .32999 L F P
0 g
s
.674 .752 .91 r
.52557 .3262 m .51589 .32976 L p .51275 .3242 L F P
0 g
s
.966 .687 .452 r
.52719 .36559 m .51586 .35157 L .51589 .32976 L p F P
0 g
s
.966 .687 .452 r
.52719 .36559 m .51589 .32976 L .51608 .32999 L F
.672 .728 .891 r
.52557 .3262 m .5368 .3403 L p .52195 .33732 L F P
0 g
s
.672 .728 .891 r
.51589 .32976 m .52557 .3262 L p .52195 .33732 L F P
0 g
s
.966 .687 .452 r
.52435 .33995 m .52716 .34345 L .52716 .34381 L p F P
0 g
s
.966 .687 .452 r
.52716 .34381 m .52719 .36559 L p .52435 .33995 L F P
0 g
s
.923 .643 .492 r
.52716 .34345 m .53264 .34821 L p .53304 .34951 L F P
0 g
s
.923 .643 .492 r
.52742 .34407 m .52716 .34345 L .53304 .34951 L F
.54187 .3782 m .52719 .36559 L .52716 .34345 L p F P
0 g
s
.672 .728 .891 r
.5368 .3403 m .52716 .34381 L p .52195 .33732 L F P
0 g
s
.966 .687 .452 r
.52719 .36559 m .51608 .32999 L .5244 .34037 L F
.923 .643 .492 r
.54175 .35793 m .54187 .3782 L p .53304 .34951 L F P
0 g
s
.923 .643 .492 r
.53304 .34951 m .53264 .34821 L .54175 .35793 L F
.67 .705 .874 r
.5368 .3403 m .54791 .3557 L p .53657 .35292 L F P
0 g
s
.67 .705 .874 r
.52716 .34381 m .5368 .3403 L p .53657 .35292 L F P
0 g
s
.88 .603 .514 r
.54174 .3561 m .54199 .35625 L p .54374 .35951 L F P
0 g
s
.88 .603 .514 r
.54348 .3593 m .54174 .3561 L .54374 .35951 L F
.54199 .35625 m .55961 .36737 L .55967 .37218 L p F P
0 g
s
.667 .684 .857 r
.55397 .37096 m .54175 .35793 L .55891 .3724 L F
.55771 .37058 m .55891 .3724 L p .54175 .35793 L F P
0 g
s
.822 .553 .532 r
.56876 .37863 m .56867 .37163 L p .5737 .38169 L F P
0 g
s
.643 .657 .848 r
.55903 .37259 m .55891 .3724 L p .58211 .38692 L F P
0 g
s
.842 .569 .527 r
.55967 .37218 m .55961 .36737 L p .56181 .37356 L F P
0 g
s
.842 .569 .527 r
.56188 .37375 m .55967 .37218 L .56181 .37356 L F
.644 .676 .865 r
.57968 .36643 m .55967 .37218 L p .54791 .3557 L F P
0 g
s
.644 .676 .865 r
.55967 .37218 m .55891 .3724 L .55811 .37119 L p F P
0 g
s
.644 .676 .865 r
.55811 .37119 m .55771 .37058 L p .55967 .37218 L F P
0 g
s
.643 .657 .848 r
.59054 .38452 m .58211 .38692 L p .56217 .37444 L F P
0 g
s
.643 .657 .848 r
.55891 .3724 m .56064 .37306 L .56217 .37444 L F
.56064 .37306 m .59054 .38452 L .56217 .37444 L F
.55891 .3724 m .57968 .36643 L .59054 .38452 L p F P
0 g
s
.88 .603 .514 r
.55967 .37218 m .55985 .38944 L p .54338 .35883 L F P
0 g
s
.88 .603 .514 r
.54338 .35883 m .54199 .35625 L .55967 .37218 L F
.644 .676 .865 r
.55771 .37058 m .54791 .3557 L p .55967 .37218 L F P
0 g
s
.88 .603 .514 r
.55985 .38944 m .54187 .3782 L .54174 .3561 L p F P
0 g
s
.67 .705 .874 r
.54791 .3557 m .54175 .35793 L p .53657 .35292 L F P
0 g
s
.923 .643 .492 r
.54187 .3782 m .52742 .34407 L .53304 .34951 L F
.667 .684 .857 r
.54175 .35793 m .54791 .3557 L .55771 .37058 L p F P
0 g
s
.88 .603 .514 r
.55985 .38944 m .54348 .3593 L .54374 .35951 L F
.643 .657 .848 r
.56876 .37863 m .57687 .38438 L .56173 .37706 L F
.66 .648 .827 r
.54927 .3977 m .56982 .3904 L .58066 .4097 L p F P
0 g
s
.842 .569 .527 r
.56896 .39368 m .55985 .38944 L .55967 .37218 L p F P
0 g
s
.842 .569 .527 r
.56896 .39368 m .55967 .37218 L .56188 .37375 L F
.643 .657 .848 r
.56876 .37863 m .58211 .38692 L .57687 .38438 L F
.822 .553 .532 r
.58231 .39893 m .56896 .39368 L .56876 .37863 L p F P
0 g
s
.822 .553 .532 r
.58231 .39893 m .56876 .37863 L .5737 .38169 L F
.58211 .38692 m .58231 .39893 L p .5737 .38169 L F P
0 g
s
.842 .569 .527 r
.56876 .37863 m .56896 .39368 L p .56188 .37375 L F P
0 g
s
.641 .639 .833 r
.58211 .38692 m .59054 .38452 L .59603 .39439 L p F P
0 g
s
.788 .525 .538 r
.60459 .39899 m .6046 .39936 L p .6038 .39856 L F P
0 g
s
.619 .629 .839 r
.60913 .40229 m .59603 .39439 L .60831 .40151 L F
.788 .525 .538 r
.6046 .39936 m .60473 .40521 L p .59602 .39439 L F P
0 g
s
.619 .629 .839 r
.59603 .39439 m .59054 .38452 L p .60831 .40151 L F P
0 g
s
.619 .629 .839 r
.60751 .40074 m .59054 .38452 L .60896 .40143 L F
.60751 .40074 m .60896 .40143 L .6092 .40165 L F
.614 .605 .819 r
.61208 .42519 m .60294 .40703 L .60913 .40229 L p F P
0 g
s
.761 .503 .542 r
.61037 .40631 m .60473 .40521 L .6046 .39936 L p F P
0 g
s
.619 .629 .839 r
.60913 .40229 m .60797 .40118 L .6092 .40165 L F
.615 .622 .834 r
.61027 .40207 m .60913 .40229 L .60965 .40182 L p F P
0 g
s
.761 .503 .542 r
.61037 .40631 m .6046 .39936 L .60909 .40149 L F
.619 .629 .839 r
.60965 .40182 m .60913 .40229 L p .6092 .40165 L F P
0 g
s
.761 .503 .542 r
.60969 .40178 m .60423 .3832 L .61027 .40205 L F
.60909 .40149 m .60909 .40148 L .60969 .40178 L F
.60909 .40148 m .60423 .3832 L .60969 .40178 L F
.615 .622 .834 r
.60965 .40182 m .60969 .40178 L p .61027 .40207 L F P
0 g
s
.615 .622 .834 r
.60969 .40178 m .61884 .39349 L p .61027 .40207 L F P
0 g
s
.619 .629 .839 r
.6092 .40165 m .61144 .38008 L .60965 .40182 L F
.761 .503 .542 r
.61027 .40205 m .61037 .40631 L p .60909 .40149 L F P
0 g
s
.619 .629 .839 r
.59054 .38452 m .61144 .38008 L p .60921 .40155 L F P
0 g
s
.619 .629 .839 r
.60896 .40143 m .59054 .38452 L .60921 .40155 L F
.61144 .38008 m .61884 .39349 L .60965 .40182 L p F P
0 g
s
.735 .481 .545 r
.62523 .40808 m .62379 .40791 L p .62348 .40737 L F P
0 g
s
.615 .622 .834 r
.61884 .39349 m .62219 .39973 L .61027 .40207 L p F P
0 g
s
.735 .481 .545 r
.62379 .40791 m .62325 .40784 L p .62308 .40755 L F P
0 g
s
.735 .481 .545 r
.62325 .40784 m .61037 .40631 L .61027 .40207 L p F P
0 g
s
.614 .605 .819 r
.62219 .39973 m .62709 .40955 L p .61961 .40622 L F P
0 g
s
.579 .387 .585 r
.64894 .72116 m .64747 .70108 L .66832 .69474 L p F P
0 g
s
.602 .404 .585 r
.64747 .70108 m .64894 .72116 L .62726 .72646 L p F P
0 g
s
.756 .711 .81 r
.42513 .42243 m .44241 .40946 L .44974 .41338 L p F P
0 g
s
.752 .713 .815 r
.44974 .41338 m .44546 .40727 L .44241 .40946 L closepath p F P
0 g
s
.606 .381 .548 r
.6854 .40657 m .68441 .38457 L .70705 .37949 L p F P
0 g
s
.649 .413 .548 r
.68441 .38457 m .6854 .40657 L .66102 .40937 L p F P
0 g
s
.758 .512 .561 r
.44817 .75185 m .42787 .7485 L .42831 .72925 L p F P
0 g
s
.77 .523 .56 r
.41634 .72682 m .42831 .72925 L .42787 .7485 L p F P
0 g
s
.845 .68 .678 r
.3245 .57481 m .34208 .58538 L .33217 .60696 L p F P
0 g
s
.838 .687 .695 r
.33381 .55728 m .3245 .57481 L .34208 .58538 L p F P
0 g
s
.706 .699 .841 r
.5178 .3886 m .49741 .39882 L .48619 .38239 L p F P
0 g
s
.723 .704 .832 r
.4658 .39412 m .48619 .38239 L .49741 .39882 L p F P
0 g
s
.797 .736 .795 r
.4026 .44125 m .38436 .45873 L .37252 .44379 L p F P
0 g
s
.797 .736 .795 r
.37252 .44379 m .38792 .42903 L .4026 .44125 L p F P
0 g
s
.79 .737 .803 r
.39305 .42439 m .38792 .42903 L .4026 .44125 L p F P
0 g
s
.79 .737 .803 r
.4026 .44125 m .40478 .43927 L .39305 .42439 L p F P
0 g
s
.778 .734 .812 r
.42513 .42243 m .40478 .43927 L .39305 .42439 L p F P
0 g
s
.808 .737 .786 r
.37474 .46876 m .38436 .45873 L .37252 .44379 L p F P
0 g
s
.536 .412 .658 r
.69762 .61322 m .71592 .60325 L p .71897 .62726 L F P
0 g
s
.536 .412 .658 r
.71897 .62726 m .69902 .62042 L .69762 .61322 L p F P
0 g
s
.547 .434 .677 r
.71046 .57906 m .71592 .60325 L .69762 .61322 L p F P
0 g
s
.673 .424 .535 r
.5324 .75687 m .54893 .75622 L .55319 .7744 L p F P
0 g
s
.673 .424 .535 r
.55319 .7744 m .53145 .77524 L .5324 .75687 L p F P
0 g
s
.691 .439 .537 r
.5324 .75687 m .53145 .77524 L .50487 .7752 L p F P
0 g
s
.691 .439 .537 r
.50487 .7752 m .50596 .75683 L .5324 .75687 L p F P
0 g
s
.707 .452 .537 r
.4991 .75656 m .50596 .75683 L .50487 .7752 L p F P
0 g
s
.683 .673 .834 r
.5178 .3886 m .53829 .37979 L .54927 .3977 L p F P
0 g
s
.802 .583 .605 r
.37939 .69673 m .37837 .68835 L .37675 .69591 L closepath p F P
0 g
s
.578 .542 .778 r
.67541 .46848 m .6666 .46893 L .67349 .46366 L closepath p F P
0 g
s
.579 .53 .765 r
.6666 .46893 m .67541 .46848 L p .68447 .49752 L F P
0 g
s
.765 .732 .822 r
.44241 .40946 m .42513 .42243 L .4135 .40745 L p F P
0 g
s
.778 .734 .812 r
.39305 .42439 m .4135 .40745 L .42513 .42243 L p F P
0 g
s
.707 .452 .537 r
.50487 .7752 m .50192 .77508 L .4991 .75656 L p F P
0 g
s
.716 .459 .535 r
.47796 .75521 m .4991 .75656 L .50192 .77508 L p F P
0 g
s
.816 .736 .776 r
.37474 .46876 m .36381 .48097 L .35186 .46594 L p F P
0 g
s
.816 .736 .776 r
.35186 .46594 m .36027 .45655 L .37474 .46876 L p F P
0 g
s
.808 .737 .786 r
.37252 .44379 m .36027 .45655 L .37474 .46876 L p F P
0 g
s
.571 .515 .754 r
.68624 .49751 m .68447 .49752 L .6859 .49654 L closepath p F P
0 g
s
.579 .53 .765 r
.67541 .46848 m .6859 .49654 L .68447 .49752 L p F P
0 g
s
.539 .473 .73 r
.69725 .53109 m .69571 .52608 L .71229 .51349 L p F P
0 g
s
.549 .491 .743 r
.70769 .49958 m .71229 .51349 L .69571 .52608 L p F P
0 g
s
.549 .491 .743 r
.69571 .52608 m .68624 .49751 L .70769 .49958 L p F P
0 g
s
.666 .419 .537 r
.54893 .75622 m .5577 .75573 L .55697 .77419 L p F P
0 g
s
.666 .419 .537 r
.55697 .77419 m .55319 .7744 L .54893 .75622 L p F P
0 g
s
.542 .465 .719 r
.70372 .55335 m .69725 .53109 L .71883 .53466 L p F P
0 g
s
.539 .473 .73 r
.71229 .51349 m .71883 .53466 L .69725 .53109 L p F P
0 g
s
.648 .404 .536 r
.55697 .77419 m .5577 .75573 L .58187 .75336 L p F P
0 g
s
.546 .501 .756 r
.70187 .48306 m .70769 .49958 L .68624 .49751 L p F P
0 g
s
.546 .501 .756 r
.68624 .49751 m .6859 .49654 L .70187 .48306 L p F P
0 g
s
.556 .517 .767 r
.69678 .4694 m .70187 .48306 L .6859 .49654 L p F P
0 g
s
.556 .517 .767 r
.6859 .49654 m .67541 .46848 L .69678 .4694 L p F P
0 g
s
.77 .523 .56 r
.42787 .7485 m .41583 .74609 L .41634 .72682 L p F P
0 g
s
.782 .532 .559 r
.39984 .72294 m .41634 .72682 L .41583 .74609 L p F P
0 g
s
.539 .408 .651 r
.70192 .63607 m .69902 .62042 L .71897 .62726 L closepath p F P
0 g
s
.825 .737 .766 r
.35288 .49418 m .36381 .48097 L .35186 .46594 L p F P
0 g
s
.592 .378 .559 r
.62778 .74573 m .62726 .72646 L .64894 .72116 L p F P
0 g
s
.615 .396 .56 r
.62726 .72646 m .62778 .74573 L .60522 .75003 L p F P
0 g
s
.716 .459 .535 r
.50192 .77508 m .47662 .77348 L .47796 .75521 L p F P
0 g
s
.731 .472 .536 r
.46053 .75346 m .47796 .75521 L .47662 .77348 L p F P
0 g
s
.765 .732 .822 r
.4135 .40745 m .42678 .39747 L .44241 .40946 L p F P
0 g
s
.76 .732 .827 r
.43393 .39233 m .42678 .39747 L .44241 .40946 L p F P
0 g
s
.76 .732 .827 r
.44241 .40946 m .44546 .40727 L .43393 .39233 L p F P
0 g
s
.531 .445 .704 r
.70372 .55335 m .72081 .54148 L p .7181 .57413 L F P
0 g
s
.531 .445 .704 r
.7181 .57413 m .70861 .57169 L .70372 .55335 L p F P
0 g
s
.542 .465 .719 r
.71883 .53466 m .72081 .54148 L .70372 .55335 L p F P
0 g
s
.745 .729 .837 r
.4658 .39412 m .44546 .40727 L .43393 .39233 L p F P
0 g
s
.795 .562 .585 r
.39984 .72294 m .38041 .71753 L .37939 .69673 L p F P
0 g
s
.804 .569 .582 r
.37675 .69591 m .37939 .69673 L .38041 .71753 L p F P
0 g
s
.845 .706 .709 r
.33381 .55728 m .33648 .55261 L .32638 .54559 L closepath p F P
0 g
s
.837 .711 .724 r
.32189 .53887 m .33516 .51822 L p .33648 .55261 L F P
0 g
s
.837 .711 .724 r
.33648 .55261 m .32638 .54559 L .32189 .53887 L p F P
0 g
s
.557 .343 .545 r
.70817 .40152 m .70705 .37949 L .72813 .37213 L p F P
0 g
s
.606 .381 .548 r
.70705 .37949 m .70817 .40152 L .6854 .40657 L p F P
0 g
s
.816 .597 .607 r
.35828 .66745 m .35385 .68761 L .37675 .69591 L p F P
0 g
s
.831 .613 .608 r
.33712 .65845 m .35828 .66745 L .35385 .68761 L p F P
0 g
s
.827 .625 .631 r
.35828 .66745 m .33712 .65845 L .34342 .63782 L p F P
0 g
s
.804 .569 .582 r
.38041 .71753 m .37423 .71562 L .37675 .69591 L p F P
0 g
s
.818 .583 .582 r
.35385 .68761 m .37675 .69591 L .37423 .71562 L p F P
0 g
s
.834 .735 .755 r
.35288 .49418 m .34304 .5071 L .33097 .49191 L p F P
0 g
s
.834 .735 .755 r
.33097 .49191 m .33854 .482 L .35288 .49418 L p F P
0 g
s
.825 .737 .766 r
.35186 .46594 m .33854 .482 L .35288 .49418 L p F P
0 g
s
.731 .472 .536 r
.47662 .77348 m .46278 .77211 L .46053 .75346 L p F P
0 g
s
.743 .48 .534 r
.44817 .75185 m .46053 .75346 L .46278 .77211 L p F P
0 g
s
.628 .387 .534 r
.58127 .77183 m .58187 .75336 L .60522 .75003 L p F P
0 g
s
.648 .404 .536 r
.58187 .75336 m .58127 .77183 L .55697 .77419 L p F P
0 g
s
.842 .643 .634 r
.324 .62809 m .34342 .63782 L .33712 .65845 L p F P
0 g
s
.836 .653 .655 r
.34342 .63782 m .324 .62809 L .33217 .60696 L p F P
0 g
s
.687 .692 .849 r
.53829 .37979 m .5178 .3886 L .50666 .37208 L p F P
0 g
s
.706 .699 .841 r
.48619 .38239 m .50666 .37208 L .5178 .3886 L p F P
0 g
s
.852 .706 .701 r
.3245 .57481 m .33381 .55728 L .32638 .54559 L p F P
0 g
s
.534 .44 .694 r
.71046 .57906 m .70861 .57169 L .7181 .57413 L closepath p F P
0 g
s
.541 .377 .608 r
.68845 .68738 m .68596 .66641 L .70531 .65794 L p F P
0 g
s
.566 .394 .608 r
.68596 .66641 m .68845 .68738 L .66832 .69474 L p F P
0 g
s
.552 .402 .63 r
.70192 .63607 m .70531 .65794 L .68596 .66641 L p F P
0 g
s
.554 .368 .583 r
.66989 .71486 m .66832 .69474 L .68845 .68738 L p F P
0 g
s
.579 .387 .585 r
.66832 .69474 m .66989 .71486 L .64894 .72116 L p F P
0 g
s
.523 .418 .677 r
.71592 .60325 m .71046 .57906 L .7181 .57413 L p F P
0 g
s
.743 .48 .534 r
.46278 .77211 m .44653 .77001 L .44817 .75185 L p F P
0 g
s
.756 .493 .534 r
.42787 .7485 m .44817 .75185 L .44653 .77001 L p F P
0 g
s
.796 .545 .558 r
.38041 .71753 m .39984 .72294 L .39925 .74222 L p F P
0 g
s
.782 .532 .559 r
.41583 .74609 m .39925 .74222 L .39984 .72294 L p F P
0 g
s
.729 .724 .846 r
.48619 .38239 m .4658 .39412 L .45436 .37908 L p F P
0 g
s
.745 .729 .837 r
.43393 .39233 m .45436 .37908 L .4658 .39412 L p F P
0 g
s
.527 .384 .63 r
.70531 .65794 m .70192 .63607 L .71897 .62726 L p F P
0 g
s
.842 .735 .745 r
.33516 .51822 m .34304 .5071 L .33097 .49191 L p F P
0 g
s
.851 .672 .659 r
.31448 .59646 m .33217 .60696 L .324 .62809 L p F P
0 g
s
.845 .68 .678 r
.33217 .60696 m .31448 .59646 L .3245 .57481 L p F P
0 g
s
.568 .359 .557 r
.64957 .74045 m .64894 .72116 L .66989 .71486 L p F P
0 g
s
.592 .378 .559 r
.64894 .72116 m .64957 .74045 L .62778 .74573 L p F P
0 g
s
.606 .369 .532 r
.60474 .76851 m .60522 .75003 L .62778 .74573 L p F P
0 g
s
.628 .387 .534 r
.60522 .75003 m .60474 .76851 L .58127 .77183 L p F P
0 g
s
.851 .732 .732 r
.33516 .51822 m .32189 .53887 L .30969 .52348 L p F P
0 g
s
.851 .732 .732 r
.30969 .52348 m .32092 .50607 L .33516 .51822 L p F P
0 g
s
.842 .735 .745 r
.33097 .49191 m .32092 .50607 L .33516 .51822 L p F P
0 g
s
.756 .493 .534 r
.44653 .77001 m .42967 .76726 L .42787 .7485 L p F P
0 g
s
.769 .502 .531 r
.41583 .74609 m .42787 .7485 L .42967 .76726 L p F P
0 g
s
.86 .7 .683 r
.30856 .56351 m .3245 .57481 L .31448 .59646 L p F P
0 g
s
.852 .706 .701 r
.32043 .54131 m .30856 .56351 L .3245 .57481 L p F P
0 g
s
.852 .706 .701 r
.32638 .54559 m .32043 .54131 L p .3245 .57481 L F P
0 g
s
.844 .711 .716 r
.32638 .54559 m .32189 .53887 L .32043 .54131 L closepath p F P
0 g
s
.711 .719 .856 r
.50666 .37208 m .48619 .38239 L .47484 .36726 L p F P
0 g
s
.729 .724 .846 r
.45436 .37908 m .47484 .36726 L .48619 .38239 L p F P
0 g
s
.557 .343 .545 r
.72813 .37213 m .72939 .39418 L .70817 .40152 L p F P
0 g
s
.51 .394 .657 r
.72051 .62644 m .71592 .60325 L .7335 .59206 L p F P
0 g
s
.523 .418 .677 r
.73046 .57868 m .7335 .59206 L .71592 .60325 L p F P
0 g
s
.523 .418 .677 r
.7181 .57413 m .73046 .57868 L p .71592 .60325 L F P
0 g
s
.536 .412 .658 r
.71592 .60325 m .72051 .62644 L .71897 .62726 L p F P
0 g
s
.519 .423 .686 r
.73046 .57868 m .7181 .57413 L .72777 .56751 L closepath p F P
0 g
s
.531 .445 .704 r
.72081 .54148 m .72777 .56751 L .7181 .57413 L p F P
0 g
s
.8 .757 .814 r
.38113 .41097 m .37597 .41563 L .38792 .42903 L p F P
0 g
s
.8 .757 .814 r
.38792 .42903 m .39305 .42439 L .38113 .41097 L p F P
0 g
s
.808 .758 .807 r
.38792 .42903 m .37252 .44379 L .36048 .43048 L p F P
0 g
s
.808 .758 .807 r
.36048 .43048 m .37597 .41563 L .38792 .42903 L p F P
0 g
s
.788 .756 .824 r
.4135 .40745 m .39305 .42439 L .38113 .41097 L p F P
0 g
s
.819 .758 .796 r
.36027 .45655 m .37252 .44379 L .36048 .43048 L p F P
0 g
s
.805 .553 .557 r
.37423 .71562 m .38041 .71753 L .37972 .73684 L p F P
0 g
s
.796 .545 .558 r
.39925 .74222 m .37972 .73684 L .38041 .71753 L p F P
0 g
s
.667 .398 .505 r
.52948 .79278 m .53145 .77524 L .55319 .7744 L p F P
0 g
s
.685 .415 .507 r
.50487 .7752 m .53145 .77524 L .52948 .79278 L p F P
0 g
s
.685 .415 .507 r
.50408 .78175 m .50487 .7752 L p .52948 .79278 L F P
0 g
s
.702 .43 .51 r
.50408 .78175 m .50192 .77508 L .50487 .7752 L closepath p F P
0 g
s
.735 .481 .545 r
.63505 .43143 m .61092 .42859 L .61037 .40631 L p F P
0 g
s
.761 .503 .542 r
.60473 .40521 m .61037 .40631 L .61092 .42859 L p F P
0 g
s
.712 .435 .505 r
.50192 .77508 m .50408 .78175 L p .47411 .79083 L F P
0 g
s
.712 .435 .505 r
.47411 .79083 m .47662 .77348 L .50192 .77508 L p F P
0 g
s
.769 .502 .531 r
.42967 .76726 m .41384 .76411 L .41583 .74609 L p F P
0 g
s
.781 .514 .532 r
.39925 .74222 m .41583 .74609 L .41384 .76411 L p F P
0 g
s
.774 .754 .835 r
.42678 .39747 m .4135 .40745 L .40169 .39392 L p F P
0 g
s
.788 .756 .824 r
.38113 .41097 m .40169 .39392 L .4135 .40745 L p F P
0 g
s
.828 .759 .787 r
.36027 .45655 m .35186 .46594 L .33968 .45274 L p F P
0 g
s
.828 .759 .787 r
.33968 .45274 m .34815 .44331 L .36027 .45655 L p F P
0 g
s
.819 .758 .796 r
.36048 .43048 m .34815 .44331 L .36027 .45655 L p F P
0 g
s
.581 .35 .529 r
.62742 .76423 m .62778 .74573 L .64957 .74045 L p F P
0 g
s
.606 .369 .532 r
.62778 .74573 m .62742 .76423 L .60474 .76851 L p F P
0 g
s
.818 .583 .582 r
.37423 .71562 m .35121 .70737 L .35385 .68761 L p F P
0 g
s
.834 .599 .582 r
.33578 .68001 m .35385 .68761 L .35121 .70737 L p F P
0 g
s
.831 .613 .608 r
.33429 .67106 m .33712 .65845 L p .35385 .68761 L F P
0 g
s
.831 .613 .608 r
.35385 .68761 m .33578 .68001 L .33429 .67106 L p F P
0 g
s
.66 .395 .509 r
.55635 .78081 m .55319 .7744 L .55697 .77419 L closepath p F P
0 g
s
.667 .398 .505 r
.55319 .7744 m .55635 .78081 L p .52948 .79278 L F P
0 g
s
.847 .631 .609 r
.33429 .67106 m .33712 .65845 L .33103 .65544 L closepath p F P
0 g
s
.842 .643 .634 r
.32347 .6298 m .324 .62809 L p .33712 .65845 L F P
0 g
s
.842 .643 .634 r
.33712 .65845 m .33103 .65544 L .32347 .6298 L p F P
0 g
s
.64 .378 .506 r
.55697 .77419 m .58127 .77183 L .57976 .78956 L p F P
0 g
s
.64 .378 .506 r
.55635 .78081 m .55697 .77419 L p .57976 .78956 L F P
0 g
s
.528 .348 .582 r
.69011 .70753 m .68845 .68738 L .70789 .67897 L p F P
0 g
s
.541 .377 .608 r
.70531 .65794 m .70789 .67897 L .68845 .68738 L p F P
0 g
s
.554 .368 .583 r
.68845 .68738 m .69011 .70753 L .66989 .71486 L p F P
0 g
s
.761 .503 .542 r
.61092 .42859 m .60524 .42748 L .60473 .40521 L p F P
0 g
s
.788 .525 .538 r
.58231 .39893 m .60473 .40521 L .60524 .42748 L p F P
0 g
s
.524 .476 .745 r
.71229 .51349 m .70769 .49958 L .72403 .50287 L closepath p F P
0 g
s
.512 .457 .731 r
.71229 .51349 m .72403 .50287 L p .72649 .53684 L F P
0 g
s
.512 .457 .731 r
.72649 .53684 m .71883 .53466 L .71229 .51349 L p F P
0 g
s
.837 .758 .776 r
.33854 .482 m .35186 .46594 L .33968 .45274 L p F P
0 g
s
.774 .754 .835 r
.40169 .39392 m .41504 .38388 L .42678 .39747 L p F P
0 g
s
.767 .753 .84 r
.42223 .3787 m .41504 .38388 L .42678 .39747 L p F P
0 g
s
.767 .753 .84 r
.42678 .39747 m .43393 .39233 L .42223 .3787 L p F P
0 g
s
.514 .358 .606 r
.70789 .67897 m .70531 .65794 L .724 .6484 L p F P
0 g
s
.527 .384 .63 r
.72081 .62828 m .724 .6484 L .70531 .65794 L p F P
0 g
s
.527 .384 .63 r
.71897 .62726 m .72081 .62828 L p .70531 .65794 L F P
0 g
s
.519 .485 .758 r
.72403 .50287 m .70769 .49958 L .70187 .48306 L p F P
0 g
s
.858 .732 .723 r
.32043 .54131 m .32189 .53887 L .30969 .52348 L p F P
0 g
s
.805 .553 .557 r
.37972 .73684 m .37351 .73494 L .37423 .71562 L p F P
0 g
s
.821 .567 .555 r
.35121 .70737 m .37423 .71562 L .37351 .73494 L p F P
0 g
s
.517 .45 .72 r
.72081 .54148 m .71883 .53466 L .72649 .53684 L closepath p F P
0 g
s
.728 .45 .507 r
.46278 .77211 m .47662 .77348 L .47411 .79083 L p F P
0 g
s
.504 .428 .704 r
.72777 .56751 m .72081 .54148 L .72649 .53684 L p F P
0 g
s
.752 .75 .85 r
.45436 .37908 m .43393 .39233 L .42223 .3787 L p F P
0 g
s
.866 .727 .707 r
.30625 .52919 m .32043 .54131 L .30856 .56351 L p F P
0 g
s
.858 .732 .723 r
.30969 .52348 m .30625 .52919 L .32043 .54131 L p F P
0 g
s
.591 .594 .823 r
.62219 .39973 m .64327 .39723 L .65397 .41882 L p F P
0 g
s
.59 .61 .84 r
.63255 .37711 m .64327 .39723 L .62219 .39973 L p F P
0 g
s
.59 .61 .84 r
.63079 .37733 m .63255 .37711 L p .62219 .39973 L F P
0 g
s
.59 .61 .84 r
.62219 .39973 m .61884 .39349 L .63079 .37733 L p F P
0 g
s
.858 .662 .636 r
.32347 .6298 m .324 .62809 L .32252 .62722 L closepath p F P
0 g
s
.851 .672 .659 r
.3119 .60307 m .31448 .59646 L p .324 .62809 L F P
0 g
s
.851 .672 .659 r
.324 .62809 m .32252 .62722 L .3119 .60307 L p F P
0 g
s
.541 .339 .555 r
.67061 .73418 m .66989 .71486 L .69011 .70753 L p F P
0 g
s
.568 .359 .557 r
.66989 .71486 m .67061 .73418 L .64957 .74045 L p F P
0 g
s
.519 .485 .758 r
.70187 .48306 m .71304 .4716 L p .72403 .50287 L F P
0 g
s
.531 .503 .77 r
.70187 .48306 m .69678 .4694 L .71304 .4716 L closepath p F P
0 g
s
.62 .646 .855 r
.61144 .38008 m .59054 .38452 L .57968 .36643 L p F P
0 g
s
.848 .646 .629 r
.33103 .65544 m .32347 .6298 L .318 .64864 L closepath p F P
0 g
s
.864 .664 .631 r
.318 .64864 m .32347 .6298 L .32252 .62722 L p F P
0 g
s
.711 .719 .856 r
.47484 .36726 m .49539 .35686 L .50666 .37208 L p F P
0 g
s
.728 .45 .507 r
.47411 .79083 m .46762 .79019 L .46278 .77211 L p F P
0 g
s
.739 .457 .502 r
.44653 .77001 m .46278 .77211 L .46762 .79019 L p F P
0 g
s
.524 .386 .636 r
.72081 .62828 m .71897 .62726 L .72051 .62644 L closepath p F P
0 g
s
.864 .664 .631 r
.32252 .62722 m .30662 .61752 L p .318 .64864 L F P
0 g
s
.858 .674 .652 r
.32252 .62722 m .3119 .60307 L .30662 .61752 L closepath p F P
0 g
s
.618 .36 .503 r
.57976 .78956 m .58127 .77183 L .60474 .76851 L p F P
0 g
s
.847 .758 .764 r
.33854 .482 m .33097 .49191 L .31865 .47885 L p F P
0 g
s
.847 .758 .764 r
.31865 .47885 m .32628 .46889 L .33854 .482 L p F P
0 g
s
.837 .758 .776 r
.33968 .45274 m .32628 .46889 L .33854 .482 L p F P
0 g
s
.854 .635 .605 r
.33103 .65544 m .318 .64864 L p .33269 .67863 L F P
0 g
s
.854 .635 .605 r
.33269 .67863 m .33429 .67106 L .33103 .65544 L p F P
0 g
s
.495 .366 .635 r
.72051 .62644 m .73816 .61533 L p .73637 .64109 L F P
0 g
s
.495 .366 .635 r
.73637 .64109 m .72081 .62828 L .72051 .62644 L p F P
0 g
s
.51 .394 .657 r
.7335 .59206 m .73816 .61533 L .72051 .62644 L p F P
0 g
s
.566 .581 .828 r
.66327 .41847 m .65397 .41882 L .64327 .39723 L p F P
0 g
s
.796 .525 .528 r
.37972 .73684 m .39925 .74222 L .40068 .76107 L p F P
0 g
s
.781 .514 .532 r
.41384 .76411 m .40068 .76107 L .39925 .74222 L p F P
0 g
s
.685 .415 .507 r
.52948 .79278 m .50831 .79275 L .50408 .78175 L p F P
0 g
s
.694 .419 .503 r
.50831 .79275 m .50262 .79261 L .50408 .78175 L closepath p F P
0 g
s
.712 .435 .505 r
.50408 .78175 m .50262 .79261 L .47411 .79083 L p F P
0 g
s
.501 .366 .629 r
.724 .6484 m .72081 .62828 L .73637 .64109 L closepath p F P
0 g
s
.49 .404 .686 r
.72777 .56751 m .74412 .55436 L p .74275 .58522 L F P
0 g
s
.49 .404 .686 r
.74275 .58522 m .73046 .57868 L .72777 .56751 L p F P
0 g
s
.504 .428 .704 r
.7409 .54235 m .74412 .55436 L .72777 .56751 L p F P
0 g
s
.504 .428 .704 r
.72649 .53684 m .7409 .54235 L p .72777 .56751 L F P
0 g
s
.868 .693 .663 r
.3119 .60307 m .31448 .59646 L .30447 .58946 L closepath p F P
0 g
s
.86 .7 .683 r
.29996 .58197 m .30856 .56351 L p .31448 .59646 L F P
0 g
s
.86 .7 .683 r
.31448 .59646 m .30447 .58946 L .29996 .58197 L p F P
0 g
s
.596 .618 .844 r
.61884 .39349 m .61144 .38008 L .63079 .37733 L closepath p F P
0 g
s
.855 .757 .753 r
.32092 .50607 m .33097 .49191 L .31865 .47885 L p F P
0 g
s
.739 .457 .502 r
.46762 .79019 m .44358 .78712 L .44653 .77001 L p F P
0 g
s
.753 .471 .504 r
.42967 .76726 m .44653 .77001 L .44358 .78712 L p F P
0 g
s
.735 .746 .861 r
.47484 .36726 m .45436 .37908 L .44277 .36535 L p F P
0 g
s
.752 .75 .85 r
.42223 .3787 m .44277 .36535 L .45436 .37908 L p F P
0 g
s
.64 .378 .506 r
.57976 .78956 m .56295 .79117 L .55635 .78081 L p F P
0 g
s
.646 .38 .502 r
.56295 .79117 m .55521 .7918 L .55635 .78081 L closepath p F P
0 g
s
.667 .398 .505 r
.55635 .78081 m .55521 .7918 L .52948 .79278 L p F P
0 g
s
.555 .328 .526 r
.64932 .75898 m .64957 .74045 L .67061 .73418 L p F P
0 g
s
.581 .35 .529 r
.64957 .74045 m .64932 .75898 L .62742 .76423 L p F P
0 g
s
.838 .618 .604 r
.33578 .68001 m .33429 .67106 L .33269 .67863 L closepath p F P
0 g
s
.498 .434 .715 r
.7409 .54235 m .72649 .53684 L .73674 .52772 L closepath p F P
0 g
s
.512 .457 .731 r
.72953 .50438 m .73674 .52772 L .72649 .53684 L p F P
0 g
s
.512 .457 .731 r
.72403 .50287 m .72953 .50438 L p .72649 .53684 L F P
0 g
s
.788 .525 .538 r
.60524 .42748 m .58268 .42123 L .58231 .39893 L p F P
0 g
s
.822 .553 .532 r
.56896 .39368 m .58231 .39893 L .58268 .42123 L p F P
0 g
s
.496 .401 .677 r
.7335 .59206 m .73046 .57868 L .74275 .58522 L closepath p F P
0 g
s
.595 .339 .5 r
.60337 .78625 m .60474 .76851 L .62742 .76423 L p F P
0 g
s
.618 .36 .503 r
.60474 .76851 m .60337 .78625 L .57976 .78956 L p F P
0 g
s
.873 .694 .656 r
.30662 .61752 m .3119 .60307 L .30447 .58946 L p F P
0 g
s
.865 .755 .739 r
.32092 .50607 m .30969 .52348 L .2972 .51055 L p F P
0 g
s
.865 .755 .739 r
.2972 .51055 m .30852 .49307 L .32092 .50607 L p F P
0 g
s
.855 .757 .753 r
.31865 .47885 m .30852 .49307 L .32092 .50607 L p F P
0 g
s
.753 .471 .504 r
.44358 .78712 m .43376 .78553 L .42967 .76726 L p F P
0 g
s
.767 .479 .499 r
.41384 .76411 m .42967 .76726 L .43376 .78553 L p F P
0 g
s
.834 .599 .582 r
.35121 .70737 m .33733 .70159 L .33578 .68001 L p F P
0 g
s
.842 .604 .58 r
.33269 .67863 m .33578 .68001 L .33733 .70159 L p F P
0 g
s
.557 .569 .821 r
.6753 .41839 m .66327 .41847 L .67049 .40828 L closepath p F P
0 g
s
.566 .581 .828 r
.66461 .39633 m .67049 .40828 L .66327 .41847 L p F P
0 g
s
.566 .581 .828 r
.64327 .39723 m .66461 .39633 L p .66327 .41847 L F P
0 g
s
.876 .722 .688 r
.30856 .56351 m .29996 .58197 L .28763 .56563 L p F P
0 g
s
.876 .722 .688 r
.28763 .56563 m .29427 .55147 L .30856 .56351 L p F P
0 g
s
.866 .727 .707 r
.30856 .56351 m .29427 .55147 L .30625 .52919 L p F P
0 g
s
.481 .375 .656 r
.73816 .61533 m .7335 .59206 L .74275 .58522 L p F P
0 g
s
.717 .741 .871 r
.49539 .35686 m .47484 .36726 L .46334 .35343 L p F P
0 g
s
.735 .746 .861 r
.44277 .36535 m .46334 .35343 L .47484 .36726 L p F P
0 g
s
.499 .327 .579 r
.70965 .69917 m .70789 .67897 L .72666 .66948 L p F P
0 g
s
.514 .358 .606 r
.724 .6484 m .72666 .66948 L .70789 .67897 L p F P
0 g
s
.528 .348 .582 r
.70789 .67897 m .70965 .69917 L .69011 .70753 L p F P
0 g
s
.684 .441 .548 r
.65067 .43187 m .66187 .43163 L .66273 .45417 L p F P
0 g
s
.684 .441 .548 r
.66273 .45417 m .65146 .45441 L .65067 .43187 L p F P
0 g
s
.703 .455 .547 r
.63505 .43143 m .65067 .43187 L .65146 .45441 L p F P
0 g
s
.796 .525 .528 r
.40068 .76107 m .37731 .75469 L .37972 .73684 L p F P
0 g
s
.806 .535 .528 r
.37351 .73494 m .37972 .73684 L .37731 .75469 L p F P
0 g
s
.842 .604 .58 r
.33733 .70159 m .3301 .69838 L .33269 .67863 L p F P
0 g
s
.858 .621 .578 r
.31366 .6688 m .33269 .67863 L .3301 .69838 L p F P
0 g
s
.854 .635 .605 r
.318 .64864 m .31366 .6688 L .33269 .67863 L p F P
0 g
s
.703 .455 .547 r
.65146 .45441 m .63574 .45396 L .63505 .43143 L p F P
0 g
s
.735 .481 .545 r
.61092 .42859 m .63505 .43143 L .63574 .45396 L p F P
0 g
s
.512 .317 .552 r
.69094 .72689 m .69011 .70753 L .70965 .69917 L p F P
0 g
s
.541 .339 .555 r
.69011 .70753 m .69094 .72689 L .67061 .73418 L p F P
0 g
s
.821 .567 .555 r
.37351 .73494 m .35038 .72673 L .35121 .70737 L p F P
0 g
s
.837 .582 .553 r
.33733 .70159 m .35121 .70737 L .35038 .72673 L p F P
0 g
s
.87 .653 .605 r
.30056 .63812 m .318 .64864 L .31366 .6688 L p F P
0 g
s
.864 .664 .631 r
.30662 .61752 m .30056 .63812 L .318 .64864 L p F P
0 g
s
.595 .635 .861 r
.63079 .37733 m .61144 .38008 L .60064 .36189 L p F P
0 g
s
.62 .646 .855 r
.57968 .36643 m .60064 .36189 L .61144 .38008 L p F P
0 g
s
.486 .337 .604 r
.72666 .66948 m .724 .6484 L .73637 .64109 L p F P
0 g
s
.81 .78 .825 r
.369 .39901 m .36678 .40102 L .37597 .41563 L p F P
0 g
s
.81 .78 .825 r
.37597 .41563 m .38113 .41097 L .369 .39901 L p F P
0 g
s
.819 .782 .818 r
.37597 .41563 m .36048 .43048 L .34821 .41881 L p F P
0 g
s
.819 .782 .818 r
.34821 .41881 m .36678 .40102 L .37597 .41563 L p F P
0 g
s
.506 .464 .744 r
.72953 .50438 m .72403 .50287 L .72779 .49908 L closepath p F P
0 g
s
.519 .485 .758 r
.71851 .47266 m .72779 .49908 L .72403 .50287 L p F P
0 g
s
.519 .485 .758 r
.71304 .4716 m .71851 .47266 L p .72403 .50287 L F P
0 g
s
.797 .779 .837 r
.40169 .39392 m .38113 .41097 L .369 .39901 L p F P
0 g
s
.822 .553 .532 r
.58268 .42123 m .56925 .416 L .56896 .39368 L p F P
0 g
s
.842 .569 .527 r
.55985 .38944 m .56896 .39368 L .56925 .416 L p F P
0 g
s
.83 .781 .806 r
.34815 .44331 m .36048 .43048 L .34821 .41881 L p F P
0 g
s
.569 .317 .496 r
.62617 .78199 m .62742 .76423 L .64932 .75898 L p F P
0 g
s
.595 .339 .5 r
.62742 .76423 m .62617 .78199 L .60337 .78625 L p F P
0 g
s
.563 .596 .844 r
.66461 .39633 m .64327 .39723 L .63255 .37711 L p F P
0 g
s
.767 .479 .499 r
.43376 .78553 m .41035 .78092 L .41384 .76411 L p F P
0 g
s
.779 .492 .501 r
.40068 .76107 m .41384 .76411 L .41035 .78092 L p F P
0 g
s
.806 .535 .528 r
.37731 .75469 m .37463 .75388 L .37351 .73494 L p F P
0 g
s
.822 .548 .524 r
.35038 .72673 m .37351 .73494 L .37463 .75388 L p F P
0 g
s
.873 .694 .656 r
.30447 .58946 m .29855 .5852 L p .30662 .61752 L F P
0 g
s
.866 .701 .676 r
.30447 .58946 m .29996 .58197 L .29855 .5852 L closepath p F P
0 g
s
.658 .369 .47 r
.52646 .80952 m .52948 .79278 L .55521 .7918 L p F P
0 g
s
.678 .388 .475 r
.50831 .79275 m .52948 .79278 L .52646 .80952 L p F P
0 g
s
.678 .388 .475 r
.52646 .80952 m .51862 .80951 L .50831 .79275 L p F P
0 g
s
.687 .39 .467 r
.50262 .79261 m .50831 .79275 L .51862 .80951 L p F P
0 g
s
.782 .778 .849 r
.41504 .38388 m .40169 .39392 L .38969 .38185 L p F P
0 g
s
.797 .779 .837 r
.369 .39901 m .38969 .38185 L .40169 .39392 L p F P
0 g
s
.872 .753 .729 r
.30625 .52919 m .30969 .52348 L .2972 .51055 L p F P
0 g
s
.687 .39 .467 r
.51862 .80951 m .49912 .80904 L .50262 .79261 L p F P
0 g
s
.706 .409 .471 r
.47411 .79083 m .50262 .79261 L .49912 .80904 L p F P
0 g
s
.62 .665 .872 r
.60064 .36189 m .57968 .36643 L .56875 .34964 L p F P
0 g
s
.644 .676 .865 r
.54791 .3557 m .56875 .34964 L .57968 .36643 L p F P
0 g
s
.84 .783 .797 r
.34815 .44331 m .33968 .45274 L .32726 .44141 L p F P
0 g
s
.84 .783 .797 r
.32726 .44141 m .33841 .429 L .34815 .44331 L p F P
0 g
s
.83 .781 .806 r
.34821 .41881 m .33841 .429 L .34815 .44331 L p F P
0 g
s
.526 .306 .522 r
.67048 .75273 m .67061 .73418 L .69094 .72689 L p F P
0 g
s
.555 .328 .526 r
.67061 .73418 m .67048 .75273 L .64932 .75898 L p F P
0 g
s
.735 .481 .545 r
.63574 .45396 m .61147 .45114 L .61092 .42859 L p F P
0 g
s
.761 .503 .542 r
.60524 .42748 m .61092 .42859 L .61147 .45114 L p F P
0 g
s
.881 .684 .632 r
.29078 .60626 m .30662 .61752 L .30056 .63812 L p F P
0 g
s
.873 .694 .656 r
.29855 .5852 m .29078 .60626 L .30662 .61752 L p F P
0 g
s
.636 .348 .466 r
.55236 .80854 m .55521 .7918 L .56295 .79117 L p F P
0 g
s
.658 .369 .47 r
.55521 .7918 m .55236 .80854 L .52646 .80952 L p F P
0 g
s
.849 .781 .785 r
.32628 .46889 m .33968 .45274 L .32726 .44141 L p F P
0 g
s
.782 .778 .849 r
.38969 .38185 m .40725 .36862 L .41504 .38388 L p F P
0 g
s
.775 .775 .853 r
.41035 .36639 m .40725 .36862 L .41504 .38388 L p F P
0 g
s
.775 .775 .853 r
.41504 .38388 m .42223 .3787 L .41035 .36639 L p F P
0 g
s
.761 .503 .542 r
.61147 .45114 m .60576 .45004 L .60524 .42748 L p F P
0 g
s
.788 .525 .538 r
.58268 .42123 m .60524 .42748 L .60576 .45004 L p F P
0 g
s
.882 .75 .712 r
.29373 .51629 m .30625 .52919 L .29427 .55147 L p F P
0 g
s
.872 .753 .729 r
.2972 .51055 m .29373 .51629 L .30625 .52919 L p F P
0 g
s
.63 .349 .474 r
.57752 .80513 m .56295 .79117 L .57976 .78956 L closepath p F P
0 g
s
.636 .348 .466 r
.56295 .79117 m .57752 .80513 L p .55236 .80854 L F P
0 g
s
.706 .409 .471 r
.47196 .80038 m .47411 .79083 L p .49912 .80904 L F P
0 g
s
.723 .425 .475 r
.47196 .80038 m .46762 .79019 L .47411 .79083 L closepath p F P
0 g
s
.717 .741 .871 r
.46334 .35343 m .48398 .34294 L .49539 .35686 L p F P
0 g
s
.759 .773 .864 r
.44277 .36535 m .42223 .3787 L .41035 .36639 L p F P
0 g
s
.528 .553 .825 r
.68626 .39742 m .69694 .42005 L .6753 .41839 L p F P
0 g
s
.528 .553 .825 r
.67648 .39673 m .68626 .39742 L p .6753 .41839 L F P
0 g
s
.528 .553 .825 r
.6753 .41839 m .67049 .40828 L .67648 .39673 L p F P
0 g
s
.484 .439 .732 r
.73674 .52772 m .72953 .50438 L .75095 .51275 L closepath p F P
0 g
s
.475 .445 .745 r
.75095 .51275 m .72953 .50438 L .72779 .49908 L p F P
0 g
s
.475 .445 .745 r
.72779 .49908 m .74173 .48216 L p .75095 .51275 L F P
0 g
s
.491 .468 .759 r
.74069 .4792 m .74173 .48216 L .72779 .49908 L p F P
0 g
s
.491 .468 .759 r
.72779 .49908 m .71851 .47266 L .74069 .4792 L p F P
0 g
s
.881 .722 .68 r
.29855 .5852 m .29996 .58197 L .28763 .56563 L p F P
0 g
s
.794 .502 .494 r
.37731 .75469 m .40068 .76107 L .40417 .7795 L p F P
0 g
s
.779 .492 .501 r
.41035 .78092 m .40417 .7795 L .40068 .76107 L p F P
0 g
s
.734 .431 .467 r
.46762 .79019 m .47196 .80038 L .47026 .8071 L p F P
0 g
s
.734 .431 .467 r
.44358 .78712 m .46762 .79019 L p .47026 .8071 L F P
0 g
s
.464 .345 .633 r
.74193 .63763 m .73816 .61533 L .7551 .60298 L p F P
0 g
s
.481 .375 .656 r
.75303 .59274 m .7551 .60298 L .73816 .61533 L p F P
0 g
s
.481 .375 .656 r
.74275 .58522 m .75303 .59274 L p .73816 .61533 L F P
0 g
s
.495 .366 .635 r
.73816 .61533 m .74193 .63763 L .73637 .64109 L p F P
0 g
s
.842 .569 .527 r
.56925 .416 m .56009 .41177 L .55985 .38944 L p F P
0 g
s
.88 .603 .514 r
.54187 .3782 m .55985 .38944 L .56009 .41177 L p F P
0 g
s
.467 .414 .715 r
.73674 .52772 m .75095 .51275 L p .75122 .54769 L F P
0 g
s
.467 .414 .715 r
.75122 .54769 m .7409 .54235 L .73674 .52772 L p F P
0 g
s
.646 .696 .882 r
.56875 .34964 m .54791 .3557 L .5368 .3403 L p F P
0 g
s
.607 .329 .469 r
.57976 .78956 m .60337 .78625 L .60107 .80326 L p F P
0 g
s
.607 .329 .469 r
.57752 .80513 m .57976 .78956 L p .60107 .80326 L F P
0 g
s
.86 .782 .773 r
.32628 .46889 m .31865 .47885 L .30605 .46791 L p F P
0 g
s
.86 .782 .773 r
.30605 .46791 m .31611 .45482 L .32628 .46889 L p F P
0 g
s
.849 .781 .785 r
.32726 .44141 m .31611 .45482 L .32628 .46889 L p F P
0 g
s
.473 .376 .664 r
.75303 .59274 m .74275 .58522 L .75017 .57934 L closepath p F P
0 g
s
.49 .404 .686 r
.74412 .55436 m .75017 .57934 L .74275 .58522 L p F P
0 g
s
.89 .715 .658 r
.2843 .57319 m .29855 .5852 L .29078 .60626 L p F P
0 g
s
.881 .722 .68 r
.28763 .56563 m .2843 .57319 L .29855 .5852 L p F P
0 g
s
.837 .582 .553 r
.35038 .72673 m .33643 .72097 L .33733 .70159 L p F P
0 g
s
.845 .588 .551 r
.3301 .69838 m .33733 .70159 L .33643 .72097 L p F P
0 g
s
.476 .41 .704 r
.74412 .55436 m .7409 .54235 L .75122 .54769 L closepath p F P
0 g
s
.54 .294 .491 r
.6482 .77675 m .64932 .75898 L .67048 .75273 L p F P
0 g
s
.569 .317 .496 r
.64932 .75898 m .6482 .77675 L .62617 .78199 L p F P
0 g
s
.868 .78 .761 r
.30852 .49307 m .31865 .47885 L .30605 .46791 L p F P
0 g
s
.459 .384 .685 r
.75017 .57934 m .74412 .55436 L .75122 .54769 L p F P
0 g
s
.742 .77 .876 r
.46334 .35343 m .44277 .36535 L .43099 .35294 L p F P
0 g
s
.759 .773 .864 r
.41035 .36639 m .43099 .35294 L .44277 .36535 L p F P
0 g
s
.539 .567 .831 r
.67049 .40828 m .66461 .39633 L .67648 .39673 L closepath p F P
0 g
s
.734 .431 .467 r
.43964 .80183 m .44358 .78712 L p .47026 .8071 L F P
0 g
s
.749 .446 .47 r
.43964 .80183 m .43376 .78553 L .44358 .78712 L closepath p F P
0 g
s
.486 .337 .604 r
.73637 .64109 m .74374 .65095 L p .72666 .66948 L F P
0 g
s
.478 .335 .608 r
.74374 .65095 m .73637 .64109 L .74193 .63763 L closepath p F P
0 g
s
.481 .293 .548 r
.71058 .71857 m .70965 .69917 L .72851 .68974 L p F P
0 g
s
.499 .327 .579 r
.72666 .66948 m .72851 .68974 L .70965 .69917 L p F P
0 g
s
.512 .317 .552 r
.70965 .69917 m .71058 .71857 L .69094 .72689 L p F P
0 g
s
.468 .305 .576 r
.72851 .68974 m .72666 .66948 L .74478 .6589 L p F P
0 g
s
.486 .337 .604 r
.74374 .65095 m .74478 .6589 L .72666 .66948 L p F P
0 g
s
.582 .306 .463 r
.60107 .80326 m .60337 .78625 L .62617 .78199 L p F P
0 g
s
.788 .525 .538 r
.60576 .45004 m .58306 .4438 L .58268 .42123 L p F P
0 g
s
.822 .553 .532 r
.56925 .416 m .58268 .42123 L .58306 .4438 L p F P
0 g
s
.589 .627 .858 r
.63255 .37711 m .63079 .37733 L .63166 .37556 L closepath p F P
0 g
s
.595 .635 .861 r
.6218 .3588 m .63166 .37556 L .63079 .37733 L p F P
0 g
s
.595 .635 .861 r
.60064 .36189 m .6218 .3588 L p .63079 .37733 L F P
0 g
s
.845 .588 .551 r
.33643 .72097 m .32916 .71778 L .3301 .69838 L p F P
0 g
s
.862 .605 .548 r
.31097 .68861 m .3301 .69838 L .32916 .71778 L p F P
0 g
s
.858 .621 .578 r
.3301 .69838 m .31097 .68861 L .31366 .6688 L p F P
0 g
s
.876 .639 .576 r
.29613 .65834 m .31366 .6688 L .31097 .68861 L p F P
0 g
s
.87 .653 .605 r
.31366 .6688 m .29613 .65834 L .30056 .63812 L p F P
0 g
s
.763 .453 .461 r
.43376 .78553 m .43964 .80183 L .43924 .80314 L p F P
0 g
s
.763 .453 .461 r
.41035 .78092 m .43376 .78553 L p .43924 .80314 L F P
0 g
s
.563 .596 .844 r
.63255 .37711 m .65393 .3761 L .66461 .39633 L p F P
0 g
s
.559 .613 .863 r
.64321 .35732 m .65393 .3761 L .63255 .37711 L p F P
0 g
s
.559 .613 .863 r
.63649 .35767 m .64321 .35732 L p .63255 .37711 L F P
0 g
s
.559 .613 .863 r
.63255 .37711 m .63166 .37556 L .63649 .35767 L p F P
0 g
s
.495 .281 .518 r
.69092 .74547 m .69094 .72689 L .71058 .71857 L p F P
0 g
s
.526 .306 .522 r
.69094 .72689 m .69092 .74547 L .67048 .75273 L p F P
0 g
s
.88 .78 .747 r
.30852 .49307 m .2972 .51055 L .2844 .50012 L p F P
0 g
s
.88 .78 .747 r
.2844 .50012 m .29799 .47919 L .30852 .49307 L p F P
0 g
s
.868 .78 .761 r
.30605 .46791 m .29799 .47919 L .30852 .49307 L p F P
0 g
s
.892 .746 .693 r
.29427 .55147 m .28763 .56563 L .27493 .55288 L p F P
0 g
s
.892 .746 .693 r
.27493 .55288 m .28164 .53866 L .29427 .55147 L p F P
0 g
s
.882 .75 .712 r
.29427 .55147 m .28164 .53866 L .29373 .51629 L p F P
0 g
s
.822 .548 .524 r
.37463 .75388 m .35138 .7457 L .35038 .72673 L p F P
0 g
s
.839 .562 .519 r
.33643 .72097 m .35038 .72673 L .35138 .7457 L p F P
0 g
s
.593 .653 .878 r
.6218 .3588 m .60064 .36189 L .58976 .34501 L p F P
0 g
s
.62 .665 .872 r
.56875 .34964 m .58976 .34501 L .60064 .36189 L p F P
0 g
s
.569 .622 .866 r
.63166 .37556 m .6218 .3588 L .63649 .35767 L closepath p F P
0 g
s
.889 .673 .605 r
.28462 .62693 m .30056 .63812 L .29613 .65834 L p F P
0 g
s
.881 .684 .632 r
.30056 .63812 m .28462 .62693 L .29078 .60626 L p F P
0 g
s
.439 .354 .662 r
.75017 .57934 m .7658 .56489 L p .75981 .59902 L F P
0 g
s
.439 .354 .662 r
.75981 .59902 m .75303 .59274 L .75017 .57934 L p F P
0 g
s
.459 .384 .685 r
.76366 .55608 m .7658 .56489 L .75017 .57934 L p F P
0 g
s
.459 .384 .685 r
.75122 .54769 m .76366 .55608 L p .75017 .57934 L F P
0 g
s
.722 .765 .887 r
.48398 .34294 m .46334 .35343 L .45168 .34092 L p F P
0 g
s
.742 .77 .876 r
.43099 .35294 m .45168 .34092 L .46334 .35343 L p F P
0 g
s
.805 .514 .496 r
.37575 .76082 m .37463 .75388 L .37731 .75469 L closepath p F P
0 g
s
.794 .502 .494 r
.37575 .76082 m .37731 .75469 L p .40417 .7795 L F P
0 g
s
.444 .311 .605 r
.74193 .63763 m .75895 .62537 L p .74739 .65715 L F P
0 g
s
.444 .311 .605 r
.74739 .65715 m .74374 .65095 L .74193 .63763 L p F P
0 g
s
.464 .345 .633 r
.7551 .60298 m .75895 .62537 L .74193 .63763 L p F P
0 g
s
.534 .581 .848 r
.67648 .39673 m .66461 .39633 L .65393 .3761 L p F P
0 g
s
.706 .409 .471 r
.49912 .80904 m .47555 .80758 L .47196 .80038 L p F P
0 g
s
.717 .413 .462 r
.47555 .80758 m .47026 .8071 L .47196 .80038 L closepath p F P
0 g
s
.684 .441 .548 r
.65146 .45441 m .66273 .45417 L .6636 .47699 L p F P
0 g
s
.684 .441 .548 r
.6636 .47699 m .65227 .47722 L .65146 .45441 L p F P
0 g
s
.703 .455 .547 r
.63574 .45396 m .65146 .45441 L .65227 .47722 L p F P
0 g
s
.821 .525 .489 r
.37463 .75388 m .37575 .76082 L .37276 .77076 L p F P
0 g
s
.821 .525 .489 r
.35138 .7457 m .37463 .75388 L p .37276 .77076 L F P
0 g
s
.649 .413 .548 r
.6636 .47699 m .66273 .45417 L .68742 .45139 L p F P
0 g
s
.703 .455 .547 r
.65227 .47722 m .63645 .47678 L .63574 .45396 L p F P
0 g
s
.735 .481 .545 r
.61147 .45114 m .63574 .45396 L .63645 .47678 L p F P
0 g
s
.619 .686 .89 r
.58976 .34501 m .56875 .34964 L .55771 .33415 L p F P
0 g
s
.646 .696 .882 r
.5368 .3403 m .55771 .33415 L .56875 .34964 L p F P
0 g
s
.302 .156 .51 r
.78195 .33496 m .77292 .34413 L .77448 .36627 L p F P
0 g
s
.505 .524 .81 r
.70186 .43119 m .69694 .42005 L .70699 .42164 L closepath p F P
0 g
s
.508 .268 .485 r
.66948 .77052 m .67048 .75273 L .69092 .74547 L p F P
0 g
s
.54 .294 .491 r
.67048 .75273 m .66948 .77052 L .6482 .77675 L p F P
0 g
s
.553 .281 .457 r
.62402 .799 m .62617 .78199 L .6482 .77675 L p F P
0 g
s
.582 .306 .463 r
.62617 .78199 m .62402 .799 L .60107 .80326 L p F P
0 g
s
.899 .706 .633 r
.27643 .59432 m .29078 .60626 L .28462 .62693 L p F P
0 g
s
.89 .715 .658 r
.29078 .60626 m .27643 .59432 L .2843 .57319 L p F P
0 g
s
.448 .386 .695 r
.76366 .55608 m .75122 .54769 L .75932 .5393 L closepath p F P
0 g
s
.467 .414 .715 r
.75189 .51323 m .75932 .5393 L .75122 .54769 L p F P
0 g
s
.467 .414 .715 r
.75095 .51275 m .75189 .51323 L p .75122 .54769 L F P
0 g
s
.822 .553 .532 r
.58306 .4438 m .56955 .43859 L .56925 .416 L p F P
0 g
s
.842 .569 .527 r
.56009 .41177 m .56925 .416 L .56955 .43859 L p F P
0 g
s
.819 .803 .836 r
.36678 .40102 m .36439 .3951 L .369 .39901 L closepath p F P
0 g
s
.829 .807 .83 r
.36678 .40102 m .34821 .41881 L .33569 .4088 L p F P
0 g
s
.829 .807 .83 r
.36439 .3951 m .36678 .40102 L p .33569 .4088 L F P
0 g
s
.806 .804 .849 r
.36439 .3951 m .369 .39901 L .38969 .38185 L p F P
0 g
s
.886 .777 .735 r
.29373 .51629 m .2972 .51055 L .2844 .50012 L p F P
0 g
s
.451 .354 .655 r
.7551 .60298 m .75303 .59274 L .75981 .59902 L closepath p F P
0 g
s
.841 .806 .817 r
.33841 .429 m .34821 .41881 L .33569 .4088 L p F P
0 g
s
.763 .453 .461 r
.40742 .78999 m .41035 .78092 L p .43924 .80314 L F P
0 g
s
.776 .468 .466 r
.40742 .78999 m .40417 .7795 L .41035 .78092 L closepath p F P
0 g
s
.897 .744 .683 r
.2843 .57319 m .28763 .56563 L .27493 .55288 L p F P
0 g
s
.606 .381 .548 r
.68844 .47422 m .68742 .45139 L .71047 .44637 L p F P
0 g
s
.649 .413 .548 r
.68742 .45139 m .68844 .47422 L .6636 .47699 L p F P
0 g
s
.88 .603 .514 r
.56009 .41177 m .542 .40057 L .54187 .3782 L p F P
0 g
s
.923 .643 .492 r
.52719 .36559 m .54187 .3782 L .542 .40057 L p F P
0 g
s
.735 .481 .545 r
.63645 .47678 m .61203 .47396 L .61147 .45114 L p F P
0 g
s
.761 .503 .542 r
.60576 .45004 m .61147 .45114 L .61203 .47396 L p F P
0 g
s
.791 .804 .863 r
.40725 .36862 m .38969 .38185 L .37747 .37125 L p F P
0 g
s
.806 .804 .849 r
.38969 .38185 m .37747 .37125 L p .36439 .3951 L F P
0 g
s
.852 .809 .808 r
.33841 .429 m .32726 .44141 L .31456 .43194 L p F P
0 g
s
.852 .809 .808 r
.31456 .43194 m .33109 .41358 L .33841 .429 L p F P
0 g
s
.841 .806 .817 r
.33569 .4088 m .33109 .41358 L .33841 .429 L p F P
0 g
s
.647 .337 .432 r
.52646 .80952 m .55236 .80854 L .54846 .82447 L p F P
0 g
s
.647 .337 .432 r
.52469 .81646 m .52646 .80952 L p .54846 .82447 L F P
0 g
s
.669 .358 .438 r
.52469 .81646 m .51862 .80951 L .52646 .80952 L closepath p F P
0 g
s
.677 .358 .426 r
.51862 .80951 m .52469 .81646 L p .49442 .82456 L F P
0 g
s
.677 .358 .426 r
.49442 .82456 m .49912 .80904 L .51862 .80951 L p F P
0 g
s
.897 .775 .718 r
.2829 .50259 m .29373 .51629 L .28164 .53866 L p F P
0 g
s
.886 .777 .735 r
.2844 .50012 m .2829 .50259 L .29373 .51629 L p F P
0 g
s
.698 .379 .433 r
.47555 .80758 m .49912 .80904 L .49442 .82456 L p F P
0 g
s
.497 .536 .827 r
.70699 .42164 m .69694 .42005 L .68626 .39742 L p F P
0 g
s
.761 .503 .542 r
.61203 .47396 m .60628 .47287 L .60576 .45004 L p F P
0 g
s
.788 .525 .538 r
.58306 .4438 m .60576 .45004 L .60628 .47287 L p F P
0 g
s
.839 .562 .519 r
.35138 .7457 m .33304 .73821 L .33643 .72097 L p F P
0 g
s
.847 .57 .519 r
.32916 .71778 m .33643 .72097 L .33304 .73821 L p F P
0 g
s
.792 .476 .455 r
.40417 .7795 m .40742 .78999 L .40504 .79626 L p F P
0 g
s
.792 .476 .455 r
.37785 .77238 m .40417 .7795 L p .40504 .79626 L F P
0 g
s
.794 .502 .494 r
.40417 .7795 m .37785 .77238 L .37575 .76082 L p F P
0 g
s
.699 .76 .899 r
.50472 .33386 m .48398 .34294 L .47242 .33033 L p F P
0 g
s
.722 .765 .887 r
.45168 .34092 m .47242 .33033 L .48398 .34294 L p F P
0 g
s
.623 .313 .425 r
.54846 .82447 m .55236 .80854 L .5773 .80653 L p F P
0 g
s
.636 .348 .466 r
.57752 .80513 m .5773 .80653 L .55236 .80854 L p F P
0 g
s
.646 .719 .901 r
.55771 .33415 m .5368 .3403 L .52557 .3262 L p F P
0 g
s
.862 .806 .794 r
.31611 .45482 m .32726 .44141 L .31456 .43194 L p F P
0 g
s
.811 .514 .486 r
.37785 .77238 m .37276 .77076 L .37575 .76082 L closepath p F P
0 g
s
.455 .316 .602 r
.74478 .6589 m .74374 .65095 L .74739 .65715 L closepath p F P
0 g
s
.791 .804 .863 r
.40584 .36229 m .40725 .36862 L p .37747 .37125 L F P
0 g
s
.783 .799 .866 r
.40725 .36862 m .40584 .36229 L .41035 .36639 L closepath p F P
0 g
s
.431 .322 .63 r
.75981 .59902 m .7551 .60298 L .75895 .62537 L p F P
0 g
s
.766 .797 .878 r
.40584 .36229 m .41035 .36639 L .43099 .35294 L p F P
0 g
s
.907 .738 .66 r
.27157 .56046 m .2843 .57319 L .27643 .59432 L p F P
0 g
s
.897 .744 .683 r
.27493 .55288 m .27157 .56046 L .2843 .57319 L p F P
0 g
s
.698 .379 .433 r
.49442 .82456 m .4872 .82412 L .47555 .80758 L p F P
0 g
s
.708 .38 .419 r
.47026 .8071 m .47555 .80758 L .4872 .82412 L p F P
0 g
s
.607 .329 .469 r
.60107 .80326 m .57929 .80628 L .57752 .80513 L p F P
0 g
s
.611 .326 .46 r
.57929 .80628 m .5773 .80653 L .57752 .80513 L closepath p F P
0 g
s
.842 .569 .527 r
.56955 .43859 m .56033 .43438 L .56009 .41177 L p F P
0 g
s
.88 .603 .514 r
.542 .40057 m .56009 .41177 L .56033 .43438 L p F P
0 g
s
.522 .568 .843 r
.68626 .39742 m .67648 .39673 L .68026 .38563 L closepath p F P
0 g
s
.534 .581 .848 r
.67559 .37672 m .68026 .38563 L .67648 .39673 L p F P
0 g
s
.534 .581 .848 r
.65393 .3761 m .67559 .37672 L p .67648 .39673 L F P
0 g
s
.708 .38 .419 r
.4872 .82412 m .46483 .82212 L .47026 .8071 L p F P
0 g
s
.727 .4 .426 r
.44025 .8033 m .47026 .8071 L .46483 .82212 L p F P
0 g
s
.734 .431 .467 r
.47026 .8071 m .44025 .8033 L .43964 .80183 L p F P
0 g
s
.447 .268 .544 r
.72953 .70918 m .72851 .68974 L .74671 .67921 L p F P
0 g
s
.468 .305 .576 r
.74478 .6589 m .74671 .67921 L .72851 .68974 L p F P
0 g
s
.481 .293 .548 r
.72851 .68974 m .72953 .70918 L .71058 .71857 L p F P
0 g
s
.874 .809 .782 r
.31611 .45482 m .30605 .46791 L .29314 .45913 L p F P
0 g
s
.874 .809 .782 r
.29314 .45913 m .30806 .43975 L .31611 .45482 L p F P
0 g
s
.862 .806 .794 r
.31456 .43194 m .30806 .43975 L .31611 .45482 L p F P
0 g
s
.461 .254 .512 r
.71066 .73718 m .71058 .71857 L .72953 .70918 L p F P
0 g
s
.495 .281 .518 r
.71058 .71857 m .71066 .73718 L .69092 .74547 L p F P
0 g
s
.596 .287 .417 r
.57357 .82247 m .5773 .80653 L .57929 .80628 L p F P
0 g
s
.623 .313 .425 r
.5773 .80653 m .57357 .82247 L .54846 .82447 L p F P
0 g
s
.594 .294 .43 r
.59885 .81443 m .57929 .80628 L .60107 .80326 L closepath p F P
0 g
s
.596 .287 .417 r
.57929 .80628 m .59885 .81443 L p .57357 .82247 L F P
0 g
s
.457 .419 .727 r
.75189 .51323 m .75095 .51275 L .75154 .51205 L closepath p F P
0 g
s
.475 .445 .745 r
.74173 .48216 m .75154 .51205 L .75095 .51275 L p F P
0 g
s
.522 .255 .451 r
.64618 .79377 m .6482 .77675 L .66948 .77052 L p F P
0 g
s
.553 .281 .457 r
.6482 .77675 m .64618 .79377 L .62402 .799 L p F P
0 g
s
.862 .605 .548 r
.32916 .71778 m .30993 .70805 L .31097 .68861 L p F P
0 g
s
.881 .622 .543 r
.29333 .67819 m .31097 .68861 L .30993 .70805 L p F P
0 g
s
.876 .639 .576 r
.31097 .68861 m .29333 .67819 L .29613 .65834 L p F P
0 g
s
.816 .809 .844 r
.35664 .38874 m .36098 .38494 L .36439 .3951 L closepath p F P
0 g
s
.829 .807 .83 r
.33569 .4088 m .35664 .38874 L .36439 .3951 L p F P
0 g
s
.806 .804 .849 r
.37747 .37125 m .36098 .38494 L .36439 .3951 L p F P
0 g
s
.847 .57 .519 r
.33304 .73821 m .3299 .73684 L .32916 .71778 L p F P
0 g
s
.865 .585 .512 r
.30993 .70805 m .32916 .71778 L .3299 .73684 L p F P
0 g
s
.606 .381 .548 r
.71047 .44637 m .71165 .46922 L .68844 .47422 L p F P
0 g
s
.564 .64 .884 r
.63649 .35767 m .6218 .3588 L .61099 .34183 L p F P
0 g
s
.593 .653 .878 r
.58976 .34501 m .61099 .34183 L .6218 .3588 L p F P
0 g
s
.435 .281 .572 r
.74739 .65715 m .74478 .6589 L .74671 .67921 L p F P
0 g
s
.42 .395 .726 r
.75154 .51205 m .76452 .49344 L p .77082 .52525 L F P
0 g
s
.42 .395 .726 r
.77082 .52525 m .75189 .51323 L .75154 .51205 L p F P
0 g
s
.442 .424 .744 r
.76346 .49021 m .76452 .49344 L .75154 .51205 L p F P
0 g
s
.442 .424 .744 r
.7431 .48015 m .76346 .49021 L p .75154 .51205 L F P
0 g
s
.442 .424 .744 r
.75154 .51205 m .74173 .48216 L .7431 .48015 L p F P
0 g
s
.434 .393 .714 r
.75932 .5393 m .75189 .51323 L .77082 .52525 L closepath p F P
0 g
s
.895 .659 .573 r
.28009 .64721 m .29613 .65834 L .29333 .67819 L p F P
0 g
s
.889 .673 .605 r
.29613 .65834 m .28009 .64721 L .28462 .62693 L p F P
0 g
s
.528 .597 .867 r
.67559 .37672 m .65393 .3761 L .64321 .35732 L p F P
0 g
s
.461 .449 .759 r
.74173 .48216 m .74069 .4792 L .7431 .48015 L closepath p F P
0 g
s
.747 .795 .891 r
.45168 .34092 m .43099 .35294 L .41903 .34185 L p F P
0 g
s
.766 .797 .878 r
.43099 .35294 m .41903 .34185 L p .40584 .36229 L F P
0 g
s
.19 .076 .484 r
.7934 .31936 m .78195 .33496 L .78356 .35713 L p F P
0 g
s
.302 .156 .51 r
.77448 .36627 m .78356 .35713 L .78195 .33496 L p F P
0 g
s
.882 .805 .769 r
.29799 .47919 m .30605 .46791 L .29314 .45913 L p F P
0 g
s
.431 .322 .63 r
.75895 .62537 m .77186 .61466 L .75981 .59902 L p F P
0 g
s
.417 .319 .636 r
.77096 .58885 m .75981 .59902 L .77186 .61466 L p F P
0 g
s
.439 .354 .662 r
.7658 .56489 m .77096 .58885 L .75981 .59902 L p F P
0 g
s
.821 .525 .489 r
.37276 .77076 m .35425 .76431 L .35138 .7457 L p F P
0 g
s
.839 .538 .48 r
.33304 .73821 m .35138 .7457 L .35425 .76431 L p F P
0 g
s
.59 .673 .897 r
.61099 .34183 m .58976 .34501 L .5788 .32944 L p F P
0 g
s
.619 .686 .89 r
.55771 .33415 m .5788 .32944 L .58976 .34501 L p F P
0 g
s
.748 .437 .457 r
.44025 .8033 m .43924 .80314 L .43964 .80183 L closepath p F P
0 g
s
.474 .24 .479 r
.69004 .76328 m .69092 .74547 L .71066 .73718 L p F P
0 g
s
.508 .268 .485 r
.69092 .74547 m .69004 .76328 L .66948 .77052 L p F P
0 g
s
.435 .281 .572 r
.74671 .67921 m .75284 .67515 L .74739 .65715 L p F P
0 g
s
.421 .273 .573 r
.76194 .64678 m .74739 .65715 L .75284 .67515 L p F P
0 g
s
.444 .311 .605 r
.75895 .62537 m .76194 .64678 L .74739 .65715 L p F P
0 g
s
.412 .362 .693 r
.75932 .5393 m .77082 .52525 L p .7695 .56092 L F P
0 g
s
.412 .362 .693 r
.7695 .56092 m .76366 .55608 L .75932 .5393 L p F P
0 g
s
.788 .525 .538 r
.60628 .47287 m .58345 .46666 L .58306 .4438 L p F P
0 g
s
.822 .553 .532 r
.56955 .43859 m .58306 .4438 L .58345 .46666 L p F P
0 g
s
.647 .337 .432 r
.54846 .82447 m .53412 .82501 L .52469 .81646 L p F P
0 g
s
.654 .334 .419 r
.53412 .82501 m .52215 .82522 L .52469 .81646 L closepath p F P
0 g
s
.677 .358 .426 r
.52469 .81646 m .52215 .82522 L .49442 .82456 L p F P
0 g
s
.481 .517 .818 r
.71897 .42419 m .70699 .42164 L .712 .40876 L closepath p F P
0 g
s
.497 .536 .827 r
.70826 .40078 m .712 .40876 L .70699 .42164 L p F P
0 g
s
.497 .536 .827 r
.68626 .39742 m .70826 .40078 L p .70699 .42164 L F P
0 g
s
.449 .456 .773 r
.75234 .45862 m .75352 .46179 L .7431 .48015 L p F P
0 g
s
.727 .4 .426 r
.46483 .82212 m .45021 .82029 L .44025 .8033 L p F P
0 g
s
.74 .404 .412 r
.43924 .80314 m .44025 .8033 L .45021 .82029 L p F P
0 g
s
.699 .76 .899 r
.47242 .33033 m .49326 .32115 L .50472 .33386 L p F P
0 g
s
.566 .269 .422 r
.60107 .80326 m .62402 .799 L .62094 .81529 L p F P
0 g
s
.566 .269 .422 r
.59885 .81443 m .60107 .80326 L p .62094 .81529 L F P
0 g
s
.908 .695 .604 r
.27018 .61506 m .28462 .62693 L .28009 .64721 L p F P
0 g
s
.899 .706 .633 r
.28462 .62693 m .27018 .61506 L .27643 .59432 L p F P
0 g
s
.74 .404 .412 r
.45021 .82029 m .43291 .81753 L .43924 .80314 L p F P
0 g
s
.757 .423 .419 r
.41004 .79743 m .43924 .80314 L .43291 .81753 L p F P
0 g
s
.763 .453 .461 r
.43924 .80314 m .41004 .79743 L .40742 .78999 L p F P
0 g
s
.91 .772 .697 r
.28164 .53866 m .27493 .55288 L .26183 .54373 L p F P
0 g
s
.91 .772 .697 r
.26183 .54373 m .2707 .52506 L .28164 .53866 L p F P
0 g
s
.897 .775 .718 r
.28164 .53866 m .2707 .52506 L .2829 .50259 L p F P
0 g
s
.773 .803 .876 r
.39826 .35557 m .40475 .35117 L .40584 .36229 L closepath p F P
0 g
s
.766 .797 .878 r
.41903 .34185 m .40475 .35117 L .40584 .36229 L p F P
0 g
s
.791 .804 .863 r
.37747 .37125 m .39826 .35557 L .40584 .36229 L p F P
0 g
s
.895 .806 .754 r
.29799 .47919 m .28935 .46442 L p .27949 .49716 L F P
0 g
s
.895 .806 .754 r
.27949 .49716 m .2844 .50012 L .29799 .47919 L p F P
0 g
s
.882 .805 .769 r
.29314 .45913 m .28935 .46442 L .29799 .47919 L p F P
0 g
s
.487 .549 .845 r
.69759 .37967 m .70826 .40078 L .68626 .39742 L p F P
0 g
s
.487 .549 .845 r
.68197 .37737 m .69759 .37967 L p .68626 .39742 L F P
0 g
s
.487 .549 .845 r
.68626 .39742 m .68026 .38563 L .68197 .37737 L p F P
0 g
s
.778 .461 .451 r
.41004 .79743 m .40504 .79626 L .40742 .78999 L closepath p F P
0 g
s
.792 .476 .455 r
.40504 .79626 m .38329 .79042 L .37785 .77238 L p F P
0 g
s
.809 .486 .443 r
.37276 .77076 m .37785 .77238 L .38329 .79042 L p F P
0 g
s
.408 .286 .601 r
.76194 .64678 m .75895 .62537 L .77186 .61466 L p F P
0 g
s
.426 .362 .683 r
.7658 .56489 m .76366 .55608 L .7695 .56092 L closepath p F P
0 g
s
.618 .708 .909 r
.5788 .32944 m .55771 .33415 L .54657 .31997 L p F P
0 g
s
.646 .719 .901 r
.52557 .3262 m .54657 .31997 L .55771 .33415 L p F P
0 g
s
.726 .791 .904 r
.47242 .33033 m .45168 .34092 L .43983 .32972 L p F P
0 g
s
.747 .795 .891 r
.41903 .34185 m .43983 .32972 L .45168 .34092 L p F P
0 g
s
.684 .441 .548 r
.65227 .47722 m .6636 .47699 L .66449 .50008 L p F P
0 g
s
.684 .441 .548 r
.66449 .50008 m .65308 .50032 L .65227 .47722 L p F P
0 g
s
.703 .455 .547 r
.63645 .47678 m .65227 .47722 L .65308 .50032 L p F P
0 g
s
.649 .413 .548 r
.66449 .50008 m .6636 .47699 L .68844 .47422 L p F P
0 g
s
.703 .455 .547 r
.65308 .50032 m .63717 .49988 L .63645 .47678 L p F P
0 g
s
.735 .481 .545 r
.61203 .47396 m .63645 .47678 L .63717 .49988 L p F P
0 g
s
.918 .73 .633 r
.26361 .58167 m .27643 .59432 L .27018 .61506 L p F P
0 g
s
.907 .738 .66 r
.27643 .59432 m .26361 .58167 L .27157 .56046 L p F P
0 g
s
.404 .33 .659 r
.7695 .56092 m .7658 .56489 L .77096 .58885 L p F P
0 g
s
.82 .5 .449 r
.35425 .76431 m .37276 .77076 L .36589 .78492 L p F P
0 g
s
.809 .486 .443 r
.38329 .79042 m .36589 .78492 L .37276 .77076 L p F P
0 g
s
.488 .226 .443 r
.6676 .78756 m .66948 .77052 L .69004 .76328 L p F P
0 g
s
.522 .255 .451 r
.66948 .77052 m .6676 .78756 L .64618 .79377 L p F P
0 g
s
.923 .643 .492 r
.542 .40057 m .52723 .38801 L .52719 .36559 L p F P
0 g
s
.966 .687 .452 r
.51586 .35157 m .52719 .36559 L .52723 .38801 L p F P
0 g
s
.554 .631 .882 r
.64321 .35732 m .63649 .35767 L .63649 .34651 L closepath p F P
0 g
s
.564 .64 .884 r
.63244 .34009 m .63649 .34651 L .63649 .35767 L p F P
0 g
s
.564 .64 .884 r
.61099 .34183 m .63244 .34009 L p .63649 .35767 L F P
0 g
s
.822 .553 .532 r
.58345 .46666 m .56985 .46147 L .56955 .43859 L p F P
0 g
s
.842 .569 .527 r
.56033 .43438 m .56955 .43859 L .56985 .46147 L p F P
0 g
s
.535 .241 .414 r
.62094 .81529 m .62402 .799 L .64618 .79377 L p F P
0 g
s
.913 .768 .686 r
.27157 .56046 m .27493 .55288 L .26183 .54373 L p F P
0 g
s
.606 .381 .548 r
.68948 .49733 m .68844 .47422 L .71165 .46922 L p F P
0 g
s
.649 .413 .548 r
.68844 .47422 m .68948 .49733 L .66449 .50008 L p F P
0 g
s
.88 .603 .514 r
.56033 .43438 m .54213 .42322 L .542 .40057 L p F P
0 g
s
.923 .643 .492 r
.52723 .38801 m .542 .40057 L .54213 .42322 L p F P
0 g
s
.503 .565 .851 r
.68026 .38563 m .67559 .37672 L .68197 .37737 L closepath p F P
0 g
s
.735 .481 .545 r
.63717 .49988 m .61259 .49707 L .61203 .47396 L p F P
0 g
s
.761 .503 .542 r
.60628 .47287 m .61203 .47396 L .61259 .49707 L p F P
0 g
s
.9 .801 .741 r
.2829 .50259 m .27949 .49716 L .2844 .50012 L closepath p F P
0 g
s
.826 .837 .857 r
.36098 .38494 m .35664 .38874 L .344 .38026 L p F P
0 g
s
.84 .835 .841 r
.35664 .38874 m .344 .38026 L p .32825 .40395 L F P
0 g
s
.84 .835 .841 r
.32825 .40395 m .33569 .4088 L .35664 .38874 L p F P
0 g
s
.424 .226 .506 r
.72972 .72783 m .72953 .70918 L .74783 .6987 L p F P
0 g
s
.447 .268 .544 r
.74671 .67921 m .74783 .6987 L .72953 .70918 L p F P
0 g
s
.461 .254 .512 r
.72953 .70918 m .72972 .72783 L .71066 .73718 L p F P
0 g
s
.826 .837 .857 r
.344 .38026 m .35889 .36723 L .36098 .38494 L p F P
0 g
s
.815 .83 .862 r
.36501 .36214 m .35889 .36723 L .36098 .38494 L p F P
0 g
s
.815 .83 .862 r
.36098 .38494 m .37747 .37125 L .36501 .36214 L p F P
0 g
s
.772 .428 .404 r
.40504 .79626 m .41004 .79743 L .41867 .81478 L p F P
0 g
s
.757 .423 .419 r
.43291 .81753 m .41867 .81478 L .41004 .79743 L p F P
0 g
s
.913 .801 .722 r
.27949 .49716 m .2829 .50259 L .2707 .52506 L p F P
0 g
s
.839 .538 .48 r
.33082 .74384 m .33304 .73821 L p .35425 .76431 L F P
0 g
s
.847 .548 .482 r
.33082 .74384 m .3299 .73684 L .33304 .73821 L closepath p F P
0 g
s
.646 .743 .92 r
.54657 .31997 m .52557 .3262 L .5142 .31341 L p F P
0 g
s
.851 .831 .827 r
.33109 .41358 m .32825 .40395 L .33569 .4088 L closepath p F P
0 g
s
.411 .241 .538 r
.75284 .67515 m .74671 .67921 L .74783 .6987 L p F P
0 g
s
.761 .503 .542 r
.61259 .49707 m .60681 .49598 L .60628 .47287 L p F P
0 g
s
.788 .525 .538 r
.58345 .46666 m .60628 .47287 L .60681 .49598 L p F P
0 g
s
.864 .837 .818 r
.33109 .41358 m .32825 .40395 L p .30265 .42501 L F P
0 g
s
.864 .837 .818 r
.30265 .42501 m .31456 .43194 L .33109 .41358 L p F P
0 g
s
.444 .496 .819 r
.7374 .42976 m .71897 .42419 L .712 .40876 L p F P
0 g
s
.404 .33 .659 r
.77096 .58885 m .78322 .57588 L .7695 .56092 L p F P
0 g
s
.386 .326 .668 r
.78009 .54818 m .7695 .56092 L .78322 .57588 L p F P
0 g
s
.412 .362 .693 r
.77503 .52867 m .78009 .54818 L .7695 .56092 L p F P
0 g
s
.412 .362 .693 r
.77082 .52525 m .77503 .52867 L p .7695 .56092 L F P
0 g
s
.799 .831 .876 r
.39826 .35557 m .37747 .37125 L .36501 .36214 L p F P
0 g
s
.702 .785 .916 r
.49326 .32115 m .47242 .33033 L .46069 .31903 L p F P
0 g
s
.726 .791 .904 r
.43983 .32972 m .46069 .31903 L .47242 .33033 L p F P
0 g
s
.865 .585 .512 r
.3299 .73684 m .31058 .72716 L .30993 .70805 L p F P
0 g
s
.885 .602 .504 r
.2922 .69769 m .30993 .70805 L .31058 .72716 L p F P
0 g
s
.881 .622 .543 r
.30993 .70805 m .2922 .69769 L .29333 .67819 L p F P
0 g
s
.925 .763 .662 r
.26037 .547 m .27157 .56046 L .26361 .58167 L p F P
0 g
s
.913 .768 .686 r
.26183 .54373 m .26037 .547 L .27157 .56046 L p F P
0 g
s
.528 .597 .867 r
.64321 .35732 m .66491 .35784 L .67559 .37672 L p F P
0 g
s
.52 .614 .887 r
.65419 .34041 m .66491 .35784 L .64321 .35732 L p F P
0 g
s
.52 .614 .887 r
.63569 .34006 m .65419 .34041 L p .64321 .35732 L F P
0 g
s
.52 .614 .887 r
.64321 .35732 m .63649 .34651 L .63569 .34006 L p F P
0 g
s
.772 .428 .404 r
.41867 .81478 m .39754 .80983 L .40504 .79626 L p F P
0 g
s
.787 .447 .412 r
.38329 .79042 m .40504 .79626 L .39754 .80983 L p F P
0 g
s
.437 .211 .471 r
.70989 .75502 m .71066 .73718 L .72972 .72783 L p F P
0 g
s
.474 .24 .479 r
.71066 .73718 m .70989 .75502 L .69004 .76328 L p F P
0 g
s
.901 .642 .536 r
.2772 .66712 m .29333 .67819 L .2922 .69769 L p F P
0 g
s
.895 .659 .573 r
.29333 .67819 m .2772 .66712 L .28009 .64721 L p F P
0 g
s
.559 .659 .903 r
.63244 .34009 m .61099 .34183 L .60009 .32616 L p F P
0 g
s
.59 .673 .897 r
.5788 .32944 m .60009 .32616 L .61099 .34183 L p F P
0 g
s
.866 .562 .472 r
.3299 .73684 m .33082 .74384 L .32631 .75257 L p F P
0 g
s
.866 .562 .472 r
.31058 .72716 m .3299 .73684 L p .32631 .75257 L F P
0 g
s
.64 .294 .369 r
.51645 .83985 m .52215 .82522 L .53412 .82501 L p F P
0 g
s
.665 .321 .38 r
.49442 .82456 m .52215 .82522 L .51645 .83985 L p F P
0 g
s
.842 .569 .527 r
.56985 .46147 m .56057 .45727 L .56033 .43438 L p F P
0 g
s
.88 .603 .514 r
.54213 .42322 m .56033 .43438 L .56057 .45727 L p F P
0 g
s
.634 .3 .388 r
.54573 .83277 m .53412 .82501 L .54846 .82447 L closepath p F P
0 g
s
.64 .294 .369 r
.53412 .82501 m .54573 .83277 L p .51645 .83985 L F P
0 g
s
.378 .292 .631 r
.77517 .61168 m .77096 .58885 L .78322 .57588 L p F P
0 g
s
.417 .319 .636 r
.77186 .61466 m .77517 .61168 L .77096 .58885 L p F P
0 g
s
.665 .321 .38 r
.49236 .82966 m .49442 .82456 L p .51645 .83985 L F P
0 g
s
.688 .345 .389 r
.49236 .82966 m .4872 .82412 L .49442 .82456 L closepath p F P
0 g
s
.874 .832 .803 r
.30806 .43975 m .30265 .42501 L .31456 .43194 L closepath p F P
0 g
s
.608 .274 .378 r
.54846 .82447 m .57357 .82247 L .56878 .83761 L p F P
0 g
s
.608 .274 .378 r
.54573 .83277 m .54846 .82447 L p .56878 .83761 L F P
0 g
s
.78 .831 .891 r
.40475 .35117 m .39826 .35557 L .38594 .34634 L p F P
0 g
s
.799 .831 .876 r
.36501 .36214 m .38594 .34634 L .39826 .35557 L p F P
0 g
s
.916 .681 .569 r
.26556 .6354 m .28009 .64721 L .2772 .66712 L p F P
0 g
s
.908 .695 .604 r
.28009 .64721 m .26556 .6354 L .27018 .61506 L p F P
0 g
s
.697 .343 .371 r
.4872 .82412 m .49236 .82966 L .48808 .83879 L p F P
0 g
s
.697 .343 .371 r
.46483 .82212 m .4872 .82412 L p .48808 .83879 L F P
0 g
s
.494 .579 .87 r
.68197 .37737 m .67559 .37672 L .66491 .35784 L p F P
0 g
s
.381 .244 .567 r
.76404 .66726 m .76194 .64678 L .77834 .63332 L p F P
0 g
s
.408 .286 .601 r
.77719 .62524 m .77834 .63332 L .76194 .64678 L p F P
0 g
s
.408 .286 .601 r
.77186 .61466 m .77719 .62524 L p .76194 .64678 L F P
0 g
s
.421 .273 .573 r
.75284 .67515 m .76404 .66726 L .76194 .64678 L p F P
0 g
s
.566 .269 .422 r
.62094 .81529 m .61226 .81689 L .59885 .81443 L p F P
0 g
s
.565 .259 .408 r
.61226 .81689 m .59774 .81943 L .59885 .81443 L closepath p F P
0 g
s
.596 .287 .417 r
.59885 .81443 m .59774 .81943 L .57357 .82247 L p F P
0 g
s
.887 .837 .79 r
.30806 .43975 m .30265 .42501 L p .28545 .45529 L F P
0 g
s
.887 .837 .79 r
.28545 .45529 m .29314 .45913 L .30806 .43975 L p F P
0 g
s
.78 .831 .891 r
.40788 .33291 m .40475 .35117 L p .38594 .34634 L F P
0 g
s
.772 .823 .893 r
.40475 .35117 m .40788 .33291 L .41903 .34185 L closepath p F P
0 g
s
.557 .343 .545 r
.71283 .49235 m .71165 .46922 L .73327 .46196 L p F P
0 g
s
.606 .381 .548 r
.71165 .46922 m .71283 .49235 L .68948 .49733 L p F P
0 g
s
.82 .5 .449 r
.36589 .78492 m .35902 .78255 L .35425 .76431 L p F P
0 g
s
.838 .511 .435 r
.33255 .75552 m .35425 .76431 L .35902 .78255 L p F P
0 g
s
.839 .538 .48 r
.35425 .76431 m .33255 .75552 L .33082 .74384 L p F P
0 g
s
.586 .695 .917 r
.60009 .32616 m .5788 .32944 L .56773 .31516 L p F P
0 g
s
.618 .708 .909 r
.54657 .31997 m .56773 .31516 L .5788 .32944 L p F P
0 g
s
.535 .241 .414 r
.64618 .79377 m .64325 .81007 L .62094 .81529 L p F P
0 g
s
.501 .211 .405 r
.64325 .81007 m .64618 .79377 L .6676 .78756 L p F P
0 g
s
.411 .241 .538 r
.74783 .6987 m .75399 .69466 L .75284 .67515 L p F P
0 g
s
.394 .228 .535 r
.76404 .66726 m .75284 .67515 L .75399 .69466 L p F P
0 g
s
.578 .244 .367 r
.56878 .83761 m .57357 .82247 L .59774 .81943 L p F P
0 g
s
.19 .076 .484 r
.79509 .34158 m .78356 .35713 L .7852 .37957 L p F P
0 g
s
.19 .076 .484 r
.78356 .35713 m .79509 .34158 L .7934 .31936 L p F P
0 g
s
.45 .195 .434 r
.68828 .78034 m .69004 .76328 L .70989 .75502 L p F P
0 g
s
.488 .226 .443 r
.69004 .76328 m .68828 .78034 L .6676 .78756 L p F P
0 g
s
.444 .496 .819 r
.712 .40876 m .71382 .40208 L p .7374 .42976 L F P
0 g
s
.464 .517 .828 r
.712 .40876 m .70826 .40078 L .71382 .40208 L closepath p F P
0 g
s
.908 .807 .735 r
.27121 .49275 m .274 .48798 L .27949 .49716 L closepath p F P
0 g
s
.895 .806 .754 r
.28935 .46442 m .274 .48798 L .27949 .49716 L p F P
0 g
s
.913 .801 .722 r
.27121 .49275 m .27949 .49716 L p .2707 .52506 L F P
0 g
s
.697 .343 .371 r
.45972 .8326 m .46483 .82212 L p .48808 .83879 L F P
0 g
s
.718 .366 .381 r
.45972 .8326 m .45021 .82029 L .46483 .82212 L closepath p F P
0 g
s
.928 .719 .601 r
.25726 .60248 m .27018 .61506 L .26556 .6354 L p F P
0 g
s
.918 .73 .633 r
.27018 .61506 m .25726 .60248 L .26361 .58167 L p F P
0 g
s
.069 0 .449 r
.79557 .31541 m .7934 .31936 L .79509 .34158 L p F P
0 g
s
.39 .278 .604 r
.77719 .62524 m .77186 .61466 L .77517 .61168 L closepath p F P
0 g
s
.752 .821 .906 r
.40788 .33291 m .41903 .34185 L .43983 .32972 L p F P
0 g
s
.859 .553 .468 r
.33255 .75552 m .32631 .75257 L .33082 .74384 L closepath p F P
0 g
s
.788 .525 .538 r
.60681 .49598 m .58384 .4898 L .58345 .46666 L p F P
0 g
s
.822 .553 .532 r
.56985 .46147 m .58345 .46666 L .58384 .4898 L p F P
0 g
s
.42 .395 .726 r
.76452 .49344 m .77317 .52194 L .77082 .52525 L p F P
0 g
s
.395 .362 .704 r
.77503 .52867 m .77082 .52525 L .77317 .52194 L closepath p F P
0 g
s
.476 .563 .865 r
.68197 .37737 m .69759 .37967 L .68693 .3602 L p F P
0 g
s
.476 .563 .865 r
.68693 .3602 m .68231 .35954 L .68197 .37737 L p F P
0 g
s
.494 .579 .87 r
.66491 .35784 m .68231 .35954 L .68197 .37737 L p F P
0 g
s
.927 .799 .699 r
.2707 .52506 m .26146 .51064 L p .25677 .54169 L F P
0 g
s
.927 .799 .699 r
.25677 .54169 m .26183 .54373 L .2707 .52506 L p F P
0 g
s
.913 .801 .722 r
.2707 .52506 m .26146 .51064 L .27121 .49275 L p F P
0 g
s
.702 .785 .916 r
.46069 .31903 m .48163 .30977 L .49326 .32115 L p F P
0 g
s
.895 .831 .776 r
.28935 .46442 m .28545 .45529 L .29314 .45913 L closepath p F P
0 g
s
.73 .366 .361 r
.45021 .82029 m .45972 .8326 L .4578 .83593 L p F P
0 g
s
.73 .366 .361 r
.43291 .81753 m .45021 .82029 L p .4578 .83593 L F P
0 g
s
.451 .528 .846 r
.71382 .40208 m .70826 .40078 L .69759 .37967 L p F P
0 g
s
.787 .447 .412 r
.39754 .80983 m .39087 .80806 L .38329 .79042 L p F P
0 g
s
.803 .453 .394 r
.36589 .78492 m .38329 .79042 L .39087 .80806 L p F P
0 g
s
.533 .625 .888 r
.63649 .34651 m .63244 .34009 L .63569 .34006 L closepath p F P
0 g
s
.614 .731 .929 r
.56773 .31516 m .54657 .31997 L .53529 .30708 L p F P
0 g
s
.646 .743 .92 r
.5142 .31341 m .53529 .30708 L .54657 .31997 L p F P
0 g
s
.909 .834 .76 r
.28545 .45529 m .28935 .46442 L .274 .48798 L p F P
0 g
s
.544 .212 .355 r
.59312 .83457 m .59774 .81943 L .61226 .81689 L p F P
0 g
s
.578 .244 .367 r
.59774 .81943 m .59312 .83457 L .56878 .83761 L p F P
0 g
s
.665 .321 .38 r
.51645 .83985 m .50364 .83955 L .49236 .82966 L p F P
0 g
s
.673 .316 .36 r
.50364 .83955 m .48808 .83879 L .49236 .82966 L closepath p F P
0 g
s
.381 .371 .723 r
.76563 .49152 m .76452 .49344 L .77317 .52194 L p F P
0 g
s
.407 .402 .742 r
.76452 .49344 m .76346 .49021 L .76563 .49152 L closepath p F P
0 g
s
.347 .248 .598 r
.77517 .61168 m .79019 .59599 L p .78002 .63175 L F P
0 g
s
.347 .248 .598 r
.78002 .63175 m .77719 .62524 L .77517 .61168 L p F P
0 g
s
.378 .292 .631 r
.78769 .58258 m .79019 .59599 L .77517 .61168 L p F P
0 g
s
.378 .292 .631 r
.78322 .57588 m .78769 .58258 L p .77517 .61168 L F P
0 g
s
0 0 .394 r
.80199 .29846 m .79557 .31541 L .79729 .33764 L p F P
0 g
s
.069 0 .449 r
.79509 .34158 m .79729 .33764 L .79557 .31541 L p F P
0 g
s
.684 .441 .548 r
.65308 .50032 m .66449 .50008 L .66538 .52347 L p F P
0 g
s
.684 .441 .548 r
.66538 .52347 m .6539 .5237 L .65308 .50032 L p F P
0 g
s
.703 .455 .547 r
.63717 .49988 m .65308 .50032 L .6539 .5237 L p F P
0 g
s
.937 .755 .632 r
.25231 .56829 m .26361 .58167 L .25726 .60248 L p F P
0 g
s
.925 .763 .662 r
.26361 .58167 m .25231 .56829 L .26037 .547 L p F P
0 g
s
.852 .841 .833 r
.32289 .40071 m .32667 .39685 L .32825 .40395 L closepath p F P
0 g
s
.84 .835 .841 r
.344 .38026 m .32667 .39685 L .32825 .40395 L p F P
0 g
s
.864 .837 .818 r
.32825 .40395 m .32289 .40071 L p .30265 .42501 L F P
0 g
s
.649 .413 .548 r
.66538 .52347 m .66449 .50008 L .68948 .49733 L p F P
0 g
s
.703 .455 .547 r
.6539 .5237 m .63789 .52326 L .63717 .49988 L p F P
0 g
s
.735 .481 .545 r
.61259 .49707 m .63717 .49988 L .63789 .52326 L p F P
0 g
s
.352 .334 .699 r
.77317 .52194 m .78332 .50479 L p .78626 .53947 L F P
0 g
s
.352 .334 .699 r
.78626 .53947 m .77503 .52867 L .77317 .52194 L p F P
0 g
s
.381 .371 .723 r
.77317 .52194 m .78332 .50479 L .76563 .49152 L p F P
0 g
s
.966 .687 .452 r
.52723 .38801 m .51582 .37404 L .51586 .35157 L p F P
0 g
s
.989 .723 .376 r
.5079 .3361 m .51586 .35157 L .51582 .37404 L p F P
0 g
s
.729 .818 .92 r
.46069 .31903 m .43983 .32972 L .42779 .31986 L p F P
0 g
s
.752 .821 .906 r
.43983 .32972 m .42779 .31986 L p .40788 .33291 L F P
0 g
s
.73 .366 .361 r
.42696 .82742 m .43291 .81753 L p .4578 .83593 L F P
0 g
s
.748 .389 .372 r
.42696 .82742 m .41867 .81478 L .43291 .81753 L closepath p F P
0 g
s
.923 .643 .492 r
.54213 .42322 m .52727 .4107 L .52723 .38801 L p F P
0 g
s
.966 .687 .452 r
.51582 .37404 m .52723 .38801 L .52727 .4107 L p F P
0 g
s
.374 .337 .689 r
.78009 .54818 m .77503 .52867 L .78626 .53947 L closepath p F P
0 g
s
.498 .299 .54 r
.73459 .48512 m .73327 .46196 L .75336 .4524 L p F P
0 g
s
.557 .343 .545 r
.73327 .46196 m .73459 .48512 L .71283 .49235 L p F P
0 g
s
.36 .37 .736 r
.77486 .47179 m .76563 .49152 L .78332 .50479 L p F P
0 g
s
.384 .196 .499 r
.75399 .69466 m .74783 .6987 L .74813 .71739 L p F P
0 g
s
.424 .226 .506 r
.74783 .6987 m .74813 .71739 L .72972 .72783 L p F P
0 g
s
.463 .178 .394 r
.6648 .80387 m .6676 .78756 L .68828 .78034 L p F P
0 g
s
.501 .211 .405 r
.6676 .78756 m .6648 .80387 L .64325 .81007 L p F P
0 g
s
.822 .553 .532 r
.58384 .4898 m .57015 .48463 L .56985 .46147 L p F P
0 g
s
.842 .569 .527 r
.56057 .45727 m .56985 .46147 L .57015 .48463 L p F P
0 g
s
.547 .227 .376 r
.62034 .81761 m .61226 .81689 L .62094 .81529 L closepath p F P
0 g
s
.544 .212 .355 r
.61226 .81689 m .62034 .81761 L p .59312 .83457 L F P
0 g
s
.444 .496 .819 r
.71382 .40208 m .7307 .40707 L p .7374 .42976 L F P
0 g
s
.428 .507 .837 r
.71382 .40208 m .7307 .40707 L .72 .38503 L p F P
0 g
s
.428 .507 .837 r
.72 .38503 m .71597 .38386 L .71382 .40208 L p F P
0 g
s
.451 .528 .846 r
.69759 .37967 m .71597 .38386 L .71382 .40208 L p F P
0 g
s
.397 .179 .463 r
.74813 .71739 m .72972 .72783 L .72907 .7457 L p F P
0 g
s
.437 .211 .471 r
.72972 .72783 m .72907 .7457 L .70989 .75502 L p F P
0 g
s
.608 .274 .378 r
.56878 .83761 m .5577 .83848 L .54573 .83277 L p F P
0 g
s
.611 .264 .358 r
.5577 .83848 m .54325 .83938 L .54573 .83277 L closepath p F P
0 g
s
.64 .294 .369 r
.54573 .83277 m .54325 .83938 L .51645 .83985 L p F P
0 g
s
.885 .602 .504 r
.31058 .72716 m .29276 .71684 L .2922 .69769 L p F P
0 g
s
.905 .621 .493 r
.27599 .68667 m .2922 .69769 L .29276 .71684 L p F P
0 g
s
.901 .642 .536 r
.2922 .69769 m .27599 .68667 L .2772 .66712 L p F P
0 g
s
.524 .642 .908 r
.63569 .34006 m .63244 .34009 L .62162 .32434 L p F P
0 g
s
.559 .659 .903 r
.60009 .32616 m .62162 .32434 L .63244 .34009 L p F P
0 g
s
.866 .562 .472 r
.32631 .75257 m .31293 .74593 L .31058 .72716 L p F P
0 g
s
.886 .578 .459 r
.29276 .71684 m .31058 .72716 L .31293 .74593 L p F P
0 g
s
.606 .381 .548 r
.69054 .52072 m .68948 .49733 L .71283 .49235 L p F P
0 g
s
.649 .413 .548 r
.68948 .49733 m .69054 .52072 L .66538 .52347 L p F P
0 g
s
.88 .603 .514 r
.56057 .45727 m .54226 .44616 L .54213 .42322 L p F P
0 g
s
.923 .643 .492 r
.52727 .4107 m .54213 .42322 L .54226 .44616 L p F P
0 g
s
.735 .481 .545 r
.63789 .52326 m .61317 .52047 L .61259 .49707 L p F P
0 g
s
.761 .503 .542 r
.60681 .49598 m .61259 .49707 L .61317 .52047 L p F P
0 g
s
.35 .196 .527 r
.76525 .6868 m .76404 .66726 L .78053 .65387 L p F P
0 g
s
.381 .244 .567 r
.77834 .63332 m .78053 .65387 L .76404 .66726 L p F P
0 g
s
.394 .228 .535 r
.75399 .69466 m .76525 .6868 L .76404 .66726 L p F P
0 g
s
.922 .663 .528 r
.26259 .65537 m .2772 .66712 L .27599 .68667 L p F P
0 g
s
.916 .681 .569 r
.2772 .66712 m .26259 .65537 L .26556 .6354 L p F P
0 g
s
.482 .595 .889 r
.68231 .35954 m .66491 .35784 L .65419 .34041 L p F P
0 g
s
.514 .195 .365 r
.62034 .81761 m .62094 .81529 L .64325 .81007 L p F P
0 g
s
.42 .471 .807 r
.74145 .43129 m .7374 .42976 L .73875 .42501 L closepath p F P
0 g
s
.444 .496 .819 r
.7307 .40707 m .73875 .42501 L .7374 .42976 L p F P
0 g
s
.93 .793 .688 r
.26037 .547 m .25677 .54169 L .26183 .54373 L closepath p F P
0 g
s
.344 .298 .662 r
.78626 .53947 m .78009 .54818 L .78577 .57286 L p F P
0 g
s
.386 .326 .668 r
.78322 .57588 m .78577 .57286 L .78009 .54818 L p F P
0 g
s
.551 .679 .923 r
.62162 .32434 m .60009 .32616 L .5891 .3118 L p F P
0 g
s
.586 .695 .917 r
.56773 .31516 m .5891 .3118 L .60009 .32616 L p F P
0 g
s
.838 .511 .435 r
.35902 .78255 m .33721 .77379 L .33255 .75552 L p F P
0 g
s
.857 .523 .418 r
.32631 .75257 m .33255 .75552 L .33721 .77379 L p F P
0 g
s
.761 .503 .542 r
.61317 .52047 m .60735 .51938 L .60681 .49598 L p F P
0 g
s
.788 .525 .538 r
.58384 .4898 m .60681 .49598 L .60735 .51938 L p F P
0 g
s
.762 .39 .35 r
.41867 .81478 m .42696 .82742 L .42469 .83049 L p F P
0 g
s
.762 .39 .35 r
.39754 .80983 m .41867 .81478 L p .42469 .83049 L F P
0 g
s
.509 .633 .908 r
.63569 .34006 m .65419 .34041 L .64342 .32444 L p F P
0 g
s
.509 .633 .908 r
.64342 .32444 m .62922 .32422 L .63569 .34006 L p F P
0 g
s
.524 .642 .908 r
.62162 .32434 m .62922 .32422 L .63569 .34006 L p F P
0 g
s
.815 .47 .403 r
.36194 .79035 m .35902 .78255 L .36589 .78492 L closepath p F P
0 g
s
.803 .453 .394 r
.36194 .79035 m .36589 .78492 L p .39087 .80806 L F P
0 g
s
.409 .161 .424 r
.72907 .7457 m .70989 .75502 L .70825 .77209 L p F P
0 g
s
.45 .195 .434 r
.70989 .75502 m .70825 .77209 L .68828 .78034 L p F P
0 g
s
.369 .259 .596 r
.77834 .63332 m .77719 .62524 L .78002 .63175 L closepath p F P
0 g
s
.924 .836 .739 r
.274 .48798 m .27121 .49275 L .25758 .48873 L p F P
0 g
s
.924 .836 .739 r
.25758 .48873 m .26715 .47239 L .274 .48798 L p F P
0 g
s
.909 .834 .76 r
.27988 .45294 m .28545 .45529 L p .274 .48798 L F P
0 g
s
.909 .834 .76 r
.274 .48798 m .26715 .47239 L .27988 .45294 L p F P
0 g
s
.942 .789 .661 r
.25677 .54169 m .26037 .547 L .25231 .56829 L p F P
0 g
s
.937 .705 .562 r
.25256 .62289 m .26556 .6354 L .26259 .65537 L p F P
0 g
s
.928 .719 .601 r
.26556 .6354 m .25256 .62289 L .25726 .60248 L p F P
0 g
s
.842 .569 .527 r
.57015 .48463 m .56082 .48045 L .56057 .45727 L p F P
0 g
s
.88 .603 .514 r
.54226 .44616 m .56057 .45727 L .56082 .48045 L p F P
0 g
s
.384 .196 .499 r
.74813 .71739 m .75078 .71567 L .75399 .69466 L p F P
0 g
s
.362 .177 .491 r
.76525 .6868 m .75399 .69466 L .75078 .71567 L p F P
0 g
s
.356 .284 .637 r
.78769 .58258 m .78322 .57588 L .78577 .57286 L closepath p F P
0 g
s
.514 .195 .365 r
.64325 .81007 m .6419 .8155 L .62034 .81761 L p F P
0 g
s
.506 .176 .342 r
.61656 .8305 m .62034 .81761 L .6419 .8155 L p F P
0 g
s
.544 .212 .355 r
.62034 .81761 m .61656 .8305 L .59312 .83457 L p F P
0 g
s
.702 .813 .934 r
.48163 .30977 m .46069 .31903 L .44877 .30907 L p F P
0 g
s
.729 .818 .92 r
.42779 .31986 m .44877 .30907 L .46069 .31903 L p F P
0 g
s
.929 .828 .726 r
.26146 .51064 m .27121 .49275 L .25758 .48873 L p F P
0 g
s
.834 .867 .868 r
.35889 .36723 m .344 .38026 L .33109 .37346 L p F P
0 g
s
.849 .863 .852 r
.32667 .39685 m .344 .38026 L .33109 .37346 L p F P
0 g
s
.376 .445 .804 r
.76088 .44056 m .74145 .43129 L .73875 .42501 L p F P
0 g
s
.822 .857 .873 r
.35889 .36723 m .35947 .35883 L .36501 .36214 L closepath p F P
0 g
s
.834 .867 .868 r
.35947 .35883 m .35889 .36723 L p .33109 .37346 L F P
0 g
s
.863 .872 .843 r
.32667 .39685 m .32289 .40071 L .30975 .39489 L p F P
0 g
s
.863 .872 .843 r
.30975 .39489 m .32577 .37855 L .32667 .39685 L p F P
0 g
s
.849 .863 .852 r
.33109 .37346 m .32577 .37855 L .32667 .39685 L p F P
0 g
s
.435 .541 .865 r
.71597 .38386 m .69759 .37967 L .68693 .3602 L p F P
0 g
s
.864 .837 .818 r
.32289 .40071 m .30223 .42364 L .30265 .42501 L p F P
0 g
s
.875 .866 .826 r
.30223 .42364 m .32289 .40071 L .30975 .39489 L p F P
0 g
s
.805 .859 .889 r
.35947 .35883 m .36501 .36214 L .38594 .34634 L p F P
0 g
s
.833 .478 .384 r
.35902 .78255 m .36194 .79035 L .35589 .79651 L p F P
0 g
s
.833 .478 .384 r
.33721 .77379 m .35902 .78255 L p .35589 .79651 L F P
0 g
s
.58 .717 .937 r
.5891 .3118 m .56773 .31516 L .55655 .3022 L p F P
0 g
s
.614 .731 .929 r
.53529 .30708 m .55655 .3022 L .56773 .31516 L p F P
0 g
s
.857 .523 .418 r
.31669 .76284 m .32631 .75257 L p .33721 .77379 L F P
0 g
s
.865 .535 .425 r
.31669 .76284 m .31293 .74593 L .32631 .75257 L closepath p F P
0 g
s
.902 .841 .775 r
.27988 .45294 m .28292 .44862 L .28545 .45529 L closepath p F P
0 g
s
.887 .837 .79 r
.30156 .42444 m .28292 .44862 L .28545 .45529 L p F P
0 g
s
.887 .837 .79 r
.30265 .42501 m .30156 .42444 L p .28545 .45529 L F P
0 g
s
.557 .343 .545 r
.71403 .51577 m .71283 .49235 L .73459 .48512 L p F P
0 g
s
.606 .381 .548 r
.71283 .49235 m .71403 .51577 L .69054 .52072 L p F P
0 g
s
.339 .214 .56 r
.78002 .63175 m .77834 .63332 L .78053 .65387 L p F P
0 g
s
.878 .843 .806 r
.30156 .42444 m .30223 .42364 L .30265 .42501 L closepath p F P
0 g
s
.376 .445 .804 r
.73875 .42501 m .74139 .41117 L p .76088 .44056 L F P
0 g
s
.404 .473 .817 r
.73875 .42501 m .7307 .40707 L .74139 .41117 L closepath p F P
0 g
s
.309 .252 .63 r
.78577 .57286 m .79866 .55493 L p .79329 .59224 L F P
0 g
s
.309 .252 .63 r
.79329 .59224 m .78769 .58258 L .78577 .57286 L p F P
0 g
s
.344 .298 .662 r
.78577 .57286 m .79866 .55493 L .78626 .53947 L p F P
0 g
s
.19 .076 .484 r
.7852 .37957 m .79681 .36408 L .79509 .34158 L p F P
0 g
s
.948 .745 .596 r
.24588 .58917 m .25726 .60248 L .25256 .62289 L p F P
0 g
s
.937 .755 .632 r
.25726 .60248 m .24588 .58917 L .25231 .56829 L p F P
0 g
s
.78 .831 .891 r
.38594 .34634 m .40686 .33212 L .40788 .33291 L p F P
0 g
s
.785 .86 .906 r
.40686 .33212 m .38594 .34634 L .37337 .3386 L p F P
0 g
s
.805 .859 .889 r
.38594 .34634 m .37337 .3386 L p .35947 .35883 L F P
0 g
s
.697 .343 .371 r
.48808 .83879 m .46338 .8366 L .45972 .8326 L p F P
0 g
s
.708 .34 .349 r
.46338 .8366 m .4578 .83593 L .45972 .8326 L closepath p F P
0 g
s
.339 .214 .56 r
.78053 .65387 m .78447 .65021 L .78002 .63175 L p F P
0 g
s
.311 .197 .558 r
.79351 .61782 m .78002 .63175 L .78447 .65021 L p F P
0 g
s
.347 .248 .598 r
.79019 .59599 m .79351 .61782 L .78002 .63175 L p F P
0 g
s
.621 .248 .314 r
.51645 .83985 m .54325 .83938 L .53653 .85312 L p F P
0 g
s
.621 .248 .314 r
.51328 .84612 m .51645 .83985 L p .53653 .85312 L F P
0 g
s
.65 .279 .328 r
.51328 .84612 m .50364 .83955 L .51645 .83985 L closepath p F P
0 g
s
.89 .874 .814 r
.30223 .42364 m .30156 .42444 L .28817 .41983 L p F P
0 g
s
.89 .874 .814 r
.28817 .41983 m .29967 .40606 L .30223 .42364 L p F P
0 g
s
.875 .866 .826 r
.30975 .39489 m .29967 .40606 L .30223 .42364 L p F P
0 g
s
.422 .143 .382 r
.70825 .77209 m .68828 .78034 L .68562 .79666 L p F P
0 g
s
.463 .178 .394 r
.68828 .78034 m .68562 .79666 L .6648 .80387 L p F P
0 g
s
.476 .161 .353 r
.6419 .8155 m .64325 .81007 L .6648 .80387 L p F P
0 g
s
.9 .866 .797 r
.28292 .44862 m .30156 .42444 L .28817 .41983 L p F P
0 g
s
.069 0 .449 r
.79729 .33764 m .79509 .34158 L .79681 .36408 L p F P
0 g
s
.762 .39 .35 r
.39427 .81407 m .39754 .80983 L p .42469 .83049 L F P
0 g
s
.779 .412 .362 r
.39427 .81407 m .39087 .80806 L .39754 .80983 L closepath p F P
0 g
s
.656 .269 .301 r
.50364 .83955 m .51328 .84612 L .50908 .85318 L p F P
0 g
s
.656 .269 .301 r
.48808 .83879 m .50364 .83955 L p .50908 .85318 L F P
0 g
s
.589 .213 .298 r
.53653 .85312 m .54325 .83938 L .5577 .83848 L p F P
0 g
s
.788 .525 .538 r
.60735 .51938 m .58423 .51323 L .58384 .4898 L p F P
0 g
s
.822 .553 .532 r
.57015 .48463 m .58384 .4898 L .58423 .51323 L p F P
0 g
s
.941 .795 .671 r
.24818 .53944 m .25092 .53271 L .25677 .54169 L closepath p F P
0 g
s
.927 .799 .699 r
.26146 .51064 m .25092 .53271 L .25677 .54169 L p F P
0 g
s
.942 .789 .661 r
.24818 .53944 m .25677 .54169 L p .25231 .56829 L F P
0 g
s
.498 .299 .54 r
.75336 .4524 m .75481 .47559 L .73459 .48512 L p F P
0 g
s
.656 .269 .301 r
.48043 .85123 m .48808 .83879 L p .50908 .85318 L F P
0 g
s
.682 .3 .316 r
.48043 .85123 m .46338 .8366 L .48808 .83879 L closepath p F P
0 g
s
.759 .829 .907 r
.40686 .33212 m .4086 .33107 L .40788 .33291 L closepath p F P
0 g
s
.752 .821 .906 r
.42779 .31986 m .4086 .33107 L .40788 .33291 L p F P
0 g
s
.589 .229 .326 r
.56707 .84177 m .5577 .83848 L .56878 .83761 L closepath p F P
0 g
s
.589 .213 .298 r
.5577 .83848 m .56707 .84177 L p .53653 .85312 L F P
0 g
s
.336 .263 .625 r
.79019 .59599 m .78769 .58258 L .79329 .59224 L closepath p F P
0 g
s
.943 .828 .7 r
.25395 .49536 m .26146 .51064 L .25092 .53271 L p F P
0 g
s
.929 .828 .726 r
.25758 .48873 m .25395 .49536 L .26146 .51064 L p F P
0 g
s
.794 .415 .338 r
.39087 .80806 m .39427 .81407 L .3872 .82112 L p F P
0 g
s
.794 .415 .338 r
.36615 .80031 m .39087 .80806 L p .3872 .82112 L F P
0 g
s
.803 .453 .394 r
.39087 .80806 m .36615 .80031 L .36194 .79035 L p F P
0 g
s
.556 .196 .312 r
.56707 .84177 m .56878 .83761 L .59312 .83457 L p F P
0 g
s
.672 .805 .946 r
.50268 .30193 m .48163 .30977 L .46983 .29971 L p F P
0 g
s
.702 .813 .934 r
.44877 .30907 m .46983 .29971 L .48163 .30977 L p F P
0 g
s
.762 .859 .922 r
.4086 .33107 m .40686 .33212 L .39444 .32427 L p F P
0 g
s
.785 .86 .906 r
.37337 .3386 m .39444 .32427 L .40686 .33212 L p F P
0 g
s
.609 .756 .949 r
.55655 .3022 m .53529 .30708 L .52388 .29552 L p F P
0 g
s
.762 .859 .922 r
.41937 .31402 m .4086 .33107 L p .39444 .32427 L F P
0 g
s
.755 .849 .921 r
.4086 .33107 m .41937 .31402 L .42779 .31986 L closepath p F P
0 g
s
.317 .29 .67 r
.79274 .52872 m .78626 .53947 L .79866 .55493 L p F P
0 g
s
.352 .334 .699 r
.7871 .50836 m .79274 .52872 L .78626 .53947 L p F P
0 g
s
.352 .334 .699 r
.78332 .50479 m .7871 .50836 L p .78626 .53947 L F P
0 g
s
.821 .46 .373 r
.36615 .80031 m .35589 .79651 L .36194 .79035 L closepath p F P
0 g
s
.691 .292 .286 r
.46338 .8366 m .48043 .85123 L p .44853 .84797 L F P
0 g
s
.691 .292 .286 r
.44853 .84797 m .4578 .83593 L .46338 .8366 L p F P
0 g
s
.353 .145 .453 r
.74792 .72408 m .75078 .71567 L .74813 .71739 L closepath p F P
0 g
s
.397 .179 .463 r
.74792 .72408 m .74813 .71739 L p .72907 .7457 L F P
0 g
s
0 0 .394 r
.80375 .32075 m .79729 .33764 L .79902 .36015 L p F P
0 g
s
0 0 .394 r
.79729 .33764 m .80375 .32075 L .80199 .29846 L p F P
0 g
s
.069 0 .449 r
.79681 .36408 m .79902 .36015 L .79729 .33764 L p F P
0 g
s
.384 .481 .835 r
.74139 .41117 m .7307 .40707 L .72 .38503 L p F P
0 g
s
.684 .441 .548 r
.6539 .5237 m .66538 .52347 L .66629 .54715 L p F P
0 g
s
.684 .441 .548 r
.66629 .54715 m .65474 .54738 L .6539 .5237 L p F P
0 g
s
.703 .455 .547 r
.63789 .52326 m .6539 .5237 L .65474 .54738 L p F P
0 g
s
.955 .782 .628 r
.24257 .55415 m .25231 .56829 L .24588 .58917 L p F P
0 g
s
.942 .789 .661 r
.25231 .56829 m .24257 .55415 L .24818 .53944 L p F P
0 g
s
.649 .413 .548 r
.66629 .54715 m .66538 .52347 L .69054 .52072 L p F P
0 g
s
.461 .579 .886 r
.68693 .3602 m .68231 .35954 L .68027 .34907 L closepath p F P
0 g
s
.482 .595 .889 r
.67625 .34248 m .68027 .34907 L .68231 .35954 L p F P
0 g
s
.482 .595 .889 r
.65419 .34041 m .67625 .34248 L p .68231 .35954 L F P
0 g
s
.703 .455 .547 r
.65474 .54738 m .63862 .54694 L .63789 .52326 L p F P
0 g
s
.735 .481 .545 r
.61317 .52047 m .63789 .52326 L .63862 .54694 L p F P
0 g
s
.886 .578 .459 r
.31293 .74593 m .29503 .73565 L .29276 .71684 L p F P
0 g
s
.907 .594 .442 r
.27646 .70587 m .29276 .71684 L .29503 .73565 L p F P
0 g
s
.905 .621 .493 r
.29276 .71684 m .27646 .70587 L .27599 .68667 L p F P
0 g
s
.715 .323 .303 r
.4301 .83156 m .4578 .83593 L .44853 .84797 L p F P
0 g
s
.73 .366 .361 r
.4578 .83593 m .4301 .83156 L .42696 .82742 L p F P
0 g
s
.916 .872 .78 r
.28292 .44862 m .27988 .45294 L .26617 .44989 L p F P
0 g
s
.916 .872 .78 r
.26617 .44989 m .27907 .43161 L .28292 .44862 L p F P
0 g
s
.9 .866 .797 r
.28817 .41983 m .27907 .43161 L .28292 .44862 L p F P
0 g
s
.966 .687 .452 r
.52727 .4107 m .51579 .39678 L .51582 .37404 L p F P
0 g
s
.989 .723 .376 r
.50781 .35862 m .51582 .37404 L .51579 .39678 L p F P
0 g
s
.989 .723 .376 r
.51582 .37404 m .50781 .35862 L .5079 .3361 L p F P
0 g
s
.314 .141 .48 r
.76556 .70544 m .76525 .6868 L .78184 .67348 L p F P
0 g
s
.35 .196 .527 r
.78053 .65387 m .78184 .67348 L .76525 .6868 L p F P
0 g
s
.362 .177 .491 r
.75078 .71567 m .76556 .70544 L .76525 .6868 L p F P
0 g
s
.927 .64 .479 r
.26129 .67497 m .27599 .68667 L .27646 .70587 L p F P
0 g
s
.922 .663 .528 r
.27599 .68667 m .26129 .67497 L .26259 .65537 L p F P
0 g
s
.817 .87 .886 r
.35227 .35491 m .36177 .34737 L .35947 .35883 L closepath p F P
0 g
s
.805 .859 .889 r
.37337 .3386 m .36177 .34737 L .35947 .35883 L p F P
0 g
s
.834 .867 .868 r
.33109 .37346 m .35227 .35491 L .35947 .35883 L p F P
0 g
s
.467 .611 .91 r
.67625 .34248 m .65419 .34041 L .64342 .32444 L p F P
0 g
s
.923 .643 .492 r
.54226 .44616 m .52731 .43368 L .52727 .4107 L p F P
0 g
s
.966 .687 .452 r
.51579 .39678 m .52727 .4107 L .52731 .43368 L p F P
0 g
s
.885 .548 .406 r
.31293 .74593 m .31669 .76284 L .31554 .76353 L p F P
0 g
s
.885 .548 .406 r
.29503 .73565 m .31293 .74593 L p .31554 .76353 L F P
0 g
s
.513 .661 .928 r
.62922 .32422 m .62162 .32434 L .6107 .3099 L p F P
0 g
s
.551 .679 .923 r
.5891 .3118 m .6107 .3099 L .62162 .32434 L p F P
0 g
s
.498 .299 .54 r
.73593 .50857 m .73459 .48512 L .75481 .47559 L p F P
0 g
s
.557 .343 .545 r
.73459 .48512 m .73593 .50857 L .71403 .51577 L p F P
0 g
s
.942 .715 .244 r
.50337 .31912 m .5079 .3361 L .50781 .35862 L p F P
0 g
s
.365 .126 .412 r
.72767 .76136 m .74177 .73855 L .72907 .7457 L closepath p F P
0 g
s
.409 .161 .424 r
.72767 .76136 m .72907 .7457 L p .70825 .77209 L F P
0 g
s
.397 .179 .463 r
.72907 .7457 m .74177 .73855 L .74792 .72408 L p F P
0 g
s
.922 .863 .764 r
.26715 .47239 m .27988 .45294 L .26617 .44989 L p F P
0 g
s
0 0 .286 r
.80398 .2874 m .80199 .29846 L .80375 .32075 L p F P
0 g
s
.326 .119 .438 r
.75078 .71567 m .76556 .70544 L p .74748 .73518 L F P
0 g
s
.326 .119 .438 r
.74748 .73518 m .74792 .72408 L .75078 .71567 L p F P
0 g
s
.743 .365 .336 r
.4301 .83156 m .42469 .83049 L .42696 .82742 L closepath p F P
0 g
s
.822 .553 .532 r
.58423 .51323 m .57046 .50808 L .57015 .48463 L p F P
0 g
s
.842 .569 .527 r
.56082 .48045 m .57015 .48463 L .57046 .50808 L p F P
0 g
s
.476 .161 .353 r
.6648 .80387 m .6635 .80929 L .6419 .8155 L p F P
0 g
s
.463 .137 .327 r
.63911 .82537 m .6419 .8155 L .6635 .80929 L p F P
0 g
s
.506 .176 .342 r
.6419 .8155 m .63911 .82537 L .61656 .8305 L p F P
0 g
s
.518 .158 .296 r
.59312 .83457 m .61656 .8305 L .61104 .84484 L p F P
0 g
s
.518 .158 .296 r
.58862 .84591 m .59312 .83457 L p .61104 .84484 L F P
0 g
s
.556 .196 .312 r
.59312 .83457 m .58862 .84591 L .56707 .84177 L p F P
0 g
s
.301 .216 .59 r
.79329 .59224 m .79019 .59599 L .79351 .61782 L p F P
0 g
s
.944 .686 .516 r
.24951 .64292 m .26259 .65537 L .26129 .67497 L p F P
0 g
s
.937 .705 .562 r
.26259 .65537 m .24951 .64292 L .25256 .62289 L p F P
0 g
s
.606 .381 .548 r
.6916 .54441 m .69054 .52072 L .71403 .51577 L p F P
0 g
s
.649 .413 .548 r
.69054 .52072 m .6916 .54441 L .66629 .54715 L p F P
0 g
s
.88 .603 .514 r
.56082 .48045 m .54239 .46938 L .54226 .44616 L p F P
0 g
s
.923 .643 .492 r
.52731 .43368 m .54226 .44616 L .54239 .46938 L p F P
0 g
s
.73 .846 .936 r
.41937 .31402 m .42779 .31986 L .44877 .30907 L p F P
0 g
s
.435 .541 .865 r
.68693 .3602 m .70936 .36519 L p .71597 .38386 L F P
0 g
s
.416 .554 .885 r
.69871 .34725 m .70936 .36519 L .68693 .3602 L p F P
0 g
s
.416 .554 .885 r
.67864 .34288 m .69871 .34725 L p .68693 .3602 L F P
0 g
s
.416 .554 .885 r
.68693 .3602 m .68027 .34907 L .67864 .34288 L p F P
0 g
s
.435 .125 .339 r
.6635 .80929 m .6648 .80387 L .68562 .79666 L p F P
0 g
s
.735 .481 .545 r
.63862 .54694 m .61374 .54416 L .61317 .52047 L p F P
0 g
s
.761 .503 .542 r
.60735 .51938 m .61317 .52047 L .61374 .54416 L p F P
0 g
s
.762 .39 .35 r
.42469 .83049 m .40138 .82508 L .39427 .81407 L p F P
0 g
s
.778 .391 .323 r
.40138 .82508 m .3872 .82112 L .39427 .81407 L closepath p F P
0 g
s
.833 .478 .384 r
.35589 .79651 m .34381 .7917 L .33721 .77379 L p F P
0 g
s
.852 .487 .36 r
.31707 .76437 m .33721 .77379 L .34381 .7917 L p F P
0 g
s
.857 .523 .418 r
.33721 .77379 m .31707 .76437 L .31669 .76284 L p F P
0 g
s
.541 .701 .943 r
.6107 .3099 m .5891 .3118 L .57801 .29876 L p F P
0 g
s
.58 .717 .937 r
.55655 .3022 m .57801 .29876 L .5891 .3118 L p F P
0 g
s
.552 .175 .28 r
.56245 .85152 m .56707 .84177 L .58862 .84591 L p F P
0 g
s
.589 .213 .298 r
.56707 .84177 m .56245 .85152 L .53653 .85312 L p F P
0 g
s
.325 .329 .711 r
.7871 .50836 m .78332 .50479 L .785 .50129 L closepath p F P
0 g
s
.36 .37 .736 r
.77561 .47234 m .77486 .47179 L p .78332 .50479 L F P
0 g
s
.36 .37 .736 r
.78332 .50479 m .785 .50129 L .77561 .47234 L p F P
0 g
s
.304 .163 .518 r
.78447 .65021 m .78053 .65387 L .78184 .67348 L p F P
0 g
s
.761 .503 .542 r
.61374 .54416 m .60789 .54308 L .60735 .51938 L p F P
0 g
s
.788 .525 .538 r
.58423 .51323 m .60735 .51938 L .60789 .54308 L p F P
0 g
s
.621 .248 .314 r
.53653 .85312 m .52707 .85328 L .51328 .84612 L p F P
0 g
s
.624 .234 .283 r
.52707 .85328 m .50908 .85318 L .51328 .84612 L closepath p F P
0 g
s
.375 .158 .45 r
.74177 .73855 m .74748 .73518 L .74792 .72408 L closepath p F P
0 g
s
.957 .73 .552 r
.2411 .60965 m .25256 .62289 L .24951 .64292 L p F P
0 g
s
.948 .745 .596 r
.25256 .62289 m .2411 .60965 L .24588 .58917 L p F P
0 g
s
.377 .105 .369 r
.70652 .7833 m .72593 .76357 L .70825 .77209 L closepath p F P
0 g
s
.409 .161 .424 r
.70825 .77209 m .72593 .76357 L .72767 .76136 L p F P
0 g
s
.422 .143 .382 r
.70652 .7833 m .70825 .77209 L p .68562 .79666 L F P
0 g
s
.495 .652 .929 r
.62922 .32422 m .64342 .32444 L .63258 .30992 L p F P
0 g
s
.495 .652 .929 r
.63258 .30992 m .61833 .30975 L .62922 .32422 L p F P
0 g
s
.513 .661 .928 r
.6107 .3099 m .61833 .30975 L .62922 .32422 L p F P
0 g
s
.408 .518 .858 r
.72 .38503 m .71597 .38386 L .71557 .37664 L closepath p F P
0 g
s
.435 .541 .865 r
.70936 .36519 m .71557 .37664 L .71597 .38386 L p F P
0 g
s
.715 .323 .303 r
.44853 .84797 m .44543 .84748 L .4301 .83156 L p F P
0 g
s
.726 .316 .27 r
.42469 .83049 m .4301 .83156 L .44543 .84748 L p F P
0 g
s
.672 .805 .946 r
.46983 .29971 m .49099 .29178 L .50268 .30193 L p F P
0 g
s
.842 .569 .527 r
.57046 .50808 m .56107 .50392 L .56082 .48045 L p F P
0 g
s
.88 .603 .514 r
.54239 .46938 m .56082 .48045 L .56107 .50392 L p F P
0 g
s
.958 .825 .669 r
.25092 .53271 m .24331 .51753 L p .2351 .54048 L F P
0 g
s
.958 .825 .669 r
.2351 .54048 m .24818 .53944 L .25092 .53271 L p F P
0 g
s
.943 .828 .7 r
.25092 .53271 m .24331 .51753 L .25395 .49536 L p F P
0 g
s
.301 .216 .59 r
.79351 .61782 m .80021 .60983 L .79329 .59224 L p F P
0 g
s
.267 .198 .59 r
.80377 .57787 m .79329 .59224 L .80021 .60983 L p F P
0 g
s
.309 .252 .63 r
.79947 .5563 m .80377 .57787 L .79329 .59224 L p F P
0 g
s
.309 .252 .63 r
.79866 .55493 m .79947 .5563 L p .79329 .59224 L F P
0 g
s
.939 .867 .741 r
.26715 .47239 m .26226 .45585 L p .25144 .48832 L F P
0 g
s
.939 .867 .741 r
.25144 .48832 m .25758 .48873 L .26715 .47239 L p F P
0 g
s
.922 .863 .764 r
.26617 .44989 m .26226 .45585 L .26715 .47239 L p F P
0 g
s
.476 .118 .278 r
.61104 .84484 m .61656 .8305 L .63911 .82537 L p F P
0 g
s
.726 .316 .27 r
.41422 .84084 m .42469 .83049 L p .44543 .84748 L F P
0 g
s
.749 .346 .289 r
.41422 .84084 m .40138 .82508 L .42469 .83049 L closepath p F P
0 g
s
.334 .37 .75 r
.77561 .47234 m .77486 .47179 L .77514 .471 L closepath p F P
0 g
s
.794 .415 .338 r
.3872 .82112 m .37578 .81757 L .36615 .80031 L p F P
0 g
s
.811 .418 .308 r
.35589 .79651 m .36615 .80031 L .37578 .81757 L p F P
0 g
s
.274 .296 .702 r
.785 .50129 m .79101 .48561 L p .79734 .51953 L F P
0 g
s
.274 .296 .702 r
.79734 .51953 m .7871 .50836 L .785 .50129 L p F P
0 g
s
.306 .304 .693 r
.79274 .52872 m .7871 .50836 L .79734 .51953 L closepath p F P
0 g
s
.57 .741 .957 r
.57801 .29876 m .55655 .3022 L .54523 .29055 L p F P
0 g
s
.609 .756 .949 r
.52388 .29552 m .54523 .29055 L .55655 .3022 L p F P
0 g
s
.376 .445 .804 r
.74139 .41117 m .75368 .41694 L p .76088 .44056 L F P
0 g
s
.351 .45 .822 r
.74139 .41117 m .75368 .41694 L .74292 .39374 L p F P
0 g
s
.351 .45 .822 r
.74292 .39374 m .7422 .3934 L .74139 .41117 L p F P
0 g
s
.384 .481 .835 r
.72 .38503 m .7422 .3934 L .74139 .41117 L p F P
0 g
s
.557 .343 .545 r
.71525 .53948 m .71403 .51577 L .73593 .50857 L p F P
0 g
s
.606 .381 .548 r
.71403 .51577 m .71525 .53948 L .6916 .54441 L p F P
0 g
s
.304 .163 .518 r
.78184 .67348 m .78579 .66984 L .78447 .65021 L p F P
0 g
s
.27 .138 .51 r
.79588 .63856 m .78447 .65021 L .78579 .66984 L p F P
0 g
s
.311 .197 .558 r
.78447 .65021 m .79588 .63856 L .79351 .61782 L p F P
0 g
s
.359 .489 .854 r
.7422 .3934 m .72 .38503 L .71557 .37664 L p F P
0 g
s
.342 .41 .787 r
.76453 .4427 m .76088 .44056 L .7618 .43596 L closepath p F P
0 g
s
.376 .445 .804 r
.75368 .41694 m .7618 .43596 L .76088 .44056 L p F P
0 g
s
.701 .841 .95 r
.46983 .29971 m .44877 .30907 L .43663 .30045 L p F P
0 g
s
.73 .846 .936 r
.44877 .30907 m .43663 .30045 L p .41937 .31402 L F P
0 g
s
.959 .816 .658 r
.24257 .55415 m .2351 .54048 L .24818 .53944 L closepath p F P
0 g
s
.435 .125 .339 r
.68562 .79666 m .68508 .79898 L .6635 .80929 L p F P
0 g
s
.416 .094 .31 r
.66081 .81917 m .6635 .80929 L .68508 .79898 L p F P
0 g
s
.463 .137 .327 r
.6635 .80929 m .66081 .81917 L .63911 .82537 L p F P
0 g
s
.967 .771 .588 r
.23606 .57511 m .24588 .58917 L .2411 .60965 L p F P
0 g
s
.955 .782 .628 r
.24588 .58917 m .23606 .57511 L .24257 .55415 L p F P
0 g
s
.338 .096 .393 r
.74177 .73855 m .74748 .73518 L p .72752 .76277 L F P
0 g
s
.338 .096 .393 r
.72752 .76277 m .72767 .76136 L .74177 .73855 L p F P
0 g
s
.266 .256 .661 r
.79734 .51953 m .79274 .52872 L .79904 .5543 L p F P
0 g
s
.317 .29 .67 r
.79866 .55493 m .79904 .5543 L .79274 .52872 L p F P
0 g
s
.069 0 .449 r
.79902 .36015 m .79681 .36408 L .79855 .38686 L p F P
0 g
s
.442 .573 .89 r
.68027 .34907 m .67625 .34248 L .67864 .34288 L closepath p F P
0 g
s
.841 .897 .879 r
.32648 .37169 m .33109 .37346 L .35227 .35491 L p F P
0 g
s
.857 .892 .861 r
.32577 .37855 m .32648 .37169 L .33109 .37346 L closepath p F P
0 g
s
.788 .525 .538 r
.60789 .54308 m .58463 .53695 L .58423 .51323 L p F P
0 g
s
.822 .553 .532 r
.57046 .50808 m .58423 .51323 L .58463 .53695 L p F P
0 g
s
.871 .903 .852 r
.32577 .37855 m .32648 .37169 L p .29966 .39199 L F P
0 g
s
.871 .903 .852 r
.29966 .39199 m .30975 .39489 L .32577 .37855 L p F P
0 g
s
.261 .161 .547 r
.80021 .60983 m .79351 .61782 L .79588 .63856 L p F P
0 g
s
.431 .249 .532 r
.75629 .49908 m .75481 .47559 L .77354 .46371 L p F P
0 g
s
.498 .299 .54 r
.75481 .47559 m .75629 .49908 L .73593 .50857 L p F P
0 g
s
.821 .901 .897 r
.36177 .34737 m .35227 .35491 L .33922 .34967 L p F P
0 g
s
.841 .897 .879 r
.35227 .35491 m .33922 .34967 L p .32648 .37169 L F P
0 g
s
.943 .857 .727 r
.25395 .49536 m .25144 .48832 L .25758 .48873 L closepath p F P
0 g
s
.389 .085 .324 r
.68508 .79898 m .69314 .79358 L .68562 .79666 L closepath p F P
0 g
s
.422 .143 .382 r
.68562 .79666 m .69314 .79358 L .70652 .7833 L p F P
0 g
s
.29 .377 .78 r
.7797 .45323 m .76453 .4427 L .7618 .43596 L p F P
0 g
s
.884 .895 .834 r
.29967 .40606 m .29966 .39199 L .30975 .39489 L closepath p F P
0 g
s
.811 .418 .308 r
.34851 .80134 m .35589 .79651 L p .37578 .81757 L F P
0 g
s
.824 .44 .325 r
.34851 .80134 m .34381 .7917 L .35589 .79651 L closepath p F P
0 g
s
.821 .901 .897 r
.36633 .3352 m .36177 .34737 L p .33922 .34967 L F P
0 g
s
.81 .888 .901 r
.36177 .34737 m .36633 .3352 L .37337 .3386 L closepath p F P
0 g
s
.7766 .45347 m
.78093 .45429 L
s
0 0 .198 r
.80453 .27942 m .80398 .2874 L .80577 .30971 L p F P
0 g
s
0 0 .286 r
.80375 .32075 m .80577 .30971 L .80398 .2874 L p F P
0 g
s
.359 .489 .854 r
.71557 .37664 m .71432 .36669 L p .7422 .3934 L F P
0 g
s
.392 .516 .863 r
.71557 .37664 m .70936 .36519 L .71432 .36669 L closepath p F P
0 g
s
.907 .594 .442 r
.29503 .73565 m .27865 .72472 L .27646 .70587 L p F P
0 g
s
.928 .611 .421 r
.26169 .69422 m .27646 .70587 L .27865 .72472 L p F P
0 g
s
.927 .64 .479 r
.27646 .70587 m .26169 .69422 L .26129 .67497 L p F P
0 g
s
.885 .548 .406 r
.31554 .76353 m .29905 .75414 L .29503 .73565 L p F P
0 g
s
.905 .561 .383 r
.27865 .72472 m .29503 .73565 L .29905 .75414 L p F P
0 g
s
.9 .905 .819 r
.29967 .40606 m .29966 .39199 L p .27786 .41806 L F P
0 g
s
.9 .905 .819 r
.27786 .41806 m .28817 .41983 L .29967 .40606 L p F P
0 g
s
.788 .89 .918 r
.36633 .3352 m .37337 .3386 L .39444 .32427 L p F P
0 g
s
.29 .377 .78 r
.7618 .43596 m .76345 .42246 L p .7797 .45323 L F P
0 g
s
.33 .416 .799 r
.7618 .43596 m .75368 .41694 L .76345 .42246 L closepath p F P
0 g
s
.429 .073 .258 r
.63377 .83971 m .63911 .82537 L .66081 .81917 L p F P
0 g
s
.476 .118 .278 r
.63911 .82537 m .63377 .83971 L .61104 .84484 L p F P
0 g
s
.272 .078 .425 r
.78224 .69216 m .76556 .70544 L .76496 .72319 L p F P
0 g
s
.314 .141 .48 r
.78184 .67348 m .78224 .69216 L .76556 .70544 L p F P
0 g
s
.326 .119 .438 r
.76556 .70544 m .76496 .72319 L .74748 .73518 L p F P
0 g
s
.878 .536 .397 r
.31707 .76437 m .31554 .76353 L .31669 .76284 L closepath p F P
0 g
s
.761 .341 .253 r
.40138 .82508 m .41422 .84084 L .41369 .84122 L p F P
0 g
s
.761 .341 .253 r
.3872 .82112 m .40138 .82508 L p .41369 .84122 L F P
0 g
s
.283 .052 .377 r
.74584 .75203 m .74748 .73518 L .76496 .72319 L p F P
0 g
s
.338 .096 .393 r
.74748 .73518 m .74584 .75203 L .72752 .76277 L p F P
0 g
s
.467 .611 .91 r
.64342 .32444 m .66554 .32642 L .67625 .34248 L p F P
0 g
s
.448 .629 .93 r
.66554 .32642 m .64342 .32444 L .63258 .30992 L p F P
0 g
s
.958 .857 .698 r
.25144 .48832 m .25395 .49536 L .24331 .51753 L p F P
0 g
s
.948 .661 .46 r
.24814 .66258 m .26129 .67497 L .26169 .69422 L p F P
0 g
s
.944 .686 .516 r
.26129 .67497 m .24814 .66258 L .24951 .64292 L p F P
0 g
s
0 0 .394 r
.80554 .34331 m .79902 .36015 L .80078 .38294 L p F P
0 g
s
0 0 .394 r
.79902 .36015 m .80554 .34331 L .80375 .32075 L p F P
0 g
s
.069 0 .449 r
.79855 .38686 m .80078 .38294 L .79902 .36015 L p F P
0 g
s
.275 .238 .634 r
.79947 .5563 m .79866 .55493 L .79904 .5543 L closepath p F P
0 g
s
.684 .441 .548 r
.65474 .54738 m .66629 .54715 L .66721 .57112 L p F P
0 g
s
.684 .441 .548 r
.66721 .57112 m .65558 .57136 L .65474 .54738 L p F P
0 g
s
.703 .455 .547 r
.63862 .54694 m .65474 .54738 L .65558 .57136 L p F P
0 g
s
.363 .048 .291 r
.6817 .81187 m .68508 .79898 L .69314 .79358 L p F P
0 g
s
.416 .094 .31 r
.68508 .79898 m .6817 .81187 L .66081 .81917 L p F P
0 g
s
.649 .413 .548 r
.66721 .57112 m .66629 .54715 L .6916 .54441 L p F P
0 g
s
.852 .487 .36 r
.34381 .7917 m .32358 .78231 L .31707 .76437 L p F P
0 g
s
.871 .495 .33 r
.31554 .76353 m .31707 .76437 L .32358 .78231 L p F P
0 g
s
.703 .455 .547 r
.65558 .57136 m .63937 .57092 L .63862 .54694 L p F P
0 g
s
.735 .481 .545 r
.61374 .54416 m .63862 .54694 L .63937 .57092 L p F P
0 g
s
.422 .587 .91 r
.67864 .34288 m .67625 .34248 L .66554 .32642 L p F P
0 g
s
.219 .199 .623 r
.79904 .5543 m .80868 .5354 L p .80757 .57175 L F P
0 g
s
.219 .199 .623 r
.80757 .57175 m .79947 .5563 L .79904 .5543 L p F P
0 g
s
.266 .256 .661 r
.79904 .5543 m .80868 .5354 L .79734 .51953 L p F P
0 g
s
.966 .687 .452 r
.52731 .43368 m .51576 .41982 L .51579 .39678 L p F P
0 g
s
.989 .723 .376 r
.50773 .38142 m .51579 .39678 L .51576 .41982 L p F P
0 g
s
.989 .723 .376 r
.51579 .39678 m .50773 .38142 L .50781 .35862 L p F P
0 g
s
.972 .809 .621 r
.2351 .54048 m .24257 .55415 L .23606 .57511 L p F P
0 g
s
.499 .681 .947 r
.61833 .30975 m .6107 .3099 L .59969 .29678 L p F P
0 g
s
.541 .701 .943 r
.57801 .29876 m .59969 .29678 L .6107 .3099 L p F P
0 g
s
.389 .137 .407 r
.72593 .76357 m .72752 .76277 L .72767 .76136 L closepath p F P
0 g
s
.667 .833 .963 r
.49099 .29178 m .46983 .29971 L .45782 .29099 L p F P
0 g
s
.701 .841 .95 r
.43663 .30045 m .45782 .29099 L .46983 .29971 L p F P
0 g
s
.734 .857 .938 r
.41551 .31152 m .4287 .30454 L .41937 .31402 L closepath p F P
0 g
s
.73 .846 .936 r
.43663 .30045 m .4287 .30454 L .41937 .31402 L p F P
0 g
s
.762 .859 .922 r
.39444 .32427 m .41551 .31152 L .41937 .31402 L p F P
0 g
s
.91 .896 .802 r
.27907 .43161 m .27786 .41806 L .28817 .41983 L closepath p F P
0 g
s
.259 .218 .621 r
.80377 .57787 m .79947 .5563 L .80757 .57175 L closepath p F P
0 g
s
.363 .048 .291 r
.69314 .79358 m .70562 .78831 L p .6817 .81187 L F P
0 g
s
.403 .116 .359 r
.69314 .79358 m .70562 .78831 L .70652 .7833 L closepath p F P
0 g
s
.351 .072 .343 r
.72593 .76357 m .72752 .76277 L p .70562 .78831 L F P
0 g
s
.351 .072 .343 r
.70562 .78831 m .70652 .7833 L .72593 .76357 L p F P
0 g
s
.923 .643 .492 r
.54239 .46938 m .52735 .45696 L .52731 .43368 L p F P
0 g
s
.966 .687 .452 r
.51576 .41982 m .52731 .43368 L .52735 .45696 L p F P
0 g
s
.871 .495 .33 r
.30303 .7666 m .31554 .76353 L p .32358 .78231 L F P
0 g
s
.879 .512 .346 r
.30303 .7666 m .29905 .75414 L .31554 .76353 L closepath p F P
0 g
s
.498 .299 .54 r
.73729 .53231 m .73593 .50857 L .75629 .49908 L p F P
0 g
s
.557 .343 .545 r
.73593 .50857 m .73729 .53231 L .71525 .53948 L p F P
0 g
s
.942 .715 .244 r
.50326 .34169 m .50781 .35862 L .50773 .38142 L p F P
0 g
s
.942 .715 .244 r
.50781 .35862 m .50326 .34169 L .50337 .31912 L p F P
0 g
s
.263 .103 .468 r
.78579 .66984 m .78184 .67348 L .78224 .69216 L p F P
0 g
s
.599 .197 .252 r
.53455 .85631 m .52707 .85328 L .53653 .85312 L closepath p F P
0 g
s
.598 .175 .21 r
.52707 .85328 m .53455 .85631 L .52786 .86531 L p F P
0 g
s
.598 .175 .21 r
.50908 .85318 m .52707 .85328 L p .52786 .86531 L F P
0 g
s
.598 .175 .21 r
.50156 .863 m .50908 .85318 L p .52786 .86531 L F P
0 g
s
.633 .216 .234 r
.50156 .863 m .4813 .85183 L .50908 .85318 L closepath p F P
0 g
s
.656 .269 .301 r
.50908 .85318 m .4813 .85183 L .48043 .85123 L p F P
0 g
s
0 0 .286 r
.80577 .30971 m .80375 .32075 L .80554 .34331 L p F P
0 g
s
.562 .157 .231 r
.53455 .85631 m .53653 .85312 L .56245 .85152 L p F P
0 g
s
.822 .553 .532 r
.58463 .53695 m .57077 .53183 L .57046 .50808 L p F P
0 g
s
.842 .569 .527 r
.56107 .50392 m .57046 .50808 L .57077 .53183 L p F P
0 g
s
.965 .709 .5 r
.23797 .62974 m .24951 .64292 L .24814 .66258 L p F P
0 g
s
.957 .73 .552 r
.24951 .64292 m .23797 .62974 L .2411 .60965 L p F P
0 g
s
.391 .567 .906 r
.67864 .34288 m .69871 .34725 L .68805 .33094 L p F P
0 g
s
.391 .567 .906 r
.68805 .33094 m .67113 .32733 L .67864 .34288 L p F P
0 g
s
.422 .587 .91 r
.66554 .32642 m .67113 .32733 L .67864 .34288 L p F P
0 g
s
.294 .026 .325 r
.7248 .77876 m .72752 .76277 L .74584 .75203 L p F P
0 g
s
.351 .072 .343 r
.72752 .76277 m .7248 .77876 L .70562 .78831 L p F P
0 g
s
.762 .89 .935 r
.41551 .31152 m .39444 .32427 L .38175 .31793 L p F P
0 g
s
.788 .89 .918 r
.39444 .32427 m .38175 .31793 L p .36633 .3352 L F P
0 g
s
.662 .256 .266 r
.4813 .85183 m .48005 .85173 L .48043 .85123 L closepath p F P
0 g
s
.691 .292 .286 r
.48043 .85123 m .48005 .85173 L .44853 .84797 L p F P
0 g
s
.518 .158 .296 r
.61104 .84484 m .60217 .84637 L .58862 .84591 L p F P
0 g
s
.509 .132 .26 r
.60217 .84637 m .5873 .84879 L .58862 .84591 L closepath p F P
0 g
s
.552 .175 .28 r
.58862 .84591 m .5873 .84879 L .56245 .85152 L p F P
0 g
s
.606 .381 .548 r
.69268 .56841 m .6916 .54441 L .71525 .53948 L p F P
0 g
s
.649 .413 .548 r
.6916 .54441 m .69268 .56841 L .66721 .57112 L p F P
0 g
s
.88 .603 .514 r
.56107 .50392 m .54253 .49289 L .54239 .46938 L p F P
0 g
s
.923 .643 .492 r
.52735 .45696 m .54239 .46938 L .54253 .49289 L p F P
0 g
s
.854 .91 .871 r
.31782 .36904 m .32943 .35824 L .32648 .37169 L closepath p F P
0 g
s
.841 .897 .879 r
.33922 .34967 m .32943 .35824 L .32648 .37169 L p F P
0 g
s
.871 .903 .852 r
.32648 .37169 m .31782 .36904 L p .29966 .39199 L F P
0 g
s
.78 .625 .063 r
.50293 .31123 m .50337 .31912 L .50326 .34169 L p F P
0 g
s
.634 .195 .189 r
.4813 .85183 m .50156 .863 L p .46943 .8626 L F P
0 g
s
.634 .195 .189 r
.46943 .8626 m .48005 .85173 L .4813 .85183 L p F P
0 g
s
.926 .903 .782 r
.27907 .43161 m .27786 .41806 L p .26125 .44974 L F P
0 g
s
.926 .903 .782 r
.26125 .44974 m .26617 .44989 L .27907 .43161 L p F P
0 g
s
.735 .481 .545 r
.63937 .57092 m .61433 .56815 L .61374 .54416 L p F P
0 g
s
.761 .503 .542 r
.60789 .54308 m .61374 .54416 L .61433 .56815 L p F P
0 g
s
.841 .444 .293 r
.34381 .7917 m .34851 .80134 L .34098 .80401 L p F P
0 g
s
.841 .444 .293 r
.32358 .78231 m .34381 .7917 L p .34098 .80401 L F P
0 g
s
.668 .237 .215 r
.44853 .84797 m .48005 .85173 L .46943 .8626 L p F P
0 g
s
.521 .112 .207 r
.56245 .85152 m .5873 .84879 L .57976 .86163 L p F P
0 g
s
.521 .112 .207 r
.55608 .86206 m .56245 .85152 L p .57976 .86163 L F P
0 g
s
.562 .157 .231 r
.56245 .85152 m .55608 .86206 L .53455 .85631 L p F P
0 g
s
.299 .418 .815 r
.76345 .42246 m .75368 .41694 L .74292 .39374 L p F P
0 g
s
.761 .341 .253 r
.3812 .82527 m .3872 .82112 L p .41369 .84122 L F P
0 g
s
.781 .371 .274 r
.3812 .82527 m .37578 .81757 L .3872 .82112 L closepath p F P
0 g
s
.527 .723 .963 r
.57801 .29876 m .59969 .29678 L .59554 .29238 L p F P
0 g
s
.57 .741 .957 r
.54523 .29055 m .56679 .28704 L .57801 .29876 L p F P
0 g
s
.367 .526 .882 r
.71432 .36669 m .70936 .36519 L .69871 .34725 L p F P
0 g
s
.761 .503 .542 r
.61433 .56815 m .60844 .56708 L .60789 .54308 L p F P
0 g
s
.788 .525 .538 r
.58463 .53695 m .60789 .54308 L .60844 .56708 L p F P
0 g
s
.477 .673 .95 r
.62166 .29686 m .60297 .29671 L .61833 .30975 L p F P
0 g
s
.499 .681 .947 r
.59969 .29678 m .60297 .29671 L .61833 .30975 L p F P
0 g
s
0 0 .198 r
.80577 .30971 m .80633 .30176 L .80453 .27942 L p F P
0 g
s
.774 .572 .001 r
.8021 .2619 m .80453 .27942 L .80633 .30176 L p F P
0 g
s
.261 .161 .547 r
.79588 .63856 m .80441 .62849 L .80021 .60983 L p F P
0 g
s
.219 .135 .542 r
.80739 .6001 m .80021 .60983 L .80441 .62849 L p F P
0 g
s
.267 .198 .59 r
.80021 .60983 m .80739 .6001 L .80377 .57787 L p F P
0 g
s
.263 .103 .468 r
.78224 .69216 m .78395 .69061 L .78579 .66984 L p F P
0 g
s
.22 .069 .452 r
.79727 .65824 m .78579 .66984 L .78395 .69061 L p F P
0 g
s
.27 .138 .51 r
.78579 .66984 m .79727 .65824 L .79588 .63856 L p F P
0 g
s
.226 .241 .668 r
.80293 .50527 m .79734 .51953 L .80868 .5354 L p F P
0 g
s
.274 .296 .702 r
.79996 .49525 m .80293 .50527 L .79734 .51953 L p F P
0 g
s
.976 .755 .538 r
.2312 .59566 m .2411 .60965 L .23797 .62974 L p F P
0 g
s
.967 .771 .588 r
.2411 .60965 m .2312 .59566 L .23606 .57511 L p F P
0 g
s
.842 .569 .527 r
.57077 .53183 m .56133 .52769 L .56107 .50392 L p F P
0 g
s
.88 .603 .514 r
.54253 .49289 m .56107 .50392 L .56133 .52769 L p F P
0 g
s
.376 .025 .236 r
.65564 .8335 m .66081 .81917 L .6817 .81187 L p F P
0 g
s
.429 .073 .258 r
.66081 .81917 m .65564 .8335 L .63377 .83971 L p F P
0 g
s
.731 .887 .952 r
.4287 .30454 m .41551 .31152 L .40298 .30506 L p F P
0 g
s
.762 .89 .935 r
.38175 .31793 m .40298 .30506 L .41551 .31152 L p F P
0 g
s
.939 .867 .741 r
.26226 .45585 m .24862 .47905 L .25144 .48832 L p F P
0 g
s
.955 .868 .712 r
.24338 .48921 m .24862 .47905 L .25144 .48832 L closepath p F P
0 g
s
.958 .857 .698 r
.24338 .48921 m .25144 .48832 L p .24331 .51753 L F P
0 g
s
.213 .097 .496 r
.80441 .62849 m .79588 .63856 L .79727 .65824 L p F P
0 g
s
.556 .128 .184 r
.52786 .86531 m .53455 .85631 L .55608 .86206 L p F P
0 g
s
.473 .063 .181 r
.57976 .86163 m .5873 .84879 L .60217 .84637 L p F P
0 g
s
.213 .16 .578 r
.80757 .57175 m .80377 .57787 L .80739 .6001 L p F P
0 g
s
.306 0 .27 r
.70178 .80346 m .70562 .78831 L .7248 .77876 L p F P
0 g
s
.363 .048 .291 r
.70562 .78831 m .70178 .80346 L .6817 .81187 L p F P
0 g
s
.934 .892 .765 r
.26226 .45585 m .26125 .44974 L .26617 .44989 L closepath p F P
0 g
s
.958 .825 .669 r
.24331 .51753 m .23445 .53921 L .2351 .54048 L p F P
0 g
s
.973 .854 .663 r
.23746 .50148 m .24331 .51753 L .23445 .53921 L p F P
0 g
s
.958 .857 .698 r
.24331 .51753 m .23746 .50148 L .24338 .48921 L p F P
0 g
s
.668 .237 .215 r
.44736 .84912 m .44853 .84797 L p .46943 .8626 L F P
0 g
s
.697 .274 .238 r
.44736 .84912 m .44543 .84748 L .44853 .84797 L closepath p F P
0 g
s
.359 .489 .854 r
.71432 .36669 m .73227 .37336 L p .7422 .3934 L F P
0 g
s
.367 .526 .882 r
.69871 .34725 m .70939 .35042 L .71432 .36669 L p F P
0 g
s
.557 .343 .545 r
.71648 .56349 m .71525 .53948 L .73729 .53231 L p F P
0 g
s
.606 .381 .548 r
.71525 .53948 m .71648 .56349 L .69268 .56841 L p F P
0 g
s
.667 .833 .963 r
.45782 .29099 m .47911 .28297 L .49099 .29178 L p F P
0 g
s
.794 .368 .235 r
.37578 .81757 m .3812 .82527 L .37267 .82898 L p F P
0 g
s
.794 .368 .235 r
.35281 .80914 m .37578 .81757 L p .37267 .82898 L F P
0 g
s
.811 .418 .308 r
.37578 .81757 m .35281 .80914 L .34851 .80134 L p F P
0 g
s
.704 .26 .195 r
.44543 .84748 m .44736 .84912 L .4362 .85755 L p F P
0 g
s
.704 .26 .195 r
.41486 .8415 m .44543 .84748 L p .4362 .85755 L F P
0 g
s
.726 .316 .27 r
.44543 .84748 m .41486 .8415 L .41422 .84084 L p F P
0 g
s
.353 .193 .52 r
.78088 .45763 m .77354 .46371 L .77514 .48725 L p F P
0 g
s
.431 .249 .532 r
.77354 .46371 m .77514 .48725 L .75629 .49908 L p F P
0 g
s
.95 .897 .739 r
.26125 .44974 m .26226 .45585 L .24862 .47905 L p F P
0 g
s
.798 .904 .916 r
.36051 .33276 m .37246 .32426 L .36633 .3352 L closepath p F P
0 g
s
.788 .89 .918 r
.38175 .31793 m .37246 .32426 L .36633 .3352 L p F P
0 g
s
.821 .901 .897 r
.33922 .34967 m .36051 .33276 L .36633 .3352 L p F P
0 g
s
.557 .765 .975 r
.54523 .29055 m .56679 .28704 L .55638 .27752 L p F P
0 g
s
.731 .887 .952 r
.43479 .29937 m .4287 .30454 L p .40298 .30506 L F P
0 g
s
.728 .874 .949 r
.4287 .30454 m .43479 .29937 L .43663 .30045 L closepath p F P
0 g
s
.473 .063 .181 r
.60217 .84637 m .61034 .84628 L p .57976 .86163 L F P
0 g
s
.488 .099 .228 r
.61034 .84628 m .60217 .84637 L .61104 .84484 L closepath p F P
0 g
s
.972 .809 .621 r
.23386 .54097 m .2351 .54048 L p .23606 .57511 L F P
0 g
s
.972 .809 .621 r
.23606 .57511 m .22782 .56027 L .23386 .54097 L p F P
0 g
s
.984 .797 .575 r
.22782 .56027 m .23606 .57511 L .2312 .59566 L p F P
0 g
s
.069 0 .449 r
.80078 .38294 m .79855 .38686 L .80031 .40993 L p F P
0 g
s
.672 .218 .165 r
.46602 .8622 m .4362 .85755 L .44736 .84912 L closepath p F P
0 g
s
.668 .237 .215 r
.46943 .8626 m .46602 .8622 L .44736 .84912 L p F P
0 g
s
.78 .625 .063 r
.50326 .34169 m .50282 .33382 L .50293 .31123 L p F P
0 g
s
0 0 .048 r
.50356 .30011 m .50293 .31123 L .50282 .33382 L p F P
0 g
s
.788 .525 .538 r
.60844 .56708 m .58503 .56098 L .58463 .53695 L p F P
0 g
s
.822 .553 .532 r
.57077 .53183 m .58463 .53695 L .58503 .56098 L p F P
0 g
s
.431 .249 .532 r
.75778 .52287 m .75629 .49908 L .77514 .48725 L p F P
0 g
s
.498 .299 .54 r
.75629 .49908 m .75778 .52287 L .73729 .53231 L p F P
0 g
s
.319 .456 .841 r
.74292 .39374 m .7422 .3934 L .74204 .39199 L closepath p F P
0 g
s
.359 .489 .854 r
.73227 .37336 m .74204 .39199 L .7422 .3934 L p F P
0 g
s
.905 .561 .383 r
.29905 .75414 m .2826 .74324 L .27865 .72472 L p F P
0 g
s
.924 .575 .353 r
.26382 .71312 m .27865 .72472 L .2826 .74324 L p F P
0 g
s
.928 .611 .421 r
.27865 .72472 m .26382 .71312 L .26169 .69422 L p F P
0 g
s
.828 .419 .271 r
.35281 .80914 m .34098 .80401 L .34851 .80134 L closepath p F P
0 g
s
.29 .377 .78 r
.77738 .43202 m .78123 .44156 L .7797 .45323 L p F P
0 g
s
.29 .377 .78 r
.76345 .42246 m .77738 .43202 L p .7797 .45323 L F P
0 g
s
.948 .629 .394 r
.24847 .68187 m .26169 .69422 L .26382 .71312 L p F P
0 g
s
.948 .661 .46 r
.26169 .69422 m .24847 .68187 L .24814 .66258 L p F P
0 g
s
.441 .053 .206 r
.61034 .84628 m .61104 .84484 L .63377 .83971 L p F P
0 g
s
.299 .418 .815 r
.74292 .39374 m .76319 .40506 L .76345 .42246 L p F P
0 g
s
.26 .419 .832 r
.76319 .40506 m .74292 .39374 L .74204 .39199 L p F P
0 g
s
.695 .868 .963 r
.43479 .29937 m .43663 .30045 L .45782 .29099 L p F P
0 g
s
0 0 .198 r
.80633 .30176 m .80577 .30971 L .80758 .33231 L p F P
0 g
s
0 0 .286 r
.80554 .34331 m .80758 .33231 L .80577 .30971 L p F P
0 g
s
.897 .521 .313 r
.29905 .75414 m .30303 .7666 L .29454 .76553 L p F P
0 g
s
.897 .521 .313 r
.2826 .74324 m .29905 .75414 L p .29454 .76553 L F P
0 g
s
.251 .375 .795 r
.76345 .42246 m .77738 .43202 L .76652 .40732 L p F P
0 g
s
.251 .375 .795 r
.76652 .40732 m .76319 .40506 L .76345 .42246 L p F P
0 g
s
.887 .915 .839 r
.29625 .39133 m .30012 .38708 L .29966 .39199 L closepath p F P
0 g
s
.871 .903 .852 r
.31782 .36904 m .30012 .38708 L .29966 .39199 L p F P
0 g
s
.9 .905 .819 r
.29966 .39199 m .29625 .39133 L p .27786 .41806 L F P
0 g
s
.224 .007 .359 r
.77823 .71272 m .76496 .72319 L .76343 .74006 L p F P
0 g
s
.283 .052 .377 r
.76496 .72319 m .76343 .74006 L .74584 .75203 L p F P
0 g
s
.272 .078 .425 r
.78206 .69881 m .78224 .69216 L p .76496 .72319 L F P
0 g
s
.272 .078 .425 r
.76496 .72319 m .77823 .71272 L .78206 .69881 L p F P
0 g
s
.398 .601 .929 r
.67113 .32733 m .66554 .32642 L .65477 .31182 L p F P
0 g
s
.448 .629 .93 r
.63258 .30992 m .65477 .31182 L .66554 .32642 L p F P
0 g
s
.968 .682 .436 r
.23653 .64946 m .24814 .66258 L .24847 .68187 L p F P
0 g
s
.965 .709 .5 r
.24814 .66258 m .23653 .64946 L .23797 .62974 L p F P
0 g
s
.213 .16 .578 r
.80739 .6001 m .81402 .58959 L .80757 .57175 L p F P
0 g
s
.162 .132 .574 r
.81544 .55657 m .80757 .57175 L .81402 .58959 L p F P
0 g
s
.219 .199 .623 r
.81241 .54241 m .81544 .55657 L .80757 .57175 L p F P
0 g
s
.219 .199 .623 r
.80868 .5354 m .81241 .54241 L p .80757 .57175 L F P
0 g
s
.441 .053 .206 r
.63377 .83971 m .63217 .84307 L .61034 .84628 L p F P
0 g
s
.418 .008 .153 r
.60378 .85775 m .61034 .84628 L .63217 .84307 L p F P
0 g
s
.473 .063 .181 r
.61034 .84628 m .60378 .85775 L .57976 .86163 L p F P
0 g
s
.216 .036 .409 r
.78206 .69881 m .78395 .69061 L .78224 .69216 L closepath p F P
0 g
s
0 0 .394 r
.80735 .36616 m .80078 .38294 L .80255 .40602 L p F P
0 g
s
0 0 .394 r
.80078 .38294 m .80735 .36616 L .80554 .34331 L p F P
0 g
s
.069 0 .449 r
.80031 .40993 m .80255 .40602 L .80078 .38294 L p F P
0 g
s
.684 .441 .548 r
.65558 .57136 m .66721 .57112 L .66814 .59541 L p F P
0 g
s
.684 .441 .548 r
.66814 .59541 m .65644 .59564 L .65558 .57136 L p F P
0 g
s
.703 .455 .547 r
.63937 .57092 m .65558 .57136 L .65644 .59564 L p F P
0 g
s
.841 .444 .293 r
.34098 .80401 m .33207 .7999 L .32358 .78231 L p F P
0 g
s
.857 .447 .253 r
.30504 .77225 m .32358 .78231 L .33207 .7999 L p F P
0 g
s
.871 .495 .33 r
.32358 .78231 m .30504 .77225 L .30303 .7666 L p F P
0 g
s
.649 .413 .548 r
.66814 .59541 m .66721 .57112 L .69268 .56841 L p F P
0 g
s
.233 0 .305 r
.76343 .74006 m .74584 .75203 L .74324 .76802 L p F P
0 g
s
.294 .026 .325 r
.74584 .75203 m .74324 .76802 L .7248 .77876 L p F P
0 g
s
.703 .455 .547 r
.65644 .59564 m .64012 .5952 L .63937 .57092 L p F P
0 g
s
.735 .481 .545 r
.61433 .56815 m .63937 .57092 L .64012 .5952 L p F P
0 g
s
.695 .881 .967 r
.42425 .29378 m .43479 .29937 L .45356 .28843 L p F P
0 g
s
.695 .868 .963 r
.45782 .29099 m .45356 .28843 L .43479 .29937 L p F P
0 g
s
.731 .887 .952 r
.40298 .30506 m .42425 .29378 L .43479 .29937 L p F P
0 g
s
.353 .193 .52 r
.77514 .48725 m .78253 .48119 L .78088 .45763 L p F P
0 g
s
.966 .687 .452 r
.52735 .45696 m .51573 .44314 L .51576 .41982 L p F P
0 g
s
.989 .723 .376 r
.50765 .4045 m .51576 .41982 L .51573 .44314 L p F P
0 g
s
.989 .723 .376 r
.51576 .41982 m .50765 .4045 L .50773 .38142 L p F P
0 g
s
.973 .819 .63 r
.23386 .54097 m .23445 .53921 L .2351 .54048 L closepath p F P
0 g
s
.737 .307 .229 r
.41486 .8415 m .41369 .84122 L .41422 .84084 L closepath p F P
0 g
s
.318 0 .212 r
.70178 .80346 m .6817 .81187 L .67668 .8262 L p F P
0 g
s
.376 .025 .236 r
.6817 .81187 m .67668 .8262 L .65564 .8335 L p F P
0 g
s
.944 .91 .756 r
.25192 .45092 m .26011 .43804 L .26125 .44974 L closepath p F P
0 g
s
.926 .903 .782 r
.27436 .41787 m .26011 .43804 L .26125 .44974 L p F P
0 g
s
.926 .903 .782 r
.27786 .41806 m .27436 .41787 L p .26125 .44974 L F P
0 g
s
.95 .897 .739 r
.25192 .45092 m .26125 .44974 L p .24862 .47905 L F P
0 g
s
.48 .701 .966 r
.60297 .29671 m .59554 .29238 L .59969 .29678 L closepath p F P
0 g
s
.923 .643 .492 r
.54253 .49289 m .52739 .48052 L .52735 .45696 L p F P
0 g
s
.966 .687 .452 r
.51573 .44314 m .52735 .45696 L .52739 .48052 L p F P
0 g
s
.498 .299 .54 r
.73867 .55636 m .73729 .53231 L .75778 .52287 L p F P
0 g
s
.557 .343 .545 r
.73729 .53231 m .73867 .55636 L .71648 .56349 L p F P
0 g
s
.942 .715 .244 r
.50314 .36454 m .50773 .38142 L .50765 .4045 L p F P
0 g
s
.942 .715 .244 r
.50773 .38142 m .50314 .36454 L .50326 .34169 L p F P
0 g
s
.761 .341 .253 r
.41369 .84122 m .38841 .83422 L .3812 .82527 L p F P
0 g
s
.774 .334 .208 r
.38841 .83422 m .37267 .82898 L .3812 .82527 L closepath p F P
0 g
s
.158 .092 .526 r
.81402 .58959 m .80739 .6001 L .80995 .62109 L p F P
0 g
s
.219 .135 .542 r
.80441 .62849 m .80995 .62109 L .80739 .6001 L p F P
0 g
s
.163 0 .383 r
.78395 .69061 m .79767 .67687 L p .78163 .70981 L F P
0 g
s
.163 0 .383 r
.78163 .70981 m .78206 .69881 L .78395 .69061 L p F P
0 g
s
.22 .069 .452 r
.78395 .69061 m .79767 .67687 L .79727 .65824 L p F P
0 g
s
.704 .26 .195 r
.4362 .85755 m .43289 .85691 L .41486 .8415 L p F P
0 g
s
.709 .242 .141 r
.41369 .84122 m .41486 .8415 L .43289 .85691 L p F P
0 g
s
.337 .536 .901 r
.70939 .35042 m .69871 .34725 L .68805 .33094 L p F P
0 g
s
0 0 .286 r
.80758 .33231 m .80554 .34331 L .80735 .36616 L p F P
0 g
s
.966 .899 .706 r
.24862 .47905 m .2456 .46163 L p .23524 .49218 L F P
0 g
s
.966 .899 .706 r
.23524 .49218 m .24338 .48921 L .24862 .47905 L p F P
0 g
s
.95 .897 .739 r
.24862 .47905 m .2456 .46163 L .25192 .45092 L p F P
0 g
s
.822 .553 .532 r
.58503 .56098 m .57109 .55588 L .57077 .53183 L p F P
0 g
s
.842 .569 .527 r
.56133 .52769 m .57077 .53183 L .57109 .55588 L p F P
0 g
s
.709 .242 .141 r
.40139 .84735 m .41369 .84122 L p .43289 .85691 L F P
0 g
s
.738 .284 .174 r
.40139 .84735 m .38841 .83422 L .41369 .84122 L closepath p F P
0 g
s
.856 .941 .875 r
.32943 .35824 m .33312 .34807 L p .30475 .36704 L F P
0 g
s
.856 .941 .875 r
.30475 .36704 m .31782 .36904 L .32943 .35824 L p F P
0 g
s
.844 .927 .885 r
.32943 .35824 m .33312 .34807 L .33922 .34967 L closepath p F P
0 g
s
.875 .933 .856 r
.30012 .38708 m .30475 .36704 L .31782 .36904 L closepath p F P
0 g
s
.987 .847 .617 r
.23445 .53921 m .22851 .52326 L p .22326 .54953 L F P
0 g
s
.987 .847 .617 r
.22326 .54953 m .23386 .54097 L .23445 .53921 L p F P
0 g
s
.973 .854 .663 r
.23445 .53921 m .22851 .52326 L .23746 .50148 L p F P
0 g
s
.982 .732 .477 r
.22801 .61582 m .23797 .62974 L .23653 .64946 L p F P
0 g
s
.976 .755 .538 r
.23797 .62974 m .22801 .61582 L .2312 .59566 L p F P
0 g
s
.822 .932 .904 r
.33312 .34807 m .33922 .34967 L .36051 .33276 L p F P
0 g
s
.917 .915 .8 r
.27436 .41787 m .27781 .41337 L .27786 .41806 L closepath p F P
0 g
s
.9 .905 .819 r
.29625 .39133 m .27781 .41337 L .27786 .41806 L p F P
0 g
s
.986 .835 .61 r
.22782 .56027 m .22326 .54953 L .23386 .54097 L closepath p F P
0 g
s
.453 .693 .969 r
.60297 .29671 m .62166 .29686 L p .58857 .28515 L F P
0 g
s
.453 .693 .969 r
.58857 .28515 m .59554 .29238 L .60297 .29671 L p F P
0 g
s
.606 .381 .548 r
.69377 .5927 m .69268 .56841 L .71648 .56349 L p F P
0 g
s
.649 .413 .548 r
.69268 .56841 m .69377 .5927 L .66814 .59541 L p F P
0 g
s
.88 .603 .514 r
.56133 .52769 m .54267 .51671 L .54253 .49289 L p F P
0 g
s
.923 .643 .492 r
.52739 .48052 m .54253 .49289 L .54267 .51671 L p F P
0 g
s
.89 .946 .84 r
.30012 .38708 m .29625 .39133 L .28229 .391 L p F P
0 g
s
.89 .946 .84 r
.30475 .36704 m .30012 .38708 L p .28229 .391 L F P
0 g
s
.78 .625 .063 r
.50282 .33382 m .50326 .34169 L .50314 .36454 L p F P
0 g
s
.735 .481 .545 r
.64012 .5952 m .61493 .59245 L .61433 .56815 L p F P
0 g
s
.761 .503 .542 r
.60844 .56708 m .61433 .56815 L .61493 .59245 L p F P
0 g
s
.213 .097 .496 r
.79727 .65824 m .80585 .64821 L .80441 .62849 L p F P
0 g
s
.161 .06 .482 r
.80995 .62109 m .80441 .62849 L .80585 .64821 L p F P
0 g
s
.905 .936 .821 r
.27781 .41337 m .29625 .39133 L .28229 .391 L p F P
0 g
s
.388 .003 .181 r
.63217 .84307 m .63377 .83971 L .65564 .8335 L p F P
0 g
s
.795 .935 .923 r
.37246 .32426 m .36051 .33276 L .34732 .32911 L p F P
0 g
s
.822 .932 .904 r
.36051 .33276 m .34732 .32911 L p .33312 .34807 L F P
0 g
s
.158 .024 .435 r
.80585 .64821 m .79727 .65824 L .79767 .67687 L p F P
0 g
s
.794 .368 .235 r
.37267 .82898 m .36457 .82603 L .35281 .80914 L p F P
0 g
s
.807 .362 .186 r
.34098 .80401 m .35281 .80914 L .36457 .82603 L p F P
0 g
s
.658 .86 .976 r
.45356 .28843 m .45782 .29099 L .47911 .28297 L p F P
0 g
s
.243 0 .247 r
.74324 .76802 m .7248 .77876 L .72109 .7939 L p F P
0 g
s
.306 0 .27 r
.7248 .77876 m .72109 .7939 L .70178 .80346 L p F P
0 g
s
.761 .503 .542 r
.61493 .59245 m .609 .59138 L .60844 .56708 L p F P
0 g
s
.788 .525 .538 r
.58503 .56098 m .60844 .56708 L .609 .59138 L p F P
0 g
s
.229 .039 .403 r
.77823 .71272 m .78163 .70981 L .78206 .69881 L closepath p F P
0 g
s
.969 .885 .692 r
.23746 .50148 m .23524 .49218 L .24338 .48921 L closepath p F P
0 g
s
.22 .26 .691 r
.80293 .50527 m .79996 .49525 L .80438 .50062 L closepath p F P
0 g
s
0 0 .198 r
.80758 .33231 m .80814 .32438 L .80633 .30176 L p F P
0 g
s
.774 .572 .001 r
.80389 .28428 m .80633 .30176 L .80814 .32438 L p F P
0 g
s
.774 .572 .001 r
.80633 .30176 m .80389 .28428 L .8021 .2619 L p F P
0 g
s
.795 .935 .923 r
.37799 .31654 m .37246 .32426 L p .34732 .32911 L F P
0 g
s
.787 .919 .927 r
.37246 .32426 m .37799 .31654 L .38175 .31793 L closepath p F P
0 g
s
.598 .175 .21 r
.52786 .86531 m .5069 .86519 L .50156 .863 L p F P
0 g
s
.594 .147 .159 r
.5069 .86519 m .49971 .86496 L .50156 .863 L closepath p F P
0 g
s
.634 .195 .189 r
.50156 .863 m .49971 .86496 L .46943 .8626 L p F P
0 g
s
.166 .201 .653 r
.80438 .50062 m .80293 .50527 L .81003 .53203 L p F P
0 g
s
.226 .241 .668 r
.80868 .5354 m .81003 .53203 L .80293 .50527 L p F P
0 g
s
.168 .176 .623 r
.81241 .54241 m .80868 .5354 L .81003 .53203 L closepath p F P
0 g
s
.842 .569 .527 r
.57109 .55588 m .56158 .55176 L .56133 .52769 L p F P
0 g
s
.88 .603 .514 r
.54267 .51671 m .56133 .52769 L .56158 .55176 L p F P
0 g
s
.992 .78 .518 r
.22288 .58089 m .2312 .59566 L .22801 .61582 L p F P
0 g
s
.984 .797 .575 r
.2312 .59566 m .22288 .58089 L .22782 .56027 L p F P
0 g
s
.521 .112 .207 r
.57976 .86163 m .56512 .86323 L .55608 .86206 L p F P
0 g
s
.508 .076 .154 r
.56512 .86323 m .55453 .86421 L .55608 .86206 L closepath p F P
0 g
s
.556 .128 .184 r
.55608 .86206 m .55453 .86421 L .52786 .86531 L p F P
0 g
s
0 0 .048 r
.50282 .33382 m .50345 .32274 L .50356 .30011 L p F P
0 g
s
0 0 .221 r
.50802 .28268 m .50356 .30011 L .50345 .32274 L p F P
0 g
s
.757 .919 .944 r
.37799 .31654 m .38175 .31793 L .40298 .30506 L p F P
0 g
s
.921 .946 .797 r
.27781 .41337 m .28022 .39347 L p .26061 .41974 L F P
0 g
s
.921 .946 .797 r
.26061 .41974 m .27436 .41787 L .27781 .41337 L p F P
0 g
s
.905 .936 .821 r
.28229 .391 m .28022 .39347 L .27781 .41337 L p F P
0 g
s
.943 .669 .206 r
.79587 .24549 m .8021 .2619 L .80389 .28428 L p F P
0 g
s
.89 .503 .293 r
.30504 .77225 m .29454 .76553 L .30303 .7666 L closepath p F P
0 g
s
.932 .933 .779 r
.26011 .43804 m .26061 .41974 L .27436 .41787 L closepath p F P
0 g
s
.557 .343 .545 r
.71773 .58782 m .71648 .56349 L .73867 .55636 L p F P
0 g
s
.606 .381 .548 r
.71648 .56349 m .71773 .58782 L .69377 .5927 L p F P
0 g
s
.388 .003 .181 r
.65564 .8335 m .65408 .83686 L .63217 .84307 L p F P
0 g
s
.356 0 .121 r
.6268 .85271 m .63217 .84307 L .65408 .83686 L p F P
0 g
s
.418 .008 .153 r
.63217 .84307 m .6268 .85271 L .60378 .85775 L p F P
0 g
s
.353 .193 .52 r
.78253 .48119 m .77514 .48725 L .77676 .51109 L p F P
0 g
s
.431 .249 .532 r
.77514 .48725 m .77676 .51109 L .75778 .52287 L p F P
0 g
s
.236 .342 .77 r
.78123 .44156 m .77738 .43202 L .78162 .43538 L closepath p F P
0 g
s
.517 .055 .096 r
.52302 .87041 m .52786 .86531 L .55453 .86421 L p F P
0 g
s
.564 .109 .129 r
.52302 .87041 m .5069 .86519 L .52786 .86531 L closepath p F P
0 g
s
.553 .07 .063 r
.5069 .86519 m .52302 .87041 L .51678 .87559 L p F P
0 g
s
.553 .07 .063 r
.49971 .86496 m .5069 .86519 L p .51678 .87559 L F P
0 g
s
.1 .13 .605 r
.81722 .55242 m .81241 .54241 L .81003 .53203 L p F P
0 g
s
.983 .882 .65 r
.23524 .49218 m .23746 .50148 L .22851 .52326 L p F P
0 g
s
.553 .07 .063 r
.48959 .87312 m .49971 .86496 L p .51678 .87559 L F P
0 g
s
.6 .126 .102 r
.49971 .86496 m .48959 .87312 L .46828 .8635 L p F P
0 g
s
.6 .126 .102 r
.46828 .8635 m .46943 .8626 L .49971 .86496 L p F P
0 g
s
.824 .393 .216 r
.33512 .80491 m .33207 .7999 L .34098 .80401 L closepath p F P
0 g
s
.807 .362 .186 r
.33512 .80491 m .34098 .80401 L p .36457 .82603 L F P
0 g
s
.948 .629 .394 r
.26382 .71312 m .25053 .70082 L .24847 .68187 L p F P
0 g
s
.924 .575 .353 r
.2826 .74324 m .26769 .73168 L .26382 .71312 L p F P
0 g
s
.94 .587 .315 r
.25053 .70082 m .26382 .71312 L .26769 .73168 L p F P
0 g
s
.744 .268 .115 r
.38841 .83422 m .40139 .84735 L .39816 .84822 L p F P
0 g
s
.744 .268 .115 r
.37267 .82898 m .38841 .83422 L p .39816 .84822 L F P
0 g
s
.897 .521 .313 r
.29454 .76553 m .28832 .76145 L .2826 .74324 L p F P
0 g
s
.913 .529 .272 r
.26769 .73168 m .2826 .74324 L .28832 .76145 L p F P
0 g
s
.224 .007 .359 r
.76343 .74006 m .76833 .73623 L .77823 .71272 L p F P
0 g
s
.169 0 .326 r
.78163 .70981 m .77823 .71272 L .76833 .73623 L p F P
0 g
s
.462 0 .058 r
.55453 .86421 m .56512 .86323 L p .57013 .87279 L F P
0 g
s
.462 0 .058 r
.54475 .87481 m .55453 .86421 L p .57013 .87279 L F P
0 g
s
.517 .055 .096 r
.55453 .86421 m .54475 .87481 L .52302 .87041 L p F P
0 g
s
.652 .871 .981 r
.44559 .28408 m .45356 .28843 L .4749 .28038 L p F P
0 g
s
.658 .86 .976 r
.47911 .28297 m .4749 .28038 L .45356 .28843 L p F P
0 g
s
.695 .881 .967 r
.45356 .28843 m .44559 .28408 L .42425 .29378 L p F P
0 g
s
.78 .625 .063 r
.50314 .36454 m .5027 .35671 L .50282 .33382 L p F P
0 g
s
0 0 .048 r
.50345 .32274 m .50282 .33382 L .5027 .35671 L p F P
0 g
s
.253 0 .186 r
.69793 .81478 m .70178 .80346 L .72109 .7939 L p F P
0 g
s
.318 0 .212 r
.69793 .81478 m .70178 .80346 L p .67668 .8262 L F P
0 g
s
.788 .525 .538 r
.609 .59138 m .58544 .58531 L .58503 .56098 L p F P
0 g
s
.822 .553 .532 r
.57109 .55588 m .58503 .56098 L .58544 .58531 L p F P
0 g
s
.189 .335 .781 r
.78162 .43538 m .77738 .43202 L .76652 .40732 L p F P
0 g
s
.431 .249 .532 r
.75929 .54696 m .75778 .52287 L .77676 .51109 L p F P
0 g
s
.498 .299 .54 r
.75778 .52287 m .75929 .54696 L .73867 .55636 L p F P
0 g
s
.329 0 .153 r
.65408 .83686 m .65564 .8335 L .67668 .8262 L p F P
0 g
s
.964 .644 .358 r
.2368 .66881 m .24847 .68187 L .25053 .70082 L p F P
0 g
s
.968 .682 .436 r
.24847 .68187 m .2368 .66881 L .23653 .64946 L p F P
0 g
s
.722 .916 .96 r
.39287 .30117 m .40298 .30506 L .42425 .29378 L p F P
0 g
s
.757 .919 .944 r
.40298 .30506 m .39287 .30117 L .37799 .31654 L p F P
0 g
s
.093 .012 .463 r
.81802 .60841 m .80995 .62109 L .81142 .64084 L p F P
0 g
s
.158 .092 .526 r
.80995 .62109 m .81802 .60841 L .81402 .58959 L p F P
0 g
s
.161 .06 .482 r
.80585 .64821 m .81142 .64084 L .80995 .62109 L p F P
0 g
s
.833 .948 .896 r
.32581 .34683 m .3398 .33508 L .33312 .34807 L closepath p F P
0 g
s
.822 .932 .904 r
.34732 .32911 m .3398 .33508 L .33312 .34807 L p F P
0 g
s
.856 .941 .875 r
.33312 .34807 m .32581 .34683 L p .30475 .36704 L F P
0 g
s
.995 .822 .556 r
.22326 .54953 m .22782 .56027 L .22288 .58089 L p F P
0 g
s
.615 .847 .987 r
.4749 .28038 m .47911 .28297 L .50054 .2764 L p F P
0 g
s
.16 .159 .608 r
.81544 .55657 m .81241 .54241 L .81722 .55242 L closepath p F P
0 g
s
.483 .043 .126 r
.57784 .86423 m .56512 .86323 L .57976 .86163 L closepath p F P
0 g
s
.462 0 .058 r
.56512 .86323 m .57784 .86423 L .57013 .87279 L p F P
0 g
s
.857 .447 .253 r
.33207 .7999 m .31345 .78986 L .30504 .77225 L p F P
0 g
s
.871 .447 .202 r
.29454 .76553 m .30504 .77225 L .31345 .78986 L p F P
0 g
s
0 0 .198 r
.80814 .32438 m .80758 .33231 L .80941 .3552 L p F P
0 g
s
0 0 .286 r
.80735 .36616 m .80941 .3552 L .80758 .33231 L p F P
0 g
s
.947 .939 .748 r
.26011 .43804 m .26061 .41974 L p .24516 .45321 L F P
0 g
s
.947 .939 .748 r
.24516 .45321 m .25192 .45092 L .26011 .43804 L p F P
0 g
s
.639 .175 .136 r
.46828 .8635 m .46602 .8622 L .46943 .8626 L closepath p F P
0 g
s
.095 .052 .513 r
.81942 .57931 m .81402 .58959 L .81802 .60841 L p F P
0 g
s
.162 .132 .574 r
.81402 .58959 m .81942 .57931 L .81544 .55657 L p F P
0 g
s
.762 .935 .942 r
.36875 .31384 m .37799 .31654 L .39287 .30117 L p F P
0 g
s
.795 .935 .923 r
.34732 .32911 m .36875 .31384 L .37799 .31654 L p F P
0 g
s
.636 .146 .073 r
.46602 .8622 m .46828 .8635 L p .43485 .85829 L F P
0 g
s
.636 .146 .073 r
.43485 .85829 m .4362 .85755 L .46602 .8622 L p F P
0 g
s
.982 .7 .403 r
.22651 .6356 m .23653 .64946 L .2368 .66881 L p F P
0 g
s
.982 .732 .477 r
.23653 .64946 m .22651 .6356 L .22801 .61582 L p F P
0 g
s
.453 .693 .969 r
.62166 .29686 m .61063 .28528 L .58857 .28515 L p F P
0 g
s
.429 0 .093 r
.57784 .86423 m .57976 .86163 L .60378 .85775 L p F P
0 g
s
.163 0 .383 r
.79767 .67687 m .79708 .69447 L .78163 .70981 L p F P
0 g
s
.096 0 .301 r
.79708 .69447 m .78163 .70981 L .77992 .72637 L p F P
0 g
s
.169 0 .326 r
.76833 .73623 m .77992 .72637 L .78163 .70981 L p F P
0 g
s
.168 0 .284 r
.76235 .74704 m .76833 .73623 L .76343 .74006 L closepath p F P
0 g
s
.233 0 .305 r
.76235 .74704 m .76343 .74006 L p .74324 .76802 L F P
0 g
s
0 0 .394 r
.80918 .3893 m .80255 .40602 L .80436 .4294 L p F P
0 g
s
0 0 .394 r
.80255 .40602 m .80918 .3893 L .80735 .36616 L p F P
0 g
s
.684 .441 .548 r
.65644 .59564 m .66814 .59541 L .66908 .62 L p F P
0 g
s
.684 .441 .548 r
.66908 .62 m .6573 .62023 L .65644 .59564 L p F P
0 g
s
.703 .455 .547 r
.64012 .5952 m .65644 .59564 L .6573 .62023 L p F P
0 g
s
.649 .413 .548 r
.66908 .62 m .66814 .59541 L .69377 .5927 L p F P
0 g
s
.703 .455 .547 r
.6573 .62023 m .64088 .6198 L .64012 .5952 L p F P
0 g
s
.735 .481 .545 r
.61493 .59245 m .64012 .5952 L .64088 .6198 L p F P
0 g
s
.158 .024 .435 r
.79767 .67687 m .80449 .66899 L .80585 .64821 L p F P
0 g
s
.093 0 .41 r
.81142 .64084 m .80585 .64821 L .80449 .66899 L p F P
0 g
s
.353 .193 .52 r
.77676 .51109 m .78421 .50506 L .78253 .48119 L p F P
0 g
s
.302 .156 .51 r
.79194 .47222 m .78253 .48119 L .78421 .50506 L p F P
0 g
s
.59 .088 .029 r
.46828 .8635 m .48959 .87312 L .48743 .87439 L p F P
0 g
s
.59 .088 .029 r
.45593 .87054 m .46828 .8635 L p .48743 .87439 L F P
0 g
s
.636 .146 .073 r
.46828 .8635 m .45593 .87054 L .43485 .85829 L p F P
0 g
s
.835 .389 .164 r
.33207 .7999 m .33512 .80491 L .3217 .80352 L p F P
0 g
s
.835 .389 .164 r
.3217 .80352 m .31345 .78986 L .33207 .7999 L p F P
0 g
s
.966 .687 .452 r
.52739 .48052 m .51569 .46677 L .51573 .44314 L p F P
0 g
s
.989 .723 .376 r
.50756 .42789 m .51573 .44314 L .51569 .46677 L p F P
0 g
s
.989 .723 .376 r
.51573 .44314 m .50756 .42789 L .50765 .4045 L p F P
0 g
s
.202 .37 .809 r
.76652 .40732 m .76319 .40506 L .76205 .39809 L closepath p F P
0 g
s
.189 .335 .781 r
.76652 .40732 m .7805 .41828 L .78162 .43538 L p F P
0 g
s
.097 .087 .556 r
.81722 .55242 m .81544 .55657 L .81942 .57931 L p F P
0 g
s
.923 .643 .492 r
.54267 .51671 m .52743 .50439 L .52739 .48052 L p F P
0 g
s
.966 .687 .452 r
.51569 .46677 m .52739 .48052 L .52743 .50439 L p F P
0 g
s
.498 .299 .54 r
.74006 .58072 m .73867 .55636 L .75929 .54696 L p F P
0 g
s
.557 .343 .545 r
.73867 .55636 m .74006 .58072 L .71773 .58782 L p F P
0 g
s
.942 .715 .244 r
.50303 .38769 m .50765 .4045 L .50756 .42789 L p F P
0 g
s
.942 .715 .244 r
.50765 .4045 m .50303 .38769 L .50314 .36454 L p F P
0 g
s
0 0 .286 r
.80941 .3552 m .80735 .36616 L .80918 .3893 L p F P
0 g
s
.956 .925 .732 r
.2456 .46163 m .24516 .45321 L .25192 .45092 L closepath p F P
0 g
s
.822 .553 .532 r
.58544 .58531 m .57141 .58024 L .57109 .55588 L p F P
0 g
s
.842 .569 .527 r
.56158 .55176 m .57109 .55588 L .57141 .58024 L p F P
0 g
s
.329 0 .153 r
.67668 .8262 m .67603 .82764 L .65408 .83686 L p F P
0 g
s
.286 0 .086 r
.64885 .84649 m .65408 .83686 L .67603 .82764 L p F P
0 g
s
.356 0 .121 r
.65408 .83686 m .64885 .84649 L .6268 .85271 L p F P
0 g
s
.744 .268 .115 r
.36807 .83013 m .37267 .82898 L p .39816 .84822 L F P
0 g
s
.77 .309 .152 r
.36807 .83013 m .36457 .82603 L .37267 .82898 L closepath p F P
0 g
s
.681 .908 .975 r
.44559 .28408 m .42425 .29378 L .41161 .28875 L p F P
0 g
s
.722 .916 .96 r
.42425 .29378 m .41161 .28875 L p .39287 .30117 L F P
0 g
s
.094 0 .362 r
.80449 .66899 m .79767 .67687 L .79708 .69447 L p F P
0 g
s
.175 0 .223 r
.74127 .77632 m .75295 .76146 L .74324 .76802 L closepath p F P
0 g
s
.233 0 .305 r
.74324 .76802 m .75295 .76146 L .76235 .74704 L p F P
0 g
s
.243 0 .247 r
.74127 .77632 m .74324 .76802 L p .72109 .7939 L F P
0 g
s
.994 .753 .447 r
.21963 .60112 m .22801 .61582 L .22651 .6356 L p F P
0 g
s
.992 .78 .518 r
.22801 .61582 m .21963 .60112 L .22288 .58089 L p F P
0 g
s
.606 .381 .548 r
.69488 .61731 m .69377 .5927 L .71773 .58782 L p F P
0 g
s
.649 .413 .548 r
.69377 .5927 m .69488 .61731 L .66908 .62 L p F P
0 g
s
.88 .603 .514 r
.56158 .55176 m .5428 .54083 L .54267 .51671 L p F P
0 g
s
.923 .643 .492 r
.52743 .50439 m .54267 .51671 L .5428 .54083 L p F P
0 g
s
.78 .625 .063 r
.5027 .35671 m .50314 .36454 L .50303 .38769 L p F P
0 g
s
.735 .481 .545 r
.64088 .6198 m .61553 .61706 L .61493 .59245 L p F P
0 g
s
.761 .503 .542 r
.609 .59138 m .61493 .59245 L .61553 .61706 L p F P
0 g
s
.602 .856 .992 r
.46702 .27598 m .4749 .28038 L .49876 .27528 L p F P
0 g
s
.615 .847 .987 r
.50054 .2764 m .49876 .27528 L .4749 .28038 L p F P
0 g
s
.652 .871 .981 r
.4749 .28038 m .46702 .27598 L .44559 .28408 L p F P
0 g
s
.131 .324 .79 r
.7805 .41828 m .76652 .40732 L .76205 .39809 L p F P
0 g
s
.1 0 .235 r
.76833 .73623 m .77992 .72637 L p .76073 .75582 L F P
0 g
s
.1 0 .235 r
.76073 .75582 m .76235 .74704 L .76833 .73623 L p F P
0 g
s
.367 0 .057 r
.59977 .86331 m .60378 .85775 L .6268 .85271 L p F P
0 g
s
.429 0 .093 r
.60378 .85775 m .59977 .86331 L .57784 .86423 L p F P
0 g
s
.987 .847 .617 r
.22851 .52326 m .22138 .54455 L .22326 .54953 L p F P
0 g
s
.993 .872 .597 r
.22437 .50639 m .22851 .52326 L .22138 .54455 L p F P
0 g
s
.983 .882 .65 r
.22833 .4968 m .23524 .49218 L p .22851 .52326 L F P
0 g
s
.983 .882 .65 r
.22851 .52326 m .22437 .50639 L .22833 .4968 L p F P
0 g
s
.397 0 .016 r
.57013 .87279 m .57784 .86423 L .59977 .86331 L p F P
0 g
s
.674 .197 .111 r
.43485 .85829 m .43289 .85691 L .4362 .85755 L closepath p F P
0 g
s
.761 .503 .542 r
.61553 .61706 m .60956 .61599 L .609 .59138 L p F P
0 g
s
.788 .525 .538 r
.58544 .58531 m .609 .59138 L .60956 .61599 L p F P
0 g
s
.98 .896 .661 r
.22833 .4968 m .23383 .48436 L .23524 .49218 L closepath p F P
0 g
s
.966 .899 .706 r
.2456 .46163 m .23383 .48436 L .23524 .49218 L p F P
0 g
s
.969 .925 .692 r
.24516 .45321 m .2456 .46163 L .23383 .48436 L p F P
0 g
s
.671 .169 .043 r
.43289 .85691 m .43485 .85829 L .42217 .86265 L p F P
0 g
s
.671 .169 .043 r
.42217 .86265 m .4046 .85012 L .43289 .85691 L p F P
0 g
s
.709 .242 .141 r
.43289 .85691 m .4046 .85012 L .40139 .84735 L p F P
0 g
s
.807 .362 .186 r
.36457 .82603 m .3434 .81691 L .33512 .80491 L p F P
0 g
s
.815 .352 .125 r
.3434 .81691 m .33512 .80491 L .3217 .80352 L p F P
0 g
s
.871 .447 .202 r
.28945 .76411 m .29454 .76553 L p .31345 .78986 L F P
0 g
s
.882 .472 .233 r
.28945 .76411 m .28832 .76145 L .29454 .76553 L closepath p F P
0 g
s
0 0 .198 r
.80941 .3552 m .80998 .34729 L .80814 .32438 L p F P
0 g
s
.774 .572 .001 r
.8057 .30696 m .80814 .32438 L .80998 .34729 L p F P
0 g
s
.774 .572 .001 r
.80814 .32438 m .8057 .30696 L .80389 .28428 L p F P
0 g
s
.023 .044 .542 r
.82319 .53398 m .81722 .55242 L .82328 .57046 L p F P
0 g
s
.097 .087 .556 r
.81942 .57931 m .82328 .57046 L .81722 .55242 L p F P
0 g
s
.265 0 .124 r
.67603 .82764 m .68424 .82306 L .67668 .8262 L closepath p F P
0 g
s
.318 0 .212 r
.67668 .8262 m .68424 .82306 L .69793 .81478 L p F P
0 g
s
.776 .295 .09 r
.36457 .82603 m .36807 .83013 L .35485 .83046 L p F P
0 g
s
.776 .295 .09 r
.35485 .83046 m .3434 .81691 L .36457 .82603 L p F P
0 g
s
.567 .83 .995 r
.50861 .27448 m .49876 .27528 L .50054 .2764 L closepath p F P
0 g
s
.497 .006 .019 r
.51678 .87559 m .52302 .87041 L .54475 .87481 L p F P
0 g
s
.842 .569 .527 r
.57141 .58024 m .56184 .57614 L .56158 .55176 L p F P
0 g
s
.88 .603 .514 r
.5428 .54083 m .56158 .55176 L .56184 .57614 L p F P
0 g
s
0 0 .048 r
.5027 .35671 m .50334 .34565 L .50345 .32274 L p F P
0 g
s
0 0 .221 r
.50793 .30536 m .50345 .32274 L .50334 .34565 L p F P
0 g
s
0 0 .221 r
.50345 .32274 m .50793 .30536 L .50802 .28268 L p F P
0 g
s
.177 0 .262 r
.75295 .76146 m .76073 .75582 L .76235 .74704 L closepath p F P
0 g
s
.627 .109 0 r
.43485 .85829 m .45593 .87054 L .45542 .87073 L p F P
0 g
s
.627 .109 0 r
.42217 .86265 m .43485 .85829 L p .45542 .87073 L F P
0 g
s
.943 .669 .206 r
.79764 .26792 m .80389 .28428 L .8057 .30696 L p F P
0 g
s
.943 .669 .206 r
.80389 .28428 m .79764 .26792 L .79587 .24549 L p F P
0 g
s
.999 .8 .489 r
.21618 .56532 m .22288 .58089 L .21963 .60112 L p F P
0 g
s
.995 .822 .556 r
.21806 .55753 m .22326 .54953 L p .22288 .58089 L F P
0 g
s
.995 .822 .556 r
.22288 .58089 m .21618 .56532 L .21806 .55753 L p F P
0 g
s
.208 0 .049 r
.66996 .83907 m .67603 .82764 L .68424 .82306 L p F P
0 g
s
.286 0 .086 r
.67603 .82764 m .66996 .83907 L .64885 .84649 L p F P
0 g
s
.184 0 .159 r
.71972 .79805 m .72919 .78922 L .72109 .7939 L closepath p F P
0 g
s
.243 0 .247 r
.72109 .7939 m .72919 .78922 L .74127 .77632 L p F P
0 g
s
.253 0 .186 r
.72109 .7939 m .71972 .79805 L .69793 .81478 L p F P
0 g
s
.976 .672 .347 r
.78579 .23024 m .79587 .24549 L .79764 .26792 L p F P
0 g
s
.87 .957 .86 r
.30418 .36701 m .30508 .36611 L .30475 .36704 L closepath p F P
0 g
s
.856 .941 .875 r
.32581 .34683 m .30508 .36611 L .30475 .36704 L p F P
0 g
s
.89 .946 .84 r
.28229 .391 m .30418 .36701 L .30475 .36704 L p F P
0 g
s
.557 .343 .545 r
.71899 .61245 m .71773 .58782 L .74006 .58072 L p F P
0 g
s
.606 .381 .548 r
.71773 .58782 m .71899 .61245 L .69488 .61731 L p F P
0 g
s
.997 .833 .559 r
.21806 .55753 m .22138 .54455 L .22326 .54953 L closepath p F P
0 g
s
.545 .835 .998 r
.48858 .26945 m .49876 .27528 L .50861 .27448 L p F P
0 g
s
.602 .856 .992 r
.49876 .27528 m .48858 .26945 L .46702 .27598 L p F P
0 g
s
.018 0 .385 r
.81955 .62822 m .81142 .64084 L .8118 .65938 L p F P
0 g
s
.093 .012 .463 r
.81142 .64084 m .81955 .62822 L .81802 .60841 L p F P
0 g
s
.093 0 .41 r
.80449 .66899 m .8118 .65938 L .81142 .64084 L p F P
0 g
s
.681 .908 .975 r
.41161 .28875 m .4331 .27895 L .44559 .28408 L p F P
0 g
s
.632 .896 .986 r
.46702 .27598 m .44559 .28408 L .4331 .27895 L p F P
0 g
s
0 0 .323 r
.50978 .27854 m .50802 .28268 L .50793 .30536 L p F P
0 g
s
.353 .193 .52 r
.78421 .50506 m .77676 .51109 L .7784 .53524 L p F P
0 g
s
.431 .249 .532 r
.77676 .51109 m .7784 .53524 L .75929 .54696 L p F P
0 g
s
.823 .975 .892 r
.31448 .34662 m .32581 .34683 L .3398 .33508 L p F P
0 g
s
.851 .969 .873 r
.30508 .36611 m .31448 .34662 L .32581 .34683 L closepath p F P
0 g
s
.86 .983 .851 r
.30508 .36611 m .30418 .36701 L .29002 .36877 L p F P
0 g
s
.86 .983 .851 r
.31448 .34662 m .30508 .36611 L p .29002 .36877 L F P
0 g
s
.885 .974 .833 r
.30418 .36701 m .29002 .36877 L p .28076 .39121 L F P
0 g
s
.885 .974 .833 r
.28076 .39121 m .28229 .391 L .30418 .36701 L p F P
0 g
s
.022 .001 .49 r
.82328 .57046 m .81942 .57931 L .82219 .60059 L p F P
0 g
s
.095 .052 .513 r
.81802 .60841 m .82219 .60059 L .81942 .57931 L p F P
0 g
s
.913 .529 .272 r
.28832 .76145 m .27336 .74992 L .26769 .73168 L p F P
0 g
s
.922 .533 .222 r
.25435 .71942 m .26769 .73168 L .27336 .74992 L p F P
0 g
s
.94 .587 .315 r
.26769 .73168 m .25435 .71942 L .25053 .70082 L p F P
0 g
s
.208 0 .049 r
.68424 .82306 m .69679 .81765 L p .66996 .83907 L F P
0 g
s
.273 0 .155 r
.68424 .82306 m .69679 .81765 L .69793 .81478 L closepath p F P
0 g
s
.823 .975 .892 r
.3398 .33508 m .34396 .32864 L p .31448 .34662 L F P
0 g
s
.816 .959 .905 r
.3398 .33508 m .34396 .32864 L .34732 .32911 L closepath p F P
0 g
s
.302 .156 .51 r
.78421 .50506 m .79368 .49612 L .79194 .47222 L p F P
0 g
s
.964 .644 .358 r
.25053 .70082 m .23881 .6878 L .2368 .66881 L p F P
0 g
s
.949 .595 .266 r
.23881 .6878 m .25053 .70082 L .25435 .71942 L p F P
0 g
s
.744 .268 .115 r
.39816 .84822 m .37986 .84217 L .36807 .83013 L p F P
0 g
s
.745 .246 .042 r
.37986 .84217 m .36807 .83013 L .35485 .83046 L p F P
0 g
s
.106 0 .162 r
.75295 .76146 m .76073 .75582 L p .73944 .78292 L F P
0 g
s
.106 0 .162 r
.73944 .78292 m .74127 .77632 L .75295 .76146 L p F P
0 g
s
.891 .472 .18 r
.28832 .76145 m .28945 .76411 L .27597 .75616 L p F P
0 g
s
.891 .472 .18 r
.27597 .75616 m .27336 .74992 L .28832 .76145 L p F P
0 g
s
.711 .219 .072 r
.4046 .85012 m .39816 .84822 L .40139 .84735 L closepath p F P
0 g
s
.784 .962 .923 r
.34396 .32864 m .34732 .32911 L .36875 .31384 L p F P
0 g
s
.297 0 .018 r
.62184 .85975 m .6268 .85271 L .64885 .84649 L p F P
0 g
s
.367 0 .057 r
.6268 .85271 m .62184 .85975 L .59977 .86331 L p F P
0 g
s
.015 0 .437 r
.82219 .60059 m .81802 .60841 L .81955 .62822 L p F P
0 g
s
.78 .625 .063 r
.50303 .38769 m .50258 .37988 L .5027 .35671 L p F P
0 g
s
0 0 .048 r
.50334 .34565 m .5027 .35671 L .50258 .37988 L p F P
0 g
s
.788 .525 .538 r
.60956 .61599 m .58586 .60996 L .58544 .58531 L p F P
0 g
s
.822 .553 .532 r
.57141 .58024 m .58544 .58531 L .58586 .60996 L p F P
0 g
s
.094 0 .362 r
.79708 .69447 m .80027 .6908 L .80449 .66899 L p F P
0 g
s
.014 0 .321 r
.8118 .65938 m .80449 .66899 L .80027 .6908 L p F P
0 g
s
.431 .249 .532 r
.76082 .57137 m .75929 .54696 L .7784 .53524 L p F P
0 g
s
.498 .299 .54 r
.75929 .54696 m .76082 .57137 L .74006 .58072 L p F P
0 g
s
.971 .656 .313 r
.22672 .655 m .2368 .66881 L .23881 .6878 L p F P
0 g
s
.982 .7 .403 r
.2368 .66881 m .22672 .655 L .22651 .6356 L p F P
0 g
s
.197 0 .122 r
.69679 .81765 m .69793 .81478 L .71972 .79805 L p F P
0 g
s
.904 .963 .816 r
.28022 .39347 m .28076 .39121 L .28229 .391 L closepath p F P
0 g
s
.921 .946 .797 r
.28022 .39347 m .26071 .41891 L .26061 .41974 L p F P
0 g
s
.916 .971 .785 r
.28076 .39121 m .28022 .39347 L .26071 .41891 L p F P
0 g
s
0 0 .198 r
.80998 .34729 m .80941 .3552 L .81126 .37838 L p F P
0 g
s
0 0 .286 r
.80918 .3893 m .81126 .37838 L .80941 .3552 L p F P
0 g
s
.871 .447 .202 r
.31345 .78986 m .29655 .77913 L .28945 .76411 L p F P
0 g
s
.878 .443 .14 r
.29655 .77913 m .28945 .76411 L .27597 .75616 L p F P
0 g
s
.186 0 .194 r
.72919 .78922 m .73944 .78292 L .74127 .77632 L closepath p F P
0 g
s
.84 .379 .1 r
.31345 .78986 m .3217 .80352 L .31331 .80045 L p F P
0 g
s
.84 .379 .1 r
.29655 .77913 m .31345 .78986 L p .31331 .80045 L F P
0 g
s
0 0 .323 r
.50793 .30536 m .50971 .30123 L .50978 .27854 L p F P
0 g
s
.978 .919 .637 r
.23383 .48436 m .23275 .46603 L p .22371 .50123 L F P
0 g
s
.978 .919 .637 r
.22371 .50123 m .22833 .4968 L .23383 .48436 L p F P
0 g
s
.969 .925 .692 r
.23691 .45802 m .24516 .45321 L p .23383 .48436 L F P
0 g
s
.969 .925 .692 r
.23383 .48436 m .23275 .46603 L .23691 .45802 L p F P
0 g
s
.722 .932 .959 r
.39017 .30035 m .40356 .29303 L .39287 .30117 L closepath p F P
0 g
s
.762 .935 .942 r
.39287 .30117 m .39017 .30035 L .36875 .31384 L p F P
0 g
s
.722 .916 .96 r
.41161 .28875 m .40356 .29303 L .39287 .30117 L p F P
0 g
s
.745 .96 .939 r
.35782 .31217 m .36875 .31384 L .39017 .30035 L p F P
0 g
s
.784 .962 .923 r
.36875 .31384 m .35782 .31217 L .34396 .32864 L p F P
0 g
s
.114 0 .087 r
.72919 .78922 m .73944 .78292 L p .71595 .80776 L F P
0 g
s
.114 0 .087 r
.71595 .80776 m .71972 .79805 L .72919 .78922 L p F P
0 g
s
.197 0 .122 r
.71972 .79805 m .71595 .80776 L .69679 .81765 L p F P
0 g
s
.96 .941 .704 r
.23691 .45802 m .24537 .44291 L .24516 .45321 L closepath p F P
0 g
s
.947 .939 .748 r
.26 .41993 m .24537 .44291 L .24516 .45321 L p F P
0 g
s
.947 .939 .748 r
.26061 .41974 m .26 .41993 L p .24516 .45321 L F P
0 g
s
.662 .133 0 r
.4046 .85012 m .42217 .86265 L .41897 .86309 L p F P
0 g
s
.662 .133 0 r
.39816 .84822 m .4046 .85012 L p .41897 .86309 L F P
0 g
s
.997 .853 .527 r
.22138 .54455 m .21716 .52777 L p .21543 .56287 L F P
0 g
s
.997 .853 .527 r
.21543 .56287 m .21806 .55753 L .22138 .54455 L p F P
0 g
s
.993 .872 .597 r
.22138 .54455 m .21716 .52777 L .22437 .50639 L p F P
0 g
s
.986 .713 .36 r
.21808 .62096 m .22651 .6356 L .22672 .655 L p F P
0 g
s
.994 .753 .447 r
.22651 .6356 m .21808 .62096 L .21963 .60112 L p F P
0 g
s
0 0 .394 r
.80436 .4294 m .81104 .41274 L .80918 .3893 L p F P
0 g
s
.894 .983 .802 r
.26774 .39512 m .28765 .37136 L .28076 .39121 L closepath p F P
0 g
s
.916 .971 .785 r
.26774 .39512 m .28076 .39121 L p .26071 .41891 L F P
0 g
s
.885 .974 .833 r
.29002 .36877 m .28765 .37136 L .28076 .39121 L p F P
0 g
s
.684 .441 .548 r
.6573 .62023 m .66908 .62 L .67003 .64491 L p F P
0 g
s
.684 .441 .548 r
.67003 .64491 m .65818 .64514 L .6573 .62023 L p F P
0 g
s
.703 .455 .547 r
.64088 .6198 m .6573 .62023 L .65818 .64514 L p F P
0 g
s
.649 .413 .548 r
.67003 .64491 m .66908 .62 L .69488 .61731 L p F P
0 g
s
.323 0 0 r
.59464 .86914 m .59977 .86331 L .62184 .85975 L p F P
0 g
s
.397 0 .016 r
.59977 .86331 m .59464 .86914 L .57013 .87279 L p F P
0 g
s
.703 .455 .547 r
.65818 .64514 m .64165 .64471 L .64088 .6198 L p F P
0 g
s
.735 .481 .545 r
.61553 .61706 m .64088 .6198 L .64165 .64471 L p F P
0 g
s
.353 .193 .52 r
.7784 .53524 m .7859 .52923 L .78421 .50506 L p F P
0 g
s
.302 .156 .51 r
.79368 .49612 m .78421 .50506 L .7859 .52923 L p F P
0 g
s
.966 .687 .452 r
.52743 .50439 m .51566 .4907 L .51569 .46677 L p F P
0 g
s
.989 .723 .376 r
.50747 .45157 m .51569 .46677 L .51566 .4907 L p F P
0 g
s
.989 .723 .376 r
.51569 .46677 m .50747 .45157 L .50756 .42789 L p F P
0 g
s
.02 0 .205 r
.79268 .7138 m .77992 .72637 L .77717 .74194 L p F P
0 g
s
.096 0 .301 r
.79614 .70411 m .79708 .69447 L p .77992 .72637 L F P
0 g
s
.096 0 .301 r
.77992 .72637 m .79268 .7138 L .79614 .70411 L p F P
0 g
s
.1 0 .235 r
.77992 .72637 m .77717 .74194 L .76073 .75582 L p F P
0 g
s
.923 .643 .492 r
.5428 .54083 m .52747 .52857 L .52743 .50439 L p F P
0 g
s
.966 .687 .452 r
.51566 .4907 m .52743 .50439 L .52747 .52857 L p F P
0 g
s
.786 .977 .909 r
.33374 .3283 m .34396 .32864 L .35782 .31217 L p F P
0 g
s
.823 .975 .892 r
.34396 .32864 m .33374 .3283 L p .31448 .34662 L F P
0 g
s
.704 .193 .013 r
.38842 .84943 m .37986 .84217 L .39816 .84822 L closepath p F P
0 g
s
.662 .133 0 r
.38842 .84943 m .39816 .84822 L p .41897 .86309 L F P
0 g
s
.123 0 .009 r
.71595 .80776 m .69679 .81765 L .69016 .83041 L p F P
0 g
s
.208 0 .049 r
.69679 .81765 m .69016 .83041 L .66996 .83907 L p F P
0 g
s
.498 .299 .54 r
.74147 .60539 m .74006 .58072 L .76082 .57137 L p F P
0 g
s
.557 .343 .545 r
.74006 .58072 m .74147 .60539 L .71899 .61245 L p F P
0 g
s
.942 .715 .244 r
.50291 .41114 m .50756 .42789 L .50747 .45157 L p F P
0 g
s
.942 .715 .244 r
.50756 .42789 m .50291 .41114 L .50303 .38769 L p F P
0 g
s
0 0 .286 r
.81126 .37838 m .80918 .3893 L .81104 .41274 L p F P
0 g
s
.574 .877 .993 r
.48858 .26945 m .46702 .27598 L .45468 .27075 L p F P
0 g
s
.632 .896 .986 r
.4331 .27895 m .45468 .27075 L .46702 .27598 L p F P
0 g
s
.935 .954 .765 r
.26 .41993 m .26071 .41891 L .26061 .41974 L closepath p F P
0 g
s
.822 .553 .532 r
.58586 .60996 m .57174 .60491 L .57141 .58024 L p F P
0 g
s
.842 .569 .527 r
.56184 .57614 m .57141 .58024 L .57174 .60491 L p F P
0 g
s
.022 0 .13 r
.77717 .74194 m .76073 .75582 L .75679 .77042 L p F P
0 g
s
.106 0 .162 r
.76073 .75582 m .75679 .77042 L .73944 .78292 L p F P
0 g
s
.774 .274 .013 r
.3434 .81691 m .35485 .83046 L .34933 .82934 L p F P
0 g
s
.774 .274 .013 r
.32413 .80706 m .3434 .81691 L p .34933 .82934 L F P
0 g
s
.815 .352 .125 r
.3217 .80352 m .32413 .80706 L .3434 .81691 L p F P
0 g
s
.021 0 .275 r
.79614 .70411 m .80027 .6908 L .79708 .69447 L closepath p F P
0 g
s
.535 .021 0 r
.49497 .87488 m .48743 .87439 L .48959 .87312 L closepath p F P
0 g
s
.553 .07 .063 r
.51678 .87559 m .49497 .87488 L .48959 .87312 L p F P
0 g
s
.923 .975 .743 r
.26071 .41891 m .26562 .39787 L p .24763 .4264 L F P
0 g
s
.923 .975 .743 r
.24763 .4264 m .26 .41993 L .26071 .41891 L p F P
0 g
s
.916 .971 .785 r
.26071 .41891 m .26562 .39787 L .26774 .39512 L p F P
0 g
s
.698 .953 .953 r
.40356 .29303 m .39017 .30035 L .37702 .29818 L p F P
0 g
s
.745 .96 .939 r
.39017 .30035 m .37702 .29818 L p .35782 .31217 L F P
0 g
s
.941 .962 .73 r
.24537 .44291 m .24763 .4264 L .26 .41993 L closepath p F P
0 g
s
.606 .381 .548 r
.696 .64223 m .69488 .61731 L .71899 .61245 L p F P
0 g
s
.649 .413 .548 r
.69488 .61731 m .696 .64223 L .67003 .64491 L p F P
0 g
s
.88 .603 .514 r
.56184 .57614 m .54295 .56526 L .5428 .54083 L p F P
0 g
s
.923 .643 .492 r
.52747 .52857 m .5428 .54083 L .54295 .56526 L p F P
0 g
s
.984 .905 .63 r
.22437 .50639 m .22371 .50123 L .22833 .4968 L closepath p F P
0 g
s
.78 .625 .063 r
.50258 .37988 m .50303 .38769 L .50291 .41114 L p F P
0 g
s
.048 .254 .75 r
.78021 .40467 m .77709 .40171 L .7805 .41828 L p F P
0 g
s
.735 .481 .545 r
.64165 .64471 m .61614 .64199 L .61553 .61706 L p F P
0 g
s
.761 .503 .542 r
.60956 .61599 m .61553 .61706 L .61614 .64199 L p F P
0 g
s
.22 0 0 r
.644 .85352 m .64885 .84649 L .66996 .83907 L p F P
0 g
s
.297 0 .018 r
.64885 .84649 m .644 .85352 L .62184 .85975 L p F P
0 g
s
.994 .767 .407 r
.21287 .58562 m .21963 .60112 L .21808 .62096 L p F P
0 g
s
.999 .8 .489 r
.21963 .60112 m .21287 .58562 L .21618 .56532 L p F P
0 g
s
0 0 .463 r
.82868 .55405 m .82328 .57046 L .82712 .58943 L p F P
0 g
s
.023 .044 .542 r
.82702 .54526 m .82319 .53398 L p .82328 .57046 L F P
0 g
s
.023 .044 .542 r
.82328 .57046 m .82868 .55405 L .82702 .54526 L p F P
0 g
s
.022 .001 .49 r
.82219 .60059 m .82712 .58943 L .82328 .57046 L p F P
0 g
s
.761 .503 .542 r
.61614 .64199 m .61013 .64093 L .60956 .61599 L p F P
0 g
s
.788 .525 .538 r
.58586 .60996 m .60956 .61599 L .61013 .64093 L p F P
0 g
s
0 0 .409 r
.82712 .58943 m .82219 .60059 L .82374 .62043 L p F P
0 g
s
.015 0 .437 r
.81955 .62822 m .82374 .62043 L .82219 .60059 L p F P
0 g
s
.462 0 .058 r
.57013 .87279 m .54657 .87496 L .54475 .87481 L p F P
0 g
s
.431 0 0 r
.54657 .87496 m .54439 .87512 L .54475 .87481 L closepath p F P
0 g
s
.497 .006 .019 r
.54475 .87481 m .54439 .87512 L .51678 .87559 L p F P
0 g
s
.438 0 0 r
.51122 .8791 m .51678 .87559 L .54439 .87512 L p F P
0 g
s
.502 0 0 r
.51122 .8791 m .49497 .87488 L .51678 .87559 L closepath p F P
0 g
s
0 0 .198 r
.81126 .37838 m .81185 .3705 L .80998 .34729 L p F P
0 g
s
.774 .572 .001 r
.80998 .34729 m .80754 .32993 L .8057 .30696 L p F P
0 g
s
.774 .572 .001 r
.80754 .32993 m .80998 .34729 L .81185 .3705 L p F P
0 g
s
.999 .842 .529 r
.21618 .56532 m .21543 .56287 L .21806 .55753 L closepath p F P
0 g
s
.362 0 0 r
.54439 .87512 m .54657 .87496 L p .55776 .88169 L F P
0 g
s
.362 0 0 r
.53311 .88241 m .54439 .87512 L p .55776 .88169 L F P
0 g
s
.438 0 0 r
.54439 .87512 m .53311 .88241 L .51122 .8791 L p F P
0 g
s
.406 0 0 r
.56669 .87579 m .54657 .87496 L .57013 .87279 L closepath p F P
0 g
s
.362 0 0 r
.54657 .87496 m .56669 .87579 L .55776 .88169 L p F P
0 g
s
.706 .939 .961 r
.40356 .29303 m .41023 .28838 L .41161 .28875 L closepath p F P
0 g
s
.698 .953 .953 r
.41023 .28838 m .40356 .29303 L p .37702 .29818 L F P
0 g
s
.471 0 0 r
.49497 .87488 m .51122 .8791 L .50221 .883 L p F P
0 g
s
.471 0 0 r
.48743 .87439 m .49497 .87488 L p .50221 .883 L F P
0 g
s
.026 0 .05 r
.75679 .77042 m .73944 .78292 L .73426 .79657 L p F P
0 g
s
.114 0 .087 r
.73944 .78292 m .73426 .79657 L .71595 .80776 L p F P
0 g
s
.842 .569 .527 r
.57174 .60491 m .56211 .60083 L .56184 .57614 L p F P
0 g
s
.88 .603 .514 r
.54295 .56526 m .56184 .57614 L .56211 .60083 L p F P
0 g
s
.014 0 .321 r
.80027 .6908 m .81107 .67674 L .8118 .65938 L p F P
0 g
s
0 0 .216 r
.80027 .6908 m .81107 .67674 L p .79533 .71087 L F P
0 g
s
0 0 .216 r
.79533 .71087 m .79614 .70411 L .80027 .6908 L p F P
0 g
s
.471 0 0 r
.4774 .87861 m .48743 .87439 L p .50221 .883 L F P
0 g
s
.536 0 0 r
.4774 .87861 m .45682 .87095 L .48743 .87439 L closepath p F P
0 g
s
.59 .088 .029 r
.48743 .87439 m .45682 .87095 L .45593 .87054 L p F P
0 g
s
0 0 .048 r
.50258 .37988 m .50323 .36887 L .50334 .34565 L p F P
0 g
s
0 0 .221 r
.50785 .32833 m .50334 .34565 L .50323 .36887 L p F P
0 g
s
0 0 .221 r
.50334 .34565 m .50785 .32833 L .50793 .30536 L p F P
0 g
s
.988 .89 .566 r
.22371 .50123 m .22437 .50639 L .21716 .52777 L p F P
0 g
s
0 0 .292 r
.81855 .649 m .8118 .65938 L .81107 .67674 L p F P
0 g
s
.018 0 .385 r
.8118 .65938 m .81855 .649 L .81955 .62822 L p F P
0 g
s
.943 .669 .206 r
.79942 .29064 m .8057 .30696 L .80754 .32993 L p F P
0 g
s
.943 .669 .206 r
.8057 .30696 m .79942 .29064 L .79764 .26792 L p F P
0 g
s
.976 .672 .347 r
.79764 .26792 m .7875 .25271 L .78579 .23024 L p F P
0 g
s
.945 .637 .424 r
.7718 .21621 m .78579 .23024 L .7875 .25271 L p F P
0 g
s
0 0 .343 r
.82374 .62043 m .81955 .62822 L .81855 .649 L p F P
0 g
s
.976 .672 .347 r
.7875 .25271 m .79764 .26792 L .79942 .29064 L p F P
0 g
s
.657 .929 .972 r
.41023 .28838 m .41161 .28875 L .4331 .27895 L p F P
0 g
s
.265 .102 .464 r
.53505 .22264 m .52824 .22949 L .52829 .25197 L p F P
0 g
s
.557 .343 .545 r
.72027 .6374 m .71899 .61245 L .74147 .60539 L p F P
0 g
s
.606 .381 .548 r
.71899 .61245 m .72027 .6374 L .696 .64223 L p F P
0 g
s
.693 .158 0 r
.37986 .84217 m .38842 .84943 L .37532 .84841 L p F P
0 g
s
.693 .158 0 r
.37532 .84841 m .35765 .83333 L .37986 .84217 L p F P
0 g
s
.745 .246 .042 r
.35485 .83046 m .35765 .83333 L .37986 .84217 L p F P
0 g
s
.333 0 0 r
.56669 .87579 m .57013 .87279 L .59464 .86914 L p F P
0 g
s
.922 .533 .222 r
.27336 .74992 m .25997 .73769 L .25435 .71942 L p F P
0 g
s
.921 .531 .159 r
.24259 .70645 m .25435 .71942 L .25997 .73769 L p F P
0 g
s
.949 .595 .266 r
.25435 .71942 m .24259 .70645 L .23881 .6878 L p F P
0 g
s
0 0 .323 r
.50971 .30123 m .50793 .30536 L .50785 .32833 L p F P
0 g
s
.891 .466 .115 r
.27336 .74992 m .27597 .75616 L .26257 .74395 L p F P
0 g
s
.891 .466 .115 r
.26257 .74395 m .25997 .73769 L .27336 .74992 L p F P
0 g
s
.353 .193 .52 r
.7859 .52923 m .7784 .53524 L .78007 .5597 L p F P
0 g
s
.431 .249 .532 r
.7784 .53524 m .78007 .5597 L .76082 .57137 L p F P
0 g
s
.946 .958 .675 r
.24537 .44291 m .24763 .4264 L p .233 .46122 L F P
0 g
s
.946 .958 .675 r
.233 .46122 m .23691 .45802 L .24537 .44291 L p F P
0 g
s
.239 0 0 r
.618 .86421 m .62184 .85975 L .644 .85352 L p F P
0 g
s
.323 0 0 r
.62184 .85975 m .618 .86421 L .59464 .86914 L p F P
0 g
s
.995 .814 .451 r
.21543 .56287 m .21618 .56532 L .21287 .58562 L p F P
0 g
s
.19 .076 .484 r
.80573 .48092 m .79368 .49612 L .79545 .52034 L p F P
0 g
s
.302 .156 .51 r
.7859 .52923 m .79545 .52034 L .79368 .49612 L p F P
0 g
s
.971 .656 .313 r
.23881 .6878 m .22869 .67404 L .22672 .655 L p F P
0 g
s
.946 .596 .206 r
.22869 .67404 m .23881 .6878 L .24259 .70645 L p F P
0 g
s
0 0 .521 r
.82702 .54526 m .82319 .53398 L .82397 .53025 L closepath p F P
0 g
s
.573 .04 0 r
.45682 .87095 m .45542 .87073 L .45593 .87054 L closepath p F P
0 g
s
.64 .939 .962 r
.39864 .28634 m .41023 .28838 L .42993 .27807 L p F P
0 g
s
.698 .953 .953 r
.37702 .29818 m .39864 .28634 L .41023 .28838 L p F P
0 g
s
.657 .929 .972 r
.4331 .27895 m .42993 .27807 L .41023 .28838 L p F P
0 g
s
.509 .851 .995 r
.48858 .26945 m .5103 .26453 L .50078 .26029 L p F P
0 g
s
.509 .851 .995 r
.47639 .26415 m .48858 .26945 L p .50078 .26029 L F P
0 g
s
.574 .877 .993 r
.45468 .27075 m .47639 .26415 L .48858 .26945 L p F P
0 g
s
.816 .337 .048 r
.32413 .80706 m .31331 .80045 L .3217 .80352 L closepath p F P
0 g
s
.84 .379 .1 r
.31331 .80045 m .30693 .79642 L .29655 .77913 L p F P
0 g
s
.834 .363 .021 r
.28137 .76767 m .29655 .77913 L .30693 .79642 L p F P
0 g
s
.878 .443 .14 r
.27597 .75616 m .28137 .76767 L .29655 .77913 L p F P
0 g
s
.78 .625 .063 r
.50291 .41114 m .50246 .40336 L .50258 .37988 L p F P
0 g
s
0 0 .048 r
.50323 .36887 m .50258 .37988 L .50246 .40336 L p F P
0 g
s
.503 0 0 r
.45682 .87095 m .4774 .87861 L .47071 .88014 L p F P
0 g
s
.503 0 0 r
.45542 .87073 m .45682 .87095 L p .47071 .88014 L F P
0 g
s
.788 .525 .538 r
.61013 .64093 m .58627 .63492 L .58586 .60996 L p F P
0 g
s
.822 .553 .532 r
.57174 .60491 m .58586 .60996 L .58627 .63492 L p F P
0 g
s
.503 0 0 r
.4434 .87335 m .45542 .87073 L p .47071 .88014 L F P
0 g
s
.569 .018 0 r
.4434 .87335 m .42593 .86485 L .45542 .87073 L closepath p F P
0 g
s
.627 .109 0 r
.45542 .87073 m .42593 .86485 L .42217 .86265 L p F P
0 g
s
.431 .249 .532 r
.76238 .59608 m .76082 .57137 L .78007 .5597 L p F P
0 g
s
.498 .299 .54 r
.76082 .57137 m .76238 .59608 L .74147 .60539 L p F P
0 g
s
.012 0 .249 r
.79268 .7138 m .79533 .71087 L .79614 .70411 L closepath p F P
0 g
s
.989 .82 .438 r
.21179 .54867 m .21543 .56287 L .21109 .57993 L p F P
0 g
s
.997 .853 .527 r
.21716 .52777 m .21179 .54867 L .21543 .56287 L p F P
0 g
s
.995 .814 .451 r
.21287 .58562 m .21109 .57993 L .21543 .56287 L p F P
0 g
s
.965 .659 .255 r
.21825 .64042 m .22672 .655 L .22869 .67404 L p F P
0 g
s
.986 .713 .36 r
.22672 .655 m .21825 .64042 L .21808 .62096 L p F P
0 g
s
.979 .902 .565 r
.22288 .48829 m .22371 .50123 L .21529 .51378 L p F P
0 g
s
.978 .919 .637 r
.23275 .46603 m .22288 .48829 L .22371 .50123 L p F P
0 g
s
.988 .89 .566 r
.21716 .52777 m .21529 .51378 L .22371 .50123 L p F P
0 g
s
0 0 .198 r
.81185 .3705 m .81126 .37838 L .81314 .40186 L p F P
0 g
s
0 0 .286 r
.81104 .41274 m .81314 .40186 L .81126 .37838 L p F P
0 g
s
.134 0 0 r
.66623 .8446 m .66996 .83907 L .69016 .83041 L p F P
0 g
s
.22 0 0 r
.66996 .83907 m .66623 .8446 L .644 .85352 L p F P
0 g
s
0 0 .323 r
.50785 .32833 m .50963 .32421 L .50971 .30123 L p F P
0 g
s
.036 0 .392 r
.51983 .28468 m .50971 .30123 L .50963 .32421 L p F P
0 g
s
.033 0 0 r
.71064 .8182 m .71595 .80776 L .73426 .79657 L p F P
0 g
s
.123 0 .009 r
.71064 .8182 m .71595 .80776 L p .69016 .83041 L F P
0 g
s
.251 0 0 r
.58882 .87433 m .59464 .86914 L .618 .86421 L p F P
0 g
s
.333 0 0 r
.59464 .86914 m .58882 .87433 L .56669 .87579 L p F P
0 g
s
.827 .989 .869 r
.31198 .34689 m .31743 .342 L .31448 .34662 L closepath p F P
0 g
s
.823 .975 .892 r
.33374 .3283 m .31743 .342 L .31448 .34662 L p F P
0 g
s
.86 .983 .851 r
.29002 .36877 m .31198 .34689 L .31448 .34662 L p F P
0 g
s
.774 .274 .013 r
.34933 .82934 m .33802 .82359 L .32413 .80706 L p F P
0 g
s
.759 .244 0 r
.31331 .80045 m .32413 .80706 L .33802 .82359 L p F P
0 g
s
.961 .944 .668 r
.23275 .46603 m .233 .46122 L .23691 .45802 L closepath p F P
0 g
s
0 0 .486 r
.82397 .53025 m .82596 .51628 L p .82917 .55212 L F P
0 g
s
0 0 .486 r
.82917 .55212 m .82702 .54526 L .82397 .53025 L p F P
0 g
s
.872 .431 .062 r
.28137 .76767 m .27597 .75616 L .26257 .74395 L p F P
0 g
s
.369 .181 .489 r
.53514 .24514 m .53505 .22264 L .55309 .20907 L p F P
0 g
s
.265 .102 .464 r
.52829 .25197 m .53514 .24514 L .53505 .22264 L p F P
0 g
s
.684 .441 .548 r
.65818 .64514 m .67003 .64491 L .671 .67014 L p F P
0 g
s
.684 .441 .548 r
.671 .67014 m .65907 .67037 L .65818 .64514 L p F P
0 g
s
.703 .455 .547 r
.64165 .64471 m .65818 .64514 L .65907 .67037 L p F P
0 g
s
.6 .912 .979 r
.42993 .27807 m .4331 .27895 L .45468 .27075 L p F P
0 g
s
.649 .413 .548 r
.671 .67014 m .67003 .64491 L .696 .64223 L p F P
0 g
s
.703 .455 .547 r
.65907 .67037 m .64244 .66994 L .64165 .64471 L p F P
0 g
s
.735 .481 .545 r
.61614 .64199 m .64165 .64471 L .64244 .66994 L p F P
0 g
s
.02 0 .205 r
.77717 .74194 m .78106 .73813 L .79268 .7138 L p F P
0 g
s
0 0 .132 r
.79533 .71087 m .79268 .7138 L .78106 .73813 L p F P
0 g
s
.353 .193 .52 r
.78007 .5597 m .78762 .55372 L .7859 .52923 L p F P
0 g
s
.302 .156 .51 r
.79545 .52034 m .7859 .52923 L .78762 .55372 L p F P
0 g
s
.609 .062 0 r
.42593 .86485 m .41897 .86309 L .42217 .86265 L closepath p F P
0 g
s
.989 .723 .376 r
.51566 .4907 m .50739 .47557 L .50747 .45157 L p F P
0 g
s
.966 .687 .452 r
.52747 .52857 m .51562 .51493 L .51566 .4907 L p F P
0 g
s
.989 .723 .376 r
.50739 .47557 m .51566 .4907 L .51562 .51493 L p F P
0 g
s
.976 .717 .305 r
.21127 .60552 m .21808 .62096 L .21825 .64042 L p F P
0 g
s
.994 .767 .407 r
.21808 .62096 m .21127 .60552 L .21287 .58562 L p F P
0 g
s
.923 .643 .492 r
.54295 .56526 m .52752 .55306 L .52747 .52857 L p F P
0 g
s
.966 .687 .452 r
.51562 .51493 m .52747 .52857 L .52752 .55306 L p F P
0 g
s
.498 .299 .54 r
.7429 .63038 m .74147 .60539 L .76238 .59608 L p F P
0 g
s
.557 .343 .545 r
.74147 .60539 m .7429 .63038 L .72027 .6374 L p F P
0 g
s
.942 .715 .244 r
.5028 .43489 m .50747 .45157 L .50739 .47557 L p F P
0 g
s
.942 .715 .244 r
.50747 .45157 m .5028 .43489 L .50291 .41114 L p F P
0 g
s
.737 .216 0 r
.35765 .83333 m .34933 .82934 L .35485 .83046 L closepath p F P
0 g
s
0 0 .309 r
.82871 .60932 m .82374 .62043 L .82406 .63886 L p F P
0 g
s
0 0 .409 r
.82374 .62043 m .82871 .60932 L .82712 .58943 L p F P
0 g
s
0 0 .343 r
.81855 .649 m .82406 .63886 L .82374 .62043 L p F P
0 g
s
0 0 .286 r
.81314 .40186 m .81104 .41274 L .81292 .43649 L p F P
0 g
s
.822 .553 .532 r
.58627 .63492 m .57207 .6299 L .57174 .60491 L p F P
0 g
s
.842 .569 .527 r
.56211 .60083 m .57174 .60491 L .57207 .6299 L p F P
0 g
s
.273 0 0 r
.55776 .88169 m .56669 .87579 L .58882 .87433 L p F P
0 g
s
0 0 .364 r
.8317 .57571 m .82712 .58943 L .82871 .60932 L p F P
0 g
s
0 0 .463 r
.82712 .58943 m .8317 .57571 L .82868 .55405 L p F P
0 g
s
.392 0 0 r
.50221 .883 m .51122 .8791 L .53311 .88241 L p F P
0 g
s
.981 .862 .482 r
.21529 .51378 m .21716 .52777 L .21179 .54867 L p F P
0 g
s
.74 .975 .924 r
.3554 .31206 m .36441 .30613 L .35782 .31217 L closepath p F P
0 g
s
.745 .96 .939 r
.37702 .29818 m .36441 .30613 L .35782 .31217 L p F P
0 g
s
.786 .977 .909 r
.35782 .31217 m .3554 .31206 L .33374 .3283 L p F P
0 g
s
.96 .931 .601 r
.233 .46122 m .23275 .46603 L .22288 .48829 L p F P
0 g
s
.145 0 0 r
.64025 .85796 m .644 .85352 L .66623 .8446 L p F P
0 g
s
.239 0 0 r
.644 .85352 m .64025 .85796 L .618 .86421 L p F P
0 g
s
.662 .133 0 r
.41897 .86309 m .39947 .85736 L .38842 .84943 L p F P
0 g
s
.641 .087 0 r
.39947 .85736 m .38842 .84943 L .37532 .84841 L p F P
0 g
s
.793 .999 .84 r
.29988 .35018 m .31198 .34689 L .31743 .342 L p F P
0 g
s
.836 .998 .829 r
.31198 .34689 m .29988 .35018 L .28867 .36915 L p F P
0 g
s
.836 .998 .829 r
.28867 .36915 m .29002 .36877 L .31198 .34689 L p F P
0 g
s
.606 .381 .548 r
.69714 .66748 m .696 .64223 L .72027 .6374 L p F P
0 g
s
.649 .413 .548 r
.696 .64223 m .69714 .66748 L .671 .67014 L p F P
0 g
s
.88 .603 .514 r
.56211 .60083 m .54309 .59001 L .54295 .56526 L p F P
0 g
s
.923 .643 .492 r
.52752 .55306 m .54295 .56526 L .54309 .59001 L p F P
0 g
s
.793 .999 .84 r
.31743 .342 m .32721 .32906 L p .29988 .35018 L F P
0 g
s
.801 .993 .876 r
.31743 .342 m .32721 .32906 L .33374 .3283 L closepath p F P
0 g
s
.78 .625 .063 r
.50246 .40336 m .50291 .41114 L .5028 .43489 L p F P
0 g
s
.735 .481 .545 r
.64244 .66994 m .61675 .66724 L .61614 .64199 L p F P
0 g
s
.761 .503 .542 r
.61013 .64093 m .61614 .64199 L .61675 .66724 L p F P
0 g
s
0 0 .096 r
.77583 .74702 m .78106 .73813 L .77717 .74194 L closepath p F P
0 g
s
.022 0 .13 r
.77583 .74702 m .77717 .74194 L p .75679 .77042 L F P
0 g
s
.534 0 0 r
.42593 .86485 m .4434 .87335 L .43515 .8736 L p F P
0 g
s
.534 0 0 r
.41897 .86309 m .42593 .86485 L p .43515 .8736 L F P
0 g
s
0 0 .095 r
.80877 .69349 m .79533 .71087 L .79222 .72589 L p F P
0 g
s
0 0 .216 r
.80936 .69156 m .80877 .69349 L .79533 .71087 L p F P
0 g
s
0 0 .216 r
.81107 .67674 m .80936 .69156 L p .79533 .71087 L F P
0 g
s
0 0 .132 r
.78106 .73813 m .79222 .72589 L .79533 .71087 L p F P
0 g
s
0 0 .515 r
.82868 .55405 m .82702 .54526 L .82917 .55212 L closepath p F P
0 g
s
.756 .99 .887 r
.32721 .32906 m .33374 .3283 L .3554 .31206 L p F P
0 g
s
0 0 .292 r
.81107 .67674 m .81499 .67075 L .81855 .649 L p F P
0 g
s
0 0 .229 r
.82406 .63886 m .81855 .649 L .81499 .67075 L p F P
0 g
s
.869 .992 .816 r
.28765 .37136 m .28867 .36915 L .29002 .36877 L closepath p F P
0 g
s
.761 .503 .542 r
.61675 .66724 m .61071 .66618 L .61013 .64093 L p F P
0 g
s
.788 .525 .538 r
.58627 .63492 m .61013 .64093 L .61071 .66618 L p F P
0 g
s
.868 .995 .772 r
.28765 .37136 m .28867 .36915 L p .26634 .39578 L F P
0 g
s
.868 .995 .772 r
.26634 .39578 m .26774 .39512 L .28765 .37136 L p F P
0 g
s
.158 0 0 r
.61109 .87047 m .618 .86421 L .64025 .85796 L p F P
0 g
s
.251 0 0 r
.618 .86421 m .61109 .87047 L .58882 .87433 L p F P
0 g
s
.667 .114 0 r
.35765 .83333 m .37532 .84841 L .37423 .84811 L p F P
0 g
s
.667 .114 0 r
.34933 .82934 m .35765 .83333 L p .37423 .84811 L F P
0 g
s
.571 .916 .965 r
.42031 .27627 m .42993 .27807 L .45155 .26985 L p F P
0 g
s
.6 .912 .979 r
.45468 .27075 m .45155 .26985 L .42993 .27807 L p F P
0 g
s
.64 .939 .962 r
.42993 .27807 m .42031 .27627 L .39864 .28634 L p F P
0 g
s
0 0 .198 r
.81314 .40186 m .81374 .39401 L .81185 .3705 L p F P
0 g
s
.774 .572 .001 r
.80941 .35319 m .81185 .3705 L .81374 .39401 L p F P
0 g
s
.774 .572 .001 r
.81185 .3705 m .80941 .35319 L .80754 .32993 L p F P
0 g
s
.945 .637 .424 r
.7875 .25271 m .77343 .23872 L .7718 .21621 L p F P
0 g
s
.9 .597 .465 r
.75386 .20343 m .7718 .21621 L .77343 .23872 L p F P
0 g
s
.534 0 0 r
.40933 .86331 m .41897 .86309 L p .43515 .8736 L F P
0 g
s
.6 .039 0 r
.40933 .86331 m .39947 .85736 L .41897 .86309 L closepath p F P
0 g
s
.979 .77 .354 r
.21109 .57993 m .21287 .58562 L .21127 .60552 L p F P
0 g
s
0 0 .012 r
.75448 .77663 m .76434 .76407 L .75679 .77042 L closepath p F P
0 g
s
.022 0 .13 r
.75679 .77042 m .76434 .76407 L .77583 .74702 L p F P
0 g
s
.026 0 .05 r
.75448 .77663 m .75679 .77042 L p .73426 .79657 L F P
0 g
s
.842 .569 .527 r
.57207 .6299 m .56237 .62584 L .56211 .60083 L p F P
0 g
s
.88 .603 .514 r
.54309 .59001 m .56211 .60083 L .56237 .62584 L p F P
0 g
s
.699 .981 .895 r
.34206 .31345 m .3554 .31206 L .36441 .30613 L p F P
0 g
s
.756 .99 .887 r
.3554 .31206 m .34206 .31345 L .32721 .32906 L p F P
0 g
s
.827 .998 .78 r
.29988 .35018 m .28867 .36915 L .2757 .37515 L p F P
0 g
s
.868 .995 .772 r
.28867 .36915 m .2757 .37515 L .26634 .39578 L p F P
0 g
s
0 0 .431 r
.82917 .55212 m .82868 .55405 L .8317 .57571 L p F P
0 g
s
0 0 .048 r
.50246 .40336 m .50311 .39238 L .50323 .36887 L p F P
0 g
s
0 0 .221 r
.50776 .3516 m .50323 .36887 L .50311 .39238 L p F P
0 g
s
0 0 .221 r
.50323 .36887 m .50776 .3516 L .50785 .32833 L p F P
0 g
s
.939 .941 .6 r
.23498 .44619 m .233 .46122 L .22364 .47248 L p F P
0 g
s
.946 .958 .675 r
.24484 .42861 m .23498 .44619 L .233 .46122 L p F P
0 g
s
.946 .958 .675 r
.24763 .4264 m .24484 .42861 L p .233 .46122 L F P
0 g
s
.96 .931 .601 r
.22288 .48829 m .22364 .47248 L .233 .46122 L p F P
0 g
s
.795 .3 0 r
.30826 .79822 m .30693 .79642 L .31331 .80045 L closepath p F P
0 g
s
.759 .244 0 r
.30826 .79822 m .31331 .80045 L p .33802 .82359 L F P
0 g
s
.943 .669 .206 r
.80123 .31366 m .80754 .32993 L .80941 .35319 L p F P
0 g
s
.943 .669 .206 r
.80754 .32993 m .80123 .31366 L .79942 .29064 L p F P
0 g
s
.976 .672 .347 r
.79942 .29064 m .78923 .27548 L .7875 .25271 L p F P
0 g
s
.945 .637 .424 r
.77343 .23872 m .7875 .25271 L .78923 .27548 L p F P
0 g
s
0 0 .182 r
.80936 .69156 m .81499 .67075 L .81107 .67674 L closepath p F P
0 g
s
.534 .887 .981 r
.45155 .26985 m .45468 .27075 L .47639 .26415 L p F P
0 g
s
0 0 .001 r
.78106 .73813 m .79222 .72589 L p .77296 .75608 L F P
0 g
s
0 0 .001 r
.77296 .75608 m .77583 .74702 L .78106 .73813 L p F P
0 g
s
.699 .981 .895 r
.36441 .30613 m .37409 .2981 L p .34206 .31345 L F P
0 g
s
.717 .975 .924 r
.36441 .30613 m .37409 .2981 L .37702 .29818 L closepath p F P
0 g
s
.976 .672 .347 r
.78923 .27548 m .79942 .29064 L .80123 .31366 L p F P
0 g
s
.043 0 0 r
.68846 .83298 m .7014 .82464 L .69016 .83041 L closepath p F P
0 g
s
.134 0 0 r
.69016 .83041 m .68846 .83298 L .66623 .8446 L p F P
0 g
s
.123 0 .009 r
.69016 .83041 m .7014 .82464 L .71064 .8182 L p F P
0 g
s
.898 .987 .762 r
.26562 .39787 m .26634 .39578 L .26774 .39512 L closepath p F P
0 g
s
.876 .452 .037 r
.25997 .73769 m .26257 .74395 L .24928 .72744 L p F P
0 g
s
.876 .452 .037 r
.24928 .72744 m .24817 .72476 L .25997 .73769 L p F P
0 g
s
.921 .531 .159 r
.25997 .73769 m .24817 .72476 L .24259 .70645 L p F P
0 g
s
.557 .343 .545 r
.72157 .66268 m .72027 .6374 L .7429 .63038 L p F P
0 g
s
.606 .381 .548 r
.72027 .6374 m .72157 .66268 L .69714 .66748 L p F P
0 g
s
.042 0 0 r
.66142 .85038 m .66623 .8446 L .68846 .83298 L p F P
0 g
s
.145 0 0 r
.66623 .8446 m .66142 .85038 L .64025 .85796 L p F P
0 g
s
.894 .982 .706 r
.26634 .39578 m .26562 .39787 L .24848 .42264 L p F P
0 g
s
.923 .975 .743 r
.26562 .39787 m .24848 .42264 L .24763 .4264 L p F P
0 g
s
.903 .519 .083 r
.23243 .69273 m .24259 .70645 L .24817 .72476 L p F P
0 g
s
.946 .596 .206 r
.24259 .70645 m .23243 .69273 L .22869 .67404 L p F P
0 g
s
0 0 .431 r
.8317 .57571 m .83287 .57121 L .82917 .55212 L p F P
0 g
s
0 0 .382 r
.83175 .53455 m .82917 .55212 L .83287 .57121 L p F P
0 g
s
0 0 .486 r
.82596 .51628 m .83175 .53455 L .82917 .55212 L p F P
0 g
s
0 0 .323 r
.50963 .32421 m .50785 .32833 L .50776 .3516 L p F P
0 g
s
.353 .193 .52 r
.78762 .55372 m .78007 .5597 L .78175 .58448 L p F P
0 g
s
.431 .249 .532 r
.78007 .5597 m .78175 .58448 L .76238 .59608 L p F P
0 g
s
.834 .363 .021 r
.30693 .79642 m .29171 .78499 L .28137 .76767 L p F P
0 g
s
.811 .337 0 r
.26794 .75548 m .28137 .76767 L .29171 .78499 L p F P
0 g
s
.872 .431 .062 r
.26257 .74395 m .26794 .75548 L .28137 .76767 L p F P
0 g
s
.667 .114 0 r
.34155 .82709 m .34933 .82934 L p .37423 .84811 L F P
0 g
s
.717 .185 0 r
.34155 .82709 m .33802 .82359 L .34933 .82934 L closepath p F P
0 g
s
.19 .076 .484 r
.79545 .52034 m .80758 .50521 L .80573 .48092 L p F P
0 g
s
.19 .076 .484 r
.80758 .50521 m .79545 .52034 L .79723 .54487 L p F P
0 g
s
.302 .156 .51 r
.78762 .55372 m .79723 .54487 L .79545 .52034 L p F P
0 g
s
0 0 .041 r
.76434 .76407 m .77296 .75608 L .77583 .74702 L closepath p F P
0 g
s
.66 .962 .931 r
.37409 .2981 m .37702 .29818 L .39864 .28634 L p F P
0 g
s
.965 .659 .255 r
.22869 .67404 m .22018 .65951 L .21825 .64042 L p F P
0 g
s
.924 .586 .133 r
.22018 .65951 m .22869 .67404 L .23243 .69273 L p F P
0 g
s
.069 0 .449 r
.80803 .47707 m .80573 .48092 L .80758 .50521 L p F P
0 g
s
.855 .986 .708 r
.2757 .37515 m .26634 .39578 L .25482 .4039 L p F P
0 g
s
.894 .982 .706 r
.24848 .42264 m .25482 .4039 L .26634 .39578 L p F P
0 g
s
.78 .625 .063 r
.5028 .43489 m .50234 .42714 L .50246 .40336 L p F P
0 g
s
0 0 .048 r
.50311 .39238 m .50246 .40336 L .50234 .42714 L p F P
0 g
s
.979 .902 .565 r
.21529 .51378 m .21503 .50998 L .22288 .48829 L p F P
0 g
s
.945 .901 .512 r
.22364 .47248 m .22288 .48829 L .21503 .50998 L p F P
0 g
s
.923 .97 .682 r
.24484 .42861 m .24848 .42264 L .24763 .4264 L closepath p F P
0 g
s
.788 .525 .538 r
.61071 .66618 m .5867 .66021 L .58627 .63492 L p F P
0 g
s
.822 .553 .532 r
.57207 .6299 m .58627 .63492 L .5867 .66021 L p F P
0 g
s
.471 0 0 r
.50221 .883 m .49152 .88231 L .4774 .87861 L p F P
0 g
s
.422 0 0 r
.49152 .88231 m .47071 .88014 L .4774 .87861 L closepath p F P
0 g
s
.431 .249 .532 r
.76395 .62112 m .76238 .59608 L .78175 .58448 L p F P
0 g
s
.498 .299 .54 r
.76238 .59608 m .76395 .62112 L .7429 .63038 L p F P
0 g
s
0 0 0 r
.73269 .79973 m .74035 .79221 L .73426 .79657 L closepath p F P
0 g
s
.026 0 .05 r
.73426 .79657 m .74035 .79221 L .75448 .77663 L p F P
0 g
s
.033 0 0 r
.73426 .79657 m .73269 .79973 L .71064 .8182 L p F P
0 g
s
.774 .271 0 r
.30693 .79642 m .30826 .79822 L .2948 .78921 L p F P
0 g
s
.774 .271 0 r
.2948 .78921 m .29171 .78499 L .30693 .79642 L p F P
0 g
s
.457 .247 .505 r
.5533 .23159 m .55309 .20907 L .57327 .19797 L p F P
0 g
s
.369 .181 .489 r
.55309 .20907 m .5533 .23159 L .53514 .24514 L p F P
0 g
s
.964 .767 .326 r
.20827 .5691 m .21109 .57993 L .20948 .59986 L p F P
0 g
s
.989 .82 .438 r
.21109 .57993 m .20827 .5691 L .21179 .54867 L p F P
0 g
s
.979 .77 .354 r
.21127 .60552 m .20948 .59986 L .21109 .57993 L p F P
0 g
s
.172 0 0 r
.58286 .87834 m .58882 .87433 L .61109 .87047 L p F P
0 g
s
.273 0 0 r
.58882 .87433 m .58286 .87834 L .55776 .88169 L p F P
0 g
s
.056 0 0 r
.63348 .8642 m .64025 .85796 L .66142 .85038 L p F P
0 g
s
.158 0 0 r
.64025 .85796 m .63348 .8642 L .61109 .87047 L p F P
0 g
s
0 0 .198 r
.81374 .39401 m .81314 .40186 L .81504 .42564 L p F P
0 g
s
0 0 .286 r
.81292 .43649 m .81504 .42564 L .81314 .40186 L p F P
0 g
s
.957 .815 .377 r
.20936 .53105 m .21179 .54867 L .20827 .5691 L p F P
0 g
s
.981 .862 .482 r
.21141 .52316 m .21529 .51378 L p .21179 .54867 L F P
0 g
s
.981 .862 .482 r
.21179 .54867 m .20936 .53105 L .21141 .52316 L p F P
0 g
s
.036 0 .392 r
.50963 .32421 m .51982 .30771 L .51983 .28468 L p F P
0 g
s
0 0 .323 r
.50776 .3516 m .50956 .3475 L .50963 .32421 L p F P
0 g
s
.036 0 .392 r
.51982 .30771 m .50963 .32421 L .50956 .3475 L p F P
0 g
s
.56 0 0 r
.39947 .85736 m .40933 .86331 L .39634 .86121 L p F P
0 g
s
.56 0 0 r
.39634 .86121 m .37597 .84888 L .39947 .85736 L p F P
0 g
s
.641 .087 0 r
.37532 .84841 m .37597 .84888 L .39947 .85736 L p F P
0 g
s
.491 .883 .96 r
.44206 .26798 m .45155 .26985 L .47506 .26376 L p F P
0 g
s
.571 .916 .965 r
.45155 .26985 m .44206 .26798 L .42031 .27627 L p F P
0 g
s
.534 .887 .981 r
.47639 .26415 m .47506 .26376 L .45155 .26985 L p F P
0 g
s
0 0 0 r
.68155 .84142 m .68846 .83298 L .7014 .82464 L p F P
0 g
s
.042 0 0 r
.68846 .83298 m .68155 .84142 L .66142 .85038 L p F P
0 g
s
.938 .649 .185 r
.21141 .62504 m .21825 .64042 L .22018 .65951 L p F P
0 g
s
.976 .717 .305 r
.21825 .64042 m .21141 .62504 L .21127 .60552 L p F P
0 g
s
0 0 0 r
.76434 .76407 m .77296 .75608 L p .75135 .78361 L F P
0 g
s
0 0 0 r
.75135 .78361 m .75448 .77663 L .76434 .76407 L p F P
0 g
s
.195 .049 .444 r
.52834 .27473 m .51983 .28468 L .51982 .30771 L p F P
0 g
s
.846 .409 0 r
.26794 .75548 m .26257 .74395 L .24928 .72744 L p F P
0 g
s
.759 .244 0 r
.33802 .82359 m .32062 .813 L .30826 .79822 L p F P
0 g
s
.725 .204 0 r
.32062 .813 m .30826 .79822 L .2948 .78921 L p F P
0 g
s
0 0 .242 r
.83332 .59566 m .82871 .60932 L .828 .63012 L p F P
0 g
s
0 0 .364 r
.82871 .60932 m .83332 .59566 L .8317 .57571 L p F P
0 g
s
0 0 .309 r
.82406 .63886 m .828 .63012 L .82871 .60932 L p F P
0 g
s
0 0 .441 r
.82642 .49907 m .82596 .51628 L .83175 .53455 L p F P
0 g
s
0 0 .229 r
.81499 .67075 m .82312 .6559 L .82406 .63886 L p F P
0 g
s
0 0 .097 r
.81499 .67075 m .82312 .6559 L p .80917 .69288 L F P
0 g
s
0 0 .097 r
.80917 .69288 m .80936 .69156 L .81499 .67075 L p F P
0 g
s
.069 0 .449 r
.80758 .50521 m .8099 .50136 L .80803 .47707 L p F P
0 g
s
.684 .441 .548 r
.65907 .67037 m .671 .67014 L .67198 .6957 L p F P
0 g
s
.684 .441 .548 r
.67198 .6957 m .65997 .69593 L .65907 .67037 L p F P
0 g
s
.703 .455 .547 r
.64244 .66994 m .65907 .67037 L .65997 .69593 L p F P
0 g
s
.875 .961 .626 r
.24848 .42264 m .25482 .4039 L p .23733 .43629 L F P
0 g
s
.875 .961 .626 r
.23733 .43629 m .24484 .42861 L .24848 .42264 L p F P
0 g
s
.649 .413 .548 r
.67198 .6957 m .671 .67014 L .69714 .66748 L p F P
0 g
s
.298 0 0 r
.5423 .8828 m .53101 .88334 L .53311 .88241 L closepath p F P
0 g
s
.392 0 0 r
.53311 .88241 m .53101 .88334 L .50221 .883 L p F P
0 g
s
.362 0 0 r
.55776 .88169 m .5423 .8828 L .53311 .88241 L p F P
0 g
s
.703 .455 .547 r
.65997 .69593 m .64323 .69551 L .64244 .66994 L p F P
0 g
s
.735 .481 .545 r
.61675 .66724 m .64244 .66994 L .64323 .69551 L p F P
0 g
s
.03 0 0 r
.7014 .82464 m .70932 .82033 L .71064 .8182 L closepath p F P
0 g
s
0 0 0 r
.7014 .82464 m .70932 .82033 L p .68155 .84142 L F P
0 g
s
0 0 .192 r
.828 .63012 m .82406 .63886 L .82312 .6559 L p F P
0 g
s
.353 .193 .52 r
.78175 .58448 m .78936 .57853 L .78762 .55372 L p F P
0 g
s
.302 .156 .51 r
.79723 .54487 m .78762 .55372 L .78936 .57853 L p F P
0 g
s
.989 .723 .376 r
.51562 .51493 m .5073 .49987 L .50739 .47557 L p F P
0 g
s
.966 .687 .452 r
.52752 .55306 m .51559 .53949 L .51562 .51493 L p F P
0 g
s
.989 .723 .376 r
.5073 .49987 m .51562 .51493 L .51559 .53949 L p F P
0 g
s
0 0 0 r
.74035 .79221 m .75135 .78361 L .75448 .77663 L closepath p F P
0 g
s
.629 .961 .896 r
.36347 .29911 m .37409 .2981 L .39244 .28611 L p F P
0 g
s
.66 .962 .931 r
.39864 .28634 m .39244 .28611 L .37409 .2981 L p F P
0 g
s
.699 .981 .895 r
.37409 .2981 m .36347 .29911 L p .34206 .31345 L F P
0 g
s
.738 .992 .846 r
.31967 .33102 m .32721 .32906 L .34206 .31345 L p F P
0 g
s
.793 .999 .84 r
.32721 .32906 m .31967 .33102 L p .29988 .35018 L F P
0 g
s
.592 .94 .932 r
.39244 .28611 m .39864 .28634 L .42031 .27627 L p F P
0 g
s
.923 .643 .492 r
.54309 .59001 m .52756 .57787 L .52752 .55306 L p F P
0 g
s
.966 .687 .452 r
.51559 .53949 m .52752 .55306 L .52756 .57787 L p F P
0 g
s
.498 .299 .54 r
.74435 .65569 m .7429 .63038 L .76395 .62112 L p F P
0 g
s
.557 .343 .545 r
.7429 .63038 m .74435 .65569 L .72157 .66268 L p F P
0 g
s
.942 .715 .244 r
.50739 .47557 m .50268 .45895 L .5028 .43489 L p F P
0 g
s
.942 .715 .244 r
.50268 .45895 m .50739 .47557 L .5073 .49987 L p F P
0 g
s
0 0 0 r
.70932 .82033 m .71064 .8182 L .73269 .79973 L p F P
0 g
s
.509 .851 .995 r
.50078 .26029 m .48456 .26229 L .47639 .26415 L p F P
0 g
s
.459 .854 .975 r
.48456 .26229 m .47506 .26376 L .47639 .26415 L closepath p F P
0 g
s
.685 .142 0 r
.33802 .82359 m .34155 .82709 L .32818 .82054 L p F P
0 g
s
.685 .142 0 r
.32818 .82054 m .32062 .813 L .33802 .82359 L p F P
0 g
s
.912 .959 .631 r
.23498 .44619 m .23733 .43629 L .24484 .42861 L closepath p F P
0 g
s
.965 .868 .469 r
.21141 .52316 m .21503 .50998 L .21529 .51378 L closepath p F P
0 g
s
.822 .553 .532 r
.5867 .66021 m .5724 .65522 L .57207 .6299 L p F P
0 g
s
.842 .569 .527 r
.56237 .62584 m .57207 .6299 L .5724 .65522 L p F P
0 g
s
0 0 .326 r
.83287 .57121 m .8317 .57571 L .83332 .59566 L p F P
0 g
s
0 0 0 r
.74035 .79221 m .75135 .78361 L p .7273 .80857 L F P
0 g
s
0 0 0 r
.7273 .80857 m .73269 .79973 L .74035 .79221 L p F P
0 g
s
0 0 0 r
.73269 .79973 m .7273 .80857 L .70932 .82033 L p F P
0 g
s
.857 .562 .487 r
.74452 .19854 m .75386 .20343 L .75538 .22597 L p F P
0 g
s
.9 .597 .465 r
.77343 .23872 m .75538 .22597 L .75386 .20343 L p F P
0 g
s
.503 0 0 r
.47071 .88014 m .45506 .87772 L .4434 .87335 L p F P
0 g
s
.452 0 0 r
.45506 .87772 m .43515 .8736 L .4434 .87335 L closepath p F P
0 g
s
.943 .707 .237 r
.20948 .59986 m .21127 .60552 L .21141 .62504 L p F P
0 g
s
.606 .381 .548 r
.69829 .69306 m .69714 .66748 L .72157 .66268 L p F P
0 g
s
.649 .413 .548 r
.69714 .66748 m .69829 .69306 L .67198 .6957 L p F P
0 g
s
.88 .603 .514 r
.56237 .62584 m .54323 .61508 L .54309 .59001 L p F P
0 g
s
.923 .643 .492 r
.52756 .57787 m .54309 .59001 L .54323 .61508 L p F P
0 g
s
.78 .625 .063 r
.50234 .42714 m .5028 .43489 L .50268 .45895 L p F P
0 g
s
.735 .481 .545 r
.64323 .69551 m .61738 .69282 L .61675 .66724 L p F P
0 g
s
.761 .503 .542 r
.61071 .66618 m .61675 .66724 L .61738 .69282 L p F P
0 g
s
.399 .837 .945 r
.46393 .26147 m .47506 .26376 L .48456 .26229 L p F P
0 g
s
.491 .883 .96 r
.47506 .26376 m .46393 .26147 L .44206 .26798 L p F P
0 g
s
.203 0 0 r
.52123 .8863 m .53101 .88334 L .5423 .8828 L p F P
0 g
s
.306 0 0 r
.53101 .88334 m .52123 .8863 L .49918 .8839 L p F P
0 g
s
.306 0 0 r
.49918 .8839 m .50221 .883 L .53101 .88334 L p F P
0 g
s
.761 .503 .542 r
.61738 .69282 m .6113 .69177 L .61071 .66618 L p F P
0 g
s
.788 .525 .538 r
.5867 .66021 m .61071 .66618 L .6113 .69177 L p F P
0 g
s
.395 0 0 r
.49918 .8839 m .49152 .88231 L .50221 .883 L closepath p F P
0 g
s
.283 0 0 r
.55523 .88294 m .5423 .8828 L .55776 .88169 L closepath p F P
0 g
s
.203 0 0 r
.5423 .8828 m .55523 .88294 L p .52123 .8863 L F P
0 g
s
.465 .847 .984 r
.49825 .25937 m .48456 .26229 L .50078 .26029 L closepath p F P
0 g
s
.399 .837 .945 r
.48456 .26229 m .49825 .25937 L p .46393 .26147 L F P
0 g
s
0 0 .198 r
.81504 .42564 m .81565 .41783 L .81374 .39401 L p F P
0 g
s
.774 .572 .001 r
.81129 .37676 m .81374 .39401 L .81565 .41783 L p F P
0 g
s
.774 .572 .001 r
.81374 .39401 m .81129 .37676 L .80941 .35319 L p F P
0 g
s
0 0 0 r
.70093 .83072 m .70932 .82033 L .7273 .80857 L p F P
0 g
s
0 0 0 r
.70932 .82033 m .70093 .83072 L p .68155 .84142 L F P
0 g
s
.945 .637 .424 r
.78923 .27548 m .77508 .26152 L .77343 .23872 L p F P
0 g
s
.9 .597 .465 r
.75538 .22597 m .77343 .23872 L .77508 .26152 L p F P
0 g
s
.667 .114 0 r
.37423 .84811 m .35577 .83928 L .34155 .82709 L p F P
0 g
s
.618 .059 0 r
.35577 .83928 m .34155 .82709 L .32818 .82054 L p F P
0 g
s
.329 0 0 r
.49152 .88231 m .49918 .8839 L p .465 .88078 L F P
0 g
s
.329 0 0 r
.465 .88078 m .47071 .88014 L .49152 .88231 L p F P
0 g
s
.91 .848 .398 r
.21503 .50998 m .21589 .4908 L p .20931 .52907 L F P
0 g
s
.91 .848 .398 r
.20931 .52907 m .21141 .52316 L .21503 .50998 L p F P
0 g
s
.945 .901 .512 r
.22051 .47807 m .22364 .47248 L p .21503 .50998 L F P
0 g
s
.945 .901 .512 r
.21503 .50998 m .21589 .4908 L .22051 .47807 L p F P
0 g
s
.842 .569 .527 r
.5724 .65522 m .56264 .65118 L .56237 .62584 L p F P
0 g
s
.88 .603 .514 r
.54323 .61508 m .56237 .62584 L .56264 .65118 L p F P
0 g
s
.186 0 0 r
.55523 .88294 m .55776 .88169 L .58286 .87834 L p F P
0 g
s
.06 0 0 r
.60663 .87353 m .61109 .87047 L .63348 .8642 L p F P
0 g
s
.172 0 0 r
.61109 .87047 m .60663 .87353 L .58286 .87834 L p F P
0 g
s
0 0 .326 r
.83332 .59566 m .8345 .59118 L .83287 .57121 L p F P
0 g
s
0 0 .254 r
.8355 .5537 m .83287 .57121 L .8345 .59118 L p F P
0 g
s
0 0 .382 r
.83287 .57121 m .8355 .5537 L .83175 .53455 L p F P
0 g
s
.534 0 0 r
.43515 .8736 m .42531 .87112 L .40933 .86331 L p F P
0 g
s
.477 0 0 r
.42531 .87112 m .40933 .86331 L .39634 .86121 L p F P
0 g
s
0 0 0 r
.65595 .8555 m .66142 .85038 L .68155 .84142 L p F P
0 g
s
.056 0 0 r
.66142 .85038 m .65595 .8555 L .63348 .8642 L p F P
0 g
s
.857 .562 .487 r
.75538 .22597 m .74598 .22109 L .74452 .19854 L p F P
0 g
s
.835 .543 .496 r
.73062 .19244 m .74452 .19854 L .74598 .22109 L p F P
0 g
s
0 0 .048 r
.50234 .42714 m .50299 .4162 L .50311 .39238 L p F P
0 g
s
0 0 .221 r
.50768 .37518 m .50311 .39238 L .50299 .4162 L p F P
0 g
s
0 0 .221 r
.50311 .39238 m .50768 .37518 L .50776 .3516 L p F P
0 g
s
.375 .801 .97 r
.49825 .25937 m .50078 .26029 L .52876 .25965 L p F P
0 g
s
0 0 0 r
.78899 .73628 m .79873 .71751 L .79222 .72589 L closepath p F P
0 g
s
0 0 .095 r
.79222 .72589 m .79873 .71751 L .80877 .69349 L p F P
0 g
s
0 0 .001 r
.79222 .72589 m .78899 .73628 L p .77296 .75608 L F P
0 g
s
.943 .669 .206 r
.80307 .33698 m .80941 .35319 L .81129 .37676 L p F P
0 g
s
.943 .669 .206 r
.80941 .35319 m .80307 .33698 L .80123 .31366 L p F P
0 g
s
.529 .302 .515 r
.57361 .22052 m .57327 .19797 L .59553 .18941 L p F P
0 g
s
.457 .247 .505 r
.57327 .19797 m .57361 .22052 L .5533 .23159 L p F P
0 g
s
.592 .94 .932 r
.42031 .27627 m .41256 .27592 L .39244 .28611 L p F P
0 g
s
.512 .907 .924 r
.41256 .27592 m .42031 .27627 L .44206 .26798 L p F P
0 g
s
.976 .672 .347 r
.80123 .31366 m .79099 .29854 L .78923 .27548 L p F P
0 g
s
.945 .637 .424 r
.77508 .26152 m .78923 .27548 L .79099 .29854 L p F P
0 g
s
.886 .925 .537 r
.23733 .43629 m .23498 .44619 L .2241 .46891 L p F P
0 g
s
.939 .941 .6 r
.22364 .47248 m .2241 .46891 L .23498 .44619 L p F P
0 g
s
.375 .801 .97 r
.52876 .25965 m .5203 .25651 L .49825 .25937 L p F P
0 g
s
0 0 .137 r
.80877 .69349 m .80917 .69288 L .80936 .69156 L closepath p F P
0 g
s
.6 .029 0 r
.37597 .84888 m .37423 .84811 L .37532 .84841 L closepath p F P
0 g
s
.976 .672 .347 r
.79099 .29854 m .80123 .31366 L .80307 .33698 L p F P
0 g
s
0 0 0 r
.76755 .76832 m .78522 .7427 L .77296 .75608 L closepath p F P
0 g
s
0 0 .001 r
.78899 .73628 m .78522 .7427 L .77296 .75608 L p F P
0 g
s
0 0 0 r
.77296 .75608 m .76755 .76832 L p .75135 .78361 L F P
0 g
s
.195 .049 .444 r
.51982 .30771 m .52839 .2978 L .52834 .27473 L p F P
0 g
s
.265 .102 .464 r
.53524 .26792 m .52834 .27473 L .52839 .2978 L p F P
0 g
s
.422 0 0 r
.465 .88078 m .45506 .87772 L .47071 .88014 L closepath p F P
0 g
s
.557 .343 .545 r
.72288 .68828 m .72157 .66268 L .74435 .65569 L p F P
0 g
s
.606 .381 .548 r
.72157 .66268 m .72288 .68828 L .69829 .69306 L p F P
0 g
s
.839 .426 0 r
.24928 .72744 m .24817 .72476 L .24437 .71965 L closepath p F P
0 g
s
.903 .519 .083 r
.23624 .70532 m .23243 .69273 L p .24817 .72476 L F P
0 g
s
.903 .519 .083 r
.24817 .72476 m .24437 .71965 L .23624 .70532 L p F P
0 g
s
.498 0 0 r
.37597 .84888 m .39634 .86121 L .3909 .85932 L p F P
0 g
s
.498 0 0 r
.37423 .84811 m .37597 .84888 L p .3909 .85932 L F P
0 g
s
0 0 0 r
.80917 .69288 m .80877 .69349 L .79873 .71751 L p F P
0 g
s
.964 .767 .326 r
.20948 .59986 m .20664 .58908 L .20827 .5691 L p F P
0 g
s
.909 .743 .248 r
.20581 .55156 m .20827 .5691 L .20664 .58908 L p F P
0 g
s
.957 .815 .377 r
.20827 .5691 m .20581 .55156 L .20936 .53105 L p F P
0 g
s
.811 .337 0 r
.29171 .78499 m .27825 .77282 L .26794 .75548 L p F P
0 g
s
.762 .299 0 r
.25628 .74252 m .26794 .75548 L .27825 .77282 L p F P
0 g
s
.846 .409 0 r
.24928 .72744 m .25628 .74252 L .26794 .75548 L p F P
0 g
s
0 0 .323 r
.50956 .3475 m .50776 .3516 L .50768 .37518 L p F P
0 g
s
.353 .193 .52 r
.78936 .57853 m .78175 .58448 L .78346 .60958 L p F P
0 g
s
.431 .249 .532 r
.78175 .58448 m .78346 .60958 L .76395 .62112 L p F P
0 g
s
.914 .689 .19 r
.20664 .58908 m .20948 .59986 L .21064 .62263 L p F P
0 g
s
.943 .707 .237 r
.21141 .62504 m .21064 .62263 L .20948 .59986 L p F P
0 g
s
0 0 0 r
.81926 .67454 m .80917 .69288 L .80557 .70718 L p F P
0 g
s
0 0 .097 r
.82183 .665 m .81926 .67454 L .80917 .69288 L p F P
0 g
s
0 0 .097 r
.82312 .6559 m .82183 .665 L p .80917 .69288 L F P
0 g
s
0 0 0 r
.79873 .71751 m .80557 .70718 L .80917 .69288 L p F P
0 g
s
.581 .006 0 r
.36212 .84387 m .35577 .83928 L .37423 .84811 L closepath p F P
0 g
s
.498 0 0 r
.36212 .84387 m .37423 .84811 L p .3909 .85932 L F P
0 g
s
.861 .494 0 r
.23624 .70532 m .23243 .69273 L .22461 .67947 L closepath p F P
0 g
s
.924 .586 .133 r
.22358 .67668 m .22018 .65951 L p .23243 .69273 L F P
0 g
s
.924 .586 .133 r
.23243 .69273 m .22461 .67947 L .22358 .67668 L p F P
0 g
s
.19 .076 .484 r
.80946 .52981 m .79723 .54487 L .79904 .56972 L p F P
0 g
s
.302 .156 .51 r
.78936 .57853 m .79904 .56972 L .79723 .54487 L p F P
0 g
s
.19 .076 .484 r
.79723 .54487 m .80946 .52981 L .80758 .50521 L p F P
0 g
s
0 0 .101 r
.83352 .61392 m .828 .63012 L .82497 .65183 L p F P
0 g
s
0 0 .242 r
.828 .63012 m .83352 .61392 L .83332 .59566 L p F P
0 g
s
0 0 .192 r
.82312 .6559 m .82497 .65183 L .828 .63012 L p F P
0 g
s
.773 .993 .783 r
.29759 .35121 m .30313 .34585 L .29988 .35018 L closepath p F P
0 g
s
.827 .998 .78 r
.29759 .35121 m .29988 .35018 L p .2757 .37515 L F P
0 g
s
.793 .999 .84 r
.31967 .33102 m .30313 .34585 L .29988 .35018 L p F P
0 g
s
.221 0 0 r
.49918 .8839 m .52123 .8863 L .51267 .88735 L p F P
0 g
s
.221 0 0 r
.48692 .88535 m .49918 .8839 L p .51267 .88735 L F P
0 g
s
.329 0 0 r
.49918 .8839 m .48692 .88535 L .465 .88078 L p F P
0 g
s
.078 0 0 r
.57754 .88102 m .58286 .87834 L .60663 .87353 L p F P
0 g
s
.186 0 0 r
.58286 .87834 m .57754 .88102 L .55523 .88294 L p F P
0 g
s
.069 0 .449 r
.8099 .50136 m .80758 .50521 L .80946 .52981 L p F P
0 g
s
.73 .231 0 r
.29171 .78499 m .2948 .78921 L .28134 .77704 L p F P
0 g
s
.73 .231 0 r
.28134 .77704 m .27825 .77282 L .29171 .78499 L p F P
0 g
s
.791 .371 0 r
.25628 .74252 m .24928 .72744 L .24437 .71965 L p F P
0 g
s
.78 .625 .063 r
.50268 .45895 m .50222 .45123 L .50234 .42714 L p F P
0 g
s
0 0 .048 r
.50299 .4162 m .50234 .42714 L .50222 .45123 L p F P
0 g
s
.788 .525 .538 r
.6113 .69177 m .58713 .68583 L .5867 .66021 L p F P
0 g
s
.822 .553 .532 r
.5724 .65522 m .5867 .66021 L .58713 .68583 L p F P
0 g
s
.352 0 0 r
.45506 .87772 m .465 .88078 L p .43068 .87332 L F P
0 g
s
.352 0 0 r
.43068 .87332 m .43515 .8736 L .45506 .87772 L p F P
0 g
s
.431 .249 .532 r
.76554 .64649 m .76395 .62112 L .78346 .60958 L p F P
0 g
s
.498 .299 .54 r
.76395 .62112 m .76554 .64649 L .74435 .65569 L p F P
0 g
s
.299 .779 .918 r
.49825 .25937 m .5203 .25651 L .51035 .25433 L p F P
0 g
s
.299 .779 .918 r
.48595 .25676 m .49825 .25937 L p .51035 .25433 L F P
0 g
s
.399 .837 .945 r
.49825 .25937 m .48595 .25676 L .46393 .26147 L p F P
0 g
s
.087 0 0 r
.55523 .88294 m .57754 .88102 L .56724 .88424 L p F P
0 g
s
.087 0 0 r
.54351 .88656 m .55523 .88294 L p .56724 .88424 L F P
0 g
s
.203 0 0 r
.55523 .88294 m .54351 .88656 L .52123 .8863 L p F P
0 g
s
.938 .649 .185 r
.21212 .6322 m .21141 .62504 L p .22018 .65951 L F P
0 g
s
.938 .649 .185 r
.22018 .65951 m .21547 .649 L .21212 .6322 L p F P
0 g
s
.877 .56 .048 r
.22358 .67668 m .22018 .65951 L .21547 .649 L closepath p F P
0 g
s
.545 .928 .887 r
.38531 .28673 m .39244 .28611 L .41256 .27592 L p F P
0 g
s
.629 .961 .896 r
.39244 .28611 m .38531 .28673 L .36347 .29911 L p F P
0 g
s
.457 .247 .505 r
.55351 .25441 m .5533 .23159 L .57361 .22052 L p F P
0 g
s
.943 .854 .424 r
.20936 .53105 m .20931 .52907 L .21141 .52316 L closepath p F P
0 g
s
0 0 0 r
.74558 .79321 m .76664 .76948 L .75135 .78361 L closepath p F P
0 g
s
0 0 0 r
.76755 .76832 m .76664 .76948 L .75135 .78361 L p F P
0 g
s
0 0 0 r
.75135 .78361 m .74558 .79321 L p .7273 .80857 L F P
0 g
s
.915 .902 .497 r
.22051 .47807 m .2241 .46891 L .22364 .47248 L closepath p F P
0 g
s
.835 .543 .496 r
.74598 .22109 m .732 .21501 L .73062 .19244 L p F P
0 g
s
.797 .512 .507 r
.70688 .18507 m .73062 .19244 L .732 .21501 L p F P
0 g
s
0 0 .313 r
.83218 .51997 m .83175 .53455 L .8355 .5537 L p F P
0 g
s
0 0 .441 r
.83006 .51049 m .82642 .49907 L p .83175 .53455 L F P
0 g
s
0 0 .441 r
.83175 .53455 m .83218 .51997 L .83006 .51049 L p F P
0 g
s
0 0 .323 r
.50768 .37518 m .50948 .37109 L .50956 .3475 L p F P
0 g
s
.036 0 .392 r
.51981 .33105 m .50956 .3475 L .50948 .37109 L p F P
0 g
s
.036 0 .392 r
.50956 .3475 m .51981 .33105 L .51982 .30771 L p F P
0 g
s
.195 .049 .444 r
.52839 .2978 m .51982 .30771 L .51981 .33105 L p F P
0 g
s
0 0 .201 r
.8345 .59118 m .83332 .59566 L .83352 .61392 L p F P
0 g
s
0 0 0 r
.6291 .86724 m .63348 .8642 L .65595 .8555 L p F P
0 g
s
.06 0 0 r
.63348 .8642 m .6291 .86724 L .60663 .87353 L p F P
0 g
s
.791 .371 0 r
.24437 .71965 m .23818 .71102 L p .25628 .74252 L F P
0 g
s
.875 .483 .019 r
.24437 .71965 m .23624 .70532 L .23818 .71102 L closepath p F P
0 g
s
.629 .089 0 r
.32062 .813 m .32818 .82054 L .31475 .8112 L p F P
0 g
s
.629 .089 0 r
.31475 .8112 m .30517 .80164 L .32062 .813 L p F P
0 g
s
.725 .204 0 r
.2948 .78921 m .30517 .80164 L .32062 .813 L p F P
0 g
s
.697 .96 .71 r
.30313 .34585 m .31364 .33356 L p .28801 .35721 L F P
0 g
s
.697 .96 .71 r
.28801 .35721 m .29759 .35121 L .30313 .34585 L p F P
0 g
s
.74 .988 .791 r
.30313 .34585 m .31364 .33356 L .31967 .33102 L closepath p F P
0 g
s
.265 .102 .464 r
.52839 .2978 m .53533 .29101 L .53524 .26792 L p F P
0 g
s
.069 0 .449 r
.80946 .52981 m .8118 .52598 L .8099 .50136 L p F P
0 g
s
.827 .998 .78 r
.2757 .37515 m .27617 .37436 L .29759 .35121 L p F P
0 g
s
.768 .98 .721 r
.27617 .37436 m .28801 .35721 L .29759 .35121 L closepath p F P
0 g
s
.738 .992 .846 r
.34206 .31345 m .34162 .31356 L .31967 .33102 L p F P
0 g
s
.67 .969 .784 r
.31364 .33356 m .31967 .33102 L .34162 .31356 L p F P
0 g
s
.684 .441 .548 r
.65997 .69593 m .67198 .6957 L .67297 .7216 L p F P
0 g
s
.684 .441 .548 r
.67297 .7216 m .66088 .72183 L .65997 .69593 L p F P
0 g
s
.703 .455 .547 r
.64323 .69551 m .65997 .69593 L .66088 .72183 L p F P
0 g
s
.663 .152 0 r
.30517 .80164 m .2948 .78921 L .28134 .77704 L p F P
0 g
s
.649 .413 .548 r
.67297 .7216 m .67198 .6957 L .69829 .69306 L p F P
0 g
s
.588 .348 .521 r
.59602 .21199 m .59553 .18941 L .61985 .18345 L p F P
0 g
s
.529 .302 .515 r
.59553 .18941 m .59602 .21199 L .57361 .22052 L p F P
0 g
s
.42 .862 .907 r
.43442 .26758 m .44206 .26798 L .46393 .26147 L p F P
0 g
s
.512 .907 .924 r
.44206 .26798 m .43442 .26758 L .41256 .27592 L p F P
0 g
s
.703 .455 .547 r
.66088 .72183 m .64403 .7214 L .64323 .69551 L p F P
0 g
s
.735 .481 .545 r
.61738 .69282 m .64323 .69551 L .64403 .7214 L p F P
0 g
s
.353 .193 .52 r
.78346 .60958 m .79112 .60366 L .78936 .57853 L p F P
0 g
s
.302 .156 .51 r
.79904 .56972 m .78936 .57853 L .79112 .60366 L p F P
0 g
s
.966 .687 .452 r
.52756 .57787 m .51555 .56437 L .51559 .53949 L p F P
0 g
s
.989 .723 .376 r
.50721 .5245 m .51559 .53949 L .51555 .56437 L p F P
0 g
s
.989 .723 .376 r
.51559 .53949 m .50721 .5245 L .5073 .49987 L p F P
0 g
s
.884 .622 .103 r
.21212 .6322 m .21141 .62504 L .21064 .62263 L closepath p F P
0 g
s
.667 .974 .846 r
.34162 .31356 m .34344 .3123 L .34206 .31345 L closepath p F P
0 g
s
.699 .981 .895 r
.36347 .29911 m .34344 .3123 L .34206 .31345 L p F P
0 g
s
0 0 .058 r
.82183 .665 m .82497 .65183 L .82312 .6559 L closepath p F P
0 g
s
.836 .863 .414 r
.2241 .46891 m .2289 .44848 L p .21654 .4864 L F P
0 g
s
.836 .863 .414 r
.21654 .4864 m .22051 .47807 L .2241 .46891 L p F P
0 g
s
.886 .925 .537 r
.2241 .46891 m .2289 .44848 L .23733 .43629 L p F P
0 g
s
.923 .643 .492 r
.54323 .61508 m .5276 .60301 L .52756 .57787 L p F P
0 g
s
.966 .687 .452 r
.51555 .56437 m .52756 .57787 L .5276 .60301 L p F P
0 g
s
.897 .789 .302 r
.20931 .52907 m .20936 .53105 L .20581 .55156 L p F P
0 g
s
.498 .299 .54 r
.74582 .68134 m .74435 .65569 L .76554 .64649 L p F P
0 g
s
.557 .343 .545 r
.74435 .65569 m .74582 .68134 L .72288 .68828 L p F P
0 g
s
.942 .715 .244 r
.50256 .48333 m .5073 .49987 L .50721 .5245 L p F P
0 g
s
.942 .715 .244 r
.5073 .49987 m .50256 .48333 L .50268 .45895 L p F P
0 g
s
.803 .982 .706 r
.27523 .37548 m .27617 .37436 L .2757 .37515 L closepath p F P
0 g
s
.855 .986 .708 r
.27523 .37548 m .2757 .37515 L p .25482 .4039 L F P
0 g
s
.447 0 0 r
.43068 .87332 m .42531 .87112 L .43515 .8736 L closepath p F P
0 g
s
.584 .935 .767 r
.32931 .31865 m .34162 .31356 L .34344 .3123 L p F P
0 g
s
.67 .969 .784 r
.34162 .31356 m .32931 .31865 L .31364 .33356 L p F P
0 g
s
.078 0 0 r
.60663 .87353 m .60001 .87691 L .57754 .88102 L p F P
0 g
s
0 0 0 r
.60001 .87691 m .60663 .87353 L .6291 .86724 L p F P
0 g
s
.822 .553 .532 r
.58713 .68583 m .57274 .68087 L .5724 .65522 L p F P
0 g
s
.842 .569 .527 r
.56264 .65118 m .5724 .65522 L .57274 .68087 L p F P
0 g
s
.584 .935 .767 r
.34344 .3123 m .35924 .30014 L p .32931 .31865 L F P
0 g
s
.639 .965 .843 r
.34344 .3123 m .35924 .30014 L .36347 .29911 L closepath p F P
0 g
s
0 0 0 r
.79873 .71751 m .80557 .70718 L p .78773 .73955 L F P
0 g
s
0 0 0 r
.78773 .73955 m .78899 .73628 L .79873 .71751 L p F P
0 g
s
0 0 .374 r
.83006 .51049 m .82642 .49907 L .8259 .49385 L closepath p F P
0 g
s
.718 .938 .623 r
.27617 .37436 m .28801 .35721 L p .26527 .38432 L F P
0 g
s
.718 .938 .623 r
.26527 .38432 m .27523 .37548 L .27617 .37436 L p F P
0 g
s
.855 .986 .708 r
.25482 .4039 m .25648 .40022 L .27523 .37548 L p F P
0 g
s
.789 .96 .641 r
.25648 .40022 m .26527 .38432 L .27523 .37548 L closepath p F P
0 g
s
.857 .562 .487 r
.74598 .22109 m .75538 .22597 L .75692 .24881 L p F P
0 g
s
.9 .597 .465 r
.77508 .26152 m .75692 .24881 L .75538 .22597 L p F P
0 g
s
.835 .915 .517 r
.24128 .4245 m .23733 .43629 L .2289 .44848 L p F P
0 g
s
.875 .961 .626 r
.25233 .40641 m .24128 .4245 L .23733 .43629 L p F P
0 g
s
.875 .961 .626 r
.25482 .4039 m .25233 .40641 L p .23733 .43629 L F P
0 g
s
0 0 0 r
.67844 .84436 m .69906 .83193 L .68155 .84142 L closepath p F P
0 g
s
0 0 0 r
.70093 .83072 m .69906 .83193 L .68155 .84142 L p F P
0 g
s
0 0 0 r
.68155 .84142 m .67844 .84436 L .65595 .8555 L p F P
0 g
s
.606 .381 .548 r
.69945 .71897 m .69829 .69306 L .72288 .68828 L p F P
0 g
s
.649 .413 .548 r
.69829 .69306 m .69945 .71897 L .67297 .7216 L p F P
0 g
s
.88 .603 .514 r
.56264 .65118 m .54338 .64048 L .54323 .61508 L p F P
0 g
s
.923 .643 .492 r
.5276 .60301 m .54323 .61508 L .54338 .64048 L p F P
0 g
s
.78 .625 .063 r
.50222 .45123 m .50268 .45895 L .50256 .48333 L p F P
0 g
s
.24 0 0 r
.465 .88078 m .48692 .88535 L .48133 .88503 L p F P
0 g
s
.24 0 0 r
.45241 .88003 m .465 .88078 L p .48133 .88503 L F P
0 g
s
.352 0 0 r
.465 .88078 m .45241 .88003 L .43068 .87332 L p F P
0 g
s
.847 .766 .257 r
.21003 .51202 m .20931 .52907 L .20567 .54696 L p F P
0 g
s
.91 .848 .398 r
.21589 .4908 m .21003 .51202 L .20931 .52907 L p F P
0 g
s
.897 .789 .302 r
.20581 .55156 m .20567 .54696 L .20931 .52907 L p F P
0 g
s
.735 .481 .545 r
.64403 .7214 m .61801 .71873 L .61738 .69282 L p F P
0 g
s
.761 .503 .542 r
.6113 .69177 m .61738 .69282 L .61801 .71873 L p F P
0 g
s
.835 .585 .037 r
.21064 .62263 m .20691 .6086 L p .21351 .64412 L F P
0 g
s
.835 .585 .037 r
.21351 .64412 m .21212 .6322 L .21064 .62263 L p F P
0 g
s
.914 .689 .19 r
.21064 .62263 m .20691 .6086 L .20664 .58908 L p F P
0 g
s
0 0 .201 r
.83352 .61392 m .83403 .61201 L .8345 .59118 L p F P
0 g
s
0 0 .107 r
.83715 .57374 m .8345 .59118 L .83403 .61201 L p F P
0 g
s
0 0 .254 r
.8345 .59118 m .83715 .57374 L .8355 .5537 L p F P
0 g
s
.824 .956 .616 r
.25233 .40641 m .25648 .40022 L .25482 .4039 L closepath p F P
0 g
s
.797 .512 .507 r
.732 .21501 m .7081 .20766 L .70688 .18507 L p F P
0 g
s
.766 .488 .513 r
.70084 .18376 m .70688 .18507 L .7081 .20766 L p F P
0 g
s
.761 .503 .542 r
.61801 .71873 m .61189 .71769 L .6113 .69177 L p F P
0 g
s
.788 .525 .538 r
.58713 .68583 m .6113 .69177 L .61189 .71769 L p F P
0 g
s
.814 .445 0 r
.23818 .71102 m .23624 .70532 L .22461 .67947 L p F P
0 g
s
.371 0 0 r
.42531 .87112 m .43068 .87332 L .41781 .87032 L p F P
0 g
s
.371 0 0 r
.41781 .87032 m .40015 .86307 L .42531 .87112 L p F P
0 g
s
.477 0 0 r
.39634 .86121 m .40015 .86307 L .42531 .87112 L p F P
0 g
s
0 0 0 r
.72333 .81355 m .74003 .79865 L .7273 .80857 L closepath p F P
0 g
s
0 0 0 r
.7273 .80857 m .72333 .81355 L .70093 .83072 L p F P
0 g
s
0 0 0 r
.74558 .79321 m .74003 .79865 L .7273 .80857 L p F P
0 g
s
.887 .878 .444 r
.21589 .4908 m .21654 .4864 L .22051 .47807 L closepath p F P
0 g
s
.556 .932 .831 r
.35924 .30014 m .36347 .29911 L .38531 .28673 L p F P
0 g
s
.766 .488 .513 r
.7081 .20766 m .70202 .20635 L .70084 .18376 L p F P
0 g
s
.736 .464 .517 r
.67501 .18038 m .70084 .18376 L .70202 .20635 L p F P
0 g
s
.774 .572 .001 r
.8132 .40064 m .81565 .41783 L .81759 .44196 L p F P
0 g
s
.774 .572 .001 r
.81565 .41783 m .8132 .40064 L .81129 .37676 L p F P
0 g
s
.512 0 0 r
.35577 .83928 m .36212 .84387 L .34881 .83678 L p F P
0 g
s
.512 0 0 r
.34881 .83678 m .33785 .82884 L .35577 .83928 L p F P
0 g
s
.618 .059 0 r
.32818 .82054 m .33785 .82884 L .35577 .83928 L p F P
0 g
s
0 0 .101 r
.83306 .62011 m .83352 .61392 L p .82497 .65183 L F P
0 g
s
0 0 .101 r
.82497 .65183 m .83116 .63377 L .83306 .62011 L p F P
0 g
s
0 0 0 r
.82497 .65183 m .83116 .63377 L p .82068 .67126 L F P
0 g
s
0 0 0 r
.82068 .67126 m .82183 .665 L .82497 .65183 L p F P
0 g
s
.945 .637 .424 r
.79099 .29854 m .77675 .28462 L .77508 .26152 L p F P
0 g
s
.9 .597 .465 r
.75692 .24881 m .77508 .26152 L .77675 .28462 L p F P
0 g
s
.637 .387 .522 r
.6205 .20604 m .61985 .18345 L .64616 .18013 L p F P
0 g
s
.588 .348 .521 r
.61985 .18345 m .6205 .20604 L .59602 .21199 L p F P
0 g
s
.911 .626 .132 r
.21547 .649 m .21212 .6322 L .21351 .64412 L closepath p F P
0 g
s
0 0 0 r
.65032 .85944 m .65595 .8555 L .67844 .84436 L p F P
0 g
s
0 0 0 r
.65595 .8555 m .65032 .85944 L .6291 .86724 L p F P
0 g
s
.834 .645 .099 r
.20414 .5716 m .20664 .58908 L .20691 .6086 L p F P
0 g
s
.909 .743 .248 r
.20664 .58908 m .20414 .5716 L .20581 .55156 L p F P
0 g
s
.842 .569 .527 r
.57274 .68087 m .56292 .67686 L .56264 .65118 L p F P
0 g
s
.88 .603 .514 r
.54338 .64048 m .56264 .65118 L .56292 .67686 L p F P
0 g
s
.446 .881 .867 r
.40718 .27635 m .41256 .27592 L .43442 .26758 L p F P
0 g
s
.545 .928 .887 r
.41256 .27592 m .40718 .27635 L .38531 .28673 L p F P
0 g
s
.857 .562 .487 r
.75692 .24881 m .74746 .24394 L .74598 .22109 L p F P
0 g
s
.835 .543 .496 r
.732 .21501 m .74598 .22109 L .74746 .24394 L p F P
0 g
s
0 0 0 r
.56724 .88424 m .57754 .88102 L .60001 .87691 L p F P
0 g
s
0 .047 .615 r
.80306 .43194 m .79927 .42203 L .79519 .41369 L p F P
0 g
s
0 0 .048 r
.50222 .45123 m .50287 .44034 L .50299 .4162 L p F P
0 g
s
0 0 .221 r
.50759 .39906 m .50299 .4162 L .50287 .44034 L p F P
0 g
s
0 0 .221 r
.50299 .4162 m .50759 .39906 L .50768 .37518 L p F P
0 g
s
0 0 0 r
.78522 .7427 m .78773 .73955 L .78899 .73628 L closepath p F P
0 g
s
.731 .903 .525 r
.25648 .40022 m .26527 .38432 L p .24552 .41476 L F P
0 g
s
.731 .903 .525 r
.24552 .41476 m .25233 .40641 L .25648 .40022 L p F P
0 g
s
.943 .669 .206 r
.80493 .3606 m .81129 .37676 L .8132 .40064 L p F P
0 g
s
.943 .669 .206 r
.81129 .37676 m .80493 .3606 L .80307 .33698 L p F P
0 g
s
.529 .302 .515 r
.57395 .24337 m .57361 .22052 L .59602 .21199 L p F P
0 g
s
.457 .247 .505 r
.57361 .22052 m .57395 .24337 L .55351 .25441 L p F P
0 g
s
0 0 .321 r
.8259 .49385 m .82428 .48244 L p .83213 .51742 L F P
0 g
s
0 0 .321 r
.83213 .51742 m .83006 .51049 L .8259 .49385 L p F P
0 g
s
.976 .672 .347 r
.80307 .33698 m .79277 .32191 L .79099 .29854 L p F P
0 g
s
.945 .637 .424 r
.77675 .28462 m .79099 .29854 L .79277 .32191 L p F P
0 g
s
.542 0 0 r
.33785 .82884 m .32818 .82054 L .31475 .8112 L p F P
0 g
s
.193 .711 .88 r
.51035 .25433 m .5203 .25651 L .54259 .25546 L p F P
0 g
s
.099 0 0 r
.51267 .88735 m .52123 .8863 L .54351 .88656 L p F P
0 g
s
.976 .672 .347 r
.79277 .32191 m .80307 .33698 L .80493 .3606 L p F P
0 g
s
.195 .049 .444 r
.51981 .33105 m .52844 .32117 L .52839 .2978 L p F P
0 g
s
.265 .102 .464 r
.53533 .29101 m .52839 .2978 L .52844 .32117 L p F P
0 g
s
.736 .464 .517 r
.70202 .20635 m .67603 .20298 L .67501 .18038 L p F P
0 g
s
.7 .435 .521 r
.65821 .17985 m .67501 .18038 L .67603 .20298 L p F P
0 g
s
.557 .343 .545 r
.72421 .71423 m .72288 .68828 L .74582 .68134 L p F P
0 g
s
.606 .381 .548 r
.72288 .68828 m .72421 .71423 L .69945 .71897 L p F P
0 g
s
.678 .419 .522 r
.64616 .18013 m .65821 .17985 L .65911 .20245 L p F P
0 g
s
.678 .419 .522 r
.65911 .20245 m .64698 .20273 L .64616 .18013 L p F P
0 g
s
.637 .387 .522 r
.64616 .18013 m .64698 .20273 L .6205 .20604 L p F P
0 g
s
.258 0 0 r
.43068 .87332 m .45241 .88003 L .44525 .87837 L p F P
0 g
s
.258 0 0 r
.41781 .87032 m .43068 .87332 L p .44525 .87837 L F P
0 g
s
.829 .517 0 r
.21547 .649 m .21351 .64412 L p .22393 .67824 L F P
0 g
s
.829 .517 0 r
.22393 .67824 m .22358 .67668 L .21547 .649 L p F P
0 g
s
0 0 0 r
.78522 .7427 m .78773 .73955 L p .76728 .76882 L F P
0 g
s
0 0 0 r
.76728 .76882 m .76755 .76832 L .78522 .7427 L p F P
0 g
s
.7 .435 .521 r
.67603 .20298 m .65911 .20245 L .65821 .17985 L p F P
0 g
s
0 0 .323 r
.50948 .37109 m .50768 .37518 L .50759 .39906 L p F P
0 g
s
.803 .928 .552 r
.24128 .4245 m .24552 .41476 L .25233 .40641 L closepath p F P
0 g
s
.762 .299 0 r
.27825 .77282 m .26657 .75988 L .25628 .74252 L p F P
0 g
s
.685 .248 0 r
.2464 .72877 m .25628 .74252 L .26657 .75988 L p F P
0 g
s
.791 .371 0 r
.23818 .71102 m .2464 .72877 L .25628 .74252 L p F P
0 g
s
.353 .193 .52 r
.79112 .60366 m .78346 .60958 L .78519 .63501 L p F P
0 g
s
.431 .249 .532 r
.78346 .60958 m .78519 .63501 L .76554 .64649 L p F P
0 g
s
.705 .318 0 r
.23012 .69641 m .23818 .71102 L .2464 .72877 L p F P
0 g
s
.814 .445 0 r
.22393 .67824 m .23012 .69641 L .23818 .71102 L p F P
0 g
s
.814 .445 0 r
.22461 .67947 m .22393 .67824 L p .23818 .71102 L F P
0 g
s
.319 .804 .878 r
.45799 .26112 m .46393 .26147 L .48595 .25676 L p F P
0 g
s
.42 .862 .907 r
.46393 .26147 m .45799 .26112 L .43442 .26758 L p F P
0 g
s
0 0 0 r
.6226 .87059 m .6291 .86724 L .65032 .85944 L p F P
0 g
s
0 0 0 r
.6291 .86724 m .6226 .87059 L .60001 .87691 L p F P
0 g
s
.898 .556 .074 r
.22461 .67947 m .22358 .67668 L .22393 .67824 L closepath p F P
0 g
s
.19 .076 .484 r
.81136 .55473 m .79904 .56972 L .80087 .5949 L p F P
0 g
s
.302 .156 .51 r
.79112 .60366 m .80087 .5949 L .79904 .56972 L p F P
0 g
s
.19 .076 .484 r
.79904 .56972 m .81136 .55473 L .80946 .52981 L p F P
0 g
s
.66 .18 0 r
.27825 .77282 m .28134 .77704 L .26789 .76169 L p F P
0 g
s
.66 .18 0 r
.26789 .76169 m .26657 .75988 L .27825 .77282 L p F P
0 g
s
0 0 .161 r
.83584 .54261 m .8355 .5537 L .83715 .57374 L p F P
0 g
s
0 0 .313 r
.8355 .5537 m .83584 .54261 L .83218 .51997 L p F P
0 g
s
.46 .885 .807 r
.37809 .28844 m .38531 .28673 L .40718 .27635 L p F P
0 g
s
.556 .932 .831 r
.38531 .28673 m .37809 .28844 L .35924 .30014 L p F P
0 g
s
0 0 .395 r
.83218 .51997 m .83006 .51049 L .83213 .51742 L closepath p F P
0 g
s
.827 .804 .313 r
.21654 .4864 m .21589 .4908 L .21003 .51202 L p F P
0 g
s
.069 0 .449 r
.8118 .52598 m .80946 .52981 L .81136 .55473 L p F P
0 g
s
0 0 0 r
.67844 .84436 m .67033 .8501 L .65032 .85944 L p F P
0 g
s
0 0 0 r
.67033 .8501 m .67844 .84436 L .69906 .83193 L p F P
0 g
s
.72 .39 0 r
.2177 .66274 m .22393 .67824 L .23012 .69641 L p F P
0 g
s
.829 .517 0 r
.21351 .64412 m .2177 .66274 L .22393 .67824 L p F P
0 g
s
.78 .625 .063 r
.50256 .48333 m .5021 .47564 L .50222 .45123 L p F P
0 g
s
0 0 .048 r
.50287 .44034 m .50222 .45123 L .5021 .47564 L p F P
0 g
s
0 0 0 r
.81926 .67454 m .82068 .67126 L .82183 .665 L closepath p F P
0 g
s
.788 .525 .538 r
.61189 .71769 m .58757 .71179 L .58713 .68583 L p F P
0 g
s
.822 .553 .532 r
.57274 .68087 m .58713 .68583 L .58757 .71179 L p F P
0 g
s
.608 .925 .688 r
.30498 .33892 m .31364 .33356 L .32931 .31865 L p F P
0 g
s
.697 .96 .71 r
.31364 .33356 m .30498 .33892 L p .28801 .35721 L F P
0 g
s
.498 0 0 r
.3909 .85932 m .37857 .85384 L .36212 .84387 L p F P
0 g
s
.409 0 0 r
.37857 .85384 m .36212 .84387 L .34881 .83678 L p F P
0 g
s
.431 .249 .532 r
.76715 .67219 m .76554 .64649 L .78519 .63501 L p F P
0 g
s
.498 .299 .54 r
.76554 .64649 m .76715 .67219 L .74582 .68134 L p F P
0 g
s
.394 0 0 r
.40015 .86307 m .3909 .85932 L .39634 .86121 L closepath p F P
0 g
s
0 0 0 r
.79859 .7232 m .78773 .73955 L .7813 .75124 L p F P
0 g
s
0 0 0 r
.80187 .71688 m .79859 .7232 L .78773 .73955 L p F P
0 g
s
0 0 0 r
.80557 .70718 m .80187 .71688 L p .78773 .73955 L F P
0 g
s
0 0 0 r
.78773 .73955 m .7813 .75124 L .76728 .76882 L p F P
0 g
s
.835 .543 .496 r
.74746 .24394 m .73339 .23787 L .732 .21501 L p F P
0 g
s
.797 .512 .507 r
.7081 .20766 m .732 .21501 L .73339 .23787 L p F P
0 g
s
.826 .698 .16 r
.20567 .54696 m .20581 .55156 L .20414 .5716 L p F P
0 g
s
0 0 .264 r
.83213 .51742 m .83218 .51997 L .83584 .54261 L p F P
0 g
s
0 0 .061 r
.83306 .62011 m .83403 .61201 L .83352 .61392 L closepath p F P
0 g
s
0 0 .323 r
.50759 .39906 m .50941 .39499 L .50948 .37109 L p F P
0 g
s
.036 0 .392 r
.5198 .35469 m .50948 .37109 L .50941 .39499 L p F P
0 g
s
.036 0 .392 r
.50948 .37109 m .5198 .35469 L .51981 .33105 L p F P
0 g
s
.546 .029 0 r
.30517 .80164 m .31475 .8112 L .30126 .79904 L p F P
0 g
s
.546 .029 0 r
.30126 .79904 m .29169 .78948 L .30517 .80164 L p F P
0 g
s
.663 .152 0 r
.28134 .77704 m .29169 .78948 L .30517 .80164 L p F P
0 g
s
.481 .885 .739 r
.34942 .30414 m .35924 .30014 L .37809 .28844 L p F P
0 g
s
.584 .935 .767 r
.35924 .30014 m .34942 .30414 L p .32931 .31865 L F P
0 g
s
0 0 0 r
.80187 .71688 m .81046 .69834 L .80557 .70718 L closepath p F P
0 g
s
0 0 0 r
.80557 .70718 m .81046 .69834 L .81926 .67454 L p F P
0 g
s
.195 .049 .444 r
.52844 .32117 m .51981 .33105 L .5198 .35469 L p F P
0 g
s
0 0 0 r
.76664 .76948 m .76728 .76882 L .76755 .76832 L closepath p F P
0 g
s
0 0 0 r
.76664 .76948 m .76728 .76882 L p .74412 .79511 L F P
0 g
s
0 0 0 r
.74412 .79511 m .74558 .79321 L .76664 .76948 L p F P
0 g
s
.835 .585 .037 r
.20691 .6086 m .20913 .62769 L .21351 .64412 L p F P
0 g
s
.729 .459 0 r
.20913 .62769 m .21351 .64412 L .2177 .66274 L p F P
0 g
s
.835 .915 .517 r
.2289 .44848 m .22913 .44779 L .24128 .4245 L p F P
0 g
s
.736 .855 .423 r
.24552 .41476 m .24128 .4245 L .22913 .44779 L p F P
0 g
s
0 0 0 r
.69906 .83193 m .70062 .83102 L p .67033 .8501 L F P
0 g
s
0 0 0 r
.69906 .83193 m .70062 .83102 L .70093 .83072 L closepath p F P
0 g
s
.571 .091 0 r
.29169 .78948 m .28134 .77704 L .26789 .76169 L p F P
0 g
s
.335 .818 .834 r
.42912 .26797 m .43442 .26758 L .45799 .26112 L p F P
0 g
s
.446 .881 .867 r
.43442 .26758 m .42912 .26797 L .40718 .27635 L p F P
0 g
s
.274 0 0 r
.40015 .86307 m .41781 .87032 L p .38322 .85623 L F P
0 g
s
.274 0 0 r
.38322 .85623 m .3909 .85932 L .40015 .86307 L p F P
0 g
s
.369 .181 .489 r
.53543 .3144 m .53533 .29101 L .55373 .27754 L p F P
0 g
s
.265 .102 .464 r
.52844 .32117 m .53543 .3144 L .53533 .29101 L p F P
0 g
s
0 0 0 r
.70062 .83102 m .70093 .83072 L .72333 .81355 L p F P
0 g
s
0 0 .394 r
.81871 .5096 m .8118 .52598 L .81372 .55093 L p F P
0 g
s
.069 0 .449 r
.81136 .55473 m .81372 .55093 L .8118 .52598 L p F P
0 g
s
.684 .441 .548 r
.66088 .72183 m .67297 .7216 L .67397 .74784 L p F P
0 g
s
.684 .441 .548 r
.67397 .74784 m .66181 .74806 L .66088 .72183 L p F P
0 g
s
.703 .455 .547 r
.64403 .7214 m .66088 .72183 L .66181 .74806 L p F P
0 g
s
0 0 0 r
.7813 .75124 m .76728 .76882 L .7593 .77927 L p F P
0 g
s
0 0 0 r
.76728 .76882 m .7593 .77927 L .74412 .79511 L p F P
0 g
s
0 0 0 r
.83403 .61201 m .83669 .59465 L p .83197 .63012 L F P
0 g
s
0 0 0 r
.83197 .63012 m .83306 .62011 L .83403 .61201 L p F P
0 g
s
0 0 .107 r
.83403 .61201 m .83669 .59465 L .83715 .57374 L p F P
0 g
s
.649 .413 .548 r
.67397 .74784 m .67297 .7216 L .69945 .71897 L p F P
0 g
s
0 0 0 r
.82068 .67126 m .81926 .67454 L .81046 .69834 L p F P
0 g
s
.755 .769 .264 r
.22038 .46998 m .21654 .4864 L .21142 .50261 L p F P
0 g
s
.827 .804 .313 r
.21003 .51202 m .21142 .50261 L .21654 .4864 L p F P
0 g
s
.836 .863 .414 r
.22834 .44966 m .22038 .46998 L .21654 .4864 L p F P
0 g
s
.836 .863 .414 r
.2289 .44848 m .22834 .44966 L p .21654 .4864 L F P
0 g
s
.588 .348 .521 r
.59652 .23486 m .59602 .21199 L .6205 .20604 L p F P
0 g
s
.529 .302 .515 r
.59602 .21199 m .59652 .23486 L .57395 .24337 L p F P
0 g
s
.703 .455 .547 r
.66181 .74806 m .64484 .74765 L .64403 .7214 L p F P
0 g
s
.735 .481 .545 r
.61801 .71873 m .64403 .7214 L .64484 .74765 L p F P
0 g
s
0 0 0 r
.72333 .81355 m .71813 .81853 L .70062 .83102 L p F P
0 g
s
0 0 0 r
.70062 .83102 m .69076 .83801 L p .67033 .8501 L F P
0 g
s
.412 .807 .578 r
.69076 .83801 m .70062 .83102 L .71813 .81853 L p F P
0 g
s
.353 .193 .52 r
.78519 .63501 m .79291 .62912 L .79112 .60366 L p F P
0 g
s
.302 .156 .51 r
.80087 .5949 m .79112 .60366 L .79291 .62912 L p F P
0 g
s
0 0 .264 r
.83584 .54261 m .83572 .53669 L .83213 .51742 L p F P
0 g
s
0 0 .169 r
.82979 .50091 m .83213 .51742 L .83572 .53669 L p F P
0 g
s
0 0 .321 r
.82428 .48244 m .82979 .50091 L .83213 .51742 L p F P
0 g
s
.966 .687 .452 r
.5276 .60301 m .51552 .58957 L .51555 .56437 L p F P
0 g
s
.989 .723 .376 r
.50712 .54945 m .51555 .56437 L .51552 .58957 L p F P
0 g
s
.989 .723 .376 r
.51555 .56437 m .50712 .54945 L .50721 .5245 L p F P
0 g
s
0 0 0 r
.5915 .87959 m .60001 .87691 L .6226 .87059 L p F P
0 g
s
0 0 0 r
.60001 .87691 m .5915 .87959 L .56724 .88424 L p F P
0 g
s
.923 .643 .492 r
.54338 .64048 m .52765 .62848 L .5276 .60301 L p F P
0 g
s
.966 .687 .452 r
.51552 .58957 m .5276 .60301 L .52765 .62848 L p F P
0 g
s
.498 .299 .54 r
.7473 .70733 m .74582 .68134 L .76715 .67219 L p F P
0 g
s
.557 .343 .545 r
.74582 .68134 m .7473 .70733 L .72421 .71423 L p F P
0 g
s
.942 .715 .244 r
.50243 .50803 m .50721 .5245 L .50712 .54945 L p F P
0 g
s
.942 .715 .244 r
.50721 .5245 m .50243 .50803 L .50256 .48333 L p F P
0 g
s
0 0 0 r
.71813 .81853 m .72333 .81355 L .74003 .79865 L p F P
0 g
s
0 0 0 r
.74003 .79865 m .74412 .79511 L .74558 .79321 L closepath p F P
0 g
s
0 0 0 r
.74003 .79865 m .74412 .79511 L p .71813 .81853 L F P
0 g
s
.822 .553 .532 r
.58757 .71179 m .57308 .70686 L .57274 .68087 L p F P
0 g
s
.842 .569 .527 r
.56292 .67686 m .57274 .68087 L .57308 .70686 L p F P
0 g
s
0 0 .56 r
.79927 .42203 m .79519 .41369 L .79685 .41609 L closepath p F P
0 g
s
.351 .823 .772 r
.39857 .27835 m .40718 .27635 L .42912 .26797 L p F P
0 g
s
.46 .885 .807 r
.40718 .27635 m .39857 .27835 L .37809 .28844 L p F P
0 g
s
.221 0 0 r
.51267 .88735 m .49937 .88672 L .48692 .88535 L p F P
0 g
s
.113 0 0 r
.49937 .88672 m .48133 .88503 L .48692 .88535 L closepath p F P
0 g
s
.753 .654 .097 r
.20626 .53269 m .20567 .54696 L .204 .56702 L p F P
0 g
s
.847 .766 .257 r
.20567 .54696 m .20626 .53269 L .21003 .51202 L p F P
0 g
s
.826 .698 .16 r
.20414 .5716 m .204 .56702 L .20567 .54696 L p F P
0 g
s
.857 .562 .487 r
.74746 .24394 m .75692 .24881 L .75848 .27195 L p F P
0 g
s
.9 .597 .465 r
.77675 .28462 m .75848 .27195 L .75692 .24881 L p F P
0 g
s
.81952 .46573 m
.8201 .46665 L
s
.606 .381 .548 r
.70063 .74523 m .69945 .71897 L .72421 .71423 L p F P
0 g
s
.649 .413 .548 r
.69945 .71897 m .70063 .74523 L .67397 .74784 L p F P
0 g
s
.419 0 0 r
.33785 .82884 m .34881 .83678 L .33541 .82717 L p F P
0 g
s
.419 0 0 r
.33541 .82717 m .32214 .81755 L .33785 .82884 L p F P
0 g
s
.542 0 0 r
.31475 .8112 m .32214 .81755 L .33785 .82884 L p F P
0 g
s
.88 .603 .514 r
.56292 .67686 m .54353 .66622 L .54338 .64048 L p F P
0 g
s
.923 .643 .492 r
.52765 .62848 m .54338 .64048 L .54353 .66622 L p F P
0 g
s
.78 .625 .063 r
.5021 .47564 m .50256 .48333 L .50243 .50803 L p F P
0 g
s
.735 .481 .545 r
.64484 .74765 m .61866 .74499 L .61801 .71873 L p F P
0 g
s
.761 .503 .542 r
.61189 .71769 m .61801 .71873 L .61866 .74499 L p F P
0 g
s
.731 .524 0 r
.20441 .59119 m .20691 .6086 L .20913 .62769 L p F P
0 g
s
.834 .645 .099 r
.20691 .6086 m .20441 .59119 L .20414 .5716 L p F P
0 g
s
0 0 0 r
.82575 .6565 m .82068 .67126 L .8164 .68461 L p F P
0 g
s
0 0 0 r
.83116 .63377 m .82575 .6565 L .82068 .67126 L p F P
0 g
s
0 0 0 r
.81046 .69834 m .8164 .68461 L .82068 .67126 L p F P
0 g
s
.627 .901 .594 r
.28243 .36213 m .29713 .34653 L .28801 .35721 L closepath p F P
0 g
s
.697 .96 .71 r
.30498 .33892 m .29713 .34653 L .28801 .35721 L p F P
0 g
s
.718 .938 .623 r
.28801 .35721 m .28243 .36213 L p .26527 .38432 L F P
0 g
s
0 0 0 r
.83116 .63377 m .83197 .63012 L .83306 .62011 L closepath p F P
0 g
s
0 0 0 r
.64528 .86205 m .65032 .85944 L .67033 .8501 L p F P
0 g
s
0 0 0 r
.65032 .85944 m .64528 .86205 L .6226 .87059 L p F P
0 g
s
.797 .512 .507 r
.73339 .23787 m .70934 .23054 L .7081 .20766 L p F P
0 g
s
.766 .488 .513 r
.70202 .20635 m .7081 .20766 L .70934 .23054 L p F P
0 g
s
.388 0 0 r
.38322 .85623 m .37857 .85384 L .3909 .85932 L closepath p F P
0 g
s
.212 .735 .839 r
.49889 .25507 m .48323 .25658 L .48595 .25676 L closepath p F P
0 g
s
.319 .804 .878 r
.48595 .25676 m .48323 .25658 L .45799 .26112 L p F P
0 g
s
.299 .779 .918 r
.51035 .25433 m .49889 .25507 L .48595 .25676 L p F P
0 g
s
.087 0 0 r
.56724 .88424 m .55753 .88536 L .54351 .88656 L p F P
0 g
s
0 0 0 r
.55753 .88536 m .54103 .88687 L .54351 .88656 L closepath p F P
0 g
s
.099 0 0 r
.54351 .88656 m .54103 .88687 L .51267 .88735 L p F P
0 g
s
.761 .503 .542 r
.61866 .74499 m .61249 .74396 L .61189 .71769 L p F P
0 g
s
.788 .525 .538 r
.58757 .71179 m .61189 .71769 L .61249 .74396 L p F P
0 g
s
.766 .488 .513 r
.70934 .23054 m .70322 .22924 L .70202 .20635 L p F P
0 g
s
.736 .464 .517 r
.67603 .20298 m .70202 .20635 L .70322 .22924 L p F P
0 g
s
0 0 .489 r
.79685 .41609 m .79519 .41369 L .7845 .39517 L p F P
0 g
s
.774 .572 .001 r
.81759 .44196 m .81514 .42484 L .8132 .40064 L p F P
0 g
s
.216 .74 .788 r
.45117 .2616 m .45799 .26112 L .48323 .25658 L p F P
0 g
s
.335 .818 .834 r
.45799 .26112 m .45117 .2616 L .42912 .26797 L p F P
0 g
s
.945 .637 .424 r
.79277 .32191 m .77845 .30803 L .77675 .28462 L p F P
0 g
s
.9 .597 .465 r
.75848 .27195 m .77675 .28462 L .77845 .30803 L p F P
0 g
s
.637 .387 .522 r
.62116 .22893 m .6205 .20604 L .64698 .20273 L p F P
0 g
s
.588 .348 .521 r
.6205 .20604 m .62116 .22893 L .59652 .23486 L p F P
0 g
s
.085 .633 .831 r
.55046 .25574 m .53962 .25479 L .54259 .25546 L closepath p F P
0 g
s
.193 .711 .88 r
.54259 .25546 m .53962 .25479 L .51035 .25433 L p F P
0 g
s
0 0 0 r
.74412 .79511 m .73604 .80289 L p .71813 .81853 L F P
0 g
s
.532 .838 .523 r
.73604 .80289 m .74412 .79511 L .7593 .77927 L p F P
0 g
s
.739 .7 .162 r
.21142 .50261 m .21003 .51202 L .20626 .53269 L p F P
0 g
s
.842 .569 .527 r
.57308 .70686 m .5632 .70287 L .56292 .67686 L p F P
0 g
s
.88 .603 .514 r
.54353 .66622 m .56292 .67686 L .5632 .70287 L p F P
0 g
s
.764 .835 .375 r
.22834 .44966 m .22913 .44779 L .2289 .44848 L closepath p F P
0 g
s
.857 .562 .487 r
.75848 .27195 m .74896 .2671 L .74746 .24394 L p F P
0 g
s
.835 .543 .496 r
.73339 .23787 m .74746 .24394 L .74896 .2671 L p F P
0 g
s
0 0 .115 r
.83572 .53669 m .83584 .54261 L .83751 .56269 L p F P
0 g
s
0 0 .161 r
.83715 .57374 m .83751 .56269 L .83584 .54261 L p F P
0 g
s
0 0 .221 r
.50287 .44034 m .5075 .42327 L .50759 .39906 L p F P
0 g
s
0 0 .048 r
.5021 .47564 m .50275 .4648 L .50287 .44034 L p F P
0 g
s
0 0 .221 r
.5075 .42327 m .50287 .44034 L .50275 .4648 L p F P
0 g
s
0 0 0 r
.83751 .56269 m .83715 .57374 L .83669 .59465 L p F P
0 g
s
.943 .669 .206 r
.80681 .38454 m .8132 .40064 L .81514 .42484 L p F P
0 g
s
.943 .669 .206 r
.8132 .40064 m .80681 .38454 L .80493 .3606 L p F P
0 g
s
.736 .855 .423 r
.22913 .44779 m .23786 .4277 L .24552 .41476 L p F P
0 g
s
.732 .799 .32 r
.22038 .46998 m .22263 .46323 L .22834 .44966 L closepath p F P
0 g
s
0 0 0 r
.22913 .44779 m .23786 .4277 L p .22263 .46323 L F P
0 g
s
0 0 0 r
.22263 .46323 m .22834 .44966 L .22913 .44779 L p F P
0 g
s
.976 .672 .347 r
.80493 .3606 m .79457 .34558 L .79277 .32191 L p F P
0 g
s
.945 .637 .424 r
.77845 .30803 m .79277 .32191 L .79457 .34558 L p F P
0 g
s
.619 .227 0 r
.7884 .40076 m .79685 .41609 L .80612 .43288 L p F P
0 g
s
0 0 .489 r
.7845 .39517 m .7884 .40076 L .79685 .41609 L p F P
0 g
s
.639 .862 .488 r
.25941 .39147 m .27196 .37461 L .26527 .38432 L closepath p F P
0 g
s
.718 .938 .623 r
.28243 .36213 m .27196 .37461 L .26527 .38432 L p F P
0 g
s
.731 .903 .525 r
.26527 .38432 m .25941 .39147 L p .24552 .41476 L F P
0 g
s
.976 .672 .347 r
.79457 .34558 m .80493 .3606 L .80681 .38454 L p F P
0 g
s
.195 .049 .444 r
.5198 .35469 m .52848 .34484 L .52844 .32117 L p F P
0 g
s
.265 .102 .464 r
.53543 .3144 m .52844 .32117 L .52848 .34484 L p F P
0 g
s
.736 .464 .517 r
.70322 .22924 m .67705 .22588 L .67603 .20298 L p F P
0 g
s
.7 .435 .521 r
.65911 .20245 m .67603 .20298 L .67705 .22588 L p F P
0 g
s
0 0 0 r
.50911 .88744 m .51267 .88735 L .54103 .88687 L p F P
0 g
s
.119 0 0 r
.50911 .88744 m .49937 .88672 L .51267 .88735 L closepath p F P
0 g
s
.557 .343 .545 r
.72556 .74051 m .72421 .71423 L .7473 .70733 L p F P
0 g
s
.606 .381 .548 r
.72421 .71423 m .72556 .74051 L .70063 .74523 L p F P
0 g
s
.678 .419 .522 r
.64698 .20273 m .65911 .20245 L .66003 .22534 L p F P
0 g
s
.678 .419 .522 r
.66003 .22534 m .64782 .22563 L .64698 .20273 L p F P
0 g
s
.637 .387 .522 r
.64698 .20273 m .64782 .22563 L .62116 .22893 L p F P
0 g
s
0 0 0 r
.79859 .7232 m .80039 .71986 L .80187 .71688 L closepath p F P
0 g
s
.679 .794 .33 r
.81046 .69834 m .8164 .68461 L p .80039 .71986 L F P
0 g
s
.679 .794 .33 r
.80039 .71986 m .80187 .71688 L .81046 .69834 L p F P
0 g
s
0 0 0 r
.6226 .87059 m .61423 .87324 L .5915 .87959 L p F P
0 g
s
.29 .778 .708 r
.61423 .87324 m .6226 .87059 L .64528 .86205 L p F P
0 g
s
.24 0 0 r
.48133 .88503 m .46229 .8821 L .45241 .88003 L p F P
0 g
s
0 .459 .711 r
.46229 .8821 m .44525 .87837 L .45241 .88003 L closepath p F P
0 g
s
.7 .435 .521 r
.67705 .22588 m .66003 .22534 L .65911 .20245 L p F P
0 g
s
0 .075 .559 r
.32214 .81755 m .31475 .8112 L .30126 .79904 L p F P
0 g
s
0 0 .323 r
.50941 .39499 m .50759 .39906 L .5075 .42327 L p F P
0 g
s
.642 .81 .377 r
.25354 .40024 m .24552 .41476 L .23786 .4277 L p F P
0 g
s
.731 .903 .525 r
.25941 .39147 m .25354 .40024 L .24552 .41476 L p F P
0 g
s
0 0 0 r
.54103 .88687 m .53154 .8871 L .50911 .88744 L p F P
0 g
s
.13 .678 .769 r
.53154 .8871 m .54103 .88687 L .55753 .88536 L p F P
0 g
s
.353 .193 .52 r
.79291 .62912 m .78519 .63501 L .78694 .66078 L p F P
0 g
s
.431 .249 .532 r
.78519 .63501 m .78694 .66078 L .76715 .67219 L p F P
0 g
s
.133 0 0 r
.47445 .88409 m .46229 .8821 L .48133 .88503 L closepath p F P
0 g
s
0 .567 .758 r
.49937 .88672 m .50911 .88744 L p .47445 .88409 L F P
0 g
s
0 .567 .758 r
.47445 .88409 m .48133 .88503 L .49937 .88672 L p F P
0 g
s
.365 .817 .698 r
.37152 .2911 m .37809 .28844 L .39857 .27835 L p F P
0 g
s
.481 .885 .739 r
.37809 .28844 m .37152 .2911 L .34942 .30414 L p F P
0 g
s
.727 .582 .006 r
.204 .56702 m .20414 .5716 L .20441 .59119 L p F P
0 g
s
.235 .747 .725 r
.42064 .26992 m .42912 .26797 L .45117 .2616 L p F P
0 g
s
.351 .823 .772 r
.42912 .26797 m .42064 .26992 L .39857 .27835 L p F P
0 g
s
.094 .651 .73 r
.48323 .25658 m .49889 .25507 L p .49615 .25491 L F P
0 g
s
.094 .651 .73 r
.47337 .25725 m .48323 .25658 L p .49615 .25491 L F P
0 g
s
.216 .74 .788 r
.48323 .25658 m .47337 .25725 L .45117 .2616 L p F P
0 g
s
.705 .318 0 r
.2464 .72877 m .23834 .7142 L .23012 .69641 L p F P
0 g
s
.685 .248 0 r
.25454 .74251 m .2464 .72877 L p .26657 .75988 L F P
0 g
s
0 0 .383 r
.2464 .72877 m .25454 .74251 L .24133 .71925 L p F P
0 g
s
0 0 .383 r
.24133 .71925 m .23834 .7142 L .2464 .72877 L p F P
0 g
s
.19 .076 .484 r
.81329 .57999 m .80087 .5949 L .80273 .62041 L p F P
0 g
s
.19 .076 .484 r
.80087 .5949 m .81329 .57999 L .81136 .55473 L p F P
0 g
s
.302 .156 .51 r
.79291 .62912 m .80273 .62041 L .80087 .5949 L p F P
0 g
s
.685 .248 0 r
.26657 .75988 m .26288 .75476 L .25454 .74251 L p F P
0 g
s
0 0 .423 r
.26789 .76169 m .26657 .75988 L .26288 .75476 L closepath p F P
0 g
s
.707 .708 .179 r
.83197 .63012 m .83116 .63377 L .82575 .6565 L p F P
0 g
s
0 .539 .721 r
.55046 .25574 m .56516 .25693 L .55547 .25592 L p F P
0 g
s
0 .539 .721 r
.53962 .25479 m .55046 .25574 L p .55547 .25592 L F P
0 g
s
0 .22 .664 r
.70697 .31446 m .69652 .30698 L .70273 .31179 L closepath p F P
0 g
s
.501 .872 .654 r
.32727 .31991 m .33651 .3131 L .32931 .31865 L closepath p F P
0 g
s
.608 .925 .688 r
.32931 .31865 m .32727 .31991 L .30498 .33892 L p F P
0 g
s
.584 .935 .767 r
.34942 .30414 m .33651 .3131 L .32931 .31865 L p F P
0 g
s
.069 0 .449 r
.81372 .55093 m .81136 .55473 L .81329 .57999 L p F P
0 g
s
.72 .39 0 r
.23012 .69641 m .22389 .68096 L .2177 .66274 L p F P
0 g
s
0 0 .334 r
.22389 .68096 m .23012 .69641 L .23834 .7142 L p F P
0 g
s
0 0 0 r
.56599 .88448 m .55753 .88536 L .56724 .88424 L closepath p F P
0 g
s
.13 .678 .769 r
.55753 .88536 m .56599 .88448 L p .53154 .8871 L F P
0 g
s
0 .273 .667 r
.37857 .85384 m .38322 .85623 L .36998 .8487 L p F P
0 g
s
.409 0 0 r
.34881 .83678 m .36 .84357 L .37857 .85384 L p F P
0 g
s
0 .273 .667 r
.36998 .8487 m .36 .84357 L .37857 .85384 L p F P
0 g
s
.78 .625 .063 r
.50243 .50803 m .50197 .50037 L .5021 .47564 L p F P
0 g
s
0 0 .048 r
.50275 .4648 m .5021 .47564 L .50197 .50037 L p F P
0 g
s
.196 .722 .844 r
.50817 .25411 m .49889 .25507 L .51035 .25433 L closepath p F P
0 g
s
.094 .651 .73 r
.49889 .25507 m .50817 .25411 L .49615 .25491 L p F P
0 g
s
.788 .525 .538 r
.61249 .74396 m .58801 .7381 L .58757 .71179 L p F P
0 g
s
.822 .553 .532 r
.57308 .70686 m .58757 .71179 L .58801 .7381 L p F P
0 g
s
0 .539 .721 r
.53062 .25386 m .53962 .25479 L p .55547 .25592 L F P
0 g
s
.074 .634 .787 r
.53962 .25479 m .53062 .25386 L .50817 .25411 L p F P
0 g
s
.074 .634 .787 r
.50817 .25411 m .51035 .25433 L .53962 .25479 L p F P
0 g
s
.431 .249 .532 r
.76879 .69824 m .76715 .67219 L .78694 .66078 L p F P
0 g
s
.498 .299 .54 r
.76715 .67219 m .76879 .69824 L .7473 .70733 L p F P
0 g
s
.571 .091 0 r
.26789 .76169 m .28021 .7765 L .29169 .78948 L p F P
0 g
s
0 0 .525 r
.28021 .7765 m .26789 .76169 L .26288 .75476 L p F P
0 g
s
.457 .247 .505 r
.55395 .30097 m .55373 .27754 L .5743 .26653 L p F P
0 g
s
.369 .181 .489 r
.55373 .27754 m .55395 .30097 L .53543 .3144 L p F P
0 g
s
0 0 0 r
.56599 .88448 m .56724 .88424 L .5915 .87959 L p F P
0 g
s
.59113 .2614 m
.59135 .26143 L
s
.835 .543 .496 r
.74896 .2671 m .7348 .26104 L .73339 .23787 L p F P
0 g
s
.797 .512 .507 r
.70934 .23054 m .73339 .23787 L .7348 .26104 L p F P
0 g
s
0 .034 .553 r
.29169 .78948 m .30126 .79904 L .28777 .78404 L p F P
0 g
s
0 .034 .553 r
.28777 .78404 m .28021 .7765 L .29169 .78948 L p F P
0 g
s
.258 0 0 r
.44525 .87837 m .43324 .87509 L .41781 .87032 L p F P
0 g
s
.274 0 0 r
.41781 .87032 m .40477 .86508 L .38322 .85623 L p F P
0 g
s
0 .424 .746 r
.43324 .87509 m .41781 .87032 L .40477 .86508 L p F P
0 g
s
0 0 .323 r
.5075 .42327 m .50933 .41921 L .50941 .39499 L p F P
0 g
s
.036 0 .392 r
.51979 .37865 m .50941 .39499 L .50933 .41921 L p F P
0 g
s
.036 0 .392 r
.50941 .39499 m .51979 .37865 L .5198 .35469 L p F P
0 g
s
0 0 .115 r
.83751 .56269 m .83739 .55679 L .83572 .53669 L p F P
0 g
s
0 0 .169 r
.83572 .53669 m .8334 .52023 L .82979 .50091 L p F P
0 g
s
.767 .567 0 r
.8334 .52023 m .83572 .53669 L .83739 .55679 L p F P
0 g
s
.729 .459 0 r
.2177 .66274 m .21332 .64636 L .20913 .62769 L p F P
0 g
s
0 0 .277 r
.21332 .64636 m .2177 .66274 L .22389 .68096 L p F P
0 g
s
0 .236 .673 r
.36 .84357 m .34881 .83678 L .33541 .82717 L p F P
0 g
s
.499 .846 .579 r
.30233 .34103 m .30498 .33892 L .32727 .31991 L p F P
0 g
s
.602 .9 .617 r
.29713 .34653 m .30233 .34103 L .30498 .33892 L closepath p F P
0 g
s
.195 .049 .444 r
.52848 .34484 m .5198 .35469 L .51979 .37865 L p F P
0 g
s
.614 .869 .523 r
.27196 .37461 m .27809 .36679 L .28243 .36213 L closepath p F P
0 g
s
0 0 0 r
.29713 .34653 m .30233 .34103 L p .27809 .36679 L F P
0 g
s
0 0 0 r
.27809 .36679 m .28243 .36213 L .29713 .34653 L p F P
0 g
s
.753 .654 .097 r
.204 .56702 m .20458 .5528 L .20626 .53269 L p F P
0 g
s
.727 .582 .006 r
.20441 .59119 m .20434 .58924 L .204 .56702 L p F P
0 g
s
0 0 .071 r
.20458 .5528 m .204 .56702 L .20434 .58924 L p F P
0 g
s
0 0 0 r
.83669 .59465 m .83408 .61644 L .83197 .63012 L p F P
0 g
s
.762 .732 .206 r
.83408 .61644 m .83197 .63012 L .82851 .64411 L p F P
0 g
s
.707 .708 .179 r
.82575 .6565 m .82851 .64411 L .83197 .63012 L p F P
0 g
s
.122 .666 .83 r
.53154 .8871 m .50911 .88744 L .49678 .88574 L p F P
0 g
s
0 .567 .758 r
.50911 .88744 m .49678 .88574 L .47445 .88409 L p F P
0 g
s
.461 0 0 r
.69652 .30698 m .70697 .31446 L .72419 .32761 L p F P
0 g
s
0 0 0 r
.5915 .87959 m .58863 .88015 L .56599 .88448 L p F P
0 g
s
.253 .765 .827 r
.58863 .88015 m .56599 .88448 L .55417 .88476 L p F P
0 g
s
.13 .678 .769 r
.56599 .88448 m .55417 .88476 L .53154 .8871 L p F P
0 g
s
.369 .181 .489 r
.53552 .3381 m .53543 .3144 L .55395 .30097 L p F P
0 g
s
.265 .102 .464 r
.52848 .34484 m .53552 .3381 L .53543 .3144 L p F P
0 g
s
0 .381 .762 r
.38322 .85623 m .40477 .86508 L .39656 .86039 L p F P
0 g
s
0 .381 .762 r
.36998 .8487 m .38322 .85623 L p .39656 .86039 L F P
0 g
s
0 0 .394 r
.82069 .53463 m .81372 .55093 L .81566 .5762 L p F P
0 g
s
.069 0 .449 r
.81329 .57999 m .81566 .5762 L .81372 .55093 L p F P
0 g
s
0 0 .394 r
.81372 .55093 m .82069 .53463 L .81871 .5096 L p F P
0 g
s
.499 .846 .579 r
.32727 .31991 m .31869 .3267 L .30233 .34103 L p F P
0 g
s
0 0 0 r
.31869 .3267 m .32727 .31991 L .33651 .3131 L p F P
0 g
s
.684 .441 .548 r
.66181 .74806 m .67397 .74784 L .67499 .77443 L p F P
0 g
s
.684 .441 .548 r
.67499 .77443 m .66274 .77465 L .66181 .74806 L p F P
0 g
s
.703 .455 .547 r
.64484 .74765 m .66181 .74806 L .66274 .77465 L p F P
0 g
s
0 .541 .8 r
.46229 .8821 m .47445 .88409 L p .43964 .87672 L F P
0 g
s
0 .541 .8 r
.43964 .87672 m .44525 .87837 L .46229 .8821 L p F P
0 g
s
.649 .413 .548 r
.67499 .77443 m .67397 .74784 L .70063 .74523 L p F P
0 g
s
.588 .348 .521 r
.59702 .25804 m .59652 .23486 L .62116 .22893 L p F P
0 g
s
0 0 0 r
.67033 .8501 m .66802 .8513 L .64528 .86205 L p F P
0 g
s
.407 .85 .751 r
.63548 .86514 m .64528 .86205 L .66802 .8513 L p F P
0 g
s
.29 .778 .708 r
.64528 .86205 m .63548 .86514 L .61423 .87324 L p F P
0 g
s
.703 .455 .547 r
.66274 .77465 m .64567 .77424 L .64484 .74765 L p F P
0 g
s
.735 .481 .545 r
.61866 .74499 m .64484 .74765 L .64567 .77424 L p F P
0 g
s
0 0 0 r
.73604 .80289 m .7304 .80791 L .71813 .81853 L p F P
0 g
s
.512 .862 .61 r
.71345 .82185 m .7304 .80791 L .71813 .81853 L closepath p F P
0 g
s
.412 .807 .578 r
.71813 .81853 m .71345 .82185 L .69076 .83801 L p F P
0 g
s
0 0 0 r
.69076 .83801 m .68128 .84373 L .67033 .8501 L p F P
0 g
s
.383 .815 .649 r
.66802 .8513 m .68128 .84373 L .67033 .8501 L closepath p F P
0 g
s
.353 .193 .52 r
.78694 .66078 m .79471 .65493 L .79291 .62912 L p F P
0 g
s
.302 .156 .51 r
.80273 .62041 m .79291 .62912 L .79471 .65493 L p F P
0 g
s
.966 .687 .452 r
.52765 .62848 m .51548 .61511 L .51552 .58957 L p F P
0 g
s
.989 .723 .376 r
.50702 .57473 m .51552 .58957 L .51548 .61511 L p F P
0 g
s
.989 .723 .376 r
.51552 .58957 m .50702 .57473 L .50712 .54945 L p F P
0 g
s
.755 .769 .264 r
.21142 .50261 m .21402 .49148 L .22038 .46998 L p F P
0 g
s
.739 .7 .162 r
.20626 .53269 m .208 .5208 L .21142 .50261 L p F P
0 g
s
0 0 0 r
.21402 .49148 m .21142 .50261 L .208 .5208 L p F P
0 g
s
.486 .869 .668 r
.33651 .3131 m .3469 .30557 L .34942 .30414 L closepath p F P
0 g
s
0 0 0 r
.33651 .3131 m .3469 .30557 L p .31869 .3267 L F P
0 g
s
.024 0 0 r
.49615 .25491 m .50817 .25411 L .53062 .25386 L p F P
0 g
s
0 0 0 r
.7813 .75124 m .7825 .74943 L .79859 .7232 L p F P
0 g
s
.69 .859 .45 r
.80039 .71986 m .79859 .7232 L .7825 .74943 L p F P
0 g
s
.923 .643 .492 r
.54353 .66622 m .52769 .65428 L .52765 .62848 L p F P
0 g
s
.966 .687 .452 r
.51548 .61511 m .52765 .62848 L .52769 .65428 L p F P
0 g
s
.593 .16 0 r
.26288 .75476 m .25454 .74251 L .25694 .74608 L closepath p F P
0 g
s
0 0 .525 r
.26288 .75476 m .25694 .74608 L p .28021 .7765 L F P
0 g
s
.498 .299 .54 r
.74881 .73366 m .7473 .70733 L .76879 .69824 L p F P
0 g
s
.557 .343 .545 r
.7473 .70733 m .74881 .73366 L .72556 .74051 L p F P
0 g
s
.942 .715 .244 r
.50231 .53306 m .50712 .54945 L .50702 .57473 L p F P
0 g
s
.942 .715 .244 r
.50712 .54945 m .50231 .53306 L .50243 .50803 L p F P
0 g
s
0 .189 .669 r
.32214 .81755 m .33541 .82717 L .32194 .81501 L p F P
0 g
s
0 .189 .669 r
.32194 .81501 m .30865 .8054 L .32214 .81755 L p F P
0 g
s
0 .075 .559 r
.30126 .79904 m .30865 .8054 L .32214 .81755 L p F P
0 g
s
0 0 .286 r
.82091 .4989 m .81871 .5096 L .82069 .53463 L p F P
0 g
s
.822 .553 .532 r
.58801 .7381 m .57343 .7332 L .57308 .70686 L p F P
0 g
s
.842 .569 .527 r
.5632 .70287 m .57308 .70686 L .57343 .7332 L p F P
0 g
s
0 0 0 r
.22263 .46323 m .22038 .46998 L .21402 .49148 L p F P
0 g
s
.731 .524 0 r
.20524 .59835 m .20441 .59119 L p .20913 .62769 L F P
0 g
s
.731 .524 0 r
.20913 .62769 m .20715 .61398 L .20524 .59835 L p F P
0 g
s
0 0 .214 r
.20715 .61398 m .20913 .62769 L .21332 .64636 L p F P
0 g
s
0 0 0 r
.208 .5208 m .20626 .53269 L .20458 .5528 L p F P
0 g
s
.589 .149 0 r
.7884 .40076 m .7845 .39517 L .77397 .38031 L p F P
0 g
s
.857 .562 .487 r
.74896 .2671 m .75848 .27195 L .76006 .29539 L p F P
0 g
s
.9 .597 .465 r
.77845 .30803 m .76006 .29539 L .75848 .27195 L p F P
0 g
s
.62 .826 .423 r
.25354 .40024 m .2565 .39564 L .25941 .39147 L closepath p F P
0 g
s
0 0 0 r
.27196 .37461 m .27809 .36679 L p .2565 .39564 L F P
0 g
s
0 0 0 r
.2565 .39564 m .25941 .39147 L .27196 .37461 L p F P
0 g
s
.776 .511 0 r
.82545 .48479 m .82979 .50091 L .8334 .52023 L p F P
0 g
s
.374 .803 .625 r
.3469 .30557 m .34942 .30414 L .37152 .2911 L p F P
0 g
s
.251 .76 .75 r
.58863 .88015 m .5915 .87959 L .61423 .87324 L p F P
0 g
s
.606 .381 .548 r
.70183 .77184 m .70063 .74523 L .72556 .74051 L p F P
0 g
s
.649 .413 .548 r
.70063 .74523 m .70183 .77184 L .67499 .77443 L p F P
0 g
s
.88 .603 .514 r
.5632 .70287 m .54368 .6923 L .54353 .66622 L p F P
0 g
s
.923 .643 .492 r
.52769 .65428 m .54353 .66622 L .54368 .6923 L p F P
0 g
s
.78 .625 .063 r
.50197 .50037 m .50243 .50803 L .50231 .53306 L p F P
0 g
s
.735 .481 .545 r
.64567 .77424 m .61931 .7716 L .61866 .74499 L p F P
0 g
s
.761 .503 .542 r
.61249 .74396 m .61866 .74499 L .61931 .7716 L p F P
0 g
s
0 0 0 r
.83669 .59465 m .83716 .58025 L .83751 .56269 L p F P
0 g
s
.802 .708 .171 r
.83716 .58025 m .83669 .59465 L .83408 .61644 L p F P
0 g
s
.365 .817 .698 r
.39857 .27835 m .39362 .28035 L .37152 .2911 L p F P
0 g
s
0 0 0 r
.39362 .28035 m .39857 .27835 L .42064 .26992 L p F P
0 g
s
.235 .747 .725 r
.45117 .2616 m .44429 .26317 L .42064 .26992 L p F P
0 g
s
0 0 0 r
.44429 .26317 m .45117 .2616 L .47337 .25725 L p F P
0 g
s
.746 .611 .042 r
.83739 .55679 m .83751 .56269 L .83716 .58025 L p F P
0 g
s
.797 .512 .507 r
.7348 .26104 m .71059 .25373 L .70934 .23054 L p F P
0 g
s
.766 .488 .513 r
.70322 .22924 m .70934 .23054 L .71059 .25373 L p F P
0 g
s
0 0 0 r
.31869 .3267 m .30233 .34103 L .29297 .35106 L p F P
0 g
s
0 0 0 r
.30233 .34103 m .29297 .35106 L .27809 .36679 L p F P
0 g
s
0 .437 .717 r
.43964 .87672 m .43324 .87509 L .44525 .87837 L closepath p F P
0 g
s
.761 .503 .542 r
.61931 .7716 m .6131 .77057 L .61249 .74396 L p F P
0 g
s
.788 .525 .538 r
.58801 .7381 m .61249 .74396 L .6131 .77057 L p F P
0 g
s
0 .513 .767 r
.58854 .26099 m .5871 .26069 L .56516 .25693 L p F P
0 g
s
.58783 .26084 m
.59113 .2614 L
s
.154 0 0 r
.5871 .26069 m .55547 .25592 L .56516 .25693 L closepath p F P
0 g
s
.753 .879 .464 r
.79321 .72966 m .80686 .7049 L .80039 .71986 L closepath p F P
0 g
s
.679 .794 .33 r
.81437 .68869 m .80686 .7049 L .80039 .71986 L p F P
0 g
s
.679 .794 .33 r
.8164 .68461 m .81437 .68869 L p .80039 .71986 L F P
0 g
s
.69 .859 .45 r
.79321 .72966 m .80039 .71986 L p .7825 .74943 L F P
0 g
s
0 0 0 r
.8164 .68461 m .81794 .68013 L .82575 .6565 L p F P
0 g
s
.796 .815 .333 r
.82851 .64411 m .82575 .6565 L .81794 .68013 L p F P
0 g
s
.622 .837 .446 r
.78046 .75234 m .7825 .74943 L .7813 .75124 L closepath p F P
0 g
s
0 0 0 r
.78046 .75234 m .7813 .75124 L p .7593 .77927 L F P
0 g
s
.766 .488 .513 r
.71059 .25373 m .70444 .25243 L .70322 .22924 L p F P
0 g
s
.736 .464 .517 r
.67705 .22588 m .70322 .22924 L .70444 .25243 L p F P
0 g
s
.945 .637 .424 r
.79457 .34558 m .78016 .33175 L .77845 .30803 L p F P
0 g
s
.9 .597 .465 r
.76006 .29539 m .77845 .30803 L .78016 .33175 L p F P
0 g
s
.637 .387 .522 r
.62183 .25213 m .62116 .22893 L .64782 .22563 L p F P
0 g
s
.588 .348 .521 r
.62116 .22893 m .62183 .25213 L .59702 .25804 L p F P
0 g
s
.51 .906 .78 r
.68128 .84373 m .66802 .8513 L .65723 .85466 L p F P
0 g
s
.407 .85 .751 r
.66802 .8513 m .65723 .85466 L p .63548 .86514 L F P
0 g
s
.842 .569 .527 r
.57343 .7332 m .56348 .72924 L .5632 .70287 L p F P
0 g
s
.88 .603 .514 r
.54368 .6923 m .5632 .70287 L .56348 .72924 L p F P
0 g
s
.461 0 0 r
.69207 .30394 m .69652 .30698 L p .72419 .32761 L F P
0 g
s
.857 .562 .487 r
.76006 .29539 m .75048 .29056 L .74896 .2671 L p F P
0 g
s
.835 .543 .496 r
.7348 .26104 m .74896 .2671 L .75048 .29056 L p F P
0 g
s
0 0 .221 r
.50275 .4648 m .50741 .44779 L .5075 .42327 L p F P
0 g
s
0 0 .048 r
.50197 .50037 m .50263 .48958 L .50275 .4648 L p F P
0 g
s
0 0 .221 r
.50741 .44779 m .50275 .4648 L .50263 .48958 L p F P
0 g
s
.108 .637 .871 r
.49678 .88574 m .47445 .88409 L .4618 .88034 L p F P
0 g
s
0 .541 .8 r
.47445 .88409 m .4618 .88034 L .43964 .87672 L p F P
0 g
s
0 0 .147 r
.20524 .59835 m .20441 .59119 L .20434 .58924 L closepath p F P
0 g
s
.619 .227 0 r
.80612 .43288 m .79767 .41757 L .7884 .40076 L p F P
0 g
s
.751 .926 .57 r
.7825 .74943 m .79253 .73077 L p .77221 .76019 L F P
0 g
s
.751 .926 .57 r
.77221 .76019 m .78046 .75234 L .7825 .74943 L p F P
0 g
s
.69 .859 .45 r
.7825 .74943 m .79253 .73077 L .79321 .72966 L p F P
0 g
s
.943 .669 .206 r
.81514 .42484 m .80872 .4088 L .80681 .38454 L p F P
0 g
s
.943 .669 .206 r
.80872 .4088 m .81514 .42484 L .8171 .44936 L p F P
0 g
s
.457 .247 .505 r
.5743 .26653 m .57466 .28999 L .55395 .30097 L p F P
0 g
s
.976 .672 .347 r
.80681 .38454 m .7964 .36957 L .79457 .34558 L p F P
0 g
s
.945 .637 .424 r
.78016 .33175 m .79457 .34558 L .7964 .36957 L p F P
0 g
s
.374 .803 .625 r
.37152 .2911 m .3662 .29412 L .3469 .30557 L p F P
0 g
s
0 0 0 r
.3662 .29412 m .37152 .2911 L .39362 .28035 L p F P
0 g
s
0 0 .484 r
.25694 .74608 m .25454 .74251 L .24133 .71925 L p F P
0 g
s
.723 .29 0 r
.77787 .3859 m .7884 .40076 L .79767 .41757 L p F P
0 g
s
.589 .149 0 r
.77397 .38031 m .77787 .3859 L .7884 .40076 L p F P
0 g
s
0 0 0 r
.7593 .77927 m .7608 .77739 L .78046 .75234 L p F P
0 g
s
.686 .906 .56 r
.7608 .77739 m .77221 .76019 L .78046 .75234 L closepath p F P
0 g
s
0 0 0 r
.3662 .29412 m .3469 .30557 L .33659 .31375 L p F P
0 g
s
0 0 0 r
.3469 .30557 m .33659 .31375 L .31869 .3267 L p F P
0 g
s
.976 .672 .347 r
.7964 .36957 m .80681 .38454 L .80872 .4088 L p F P
0 g
s
.51 .906 .78 r
.6889 .83889 m .68128 .84373 L p .65723 .85466 L F P
0 g
s
.447 .857 .691 r
.68128 .84373 m .6889 .83889 L .69076 .83801 L closepath p F P
0 g
s
.195 .049 .444 r
.51979 .37865 m .52853 .36884 L .52848 .34484 L p F P
0 g
s
.265 .102 .464 r
.53552 .3381 m .52848 .34484 L .52853 .36884 L p F P
0 g
s
.642 .81 .377 r
.23786 .4277 m .23976 .42425 L .25354 .40024 L p F P
0 g
s
0 0 0 r
.2565 .39564 m .25354 .40024 L .23976 .42425 L p F P
0 g
s
0 .139 .654 r
.30865 .8054 m .30126 .79904 L .28777 .78404 L p F P
0 g
s
0 .333 .762 r
.36 .84357 m .36998 .8487 L .35663 .83885 L p F P
0 g
s
0 .333 .762 r
.35663 .83885 m .34397 .83236 L .36 .84357 L p F P
0 g
s
0 .236 .673 r
.33541 .82717 m .34397 .83236 L .36 .84357 L p F P
0 g
s
.736 .464 .517 r
.70444 .25243 m .6781 .24908 L .67705 .22588 L p F P
0 g
s
.7 .435 .521 r
.66003 .22534 m .67705 .22588 L .6781 .24908 L p F P
0 g
s
.557 .343 .545 r
.72692 .76715 m .72556 .74051 L .74881 .73366 L p F P
0 g
s
.606 .381 .548 r
.72556 .74051 m .72692 .76715 L .70183 .77184 L p F P
0 g
s
.251 .76 .75 r
.61423 .87324 m .61141 .87378 L .58863 .88015 L p F P
0 g
s
.369 .837 .869 r
.61141 .87378 m .58863 .88015 L .57698 .88038 L p F P
0 g
s
.253 .765 .827 r
.55417 .88476 m .57698 .88038 L .58863 .88015 L p F P
0 g
s
0 .424 .746 r
.40477 .86508 m .40932 .86649 L .43324 .87509 L p F P
0 g
s
0 .503 .824 r
.43324 .87509 m .43964 .87672 L .42671 .8709 L p F P
0 g
s
0 .503 .824 r
.42671 .8709 m .40932 .86649 L .43324 .87509 L p F P
0 g
s
0 0 0 r
.22966 .44705 m .22263 .46323 L .21789 .47985 L p F P
0 g
s
0 0 0 r
.23528 .43383 m .22966 .44705 L .22263 .46323 L p F P
0 g
s
0 0 0 r
.23786 .4277 m .23528 .43383 L p .22263 .46323 L F P
0 g
s
0 0 0 r
.21402 .49148 m .21789 .47985 L .22263 .46323 L p F P
0 g
s
.678 .419 .522 r
.64782 .22563 m .66003 .22534 L .66096 .24855 L p F P
0 g
s
.678 .419 .522 r
.66096 .24855 m .64867 .24883 L .64782 .22563 L p F P
0 g
s
.637 .387 .522 r
.64782 .22563 m .64867 .24883 L .62183 .25213 L p F P
0 g
s
.7 .435 .521 r
.6781 .24908 m .66096 .24855 L .66003 .22534 L p F P
0 g
s
0 0 .323 r
.50933 .41921 m .5075 .42327 L .50741 .44779 L p F P
0 g
s
.74 .817 .35 r
.81437 .68869 m .81794 .68013 L .8164 .68461 L closepath p F P
0 g
s
.353 .193 .52 r
.79471 .65493 m .78694 .66078 L .78872 .68689 L p F P
0 g
s
.431 .249 .532 r
.78694 .66078 m .78872 .68689 L .76879 .69824 L p F P
0 g
s
0 0 .229 r
.20434 .58924 m .20504 .57239 L p .20687 .61026 L F P
0 g
s
0 0 .229 r
.20687 .61026 m .20524 .59835 L .20434 .58924 L p F P
0 g
s
0 0 .071 r
.20434 .58924 m .20504 .57239 L .20458 .5528 L p F P
0 g
s
.615 .878 .545 r
.75842 .78012 m .7608 .77739 L .7593 .77927 L closepath p F P
0 g
s
.532 .838 .523 r
.7593 .77927 m .75842 .78012 L .73604 .80289 L p F P
0 g
s
.55 .911 .719 r
.6889 .83889 m .69076 .83801 L .71345 .82185 L p F P
0 g
s
.19 .076 .484 r
.81525 .60558 m .80273 .62041 L .80461 .64626 L p F P
0 g
s
.19 .076 .484 r
.80273 .62041 m .81525 .60558 L .81329 .57999 L p F P
0 g
s
.302 .156 .51 r
.79471 .65493 m .80461 .64626 L .80273 .62041 L p F P
0 g
s
0 0 0 r
.29297 .35106 m .27809 .36679 L .26986 .37859 L p F P
0 g
s
0 0 0 r
.27809 .36679 m .26986 .37859 L .2565 .39564 L p F P
0 g
s
.746 .611 .042 r
.83716 .58025 m .83711 .57773 L .83739 .55679 L p F P
0 g
s
.863 .683 .153 r
.83507 .54039 m .83739 .55679 L .83711 .57773 L p F P
0 g
s
.767 .567 0 r
.83739 .55679 m .83507 .54039 L .8334 .52023 L p F P
0 g
s
.247 .752 .886 r
.53154 .8871 m .55417 .88476 L .54394 .88328 L p F P
0 g
s
.247 .752 .886 r
.51934 .88539 m .53154 .8871 L p .54394 .88328 L F P
0 g
s
.122 .666 .83 r
.49678 .88574 m .51934 .88539 L .53154 .8871 L p F P
0 g
s
.069 0 .449 r
.81566 .5762 m .81329 .57999 L .81525 .60558 L p F P
0 g
s
.364 .832 .794 r
.61141 .87378 m .61423 .87324 L .63548 .86514 L p F P
0 g
s
.78 .625 .063 r
.50231 .53306 m .50184 .52544 L .50197 .50037 L p F P
0 g
s
0 0 .048 r
.50263 .48958 m .50197 .50037 L .50184 .52544 L p F P
0 g
s
0 .034 .598 r
.24949 .73134 m .25694 .74608 L .27075 .76266 L p F P
0 g
s
0 0 .484 r
.24133 .71925 m .24949 .73134 L .25694 .74608 L p F P
0 g
s
0 0 .525 r
.25694 .74608 m .27075 .76266 L .28021 .7765 L p F P
0 g
s
.788 .525 .538 r
.6131 .77057 m .58846 .76475 L .58801 .7381 L p F P
0 g
s
.822 .553 .532 r
.57343 .7332 m .58801 .7381 L .58846 .76475 L p F P
0 g
s
0 0 .464 r
.24133 .71925 m .23834 .7142 L .23564 .70748 L closepath p F P
0 g
s
0 0 .334 r
.22841 .69073 m .22389 .68096 L p .23834 .7142 L F P
0 g
s
0 0 .334 r
.23834 .7142 m .23564 .70748 L .22841 .69073 L p F P
0 g
s
.431 .249 .532 r
.77045 .72463 m .76879 .69824 L .78872 .68689 L p F P
0 g
s
.498 .299 .54 r
.76879 .69824 m .77045 .72463 L .74881 .73366 L p F P
0 g
s
0 0 0 r
.41577 .27188 m .42064 .26992 L .44429 .26317 L p F P
0 g
s
0 0 0 r
.42064 .26992 m .41577 .27188 L .39362 .28035 L p F P
0 g
s
.736 .956 .662 r
.7608 .77739 m .75842 .78012 L .74875 .78655 L p F P
0 g
s
.736 .956 .662 r
.77221 .76019 m .7608 .77739 L p .74875 .78655 L F P
0 g
s
.668 .935 .656 r
.75842 .78012 m .74875 .78655 L p .73428 .80408 L F P
0 g
s
.668 .935 .656 r
.73428 .80408 m .73604 .80289 L .75842 .78012 L p F P
0 g
s
0 0 0 r
.208 .5208 m .20998 .51231 L .21402 .49148 L p F P
0 g
s
0 0 0 r
.21789 .47985 m .21402 .49148 L .20998 .51231 L p F P
0 g
s
.637 .948 .734 r
.70576 .82542 m .71345 .82185 L .7304 .80791 L p F P
0 g
s
.55 .911 .719 r
.71345 .82185 m .70576 .82542 L .6889 .83889 L p F P
0 g
s
.457 .247 .505 r
.55417 .32471 m .55395 .30097 L .57466 .28999 L p F P
0 g
s
.369 .181 .489 r
.55395 .30097 m .55417 .32471 L .53552 .3381 L p F P
0 g
s
0 0 .144 r
.20715 .61398 m .20524 .59835 L .20687 .61026 L closepath p F P
0 g
s
0 0 0 r
.23528 .43383 m .23976 .42425 L .23786 .4277 L closepath p F P
0 g
s
.835 .543 .496 r
.75048 .29056 m .73623 .28452 L .7348 .26104 L p F P
0 g
s
.797 .512 .507 r
.71059 .25373 m .7348 .26104 L .73623 .28452 L p F P
0 g
s
0 0 .286 r
.82069 .53463 m .82291 .52397 L .82091 .4989 L p F P
0 g
s
0 .092 .632 r
.28021 .7765 m .28777 .78404 L .27428 .76617 L p F P
0 g
s
0 .092 .632 r
.27428 .76617 m .27075 .76266 L .28021 .7765 L p F P
0 g
s
.089 .597 .892 r
.4618 .88034 m .43964 .87672 L .42671 .8709 L p F P
0 g
s
0 0 0 r
.26986 .37859 m .2565 .39564 L .24949 .40919 L p F P
0 g
s
0 0 0 r
.23976 .42425 m .24949 .40919 L .2565 .39564 L p F P
0 g
s
.036 0 .392 r
.50933 .41921 m .51979 .40294 L .51979 .37865 L p F P
0 g
s
0 0 .323 r
.50741 .44779 m .50925 .44375 L .50933 .41921 L p F P
0 g
s
.036 0 .392 r
.51979 .40294 m .50933 .41921 L .50925 .44375 L p F P
0 g
s
.637 .948 .734 r
.7304 .80791 m .73428 .80408 L p .70576 .82542 L F P
0 g
s
.583 .901 .64 r
.7304 .80791 m .73428 .80408 L .73604 .80289 L closepath p F P
0 g
s
0 0 .412 r
.22841 .69073 m .22389 .68096 L .2215 .672 L closepath p F P
0 g
s
0 0 .277 r
.21603 .65432 m .21332 .64636 L p .22389 .68096 L F P
0 g
s
0 0 .277 r
.22389 .68096 m .2215 .672 L .21603 .65432 L p F P
0 g
s
.195 .049 .444 r
.52853 .36884 m .51979 .37865 L .51979 .40294 L p F P
0 g
s
0 0 0 r
.39362 .28035 m .387 .28412 L .3662 .29412 L p F P
0 g
s
0 0 0 r
.387 .28412 m .39362 .28035 L .41577 .27188 L p F P
0 g
s
.856 .889 .462 r
.81794 .68013 m .8218 .66273 L p .80975 .69534 L F P
0 g
s
.856 .889 .462 r
.80975 .69534 m .81437 .68869 L .81794 .68013 L p F P
0 g
s
.796 .815 .333 r
.82623 .64934 m .82851 .64411 L p .81794 .68013 L F P
0 g
s
.796 .815 .333 r
.81794 .68013 m .8218 .66273 L .82623 .64934 L p F P
0 g
s
.599 .946 .796 r
.6802 .84155 m .6889 .83889 L .70576 .82542 L p F P
0 g
s
.51 .906 .78 r
.65723 .85466 m .6802 .84155 L .6889 .83889 L p F P
0 g
s
.802 .708 .171 r
.83626 .58587 m .83716 .58025 L p .83408 .61644 L F P
0 g
s
.802 .708 .171 r
.83408 .61644 m .83461 .59957 L .83626 .58587 L p F P
0 g
s
.762 .732 .206 r
.82851 .64411 m .82928 .63908 L .83408 .61644 L p F P
0 g
s
.879 .804 .319 r
.83461 .59957 m .83408 .61644 L .82928 .63908 L p F P
0 g
s
0 .539 .721 r
.55547 .25592 m .54764 .25524 L .53062 .25386 L p F P
0 g
s
.135 0 0 r
.54764 .25524 m .52492 .25425 L .53062 .25386 L closepath p F P
0 g
s
.024 0 0 r
.53062 .25386 m .52492 .25425 L .49615 .25491 L p F P
0 g
s
0 .295 .76 r
.34397 .83236 m .33541 .82717 L .32194 .81501 L p F P
0 g
s
0 0 .155 r
.20633 .54096 m .20458 .5528 L .20504 .57239 L p F P
0 g
s
0 0 0 r
.20458 .5528 m .20633 .54096 L .208 .5208 L p F P
0 g
s
.094 .651 .73 r
.49615 .25491 m .49388 .25513 L .47337 .25725 L p F P
0 g
s
.001 0 0 r
.49388 .25513 m .46945 .25814 L .47337 .25725 L closepath p F P
0 g
s
0 0 0 r
.47337 .25725 m .46945 .25814 L .44429 .26317 L p F P
0 g
s
0 0 .075 r
.20998 .51231 m .208 .5208 L .20633 .54096 L p F P
0 g
s
.369 .181 .489 r
.53562 .36211 m .53552 .3381 L .55417 .32471 L p F P
0 g
s
.265 .102 .464 r
.52853 .36884 m .53562 .36211 L .53552 .3381 L p F P
0 g
s
0 0 .394 r
.8227 .55998 m .81566 .5762 L .81764 .60181 L p F P
0 g
s
0 0 .394 r
.81566 .5762 m .8227 .55998 L .82069 .53463 L p F P
0 g
s
.069 0 .449 r
.81525 .60558 m .81764 .60181 L .81566 .5762 L p F P
0 g
s
.461 0 0 r
.72419 .32761 m .7062 .31473 L .69207 .30394 L p F P
0 g
s
.684 .441 .548 r
.66274 .77465 m .67499 .77443 L .67602 .80137 L p F P
0 g
s
.684 .441 .548 r
.67602 .80137 m .66369 .80159 L .66274 .77465 L p F P
0 g
s
.703 .455 .547 r
.64567 .77424 m .66274 .77465 L .66369 .80159 L p F P
0 g
s
.61175 .26779 m
.61736 .26954 L
s
.59664 .26308 m
.59727 .26328 L
s
.59727 .26328 m
.59833 .26361 L
s
.59369 .26216 m
.59664 .26308 L
s
.59135 .26143 m
.59369 .26216 L
s
.649 .413 .548 r
.67602 .80137 m .67499 .77443 L .70183 .77184 L p F P
0 g
s
.875 .632 .105 r
.82906 .50416 m .8334 .52023 L .83507 .54039 L p F P
0 g
s
.776 .511 0 r
.8334 .52023 m .82906 .50416 L .82545 .48479 L p F P
0 g
s
.703 .455 .547 r
.66369 .80159 m .6465 .80118 L .64567 .77424 L p F P
0 g
s
.735 .481 .545 r
.61931 .7716 m .64567 .77424 L .6465 .80118 L p F P
0 g
s
.353 .193 .52 r
.78872 .68689 m .79655 .68108 L .79471 .65493 L p F P
0 g
s
.302 .156 .51 r
.80461 .64626 m .79471 .65493 L .79655 .68108 L p F P
0 g
s
.966 .687 .452 r
.52769 .65428 m .51544 .641 L .51548 .61511 L p F P
0 g
s
.989 .723 .376 r
.50693 .60035 m .51548 .61511 L .51544 .641 L p F P
0 g
s
.989 .723 .376 r
.51548 .61511 m .50693 .60035 L .50702 .57473 L p F P
0 g
s
0 0 0 r
.23976 .42425 m .24949 .40919 L p .23192 .44277 L F P
0 g
s
0 0 0 r
.23192 .44277 m .23528 .43383 L .23976 .42425 L p F P
0 g
s
0 .486 .845 r
.40932 .86649 m .39656 .86039 L .40477 .86508 L closepath p F P
0 g
s
0 .241 .74 r
.30865 .8054 m .32194 .81501 L .30842 .80026 L p F P
0 g
s
0 .241 .74 r
.30842 .80026 m .29744 .79234 L .30865 .8054 L p F P
0 g
s
0 .139 .654 r
.28777 .78404 m .29744 .79234 L .30865 .8054 L p F P
0 g
s
0 0 .553 r
.24949 .73134 m .24133 .71925 L .23564 .70748 L p F P
0 g
s
0 0 .353 r
.21603 .65432 m .21332 .64636 L .2126 .64134 L closepath p F P
0 g
s
0 0 .214 r
.21332 .64636 m .2126 .64134 L .20715 .61398 L p F P
0 g
s
.923 .643 .492 r
.54368 .6923 m .52773 .68044 L .52769 .65428 L p F P
0 g
s
.966 .687 .452 r
.51544 .641 m .52769 .65428 L .52773 .68044 L p F P
0 g
s
.498 .299 .54 r
.75033 .76035 m .74881 .73366 L .77045 .72463 L p F P
0 g
s
.557 .343 .545 r
.74881 .73366 m .75033 .76035 L .72692 .76715 L p F P
0 g
s
.942 .715 .244 r
.50219 .55842 m .50702 .57473 L .50693 .60035 L p F P
0 g
s
.942 .715 .244 r
.50702 .57473 m .50219 .55842 L .50231 .53306 L p F P
0 g
s
.364 .832 .794 r
.63548 .86514 m .63429 .86537 L .61141 .87378 L p F P
0 g
s
.472 .893 .895 r
.63429 .86537 m .61141 .87378 L .59993 .87395 L p F P
0 g
s
.369 .837 .869 r
.57698 .88038 m .59993 .87395 L .61141 .87378 L p F P
0 g
s
0 .381 .762 r
.39656 .86039 m .38927 .8566 L .36998 .8487 L p F P
0 g
s
0 .433 .841 r
.38927 .8566 m .36998 .8487 L .35663 .83885 L p F P
0 g
s
0 0 .286 r
.82291 .52397 m .82069 .53463 L .8227 .55998 L p F P
0 g
s
.815 .885 .457 r
.80686 .7049 m .80975 .69534 L .81437 .68869 L closepath p F P
0 g
s
0 0 .302 r
.20687 .61026 m .20715 .61398 L .2126 .64134 L p F P
0 g
s
.822 .553 .532 r
.58846 .76475 m .57378 .75989 L .57343 .7332 L p F P
0 g
s
.842 .569 .527 r
.56348 .72924 m .57343 .7332 L .57378 .75989 L p F P
0 g
s
.605 .057 0 r
.71687 .32475 m .7062 .31473 L .72419 .32761 L p F P
0 g
s
.857 .562 .487 r
.75048 .29056 m .76006 .29539 L .76166 .31916 L p F P
0 g
s
.9 .597 .465 r
.78016 .33175 m .76166 .31916 L .76006 .29539 L p F P
0 g
s
.81912 .46814 m
.8201 .46665 L
s
.81747 .47068 m
.81815 .46964 L
s
.708 .971 .74 r
.72602 .80784 m .7478 .78751 L .73428 .80408 L closepath p F P
0 g
s
.668 .935 .656 r
.74875 .78655 m .7478 .78751 L .73428 .80408 L p F P
0 g
s
.637 .948 .734 r
.73428 .80408 m .72602 .80784 L p .70576 .82542 L F P
0 g
s
.016 0 0 r
.43803 .26571 m .44429 .26317 L .46945 .25814 L p F P
0 g
s
0 0 0 r
.44429 .26317 m .43803 .26571 L .41577 .27188 L p F P
0 g
s
0 0 0 r
.31214 .33374 m .31869 .3267 L .33659 .31375 L p F P
0 g
s
0 0 0 r
.31214 .33374 m .31869 .3267 L p .29297 .35106 L F P
0 g
s
.606 .381 .548 r
.70304 .7988 m .70183 .77184 L .72692 .76715 L p F P
0 g
s
.649 .413 .548 r
.70183 .77184 m .70304 .7988 L .67602 .80137 L p F P
0 g
s
.88 .603 .514 r
.56348 .72924 m .54383 .71873 L .54368 .6923 L p F P
0 g
s
.923 .643 .492 r
.52773 .68044 m .54368 .6923 L .54383 .71873 L p F P
0 g
s
.78 .625 .063 r
.50184 .52544 m .50231 .53306 L .50219 .55842 L p F P
0 g
s
.735 .481 .545 r
.6465 .80118 m .61997 .79856 L .61931 .7716 L p F P
0 g
s
.761 .503 .542 r
.6131 .77057 m .61931 .7716 L .61997 .79856 L p F P
0 g
s
0 0 0 r
.35713 .30135 m .3662 .29412 L .387 .28412 L p F P
0 g
s
0 0 0 r
.35713 .30135 m .3662 .29412 L p .33659 .31375 L F P
0 g
s
.837 .824 .346 r
.82623 .64934 m .82928 .63908 L .82851 .64411 L closepath p F P
0 g
s
.874 .569 .052 r
.81907 .46909 m .82545 .48479 L .82906 .50416 L p F P
0 g
s
.839 .721 .193 r
.83626 .58587 m .83711 .57773 L .83716 .58025 L closepath p F P
0 g
s
0 0 .553 r
.23564 .70748 m .23258 .69863 L p .24949 .73134 L F P
0 g
s
0 0 .432 r
.23564 .70748 m .22841 .69073 L .23258 .69863 L closepath p F P
0 g
s
.068 .548 .896 r
.40932 .86649 m .42671 .8709 L p .39161 .85741 L F P
0 g
s
.068 .548 .896 r
.39161 .85741 m .39656 .86039 L .40932 .86649 L p F P
0 g
s
.797 .512 .507 r
.73623 .28452 m .71187 .27723 L .71059 .25373 L p F P
0 g
s
.766 .488 .513 r
.70444 .25243 m .71059 .25373 L .71187 .27723 L p F P
0 g
s
.233 .722 .924 r
.49678 .88574 m .51934 .88539 L .51549 .88422 L p F P
0 g
s
.233 .722 .924 r
.48424 .88199 m .49678 .88574 L p .51549 .88422 L F P
0 g
s
.108 .637 .871 r
.4618 .88034 m .48424 .88199 L .49678 .88574 L p F P
0 g
s
0 0 0 r
.22966 .44705 m .23192 .44277 L .23528 .43383 L closepath p F P
0 g
s
.761 .503 .542 r
.61997 .79856 m .61372 .79754 L .6131 .77057 L p F P
0 g
s
.788 .525 .538 r
.58846 .76475 m .6131 .77057 L .61372 .79754 L p F P
0 g
s
.209 0 0 r
.58806 .26092 m .5871 .26069 L .58854 .26099 L closepath p F P
0 g
s
.294 0 0 r
.5871 .26069 m .58806 .26092 L p .55335 .25603 L F P
0 g
s
.294 0 0 r
.55335 .25603 m .55547 .25592 L .5871 .26069 L p F P
0 g
s
.766 .488 .513 r
.71187 .27723 m .70567 .27593 L .70444 .25243 L p F P
0 g
s
.736 .464 .517 r
.6781 .24908 m .70444 .25243 L .70567 .27593 L p F P
0 g
s
.364 .822 .925 r
.54394 .88328 m .55417 .88476 L .57698 .88038 L p F P
0 g
s
.945 .637 .424 r
.7964 .36957 m .7819 .35579 L .78016 .33175 L p F P
0 g
s
.9 .597 .465 r
.76166 .31916 m .78016 .33175 L .7819 .35579 L p F P
0 g
s
.407 .85 .751 r
.65723 .85466 m .64288 .86145 L .63548 .86514 L p F P
0 g
s
.466 .89 .824 r
.63429 .86537 m .64288 .86145 L .63548 .86514 L closepath p F P
0 g
s
.384 0 0 r
.58806 .26092 m .61138 .26884 L .61017 .26892 L p F P
0 g
s
.384 0 0 r
.57644 .26157 m .58806 .26092 L p .61017 .26892 L F P
0 g
s
.59833 .26361 m
.61175 .26779 L
s
.294 0 0 r
.58806 .26092 m .57644 .26157 L .55335 .25603 L p F P
0 g
s
0 0 .229 r
.20504 .57239 m .20768 .59146 L .20687 .61026 L p F P
0 g
s
0 0 .302 r
.2126 .64134 m .21167 .62877 L .20687 .61026 L p F P
0 g
s
0 0 .366 r
.20768 .59146 m .20687 .61026 L .21167 .62877 L p F P
0 g
s
0 .191 .716 r
.29744 .79234 m .28777 .78404 L .27428 .76617 L p F P
0 g
s
.842 .569 .527 r
.57378 .75989 m .56376 .75595 L .56348 .72924 L p F P
0 g
s
.88 .603 .514 r
.54383 .71873 m .56348 .72924 L .56376 .75595 L p F P
0 g
s
.928 .771 .294 r
.83711 .57773 m .83477 .56141 L p .8341 .59445 L F P
0 g
s
.928 .771 .294 r
.8341 .59445 m .83626 .58587 L .83711 .57773 L p F P
0 g
s
.863 .683 .153 r
.83711 .57773 m .83477 .56141 L .83507 .54039 L p F P
0 g
s
0 0 .434 r
.2126 .64134 m .21167 .62877 L p .21997 .66447 L F P
0 g
s
0 0 .434 r
.21997 .66447 m .21603 .65432 L .2126 .64134 L p F P
0 g
s
0 0 .497 r
.23258 .69863 m .22841 .69073 L .2215 .672 L p F P
0 g
s
0 0 0 r
.40927 .27562 m .41577 .27188 L .43803 .26571 L p F P
0 g
s
0 0 0 r
.41577 .27188 m .40927 .27562 L .387 .28412 L p F P
0 g
s
0 .377 .825 r
.34397 .83236 m .35663 .83885 L .34319 .82667 L p F P
0 g
s
0 .377 .825 r
.34319 .82667 m .33051 .82019 L .34397 .83236 L p F P
0 g
s
0 .295 .76 r
.32194 .81501 m .33051 .82019 L .34397 .83236 L p F P
0 g
s
.859 .94 .571 r
.80686 .7049 m .80975 .69534 L p .79283 .73002 L F P
0 g
s
.859 .94 .571 r
.79283 .73002 m .79321 .72966 L .80686 .7049 L p F P
0 g
s
.857 .562 .487 r
.76166 .31916 m .75202 .31433 L .75048 .29056 L p F P
0 g
s
.835 .543 .496 r
.73623 .28452 m .75048 .29056 L .75202 .31433 L p F P
0 g
s
0 0 .048 r
.50184 .52544 m .50251 .51469 L .50263 .48958 L p F P
0 g
s
0 0 .221 r
.50732 .47265 m .50263 .48958 L .50251 .51469 L p F P
0 g
s
0 0 .221 r
.50263 .48958 m .50732 .47265 L .50741 .44779 L p F P
0 g
s
.723 .29 0 r
.79767 .41757 m .78713 .40272 L .77787 .3859 L p F P
0 g
s
.832 .42 0 r
.78713 .40272 m .79767 .41757 L .80508 .43525 L p F P
0 g
s
.132 0 0 r
.46945 .25814 m .49388 .25513 L p .48481 .25958 L F P
0 g
s
.132 0 0 r
.46043 .26185 m .46945 .25814 L p .48481 .25958 L F P
0 g
s
.016 0 0 r
.46945 .25814 m .46043 .26185 L .43803 .26571 L p F P
0 g
s
.943 .669 .206 r
.8171 .44936 m .81065 .43338 L .80872 .4088 L p F P
0 g
s
.529 .302 .515 r
.57502 .31377 m .57466 .28999 L .59753 .28153 L p F P
0 g
s
.457 .247 .505 r
.57466 .28999 m .57502 .31377 L .55417 .32471 L p F P
0 g
s
.976 .672 .347 r
.80872 .4088 m .79825 .39389 L .7964 .36957 L p F P
0 g
s
.945 .637 .424 r
.7819 .35579 m .7964 .36957 L .79825 .39389 L p F P
0 g
s
0 0 .37 r
.2215 .672 m .21603 .65432 L .21997 .66447 L closepath p F P
0 g
s
0 0 .497 r
.2215 .672 m .21997 .66447 L p .23258 .69863 L F P
0 g
s
.562 .933 .908 r
.64288 .86145 m .63429 .86537 L .62299 .86546 L p F P
0 g
s
.472 .893 .895 r
.59993 .87395 m .62299 .86546 L .63429 .86537 L p F P
0 g
s
.976 .672 .347 r
.79825 .39389 m .80872 .4088 L .81065 .43338 L p F P
0 g
s
0 0 .075 r
.20633 .54096 m .20831 .53251 L .20998 .51231 L p F P
0 g
s
0 0 .154 r
.21467 .49829 m .20998 .51231 L .20831 .53251 L p F P
0 g
s
0 0 0 r
.20998 .51231 m .21467 .49829 L .21789 .47985 L p F P
0 g
s
.195 .049 .444 r
.51979 .40294 m .52859 .39316 L .52853 .36884 L p F P
0 g
s
.265 .102 .464 r
.53562 .36211 m .52853 .36884 L .52859 .39316 L p F P
0 g
s
.736 .464 .517 r
.70567 .27593 m .67915 .27259 L .6781 .24908 L p F P
0 g
s
.7 .435 .521 r
.66096 .24855 m .6781 .24908 L .67915 .27259 L p F P
0 g
s
.557 .343 .545 r
.72831 .79415 m .72692 .76715 L .75033 .76035 L p F P
0 g
s
.606 .381 .548 r
.72692 .76715 m .72831 .79415 L .70304 .7988 L p F P
0 g
s
.678 .419 .522 r
.64867 .24883 m .66096 .24855 L .6619 .27206 L p F P
0 g
s
.678 .419 .522 r
.6619 .27206 m .64953 .27234 L .64867 .24883 L p F P
0 g
s
0 0 .072 r
.22266 .46888 m .21789 .47985 L .21467 .49829 L p F P
0 g
s
0 0 0 r
.21789 .47985 m .22266 .46888 L .22966 .44705 L p F P
0 g
s
.7 .435 .521 r
.67915 .27259 m .6619 .27206 L .66096 .24855 L p F P
0 g
s
0 0 .323 r
.50925 .44375 m .50741 .44779 L .50732 .47265 L p F P
0 g
s
.926 .871 .443 r
.82928 .63908 m .82978 .62232 L p .82248 .65513 L F P
0 g
s
.926 .871 .443 r
.82248 .65513 m .82623 .64934 L .82928 .63908 L p F P
0 g
s
.879 .804 .319 r
.82928 .63908 m .82978 .62232 L .83461 .59957 L p F P
0 g
s
.353 .193 .52 r
.79655 .68108 m .78872 .68689 L .79052 .71336 L p F P
0 g
s
.431 .249 .532 r
.78872 .68689 m .79052 .71336 L .77045 .72463 L p F P
0 g
s
.189 0 0 r
.55335 .25603 m .54764 .25524 L .55547 .25592 L closepath p F P
0 g
s
0 0 0 r
.23192 .44277 m .22966 .44705 L .22266 .46888 L p F P
0 g
s
.19 .076 .484 r
.81723 .63152 m .80461 .64626 L .80652 .67246 L p F P
0 g
s
.19 .076 .484 r
.80461 .64626 m .81723 .63152 L .81525 .60558 L p F P
0 g
s
.302 .156 .51 r
.79655 .68108 m .80652 .67246 L .80461 .64626 L p F P
0 g
s
0 0 0 r
.28932 .35632 m .30219 .34298 L .29297 .35106 L closepath p F P
0 g
s
0 0 0 r
.29297 .35106 m .30219 .34298 L .31214 .33374 L p F P
0 g
s
0 0 0 r
.28932 .35632 m .29297 .35106 L p .26986 .37859 L F P
0 g
s
.267 0 0 r
.54764 .25524 m .55335 .25603 L .54321 .25853 L p F P
0 g
s
.267 0 0 r
.52492 .25425 m .54764 .25524 L p .54321 .25853 L F P
0 g
s
.562 .933 .908 r
.65494 .8549 m .64288 .86145 L p .62299 .86546 L F P
0 g
s
.525 .92 .865 r
.64288 .86145 m .65494 .8549 L .65723 .85466 L closepath p F P
0 g
s
.043 0 0 r
.49576 .255 m .49388 .25513 L .49615 .25491 L closepath p F P
0 g
s
.132 0 0 r
.49388 .25513 m .49576 .255 L .48481 .25958 L p F P
0 g
s
.162 0 0 r
.49576 .255 m .49615 .25491 L .52492 .25425 L p F P
0 g
s
.91 .771 .284 r
.83461 .59957 m .8341 .59445 L .83626 .58587 L closepath p F P
0 g
s
.069 0 .449 r
.81764 .60181 m .81525 .60558 L .81723 .63152 L p F P
0 g
s
.267 0 0 r
.51839 .25581 m .52492 .25425 L p .54321 .25853 L F P
0 g
s
.162 0 0 r
.52492 .25425 m .51839 .25581 L .49576 .255 L p F P
0 g
s
.212 .678 .942 r
.4618 .88034 m .48424 .88199 L .48319 .8815 L p F P
0 g
s
.212 .678 .942 r
.44897 .87451 m .4618 .88034 L p .48319 .8815 L F P
0 g
s
.089 .597 .892 r
.42671 .8709 m .44897 .87451 L .4618 .88034 L p F P
0 g
s
.78 .625 .063 r
.50219 .55842 m .50171 .55084 L .50184 .52544 L p F P
0 g
s
0 0 .048 r
.50251 .51469 m .50184 .52544 L .50171 .55084 L p F P
0 g
s
.236 0 0 r
.48481 .25958 m .49576 .255 L .51839 .25581 L p F P
0 g
s
.788 .525 .538 r
.61372 .79754 m .58891 .79177 L .58846 .76475 L p F P
0 g
s
.822 .553 .532 r
.57378 .75989 m .58846 .76475 L .58891 .79177 L p F P
0 g
s
0 .458 .832 r
.39161 .85741 m .38927 .8566 L .39656 .86039 L closepath p F P
0 g
s
.431 .249 .532 r
.77212 .75138 m .77045 .72463 L .79052 .71336 L p F P
0 g
s
.498 .299 .54 r
.77045 .72463 m .77212 .75138 L .75033 .76035 L p F P
0 g
s
0 0 .231 r
.20831 .53251 m .20633 .54096 L .20643 .56309 L p F P
0 g
s
0 0 .155 r
.20504 .57239 m .20643 .56309 L .20633 .54096 L p F P
0 g
s
0 0 .295 r
.20643 .56309 m .20504 .57239 L .20768 .59146 L p F P
0 g
s
.941 .725 .253 r
.83072 .52439 m .83507 .54039 L .83477 .56141 L p F P
0 g
s
.875 .632 .105 r
.83507 .54039 m .83072 .52439 L .82906 .50416 L p F P
0 g
s
.457 .247 .505 r
.55439 .34878 m .55417 .32471 L .57502 .31377 L p F P
0 g
s
.369 .181 .489 r
.55417 .32471 m .55439 .34878 L .53562 .36211 L p F P
0 g
s
.835 .543 .496 r
.75202 .31433 m .73768 .30832 L .73623 .28452 L p F P
0 g
s
.797 .512 .507 r
.71187 .27723 m .73623 .28452 L .73768 .30832 L p F P
0 g
s
0 0 .198 r
.82356 .51629 m .82291 .52397 L .82495 .54938 L p F P
0 g
s
0 0 .286 r
.8227 .55998 m .82495 .54938 L .82291 .52397 L p F P
0 g
s
0 0 0 r
.37951 .29013 m .387 .28412 L .40927 .27562 L p F P
0 g
s
0 0 0 r
.387 .28412 m .37951 .29013 L .35713 .30135 L p F P
0 g
s
0 .034 .598 r
.26086 .74494 m .24949 .73134 L p .27075 .76266 L F P
0 g
s
0 .085 .645 r
.24949 .73134 m .26086 .74494 L .24758 .7198 L p F P
0 g
s
0 .085 .645 r
.24758 .7198 m .24412 .71567 L .24949 .73134 L p F P
0 g
s
0 0 .553 r
.23258 .69863 m .24412 .71567 L .24949 .73134 L p F P
0 g
s
.036 0 .392 r
.50925 .44375 m .51978 .42754 L .51979 .40294 L p F P
0 g
s
0 0 .323 r
.50732 .47265 m .50917 .46862 L .50925 .44375 L p F P
0 g
s
.036 0 .392 r
.51978 .42754 m .50925 .44375 L .50917 .46862 L p F P
0 g
s
.903 .876 .444 r
.8218 .66273 m .82248 .65513 L .82623 .64934 L closepath p F P
0 g
s
.817 .938 .573 r
.79253 .73077 m .79283 .73002 L .79321 .72966 L closepath p F P
0 g
s
.614 .957 .875 r
.65494 .8549 m .65723 .85466 L .6802 .84155 L p F P
0 g
s
.751 .926 .57 r
.79253 .73077 m .77328 .7582 L .77221 .76019 L p F P
0 g
s
.847 .975 .667 r
.79283 .73002 m .79253 .73077 L .77328 .7582 L p F P
0 g
s
0 .141 .684 r
.27428 .76617 m .27075 .76266 L .26644 .75409 L closepath p F P
0 g
s
0 .034 .598 r
.27075 .76266 m .26644 .75409 L .26086 .74494 L p F P
0 g
s
0 .336 .812 r
.33051 .82019 m .32194 .81501 L .30842 .80026 L p F P
0 g
s
0 .026 .596 r
.22925 .68199 m .23258 .69863 L .24412 .71567 L p F P
0 g
s
0 0 .497 r
.21997 .66447 m .22925 .68199 L .23258 .69863 L p F P
0 g
s
.195 .049 .444 r
.52859 .39316 m .51979 .40294 L .51978 .42754 L p F P
0 g
s
.358 0 0 r
.54321 .25853 m .55335 .25603 L .57644 .26157 L p F P
0 g
s
0 0 .062 r
.24378 .42445 m .23192 .44277 L .22751 .45972 L p F P
0 g
s
0 0 0 r
.22266 .46888 m .22751 .45972 L .23192 .44277 L p F P
0 g
s
0 0 0 r
.24949 .40919 m .24378 .42445 L .23192 .44277 L p F P
0 g
s
.662 .11 0 r
.7062 .31473 m .71687 .32475 L .71231 .32358 L p F P
0 g
s
0 0 0 r
.26596 .38616 m .27657 .37151 L .26986 .37859 L closepath p F P
0 g
s
0 0 0 r
.26986 .37859 m .27657 .37151 L .28932 .35632 L p F P
0 g
s
0 0 0 r
.26596 .38616 m .26986 .37859 L p .24949 .40919 L F P
0 g
s
.353 .193 .52 r
.79841 .70758 m .79052 .71336 L .79134 .72548 L p F P
0 g
s
.881 .971 .657 r
.79283 .73002 m .78704 .73344 L p .79134 .72548 L F P
0 g
s
.881 .971 .657 r
.79772 .7137 m .7973 .7151 L p .79134 .72548 L F P
0 g
s
.881 .971 .657 r
.7973 .7151 m .79283 .73002 L p .79134 .72548 L F P
0 g
s
.431 .249 .532 r
.79052 .71336 m .79134 .72548 L p .77212 .75138 L F P
0 g
s
.431 .249 .532 r
.77212 .75138 m .79134 .72548 L .78664 .73367 L F
.847 .975 .667 r
.77328 .7582 m .77932 .7451 L .79283 .73002 L F
.78664 .73367 m .79283 .73002 L p .77932 .7451 L F P
0 g
s
.431 .249 .532 r
.77705 .74865 m .77212 .75138 L p .78664 .73367 L F P
0 g
s
.847 .975 .667 r
.78036 .74027 m .78384 .73532 L p .77932 .7451 L F P
0 g
s
.847 .975 .667 r
.77328 .7582 m .77705 .74865 L p .77932 .7451 L F P
0 g
s
.847 .975 .667 r
.77705 .74865 m .78036 .74027 L p .77932 .7451 L F P
0 g
s
.789 .967 .662 r
.7712 .76085 m .77328 .7582 L .77221 .76019 L closepath p F P
0 g
s
.86 .991 .736 r
.77328 .7582 m .7712 .76085 L .76719 .76231 L p F P
0 g
s
.498 .299 .54 r
.75033 .76035 m .77212 .75138 L p .76344 .76684 L F P
0 g
s
.822 .993 .749 r
.7712 .76085 m .76841 .76187 L p .74833 .78671 L F P
0 g
s
.822 .993 .749 r
.76841 .76187 m .76719 .76231 L p .76081 .77057 L F P
0 g
s
.822 .993 .749 r
.74833 .78671 m .76841 .76187 L .76081 .77057 L F
.557 .343 .545 r
.75033 .76035 m .75153 .78119 L p .72831 .79415 L F P
0 g
s
.822 .993 .749 r
.74833 .78671 m .76719 .76231 L .75166 .78103 L F
.736 .956 .662 r
.74875 .78655 m .7712 .76085 L .77221 .76019 L p F P
0 g
s
.822 .993 .749 r
.74833 .78671 m .74875 .78655 L .7712 .76085 L p F P
0 g
s
.772 .989 .758 r
.7478 .78751 m .74833 .78671 L .74875 .78655 L closepath p F P
0 g
s
.787 .998 .815 r
.7478 .78751 m .74833 .78671 L p .73471 .79761 L F P
0 g
s
.787 .998 .815 r
.73336 .79887 m .7478 .78751 L .73471 .79761 L F
.72602 .80784 m .7478 .78751 L p .73577 .79698 L F P
0 g
s
.787 .998 .815 r
.73336 .79887 m .73268 .7997 L .73577 .79698 L F
.73268 .7997 m .72602 .80784 L .73577 .79698 L F
.672 .972 .801 r
.70315 .8262 m .71117 .82005 L .70576 .82542 L closepath p F P
0 g
s
.637 .948 .734 r
.72602 .80784 m .71117 .82005 L .70576 .82542 L p F P
0 g
s
.599 .946 .796 r
.70576 .82542 m .70315 .8262 L .6802 .84155 L p F P
0 g
s
.745 .992 .866 r
.71117 .82005 m .70315 .8262 L .6979 .82666 L p F P
0 g
s
.649 .413 .548 r
.70304 .7988 m .7041 .82221 L p .67707 .82868 L F P
0 g
s
.745 .992 .866 r
.6979 .82666 m .69746 .8267 L p .70255 .82332 L F P
0 g
s
.745 .992 .866 r
.70234 .8234 m .70255 .82332 L .69746 .8267 L F
.70255 .82332 m .71117 .82005 L .6979 .82666 L F
.686 .98 .875 r
.67252 .84231 m .6802 .84155 L .70315 .8262 L p F P
0 g
s
.684 .441 .548 r
.66465 .8289 m .67707 .82868 L .67744 .83854 L p F P
0 g
s
.686 .98 .875 r
.70315 .8262 m .69879 .82658 L p .67252 .84231 L F P
0 g
s
.686 .98 .875 r
.67252 .84231 m .69879 .82658 L .68796 .83265 L F
.67252 .84231 m .69746 .8267 L .67767 .8384 L F
.614 .957 .875 r
.6802 .84155 m .67252 .84231 L .65494 .8549 L p F P
0 g
s
.637 .961 .911 r
.64613 .85491 m .65494 .8549 L .67252 .84231 L p F P
0 g
s
.684 .441 .548 r
.67528 .83975 m .66465 .8289 L .67744 .83854 L F
.699 .978 .905 r
.67528 .83975 m .67252 .84231 L .67029 .84229 L p F P
0 g
s
.684 .441 .548 r
.67112 .84208 m .67104 .84191 L .67528 .83975 L F
.67104 .84191 m .66465 .8289 L .67528 .83975 L F
.735 .481 .545 r
.62063 .82589 m .64735 .82849 L .64805 .85105 L p F P
0 g
s
.735 .481 .545 r
.64752 .85123 m .62063 .82589 L .64805 .85105 L F
.692 .959 .946 r
.66188 .84633 m .64613 .85491 L .64054 .85391 L p F P
0 g
s
.692 .959 .946 r
.64054 .85391 m .63997 .8538 L p .64805 .85105 L F P
0 g
s
.692 .959 .946 r
.64805 .85105 m .66188 .84633 L .64054 .85391 L F
.637 .961 .911 r
.67252 .84231 m .67213 .84231 L p .64613 .85491 L F P
0 g
s
.637 .961 .911 r
.64613 .85491 m .67213 .84231 L .66522 .84502 L F
.66459 .84527 m .67049 .84229 L .66945 .84273 L F
.64613 .85491 m .66522 .84502 L .66459 .84527 L F
.66522 .84502 m .67049 .84229 L .66459 .84527 L F
.63 .942 .955 r
.64613 .85491 m .63997 .8538 L p .61318 .86382 L F P
0 g
s
.735 .481 .545 r
.62131 .85359 m .62063 .82589 L p .64482 .85246 L F P
0 g
s
.735 .481 .545 r
.64311 .85293 m .62131 .85359 L .64482 .85246 L F
.63 .942 .955 r
.62404 .85831 m .63997 .8538 L .62437 .85814 L F
.675 .915 .975 r
.62017 .85954 m .61143 .8634 L .60638 .86139 L p F P
0 g
s
.675 .915 .975 r
.6134 .86027 m .62017 .85954 L .60638 .86139 L F
.61927 .8595 m .62017 .85954 L .6134 .86027 L F
.61515 .85999 m .6134 .86027 L .60564 .8611 L F
.61927 .8595 m .6134 .86027 L .61515 .85999 L F
.63 .942 .955 r
.63557 .85545 m .63997 .8538 L .62404 .85831 L F
.62017 .85954 m .61318 .86382 L p .62404 .85831 L F P
0 g
s
.63 .942 .955 r
.61318 .86382 m .63141 .85701 L .62306 .85881 L F
.556 .916 .957 r
.59233 .87275 m .59993 .87395 L .62299 .86546 L p F P
0 g
s
.63 .942 .955 r
.61318 .86382 m .62299 .86546 L .64613 .85491 L p F P
0 g
s
.556 .916 .957 r
.62299 .86546 m .61318 .86382 L .59233 .87275 L p F P
0 g
s
.641 .935 .967 r
.61143 .8634 m .62017 .85954 L .61318 .86382 L closepath p F P
0 g
s
.761 .503 .542 r
.622 .88167 m .61563 .88068 L .61516 .86052 L p F P
0 g
s
.761 .503 .542 r
.61515 .85999 m .61498 .85259 L p .61671 .85974 L F P
0 g
s
.761 .503 .542 r
.61671 .85974 m .61498 .85259 L .62123 .85901 L F
.788 .525 .538 r
.58984 .8469 m .61498 .85259 L .61515 .85999 L p F P
0 g
s
.788 .525 .538 r
.61435 .86008 m .58984 .8469 L .61515 .85999 L F
.675 .915 .975 r
.60638 .86139 m .60564 .8611 L p .6134 .86027 L F P
0 g
s
.621 .9 .986 r
.57622 .86719 m .59009 .86216 L p .61143 .8634 L F P
0 g
s
.621 .9 .986 r
.60564 .8611 m .61143 .8634 L p .59009 .86216 L F P
0 g
s
.788 .525 .538 r
.60234 .86329 m .60092 .86142 L .61516 .86052 L F
.60092 .86142 m .58984 .8469 L .61435 .86008 L F
.735 .481 .545 r
.63803 .85434 m .62131 .85359 L .64311 .85293 L F
.63797 .85519 m .62131 .85359 L p .64109 .85448 L F P
0 g
s
.761 .503 .542 r
.62122 .859 m .61498 .85259 L .62144 .85896 L F
.61498 .85259 m .62131 .85359 L .62144 .85896 L p F P
0 g
s
.63 .942 .955 r
.63141 .85701 m .63557 .85545 L .62306 .85881 L F
.562 .933 .908 r
.62299 .86546 m .64613 .85491 L .65494 .8549 L p F P
0 g
s
.735 .481 .545 r
.64821 .85617 m .64908 .88423 L p .62546 .85817 L F P
0 g
s
.63 .942 .955 r
.62306 .85881 m .63557 .85545 L .62404 .85831 L F
.735 .481 .545 r
.62131 .85359 m .63955 .85534 L p .62546 .85817 L F P
0 g
s
.735 .481 .545 r
.63955 .85534 m .64821 .85617 L p .62546 .85817 L F P
0 g
s
.63 .942 .955 r
.62404 .85831 m .62437 .85814 L .62333 .85849 L F
.62404 .85831 m .62333 .85849 L .62017 .85954 L F
.62144 .85896 m .62017 .85954 L p .62437 .85814 L F P
0 g
s
.735 .481 .545 r
.64908 .88423 m .622 .88167 L .62131 .85359 L p F P
0 g
s
.675 .915 .975 r
.63114 .85159 m .62076 .85911 L p .59962 .8587 L F P
0 g
s
.675 .915 .975 r
.62076 .85911 m .6204 .85937 L p .6196 .85934 L F P
0 g
s
.675 .915 .975 r
.59962 .8587 m .62076 .85911 L .6196 .85934 L F
.6204 .85937 m .62017 .85954 L p .61927 .8595 L F P
0 g
s
.675 .915 .975 r
.59962 .8587 m .6204 .85937 L .61927 .8595 L F
.788 .525 .538 r
.60564 .8611 m .61435 .86008 L .61506 .86046 L F
.60092 .86142 m .61435 .86008 L .60564 .8611 L F
.60092 .86142 m .61506 .86046 L .61516 .86052 L F
.467 .876 .948 r
.56927 .87922 m .57698 .88038 L .59993 .87395 L p F P
0 g
s
.467 .876 .948 r
.59993 .87395 m .59233 .87275 L .56927 .87922 L p F P
0 g
s
.5 .882 .968 r
.56508 .8783 m .56927 .87922 L .59233 .87275 L p F P
0 g
s
.5 .882 .968 r
.59233 .87275 m .5882 .87181 L .56508 .8783 L p F P
0 g
s
.576 .914 .971 r
.5882 .87181 m .59233 .87275 L .61318 .86382 L p F P
0 g
s
.576 .914 .971 r
.61318 .86382 m .61143 .8634 L .5882 .87181 L p F P
0 g
s
.621 .9 .986 r
.61143 .8634 m .5882 .87181 L .57622 .86719 L p F P
0 g
s
.788 .525 .538 r
.61563 .88068 m .59031 .87504 L .59009 .86216 L p F P
0 g
s
.788 .525 .538 r
.59009 .86216 m .58984 .8469 L p .60142 .86208 L F P
0 g
s
.788 .525 .538 r
.61563 .88068 m .59009 .86216 L .60142 .86208 L F
.649 .875 .982 r
.57622 .86719 m .56719 .86231 L p .58422 .8622 L F P
0 g
s
.649 .875 .982 r
.59009 .86216 m .58875 .86264 L p .58422 .8622 L F P
0 g
s
.649 .875 .982 r
.58875 .86264 m .57622 .86719 L p .58422 .8622 L F P
0 g
s
.842 .569 .527 r
.56464 .8383 m .57486 .84215 L .57511 .8613 L p F P
0 g
s
.842 .569 .527 r
.57215 .86101 m .56464 .8383 L .57511 .8613 L F
.822 .553 .532 r
.57486 .84215 m .58984 .8469 L .59009 .86216 L p F P
0 g
s
.822 .553 .532 r
.5841 .86181 m .57486 .84215 L .59009 .86216 L F
.649 .875 .982 r
.56719 .86231 m .56415 .86067 L p .5681 .8609 L F P
0 g
s
.649 .875 .982 r
.5681 .8609 m .57511 .8613 L .5722 .86167 L F
.5681 .8609 m .5722 .86167 L .56719 .86231 L F
.88 .603 .514 r
.54446 .8281 m .56464 .8383 L .56488 .86029 L p F P
0 g
s
.822 .553 .532 r
.57511 .8613 m .57486 .84215 L p .5841 .86181 L F P
0 g
s
.649 .875 .982 r
.56415 .86067 m .56402 .8606 L p .59009 .86216 L F P
0 g
s
.842 .569 .527 r
.56488 .86029 m .56464 .8383 L p .57215 .86101 L F P
0 g
s
.649 .875 .982 r
.59962 .8587 m .59009 .86216 L p .56402 .8606 L F P
0 g
s
.595 .858 .993 r
.54062 .86724 m .56388 .86065 L p .57622 .86719 L F P
0 g
s
.595 .858 .993 r
.56388 .86065 m .56402 .8606 L .56415 .86067 L p F P
0 g
s
.595 .858 .993 r
.56415 .86067 m .57622 .86719 L p .56388 .86065 L F P
0 g
s
.649 .875 .982 r
.57511 .8613 m .58422 .8622 L .56719 .86231 L F
.557 .878 .992 r
.5882 .87181 m .56508 .8783 L .55296 .87375 L p F P
0 g
s
.557 .878 .992 r
.55296 .87375 m .57622 .86719 L .5882 .87181 L p F P
0 g
s
.595 .858 .993 r
.57622 .86719 m .55296 .87375 L .54062 .86724 L p F P
0 g
s
.822 .553 .532 r
.59031 .87504 m .57523 .87032 L .57512 .86177 L p F P
0 g
s
.822 .553 .532 r
.57512 .86177 m .57511 .8613 L p .5757 .86183 L F P
0 g
s
.822 .553 .532 r
.59031 .87504 m .57512 .86177 L .5757 .86183 L F
.649 .875 .982 r
.56402 .8606 m .58757 .85203 L .59962 .8587 L p F P
0 g
s
.619 .83 .981 r
.56402 .8606 m .54062 .86724 L .52807 .85874 L p F P
0 g
s
.88 .603 .514 r
.56267 .85967 m .54446 .8281 L .56488 .86029 L F
.619 .83 .981 r
.56267 .85967 m .56402 .8606 L p .54461 .85402 L F P
0 g
s
.88 .603 .514 r
.56106 .85922 m .56102 .85915 L .56267 .85967 L F
.56102 .85915 m .54446 .8281 L .56267 .85967 L F
.923 .643 .492 r
.52797 .81664 m .54446 .8281 L .54461 .85402 L p F P
0 g
s
.619 .83 .981 r
.52807 .85874 m .54461 .85402 L p .55842 .86031 L F P
0 g
s
.633 .799 .963 r
.52807 .85874 m .51534 .84819 L p .53872 .85066 L F P
0 g
s
.923 .643 .492 r
.54332 .85328 m .52797 .81664 L .54461 .85402 L F
.619 .83 .981 r
.55842 .86031 m .54461 .85402 L .56402 .8606 L F
.88 .603 .514 r
.56494 .86651 m .54462 .85639 L .54446 .8281 L p F P
0 g
s
.633 .799 .963 r
.54461 .85402 m .52807 .85874 L p .53872 .85066 L F P
0 g
s
.633 .799 .963 r
.53483 .85025 m .52802 .84455 L .53872 .85066 L F
.51534 .84819 m .52802 .84455 L p .53483 .85025 L F P
0 g
s
.966 .687 .452 r
.51521 .80389 m .52797 .81664 L .52802 .84455 L p F P
0 g
s
.64 .768 .941 r
.51534 .84819 m .50244 .83559 L p .52208 .8387 L F P
0 g
s
.966 .687 .452 r
.5278 .84434 m .51521 .80389 L .52802 .84455 L F
.923 .643 .492 r
.52802 .84455 m .52797 .81664 L p .54332 .85328 L F P
0 g
s
.64 .768 .941 r
.52802 .84455 m .51534 .84819 L p .52208 .8387 L F P
0 g
s
.64 .768 .941 r
.51928 .83826 m .51517 .8319 L .52208 .8387 L F
.50244 .83559 m .51517 .8319 L p .51928 .83826 L F P
0 g
s
.989 .723 .376 r
.50624 .78979 m .51521 .80389 L .51517 .8319 L p F P
0 g
s
.643 .739 .919 r
.50244 .83559 m .48937 .8209 L p .5116 .8256 L F P
0 g
s
.989 .723 .376 r
.51501 .83161 m .50624 .78979 L .51517 .8319 L F
.966 .687 .452 r
.51517 .8319 m .51521 .80389 L p .5278 .84434 L F P
0 g
s
.643 .739 .919 r
.51517 .8319 m .50244 .83559 L p .5116 .8256 L F P
0 g
s
.643 .739 .919 r
.50882 .82501 m .50614 .81599 L .5116 .8256 L F
.48937 .8209 m .50614 .81599 L p .50882 .82501 L F P
0 g
s
.942 .715 .244 r
.50112 .77428 m .50624 .78979 L .50614 .81599 L p F P
0 g
s
.644 .712 .897 r
.48937 .8209 m .47616 .8041 L p .50501 .81172 L F P
0 g
s
.942 .715 .244 r
.50565 .81415 m .50112 .77428 L .50614 .81599 L F
.989 .723 .376 r
.50614 .81599 m .50624 .78979 L p .51501 .83161 L F P
0 g
s
.644 .712 .897 r
.50614 .81599 m .48937 .8209 L p .50501 .81172 L F P
0 g
s
.673 .722 .887 r
.50157 .79886 m .50109 .79824 L p .50115 .79722 L F P
0 g
s
.673 .722 .887 r
.50109 .79824 m .50013 .797 L p .50104 .7972 L F P
0 g
s
.673 .722 .887 r
.50104 .7972 m .50115 .79722 L .50109 .79824 L F
.78 .625 .063 r
.50062 .76707 m .50112 .77428 L .50101 .79667 L p F P
0 g
s
.644 .712 .897 r
.47616 .8041 m .50013 .797 L .50109 .79824 L p F P
0 g
s
.644 .712 .897 r
.47616 .8041 m .50109 .79824 L .50113 .79895 L F
.47616 .8041 m .50157 .79886 L .50501 .81172 L F
.942 .715 .244 r
.50101 .79667 m .50112 .77428 L p .50576 .81507 L F P
0 g
s
.923 .643 .492 r
.52792 .78865 m .5443 .8002 L .54446 .8281 L p F P
0 g
s
.923 .643 .492 r
.54446 .8281 m .52797 .81664 L .52792 .78865 L p F P
0 g
s
.966 .687 .452 r
.51525 .7758 m .52792 .78865 L .52797 .81664 L p F P
0 g
s
.966 .687 .452 r
.52797 .81664 m .51521 .80389 L .51525 .7758 L p F P
0 g
s
.989 .723 .376 r
.50634 .76159 m .51525 .7758 L .51521 .80389 L p F P
0 g
s
.989 .723 .376 r
.51521 .80389 m .50624 .78979 L .50634 .76159 L p F P
0 g
s
.673 .722 .887 r
.50013 .797 m .52428 .78793 L .53729 .80493 L p F P
0 g
s
.669 .698 .867 r
.50013 .797 m .48687 .77798 L p .50027 .78154 L F P
0 g
s
.78 .625 .063 r
.50052 .78663 m .50062 .76707 L p .50089 .79423 L F P
0 g
s
.78 .625 .063 r
.50089 .7945 m .50062 .76707 L .50101 .79667 L F
.942 .715 .244 r
.50126 .74597 m .50634 .76159 L .50624 .78979 L p F P
0 g
s
.942 .715 .244 r
.50624 .78979 m .50112 .77428 L .50126 .74597 L p F P
0 g
s
.78 .625 .063 r
.50076 .73871 m .50126 .74597 L .50112 .77428 L p F P
0 g
s
.78 .625 .063 r
.50112 .77428 m .50062 .76707 L .50076 .73871 L p F P
0 g
s
0 0 .048 r
.50132 .75689 m .50062 .76707 L .50052 .78663 L p F P
0 g
s
.669 .698 .867 r
.52428 .78793 m .50101 .79667 L p .50052 .78663 L F P
0 g
s
.669 .698 .867 r
.50077 .78167 m .52428 .78793 L .50052 .78663 L F
.50101 .79667 m .50013 .797 L p .50016 .79354 L F P
0 g
s
.669 .698 .867 r
.50027 .78154 m .50052 .78663 L .50016 .79354 L F
.50052 .78663 m .50101 .79667 L .50016 .79354 L F
.78 .625 .063 r
.50051 .78793 m .50052 .78663 L p .50089 .79472 L F P
0 g
s
.78 .625 .063 r
.50089 .79472 m .50052 .78663 L .50089 .79423 L F
.50098 .803 m .50047 .79584 L .50051 .78793 L p F P
0 g
s
.78 .625 .063 r
.50098 .803 m .50051 .78793 L .50089 .79472 L F
0 0 .048 r
.50124 .77253 m .50132 .75689 L p .50079 .78143 L F P
0 g
s
0 0 .048 r
.50079 .78143 m .50132 .75689 L .50052 .78663 L F
.966 .687 .452 r
.52792 .78865 m .51525 .7758 L .51529 .7481 L p F P
0 g
s
.989 .723 .376 r
.50644 .73379 m .51529 .7481 L .51525 .7758 L p F P
0 g
s
.989 .723 .376 r
.51525 .7758 m .50634 .76159 L .50644 .73379 L p F P
0 g
s
.669 .698 .867 r
.51111 .76879 m .52428 .78793 L p .49923 .78126 L F P
0 g
s
.669 .698 .867 r
.48687 .77798 m .50124 .77253 L p .49923 .78126 L F P
0 g
s
.669 .698 .867 r
.50124 .77253 m .51111 .76879 L p .49923 .78126 L F P
0 g
s
.942 .715 .244 r
.5014 .71806 m .50644 .73379 L .50634 .76159 L p F P
0 g
s
.942 .715 .244 r
.50634 .76159 m .50126 .74597 L .5014 .71806 L p F P
0 g
s
0 0 .221 r
.50633 .74092 m .50132 .75689 L .50124 .77253 L p F P
0 g
s
0 0 .221 r
.50437 .75802 m .50633 .74092 L .50124 .77253 L F
.78 .625 .063 r
.5009 .71074 m .5014 .71806 L .50126 .74597 L p F P
0 g
s
.78 .625 .063 r
.50126 .74597 m .50076 .73871 L .5009 .71074 L p F P
0 g
s
0 0 .048 r
.50146 .72845 m .50076 .73871 L .50062 .76707 L p F P
0 g
s
0 0 .048 r
.50062 .76707 m .50132 .75689 L .50146 .72845 L p F P
0 g
s
.665 .675 .849 r
.48687 .77798 m .47349 .75682 L p .50263 .76609 L F P
0 g
s
.665 .675 .849 r
.51111 .76879 m .50124 .77253 L p .50263 .76609 L F P
0 g
s
.665 .675 .849 r
.50124 .77253 m .48687 .77798 L p .50263 .76609 L F P
0 g
s
.942 .715 .244 r
.50153 .69053 m .50654 .70636 L .50644 .73379 L p F P
0 g
s
.942 .715 .244 r
.50644 .73379 m .5014 .71806 L .50153 .69053 L p F P
0 g
s
0 0 .221 r
.50644 .71237 m .50146 .72845 L .50132 .75689 L p F P
0 g
s
0 0 .221 r
.50132 .75689 m .50633 .74092 L .50644 .71237 L p F P
0 g
s
0 0 .221 r
.50437 .75802 m .50437 .75801 L .50633 .74092 L F
.923 .643 .492 r
.54414 .77267 m .52787 .76104 L .52783 .73381 L p F P
0 g
s
.966 .687 .452 r
.51533 .72077 m .52783 .73381 L .52787 .76104 L p F P
0 g
s
.966 .687 .452 r
.52787 .76104 m .51529 .7481 L .51533 .72077 L p F P
0 g
s
.966 .687 .452 r
.51529 .7481 m .52787 .76104 L .52792 .78865 L p F P
0 g
s
.688 .684 .841 r
.50606 .74973 m .53549 .75761 L .50437 .75801 L F
0 0 .221 r
.50631 .74854 m .50633 .74092 L p .50437 .75801 L F P
0 g
s
.989 .723 .376 r
.50654 .70636 m .51533 .72077 L .51529 .7481 L p F P
0 g
s
.989 .723 .376 r
.51529 .7481 m .50644 .73379 L .50654 .70636 L p F P
0 g
s
.688 .684 .841 r
.52642 .74293 m .53549 .75761 L p .50606 .74973 L F P
0 g
s
0 0 .323 r
.50832 .73712 m .50633 .74092 L .50631 .74854 L p F P
0 g
s
0 0 .323 r
.50789 .74389 m .50832 .73712 L .50631 .74854 L F
.688 .684 .841 r
.50631 .74854 m .52642 .74293 L .50606 .74973 L F
.50681 .74608 m .50716 .74602 L .50631 .74854 L F
.50716 .74602 m .52642 .74293 L .50631 .74854 L F
.923 .643 .492 r
.52787 .76104 m .54414 .77267 L .5443 .8002 L p F P
0 g
s
.923 .643 .492 r
.5443 .8002 m .52792 .78865 L .52787 .76104 L p F P
0 g
s
.688 .684 .841 r
.53549 .75761 m .51111 .76879 L .50437 .75801 L p F P
0 g
s
.665 .675 .849 r
.50437 .75801 m .51111 .76879 L p .50263 .76609 L F P
0 g
s
0 0 .323 r
.50789 .74389 m .5081 .74327 L .50832 .73712 L F
.69 .678 .834 r
.5081 .74327 m .52642 .74293 L p .5083 .74266 L F P
0 g
s
0 0 .323 r
.5083 .74267 m .5083 .74266 L p .5081 .74327 L F P
0 g
s
0 0 .323 r
.5083 .74266 m .50832 .73712 L p .5081 .74327 L F P
0 g
s
.69 .678 .834 r
.52642 .74293 m .52227 .73601 L .5083 .74266 L p F P
0 g
s
.69 .678 .834 r
.5083 .74266 m .50696 .74329 L .5081 .74327 L p F P
0 g
s
.688 .684 .841 r
.4978 .74752 m .50696 .74329 L .50801 .74327 L p F P
0 g
s
.688 .684 .841 r
.50801 .74327 m .52642 .74293 L p .50664 .7461 L F P
0 g
s
.688 .684 .841 r
.4978 .74752 m .50801 .74327 L .50664 .7461 L F
.966 .687 .452 r
.52783 .73381 m .51533 .72077 L .51537 .69382 L p F P
0 g
s
.036 0 .392 r
.51439 .72897 m .50832 .73712 L .5083 .74266 L p F P
0 g
s
.989 .723 .376 r
.51533 .72077 m .50654 .70636 L .50664 .67932 L p F P
0 g
s
0 0 .323 r
.50633 .74092 m .50832 .73712 L .50841 .70854 L p F P
0 g
s
.966 .687 .452 r
.52778 .70694 m .51537 .69382 L .51541 .66723 L p F P
0 g
s
.966 .687 .452 r
.51537 .69382 m .52778 .70694 L .52783 .73381 L p F P
0 g
s
.989 .723 .376 r
.50664 .67932 m .51537 .69382 L .51533 .72077 L p F P
0 g
s
.036 0 .392 r
.51969 .69318 m .50841 .70854 L .50832 .73712 L p F P
0 g
s
.683 .657 .817 r
.5162 .7249 m .52227 .73601 L .5083 .74266 L p F P
0 g
s
.036 0 .392 r
.50832 .73712 m .51465 .72862 L p .51969 .69318 L F P
0 g
s
.88 .603 .514 r
.56376 .75595 m .54398 .74552 L .54383 .71873 L p F P
0 g
s
.923 .643 .492 r
.52778 .70694 m .54383 .71873 L .54398 .74552 L p F P
0 g
s
.923 .643 .492 r
.54398 .74552 m .52783 .73381 L .52778 .70694 L p F P
0 g
s
.704 .665 .809 r
.54686 .72221 m .52227 .73601 L .5162 .7249 L p F P
0 g
s
.704 .665 .809 r
.51968 .71656 m .54686 .72221 L .5162 .7249 L F
.923 .643 .492 r
.54383 .71873 m .52778 .70694 L .52773 .68044 L p F P
0 g
s
.966 .687 .452 r
.51541 .66723 m .52773 .68044 L .52778 .70694 L p F P
0 g
s
.195 .049 .444 r
.52202 .71254 m .52919 .68394 L .51968 .71656 L F
.704 .665 .809 r
.52041 .71482 m .52066 .71488 L .51968 .71656 L F
.52066 .71488 m .54686 .72221 L .51968 .71656 L F
.195 .049 .444 r
.52919 .68394 m .51969 .69318 L .51968 .71656 L p F P
0 g
s
.036 0 .392 r
.51968 .71656 m .51969 .69318 L p .51465 .72862 L F P
0 g
s
.704 .665 .809 r
.5336 .69769 m .54686 .72221 L p .52066 .71488 L F P
0 g
s
.195 .049 .444 r
.52922 .70016 m .52919 .68394 L p .52202 .71254 L F P
0 g
s
.704 .665 .809 r
.50893 .71161 m .52922 .70016 L p .52066 .71488 L F P
0 g
s
.704 .665 .809 r
.52922 .70016 m .5336 .69769 L p .52066 .71488 L F P
0 g
s
.195 .049 .444 r
.51968 .72187 m .52925 .7127 L .52922 .70016 L p F P
0 g
s
.195 .049 .444 r
.51968 .72187 m .52922 .70016 L .52202 .71254 L F
.51968 .71656 m .51968 .72187 L p .52202 .71254 L F P
0 g
s
.036 0 .392 r
.51465 .72862 m .51968 .72187 L .51968 .71656 L p F P
0 g
s
.704 .665 .809 r
.5162 .7249 m .50893 .71161 L p .52041 .71482 L F P
0 g
s
.683 .657 .817 r
.50893 .71161 m .5162 .7249 L p .50696 .74329 L F P
0 g
s
.683 .657 .817 r
.5083 .74266 m .50696 .74329 L p .5162 .7249 L F P
0 g
s
.036 0 .392 r
.516 .72681 m .51439 .72897 L p .5083 .74267 L F P
0 g
s
.036 0 .392 r
.5083 .74266 m .5083 .74267 L p .51439 .72897 L F P
0 g
s
.036 0 .392 r
.51968 .72187 m .516 .72681 L p .50823 .76612 L F P
0 g
s
.036 0 .392 r
.5083 .74267 m .50823 .76612 L p .516 .72681 L F P
0 g
s
0 0 .323 r
.50623 .76989 m .50823 .76612 L .5083 .74267 L p F P
0 g
s
0 0 .323 r
.50623 .76989 m .5083 .74267 L .50789 .74389 L F
.50631 .74854 m .50623 .76989 L p .50789 .74389 L F P
0 g
s
.688 .684 .841 r
.4978 .74752 m .50681 .74608 L .50631 .74854 L F
.50592 .74969 m .50631 .74854 L .50606 .74973 L F
.4978 .74752 m .50631 .74854 L .50592 .74969 L F
0 0 .221 r
.50118 .78574 m .5063 .74903 L .50437 .75801 L F
.50437 .75802 m .50437 .75801 L .50437 .75802 L F
.50118 .78574 m .50437 .75801 L .50437 .75802 L F
.5063 .74903 m .50631 .74854 L p .50437 .75801 L F P
0 g
s
.688 .684 .841 r
.50437 .75801 m .4978 .74752 L p .50606 .74973 L F P
0 g
s
.665 .675 .849 r
.47349 .75682 m .4978 .74752 L .50437 .75801 L p F P
0 g
s
.665 .675 .849 r
.47349 .75682 m .50437 .75801 L .50263 .76609 L F
0 0 .221 r
.50118 .78574 m .50623 .76989 L .5063 .74903 L p F P
0 g
s
0 0 .221 r
.50415 .75994 m .50437 .75802 L .50124 .77253 L F
.50124 .77253 m .50118 .78574 L p .50415 .75994 L F P
0 g
s
0 0 .048 r
.50047 .79584 m .50118 .78574 L .50124 .77253 L p F P
0 g
s
0 0 .048 r
.50047 .79584 m .50124 .77253 L .50079 .78143 L F
.50052 .78663 m .50047 .79584 L p .50079 .78143 L F P
0 g
s
.669 .698 .867 r
.50027 .78154 m .50077 .78167 L .50052 .78663 L F
.644 .712 .897 r
.50109 .79824 m .50157 .79886 L p .50113 .79895 L F P
0 g
s
.644 .712 .897 r
.50157 .79886 m .51325 .8139 L p .50501 .81172 L F P
0 g
s
.942 .715 .244 r
.50613 .81838 m .50098 .803 L .50101 .79674 L p F P
0 g
s
.942 .715 .244 r
.50101 .79674 m .50101 .79667 L p .50115 .79729 L F P
0 g
s
.942 .715 .244 r
.50613 .81838 m .50101 .79674 L .50115 .79729 L F
.78 .625 .063 r
.50101 .79667 m .50098 .803 L p .50089 .7945 L F P
0 g
s
.942 .715 .244 r
.50613 .81838 m .50101 .79667 L .50576 .81507 L F
.673 .722 .887 r
.53729 .80493 m .51325 .8139 L .50157 .79886 L p F P
0 g
s
.673 .722 .887 r
.50115 .79722 m .53729 .80493 L .50157 .79886 L F
.644 .712 .897 r
.51325 .8139 m .50614 .81599 L p .50501 .81172 L F P
0 g
s
.942 .715 .244 r
.50569 .81445 m .50565 .81415 L .50614 .81599 L F
.50614 .81599 m .50613 .81838 L p .50569 .81445 L F P
0 g
s
.989 .723 .376 r
.51517 .83237 m .50613 .81838 L .50614 .81599 L p F P
0 g
s
.989 .723 .376 r
.51517 .83237 m .50614 .81599 L .51501 .83161 L F
.643 .739 .919 r
.51325 .8139 m .52621 .82869 L p .5116 .8256 L F P
0 g
s
.643 .739 .919 r
.50614 .81599 m .51325 .8139 L p .5116 .8256 L F P
0 g
s
.643 .739 .919 r
.52621 .82869 m .51517 .8319 L p .5116 .8256 L F P
0 g
s
.989 .723 .376 r
.51502 .83166 m .51501 .83161 L .51517 .8319 L F
.51517 .8319 m .51517 .83237 L p .51502 .83166 L F P
0 g
s
.966 .687 .452 r
.52802 .84503 m .51517 .83237 L .51517 .8319 L p F P
0 g
s
.966 .687 .452 r
.52802 .84503 m .51517 .8319 L .5278 .84434 L F
.64 .768 .941 r
.52621 .82869 m .539 .84139 L p .52208 .8387 L F P
0 g
s
.64 .768 .941 r
.51517 .8319 m .52621 .82869 L p .52208 .8387 L F P
0 g
s
.64 .768 .941 r
.539 .84139 m .52802 .84455 L p .52208 .8387 L F P
0 g
s
.966 .687 .452 r
.52782 .84438 m .5278 .84434 L .52802 .84455 L F
.52802 .84455 m .52802 .84503 L p .52782 .84438 L F P
0 g
s
.923 .643 .492 r
.54462 .85639 m .52802 .84503 L .52802 .84455 L p F P
0 g
s
.923 .643 .492 r
.54462 .85639 m .52802 .84455 L .54332 .85328 L F
.633 .799 .963 r
.539 .84139 m .55161 .85202 L p .53872 .85066 L F P
0 g
s
.633 .799 .963 r
.52802 .84455 m .539 .84139 L p .53872 .85066 L F P
0 g
s
.633 .799 .963 r
.55161 .85202 m .54461 .85402 L p .53872 .85066 L F P
0 g
s
.923 .643 .492 r
.5434 .85346 m .54332 .85328 L .54461 .85402 L F
.54461 .85402 m .54462 .85639 L p .5434 .85346 L F P
0 g
s
.619 .83 .981 r
.54461 .85402 m .55161 .85202 L .56267 .85967 L p F P
0 g
s
.665 .844 .968 r
.58757 .85203 m .56488 .86029 L p .55161 .85202 L F P
0 g
s
.665 .844 .968 r
.56488 .86029 m .56402 .8606 L .56267 .85967 L p F P
0 g
s
.665 .844 .968 r
.56267 .85967 m .55161 .85202 L p .56488 .86029 L F P
0 g
s
.88 .603 .514 r
.56127 .85961 m .56106 .85922 L .56488 .86029 L F
.56488 .86029 m .56494 .86651 L p .56127 .85961 L F P
0 g
s
.842 .569 .527 r
.57523 .87032 m .56494 .86651 L .56488 .86029 L p F P
0 g
s
.842 .569 .527 r
.57523 .87032 m .56488 .86029 L .57215 .86101 L F
.649 .875 .982 r
.57511 .8613 m .59009 .86216 L .58422 .8622 L F
.822 .553 .532 r
.59031 .87504 m .57511 .8613 L .5841 .86181 L F
.59009 .86216 m .59031 .87504 L p .5841 .86181 L F P
0 g
s
.842 .569 .527 r
.57511 .8613 m .57523 .87032 L p .57215 .86101 L F P
0 g
s
.621 .9 .986 r
.59009 .86216 m .59962 .8587 L .60564 .8611 L p F P
0 g
s
.675 .915 .975 r
.60564 .8611 m .59962 .8587 L p .61838 .85947 L F P
0 g
s
.675 .915 .975 r
.61838 .85947 m .61927 .8595 L .61515 .85999 L F
.61838 .85947 m .61515 .85999 L .60564 .8611 L F
.761 .503 .542 r
.61516 .86052 m .61515 .85999 L p .6168 .86011 L F P
0 g
s
.761 .503 .542 r
.6168 .86011 m .61515 .85999 L .61671 .85974 L F
.622 .88167 m .61516 .86052 L .6168 .86011 L F
.63 .942 .955 r
.63476 .85287 m .62144 .85896 L p .62437 .85814 L F P
0 g
s
.735 .481 .545 r
.64109 .85448 m .63803 .85434 L .6452 .85287 L F
.63803 .85434 m .64311 .85293 L .6452 .85287 L F
.63902 .85529 m .63797 .85519 L p .64109 .85448 L F P
0 g
s
.674 .926 .972 r
.63114 .85159 m .63476 .85287 L .62144 .85896 L p F P
0 g
s
.674 .926 .972 r
.62144 .85896 m .62017 .85954 L .6208 .85908 L p F P
0 g
s
.674 .926 .972 r
.6208 .85908 m .63114 .85159 L p .62144 .85896 L F P
0 g
s
.761 .503 .542 r
.62123 .85901 m .62122 .859 L .62144 .85896 L F
.6168 .86011 m .61671 .85974 L .62123 .85901 L F
.622 .88167 m .6168 .86011 L .62123 .85901 L F
.62144 .85896 m .62144 .85898 L p .62123 .85901 L F P
0 g
s
.761 .503 .542 r
.62144 .85898 m .622 .88167 L p .62123 .85901 L F P
0 g
s
.788 .525 .538 r
.61515 .85999 m .61516 .86052 L p .61435 .86008 L F P
0 g
s
.788 .525 .538 r
.61516 .86052 m .61563 .88068 L p .60234 .86329 L F P
0 g
s
.63 .942 .955 r
.63997 .8538 m .63476 .85287 L p .62437 .85814 L F P
0 g
s
.735 .481 .545 r
.6452 .85287 m .64311 .85293 L .64482 .85246 L F
.637 .961 .911 r
.6652 .84452 m .64613 .85491 L p .67029 .84229 L F P
0 g
s
.735 .481 .545 r
.64821 .85617 m .63902 .85529 L p .6452 .85287 L F P
0 g
s
.703 .455 .547 r
.66563 .85658 m .64821 .85617 L .64805 .85105 L p F P
0 g
s
.703 .455 .547 r
.64805 .85105 m .64735 .82849 L p .65925 .84678 L F P
0 g
s
.735 .481 .545 r
.6452 .85287 m .64461 .85222 L .64807 .85174 L F
.64461 .85222 m .62063 .82589 L .64752 .85123 L F
.64461 .85222 m .64752 .85123 L .64807 .85174 L F
.703 .455 .547 r
.64735 .82849 m .66465 .8289 L .6652 .84452 L p F P
0 g
s
.692 .959 .946 r
.6652 .84452 m .66188 .84633 L p .65797 .84727 L F P
0 g
s
.692 .959 .946 r
.63997 .8538 m .63476 .85287 L p .66188 .84633 L F P
0 g
s
.703 .455 .547 r
.65938 .84697 m .65925 .84678 L .6652 .84452 L F
.65925 .84678 m .64735 .82849 L .6652 .84452 L F
.684 .441 .548 r
.6652 .84452 m .66465 .8289 L p .67106 .84195 L F P
0 g
s
.692 .959 .946 r
.66932 .84228 m .6652 .84452 L p .63476 .85287 L F P
0 g
s
.692 .959 .946 r
.63476 .85287 m .6652 .84452 L .65797 .84727 L F
.703 .455 .547 r
.66563 .85658 m .64805 .85105 L .65925 .84678 L F
.735 .481 .545 r
.64805 .85105 m .64807 .85174 L p .64752 .85123 L F P
0 g
s
.735 .481 .545 r
.64807 .85174 m .64821 .85617 L p .6452 .85287 L F P
0 g
s
.637 .961 .911 r
.67213 .84231 m .67049 .84229 L p .66522 .84502 L F P
0 g
s
.637 .961 .911 r
.67049 .84229 m .67029 .84229 L p .66945 .84273 L F P
0 g
s
.703 .455 .547 r
.6652 .84452 m .66563 .85658 L p .65938 .84697 L F P
0 g
s
.684 .441 .548 r
.67812 .85636 m .66563 .85658 L .6652 .84452 L p F P
0 g
s
.684 .441 .548 r
.67812 .85636 m .6652 .84452 L .67106 .84195 L F
.637 .961 .911 r
.67029 .84229 m .66932 .84228 L .6652 .84452 L p F P
0 g
s
.649 .413 .548 r
.67744 .83854 m .67707 .82868 L .69732 .82678 L p F P
0 g
s
.686 .98 .875 r
.69879 .82658 m .69746 .8267 L p .68796 .83265 L F P
0 g
s
.649 .413 .548 r
.69734 .82678 m .67707 .82868 L p .7041 .82221 L F P
0 g
s
.686 .98 .875 r
.69249 .82713 m .67946 .83586 L .67508 .83993 L p F P
0 g
s
.686 .98 .875 r
.67508 .83993 m .67252 .84231 L p .67767 .8384 L F P
0 g
s
.686 .98 .875 r
.67767 .8384 m .69249 .82713 L .67508 .83993 L F
.649 .413 .548 r
.67812 .85636 m .67744 .83854 L p .70427 .82613 L F P
0 g
s
.649 .413 .548 r
.69732 .82678 m .70427 .82613 L p .67744 .83854 L F P
0 g
s
.699 .978 .905 r
.66932 .84228 m .67946 .83586 L .67528 .83975 L p F P
0 g
s
.699 .978 .905 r
.67029 .84229 m .66932 .84228 L p .67528 .83975 L F P
0 g
s
.684 .441 .548 r
.67744 .83854 m .67812 .85636 L p .67112 .84208 L F P
0 g
s
.686 .98 .875 r
.69746 .8267 m .69249 .82713 L p .67767 .8384 L F P
0 g
s
.649 .413 .548 r
.70427 .82613 m .69734 .82678 L p .69746 .8267 L F P
0 g
s
.606 .381 .548 r
.71088 .81734 m .72831 .79415 L .72082 .80998 L F
.733 .99 .824 r
.72264 .80857 m .72602 .80784 L p .71737 .81267 L F P
0 g
s
.606 .381 .548 r
.71737 .81267 m .72082 .80998 L .72067 .8103 L F
.71088 .81734 m .72082 .80998 L .71737 .81267 L F
.733 .99 .824 r
.72602 .80784 m .71117 .82005 L .71737 .81267 L p F P
0 g
s
.606 .381 .548 r
.72831 .79415 m .72877 .80316 L p .72067 .8103 L F P
0 g
s
.733 .99 .824 r
.71737 .81267 m .72043 .80904 L .72264 .80857 L p F P
0 g
s
.745 .992 .866 r
.71737 .81267 m .71117 .82005 L p .70255 .82332 L F P
0 g
s
.606 .381 .548 r
.70427 .82613 m .70304 .7988 L .72831 .79415 L p F P
0 g
s
.745 .992 .866 r
.72043 .80904 m .71737 .81267 L p .69249 .82713 L F P
0 g
s
.745 .992 .866 r
.69249 .82713 m .71737 .81267 L .70255 .82332 L F
.606 .381 .548 r
.70729 .82212 m .72067 .8103 L .72971 .82151 L F
.557 .343 .545 r
.72877 .80316 m .72831 .79415 L .7429 .78997 L p F P
0 g
s
.787 .998 .815 r
.72043 .80904 m .72307 .80847 L p .73336 .79887 L F P
0 g
s
.787 .998 .815 r
.72307 .80847 m .72602 .80784 L p .73336 .79887 L F P
0 g
s
.606 .381 .548 r
.72877 .80316 m .72883 .80444 L p .72067 .8103 L F P
0 g
s
.606 .381 .548 r
.72883 .80444 m .72971 .82151 L p .72067 .8103 L F P
0 g
s
.649 .413 .548 r
.7041 .82221 m .70412 .82276 L p .69746 .8267 L F P
0 g
s
.649 .413 .548 r
.70412 .82276 m .70427 .82613 L p .69746 .8267 L F P
0 g
s
.745 .992 .866 r
.69746 .8267 m .69249 .82713 L p .70234 .8234 L F P
0 g
s
.606 .381 .548 r
.70729 .82212 m .71088 .81734 L .72067 .8103 L F
.72971 .82151 m .70427 .82613 L p .70729 .82212 L F P
0 g
s
.557 .343 .545 r
.72971 .82151 m .72877 .80316 L p .75188 .7874 L F P
0 g
s
.557 .343 .545 r
.72831 .79415 m .75153 .78119 L .75062 .78223 L F
.83 1 .801 r
.75062 .78223 m .74833 .78671 L .74587 .7872 L p F P
0 g
s
.557 .343 .545 r
.74767 .78531 m .75062 .78223 L .7481 .78512 L F
.72831 .79415 m .75062 .78223 L .74767 .78531 L F
.498 .299 .54 r
.75164 .78323 m .75153 .78119 L p .76223 .76899 L F P
0 g
s
.498 .299 .54 r
.75153 .78119 m .75033 .76035 L p .76187 .76873 L F P
0 g
s
.498 .299 .54 r
.75153 .78119 m .76187 .76873 L .76223 .76899 L F
.76187 .76873 m .75033 .76035 L .76344 .76684 L F
.822 .993 .749 r
.7614 .76441 m .75735 .76905 L .75055 .78237 L p F P
0 g
s
.822 .993 .749 r
.75055 .78237 m .74833 .78671 L p .75166 .78103 L F P
0 g
s
.822 .993 .749 r
.75166 .78103 m .7614 .76441 L .75055 .78237 L F
.83 1 .801 r
.73861 .78864 m .75735 .76905 L .75062 .78223 L p F P
0 g
s
.557 .343 .545 r
.7429 .78997 m .72831 .79415 L p .7481 .78512 L F P
0 g
s
.83 1 .801 r
.74587 .7872 m .73861 .78864 L p .75062 .78223 L F P
0 g
s
.787 .998 .815 r
.72043 .80904 m .73471 .79761 L .73861 .78864 L F
.74833 .78671 m .74587 .7872 L p .73471 .79761 L F P
0 g
s
.787 .998 .815 r
.74587 .7872 m .73861 .78864 L p .73471 .79761 L F P
0 g
s
.557 .343 .545 r
.74418 .7896 m .7429 .78997 L p .7481 .78512 L F P
0 g
s
.557 .343 .545 r
.7429 .78997 m .75188 .7874 L p .72877 .80316 L F P
0 g
s
.787 .998 .815 r
.72043 .80904 m .73336 .79887 L .73471 .79761 L F
.557 .343 .545 r
.75188 .7874 m .74418 .7896 L p .7481 .78512 L F P
0 g
s
.557 .343 .545 r
.75153 .78119 m .75157 .78188 L p .7481 .78512 L F P
0 g
s
.557 .343 .545 r
.75157 .78188 m .75188 .7874 L p .7481 .78512 L F P
0 g
s
.498 .299 .54 r
.76223 .76899 m .76187 .76873 L .76344 .76684 L F
.86 .991 .736 r
.76832 .76079 m .77328 .7582 L .76719 .76231 L F
.498 .299 .54 r
.77383 .77849 m .75188 .7874 L p .76223 .76899 L F P
0 g
s
.498 .299 .54 r
.77212 .75138 m .77237 .75534 L p .76223 .76899 L F P
0 g
s
.86 .991 .736 r
.77672 .74949 m .77328 .7582 L p .76869 .7606 L F P
0 g
s
.86 .991 .736 r
.76832 .76079 m .77237 .75534 L .76869 .7606 L F
.77237 .75534 m .77672 .74949 L .76869 .7606 L F
.431 .249 .532 r
.77237 .75534 m .77212 .75138 L .77705 .74865 L p F P
0 g
s
.86 .991 .736 r
.7614 .76441 m .78036 .74027 L .77672 .74949 L p F P
0 g
s
.86 .991 .736 r
.7614 .76441 m .77672 .74949 L .76832 .76079 L F
.431 .249 .532 r
.77241 .7559 m .77237 .75534 L p .77705 .74865 L F P
0 g
s
.498 .299 .54 r
.77237 .75534 m .77383 .77849 L p .76223 .76899 L F P
0 g
s
.822 .993 .749 r
.76719 .76231 m .7614 .76441 L p .75166 .78103 L F P
0 g
s
.86 .991 .736 r
.76719 .76231 m .7614 .76441 L p .76832 .76079 L F P
0 g
s
.498 .299 .54 r
.75188 .7874 m .75164 .78323 L p .76223 .76899 L F P
0 g
s
.431 .249 .532 r
.77383 .77849 m .77241 .7559 L p .79234 .74018 L F P
0 g
s
.431 .249 .532 r
.77705 .74865 m .79234 .74018 L p .77241 .7559 L F P
0 g
s
.431 .249 .532 r
.77851 .74784 m .77705 .74865 L p .78664 .73367 L F P
0 g
s
.847 .975 .667 r
.78384 .73532 m .78664 .73367 L p .77932 .7451 L F P
0 g
s
.353 .193 .52 r
.79703 .71497 m .79841 .70758 L .79134 .72548 L F
.859 .94 .571 r
.80566 .69908 m .79869 .7117 L p .79283 .73002 L F P
0 g
s
.859 .94 .571 r
.80975 .69534 m .80566 .69908 L p .79283 .73002 L F P
0 g
s
.353 .193 .52 r
.79234 .74018 m .80029 .73444 L .79869 .7117 L p F P
0 g
s
.353 .193 .52 r
.79869 .7117 m .79841 .70758 L p .79699 .71519 L F P
0 g
s
.859 .94 .571 r
.79772 .7137 m .79283 .73002 L p .79869 .7117 L F P
0 g
s
.353 .193 .52 r
.79234 .74018 m .79869 .7117 L .79699 .71519 L F
.859 .94 .571 r
.79869 .7117 m .79787 .71319 L .79772 .7137 L p F P
0 g
s
.881 .971 .657 r
.78704 .73344 m .78384 .73532 L p .79772 .7137 L F P
0 g
s
.431 .249 .532 r
.79134 .72548 m .79234 .74018 L .77851 .74784 L p F P
0 g
s
.353 .193 .52 r
.79134 .72548 m .79234 .74018 L p .79703 .71497 L F P
0 g
s
.881 .971 .657 r
.78384 .73532 m .79787 .71319 L .79772 .7137 L p F P
0 g
s
.364 .822 .925 r
.57698 .88038 m .56927 .87922 L .54394 .88328 L p F P
0 g
s
.369 .181 .489 r
.53572 .38646 m .53562 .36211 L .55439 .34878 L p F P
0 g
s
.265 .102 .464 r
.52859 .39316 m .53572 .38646 L .53562 .36211 L p F P
0 g
s
0 0 .394 r
.82474 .58568 m .81764 .60181 L .81964 .62777 L p F P
0 g
s
0 0 .394 r
.81764 .60181 m .82474 .58568 L .8227 .55998 L p F P
0 g
s
.069 0 .449 r
.81723 .63152 m .81964 .62777 L .81764 .60181 L p F P
0 g
s
.684 .441 .548 r
.66369 .80159 m .67602 .80137 L .67707 .82868 L p F P
0 g
s
.684 .441 .548 r
.67707 .82868 m .66465 .8289 L .66369 .80159 L p F P
0 g
s
.703 .455 .547 r
.6465 .80118 m .66369 .80159 L .66465 .8289 L p F P
0 g
s
0 0 0 r
.33469 .3158 m .34871 .30656 L .33659 .31375 L closepath p F P
0 g
s
0 0 0 r
.33659 .31375 m .34871 .30656 L .35713 .30135 L p F P
0 g
s
0 0 0 r
.33659 .31375 m .33469 .3158 L .31214 .33374 L p F P
0 g
s
.649 .413 .548 r
.67707 .82868 m .67602 .80137 L .70304 .7988 L p F P
0 g
s
.588 .348 .521 r
.59805 .30533 m .59753 .28153 L .62251 .27563 L p F P
0 g
s
.529 .302 .515 r
.59753 .28153 m .59805 .30533 L .57502 .31377 L p F P
0 g
s
.703 .455 .547 r
.66465 .8289 m .64735 .82849 L .6465 .80118 L p F P
0 g
s
.735 .481 .545 r
.61997 .79856 m .6465 .80118 L .64735 .82849 L p F P
0 g
s
.187 .626 .944 r
.42671 .8709 m .44897 .87451 L .44087 .86955 L p F P
0 g
s
.187 .626 .944 r
.41363 .86296 m .42671 .8709 L p .44087 .86955 L F P
0 g
s
.068 .548 .896 r
.42671 .8709 m .41363 .86296 L .39161 .85741 L p F P
0 g
s
.247 .752 .886 r
.54394 .88328 m .53356 .88391 L .51934 .88539 L p F P
0 g
s
.348 .79 .96 r
.53356 .88391 m .51549 .88422 L .51934 .88539 L closepath p F P
0 g
s
0 0 0 r
.25897 .39711 m .24949 .40919 L .24378 .42445 L p F P
0 g
s
0 0 0 r
.24949 .40919 m .25897 .39711 L .26596 .38616 L p F P
0 g
s
.353 .193 .52 r
.79052 .71336 m .79841 .70758 L .79655 .68108 L p F P
0 g
s
.302 .156 .51 r
.80652 .67246 m .79655 .68108 L .79841 .70758 L p F P
0 g
s
.966 .687 .452 r
.52773 .68044 m .51541 .66723 L .51544 .641 L p F P
0 g
s
.989 .723 .376 r
.50684 .62632 m .51544 .641 L .51541 .66723 L p F P
0 g
s
.989 .723 .376 r
.51544 .641 m .50684 .62632 L .50693 .60035 L p F P
0 g
s
.61736 .26954 m
.62363 .27236 L
s
.6262 .27351 m
.62992 .27519 L
s
.62363 .27236 m
.6262 .27351 L
s
.6392 .27936 m
.64493 .28194 L
s
0 .433 .841 r
.35663 .83885 m .37286 .84548 L .38927 .8566 L p F P
0 g
s
.044 .495 .887 r
.38927 .8566 m .39161 .85741 L .37832 .84735 L p F P
0 g
s
.044 .495 .887 r
.37832 .84735 m .37286 .84548 L .38927 .8566 L p F P
0 g
s
.1 0 0 r
.43299 .26864 m .43803 .26571 L .46043 .26185 L p F P
0 g
s
0 0 0 r
.43803 .26571 m .43299 .26864 L .40927 .27562 L p F P
0 g
s
0 0 .54 r
.21872 .64679 m .21997 .66447 L .22925 .68199 L p F P
0 g
s
0 0 .434 r
.21167 .62877 m .21872 .64679 L .21997 .66447 L p F P
0 g
s
0 .28 .781 r
.29744 .79234 m .30842 .80026 L .29488 .78292 L p F P
0 g
s
0 .28 .781 r
.29488 .78292 m .28851 .77834 L .29744 .79234 L p F P
0 g
s
0 .191 .716 r
.27428 .76617 m .28851 .77834 L .29744 .79234 L p F P
0 g
s
.942 .715 .244 r
.50206 .58413 m .50693 .60035 L .50684 .62632 L p F P
0 g
s
.942 .715 .244 r
.50693 .60035 m .50206 .58413 L .50219 .55842 L p F P
0 g
s
.943 .668 .205 r
.82267 .4885 m .82906 .50416 L .83072 .52439 L p F P
0 g
s
.874 .569 .052 r
.82906 .50416 m .82267 .4885 L .81907 .46909 L p F P
0 g
s
0 0 .286 r
.82495 .54938 m .8227 .55998 L .82474 .58568 L p F P
0 g
s
.822 .553 .532 r
.58891 .79177 m .57413 .78694 L .57378 .75989 L p F P
0 g
s
.842 .569 .527 r
.56376 .75595 m .57378 .75989 L .57413 .78694 L p F P
0 g
s
.054 .464 .883 r
.37286 .84548 m .35663 .83885 L .34319 .82667 L p F P
0 g
s
.955 .841 .415 r
.8341 .59445 m .83461 .59957 L .82978 .62232 L p F P
0 g
s
.891 .937 .566 r
.80566 .69908 m .8115 .68739 L .80975 .69534 L closepath p F P
0 g
s
.856 .889 .462 r
.8218 .66273 m .8115 .68739 L .80975 .69534 L p F P
0 g
s
.857 .562 .487 r
.75202 .31433 m .76166 .31916 L .76329 .34324 L p F P
0 g
s
.9 .597 .465 r
.7819 .35579 m .76329 .34324 L .76166 .31916 L p F P
0 g
s
0 0 0 r
.30963 .33691 m .31214 .33374 L .33469 .3158 L p F P
0 g
s
0 0 0 r
.30219 .34298 m .30963 .33691 L .31214 .33374 L closepath p F P
0 g
s
0 0 0 r
.30219 .34298 m .30963 .33691 L p .28516 .36319 L F P
0 g
s
0 0 0 r
.28516 .36319 m .28932 .35632 L .30219 .34298 L p F P
0 g
s
.159 .57 .932 r
.41363 .86296 m .39161 .85741 L .37832 .84735 L p F P
0 g
s
0 .23 .75 r
.28851 .77834 m .27428 .76617 L .26644 .75409 L p F P
0 g
s
.933 .924 .552 r
.82248 .65513 m .8218 .66273 L .8115 .68739 L p F P
0 g
s
.78 .625 .063 r
.50171 .55084 m .50219 .55842 L .50206 .58413 L p F P
0 g
s
.735 .481 .545 r
.64735 .82849 m .62063 .82589 L .61997 .79856 L p F P
0 g
s
.761 .503 .542 r
.61372 .79754 m .61997 .79856 L .62063 .82589 L p F P
0 g
s
0 0 0 r
.27657 .37151 m .28516 .36319 L .28932 .35632 L closepath p F P
0 g
s
.797 .512 .507 r
.73768 .30832 m .71316 .30105 L .71187 .27723 L p F P
0 g
s
.766 .488 .513 r
.70567 .27593 m .71187 .27723 L .71316 .30105 L p F P
0 g
s
0 0 0 r
.32802 .32432 m .33469 .3158 L .34871 .30656 L p F P
0 g
s
0 0 0 r
.33469 .3158 m .32802 .32432 L .30963 .33691 L p F P
0 g
s
.761 .503 .542 r
.62063 .82589 m .61435 .82488 L .61372 .79754 L p F P
0 g
s
.788 .525 .538 r
.58891 .79177 m .61372 .79754 L .61435 .82488 L p F P
0 g
s
0 0 .072 r
.21467 .49829 m .21833 .48993 L .22266 .46888 L p F P
0 g
s
0 0 .144 r
.22751 .45972 m .22266 .46888 L .21833 .48993 L p F P
0 g
s
0 0 .478 r
.21238 .61339 m .21167 .62877 L .21872 .64679 L p F P
0 g
s
0 0 .366 r
.2105 .60226 m .20768 .59146 L p .21167 .62877 L F P
0 g
s
0 0 .366 r
.21167 .62877 m .21238 .61339 L .2105 .60226 L p F P
0 g
s
0 0 .231 r
.20643 .56309 m .20904 .55208 L .20831 .53251 L p F P
0 g
s
0 0 .289 r
.21301 .51854 m .20831 .53251 L .20904 .55208 L p F P
0 g
s
0 0 .154 r
.20831 .53251 m .21301 .51854 L .21467 .49829 L p F P
0 g
s
.766 .488 .513 r
.71316 .30105 m .70692 .29976 L .70567 .27593 L p F P
0 g
s
.736 .464 .517 r
.67915 .27259 m .70567 .27593 L .70692 .29976 L p F P
0 g
s
0 0 .198 r
.82495 .54938 m .82561 .54174 L .82356 .51629 L p F P
0 g
s
.774 .572 .001 r
.82111 .49939 m .82356 .51629 L .82561 .54174 L p F P
0 g
s
.945 .637 .424 r
.79825 .39389 m .78367 .38016 L .7819 .35579 L p F P
0 g
s
.9 .597 .465 r
.76329 .34324 m .7819 .35579 L .78367 .38016 L p F P
0 g
s
.588 .348 .521 r
.62251 .27563 m .62319 .29945 L .59805 .30533 L p F P
0 g
s
.112 0 0 r
.40192 .28159 m .40927 .27562 L .43299 .26864 L p F P
0 g
s
0 0 0 r
.40927 .27562 m .40192 .28159 L .37951 .29013 L p F P
0 g
s
0 0 0 r
.27657 .37151 m .28516 .36319 L p .26313 .39234 L F P
0 g
s
0 0 0 r
.26313 .39234 m .26596 .38616 L .27657 .37151 L p F P
0 g
s
.027 .405 .857 r
.33051 .82019 m .34319 .82667 L .32968 .81212 L p F P
0 g
s
.027 .405 .857 r
.32968 .81212 m .31965 .80702 L .33051 .82019 L p F P
0 g
s
0 .336 .812 r
.30842 .80026 m .31965 .80702 L .33051 .82019 L p F P
0 g
s
.842 .569 .527 r
.57413 .78694 m .56405 .78303 L .56376 .75595 L p F P
0 g
s
.88 .603 .514 r
.54398 .74552 m .56376 .75595 L .56405 .78303 L p F P
0 g
s
.908 .528 .094 r
.79453 .42043 m .80508 .43525 L .8106 .45383 L p F P
0 g
s
.832 .42 0 r
.80508 .43525 m .79453 .42043 L .78713 .40272 L p F P
0 g
s
.395 .805 .979 r
.50694 .88115 m .51549 .88422 L .53356 .88391 L p F P
0 g
s
.295 .75 .955 r
.50694 .88115 m .48612 .88196 L .51549 .88422 L closepath p F P
0 g
s
.233 .722 .924 r
.51549 .88422 m .48612 .88196 L .48424 .88199 L p F P
0 g
s
0 0 0 r
.34871 .30656 m .35612 .30233 L p .32802 .32432 L F P
0 g
s
0 0 0 r
.34871 .30656 m .35612 .30233 L .35713 .30135 L closepath p F P
0 g
s
.311 .784 .928 r
.54212 .88289 m .53356 .88391 L .54394 .88328 L closepath p F P
0 g
s
.395 .805 .979 r
.53356 .88391 m .54212 .88289 L p .50694 .88115 L F P
0 g
s
0 0 .364 r
.20904 .55208 m .20643 .56309 L .20833 .58714 L p F P
0 g
s
0 0 .295 r
.20768 .59146 m .20833 .58714 L .20643 .56309 L p F P
0 g
s
.857 .562 .487 r
.76329 .34324 m .75359 .33843 L .75202 .31433 L p F P
0 g
s
.835 .543 .496 r
.73768 .30832 m .75202 .31433 L .75359 .33843 L p F P
0 g
s
0 0 .048 r
.50171 .55084 m .50238 .54015 L .50251 .51469 L p F P
0 g
s
0 0 .221 r
.50723 .49784 m .50251 .51469 L .50238 .54015 L p F P
0 g
s
0 0 .221 r
.50251 .51469 m .50723 .49784 L .50732 .47265 L p F P
0 g
s
0 0 .222 r
.21833 .48993 m .21467 .49829 L .21301 .51854 L p F P
0 g
s
.529 .302 .515 r
.57539 .33787 m .57502 .31377 L .59805 .30533 L p F P
0 g
s
.457 .247 .505 r
.57502 .31377 m .57539 .33787 L .55439 .34878 L p F P
0 g
s
.412 .84 .955 r
.54212 .88289 m .54394 .88328 L .56927 .87922 L p F P
0 g
s
.928 .771 .294 r
.83477 .56141 m .83247 .58326 L .8341 .59445 L p F P
0 g
s
.965 .833 .413 r
.8285 .60405 m .83247 .58326 L .8341 .59445 L closepath p F P
0 g
s
.955 .841 .415 r
.8285 .60405 m .8341 .59445 L p .82978 .62232 L F P
0 g
s
.976 .672 .347 r
.81065 .43338 m .80012 .41853 L .79825 .39389 L p F P
0 g
s
.945 .637 .424 r
.78367 .38016 m .79825 .39389 L .80012 .41853 L p F P
0 g
s
.976 .672 .347 r
.80012 .41853 m .81065 .43338 L .81261 .4583 L p F P
0 g
s
.326 .745 .976 r
.48612 .88196 m .48319 .8815 L .48424 .88199 L closepath p F P
0 g
s
.195 .049 .444 r
.51978 .42754 m .52864 .4178 L .52859 .39316 L p F P
0 g
s
.265 .102 .464 r
.53572 .38646 m .52859 .39316 L .52864 .4178 L p F P
0 g
s
0 0 0 r
.30221 .3493 m .30963 .33691 L .32802 .32432 L p F P
0 g
s
0 0 0 r
.30963 .33691 m .30221 .3493 L .28516 .36319 L p F P
0 g
s
0 0 0 r
.35612 .30233 m .35713 .30135 L .37951 .29013 L p F P
0 g
s
.736 .464 .517 r
.70692 .29976 m .68022 .29642 L .67915 .27259 L p F P
0 g
s
.7 .435 .521 r
.6619 .27206 m .67915 .27259 L .68022 .29642 L p F P
0 g
s
0 .133 .68 r
.26644 .75409 m .26086 .74494 L .26365 .74783 L closepath p F P
0 g
s
0 .23 .75 r
.26644 .75409 m .26365 .74783 L p .28851 .77834 L F P
0 g
s
.979 .791 .377 r
.8304 .54547 m .83477 .56141 L .83247 .58326 L p F P
0 g
s
.941 .725 .253 r
.83477 .56141 m .8304 .54547 L .83072 .52439 L p F P
0 g
s
0 0 .323 r
.50917 .46862 m .50732 .47265 L .50723 .49784 L p F P
0 g
s
.371 .761 .988 r
.48612 .88196 m .50694 .88115 L p .47152 .87567 L F P
0 g
s
.371 .761 .988 r
.47152 .87567 m .48319 .8815 L .48612 .88196 L p F P
0 g
s
.46 0 0 r
.61359 .26981 m .61017 .26892 L .61138 .26884 L closepath p F P
0 g
s
0 0 0 r
.25897 .39711 m .26313 .39234 L .26596 .38616 L closepath p F P
0 g
s
.273 .707 .965 r
.47152 .87567 m .45599 .87502 L .48319 .8815 L closepath p F P
0 g
s
.212 .678 .942 r
.48319 .8815 m .45599 .87502 L .44897 .87451 L p F P
0 g
s
.19 .076 .484 r
.80652 .67246 m .8078 .69002 L p .81259 .67651 L F P
0 g
s
.933 .924 .552 r
.8115 .68739 m .8168 .66315 L .82248 .65513 L F
.81813 .65894 m .82248 .65513 L p .8168 .66315 L F P
0 g
s
.19 .076 .484 r
.81805 .65917 m .80652 .67246 L p .81259 .67651 L F P
0 g
s
.19 .076 .484 r
.80652 .67246 m .81807 .65915 L p .81723 .63152 L F P
0 g
s
0 0 .394 r
.81964 .62777 m .82108 .64655 L p .82335 .63277 L F P
0 g
s
.976 .885 .518 r
.82671 .61058 m .8281 .60596 L p .82604 .61797 L F P
0 g
s
.976 .885 .518 r
.82216 .64062 m .82671 .61058 L .82604 .61797 L F
0 0 .286 r
.82701 .57513 m .82474 .58568 L .82671 .61058 L p F P
0 g
s
.994 .874 .569 r
.82777 .60464 m .8281 .60596 L .82671 .61058 L p F P
0 g
s
0 0 .286 r
.82682 .609 m .82701 .57513 L .82671 .61058 L F
0 0 .394 r
.8264 .61263 m .81964 .62777 L p .82335 .63277 L F P
0 g
s
0 0 .394 r
.81964 .62777 m .82647 .61247 L p .82474 .58568 L F P
0 g
s
0 0 .394 r
.82647 .61247 m .82659 .61151 L .82474 .58568 L F
.82675 .61107 m .82474 .58568 L p .82664 .6121 L F P
0 g
s
.994 .874 .569 r
.8271 .60478 m .82746 .60471 L p .82698 .60656 L F P
0 g
s
.994 .874 .569 r
.82746 .60471 m .82777 .60464 L p .8272 .60676 L F P
0 g
s
0 0 .286 r
.82682 .609 m .8271 .60478 L .82701 .57513 L F
.8271 .60478 m .82722 .60269 L .82701 .57513 L F
.995 .834 .476 r
.82784 .59535 m .8284 .56865 L .82795 .58167 L F
.82777 .60464 m .82785 .59998 L .82784 .59535 L F
.82785 .59998 m .8284 .56865 L .82784 .59535 L F
0 0 .198 r
.82768 .56753 m .82701 .57513 L .82782 .58532 L p F P
0 g
s
.995 .834 .476 r
.83247 .58326 m .8284 .56865 L p .82777 .60464 L F P
0 g
s
.995 .834 .476 r
.8284 .56865 m .82806 .56741 L p .82803 .57077 L F P
0 g
s
.995 .834 .476 r
.82795 .58167 m .82827 .57259 L .82803 .57077 L F
.82827 .57259 m .8284 .56865 L .82803 .57077 L F
.82777 .60464 m .8285 .60405 L .83247 .58326 L p F P
0 g
s
0 0 .198 r
.82779 .57008 m .82768 .56753 L .82782 .58532 L F
0 0 .286 r
.82782 .58532 m .82701 .57513 L p .82722 .60269 L F P
0 g
s
0 0 .198 r
.82561 .54174 m .82495 .54938 L .82701 .57513 L p F P
0 g
s
0 0 .286 r
.82474 .58568 m .82701 .57513 L .82495 .54938 L p F P
0 g
s
0 0 .198 r
.82701 .57513 m .82768 .56753 L .82561 .54174 L p F P
0 g
s
.995 .834 .476 r
.82806 .56741 m .82779 .56883 L p .82781 .578 L F P
0 g
s
.995 .834 .476 r
.82795 .58167 m .82806 .56741 L .82722 .60269 L F
0 0 .198 r
.8291 .60124 m .82978 .59368 L .82779 .56883 L p F P
0 g
s
0 0 .198 r
.82779 .56883 m .82768 .56753 L p .82779 .57008 L F P
0 g
s
0 0 .198 r
.8291 .60124 m .82779 .56883 L .82779 .57008 L F
.995 .834 .476 r
.82368 .59019 m .82722 .60269 L p .82781 .578 L F P
0 g
s
.995 .834 .476 r
.82779 .56883 m .82368 .59019 L p .82781 .578 L F P
0 g
s
.995 .834 .476 r
.82722 .60269 m .82777 .60464 L p .82795 .58167 L F P
0 g
s
0 0 .286 r
.82814 .58929 m .82803 .58798 L p .82722 .60269 L F P
0 g
s
.997 .862 .554 r
.82746 .60471 m .8271 .60478 L p .82755 .60387 L F P
0 g
s
.997 .862 .554 r
.8271 .60478 m .81925 .60641 L p .82714 .604 L F P
0 g
s
.997 .862 .554 r
.82714 .604 m .82755 .60387 L .8271 .60478 L F
.82722 .60269 m .82755 .60387 L p .82714 .604 L F P
0 g
s
0 0 .286 r
.8271 .60478 m .82719 .60343 L .82722 .60269 L F
.82719 .60343 m .82814 .58929 L .82722 .60269 L F
0 0 .198 r
.82782 .58532 m .8291 .60124 L p .82779 .57008 L F P
0 g
s
.774 .572 .001 r
.82315 .52492 m .82561 .54174 L .82768 .56753 L p F P
0 g
s
.774 .572 .001 r
.82561 .54174 m .82315 .52492 L .82111 .49939 L p F P
0 g
s
.997 .787 .438 r
.82745 .56597 m .82156 .55197 L .82372 .532 L p F P
0 g
s
.999 .819 .52 r
.82156 .55197 m .82745 .56597 L p .82368 .59019 L F P
0 g
s
.774 .572 .001 r
.82768 .56753 m .82745 .56597 L p .82315 .52492 L F P
0 g
s
.774 .572 .001 r
.82768 .56753 m .82779 .56883 L p .82765 .56773 L F P
0 g
s
.774 .572 .001 r
.82745 .56597 m .82768 .56753 L p .82765 .56773 L F P
0 g
s
.999 .819 .52 r
.82745 .56597 m .82806 .56741 L .82779 .56883 L p F P
0 g
s
.999 .819 .52 r
.82779 .56883 m .82368 .59019 L p .82745 .56597 L F P
0 g
s
.774 .572 .001 r
.82745 .56597 m .8259 .55536 L p .82481 .54327 L F P
0 g
s
.995 .77 .481 r
.81537 .51486 m .82235 .52713 L p .82156 .55197 L F P
0 g
s
.995 .77 .481 r
.82156 .55197 m .82235 .52713 L .82329 .53049 L F
.943 .669 .206 r
.82315 .52492 m .82372 .532 L p .82235 .52713 L F P
0 g
s
.991 .733 .395 r
.82235 .52713 m .81537 .51486 L .8157 .4976 L p F P
0 g
s
.943 .669 .206 r
.81867 .51411 m .8203 .51805 L p .82235 .52713 L F P
0 g
s
.943 .669 .206 r
.8203 .51805 m .82315 .52492 L p .82235 .52713 L F P
0 g
s
.774 .572 .001 r
.82745 .56597 m .82552 .54936 L .82315 .52492 L F
.82552 .54936 m .82427 .53729 L .82315 .52492 L F
.82388 .53394 m .82315 .52492 L p .8259 .55536 L F P
0 g
s
.943 .669 .206 r
.82315 .52492 m .81846 .51362 L p .8146 .48356 L F P
0 g
s
.943 .669 .206 r
.81846 .51362 m .81661 .50916 L .8157 .4976 L p F P
0 g
s
.943 .669 .206 r
.8157 .4976 m .8146 .48356 L p .81846 .51362 L F P
0 g
s
.976 .672 .347 r
.80395 .46883 m .8146 .48356 L .8157 .4976 L p F P
0 g
s
.983 .715 .438 r
.81537 .51486 m .80703 .48568 L .81489 .49648 L F
.976 .672 .347 r
.81091 .49101 m .80395 .46883 L .8157 .4976 L F
.983 .715 .438 r
.8157 .4976 m .81537 .51486 L p .81489 .49648 L F P
0 g
s
.983 .715 .438 r
.81489 .49648 m .81478 .49226 L .8157 .4976 L F
.976 .672 .347 r
.80502 .48291 m .80395 .46883 L p .81091 .49101 L F P
0 g
s
.983 .715 .438 r
.81537 .51486 m .80464 .50022 L .80502 .48291 L p F P
0 g
s
.983 .715 .438 r
.80502 .48291 m .80511 .47893 L p .80575 .48118 L F P
0 g
s
.983 .715 .438 r
.81537 .51486 m .80502 .48291 L .80575 .48118 L F
.945 .637 .424 r
.7891 .45527 m .80395 .46883 L .80502 .48291 L p F P
0 g
s
.945 .637 .424 r
.8017 .48469 m .7891 .45527 L .80502 .48291 L F
.965 .693 .468 r
.80502 .48291 m .80464 .50022 L p .79962 .48581 L F P
0 g
s
.945 .637 .424 r
.79097 .481 m .7891 .45527 L p .8017 .48469 L F P
0 g
s
.965 .693 .468 r
.80464 .50022 m .79416 .48873 L p .79962 .48581 L F P
0 g
s
.945 .637 .424 r
.8059 .4945 m .79752 .48693 L p .8017 .48469 L F P
0 g
s
.945 .637 .424 r
.79752 .48693 m .79097 .481 L p .8017 .48469 L F P
0 g
s
.98 .745 .511 r
.80464 .50022 m .81537 .51486 L .81292 .53696 L p F P
0 g
s
.98 .745 .511 r
.81292 .53696 m .80213 .52239 L .80464 .50022 L p F P
0 g
s
.959 .718 .53 r
.80464 .50022 m .80213 .52239 L p .79238 .48834 L F P
0 g
s
.959 .718 .53 r
.79416 .48873 m .80464 .50022 L p .79238 .48834 L F P
0 g
s
.945 .637 .424 r
.8059 .4945 m .80788 .52053 L p .79429 .48876 L F P
0 g
s
.945 .637 .424 r
.79097 .481 m .80125 .4903 L p .79429 .48876 L F P
0 g
s
.945 .637 .424 r
.80125 .4903 m .8059 .4945 L p .79429 .48876 L F P
0 g
s
.959 .718 .53 r
.80213 .52239 m .78913 .50831 L .79148 .48814 L p F P
0 g
s
.959 .718 .53 r
.80213 .52239 m .79148 .48814 L .79238 .48834 L F
.945 .637 .424 r
.80788 .52053 m .79285 .50709 L .79148 .48814 L p F P
0 g
s
.945 .637 .424 r
.79148 .48814 m .79097 .481 L p .79429 .48876 L F P
0 g
s
.945 .637 .424 r
.80788 .52053 m .79148 .48814 L .79429 .48876 L F
.959 .718 .53 r
.79148 .48814 m .79172 .48606 L p .79238 .48834 L F P
0 g
s
.959 .718 .53 r
.79172 .48606 m .79416 .48873 L p .79238 .48834 L F P
0 g
s
.965 .693 .468 r
.79172 .48606 m .79226 .46472 L p .79962 .48581 L F P
0 g
s
.965 .693 .468 r
.79416 .48873 m .79172 .48606 L p .79962 .48581 L F P
0 g
s
.965 .693 .468 r
.79226 .46472 m .80511 .47893 L .80502 .48291 L p F P
0 g
s
.965 .693 .468 r
.79962 .48581 m .79226 .46472 L .80502 .48291 L F
.945 .637 .424 r
.80299 .48771 m .8017 .48469 L .80502 .48291 L F
.80502 .48291 m .8059 .4945 L p .80299 .48771 L F P
0 g
s
.976 .672 .347 r
.81661 .50916 m .8059 .4945 L .80502 .48291 L p F P
0 g
s
.976 .672 .347 r
.81661 .50916 m .80502 .48291 L .81091 .49101 L F
.8157 .4976 m .81661 .50916 L p .81091 .49101 L F P
0 g
s
.983 .715 .438 r
.80511 .47893 m .81478 .49226 L p .81489 .49648 L F P
0 g
s
.983 .715 .438 r
.80703 .48568 m .80511 .47893 L .81489 .49648 L F
.81478 .49226 m .81578 .49363 L .8157 .4976 L p F P
0 g
s
.991 .733 .395 r
.82394 .52995 m .82235 .52713 L p .81578 .49363 L F P
0 g
s
.991 .733 .395 r
.8157 .4976 m .81578 .49363 L p .82235 .52713 L F P
0 g
s
.995 .77 .481 r
.82372 .532 m .82156 .55197 L p .82341 .52901 L F P
0 g
s
.943 .669 .206 r
.81661 .50916 m .81867 .51411 L p .82523 .5508 L F P
0 g
s
.943 .669 .206 r
.82372 .532 m .82523 .5508 L p .81867 .51411 L F P
0 g
s
.995 .77 .481 r
.82235 .52713 m .82341 .52901 L p .82329 .53049 L F P
0 g
s
.995 .77 .481 r
.82341 .52901 m .82394 .52995 L .82372 .532 L p F P
0 g
s
.774 .572 .001 r
.82552 .54936 m .82481 .54327 L .82427 .53729 L F
.8259 .55536 m .82523 .5508 L .82388 .53394 L p F P
0 g
s
.991 .733 .395 r
.8243 .50879 m .82394 .52995 L p .82318 .52655 L F P
0 g
s
.943 .669 .206 r
.8146 .48356 m .82111 .49939 L .82315 .52492 L p F P
0 g
s
.991 .733 .395 r
.81578 .49363 m .82094 .50282 L p .82318 .52655 L F P
0 g
s
.991 .733 .395 r
.82094 .50282 m .8243 .50879 L p .82318 .52655 L F P
0 g
s
.997 .787 .438 r
.82806 .56741 m .82745 .56597 L p .82394 .52995 L F P
0 g
s
.997 .787 .438 r
.82372 .532 m .82394 .52995 L p .82745 .56597 L F P
0 g
s
.774 .572 .001 r
.82722 .56441 m .82745 .56597 L p .82765 .56773 L F P
0 g
s
.774 .572 .001 r
.82523 .5508 m .82722 .56441 L p .82978 .59368 L F P
0 g
s
.774 .572 .001 r
.82779 .56883 m .82978 .59368 L p .82722 .56441 L F P
0 g
s
0 0 .286 r
.82803 .58798 m .82782 .58532 L p .82722 .60269 L F P
0 g
s
.997 .862 .554 r
.81925 .60641 m .82368 .59019 L .82722 .60269 L p F P
0 g
s
.997 .862 .554 r
.81925 .60641 m .82722 .60269 L .82714 .604 L F
.994 .874 .569 r
.82098 .6297 m .82746 .60471 L .8272 .60676 L F
.997 .862 .554 r
.82755 .60387 m .82777 .60464 L .82746 .60471 L p F P
0 g
s
.994 .874 .569 r
.82689 .60789 m .82777 .60464 L .82671 .61058 L F
.992 .846 .485 r
.8281 .60596 m .82777 .60464 L .8285 .60405 L closepath p F P
0 g
s
0 0 .286 r
.8268 .61173 m .8291 .60124 L .82814 .58929 L p F P
0 g
s
0 0 .286 r
.8268 .61173 m .82814 .58929 L .82682 .609 L F
.994 .874 .569 r
.81925 .60641 m .8271 .60478 L p .82098 .6297 L F P
0 g
s
.994 .874 .569 r
.82098 .6297 m .8271 .60478 L .82698 .60656 L F
0 0 .394 r
.82647 .61247 m .82664 .6121 L p .82659 .61151 L F P
0 g
s
0 0 .394 r
.82664 .6121 m .8268 .61173 L .82675 .61107 L p F P
0 g
s
.994 .874 .569 r
.82671 .61058 m .82098 .6297 L p .82689 .60789 L F P
0 g
s
0 0 .286 r
.82681 .60945 m .82682 .609 L .82671 .61058 L F
.82671 .61058 m .8268 .61173 L p .82681 .60945 L F P
0 g
s
0 0 .394 r
.8268 .61173 m .8264 .61263 L p .82335 .63277 L F P
0 g
s
.976 .885 .518 r
.82273 .64594 m .82216 .64062 L p .8281 .60596 L F P
0 g
s
0 0 .394 r
.82257 .63833 m .8268 .61173 L .82108 .64655 L F
.976 .885 .518 r
.82216 .64062 m .82098 .6297 L .82671 .61058 L p F P
0 g
s
.069 0 .449 r
.81964 .62777 m .81723 .63152 L .81906 .65559 L p F P
0 g
s
.98 .91 .597 r
.81906 .65559 m .82273 .64594 L p .82046 .64933 L F P
0 g
s
.069 0 .449 r
.81927 .65475 m .81927 .65464 L .81906 .65559 L F
.81927 .65464 m .81964 .62777 L .81906 .65559 L F
.19 .076 .484 r
.81906 .65559 m .81723 .63152 L p .81807 .65915 L F P
0 g
s
.98 .91 .597 r
.81241 .66138 m .81763 .65938 L .81906 .65559 L p F P
0 g
s
.98 .91 .597 r
.82273 .64594 m .82216 .64062 L p .82062 .64909 L F P
0 g
s
.95 .913 .542 r
.82273 .64594 m .82248 .65513 L .8188 .65835 L p F P
0 g
s
.95 .913 .542 r
.81941 .6555 m .82273 .64594 L .8188 .65835 L F
.81846 .65799 m .82273 .64594 L .81825 .65883 L F
.81906 .65559 m .82273 .64594 L p .81813 .65894 L F P
0 g
s
.069 0 .449 r
.81923 .65781 m .82166 .65409 L .82108 .64655 L p F P
0 g
s
.069 0 .449 r
.82108 .64655 m .81964 .62777 L p .81927 .65464 L F P
0 g
s
.98 .91 .597 r
.82046 .64933 m .82062 .64909 L .82063 .64856 L F
.82216 .64062 m .82098 .6297 L p .82062 .64909 L F P
0 g
s
.069 0 .449 r
.81923 .65781 m .82108 .64655 L .81927 .65464 L F
.98 .91 .597 r
.81241 .66138 m .82046 .64933 L .82098 .6297 L F
.82046 .64933 m .82063 .64856 L .82098 .6297 L F
.81241 .66138 m .81906 .65559 L .82046 .64933 L F
0 0 .394 r
.82108 .64655 m .82114 .64731 L p .82257 .63833 L F P
0 g
s
0 0 .394 r
.82114 .64731 m .82166 .65409 L p .82429 .63244 L F P
0 g
s
0 0 .394 r
.82429 .63244 m .8268 .61173 L .82114 .64731 L F
.95 .913 .542 r
.8188 .65835 m .81825 .65883 L p .81941 .6555 L F P
0 g
s
.95 .913 .542 r
.81825 .65883 m .81813 .65894 L p .81846 .65799 L F P
0 g
s
.069 0 .449 r
.81906 .65559 m .81923 .65781 L p .81927 .65475 L F P
0 g
s
.19 .076 .484 r
.81807 .65915 m .81923 .65781 L .81906 .65559 L p F P
0 g
s
.95 .913 .542 r
.81813 .65894 m .81763 .65938 L .81906 .65559 L p F P
0 g
s
.933 .924 .552 r
.81294 .67056 m .81763 .65938 L p .8168 .66315 L F P
0 g
s
.933 .924 .552 r
.8115 .68739 m .81237 .67722 L p .8168 .66315 L F P
0 g
s
.19 .076 .484 r
.81904 .65856 m .81923 .65781 L .8078 .69002 L F
.933 .924 .552 r
.81237 .67722 m .81294 .67056 L p .8168 .66315 L F P
0 g
s
.944 .949 .634 r
.8115 .68739 m .81223 .6788 L p .80655 .69352 L F P
0 g
s
.944 .949 .634 r
.81223 .6788 m .81237 .67722 L p .8078 .69002 L F P
0 g
s
.944 .949 .634 r
.80655 .69352 m .81223 .6788 L .8078 .69002 L F
.302 .156 .51 r
.79841 .70758 m .80178 .70471 L p .80652 .67246 L F P
0 g
s
.302 .156 .51 r
.80178 .70471 m .8022 .70376 L .80652 .67246 L F
.925 .961 .649 r
.80386 .69998 m .80566 .69908 L .79869 .7117 L p F P
0 g
s
.302 .156 .51 r
.8078 .69002 m .80652 .67246 L p .8021 .70443 L F P
0 g
s
.302 .156 .51 r
.80846 .69902 m .79841 .70758 L .80029 .73444 L p F P
0 g
s
.925 .961 .649 r
.79787 .71319 m .7996 .70213 L .80386 .69998 L p F P
0 g
s
.925 .961 .649 r
.79869 .7117 m .79787 .71319 L p .80386 .69998 L F P
0 g
s
.302 .156 .51 r
.80178 .70471 m .8021 .70443 L p .8022 .70376 L F P
0 g
s
.944 .949 .634 r
.7996 .70213 m .80655 .69352 L .81294 .67056 L F
.81237 .67722 m .81294 .67056 L p .80655 .69352 L F P
0 g
s
.944 .949 .634 r
.7996 .70213 m .80566 .69908 L .8115 .68739 L p F P
0 g
s
.302 .156 .51 r
.8021 .70443 m .80846 .69902 L .8078 .69002 L p F P
0 g
s
.19 .076 .484 r
.80846 .69902 m .81904 .65856 L .81237 .67722 L F
.8078 .69002 m .8079 .69142 L p .81237 .67722 L F P
0 g
s
.19 .076 .484 r
.8079 .69142 m .80846 .69902 L p .81237 .67722 L F P
0 g
s
.19 .076 .484 r
.81923 .65781 m .81805 .65917 L p .81259 .67651 L F P
0 g
s
.933 .924 .552 r
.81763 .65938 m .81813 .65894 L p .8168 .66315 L F P
0 g
s
.267 0 0 r
.54321 .25853 m .53555 .25819 L .51839 .25581 L p F P
0 g
s
.326 0 0 r
.53555 .25819 m .5132 .25803 L .51839 .25581 L closepath p F P
0 g
s
.236 0 0 r
.51839 .25581 m .5132 .25803 L .48481 .25958 L p F P
0 g
s
.412 .84 .955 r
.56927 .87922 m .56508 .8783 L .54212 .88289 L p F P
0 g
s
.482 .847 .99 r
.56508 .8783 m .54212 .88289 L .52985 .8784 L p F P
0 g
s
.395 .805 .979 r
.54212 .88289 m .52985 .8784 L .50694 .88115 L p F P
0 g
s
.081 0 0 r
.34784 .31302 m .35612 .30233 L .3772 .29241 L p F P
0 g
s
0 0 0 r
.37951 .29013 m .3772 .29241 L .35612 .30233 L p F P
0 g
s
0 0 0 r
.35612 .30233 m .34784 .31302 L .32802 .32432 L p F P
0 g
s
0 0 .412 r
.2105 .60226 m .20768 .59146 L .20833 .58714 L closepath p F P
0 g
s
.526 0 0 r
.63572 .28174 m .6345 .28135 L .61359 .26981 L p F P
0 g
s
.561 0 0 r
.61017 .26892 m .61359 .26981 L .6345 .28135 L p F P
0 g
s
.62992 .27519 m
.6392 .27936 L
s
.78 .625 .063 r
.50206 .58413 m .50158 .57659 L .50171 .55084 L p F P
0 g
s
0 0 .048 r
.50238 .54015 m .50171 .55084 L .50158 .57659 L p F P
0 g
s
.788 .525 .538 r
.61435 .82488 m .58937 .81915 L .58891 .79177 L p F P
0 g
s
.822 .553 .532 r
.57413 .78694 m .58891 .79177 L .58937 .81915 L p F P
0 g
s
.926 .871 .443 r
.82978 .62232 m .82273 .64594 L .82248 .65513 L p F P
0 g
s
.031 .363 .834 r
.31965 .80702 m .30842 .80026 L .29488 .78292 L p F P
0 g
s
.5 0 0 r
.59998 .27172 m .57893 .26242 L .61017 .26892 L closepath p F P
0 g
s
.561 0 0 r
.59998 .27172 m .61017 .26892 L p .6345 .28135 L F P
0 g
s
.384 0 0 r
.61017 .26892 m .57893 .26242 L .57644 .26157 L p F P
0 g
s
.132 0 0 r
.48481 .25958 m .47358 .26096 L .46043 .26185 L p F P
0 g
s
.201 0 0 r
.47358 .26096 m .45812 .26321 L .46043 .26185 L closepath p F P
0 g
s
.1 0 0 r
.46043 .26185 m .45812 .26321 L .43299 .26864 L p F P
0 g
s
.976 .885 .518 r
.8281 .60596 m .82978 .62232 L .82273 .64594 L p F P
0 g
s
.955 .841 .415 r
.82978 .62232 m .8281 .60596 L .8285 .60405 L p F P
0 g
s
.216 0 0 r
.43299 .26864 m .45812 .26321 L .44874 .27111 L p F P
0 g
s
.216 0 0 r
.42441 .27571 m .43299 .26864 L p .44874 .27111 L F P
0 g
s
.112 0 0 r
.43299 .26864 m .42441 .27571 L .40192 .28159 L p F P
0 g
s
0 0 .047 r
.26313 .39234 m .25897 .39711 L .24657 .42091 L p F P
0 g
s
0 0 0 r
.24378 .42445 m .24657 .42091 L .25897 .39711 L p F P
0 g
s
.457 .247 .505 r
.55462 .37317 m .55439 .34878 L .57539 .33787 L p F P
0 g
s
.369 .181 .489 r
.55439 .34878 m .55462 .37317 L .53572 .38646 L p F P
0 g
s
0 .175 .709 r
.26365 .74783 m .26086 .74494 L .24758 .7198 L p F P
0 g
s
.835 .543 .496 r
.75359 .33843 m .73915 .33244 L .73768 .30832 L p F P
0 g
s
.797 .512 .507 r
.71316 .30105 m .73768 .30832 L .73915 .33244 L p F P
0 g
s
.72845 .80378 m
.72969 .80265 L
s
0 0 .323 r
.50723 .49784 m .50909 .49383 L .50917 .46862 L p F P
0 g
s
.036 0 .392 r
.51977 .45249 m .50917 .46862 L .50909 .49383 L p F P
0 g
s
.036 0 .392 r
.50917 .46862 m .51977 .45249 L .51978 .42754 L p F P
0 g
s
.981 .739 .334 r
.8243 .50879 m .83072 .52439 L .8304 .54547 L p F P
0 g
s
.943 .668 .205 r
.83072 .52439 m .8243 .50879 L .82267 .4885 L p F P
0 g
s
.297 .692 .976 r
.45599 .87502 m .44087 .86955 L .44897 .87451 L closepath p F P
0 g
s
0 0 .015 r
.27879 .37722 m .28516 .36319 L .30221 .3493 L p F P
0 g
s
0 0 0 r
.28516 .36319 m .27879 .37722 L .26313 .39234 L p F P
0 g
s
0 0 .205 r
.23813 .44339 m .22751 .45972 L .22449 .47836 L p F P
0 g
s
0 0 .062 r
.24106 .43503 m .24378 .42445 L p .22751 .45972 L F P
0 g
s
0 0 .062 r
.22751 .45972 m .23813 .44339 L .24106 .43503 L p F P
0 g
s
0 0 .144 r
.21833 .48993 m .22449 .47836 L .22751 .45972 L p F P
0 g
s
.195 .049 .444 r
.52864 .4178 m .51978 .42754 L .51977 .45249 L p F P
0 g
s
.054 .464 .883 r
.34319 .82667 m .35945 .83327 L .37286 .84548 L p F P
0 g
s
.13 .514 .912 r
.37286 .84548 m .37832 .84735 L .36492 .83513 L p F P
0 g
s
.13 .514 .912 r
.36492 .83513 m .35945 .83327 L .37286 .84548 L p F P
0 g
s
.076 0 0 r
.3772 .29241 m .37951 .29013 L .40192 .28159 L p F P
0 g
s
.64493 .28194 m
.65002 .28495 L
s
.65002 .28495 m
.65162 .2859 L
s
.67301 .29855 m
.67322 .29867 L
s
.66968 .29658 m
.67301 .29855 L
s
.66605 .29443 m
.66968 .29658 L
s
.369 .181 .489 r
.53582 .41113 m .53572 .38646 L .55462 .37317 L p F P
0 g
s
.265 .102 .464 r
.52864 .4178 m .53582 .41113 L .53572 .38646 L p F P
0 g
s
0 0 .364 r
.20833 .58714 m .21222 .57104 L .20904 .55208 L p F P
0 g
s
0 0 .47 r
.20833 .58714 m .21222 .57104 L p .21284 .60991 L F P
0 g
s
0 0 .47 r
.21284 .60991 m .2105 .60226 L .20833 .58714 L p F P
0 g
s
.588 .348 .521 r
.59857 .32946 m .59805 .30533 L .62319 .29945 L p F P
0 g
s
.529 .302 .515 r
.59805 .30533 m .59857 .32946 L .57539 .33787 L p F P
0 g
s
0 .126 .671 r
.24758 .7198 m .24412 .71567 L .24298 .70988 L closepath p F P
0 g
s
0 .026 .596 r
.23455 .68977 m .22925 .68199 L p .24412 .71567 L F P
0 g
s
0 .026 .596 r
.24412 .71567 m .24298 .70988 L .23455 .68977 L p F P
0 g
s
0 .23 .75 r
.26365 .74783 m .28134 .76289 L p .28851 .77834 L F P
0 g
s
.001 .258 .763 r
.26365 .74783 m .28134 .76289 L .26791 .73911 L p F P
0 g
s
.001 .258 .763 r
.26791 .73911 m .25933 .73186 L .26365 .74783 L p F P
0 g
s
0 .175 .709 r
.24758 .7198 m .25933 .73186 L .26365 .74783 L p F P
0 g
s
.79231 .72406 m
.79492 .71886 L
s
.79736 .71399 m
.79792 .71288 L
s
.989 .723 .376 r
.50674 .65264 m .51541 .66723 L .51537 .69382 L p F P
0 g
s
.989 .723 .376 r
.51541 .66723 m .50674 .65264 L .50684 .62632 L p F P
0 g
s
.435 0 0 r
.57893 .26242 m .57534 .26185 L .57644 .26157 L closepath p F P
0 g
s
.358 0 0 r
.57644 .26157 m .57534 .26185 L .54321 .25853 L p F P
0 g
s
0 0 .222 r
.21301 .51854 m .21669 .51021 L .21833 .48993 L p F P
0 g
s
0 0 .273 r
.22449 .47836 m .21833 .48993 L .21669 .51021 L p F P
0 g
s
.498 .299 .54 r
.75345 .81481 m .75188 .7874 L .77383 .77849 L p F P
0 g
s
.557 .343 .545 r
.75188 .7874 m .75345 .81481 L .72971 .82151 L p F P
0 g
s
.942 .715 .244 r
.50193 .61019 m .50684 .62632 L .50674 .65264 L p F P
0 g
s
.942 .715 .244 r
.50684 .62632 m .50193 .61019 L .50206 .58413 L p F P
0 g
s
.139 .479 .898 r
.35945 .83327 m .34319 .82667 L .32968 .81212 L p F P
0 g
s
0 0 .103 r
.25787 .408 m .26313 .39234 L .27879 .37722 L p F P
0 g
s
0 0 .047 r
.24657 .42091 m .25787 .408 L .26313 .39234 L p F P
0 g
s
0 0 .124 r
.24106 .43503 m .24657 .42091 L .24378 .42445 L closepath p F P
0 g
s
.822 .553 .532 r
.58937 .81915 m .57449 .81436 L .57413 .78694 L p F P
0 g
s
.842 .569 .527 r
.56405 .78303 m .57413 .78694 L .57449 .81436 L p F P
0 g
s
.307 0 0 r
.44874 .27111 m .45812 .26321 L .47358 .26096 L p F P
0 g
s
.187 .626 .944 r
.44087 .86955 m .4326 .86601 L .41363 .86296 L p F P
0 g
s
.266 .635 .963 r
.4326 .86601 m .41363 .86296 L .40041 .85288 L p F P
0 g
s
.159 .57 .932 r
.37832 .84735 m .40041 .85288 L .41363 .86296 L p F P
0 g
s
.81547 .47212 m
.81747 .47068 L
s
0 .07 .621 r
.23455 .68977 m .22925 .68199 L .22871 .67394 L closepath p F P
0 g
s
0 0 .54 r
.22198 .65291 m .21872 .64679 L p .22925 .68199 L F P
0 g
s
0 0 .54 r
.22925 .68199 m .22871 .67394 L .22198 .65291 L p F P
0 g
s
.6755 .83965 m
.67639 .83916 L
s
.973 .679 .285 r
.81418 .47329 m .82267 .4885 L .8243 .50879 L p F P
0 g
s
.857 .562 .487 r
.75359 .33843 m .76329 .34324 L .76493 .36765 L p F P
0 g
s
.9 .597 .465 r
.78367 .38016 m .76493 .36765 L .76329 .34324 L p F P
0 g
s
.002 .306 .799 r
.29488 .78292 m .28851 .77834 L .28247 .76463 L closepath p F P
0 g
s
0 .23 .75 r
.28134 .76289 m .28247 .76463 L .28851 .77834 L p F P
0 g
s
.343 .711 .984 r
.45599 .87502 m .47152 .87567 L p .43598 .86643 L F P
0 g
s
.343 .711 .984 r
.43598 .86643 m .44087 .86955 L .45599 .87502 L p F P
0 g
s
.529 0 0 r
.57893 .26242 m .59998 .27172 L p .56499 .26693 L F P
0 g
s
.529 0 0 r
.56499 .26693 m .57534 .26185 L .57893 .26242 L p F P
0 g
s
.606 .381 .548 r
.70552 .85383 m .70427 .82613 L .72971 .82151 L p F P
0 g
s
.649 .413 .548 r
.70427 .82613 m .70552 .85383 L .67812 .85636 L p F P
0 g
s
.67639 .83916 m
.68005 .83716 L
s
0 0 .401 r
.21295 .54059 m .20904 .55208 L .21222 .57104 L p F P
0 g
s
0 0 .289 r
.20904 .55208 m .21295 .54059 L .21301 .51854 L p F P
0 g
s
.88 .603 .514 r
.56405 .78303 m .54414 .77267 L .54398 .74552 L p F P
0 g
s
.923 .643 .492 r
.52783 .73381 m .54398 .74552 L .54414 .77267 L p F P
0 g
s
.233 .577 .943 r
.40041 .85288 m .37832 .84735 L .36492 .83513 L p F P
0 g
s
.466 0 0 r
.54321 .25853 m .57534 .26185 L .56499 .26693 L p F P
0 g
s
.926 .973 .713 r
.79787 .71319 m .7996 .70213 L p .78141 .73595 L F P
0 g
s
.926 .973 .713 r
.78141 .73595 m .78384 .73532 L .79787 .71319 L p F P
0 g
s
.78 .625 .063 r
.50158 .57659 m .50206 .58413 L .50193 .61019 L p F P
0 g
s
.761 .503 .542 r
.61435 .82488 m .62063 .82589 L .62131 .85359 L p F P
0 g
s
.257 0 0 r
.48302 .26075 m .47358 .26096 L .48481 .25958 L closepath p F P
0 g
s
.307 0 0 r
.47358 .26096 m .48302 .26075 L p .44874 .27111 L F P
0 g
s
.457 .803 .998 r
.52985 .8784 m .50694 .88115 L .49434 .87476 L p F P
0 g
s
.371 .761 .988 r
.50694 .88115 m .49434 .87476 L .47152 .87567 L p F P
0 g
s
0 0 .438 r
.21238 .61339 m .2105 .60226 L .21284 .60991 L closepath p F P
0 g
s
.482 .847 .99 r
.52985 .8784 m .55296 .87375 L .56508 .8783 L p F P
0 g
s
.797 .512 .507 r
.73915 .33244 m .71446 .32519 L .71316 .30105 L p F P
0 g
s
.766 .488 .513 r
.70692 .29976 m .71316 .30105 L .71446 .32519 L p F P
0 g
s
.979 .791 .377 r
.83247 .58326 m .82806 .56741 L .8304 .54547 L p F P
0 g
s
.792 .998 .854 r
.71561 .80939 m .72617 .80024 L .72043 .80904 L closepath p F P
0 g
s
.787 .998 .815 r
.73861 .78864 m .72617 .80024 L .72043 .80904 L p F P
0 g
s
.745 .992 .866 r
.69249 .82713 m .71561 .80939 L .72043 .80904 L p F P
0 g
s
0 0 .348 r
.21669 .51021 m .21301 .51854 L .21295 .54059 L p F P
0 g
s
.761 .503 .542 r
.62131 .85359 m .61498 .85259 L .61435 .82488 L p F P
0 g
s
.788 .525 .538 r
.58937 .81915 m .61435 .82488 L .61498 .85259 L p F P
0 g
s
.182 0 0 r
.36908 .30305 m .3772 .29241 L .39965 .28385 L p F P
0 g
s
.076 0 0 r
.40192 .28159 m .39965 .28385 L .3772 .29241 L p F P
0 g
s
.081 0 0 r
.3772 .29241 m .36908 .30305 L .34784 .31302 L p F P
0 g
s
0 .205 .719 r
.25933 .73186 m .24758 .7198 L .24298 .70988 L p F P
0 g
s
.082 0 0 r
.34784 .31302 m .32802 .32432 L .32071 .33667 L p F P
0 g
s
0 0 0 r
.32802 .32432 m .32071 .33667 L .30221 .3493 L p F P
0 g
s
.349 0 0 r
.48302 .26075 m .48481 .25958 L .5132 .25803 L p F P
0 g
s
0 0 .182 r
.24657 .42091 m .25787 .408 L p .23952 .44152 L F P
0 g
s
0 0 .182 r
.23952 .44152 m .24106 .43503 L .24657 .42091 L p F P
0 g
s
0 .012 .565 r
.22198 .65291 m .21872 .64679 L .21895 .64215 L closepath p F P
0 g
s
0 0 .478 r
.21872 .64679 m .21895 .64215 L .21238 .61339 L p F P
0 g
s
.766 .488 .513 r
.71446 .32519 m .70818 .3239 L .70692 .29976 L p F P
0 g
s
.736 .464 .517 r
.68022 .29642 m .70692 .29976 L .70818 .3239 L p F P
0 g
s
.945 .637 .424 r
.80012 .41853 m .78545 .40485 L .78367 .38016 L p F P
0 g
s
.9 .597 .465 r
.76493 .36765 m .78367 .38016 L .78545 .40485 L p F P
0 g
s
.637 .387 .522 r
.62389 .3236 m .62319 .29945 L .6504 .29618 L p F P
0 g
s
.588 .348 .521 r
.62319 .29945 m .62389 .3236 L .59857 .32946 L p F P
0 g
s
.466 0 0 r
.54131 .25942 m .54321 .25853 L p .56499 .26693 L F P
0 g
s
.389 0 0 r
.54131 .25942 m .53555 .25819 L .54321 .25853 L closepath p F P
0 g
s
.842 .569 .527 r
.57449 .81436 m .56435 .81048 L .56405 .78303 L p F P
0 g
s
.88 .603 .514 r
.54414 .77267 m .56405 .78303 L .56435 .81048 L p F P
0 g
s
0 0 .537 r
.21284 .60991 m .21238 .61339 L .21895 .64215 L p F P
0 g
s
.427 0 0 r
.53555 .25819 m .54131 .25942 L .53348 .26486 L p F P
0 g
s
.427 0 0 r
.5132 .25803 m .53555 .25819 L p .53348 .26486 L F P
0 g
s
.107 .421 .866 r
.31965 .80702 m .32968 .81212 L .31612 .79518 L p F P
0 g
s
.107 .421 .866 r
.31612 .79518 m .31142 .79282 L .31965 .80702 L p F P
0 g
s
.031 .363 .834 r
.29488 .78292 m .31142 .79282 L .31965 .80702 L p F P
0 g
s
.427 0 0 r
.50585 .26297 m .5132 .25803 L p .53348 .26486 L F P
0 g
s
.349 0 0 r
.5132 .25803 m .50585 .26297 L .48302 .26075 L p F P
0 g
s
0 .205 .719 r
.24298 .70988 m .24166 .69879 L p .25933 .73186 L F P
0 g
s
0 .115 .658 r
.24298 .70988 m .23455 .68977 L .24166 .69879 L closepath p F P
0 g
s
.857 .562 .487 r
.76493 .36765 m .75517 .36286 L .75359 .33843 L p F P
0 g
s
.835 .543 .496 r
.73915 .33244 m .75359 .33843 L .75517 .36286 L p F P
0 g
s
0 0 .048 r
.50158 .57659 m .50226 .56595 L .50238 .54015 L p F P
0 g
s
0 0 .221 r
.50713 .52338 m .50238 .54015 L .50226 .56595 L p F P
0 g
s
0 0 .221 r
.50238 .54015 m .50713 .52338 L .50723 .49784 L p F P
0 g
s
.177 0 0 r
.39965 .28385 m .40192 .28159 L .42441 .27571 L p F P
0 g
s
.529 .302 .515 r
.57576 .3623 m .57539 .33787 L .59857 .32946 L p F P
0 g
s
.457 .247 .505 r
.57539 .33787 m .57576 .3623 L .55462 .37317 L p F P
0 g
s
.976 .672 .347 r
.81261 .4583 m .80202 .44351 L .80012 .41853 L p F P
0 g
s
.945 .637 .424 r
.78545 .40485 m .80012 .41853 L .80202 .44351 L p F P
0 g
s
.904 .984 .732 r
.78036 .74027 m .78141 .73595 L .78384 .73532 L closepath p F P
0 g
s
.195 .049 .444 r
.51977 .45249 m .52869 .44278 L .52864 .4178 L p F P
0 g
s
.265 .102 .464 r
.53582 .41113 m .52864 .4178 L .52869 .44278 L p F P
0 g
s
.82464 .62959 m
.82489 .62844 L
s
.11 .377 .837 r
.31142 .79282 m .29488 .78292 L .28247 .76463 L p F P
0 g
s
.557 .343 .545 r
.73113 .84925 m .72971 .82151 L .75345 .81481 L p F P
0 g
s
.606 .381 .548 r
.72971 .82151 m .73113 .84925 L .70552 .85383 L p F P
0 g
s
.678 .419 .522 r
.66382 .32006 m .65128 .32034 L .6504 .29618 L p F P
0 g
s
.637 .387 .522 r
.6504 .29618 m .65128 .32034 L .62389 .3236 L p F P
0 g
s
0 0 .323 r
.50909 .49383 m .50723 .49784 L .50713 .52338 L p F P
0 g
s
.899 .985 .781 r
.78036 .74027 m .78141 .73595 L p .75888 .76463 L F P
0 g
s
.899 .985 .781 r
.75888 .76463 m .7614 .76441 L .78036 .74027 L p F P
0 g
s
.248 .657 .963 r
.43598 .86643 m .4326 .86601 L .44087 .86955 L closepath p F P
0 g
s
.353 .193 .52 r
.80029 .73444 m .79234 .74018 L .79419 .76737 L p F P
0 g
s
.431 .249 .532 r
.79234 .74018 m .79419 .76737 L .77383 .77849 L p F P
0 g
s
.742 .968 .933 r
.67946 .83586 m .66932 .84228 L .65813 .84013 L p F P
0 g
s
.692 .959 .946 r
.63476 .85287 m .65813 .84013 L .66932 .84228 L p F P
0 g
s
.385 0 0 r
.4755 .26723 m .48302 .26075 L .50585 .26297 L p F P
0 g
s
.307 0 0 r
.48302 .26075 m .4755 .26723 L .44874 .27111 L p F P
0 g
s
0 .149 .669 r
.24166 .69879 m .23455 .68977 L .22871 .67394 L p F P
0 g
s
.997 .787 .438 r
.82394 .52995 m .8304 .54547 L .82806 .56741 L p F P
0 g
s
.981 .739 .334 r
.8304 .54547 m .82394 .52995 L .8243 .50879 L p F P
0 g
s
.19 .076 .484 r
.82127 .68446 m .80846 .69902 L .81042 .72594 L p F P
0 g
s
.302 .156 .51 r
.80029 .73444 m .81042 .72594 L .80846 .69902 L p F P
0 g
s
.19 .076 .484 r
.80846 .69902 m .82127 .68446 L .81923 .65781 L p F P
0 g
s
0 .033 .553 r
.21772 .59004 m .21284 .60991 L .22093 .62764 L p F P
0 g
s
0 0 .47 r
.21741 .58785 m .21772 .59004 L .21284 .60991 L p F P
0 g
s
0 0 .47 r
.21222 .57104 m .21741 .58785 L p .21284 .60991 L F P
0 g
s
0 0 .537 r
.21895 .64215 m .22093 .62764 L .21284 .60991 L p F P
0 g
s
0 .092 .613 r
.21895 .64215 m .22093 .62764 L p .22886 .66408 L F P
0 g
s
0 .092 .613 r
.22886 .66408 m .22198 .65291 L .21895 .64215 L p F P
0 g
s
.466 0 0 r
.56499 .26693 m .56363 .26679 L .54131 .25942 L p F P
0 g
s
.492 0 0 r
.56363 .26679 m .53348 .26486 L .54131 .25942 L closepath p F P
0 g
s
.428 .753 .995 r
.49434 .87476 m .47152 .87567 L .45863 .86734 L p F P
0 g
s
.343 .711 .984 r
.47152 .87567 m .45863 .86734 L .43598 .86643 L p F P
0 g
s
.742 .968 .933 r
.68759 .82656 m .67946 .83586 L p .65813 .84013 L F P
0 g
s
.743 .979 .917 r
.67946 .83586 m .68759 .82656 L .69249 .82713 L closepath p F P
0 g
s
.069 0 .449 r
.82166 .65409 m .81923 .65781 L .82127 .68446 L p F P
0 g
s
.972 .924 .613 r
.81294 .67056 m .81241 .66138 L .81763 .65938 L closepath p F P
0 g
s
0 .053 .601 r
.22871 .67394 m .22198 .65291 L .22886 .66408 L closepath p F P
0 g
s
0 .149 .669 r
.22871 .67394 m .22886 .66408 L p .24166 .69879 L F P
0 g
s
.68011 .30381 m
.68075 .30428 L
s
.67322 .29867 m
.68011 .30381 L
s
.69047 .31153 m
.69174 .31247 L
s
.68075 .30428 m
.69047 .31153 L
s
.70016 .31875 m
.70134 .31963 L
s
.69174 .31247 m
.70016 .31875 L
s
0 0 .129 r
.23813 .44339 m .23952 .44152 L .24106 .43503 L closepath p F P
0 g
s
.78 .625 .063 r
.50193 .61019 m .50145 .60269 L .50158 .57659 L p F P
0 g
s
0 0 .048 r
.50226 .56595 m .50158 .57659 L .50145 .60269 L p F P
0 g
s
.788 .525 .538 r
.61498 .85259 m .58984 .8469 L .58937 .81915 L p F P
0 g
s
.822 .553 .532 r
.57449 .81436 m .58937 .81915 L .58984 .8469 L p F P
0 g
s
.431 .249 .532 r
.77555 .80597 m .77383 .77849 L .79419 .76737 L p F P
0 g
s
.498 .299 .54 r
.77383 .77849 m .77555 .80597 L .75345 .81481 L p F P
0 g
s
.079 0 .068 r
.32071 .33667 m .30221 .3493 L .29593 .36331 L p F P
0 g
s
0 0 .015 r
.30221 .3493 m .29593 .36331 L .27879 .37722 L p F P
0 g
s
.457 .247 .505 r
.55485 .39789 m .55462 .37317 L .57576 .3623 L p F P
0 g
s
.369 .181 .489 r
.55462 .37317 m .55485 .39789 L .53582 .41113 L p F P
0 g
s
0 0 .324 r
.23343 .46469 m .22449 .47836 L .22287 .49869 L p F P
0 g
s
0 0 .205 r
.22449 .47836 m .23343 .46469 L .23813 .44339 L p F P
0 g
s
0 0 .273 r
.21669 .51021 m .22287 .49869 L .22449 .47836 L p F P
0 g
s
.789 .983 .9 r
.68759 .82656 m .69249 .82713 L .71561 .80939 L p F P
0 g
s
.835 .543 .496 r
.75517 .36286 m .74064 .35689 L .73915 .33244 L p F P
0 g
s
.271 0 0 r
.39171 .29446 m .39965 .28385 L .42346 .27668 L p F P
0 g
s
.177 0 0 r
.42441 .27571 m .42346 .27668 L .39965 .28385 L p F P
0 g
s
.182 0 0 r
.39965 .28385 m .39171 .29446 L .36908 .30305 L p F P
0 g
s
.872 .994 .801 r
.75735 .76905 m .75888 .76463 L .7614 .76441 L closepath p F P
0 g
s
0 0 .348 r
.21295 .54059 m .21778 .52974 L .21669 .51021 L p F P
0 g
s
0 0 .38 r
.22287 .49869 m .21669 .51021 L .21778 .52974 L p F P
0 g
s
0 0 .323 r
.50713 .52338 m .50901 .51939 L .50909 .49383 L p F P
0 g
s
.036 0 .392 r
.51976 .47777 m .50909 .49383 L .50901 .51939 L p F P
0 g
s
.036 0 .392 r
.50909 .49383 m .51976 .47777 L .51977 .45249 L p F P
0 g
s
.865 .988 .836 r
.75735 .76905 m .75888 .76463 L p .73182 .78837 L F P
0 g
s
.865 .988 .836 r
.73182 .78837 m .73861 .78864 L .75735 .76905 L p F P
0 g
s
.82489 .62844 m
.82522 .62481 L
s
.313 .658 .972 r
.4326 .86601 m .43598 .86643 L .42284 .85614 L p F P
0 g
s
.313 .658 .972 r
.42284 .85614 m .41495 .85519 L .4326 .86601 L p F P
0 g
s
.266 .635 .963 r
.40041 .85288 m .41495 .85519 L .4326 .86601 L p F P
0 g
s
.139 .479 .898 r
.32968 .81212 m .34908 .81994 L .35945 .83327 L p F P
0 g
s
.2 .52 .917 r
.35945 .83327 m .36492 .83513 L .35143 .82073 L p F P
0 g
s
.2 .52 .917 r
.35143 .82073 m .34908 .81994 L .35945 .83327 L p F P
0 g
s
.532 .835 .999 r
.55296 .87375 m .52985 .8784 L .51738 .87196 L p F P
0 g
s
.457 .803 .998 r
.49434 .87476 m .51738 .87196 L .52985 .8784 L p F P
0 g
s
.195 .049 .444 r
.52869 .44278 m .51977 .45249 L .51976 .47777 L p F P
0 g
s
.92 .976 .76 r
.77395 .7364 m .78331 .72326 L .78141 .73595 L closepath p F P
0 g
s
.899 .985 .781 r
.78141 .73595 m .77395 .7364 L p .75888 .76463 L F P
0 g
s
.926 .973 .713 r
.79625 .7029 m .78331 .72326 L .78141 .73595 L p F P
0 g
s
.926 .973 .713 r
.7996 .70213 m .79625 .7029 L p .78141 .73595 L F P
0 g
s
.825 .983 .881 r
.72617 .80024 m .71561 .80939 L .70486 .80795 L p F P
0 g
s
.789 .983 .9 r
.71561 .80939 m .70486 .80795 L p .68759 .82656 L F P
0 g
s
.973 .679 .285 r
.8243 .50879 m .81578 .49363 L .81418 .47329 L p F P
0 g
s
.833 .993 .857 r
.72617 .80024 m .73182 .78837 L .73861 .78864 L closepath p F P
0 g
s
.825 .983 .881 r
.73182 .78837 m .72617 .80024 L p .70486 .80795 L F P
0 g
s
.672 .134 0 r
.63525 .28188 m .63572 .28174 L p .66575 .30036 L F P
0 g
s
.627 .075 0 r
.63525 .28188 m .6345 .28135 L .63572 .28174 L closepath p F P
0 g
s
.62115 .859 m
.62143 .85893 L
s
.62143 .85893 m
.62193 .85881 L
s
.62193 .85881 m
.62408 .85829 L
s
.61956 .85939 m
.62115 .859 L
s
.944 .949 .634 r
.81294 .67056 m .80008 .69626 L .7996 .70213 L p F P
0 g
s
.967 .936 .677 r
.81241 .66138 m .81294 .67056 L .80008 .69626 L p F P
0 g
s
.369 .181 .489 r
.53592 .43614 m .53582 .41113 L .55485 .39789 L p F P
0 g
s
.265 .102 .464 r
.52869 .44278 m .53592 .43614 L .53582 .41113 L p F P
0 g
s
.207 .482 .894 r
.34908 .81994 m .32968 .81212 L .31612 .79518 L p F P
0 g
s
0 0 .394 r
.82889 .63813 m .82166 .65409 L .82372 .68076 L p F P
0 g
s
0 0 .394 r
.82166 .65409 m .82889 .63813 L .8268 .61173 L p F P
0 g
s
.069 0 .449 r
.82127 .68446 m .82372 .68076 L .82166 .65409 L p F P
0 g
s
.64 .113 0 r
.6345 .28135 m .63525 .28188 L .62613 .28726 L p F P
0 g
s
.64 .113 0 r
.60221 .27296 m .6345 .28135 L p .62613 .28726 L F P
0 g
s
.561 0 0 r
.6345 .28135 m .60221 .27296 L .59998 .27172 L p F P
0 g
s
0 0 .251 r
.23952 .44152 m .23813 .44339 L .23343 .46469 L p F P
0 g
s
0 0 .449 r
.21778 .52974 m .21295 .54059 L .2145 .56442 L p F P
0 g
s
0 0 .401 r
.21222 .57104 m .2145 .56442 L .21295 .54059 L p F P
0 g
s
.684 .441 .548 r
.66563 .85658 m .67812 .85636 L .6792 .88442 L p F P
0 g
s
.684 .441 .548 r
.6792 .88442 m .66662 .88463 L .66563 .85658 L p F P
0 g
s
.703 .455 .547 r
.64821 .85617 m .66563 .85658 L .66662 .88463 L p F P
0 g
s
.708 .183 0 r
.67753 .30525 m .66575 .30036 L .67066 .29875 L closepath p F P
0 g
s
.649 .413 .548 r
.6792 .88442 m .67812 .85636 L .70552 .85383 L p F P
0 g
s
.396 .701 .983 r
.45863 .86734 m .43598 .86643 L .42284 .85614 L p F P
0 g
s
.588 .348 .521 r
.5991 .35392 m .59857 .32946 L .62389 .3236 L p F P
0 g
s
.529 .302 .515 r
.59857 .32946 m .5991 .35392 L .57576 .3623 L p F P
0 g
s
.703 .455 .547 r
.66662 .88463 m .64908 .88423 L .64821 .85617 L p F P
0 g
s
.943 .962 .695 r
.79625 .7029 m .80008 .69626 L .7996 .70213 L closepath p F P
0 g
s
.183 0 .026 r
.34175 .32348 m .34784 .31302 L .36908 .30305 L p F P
0 g
s
.082 0 0 r
.34175 .32348 m .34784 .31302 L p .32071 .33667 L F P
0 g
s
.353 .193 .52 r
.79419 .76737 m .8022 .76167 L .80029 .73444 L p F P
0 g
s
.302 .156 .51 r
.81042 .72594 m .80029 .73444 L .8022 .76167 L p F P
0 g
s
.672 .134 0 r
.66575 .30036 m .65091 .29486 L .63525 .28188 L p F P
0 g
s
.68 .163 .001 r
.65091 .29486 m .62613 .28726 L .63525 .28188 L closepath p F P
0 g
s
.989 .723 .376 r
.51537 .69382 m .50664 .67932 L .50674 .65264 L p F P
0 g
s
.072 0 .153 r
.29593 .36331 m .27879 .37722 L .27361 .39287 L p F P
0 g
s
0 0 .103 r
.27879 .37722 m .27361 .39287 L .25787 .408 L p F P
0 g
s
.498 .299 .54 r
.75504 .8426 m .75345 .81481 L .77555 .80597 L p F P
0 g
s
.557 .343 .545 r
.75345 .81481 m .75504 .8426 L .73113 .84925 L p F P
0 g
s
.942 .715 .244 r
.5018 .6366 m .50674 .65264 L .50664 .67932 L p F P
0 g
s
.942 .715 .244 r
.50674 .65264 m .5018 .6366 L .50193 .61019 L p F P
0 g
s
.052 0 .296 r
.23667 .46034 m .23952 .44152 L .25383 .42525 L p F P
0 g
s
0 0 .182 r
.25787 .408 m .25383 .42525 L .23952 .44152 L p F P
0 g
s
0 0 .251 r
.23343 .46469 m .23667 .46034 L .23952 .44152 L p F P
0 g
s
0 0 .286 r
.8291 .60124 m .8268 .61173 L .82889 .63813 L p F P
0 g
s
.266 0 0 r
.43287 .27452 m .42346 .27668 L .42441 .27571 L closepath p F P
0 g
s
.216 0 0 r
.44874 .27111 m .43287 .27452 L .42441 .27571 L p F P
0 g
s
.822 .553 .532 r
.58984 .8469 m .57486 .84215 L .57449 .81436 L p F P
0 g
s
.842 .569 .527 r
.56435 .81048 m .57449 .81436 L .57486 .84215 L p F P
0 g
s
0 0 .49 r
.21741 .58785 m .21222 .57104 L .2145 .56442 L closepath p F P
0 g
s
.976 .672 .346 r
.80355 .45854 m .81418 .47329 L .81578 .49363 L p F P
0 g
s
.326 .629 .961 r
.41495 .85519 m .40041 .85288 L .38706 .84062 L p F P
0 g
s
.233 .577 .943 r
.36492 .83513 m .38706 .84062 L .40041 .85288 L p F P
0 g
s
.291 .572 .936 r
.38706 .84062 m .36492 .83513 L .35143 .82073 L p F P
0 g
s
.063 0 .229 r
.27361 .39287 m .25787 .408 L .25383 .42525 L p F P
0 g
s
.11 .377 .837 r
.28247 .76463 m .282 .76335 L p .31142 .79282 L F P
0 g
s
.032 .314 .801 r
.28247 .76463 m .28134 .76289 L .282 .76335 L closepath p F P
0 g
s
.89 .981 .816 r
.75118 .76415 m .7619 .75174 L .75888 .76463 L closepath p F P
0 g
s
.899 .985 .781 r
.77395 .7364 m .7619 .75174 L .75888 .76463 L p F P
0 g
s
.865 .988 .836 r
.75888 .76463 m .75118 .76415 L p .73182 .78837 L F P
0 g
s
.606 .381 .548 r
.70678 .88191 m .70552 .85383 L .73113 .84925 L p F P
0 g
s
.649 .413 .548 r
.70552 .85383 m .70678 .88191 L .6792 .88442 L p F P
0 g
s
.88 .603 .514 r
.56435 .81048 m .5443 .8002 L .54414 .77267 L p F P
0 g
s
.78 .625 .063 r
.50145 .60269 m .50193 .61019 L .5018 .6366 L p F P
0 g
s
.82776 .57473 m
.82782 .57671 L
s
.82698 .55222 m
.82737 .56331 L
s
.074 .276 .763 r
.26791 .73911 m .25933 .73186 L .25789 .71912 L closepath p F P
0 g
s
0 .205 .719 r
.25458 .71195 m .25789 .71912 L .25933 .73186 L p F P
0 g
s
0 .205 .719 r
.24166 .69879 m .25458 .71195 L p .25933 .73186 L F P
0 g
s
.109 .329 .8 r
.282 .76335 m .28134 .76289 L .26791 .73911 L p F P
0 g
s
.349 0 .021 r
.41571 .28725 m .42346 .27668 L .43287 .27452 L p F P
0 g
s
.271 0 0 r
.42346 .27668 m .41571 .28725 L .39171 .29446 L p F P
0 g
s
.069 .226 .719 r
.25458 .71195 m .24166 .69879 L .24204 .68143 L closepath p F P
0 g
s
0 .149 .669 r
.2415 .67997 m .24204 .68143 L .24166 .69879 L p F P
0 g
s
0 .149 .669 r
.22886 .66408 m .2415 .67997 L p .24166 .69879 L F P
0 g
s
.9 .597 .465 r
.7666 .39239 m .76838 .39357 L p .78727 .42989 L F P
0 g
s
.924 .539 .24 r
.76838 .39357 m .78183 .40609 L .78677 .42297 L p F P
0 g
s
.9 .597 .465 r
.76838 .39357 m .78545 .40485 L .78677 .42297 L p F P
0 g
s
.9 .597 .465 r
.78677 .42297 m .78727 .42989 L p .76838 .39357 L F P
0 g
s
.924 .539 .24 r
.76698 .39226 m .76838 .39357 L p .78728 .42473 L F P
0 g
s
.924 .539 .24 r
.78677 .42297 m .78728 .42473 L p .76838 .39357 L F P
0 g
s
.11 .377 .837 r
.282 .76335 m .30254 .77555 L p .31142 .79282 L F P
0 g
s
.172 .384 .83 r
.282 .76335 m .30254 .77555 L .289 .75284 L p F P
0 g
s
.172 .384 .83 r
.289 .75284 m .27903 .74698 L .282 .76335 L p F P
0 g
s
.109 .329 .8 r
.26791 .73911 m .27903 .74698 L .282 .76335 L p F P
0 g
s
.70134 .31963 m
.70601 .32394 L
s
.70601 .32394 m
.70625 .32416 L
s
.72306 .33966 m
.72841 .34459 L
s
.71947 .33635 m
.72306 .33966 L
s
.582 .038 0 r
.60221 .27296 m .5989 .27228 L .59998 .27172 L closepath p F P
0 g
s
.529 0 0 r
.59998 .27172 m .5989 .27228 L .56499 .26693 L p F P
0 g
s
.637 .387 .522 r
.6246 .34808 m .62389 .3236 L .65128 .32034 L p F P
0 g
s
.588 .348 .521 r
.62389 .3236 m .6246 .34808 L .5991 .35392 L p F P
0 g
s
.317 0 0 r
.44703 .27311 m .43287 .27452 L .44874 .27111 L closepath p F P
0 g
s
.349 0 .021 r
.43287 .27452 m .44703 .27311 L p .41571 .28725 L F P
0 g
s
.842 .569 .527 r
.57486 .84215 m .56464 .8383 L .56435 .81048 L p F P
0 g
s
.88 .603 .514 r
.5443 .8002 m .56435 .81048 L .56464 .8383 L p F P
0 g
s
.501 .787 .996 r
.51738 .87196 m .49434 .87476 L .48156 .86638 L p F P
0 g
s
.428 .753 .995 r
.45863 .86734 m .48156 .86638 L .49434 .87476 L p F P
0 g
s
.062 .174 .67 r
.2415 .67997 m .22886 .66408 L .23112 .64827 L closepath p F P
0 g
s
0 .092 .613 r
.22893 .64049 m .23112 .64827 L .22886 .66408 L p F P
0 g
s
0 .092 .613 r
.22093 .62764 m .22893 .64049 L p .22886 .66408 L F P
0 g
s
.789 .983 .9 r
.70486 .80795 m .69436 .81601 L .68759 .82656 L p F P
0 g
s
.783 .972 .916 r
.68151 .8253 m .69436 .81601 L .68759 .82656 L closepath p F P
0 g
s
.742 .968 .933 r
.65813 .84013 m .68151 .8253 L .68759 .82656 L p F P
0 g
s
.955 .941 .724 r
.80008 .69626 m .79625 .7029 L .78631 .702 L p F P
0 g
s
.955 .941 .724 r
.78631 .702 m .79902 .68004 L .80008 .69626 L p F P
0 g
s
.967 .936 .677 r
.80822 .66171 m .81241 .66138 L p .80008 .69626 L F P
0 g
s
.967 .936 .677 r
.80008 .69626 m .79902 .68004 L .80822 .66171 L p F P
0 g
s
0 0 .048 r
.50145 .60269 m .50213 .59211 L .50226 .56595 L p F P
0 g
s
0 0 .221 r
.50704 .54927 m .50226 .56595 L .50213 .59211 L p F P
0 g
s
0 0 .221 r
.50226 .56595 m .50704 .54927 L .50713 .52338 L p F P
0 g
s
.645 .142 .038 r
.5989 .27228 m .60221 .27296 L .62031 .28576 L p F P
0 g
s
.64 .113 0 r
.62613 .28726 m .62031 .28576 L .60221 .27296 L p F P
0 g
s
.529 .302 .515 r
.57613 .38706 m .57576 .3623 L .5991 .35392 L p F P
0 g
s
.457 .247 .505 r
.57576 .3623 m .57613 .38706 L .55485 .39789 L p F P
0 g
s
.763 .262 .02 r
.70079 .32562 m .69028 .32045 L .67753 .30525 L p F P
0 g
s
.761 .278 .09 r
.66575 .30036 m .67753 .30525 L .69028 .32045 L p F P
0 g
s
.532 .835 .999 r
.51738 .87196 m .54062 .86724 L .55296 .87375 L p F P
0 g
s
.172 .427 .863 r
.31612 .79518 m .31142 .79282 L .3082 .78393 L closepath p F P
0 g
s
.11 .377 .837 r
.30254 .77555 m .3082 .78393 L .31142 .79282 L p F P
0 g
s
.602 .09 .006 r
.56499 .26693 m .5989 .27228 L .59024 .27953 L p F P
0 g
s
.645 .142 .038 r
.62031 .28576 m .59024 .27953 L .5989 .27228 L p F P
0 g
s
.82472 .53787 m
.82698 .55222 L
s
.8209 .51374 m
.82246 .52357 L
s
.195 .049 .444 r
.51976 .47777 m .52874 .46811 L .52869 .44278 L p F P
0 g
s
.265 .102 .464 r
.53592 .43614 m .52869 .44278 L .52874 .46811 L p F P
0 g
s
.98 .91 .597 r
.82098 .6297 m .81161 .6543 L .81241 .66138 L p F P
0 g
s
.987 .89 .632 r
.817 .61389 m .82098 .6297 L .81161 .6543 L p F P
0 g
s
.994 .874 .569 r
.82098 .6297 m .817 .61389 L .81925 .60641 L p F P
0 g
s
.736 .464 .517 r
.70947 .34838 m .68241 .34507 L .68131 .32058 L p F P
0 g
s
.7 .435 .521 r
.66382 .32006 m .68131 .32058 L .68241 .34507 L p F P
0 g
s
.944 .952 .745 r
.78331 .72326 m .79625 .7029 L .78631 .702 L p F P
0 g
s
.557 .343 .545 r
.73257 .87737 m .73113 .84925 L .75504 .8426 L p F P
0 g
s
.606 .381 .548 r
.73113 .84925 m .73257 .87737 L .70678 .88191 L p F P
0 g
s
.179 0 .116 r
.3188 .34102 m .33316 .3296 L .32071 .33667 L closepath p F P
0 g
s
.082 0 0 r
.32071 .33667 m .33316 .3296 L .34175 .32348 L p F P
0 g
s
.079 0 .068 r
.3188 .34102 m .32071 .33667 L p .29593 .36331 L F P
0 g
s
0 0 .449 r
.2145 .56442 m .22166 .54854 L .21778 .52974 L p F P
0 g
s
.06 .049 .529 r
.2145 .56442 m .22166 .54854 L p .21796 .58936 L F P
0 g
s
.06 .049 .529 r
.21796 .58936 m .21741 .58785 L .2145 .56442 L p F P
0 g
s
.678 .419 .522 r
.65128 .32034 m .66382 .32006 L .6648 .34455 L p F P
0 g
s
.678 .419 .522 r
.6648 .34455 m .65217 .34483 L .65128 .32034 L p F P
0 g
s
.637 .387 .522 r
.65128 .32034 m .65217 .34483 L .6246 .34808 L p F P
0 g
s
.7 .435 .521 r
.68241 .34507 m .6648 .34455 L .66382 .32006 L p F P
0 g
s
0 0 .323 r
.50901 .51939 m .50713 .52338 L .50704 .54927 L p F P
0 g
s
.395 0 0 r
.44703 .27311 m .44874 .27111 L .4755 .26723 L p F P
0 g
s
.427 0 0 r
.53348 .26486 m .51391 .26471 L .50585 .26297 L p F P
0 g
s
.452 0 0 r
.51391 .26471 m .50362 .26495 L .50585 .26297 L closepath p F P
0 g
s
.385 0 0 r
.50585 .26297 m .50362 .26495 L .4755 .26723 L p F P
0 g
s
.353 .193 .52 r
.8022 .76167 m .79419 .76737 L .79607 .79493 L p F P
0 g
s
.431 .249 .532 r
.79419 .76737 m .79607 .79493 L .77555 .80597 L p F P
0 g
s
.06 0 .421 r
.23186 .48507 m .22287 .49869 L .22269 .52068 L p F P
0 g
s
0 0 .324 r
.22287 .49869 m .23186 .48507 L .23343 .46469 L p F P
0 g
s
0 0 .38 r
.21778 .52974 m .22269 .52068 L .22287 .49869 L p F P
0 g
s
.975 .924 .658 r
.80822 .66171 m .81161 .6543 L .81241 .66138 L closepath p F P
0 g
s
.724 .936 .957 r
.63114 .85159 m .63476 .85287 L .65813 .84013 L p F P
0 g
s
.272 0 .071 r
.36453 .31102 m .36908 .30305 L .39171 .29446 L p F P
0 g
s
.183 0 .026 r
.36908 .30305 m .36453 .31102 L .34175 .32348 L p F P
0 g
s
.19 .076 .484 r
.82333 .71147 m .81042 .72594 L .8124 .75323 L p F P
0 g
s
.19 .076 .484 r
.81042 .72594 m .82333 .71147 L .82127 .68446 L p F P
0 g
s
.302 .156 .51 r
.8022 .76167 m .8124 .75323 L .81042 .72594 L p F P
0 g
s
.052 .121 .617 r
.22893 .64049 m .22093 .62764 L .22334 .61808 L closepath p F P
0 g
s
0 .033 .553 r
.22093 .62764 m .22334 .61808 L .21772 .59004 L p F P
0 g
s
.039 0 .353 r
.23667 .46034 m .23343 .46469 L .23186 .48507 L p F P
0 g
s
.043 0 .466 r
.22269 .52068 m .21778 .52974 L .22166 .54854 L p F P
0 g
s
.069 0 .449 r
.82372 .68076 m .82127 .68446 L .82333 .71147 L p F P
0 g
s
.362 .648 .965 r
.41495 .85519 m .42284 .85614 L .40957 .84383 L p F P
0 g
s
.362 .648 .965 r
.40957 .84383 m .40165 .84289 L .41495 .85519 L p F P
0 g
s
.326 .629 .961 r
.38706 .84062 m .40165 .84289 L .41495 .85519 L p F P
0 g
s
.78 .625 .063 r
.5018 .6366 m .50132 .62914 L .50145 .60269 L p F P
0 g
s
0 0 .048 r
.50213 .59211 m .50145 .60269 L .50132 .62914 L p F P
0 g
s
.74799 .36687 m
.75356 .37321 L
s
.74375 .36205 m
.74402 .36236 L
s
.431 .249 .532 r
.7773 .83383 m .77555 .80597 L .79607 .79493 L p F P
0 g
s
.498 .299 .54 r
.77555 .80597 m .7773 .83383 L .75504 .8426 L p F P
0 g
s
.207 .482 .894 r
.31612 .79518 m .33788 .80387 L p .34908 .81994 L F P
0 g
s
.259 .48 .881 r
.32429 .78444 m .33788 .80387 L .31612 .79518 L p F P
0 g
s
.259 .48 .881 r
.30639 .77738 m .32429 .78444 L p .31612 .79518 L F P
0 g
s
.259 .48 .881 r
.31612 .79518 m .3082 .78393 L .30639 .77738 L p F P
0 g
s
.468 .736 .985 r
.48156 .86638 m .45863 .86734 L .44559 .857 L p F P
0 g
s
.396 .701 .983 r
.42284 .85614 m .44559 .857 L .45863 .86734 L p F P
0 g
s
.761 .278 .09 r
.65995 .30439 m .66575 .30036 L p .69028 .32045 L F P
0 g
s
.733 .24 .064 r
.65995 .30439 m .65091 .29486 L .66575 .30036 L closepath p F P
0 g
s
.457 .247 .505 r
.55508 .42295 m .55485 .39789 L .57613 .38706 L p F P
0 g
s
.369 .181 .489 r
.55485 .39789 m .55508 .42295 L .53592 .43614 L p F P
0 g
s
.17 .338 .791 r
.27903 .74698 m .26791 .73911 L .25789 .71912 L p F P
0 g
s
.81793 .50327 m
.8209 .51374 L
s
.461 0 .034 r
.4755 .26723 m .50362 .26495 L .49586 .27459 L p F P
0 g
s
.461 0 .034 r
.46984 .27404 m .4755 .26723 L p .49586 .27459 L F P
0 g
s
.395 0 0 r
.4755 .26723 m .46984 .27404 L .44703 .27311 L p F P
0 g
s
0 0 .198 r
.82978 .59368 m .8291 .60124 L .83121 .62771 L p F P
0 g
s
0 0 .286 r
.82889 .63813 m .83121 .62771 L .8291 .60124 L p F P
0 g
s
.602 .09 .006 r
.56461 .26723 m .56499 .26693 L p .59024 .27953 L F P
0 g
s
.551 .03 0 r
.56461 .26723 m .56363 .26679 L .56499 .26693 L closepath p F P
0 g
s
.835 .373 .109 r
.74264 .36122 m .72274 .34872 L .71297 .33213 L p F P
0 g
s
.72841 .34459 m
.73691 .35427 L
s
.826 .379 .169 r
.70079 .32562 m .71297 .33213 L .72274 .34872 L p F P
0 g
s
.929 .95 .781 r
.78331 .72326 m .77395 .7364 L .76367 .73426 L p F P
0 g
s
.929 .95 .781 r
.76367 .73426 m .7832 .70689 L .78331 .72326 L p F P
0 g
s
.944 .952 .745 r
.78631 .702 m .7832 .70689 L .78331 .72326 L p F P
0 g
s
.561 .067 .039 r
.56363 .26679 m .56461 .26723 L .55695 .27544 L p F P
0 g
s
.561 .067 .039 r
.53348 .26486 m .56363 .26679 L p .55695 .27544 L F P
0 g
s
0 0 .323 r
.50704 .54927 m .50893 .5453 L .50901 .51939 L p F P
0 g
s
.036 0 .392 r
.51975 .5034 m .50901 .51939 L .50893 .5453 L p F P
0 g
s
.036 0 .392 r
.50901 .51939 m .51975 .5034 L .51976 .47777 L p F P
0 g
s
.855 .979 .861 r
.72811 .7878 m .7339 .78221 L .73182 .78837 L closepath p F P
0 g
s
.865 .988 .836 r
.75118 .76415 m .7339 .78221 L .73182 .78837 L p F P
0 g
s
.825 .983 .881 r
.70486 .80795 m .72811 .7878 L .73182 .78837 L p F P
0 g
s
.417 0 .058 r
.44105 .28147 m .44703 .27311 L .46984 .27404 L p F P
0 g
s
.349 0 .021 r
.44703 .27311 m .44105 .28147 L .41571 .28725 L p F P
0 g
s
.602 .09 .006 r
.59024 .27953 m .58413 .27857 L .56461 .26723 L p F P
0 g
s
.606 .118 .07 r
.58413 .27857 m .55695 .27544 L .56461 .26723 L closepath p F P
0 g
s
.195 .049 .444 r
.52874 .46811 m .51976 .47777 L .51975 .5034 L p F P
0 g
s
.223 0 .165 r
.31484 .35098 m .3188 .34102 L .33316 .3296 L p F P
0 g
s
.079 0 .068 r
.29593 .36331 m .29748 .36226 L .3188 .34102 L p F P
0 g
s
.137 0 .125 r
.29748 .36226 m .31484 .35098 L .3188 .34102 L closepath p F P
0 g
s
.765 .942 .939 r
.68151 .8253 m .65813 .84013 L .64667 .83589 L p F P
0 g
s
.724 .936 .957 r
.65813 .84013 m .64667 .83589 L p .63114 .85159 L F P
0 g
s
.171 0 .197 r
.29551 .36461 m .29748 .36226 L .29593 .36331 L closepath p F P
0 g
s
.072 0 .153 r
.29551 .36461 m .29593 .36331 L p .27361 .39287 L F P
0 g
s
.207 .482 .894 r
.33788 .80387 m .34636 .81452 L .34908 .81994 L p F P
0 g
s
.256 .518 .909 r
.35143 .82073 m .34908 .81994 L .34636 .81452 L closepath p F P
0 g
s
.976 .672 .346 r
.81578 .49363 m .80511 .47893 L .80355 .45854 L p F P
0 g
s
.81017 .47593 m
.81266 .4847 L
s
.81017 .47593 m
.81188 .4747 L
s
.518 .043 .068 r
.49586 .27459 m .50362 .26495 L .51391 .26471 L p F P
0 g
s
.561 .067 .039 r
.52899 .26947 m .53348 .26486 L p .55695 .27544 L F P
0 g
s
.507 .007 .003 r
.52899 .26947 m .51391 .26471 L .53348 .26486 L closepath p F P
0 g
s
.369 .181 .489 r
.53602 .46149 m .53592 .43614 L .55508 .42295 L p F P
0 g
s
.265 .102 .464 r
.52874 .46811 m .53602 .46149 L .53592 .43614 L p F P
0 g
s
.518 .043 .068 r
.51391 .26471 m .52899 .26947 L p .49586 .27459 L F P
0 g
s
0 0 .394 r
.83101 .6649 m .82372 .68076 L .8258 .70779 L p F P
0 g
s
.069 0 .449 r
.82333 .71147 m .8258 .70779 L .82372 .68076 L p F P
0 g
s
0 0 .394 r
.82372 .68076 m .83101 .6649 L .82889 .63813 L p F P
0 g
s
.684 .441 .548 r
.66662 .88463 m .6792 .88442 L .68029 .91286 L p F P
0 g
s
.684 .441 .548 r
.68029 .91286 m .66762 .91308 L .66662 .88463 L p F P
0 g
s
.703 .455 .547 r
.64908 .88423 m .66662 .88463 L .66762 .91308 L p F P
0 g
s
.132 0 .389 r
.23511 .48073 m .23667 .46034 L .25105 .4441 L p F P
0 g
s
.052 0 .296 r
.25383 .42525 m .25105 .4441 L .23667 .46034 L p F P
0 g
s
.039 0 .353 r
.23186 .48507 m .23511 .48073 L .23667 .46034 L p F P
0 g
s
.879 .45 .169 r
.74329 .36268 m .74264 .36122 L .74411 .36232 L closepath p F P
0 g
s
.214 0 .236 r
.29748 .36226 m .31484 .35098 L p .29114 .37928 L F P
0 g
s
.214 0 .236 r
.29114 .37928 m .29551 .36461 L .29748 .36226 L p F P
0 g
s
.223 0 .165 r
.33316 .3296 m .34074 .32543 L p .31484 .35098 L F P
0 g
s
.141 0 .044 r
.33316 .3296 m .34074 .32543 L .34175 .32348 L closepath p F P
0 g
s
.649 .413 .548 r
.68029 .91286 m .6792 .88442 L .70678 .88191 L p F P
0 g
s
0 .011 .519 r
.21772 .59004 m .21741 .58785 L .21796 .58936 L closepath p F P
0 g
s
.588 .348 .521 r
.59964 .37871 m .5991 .35392 L .6246 .34808 L p F P
0 g
s
.529 .302 .515 r
.5991 .35392 m .59964 .37871 L .57613 .38706 L p F P
0 g
s
.914 .959 .803 r
.7619 .75174 m .77395 .7364 L .76367 .73426 L p F P
0 g
s
.703 .455 .547 r
.66762 .91308 m .64996 .91268 L .64908 .88423 L p F P
0 g
s
.735 .481 .545 r
.622 .88167 m .64908 .88423 L .64996 .91268 L p F P
0 g
s
.72 .924 .961 r
.62311 .84828 m .6447 .83696 L .63114 .85159 L closepath p F P
0 g
s
.724 .936 .957 r
.64667 .83589 m .6447 .83696 L .63114 .85159 L p F P
0 g
s
.675 .915 .975 r
.59962 .8587 m .62311 .84828 L .63114 .85159 L p F P
0 g
s
.072 0 .153 r
.27361 .39287 m .27898 .38854 L .29551 .36461 L p F P
0 g
s
.129 0 .199 r
.27898 .38854 m .29114 .37928 L .29551 .36461 L closepath p F P
0 g
s
.353 .193 .52 r
.79607 .79493 m .80413 .78927 L .8022 .76167 L p F P
0 g
s
.302 .156 .51 r
.8124 .75323 m .8022 .76167 L .80413 .78927 L p F P
0 g
s
.75356 .37321 m
.7581 .37965 L
s
.7581 .37965 m
.76171 .38476 L
s
.434 .684 .969 r
.44559 .857 m .42284 .85614 L .40957 .84383 L p F P
0 g
s
.993 .839 .585 r
.82368 .59019 m .81711 .57485 L p .81309 .60431 L F P
0 g
s
.993 .839 .585 r
.81309 .60431 m .81925 .60641 L .82368 .59019 L p F P
0 g
s
.999 .819 .52 r
.82368 .59019 m .81711 .57485 L .82156 .55197 L p F P
0 g
s
.80744 .4775 m
.81017 .47593 L
s
.79829 .48277 m
.80161 .48086 L
s
.80667 .46748 m
.81017 .47593 L
s
.075 .107 .59 r
.21796 .58936 m .21772 .59004 L .22334 .61808 L p F P
0 g
s
.291 .572 .936 r
.35143 .82073 m .37362 .82615 L .38706 .84062 L p F P
0 g
s
.335 .563 .921 r
.36009 .80947 m .37362 .82615 L .35143 .82073 L p F P
0 g
s
.335 .563 .921 r
.34247 .80523 m .36009 .80947 L p .35143 .82073 L F P
0 g
s
.335 .563 .921 r
.35143 .82073 m .34636 .81452 L .34247 .80523 L p F P
0 g
s
.867 .449 .226 r
.74264 .36122 m .74329 .36268 L .73671 .37022 L p F P
0 g
s
.867 .449 .226 r
.72274 .34872 m .74264 .36122 L p .73671 .37022 L F P
0 g
s
.565 .812 .991 r
.54062 .86724 m .51738 .87196 L .50471 .86352 L p F P
0 g
s
.501 .787 .996 r
.48156 .86638 m .50471 .86352 L .51738 .87196 L p F P
0 g
s
.228 0 .086 r
.34074 .32543 m .34175 .32348 L .36453 .31102 L p F P
0 g
s
.498 .299 .54 r
.75665 .87077 m .75504 .8426 L .7773 .83383 L p F P
0 g
s
.557 .343 .545 r
.75504 .8426 m .75665 .87077 L .73257 .87737 L p F P
0 g
s
.942 .715 .244 r
.50167 .66338 m .50664 .67932 L .50654 .70636 L p F P
0 g
s
.942 .715 .244 r
.50664 .67932 m .50167 .66338 L .5018 .6366 L p F P
0 g
s
.075 .107 .59 r
.22334 .61808 m .22741 .6067 L .21796 .58936 L p F P
0 g
s
.13 .131 .591 r
.22692 .5698 m .21796 .58936 L .22741 .6067 L p F P
0 g
s
.06 .049 .529 r
.22557 .55905 m .22692 .5698 L .21796 .58936 L p F P
0 g
s
.06 .049 .529 r
.22166 .54854 m .22557 .55905 L p .21796 .58936 L F P
0 g
s
.945 .637 .424 r
.80395 .46883 m .7891 .45527 L .78727 .42989 L p F P
0 g
s
.964 .657 .391 r
.79077 .44427 m .80355 .45854 L .80511 .47893 L p F P
0 g
s
.953 .607 .295 r
.80355 .45854 m .79077 .44427 L .78728 .42473 L p F P
0 g
s
.79507 .43946 m
.79926 .44958 L
s
0 0 .286 r
.83121 .62771 m .82889 .63813 L .83101 .6649 L p F P
0 g
s
.975 .897 .681 r
.81161 .6543 m .80822 .66171 L .79824 .65886 L p F P
0 g
s
.975 .897 .681 r
.79824 .65886 m .80754 .63862 L .81161 .6543 L p F P
0 g
s
.987 .89 .632 r
.81161 .6543 m .80754 .63862 L .817 .61389 L p F P
0 g
s
.371 .616 .946 r
.40165 .84289 m .38706 .84062 L .37362 .82615 L p F P
0 g
s
.16 0 .27 r
.27114 .40364 m .27898 .38854 L .27361 .39287 L closepath p F P
0 g
s
.063 0 .229 r
.27114 .40364 m .27361 .39287 L p .25383 .42525 L F P
0 g
s
.727 .255 .126 r
.65091 .29486 m .65995 .30439 L .65729 .30726 L p F P
0 g
s
.727 .255 .126 r
.62613 .28726 m .65091 .29486 L p .65729 .30726 L F P
0 g
s
.889 .469 .185 r
.76698 .39226 m .74993 .37897 L .74329 .36268 L p F P
0 g
s
.878 .467 .237 r
.74993 .37897 m .73671 .37022 L .74329 .36268 L closepath p F P
0 g
s
.147 0 .334 r
.26727 .41242 m .25383 .42525 L .25105 .4441 L p F P
0 g
s
.063 0 .229 r
.25383 .42525 m .26727 .41242 L .27114 .40364 L p F P
0 g
s
.35 0 .109 r
.38727 .3024 m .39171 .29446 L .41571 .28725 L p F P
0 g
s
.272 0 .071 r
.39171 .29446 m .38727 .3024 L .36453 .31102 L p F P
0 g
s
.79021 .43068 m
.79507 .43946 L
s
.78728 .4254 m
.78745 .4257 L
s
.105 .277 .756 r
.25789 .71912 m .25458 .71195 L .2578 .71471 L closepath p F P
0 g
s
.17 .338 .791 r
.25789 .71912 m .2578 .71471 L p .27903 .74698 L F P
0 g
s
.799 .943 .92 r
.69436 .81601 m .68151 .8253 L .67024 .82092 L p F P
0 g
s
.765 .942 .939 r
.64667 .83589 m .67024 .82092 L .68151 .8253 L p F P
0 g
s
.857 .562 .487 r
.75677 .38762 m .7666 .39239 L .76829 .41748 L p F P
0 g
s
.9 .597 .465 r
.78727 .42989 m .76829 .41748 L .7666 .39239 L p F P
0 g
s
.7841 .41965 m
.78623 .4235 L
s
.77601 .40502 m
.78312 .41788 L
s
.76954 .39585 m
.77601 .40502 L
s
.898 .952 .828 r
.7619 .75174 m .75118 .76415 L .7406 .76104 L p F P
0 g
s
.898 .952 .828 r
.7406 .76104 m .76295 .73517 L .7619 .75174 L p F P
0 g
s
.914 .959 .803 r
.76367 .73426 m .76295 .73517 L .7619 .75174 L p F P
0 g
s
.857 .562 .487 r
.76829 .41748 m .7584 .41272 L .75677 .38762 L p F P
0 g
s
.835 .543 .496 r
.74215 .38167 m .75677 .38762 L .7584 .41272 L p F P
0 g
s
.911 .532 .29 r
.74993 .37897 m .76698 .39226 L .77236 .41093 L p F P
0 g
s
.924 .539 .24 r
.78728 .42473 m .77236 .41093 L .76698 .39226 L p F P
0 g
s
.9 .597 .465 r
.76829 .41748 m .78727 .42989 L .7891 .45527 L p F P
0 g
s
.94 .595 .341 r
.77236 .41093 m .78728 .42473 L .79077 .44427 L p F P
0 g
s
.209 .44 .864 r
.3082 .78393 m .30254 .77555 L .30639 .77738 L closepath p F P
0 g
s
.606 .381 .548 r
.70806 .91037 m .70678 .88191 L .73257 .87737 L p F P
0 g
s
.649 .413 .548 r
.70678 .88191 m .70806 .91037 L .68029 .91286 L p F P
0 g
s
.88 .603 .514 r
.56464 .8383 m .54446 .8281 L .5443 .8002 L p F P
0 g
s
.78 .625 .063 r
.50132 .62914 m .5018 .6366 L .50167 .66338 L p F P
0 g
s
.735 .481 .545 r
.64996 .91268 m .62269 .91014 L .622 .88167 L p F P
0 g
s
.761 .503 .542 r
.61563 .88068 m .622 .88167 L .62269 .91014 L p F P
0 g
s
.799 .943 .92 r
.69867 .80587 m .69436 .81601 L p .67024 .82092 L F P
0 g
s
.81 .956 .91 r
.69436 .81601 m .69867 .80587 L .70486 .80795 L closepath p F P
0 g
s
.826 .379 .169 r
.69619 .32958 m .70079 .32562 L p .72274 .34872 L F P
0 g
s
.808 .352 .151 r
.69619 .32958 m .69028 .32045 L .70079 .32562 L closepath p F P
0 g
s
.878 .959 .85 r
.7339 .78221 m .75118 .76415 L .7406 .76104 L p F P
0 g
s
.164 .289 .746 r
.2578 .71471 m .25458 .71195 L .24204 .68143 L p F P
0 g
s
.299 0 .198 r
.33513 .33987 m .34074 .32543 L .36223 .31555 L p F P
0 g
s
.228 0 .086 r
.36453 .31102 m .36223 .31555 L .34074 .32543 L p F P
0 g
s
.223 0 .165 r
.34074 .32543 m .33513 .33987 L .31484 .35098 L p F P
0 g
s
.968 .909 .701 r
.79902 .68004 m .80822 .66171 L .79824 .65886 L p F P
0 g
s
.797 .512 .507 r
.74215 .38167 m .71713 .37447 L .71579 .34966 L p F P
0 g
s
.766 .488 .513 r
.70947 .34838 m .71579 .34966 L .71713 .37447 L p F P
0 g
s
.57436 .86159 m
.57629 .86174 L
s
.84 .953 .889 r
.69867 .80587 m .70486 .80795 L .72811 .7878 L p F P
0 g
s
.761 .503 .542 r
.62269 .91014 m .61628 .90916 L .61563 .88068 L p F P
0 g
s
.788 .525 .538 r
.59031 .87504 m .61563 .88068 L .61628 .90916 L p F P
0 g
s
.135 .059 .498 r
.22396 .54433 m .22269 .52068 L .23345 .50453 L p F P
0 g
s
.06 0 .421 r
.22269 .52068 m .23345 .50453 L .23186 .48507 L p F P
0 g
s
.043 0 .466 r
.22166 .54854 m .22396 .54433 L .22269 .52068 L p F P
0 g
s
.864 .949 .868 r
.7339 .78221 m .72811 .7878 L .71727 .7839 L p F P
0 g
s
.864 .949 .868 r
.71727 .7839 m .73644 .76537 L .7339 .78221 L p F P
0 g
s
.878 .959 .85 r
.7406 .76104 m .73644 .76537 L .7339 .78221 L p F P
0 g
s
.84 .953 .889 r
.72811 .7878 m .71727 .7839 L p .69867 .80587 L F P
0 g
s
.766 .488 .513 r
.71713 .37447 m .71077 .3732 L .70947 .34838 L p F P
0 g
s
.736 .464 .517 r
.68241 .34507 m .70947 .34838 L .71077 .3732 L p F P
0 g
s
.297 .535 .912 r
.34636 .81452 m .33788 .80387 L .34247 .80523 L closepath p F P
0 g
s
0 0 .198 r
.83121 .62771 m .83191 .62018 L .82978 .59368 L p F P
0 g
s
.774 .572 .001 r
.82733 .57704 m .82978 .59368 L .83191 .62018 L p F P
0 g
s
.774 .572 .001 r
.82978 .59368 m .82733 .57704 L .82523 .5508 L p F P
0 g
s
.144 .185 .646 r
.22334 .61808 m .22741 .6067 L p .23201 .64467 L F P
0 g
s
.144 .185 .646 r
.23201 .64467 m .22893 .64049 L .22334 .61808 L p F P
0 g
s
.637 .387 .522 r
.62531 .3729 m .6246 .34808 L .65217 .34483 L p F P
0 g
s
.588 .348 .521 r
.6246 .34808 m .62531 .3729 L .59964 .37871 L p F P
0 g
s
.203 0 .299 r
.27898 .38854 m .29114 .37928 L p .26973 .41022 L F P
0 g
s
.203 0 .299 r
.26973 .41022 m .27114 .40364 L .27898 .38854 L p F P
0 g
s
.995 .77 .481 r
.82156 .55197 m .81292 .53696 L .81537 .51486 L p F P
0 g
s
.989 .794 .55 r
.81292 .53696 m .82156 .55197 L .81711 .57485 L p F P
0 g
s
.304 0 .123 r
.36223 .31555 m .36453 .31102 L .38727 .3024 L p F P
0 g
s
0 0 .048 r
.50132 .62914 m .502 .61862 L .50213 .59211 L p F P
0 g
s
0 0 .221 r
.50694 .57551 m .50213 .59211 L .502 .61862 L p F P
0 g
s
0 0 .221 r
.50213 .59211 m .50694 .57551 L .50704 .54927 L p F P
0 g
s
.991 .849 .601 r
.817 .61389 m .81309 .60431 L .81925 .60641 L closepath p F P
0 g
s
.694 .886 .968 r
.62311 .84828 m .59962 .8587 L .58757 .85203 L p F P
0 g
s
.17 .338 .791 r
.2578 .71471 m .27552 .72712 L p .27903 .74698 L F P
0 g
s
.217 .342 .777 r
.2578 .71471 m .27552 .72712 L .2622 .69734 L p F P
0 g
s
.217 .342 .777 r
.2622 .69734 m .26022 .69597 L .2578 .71471 L p F P
0 g
s
.164 .289 .746 r
.24213 .68064 m .26022 .69597 L .2578 .71471 L p F P
0 g
s
.164 .289 .746 r
.24204 .68143 m .24213 .68064 L p .2578 .71471 L F P
0 g
s
.259 .438 .848 r
.30639 .77738 m .30254 .77555 L .289 .75284 L p F P
0 g
s
.943 .669 .206 r
.81865 .53512 m .82523 .5508 L .82733 .57704 L p F P
0 g
s
.943 .669 .206 r
.82523 .5508 m .81865 .53512 L .81661 .50916 L p F P
0 g
s
.529 .302 .515 r
.57651 .41217 m .57613 .38706 L .59964 .37871 L p F P
0 g
s
.457 .247 .505 r
.57613 .38706 m .57651 .41217 L .55508 .42295 L p F P
0 g
s
.115 .003 .436 r
.23511 .48073 m .23186 .48507 L .23345 .50453 L p F P
0 g
s
.222 .387 .817 r
.289 .75284 m .27903 .74698 L .27888 .73385 L closepath p F P
0 g
s
.17 .338 .791 r
.27552 .72712 m .27888 .73385 L .27903 .74698 L p F P
0 g
s
.532 .763 .982 r
.50471 .86352 m .48156 .86638 L .4686 .85598 L p F P
0 g
s
.468 .736 .985 r
.44559 .857 m .4686 .85598 L .48156 .86638 L p F P
0 g
s
.098 .222 .705 r
.24204 .68143 m .2415 .67997 L .24213 .68064 L closepath p F P
0 g
s
.088 .165 .65 r
.23112 .64827 m .22893 .64049 L .23201 .64467 L closepath p F P
0 g
s
.155 .238 .698 r
.24213 .68064 m .2415 .67997 L .23112 .64827 L p F P
0 g
s
.976 .672 .347 r
.8059 .4945 m .81661 .50916 L .81865 .53512 L p F P
0 g
s
.195 .049 .444 r
.51975 .5034 m .52879 .49378 L .52874 .46811 L p F P
0 g
s
.265 .102 .464 r
.53602 .46149 m .52874 .46811 L .52879 .49378 L p F P
0 g
s
.155 .238 .698 r
.23112 .64827 m .23201 .64467 L p .24213 .68064 L F P
0 g
s
.736 .464 .517 r
.71077 .3732 m .68352 .3699 L .68241 .34507 L p F P
0 g
s
.7 .435 .521 r
.6648 .34455 m .68241 .34507 L .68352 .3699 L p F P
0 g
s
.796 .356 .203 r
.69028 .32045 m .69619 .32958 L .69326 .33361 L p F P
0 g
s
.796 .356 .203 r
.66439 .30973 m .69028 .32045 L p .69326 .33361 L F P
0 g
s
.761 .278 .09 r
.69028 .32045 m .66439 .30973 L .65995 .30439 L p F P
0 g
s
.557 .343 .545 r
.73403 .90587 m .73257 .87737 L .75665 .87077 L p F P
0 g
s
.606 .381 .548 r
.73257 .87737 m .73403 .90587 L .70806 .91037 L p F P
0 g
s
.678 .419 .522 r
.65217 .34483 m .6648 .34455 L .66579 .36938 L p F P
0 g
s
.678 .419 .522 r
.66579 .36938 m .65308 .36965 L .65217 .34483 L p F P
0 g
s
.637 .387 .522 r
.65217 .34483 m .65308 .36965 L .62531 .3729 L p F P
0 g
s
.21 .296 .735 r
.24722 .66064 m .24213 .68064 L .26022 .69597 L p F P
0 g
s
.155 .238 .698 r
.23201 .64467 m .24722 .66064 L .24213 .68064 L p F P
0 g
s
.727 .255 .126 r
.62415 .28926 m .62613 .28726 L p .65729 .30726 L F P
0 g
s
.697 .215 .102 r
.62415 .28926 m .62031 .28576 L .62613 .28726 L closepath p F P
0 g
s
.417 .002 .143 r
.41571 .28725 m .44105 .28147 L .43458 .29368 L p F P
0 g
s
.417 .002 .143 r
.41005 .29764 m .41571 .28725 L p .43458 .29368 L F P
0 g
s
.35 0 .109 r
.41571 .28725 m .41005 .29764 L .38727 .3024 L p F P
0 g
s
.7 .435 .521 r
.68352 .3699 m .66579 .36938 L .6648 .34455 L p F P
0 g
s
0 0 .323 r
.50893 .5453 m .50704 .54927 L .50694 .57551 L p F P
0 g
s
.353 .193 .52 r
.80413 .78927 m .79607 .79493 L .79797 .82288 L p F P
0 g
s
.431 .249 .532 r
.79607 .79493 m .79797 .82288 L .7773 .83383 L p F P
0 g
s
.953 .91 .738 r
.79902 .68004 m .79551 .66429 L p .78202 .70032 L F P
0 g
s
.953 .91 .738 r
.78202 .70032 m .78631 .702 L .79902 .68004 L p F P
0 g
s
.968 .909 .701 r
.79824 .65886 m .79551 .66429 L .79902 .68004 L p F P
0 g
s
.115 .078 .534 r
.22557 .55905 m .22166 .54854 L .22396 .54433 L closepath p F P
0 g
s
.19 .076 .484 r
.82542 .73886 m .8124 .75323 L .81442 .78089 L p F P
0 g
s
.19 .076 .484 r
.8124 .75323 m .82542 .73886 L .82333 .71147 L p F P
0 g
s
.302 .156 .51 r
.80413 .78927 m .81442 .78089 L .8124 .75323 L p F P
0 g
s
.979 .86 .652 r
.81309 .60431 m .817 .61389 L .80754 .63862 L p F P
0 g
s
.565 .812 .991 r
.50471 .86352 m .52807 .85874 L .54062 .86724 L p F P
0 g
s
.69 .23 .156 r
.62031 .28576 m .62415 .28926 L .61894 .29639 L p F P
0 g
s
.69 .23 .156 r
.59024 .27953 m .62031 .28576 L p .61894 .29639 L F P
0 g
s
.3 .474 .864 r
.30639 .77738 m .32429 .78444 L .31069 .76259 L p F P
0 g
s
.3 .474 .864 r
.31069 .76259 m .30522 .76046 L .30639 .77738 L p F P
0 g
s
.259 .438 .848 r
.289 .75284 m .30522 .76046 L .30639 .77738 L p F P
0 g
s
.399 .633 .949 r
.40165 .84289 m .40957 .84383 L .39617 .82947 L p F P
0 g
s
.399 .633 .949 r
.39617 .82947 m .39277 .82907 L .40165 .84289 L p F P
0 g
s
.371 .616 .946 r
.37362 .82615 m .39277 .82907 L .40165 .84289 L p F P
0 g
s
.29 0 .266 r
.31019 .36697 m .31484 .35098 L .33513 .33987 L p F P
0 g
s
.214 0 .236 r
.31484 .35098 m .31019 .36697 L .29114 .37928 L p F P
0 g
s
.069 0 .449 r
.8258 .70779 m .82333 .71147 L .82542 .73886 L p F P
0 g
s
.119 0 .265 r
.26727 .41242 m .26973 .41022 L .27114 .40364 L closepath p F P
0 g
s
.78 .625 .063 r
.50167 .66338 m .50118 .65597 L .50132 .62914 L p F P
0 g
s
0 0 .048 r
.502 .61862 m .50132 .62914 L .50118 .65597 L p F P
0 g
s
.788 .525 .538 r
.61628 .90916 m .59079 .90357 L .59031 .87504 L p F P
0 g
s
.822 .553 .532 r
.57523 .87032 m .59031 .87504 L .59079 .90357 L p F P
0 g
s
.561 .067 .039 r
.55695 .27544 m .53974 .27434 L .52899 .26947 L p F P
0 g
s
.565 .095 .096 r
.53974 .27434 m .52555 .27391 L .52899 .26947 L closepath p F P
0 g
s
.518 .043 .068 r
.52899 .26947 m .52555 .27391 L .49586 .27459 L p F P
0 g
s
.431 .249 .532 r
.77907 .86207 m .7773 .83383 L .79797 .82288 L p F P
0 g
s
.498 .299 .54 r
.7773 .83383 m .77907 .86207 L .75665 .87077 L p F P
0 g
s
.197 .065 .464 r
.23485 .50268 m .23511 .48073 L .24956 .46455 L p F P
0 g
s
.132 0 .389 r
.25105 .4441 m .24956 .46455 L .23511 .48073 L p F P
0 g
s
.115 .003 .436 r
.23345 .50453 m .23485 .50268 L .23511 .48073 L p F P
0 g
s
.2 .248 .688 r
.23858 .62671 m .23201 .64467 L .24722 .66064 L p F P
0 g
s
.144 .185 .646 r
.23669 .61916 m .23858 .62671 L .23201 .64467 L p F P
0 g
s
.144 .185 .646 r
.22741 .6067 m .23669 .61916 L p .23201 .64467 L F P
0 g
s
.474 .02 .09 r
.47989 .27587 m .46769 .27713 L .46984 .27404 L closepath p F P
0 g
s
.417 0 .058 r
.46984 .27404 m .46769 .27713 L .44105 .28147 L p F P
0 g
s
.461 0 .034 r
.49586 .27459 m .47989 .27587 L .46984 .27404 L p F P
0 g
s
.457 .247 .505 r
.55531 .44836 m .55508 .42295 L .57651 .41217 L p F P
0 g
s
.369 .181 .489 r
.55508 .42295 m .55531 .44836 L .53602 .46149 L p F P
0 g
s
.497 .713 .967 r
.4686 .85598 m .44559 .857 L .43239 .84463 L p F P
0 g
s
.434 .684 .969 r
.40957 .84383 m .43239 .84463 L .44559 .857 L p F P
0 g
s
.835 .543 .496 r
.7584 .41272 m .74368 .4068 L .74215 .38167 L p F P
0 g
s
.797 .512 .507 r
.71713 .37447 m .74215 .38167 L .74368 .4068 L p F P
0 g
s
.867 .449 .226 r
.73671 .37022 m .73044 .3663 L .72274 .34872 L p F P
0 g
s
.85 .445 .27 r
.70044 .33687 m .72274 .34872 L .73044 .3663 L p F P
0 g
s
.826 .379 .169 r
.72274 .34872 m .70044 .33687 L .69619 .32958 L p F P
0 g
s
.753 .289 .146 r
.66439 .30973 m .65729 .30726 L .65995 .30439 L closepath p F P
0 g
s
0 0 .198 r
.83191 .62018 m .83121 .62771 L .83336 .65454 L p F P
0 g
s
0 0 .286 r
.83101 .6649 m .83336 .65454 L .83121 .62771 L p F P
0 g
s
.366 .013 .227 r
.35677 .32998 m .36223 .31555 L .38503 .30692 L p F P
0 g
s
.304 0 .123 r
.38727 .3024 m .38503 .30692 L .36223 .31555 L p F P
0 g
s
.299 0 .198 r
.36223 .31555 m .35677 .32998 L .33513 .33987 L p F P
0 g
s
.337 .525 .892 r
.34247 .80523 m .33788 .80387 L .32429 .78444 L p F P
0 g
s
.733 .893 .952 r
.6447 .83696 m .62311 .84828 L .61122 .84151 L p F P
0 g
s
.694 .886 .968 r
.58757 .85203 m .61122 .84151 L .62311 .84828 L p F P
0 g
s
0 0 .323 r
.50694 .57551 m .50885 .57156 L .50893 .5453 L p F P
0 g
s
.036 0 .392 r
.51974 .52938 m .50893 .5453 L .50885 .57156 L p F P
0 g
s
.036 0 .392 r
.50893 .5453 m .51974 .52938 L .51975 .5034 L p F P
0 g
s
.964 .657 .391 r
.80511 .47893 m .79226 .46472 L .79077 .44427 L p F P
0 g
s
.195 .049 .444 r
.52879 .49378 m .51975 .5034 L .51974 .52938 L p F P
0 g
s
.135 .059 .498 r
.23525 .51147 m .23609 .52634 L .22396 .54433 L p F P
0 g
s
.135 .059 .498 r
.23345 .50453 m .23525 .51147 L p .22396 .54433 L F P
0 g
s
.197 .137 .559 r
.22396 .54433 m .23609 .52634 L p .22888 .56644 L F P
0 g
s
.197 .137 .559 r
.22888 .56644 m .22557 .55905 L .22396 .54433 L p F P
0 g
s
.474 .059 .171 r
.43458 .29368 m .44105 .28147 L .46769 .27713 L p F P
0 g
s
.372 0 .156 r
.38503 .30692 m .38727 .3024 L .41005 .29764 L p F P
0 g
s
.718 .265 .174 r
.63449 .3003 m .61894 .29639 L .62415 .28926 L closepath p F P
0 g
s
.727 .255 .126 r
.65729 .30726 m .63449 .3003 L .62415 .28926 L p F P
0 g
s
.147 0 .334 r
.25105 .4441 m .26136 .43432 L .26727 .41242 L p F P
0 g
s
.19 0 .355 r
.26973 .41022 m .26727 .41242 L .26136 .43432 L p F P
0 g
s
.369 .181 .489 r
.53613 .4872 m .53602 .46149 L .55531 .44836 L p F P
0 g
s
.265 .102 .464 r
.52879 .49378 m .53613 .4872 L .53602 .46149 L p F P
0 g
s
.943 .919 .76 r
.7832 .70689 m .78202 .70032 L .78631 .702 L closepath p F P
0 g
s
.278 .018 .327 r
.2875 .39678 m .29114 .37928 L .31019 .36697 L p F P
0 g
s
.203 0 .299 r
.29114 .37928 m .2875 .39678 L .26973 .41022 L p F P
0 g
s
0 0 .394 r
.83316 .69204 m .8258 .70779 L .82791 .73521 L p F P
0 g
s
0 0 .394 r
.8258 .70779 m .83316 .69204 L .83101 .6649 L p F P
0 g
s
.069 0 .449 r
.82542 .73886 m .82791 .73521 L .8258 .70779 L p F P
0 g
s
.684 .441 .548 r
.66762 .91308 m .68029 .91286 L .68139 .9417 L p F P
0 g
s
.684 .441 .548 r
.68139 .9417 m .66864 .94191 L .66762 .91308 L p F P
0 g
s
.703 .455 .547 r
.64996 .91268 m .66762 .91308 L .66864 .94191 L p F P
0 g
s
.462 .664 .95 r
.43239 .84463 m .40957 .84383 L .39617 .82947 L p F P
0 g
s
.911 .532 .29 r
.77236 .41093 m .75524 .39766 L .74993 .37897 L p F P
0 g
s
.893 .521 .327 r
.73671 .37022 m .74993 .37897 L .75524 .39766 L p F P
0 g
s
.649 .413 .548 r
.68139 .9417 m .68029 .91286 L .70806 .91037 L p F P
0 g
s
.405 .6 .925 r
.39277 .82907 m .37362 .82615 L .36009 .80947 L p F P
0 g
s
.588 .348 .521 r
.60018 .40385 m .59964 .37871 L .62531 .3729 L p F P
0 g
s
.529 .302 .515 r
.59964 .37871 m .60018 .40385 L .57651 .41217 L p F P
0 g
s
.84 .953 .889 r
.71727 .7839 m .70065 .79831 L .69867 .80587 L p F P
0 g
s
.703 .455 .547 r
.66864 .94191 m .65085 .94152 L .64996 .91268 L p F P
0 g
s
.735 .481 .545 r
.62269 .91014 m .64996 .91268 L .65085 .94152 L p F P
0 g
s
.827 .942 .9 r
.6938 .80388 m .70065 .79831 L .69867 .80587 L closepath p F P
0 g
s
.799 .943 .92 r
.67024 .82092 m .6938 .80388 L .69867 .80587 L p F P
0 g
s
.9 .597 .465 r
.7891 .45527 m .77001 .44291 L .76829 .41748 L p F P
0 g
s
.9 .597 .465 r
.77001 .44291 m .7891 .45527 L .79097 .481 L p F P
0 g
s
.945 .637 .423 r
.77579 .43051 m .79077 .44427 L .79226 .46472 L p F P
0 g
s
.94 .595 .341 r
.79077 .44427 m .77579 .43051 L .77236 .41093 L p F P
0 g
s
.353 .193 .52 r
.79797 .82288 m .8061 .81726 L .80413 .78927 L p F P
0 g
s
.302 .156 .51 r
.81442 .78089 m .80413 .78927 L .8061 .81726 L p F P
0 g
s
.216 .042 .418 r
.26136 .43432 m .25105 .4441 L .24956 .46455 L p F P
0 g
s
.926 .916 .788 r
.7832 .70689 m .78202 .70032 L p .76279 .73385 L F P
0 g
s
.926 .916 .788 r
.76279 .73385 m .76367 .73426 L .7832 .70689 L p F P
0 g
s
.655 .189 .133 r
.58843 .28188 m .58413 .27857 L .59024 .27953 L closepath p F P
0 g
s
.69 .23 .156 r
.58843 .28188 m .59024 .27953 L p .61894 .29639 L F P
0 g
s
.857 .562 .487 r
.7584 .41272 m .76829 .41748 L .77001 .44291 L p F P
0 g
s
.921 .58 .376 r
.75524 .39766 m .77236 .41093 L .77579 .43051 L p F P
0 g
s
.337 .525 .892 r
.32429 .78444 m .33998 .78901 L .34247 .80523 L p F P
0 g
s
.368 .55 .901 r
.34247 .80523 m .36009 .80947 L .3465 .79055 L p F P
0 g
s
.368 .55 .901 r
.3465 .79055 m .33998 .78901 L .34247 .80523 L p F P
0 g
s
.498 .299 .54 r
.75828 .89933 m .75665 .87077 L .77907 .86207 L p F P
0 g
s
.557 .343 .545 r
.75665 .87077 m .75828 .89933 L .73403 .90587 L p F P
0 g
s
.942 .715 .244 r
.50654 .70636 m .50153 .69053 L .50167 .66338 L p F P
0 g
s
.993 .839 .585 r
.81711 .57485 m .81059 .59857 L .81309 .60431 L p F P
0 g
s
.979 .81 .604 r
.80841 .55992 m .81711 .57485 L .81059 .59857 L p F P
0 g
s
.989 .794 .55 r
.81711 .57485 m .80841 .55992 L .81292 .53696 L p F P
0 g
s
.298 .433 .829 r
.30522 .76046 m .289 .75284 L .27888 .73385 L p F P
0 g
s
.264 .044 .381 r
.26714 .42922 m .26973 .41022 L .2875 .39678 L p F P
0 g
s
.19 0 .355 r
.26136 .43432 m .26714 .42922 L .26973 .41022 L p F P
0 g
s
.649 .204 .18 r
.58413 .27857 m .58843 .28188 L .58359 .28982 L p F P
0 g
s
.649 .204 .18 r
.55695 .27544 m .58413 .27857 L p .58359 .28982 L F P
0 g
s
0 0 .286 r
.83336 .65454 m .83101 .6649 L .83316 .69204 L p F P
0 g
s
.822 .553 .532 r
.59079 .90357 m .57561 .89889 L .57523 .87032 L p F P
0 g
s
.842 .569 .527 r
.56494 .86651 m .57523 .87032 L .57561 .89889 L p F P
0 g
s
.813 .381 .216 r
.70044 .33687 m .69326 .33361 L .69619 .32958 L closepath p F P
0 g
s
.188 .2 .64 r
.23669 .61916 m .22741 .6067 L .2318 .59729 L closepath p F P
0 g
s
.13 .131 .591 r
.22741 .6067 m .2318 .59729 L .22692 .5698 L p F P
0 g
s
.733 .893 .952 r
.6457 .83536 m .6447 .83696 L p .61122 .84151 L F P
0 g
s
.74 .904 .951 r
.6447 .83696 m .6457 .83536 L .64667 .83589 L closepath p F P
0 g
s
.586 .783 .974 r
.52807 .85874 m .50471 .86352 L .49187 .85305 L p F P
0 g
s
.532 .763 .982 r
.4686 .85598 m .49187 .85305 L .50471 .86352 L p F P
0 g
s
.774 .907 .932 r
.6457 .83536 m .64667 .83589 L .67024 .82092 L p F P
0 g
s
.524 .108 .195 r
.46144 .28933 m .46769 .27713 L .47989 .27587 L p F P
0 g
s
.474 .059 .171 r
.46769 .27713 m .46144 .28933 L .43458 .29368 L p F P
0 g
s
.606 .381 .548 r
.70936 .93923 m .70806 .91037 L .73403 .90587 L p F P
0 g
s
.649 .413 .548 r
.70806 .91037 m .70936 .93923 L .68139 .9417 L p F P
0 g
s
.796 .356 .203 r
.69326 .33361 m .6748 .32601 L .66439 .30973 L p F P
0 g
s
.781 .357 .243 r
.65729 .30726 m .66439 .30973 L .6748 .32601 L p F P
0 g
s
.78 .625 .063 r
.50118 .65597 m .50167 .66338 L .50153 .69053 L p F P
0 g
s
.735 .481 .545 r
.65085 .94152 m .6234 .939 L .62269 .91014 L p F P
0 g
s
.761 .503 .542 r
.61628 .90916 m .62269 .91014 L .6234 .939 L p F P
0 g
s
.964 .866 .693 r
.80754 .63862 m .80117 .62338 L p .79175 .65479 L F P
0 g
s
.964 .866 .693 r
.79175 .65479 m .79824 .65886 L .80754 .63862 L p F P
0 g
s
.979 .86 .652 r
.8093 .60224 m .81309 .60431 L p .80754 .63862 L F P
0 g
s
.979 .86 .652 r
.80754 .63862 m .80117 .62338 L .8093 .60224 L p F P
0 g
s
.154 .116 .559 r
.22692 .5698 m .22557 .55905 L .22888 .56644 L closepath p F P
0 g
s
.52 .085 .154 r
.4929 .27971 m .47989 .27587 L .49586 .27459 L closepath p F P
0 g
s
.524 .108 .195 r
.47989 .27587 m .4929 .27971 L p .46144 .28933 L F P
0 g
s
.797 .512 .507 r
.74368 .4068 m .71849 .39963 L .71713 .37447 L p F P
0 g
s
.766 .488 .513 r
.71077 .3732 m .71713 .37447 L .71849 .39963 L p F P
0 g
s
.765 .897 .936 r
.63494 .82904 m .65127 .81914 L .6457 .83536 L closepath p F P
0 g
s
.774 .907 .932 r
.6587 .81442 m .65127 .81914 L .6457 .83536 L p F P
0 g
s
.774 .907 .932 r
.67024 .82092 m .6587 .81442 L p .6457 .83536 L F P
0 g
s
.733 .893 .952 r
.61122 .84151 m .63494 .82904 L .6457 .83536 L p F P
0 g
s
.649 .204 .18 r
.55257 .28227 m .55695 .27544 L p .58359 .28982 L F P
0 g
s
.612 .162 .159 r
.55257 .28227 m .53974 .27434 L .55695 .27544 L closepath p F P
0 g
s
.761 .503 .542 r
.6234 .939 m .61694 .93803 L .61628 .90916 L p F P
0 g
s
.788 .525 .538 r
.59079 .90357 m .61628 .90916 L .61694 .93803 L p F P
0 g
s
.982 .851 .635 r
.8093 .60224 m .81059 .59857 L .81309 .60431 L closepath p F P
0 g
s
.567 .135 .179 r
.49586 .27459 m .52555 .27391 L .5192 .28535 L p F P
0 g
s
.567 .135 .179 r
.4929 .27971 m .49586 .27459 L p .5192 .28535 L F P
0 g
s
.766 .488 .513 r
.71849 .39963 m .71208 .39835 L .71077 .3732 L p F P
0 g
s
.736 .464 .517 r
.68352 .3699 m .71077 .3732 L .71208 .39835 L p F P
0 g
s
.608 .178 .199 r
.53974 .27434 m .55257 .28227 L p .5192 .28535 L F P
0 g
s
.608 .178 .199 r
.5192 .28535 m .52555 .27391 L .53974 .27434 L p F P
0 g
s
.781 .357 .243 r
.6748 .32601 m .65127 .31785 L .65729 .30726 L p F P
0 g
s
.76 .33 .232 r
.63449 .3003 m .65729 .30726 L .65127 .31785 L p F P
0 g
s
0 0 .198 r
.83336 .65454 m .83407 .64706 L .83191 .62018 L p F P
0 g
s
.774 .572 .001 r
.82946 .60364 m .83191 .62018 L .83407 .64706 L p F P
0 g
s
.774 .572 .001 r
.83191 .62018 m .82946 .60364 L .82733 .57704 L p F P
0 g
s
.637 .387 .522 r
.62603 .39806 m .62531 .3729 L .65308 .36965 L p F P
0 g
s
.588 .348 .521 r
.62531 .3729 m .62603 .39806 L .60018 .40385 L p F P
0 g
s
.912 .924 .809 r
.76295 .73517 m .76279 .73385 L .76367 .73426 L closepath p F P
0 g
s
.424 .067 .252 r
.37972 .32133 m .38503 .30692 L .40911 .29958 L p F P
0 g
s
.372 0 .156 r
.41005 .29764 m .40911 .29958 L .38503 .30692 L p F P
0 g
s
.366 .013 .227 r
.38503 .30692 m .37972 .32133 L .35677 .32998 L p F P
0 g
s
.357 .045 .292 r
.3306 .35585 m .33513 .33987 L .35677 .32998 L p F P
0 g
s
.29 0 .266 r
.33513 .33987 m .3306 .35585 L .31019 .36697 L p F P
0 g
s
.895 .917 .829 r
.76295 .73517 m .76279 .73385 L p .73607 .75869 L F P
0 g
s
.895 .917 .829 r
.73607 .75869 m .7406 .76104 L .76295 .73517 L p F P
0 g
s
.178 .084 .503 r
.23525 .51147 m .23345 .50453 L .23485 .50268 L closepath p F P
0 g
s
.69 .23 .156 r
.61894 .29639 m .59984 .29246 L .58843 .28188 L p F P
0 g
s
.681 .24 .198 r
.59984 .29246 m .58359 .28982 L .58843 .28188 L closepath p F P
0 g
s
.803 .908 .913 r
.6938 .80388 m .67024 .82092 L .6587 .81442 L p F P
0 g
s
.842 .569 .527 r
.57561 .89889 m .56525 .8951 L .56494 .86651 L p F P
0 g
s
.88 .603 .514 r
.54462 .85639 m .56494 .86651 L .56525 .8951 L p F P
0 g
s
.971 .766 .568 r
.80213 .52239 m .81292 .53696 L .80841 .55992 L p F P
0 g
s
.213 .19 .614 r
.22888 .56644 m .22692 .5698 L .2318 .59729 L p F P
0 g
s
.857 .562 .487 r
.77001 .44291 m .76005 .43818 L .7584 .41272 L p F P
0 g
s
.835 .543 .496 r
.74368 .4068 m .7584 .41272 L .76005 .43818 L p F P
0 g
s
0 0 .048 r
.50118 .65597 m .50187 .64551 L .502 .61862 L p F P
0 g
s
0 0 .221 r
.50684 .60212 m .502 .61862 L .50187 .64551 L p F P
0 g
s
0 0 .221 r
.502 .61862 m .50684 .60212 L .50694 .57551 L p F P
0 g
s
.298 .433 .829 r
.27888 .73385 m .27933 .72928 L p .30522 .76046 L F P
0 g
s
.256 .392 .809 r
.27888 .73385 m .27552 .72712 L .27933 .72928 L closepath p F P
0 g
s
.909 .911 .809 r
.75298 .72846 m .76004 .7195 L .76279 .73385 L closepath p F P
0 g
s
.926 .916 .788 r
.77593 .69727 m .76004 .7195 L .76279 .73385 L p F P
0 g
s
.926 .916 .788 r
.78202 .70032 m .77593 .69727 L p .76279 .73385 L F P
0 g
s
.895 .917 .829 r
.76279 .73385 m .75298 .72846 L p .73607 .75869 L F P
0 g
s
.943 .669 .206 r
.82072 .56144 m .82733 .57704 L .82946 .60364 L p F P
0 g
s
.943 .669 .206 r
.82733 .57704 m .82072 .56144 L .81865 .53512 L p F P
0 g
s
.529 .302 .515 r
.5769 .43762 m .57651 .41217 L .60018 .40385 L p F P
0 g
s
.457 .247 .505 r
.57651 .41217 m .5769 .43762 L .55531 .44836 L p F P
0 g
s
.976 .672 .347 r
.81865 .53512 m .80788 .52053 L .8059 .4945 L p F P
0 g
s
.251 .139 .525 r
.23485 .50268 m .24937 .48658 L p .23895 .52287 L F P
0 g
s
.251 .139 .525 r
.23895 .52287 m .23525 .51147 L .23485 .50268 L p F P
0 g
s
.197 .065 .464 r
.24956 .46455 m .24937 .48658 L .23485 .50268 L p F P
0 g
s
.937 .908 .767 r
.77593 .69727 m .77989 .6912 L .78202 .70032 L closepath p F P
0 g
s
.953 .91 .738 r
.79551 .66429 m .77989 .6912 L .78202 .70032 L p F P
0 g
s
.893 .521 .327 r
.73393 .37789 m .73671 .37022 L p .75524 .39766 L F P
0 g
s
.884 .508 .324 r
.73393 .37789 m .73044 .3663 L .73671 .37022 L closepath p F P
0 g
s
.976 .672 .347 r
.80788 .52053 m .81865 .53512 L .82072 .56144 L p F P
0 g
s
.552 .736 .961 r
.49187 .85305 m .4686 .85598 L .4555 .84354 L p F P
0 g
s
.497 .713 .967 r
.43239 .84463 m .4555 .84354 L .4686 .85598 L p F P
0 g
s
.195 .049 .444 r
.51974 .52938 m .52885 .51982 L .52879 .49378 L p F P
0 g
s
.265 .102 .464 r
.53613 .4872 m .52879 .49378 L .52885 .51982 L p F P
0 g
s
.736 .464 .517 r
.71208 .39835 m .68465 .39507 L .68352 .3699 L p F P
0 g
s
.7 .435 .521 r
.66579 .36938 m .68352 .3699 L .68465 .39507 L p F P
0 g
s
.85 .445 .27 r
.73044 .3663 m .70804 .35446 L .70044 .33687 L p F P
0 g
s
.832 .438 .304 r
.69326 .33361 m .70044 .33687 L .70804 .35446 L p F P
0 g
s
.557 .343 .545 r
.73552 .93477 m .73403 .90587 L .75828 .89933 L p F P
0 g
s
.606 .381 .548 r
.73403 .90587 m .73552 .93477 L .70936 .93923 L p F P
0 g
s
.828 .908 .894 r
.70065 .79831 m .6938 .80388 L .68244 .79722 L p F P
0 g
s
.803 .908 .913 r
.6587 .81442 m .68244 .79722 L .6938 .80388 L p F P
0 g
s
.878 .923 .851 r
.73644 .76537 m .73607 .75869 L .7406 .76104 L closepath p F P
0 g
s
.678 .419 .522 r
.65308 .36965 m .66579 .36938 L .6668 .39455 L p F P
0 g
s
.678 .419 .522 r
.6668 .39455 m .654 .39483 L .65308 .36965 L p F P
0 g
s
.637 .387 .522 r
.65308 .36965 m .654 .39483 L .62603 .39806 L p F P
0 g
s
.368 .513 .871 r
.33998 .78901 m .32429 .78444 L .31069 .76259 L p F P
0 g
s
.862 .914 .865 r
.73644 .76537 m .71727 .7839 L .70612 .7777 L p F P
0 g
s
.862 .914 .865 r
.73607 .75869 m .73644 .76537 L p .70612 .7777 L F P
0 g
s
.828 .908 .894 r
.68244 .79722 m .7012 .78197 L .70065 .79831 L p F P
0 g
s
.841 .917 .885 r
.70612 .7777 m .7012 .78197 L .70065 .79831 L p F P
0 g
s
.841 .917 .885 r
.70065 .79831 m .71727 .7839 L .70612 .7777 L p F P
0 g
s
.7 .435 .521 r
.68465 .39507 m .6668 .39455 L .66579 .36938 L p F P
0 g
s
.293 .39 .791 r
.27933 .72928 m .27552 .72712 L .2622 .69734 L p F P
0 g
s
0 0 .323 r
.50885 .57156 m .50694 .57551 L .50684 .60212 L p F P
0 g
s
.353 .193 .52 r
.8061 .81726 m .79797 .82288 L .79989 .85121 L p F P
0 g
s
.431 .249 .532 r
.79797 .82288 m .79989 .85121 L .77907 .86207 L p F P
0 g
s
.958 .874 .712 r
.79551 .66429 m .79175 .65479 L .79824 .65886 L closepath p F P
0 g
s
.704 .853 .954 r
.61122 .84151 m .58757 .85203 L .5753 .84335 L p F P
0 g
s
.665 .844 .968 r
.55161 .85202 m .5753 .84335 L .58757 .85203 L p F P
0 g
s
.417 .002 .143 r
.43458 .29368 m .4186 .29731 L .41005 .29764 L p F P
0 g
s
.43 .033 .183 r
.4186 .29731 m .40911 .29958 L .41005 .29764 L closepath p F P
0 g
s
.213 .19 .614 r
.2318 .59729 m .24012 .58324 L .22888 .56644 L p F P
0 g
s
.247 .202 .608 r
.23891 .55176 m .22888 .56644 L .24012 .58324 L p F P
0 g
s
.197 .137 .559 r
.23609 .52634 m .23891 .55176 L .22888 .56644 L p F P
0 g
s
.216 .042 .418 r
.24956 .46455 m .25992 .45481 L .26136 .43432 L p F P
0 g
s
.248 .067 .429 r
.26714 .42922 m .26136 .43432 L .25992 .45481 L p F P
0 g
s
.19 .076 .484 r
.81442 .78089 m .82754 .76663 L .82542 .73886 L p F P
0 g
s
.19 .076 .484 r
.82754 .76663 m .81442 .78089 L .81646 .80894 L p F P
0 g
s
.302 .156 .51 r
.8061 .81726 m .81646 .80894 L .81442 .78089 L p F P
0 g
s
.967 .821 .647 r
.81059 .59857 m .8093 .60224 L .79876 .59236 L p F P
0 g
s
.967 .821 .647 r
.79876 .59236 m .8018 .58375 L .81059 .59857 L p F P
0 g
s
.979 .81 .604 r
.81059 .59857 m .8018 .58375 L .80841 .55992 L p F P
0 g
s
.069 0 .449 r
.82791 .73521 m .82542 .73886 L .82754 .76663 L p F P
0 g
s
.941 .875 .743 r
.79175 .65479 m .79551 .66429 L .77989 .6912 L p F P
0 g
s
.344 .073 .351 r
.30665 .38449 m .31019 .36697 L .3306 .35585 L p F P
0 g
s
.278 .018 .327 r
.31019 .36697 m .30665 .38449 L .2875 .39678 L p F P
0 g
s
.219 .121 .524 r
.23609 .52634 m .23525 .51147 L .23895 .52287 L closepath p F P
0 g
s
.78 .625 .063 r
.50153 .69053 m .50104 .68316 L .50118 .65597 L p F P
0 g
s
0 0 .048 r
.50187 .64551 m .50118 .65597 L .50104 .68316 L p F P
0 g
s
.788 .525 .538 r
.61694 .93803 m .59128 .93249 L .59079 .90357 L p F P
0 g
s
.822 .553 .532 r
.57561 .89889 m .59079 .90357 L .59128 .93249 L p F P
0 g
s
.586 .783 .974 r
.49187 .85305 m .51534 .84819 L .52807 .85874 L p F P
0 g
s
.832 .438 .304 r
.70804 .35446 m .68839 .34562 L .69326 .33361 L p F P
0 g
s
.817 .419 .297 r
.6748 .32601 m .69326 .33361 L .68839 .34562 L p F P
0 g
s
.427 .616 .93 r
.39617 .82947 m .39277 .82907 L .39113 .82333 L closepath p F P
0 g
s
.405 .6 .925 r
.38269 .81282 m .39113 .82333 L .39277 .82907 L p F P
0 g
s
.405 .6 .925 r
.36009 .80947 m .38269 .81282 L p .39277 .82907 L F P
0 g
s
.431 .249 .532 r
.78087 .89071 m .77907 .86207 L .79989 .85121 L p F P
0 g
s
.498 .299 .54 r
.77907 .86207 m .78087 .89071 L .75828 .89933 L p F P
0 g
s
.745 .331 .266 r
.61894 .29639 m .63449 .3003 L .6458 .31619 L p F P
0 g
s
.76 .33 .232 r
.65127 .31785 m .6458 .31619 L .63449 .3003 L p F P
0 g
s
.863 .496 .354 r
.73044 .3663 m .73393 .37789 L .73267 .38312 L p F P
0 g
s
.863 .496 .354 r
.70804 .35446 m .73044 .3663 L p .73267 .38312 L F P
0 g
s
.517 .689 .946 r
.4555 .84354 m .43239 .84463 L .41907 .83019 L p F P
0 g
s
.462 .664 .95 r
.39617 .82947 m .41907 .83019 L .43239 .84463 L p F P
0 g
s
.962 .827 .663 r
.80117 .62338 m .8093 .60224 L .79876 .59236 L p F P
0 g
s
.262 .25 .657 r
.2318 .59729 m .24012 .58324 L p .24032 .62318 L F P
0 g
s
.262 .25 .657 r
.24032 .62318 m .23669 .61916 L .2318 .59729 L p F P
0 g
s
.298 .433 .829 r
.27933 .72928 m .29713 .73751 L p .30522 .76046 L F P
0 g
s
.327 .427 .811 r
.29713 .73751 m .27933 .72928 L .28421 .71054 L closepath p F P
0 g
s
.293 .39 .791 r
.28365 .70929 m .28421 .71054 L .27933 .72928 L p F P
0 g
s
.293 .39 .791 r
.2622 .69734 m .28365 .70929 L p .27933 .72928 L F P
0 g
s
.457 .247 .505 r
.55555 .47413 m .55531 .44836 L .5769 .43762 L p F P
0 g
s
.369 .181 .489 r
.55531 .44836 m .55555 .47413 L .53613 .4872 L p F P
0 g
s
.475 .114 .272 r
.40398 .31397 m .40911 .29958 L .4186 .29731 L p F P
0 g
s
.424 .067 .252 r
.40911 .29958 m .40398 .31397 L .37972 .32133 L p F P
0 g
s
.429 .583 .903 r
.38269 .81282 m .36009 .80947 L .3465 .79055 L p F P
0 g
s
.9 .597 .465 r
.79097 .481 m .77175 .4687 L .77001 .44291 L p F P
0 g
s
.9 .597 .465 r
.77175 .4687 m .79097 .481 L .79148 .48814 L p F P
0 g
s
.937 .692 .543 r
.79148 .48814 m .78913 .50831 L p .78345 .49205 L F P
0 g
s
.9 .597 .465 r
.79148 .48814 m .79285 .50709 L p .78435 .49161 L F P
0 g
s
.9 .597 .465 r
.78435 .49161 m .77175 .4687 L .79148 .48814 L F
.937 .692 .543 r
.77659 .47241 m .79172 .48606 L .79148 .48814 L p F P
0 g
s
.9 .597 .465 r
.77351 .49485 m .77175 .4687 L p .78435 .49161 L F P
0 g
s
.937 .692 .543 r
.78913 .50831 m .77533 .496 L p .78345 .49205 L F P
0 g
s
.9 .597 .465 r
.79285 .50709 m .77533 .496 L p .78435 .49161 L F P
0 g
s
.9 .597 .465 r
.77533 .496 m .77351 .49485 L p .78435 .49161 L F P
0 g
s
.937 .692 .543 r
.7739 .49472 m .77659 .47241 L p .78345 .49205 L F P
0 g
s
.937 .692 .543 r
.77533 .496 m .7739 .49472 L p .78345 .49205 L F P
0 g
s
.937 .692 .543 r
.78345 .49205 m .77659 .47241 L .79148 .48814 L F
.943 .669 .489 r
.77721 .451 m .79226 .46472 L .79172 .48606 L p F P
0 g
s
.945 .637 .423 r
.79226 .46472 m .77721 .451 L .77579 .43051 L p F P
0 g
s
.835 .543 .496 r
.76005 .43818 m .74523 .43227 L .74368 .4068 L p F P
0 g
s
.797 .512 .507 r
.71849 .39963 m .74368 .4068 L .74523 .43227 L p F P
0 g
s
.255 .344 .763 r
.2622 .69734 m .26022 .69597 L .26079 .69385 L closepath p F P
0 g
s
.21 .296 .735 r
.24917 .66227 m .24722 .66064 L p .26022 .69597 L F P
0 g
s
.21 .296 .735 r
.26022 .69597 m .26079 .69385 L .24917 .66227 L p F P
0 g
s
.271 .121 .486 r
.25992 .45481 m .24956 .46455 L .24937 .48658 L p F P
0 g
s
0 0 .198 r
.83407 .64706 m .83336 .65454 L .83554 .68174 L p F P
0 g
s
0 0 .286 r
.83316 .69204 m .83554 .68174 L .83336 .65454 L p F P
0 g
s
.79418 .48498 m
.79829 .48277 L
s
.78205 .49152 m
.78815 .48823 L
s
0 0 .323 r
.50684 .60212 m .50876 .59819 L .50885 .57156 L p F P
0 g
s
.036 0 .392 r
.51974 .55573 m .50885 .57156 L .50876 .59819 L p F P
0 g
s
.036 0 .392 r
.50885 .57156 m .51974 .55573 L .51974 .52938 L p F P
0 g
s
.921 .58 .376 r
.77579 .43051 m .75859 .41727 L .75524 .39766 L p F P
0 g
s
.899 .564 .401 r
.7359 .38494 m .75524 .39766 L .75859 .41727 L p F P
0 g
s
.893 .521 .327 r
.75524 .39766 m .7359 .38494 L .73393 .37789 L p F P
0 g
s
.482 .643 .928 r
.40563 .81368 m .41907 .83019 L .39617 .82947 L p F P
0 g
s
.482 .643 .928 r
.38983 .81324 m .40563 .81368 L p .39617 .82947 L F P
0 g
s
.482 .643 .928 r
.39617 .82947 m .39113 .82333 L .38983 .81324 L p F P
0 g
s
.923 .617 .446 r
.75859 .41727 m .77579 .43051 L .77721 .451 L p F P
0 g
s
.567 .152 .215 r
.50572 .28566 m .48958 .28644 L .4929 .27971 L closepath p F P
0 g
s
.524 .108 .195 r
.4929 .27971 m .48958 .28644 L .46144 .28933 L p F P
0 g
s
.567 .135 .179 r
.5192 .28535 m .50572 .28566 L .4929 .27971 L p F P
0 g
s
.195 .049 .444 r
.52885 .51982 m .51974 .52938 L .51974 .55573 L p F P
0 g
s
.33 .098 .403 r
.285 .41581 m .2875 .39678 L .30665 .38449 L p F P
0 g
s
.264 .044 .381 r
.2875 .39678 m .285 .41581 L .26714 .42922 L p F P
0 g
s
.331 .466 .845 r
.31069 .76259 m .30522 .76046 L .30594 .75411 L closepath p F P
0 g
s
.298 .433 .829 r
.29713 .73751 m .30594 .75411 L .30522 .76046 L p F P
0 g
s
.469 .095 .245 r
.43291 .298 m .4186 .29731 L .43458 .29368 L closepath p F P
0 g
s
.475 .114 .272 r
.4186 .29731 m .43291 .298 L p .40398 .31397 L F P
0 g
s
.321 .386 .773 r
.27038 .67639 m .28365 .70929 L .2622 .69734 L p F P
0 g
s
.321 .386 .773 r
.26807 .67512 m .27038 .67639 L p .2622 .69734 L F P
0 g
s
.321 .386 .773 r
.2622 .69734 m .26079 .69385 L .26807 .67512 L p F P
0 g
s
.369 .181 .489 r
.53623 .51326 m .53613 .4872 L .55555 .47413 L p F P
0 g
s
.265 .102 .464 r
.52885 .51982 m .53623 .51326 L .53613 .4872 L p F P
0 g
s
.314 .119 .449 r
.26573 .44972 m .26714 .42922 L .285 .41581 L p F P
0 g
s
.248 .067 .429 r
.25992 .45481 m .26573 .44972 L .26714 .42922 L p F P
0 g
s
.415 .096 .314 r
.35237 .34595 m .35677 .32998 L .37972 .32133 L p F P
0 g
s
.357 .045 .292 r
.35677 .32998 m .35237 .34595 L .3306 .35585 L p F P
0 g
s
0 0 .394 r
.83534 .71956 m .82791 .73521 L .83005 .763 L p F P
0 g
s
0 0 .394 r
.82791 .73521 m .83534 .71956 L .83316 .69204 L p F P
0 g
s
.069 0 .449 r
.82754 .76663 m .83005 .763 L .82791 .73521 L p F P
0 g
s
.285 .345 .749 r
.26079 .69385 m .24917 .66227 L .26807 .67512 L closepath p F P
0 g
s
.684 .441 .548 r
.66864 .94191 m .68139 .9417 L .68251 .97094 L p F P
0 g
s
.684 .441 .548 r
.68251 .97094 m .66967 .97115 L .66864 .94191 L p F P
0 g
s
.703 .455 .547 r
.65085 .94152 m .66864 .94191 L .66967 .97115 L p F P
0 g
s
.246 .301 .722 r
.24917 .66227 m .24722 .66064 L .24797 .65866 L closepath p F P
0 g
s
.2 .248 .688 r
.24722 .66064 m .24797 .65866 L .23858 .62671 L p F P
0 g
s
.228 .242 .667 r
.23858 .62671 m .23669 .61916 L .24032 .62318 L closepath p F P
0 g
s
.649 .413 .548 r
.68251 .97094 m .68139 .9417 L .70936 .93923 L p F P
0 g
s
.745 .331 .266 r
.6458 .31619 m .6134 .30808 L .61894 .29639 L p F P
0 g
s
.72 .303 .254 r
.59984 .29246 m .61894 .29639 L .6134 .30808 L p F P
0 g
s
.588 .348 .521 r
.60074 .42934 m .60018 .40385 L .62603 .39806 L p F P
0 g
s
.529 .302 .515 r
.60018 .40385 m .60074 .42934 L .5769 .43762 L p F P
0 g
s
.703 .455 .547 r
.66967 .97115 m .65176 .97076 L .65085 .94152 L p F P
0 g
s
.735 .481 .545 r
.6234 .939 m .65085 .94152 L .65176 .97076 L p F P
0 g
s
.737 .859 .938 r
.63494 .82904 m .61122 .84151 L .59909 .83272 L p F P
0 g
s
.704 .853 .954 r
.5753 .84335 m .59909 .83272 L .61122 .84151 L p F P
0 g
s
.353 .193 .52 r
.79989 .85121 m .80809 .84564 L .8061 .81726 L p F P
0 g
s
.302 .156 .51 r
.81646 .80894 m .8061 .81726 L .80809 .84564 L p F P
0 g
s
.275 .298 .704 r
.24797 .65866 m .23858 .62671 L .24032 .62318 L p F P
0 g
s
.88 .91 .845 r
.72967 .75495 m .73479 .74949 L .73607 .75869 L closepath p F P
0 g
s
.895 .917 .829 r
.75298 .72846 m .73479 .74949 L .73607 .75869 L p F P
0 g
s
.862 .914 .865 r
.70612 .7777 m .72967 .75495 L .73607 .75869 L p F P
0 g
s
.498 .299 .54 r
.75994 .92829 m .75828 .89933 L .78087 .89071 L p F P
0 g
s
.557 .343 .545 r
.75828 .89933 m .75994 .92829 L .73552 .93477 L p F P
0 g
s
.96 .78 .615 r
.79753 .54545 m .80841 .55992 L .8018 .58375 L p F P
0 g
s
.971 .766 .568 r
.80841 .55992 m .79753 .54545 L .80213 .52239 L p F P
0 g
s
0 0 .286 r
.83554 .68174 m .83316 .69204 L .83534 .71956 L p F P
0 g
s
.271 .19 .578 r
.23895 .52287 m .23609 .52634 L .23891 .55176 L p F P
0 g
s
.822 .553 .532 r
.59128 .93249 m .57599 .92785 L .57561 .89889 L p F P
0 g
s
.842 .569 .527 r
.56525 .8951 m .57561 .89889 L .57599 .92785 L p F P
0 g
s
.312 .344 .733 r
.26807 .67512 m .24917 .66227 L .24797 .65866 L p F P
0 g
s
.312 .344 .733 r
.24797 .65866 m .25784 .63903 L p .26807 .67512 L F P
0 g
s
.275 .298 .704 r
.25745 .63769 m .25784 .63903 L .24797 .65866 L p F P
0 g
s
.275 .298 .704 r
.24032 .62318 m .25745 .63769 L p .24797 .65866 L F P
0 g
s
.649 .204 .18 r
.58359 .28982 m .55855 .28695 L .55257 .28227 L p F P
0 g
s
.642 .215 .217 r
.55855 .28695 m .55043 .2863 L .55257 .28227 L closepath p F P
0 g
s
.608 .178 .199 r
.55257 .28227 m .55043 .2863 L .5192 .28535 L p F P
0 g
s
.857 .562 .487 r
.76005 .43818 m .77001 .44291 L .77175 .4687 L p F P
0 g
s
.519 .142 .266 r
.43458 .29368 m .46144 .28933 L .45629 .30321 L p F P
0 g
s
.519 .142 .266 r
.43291 .298 m .43458 .29368 L p .45629 .30321 L F P
0 g
s
.925 .874 .768 r
.77989 .6912 m .77593 .69727 L .76516 .6892 L p F P
0 g
s
.925 .874 .768 r
.76516 .6892 m .77373 .67611 L .77989 .6912 L p F P
0 g
s
.941 .875 .743 r
.78779 .65194 m .79175 .65479 L p .77989 .6912 L F P
0 g
s
.941 .875 .743 r
.77989 .6912 m .77373 .67611 L .78779 .65194 L p F P
0 g
s
.599 .754 .952 r
.51534 .84819 m .49187 .85305 L .47886 .84053 L p F P
0 g
s
.552 .736 .961 r
.4555 .84354 m .47886 .84053 L .49187 .85305 L p F P
0 g
s
.466 .631 .925 r
.39113 .82333 m .38269 .81282 L .38983 .81324 L closepath p F P
0 g
s
.606 .381 .548 r
.71067 .9685 m .70936 .93923 L .73552 .93477 L p F P
0 g
s
.649 .413 .548 r
.70936 .93923 m .71067 .9685 L .68251 .97094 L p F P
0 g
s
.88 .603 .514 r
.56525 .8951 m .54479 .88507 L .54462 .85639 L p F P
0 g
s
.923 .643 .492 r
.52802 .84503 m .54462 .85639 L .54479 .88507 L p F P
0 g
s
.52807 .84524 m
.52812 .84527 L
s
.78 .625 .063 r
.50104 .68316 m .50153 .69053 L .5014 .71806 L p F P
0 g
s
.817 .419 .297 r
.68839 .34562 m .68292 .34338 L .6748 .32601 L p F P
0 g
s
.798 .413 .325 r
.65127 .31785 m .6748 .32601 L .68292 .34338 L p F P
0 g
s
.368 .513 .871 r
.31069 .76259 m .33289 .76893 L p .33998 .78901 L F P
0 g
s
.392 .501 .85 r
.31928 .74451 m .33289 .76893 L .31069 .76259 L p F P
0 g
s
.392 .501 .85 r
.30907 .74166 m .31928 .74451 L p .31069 .76259 L F P
0 g
s
.392 .501 .85 r
.31069 .76259 m .30594 .75411 L .30907 .74166 L p F P
0 g
s
.735 .481 .545 r
.65176 .97076 m .62411 .96827 L .6234 .939 L p F P
0 g
s
.761 .503 .542 r
.61694 .93803 m .6234 .939 L .62411 .96827 L p F P
0 g
s
.72 .303 .254 r
.6134 .30808 m .61227 .30785 L .59984 .29246 L p F P
0 g
s
.707 .305 .284 r
.58359 .28982 m .59984 .29246 L .61227 .30785 L p F P
0 g
s
.914 .879 .786 r
.76004 .7195 m .77593 .69727 L .76516 .6892 L p F P
0 g
s
.673 .811 .949 r
.5753 .84335 m .55161 .85202 L .539 .84139 L p F P
0 g
s
.797 .512 .507 r
.74523 .43227 m .71987 .42514 L .71849 .39963 L p F P
0 g
s
.766 .488 .513 r
.71208 .39835 m .71849 .39963 L .71987 .42514 L p F P
0 g
s
.964 .866 .693 r
.80117 .62338 m .78931 .6491 L .79175 .65479 L p F P
0 g
s
.948 .832 .697 r
.79247 .60861 m .80117 .62338 L .78931 .6491 L p F P
0 g
s
.962 .827 .663 r
.79876 .59236 m .79247 .60861 L .80117 .62338 L p F P
0 g
s
.368 .513 .871 r
.33289 .76893 m .34055 .78132 L .33998 .78901 L p F P
0 g
s
.394 .537 .881 r
.3465 .79055 m .33998 .78901 L .34055 .78132 L closepath p F P
0 g
s
.302 .3 .691 r
.25745 .63769 m .24032 .62318 L .24953 .60792 L closepath p F P
0 g
s
.262 .25 .657 r
.24523 .58879 m .24953 .60792 L .24032 .62318 L p F P
0 g
s
.262 .25 .657 r
.24012 .58324 m .24523 .58879 L p .24032 .62318 L F P
0 g
s
.761 .503 .542 r
.62411 .96827 m .61761 .9673 L .61694 .93803 L p F P
0 g
s
.788 .525 .538 r
.59128 .93249 m .61694 .93803 L .61761 .9673 L p F P
0 g
s
.873 .509 .355 r
.7359 .38494 m .73267 .38312 L .73393 .37789 L closepath p F P
0 g
s
.766 .863 .921 r
.65127 .81914 m .63494 .82904 L .62297 .82014 L p F P
0 g
s
.737 .859 .938 r
.59909 .83272 m .62297 .82014 L .63494 .82904 L p F P
0 g
s
.251 .139 .525 r
.24937 .48658 m .25052 .51018 L .23895 .52287 L p F P
0 g
s
.271 .19 .578 r
.23891 .55176 m .2487 .53998 L .23895 .52287 L p F P
0 g
s
.296 .2 .574 r
.25052 .51018 m .23895 .52287 L .2487 .53998 L p F P
0 g
s
.766 .488 .513 r
.71987 .42514 m .71342 .42387 L .71208 .39835 L p F P
0 g
s
.736 .464 .517 r
.68465 .39507 m .71208 .39835 L .71342 .42387 L p F P
0 g
s
0 0 .198 r
.83554 .68174 m .83626 .67431 L .83407 .64706 L p F P
0 g
s
.774 .572 .001 r
.83162 .63061 m .83407 .64706 L .83626 .67431 L p F P
0 g
s
.774 .572 .001 r
.83407 .64706 m .83162 .63061 L .82946 .60364 L p F P
0 g
s
.637 .387 .522 r
.62677 .42357 m .62603 .39806 L .654 .39483 L p F P
0 g
s
.588 .348 .521 r
.62603 .39806 m .62677 .42357 L .60074 .42934 L p F P
0 g
s
.95 .737 .58 r
.78913 .50831 m .80213 .52239 L .79753 .54545 L p F P
0 g
s
.68 .275 .272 r
.55855 .28695 m .58359 .28982 L .57841 .30239 L p F P
0 g
s
.707 .305 .284 r
.61227 .30785 m .57841 .30239 L .58359 .28982 L p F P
0 g
s
.949 .868 .725 r
.78779 .65194 m .78931 .6491 L .79175 .65479 L closepath p F P
0 g
s
.365 .473 .837 r
.30594 .75411 m .29713 .73751 L .30907 .74166 L closepath p F P
0 g
s
.842 .569 .527 r
.57599 .92785 m .56556 .9241 L .56525 .8951 L p F P
0 g
s
.88 .603 .514 r
.54479 .88507 m .56525 .8951 L .56556 .9241 L p F P
0 g
s
.403 .123 .37 r
.32718 .37338 m .3306 .35585 L .35237 .34595 L p F P
0 g
s
.344 .073 .351 r
.3306 .35585 m .32718 .37338 L .30665 .38449 L p F P
0 g
s
.562 .184 .283 r
.45629 .30321 m .46144 .28933 L .48958 .28644 L p F P
0 g
s
.271 .121 .486 r
.24937 .48658 m .26301 .47388 L .25992 .45481 L p F P
0 g
s
.296 .137 .489 r
.26573 .44972 m .25992 .45481 L .26301 .47388 L p F P
0 g
s
.857 .562 .487 r
.77175 .4687 m .76173 .46399 L .76005 .43818 L p F P
0 g
s
.835 .543 .496 r
.74523 .43227 m .76005 .43818 L .76173 .46399 L p F P
0 g
s
0 0 .048 r
.50104 .68316 m .50173 .67277 L .50187 .64551 L p F P
0 g
s
0 0 .221 r
.50674 .6291 m .50187 .64551 L .50173 .67277 L p F P
0 g
s
0 0 .221 r
.50187 .64551 m .50674 .6291 L .50684 .60212 L p F P
0 g
s
.943 .669 .206 r
.82282 .58812 m .82946 .60364 L .83162 .63061 L p F P
0 g
s
.943 .669 .206 r
.82946 .60364 m .82282 .58812 L .82072 .56144 L p F P
0 g
s
.529 .302 .515 r
.57729 .46343 m .5769 .43762 L .60074 .42934 L p F P
0 g
s
.457 .247 .505 r
.5769 .43762 m .57729 .46343 L .55555 .47413 L p F P
0 g
s
.466 .142 .332 r
.37548 .33731 m .37972 .32133 L .40398 .31397 L p F P
0 g
s
.415 .096 .314 r
.37972 .32133 m .37548 .33731 L .35237 .34595 L p F P
0 g
s
.976 .672 .347 r
.82072 .56144 m .80989 .54693 L .80788 .52053 L p F P
0 g
s
.945 .637 .424 r
.79285 .50709 m .80788 .52053 L .80989 .54693 L p F P
0 g
s
.565 .709 .939 r
.47886 .84053 m .4555 .84354 L .44225 .82902 L p F P
0 g
s
.517 .689 .946 r
.41907 .83019 m .44225 .82902 L .4555 .84354 L p F P
0 g
s
.863 .496 .354 r
.73267 .38312 m .71352 .37307 L .70804 .35446 L p F P
0 g
s
.842 .484 .377 r
.68839 .34562 m .70804 .35446 L .71352 .37307 L p F P
0 g
s
.766 .863 .921 r
.65135 .80901 m .65127 .81914 L p .62297 .82014 L F P
0 g
s
.775 .871 .918 r
.65127 .81914 m .65135 .80901 L .6587 .81442 L closepath p F P
0 g
s
.899 .876 .805 r
.76004 .7195 m .75298 .72846 L .74196 .72001 L p F P
0 g
s
.899 .876 .805 r
.74196 .72001 m .75426 .70442 L .76004 .7195 L p F P
0 g
s
.914 .879 .786 r
.76516 .6892 m .75426 .70442 L .76004 .7195 L p F P
0 g
s
.519 .142 .266 r
.45629 .30321 m .45403 .30358 L .43291 .298 L p F P
0 g
s
.52 .156 .289 r
.45403 .30358 m .4295 .30792 L .43291 .298 L closepath p F P
0 g
s
.475 .114 .272 r
.43291 .298 m .4295 .30792 L .40398 .31397 L p F P
0 g
s
.976 .672 .347 r
.80989 .54693 m .82072 .56144 L .82282 .58812 L p F P
0 g
s
.195 .049 .444 r
.51974 .55573 m .5289 .54621 L .52885 .51982 L p F P
0 g
s
.265 .102 .464 r
.53623 .51326 m .52885 .51982 L .5289 .54621 L p F P
0 g
s
.317 .188 .541 r
.25052 .51018 m .24937 .48658 L .26301 .47388 L p F P
0 g
s
.736 .464 .517 r
.71342 .42387 m .6858 .42059 L .68465 .39507 L p F P
0 g
s
.7 .435 .521 r
.6668 .39455 m .68465 .39507 L .6858 .42059 L p F P
0 g
s
.557 .343 .545 r
.73702 .96408 m .73552 .93477 L .75994 .92829 L p F P
0 g
s
.606 .381 .548 r
.73552 .93477 m .73702 .96408 L .71067 .9685 L p F P
0 g
s
.429 .583 .903 r
.3465 .79055 m .36913 .79381 L .38269 .81282 L p F P
0 g
s
.448 .566 .881 r
.35551 .77253 m .36913 .79381 L .3465 .79055 L p F P
0 g
s
.448 .566 .881 r
.34302 .7708 m .35551 .77253 L p .3465 .79055 L F P
0 g
s
.448 .566 .881 r
.3465 .79055 m .34055 .78132 L .34302 .7708 L p F P
0 g
s
.68 .275 .272 r
.57841 .30239 m .5724 .30171 L .55855 .28695 L p F P
0 g
s
.669 .279 .298 r
.55043 .2863 m .55855 .28695 L .5724 .30171 L p F P
0 g
s
.678 .419 .522 r
.654 .39483 m .6668 .39455 L .66782 .42008 L p F P
0 g
s
.678 .419 .522 r
.66782 .42008 m .65493 .42035 L .654 .39483 L p F P
0 g
s
.637 .387 .522 r
.654 .39483 m .65493 .42035 L .62677 .42357 L p F P
0 g
s
.943 .669 .489 r
.79172 .48606 m .77659 .47241 L .77721 .451 L p F P
0 g
s
.801 .872 .9 r
.65135 .80901 m .6587 .81442 L .68244 .79722 L p F P
0 g
s
.7 .435 .521 r
.6858 .42059 m .66782 .42008 L .6668 .39455 L p F P
0 g
s
0 0 .323 r
.50876 .59819 m .50684 .60212 L .50674 .6291 L p F P
0 g
s
.599 .22 .297 r
.48464 .30032 m .48958 .28644 L .50572 .28566 L p F P
0 g
s
.562 .184 .283 r
.48958 .28644 m .48464 .30032 L .45629 .30321 L p F P
0 g
s
.885 .88 .824 r
.73479 .74949 m .75298 .72846 L .74196 .72001 L p F P
0 g
s
.353 .193 .52 r
.80809 .84564 m .79989 .85121 L .80185 .87994 L p F P
0 g
s
.431 .249 .532 r
.79989 .85121 m .80185 .87994 L .78087 .89071 L p F P
0 g
s
.669 .279 .298 r
.5724 .30171 m .54553 .29959 L .55043 .2863 L p F P
0 g
s
.639 .248 .286 r
.5192 .28535 m .55043 .2863 L .54553 .29959 L p F P
0 g
s
.313 .248 .622 r
.24321 .57879 m .23891 .55176 L .2487 .53998 L p F P
0 g
s
.247 .202 .608 r
.24012 .58324 m .24321 .57879 L .23891 .55176 L p F P
0 g
s
.604 .212 .273 r
.51631 .2928 m .50572 .28566 L .5192 .28535 L closepath p F P
0 g
s
.599 .22 .297 r
.50572 .28566 m .51631 .2928 L p .48464 .30032 L F P
0 g
s
.19 .076 .484 r
.82969 .79478 m .81646 .80894 L .81853 .83739 L p F P
0 g
s
.19 .076 .484 r
.81646 .80894 m .82969 .79478 L .82754 .76663 L p F P
0 g
s
.302 .156 .51 r
.80809 .84564 m .81853 .83739 L .81646 .80894 L p F P
0 g
s
.639 .248 .286 r
.51631 .2928 m .5192 .28535 L p .54553 .29959 L F P
0 g
s
.899 .564 .401 r
.75859 .41727 m .73914 .40459 L .7359 .38494 L p F P
0 g
s
.878 .548 .421 r
.73267 .38312 m .7359 .38494 L .73914 .40459 L p F P
0 g
s
.531 .666 .923 r
.44225 .82902 m .41907 .83019 L .40563 .81368 L p F P
0 g
s
.92 .645 .504 r
.75992 .43781 m .77721 .451 L .77659 .47241 L p F P
0 g
s
.923 .617 .446 r
.77721 .451 m .75992 .43781 L .75859 .41727 L p F P
0 g
s
.388 .146 .421 r
.30426 .40355 m .30665 .38449 L .32718 .37338 L p F P
0 g
s
.33 .098 .403 r
.30665 .38449 m .30426 .40355 L .285 .41581 L p F P
0 g
s
.798 .413 .325 r
.64944 .32328 m .65127 .31785 L p .68292 .34338 L F P
0 g
s
.78 .392 .319 r
.64944 .32328 m .6458 .31619 L .65127 .31785 L closepath p F P
0 g
s
.484 .61 .901 r
.38983 .81324 m .38269 .81282 L .36913 .79381 L p F P
0 g
s
.948 .79 .652 r
.8018 .58375 m .79876 .59236 L .78775 .57802 L p F P
0 g
s
.948 .79 .652 r
.78775 .57802 m .79083 .56937 L .8018 .58375 L p F P
0 g
s
.96 .78 .615 r
.8018 .58375 m .79083 .56937 L .79753 .54545 L p F P
0 g
s
.069 0 .449 r
.83005 .763 m .82754 .76663 L .82969 .79478 L p F P
0 g
s
.9 .597 .463 r
.73914 .40459 m .75859 .41727 L .75992 .43781 L p F P
0 g
s
.707 .82 .935 r
.59909 .83272 m .5753 .84335 L .56282 .83262 L p F P
0 g
s
.673 .811 .949 r
.539 .84139 m .56282 .83262 L .5753 .84335 L p F P
0 g
s
.78 .625 .063 r
.5014 .71806 m .5009 .71074 L .50104 .68316 L p F P
0 g
s
0 0 .048 r
.50173 .67277 m .50104 .68316 L .5009 .71074 L p F P
0 g
s
.823 .873 .882 r
.7012 .78197 m .68244 .79722 L .67081 .7884 L p F P
0 g
s
.801 .872 .9 r
.68244 .79722 m .67081 .7884 L p .65135 .80901 L F P
0 g
s
.788 .525 .538 r
.61761 .9673 m .59177 .96182 L .59128 .93249 L p F P
0 g
s
.822 .553 .532 r
.57599 .92785 m .59128 .93249 L .59177 .96182 L p F P
0 g
s
.289 .256 .647 r
.24523 .58879 m .24012 .58324 L .24321 .57879 L closepath p F P
0 g
s
.387 .462 .816 r
.30907 .74166 m .29713 .73751 L .28421 .71054 L p F P
0 g
s
.871 .875 .837 r
.73479 .74949 m .72967 .75495 L .71843 .7462 L p F P
0 g
s
.871 .875 .837 r
.71843 .7462 m .72949 .73441 L .73479 .74949 L p F P
0 g
s
.885 .88 .824 r
.74196 .72001 m .72949 .73441 L .73479 .74949 L p F P
0 g
s
.431 .249 .532 r
.78269 .91974 m .78087 .89071 L .80185 .87994 L p F P
0 g
s
.498 .299 .54 r
.78087 .89071 m .78269 .91974 L .75994 .92829 L p F P
0 g
s
.354 .182 .504 r
.26551 .47171 m .26573 .44972 L .28368 .43636 L p F P
0 g
s
.314 .119 .449 r
.285 .41581 m .28368 .43636 L .26573 .44972 L p F P
0 g
s
.296 .137 .489 r
.26301 .47388 m .26551 .47171 L .26573 .44972 L p F P
0 g
s
.855 .878 .855 r
.72967 .75495 m .71843 .7462 L p .699 .77235 L F P
0 g
s
.855 .878 .855 r
.699 .77235 m .70612 .7777 L .72967 .75495 L p F P
0 g
s
.599 .754 .952 r
.47886 .84053 m .50244 .83559 L .51534 .84819 L p F P
0 g
s
.878 .548 .421 r
.73914 .40459 m .73157 .40036 L .73267 .38312 L p F P
0 g
s
.868 .538 .423 r
.71352 .37307 m .73267 .38312 L .73157 .40036 L p F P
0 g
s
.933 .835 .725 r
.78931 .6491 m .78779 .65194 L .77692 .64113 L p F P
0 g
s
.933 .835 .725 r
.77692 .64113 m .78049 .63447 L .78931 .6491 L p F P
0 g
s
.948 .832 .697 r
.78931 .6491 m .78049 .63447 L .79247 .60861 L p F P
0 g
s
.762 .386 .343 r
.6458 .31619 m .64944 .32328 L .64723 .33145 L p F P
0 g
s
.762 .386 .343 r
.6134 .30808 m .6458 .31619 L p .64723 .33145 L F P
0 g
s
.823 .873 .882 r
.699 .77235 m .7012 .78197 L p .67081 .7884 L F P
0 g
s
.836 .879 .874 r
.7012 .78197 m .699 .77235 L .70612 .7777 L closepath p F P
0 g
s
.457 .247 .505 r
.5558 .50025 m .55555 .47413 L .57729 .46343 L p F P
0 g
s
.369 .181 .489 r
.55555 .47413 m .5558 .50025 L .53623 .51326 L p F P
0 g
s
.372 .165 .465 r
.28368 .43636 m .285 .41581 L .30426 .40355 L p F P
0 g
s
.835 .543 .496 r
.76173 .46399 m .74681 .45811 L .74523 .43227 L p F P
0 g
s
.797 .512 .507 r
.71987 .42514 m .74523 .43227 L .74681 .45811 L p F P
0 g
s
0 0 .198 r
.83626 .67431 m .83554 .68174 L .83775 .70933 L p F P
0 g
s
0 0 .286 r
.83534 .71956 m .83775 .70933 L .83554 .68174 L p F P
0 g
s
.925 .84 .742 r
.77373 .67611 m .78779 .65194 L .77692 .64113 L p F P
0 g
s
.429 .546 .873 r
.34055 .78132 m .33289 .76893 L .34302 .7708 L closepath p F P
0 g
s
0 0 .323 r
.50674 .6291 m .50868 .6252 L .50876 .59819 L p F P
0 g
s
.036 0 .392 r
.51973 .58245 m .50876 .59819 L .50868 .6252 L p F P
0 g
s
.036 0 .392 r
.50876 .59819 m .51973 .58245 L .51974 .55573 L p F P
0 g
s
.942 .794 .667 r
.79247 .60861 m .79876 .59236 L .78775 .57802 L p F P
0 g
s
.195 .049 .444 r
.5289 .54621 m .51974 .55573 L .51973 .58245 L p F P
0 g
s
.511 .183 .347 r
.3999 .32994 m .40398 .31397 L .4295 .30792 L p F P
0 g
s
.466 .142 .332 r
.40398 .31397 m .3999 .32994 L .37548 .33731 L p F P
0 g
s
.497 .623 .906 r
.40563 .81368 m .38983 .81324 L .39324 .79663 L closepath p F P
0 g
s
.484 .61 .901 r
.3921 .79503 m .39324 .79663 L .38983 .81324 L p F P
0 g
s
.484 .61 .901 r
.36913 .79381 m .3921 .79503 L p .38983 .81324 L F P
0 g
s
.369 .181 .489 r
.53634 .53969 m .53623 .51326 L .5558 .50025 L p F P
0 g
s
.265 .102 .464 r
.5289 .54621 m .53634 .53969 L .53623 .51326 L p F P
0 g
s
0 0 .394 r
.83755 .74747 m .83005 .763 L .83222 .79119 L p F P
0 g
s
0 0 .394 r
.83005 .763 m .83755 .74747 L .83534 .71956 L p F P
0 g
s
.069 0 .449 r
.82969 .79478 m .83222 .79119 L .83005 .763 L p F P
0 g
s
.684 .441 .548 r
.66967 .97115 m .68251 .97094 L .68364 1.00059 L p F P
0 g
s
.684 .441 .548 r
.68364 1.00059 m .67071 1.0008 L .66967 .97115 L p F P
0 g
s
.703 .455 .547 r
.65176 .97076 m .66967 .97115 L .67071 1.0008 L p F P
0 g
s
.649 .413 .548 r
.68364 1.00059 m .68251 .97094 L .71067 .9685 L p F P
0 g
s
.588 .348 .521 r
.6013 .45519 m .60074 .42934 L .62677 .42357 L p F P
0 g
s
.529 .302 .515 r
.60074 .42934 m .6013 .45519 L .57729 .46343 L p F P
0 g
s
.454 .167 .386 r
.34909 .36349 m .35237 .34595 L .37548 .33731 L p F P
0 g
s
.403 .123 .37 r
.35237 .34595 m .34909 .36349 L .32718 .37338 L p F P
0 g
s
.703 .455 .547 r
.67071 1.0008 m .65268 1.00041 L .65176 .97076 L p F P
0 g
s
.735 .481 .545 r
.62411 .96827 m .65176 .97076 L .65268 1.00041 L p F P
0 g
s
.353 .193 .52 r
.80185 .87994 m .8101 .87441 L .80809 .84564 L p F P
0 g
s
.302 .156 .51 r
.81853 .83739 m .80809 .84564 L .8101 .87441 L p F P
0 g
s
.842 .484 .377 r
.68653 .35489 m .68839 .34562 L p .71352 .37307 L F P
0 g
s
.829 .469 .375 r
.68653 .35489 m .68292 .34338 L .68839 .34562 L closepath p F P
0 g
s
.347 .296 .658 r
.24321 .57879 m .25715 .56229 L p .25657 .59859 L F P
0 g
s
.347 .296 .658 r
.25657 .59859 m .24523 .58879 L .24321 .57879 L p F P
0 g
s
.313 .248 .622 r
.25468 .54697 m .25715 .56229 L .24321 .57879 L p F P
0 g
s
.313 .248 .622 r
.2487 .53998 m .25468 .54697 L p .24321 .57879 L F P
0 g
s
.94 .751 .62 r
.78444 .53144 m .79753 .54545 L .79083 .56937 L p F P
0 g
s
.95 .737 .58 r
.79753 .54545 m .78444 .53144 L .78913 .50831 L p F P
0 g
s
.923 .643 .492 r
.54479 .88507 m .52807 .87381 L .52802 .84503 L p F P
0 g
s
.966 .687 .452 r
.51517 .83237 m .52802 .84503 L .52807 .87381 L p F P
0 g
s
.498 .299 .54 r
.76162 .95766 m .75994 .92829 L .78269 .91974 L p F P
0 g
s
.557 .343 .545 r
.75994 .92829 m .76162 .95766 L .73702 .96408 L p F P
0 g
s
0 0 .286 r
.83775 .70933 m .83534 .71956 L .83755 .74747 L p F P
0 g
s
.737 .826 .92 r
.62297 .82014 m .59909 .83272 L .58675 .82189 L p F P
0 g
s
.707 .82 .935 r
.56282 .83262 m .58675 .82189 L .59909 .83272 L p F P
0 g
s
.822 .553 .532 r
.59177 .96182 m .57637 .95723 L .57599 .92785 L p F P
0 g
s
.842 .569 .527 r
.56556 .9241 m .57599 .92785 L .57637 .95723 L p F P
0 g
s
.607 .726 .929 r
.50244 .83559 m .47886 .84053 L .4657 .82593 L p F P
0 g
s
.565 .709 .939 r
.44225 .82902 m .4657 .82593 L .47886 .84053 L p F P
0 g
s
.328 .295 .669 r
.24953 .60792 m .24523 .58879 L .25657 .59859 L closepath p F P
0 g
s
.387 .462 .816 r
.28421 .71054 m .28456 .70968 L p .30907 .74166 L F P
0 g
s
.36 .431 .799 r
.28421 .71054 m .28365 .70929 L .28456 .70968 L closepath p F P
0 g
s
.857 .562 .487 r
.76173 .46399 m .77175 .4687 L .77351 .49485 L p F P
0 g
s
.317 .188 .541 r
.26589 .48049 m .26665 .49532 L .25052 .51018 L p F P
0 g
s
.317 .188 .541 r
.26301 .47388 m .26589 .48049 L p .25052 .51018 L F P
0 g
s
.354 .243 .586 r
.253 .53533 m .25052 .51018 L .26665 .49532 L p F P
0 g
s
.296 .2 .574 r
.2487 .53998 m .253 .53533 L .25052 .51018 L p F P
0 g
s
.808 .458 .394 r
.68292 .34338 m .68653 .35489 L .68562 .36079 L p F P
0 g
s
.808 .458 .394 r
.6541 .33344 m .68292 .34338 L p .68562 .36079 L F P
0 g
s
.798 .413 .325 r
.68292 .34338 m .6541 .33344 L .64944 .32328 L p F P
0 g
s
.381 .423 .779 r
.28456 .70968 m .28365 .70929 L .27038 .67639 L p F P
0 g
s
.606 .381 .548 r
.71201 .99817 m .71067 .9685 L .73702 .96408 L p F P
0 g
s
.649 .413 .548 r
.71067 .9685 m .71201 .99817 L .68364 1.00059 L p F P
0 g
s
.88 .603 .514 r
.56556 .9241 m .54495 .91416 L .54479 .88507 L p F P
0 g
s
.923 .643 .492 r
.52807 .87381 m .54479 .88507 L .54495 .91416 L p F P
0 g
s
.78 .406 .347 r
.6541 .33344 m .64723 .33145 L .64944 .32328 L closepath p F P
0 g
s
.445 .53 .85 r
.34302 .7708 m .33289 .76893 L .31928 .74451 L p F P
0 g
s
.387 .462 .816 r
.28456 .70968 m .30573 .71686 L p .30907 .74166 L F P
0 g
s
.404 .452 .797 r
.30573 .71686 m .28456 .70968 L .29468 .69143 L closepath p F P
0 g
s
.381 .423 .779 r
.29229 .6855 m .29468 .69143 L .28456 .70968 L p F P
0 g
s
.381 .423 .779 r
.27038 .67639 m .29229 .6855 L p .28456 .70968 L F P
0 g
s
.735 .481 .545 r
.65268 1.00041 m .62484 .99795 L .62411 .96827 L p F P
0 g
s
.761 .503 .542 r
.61761 .9673 m .62411 .96827 L .62484 .99795 L p F P
0 g
s
.91 .84 .764 r
.77373 .67611 m .76516 .6892 L .75405 .67823 L p F P
0 g
s
.91 .84 .764 r
.75405 .67823 m .765 .66156 L .77373 .67611 L p F P
0 g
s
.925 .84 .742 r
.77692 .64113 m .765 .66156 L .77373 .67611 L p F P
0 g
s
.797 .512 .507 r
.74681 .45811 m .72127 .451 L .71987 .42514 L p F P
0 g
s
.766 .488 .513 r
.71342 .42387 m .71987 .42514 L .72127 .451 L p F P
0 g
s
.79 .866 .905 r
.6469 .8056 m .65049 .80314 L .65135 .80901 L closepath p F P
0 g
s
.801 .872 .9 r
.67081 .7884 m .65049 .80314 L .65135 .80901 L p F P
0 g
s
.766 .863 .921 r
.62297 .82014 m .6469 .8056 L .65135 .80901 L p F P
0 g
s
.929 .8 .697 r
.7814 .59434 m .79247 .60861 L .78049 .63447 L p F P
0 g
s
.942 .794 .667 r
.78775 .57802 m .7814 .59434 L .79247 .60861 L p F P
0 g
s
.762 .386 .343 r
.61306 .30924 m .6134 .30808 L p .64723 .33145 L F P
0 g
s
.741 .363 .337 r
.61306 .30924 m .61227 .30785 L .6134 .30808 L closepath p F P
0 g
s
.928 .71 .587 r
.78913 .50831 m .78444 .53144 L p .77429 .4961 L F P
0 g
s
.928 .71 .587 r
.77533 .496 m .78913 .50831 L p .77429 .4961 L F P
0 g
s
.9 .597 .465 r
.77351 .49485 m .77533 .496 L p .7742 .49611 L F P
0 g
s
.928 .71 .587 r
.78444 .53144 m .76911 .51793 L .7736 .49617 L p F P
0 g
s
.9 .597 .465 r
.7736 .49617 m .77351 .49485 L p .7742 .49611 L F P
0 g
s
.928 .71 .587 r
.7736 .49617 m .7739 .49472 L p .77429 .4961 L F P
0 g
s
.928 .71 .587 r
.78444 .53144 m .7736 .49617 L .77429 .4961 L F
.9 .597 .465 r
.79477 .53355 m .7753 .52137 L .7736 .49617 L p F P
0 g
s
.9 .597 .465 r
.79477 .53355 m .7736 .49617 L .7742 .49611 L F
.79285 .50709 m .79477 .53355 L p .7742 .49611 L F P
0 g
s
.9 .597 .465 r
.77533 .496 m .79285 .50709 L p .7742 .49611 L F P
0 g
s
.928 .71 .587 r
.7739 .49472 m .77533 .496 L p .77429 .4961 L F P
0 g
s
.55 .219 .359 r
.4256 .32388 m .4295 .30792 L .45403 .30358 L p F P
0 g
s
.511 .183 .347 r
.4295 .30792 m .4256 .32388 L .3999 .32994 L p F P
0 g
s
.761 .503 .542 r
.62484 .99795 m .61829 .99699 L .61761 .9673 L p F P
0 g
s
.788 .525 .538 r
.59177 .96182 m .61761 .9673 L .61829 .99699 L p F P
0 g
s
.675 .779 .928 r
.56282 .83262 m .539 .84139 L .52621 .82869 L p F P
0 g
s
.725 .359 .356 r
.61227 .30785 m .61306 .30924 L .60978 .32264 L p F P
0 g
s
.725 .359 .356 r
.57841 .30239 m .61227 .30785 L p .60978 .32264 L F P
0 g
s
.344 .382 .757 r
.27038 .67639 m .26807 .67512 L .26915 .67304 L closepath p F P
0 g
s
.312 .344 .733 r
.25784 .63903 m .26915 .67304 L .26807 .67512 L p F P
0 g
s
.41 .489 .83 r
.31928 .74451 m .30907 .74166 L .31306 .73223 L closepath p F P
0 g
s
.387 .462 .816 r
.30573 .71686 m .31306 .73223 L .30907 .74166 L p F P
0 g
s
.639 .248 .286 r
.54553 .29959 m .52323 .29892 L .51631 .2928 L p F P
0 g
s
.631 .252 .308 r
.52323 .29892 m .51424 .2989 L .51631 .2928 L closepath p F P
0 g
s
.599 .22 .297 r
.51631 .2928 m .51424 .2989 L .48464 .30032 L p F P
0 g
s
.36 .339 .7 r
.24953 .60792 m .25657 .59859 L p .25833 .63828 L F P
0 g
s
.36 .339 .7 r
.25833 .63828 m .25745 .63769 L .24953 .60792 L p F P
0 g
s
.766 .488 .513 r
.72127 .451 m .71478 .44974 L .71342 .42387 L p F P
0 g
s
.736 .464 .517 r
.6858 .42059 m .71342 .42387 L .71478 .44974 L p F P
0 g
s
0 0 .198 r
.83775 .70933 m .83848 .70195 L .83626 .67431 L p F P
0 g
s
.774 .572 .001 r
.83381 .65796 m .83626 .67431 L .83848 .70195 L p F P
0 g
s
.774 .572 .001 r
.83626 .67431 m .83381 .65796 L .83162 .63061 L p F P
0 g
s
.336 .197 .539 r
.26589 .48049 m .26301 .47388 L .26551 .47171 L closepath p F P
0 g
s
.945 .637 .424 r
.80989 .54693 m .79477 .53355 L .79285 .50709 L p F P
0 g
s
.637 .387 .522 r
.62751 .44944 m .62677 .42357 L .65493 .42035 L p F P
0 g
s
.588 .348 .521 r
.62677 .42357 m .62751 .44944 L .6013 .45519 L p F P
0 g
s
.44 .188 .435 r
.32491 .39246 m .32718 .37338 L .34909 .36349 L p F P
0 g
s
.388 .146 .421 r
.32718 .37338 m .32491 .39246 L .30426 .40355 L p F P
0 g
s
.762 .386 .343 r
.64723 .33145 m .62093 .32491 L .61306 .30924 L p F P
0 g
s
.746 .381 .361 r
.62093 .32491 m .60978 .32264 L .61306 .30924 L closepath p F P
0 g
s
.573 .684 .916 r
.4657 .82593 m .44225 .82902 L .42888 .81242 L p F P
0 g
s
.531 .666 .923 r
.40563 .81368 m .42888 .81242 L .44225 .82902 L p F P
0 g
s
.868 .538 .423 r
.73157 .40036 m .71683 .39268 L .71352 .37307 L p F P
0 g
s
.847 .522 .438 r
.68855 .36191 m .71352 .37307 L .71683 .39268 L p F P
0 g
s
.842 .484 .377 r
.71352 .37307 m .68855 .36191 L .68653 .35489 L p F P
0 g
s
.332 .252 .614 r
.25468 .54697 m .2487 .53998 L .253 .53533 L closepath p F P
0 g
s
.899 .844 .78 r
.75426 .70442 m .76516 .6892 L .75405 .67823 L p F P
0 g
s
.842 .569 .527 r
.57637 .95723 m .56587 .95351 L .56556 .9241 L p F P
0 g
s
.88 .603 .514 r
.54495 .91416 m .56556 .9241 L .56587 .95351 L p F P
0 g
s
.397 .415 .762 r
.28115 .65512 m .29229 .6855 L .27038 .67639 L p F P
0 g
s
.397 .415 .762 r
.27038 .67639 m .26915 .67304 L .28115 .65512 L p F P
0 g
s
.762 .831 .905 r
.6469 .8056 m .62297 .82014 L .61078 .80919 L p F P
0 g
s
.737 .826 .92 r
.58675 .82189 m .61078 .80919 L .62297 .82014 L p F P
0 g
s
.371 .381 .741 r
.27911 .64899 m .28115 .65512 L .26915 .67304 L p F P
0 g
s
.371 .381 .741 r
.25833 .63828 m .27911 .64899 L p .26915 .67304 L F P
0 g
s
.371 .381 .741 r
.26915 .67304 m .25784 .63903 L .25833 .63828 L p F P
0 g
s
.496 .59 .878 r
.3921 .79503 m .36913 .79381 L .35551 .77253 L p F P
0 g
s
.857 .562 .487 r
.77351 .49485 m .76342 .49016 L .76173 .46399 L p F P
0 g
s
.835 .543 .496 r
.74681 .45811 m .76173 .46399 L .76342 .49016 L p F P
0 g
s
.914 .667 .551 r
.7592 .45927 m .77659 .47241 L .7739 .49472 L p F P
0 g
s
.92 .645 .504 r
.77659 .47241 m .7592 .45927 L .75992 .43781 L p F P
0 g
s
0 0 .048 r
.5009 .71074 m .5016 .70042 L .50173 .67277 L p F P
0 g
s
0 0 .221 r
.50664 .65646 m .50173 .67277 L .5016 .70042 L p F P
0 g
s
0 0 .221 r
.50173 .67277 m .50664 .65646 L .50674 .6291 L p F P
0 g
s
.341 .341 .715 r
.25784 .63903 m .25745 .63769 L .25833 .63828 L closepath p F P
0 g
s
.943 .669 .206 r
.82495 .61519 m .83162 .63061 L .83381 .65796 L p F P
0 g
s
.943 .669 .206 r
.83162 .63061 m .82495 .61519 L .82282 .58812 L p F P
0 g
s
.529 .302 .515 r
.57769 .48961 m .57729 .46343 L .6013 .45519 L p F P
0 g
s
.457 .247 .505 r
.57729 .46343 m .57769 .48961 L .5558 .50025 L p F P
0 g
s
.388 .236 .55 r
.26551 .47171 m .28355 .45841 L p .27215 .49106 L F P
0 g
s
.388 .236 .55 r
.27215 .49106 m .26589 .48049 L .26551 .47171 L p F P
0 g
s
.354 .182 .504 r
.28368 .43636 m .28355 .45841 L .26551 .47171 L p F P
0 g
s
.976 .672 .347 r
.82282 .58812 m .81193 .57369 L .80989 .54693 L p F P
0 g
s
.945 .637 .424 r
.79477 .53355 m .80989 .54693 L .81193 .57369 L p F P
0 g
s
.54 .643 .9 r
.41541 .79372 m .42888 .81242 L .40563 .81368 L p F P
0 g
s
.54 .643 .9 r
.39404 .79496 m .41541 .79372 L p .40563 .81368 L F P
0 g
s
.54 .643 .9 r
.40563 .81368 m .39324 .79663 L .39404 .79496 L p F P
0 g
s
.9 .597 .463 r
.75992 .43781 m .74037 .42517 L .73914 .40459 L p F P
0 g
s
.878 .578 .475 r
.73157 .40036 m .73914 .40459 L .74037 .42517 L p F P
0 g
s
.855 .878 .855 r
.71843 .7462 m .69724 .76667 L .699 .77235 L p F P
0 g
s
.841 .872 .865 r
.69469 .76897 m .69724 .76667 L .699 .77235 L closepath p F P
0 g
s
.823 .873 .882 r
.67081 .7884 m .69469 .76897 L .699 .77235 L p F P
0 g
s
.897 .623 .514 r
.74037 .42517 m .75992 .43781 L .7592 .45927 L p F P
0 g
s
.499 .206 .399 r
.37234 .35485 m .37548 .33731 L .3999 .32994 L p F P
0 g
s
.454 .167 .386 r
.37548 .33731 m .37234 .35485 L .34909 .36349 L p F P
0 g
s
.976 .672 .347 r
.81193 .57369 m .82282 .58812 L .82495 .61519 L p F P
0 g
s
.387 .376 .725 r
.27911 .64899 m .25833 .63828 L .27091 .62194 L closepath p F P
0 g
s
.36 .339 .7 r
.26639 .60498 m .27091 .62194 L .25833 .63828 L p F P
0 g
s
.36 .339 .7 r
.25657 .59859 m .26639 .60498 L p .25833 .63828 L F P
0 g
s
.77628 .49464 m
.78205 .49152 L
s
.195 .049 .444 r
.51973 .58245 m .52896 .57298 L .5289 .54621 L p F P
0 g
s
.265 .102 .464 r
.53634 .53969 m .5289 .54621 L .52896 .57298 L p F P
0 g
s
.553 .212 .344 r
.45595 .30451 m .45403 .30358 L .45629 .30321 L closepath p F P
0 g
s
.55 .219 .359 r
.45403 .30358 m .45595 .30451 L p .4256 .32388 L F P
0 g
s
.736 .464 .517 r
.71478 .44974 m .68696 .44648 L .6858 .42059 L p F P
0 g
s
.7 .435 .521 r
.66782 .42008 m .6858 .42059 L .68696 .44648 L p F P
0 g
s
.557 .343 .545 r
.73854 .9938 m .73702 .96408 L .76162 .95766 L p F P
0 g
s
.606 .381 .548 r
.73702 .96408 m .73854 .9938 L .71201 .99817 L p F P
0 g
s
.678 .419 .522 r
.65493 .42035 m .66782 .42008 L .66886 .44596 L p F P
0 g
s
.678 .419 .522 r
.66886 .44596 m .65587 .44624 L .65493 .42035 L p F P
0 g
s
.637 .387 .522 r
.65493 .42035 m .65587 .44624 L .62751 .44944 L p F P
0 g
s
.59 .247 .356 r
.45629 .30321 m .48464 .30032 L .48083 .31591 L p F P
0 g
s
.59 .247 .356 r
.45595 .30451 m .45629 .30321 L p .48083 .31591 L F P
0 g
s
.424 .207 .478 r
.30303 .42413 m .30426 .40355 L .32491 .39246 L p F P
0 g
s
.372 .165 .465 r
.30426 .40355 m .30303 .42413 L .28368 .43636 L p F P
0 g
s
.7 .435 .521 r
.68696 .44648 m .66886 .44596 L .66782 .42008 L p F P
0 g
s
.885 .842 .797 r
.75426 .70442 m .74196 .72001 L .73064 .70894 L p F P
0 g
s
.885 .842 .797 r
.73064 .70894 m .74564 .68995 L .75426 .70442 L p F P
0 g
s
.899 .844 .78 r
.75405 .67823 m .74564 .68995 L .75426 .70442 L p F P
0 g
s
0 0 .323 r
.50868 .6252 m .50674 .6291 L .50664 .65646 L p F P
0 g
s
.353 .193 .52 r
.8101 .87441 m .80185 .87994 L .80383 .90907 L p F P
0 g
s
.431 .249 .532 r
.80185 .87994 m .80383 .90907 L .78269 .91974 L p F P
0 g
s
.406 .223 .516 r
.28355 .45841 m .28368 .43636 L .30303 .42413 L p F P
0 g
s
.725 .359 .356 r
.57681 .30845 m .57841 .30239 L p .60978 .32264 L F P
0 g
s
.701 .334 .349 r
.57681 .30845 m .5724 .30171 L .57841 .30239 L closepath p F P
0 g
s
.445 .53 .85 r
.34188 .74854 m .34802 .75961 L .34302 .7708 L p F P
0 g
s
.445 .53 .85 r
.31928 .74451 m .34188 .74854 L p .34302 .7708 L F P
0 g
s
.462 .55 .86 r
.35551 .77253 m .34302 .7708 L .34802 .75961 L closepath p F P
0 g
s
.19 .076 .484 r
.83187 .82334 m .81853 .83739 L .82063 .86623 L p F P
0 g
s
.302 .156 .51 r
.8101 .87441 m .82063 .86623 L .81853 .83739 L p F P
0 g
s
.19 .076 .484 r
.81853 .83739 m .83187 .82334 L .82969 .79478 L p F P
0 g
s
.59 .247 .356 r
.48083 .31591 m .4719 .31681 L .45595 .30451 L p F P
0 g
s
.585 .25 .369 r
.4719 .31681 m .45255 .31914 L .45595 .30451 L closepath p F P
0 g
s
.55 .219 .359 r
.45595 .30451 m .45255 .31914 L .4256 .32388 L p F P
0 g
s
.688 .332 .366 r
.5724 .30171 m .57681 .30845 L p .54182 .31473 L F P
0 g
s
.688 .332 .366 r
.54182 .31473 m .54553 .29959 L .5724 .30171 L p F P
0 g
s
.928 .761 .654 r
.79083 .56937 m .78775 .57802 L .77631 .55918 L p F P
0 g
s
.928 .761 .654 r
.77631 .55918 m .77764 .55546 L .79083 .56937 L p F P
0 g
s
.94 .751 .62 r
.79083 .56937 m .77764 .55546 L .78444 .53144 L p F P
0 g
s
.784 .834 .89 r
.65049 .80314 m .6469 .8056 L .63486 .79453 L p F P
0 g
s
.762 .831 .905 r
.61078 .80919 m .63486 .79453 L .6469 .8056 L p F P
0 g
s
.385 .29 .623 r
.253 .53533 m .26922 .52058 L p .26415 .55544 L F P
0 g
s
.385 .29 .623 r
.26415 .55544 m .25468 .54697 L .253 .53533 L p F P
0 g
s
.354 .243 .586 r
.26665 .49532 m .26922 .52058 L .253 .53533 L p F P
0 g
s
.069 0 .449 r
.83222 .79119 m .82969 .79478 L .83187 .82334 L p F P
0 g
s
.784 .834 .89 r
.63486 .79453 m .64328 .78873 L .65049 .80314 L p F P
0 g
s
.794 .837 .884 r
.65894 .77736 m .64328 .78873 L .65049 .80314 L p F P
0 g
s
.794 .837 .884 r
.65049 .80314 m .67081 .7884 L .65894 .77736 L p F P
0 g
s
.822 .473 .395 r
.68855 .36191 m .68562 .36079 L .68653 .35489 L closepath p F P
0 g
s
.375 .231 .554 r
.26665 .49532 m .26589 .48049 L .27215 .49106 L closepath p F P
0 g
s
0 0 .048 r
.5016 .70042 m .5009 .71074 L .50076 .73871 L p F P
0 g
s
.872 .844 .814 r
.72949 .73441 m .74196 .72001 L .73064 .70894 L p F P
0 g
s
.607 .726 .929 r
.4657 .82593 m .48937 .8209 L .50244 .83559 L p F P
0 g
s
.788 .525 .538 r
.61829 .99699 m .59227 .99156 L .59177 .96182 L p F P
0 g
s
.822 .553 .532 r
.57637 .95723 m .59177 .96182 L .59227 .99156 L p F P
0 g
s
.623 .278 .365 r
.48083 .31591 m .48464 .30032 L .51424 .2989 L p F P
0 g
s
.706 .788 .915 r
.58675 .82189 m .56282 .83262 L .55015 .81983 L p F P
0 g
s
.675 .779 .928 r
.52621 .82869 m .55015 .81983 L .56282 .83262 L p F P
0 g
s
.431 .249 .532 r
.78454 .94919 m .78269 .91974 L .80383 .90907 L p F P
0 g
s
.498 .299 .54 r
.78269 .91974 m .78454 .94919 L .76162 .95766 L p F P
0 g
s
.79 .448 .408 r
.64723 .33145 m .6541 .33344 L .65973 .35192 L p F P
0 g
s
.808 .458 .394 r
.68562 .36079 m .65973 .35192 L .6541 .33344 L p F P
0 g
s
.878 .578 .475 r
.74037 .42517 m .73276 .42096 L .73157 .40036 L p F P
0 g
s
.869 .57 .48 r
.71683 .39268 m .73157 .40036 L .73276 .42096 L p F P
0 g
s
.458 .516 .83 r
.32827 .72153 m .34188 .74854 L .31928 .74451 L p F P
0 g
s
.458 .516 .83 r
.32033 .72018 m .32827 .72153 L p .31928 .74451 L F P
0 g
s
.458 .516 .83 r
.31928 .74451 m .31306 .73223 L .32033 .72018 L p F P
0 g
s
.662 .306 .359 r
.52323 .29892 m .54553 .29959 L .54182 .31473 L p F P
0 g
s
.916 .804 .722 r
.78049 .63447 m .77692 .64113 L .76569 .62702 L p F P
0 g
s
.916 .804 .722 r
.76569 .62702 m .76929 .62032 L .78049 .63447 L p F P
0 g
s
.929 .8 .697 r
.78049 .63447 m .76929 .62032 L .7814 .59434 L p F P
0 g
s
.457 .247 .505 r
.55604 .52675 m .5558 .50025 L .57769 .48961 L p F P
0 g
s
.369 .181 .489 r
.5558 .50025 m .55604 .52675 L .53634 .53969 L p F P
0 g
s
.835 .543 .496 r
.76342 .49016 m .7484 .48431 L .74681 .45811 L p F P
0 g
s
.797 .512 .507 r
.72127 .451 m .74681 .45811 L .7484 .48431 L p F P
0 g
s
.662 .306 .359 r
.54182 .31473 m .53522 .31453 L .52323 .29892 L p F P
0 g
s
.651 .305 .373 r
.51424 .2989 m .52323 .29892 L .53522 .31453 L p F P
0 g
s
.651 .305 .373 r
.53522 .31453 m .51066 .31448 L .51424 .2989 L p F P
0 g
s
.623 .278 .365 r
.51424 .2989 m .51066 .31448 L .48083 .31591 L p F P
0 g
s
0 0 .198 r
.83848 .70195 m .83775 .70933 L .83998 .73731 L p F P
0 g
s
0 0 .286 r
.83755 .74747 m .83998 .73731 L .83775 .70933 L p F P
0 g
s
.859 .842 .827 r
.72949 .73441 m .71843 .7462 L .7069 .73506 L p F P
0 g
s
.859 .842 .827 r
.7069 .73506 m .72103 .72002 L .72949 .73441 L p F P
0 g
s
.872 .844 .814 r
.73064 .70894 m .72103 .72002 L .72949 .73441 L p F P
0 g
s
.814 .839 .868 r
.69469 .76897 m .67081 .7884 L .65894 .77736 L p F P
0 g
s
0 0 .323 r
.50664 .65646 m .50859 .65258 L .50868 .6252 L p F P
0 g
s
.036 0 .392 r
.51972 .60954 m .50868 .6252 L .50859 .65258 L p F P
0 g
s
.036 0 .392 r
.50868 .6252 m .51972 .60954 L .51973 .58245 L p F P
0 g
s
.922 .762 .667 r
.7814 .59434 m .78775 .57802 L .77631 .55918 L p F P
0 g
s
.79 .448 .408 r
.65973 .35192 m .64492 .34765 L .64723 .33145 L p F P
0 g
s
.773 .431 .407 r
.62093 .32491 m .64723 .33145 L .64492 .34765 L p F P
0 g
s
.844 .843 .843 r
.69724 .76667 m .71843 .7462 L .7069 .73506 L p F P
0 g
s
.371 .289 .633 r
.25715 .56229 m .25468 .54697 L .26415 .55544 L closepath p F P
0 g
s
.907 .806 .737 r
.765 .66156 m .77692 .64113 L .76569 .62702 L p F P
0 g
s
.195 .049 .444 r
.52896 .57298 m .51973 .58245 L .51972 .60954 L p F P
0 g
s
.832 .84 .853 r
.69724 .76667 m .69469 .76897 L .68298 .75779 L p F P
0 g
s
.814 .839 .868 r
.65894 .77736 m .68298 .75779 L .69469 .76897 L p F P
0 g
s
.832 .84 .853 r
.68298 .75779 m .68897 .75237 L .69724 .76667 L p F P
0 g
s
.844 .843 .843 r
.7069 .73506 m .68897 .75237 L .69724 .76667 L p F P
0 g
s
.376 .337 .687 r
.26639 .60498 m .25657 .59859 L .26302 .59108 L closepath p F P
0 g
s
.347 .296 .658 r
.25715 .56229 m .26302 .59108 L .25657 .59859 L p F P
0 g
s
.919 .723 .623 r
.76911 .51793 m .78444 .53144 L .77764 .55546 L p F P
0 g
s
.369 .181 .489 r
.53645 .56649 m .53634 .53969 L .55604 .52675 L p F P
0 g
s
.265 .102 .464 r
.52896 .57298 m .53645 .56649 L .53634 .53969 L p F P
0 g
s
.539 .241 .409 r
.39691 .34749 m .3999 .32994 L .4256 .32388 L p F P
0 g
s
.499 .206 .399 r
.3999 .32994 m .39691 .34749 L .37234 .35485 L p F P
0 g
s
.485 .226 .446 r
.34694 .38258 m .34909 .36349 L .37234 .35485 L p F P
0 g
s
.44 .188 .435 r
.34909 .36349 m .34694 .38258 L .32491 .39246 L p F P
0 g
s
0 0 .394 r
.8398 .77577 m .83222 .79119 L .83443 .81977 L p F P
0 g
s
0 0 .394 r
.83222 .79119 m .8398 .77577 L .83755 .74747 L p F P
0 g
s
.069 0 .449 r
.83187 .82334 m .83443 .81977 L .83222 .79119 L p F P
0 g
s
.684 .441 .548 r
.67071 1.0008 m .68364 1.00059 L .6848 1.03066 L p F P
0 g
s
.684 .441 .548 r
.6848 1.03066 m .67177 1.03087 L .67071 1.0008 L p F P
0 g
s
.703 .455 .547 r
.65268 1.00041 m .67071 1.0008 L .67177 1.03087 L p F P
0 g
s
.441 .493 .817 r
.31306 .73223 m .30573 .71686 L .32033 .72018 L closepath p F P
0 g
s
.649 .413 .548 r
.6848 1.03066 m .68364 1.00059 L .71201 .99817 L p F P
0 g
s
.588 .348 .521 r
.60186 .4814 m .6013 .45519 L .62751 .44944 L p F P
0 g
s
.529 .302 .515 r
.6013 .45519 m .60186 .4814 L .57769 .48961 L p F P
0 g
s
.703 .455 .547 r
.67177 1.03087 m .65361 1.03048 L .65268 1.00041 L p F P
0 g
s
.735 .481 .545 r
.62484 .99795 m .65268 1.00041 L .65361 1.03048 L p F P
0 g
s
.353 .193 .52 r
.80383 .90907 m .81215 .9036 L .8101 .87441 L p F P
0 g
s
.302 .156 .51 r
.82063 .86623 m .8101 .87441 L .81215 .9036 L p F P
0 g
s
.966 .687 .452 r
.52807 .87381 m .51513 .86126 L .51517 .83237 L p F P
0 g
s
.989 .723 .376 r
.50613 .81838 m .51517 .83237 L .51513 .86126 L p F P
0 g
s
.611 .699 .907 r
.48937 .8209 m .4657 .82593 L .4524 .80924 L p F P
0 g
s
.573 .684 .916 r
.42888 .81242 m .4524 .80924 L .4657 .82593 L p F P
0 g
s
.847 .522 .438 r
.71683 .39268 m .69173 .38155 L .68855 .36191 L p F P
0 g
s
.827 .507 .449 r
.68562 .36079 m .68855 .36191 L .69173 .38155 L p F P
0 g
s
.923 .643 .492 r
.54495 .91416 m .52812 .903 L .52807 .87381 L p F P
0 g
s
.966 .687 .452 r
.51513 .86126 m .52807 .87381 L .52812 .903 L p F P
0 g
s
.498 .299 .54 r
.76332 .98744 m .76162 .95766 L .78454 .94919 L p F P
0 g
s
.557 .343 .545 r
.76162 .95766 m .76332 .98744 L .73854 .9938 L p F P
0 g
s
.725 .359 .356 r
.60978 .32264 m .58227 .31823 L .57681 .30845 L p F P
0 g
s
.711 .355 .371 r
.58227 .31823 m .57479 .31731 L .57681 .30845 L closepath p F P
0 g
s
.688 .332 .366 r
.57681 .30845 m .57479 .31731 L .54182 .31473 L p F P
0 g
s
0 0 .286 r
.83998 .73731 m .83755 .74747 L .8398 .77577 L p F P
0 g
s
.496 .59 .878 r
.35551 .77253 m .37852 .77364 L .3921 .79503 L p F P
0 g
s
.505 .572 .857 r
.36489 .74998 m .37852 .77364 L .35551 .77253 L p F P
0 g
s
.505 .572 .857 r
.35478 .74955 m .36489 .74998 L p .35551 .77253 L F P
0 g
s
.505 .572 .857 r
.35551 .77253 m .34802 .75961 L .35478 .74955 L p F P
0 g
s
.822 .553 .532 r
.59227 .99156 m .57677 .98701 L .57637 .95723 L p F P
0 g
s
.842 .569 .527 r
.56587 .95351 m .57637 .95723 L .57677 .98701 L p F P
0 g
s
.406 .281 .595 r
.26922 .52058 m .26665 .49532 L .27215 .49106 L p F P
0 g
s
.827 .507 .449 r
.69173 .38155 m .68486 .37894 L .68562 .36079 L p F P
0 g
s
.814 .495 .451 r
.65973 .35192 m .68562 .36079 L .68486 .37894 L p F P
0 g
s
.733 .794 .901 r
.61078 .80919 m .58675 .82189 L .57421 .80899 L p F P
0 g
s
.706 .788 .915 r
.55015 .81983 m .57421 .80899 L .58675 .82189 L p F P
0 g
s
.4 .332 .665 r
.26302 .59108 m .25715 .56229 L .26415 .55544 L p F P
0 g
s
.857 .562 .487 r
.76342 .49016 m .77351 .49485 L .7736 .49617 L p F P
0 g
s
.907 .684 .59 r
.75641 .48165 m .7739 .49472 L .7736 .49617 L p F P
0 g
s
.835 .543 .496 r
.7484 .48431 m .76342 .49016 L .76409 .50051 L p F P
0 g
s
.907 .684 .59 r
.7736 .49617 m .76911 .51793 L p .76325 .50119 L F P
0 g
s
.907 .684 .59 r
.76325 .50119 m .76409 .50051 L .7736 .49617 L F
.898 .698 .623 r
.76437 .53448 m .76911 .51793 L .7552 .50766 L p F P
0 g
s
.898 .698 .623 r
.75389 .5083 m .76437 .53448 L p .7552 .50766 L F P
0 g
s
.89 .696 .633 r
.76196 .54211 m .76437 .53448 L .75389 .5083 L p F P
0 g
s
.835 .543 .496 r
.75892 .50466 m .75354 .50842 L .7484 .48431 L F
.74995 .50971 m .7484 .48431 L p .75354 .50842 L F P
0 g
s
.89 .696 .633 r
.76196 .54211 m .75389 .5083 L .75358 .50841 L F
.74368 .52939 m .76196 .54211 L p .75255 .50878 L F P
0 g
s
.89 .696 .633 r
.74995 .50971 m .74368 .52939 L p .75255 .50878 L F P
0 g
s
.835 .543 .496 r
.75481 .50797 m .75354 .50842 L .75892 .50466 L F
.89 .696 .633 r
.75299 .50603 m .75147 .50495 L p .75255 .50878 L F P
0 g
s
.89 .696 .633 r
.76196 .54211 m .75358 .50841 L .75255 .50878 L F
.75358 .50841 m .75299 .50603 L .75255 .50878 L F
.835 .543 .496 r
.76514 .5167 m .75081 .51118 L p .75481 .50797 L F P
0 g
s
.907 .684 .59 r
.76911 .51793 m .75629 .50678 L .76325 .50119 L F
.76911 .51793 m .75299 .50603 L .75285 .50565 L p F P
0 g
s
.907 .684 .59 r
.75285 .50565 m .75192 .50299 L p .75425 .50501 L F P
0 g
s
.907 .684 .59 r
.76911 .51793 m .75285 .50565 L .75425 .50501 L F
.919 .723 .623 r
.76437 .53448 m .76911 .51793 L p .77764 .55546 L F P
0 g
s
.857 .562 .487 r
.7753 .52137 m .76514 .5167 L .76409 .50051 L p F P
0 g
s
.857 .562 .487 r
.76409 .50051 m .76342 .49016 L p .76688 .49924 L F P
0 g
s
.857 .562 .487 r
.7753 .52137 m .76409 .50051 L .76688 .49924 L F
.835 .543 .496 r
.75972 .50621 m .75481 .50797 L .75892 .50466 L F
.76514 .5167 m .75481 .50797 L .75972 .50621 L F
.75081 .51118 m .75002 .51088 L p .75354 .50842 L F P
0 g
s
.835 .543 .496 r
.75081 .51118 m .75354 .50842 L .75481 .50797 L F
.89 .696 .633 r
.75147 .50495 m .74995 .50971 L p .75255 .50878 L F P
0 g
s
.89 .696 .633 r
.75389 .5083 m .75299 .50603 L p .75358 .50841 L F P
0 g
s
.835 .543 .496 r
.75002 .51088 m .74995 .50971 L p .75354 .50842 L F P
0 g
s
.835 .543 .496 r
.75892 .50466 m .7484 .48431 L .76409 .50051 L F
.907 .684 .59 r
.75192 .50299 m .75641 .48165 L p .76325 .50119 L F P
0 g
s
.907 .684 .59 r
.75629 .50678 m .75192 .50299 L .76325 .50119 L F
.898 .698 .623 r
.7552 .50766 m .75299 .50603 L .75389 .5083 L p F P
0 g
s
.835 .543 .496 r
.76409 .50051 m .76427 .50322 L p .75892 .50466 L F P
0 g
s
.835 .543 .496 r
.76427 .50322 m .76514 .5167 L p .7594 .5056 L F P
0 g
s
.835 .543 .496 r
.7594 .5056 m .75892 .50466 L .76427 .50322 L F
.907 .684 .59 r
.76325 .50119 m .76316 .50094 L .76409 .50051 L F
.857 .562 .487 r
.76688 .49924 m .76342 .49016 L .7736 .49617 L F
.907 .684 .59 r
.76316 .50094 m .75641 .48165 L .7736 .49617 L F
.857 .562 .487 r
.7736 .49617 m .7753 .52137 L p .76688 .49924 L F P
0 g
s
.76186 .50244 m
.76598 .50021 L
s
.76598 .50021 m
.76924 .49844 L
s
.914 .667 .551 r
.7739 .49472 m .75641 .48165 L .7592 .45927 L p F P
0 g
s
.531 .633 .896 r
.39324 .79663 m .3921 .79503 L .39404 .79496 L closepath p F P
0 g
s
.606 .381 .548 r
.71336 1.02827 m .71201 .99817 L .73854 .9938 L p F P
0 g
s
.649 .413 .548 r
.71201 .99817 m .71336 1.02827 L .6848 1.03066 L p F P
0 g
s
.88 .603 .514 r
.56587 .95351 m .54512 .94366 L .54495 .91416 L p F P
0 g
s
.923 .643 .492 r
.52812 .903 m .54495 .91416 L .54512 .94366 L p F P
0 g
s
.578 .661 .894 r
.4524 .80924 m .42888 .81242 L .41541 .79372 L p F P
0 g
s
.735 .481 .545 r
.65361 1.03048 m .62558 1.02805 L .62484 .99795 L p F P
0 g
s
.761 .503 .542 r
.61829 .99699 m .62484 .99795 L .62558 1.02805 L p F P
0 g
s
.452 .48 .798 r
.32033 .72018 m .30573 .71686 L .29468 .69143 L p F P
0 g
s
.869 .57 .48 r
.73276 .42096 m .71794 .4133 L .71683 .39268 L p F P
0 g
s
.848 .552 .489 r
.69173 .38155 m .71683 .39268 L .71794 .4133 L p F P
0 g
s
.91 .77 .694 r
.7679 .5806 m .7814 .59434 L .76929 .62032 L p F P
0 g
s
.922 .762 .667 r
.77631 .55918 m .7679 .5806 L .7814 .59434 L p F P
0 g
s
.894 .809 .757 r
.765 .66156 m .75405 .67823 L .74261 .66432 L p F P
0 g
s
.894 .809 .757 r
.74261 .66432 m .75366 .64755 L .765 .66156 L p F P
0 g
s
.907 .806 .737 r
.76569 .62702 m .75366 .64755 L .765 .66156 L p F P
0 g
s
.47 .244 .488 r
.3238 .41308 m .32491 .39246 L .34694 .38258 L p F P
0 g
s
.424 .207 .478 r
.32491 .39246 m .3238 .41308 L .30303 .42413 L p F P
0 g
s
.539 .611 .873 r
.39404 .79496 m .3921 .79503 L .37852 .77364 L p F P
0 g
s
.675 .75 .907 r
.55015 .81983 m .52621 .82869 L .51325 .8139 L p F P
0 g
s
.797 .512 .507 r
.7484 .48431 m .72269 .47723 L .72127 .451 L p F P
0 g
s
.766 .488 .513 r
.71478 .44974 m .72127 .451 L .72269 .47723 L p F P
0 g
s
.773 .431 .407 r
.64492 .34765 m .62691 .34321 L .62093 .32491 L p F P
0 g
s
.756 .422 .418 r
.60978 .32264 m .62093 .32491 L .62691 .34321 L p F P
0 g
s
.892 .644 .556 r
.73955 .44668 m .7592 .45927 L .75641 .48165 L p F P
0 g
s
.897 .623 .514 r
.7592 .45927 m .73955 .44668 L .74037 .42517 L p F P
0 g
s
.761 .503 .542 r
.62558 1.02805 m .61898 1.0271 L .61829 .99699 L p F P
0 g
s
.788 .525 .538 r
.59227 .99156 m .61829 .99699 L .61898 1.0271 L p F P
0 g
s
.876 .603 .521 r
.73276 .42096 m .74037 .42517 L .73955 .44668 L p F P
0 g
s
.547 .623 .879 r
.41541 .79372 m .39404 .79496 L .4061 .77943 L closepath p F P
0 g
s
.539 .611 .873 r
.40185 .77269 m .4061 .77943 L .39404 .79496 L p F P
0 g
s
.539 .611 .873 r
.37852 .77364 m .40185 .77269 L p .39404 .79496 L F P
0 g
s
.574 .271 .418 r
.42278 .34143 m .4256 .32388 L .45255 .31914 L p F P
0 g
s
.539 .241 .409 r
.4256 .32388 m .42278 .34143 L .39691 .34749 L p F P
0 g
s
.434 .271 .559 r
.28464 .48195 m .28355 .45841 L .30301 .44624 L p F P
0 g
s
.406 .223 .516 r
.30303 .42413 m .30301 .44624 L .28355 .45841 L p F P
0 g
s
.388 .236 .55 r
.28355 .45841 m .28464 .48195 L .27215 .49106 L p F P
0 g
s
.766 .488 .513 r
.72269 .47723 m .71615 .47598 L .71478 .44974 L p F P
0 g
s
.736 .464 .517 r
.68696 .44648 m .71478 .44974 L .71615 .47598 L p F P
0 g
s
0 0 .198 r
.83998 .73731 m .84074 .72998 L .83848 .70195 L p F P
0 g
s
.774 .572 .001 r
.83603 .68571 m .83848 .70195 L .84074 .72998 L p F P
0 g
s
.774 .572 .001 r
.83848 .70195 m .83603 .68571 L .83381 .65796 L p F P
0 g
s
.945 .637 .424 r
.81193 .57369 m .79671 .56039 L .79477 .53355 L p F P
0 g
s
.9 .597 .465 r
.7753 .52137 m .79477 .53355 L .79671 .56039 L p F P
0 g
s
.637 .387 .522 r
.62827 .47568 m .62751 .44944 L .65587 .44624 L p F P
0 g
s
.588 .348 .521 r
.62751 .44944 m .62827 .47568 L .60186 .4814 L p F P
0 g
s
.453 .258 .526 r
.30301 .44624 m .30303 .42413 L .3238 .41308 L p F P
0 g
s
.406 .281 .595 r
.27215 .49106 m .28676 .50488 L p .26922 .52058 L F P
0 g
s
.416 .281 .589 r
.28676 .50488 m .27215 .49106 L .28464 .48195 L closepath p F P
0 g
s
.756 .422 .418 r
.62691 .34321 m .60752 .33929 L .60978 .32264 L p F P
0 g
s
.738 .404 .416 r
.58227 .31823 m .60978 .32264 L .60752 .33929 L p F P
0 g
s
.842 .569 .527 r
.57677 .98701 m .56619 .98334 L .56587 .95351 L p F P
0 g
s
.88 .603 .514 r
.54512 .94366 m .56587 .95351 L .56619 .98334 L p F P
0 g
s
.493 .556 .848 r
.34802 .75961 m .34188 .74854 L .35478 .74955 L closepath p F P
0 g
s
.756 .799 .888 r
.63486 .79453 m .61078 .80919 L .59837 .79617 L p F P
0 g
s
.733 .794 .901 r
.57421 .80899 m .59837 .79617 L .61078 .80919 L p F P
0 g
s
.423 .368 .692 r
.26302 .59108 m .27872 .57597 L p .28061 .61175 L F P
0 g
s
.423 .368 .692 r
.28061 .61175 m .26639 .60498 L .26302 .59108 L p F P
0 g
s
.4 .332 .665 r
.27604 .56292 m .27872 .57597 L .26302 .59108 L p F P
0 g
s
.4 .332 .665 r
.26415 .55544 m .27604 .56292 L p .26302 .59108 L F P
0 g
s
0 0 .048 r
.50076 .73871 m .50146 .72845 L .5016 .70042 L p F P
0 g
s
0 0 .221 r
.50654 .68422 m .5016 .70042 L .50146 .72845 L p F P
0 g
s
0 0 .221 r
.5016 .70042 m .50654 .68422 L .50664 .65646 L p F P
0 g
s
.883 .81 .772 r
.74564 .68995 m .75405 .67823 L .74261 .66432 L p F P
0 g
s
.943 .669 .206 r
.82711 .64263 m .83381 .65796 L .83603 .68571 L p F P
0 g
s
.943 .669 .206 r
.83381 .65796 m .82711 .64263 L .82495 .61519 L p F P
0 g
s
.529 .302 .515 r
.57809 .51615 m .57769 .48961 L .60186 .4814 L p F P
0 g
s
.457 .247 .505 r
.57769 .48961 m .57809 .51615 L .55604 .52675 L p F P
0 g
s
.525 .26 .455 r
.37033 .37396 m .37234 .35485 L .39691 .34749 L p F P
0 g
s
.485 .226 .446 r
.37234 .35485 m .37033 .37396 L .34694 .38258 L p F P
0 g
s
.976 .672 .347 r
.82495 .61519 m .814 .60084 L .81193 .57369 L p F P
0 g
s
.945 .637 .424 r
.79671 .56039 m .81193 .57369 L .814 .60084 L p F P
0 g
s
.452 .48 .798 r
.29468 .69143 m .29786 .68711 L p .32033 .72018 L F P
0 g
s
.433 .454 .782 r
.29468 .69143 m .29229 .6855 L .29786 .68711 L closepath p F P
0 g
s
.976 .672 .347 r
.814 .60084 m .82495 .61519 L .82711 .64263 L p F P
0 g
s
.195 .049 .444 r
.51972 .60954 m .52902 .60013 L .52896 .57298 L p F P
0 g
s
.265 .102 .464 r
.53645 .56649 m .52896 .57298 L .52902 .60013 L p F P
0 g
s
.444 .444 .764 r
.29786 .68711 m .29229 .6855 L .28115 .65512 L p F P
0 g
s
.736 .464 .517 r
.71615 .47598 m .68814 .47273 L .68696 .44648 L p F P
0 g
s
.7 .435 .521 r
.66886 .44596 m .68696 .44648 L .68814 .47273 L p F P
0 g
s
.557 .343 .545 r
.74009 1.02394 m .73854 .9938 L .76332 .98744 L p F P
0 g
s
.606 .381 .548 r
.73854 .9938 m .74009 1.02394 L .71336 1.02827 L p F P
0 g
s
.413 .374 .706 r
.27091 .62194 m .26639 .60498 L .28061 .61175 L closepath p F P
0 g
s
.678 .419 .522 r
.65587 .44624 m .66886 .44596 L .66991 .47222 L p F P
0 g
s
.678 .419 .522 r
.66991 .47222 m .65683 .47249 L .65587 .44624 L p F P
0 g
s
.637 .387 .522 r
.65587 .44624 m .65683 .47249 L .62827 .47568 L p F P
0 g
s
.876 .603 .521 r
.73955 .44668 m .73627 .44489 L .73276 .42096 L p F P
0 g
s
.867 .596 .527 r
.71794 .4133 m .73276 .42096 L .73627 .44489 L p F P
0 g
s
.7 .435 .521 r
.68814 .47273 m .66991 .47222 L .66886 .44596 L p F P
0 g
s
.909 .734 .653 r
.77631 .55918 m .77764 .55546 L .77187 .55045 L closepath p F P
0 g
s
.919 .723 .623 r
.77764 .55546 m .77187 .55045 L .76437 .53448 L p F P
0 g
s
.41 .329 .654 r
.27604 .56292 m .26415 .55544 L .27314 .54737 L closepath p F P
0 g
s
.385 .29 .623 r
.26922 .52058 m .27314 .54737 L .26415 .55544 L p F P
0 g
s
0 0 .323 r
.50859 .65258 m .50664 .65646 L .50654 .68422 L p F P
0 g
s
.353 .193 .52 r
.81215 .9036 m .80383 .90907 L .80584 .93862 L p F P
0 g
s
.431 .249 .532 r
.80383 .90907 m .80584 .93862 L .78454 .94919 L p F P
0 g
s
.87 .811 .788 r
.74564 .68995 m .73064 .70894 L .71902 .6952 L p F P
0 g
s
.87 .811 .788 r
.71902 .6952 m .73414 .6761 L .74564 .68995 L p F P
0 g
s
.883 .81 .772 r
.74261 .66432 m .73414 .6761 L .74564 .68995 L p F P
0 g
s
.605 .299 .424 r
.44991 .3367 m .45255 .31914 L .4719 .31681 L p F P
0 g
s
.574 .271 .418 r
.45255 .31914 m .44991 .3367 L .42278 .34143 L p F P
0 g
s
.611 .699 .907 r
.4524 .80924 m .47616 .8041 L .48937 .8209 L p F P
0 g
s
.435 .406 .729 r
.27091 .62194 m .28061 .61175 L p .28463 .65103 L F P
0 g
s
.435 .406 .729 r
.28463 .65103 m .27911 .64899 L .27091 .62194 L p F P
0 g
s
.19 .076 .484 r
.83408 .8523 m .82063 .86623 L .82276 .89549 L p F P
0 g
s
.19 .076 .484 r
.82063 .86623 m .83408 .8523 L .83187 .82334 L p F P
0 g
s
.302 .156 .51 r
.81215 .9036 m .82276 .89549 L .82063 .86623 L p F P
0 g
s
.432 .323 .63 r
.27314 .54737 m .26922 .52058 L .28698 .507 L p F P
0 g
s
.406 .281 .595 r
.28676 .50488 m .28698 .507 L .26922 .52058 L p F P
0 g
s
.738 .404 .416 r
.60752 .33929 m .58869 .33629 L .58227 .31823 L p F P
0 g
s
.723 .396 .426 r
.57479 .31731 m .58227 .31823 L .58869 .33629 L p F P
0 g
s
.795 .482 .459 r
.64492 .34765 m .65973 .35192 L .66298 .37151 L p F P
0 g
s
.814 .495 .451 r
.68486 .37894 m .66298 .37151 L .65973 .35192 L p F P
0 g
s
.901 .733 .665 r
.7679 .5806 m .77631 .55918 L .77187 .55045 L p F P
0 g
s
.444 .444 .764 r
.28115 .65512 m .28463 .65103 L p .29786 .68711 L F P
0 g
s
.424 .414 .745 r
.28115 .65512 m .27911 .64899 L .28463 .65103 L closepath p F P
0 g
s
.501 .539 .828 r
.35478 .74955 m .34188 .74854 L .32827 .72153 L p F P
0 g
s
.069 0 .449 r
.83443 .81977 m .83187 .82334 L .83408 .8523 L p F P
0 g
s
.777 .803 .874 r
.64328 .78873 m .63486 .79453 L .62259 .78139 L p F P
0 g
s
.756 .799 .888 r
.59837 .79617 m .62259 .78139 L .63486 .79453 L p F P
0 g
s
.703 .758 .895 r
.57421 .80899 m .55015 .81983 L .53729 .80493 L p F P
0 g
s
.675 .75 .907 r
.51325 .8139 m .53729 .80493 L .55015 .81983 L p F P
0 g
s
.723 .396 .426 r
.58869 .33629 m .57256 .33432 L .57479 .31731 L p F P
0 g
s
.702 .377 .423 r
.54182 .31473 m .57479 .31731 L .57256 .33432 L p F P
0 g
s
.788 .525 .538 r
.61898 1.0271 m .59278 1.02172 L .59227 .99156 L p F P
0 g
s
.822 .553 .532 r
.57677 .98701 m .59227 .99156 L .59278 1.02172 L p F P
0 g
s
.612 .3 .417 r
.47918 .32669 m .4719 .31681 L .48083 .31591 L closepath p F P
0 g
s
.605 .299 .424 r
.4719 .31681 m .47918 .32669 L p .44991 .3367 L F P
0 g
s
.898 .775 .717 r
.76929 .62032 m .76569 .62702 L .75411 .60958 L p F P
0 g
s
.898 .775 .717 r
.75411 .60958 m .75567 .6067 L .76929 .62032 L p F P
0 g
s
.91 .77 .694 r
.76929 .62032 m .75567 .6067 L .7679 .5806 L p F P
0 g
s
.431 .249 .532 r
.78642 .97906 m .78454 .94919 L .80584 .93862 L p F P
0 g
s
.498 .299 .54 r
.78454 .94919 m .78642 .97906 L .76332 .98744 L p F P
0 g
s
.777 .803 .874 r
.62259 .78139 m .63107 .77554 L .64328 .78873 L p F P
0 g
s
.786 .805 .868 r
.64682 .76409 m .63107 .77554 L .64328 .78873 L p F P
0 g
s
.786 .805 .868 r
.64328 .78873 m .65894 .77736 L .64682 .76409 L p F P
0 g
s
.858 .811 .803 r
.72103 .72002 m .73064 .70894 L .71902 .6952 L p F P
0 g
s
.461 .469 .78 r
.31476 .6908 m .29786 .68711 L .30848 .67497 L closepath p F P
0 g
s
.444 .444 .764 r
.30142 .65569 m .30848 .67497 L .29786 .68711 L p F P
0 g
s
.444 .444 .764 r
.28463 .65103 m .30142 .65569 L p .29786 .68711 L F P
0 g
s
.452 .48 .798 r
.29786 .68711 m .31476 .6908 L p .32033 .72018 L F P
0 g
s
.641 .326 .423 r
.48083 .31591 m .51066 .31448 L .50821 .33179 L p F P
0 g
s
.641 .326 .423 r
.47918 .32669 m .48083 .31591 L p .50821 .33179 L F P
0 g
s
.457 .247 .505 r
.55629 .55362 m .55604 .52675 L .57809 .51615 L p F P
0 g
s
.369 .181 .489 r
.55604 .52675 m .55629 .55362 L .53645 .56649 L p F P
0 g
s
.797 .512 .507 r
.72269 .47723 m .7484 .48431 L .74995 .50971 L p F P
0 g
s
.797 .512 .507 r
.74935 .51005 m .72269 .47723 L .74995 .50971 L F
.87 .671 .631 r
.74995 .50971 m .74368 .52939 L p .73898 .516 L F P
0 g
s
.797 .512 .507 r
.75002 .51088 m .72413 .50384 L .72269 .47723 L p F P
0 g
s
.87 .671 .631 r
.73082 .49275 m .75147 .50495 L .74995 .50971 L p F P
0 g
s
.881 .707 .661 r
.74368 .52939 m .76196 .54211 L .75196 .5674 L p F P
0 g
s
.87 .671 .631 r
.74368 .52939 m .72976 .52127 L p .73898 .516 L F P
0 g
s
.797 .512 .507 r
.75002 .51088 m .75166 .53783 L p .73556 .51795 L F P
0 g
s
.797 .512 .507 r
.72413 .50384 m .74859 .51049 L p .73556 .51795 L F P
0 g
s
.797 .512 .507 r
.74859 .51049 m .75002 .51088 L p .73556 .51795 L F P
0 g
s
.881 .707 .661 r
.75196 .5674 m .73354 .55477 L .74368 .52939 L p F P
0 g
s
.863 .683 .657 r
.74368 .52939 m .73354 .55477 L p .72465 .52345 L F P
0 g
s
.766 .488 .513 r
.72367 .5241 m .71754 .50259 L .72518 .5231 L F
.863 .683 .657 r
.72465 .52345 m .72461 .52332 L .72477 .52337 L F
.72465 .52345 m .72477 .52337 L .74368 .52939 L F
.766 .488 .513 r
.71754 .50259 m .72413 .50384 L .72518 .5231 L p F P
0 g
s
.863 .683 .657 r
.72976 .52127 m .74368 .52939 L p .72461 .52332 L F P
0 g
s
.863 .683 .657 r
.71725 .53125 m .71884 .52731 L p .73354 .55477 L F P
0 g
s
.766 .488 .513 r
.71884 .52731 m .71754 .50259 L p .72367 .5241 L F P
0 g
s
.863 .683 .657 r
.71884 .52731 m .72289 .51726 L p .72465 .52345 L F P
0 g
s
.863 .683 .657 r
.73354 .55477 m .71884 .52731 L .72465 .52345 L F
.766 .488 .513 r
.72559 .53083 m .71896 .52958 L .71884 .52731 L p F P
0 g
s
.766 .488 .513 r
.72559 .53083 m .71884 .52731 L .72367 .5241 L F
.72518 .5231 m .72559 .53083 L p .72367 .5241 L F P
0 g
s
.797 .512 .507 r
.75166 .53783 m .72559 .53083 L .72518 .5231 L p F P
0 g
s
.797 .512 .507 r
.72518 .5231 m .72413 .50384 L p .73618 .51872 L F P
0 g
s
.797 .512 .507 r
.75166 .53783 m .72518 .5231 L .73618 .51872 L F
.863 .683 .657 r
.72289 .51726 m .72976 .52127 L p .72461 .52332 L F P
0 g
s
.87 .671 .631 r
.72289 .51726 m .73082 .49275 L p .73898 .516 L F P
0 g
s
.87 .671 .631 r
.72976 .52127 m .72289 .51726 L p .73898 .516 L F P
0 g
s
.87 .671 .631 r
.73898 .516 m .73082 .49275 L .74995 .50971 L F
.797 .512 .507 r
.74995 .50971 m .75002 .51088 L p .74935 .51005 L F P
0 g
s
0 0 .198 r
.84074 .72998 m .83998 .73731 L .84225 .76568 L p F P
0 g
s
0 0 .286 r
.8398 .77577 m .84225 .76568 L .83998 .73731 L p F P
0 g
s
.468 .502 .811 r
.32827 .72153 m .32033 .72018 L .32489 .71419 L closepath p F P
0 g
s
.452 .48 .798 r
.31476 .6908 m .32489 .71419 L .32033 .72018 L p F P
0 g
s
.51 .276 .496 r
.34595 .40324 m .34694 .38258 L .37033 .37396 L p F P
0 g
s
.47 .244 .488 r
.34694 .38258 m .34595 .40324 L .3238 .41308 L p F P
0 g
s
0 0 .323 r
.50654 .68422 m .5085 .68036 L .50859 .65258 L p F P
0 g
s
.036 0 .392 r
.51971 .63703 m .50859 .65258 L .5085 .68036 L p F P
0 g
s
.036 0 .392 r
.50859 .65258 m .51971 .63703 L .51972 .60954 L p F P
0 g
s
.846 .811 .815 r
.72103 .72002 m .7069 .73506 L .69511 .72149 L p F P
0 g
s
.846 .811 .815 r
.69511 .72149 m .70934 .70636 L .72103 .72002 L p F P
0 g
s
.858 .811 .803 r
.71902 .6952 m .70934 .70636 L .72103 .72002 L p F P
0 g
s
.612 .675 .886 r
.47616 .8041 m .4524 .80924 L .43899 .79043 L p F P
0 g
s
.578 .661 .894 r
.41541 .79372 m .43899 .79043 L .4524 .80924 L p F P
0 g
s
.702 .377 .423 r
.54029 .32533 m .54182 .31473 L p .57256 .33432 L F P
0 g
s
.678 .355 .419 r
.54029 .32533 m .53522 .31453 L .54182 .31473 L closepath p F P
0 g
s
.889 .775 .73 r
.75366 .64755 m .76569 .62702 L .75411 .60958 L p F P
0 g
s
.804 .807 .853 r
.68298 .75779 m .65894 .77736 L .64682 .76409 L p F P
0 g
s
.667 .35 .427 r
.53522 .31453 m .54029 .32533 L p .50821 .33179 L F P
0 g
s
.667 .35 .427 r
.50821 .33179 m .51066 .31448 L .53522 .31453 L p F P
0 g
s
.901 .733 .665 r
.77187 .55045 m .76196 .54211 L p .7679 .5806 L F P
0 g
s
.911 .723 .634 r
.77187 .55045 m .76437 .53448 L .76196 .54211 L closepath p F P
0 g
s
.195 .049 .444 r
.52902 .60013 m .51972 .60954 L .51971 .63703 L p F P
0 g
s
.848 .552 .489 r
.71794 .4133 m .6927 .4022 L .69173 .38155 L p F P
0 g
s
.828 .536 .495 r
.68486 .37894 m .69173 .38155 L .6927 .4022 L p F P
0 g
s
.795 .482 .459 r
.66298 .37151 m .64409 .36611 L .64492 .34765 L p F P
0 g
s
.78 .468 .46 r
.62691 .34321 m .64492 .34765 L .64409 .36611 L p F P
0 g
s
.544 .592 .853 r
.40185 .77269 m .37852 .77364 L .36489 .74998 L p F P
0 g
s
.561 .29 .462 r
.39505 .36661 m .39691 .34749 L .42278 .34143 L p F P
0 g
s
.525 .26 .455 r
.39691 .34749 m .39505 .36661 L .37033 .37396 L p F P
0 g
s
.831 .81 .83 r
.68897 .75237 m .7069 .73506 L .69511 .72149 L p F P
0 g
s
.821 .809 .839 r
.68897 .75237 m .68298 .75779 L .67102 .74437 L p F P
0 g
s
.804 .807 .853 r
.64682 .76409 m .67102 .74437 L .68298 .75779 L p F P
0 g
s
.453 .434 .748 r
.30142 .65569 m .28463 .65103 L .29594 .6394 L closepath p F P
0 g
s
.821 .809 .839 r
.67102 .74437 m .67705 .73892 L .68897 .75237 L p F P
0 g
s
.831 .81 .83 r
.69511 .72149 m .67705 .73892 L .68897 .75237 L p F P
0 g
s
.435 .406 .729 r
.28839 .61452 m .29594 .6394 L .28463 .65103 L p F P
0 g
s
.435 .406 .729 r
.28061 .61175 m .28839 .61452 L p .28463 .65103 L F P
0 g
s
.369 .181 .489 r
.53656 .59368 m .53645 .56649 L .55629 .55362 L p F P
0 g
s
.265 .102 .464 r
.52902 .60013 m .53656 .59368 L .53645 .56649 L p F P
0 g
s
.458 .312 .595 r
.28464 .48195 m .30419 .46985 L p .28858 .50597 L F P
0 g
s
.458 .312 .595 r
.28858 .50597 m .28676 .50488 L .28464 .48195 L p F P
0 g
s
.434 .271 .559 r
.30301 .44624 m .30419 .46985 L .28464 .48195 L p F P
0 g
s
0 0 .394 r
.84207 .80447 m .83443 .81977 L .83666 .84876 L p F P
0 g
s
.069 0 .449 r
.83408 .8523 m .83666 .84876 L .83443 .81977 L p F P
0 g
s
0 0 .394 r
.83443 .81977 m .84207 .80447 L .8398 .77577 L p F P
0 g
s
.582 .639 .873 r
.42548 .7695 m .43899 .79043 L .41541 .79372 L p F P
0 g
s
.582 .639 .873 r
.41659 .77078 m .42548 .7695 L p .41541 .79372 L F P
0 g
s
.582 .639 .873 r
.41541 .79372 m .4061 .77943 L .41659 .77078 L p F P
0 g
s
.892 .644 .556 r
.73846 .45507 m .73955 .44668 L p .75641 .48165 L F P
0 g
s
.892 .644 .556 r
.75641 .48165 m .74284 .47305 L .73846 .45507 L p F P
0 g
s
.886 .661 .592 r
.75192 .50299 m .75641 .48165 L .74284 .47305 L closepath p F P
0 g
s
.588 .348 .521 r
.60244 .50799 m .60186 .4814 L .62827 .47568 L p F P
0 g
s
.529 .302 .515 r
.60186 .4814 m .60244 .50799 L .57809 .51615 L p F P
0 g
s
.353 .193 .52 r
.80584 .93862 m .81422 .9332 L .81215 .9036 L p F P
0 g
s
.302 .156 .51 r
.82276 .89549 m .81215 .9036 L .81422 .9332 L p F P
0 g
s
.966 .687 .452 r
.52812 .903 m .51509 .89056 L .51513 .86126 L p F P
0 g
s
.989 .723 .376 r
.50603 .84739 m .51513 .86126 L .51509 .89056 L p F P
0 g
s
.989 .723 .376 r
.51513 .86126 m .50603 .84739 L .50613 .81838 L p F P
0 g
s
.867 .596 .527 r
.73627 .44489 m .7168 .43493 L .71794 .4133 L p F P
0 g
s
.846 .577 .531 r
.6927 .4022 m .71794 .4133 L .7168 .43493 L p F P
0 g
s
.494 .29 .532 r
.32387 .43524 m .3238 .41308 L .34595 .40324 L p F P
0 g
s
.453 .258 .526 r
.3238 .41308 m .32387 .43524 L .30301 .44624 L p F P
0 g
s
.872 .623 .559 r
.73846 .45507 m .73955 .44668 L .73627 .44489 L closepath p F P
0 g
s
.75668 .50536 m
.76186 .50244 L
s
.73829 .51573 m
.74631 .51121 L
s
.50047 .79541 m
.50047 .79543 L
s
.923 .643 .492 r
.54512 .94366 m .52817 .9326 L .52812 .903 L p F P
0 g
s
.966 .687 .452 r
.51509 .89056 m .52812 .903 L .52817 .9326 L p F P
0 g
s
.828 .536 .495 r
.6927 .4022 m .68579 .39961 L .68486 .37894 L p F P
0 g
s
.816 .526 .498 r
.66298 .37151 m .68486 .37894 L .68579 .39961 L p F P
0 g
s
.498 .299 .54 r
.76505 1.01765 m .76332 .98744 L .78642 .97906 L p F P
0 g
s
.557 .343 .545 r
.76332 .98744 m .76505 1.01765 L .74009 1.02394 L p F P
0 g
s
.942 .715 .244 r
.50098 .803 m .50613 .81838 L .50603 .84739 L p F P
0 g
s
.476 .302 .565 r
.30419 .46985 m .30301 .44624 L .32387 .43524 L p F P
0 g
s
.728 .765 .883 r
.59837 .79617 m .57421 .80899 L .56148 .79398 L p F P
0 g
s
.703 .758 .895 r
.53729 .80493 m .56148 .79398 L .57421 .80899 L p F P
0 g
s
0 0 .286 r
.84225 .76568 m .8398 .77577 L .84207 .80447 L p F P
0 g
s
.453 .358 .658 r
.27314 .54737 m .29098 .53392 L p .28847 .5682 L F P
0 g
s
.453 .358 .658 r
.28847 .5682 m .27604 .56292 L .27314 .54737 L p F P
0 g
s
.432 .323 .63 r
.28698 .507 m .29098 .53392 L .27314 .54737 L p F P
0 g
s
.822 .553 .532 r
.59278 1.02172 m .57716 1.01723 L .57677 .98701 L p F P
0 g
s
.842 .569 .527 r
.56619 .98334 m .57677 .98701 L .57716 1.01723 L p F P
0 g
s
.891 .742 .69 r
.75196 .5674 m .7679 .5806 L .75567 .6067 L p F P
0 g
s
.901 .733 .665 r
.76196 .54211 m .75196 .5674 L .7679 .5806 L p F P
0 g
s
.9 .597 .465 r
.79671 .56039 m .77711 .54827 L .7753 .52137 L p F P
0 g
s
.857 .562 .487 r
.76514 .5167 m .7753 .52137 L .77711 .54827 L p F P
0 g
s
.501 .539 .828 r
.35126 .72318 m .36091 .74244 L .35478 .74955 L p F P
0 g
s
.501 .539 .828 r
.32827 .72153 m .35126 .72318 L p .35478 .74955 L F P
0 g
s
.512 .556 .837 r
.36489 .74998 m .35478 .74955 L .36091 .74244 L closepath p F P
0 g
s
.507 .524 .809 r
.3401 .69888 m .35126 .72318 L .32827 .72153 L p F P
0 g
s
.507 .524 .809 r
.32827 .72153 m .32489 .71419 L .3401 .69888 L p F P
0 g
s
.863 .618 .567 r
.73627 .44489 m .7168 .43493 L p .73641 .4692 L F P
0 g
s
.863 .618 .567 r
.73641 .4692 m .73846 .45507 L .73627 .44489 L p F P
0 g
s
.78 .468 .46 r
.64409 .36611 m .63024 .36272 L .62691 .34321 L p F P
0 g
s
.763 .456 .467 r
.60752 .33929 m .62691 .34321 L .63024 .36272 L p F P
0 g
s
.88 .603 .514 r
.56619 .98334 m .54529 .97358 L .54512 .94366 L p F P
0 g
s
.923 .643 .492 r
.52817 .9326 m .54512 .94366 L .54529 .97358 L p F P
0 g
s
.877 .779 .749 r
.75366 .64755 m .74261 .66432 L .73087 .64743 L p F P
0 g
s
.877 .779 .749 r
.73087 .64743 m .73966 .63413 L .75366 .64755 L p F P
0 g
s
.889 .775 .73 r
.75411 .60958 m .73966 .63413 L .75366 .64755 L p F P
0 g
s
.766 .488 .513 r
.71615 .47598 m .72269 .47723 L .72413 .50384 L p F P
0 g
s
.495 .505 .797 r
.33768 .69327 m .3401 .69888 L .32489 .71419 L p F P
0 g
s
.495 .505 .797 r
.32489 .71419 m .31476 .6908 L .33768 .69327 L p F P
0 g
s
.592 .316 .467 r
.42107 .36057 m .42278 .34143 L .44991 .3367 L p F P
0 g
s
.561 .29 .462 r
.42278 .34143 m .42107 .36057 L .39505 .36661 L p F P
0 g
s
.446 .364 .67 r
.27872 .57597 m .27604 .56292 L .28847 .5682 L closepath p F P
0 g
s
.443 .399 .714 r
.28839 .61452 m .28061 .61175 L .28616 .60651 L closepath p F P
0 g
s
.423 .368 .692 r
.27872 .57597 m .28616 .60651 L .28061 .61175 L p F P
0 g
s
.884 .64 .564 r
.74284 .47305 m .73846 .45507 L .73641 .4692 L closepath p F P
0 g
s
.766 .488 .513 r
.72413 .50384 m .71754 .50259 L .71615 .47598 L p F P
0 g
s
.736 .464 .517 r
.68814 .47273 m .71615 .47598 L .71754 .50259 L p F P
0 g
s
0 0 .198 r
.84225 .76568 m .84302 .75841 L .84074 .72998 L p F P
0 g
s
.774 .572 .001 r
.84074 .72998 m .83828 .71385 L .83603 .68571 L p F P
0 g
s
.774 .572 .001 r
.83828 .71385 m .84074 .72998 L .84302 .75841 L p F P
0 g
s
.945 .637 .424 r
.814 .60084 m .79868 .58761 L .79671 .56039 L p F P
0 g
s
.9 .597 .465 r
.77711 .54827 m .79671 .56039 L .79868 .58761 L p F P
0 g
s
.637 .387 .522 r
.62904 .5023 m .62827 .47568 L .65683 .47249 L p F P
0 g
s
.588 .348 .521 r
.62827 .47568 m .62904 .5023 L .60244 .50799 L p F P
0 g
s
.546 .305 .502 r
.36947 .39464 m .37033 .37396 L .39505 .36661 L p F P
0 g
s
.51 .276 .496 r
.37033 .37396 m .36947 .39464 L .34595 .40324 L p F P
0 g
s
.842 .569 .527 r
.57716 1.01723 m .56651 1.01359 L .56619 .98334 L p F P
0 g
s
.88 .603 .514 r
.54529 .97358 m .56619 .98334 L .56651 1.01359 L p F P
0 g
s
.641 .326 .423 r
.50821 .33179 m .48268 .333 L .47918 .32669 L p F P
0 g
s
.632 .323 .43 r
.48268 .333 m .47826 .3333 L .47918 .32669 L closepath p F P
0 g
s
.605 .299 .424 r
.47918 .32669 m .47826 .3333 L .44991 .3367 L p F P
0 g
s
.749 .771 .87 r
.62259 .78139 m .59837 .79617 L .58576 .78105 L p F P
0 g
s
.728 .765 .883 r
.56148 .79398 m .58576 .78105 L .59837 .79617 L p F P
0 g
s
.763 .456 .467 r
.63024 .36272 m .60663 .35798 L .60752 .33929 L p F P
0 g
s
.746 .441 .467 r
.58869 .33629 m .60752 .33929 L .60663 .35798 L p F P
0 g
s
.866 .779 .763 r
.73414 .6761 m .74261 .66432 L .73087 .64743 L p F P
0 g
s
.857 .562 .487 r
.77711 .54827 m .76689 .54363 L .76514 .5167 L p F P
0 g
s
.835 .543 .496 r
.75002 .51088 m .76514 .5167 L .76689 .54363 L p F P
0 g
s
.576 .629 .867 r
.4061 .77943 m .40185 .77269 L .41659 .77078 L closepath p F P
0 g
s
.643 .687 .877 r
.50013 .797 m .47616 .8041 L .46283 .78519 L p F P
0 g
s
.612 .675 .886 r
.43899 .79043 m .46283 .78519 L .47616 .8041 L p F P
0 g
s
.466 .396 .695 r
.28616 .60651 m .27872 .57597 L .28847 .5682 L p F P
0 g
s
0 0 .221 r
.50146 .72845 m .50644 .71237 L .50654 .68422 L p F P
0 g
s
.452 .314 .602 r
.28698 .507 m .28676 .50488 L .28858 .50597 L closepath p F P
0 g
s
.943 .669 .206 r
.8293 .67047 m .83603 .68571 L .83828 .71385 L p F P
0 g
s
.943 .669 .206 r
.83603 .68571 m .8293 .67047 L .82711 .64263 L p F P
0 g
s
.529 .302 .515 r
.5785 .54308 m .57809 .51615 L .60244 .50799 L p F P
0 g
s
.457 .247 .505 r
.57809 .51615 m .5785 .54308 L .55629 .55362 L p F P
0 g
s
.689 .371 .431 r
.54292 .33202 m .53945 .33185 L .54029 .32533 L closepath p F P
0 g
s
.667 .35 .427 r
.54029 .32533 m .53945 .33185 L .50821 .33179 L p F P
0 g
s
.702 .377 .423 r
.57256 .33432 m .54292 .33202 L .54029 .32533 L p F P
0 g
s
.976 .672 .347 r
.82711 .64263 m .81609 .62837 L .814 .60084 L p F P
0 g
s
.945 .637 .424 r
.79868 .58761 m .814 .60084 L .81609 .62837 L p F P
0 g
s
.816 .526 .498 r
.68579 .39961 m .66379 .3922 L .66298 .37151 L p F P
0 g
s
.798 .511 .503 r
.64409 .36611 m .66298 .37151 L .66379 .3922 L p F P
0 g
s
.544 .592 .853 r
.36489 .74998 m .38825 .7489 L .40185 .77269 L p F P
0 g
s
.547 .574 .833 r
.37745 .72828 m .38825 .7489 L .36489 .74998 L p F P
0 g
s
.547 .574 .833 r
.36489 .74998 m .36091 .74244 L .37745 .72828 L p F P
0 g
s
.5 .492 .779 r
.32464 .66033 m .33768 .69327 L .31476 .6908 L p F P
0 g
s
.5 .492 .779 r
.31476 .6908 m .30848 .67497 L .32464 .66033 L p F P
0 g
s
.474 .352 .634 r
.29098 .53392 m .28698 .507 L .28858 .50597 L p F P
0 g
s
.877 .657 .601 r
.74284 .47305 m .73641 .4692 L p .75147 .50495 L F P
0 g
s
.877 .657 .601 r
.75147 .50495 m .75192 .50299 L .74284 .47305 L p F P
0 g
s
.976 .672 .347 r
.81609 .62837 m .82711 .64263 L .8293 .67047 L p F P
0 g
s
.195 .049 .444 r
.51971 .63703 m .52907 .62767 L .52902 .60013 L p F P
0 g
s
.265 .102 .464 r
.53656 .59368 m .52902 .60013 L .52907 .62767 L p F P
0 g
s
.736 .464 .517 r
.71754 .50259 m .68934 .49936 L .68814 .47273 L p F P
0 g
s
.7 .435 .521 r
.66991 .47222 m .68814 .47273 L .68934 .49936 L p F P
0 g
s
.856 .781 .778 r
.73414 .6761 m .71902 .6952 L .70712 .67878 L p F P
0 g
s
.856 .781 .778 r
.70712 .67878 m .71971 .66291 L .73414 .6761 L p F P
0 g
s
.866 .779 .763 r
.73087 .64743 m .71971 .66291 L .73414 .6761 L p F P
0 g
s
.678 .419 .522 r
.65683 .47249 m .66991 .47222 L .67098 .49885 L p F P
0 g
s
.678 .419 .522 r
.67098 .49885 m .6578 .49912 L .65683 .47249 L p F P
0 g
s
.637 .387 .522 r
.65683 .47249 m .6578 .49912 L .62904 .5023 L p F P
0 g
s
.62 .34 .471 r
.44837 .35584 m .44991 .3367 L .47826 .3333 L p F P
0 g
s
.592 .316 .467 r
.44991 .3367 m .44837 .35584 L .42107 .36057 L p F P
0 g
s
.7 .435 .521 r
.68934 .49936 m .67098 .49885 L .66991 .47222 L p F P
0 g
s
0 0 .323 r
.5085 .68036 m .50654 .68422 L .50644 .71237 L p F P
0 g
s
.899 .682 .6 r
.75299 .50603 m .75192 .50299 L .75147 .50495 L closepath p F P
0 g
s
.474 .352 .634 r
.28858 .50597 m .3091 .5132 L p .29098 .53392 L F P
0 g
s
.477 .347 .625 r
.3091 .5132 m .28858 .50597 L .3066 .49496 L closepath p F P
0 g
s
.458 .312 .595 r
.30419 .46985 m .3066 .49496 L .28858 .50597 L p F P
0 g
s
.746 .441 .467 r
.60663 .35798 m .59214 .35569 L .58869 .33629 L p F P
0 g
s
.731 .431 .472 r
.57256 .33432 m .58869 .33629 L .59214 .35569 L p F P
0 g
s
.353 .193 .52 r
.81422 .9332 m .80584 .93862 L .80788 .96859 L p F P
0 g
s
.431 .249 .532 r
.80584 .93862 m .80788 .96859 L .78642 .97906 L p F P
0 g
s
.699 .731 .876 r
.56148 .79398 m .53729 .80493 L .52428 .78793 L p F P
0 g
s
.613 .653 .866 r
.46283 .78519 m .43899 .79043 L .42548 .7695 L p F P
0 g
s
.487 .469 .764 r
.32422 .65918 m .32464 .66033 L .30848 .67497 L p F P
0 g
s
.487 .469 .764 r
.30848 .67497 m .30142 .65569 L .32422 .65918 L p F P
0 g
s
.53 .319 .538 r
.34614 .42544 m .34595 .40324 L .36947 .39464 L p F P
0 g
s
.494 .29 .532 r
.34595 .40324 m .34614 .42544 L .32387 .43524 L p F P
0 g
s
.19 .076 .484 r
.83632 .88168 m .82276 .89549 L .82492 .92516 L p F P
0 g
s
.302 .156 .51 r
.81422 .9332 m .82492 .92516 L .82276 .89549 L p F P
0 g
s
.19 .076 .484 r
.82276 .89549 m .83632 .88168 L .83408 .8523 L p F P
0 g
s
.877 .657 .601 r
.73641 .4692 m .73082 .49275 L .75147 .50495 L p F P
0 g
s
.578 .609 .847 r
.41659 .77078 m .40185 .77269 L .38825 .7489 L p F P
0 g
s
.881 .748 .711 r
.75411 .60958 m .75567 .6067 L .74967 .60181 L closepath p F P
0 g
s
.891 .742 .69 r
.74218 .58813 m .75196 .5674 L p .75567 .6067 L F P
0 g
s
.891 .742 .69 r
.75567 .6067 m .74967 .60181 L .74218 .58813 L p F P
0 g
s
.769 .775 .858 r
.63107 .77554 m .62259 .78139 L .61011 .76615 L p F P
0 g
s
.749 .771 .87 r
.58576 .78105 m .61011 .76615 L .62259 .78139 L p F P
0 g
s
.539 .56 .824 r
.37461 .72257 m .37745 .72828 L .36091 .74244 L p F P
0 g
s
.539 .56 .824 r
.36091 .74244 m .35126 .72318 L .37461 .72257 L p F P
0 g
s
.482 .424 .716 r
.28839 .61452 m .28616 .60651 L .30363 .59283 L p F P
0 g
s
.466 .396 .695 r
.2983 .57107 m .30363 .59283 L .28616 .60651 L p F P
0 g
s
.466 .396 .695 r
.28847 .5682 m .2983 .57107 L p .28616 .60651 L F P
0 g
s
.069 0 .449 r
.83666 .84876 m .83408 .8523 L .83632 .88168 L p F P
0 g
s
.731 .431 .472 r
.59214 .35569 m .57158 .3532 L .57256 .33432 L p F P
0 g
s
.712 .414 .471 r
.54292 .33202 m .57256 .33432 L .57158 .3532 L p F P
0 g
s
.477 .433 .73 r
.29594 .6394 m .28839 .61452 L .31102 .61932 L p F P
0 g
s
.482 .424 .716 r
.30363 .59283 m .31102 .61932 L .28839 .61452 L p F P
0 g
s
.846 .577 .531 r
.7168 .43493 m .69142 .42387 L .6927 .4022 L p F P
0 g
s
.828 .56 .534 r
.68579 .39961 m .6927 .4022 L .69142 .42387 L p F P
0 g
s
.871 .747 .723 r
.73966 .63413 m .75411 .60958 L .74967 .60181 L p F P
0 g
s
.492 .458 .748 r
.31283 .62529 m .32422 .65918 L .30142 .65569 L p F P
0 g
s
.492 .458 .748 r
.30142 .65569 m .29594 .6394 L .31283 .62529 L p F P
0 g
s
.496 .34 .599 r
.3066 .49496 m .30419 .46985 L .32516 .45892 L p F P
0 g
s
.476 .302 .565 r
.32387 .43524 m .32516 .45892 L .30419 .46985 L p F P
0 g
s
.769 .775 .858 r
.61011 .76615 m .61377 .76362 L .63107 .77554 L p F P
0 g
s
.776 .775 .851 r
.63448 .74854 m .61377 .76362 L .63107 .77554 L p F P
0 g
s
.776 .775 .851 r
.63107 .77554 m .64682 .76409 L .63448 .74854 L p F P
0 g
s
.843 .78 .791 r
.70934 .70636 m .71902 .6952 L .70712 .67878 L p F P
0 g
s
.477 .433 .73 r
.31102 .61932 m .31283 .62529 L .29594 .6394 L p F P
0 g
s
.431 .249 .532 r
.78832 1.00936 m .78642 .97906 L .80788 .96859 L p F P
0 g
s
.498 .299 .54 r
.78642 .97906 m .78832 1.00936 L .76505 1.01765 L p F P
0 g
s
.645 .361 .474 r
.47826 .3333 m .48268 .333 L .48729 .35174 L p F P
0 g
s
.645 .361 .474 r
.48729 .35174 m .47689 .35246 L .47826 .3333 L p F P
0 g
s
.62 .34 .471 r
.47826 .3333 m .47689 .35246 L .44837 .35584 L p F P
0 g
s
.513 .33 .57 r
.32516 .45892 m .32387 .43524 L .34614 .42544 L p F P
0 g
s
.858 .635 .6 r
.71339 .45755 m .73641 .4692 L .73082 .49275 L p F P
0 g
s
.863 .618 .567 r
.7168 .43493 m .71339 .45755 L .73641 .4692 L p F P
0 g
s
.655 .367 .472 r
.48268 .333 m .50821 .33179 L .50693 .35082 L p F P
0 g
s
.655 .367 .472 r
.50693 .35082 m .48729 .35174 L .48268 .333 L p F P
0 g
s
.843 .598 .567 r
.69142 .42387 m .7168 .43493 L .71339 .45755 L p F P
0 g
s
.457 .247 .505 r
.55654 .58087 m .55629 .55362 L .5785 .54308 L p F P
0 g
s
.369 .181 .489 r
.55629 .55362 m .55654 .58087 L .53656 .59368 L p F P
0 g
s
.578 .331 .506 r
.39433 .38732 m .39505 .36661 L .42107 .36057 L p F P
0 g
s
.546 .305 .502 r
.39505 .36661 m .39433 .38732 L .36947 .39464 L p F P
0 g
s
.833 .782 .803 r
.70934 .70636 m .69511 .72149 L .68306 .70546 L p F P
0 g
s
.833 .782 .803 r
.68306 .70546 m .69437 .69345 L .70934 .70636 L p F P
0 g
s
.843 .78 .791 r
.70712 .67878 m .69437 .69345 L .70934 .70636 L p F P
0 g
s
.835 .543 .496 r
.76689 .54363 m .75166 .53783 L .75002 .51088 L p F P
0 g
s
0 0 .198 r
.84302 .75841 m .84225 .76568 L .84456 .79446 L p F P
0 g
s
0 0 .286 r
.84207 .80447 m .84456 .79446 L .84225 .76568 L p F P
0 g
s
.794 .778 .838 r
.67102 .74437 m .64682 .76409 L .63448 .74854 L p F P
0 g
s
.798 .511 .503 r
.66379 .3922 m .6448 .38682 L .64409 .36611 L p F P
0 g
s
.783 .499 .505 r
.63024 .36272 m .64409 .36611 L .6448 .38682 L p F P
0 g
s
.712 .414 .471 r
.57158 .3532 m .54652 .35127 L .54292 .33202 L p F P
0 g
s
.699 .406 .475 r
.53945 .33185 m .54292 .33202 L .54652 .35127 L p F P
0 g
s
0 0 .323 r
.50644 .71237 m .50841 .70854 L .5085 .68036 L p F P
0 g
s
.036 0 .392 r
.5197 .6649 m .5085 .68036 L .50841 .70854 L p F P
0 g
s
.036 0 .392 r
.5085 .68036 m .5197 .6649 L .51971 .63703 L p F P
0 g
s
.699 .406 .475 r
.54652 .35127 m .53837 .35088 L .53945 .33185 L p F P
0 g
s
.678 .388 .474 r
.53945 .33185 m .53837 .35088 L .50693 .35082 L p F P
0 g
s
.678 .388 .474 r
.50693 .35082 m .50821 .33179 L .53945 .33185 L p F P
0 g
s
.828 .56 .534 r
.69142 .42387 m .68845 .42277 L .68579 .39961 L p F P
0 g
s
.816 .551 .539 r
.66379 .3922 m .68579 .39961 L .68845 .42277 L p F P
0 g
s
.819 .78 .816 r
.67705 .73892 m .69511 .72149 L .68306 .70546 L p F P
0 g
s
.195 .049 .444 r
.52907 .62767 m .51971 .63703 L .5197 .6649 L p F P
0 g
s
.81 .781 .826 r
.67705 .73892 m .67102 .74437 L .65882 .72869 L p F P
0 g
s
.794 .778 .838 r
.63448 .74854 m .65882 .72869 L .67102 .74437 L p F P
0 g
s
.819 .78 .816 r
.68306 .70546 m .66143 .72634 L .67705 .73892 L p F P
0 g
s
.81 .781 .826 r
.65882 .72869 m .66143 .72634 L .67705 .73892 L p F P
0 g
s
.471 .389 .682 r
.2983 .57107 m .28847 .5682 L .29634 .56235 L closepath p F P
0 g
s
.453 .358 .658 r
.29098 .53392 m .29634 .56235 L .28847 .5682 L p F P
0 g
s
.369 .181 .489 r
.53667 .62125 m .53656 .59368 L .55654 .58087 L p F P
0 g
s
.265 .102 .464 r
.52907 .62767 m .53667 .62125 L .53656 .59368 L p F P
0 g
s
0 0 .394 r
.84438 .83359 m .83666 .84876 L .83893 .87817 L p F P
0 g
s
0 0 .394 r
.83666 .84876 m .84438 .83359 L .84207 .80447 L p F P
0 g
s
.069 0 .449 r
.83632 .88168 m .83893 .87817 L .83666 .84876 L p F P
0 g
s
.643 .687 .877 r
.46283 .78519 m .48687 .77798 L .50013 .797 L p F P
0 g
s
.491 .384 .661 r
.29634 .56235 m .29098 .53392 L .31038 .52167 L p F P
0 g
s
.474 .352 .634 r
.3091 .5132 m .31038 .52167 L .29098 .53392 L p F P
0 g
s
.721 .738 .865 r
.58576 .78105 m .56148 .79398 L .54856 .77686 L p F P
0 g
s
.699 .731 .876 r
.52428 .78793 m .54856 .77686 L .56148 .79398 L p F P
0 g
s
.871 .747 .723 r
.74967 .60181 m .73931 .5937 L p .73966 .63413 L F P
0 g
s
.881 .741 .702 r
.74967 .60181 m .74218 .58813 L .73931 .5937 L closepath p F P
0 g
s
.588 .348 .521 r
.60303 .53496 m .60244 .50799 L .62904 .5023 L p F P
0 g
s
.529 .302 .515 r
.60244 .50799 m .60303 .53496 L .5785 .54308 L p F P
0 g
s
.542 .543 .806 r
.361 .69281 m .37461 .72257 L .35126 .72318 L p F P
0 g
s
.542 .543 .806 r
.34736 .69326 m .361 .69281 L p .35126 .72318 L F P
0 g
s
.542 .543 .806 r
.35126 .72318 m .3401 .69888 L .34736 .69326 L p F P
0 g
s
.873 .716 .685 r
.75196 .5674 m .74218 .58813 L .7299 .56243 L p F P
0 g
s
.873 .716 .685 r
.7299 .56243 m .73354 .55477 L .75196 .5674 L p F P
0 g
s
.353 .193 .52 r
.80788 .96859 m .81633 .96322 L .81422 .9332 L p F P
0 g
s
.302 .156 .51 r
.82492 .92516 m .81422 .9332 L .81633 .96322 L p F P
0 g
s
.966 .687 .452 r
.52817 .9326 m .51504 .92028 L .51509 .89056 L p F P
0 g
s
.989 .723 .376 r
.50592 .87681 m .51509 .89056 L .51504 .92028 L p F P
0 g
s
.989 .723 .376 r
.51509 .89056 m .50592 .87681 L .50603 .84739 L p F P
0 g
s
.783 .499 .505 r
.6448 .38682 m .63087 .38343 L .63024 .36272 L p F P
0 g
s
.767 .486 .508 r
.60663 .35798 m .63024 .36272 L .63087 .38343 L p F P
0 g
s
.50047 .79541 m
.50048 .7946 L
s
.50065 .77864 m
.50071 .77321 L
s
.923 .643 .492 r
.54529 .97358 m .52822 .96263 L .52817 .9326 L p F P
0 g
s
.966 .687 .452 r
.51504 .92028 m .52817 .9326 L .52822 .96263 L p F P
0 g
s
.583 .62 .854 r
.42548 .7695 m .41659 .77078 L .42345 .76606 L closepath p F P
0 g
s
.578 .609 .847 r
.41191 .74571 m .42345 .76606 L .41659 .77078 L p F P
0 g
s
.578 .609 .847 r
.38825 .7489 m .41191 .74571 L p .41659 .77078 L F P
0 g
s
.942 .715 .244 r
.50083 .83213 m .50603 .84739 L .50592 .87681 L p F P
0 g
s
.942 .715 .244 r
.50603 .84739 m .50083 .83213 L .50098 .803 L p F P
0 g
s
0 0 .286 r
.84456 .79446 m .84207 .80447 L .84438 .83359 L p F P
0 g
s
.861 .752 .741 r
.73966 .63413 m .73087 .64743 L .71885 .62755 L p F P
0 g
s
.861 .752 .741 r
.71885 .62755 m .72298 .62131 L .73966 .63413 L p F P
0 g
s
.871 .747 .723 r
.73931 .5937 m .72298 .62131 L .73966 .63413 L p F P
0 g
s
.9 .597 .465 r
.79868 .58761 m .77896 .57556 L .77711 .54827 L p F P
0 g
s
.857 .562 .487 r
.76689 .54363 m .77711 .54827 L .77896 .57556 L p F P
0 g
s
.607 .355 .509 r
.4205 .38129 m .42107 .36057 L .44837 .35584 L p F P
0 g
s
.578 .331 .506 r
.42107 .36057 m .4205 .38129 L .39433 .38732 L p F P
0 g
s
.563 .344 .541 r
.36978 .41688 m .36947 .39464 L .39433 .38732 L p F P
0 g
s
.53 .319 .538 r
.36947 .39464 m .36978 .41688 L .34614 .42544 L p F P
0 g
s
.88 .603 .514 r
.56651 1.01359 m .54547 1.00394 L .54529 .97358 L p F P
0 g
s
.923 .643 .492 r
.52822 .96263 m .54529 .97358 L .54547 1.00394 L p F P
0 g
s
.78 .625 .063 r
.50047 .79584 m .50098 .803 L .50083 .83213 L p F P
0 g
s
.641 .665 .858 r
.48687 .77798 m .46283 .78519 L .44938 .76415 L p F P
0 g
s
.613 .653 .866 r
.42548 .7695 m .44938 .76415 L .46283 .78519 L p F P
0 g
s
.579 .59 .828 r
.39829 .71951 m .41191 .74571 L .38825 .7489 L p F P
0 g
s
.579 .59 .828 r
.38938 .72076 m .39829 .71951 L p .38825 .7489 L F P
0 g
s
.579 .59 .828 r
.38825 .7489 m .37745 .72828 L .38938 .72076 L p F P
0 g
s
.85 .75 .753 r
.71971 .66291 m .73087 .64743 L .71885 .62755 L p F P
0 g
s
.512 .372 .627 r
.3066 .49496 m .32766 .4841 L p .32344 .51481 L F P
0 g
s
.512 .372 .627 r
.32344 .51481 m .3091 .5132 L .3066 .49496 L p F P
0 g
s
.496 .34 .599 r
.32516 .45892 m .32766 .4841 L .3066 .49496 L p F P
0 g
s
.742 .744 .854 r
.61011 .76615 m .58576 .78105 L .57296 .76382 L p F P
0 g
s
.721 .738 .865 r
.54856 .77686 m .57296 .76382 L .58576 .78105 L p F P
0 g
s
.816 .551 .539 r
.68845 .42277 m .66212 .41399 L .66379 .3922 L p F P
0 g
s
.798 .535 .54 r
.6448 .38682 m .66379 .3922 L .66212 .41399 L p F P
0 g
s
.612 .633 .847 r
.44465 .75606 m .44938 .76415 L .42548 .7695 L p F P
0 g
s
.612 .633 .847 r
.42548 .7695 m .42345 .76606 L .44465 .75606 L p F P
0 g
s
.767 .486 .508 r
.63087 .38343 m .60712 .37871 L .60663 .35798 L p F P
0 g
s
.751 .472 .51 r
.59214 .35569 m .60663 .35798 L .60712 .37871 L p F P
0 g
s
.533 .526 .794 r
.3401 .69888 m .33768 .69327 L .34736 .69326 L closepath p F P
0 g
s
.506 .412 .683 r
.2983 .57107 m .29634 .56235 L .31582 .55023 L p F P
0 g
s
.491 .384 .661 r
.31038 .52167 m .31582 .55023 L .29634 .56235 L p F P
0 g
s
.736 .464 .517 r
.68934 .49936 m .71754 .50259 L .71884 .52731 L p F P
0 g
s
.736 .464 .517 r
.71766 .52826 m .68934 .49936 L .71884 .52731 L F
.846 .661 .652 r
.71652 .52917 m .71725 .53125 L .71884 .52731 L p F P
0 g
s
.736 .464 .517 r
.69055 .52637 m .68934 .49936 L p .71775 .52835 L F P
0 g
s
.835 .657 .661 r
.7121 .5429 m .71725 .53125 L .71652 .52917 L p F P
0 g
s
.835 .657 .661 r
.7121 .5429 m .71652 .52917 L .71146 .53256 L F
.736 .464 .517 r
.71896 .52958 m .71635 .52929 L p .71775 .52835 L F P
0 g
s
.736 .464 .517 r
.71635 .52929 m .69055 .52637 L p .71775 .52835 L F P
0 g
s
.863 .683 .657 r
.73354 .55477 m .72441 .54952 L .71725 .53125 L p F P
0 g
s
.846 .689 .688 r
.72441 .54952 m .7121 .5429 L p .72006 .5814 L F P
0 g
s
.853 .679 .666 r
.72441 .54952 m .71725 .53125 L .7121 .5429 L closepath p F P
0 g
s
.846 .689 .688 r
.7121 .5429 m .69807 .56976 L .72006 .5814 L p F P
0 g
s
.835 .657 .661 r
.7121 .5429 m .71146 .53256 L .70903 .53418 L F
.7 .435 .521 r
.67206 .52587 m .69055 .52637 L .69136 .54448 L p F P
0 g
s
.83 .667 .682 r
.7121 .5429 m .69807 .56976 L p .69109 .5447 L F P
0 g
s
.83 .667 .682 r
.69109 .5447 m .69118 .54463 L .7121 .5429 L F
.7 .435 .521 r
.68742 .54761 m .67206 .52587 L .69136 .54448 L F
.83 .667 .682 r
.70245 .53857 m .7121 .5429 L p .69107 .54464 L F P
0 g
s
.7 .435 .521 r
.67315 .55327 m .67206 .52587 L p .68742 .54761 L F P
0 g
s
.83 .667 .682 r
.69807 .56976 m .68472 .54974 L .69109 .5447 L F
.7 .435 .521 r
.68353 .55068 m .67315 .55327 L .68742 .54761 L F
.818 .663 .69 r
.67241 .55911 m .68944 .56595 L .68353 .55068 L p F P
0 g
s
.818 .663 .69 r
.67332 .55753 m .67241 .55911 L p .68353 .55068 L F P
0 g
s
.7 .435 .521 r
.68002 .55346 m .67942 .55344 L p .68353 .55068 L F P
0 g
s
.7 .435 .521 r
.67942 .55344 m .67315 .55327 L p .68353 .55068 L F P
0 g
s
.83 .667 .682 r
.69807 .56976 m .68944 .56595 L .68353 .55068 L p F P
0 g
s
.83 .667 .682 r
.68353 .55068 m .68102 .54419 L p .68472 .54974 L F P
0 g
s
.83 .667 .682 r
.69807 .56976 m .68353 .55068 L .68472 .54974 L F
.827 .694 .717 r
.69392 .57671 m .67996 .59808 L .70323 .60924 L p F P
0 g
s
.824 .677 .7 r
.69392 .57671 m .69807 .56976 L .68944 .56595 L closepath p F P
0 g
s
.812 .672 .708 r
.68944 .56595 m .69392 .57671 L .67996 .59808 L p F P
0 g
s
.812 .672 .708 r
.67241 .55911 m .68944 .56595 L p .67996 .59808 L F P
0 g
s
.7 .435 .521 r
.69178 .55378 m .69303 .58158 L p .67569 .55689 L F P
0 g
s
.7 .435 .521 r
.67315 .55327 m .68002 .55346 L p .67973 .55369 L F P
0 g
s
.7 .435 .521 r
.67531 .55634 m .67315 .55327 L .67973 .55369 L F
.812 .672 .708 r
.657 .58258 m .67241 .55911 L p .67996 .59808 L F P
0 g
s
.7 .435 .521 r
.69303 .58158 m .67427 .58108 L .67315 .55327 L p F P
0 g
s
.803 .642 .682 r
.675 .52714 m .68102 .54419 L .67332 .55753 L p F P
0 g
s
.678 .419 .522 r
.65979 .55354 m .67315 .55327 L .67332 .55753 L p F P
0 g
s
.803 .642 .682 r
.67332 .55753 m .67241 .55911 L p .67249 .55816 L F P
0 g
s
.678 .419 .522 r
.67158 .55884 m .65979 .55354 L .67332 .55753 L F
.799 .652 .7 r
.657 .58258 m .67158 .55884 L .66025 .5661 L F
.637 .387 .522 r
.6314 .58447 m .66025 .5661 L .65311 .57245 L F
.786 .647 .708 r
.6532 .58784 m .65311 .57245 L .65018 .57473 L F
.637 .387 .522 r
.63859 .58371 m .6314 .58447 L p .65311 .57245 L F P
0 g
s
.637 .387 .522 r
.65979 .55354 m .66025 .5661 L p .6314 .58447 L F P
0 g
s
.637 .387 .522 r
.65879 .52614 m .65979 .55354 L .6306 .55668 L p F P
0 g
s
.637 .387 .522 r
.6314 .58447 m .6306 .55668 L .65979 .55354 L p F P
0 g
s
.588 .348 .521 r
.6306 .55668 m .6314 .58447 L .60422 .59007 L p F P
0 g
s
.786 .647 .708 r
.64312 .54946 m .62173 .57894 L .63859 .58371 L p F P
0 g
s
.786 .647 .708 r
.63859 .58371 m .6532 .58784 L p .64983 .575 L F P
0 g
s
.786 .647 .708 r
.64983 .575 m .64312 .54946 L .63859 .58371 L F
.6532 .58784 m .657 .58258 L .65311 .57245 L p F P
0 g
s
.799 .652 .7 r
.65311 .57245 m .657 .58258 L p .66025 .5661 L F P
0 g
s
.799 .652 .7 r
.657 .58258 m .67241 .55911 L .67158 .55884 L p F P
0 g
s
.786 .647 .708 r
.64443 .54984 m .64312 .54946 L p .64983 .575 L F P
0 g
s
.786 .647 .708 r
.6532 .58784 m .65018 .57473 L .64983 .575 L F
.65018 .57473 m .64443 .54984 L .64983 .575 L F
.812 .672 .708 r
.67996 .59808 m .66025 .5903 L .657 .58258 L p F P
0 g
s
.795 .675 .733 r
.6532 .58784 m .66025 .5903 L p .65697 .62807 L F P
0 g
s
.795 .675 .733 r
.63256 .61358 m .6532 .58784 L p .65697 .62807 L F P
0 g
s
.8 .667 .717 r
.66025 .5903 m .657 .58258 L .6532 .58784 L closepath p F P
0 g
s
.782 .656 .723 r
.6532 .58784 m .63256 .61358 L .62484 .5949 L p F P
0 g
s
.769 .65 .731 r
.63256 .61358 m .62817 .61854 L p .62292 .59651 L F P
0 g
s
.588 .348 .521 r
.62002 .59894 m .6314 .58447 L .62484 .5949 L F
.60422 .59007 m .6314 .58447 L p .62002 .59894 L F P
0 g
s
.588 .348 .521 r
.618 .60063 m .60422 .59007 L .62002 .59894 L F
.769 .65 .731 r
.62817 .61854 m .60433 .61218 L .62292 .59651 L F
.529 .302 .515 r
.57976 .62622 m .60469 .61177 L .6037 .61289 L F
.765 .658 .744 r
.59851 .61827 m .6079 .63955 L p .6037 .61289 L F P
0 g
s
.751 .652 .751 r
.6079 .63955 m .5945 .65205 L p .59507 .62147 L F P
0 g
s
.751 .652 .751 r
.59851 .61827 m .6079 .63955 L p .59507 .62147 L F P
0 g
s
.529 .302 .515 r
.57976 .62622 m .6037 .61289 L .59851 .61827 L F
.59574 .62113 m .59528 .62128 L p .59851 .61827 L F P
0 g
s
.529 .302 .515 r
.59528 .62128 m .57976 .62622 L p .59851 .61827 L F P
0 g
s
.529 .302 .515 r
.60422 .59007 m .60469 .61177 L p .57976 .62622 L F P
0 g
s
.751 .652 .751 r
.5945 .65205 m .59392 .62254 L .59507 .62147 L F
.765 .658 .744 r
.6079 .63955 m .62817 .61854 L .6037 .61289 L p F P
0 g
s
.748 .66 .763 r
.58314 .66192 m .5945 .65205 L .57708 .64899 L closepath p F P
0 g
s
.751 .652 .751 r
.5945 .65205 m .57741 .63871 L .59392 .62254 L F
.735 .645 .759 r
.56942 .64809 m .57708 .64899 L .57425 .64263 L p F P
0 g
s
.457 .247 .505 r
.56348 .65439 m .57976 .62622 L .57244 .64488 L F
.733 .653 .771 r
.56122 .65678 m .58314 .66192 L .55321 .6667 L F
.369 .181 .489 r
.5369 .67761 m .55729 .66096 L .55219 .66813 L F
.716 .646 .778 r
.55219 .66813 m .55835 .68116 L p .54463 .67791 L F P
0 g
s
.369 .181 .489 r
.5521 .66825 m .55209 .66826 L p .55219 .66813 L F P
0 g
s
.369 .181 .489 r
.55209 .66826 m .5369 .67761 L p .55219 .66813 L F P
0 g
s
.716 .646 .778 r
.55835 .68116 m .54442 .69067 L p .54463 .67791 L F P
0 g
s
.369 .181 .489 r
.55706 .63658 m .55729 .66096 L p .5369 .67761 L F P
0 g
s
.369 .181 .489 r
.5369 .67761 m .53678 .64923 L .55706 .63658 L p F P
0 g
s
.733 .653 .771 r
.58314 .66192 m .55835 .68116 L .55219 .66813 L p F P
0 g
s
.733 .653 .771 r
.55321 .6667 m .58314 .66192 L .55219 .66813 L F
.722 .672 .801 r
.57154 .70625 m .54686 .72221 L .5336 .69769 L p F P
0 g
s
.722 .672 .801 r
.5643 .69274 m .57154 .70625 L p .5336 .69769 L F P
0 g
s
.722 .672 .801 r
.5336 .69769 m .54442 .69067 L .5643 .69274 L p F P
0 g
s
.725 .665 .791 r
.5643 .69274 m .55835 .68116 L .54442 .69067 L closepath p F P
0 g
s
.714 .653 .788 r
.5336 .69769 m .54442 .69067 L .53557 .6902 L p F P
0 g
s
.265 .102 .464 r
.5369 .67761 m .52919 .68394 L .52922 .70016 L p F P
0 g
s
.265 .102 .464 r
.52922 .70016 m .52923 .70053 L p .52948 .69978 L F P
0 g
s
.265 .102 .464 r
.52948 .69978 m .5369 .67761 L .52922 .70016 L F
.697 .646 .795 r
.53242 .69533 m .5336 .69769 L .52922 .70016 L p F P
0 g
s
.265 .102 .464 r
.53337 .69378 m .5369 .67761 L .52923 .70053 L F
.697 .646 .795 r
.52971 .68989 m .53242 .69533 L p .50893 .71161 L F P
0 g
s
.697 .646 .795 r
.52922 .70016 m .50893 .71161 L p .53242 .69533 L F P
0 g
s
.714 .653 .788 r
.53242 .69533 m .5336 .69769 L p .53557 .6902 L F P
0 g
s
.265 .102 .464 r
.53694 .68786 m .5369 .67761 L p .53331 .69406 L F P
0 g
s
.369 .181 .489 r
.53694 .68786 m .5369 .67761 L .55209 .66826 L p F P
0 g
s
.195 .049 .444 r
.52913 .6556 m .5197 .6649 L .51969 .69318 L p F P
0 g
s
.195 .049 .444 r
.51969 .69318 m .52919 .68394 L .52913 .6556 L p F P
0 g
s
.265 .102 .464 r
.53678 .64923 m .52913 .6556 L .52919 .68394 L p F P
0 g
s
.265 .102 .464 r
.52919 .68394 m .5369 .67761 L .53678 .64923 L p F P
0 g
s
.716 .646 .778 r
.52971 .68989 m .52022 .66999 L p .5386 .6857 L F P
0 g
s
.716 .646 .778 r
.54442 .69067 m .53514 .69018 L p .5386 .6857 L F P
0 g
s
.716 .646 .778 r
.53514 .69018 m .52971 .68989 L p .5386 .6857 L F P
0 g
s
.716 .646 .778 r
.54442 .69067 m .53833 .68547 L .54469 .6746 L F
.369 .181 .489 r
.53694 .68958 m .53694 .68786 L p .5521 .66825 L F P
0 g
s
.369 .181 .489 r
.55209 .66826 m .5521 .66825 L p .53694 .68786 L F P
0 g
s
.265 .102 .464 r
.52925 .7127 m .53701 .70641 L .53694 .68786 L p F P
0 g
s
.265 .102 .464 r
.52925 .7127 m .53694 .68786 L .53331 .69406 L F
.716 .646 .778 r
.52022 .66999 m .54504 .65299 L p .54469 .6746 L F P
0 g
s
.716 .646 .778 r
.53833 .68547 m .52022 .66999 L .54469 .6746 L F
.714 .653 .788 r
.53557 .6902 m .52971 .68989 L .53242 .69533 L p F P
0 g
s
.265 .102 .464 r
.52923 .70053 m .52925 .7127 L p .53337 .69378 L F P
0 g
s
.369 .181 .489 r
.53701 .70641 m .53694 .68958 L p .55733 .66504 L F P
0 g
s
.369 .181 .489 r
.5521 .66825 m .55733 .66504 L p .53694 .68958 L F P
0 g
s
.733 .653 .771 r
.55219 .66813 m .55164 .66695 L p .55321 .6667 L F P
0 g
s
.716 .646 .778 r
.54504 .65299 m .55219 .66813 L p .54463 .67791 L F P
0 g
s
.733 .653 .771 r
.55729 .66096 m .55321 .6667 L .55164 .66695 L F
.56122 .65678 m .55321 .6667 L .55729 .66096 L F
.369 .181 .489 r
.55729 .66096 m .55733 .66504 L .5521 .66825 L p F P
0 g
s
.457 .247 .505 r
.55706 .63658 m .57976 .62622 L p .56348 .65439 L F P
0 g
s
.733 .653 .771 r
.57708 .64899 m .58314 .66192 L p .56122 .65678 L F P
0 g
s
.733 .653 .771 r
.56743 .6502 m .57708 .64899 L .56122 .65678 L F
.457 .247 .505 r
.55733 .66504 m .55729 .66096 L p .56348 .65439 L F P
0 g
s
.457 .247 .505 r
.55729 .66096 m .55706 .63658 L p .56348 .65439 L F P
0 g
s
.733 .653 .771 r
.54504 .65299 m .56743 .6502 L .56122 .65678 L F
.735 .645 .759 r
.56989 .63284 m .55374 .64623 L .56942 .64809 L p F P
0 g
s
.457 .247 .505 r
.57259 .64451 m .57976 .62622 L .57425 .64263 L F
.735 .645 .759 r
.57425 .64263 m .56989 .63284 L p .56942 .64809 L F P
0 g
s
.457 .247 .505 r
.57976 .62622 m .5799 .63561 L p .57425 .64263 L F P
0 g
s
.457 .247 .505 r
.57244 .64488 m .57259 .64451 L .57425 .64263 L F
.733 .653 .771 r
.54504 .65299 m .55374 .64623 L .56942 .64809 L p F P
0 g
s
.733 .653 .771 r
.56942 .64809 m .57708 .64899 L p .56743 .6502 L F P
0 g
s
.733 .653 .771 r
.54504 .65299 m .56942 .64809 L .56743 .6502 L F
.457 .247 .505 r
.56014 .66018 m .57244 .64488 L .58019 .65475 L F
.751 .652 .751 r
.57741 .63871 m .5799 .63561 L .59392 .62254 L F
.5945 .65205 m .57708 .64899 L .56989 .63284 L p F P
0 g
s
.457 .247 .505 r
.5799 .63561 m .57992 .63694 L p .57244 .64488 L F P
0 g
s
.457 .247 .505 r
.57992 .63694 m .58019 .65475 L p .57244 .64488 L F P
0 g
s
.457 .247 .505 r
.56014 .66018 m .56348 .65439 L .57244 .64488 L F
.733 .653 .771 r
.55164 .66695 m .54504 .65299 L p .56122 .65678 L F P
0 g
s
.751 .652 .751 r
.57741 .63871 m .57696 .63835 L .5799 .63561 L F
.457 .247 .505 r
.58019 .65475 m .55733 .66504 L p .56014 .66018 L F P
0 g
s
.529 .302 .515 r
.58019 .65475 m .5799 .63561 L p .60483 .61823 L F P
0 g
s
.529 .302 .515 r
.5799 .63561 m .57976 .62622 L .59528 .62128 L p F P
0 g
s
.529 .302 .515 r
.59528 .62128 m .60483 .61823 L p .5799 .63561 L F P
0 g
s
.529 .302 .515 r
.57976 .62622 m .57933 .59811 L .60422 .59007 L p F P
0 g
s
.457 .247 .505 r
.57933 .59811 m .57976 .62622 L .55706 .63658 L p F P
0 g
s
.751 .652 .751 r
.56989 .63284 m .59369 .61066 L p .59392 .62254 L F P
0 g
s
.751 .652 .751 r
.57696 .63835 m .56989 .63284 L .59392 .62254 L F
.59369 .61066 m .59527 .61095 L p .59507 .62147 L F P
0 g
s
.751 .652 .751 r
.59392 .62254 m .59369 .61066 L .59507 .62147 L F
.59527 .61095 m .59851 .61827 L p .59507 .62147 L F P
0 g
s
.529 .302 .515 r
.59664 .62084 m .59574 .62113 L p .59851 .61827 L F P
0 g
s
.529 .302 .515 r
.59851 .61827 m .6037 .61289 L .60093 .61601 L F
.59851 .61827 m .60093 .61601 L .59664 .62084 L F
.765 .658 .744 r
.6037 .61289 m .59527 .61095 L .59851 .61827 L p F P
0 g
s
.769 .65 .731 r
.60433 .61218 m .60423 .61216 L .60469 .61177 L F
.60433 .61218 m .60469 .61177 L .62292 .59651 L F
.62817 .61854 m .60343 .61283 L p .60423 .61216 L F P
0 g
s
.588 .348 .521 r
.60474 .6139 m .60469 .61177 L p .61842 .60096 L F P
0 g
s
.588 .348 .521 r
.60469 .61177 m .60422 .59007 L p .618 .60063 L F P
0 g
s
.588 .348 .521 r
.60469 .61177 m .618 .60063 L .61842 .60096 L F
.769 .65 .731 r
.59527 .61095 m .59472 .60962 L p .60423 .61216 L F P
0 g
s
.769 .65 .731 r
.60343 .61283 m .59527 .61095 L p .60423 .61216 L F P
0 g
s
.529 .302 .515 r
.60469 .61177 m .60483 .61823 L .59664 .62084 L p F P
0 g
s
.769 .65 .731 r
.59472 .60962 m .61942 .58181 L p .62292 .59651 L F P
0 g
s
.769 .65 .731 r
.60423 .61216 m .59472 .60962 L .62292 .59651 L F
.588 .348 .521 r
.61842 .60096 m .618 .60063 L .62002 .59894 L F
.60483 .61823 m .60474 .6139 L p .61842 .60096 L F P
0 g
s
.588 .348 .521 r
.6314 .58447 m .63152 .58859 L p .62484 .5949 L F P
0 g
s
.637 .387 .522 r
.63152 .58859 m .6314 .58447 L .63859 .58371 L p F P
0 g
s
.782 .656 .723 r
.62429 .59358 m .61942 .58181 L p .63563 .5847 L F P
0 g
s
.782 .656 .723 r
.63563 .5847 m .63684 .58492 L .63152 .58859 L F
.63563 .5847 m .63152 .58859 L .62429 .59358 L F
.769 .65 .731 r
.61942 .58181 m .62484 .5949 L p .62292 .59651 L F P
0 g
s
.769 .65 .731 r
.62484 .5949 m .63256 .61358 L p .62292 .59651 L F P
0 g
s
.588 .348 .521 r
.61842 .60096 m .62002 .59894 L .62484 .5949 L F
.63222 .61267 m .60483 .61823 L p .61842 .60096 L F P
0 g
s
.782 .656 .723 r
.62676 .59309 m .6532 .58784 L .62484 .5949 L F
.63684 .58492 m .6532 .58784 L .62429 .59358 L F
.588 .348 .521 r
.63152 .58859 m .63222 .61267 L p .61842 .60096 L F P
0 g
s
.782 .656 .723 r
.62484 .5949 m .62429 .59358 L p .62676 .59309 L F P
0 g
s
.782 .656 .723 r
.61942 .58181 m .62173 .57894 L .6532 .58784 L p F P
0 g
s
.637 .387 .522 r
.63154 .58918 m .63152 .58859 L p .63859 .58371 L F P
0 g
s
.637 .387 .522 r
.63222 .61267 m .63154 .58918 L p .6608 .58135 L F P
0 g
s
.637 .387 .522 r
.63859 .58371 m .6608 .58135 L p .63154 .58918 L F P
0 g
s
.637 .387 .522 r
.6608 .58135 m .64071 .58348 L p .65311 .57245 L F P
0 g
s
.637 .387 .522 r
.66025 .5661 m .66028 .5669 L p .65311 .57245 L F P
0 g
s
.637 .387 .522 r
.66028 .5669 m .6608 .58135 L p .65311 .57245 L F P
0 g
s
.637 .387 .522 r
.64071 .58348 m .63859 .58371 L p .65311 .57245 L F P
0 g
s
.786 .647 .708 r
.65311 .57245 m .64443 .54984 L p .65018 .57473 L F P
0 g
s
.799 .652 .7 r
.65257 .57103 m .65311 .57245 L p .66025 .5661 L F P
0 g
s
.678 .419 .522 r
.66511 .56367 m .66484 .56316 L .67158 .55884 L F
.66484 .56316 m .65979 .55354 L .67158 .55884 L F
.67427 .58108 m .6608 .58135 L .66029 .56728 L p F P
0 g
s
.678 .419 .522 r
.66029 .56728 m .65979 .55354 L p .66511 .56367 L F P
0 g
s
.678 .419 .522 r
.67427 .58108 m .66029 .56728 L .66511 .56367 L F
.67206 .52587 m .65879 .52614 L .6578 .49912 L p F P
0 g
s
.637 .387 .522 r
.6578 .49912 m .65879 .52614 L .62981 .52929 L p F P
0 g
s
.637 .387 .522 r
.6306 .55668 m .62981 .52929 L .65879 .52614 L p F P
0 g
s
.678 .419 .522 r
.65879 .52614 m .67206 .52587 L .67315 .55327 L p F P
0 g
s
.678 .419 .522 r
.67315 .55327 m .65979 .55354 L .65879 .52614 L p F P
0 g
s
.803 .642 .682 r
.64387 .54828 m .65924 .52184 L p .67216 .5584 L F P
0 g
s
.803 .642 .682 r
.67241 .55911 m .67161 .55881 L .67216 .5584 L F
.67161 .55881 m .64387 .54828 L .67216 .5584 L F
.799 .652 .7 r
.67158 .55884 m .64443 .54984 L .65257 .57103 L p F P
0 g
s
.803 .642 .682 r
.65924 .52184 m .675 .52714 L p .67241 .55911 L F P
0 g
s
.803 .642 .682 r
.67241 .55911 m .64443 .54984 L .64387 .54828 L p F P
0 g
s
.678 .419 .522 r
.67332 .55753 m .67427 .58108 L p .66511 .56367 L F P
0 g
s
.803 .642 .682 r
.67249 .55816 m .6725 .55803 L .67332 .55753 L F
.6725 .55803 m .675 .52714 L .67332 .55753 L F
.7 .435 .521 r
.67569 .55689 m .67531 .55634 L .67973 .55369 L F
.68002 .55346 m .69178 .55378 L p .67569 .55689 L F P
0 g
s
.818 .663 .69 r
.68353 .55068 m .68102 .54419 L .67332 .55753 L p F P
0 g
s
.7 .435 .521 r
.69178 .55378 m .68002 .55346 L p .68742 .54761 L F P
0 g
s
.83 .667 .682 r
.69109 .5447 m .68388 .54848 L .69107 .54464 L F
.68472 .54974 m .68388 .54848 L .69109 .5447 L F
.68102 .54419 m .68751 .53186 L p .69107 .54464 L F P
0 g
s
.83 .667 .682 r
.68388 .54848 m .68102 .54419 L .69107 .54464 L F
.736 .464 .517 r
.72039 .55697 m .69178 .55378 L .69136 .54448 L p F P
0 g
s
.736 .464 .517 r
.69136 .54448 m .69055 .52637 L p .70245 .53857 L F P
0 g
s
.736 .464 .517 r
.72039 .55697 m .69136 .54448 L .70245 .53857 L F
.7 .435 .521 r
.69136 .54448 m .69178 .55378 L p .68742 .54761 L F P
0 g
s
.83 .667 .682 r
.69109 .5447 m .69107 .54464 L .69118 .54463 L F
.68751 .53186 m .70245 .53857 L p .69107 .54464 L F P
0 g
s
.736 .464 .517 r
.69055 .52637 m .71635 .52929 L p .70245 .53857 L F P
0 g
s
.7 .435 .521 r
.67098 .49885 m .68934 .49936 L .69055 .52637 L p F P
0 g
s
.7 .435 .521 r
.69055 .52637 m .67206 .52587 L .67098 .49885 L p F P
0 g
s
.835 .657 .661 r
.69908 .50593 m .68751 .53186 L .7121 .5429 L p F P
0 g
s
.736 .464 .517 r
.71896 .52958 m .71897 .52975 L p .70245 .53857 L F P
0 g
s
.736 .464 .517 r
.71897 .52975 m .72039 .55697 L p .70245 .53857 L F P
0 g
s
.736 .464 .517 r
.71635 .52929 m .71896 .52958 L p .70245 .53857 L F P
0 g
s
.835 .657 .661 r
.71011 .51095 m .69908 .50593 L p .70903 .53418 L F P
0 g
s
.835 .657 .661 r
.71146 .53256 m .71011 .51095 L .70903 .53418 L F
.71652 .52917 m .71011 .51095 L p .71146 .53256 L F P
0 g
s
.846 .661 .652 r
.72289 .51726 m .71011 .51095 L .71652 .52917 L p F P
0 g
s
.846 .661 .652 r
.71884 .52731 m .72289 .51726 L p .71652 .52917 L F P
0 g
s
.736 .464 .517 r
.71884 .52731 m .71896 .52958 L p .71766 .52826 L F P
0 g
s
0 0 .198 r
.84456 .79446 m .84534 .78724 L .84302 .75841 L p F P
0 g
s
.774 .572 .001 r
.84057 .74239 m .84302 .75841 L .84534 .78724 L p F P
0 g
s
.774 .572 .001 r
.84302 .75841 m .84057 .74239 L .83828 .71385 L p F P
0 g
s
.945 .637 .424 r
.81609 .62837 m .80068 .61522 L .79868 .58761 L p F P
0 g
s
.9 .597 .465 r
.77896 .57556 m .79868 .58761 L .80068 .61522 L p F P
0 g
s
.637 .387 .522 r
.62981 .52929 m .62904 .5023 L .6578 .49912 L p F P
0 g
s
.588 .348 .521 r
.62904 .5023 m .62981 .52929 L .60303 .53496 L p F P
0 g
s
.547 .355 .573 r
.34753 .44918 m .34614 .42544 L .36978 .41688 L p F P
0 g
s
.513 .33 .57 r
.34614 .42544 m .34753 .44918 L .32516 .45892 L p F P
0 g
s
.535 .512 .777 r
.34736 .69326 m .33768 .69327 L .32464 .66033 L p F P
0 g
s
.73315 .51882 m
.73829 .51573 L
s
.72968 .5209 m
.73315 .51882 L
s
.71205 .53149 m
.71255 .53119 L
s
.71255 .53119 m
.71662 .52875 L
s
.71662 .52875 m
.71685 .52861 L
s
.529 .364 .602 r
.32766 .4841 m .32516 .45892 L .34753 .44918 L p F P
0 g
s
.609 .623 .84 r
.43585 .74041 m .44465 .75606 L .42345 .76606 L p F P
0 g
s
.609 .623 .84 r
.42345 .76606 m .41191 .74571 L .43585 .74041 L p F P
0 g
s
.863 .714 .695 r
.73931 .5937 m .74218 .58813 L .7299 .56243 L p F P
0 g
s
.504 .421 .696 r
.30363 .59283 m .2983 .57107 L .3212 .57402 L p F P
0 g
s
.506 .412 .683 r
.31582 .55023 m .3212 .57402 L .2983 .57107 L p F P
0 g
s
.693 .706 .858 r
.54856 .77686 m .52428 .78793 L .51111 .76879 L p F P
0 g
s
.852 .649 .628 r
.70766 .48116 m .73082 .49275 L .72289 .51726 L p F P
0 g
s
.858 .635 .6 r
.73082 .49275 m .70766 .48116 L .71339 .45755 L p F P
0 g
s
.632 .375 .511 r
.44795 .37658 m .44837 .35584 L .47689 .35246 L p F P
0 g
s
.607 .355 .509 r
.44837 .35584 m .44795 .37658 L .4205 .38129 L p F P
0 g
s
.857 .562 .487 r
.77896 .57556 m .76866 .57094 L .76689 .54363 L p F P
0 g
s
.835 .543 .496 r
.75166 .53783 m .76689 .54363 L .76866 .57094 L p F P
0 g
s
.751 .472 .51 r
.60712 .37871 m .59255 .37643 L .59214 .35569 L p F P
0 g
s
.736 .46 .511 r
.57158 .3532 m .59214 .35569 L .59255 .37643 L p F P
0 g
s
.841 .754 .767 r
.71971 .66291 m .70712 .67878 L .69496 .65964 L p F P
0 g
s
.841 .754 .767 r
.69496 .65964 m .7023 .65042 L .71971 .66291 L p F P
0 g
s
.85 .75 .753 r
.71885 .62755 m .7023 .65042 L .71971 .66291 L p F P
0 g
s
.843 .598 .567 r
.69009 .43235 m .69142 .42387 L p .71339 .45755 L F P
0 g
s
.826 .58 .567 r
.69009 .43235 m .69142 .42387 L .68845 .42277 L closepath p F P
0 g
s
.943 .669 .206 r
.83152 .69871 m .83828 .71385 L .84057 .74239 L p F P
0 g
s
.943 .669 .206 r
.83828 .71385 m .83152 .69871 L .8293 .67047 L p F P
0 g
s
.529 .302 .515 r
.57891 .5704 m .5785 .54308 L .60303 .53496 L p F P
0 g
s
.457 .247 .505 r
.5785 .54308 m .57891 .5704 L .55654 .58087 L p F P
0 g
s
.976 .672 .347 r
.8293 .67047 m .81822 .6563 L .81609 .62837 L p F P
0 g
s
.945 .637 .424 r
.80068 .61522 m .81609 .62837 L .81822 .6563 L p F P
0 g
s
.839 .615 .598 r
.6932 .44885 m .71339 .45755 L .70766 .48116 L p F P
0 g
s
.843 .598 .567 r
.71339 .45755 m .6932 .44885 L .69009 .43235 L p F P
0 g
s
.854 .721 .715 r
.72006 .5814 m .73931 .5937 L .72298 .62131 L p F P
0 g
s
.863 .714 .695 r
.7299 .56243 m .72006 .5814 L .73931 .5937 L p F P
0 g
s
.976 .672 .347 r
.81822 .6563 m .8293 .67047 L .83152 .69871 L p F P
0 g
s
.814 .572 .573 r
.68845 .42277 m .66212 .41399 L p .68758 .44665 L F P
0 g
s
.814 .572 .573 r
.68758 .44665 m .69009 .43235 L .68845 .42277 L p F P
0 g
s
.195 .049 .444 r
.5197 .6649 m .52913 .6556 L .52907 .62767 L p F P
0 g
s
.265 .102 .464 r
.53667 .62125 m .52907 .62767 L .52913 .6556 L p F P
0 g
s
.76 .749 .843 r
.61011 .76615 m .61377 .76362 L .60538 .75967 L closepath p F P
0 g
s
.742 .744 .854 r
.60538 .75967 m .61011 .76615 L p .57296 .76382 L F P
0 g
s
.678 .419 .522 r
.6578 .49912 m .67098 .49885 L .67206 .52587 L p F P
0 g
s
.517 .446 .716 r
.30363 .59283 m .32278 .58046 L p .32061 .62002 L F P
0 g
s
.517 .446 .716 r
.32061 .62002 m .31102 .61932 L .30363 .59283 L p F P
0 g
s
.504 .421 .696 r
.3212 .57402 m .32278 .58046 L .30363 .59283 L p F P
0 g
s
0 0 .323 r
.50841 .70854 m .50644 .71237 L .50633 .74092 L p F P
0 g
s
.766 .747 .835 r
.62192 .73071 m .63448 .74854 L .61377 .76362 L p F P
0 g
s
.766 .747 .835 r
.59743 .74858 m .62192 .73071 L p .61377 .76362 L F P
0 g
s
.766 .747 .835 r
.61377 .76362 m .60538 .75967 L .59743 .74858 L p F P
0 g
s
.353 .193 .52 r
.81633 .96322 m .80788 .96859 L .80995 .999 L p F P
0 g
s
.431 .249 .532 r
.80788 .96859 m .80995 .999 L .78832 1.00936 L p F P
0 g
s
.736 .46 .511 r
.59255 .37643 m .57187 .37395 L .57158 .3532 L p F P
0 g
s
.718 .446 .512 r
.54652 .35127 m .57158 .3532 L .57187 .37395 L p F P
0 g
s
.592 .367 .544 r
.39477 .40959 m .39433 .38732 L .4205 .38129 L p F P
0 g
s
.563 .344 .541 r
.39433 .38732 m .39477 .40959 L .36978 .41688 L p F P
0 g
s
.828 .752 .779 r
.69437 .69345 m .70712 .67878 L .69496 .65964 L p F P
0 g
s
.511 .378 .636 r
.31038 .52167 m .3091 .5132 L .32344 .51481 L closepath p F P
0 g
s
.798 .535 .54 r
.66212 .41399 m .64706 .40976 L .6448 .38682 L p F P
0 g
s
.785 .525 .544 r
.63087 .38343 m .6448 .38682 L .64706 .40976 L p F P
0 g
s
.535 .512 .777 r
.32464 .66033 m .32614 .65925 L p .34736 .69326 L F P
0 g
s
.525 .492 .762 r
.32464 .66033 m .32422 .65918 L .32614 .65925 L closepath p F P
0 g
s
.526 .479 .747 r
.32614 .65925 m .32422 .65918 L .31283 .62529 L p F P
0 g
s
.655 .394 .513 r
.47689 .35246 m .48729 .35174 L .48709 .37249 L p F P
0 g
s
.655 .394 .513 r
.48709 .37249 m .47664 .3732 L .47689 .35246 L p F P
0 g
s
.632 .375 .511 r
.47689 .35246 m .47664 .3732 L .44795 .37658 L p F P
0 g
s
.19 .076 .484 r
.8386 .91148 m .82492 .92516 L .82711 .95527 L p F P
0 g
s
.19 .076 .484 r
.82492 .92516 m .8386 .91148 L .83632 .88168 L p F P
0 g
s
.302 .156 .51 r
.81633 .96322 m .82711 .95527 L .82492 .92516 L p F P
0 g
s
.573 .577 .819 r
.37745 .72828 m .37461 .72257 L .38938 .72076 L closepath p F P
0 g
s
.515 .457 .729 r
.31283 .62529 m .31102 .61932 L .32061 .62002 L closepath p F P
0 g
s
.665 .402 .513 r
.48729 .35174 m .50693 .35082 L .50685 .37157 L p F P
0 g
s
.665 .402 .513 r
.50685 .37157 m .48709 .37249 L .48729 .35174 L p F P
0 g
s
.526 .479 .747 r
.31283 .62529 m .32061 .62002 L p .32614 .65925 L F P
0 g
s
.069 0 .449 r
.83893 .87817 m .83632 .88168 L .8386 .91148 L p F P
0 g
s
.535 .512 .777 r
.32614 .65925 m .34749 .65905 L p .34736 .69326 L F P
0 g
s
.536 .499 .761 r
.34749 .65905 m .32614 .65925 L .34339 .64781 L closepath p F P
0 g
s
.526 .479 .747 r
.33416 .62031 m .34339 .64781 L .32614 .65925 L p F P
0 g
s
.526 .479 .747 r
.32061 .62002 m .33416 .62031 L p .32614 .65925 L F P
0 g
s
.82 .755 .791 r
.69437 .69345 m .68306 .70546 L .67077 .68696 L p F P
0 g
s
.82 .755 .791 r
.67077 .68696 m .67608 .68132 L .69437 .69345 L p F P
0 g
s
.828 .752 .779 r
.69496 .65964 m .67608 .68132 L .69437 .69345 L p F P
0 g
s
.718 .446 .512 r
.57187 .37395 m .54667 .37202 L .54652 .35127 L p F P
0 g
s
.706 .436 .513 r
.53837 .35088 m .54652 .35127 L .54667 .37202 L p F P
0 g
s
.783 .751 .824 r
.65882 .72869 m .63448 .74854 L .62192 .73071 L p F P
0 g
s
.544 .529 .789 r
.361 .69281 m .34736 .69326 L .35804 .68578 L closepath p F P
0 g
s
.535 .512 .777 r
.34749 .65905 m .35804 .68578 L .34736 .69326 L p F P
0 g
s
.832 .59 .574 r
.6932 .44885 m .69009 .43235 L .68758 .44665 L closepath p F P
0 g
s
.78 .625 .063 r
.50083 .83213 m .50032 .82503 L .50047 .79584 L p F P
0 g
s
0 0 .048 r
.50118 .78574 m .50047 .79584 L .50032 .82503 L p F P
0 g
s
.50057 .78591 m
.50065 .77864 L
s
.641 .665 .858 r
.44938 .76415 m .47349 .75682 L .48687 .77798 L p F P
0 g
s
.706 .436 .513 r
.54667 .37202 m .53847 .37164 L .53837 .35088 L p F P
0 g
s
.687 .42 .513 r
.53837 .35088 m .53847 .37164 L .50685 .37157 L p F P
0 g
s
.687 .42 .513 r
.50685 .37157 m .50693 .35082 L .53837 .35088 L p F P
0 g
s
.525 .408 .662 r
.31582 .55023 m .31038 .52167 L .32344 .51481 L p F P
0 g
s
.806 .752 .803 r
.67077 .68696 m .68306 .70546 L .66143 .72634 L p F P
0 g
s
.573 .56 .801 r
.38938 .72076 m .37461 .72257 L .361 .69281 L p F P
0 g
s
.799 .755 .813 r
.65882 .72869 m .66143 .72634 L .65418 .72198 L closepath p F P
0 g
s
.783 .751 .824 r
.65418 .72198 m .65882 .72869 L p .62192 .73071 L F P
0 g
s
.457 .247 .505 r
.5568 .60853 m .55654 .58087 L .57891 .5704 L p F P
0 g
s
.369 .181 .489 r
.55654 .58087 m .5568 .60853 L .53667 .62125 L p F P
0 g
s
.806 .752 .803 r
.6464 .71047 m .67077 .68696 L p .66143 .72634 L F P
0 g
s
.806 .752 .803 r
.66143 .72634 m .65418 .72198 L .6464 .71047 L p F P
0 g
s
.715 .714 .848 r
.57296 .76382 m .54856 .77686 L .53549 .75761 L p F P
0 g
s
.693 .706 .858 r
.51111 .76879 m .53549 .75761 L .54856 .77686 L p F P
0 g
s
.835 .543 .496 r
.76866 .57094 m .75333 .56518 L .75166 .53783 L p F P
0 g
s
.797 .512 .507 r
.72559 .53083 m .75166 .53783 L .75333 .56518 L p F P
0 g
s
0 0 .198 r
.84534 .78724 m .84456 .79446 L .84689 .82366 L p F P
0 g
s
0 0 .286 r
.84438 .83359 m .84689 .82366 L .84456 .79446 L p F P
0 g
s
.856 .693 .679 r
.7299 .56243 m .73354 .55477 L .72441 .54952 L closepath p F P
0 g
s
.785 .525 .544 r
.64706 .40976 m .62874 .40535 L .63087 .38343 L p F P
0 g
s
.769 .51 .543 r
.60712 .37871 m .63087 .38343 L .62874 .40535 L p F P
0 g
s
.036 0 .392 r
.50841 .70854 m .51969 .69318 L .5197 .6649 L p F P
0 g
s
.742 .744 .854 r
.57296 .76382 m .58978 .7535 L .60538 .75967 L p F P
0 g
s
.747 .742 .847 r
.60538 .75967 m .59743 .74858 L .58978 .7535 L closepath p F P
0 g
s
.576 .378 .575 r
.37129 .44067 m .36978 .41688 L .39477 .40959 L p F P
0 g
s
.547 .355 .573 r
.36978 .41688 m .37129 .44067 L .34753 .44918 L p F P
0 g
s
.638 .644 .84 r
.46879 .74869 m .47349 .75682 L .44938 .76415 L p F P
0 g
s
.638 .644 .84 r
.44938 .76415 m .44465 .75606 L .46879 .74869 L p F P
0 g
s
.608 .604 .822 r
.43585 .74041 m .41191 .74571 L .39829 .71951 L p F P
0 g
s
.846 .727 .732 r
.71885 .62755 m .72298 .62131 L .71169 .61423 L closepath p F P
0 g
s
.854 .721 .715 r
.70653 .60417 m .72006 .5814 L p .72298 .62131 L F P
0 g
s
.854 .721 .715 r
.72298 .62131 m .71169 .61423 L .70653 .60417 L p F P
0 g
s
.369 .181 .489 r
.53678 .64923 m .53667 .62125 L .5568 .60853 L p F P
0 g
s
.265 .102 .464 r
.52913 .6556 m .53678 .64923 L .53667 .62125 L p F P
0 g
s
.592 .367 .544 r
.4205 .38129 m .42108 .40359 L .39477 .40959 L p F P
0 g
s
.618 .388 .545 r
.42108 .40359 m .4205 .38129 L .44795 .37658 L p F P
0 g
s
.543 .394 .629 r
.3314 .51076 m .32766 .4841 L .35014 .47443 L p F P
0 g
s
.529 .364 .602 r
.34753 .44918 m .35014 .47443 L .32766 .4841 L p F P
0 g
s
.512 .372 .627 r
.32766 .4841 m .3314 .51076 L .32344 .51481 L p F P
0 g
s
0 0 .394 r
.84671 .86313 m .83893 .87817 L .84122 .908 L p F P
0 g
s
.069 0 .449 r
.8386 .91148 m .84122 .908 L .83893 .87817 L p F P
0 g
s
0 0 .394 r
.83893 .87817 m .84671 .86313 L .84438 .83359 L p F P
0 g
s
.846 .689 .688 r
.72006 .5814 m .7299 .56243 L .72441 .54952 L p F P
0 g
s
.588 .348 .521 r
.60362 .56231 m .60303 .53496 L .62981 .52929 L p F P
0 g
s
.529 .302 .515 r
.60303 .53496 m .60362 .56231 L .57891 .5704 L p F P
0 g
s
.50071 .77321 m
.50138 .77013 L
s
.50138 .77013 m
.50188 .76782 L
s
.50315 .76193 m
.50537 .75167 L
s
.50188 .76782 m
.50315 .76193 L
s
.50537 .75167 m
.50595 .74899 L
s
.56 .386 .603 r
.35014 .47443 m .34753 .44918 L .37129 .44067 L p F P
0 g
s
.353 .193 .52 r
.80995 .999 m .81847 .99368 L .81633 .96322 L p F P
0 g
s
.302 .156 .51 r
.82711 .95527 m .81633 .96322 L .81847 .99368 L p F P
0 g
s
.966 .687 .452 r
.52822 .96263 m .515 .95043 L .51504 .92028 L p F P
0 g
s
.989 .723 .376 r
.50581 .90665 m .51504 .92028 L .515 .95043 L p F P
0 g
s
.989 .723 .376 r
.51504 .92028 m .50581 .90665 L .50592 .87681 L p F P
0 g
s
.839 .615 .598 r
.70766 .48116 m .7002 .47798 L .6932 .44885 L p F P
0 g
s
.828 .609 .605 r
.68758 .44665 m .6932 .44885 L .7002 .47798 L p F P
0 g
s
.852 .649 .628 r
.70414 .4919 m .70766 .48116 L p .72289 .51726 L F P
0 g
s
.852 .649 .628 r
.72289 .51726 m .71011 .51095 L .70414 .4919 L p F P
0 g
s
.835 .725 .743 r
.71169 .61423 m .71885 .62755 L .7023 .65042 L p F P
0 g
s
.528 .468 .733 r
.33416 .62031 m .32061 .62002 L .33185 .61289 L closepath p F P
0 g
s
.517 .446 .716 r
.32278 .58046 m .33185 .61289 L .32061 .62002 L p F P
0 g
s
.798 .556 .571 r
.64706 .40976 m .66212 .41399 L .65794 .43687 L p F P
0 g
s
.814 .572 .573 r
.66212 .41399 m .65794 .43687 L .68758 .44665 L p F P
0 g
s
.923 .643 .492 r
.54547 1.00394 m .52827 .99309 L .52822 .96263 L p F P
0 g
s
.966 .687 .452 r
.515 .95043 m .52822 .96263 L .52827 .99309 L p F P
0 g
s
.942 .715 .244 r
.50069 .86168 m .50592 .87681 L .50581 .90665 L p F P
0 g
s
.942 .715 .244 r
.50592 .87681 m .50069 .86168 L .50083 .83213 L p F P
0 g
s
0 0 .286 r
.84689 .82366 m .84438 .83359 L .84671 .86313 L p F P
0 g
s
.783 .751 .824 r
.62192 .73071 m .6413 .7149 L .65418 .72198 L p F P
0 g
s
.791 .749 .815 r
.65418 .72198 m .6464 .71047 L .6413 .7149 L closepath p F P
0 g
s
.769 .51 .543 r
.62874 .40535 m .60902 .40147 L .60712 .37871 L p F P
0 g
s
.754 .499 .546 r
.59255 .37643 m .60712 .37871 L .60902 .40147 L p F P
0 g
s
.537 .433 .683 r
.31582 .55023 m .33684 .53935 L p .33578 .57358 L F P
0 g
s
.537 .433 .683 r
.33578 .57358 m .3212 .57402 L .31582 .55023 L p F P
0 g
s
.525 .408 .662 r
.33214 .51496 m .33684 .53935 L .31582 .55023 L p F P
0 g
s
.525 .408 .662 r
.32344 .51481 m .33214 .51496 L p .31582 .55023 L F P
0 g
s
.637 .636 .833 r
.46002 .73296 m .46879 .74869 L .44465 .75606 L p F P
0 g
s
.637 .636 .833 r
.44465 .75606 m .43585 .74041 L .46002 .73296 L p F P
0 g
s
.734 .72 .838 r
.57296 .76382 m .58978 .7535 L .56108 .74608 L closepath p F P
0 g
s
.715 .714 .848 r
.56108 .74608 m .57296 .76382 L p .53549 .75761 L F P
0 g
s
.9 .597 .465 r
.80068 .61522 m .78082 .60324 L .77896 .57556 L p F P
0 g
s
.857 .562 .487 r
.76866 .57094 m .77896 .57556 L .78082 .60324 L p F P
0 g
s
.835 .63 .625 r
.70414 .4919 m .70766 .48116 L .7002 .47798 L closepath p F P
0 g
s
.828 .609 .605 r
.7002 .47798 m .68102 .47055 L .68758 .44665 L p F P
0 g
s
.812 .59 .602 r
.65794 .43687 m .68758 .44665 L .68102 .47055 L p F P
0 g
s
.573 .545 .785 r
.37831 .6746 m .38468 .68975 L .361 .69281 L p F P
0 g
s
.573 .545 .785 r
.361 .69281 m .35804 .68578 L .37831 .6746 L p F P
0 g
s
.573 .56 .801 r
.361 .69281 m .38468 .68975 L p .38938 .72076 L F P
0 g
s
.525 .4 .652 r
.33214 .51496 m .32344 .51481 L .3314 .51076 L closepath p F P
0 g
s
.573 .56 .801 r
.38468 .68975 m .39683 .71647 L .38938 .72076 L p F P
0 g
s
.579 .574 .811 r
.39829 .71951 m .38938 .72076 L .39683 .71647 L closepath p F P
0 g
s
.78 .625 .063 r
.50032 .82503 m .50083 .83213 L .50069 .86168 L p F P
0 g
s
.566 .529 .773 r
.37112 .65632 m .37831 .6746 L .35804 .68578 L p F P
0 g
s
.566 .529 .773 r
.35804 .68578 m .34749 .65905 L .37112 .65632 L p F P
0 g
s
.642 .406 .546 r
.44868 .3989 m .44795 .37658 L .47664 .3732 L p F P
0 g
s
.618 .388 .545 r
.44795 .37658 m .44868 .3989 L .42108 .40359 L p F P
0 g
s
.754 .499 .546 r
.60902 .40147 m .58986 .3985 L .59255 .37643 L p F P
0 g
s
.74 .486 .545 r
.57187 .37395 m .59255 .37643 L .58986 .3985 L p F P
0 g
s
.797 .512 .507 r
.75333 .56518 m .72708 .55821 L .72559 .53083 L p F P
0 g
s
.766 .488 .513 r
.71896 .52958 m .72559 .53083 L .72708 .55821 L p F P
0 g
s
.739 .716 .831 r
.58457 .72857 m .59743 .74858 L .58978 .7535 L p F P
0 g
s
.739 .716 .831 r
.55999 .74441 m .58457 .72857 L p .58978 .7535 L F P
0 g
s
.739 .716 .831 r
.58978 .7535 m .56108 .74608 L .55999 .74441 L p F P
0 g
s
.827 .73 .757 r
.69496 .65964 m .7023 .65042 L .6836 .63962 L closepath p F P
0 g
s
.835 .725 .743 r
.70323 .60924 m .71169 .61423 L p .7023 .65042 L F P
0 g
s
.835 .725 .743 r
.68256 .63771 m .70323 .60924 L p .7023 .65042 L F P
0 g
s
.835 .725 .743 r
.7023 .65042 m .6836 .63962 L .68256 .63771 L p F P
0 g
s
.798 .556 .571 r
.65794 .43687 m .65088 .4349 L .64706 .40976 L p F P
0 g
s
.785 .546 .576 r
.62874 .40535 m .64706 .40976 L .65088 .4349 L p F P
0 g
s
.839 .698 .708 r
.72006 .5814 m .70653 .60417 L .69392 .57671 L p F P
0 g
s
.839 .698 .708 r
.69392 .57671 m .69807 .56976 L .72006 .5814 L p F P
0 g
s
.603 .398 .576 r
.3964 .43342 m .39477 .40959 L .42108 .40359 L p F P
0 g
s
.576 .378 .575 r
.39477 .40959 m .3964 .43342 L .37129 .44067 L p F P
0 g
s
.538 .443 .695 r
.32278 .58046 m .3212 .57402 L .33578 .57358 L closepath p F P
0 g
s
.766 .488 .513 r
.72708 .55821 m .72039 .55697 L .71896 .52958 L p F P
0 g
s
.824 .624 .632 r
.7002 .47798 m .68102 .47055 L p .69908 .50593 L F P
0 g
s
.824 .624 .632 r
.69908 .50593 m .70414 .4919 L .7002 .47798 L p F P
0 g
s
0 0 .198 r
.84689 .82366 m .84769 .8165 L .84534 .78724 L p F P
0 g
s
.774 .572 .001 r
.84288 .77135 m .84534 .78724 L .84769 .8165 L p F P
0 g
s
.774 .572 .001 r
.84534 .78724 m .84288 .77135 L .84057 .74239 L p F P
0 g
s
.945 .637 .424 r
.81822 .6563 m .80271 .64323 L .80068 .61522 L p F P
0 g
s
.9 .597 .465 r
.78082 .60324 m .80068 .61522 L .80271 .64323 L p F P
0 g
s
.588 .348 .521 r
.62981 .52929 m .6306 .55668 L .60362 .56231 L p F P
0 g
s
.757 .722 .82 r
.62192 .73071 m .59743 .74858 L .58457 .72857 L p F P
0 g
s
.548 .466 .714 r
.33185 .61289 m .32278 .58046 L .33578 .57358 L p F P
0 g
s
.815 .727 .768 r
.6836 .63962 m .69496 .65964 L .67608 .68132 L p F P
0 g
s
.74 .486 .545 r
.58986 .3985 m .57346 .39655 L .57187 .37395 L p F P
0 g
s
.723 .473 .548 r
.54667 .37202 m .57187 .37395 L .57346 .39655 L p F P
0 g
s
.841 .644 .636 r
.71011 .51095 m .70414 .4919 L .69908 .50593 L closepath p F P
0 g
s
.661 .655 .833 r
.4958 .74402 m .4978 .74752 L .47349 .75682 L p F P
0 g
s
.661 .655 .833 r
.47349 .75682 m .46879 .74869 L .4958 .74402 L p F P
0 g
s
.843 .718 .726 r
.71169 .61423 m .70653 .60417 L .70323 .60924 L closepath p F P
0 g
s
.565 .516 .759 r
.36402 .63681 m .37112 .65632 L .34749 .65905 L p F P
0 g
s
.565 .516 .759 r
.34749 .65905 m .34339 .64781 L .36402 .63681 L p F P
0 g
s
.608 .604 .822 r
.39829 .71951 m .42226 .71408 L .43585 .74041 L p F P
0 g
s
.606 .587 .806 r
.41885 .70694 m .42226 .71408 L .39829 .71951 L p F P
0 g
s
.606 .587 .806 r
.39829 .71951 m .39683 .71647 L .41885 .70694 L p F P
0 g
s
.663 .423 .546 r
.47664 .3732 m .48709 .37249 L .48202 .39524 L p F P
0 g
s
.663 .423 .546 r
.48202 .39524 m .47752 .39554 L .47664 .3732 L p F P
0 g
s
.642 .406 .546 r
.47664 .3732 m .47752 .39554 L .44868 .3989 L p F P
0 g
s
.857 .562 .487 r
.78082 .60324 m .77046 .59865 L .76866 .57094 L p F P
0 g
s
.835 .543 .496 r
.75333 .56518 m .76866 .57094 L .77046 .59865 L p F P
0 g
s
.554 .419 .652 r
.33214 .51496 m .3314 .51076 L .35397 .50117 L p F P
0 g
s
.543 .394 .629 r
.35014 .47443 m .35397 .50117 L .3314 .51076 L p F P
0 g
s
0 0 .048 r
.50032 .82503 m .50103 .81501 L .50118 .78574 L p F P
0 g
s
0 0 .221 r
.50623 .76989 m .50118 .78574 L .50103 .81501 L p F P
0 g
s
.558 .498 .744 r
.35771 .61801 m .36402 .63681 L .34339 .64781 L p F P
0 g
s
.558 .498 .744 r
.34339 .64781 m .33416 .62031 L .35771 .61801 L p F P
0 g
s
.943 .669 .206 r
.83378 .72737 m .84057 .74239 L .84288 .77135 L p F P
0 g
s
.943 .669 .206 r
.84057 .74239 m .83378 .72737 L .83152 .69871 L p F P
0 g
s
.529 .302 .515 r
.57933 .59811 m .57891 .5704 L .60362 .56231 L p F P
0 g
s
.457 .247 .505 r
.57891 .5704 m .57933 .59811 L .5568 .60853 L p F P
0 g
s
.976 .672 .347 r
.83152 .69871 m .82037 .68463 L .81822 .6563 L p F P
0 g
s
.945 .637 .424 r
.80271 .64323 m .81822 .6563 L .82037 .68463 L p F P
0 g
s
.673 .432 .548 r
.48709 .37249 m .50685 .37157 L .50799 .39404 L p F P
0 g
s
.673 .432 .548 r
.50799 .39404 m .48202 .39524 L .48709 .37249 L p F P
0 g
s
.602 .575 .796 r
.40865 .68437 m .41885 .70694 L .39683 .71647 L p F P
0 g
s
.602 .575 .796 r
.39683 .71647 m .38468 .68975 L .40865 .68437 L p F P
0 g
s
.556 .428 .662 r
.33684 .53935 m .33214 .51496 L .35573 .51102 L p F P
0 g
s
.554 .419 .652 r
.35397 .50117 m .35573 .51102 L .33214 .51496 L p F P
0 g
s
.633 .617 .816 r
.46002 .73296 m .43585 .74041 L .42226 .71408 L p F P
0 g
s
.557 .486 .731 r
.33416 .62031 m .33185 .61289 L .35275 .60203 L p F P
0 g
s
.548 .466 .714 r
.34459 .57293 m .35275 .60203 L .33185 .61289 L p F P
0 g
s
.548 .466 .714 r
.33578 .57358 m .34459 .57293 L p .33185 .61289 L F P
0 g
s
.723 .473 .548 r
.57346 .39655 m .5433 .39427 L .54667 .37202 L p F P
0 g
s
.711 .461 .546 r
.53847 .37164 m .54667 .37202 L .5433 .39427 L p F P
0 g
s
.557 .486 .731 r
.35275 .60203 m .35771 .61801 L .33416 .62031 L p F P
0 g
s
.587 .406 .604 r
.374 .46598 m .37129 .44067 L .3964 .43342 L p F P
0 g
s
.56 .386 .603 r
.37129 .44067 m .374 .46598 L .35014 .47443 L p F P
0 g
s
.976 .672 .347 r
.82037 .68463 m .83152 .69871 L .83378 .72737 L p F P
0 g
s
.773 .727 .81 r
.6413 .7149 m .62192 .73071 L .60918 .71059 L p F P
0 g
s
.757 .722 .82 r
.58457 .72857 m .60918 .71059 L .62192 .73071 L p F P
0 g
s
.711 .461 .546 r
.5433 .39427 m .53977 .3941 L .53847 .37164 L p F P
0 g
s
.693 .447 .547 r
.53847 .37164 m .53977 .3941 L .50799 .39404 L p F P
0 g
s
.693 .447 .547 r
.50799 .39404 m .50685 .37157 L .53847 .37164 L p F P
0 g
s
.808 .731 .78 r
.67077 .68696 m .67608 .68132 L .66349 .67475 L closepath p F P
0 g
s
.815 .727 .768 r
.6818 .63866 m .6836 .63962 L p .67608 .68132 L F P
0 g
s
.815 .727 .768 r
.65825 .66566 m .6818 .63866 L p .67608 .68132 L F P
0 g
s
.815 .727 .768 r
.67608 .68132 m .66349 .67475 L .65825 .66566 L p F P
0 g
s
.70128 .53848 m
.70254 .53767 L
s
.70254 .53767 m
.71205 .53149 L
s
.69093 .5452 m
.69157 .54479 L
s
.68399 .5497 m
.69093 .5452 L
s
.69157 .54479 m
.70128 .53848 L
s
.571 .414 .629 r
.35397 .50117 m .35014 .47443 L .374 .46598 L p F P
0 g
s
.794 .727 .79 r
.67077 .68696 m .6464 .71047 L .63376 .68961 L p F P
0 g
s
.794 .727 .79 r
.66349 .67475 m .67077 .68696 L p .63376 .68961 L F P
0 g
s
.715 .714 .848 r
.53549 .75761 m .55795 .74555 L .56108 .74608 L p F P
0 g
s
.708 .692 .832 r
.53549 .75761 m .55795 .74555 L .52642 .74293 L closepath p F P
0 g
s
.785 .546 .576 r
.65088 .4349 m .62382 .42847 L .62874 .40535 L p F P
0 g
s
.77 .531 .574 r
.60902 .40147 m .62874 .40535 L .62382 .42847 L p F P
0 g
s
.773 .727 .81 r
.60918 .71059 m .61635 .70473 L .6413 .7149 L p F P
0 g
s
.779 .723 .8 r
.63376 .68961 m .61635 .70473 L .6413 .7149 L p F P
0 g
s
.779 .723 .8 r
.6413 .7149 m .6464 .71047 L .63376 .68961 L p F P
0 g
s
.661 .647 .825 r
.48439 .72337 m .4958 .74402 L .46879 .74869 L p F P
0 g
s
.661 .647 .825 r
.46879 .74869 m .46002 .73296 L .48439 .72337 L p F P
0 g
s
.19 .076 .484 r
.8409 .94171 m .82711 .95527 L .82934 .98581 L p F P
0 g
s
.302 .156 .51 r
.81847 .99368 m .82934 .98581 L .82711 .95527 L p F P
0 g
s
.19 .076 .484 r
.82711 .95527 m .8409 .94171 L .8386 .91148 L p F P
0 g
s
.827 .694 .717 r
.70323 .60924 m .70653 .60417 L .69392 .57671 L p F P
0 g
s
.628 .416 .576 r
.42283 .42745 m .42108 .40359 L .44868 .3989 L p F P
0 g
s
.603 .398 .576 r
.42108 .40359 m .42283 .42745 L .3964 .43342 L p F P
0 g
s
.069 0 .449 r
.84122 .908 m .8386 .91148 L .8409 .94171 L p F P
0 g
s
.78 .625 .063 r
.50069 .86168 m .50017 .85464 L .50032 .82503 L p F P
0 g
s
0 0 .048 r
.50103 .81501 m .50032 .82503 L .50017 .85464 L p F P
0 g
s
.82 .637 .655 r
.67188 .49552 m .69908 .50593 L .68751 .53186 L p F P
0 g
s
.824 .624 .632 r
.68102 .47055 m .67188 .49552 L .69908 .50593 L p F P
0 g
s
.82 .701 .733 r
.70323 .60924 m .68256 .63771 L .66989 .6119 L p F P
0 g
s
.82 .701 .733 r
.66989 .6119 m .67996 .59808 L .70323 .60924 L p F P
0 g
s
.812 .59 .602 r
.65402 .45082 m .65794 .43687 L p .68102 .47055 L F P
0 g
s
.796 .573 .599 r
.65402 .45082 m .65794 .43687 L .65088 .4349 L closepath p F P
0 g
s
.457 .247 .505 r
.55706 .63658 m .5568 .60853 L .57933 .59811 L p F P
0 g
s
.369 .181 .489 r
.5568 .60853 m .55706 .63658 L .53678 .64923 L p F P
0 g
s
.808 .605 .627 r
.65655 .46257 m .68102 .47055 L .67188 .49552 L p F P
0 g
s
.812 .59 .602 r
.68102 .47055 m .65655 .46257 L .65402 .45082 L p F P
0 g
s
.77 .531 .574 r
.62382 .42847 m .61235 .42623 L .60902 .40147 L p F P
0 g
s
.755 .521 .578 r
.58986 .3985 m .60902 .40147 L .61235 .42623 L p F P
0 g
s
.566 .452 .682 r
.34371 .56954 m .33684 .53935 L .35938 .52975 L p F P
0 g
s
.556 .428 .662 r
.35573 .51102 m .35938 .52975 L .33684 .53935 L p F P
0 g
s
.537 .433 .683 r
.33684 .53935 m .34371 .56954 L .33578 .57358 L p F P
0 g
s
.835 .543 .496 r
.77046 .59865 m .75502 .59292 L .75333 .56518 L p F P
0 g
s
.797 .512 .507 r
.72708 .55821 m .75333 .56518 L .75502 .59292 L p F P
0 g
s
.718 .71 .841 r
.56108 .74608 m .55999 .74441 L .55795 .74555 L closepath p F P
0 g
s
0 0 .198 r
.84769 .8165 m .84689 .82366 L .84926 .85328 L p F P
0 g
s
0 0 .286 r
.84671 .86313 m .84926 .85328 L .84689 .82366 L p F P
0 g
s
.547 .455 .702 r
.34459 .57293 m .33578 .57358 L .34371 .56954 L closepath p F P
0 g
s
.599 .559 .781 r
.40058 .66509 m .40865 .68437 L .38468 .68975 L p F P
0 g
s
.599 .559 .781 r
.38468 .68975 m .37831 .6746 L .40058 .66509 L p F P
0 g
s
.51372 .72932 m
.51611 .72329 L
s
.50942 .74021 m
.51372 .72932 L
s
.711 .686 .824 r
.54686 .72221 m .55999 .74441 L .55795 .74555 L p F P
0 g
s
.711 .686 .824 r
.52227 .73601 m .54686 .72221 L p .55795 .74555 L F P
0 g
s
.711 .686 .824 r
.55795 .74555 m .52642 .74293 L .52227 .73601 L p F P
0 g
s
.784 .565 .604 r
.65088 .4349 m .65402 .45082 L .65086 .46095 L p F P
0 g
s
.784 .565 .604 r
.62382 .42847 m .65088 .4349 L p .65086 .46095 L F P
0 g
s
.682 .664 .825 r
.4978 .74752 m .50696 .74329 L .4958 .74402 L closepath p F P
0 g
s
.50662 .74729 m
.5077 .74456 L
s
.50595 .74899 m
.50662 .74729 L
s
.73 .693 .815 r
.58457 .72857 m .55999 .74441 L .54686 .72221 L p F P
0 g
s
.649 .432 .575 r
.44868 .3989 m .47752 .39554 L p .47047 .42049 L F P
0 g
s
.649 .432 .575 r
.47047 .42049 m .45056 .42279 L .44868 .3989 L p F P
0 g
s
.628 .416 .576 r
.44868 .3989 m .45056 .42279 L .42283 .42745 L p F P
0 g
s
.612 .424 .603 r
.39922 .45878 m .3964 .43342 L .42283 .42745 L p F P
0 g
s
.587 .406 .604 r
.3964 .43342 m .39922 .45878 L .374 .46598 L p F P
0 g
s
0 0 .394 r
.84909 .8931 m .84122 .908 L .84355 .93827 L p F P
0 g
s
0 0 .394 r
.84122 .908 m .84909 .8931 L .84671 .86313 L p F P
0 g
s
.069 0 .449 r
.8409 .94171 m .84355 .93827 L .84122 .908 L p F P
0 g
s
.683 .657 .817 r
.50696 .74329 m .4958 .74402 L .48439 .72337 L p F P
0 g
s
.794 .727 .79 r
.63376 .68961 m .65389 .67019 L .66349 .67475 L p F P
0 g
s
.801 .723 .778 r
.66349 .67475 m .65825 .66566 L .65389 .67019 L closepath p F P
0 g
s
.755 .521 .578 r
.61235 .42623 m .58405 .42189 L .58986 .3985 L p F P
0 g
s
.742 .508 .575 r
.57346 .39655 m .58986 .3985 L .58405 .42189 L p F P
0 g
s
.594 .545 .769 r
.39508 .65104 m .40058 .66509 L .37831 .6746 L p F P
0 g
s
.594 .545 .769 r
.37831 .6746 m .37112 .65632 L .39508 .65104 L p F P
0 g
s
.588 .348 .521 r
.60422 .59007 m .60362 .56231 L .6306 .55668 L p F P
0 g
s
.529 .302 .515 r
.60362 .56231 m .60422 .59007 L .57933 .59811 L p F P
0 g
s
.683 .657 .817 r
.48439 .72337 m .50893 .71161 L p .50696 .74329 L F P
0 g
s
.966 .687 .452 r
.52827 .99309 m .51496 .98102 L .515 .95043 L p F P
0 g
s
.989 .723 .376 r
.5057 .93693 m .515 .95043 L .51496 .98102 L p F P
0 g
s
.989 .723 .376 r
.515 .95043 m .5057 .93693 L .50581 .90665 L p F P
0 g
s
.822 .721 .754 r
.6836 .63962 m .68256 .63771 L .6818 .63866 L closepath p F P
0 g
s
.656 .628 .809 r
.48439 .72337 m .46002 .73296 L .44647 .7065 L p F P
0 g
s
.633 .617 .816 r
.42226 .71408 m .44647 .7065 L .46002 .73296 L p F P
0 g
s
.63 .599 .801 r
.44308 .69933 m .44647 .7065 L .42226 .71408 L p F P
0 g
s
.63 .599 .801 r
.42226 .71408 m .41885 .70694 L .44308 .69933 L p F P
0 g
s
.58 .437 .651 r
.35573 .51102 m .35397 .50117 L .37792 .49279 L p F P
0 g
s
.571 .414 .629 r
.374 .46598 m .37792 .49279 L .35397 .50117 L p F P
0 g
s
.942 .715 .244 r
.50054 .89166 m .50581 .90665 L .5057 .93693 L p F P
0 g
s
.942 .715 .244 r
.50581 .90665 m .50054 .89166 L .50069 .86168 L p F P
0 g
s
.808 .697 .743 r
.6818 .63866 m .68256 .63771 L .66989 .6119 L p F P
0 g
s
.597 .431 .629 r
.37792 .49279 m .374 .46598 L .39922 .45878 L p F P
0 g
s
.802 .704 .757 r
.6818 .63866 m .65825 .66566 L .6455 .64118 L p F P
0 g
s
.802 .704 .757 r
.6455 .64118 m .65697 .62807 L .6818 .63866 L p F P
0 g
s
.808 .697 .743 r
.66989 .6119 m .65697 .62807 L .6818 .63866 L p F P
0 g
s
.574 .472 .701 r
.34459 .57293 m .34371 .56954 L .36633 .56005 L p F P
0 g
s
.566 .452 .682 r
.35938 .52975 m .36633 .56005 L .34371 .56954 L p F P
0 g
s
0 0 .286 r
.84926 .85328 m .84671 .86313 L .84909 .8931 L p F P
0 g
s
.742 .508 .575 r
.58405 .42189 m .57636 .42099 L .57346 .39655 L p F P
0 g
s
.726 .496 .578 r
.57346 .39655 m .57636 .42099 L .54243 .41844 L p F P
0 g
s
.726 .496 .578 r
.5433 .39427 m .57346 .39655 L p .54243 .41844 L F P
0 g
s
.576 .483 .712 r
.35275 .60203 m .34459 .57293 L .3684 .56798 L p F P
0 g
s
.574 .472 .701 r
.36633 .56005 m .3684 .56798 L .34459 .57293 L p F P
0 g
s
.747 .7 .806 r
.60918 .71059 m .58457 .72857 L .57154 .70625 L p F P
0 g
s
.73 .693 .815 r
.54686 .72221 m .57154 .70625 L .58457 .72857 L p F P
0 g
s
.592 .531 .755 r
.38646 .62731 m .39508 .65104 L .37112 .65632 L p F P
0 g
s
.592 .531 .755 r
.37112 .65632 m .36402 .63681 L .38646 .62731 L p F P
0 g
s
.799 .582 .608 r
.65655 .46257 m .65402 .45082 L .65086 .46095 L closepath p F P
0 g
s
.627 .588 .791 r
.43289 .67667 m .44308 .69933 L .41885 .70694 L p F P
0 g
s
.627 .588 .791 r
.41885 .70694 m .40865 .68437 L .43289 .67667 L p F P
0 g
s
.9 .597 .465 r
.80271 .64323 m .78272 .63132 L .78082 .60324 L p F P
0 g
s
.857 .562 .487 r
.77046 .59865 m .78082 .60324 L .78272 .63132 L p F P
0 g
s
.669 .447 .574 r
.47827 .40448 m .48202 .39524 L .47752 .39554 L closepath p F P
0 g
s
.649 .432 .575 r
.47752 .39554 m .47827 .40448 L .47047 .42049 L p F P
0 g
s
.679 .458 .578 r
.48202 .39524 m .50799 .39404 L p .47967 .4196 L F P
0 g
s
.679 .458 .578 r
.47967 .4196 m .47827 .40448 L .48202 .39524 L p F P
0 g
s
.584 .447 .661 r
.35938 .52975 m .35573 .51102 L .37972 .50267 L p F P
0 g
s
.58 .437 .651 r
.37792 .49279 m .37972 .50267 L .35573 .51102 L p F P
0 g
s
.78 .625 .063 r
.50017 .85464 m .50069 .86168 L .50054 .89166 L p F P
0 g
s
.586 .515 .741 r
.38162 .61287 m .38646 .62731 L .36402 .63681 L p F P
0 g
s
.586 .515 .741 r
.36402 .63681 m .35771 .61801 L .38162 .61287 L p F P
0 g
s
.583 .502 .728 r
.35771 .61801 m .35275 .60203 L .3753 .59253 L p F P
0 g
s
.576 .483 .712 r
.3684 .56798 m .3753 .59253 L .35275 .60203 L p F P
0 g
s
.583 .502 .728 r
.3753 .59253 m .38162 .61287 L .35771 .61801 L p F P
0 g
s
.726 .496 .578 r
.54243 .41844 m .54071 .40314 L .5433 .39427 L p F P
0 g
s
.715 .484 .574 r
.54071 .40314 m .5433 .39427 L .53977 .3941 L closepath p F P
0 g
s
.698 .471 .577 r
.53977 .3941 m .54071 .40314 L .53563 .41825 L p F P
0 g
s
.698 .471 .577 r
.50799 .39404 m .53977 .3941 L p .53563 .41825 L F P
0 g
s
.698 .471 .577 r
.53563 .41825 m .51035 .4182 L .50799 .39404 L p F P
0 g
s
.679 .458 .578 r
.50799 .39404 m .51035 .4182 L .47967 .4196 L p F P
0 g
s
.797 .512 .507 r
.75502 .59292 m .72858 .58599 L .72708 .55821 L p F P
0 g
s
.766 .488 .513 r
.72039 .55697 m .72708 .55821 L .72858 .58599 L p F P
0 g
s
.784 .565 .604 r
.61672 .45073 m .62382 .42847 L p .65086 .46095 L F P
0 g
s
.77 .55 .6 r
.61672 .45073 m .62382 .42847 L .61235 .42623 L closepath p F P
0 g
s
.763 .705 .797 r
.60918 .71059 m .61635 .70473 L .60354 .7008 L closepath p F P
0 g
s
.747 .7 .806 r
.60354 .7008 m .60918 .71059 L p .57154 .70625 L F P
0 g
s
.788 .699 .766 r
.65389 .67019 m .65825 .66566 L .6455 .64118 L p F P
0 g
s
.815 .648 .675 r
.68102 .54419 m .68751 .53186 L .675 .52714 L closepath p F P
0 g
s
.82 .637 .655 r
.66778 .50461 m .67188 .49552 L p .68751 .53186 L F P
0 g
s
.82 .637 .655 r
.68751 .53186 m .675 .52714 L .66778 .50461 L p F P
0 g
s
.783 .705 .778 r
.65389 .67019 m .63376 .68961 L .62092 .66624 L p F P
0 g
s
.783 .705 .778 r
.62092 .66624 m .62708 .6603 L .65389 .67019 L p F P
0 g
s
.788 .699 .766 r
.6455 .64118 m .62708 .6603 L .65389 .67019 L p F P
0 g
s
.808 .605 .627 r
.67188 .49552 m .66441 .49312 L .65655 .46257 L p F P
0 g
s
.796 .598 .634 r
.65086 .46095 m .65655 .46257 L .66441 .49312 L p F P
0 g
s
.768 .7 .787 r
.62092 .66624 m .63376 .68961 L .61635 .70473 L p F P
0 g
s
.768 .7 .787 r
.59624 .68769 m .62092 .66624 L p .61635 .70473 L F P
0 g
s
.768 .7 .787 r
.61635 .70473 m .60354 .7008 L .59624 .68769 L p F P
0 g
s
.635 .441 .603 r
.42283 .42745 m .45056 .42279 L p .45129 .44862 L F P
0 g
s
.635 .441 .603 r
.45129 .44862 m .42577 .45286 L .42283 .42745 L p F P
0 g
s
.612 .424 .603 r
.42283 .42745 m .42577 .45286 L .39922 .45878 L p F P
0 g
s
.766 .488 .513 r
.72858 .58599 m .72185 .58476 L .72039 .55697 L p F P
0 g
s
.736 .464 .517 r
.69178 .55378 m .72039 .55697 L .72185 .58476 L p F P
0 g
s
0 0 .198 r
.84926 .85328 m .85007 .84618 L .84769 .8165 L p F P
0 g
s
.774 .572 .001 r
.84524 .80073 m .84769 .8165 L .85007 .84618 L p F P
0 g
s
.774 .572 .001 r
.84769 .8165 m .84524 .80073 L .84288 .77135 L p F P
0 g
s
.945 .637 .424 r
.82037 .68463 m .80476 .67165 L .80271 .64323 L p F P
0 g
s
.9 .597 .465 r
.78272 .63132 m .80271 .64323 L .80476 .67165 L p F P
0 g
s
.796 .598 .634 r
.66441 .49312 m .64044 .48636 L .65086 .46095 L p F P
0 g
s
.782 .581 .628 r
.61717 .45302 m .65086 .46095 L .64044 .48636 L p F P
0 g
s
.784 .565 .604 r
.65086 .46095 m .61717 .45302 L .61672 .45073 L p F P
0 g
s
.805 .618 .649 r
.66778 .50461 m .67188 .49552 L .66441 .49312 L closepath p F P
0 g
s
.756 .54 .605 r
.61235 .42623 m .61672 .45073 L .61599 .4528 L p F P
0 g
s
.756 .54 .605 r
.58405 .42189 m .61235 .42623 L p .61599 .4528 L F P
0 g
s
.658 .442 .58 r
.47967 .4196 m .47827 .40448 L .47047 .42049 L closepath p F P
0 g
s
.592 .469 .681 r
.36633 .56005 m .35938 .52975 L .38343 .52145 L p F P
0 g
s
.584 .447 .661 r
.37972 .50267 m .38343 .52145 L .35938 .52975 L p F P
0 g
s
.857 .562 .487 r
.78272 .63132 m .77228 .62676 L .77046 .59865 L p F P
0 g
s
.835 .543 .496 r
.75502 .59292 m .77046 .59865 L .77228 .62676 L p F P
0 g
s
.623 .572 .776 r
.42482 .6573 m .43289 .67667 L .40865 .68437 L p F P
0 g
s
.623 .572 .776 r
.40865 .68437 m .40058 .66509 L .42482 .6573 L p F P
0 g
s
0 0 .048 r
.50017 .85464 m .50089 .84471 L .50103 .81501 L p F P
0 g
s
0 0 .221 r
.50612 .79928 m .50103 .81501 L .50089 .84471 L p F P
0 g
s
0 0 .221 r
.50103 .81501 m .50612 .79928 L .50623 .76989 L p F P
0 g
s
.68378 .54986 m
.68399 .5497 L
s
.6804 .55225 m
.68378 .54986 L
s
.67672 .55487 m
.6804 .55225 L
s
.65505 .57026 m
.6603 .56653 L
s
.6603 .56653 m
.66195 .56536 L
s
.677 .637 .802 r
.50893 .71161 m .48439 .72337 L .47089 .69678 L p F P
0 g
s
.656 .628 .809 r
.44647 .7065 m .47089 .69678 L .48439 .72337 L p F P
0 g
s
.943 .669 .206 r
.83606 .75644 m .84288 .77135 L .84524 .80073 L p F P
0 g
s
.943 .669 .206 r
.84288 .77135 m .83606 .75644 L .83378 .72737 L p F P
0 g
s
.807 .68 .724 r
.66989 .6119 m .67996 .59808 L .66025 .5903 L closepath p F P
0 g
s
.709 .483 .581 r
.54243 .41844 m .54071 .40314 L .53563 .41825 L closepath p F P
0 g
s
.976 .672 .347 r
.83378 .72737 m .82256 .71338 L .82037 .68463 L p F P
0 g
s
.945 .637 .424 r
.80476 .67165 m .82037 .68463 L .82256 .71338 L p F P
0 g
s
.62 .448 .627 r
.39922 .45878 m .42577 .45286 L p .41323 .48346 L F P
0 g
s
.62 .448 .627 r
.41323 .48346 m .40325 .48566 L .39922 .45878 L p F P
0 g
s
.597 .431 .629 r
.39922 .45878 m .40325 .48566 L .37792 .49279 L p F P
0 g
s
.976 .672 .347 r
.82256 .71338 m .83378 .72737 L .83606 .75644 L p F P
0 g
s
.793 .612 .656 r
.66441 .49312 m .66778 .50461 L .65924 .52184 L p F P
0 g
s
.793 .612 .656 r
.64044 .48636 m .66441 .49312 L p .65924 .52184 L F P
0 g
s
.736 .464 .517 r
.72185 .58476 m .69303 .58158 L .69178 .55378 L p F P
0 g
s
.652 .61 .795 r
.46944 .6937 m .47089 .69678 L .44647 .7065 L p F P
0 g
s
.652 .61 .795 r
.44647 .7065 m .44308 .69933 L .46944 .6937 L p F P
0 g
s
.747 .7 .806 r
.57154 .70625 m .58512 .69631 L .60354 .7008 L p F P
0 g
s
.604 .453 .65 r
.37972 .50267 m .37792 .49279 L .40325 .48566 L p F P
0 g
s
.752 .694 .796 r
.60354 .7008 m .59624 .68769 L .58512 .69631 L closepath p F P
0 g
s
0 0 .323 r
.50823 .76612 m .50623 .76989 L .50612 .79928 L p F P
0 g
s
.808 .631 .662 r
.675 .52714 m .66778 .50461 L .65924 .52184 L closepath p F P
0 g
s
.51756 .72069 m
.51983 .71661 L
s
.51611 .72329 m
.51756 .72069 L
s
.655 .455 .601 r
.45336 .4461 m .47047 .42049 L .45056 .42279 L closepath p F P
0 g
s
.635 .441 .603 r
.45056 .42279 m .45336 .4461 L .45129 .44862 L p F P
0 g
s
.62 .559 .764 r
.41931 .64319 m .42482 .6573 L .40058 .66509 L p F P
0 g
s
.62 .559 .764 r
.40058 .66509 m .39508 .65104 L .41931 .64319 L p F P
0 g
s
.795 .675 .733 r
.66025 .5903 m .66989 .6119 L .65697 .62807 L p F P
0 g
s
.19 .076 .484 r
.82934 .98581 m .84325 .97239 L .8409 .94171 L p F P
0 g
s
.756 .54 .605 r
.57881 .43627 m .58405 .42189 L p .61599 .4528 L F P
0 g
s
.743 .526 .6 r
.57881 .43627 m .58405 .42189 L .57636 .42099 L closepath p F P
0 g
s
.65 .6 .785 r
.45734 .66661 m .46944 .6937 L .44308 .69933 L p F P
0 g
s
.65 .6 .785 r
.44308 .69933 m .43289 .67667 L .45734 .66661 L p F P
0 g
s
.598 .487 .698 r
.3684 .56798 m .36633 .56005 L .39045 .55185 L p F P
0 g
s
.592 .469 .681 r
.38343 .52145 m .39045 .55185 L .36633 .56005 L p F P
0 g
s
.069 0 .449 r
.84355 .93827 m .8409 .94171 L .84325 .97239 L p F P
0 g
s
.609 .464 .659 r
.38343 .52145 m .37972 .50267 L .40403 .4899 L p F P
0 g
s
.604 .453 .65 r
.40325 .48566 m .40403 .4899 L .37972 .50267 L p F P
0 g
s
.728 .516 .604 r
.57636 .42099 m .57881 .43627 L .5745 .44678 L p F P
0 g
s
.728 .516 .604 r
.54243 .41844 m .57636 .42099 L p .5745 .44678 L F P
0 g
s
.78 .625 .063 r
.50054 .89166 m .50002 .88469 L .50017 .85464 L p F P
0 g
s
0 0 .048 r
.50089 .84471 m .50017 .85464 L .50002 .88469 L p F P
0 g
s
.616 .544 .751 r
.41068 .61937 m .41931 .64319 L .39508 .65104 L p F P
0 g
s
.616 .544 .751 r
.39508 .65104 m .38646 .62731 L .41068 .61937 L p F P
0 g
s
.664 .466 .607 r
.47047 .42049 m .47967 .4196 L p .45364 .44826 L F P
0 g
s
.664 .466 .607 r
.45364 .44826 m .45336 .4461 L .47047 .42049 L p F P
0 g
s
.602 .499 .709 r
.3753 .59253 m .3684 .56798 L .39253 .55982 L p F P
0 g
s
.598 .487 .698 r
.39045 .55185 m .39253 .55982 L .3684 .56798 L p F P
0 g
s
.738 .679 .793 r
.57154 .70625 m .58512 .69631 L .5643 .69274 L closepath p F P
0 g
s
.79 .683 .746 r
.6455 .64118 m .65697 .62807 L .63582 .6208 L closepath p F P
0 g
s
.795 .675 .733 r
.65697 .62807 m .63582 .6208 L .63256 .61358 L p F P
0 g
s
.683 .48 .605 r
.48316 .44542 m .47967 .4196 L .51035 .4182 L p F P
0 g
s
.664 .466 .607 r
.47967 .4196 m .48316 .44542 L .45364 .44826 L p F P
0 g
s
.835 .543 .496 r
.77228 .62676 m .75673 .62106 L .75502 .59292 L p F P
0 g
s
.797 .512 .507 r
.72858 .58599 m .75502 .59292 L .75673 .62106 L p F P
0 g
s
0 0 .198 r
.85007 .84618 m .84926 .85328 L .85167 .88334 L p F P
0 g
s
0 0 .286 r
.84909 .8931 m .85167 .88334 L .84926 .85328 L p F P
0 g
s
.769 .556 .609 r
.61717 .45302 m .61672 .45073 L .61599 .4528 L closepath p F P
0 g
s
.612 .529 .737 r
.40582 .60487 m .41068 .61937 L .38646 .62731 L p F P
0 g
s
.612 .529 .737 r
.38646 .62731 m .38162 .61287 L .40582 .60487 L p F P
0 g
s
.608 .516 .725 r
.38162 .61287 m .3753 .59253 L .39948 .58446 L p F P
0 g
s
.602 .499 .709 r
.39253 .55982 m .39948 .58446 L .3753 .59253 L p F P
0 g
s
0 0 .323 r
.50612 .79928 m .50813 .79554 L .50823 .76612 L p F P
0 g
s
.036 0 .392 r
.51967 .75098 m .50823 .76612 L .50813 .79554 L p F P
0 g
s
.036 0 .392 r
.50823 .76612 m .51967 .75098 L .51968 .72187 L p F P
0 g
s
.697 .646 .795 r
.50893 .71161 m .4983 .69049 L .52971 .68989 L p F P
0 g
s
.52549 .70647 m
.52751 .70286 L
s
.52751 .70286 m
.53095 .69669 L
s
.677 .637 .802 r
.4983 .69049 m .50893 .71161 L p .47089 .69678 L F P
0 g
s
.608 .516 .725 r
.39948 .58446 m .40582 .60487 L .38162 .61287 L p F P
0 g
s
.728 .516 .604 r
.5745 .44678 m .54653 .44471 L .54243 .41844 L p F P
0 g
s
.712 .505 .607 r
.53563 .41825 m .54243 .41844 L .54653 .44471 L p F P
0 g
s
.742 .672 .783 r
.58314 .66192 m .59624 .68769 L .58512 .69631 L p F P
0 g
s
.742 .672 .783 r
.55835 .68116 m .58314 .66192 L p .58512 .69631 L F P
0 g
s
.742 .672 .783 r
.58512 .69631 m .5643 .69274 L .55835 .68116 L p F P
0 g
s
.782 .581 .628 r
.64044 .48636 m .62408 .48256 L .61717 .45302 L p F P
0 g
s
.768 .573 .634 r
.61599 .4528 m .61717 .45302 L .62408 .48256 L p F P
0 g
s
.712 .505 .607 r
.54653 .44471 m .52332 .44405 L .53563 .41825 L p F P
0 g
s
.701 .492 .602 r
.51035 .4182 m .53563 .41825 L .52332 .44405 L p F P
0 g
s
.776 .677 .755 r
.63582 .6208 m .6455 .64118 L .62708 .6603 L p F P
0 g
s
.701 .492 .602 r
.52332 .44405 m .51397 .44403 L .51035 .4182 L p F P
0 g
s
.683 .48 .605 r
.51035 .4182 m .51397 .44403 L .48316 .44542 L p F P
0 g
s
.641 .462 .626 r
.42861 .47135 m .45129 .44862 L .42577 .45286 L closepath p F P
0 g
s
.62 .448 .627 r
.42577 .45286 m .42861 .47135 L .41323 .48346 L p F P
0 g
s
.768 .573 .634 r
.62408 .48256 m .60399 .47874 L .61599 .4528 L p F P
0 g
s
.755 .557 .628 r
.58076 .44746 m .61599 .4528 L .60399 .47874 L p F P
0 g
s
.756 .54 .605 r
.61599 .4528 m .58076 .44746 L .57881 .43627 L p F P
0 g
s
.195 .049 .444 r
.52925 .7127 m .51968 .72187 L .51967 .75098 L p F P
0 g
s
.51983 .71661 m
.52549 .70647 L
s
.79 .624 .675 r
.64387 .54828 m .65924 .52184 L .63289 .51451 L closepath p F P
0 g
s
.793 .612 .656 r
.63047 .50626 m .64044 .48636 L p .65924 .52184 L F P
0 g
s
.793 .612 .656 r
.65924 .52184 m .63289 .51451 L .63047 .50626 L p F P
0 g
s
.757 .679 .775 r
.62092 .66624 m .59624 .68769 L .58314 .66192 L p F P
0 g
s
.615 .484 .679 r
.39045 .55185 m .38343 .52145 L .40894 .51451 L p F P
0 g
s
.609 .464 .659 r
.40403 .4899 m .40894 .51451 L .38343 .52145 L p F P
0 g
s
.772 .684 .767 r
.62092 .66624 m .62708 .6603 L .61638 .65721 L closepath p F P
0 g
s
.776 .677 .755 r
.62817 .61854 m .63582 .6208 L p .62708 .6603 L F P
0 g
s
.776 .677 .755 r
.6079 .63955 m .62817 .61854 L p .62708 .6603 L F P
0 g
s
.776 .677 .755 r
.62708 .6603 m .61638 .65721 L .6079 .63955 L p F P
0 g
s
.78 .595 .65 r
.63047 .50626 m .64044 .48636 L .62408 .48256 L closepath p F P
0 g
s
.645 .584 .771 r
.45099 .65126 m .45734 .66661 L .43289 .67667 L p F P
0 g
s
.645 .584 .771 r
.43289 .67667 m .42482 .6573 L .45099 .65126 L p F P
0 g
s
.757 .679 .775 r
.61638 .65721 m .62092 .66624 L p .58314 .66192 L F P
0 g
s
0 0 .394 r
.8515 .9235 m .84355 .93827 L .84592 .96898 L p F P
0 g
s
.069 0 .449 r
.84325 .97239 m .84592 .96898 L .84355 .93827 L p F P
0 g
s
0 0 .394 r
.84355 .93827 m .8515 .9235 L .84909 .8931 L p F P
0 g
s
.677 .637 .802 r
.47089 .69678 m .4801 .69234 L .4983 .69049 L p F P
0 g
s
.672 .62 .789 r
.47089 .69678 m .4801 .69234 L .46944 .6937 L closepath p F P
0 g
s
.626 .468 .649 r
.40403 .4899 m .41323 .48346 L .40325 .48566 L closepath p F P
0 g
s
.74 .53 .609 r
.58076 .44746 m .57881 .43627 L .5745 .44678 L closepath p F P
0 g
s
.989 .723 .376 r
.51496 .98102 m .50559 .96766 L .5057 .93693 L p F P
0 g
s
.671 .61 .778 r
.4801 .69234 m .46944 .6937 L .45734 .66661 L p F P
0 g
s
.632 .479 .657 r
.40894 .51451 m .40403 .4899 L .41323 .48346 L p F P
0 g
s
.942 .715 .244 r
.50039 .92208 m .5057 .93693 L .50559 .96766 L p F P
0 g
s
.942 .715 .244 r
.5057 .93693 m .50039 .92208 L .50054 .89166 L p F P
0 g
s
0 0 .286 r
.85167 .88334 m .84909 .8931 L .8515 .9235 L p F P
0 g
s
.642 .451 .609 r
.45364 .44826 m .45336 .4461 L .45129 .44862 L closepath p F P
0 g
s
.632 .479 .657 r
.41323 .48346 m .43004 .47993 L p .40894 .51451 L F P
0 g
s
.626 .458 .635 r
.43004 .47993 m .42861 .47135 L .41323 .48346 L closepath p F P
0 g
s
.678 .628 .793 r
.4983 .69049 m .49549 .68465 L .4801 .69234 L closepath p F P
0 g
s
.671 .61 .778 r
.48198 .6542 m .49549 .68465 L .4801 .69234 L p F P
0 g
s
.671 .61 .778 r
.45734 .66661 m .48198 .6542 L p .4801 .69234 L F P
0 g
s
.648 .473 .633 r
.45129 .44862 m .45364 .44826 L p .43004 .47993 L F P
0 g
s
.648 .473 .633 r
.43004 .47993 m .42861 .47135 L .45129 .44862 L p F P
0 g
s
.9 .597 .465 r
.80476 .67165 m .78464 .65982 L .78272 .63132 L p F P
0 g
s
.857 .562 .487 r
.77228 .62676 m .78272 .63132 L .78464 .65982 L p F P
0 g
s
.6491 .57494 m
.65505 .57026 L
s
.63552 .58562 m
.63942 .58255 L
s
.63282 .58774 m
.63552 .58562 L
s
.643 .572 .759 r
.44378 .63276 m .45099 .65126 L .42482 .6573 L p F P
0 g
s
.643 .572 .759 r
.42482 .6573 m .41931 .64319 L .44378 .63276 L p F P
0 g
s
.757 .679 .775 r
.58314 .66192 m .5945 .65205 L .61638 .65721 L p F P
0 g
s
.761 .672 .763 r
.61638 .65721 m .6079 .63955 L .5945 .65205 L closepath p F P
0 g
s
.668 .487 .631 r
.4583 .4757 m .45364 .44826 L .48316 .44542 L p F P
0 g
s
.648 .473 .633 r
.45364 .44826 m .4583 .4757 L .43004 .47993 L p F P
0 g
s
.53892 .68547 m
.55004 .66979 L
s
.53095 .69669 m
.53297 .69385 L
s
.53509 .69086 m
.53571 .68999 L
s
.53297 .69385 m
.53509 .69086 L
s
.767 .587 .655 r
.62408 .48256 m .63047 .50626 L .6267 .51306 L p F P
0 g
s
.767 .587 .655 r
.60399 .47874 m .62408 .48256 L p .6267 .51306 L F P
0 g
s
.78 .625 .063 r
.50002 .88469 m .50054 .89166 L .50039 .92208 L p F P
0 g
s
.741 .548 .633 r
.5745 .44678 m .58076 .44746 L .58688 .47618 L p F P
0 g
s
.755 .557 .628 r
.60399 .47874 m .58688 .47618 L .58076 .44746 L p F P
0 g
s
.62 .501 .696 r
.39253 .55982 m .39045 .55185 L .41604 .54499 L p F P
0 g
s
.615 .484 .679 r
.40894 .51451 m .41604 .54499 L .39045 .55185 L p F P
0 g
s
.741 .548 .633 r
.58688 .47618 m .56053 .47338 L .5745 .44678 L p F P
0 g
s
.729 .534 .627 r
.54653 .44471 m .5745 .44678 L .56053 .47338 L p F P
0 g
s
.638 .557 .747 r
.43664 .61301 m .44378 .63276 L .41931 .64319 L p F P
0 g
s
.638 .557 .747 r
.41931 .64319 m .41068 .61937 L .43664 .61301 L p F P
0 g
s
.797 .512 .507 r
.75673 .62106 m .73011 .61418 L .72858 .58599 L p F P
0 g
s
.766 .488 .513 r
.72185 .58476 m .72858 .58599 L .73011 .61418 L p F P
0 g
s
.781 .67 .741 r
.63582 .6208 m .63256 .61358 L .62817 .61854 L closepath p F P
0 g
s
.626 .513 .706 r
.39948 .58446 m .39253 .55982 L .41694 .54841 L p F P
0 g
s
.62 .501 .696 r
.41604 .54499 m .41694 .54841 L .39253 .55982 L p F P
0 g
s
.698 .638 .785 r
.52022 .66999 m .52971 .68989 L .4983 .69049 L p F P
0 g
s
.698 .638 .785 r
.4983 .69049 m .49549 .68465 L .52022 .66999 L p F P
0 g
s
.687 .499 .628 r
.48316 .44542 m .51397 .44403 L p .50492 .47213 L F P
0 g
s
.687 .499 .628 r
.50492 .47213 m .48792 .47289 L .48316 .44542 L p F P
0 g
s
.668 .487 .631 r
.48316 .44542 m .48792 .47289 L .4583 .4757 L p F P
0 g
s
.766 .488 .513 r
.73011 .61418 m .72333 .61295 L .72185 .58476 L p F P
0 g
s
.736 .464 .517 r
.69303 .58158 m .72185 .58476 L .72333 .61295 L p F P
0 g
s
.79 .636 .69 r
.64443 .54984 m .64387 .54828 L .64312 .54946 L closepath p F P
0 g
s
.78 .605 .662 r
.63289 .51451 m .63047 .50626 L .6267 .51306 L closepath p F P
0 g
s
0 0 .198 r
.85167 .88334 m .85249 .8763 L .85007 .84618 L p F P
0 g
s
.774 .572 .001 r
.84762 .83055 m .85007 .84618 L .85249 .8763 L p F P
0 g
s
.774 .572 .001 r
.85007 .84618 m .84762 .83055 L .84524 .80073 L p F P
0 g
s
.777 .617 .682 r
.64312 .54946 m .64387 .54828 L .63289 .51451 L p F P
0 g
s
.653 .493 .654 r
.4359 .50893 m .43004 .47993 L .4583 .4757 L p F P
0 g
s
.632 .479 .657 r
.43004 .47993 m .4359 .50893 L .40894 .51451 L p F P
0 g
s
.635 .543 .733 r
.43028 .59398 m .43664 .61301 L .41068 .61937 L p F P
0 g
s
.635 .543 .733 r
.41068 .61937 m .40582 .60487 L .43028 .59398 L p F P
0 g
s
.945 .637 .424 r
.82256 .71338 m .80685 .70049 L .80476 .67165 L p F P
0 g
s
.9 .597 .465 r
.78464 .65982 m .80476 .67165 L .80685 .70049 L p F P
0 g
s
.63 .529 .721 r
.40582 .60487 m .39948 .58446 L .42525 .57782 L p F P
0 g
s
.626 .513 .706 r
.41694 .54841 m .42525 .57782 L .39948 .58446 L p F P
0 g
s
.69 .62 .772 r
.52022 .66999 m .49549 .68465 L .48198 .6542 L p F P
0 g
s
.774 .628 .699 r
.6084 .54143 m .64312 .54946 L .62173 .57894 L p F P
0 g
s
.63942 .58255 m
.6491 .57494 L
s
.777 .617 .682 r
.6267 .51306 m .6084 .54143 L .64312 .54946 L p F P
0 g
s
.777 .617 .682 r
.63289 .51451 m .6267 .51306 L p .64312 .54946 L F P
0 g
s
.637 .497 .676 r
.40894 .51451 m .4359 .50893 L p .42616 .54292 L F P
0 g
s
.637 .497 .676 r
.42616 .54292 m .41604 .54499 L .40894 .51451 L p F P
0 g
s
.729 .534 .627 r
.56053 .47338 m .55198 .47276 L .54653 .44471 L p F P
0 g
s
.713 .523 .631 r
.54653 .44471 m .55198 .47276 L .51911 .47184 L p F P
0 g
s
.713 .523 .631 r
.52332 .44405 m .54653 .44471 L p .51911 .47184 L F P
0 g
s
.63 .529 .721 r
.42525 .57782 m .43028 .59398 L .40582 .60487 L p F P
0 g
s
.665 .594 .766 r
.47902 .64702 m .48198 .6542 L .45734 .66661 L p F P
0 g
s
.665 .594 .766 r
.45734 .66661 m .45099 .65126 L .47902 .64702 L p F P
0 g
s
.713 .523 .631 r
.51911 .47184 m .51609 .45603 L .52332 .44405 L p F P
0 g
s
.703 .511 .625 r
.51609 .45603 m .52332 .44405 L .51397 .44403 L closepath p F P
0 g
s
.687 .499 .628 r
.51397 .44403 m .51609 .45603 L .50492 .47213 L p F P
0 g
s
.767 .587 .655 r
.59258 .49912 m .60399 .47874 L p .6267 .51306 L F P
0 g
s
.755 .572 .649 r
.59258 .49912 m .60399 .47874 L .58688 .47618 L closepath p F P
0 g
s
.857 .562 .487 r
.78464 .65982 m .77413 .65528 L .77228 .62676 L p F P
0 g
s
.835 .543 .496 r
.75673 .62106 m .77228 .62676 L .77413 .65528 L p F P
0 g
s
0 0 .048 r
.50002 .88469 m .50074 .87484 L .50089 .84471 L p F P
0 g
s
0 0 .221 r
.50601 .82911 m .50089 .84471 L .50074 .87484 L p F P
0 g
s
0 0 .221 r
.50089 .84471 m .50601 .82911 L .50612 .79928 L p F P
0 g
s
.765 .6 .674 r
.59471 .50706 m .6267 .51306 L .6084 .54143 L p F P
0 g
s
.767 .587 .655 r
.6267 .51306 m .59471 .50706 L .59258 .49912 L p F P
0 g
s
.943 .669 .206 r
.83838 .78594 m .84524 .80073 L .84762 .83055 L p F P
0 g
s
.943 .669 .206 r
.84524 .80073 m .83838 .78594 L .83606 .75644 L p F P
0 g
s
.976 .672 .347 r
.83606 .75644 m .82478 .74256 L .82256 .71338 L p F P
0 g
s
.945 .637 .424 r
.80685 .70049 m .82256 .71338 L .82478 .74256 L p F P
0 g
s
.976 .672 .347 r
.82478 .74256 m .83606 .75644 L .83838 .78594 L p F P
0 g
s
.195 .049 .444 r
.51967 .75098 m .52931 .74187 L .52925 .7127 L p F P
0 g
s
.265 .102 .464 r
.53701 .70641 m .52925 .7127 L .52931 .74187 L p F P
0 g
s
.736 .464 .517 r
.72333 .61295 m .6943 .6098 L .69303 .58158 L p F P
0 g
s
.7 .435 .521 r
.67427 .58108 m .69303 .58158 L .6943 .6098 L p F P
0 g
s
.664 .583 .754 r
.46844 .61973 m .47902 .64702 L .45099 .65126 L p F P
0 g
s
.664 .583 .754 r
.45099 .65126 m .44378 .63276 L .46844 .61973 L p F P
0 g
s
.678 .419 .522 r
.6608 .58135 m .67427 .58108 L .6754 .6093 L p F P
0 g
s
.678 .419 .522 r
.6754 .6093 m .66183 .60956 L .6608 .58135 L p F P
0 g
s
.637 .387 .522 r
.6608 .58135 m .66183 .60956 L .63222 .61267 L p F P
0 g
s
.62622 .59293 m
.63282 .58774 L
s
.7 .435 .521 r
.6943 .6098 m .6754 .6093 L .67427 .58108 L p F P
0 g
s
0 0 .323 r
.50813 .79554 m .50612 .79928 L .50601 .82911 L p F P
0 g
s
.74 .563 .654 r
.58688 .47618 m .59258 .49912 L .5882 .50613 L p F P
0 g
s
.74 .563 .654 r
.56053 .47338 m .58688 .47618 L p .5882 .50613 L F P
0 g
s
.57085 .64545 m
.5728 .64316 L
s
.56506 .65222 m
.57085 .64545 L
s
.55714 .66148 m
.55735 .66125 L
s
.55735 .66125 m
.56506 .65222 L
s
.55004 .66979 m
.55554 .66336 L
s
.55554 .66336 m
.55714 .66148 L
s
.60416 .61237 m
.60484 .61177 L
s
.62028 .59817 m
.62622 .59293 L
s
.59848 .61737 m
.601 .61516 L
s
.601 .61516 m
.60416 .61237 L
s
.672 .505 .651 r
.4583 .4757 m .48792 .47289 L p .47724 .50352 L F P
0 g
s
.672 .505 .651 r
.47724 .50352 m .46425 .50474 L .4583 .4757 L p F P
0 g
s
.653 .493 .654 r
.4583 .4757 m .46425 .50474 L .4359 .50893 L p F P
0 g
s
.696 .512 .635 r
.51911 .47184 m .51609 .45603 L .50492 .47213 L closepath p F P
0 g
s
.708 .628 .766 r
.54169 .64535 m .54504 .65299 L .52022 .66999 L p F P
0 g
s
.708 .628 .766 r
.52022 .66999 m .50917 .64491 L .54169 .64535 L p F P
0 g
s
.69 .62 .772 r
.50917 .64491 m .52022 .66999 L p .48198 .6542 L F P
0 g
s
.641 .514 .693 r
.41694 .54841 m .42616 .54292 L .41604 .54499 L closepath p F P
0 g
s
.647 .526 .703 r
.42525 .57782 m .41694 .54841 L .42616 .54292 L p F P
0 g
s
.658 .568 .742 r
.46431 .60826 m .46844 .61973 L .44378 .63276 L p F P
0 g
s
.658 .568 .742 r
.44378 .63276 m .43664 .61301 L .46431 .60826 L p F P
0 g
s
.771 .638 .714 r
.61942 .58181 m .62173 .57894 L .618 .57809 L closepath p F P
0 g
s
.774 .628 .699 r
.6061 .54459 m .6084 .54143 L p .62173 .57894 L F P
0 g
s
.774 .628 .699 r
.62173 .57894 m .618 .57809 L .6061 .54459 L p F P
0 g
s
.656 .51 .673 r
.44157 .5331 m .4359 .50893 L .46425 .50474 L p F P
0 g
s
.637 .497 .676 r
.4359 .50893 m .44157 .5331 L .42616 .54292 L p F P
0 g
s
.78 .625 .063 r
.50039 .92208 m .49987 .91517 L .50002 .88469 L p F P
0 g
s
0 0 .048 r
.50074 .87484 m .50002 .88469 L .49987 .91517 L p F P
0 g
s
.758 .631 .721 r
.61942 .58181 m .59472 .60962 L .58138 .5749 L p F P
0 g
s
.60484 .61177 m
.62028 .59817 L
s
.758 .631 .721 r
.618 .57809 m .61942 .58181 L p .58138 .5749 L F P
0 g
s
.74 .563 .654 r
.55436 .48317 m .56053 .47338 L p .5882 .50613 L F P
0 g
s
.73 .549 .647 r
.55436 .48317 m .56053 .47338 L .55198 .47276 L closepath p F P
0 g
s
.683 .603 .76 r
.48198 .6542 m .49642 .6456 L .47902 .64702 L closepath p F P
0 g
s
.69 .62 .772 r
.48198 .6542 m .49642 .6456 L .50917 .64491 L p F P
0 g
s
.758 .631 .721 r
.58138 .5749 m .58404 .57191 L .618 .57809 L p F P
0 g
s
.76 .621 .706 r
.618 .57809 m .6061 .54459 L .58404 .57191 L closepath p F P
0 g
s
.656 .555 .729 r
.45494 .58022 m .46431 .60826 L .43664 .61301 L p F P
0 g
s
.656 .555 .729 r
.43664 .61301 m .43028 .59398 L .45494 .58022 L p F P
0 g
s
.647 .526 .703 r
.42616 .54292 m .44323 .53965 L p .42525 .57782 L F P
0 g
s
.643 .51 .686 r
.44323 .53965 m .44157 .5331 L .42616 .54292 L closepath p F P
0 g
s
.752 .579 .661 r
.59471 .50706 m .59258 .49912 L .5882 .50613 L closepath p F P
0 g
s
.689 .516 .648 r
.49123 .48886 m .50492 .47213 L .48792 .47289 L closepath p F P
0 g
s
.672 .505 .651 r
.48792 .47289 m .49123 .48886 L .47724 .50352 L p F P
0 g
s
.65 .541 .718 r
.43028 .59398 m .42525 .57782 L .45258 .57266 L p F P
0 g
s
.647 .526 .703 r
.44323 .53965 m .45258 .57266 L .42525 .57782 L p F P
0 g
s
.715 .54 .651 r
.55198 .47276 m .55436 .48317 L .54095 .50205 L p F P
0 g
s
.715 .54 .651 r
.51911 .47184 m .55198 .47276 L p .54095 .50205 L F P
0 g
s
.65 .541 .718 r
.45258 .57266 m .45494 .58022 L .43028 .59398 L p F P
0 g
s
.457 .247 .505 r
.55759 .69393 m .55733 .66504 L .58019 .65475 L p F P
0 g
s
.369 .181 .489 r
.55733 .66504 m .55759 .69393 L .53701 .70641 L p F P
0 g
s
.835 .543 .496 r
.77413 .65528 m .75847 .64963 L .75673 .62106 L p F P
0 g
s
.797 .512 .507 r
.73011 .61418 m .75673 .62106 L .75847 .64963 L p F P
0 g
s
.5728 .64316 m
.57718 .63877 L
s
.57718 .63877 m
.5796 .63634 L
s
.59452 .62136 m
.59848 .61737 L
s
.58089 .63504 m
.59452 .62136 L
s
0 0 .198 r
.85249 .8763 m .85167 .88334 L .85411 .91384 L p F P
0 g
s
0 0 .286 r
.8515 .9235 m .85411 .91384 L .85167 .88334 L p F P
0 g
s
.698 .529 .655 r
.50492 .47213 m .51911 .47184 L p .49423 .50228 L F P
0 g
s
.698 .529 .655 r
.49423 .50228 m .49123 .48886 L .50492 .47213 L p F P
0 g
s
.765 .6 .674 r
.6084 .54143 m .60484 .54077 L .59471 .50706 L p F P
0 g
s
.751 .593 .68 r
.59471 .50706 m .60484 .54077 L .56835 .53564 L p F P
0 g
s
.751 .593 .68 r
.5882 .50613 m .59471 .50706 L p .56835 .53564 L F P
0 g
s
.683 .593 .748 r
.49642 .6456 m .47902 .64702 L .46844 .61973 L p F P
0 g
s
.724 .635 .759 r
.54504 .65299 m .55374 .64623 L .54169 .64535 L closepath p F P
0 g
s
0 0 .323 r
.50601 .82911 m .50804 .8254 L .50813 .79554 L p F P
0 g
s
.036 0 .392 r
.51966 .78052 m .50813 .79554 L .50804 .8254 L p F P
0 g
s
.036 0 .392 r
.50813 .79554 m .51966 .78052 L .51967 .75098 L p F P
0 g
s
.715 .54 .651 r
.54095 .50205 m .52584 .50163 L .51911 .47184 L p F P
0 g
s
.698 .529 .655 r
.51911 .47184 m .52584 .50163 L .49423 .50228 L p F P
0 g
s
.763 .611 .691 r
.6061 .54459 m .6084 .54143 L .60484 .54077 L closepath p F P
0 g
s
.726 .627 .747 r
.55892 .60616 m .56989 .63284 L .55374 .64623 L p F P
0 g
s
.726 .627 .747 r
.5503 .60552 m .55892 .60616 L p .55374 .64623 L F P
0 g
s
.726 .627 .747 r
.53162 .62102 m .5503 .60552 L p .55374 .64623 L F P
0 g
s
.726 .627 .747 r
.55374 .64623 m .54169 .64535 L .53162 .62102 L p F P
0 g
s
.751 .593 .68 r
.56835 .53564 m .56792 .53424 L .5882 .50613 L p F P
0 g
s
.74 .577 .672 r
.56792 .53424 m .5882 .50613 L .55927 .5031 L closepath p F P
0 g
s
.74 .563 .654 r
.5882 .50613 m .55927 .5031 L .55436 .48317 L p F P
0 g
s
.725 .554 .659 r
.55927 .5031 m .55436 .48317 L .54095 .50205 L closepath p F P
0 g
s
.754 .643 .738 r
.59527 .61095 m .59472 .60962 L .59369 .61066 L closepath p F P
0 g
s
.195 .049 .444 r
.52931 .74187 m .51967 .75098 L .51966 .78052 L p F P
0 g
s
.749 .604 .697 r
.60484 .54077 m .6061 .54459 L .58404 .57191 L p F P
0 g
s
.749 .604 .697 r
.56835 .53564 m .60484 .54077 L p .58404 .57191 L F P
0 g
s
.743 .624 .727 r
.58138 .5749 m .59472 .60962 L .59369 .61066 L p F P
0 g
s
.741 .634 .741 r
.56989 .63284 m .59369 .61066 L .55892 .60616 L closepath p F P
0 g
s
.743 .624 .727 r
.55652 .59996 m .58138 .5749 L p .59369 .61066 L F P
0 g
s
.743 .624 .727 r
.59369 .61066 m .55892 .60616 L .55652 .59996 L p F P
0 g
s
.691 .61 .761 r
.50917 .64491 m .50676 .63913 L .49642 .6456 L closepath p F P
0 g
s
.683 .593 .748 r
.49367 .60521 m .50676 .63913 L .49642 .6456 L p F P
0 g
s
.683 .593 .748 r
.49117 .60542 m .49367 .60521 L p .49642 .6456 L F P
0 g
s
.683 .593 .748 r
.46844 .61973 m .49117 .60542 L p .49642 .6456 L F P
0 g
s
.664 .523 .682 r
.44323 .53965 m .44157 .5331 L .46636 .51365 L p F P
0 g
s
.656 .51 .673 r
.46425 .50474 m .46636 .51365 L .44157 .5331 L p F P
0 g
s
.709 .619 .754 r
.53162 .62102 m .54169 .64535 L .50917 .64491 L p F P
0 g
s
.369 .181 .489 r
.53713 .73563 m .53701 .70641 L .55759 .69393 L p F P
0 g
s
.265 .102 .464 r
.52931 .74187 m .53713 .73563 L .53701 .70641 L p F P
0 g
s
0 0 .394 r
.84592 .96898 m .85394 .95436 L .8515 .9235 L p F P
0 g
s
.709 .619 .754 r
.50917 .64491 m .50676 .63913 L .53162 .62102 L p F P
0 g
s
.674 .521 .669 r
.46636 .51365 m .47724 .50352 L .46425 .50474 L closepath p F P
0 g
s
.68 .518 .659 r
.49423 .50228 m .49123 .48886 L .47724 .50352 L closepath p F P
0 g
s
.666 .538 .699 r
.44323 .53965 m .47203 .53593 L p .4694 .57053 L F P
0 g
s
.666 .538 .699 r
.4694 .57053 m .45258 .57266 L .44323 .53965 L p F P
0 g
s
.664 .523 .682 r
.46636 .51365 m .47203 .53593 L .44323 .53965 L p F P
0 g
s
.588 .348 .521 r
.60545 .64682 m .60483 .61823 L .63222 .61267 L p F P
0 g
s
.529 .302 .515 r
.60483 .61823 m .60545 .64682 L .58019 .65475 L p F P
0 g
s
.676 .578 .737 r
.46844 .61973 m .49117 .60542 L .46431 .60826 L closepath p F P
0 g
s
.701 .602 .742 r
.52531 .60459 m .53162 .62102 L .50676 .63913 L p F P
0 g
s
.701 .602 .742 r
.50676 .63913 m .49367 .60521 L .52531 .60459 L p F P
0 g
s
.682 .534 .678 r
.47724 .50352 m .49423 .50228 L p .47203 .53593 L F P
0 g
s
.682 .534 .678 r
.47203 .53593 m .46636 .51365 L .47724 .50352 L p F P
0 g
s
.942 .715 .244 r
.50559 .96766 m .50024 .95296 L .50039 .92208 L p F P
0 g
s
.725 .568 .677 r
.55927 .5031 m .56792 .53424 L .56689 .53551 L p F P
0 g
s
.725 .568 .677 r
.54095 .50205 m .55927 .5031 L p .56689 .53551 L F P
0 g
s
.675 .566 .724 r
.49117 .60542 m .46431 .60826 L .45494 .58022 L p F P
0 g
s
0 0 .286 r
.85411 .91384 m .8515 .9235 L .85394 .95436 L p F P
0 g
s
.668 .552 .713 r
.45494 .58022 m .4694 .57053 L .45258 .57266 L closepath p F P
0 g
s
.675 .566 .724 r
.45494 .58022 m .4694 .57053 L p .49117 .60542 L F P
0 g
s
.7 .545 .674 r
.49423 .50228 m .52584 .50163 L p .51337 .53352 L F P
0 g
s
.7 .545 .674 r
.51337 .53352 m .50229 .53375 L .49423 .50228 L p F P
0 g
s
.682 .534 .678 r
.49423 .50228 m .50229 .53375 L .47203 .53593 L p F P
0 g
s
.725 .568 .677 r
.52956 .51604 m .54095 .50205 L p .56689 .53551 L F P
0 g
s
.715 .554 .669 r
.52956 .51604 m .54095 .50205 L .52584 .50163 L closepath p F P
0 g
s
.9 .597 .465 r
.80685 .70049 m .78659 .68874 L .78464 .65982 L p F P
0 g
s
.857 .562 .487 r
.77413 .65528 m .78464 .65982 L .78659 .68874 L p F P
0 g
s
.747 .615 .712 r
.58138 .5749 m .58404 .57191 L .58013 .57137 L closepath p F P
0 g
s
.749 .604 .697 r
.58404 .57191 m .58013 .57137 L .56835 .53564 L p F P
0 g
s
.7 .545 .674 r
.52584 .50163 m .52956 .51604 L .51337 .53352 L p F P
0 g
s
.733 .608 .718 r
.58013 .57137 m .58138 .5749 L .55652 .59996 L p F P
0 g
s
.733 .608 .718 r
.55652 .59996 m .54517 .56821 L .58013 .57137 L p F P
0 g
s
.735 .597 .703 r
.56835 .53564 m .58013 .57137 L .54517 .56821 L p F P
0 g
s
.717 .61 .737 r
.53162 .62102 m .5503 .60552 L .52531 .60459 L closepath p F P
0 g
s
.78 .625 .063 r
.49987 .91517 m .50039 .92208 L .50024 .95296 L p F P
0 g
s
.727 .617 .734 r
.55892 .60616 m .55652 .59996 L .5503 .60552 L closepath p F P
0 g
s
.684 .549 .694 r
.47975 .56309 m .47203 .53593 L .50229 .53375 L p F P
0 g
s
.666 .538 .699 r
.47203 .53593 m .47975 .56309 L .4694 .57053 L p F P
0 g
s
.736 .584 .686 r
.56835 .53564 m .56792 .53424 L .56689 .53551 L closepath p F P
0 g
s
.735 .597 .703 r
.56689 .53551 m .56835 .53564 L p .54517 .56821 L F P
0 g
s
.735 .597 .703 r
.54517 .56821 m .54306 .56182 L .56689 .53551 L p F P
0 g
s
.725 .581 .694 r
.54306 .56182 m .56689 .53551 L .53443 .53366 L closepath p F P
0 g
s
.725 .568 .677 r
.56689 .53551 m .53443 .53366 L .52956 .51604 L p F P
0 g
s
.674 .552 .709 r
.48162 .56921 m .47975 .56309 L .4694 .57053 L closepath p F P
0 g
s
.675 .566 .724 r
.4694 .57053 m .48162 .56921 L p .49117 .60542 L F P
0 g
s
.718 .6 .723 r
.54517 .56821 m .55652 .59996 L .5503 .60552 L p F P
0 g
s
.718 .6 .723 r
.53683 .56789 m .54517 .56821 L p .5503 .60552 L F P
0 g
s
.718 .6 .723 r
.51814 .5846 m .53683 .56789 L p .5503 .60552 L F P
0 g
s
.718 .6 .723 r
.5503 .60552 m .52531 .60459 L .51814 .5846 L p F P
0 g
s
.683 .581 .735 r
.49367 .60521 m .49325 .60403 L .49117 .60542 L closepath p F P
0 g
s
.675 .566 .724 r
.48162 .56921 m .49325 .60403 L .49117 .60542 L p F P
0 g
s
.797 .512 .507 r
.75847 .64963 m .73165 .64279 L .73011 .61418 L p F P
0 g
s
.766 .488 .513 r
.72333 .61295 m .73011 .61418 L .73165 .64279 L p F P
0 g
s
.709 .559 .682 r
.53443 .53366 m .52956 .51604 L .51337 .53352 L closepath p F P
0 g
s
.701 .591 .729 r
.51814 .5846 m .52531 .60459 L .49367 .60521 L p F P
0 g
s
.701 .591 .729 r
.49367 .60521 m .49325 .60403 L .51814 .5846 L p F P
0 g
s
.693 .575 .719 r
.51252 .56773 m .51814 .5846 L .49325 .60403 L p F P
0 g
s
.693 .575 .719 r
.49325 .60403 m .48162 .56921 L .51252 .56773 L p F P
0 g
s
.692 .563 .704 r
.48162 .56921 m .47975 .56309 L .50464 .54202 L p F P
0 g
s
.684 .549 .694 r
.50229 .53375 m .50464 .54202 L .47975 .56309 L p F P
0 g
s
.692 .563 .704 r
.50464 .54202 m .51252 .56773 L .48162 .56921 L p F P
0 g
s
.766 .488 .513 r
.73165 .64279 m .72483 .64157 L .72333 .61295 L p F P
0 g
s
.736 .464 .517 r
.6943 .6098 m .72333 .61295 L .72483 .64157 L p F P
0 g
s
0 0 .198 r
.85411 .91384 m .85495 .90687 L .85249 .8763 L p F P
0 g
s
.774 .572 .001 r
.85005 .8608 m .85249 .8763 L .85495 .90687 L p F P
0 g
s
.774 .572 .001 r
.85249 .8763 m .85005 .8608 L .84762 .83055 L p F P
0 g
s
.7 .558 .69 r
.50464 .54202 m .51337 .53352 L .50229 .53375 L closepath p F P
0 g
s
.709 .572 .699 r
.53443 .53366 m .54306 .56182 L .53683 .56789 L p F P
0 g
s
.709 .572 .699 r
.51337 .53352 m .53443 .53366 L p .53683 .56789 L F P
0 g
s
.945 .637 .424 r
.82478 .74256 m .80897 .72976 L .80685 .70049 L p F P
0 g
s
.9 .597 .465 r
.78659 .68874 m .80685 .70049 L .80897 .72976 L p F P
0 g
s
.637 .387 .522 r
.63304 .64128 m .63222 .61267 L .66183 .60956 L p F P
0 g
s
.588 .348 .521 r
.63222 .61267 m .63304 .64128 L .60545 .64682 L p F P
0 g
s
.709 .572 .699 r
.50464 .54202 m .51337 .53352 L p .53683 .56789 L F P
0 g
s
.709 .572 .699 r
.53683 .56789 m .51252 .56773 L .50464 .54202 L p F P
0 g
s
.719 .588 .709 r
.54517 .56821 m .54306 .56182 L .53683 .56789 L closepath p F P
0 g
s
.709 .584 .714 r
.51814 .5846 m .53683 .56789 L .51252 .56773 L closepath p F P
0 g
s
.857 .562 .487 r
.78659 .68874 m .77601 .68423 L .77413 .65528 L p F P
0 g
s
.835 .543 .496 r
.75847 .64963 m .77413 .65528 L .77601 .68423 L p F P
0 g
s
0 0 .048 r
.49987 .91517 m .50059 .90542 L .50074 .87484 L p F P
0 g
s
0 0 .221 r
.5059 .85938 m .50074 .87484 L .50059 .90542 L p F P
0 g
s
0 0 .221 r
.50074 .87484 m .5059 .85938 L .50601 .82911 L p F P
0 g
s
.943 .669 .206 r
.84074 .81587 m .84762 .83055 L .85005 .8608 L p F P
0 g
s
.943 .669 .206 r
.84762 .83055 m .84074 .81587 L .83838 .78594 L p F P
0 g
s
.529 .302 .515 r
.58063 .68371 m .58019 .65475 L .60545 .64682 L p F P
0 g
s
.457 .247 .505 r
.58019 .65475 m .58063 .68371 L .55759 .69393 L p F P
0 g
s
.976 .672 .347 r
.83838 .78594 m .82703 .77216 L .82478 .74256 L p F P
0 g
s
.945 .637 .424 r
.80897 .72976 m .82478 .74256 L .82703 .77216 L p F P
0 g
s
.976 .672 .347 r
.82703 .77216 m .83838 .78594 L .84074 .81587 L p F P
0 g
s
.195 .049 .444 r
.51966 .78052 m .52937 .77148 L .52931 .74187 L p F P
0 g
s
.265 .102 .464 r
.53713 .73563 m .52931 .74187 L .52937 .77148 L p F P
0 g
s
.736 .464 .517 r
.72483 .64157 m .69558 .63843 L .6943 .6098 L p F P
0 g
s
.7 .435 .521 r
.6754 .6093 m .6943 .6098 L .69558 .63843 L p F P
0 g
s
.678 .419 .522 r
.66183 .60956 m .6754 .6093 L .67654 .63793 L p F P
0 g
s
.678 .419 .522 r
.67654 .63793 m .66288 .6382 L .66183 .60956 L p F P
0 g
s
.637 .387 .522 r
.66183 .60956 m .66288 .6382 L .63304 .64128 L p F P
0 g
s
.7 .435 .521 r
.69558 .63843 m .67654 .63793 L .6754 .6093 L p F P
0 g
s
0 0 .323 r
.50804 .8254 m .50601 .82911 L .5059 .85938 L p F P
0 g
s
.78 .625 .063 r
.50024 .95296 m .49971 .94611 L .49987 .91517 L p F P
0 g
s
0 0 .048 r
.50059 .90542 m .49987 .91517 L .49971 .94611 L p F P
0 g
s
.457 .247 .505 r
.55787 .72324 m .55759 .69393 L .58063 .68371 L p F P
0 g
s
.369 .181 .489 r
.55759 .69393 m .55787 .72324 L .53713 .73563 L p F P
0 g
s
.835 .543 .496 r
.77601 .68423 m .76024 .67861 L .75847 .64963 L p F P
0 g
s
.797 .512 .507 r
.73165 .64279 m .75847 .64963 L .76024 .67861 L p F P
0 g
s
0 0 .198 r
.85495 .90687 m .85411 .91384 L .85659 .94479 L p F P
0 g
s
0 0 .286 r
.85394 .95436 m .85659 .94479 L .85411 .91384 L p F P
0 g
s
0 0 .323 r
.5059 .85938 m .50794 .8557 L .50804 .8254 L p F P
0 g
s
.036 0 .392 r
.51965 .8105 m .50804 .8254 L .50794 .8557 L p F P
0 g
s
.036 0 .392 r
.50804 .8254 m .51965 .8105 L .51966 .78052 L p F P
0 g
s
.195 .049 .444 r
.52937 .77148 m .51966 .78052 L .51965 .8105 L p F P
0 g
s
.369 .181 .489 r
.53725 .76529 m .53713 .73563 L .55787 .72324 L p F P
0 g
s
.265 .102 .464 r
.52937 .77148 m .53725 .76529 L .53713 .73563 L p F P
0 g
s
.588 .348 .521 r
.60608 .67582 m .60545 .64682 L .63304 .64128 L p F P
0 g
s
.529 .302 .515 r
.60545 .64682 m .60608 .67582 L .58063 .68371 L p F P
0 g
s
.9 .597 .465 r
.80897 .72976 m .78857 .71809 L .78659 .68874 L p F P
0 g
s
.857 .562 .487 r
.77601 .68423 m .78659 .68874 L .78857 .71809 L p F P
0 g
s
.797 .512 .507 r
.76024 .67861 m .73323 .67182 L .73165 .64279 L p F P
0 g
s
.766 .488 .513 r
.72483 .64157 m .73165 .64279 L .73323 .67182 L p F P
0 g
s
.766 .488 .513 r
.73323 .67182 m .72635 .67061 L .72483 .64157 L p F P
0 g
s
.736 .464 .517 r
.69558 .63843 m .72483 .64157 L .72635 .67061 L p F P
0 g
s
0 0 .198 r
.85659 .94479 m .85744 .93789 L .85495 .90687 L p F P
0 g
s
.774 .572 .001 r
.85251 .89151 m .85495 .90687 L .85744 .93789 L p F P
0 g
s
.774 .572 .001 r
.85495 .90687 m .85251 .89151 L .85005 .8608 L p F P
0 g
s
.945 .637 .424 r
.82703 .77216 m .81112 .75946 L .80897 .72976 L p F P
0 g
s
.9 .597 .465 r
.78857 .71809 m .80897 .72976 L .81112 .75946 L p F P
0 g
s
.637 .387 .522 r
.63388 .67033 m .63304 .64128 L .66288 .6382 L p F P
0 g
s
.588 .348 .521 r
.63304 .64128 m .63388 .67033 L .60608 .67582 L p F P
0 g
s
.857 .562 .487 r
.78857 .71809 m .77791 .71362 L .77601 .68423 L p F P
0 g
s
.835 .543 .496 r
.76024 .67861 m .77601 .68423 L .77791 .71362 L p F P
0 g
s
0 0 .048 r
.49971 .94611 m .50044 .93646 L .50059 .90542 L p F P
0 g
s
0 0 .221 r
.50579 .8901 m .50059 .90542 L .50044 .93646 L p F P
0 g
s
0 0 .221 r
.50059 .90542 m .50579 .8901 L .5059 .85938 L p F P
0 g
s
.943 .669 .206 r
.84313 .84626 m .85005 .8608 L .85251 .89151 L p F P
0 g
s
.943 .669 .206 r
.85005 .8608 m .84313 .84626 L .84074 .81587 L p F P
0 g
s
.529 .302 .515 r
.58108 .71309 m .58063 .68371 L .60608 .67582 L p F P
0 g
s
.457 .247 .505 r
.58063 .68371 m .58108 .71309 L .55787 .72324 L p F P
0 g
s
.976 .672 .347 r
.84074 .81587 m .82932 .80221 L .82703 .77216 L p F P
0 g
s
.945 .637 .424 r
.81112 .75946 m .82703 .77216 L .82932 .80221 L p F P
0 g
s
.976 .672 .347 r
.82932 .80221 m .84074 .81587 L .84313 .84626 L p F P
0 g
s
.195 .049 .444 r
.51965 .8105 m .52944 .80154 L .52937 .77148 L p F P
0 g
s
.265 .102 .464 r
.53725 .76529 m .52937 .77148 L .52944 .80154 L p F P
0 g
s
.736 .464 .517 r
.72635 .67061 m .69689 .66749 L .69558 .63843 L p F P
0 g
s
.7 .435 .521 r
.67654 .63793 m .69558 .63843 L .69689 .66749 L p F P
0 g
s
.678 .419 .522 r
.66288 .6382 m .67654 .63793 L .6777 .667 L p F P
0 g
s
.678 .419 .522 r
.6777 .667 m .66394 .66726 L .66288 .6382 L p F P
0 g
s
.637 .387 .522 r
.66288 .6382 m .66394 .66726 L .63388 .67033 L p F P
0 g
s
.7 .435 .521 r
.69689 .66749 m .6777 .667 L .67654 .63793 L p F P
0 g
s
0 0 .323 r
.50794 .8557 m .5059 .85938 L .50579 .8901 L p F P
0 g
s
.457 .247 .505 r
.55814 .75299 m .55787 .72324 L .58108 .71309 L p F P
0 g
s
.369 .181 .489 r
.55787 .72324 m .55814 .75299 L .53725 .76529 L p F P
0 g
s
.835 .543 .496 r
.77791 .71362 m .76203 .70804 L .76024 .67861 L p F P
0 g
s
.797 .512 .507 r
.73323 .67182 m .76024 .67861 L .76203 .70804 L p F P
0 g
s
0 0 .323 r
.50579 .8901 m .50785 .88645 L .50794 .8557 L p F P
0 g
s
.036 0 .392 r
.51964 .84093 m .50794 .8557 L .50785 .88645 L p F P
0 g
s
.036 0 .392 r
.50794 .8557 m .51964 .84093 L .51965 .8105 L p F P
0 g
s
.195 .049 .444 r
.52944 .80154 m .51965 .8105 L .51964 .84093 L p F P
0 g
s
.369 .181 .489 r
.53737 .79539 m .53725 .76529 L .55814 .75299 L p F P
0 g
s
.265 .102 .464 r
.52944 .80154 m .53737 .79539 L .53725 .76529 L p F P
0 g
s
.588 .348 .521 r
.60672 .70526 m .60608 .67582 L .63388 .67033 L p F P
0 g
s
.529 .302 .515 r
.60608 .67582 m .60672 .70526 L .58108 .71309 L p F P
0 g
s
.9 .597 .465 r
.81112 .75946 m .79058 .74788 L .78857 .71809 L p F P
0 g
s
.857 .562 .487 r
.77791 .71362 m .78857 .71809 L .79058 .74788 L p F P
0 g
s
.797 .512 .507 r
.76203 .70804 m .73482 .70129 L .73323 .67182 L p F P
0 g
s
.766 .488 .513 r
.72635 .67061 m .73323 .67182 L .73482 .70129 L p F P
0 g
s
.766 .488 .513 r
.73482 .70129 m .72789 .70009 L .72635 .67061 L p F P
0 g
s
.736 .464 .517 r
.69689 .66749 m .72635 .67061 L .72789 .70009 L p F P
0 g
s
.774 .572 .001 r
.85744 .93789 m .855 .92268 L .85251 .89151 L p F P
0 g
s
.945 .637 .424 r
.82932 .80221 m .8133 .78961 L .81112 .75946 L p F P
0 g
s
.9 .597 .465 r
.79058 .74788 m .81112 .75946 L .8133 .78961 L p F P
0 g
s
.637 .387 .522 r
.63472 .69981 m .63388 .67033 L .66394 .66726 L p F P
0 g
s
.588 .348 .521 r
.63388 .67033 m .63472 .69981 L .60672 .70526 L p F P
0 g
s
.857 .562 .487 r
.79058 .74788 m .77984 .74344 L .77791 .71362 L p F P
0 g
s
.835 .543 .496 r
.76203 .70804 m .77791 .71362 L .77984 .74344 L p F P
0 g
s
0 0 .221 r
.50044 .93646 m .50567 .92129 L .50579 .8901 L p F P
0 g
s
.943 .669 .206 r
.84555 .8771 m .85251 .89151 L .855 .92268 L p F P
0 g
s
.943 .669 .206 r
.85251 .89151 m .84555 .8771 L .84313 .84626 L p F P
0 g
s
.529 .302 .515 r
.58153 .74292 m .58108 .71309 L .60672 .70526 L p F P
0 g
s
.457 .247 .505 r
.58108 .71309 m .58153 .74292 L .55814 .75299 L p F P
0 g
s
.976 .672 .347 r
.84313 .84626 m .83164 .83271 L .82932 .80221 L p F P
0 g
s
.945 .637 .424 r
.8133 .78961 m .82932 .80221 L .83164 .83271 L p F P
0 g
s
.976 .672 .347 r
.83164 .83271 m .84313 .84626 L .84555 .8771 L p F P
0 g
s
.195 .049 .444 r
.51964 .84093 m .5295 .83204 L .52944 .80154 L p F P
0 g
s
.265 .102 .464 r
.53737 .79539 m .52944 .80154 L .5295 .83204 L p F P
0 g
s
.736 .464 .517 r
.72789 .70009 m .69821 .69699 L .69689 .66749 L p F P
0 g
s
.7 .435 .521 r
.6777 .667 m .69689 .66749 L .69821 .69699 L p F P
0 g
s
.678 .419 .522 r
.66394 .66726 m .6777 .667 L .67889 .6965 L p F P
0 g
s
.678 .419 .522 r
.67889 .6965 m .66502 .69676 L .66394 .66726 L p F P
0 g
s
.637 .387 .522 r
.66394 .66726 m .66502 .69676 L .63472 .69981 L p F P
0 g
s
.7 .435 .521 r
.69821 .69699 m .67889 .6965 L .6777 .667 L p F P
0 g
s
0 0 .323 r
.50785 .88645 m .50579 .8901 L .50567 .92129 L p F P
0 g
s
.457 .247 .505 r
.55842 .78319 m .55814 .75299 L .58153 .74292 L p F P
0 g
s
.369 .181 .489 r
.55814 .75299 m .55842 .78319 L .53737 .79539 L p F P
0 g
s
.835 .543 .496 r
.77984 .74344 m .76385 .7379 L .76203 .70804 L p F P
0 g
s
.797 .512 .507 r
.73482 .70129 m .76203 .70804 L .76385 .7379 L p F P
0 g
s
0 0 .323 r
.50567 .92129 m .50775 .91767 L .50785 .88645 L p F P
0 g
s
.036 0 .392 r
.51963 .87182 m .50785 .88645 L .50775 .91767 L p F P
0 g
s
.036 0 .392 r
.50785 .88645 m .51963 .87182 L .51964 .84093 L p F P
0 g
s
.195 .049 .444 r
.5295 .83204 m .51964 .84093 L .51963 .87182 L p F P
0 g
s
.369 .181 .489 r
.5375 .82595 m .53737 .79539 L .55842 .78319 L p F P
0 g
s
.265 .102 .464 r
.5295 .83204 m .5375 .82595 L .53737 .79539 L p F P
0 g
s
.588 .348 .521 r
.60737 .73515 m .60672 .70526 L .63472 .69981 L p F P
0 g
s
.529 .302 .515 r
.60672 .70526 m .60737 .73515 L .58153 .74292 L p F P
0 g
s
.9 .597 .465 r
.8133 .78961 m .79262 .77812 L .79058 .74788 L p F P
0 g
s
.857 .562 .487 r
.77984 .74344 m .79058 .74788 L .79262 .77812 L p F P
0 g
s
.797 .512 .507 r
.76385 .7379 m .73644 .7312 L .73482 .70129 L p F P
0 g
s
.766 .488 .513 r
.72789 .70009 m .73482 .70129 L .73644 .7312 L p F P
0 g
s
.766 .488 .513 r
.73644 .7312 m .72946 .73001 L .72789 .70009 L p F P
0 g
s
.736 .464 .517 r
.69821 .69699 m .72789 .70009 L .72946 .73001 L p F P
0 g
s
.945 .637 .424 r
.83164 .83271 m .81552 .82022 L .8133 .78961 L p F P
0 g
s
.9 .597 .465 r
.79262 .77812 m .8133 .78961 L .81552 .82022 L p F P
0 g
s
.637 .387 .522 r
.63559 .72973 m .63472 .69981 L .66502 .69676 L p F P
0 g
s
.588 .348 .521 r
.63472 .69981 m .63559 .72973 L .60737 .73515 L p F P
0 g
s
.857 .562 .487 r
.79262 .77812 m .78181 .77372 L .77984 .74344 L p F P
0 g
s
.835 .543 .496 r
.76385 .7379 m .77984 .74344 L .78181 .77372 L p F P
0 g
s
.943 .669 .206 r
.855 .92268 m .84802 .90841 L .84555 .8771 L p F P
0 g
s
.529 .302 .515 r
.58199 .7732 m .58153 .74292 L .60737 .73515 L p F P
0 g
s
.457 .247 .505 r
.58153 .74292 m .58199 .7732 L .55842 .78319 L p F P
0 g
s
.976 .672 .347 r
.84555 .8771 m .834 .86367 L .83164 .83271 L p F P
0 g
s
.945 .637 .424 r
.81552 .82022 m .83164 .83271 L .834 .86367 L p F P
0 g
s
.976 .672 .347 r
.834 .86367 m .84555 .8771 L .84802 .90841 L p F P
0 g
s
.195 .049 .444 r
.51963 .87182 m .52956 .86301 L .5295 .83204 L p F P
0 g
s
.265 .102 .464 r
.5375 .82595 m .5295 .83204 L .52956 .86301 L p F P
0 g
s
.736 .464 .517 r
.72946 .73001 m .69956 .72694 L .69821 .69699 L p F P
0 g
s
.7 .435 .521 r
.67889 .6965 m .69821 .69699 L .69956 .72694 L p F P
0 g
s
.678 .419 .522 r
.66502 .69676 m .67889 .6965 L .68008 .72645 L p F P
0 g
s
.678 .419 .522 r
.68008 .72645 m .66611 .72671 L .66502 .69676 L p F P
0 g
s
.637 .387 .522 r
.66502 .69676 m .66611 .72671 L .63559 .72973 L p F P
0 g
s
.7 .435 .521 r
.69956 .72694 m .68008 .72645 L .67889 .6965 L p F P
0 g
s
.457 .247 .505 r
.55871 .81385 m .55842 .78319 L .58199 .7732 L p F P
0 g
s
.369 .181 .489 r
.55842 .78319 m .55871 .81385 L .5375 .82595 L p F P
0 g
s
.835 .543 .496 r
.78181 .77372 m .7657 .76822 L .76385 .7379 L p F P
0 g
s
.797 .512 .507 r
.73644 .7312 m .76385 .7379 L .7657 .76822 L p F P
0 g
s
.036 0 .392 r
.50775 .91767 m .51962 .90318 L .51963 .87182 L p F P
0 g
s
.195 .049 .444 r
.52956 .86301 m .51963 .87182 L .51962 .90318 L p F P
0 g
s
.369 .181 .489 r
.53762 .85698 m .5375 .82595 L .55871 .81385 L p F P
0 g
s
.265 .102 .464 r
.52956 .86301 m .53762 .85698 L .5375 .82595 L p F P
0 g
s
.588 .348 .521 r
.60802 .76549 m .60737 .73515 L .63559 .72973 L p F P
0 g
s
.529 .302 .515 r
.60737 .73515 m .60802 .76549 L .58199 .7732 L p F P
0 g
s
.9 .597 .465 r
.81552 .82022 m .79469 .80882 L .79262 .77812 L p F P
0 g
s
.857 .562 .487 r
.78181 .77372 m .79262 .77812 L .79469 .80882 L p F P
0 g
s
.797 .512 .507 r
.7657 .76822 m .73808 .76158 L .73644 .7312 L p F P
0 g
s
.766 .488 .513 r
.72946 .73001 m .73644 .7312 L .73808 .76158 L p F P
0 g
s
.766 .488 .513 r
.73808 .76158 m .73105 .76039 L .72946 .73001 L p F P
0 g
s
.736 .464 .517 r
.69956 .72694 m .72946 .73001 L .73105 .76039 L p F P
0 g
s
.945 .637 .424 r
.834 .86367 m .81777 .85129 L .81552 .82022 L p F P
0 g
s
.9 .597 .465 r
.79469 .80882 m .81552 .82022 L .81777 .85129 L p F P
0 g
s
.637 .387 .522 r
.63646 .76012 m .63559 .72973 L .66611 .72671 L p F P
0 g
s
.588 .348 .521 r
.63559 .72973 m .63646 .76012 L .60802 .76549 L p F P
0 g
s
.857 .562 .487 r
.79469 .80882 m .7838 .80446 L .78181 .77372 L p F P
0 g
s
.835 .543 .496 r
.7657 .76822 m .78181 .77372 L .7838 .80446 L p F P
0 g
s
.529 .302 .515 r
.58245 .80394 m .58199 .7732 L .60802 .76549 L p F P
0 g
s
.457 .247 .505 r
.58199 .7732 m .58245 .80394 L .55871 .81385 L p F P
0 g
s
.976 .672 .347 r
.84802 .90841 m .83639 .89511 L .834 .86367 L p F P
0 g
s
.945 .637 .424 r
.81777 .85129 m .834 .86367 L .83639 .89511 L p F P
0 g
s
.195 .049 .444 r
.51962 .90318 m .52963 .89446 L .52956 .86301 L p F P
0 g
s
.265 .102 .464 r
.53762 .85698 m .52956 .86301 L .52963 .89446 L p F P
0 g
s
.736 .464 .517 r
.73105 .76039 m .70092 .75734 L .69956 .72694 L p F P
0 g
s
.7 .435 .521 r
.68008 .72645 m .69956 .72694 L .70092 .75734 L p F P
0 g
s
.678 .419 .522 r
.66611 .72671 m .68008 .72645 L .6813 .75686 L p F P
0 g
s
.678 .419 .522 r
.6813 .75686 m .66722 .75712 L .66611 .72671 L p F P
0 g
s
.637 .387 .522 r
.66611 .72671 m .66722 .75712 L .63646 .76012 L p F P
0 g
s
.7 .435 .521 r
.70092 .75734 m .6813 .75686 L .68008 .72645 L p F P
0 g
s
.457 .247 .505 r
.559 .84498 m .55871 .81385 L .58245 .80394 L p F P
0 g
s
.369 .181 .489 r
.55871 .81385 m .559 .84498 L .53762 .85698 L p F P
0 g
s
.835 .543 .496 r
.7838 .80446 m .76757 .79901 L .7657 .76822 L p F P
0 g
s
.797 .512 .507 r
.73808 .76158 m .7657 .76822 L .76757 .79901 L p F P
0 g
s
.369 .181 .489 r
.53775 .88847 m .53762 .85698 L .559 .84498 L p F P
0 g
s
.265 .102 .464 r
.52963 .89446 m .53775 .88847 L .53762 .85698 L p F P
0 g
s
.588 .348 .521 r
.60869 .7963 m .60802 .76549 L .63646 .76012 L p F P
0 g
s
.529 .302 .515 r
.60802 .76549 m .60869 .7963 L .58245 .80394 L p F P
0 g
s
.9 .597 .465 r
.81777 .85129 m .79679 .84 L .79469 .80882 L p F P
0 g
s
.857 .562 .487 r
.7838 .80446 m .79469 .80882 L .79679 .84 L p F P
0 g
s
.797 .512 .507 r
.76757 .79901 m .73975 .79241 L .73808 .76158 L p F P
0 g
s
.766 .488 .513 r
.73105 .76039 m .73808 .76158 L .73975 .79241 L p F P
0 g
s
.766 .488 .513 r
.73975 .79241 m .73267 .79124 L .73105 .76039 L p F P
0 g
s
.736 .464 .517 r
.70092 .75734 m .73105 .76039 L .73267 .79124 L p F P
0 g
s
.945 .637 .424 r
.83639 .89511 m .82005 .88285 L .81777 .85129 L p F P
0 g
s
.9 .597 .465 r
.79679 .84 m .81777 .85129 L .82005 .88285 L p F P
0 g
s
.637 .387 .522 r
.63735 .79097 m .63646 .76012 L .66722 .75712 L p F P
0 g
s
.588 .348 .521 r
.63646 .76012 m .63735 .79097 L .60869 .7963 L p F P
0 g
s
.857 .562 .487 r
.79679 .84 m .78582 .83567 L .7838 .80446 L p F P
0 g
s
.835 .543 .496 r
.76757 .79901 m .7838 .80446 L .78582 .83567 L p F P
0 g
s
.529 .302 .515 r
.58293 .83516 m .58245 .80394 L .60869 .7963 L p F P
0 g
s
.457 .247 .505 r
.58245 .80394 m .58293 .83516 L .559 .84498 L p F P
0 g
s
.736 .464 .517 r
.73267 .79124 m .70231 .78822 L .70092 .75734 L p F P
0 g
s
.7 .435 .521 r
.6813 .75686 m .70092 .75734 L .70231 .78822 L p F P
0 g
s
.678 .419 .522 r
.66722 .75712 m .6813 .75686 L .68254 .78774 L p F P
0 g
s
.678 .419 .522 r
.68254 .78774 m .66835 .78799 L .66722 .75712 L p F P
0 g
s
.637 .387 .522 r
.66722 .75712 m .66835 .78799 L .63735 .79097 L p F P
0 g
s
.7 .435 .521 r
.70231 .78822 m .68254 .78774 L .6813 .75686 L p F P
0 g
s
.457 .247 .505 r
.55929 .87659 m .559 .84498 L .58293 .83516 L p F P
0 g
s
.369 .181 .489 r
.559 .84498 m .55929 .87659 L .53775 .88847 L p F P
0 g
s
.835 .543 .496 r
.78582 .83567 m .76947 .83027 L .76757 .79901 L p F P
0 g
s
.797 .512 .507 r
.73975 .79241 m .76757 .79901 L .76947 .83027 L p F P
0 g
s
.588 .348 .521 r
.60937 .82758 m .60869 .7963 L .63735 .79097 L p F P
0 g
s
.529 .302 .515 r
.60869 .7963 m .60937 .82758 L .58293 .83516 L p F P
0 g
s
.9 .597 .465 r
.82005 .88285 m .79893 .87166 L .79679 .84 L p F P
0 g
s
.857 .562 .487 r
.78582 .83567 m .79679 .84 L .79893 .87166 L p F P
0 g
s
.797 .512 .507 r
.76947 .83027 m .74145 .82373 L .73975 .79241 L p F P
0 g
s
.766 .488 .513 r
.73267 .79124 m .73975 .79241 L .74145 .82373 L p F P
0 g
s
.766 .488 .513 r
.74145 .82373 m .73431 .82257 L .73267 .79124 L p F P
0 g
s
.736 .464 .517 r
.70231 .78822 m .73267 .79124 L .73431 .82257 L p F P
0 g
s
.637 .387 .522 r
.63825 .8223 m .63735 .79097 L .66835 .78799 L p F P
0 g
s
.588 .348 .521 r
.63735 .79097 m .63825 .8223 L .60937 .82758 L p F P
0 g
s
.857 .562 .487 r
.79893 .87166 m .78788 .86737 L .78582 .83567 L p F P
0 g
s
.835 .543 .496 r
.76947 .83027 m .78582 .83567 L .78788 .86737 L p F P
0 g
s
.529 .302 .515 r
.58341 .86686 m .58293 .83516 L .60937 .82758 L p F P
0 g
s
.457 .247 .505 r
.58293 .83516 m .58341 .86686 L .55929 .87659 L p F P
0 g
s
.736 .464 .517 r
.73431 .82257 m .70372 .81957 L .70231 .78822 L p F P
0 g
s
.7 .435 .521 r
.68254 .78774 m .70231 .78822 L .70372 .81957 L p F P
0 g
s
.678 .419 .522 r
.66835 .78799 m .68254 .78774 L .68379 .8191 L p F P
0 g
s
.678 .419 .522 r
.68379 .8191 m .66949 .81935 L .66835 .78799 L p F P
0 g
s
.637 .387 .522 r
.66835 .78799 m .66949 .81935 L .63825 .8223 L p F P
0 g
s
.7 .435 .521 r
.70372 .81957 m .68379 .8191 L .68254 .78774 L p F P
0 g
s
.835 .543 .496 r
.78788 .86737 m .77141 .86201 L .76947 .83027 L p F P
0 g
s
.797 .512 .507 r
.74145 .82373 m .76947 .83027 L .77141 .86201 L p F P
0 g
s
.588 .348 .521 r
.61006 .85935 m .60937 .82758 L .63825 .8223 L p F P
0 g
s
.529 .302 .515 r
.60937 .82758 m .61006 .85935 L .58341 .86686 L p F P
0 g
s
.797 .512 .507 r
.77141 .86201 m .74317 .85554 L .74145 .82373 L p F P
0 g
s
.766 .488 .513 r
.73431 .82257 m .74145 .82373 L .74317 .85554 L p F P
0 g
s
.766 .488 .513 r
.74317 .85554 m .73597 .85439 L .73431 .82257 L p F P
0 g
s
.736 .464 .517 r
.70372 .81957 m .73431 .82257 L .73597 .85439 L p F P
0 g
s
.637 .387 .522 r
.63917 .85412 m .63825 .8223 L .66949 .81935 L p F P
0 g
s
.588 .348 .521 r
.63825 .8223 m .63917 .85412 L .61006 .85935 L p F P
0 g
s
.736 .464 .517 r
.73597 .85439 m .70515 .85141 L .70372 .81957 L p F P
0 g
s
.7 .435 .521 r
.68379 .8191 m .70372 .81957 L .70515 .85141 L p F P
0 g
s
.678 .419 .522 r
.66949 .81935 m .68379 .8191 L .68507 .85095 L p F P
0 g
s
.678 .419 .522 r
.68507 .85095 m .67065 .8512 L .66949 .81935 L p F P
0 g
s
.637 .387 .522 r
.66949 .81935 m .67065 .8512 L .63917 .85412 L p F P
0 g
s
.7 .435 .521 r
.70515 .85141 m .68507 .85095 L .68379 .8191 L p F P
0 g
s
.25 Mabswid
.6625 0 m
.92567 .40454 L
s
.92567 .40454 m
1 1.07561 L
s
1 1.07561 m
.69405 .72426 L
s
.69405 .72426 m
.6625 0 L
s
.08675 .23534 m
0 .93143 L
s
0 .93143 m
.69405 .72426 L
s
.69405 .72426 m
.6625 0 L
s
.6625 0 m
.08675 .23534 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{272.375, 331.938},
  ImageMargins->{{20, 0}, {0, 4}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004@0001Bb000`400?l00000o`00003o/_ooool2
o`0005cooooo002_ooooo`?o000000?oooooo`000?ooool0Foooool00:gooooo0_l00004ooooo`;o
0000Foooool00:[ooooo0ol00006ooooo`03o`000?oooooo000005[ooooo002Xooooo`;o00002Ooo
ool00ol0003oooooo`00001Jooooo`00Y_ooool2o`0000_ooooo00Co0000oooooooooooo0000FOoo
ool00:?ooooo0ol0000=ooooo`05o`000?ooooooooooooooool00000F?ooool00:7ooooo0_l0000@
ooooo`05o`000?ooooooooooooooool00000F?ooool009kooooo0ol0000Booooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0EOooool009cooooo0_l0000Eooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0E?ooool009Wooooo0ol0000Gooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool0E?ooool009Oooooo0_l0000Jooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool0Doooool009Gooooo0_l0000Mooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool0D_ooool009;ooooo0ol0000Oooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool0D_ooool0093ooooo0_l0000Rooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool0DOooool008gooooo0ol0000Tooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool0D?ooool008_ooooo0_l0000Wooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0
D?ooool008Sooooo0ol0000Yooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0Cooo
ool008Kooooo0_l0000/ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0C_ooool0
08?ooooo0ol0000^ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0C_ooool0087o
oooo0_l0000aooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0COooool007oooooo
0_l0000cooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0C?ooool007cooooo0ol0
000eooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0C?ooool007[ooooo0_l0000h
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0Boooool007Oooooo0ol0000joooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool0B_ooool007Gooooo0_l0000mooooo`03
o`000?oooooooooo00cooooo00?o0000ooooooooool0B_ooool007;ooooo0ol0000oooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool0BOooool0073ooooo0_l00012ooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooooooool0B?ooool006kooooo0_l00014ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool0B?ooool006_ooooo0ol00016ooooo`03o`000?oooooooooo
00oooooo00?o0000ooooooooool0Aoooool006Wooooo0_l00019ooooo`03o`000?oooooooooo00oo
oooo00?o0000ooooooooool0Aoooool006Kooooo0ol0001;ooooo`03o`000?oooooooooo013ooooo
00?o0000ooooooooool0A_ooool006Cooooo0_l0001>ooooo`03o`000?oooooooooo017ooooo00?o
0000ooooooooool0AOooool0067ooooo0ol0001@ooooo`03o`000?oooooooooo017ooooo00?o0000
ooooooooool0AOooool005oooooo0_l0001Dooooo`03o`000?oooooooooo017ooooo00?o0000oooo
ooooool0A?ooool005cooooo0ol0001Fooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool0@oooool005[ooooo0_l0001Iooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
@oooool005Sooooo0_l0001Kooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool0@_oo
ool005Gooooo0ol0001Mooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0@Oooool0
05?ooooo0_l0001Pooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0@Oooool0053o
oooo0ol0001Rooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0@?ooool004kooooo
0_l0001Uooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0?oooool004_ooooo0ol0
001Wooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0?oooool004Wooooo0_l0001Z
ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0?_ooool004Oooooo0_l0001/oooo
o`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0?Oooool004Cooooo0ol0001^ooooo`03
o`000?oooooooooo01Sooooo00?o0000ooooooooool0?Oooool004;ooooo0_l0001aooooo`03o`00
0?oooooooooo01Wooooo00?o0000ooooooooool0??ooool003oooooo0ol0001cooooo`03o`000?oo
oooooooo01[ooooo00?o0000ooooooooool0>oooool003gooooo0_l0001booooo`Go00007?ooool0
0ol0003oooooooooo`0kooooo`00>_ooool3o`0006Wooooo2ol000001?n]JhGo0000ok=_QOncKhD7
o`0001Oooooo00?o0000ooooooooool0>_ooool003Sooooo0_l0001Yooooo`?o00000_nFFHD00ol0
003oXf>5oj=SQ@04oj=SQ@04o`000?n]JhGo[F^5o`0000;o/fn500?o0000ok=_QOl000001?nlMX@6
o`0001;ooooo00?o0000ooooooooool0>Oooool003Gooooo0ol0001Xooooo`?o00001OnFFHD00ol0
003oXf>5oj=SQ@04oj=SQ@04o`000?n]JhGo[F^5o`0000;o/fn500?o0000ok=_QOl000001_nlMX@2
o`0000;oc8>10ol0000?ooooo`03o`000?oooooooooo03Wooooo000cooooo`;o0000J?ooool3o`00
0003ohM=Pol0003oUUV500GoUUV500?o0000oj=SQOnSHhD01?nSHhD01?l0003o[F^5oje[QOl00002
ok=_Q@03o`000?ncKhGo000000Ko_7J40_l00005olb3P@?o00003Oooool00ol0003oooooooooo`0h
ooooo`00<Oooool2o`0006Oooooo0ol00004ohM=P`03o`000?nFFHGoUUV500CoUUV500?o0000oj=S
QOnSHhD01?nSHhD01?l0003o[F^5oje[QOl00002ok=_Q@03o`000?ncKhGo000000Ko_7J40_l00006
olb3P@04o`000?oERgko0000o`0000cooooo00?o0000ooooooooool0=oooool002kooooo0ol0001W
ooooo`;o000000?oM3n1o`000?n7CH<01?n7CH<00ol0003oUUV5oiIIQ@04oiIIQ@03o`000?nSHhGo
Xf>500CoXf>500Co0000oje[QOn]JhGo00000_ncKhD00ol0003o/fn5o`000006okafQ003o`000?o4
O8?o000000Goc8>100Co0000omF;O_oERgkoeH]n0_l0000:ooooo`03o`000?oooooooooo03Oooooo
000/ooooo`;o0000JOooool01Ol0003oM3n1og@oPOmd?h7o000000GoQdf300?o0000oiIIQOnFFHD0
1?nFFHD01?l0003oXf>5oj=SQOnSHhD@o`0000;o_7J400?o0000olAlPol000001Oo<Ph401_l0003o
eH]nomF;O_oERgko0000om^?O0;o00002Oooool00ol0003oooooooooo`0fooooo`00:Oooool3o`00
06Wooooo0_l00004og@oP@03o`000?n7CH?oQdf300?oQdf300Co0000oiIIQOnFFHGoUUV51ol00003
oj=SQ@04o`000?n]JhGo[F^5o`0000?o/fn50_l00004okafQ0Oo00000oo<Ph402?l0003oeH]nomF;
O_oERgko0000om^?O?l0003oiYQg0_l00008ooooo`03o`000?oooooooooo03Gooooo000Wooooo`;o
0000Joooool00ol0003oGRimo`000004og@oP@03o`000?n7CH?oQdf300;oQdf31Ol00003oiIIQ@03
o`000?nSHhGoXf>500CoXf>500Co0000oje[QOn]JhGo00000oncKhD2o`0000Ko_7J400?o0000olAl
Pol000000_o<Ph44o`0000?oeH]n00?o0000om^?O?l000000ooVV7L00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo03Gooooo000Tooooo`?o0000K?ooool01?l0003oGRimoeh^OOl00004og@o
P@03o`000?n7CH?o000000;o000000?oQdf3o`000?nFFHD01OnFFHD00ol0003oXf>5oj=SQ@04oj=S
Q@04o`000?n]JhGo[F^5o`0000?o/fn50_l00006okafQ003o`000?o4O8?o000000Goc8>10_l00002
omF;OP03o`000?oKSgco000000CoiYQg00?o0000ooooooooool01Oooool00ol0003oooooooooo`0d
ooooo`008_ooool2o`0006kooooo00Go0000oeh^OOmN;WgoGRimo`000003og@oP@?o00001?n7CH<0
0ol0003oUUV5oiIIQ@04oiIIQ@03o`000?nSHhGoXf>500CoXf>500Go0000oje[QOn]JhGo[F^5o`00
0002ok=_Q@;o00001_nlMX@00ol0003oa7b3o`000005olb3P@03o`000?oERgko000000;o000000?o
fhmlo`000?oVV7L00ooVV7L2o`0000Oooooo00?o0000ooooooooool0<oooool0023ooooo0_l0001_
ooooo`03o`000?mN;WgoGRim00;oGRim00Ko0000og@oPOl0003o0000og@oPOl00005ohM=P`03o`00
0?nFFHGoUUV500CoUUV500?o0000oj=SQOnSHhD01?nSHhD01Ol0003o[F^5oje[QOn]JhGo000000;o
/fn50_l00006okafQ003o`000?o4O8?o000000Goc8>100Co0000omF;O_oERgkoeH]n0ol00004onJH
M`03o`000?oaXfco000000Kooooo00?o0000ooooooooool0<oooool001gooooo0ol0001`ooooo`;o
00001?mN;Wd2o`0000?oM3n100?o0000ohM=Pon7CH<00on7CH<00ol0003oUUV5oiIIQ@04oiIIQ@04
o`000?nSHhGoXf>5oj=SQA3o00000_nlMX@00ol0003oa7b3o`000005olb3P@06o`000?oERgkoeH]n
omF;O_l0003ofhml0_l00003onJHM`04o`000?oaXfcolJ=/o`0000Kooooo00?o0000ooooooooool0
<_ooool001_ooooo0_l0001booooo`03o`000?m36WKo000000?oGRim0_l00004og@oP@03o`000?n7
CH?oQdf300?oQdf300Co0000oiIIQOnFFHGoUUV51ol00003oj=SQ@05o`000?n]JhGo[F^5oje[QOl0
00000_ncKhD2o`0000Co_7J41ol00004olb3P@07o`000?oERgkoeH]no`000?oKSgco0000onJHM`02
o`000003onJHMol0003olJ=/00;olJ=/00?o0000ooooooooool01?ooool00ol0003oooooooooo`0a
ooooo`006?ooool3o`0007Cooooo00?o0000od<JM_l000000_mN;Wd00ol0003oGRimo`000004og@o
P@03o`000?n7CH?oQdf300;oQdf31Ol00003oiIIQ@03o`000?nSHhGoXf>500CoXf>500Go0000oje[
QOn]JhGo[F^5o`000002ok=_Q@;o00001_nlMX@00ol0003oa7b3o`000002olb3P@?o000000Ooc8>1
o`000?oERgkoeH]no`000?oKSgco000000?oiYQg0_l00003oo6SK003o`000?oooooooooo00Cooooo
00?o0000ooooooooool0<Oooool001Oooooo00?o0000ooooooooool0M?ooool2o`000004od<JM_l0
003oGRimo`0000;oGRim00?o0000og@oPOmd?h400_md?h400ol0003oQdf3ohM=P`02o`000003ohM=
Pol0003oUUV500GoUUV500?o0000oj=SQOnSHhD01?nSHhD01Ol0003o[F^5oje[QOn]JhGo000000;o
/fn50_l00006okafQ003o`000?o4O8?o000000Goc8>10ol000001?oERgko0000om^?O?l00004onJH
M`04o`000?oaXfcolJ=/oo6SK0;o00001_ooool00ol0003oooooooooo`0`ooooo`005oooool00ol0
003oooooooooo`1cooooo`04o`000?la377o0000od<JMP;o00000omN;Wd00ol0003oM3n1og@oP@02
og@oP@?o00000on7CH<00ol0003oUUV5oiIIQ@04oiIIQ@03o`000?nSHhGoXf>500GoXf>500Co0000
oje[QOn]JhGo00000_ncKhD00ol0003o/fn5o`000005okafQ003o`000?o4O8?o000000Koc8>100Co
0000omF;O_l0003o00000_oKSg`01?l0003oiYQgonJHMooVV7L2o`0000;olJ=/0_l00007ooooo`03
o`000?oooooooooo02oooooo000Gooooo`;o0000M?ooool01Ol0003o<@aao`000?m36WKo000000Co
GRim00Co0000og@oPOmd?h7oM3n10_l00005ohM=P`03o`000?nFFHGoUUV500CoUUV500?o0000oj=S
QOnSHhD01OnSHhD01?l0003o[F^5oje[QOl00002ok=_Q@03o`000?ncKhGo000000Ko_7J40_l00006
olb3P@03o`000?oERgkoeH]n00Co00000ooVV7L01ol0003olJ=/o`000?oaXfco0000ooV/F?l00000
1_ooool00ol0003oooooooooo`0_ooooo`005oooool00ol0003oooooo`00001booooo`;o000000?o
<@aao`000?l000001OmN;Wd01_l0003oM3n1o`000?l0003oM3n1o`0000KoQdf300?o0000oiIIQOnF
FHD00onFFHD01?l0003oXf>5oj=SQOnSHhDAo`0000;o_7J40_l00006olb3P@04o`000?oERgkoeH]n
o`0000;ofhml0_l00002onJHM`03o`000?oaXfcolJ=/00;o000000?onJaHo`000?ooool01_ooool0
0ol0003oooooooooo`0^ooooo`005oooool01?l0003oooooooooool0001`ooooo`06o`000?l906Co
0000oc4<LOl0003o@aYf1OmN;Wd2o`0000?oM3n100?o0000ohM=Pon7CH<01?n7CH<00ol0003oUUV5
oiIIQ@02oiIIQ@Go00001?nSHhD01?l0003o[F^5oje[QOl00002ok=_Q@03o`000?ncKhGo000000Co
_7J41_l00004olb3P@04o`000?oERgkoeH]no`0000;ofhml00?o0000onJHMol000000_oVV7L01Ol0
003olJ=/oo6SK?l0003onJaH00;o00001oooool00ol0003oooooooooo`0]ooooo`005_ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo067ooooo7_l00005ohM=P`03o`000?nFFHGo0000
00;o000000?oUUV5o`000?nSHhD01_nSHhD01?l0003o[F^5oje[QOl00002ok=_Q@03o`000?ncKhGo
000000Ko_7J40_l00002olb3P@?o000000Goc8>1o`000?oERgkoeH]no`000002om^?O006o`000?oV
V7OoiYQgo`000?oVV7Oo00000_oaXf`01?l0003onJaHo`000?l00007ooooo`03o`000?oooooooooo
02gooooo000Fooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0GOoooolXo`0000Co
UUV500?o0000oj=SQOnSHhD01OnSHhD01?l0003o[F^5oje[QOl00002ok=_Q@03o`000?ncKhGo0000
00Ko_7J40_l00005olb3P@?o00000_oERgh00ol0003ofhmlo`000003onJHM`;o00000_oaXf`2o`00
0003ooV/F?l0003ooooo00Oooooo00?o0000ooooooooool0;?ooool001Kooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`1Gooooo`Oo00001?m>00000ol0003oHP00of800002of8000So
00000_m]00001?l0003oO@00ogd00?mm0003o`000003ogL00?l0003o000000Go000000?oHP00o`00
0?l000000_l00003oiIIQ@03o`000?nSHhGoXf>500GoXf>500Co0000oje[QOn]JhGo00000_ncKhD0
0ol0003o/fn5o`000006okafQ0;o00001_o<Ph400ol0003oeH]no`000002o`000003om^?O?l0003o
iYQg00?oiYQg0_l000000ooaXfco0000ooV/F003o`0000Sooooo00?o0000ooooooooool0:oooool0
01Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`1Booooo`So00000_m>000=o`00
00?oQ0/A3ol00003ohL000So000000?oUUV5o`000?nSHhD01_nSHhD01?l0003o[F^5oje[QOl00002
ok=_Q@03o`000?ncKhGo000000Ko_7J400?o0000olAlPol000001Oo<Ph401?l0003oeH]nomF;O_oE
Rgh3o`0000CoiYQg00Ko0000oo6SK?l0003olJ=/o`000?oi[5P2o`0000Sooooo00?o0000oooooooo
ool0:oooool001Kooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1=ooooo`ko0000
0omU00000ol0003oMP08ogH02004ogH02003o`000?n42a7oQ0/A00GoQ0/A0ol00006ohlA2@03o`00
0?nK7Q7oVahA00Ko000000?oQ`00o`000?l000001Ol00007oj=SQ@03o`000?n]JhGo000000Co0000
00?o/fn5o`000?nlMX@01OnlMX@00ol0003oa7b3o`000005olb3P@06o`000?oERgkoeH]nomF;O_l0
003ofhml0_l00003onJHM`03o`000?oaXfcolJ=/00;o000000?onJaHo`000?l000002Oooool00ol0
003oooooooooo`0Zooooo`005_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo04[o
oooo5Ol00002ogH021So000000?oVahAo`000?nJ5`400_nJ5`45o`0000;oS`002_l000001?n]JhGo
/fn5ok=_QOncKhD7o`0000;o_7J400?o0000olAlPol000001Oo<Ph402Ol0003oeH]nomF;O_oERgko
0000om^?O?l0003oiYQgo`000002onJHM`06o`000?oaXfcolJ=/oo6SK?l0003onJaH0ol00009oooo
o`03o`000?oooooooooo02Wooooo000Fooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool0Aoooool9o`0000CoF@0500?o0000ofX03_mZ00h02_l000000on55BOo0000oi4R;@06oi4R;@03
o`000?nK;C;oVbdb00?oVbdb00?o0000oi`Y:?l000001OnV=2h7o`0000;oYB@91ol000001OnSHhGo
0000o`000?nSHhGo000000;o[F^500Ko0000ok=_QOncKhGo0000ok=_QOl00004okafQ0Oo00000oo<
Ph401ol0003oeH]nomF;O_oERgko0000om^?O?l000000_oVV7L00ol0003oiYQgo`000003oo6SK003
o`000?oi[5So000000;o00002Oooool00ol0003oooooooooo`0Yooooo`005_ooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo04Cooooo2?l000001?m5003o0000oeT01OmI00D6o`0000?o
N@l[00?o0000ohHK<On66c401?n66c43o`0000GoTB8]00?o0000oi/]<_nK;C801OnK;C800ol0003o
YS@^ojHd;P07ojHd;P04o`000?n`>ROo/3XWok0j9`Go00000onS7003o`000003oj=SQOl0003o0000
00;o[F^500Ko0000ok=_QOncKhGo0000ok=_QOl00006okafQ003o`000?o4O8?o000000;oc8>11?l0
0003omF;OP03o`000?oKSgco000000?oiYQg0_l00003oo6SK0Go00002_ooool00ol0003ooooooooo
o`0Xooooo`005Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo047ooooo1ol00003
odD000Co00000_mZ02@00ol0003oN@l[ogT?:`03ogT?:`04o`000?n66c7oQQ/aohHK<AKo00002?nV
=2h2o`0000Ko/3XW0_l000001?nS703o0000ojhY0?n^:@05o`000003oje[QOl0003o/fn500;o/fn5
0_l00006okafQ003o`000?o4O8?o000000Goc8>10ol000001OoERgko0000om^?O?oKSgco000000?o
iYQg00Co0000oo6SK?oaXfcolJ=/0ol000000ooaZcCo0000ooooo`0:ooooo`03o`000?oooooooooo
02Oooooo000Eooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0?_ooool6o`000004
obh00?l0003oA@00odD000?o00001?mZ02@00ol0003oN@l[ogT?:`08o`0000?oSbm800?o0000oiTh
C?nI>4`01?nI>4`2o`0000SoXcm900?o0000oj]7C?l000002_l00007ok0j9`?o00000_n^:@001_l0
003o[280oj`R0?l0003o[F^5o`0000?o/fn50_l00006okafQ003o`000?o4O8?o000000Goc8>100?o
0000omF;O_oERgh00ol000000ooKSgco0000onJHM`02onJHM`;o00000_oaXf`3o`000003oo6[=?l0
003ooooo00[ooooo00?o0000ooooooooool09oooool001Gooooo00?o0000ooooooooool03Oooool0
0ol0003oooooooooo`0jooooo`Ko00000ol^0004o`000004oeT06ol0003oJP0TofX090Ko00001?n4
94@00ol0003oSbm8ohl_B004ohl_B003o`000?nI>4coVCQ<00GoVCQ<00?o0000oj<oBOnS?dT01_nS
?dT01?l0003oZdM<oj]7C?l00005oji6A@03o`000?ndCTSo]4i800Go00000_n`>RL01?l0003o]d</
o`000?nj@B04o`0000?o[2800_l00002ok=_Q@;o00001_nlMX@00ol0003oa7b3o`000005olb3P@06
o`000?oERgkoeH]nomF;O_l0003ofhml0_l00003onJHM`09o`000?oaXfco0000oo6SK?l0003onJaH
o`000?oaZcCo000000cooooo00?o0000ooooooooool09_ooool001Gooooo00?o0000ooooooooool0
3_ooool00ol0003oooooooooo`0hooooo`Co000000Co5000o`000?l^003o;P000ol00002oeT06`Ko
000000?oN1Pno`000?n494@01On494@00ol0003oSbm8ohl_B004ohl_B003o`000?nI>4coVCQ<00Ko
VCQ<00?o0000oj<oBOnS?dT01OnS?dT00ol0003oZdM<oj]7C002oj]7C005o`000?n^ATGo[TI5oji6
AOl000001OndCTP00ol0003o^4e1okQ=@@06o`0000?o^T4P3_l00002okafQ003o`000?o4O8?o0000
00Goc8>100Go0000omF;O_oERgkoeH]no`000002om^?O0;o00000_oVV7L00ol0003olJ=/oo6SK002
o`000004ooV/F?l0003olJ/do`0000gooooo00?o0000ooooooooool09Oooool001Gooooo00?o0000
ooooooooool03oooool00ol0003oooooooooo`0eooooo`Co00000_lD0004o`000003odD04_l0003o
000000Co00001?mi7DD5o`0000?oQ2A400?o0000ohl_B?n?;dP06_l000001On[Adco0000oji6AOn^
ATGo000000Ko]4i800Co0000okQ=@OnhCD7o00000onnE4@4o`0000?o^T4P1ol00004okafQ0Oo0000
1?o<Ph401?l0003oeH]nomF;O_l00002om^?O006o`000?oVV7Oo0000o`000?oVV7Oo00000_oaXf`0
0ol0003onJaHo`000002o`0000gooooo00?o0000ooooooooool09Oooool001Gooooo00?o0000oooo
ooooool04?ooool00ol0003oooooooooo`0cooooo`?o00000_lD0003o`000003odD04_l0003o0000
00Co00000_m/4D000ol0003oNAe5ogTMA@03ogTMA@03o`000?n59dWoQBM900Oo00001?nG?e/00ol0
003oWdMMoim7G@05oim7G@04o`000?nVCUooYTiOo`0000GoZDiK00?o0000ok1DGOn`E5d00_n`E5d9
o`0000?o]4i80_l00005okiDA003o`000?o2E3_o`U@k00?o000000?o^T4Po`000?o2AaL00_o2AaL3
o`0000Go_7J400?o0000olAlPol000000_o<Ph43o`000003olb3POl0003oeH]n00;oeH]n00?o0000
om^?O?l000000ooVV7L2o`0000;olJ=/00?o0000ooV/F?l000000_l0000>ooooo`03o`000?oooooo
oooo02Cooooo000Eooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0<Oooool=o`00
00CoK15000Co0000ogTMAOmi7DGoNAe51_l00003oh`hF`03o`000?nE?eko000000GoUcmK00?o0000
oim7GOnOAed01OnOAed01Ol0003oYTiOojI>GonVCUoo000000CoZDiK00?o0000ok1DGOn`E5d01On`
E5d00ol0003o^E]KokUKF`03okUKF`Oo00001?nnE4@00ol0003o`U@kol9D>`02ol9D>`;o00000oo2
AaL01?l0003o`d<5o`000?l00004okafQ003o`000?o4O8?o000000Goc8>10ol00002omF;OP03o`00
0?oKSgco000000CoiYQg00?o0000oo6SK?oaXf`00_l000000ooi[5So0000o`00000>ooooo`03o`00
0?oooooooooo02Cooooo000Eooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0;_oo
ool<o`000003oed3>_l0003oK15000CoK1501?l00002oh8^F003o`000?n<>5_oS3QK00CoS3QK00Co
0000oiDoG_nE?eko00000onG?e/00ol0003oWdMMoim7G@05oim7G@03o`000?nVCUooYTiO00?oYTiO
00Co0000ojU>FonYCU_o00002?n`E5d00ol0003o^E]KokUKF`07okUKF`03o`000?o3HUOo`f9G00Ko
00000oo2E3/01Ol0003oae/no`000?l0003o`TLG00;o00000_o3@`D2o`0000;o_7J400?o0000olAl
Pol000001_o<Ph400ol0003oeH]no`000002o`000003om^?O?l0003oiYQg00?oiYQg0_l000000ooa
Xfco0000ooV/F003o`0000oooooo00?o0000ooooooooool08oooool001Cooooo00?o0000oooooooo
ool05?ooool00ol0003oooooooooo`0[ooooo`_o00001?mM0cX01?l0003oK150of`A@?m/4D03o`00
00GoPRiH00?o0000oh`hFon<>5/00on<>5/00ol0003oUCmNoiDoGP02oiDoGP03o`000?nG?e_o0000
01Ko00000on`E5d00ol0003o]UYNo`000008okUKF`03o`000?o3HUOo`f9G00Go`f9G0_l000001_o2
E3_o0000olMK?_o7Fcko0000ol]K<`Co00000_o3@`D2o`0000;o_7J40_l00006olb3P@04o`000?oE
RgkoeH]nomF;OP?o00001?oVV7L01_l0003olJ=/o`000?oaXfco0000ooV/F0;o00004?ooool00ol0
003oooooooooo`0Rooooo`005?ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo02Wo
oooo2Ol000000om<03;o0000oed3>P03oed3>P03o`000?m/4D3o000000;o000000?oMbADo`000?n2
;UP01?n2;UP00ol0003oS3QKoh`hF`02oh`hF`Wo000000?oW4aZo`000?nTDf`01_nTDf`00ol0003o
ZUU]ojYIK@04ojYIK@03o`000?n]FV_o000000Co/f1/2ol00002okUKF`03o`000?nnHEco000000Oo
`f9G1?l00002olMK?P04o`000?o;Fc?o0000ol]K<`;o00000oo3@`D01?l0003o_7J4o`000?l00006
olb3P@06o`000?oERgkoeH]nomF;O_l0003ofhml0_l00003onJHM`03o`000?oaXfcolJ=/00;o0000
00ConJaHo`000?l0003o00003oooool00ol0003oooooooooo`0Rooooo`005?ooool00ol0003ooooo
ooooo`0Fooooo`03o`000?oooooooooo02Oooooo1?l000001?lD003o0000o`000?l00002od`0<P04
o`000?mM0c[oG@<joed3>PCo00001?mg95@00ol0003oPRiHoh8^F003oh8^F003o`000?n<>5_o0000
00;o00000_nBAF/00ol0003oVTa/oiY<K004oiY<K0;o00001onTDf`00ol0003oZUU]ojYIK@05ojYI
K@03o`000?ncH6co/f1/00Ko/f1/00Co0000okUUKOniIFgo00001?nlIfX5o`0000So`f9G00?o0000
olaYDoo<JE<01Ol00003ol]K<`Co000000?o_7J4o`000?l000001_o<Ph402Ol0003oeH]nomF;O_oE
Rgko0000om^?O?l0003oiYQgo`000002onJHM`06o`000?oaXfcolJ=/oo6SK?l0003onJaH0ol0000@
ooooo`03o`000?oooooooooo027ooooo000Dooooo`03o`000?oooooooooo01Kooooo00?o0000oooo
ooooool09_ooool4o`000003oa@00?l0003o000000CoC00b1?l00002ofXHD003o`000?mg95CoMbAD
00;oMbAD00Co0000oh8^F?n2;USoPRiH1Ol00005oi95J`03o`000?nJC6coVTa/00GoVTa/00?o0000
ojACK?nTDf`01?nTDf`00ol0003oZUU]ojYIK@06ojYIK@03o`000?ncH6co/f1/00Ko/f1/00Co0000
okUUKOniIFgo00001_nlIfX00ol0003o`Fa[ol5/J`03o`0000Go`f9G00?o0000olaYDoo<JE<00oo<
JE<3o`0000;obe/c00?o0000oliJ9_l000001_l00004olb3P@07o`000?oERgkoeH]nomF;O_l0003o
fhmlo`000002onJHM`03o`000?oVV7Oo000000?olJ=/00?o0000ooV/F?l000000_l0000Aooooo`03
o`000?oooooooooo023ooooo000Dooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0
9?ooool6o`000004ocT0:_l0003oC00bod`0<P?o00001?mZ65001?l0003oMbADogLTE?mg95@6o`00
00?oRCeX00?o0000oi95JonBAF/01?nBAF/00ol0003oVTa/oiY<K005oiY<K003o`000?nTDfcoY5=/
00CoY5=/00?o0000ojYIKOnZFFd01_nZFFd00ol0003o/f1/ok=PK006ok=PK005o`000?niIFgo^FE]
okUUKOl000001OnlIfX01?l0003o`Fa[ol5/Jol00002olE^J0?o000000Co`f9Go`000?o7IeSo0000
1Oo<JE<00ol0003odF]<o`000003o`0000?odf4[0_l00002olb3P@?o000000?oc8>1o`000?oERgh0
0_oERgh00ol0003ofhmlo`000003onJHM`;o00000ooaXf`3o`000003oo6[=?l0003ooooo013ooooo
00?o0000ooooooooool08?ooool001Cooooo00?o0000ooooooooool06?ooool00ol0003ooooooooo
o`0Rooooo`Go00000_li02X01_l0003oC00bo`000?l0003oF`]:o`0000GoJQQ@1?l00002ogldIP03
o`000?n9?FSoRCeX00CoRCeX00?o0000oi95JonBAF/01?nBAF/01?l0003oVTa/oiY<K?nJC6`Po`00
0003okUUKOl0003o_6MZ00?o_6MZ00?o0000ol5/Joo1K6/00_o1K6/00ol0003oaFiXolE^J002olE^
J0Go00001?o<JE<2o`0000?odF]<0_l00003om=Q:`;o00001?o<Ph44o`000005omF;O_l0003ofhml
om^?O?l000000ooVV7L2o`0000;olJ=/0ol000000ooaZcCo0000ooooo`0Aooooo`03o`000?oooooo
oooo01oooooo000Dooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool08?ooool5o`00
00?o>@0Z0_l00003oe/;BP04o`000?mZ653oJQQ@ofXHD0?o00001Omo=6H00ol0003oRCeXohTmJ003
ohTmJ004o`000?nBAF_oTTE[oi95J`So00000onNEgP2o`0000KoYeeh00?o0000ojeSNOn]HgT01_n]
HgT2o`0000Oo]VUh00?o0000ok]^N?nkKWP01Ol000000onlIf[o0000ol5/J`03ol5/J`03o`000?o5
KVSoaFiX00?oaFiX00Co0000olYbJ?l0003ocWET0ol000000oo<JE?o0000o`000003om5[C008o`00
0?oDL4go0000o`000?oCHB_o0000omEO6ol00004olb3P@03o`000?oERgkoeH]n00?o000000?ofhml
o`000?oVV7L00_oVV7L02Ol0003olJ=/o`000?oaXfco0000ooV/F?l0003olJ/do`00000Cooooo`03
o`000?oooooooooo01kooooo000Dooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool0
7_ooool5o`0000;o>@0Z0_l00004oe/;BP03o`000?mZ653oJQQ@00;o000000?oM2YRo`000?mo=6H0
1?mo=6H00ol0003oRCeXohTmJ002ohTmJ0Ko00001?nGD7L00ol0003oWUMhoiiGN004oiiGN003o`00
0?nUG7Wo000000GoYeeh00?o0000ojeSNOn]HgT01_n]HgT2o`0000Oo]VUh00Go0000ok]^N?nkKWSo
^fiho`000003oki`M`Go000000?o`Fa[o`000?o5KVP01?o5KVP01?l0003obW9XolYbJ?l00003olie
I0?o00000_oAJd`01Ol0003oe71=omA`COl0003ofG5500?o000000?oeElKo`000?o<Ph400_o<Ph40
1_l0003oeH]nomF;O_oERgko0000om^?O0;o00000ooVV7L00ol0003olJ=/oo6SK002o`000004ooV/
F?l0003olJ/do`0001?ooooo00?o0000ooooooooool07_ooool001Cooooo00?o0000ooooooooool0
6oooool00ol0003oooooooooo`0Looooo`?o000000?o500Ao`000?l000000_l000000om:04Co0000
oe/;BP03oe/;BP?o00000omd:V800ol0003oOcAVogldIP03ogldIP03o`000?n9?FSo000000;o0000
0_n?BWH00ol0003oUe1goiM@M`05oiM@M`03o`000?nNEgSoWUMh00CoWUMh00?o0000ojELNOl00000
1OnWGGP00ol0003o[F=iojeSN@06ojeSN@03o`000?nbIgWo000000Ko]VUh00Go0000ok]^N?nkKWSo
^fiho`000004oki`M`04o`000?o3M7Oo`gAgol=dM`Ko000000GoaFiXo`000?o:LVSobW9Xo`000004
olieI003o`000?o>MFCo000000;o00000ooDL4d00ol0003ofG55omUaA@02o`000005omEO6ol0003o
c8>1olb3POl000000ooERgh00ol0003ofhmlom^?O002o`0000;oiYQg00Ko0000oo6SK?oaXfcolJ=/
o`000?oi[5P3o`0001Cooooo00?o0000ooooooooool07Oooool001?ooooo00?o0000ooooooooool0
7Oooool00ol0003oooooooooo`0Jooooo`?o000000Co500Ao`000?l0003o00000om:04@01?l0003o
F`]:oe/;B_mK2dX2o`0000GoM2YR00?o0000ogldI_mo=6H00_mo=6H3o`0000GoSdYf00?o0000oiM@
MonGD7L01?nGD7L00ol0003oWUMhoiiGN005oiiGN003o`000?nUG7Wo000000GoYeeh00?o0000ojeS
NOn]HgT01_n]HgT00ol0003o/VMio`000006okIYN003o`000?nkKWSo^fih00;o^fih00Go0000oki`
MonnL7Oo_W1go`000005ol=dM`04o`000?o7MgGoagMeolMgM@Go00001?o>MF@01Ol0003ocWETo`00
0?l0003oeg]P00;o000000?oe71=o`000?oILDD00ooILDD2o`0000;oc8>100Go0000omF;O_oERgko
eH]no`000002om^?O006o`000?oVV7Oo0000o`000?oVV7Oo00000_oaXf`00ol0003onJaHo`000002
o`0001Gooooo00?o0000ooooooooool07?ooool001?ooooo00?o0000ooooooooool07_ooool00ol0
003oooooooooo`0Hooooo`;o000000?o0003o`000?l000000_l00003odX0A003o`000?mK2d[o0000
00;o000000?oIamNo`000?md:V801?md:V800ol0003oOcAVo`000002o`000003ohI2M?l0003oSdYf
00GoSdYf00?o0000oiM@MonGD7L01?nGD7L01?l0003oWUMhoiiGN?nNEgPRo`000003ok]^N?l0003o
_W1g00;o_W1g00?o0000ol=dMoo3M7L00oo3M7L00ol0003oagMeolMgM@02olMgM@03o`000?o;NgGo
bg]e00?o00000_o>MF@01?l0003ocWETolieI?l00003omMkH0;o00001?oILDD01Ol0003ogG8io`00
0?o<Ph7o000000?oeH]n00Co0000om^?O?oKSgco00000ooVV7L2o`0000;olJ=/0_l000000ooi[5So
0000o`00000Eooooo`03o`000?oooooooooo01cooooo000Cooooo`03o`000?oooooooooo01oooooo
00?o0000ooooooooool05_ooool2o`000006o`000ol0003o0000o`000?lf03co00000_m:04@3o`00
00CoIamN00Co0000og@ZH_md:V;oM2YR1?l00004ohI2M003o`000?n?BWKoSdYf00CoSdYf00Co0000
oiM@MonGD7OoUe1g1ol00004oj5OPP04o`000?nWI8?oYfB3o`0000CoZVJ300?o0000ojm[Pon_Jh<0
1_n_Jh<00ol0003o]6n3o`000006okMbP`04o`000?nlMH;o_7F2okaePPCo000000?o_W1go`000?o3
M7L01Oo3M7L01Ol0003oagMeolMgMOo7MgGo000000?obg]e00?o0000om1nLol000000_l00002olie
I003o`000?oGNf3oeg]P00?oeg]P0_l00003omUaA@03o`000?oMLSWo000000;o00000_oERgh01?l0
003ofhmlom^?O?l00004onJHM`05o`000?oaXfcolJ=/o`000?oi[5P00ol0000Fooooo`03o`000?oo
oooooooo01_ooooo000Cooooo`03o`000?oooooooooo023ooooo00?o0000ooooooooool05?ooool2
o`0000;o000300Co0000ocH0??lf03co=P0l0ol000000omH4UWo0000ofLOGP03ofLOGP03o`000?md
:V;o000000;o00000_ml>G800ol0003oQT9dohI2M003ohI2M003o`000?n?BWKoSdYf00;oSdYf1_l0
0003oi]JPP03o`000?nQGh;oXEn200GoXEn200Co0000ojMTPonWI8?o00001?nZIX<00ol0003o[f^3
ojm[P`06ojm[P`03o`000?ndKh?o000000Ko]g:300?o0000okaeP_nlMH800_nlMH800ol0003o`7R2
ol1hPP06o`0000;o`gAg00Co0000olMgMOo7MgGo00001?o;NgD01?l0003od7icom1nLoo@OW<4o`00
00Goeg]P00Ko0000omanF_l0003o0000omUaAOl00002omeb>@03o`000?oERgko000000;o00000_oK
Sg`00ol0003oiYQgonJHM`02onJHM`;o00000_oaXf`01?l0003onJaHo`000?l0000Gooooo`03o`00
0?oooooooooo01[ooooo000Cooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool04_oo
ool2o`000003o`000ol0003o000000?o=P0l0_l00003oePBF@04o`000?mW7ekoIamNofLOGP?o0000
1Oml>G800ol0003oQT9dohI2M003ohI2M003o`000?n?BWKo000000;o00000_nCE8400ol0003oVeZ2
oi]JPP04oi]JPP03o`000?nQGh;oXEn200GoXEn200Co0000ojMTPonWI8?o00001?nZIX<00ol0003o
[f^3ojm[P`06ojm[P`03o`000?ndKh?o000000Ko]g:300?o0000okaeP_nlMH800_nlMH801Ol0003o
`7R2ol1hP_o0N8;o000000Coa7b21_l00004ol]kM@05o`000?o@OW?od7icom1nLol000000_o@OW<2
o`0000Coeg]P00Co0000omanF_oLOU[og7iJ0_l00003omeb>@03o`000?oERgkoeH]n00Co00001?oV
V7L01_l0003olJ=/o`000?oaXfco0000ooV/F0?o00005_ooool00ol0003oooooooooo`0Jooooo`00
4oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo013ooooo1?l000001?lB02Oo0000
ocH0??lf03`2o`0000?oF19I00?o0000ofLOG_mW7eh00_l000000om`<6oo0000og`iLP04og`iLP03
o`000?n6@WCoQT9d00;oQT9d1?l00005oi=DP@03o`000?nKFX;oVeZ200CoVeZ200?o0000oj5OP_nQ
Gh801OnQGh801?l0003oYfB3ojMTPol00004ojYVP`03o`000?n_Jh?o[f^300Ko[f^300?o0000okA_
Pol000001_ngLX<00ol0003o_7F2okaePP02okaePP05o`000?o0N8;o`7R2ol1hP_l000001_o4O880
0ol0003ob7n1olQoP@04o`000003ol]kMOl0003od7ic00?od7ic00Co0000om1nLol0003of8E`0ol0
0002omMkH003o`000?oLOU[og7iJ00;og7iJ00?o0000omeb>Ol000000_l000001?oERgko0000om^?
O?oKSg`2o`0000?oiYQg00?o0000oo6SK?oaXf`00_l000001?oi[5So0000o`000?l0000Gooooo`03
o`000?oooooooooo01Wooooo000Cooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool0
3_ooool4o`0000;o4P0W00Go0000ocH0??l0003oA`ACo`000003oePBF@?o00000om`<6l00ol0003o
O3Ubog`iLP03og`iLP03o`000?n6@WCo000000;o00000_n;CX000ol0003oTeB1oi=DP@04oi=DP@03
o`000?nKFX;oVeZ200CoVeZ200?o0000oj5OP_nQGh801OnQGh801?l0003oYfB3ojMTPol00002ojYV
P`ko00001_ngLX<00ol0003o_7F2okaePP02okaePP05o`000?o0N8;o`7R2ol1hP_l000001_o4O880
1?l0003ob7n1olQoPOl00003olb2P0Co00000_o@OW<00ol0003od7ico`000004omR5L0?o00001?oL
OUX3o`000006on1g??l0003o0000omF;O_l0003ofhml0_oVV7L01?l0003oiYQgonJHMol00003oo6S
K003o`000?oi[5So000000;o00006?ooool00ol0003oooooooooo`0Hooooo`004oooool00ol0003o
ooooooooo`0Tooooo`03o`000?oooooooooo00cooooo1?l00002oa809`?o00000_m715<00ol0003o
F19IoePBF@02o`0000GoL31_00?o0000og`iL_ml>G800_ml>G83o`0000GoRdj000?o0000oi=DPOnC
E8401?nCE8400ol0003oVeZ2oi]JPP04oi]JPP04o`000?nQGh;oXEn2oj5OPP[o00000_n/KX`00ol0
003o/G:<ok5bS006ok5bS003o`000?nfMX_o000000[o000000?o_7F2o`000?o0N8800_o0N8800ol0
003oa7b2olAlPP04olAlPP04o`000?o8Oh7ob7n1o`0000Coc8:000?o0000om26Ooo@QWl01?l00000
0ooCPG;o0000omR5L004omR5L0;o00001?oLOUX01Ol0003oi8ECo`000?l0003ohgP_00Co00000_oV
V7L00ol0003oiYQgo`000003oo6SK003o`000?oi[5So000000;o00006?ooool00ol0003ooooooooo
o`0Hooooo`004_ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo00_ooooo0ol00002
oa809`?o00000_m715<01_l0003oF19Io`000?l0003oHbE[o`0000GoL31_00?o0000og`iL_l00000
0_l000000on2AWko0000oh]>P005oh]>P003o`000?nCE87oTeB100CoTeB100Co0000oi]JP_nKFX;o
VeZ21ol00004ojAWR`04o`000?nYK8_oZFb;o`0000Co[6j<00?o0000ok5bS?naLX`01_naLX`00ol0
003o]WJ;o`000006okUiS004o`000?nmO8_o_Gb;okelR`So00001?o4O8801?l0003ob7n1olQoPOl0
0004olb2P003o`000?o@QWood8Io00;od8Io1?l00005omR5L004o`000?oNRFco0000o`0000;og7iJ
00Co0000onB5DooTQE?oi8EC0ol000000ooKSgco0000onJHM`02onJHM`;o00000ooaXf`3o`000003
oo6[=?l0003ooooo01Sooooo00?o0000ooooooooool05oooool001;ooooo00?o0000ooooooooool0
9oooool00ol0003oooooooooo`09ooooo`Co000000Co4P0Wo`000?l0003o00000om715<2o`0000?o
HbE[00?o0000og0`Kom`<6l00_m`<6l3o`0000CoPTIn00?o0000oh]>P?n;CX001?n;CX000ol0003o
TeB1oi=DP@02oi=DP@Ko00000onNHh/00ol0003oY6N;ojAWR`05ojAWR`03o`000?nYK8_o000000Go
[6j<00?o0000ok5bS?naLX`01_naLX`00ol0003o]WJ;o`000006okUiS003o`000?nmO8_o_Gb;00;o
_Gb;00Go0000ol5oRoo1Oh_o`Gn;o`000002olB2R`?o000000Goa7b2o`000?o8Oh7ob7n1o`000004
olb2P003o`000?o@QWood8Io00;od8Io0_l000000ooCRGko0000o`000004omR5L007o`000?oNRFco
gXU/omj9K?l0003og7iJo`000003onB5D`03o`000?oYR4[o000000;ofhml00Go0000onJHMooVV7Oo
iYQgo`000003oo6SK0?o000000?olJ/do`000?ooool06Oooool00ol0003oooooooooo`0Fooooo`00
4_ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00Oooooo0ol000001_l001[o0000
o`000?l0003o<`1<o`0000;oA`AC0_l00004of<UJ`03o`000?m`<6ooL31_00;o000000?oN3ilo`00
0?n2AWh01?n2AWh00ol0003oRdj0oh]>P004oh]>P003o`000?nCE87o000000;o00000_nGGH/00ol0
003oWV>;oiiSR`04oiiSR`03o`000?nTIh_oY6N;00GoY6N;00?o0000ojU/Rol000001On/KX`00ol0
003o/G:<ok5bS006ok5bS003o`000?nfMX_o000000Ko^GV<00?o0000okelRonmO8/00_nmO8/01Ol0
003o`Gn;ol5oRoo1Oh_o000000Goa8:;1Ol00005olb2P004o`000?o@QWood8Ioom26O`;o000000?o
dhUno`000?oISGd00ol00002omR5L004o`000?oNRFcogXU/omj9K0?o00000_oTQE<01_l0003ojHQ:
onV8B_l0003ofhmlo`0000?oiYQg0_l00002oo6SK005o`000?oi[5So0000oo6[=?l000006_ooool0
0ol0003oooooooooo`0Fooooo`004_ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo
00Kooooo0_l000000ol001[o0000o`000003oc<0C0?o000000?oE1UWo`000?mS9F/00omS9F/3o`00
00?oN3il00?o0000oh96O_n2AWh00on2AWh00ol0003oRdj0oh]>P002oh]>P0Co00001OnGGH/00ol0
003oWV>;oiiSR`04oiiSR`03o`000?nTIh_oY6N;00GoY6N;00?o0000ojU/Rol000001On/KX`00ol0
003o/G:<ok5bS006ok5bS0;o00001oniNH`00ol0003o_Gb;okelR`02okelR`05o`000?o1Oh_o`Gn;
ol5oRol000001_o4PX/00ol0003ob8J;olR6R`04o`0000;oc8:000Co0000om26Ooo@QWood8Io0_l0
00000ooCRGko0000omV=O@03omV=O@?o00000ooNRF`2o`000004onJ@I_l0003oi8ECo`0000?ojHQ:
0_l00003onJHM`09o`000?oaXfco0000oo6SK?l0003onJaHo`000?oaZcCo000001_ooooo00?o0000
ooooooooool05Oooool001;ooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`04oooo
o`;o000000Co000Jo`000?l0003o00000_lc04`2o`0000?oE1UW00Co0000of<UJomS9F_oHbE[0_l0
0005ogPnO003o`000?n2AWkoPTIn00?oPTIn00?o0000oh]>P?l000000_l00002oi1HRP03o`000?nG
GH_oUef;00CoUef;00?o0000oiiSRonNHh/01?nNHh/00ol0003oY6N;ojAWR`05ojAWR`;o00001_n/
KX`00ol0003o/G:<ok5bS006ok5bS0;o00001oniNH`00ol0003o_Gb;okelR`02okelR`03o`000?o1
Oh_o`Gn;00;o`Gn;00?o0000olB2Roo4PX/00oo4PX/01?l0003ob8J;olR6Rol00003olb8RPGo0000
00?od8Ioo`000?o@QWl00_l00006omV=O@;o00000_oNRF`2o`0000;oiY1V00?o0000onB5Dol00000
0ooYR4X2o`0000;oiYQg00?o0000oo6SK?oaXf`00_l000001?oi[5So0000o`000?l0000Looooo`03
o`000?oooooooooo01Cooooo000Booooo`03o`000?oooooooooo02_ooooo00?o0000ooooooooool0
0_ooool4o`000004oa00>_l0003o<`1<oc<0C0;o00000omD6FL00ol0003oHbE[of<UJ`02o`000003
of`dN_l0003oN3il00?oN3il00?o0000oh96O_n2AWh00_n2AWh4o`0000GoT5R:00?o0000oiMMRonG
GH/01?nGGH/00ol0003oWV>;oiiSR`04oiiSR`04o`000?nTIh_oY6N;ojAWRb;o000000?o_Gb;o`00
0?o1Oh/00oo1Oh/00ol0003oa8:;olB2R`03olB2R`04o`000?o8QX_ob8J;o`0000Goc8R:00?o0000
om2=ROo@SHT01Ol00006omV=O@03o`000?oNTG[o000000;o000000Coh8a[o`000?oVT6KoiY1V0_l0
0003onV8BP03o`000?oVV7Oo000000;oiYQg00Go0000oo6SK?oaXfco0000ooV/F003o`0001cooooo
00?o0000ooooooooool05?ooool001;ooooo00?o0000ooooooooool0;?ooool00ol0003ooooooooo
o`04o`000007oa00>_l0003o0000oc<0C?l0003o@`]Qo`000003oe@II`?o00000om/=7X00ol0003o
N3ilogPnO002ogPnO003o`000?n2AWko000000;o00000_n7DHT00ol0003oT5R:oi1HRP04oi1HRP03
o`000?nGGH_oUef;00CoUef;00Co0000oiiSRonNHh_oWV>;1ol00004ojI^T`;o00001_n]MI<00ol0
003o/WRCok9hT`06ok9hT`;o00001oniOY<01?l0003o_H:Cokf2TonmPY<5o`000003ol5oRol0003o
a8:;00?oa8:;00Go0000olR6Roo8QX_ob8J;o`000005olb8RP06o`000?o@SHWod8f9om2=ROl0003o
d8f90_l00006omV=O@04o`000?oNTG[ogY5jomjANP?o00000ooVT6H2o`0000;ojHQ:00Ko0000onJH
MooVV7Oo0000onJHMol00002oo6SK003o`000?oi[5SonJaH00;o00007Oooool00ol0003ooooooooo
o`0Cooooo`004_ooool00ol0003oooooooooo`0]ooooo`03o`000?oooooo000000;o00000_l@03X0
0ol0003o<`1<o`000002od<;H@03o`000?mD6FOoE1UW00;o00001Om/=7X01?l0003oN3ilogPnO?mh
?W`3o`0000GoQe6900?o0000oi1HR_n@F8X01?n@F8X00ol0003oUef;oiMMR`02oiMMR`Ko00000onP
JY<00ol0003oYVjCojI^T`05ojI^T`03o`000?n]MI?o[GFC00Go[GFC00?o0000ok9hTonbN9<01_nb
N9<00ol0003o^GjCokUnT`06okUnT`03o`000?nmPY?o_H:C00;o_H:C00Co0000ol65Too1QI?o`HFC
1Ol000000oo4PX_o0000olR6R`03olR6R`03o`000?o<R8[oc8R:00;oc8R:00Ko0000om2=ROo@SHWo
d8f9o`000?o@SHT3o`0000GofHem00Ko0000omjAN_oNTG[ogY5jo`000?oPTgT2o`0000;oiY1V00Ko
0000on^DH?l0003o0000onV8B_l00002onJHM`;o00000_oaXf`2o`000003ooV/F?l0003o000001go
oooo0_l0000Dooooo`004Oooool00ol0003oooooooooo`0_ooooo`?o00000ol@03X2o`0000;o@`]Q
00Ko0000oe@IIol0003o0000oelZMol00004of`dNP03o`000?mh?WcoN3il00;o000000?oOTZ8o`00
0?n7DHT01On7DHT00ol0003oT5R:oi1HRP04oi1HRP03o`000?nGGH_o000000;o00000_nJII<00ol0
003oX6ZCoj1ZT`04oj1ZT`03o`000?nVKY?oYVjC00GoYVjC00?o0000ojeeTon]MI<01On]MI<00ol0
003o/WRCok9hT`06ok9hT`03o`000?niOY?o^GjC00Ko^GjC00Go0000okf2TonmPY?o_H:Co`000005
ol65T`04o`000?o5Qi;oaHNBolF7TPGo000000?ob8J;o`000?o<R8X00_o<R8X00ol0003od8f9om2=
R@02om2=R@05o`000?o@SHWo0000o`000?oHThL00ol00002omV=O@0;o`000?oNTG[ogY5jomjAN_l0
003oh9=io`000?oVV7Ko0000onJ@I_l000000oo[U603o`0000;oiYQg0_l000000ooaXfco0000ooV/
F003o`0001[ooooo0ol000000ooooooo0000ooooo`0Cooooo`004Oooool00ol0003oooooooooo`0_
ooooo`?o00000_l@03X2o`0000?o@`]Q0_l00003oelZM`03o`000?m/=7[oK3Aj00;oK3Aj0ol00003
ogi:R003o`000?n7DHWoQe6900CoQe6900?o0000oi1HR_n@F8X00_n@F8X4o`0000GoVVFC00?o0000
oj1ZTonPJY<01?nPJY<00ol0003oYVjCojI^T`04ojI^T`;o00002?n]MI<00ol0003o/WRCok9hT`05
ok9hT`03o`000?niOY?o^GjC00Oo^GjC00Co0000okf2TonmPY?o00001Oo1QI<00ol0003oaHNBolF7
TP02olF7TP04o`000?o8Ri?ob8^ColR;T`Co000000?oc8R:o`000?o@SHT00oo@SHT01?l0003od8f9
o`000?l00004omRCQ`?o00000ooNTGX00ol0003oh9=io`000002onJHMP03o`000?oVT6Ko000000?o
jiAP00[o0000onb9?OoVV7OoiYQgo`000?oaXfco0000oo6SK?l0003onJaH0ol0000Fooooo`?o0000
1?ooool00ol0003oooooooooo`0Booooo`004Oooool00ol0003oooooooooo`0^ooooo`Co000000Co
400jo`000?l0003o00000_m32f42o`0000CoGbYg00Co0000of`dN_m/=7[oK3Aj0_l00005ogi:R003
o`000?n7DHWoQe6900CoQe6900?o0000oi1HR_l000000_l00002oi=PT`03o`000?nJII?oVVFC00Co
VVFC00?o0000oj1ZTonPJY<01OnPJY<00ol0003oYVjCojI^T`03ojI^T`03o`000?nXLICo000000Oo
[GFC00?o0000ok9hTonbN9<01?nbN9<00ol0003o]G^Do`000008okUnT`04o`000?nmPY?o_H:Co`00
00Go`HFC00?o0000olF7T_o5Qi800_o5Qi800ol0003ob8^ColR;T`02olR;T`03o`000?o<SY;oc8jB
00Co00000_o@SHT01?l0003od8f9o`000?l00006omRCQ`;o00000_oNTGX00ol0003oh9=io`000003
onJHMP;o00000oo[U603o`000004onJHMol0003olJ=/oo6SK0;o000000ConJaHo`000?oaZcCo0000
4oooool3o`0000Oooooo00?o0000ooooooooool04_ooool0017ooooo00?o0000ooooooooool0;_oo
ool3o`000003oa00>_l0003o9@1E00;o000000Co@`]Qo`000?m@7W;o00001?mO:WL01_l0003oK3Aj
o`000?l0003oLd:6o`0000GoOTZ800?o0000ohMAROn7DHT00_n7DHT4o`0000GoTf2C00?o0000oiYU
TonJII<01?nJII<00ol0003oX6ZCoj1ZT`05oj1ZT`03o`000?nVKY?oYVjC00?oYVjC00?o0000ojQa
U?l000000on]MI<Co`0000?o^GjC00?o0000okf2Tol000001oo1QI<01Ol0003oaHNBolF7T_o5Qi;o
000000Cob8^C00Go0000olb>T_o<SY;oc8jBo`000002om2BTP?o000000?od8f9o`000?l000001_oH
ThL00ol0003ogIR6o`000002o`000003on2CNOl0003oiYQf00?oiYQf0_l00002on^DH003o`000?o`
V5Oo000000;o00000ooaXf`00ol0003onJaHo`000002o`00013ooooo0ol0000:ooooo`03o`000?oo
oooooooo01;ooooo000Aooooo`03o`000?oooooooooo02gooooo0_l000001?l002ko0000o`000?lU
05D2o`000005od<;HOl0003oD1iboe0NL_l000001?mO:WL2o`0000?oLd:600?o0000ogi:R?mnBXP0
0omnBXP00ol0003oQe69o`000002o`0000;oS5ZB00?o0000oi=PTonCH9<01?nCH9<00ol0003oVVFC
oiYUT`04oiYUT`03o`000?nPJY?oX6ZC00?oX6ZC3_l00004ojijVP03o`000?ncOI[o/gfJ00Co/gfJ
00?o0000okJ1Vol000001OnjQ9X:o`0000?o`HFC00Co0000olF7T_o5Qi;o00001Oo8Ri<01Ol0003o
c8jBolb>T_o<SY;o000000Cod9:B1?l00006omRCQ`04o`000?oMV8KogIR6omfHQP?o00001?oVV7H0
1ol0003ok9ebo`000?l0003ojiAPo`000?o`V5L00_l00003oo6SK003o`000?oi[5So000000;o0000
3Oooool3o`0000gooooo00?o0000ooooooooool04_ooool0017ooooo00?o0000ooooooooool0;Ooo
ool2o`000004o`00;_l0003o9@1EobD0E@?o00000om@7W801?l0003oGbYgoelZMomO:WL2o`0000Co
Ld:600?o0000ogi:R?mnBXP00_mnBXP3o`0000GoS5ZB00?o0000oi=PTonCH9<01?nCH9<00ol0003o
VVFCoiYUT`04oiYUT`03o`000?nPJY?o000000?o00000_nRL9X00ol0003oYgBIojMdV@02ojMdV@04
o`000?nYMi_oZGNKo`0000Oo[WZJ00?o0000ok=mV_ncOIX00oncOIX01?l0003o]X6KokJ1Vol00008
okZ4VP03o`000?nnQYWo000000Co`HZJ1ol00006olR;T`04o`000?o<SY;oc8jBo`0000Cod9:B00?o
0000om2BT_l000000_l00005omRCQ`06o`000?oMV8KogIR6omfHQ_l0003oh9Z50_l00003onJHMP04
o`000?o/WG;ok9ebonbMLP;o00000_o`V5L01?l0003olJ=/oo6SK?oaXf`3o`000003oo6[=?l0003o
oooo00Wooooo0ol0000Aooooo`03o`000?oooooooooo017ooooo000Aooooo`03o`000?oooooooooo
02cooooo0ol000001_l002ko0000obD0EOlU05Go<01Jo`0000?oD1ib00?o0000oelZMomO:WL00_l0
00000omW>HCo0000og=2QP03og=2QP03o`000?mnBXSoOTZ800;o000000?oPeBAo`000?n<FY801On<
FY800ol0003oTf2Coi=PT`04oi=PT`04o`000?nJII?oVVFCoiYUT`Go00001_nRL9X01Ol0003oYgBI
ojMdVOnWM9Wo000000?oZGNK00?o0000ojijV_n^NYX01On^NYX00ol0003o/gfJok=mVP03ok=mVP04
o`000?nfPI_o]X6Ko`0000So^XBJ00?o0000okj6VOl000001oo1RYX00ol0003oaHbIolF<V@03o`00
00Cob8^C00?o0000olb>T_l000001Oo@TY801Ol0003od9:Bom2BT_l0003oeiVA00?o00000_oHThL0
2?l0003ogIR6omfHQ_oMV8Ko0000on2JQOl0003oiIn30_l00002onJHMP05o`000?o/WG;ok9ebonbM
L_l000000_o`V5L2o`0000;olJ=/0ol000000ooaZcCo0000ooooo`06ooooo`?o00005?ooool00ol0
003oooooooooo`0Aooooo`004Oooool00ol0003oooooooooo`0[ooooo`?o000000Co000^o`000?l0
003o9@1E0ol00003oe0NLP?o00000omW>H@00ol0003oLd:6og=2QP02og=2QP?o00000on3E9400ol0
003oS5ZBohaJTP04ohaJTP03o`000?nCH9?oTf2C00;oTf2C1_l00003oia/VP03o`000?nRL9[oXW2J
00GoXW2J00Go0000ojMdVOnWM9WoYgBIo`000003ojUgV`03o`000?n^NY[o[WZJ00Ko[WZJ00Go0000
ok=mV_ncOI[o/gfJo`000004okJ1V`03o`000?njQ9[o^XBJ00Ko^XBJ00?o0000ol6:V_o1RYX01_o1
RYX01?l0003oaHbIolF<VOl00002olR@VP?o000000Cob8^Co`000?o<SY;o00001Oo@TY801?l0003o
d9:Bom2BT_l00004omNIT@?o00000ooMV8H00ol0003oh9Z5o`000003onFOP`?o00000oo/WG82o`00
0003oo2HEol0003o000000;olJ=/00Go0000ooV/F?l0003olJ/do`000004ooooo`?o00005oooool0
0ol0003oooooooooo`0Aooooo`004?ooool00ol0003oooooooooo`0/ooooo`Co000000Ko3@1;o`00
0?lU05Go0000oclAKOl00003oe0NLP03o`000?mW>HCoIcV400?oIcV400Co0000og=2Q_mc@XKoLd:6
0_l00005oh=DT@03o`000?n<FY;oS5ZB00CoS5ZB00?o0000oi=PTol000000_l00002oiIWVP03o`00
0?nLK9[oW6bJ00CoW6bJ00?o0000oj9`V_nRL9X01_nRL9X00ol0003oYgBIo`000005ojUgV`03o`00
0?n^NY[o[WZJ00Go[WZJ00Go0000ok=mV_ncOI[o/gfJo`000004okJ1V`03o`000?njQ9[o^XBJ00Ko
^XBJ00?o0000ol6:V_o1RYX01_o1RYX00ol0003oaHbIo`000006olR@VPGo00001?o@TY801?l0003o
d9:Bom2BT_l00006omNIT@;o00000ooMV8H2o`0000GoiIn300So0000onbML_o/WG;ok9ebo`000?oa
Xfco0000oo2HE`;o000000OolJ=/o`000?oi[5So0000oo6[=?l0003ooooo00?o00006_ooool00ol0
003oooooooooo`0Aooooo`004?ooool00ol0003oooooooooo`0[ooooo`;o000000Co000?o`000?l=
04_o3@1;0ol000001?lo4Fgo0000oe0NL_m@7W82o`0000GoIcV400Ko0000og=2Q_l0003o0000ogU=
T?l00006oh=DT@03o`000?n<FY;oS5ZB00;oS5ZB0ol00005oiIWVP03o`000?nLK9[oW6bJ00CoW6bJ
00?o0000oj9`V_nRL9X01_nRL9X2o`0000KoZGNK00?o0000ojijV_n^NYX01On^NYX01Ol0003o/gfJ
ok=mV_ncOI[o000000Co]X6K00?o0000okZ4V_njQ9X01_njQ9X00ol0003o`HZJol6:VP07ol6:VP;o
00001oo8T9X01?l0003obi:Io`000?o?UiX3o`000005om2BT_l0003od9:Bom2BT_l000001_oGVI40
0ol0003og9jAo`000004o`0000GoiIn30_l00002onbMLP03o`000?oaXfcolJ=/00?o000000?olJ=/
o`000?oi[5P01?l0000Mooooo`03o`000?oooooooooo017ooooo000@ooooo`03o`000?oooooooooo
02_ooooo00Co0000o`003ol0003o00000_l=04/02Ol0003o=`Y[o`000?lo4Fgo0000oe0NL_l0003o
FRj1o`000005ofLiQ0;o00000omiCI000ol0003oPeBAoh=DT@04oh=DT@03o`000?n<FY;oS5ZB00;o
000000?oSf:Jo`000?nFIiX01OnFIiX00ol0003oW6bJoia/VP05oia/VP03o`000?nRL9[oXW2J00Go
XW2J0_l00006ojUgV`04o`000?n^NY[o[WZJojijVQ;o00000onjQ9X2o`0000Wo`HZJ0_l00007olR@
VP03o`000?o;TYWo000000CociNJ1?l000000ooDUi;o0000omNIT@04omNIT@03o`000?oLWY7og9jA
00;og9jA0_l00005onFOP`05o`000?o[YH7o0000onbML_l000000ooaXf`2o`000003oo6SK?l0003o
nJaH00?o00007_ooool00ol0003oooooooooo`0Aooooo`004?ooool00ol0003oooooooooo`0[oooo
o`04o`000?l000oo0000o`0000;o3@1;00Co0000ocL:Jol0003o?a5]0_l00002oeX^P@03o`000?mW
>HCoIcV400;oIcV40_l00004ogU=T003o`000?n3E97oPeBA00CoPeBA0ol00003ohmRVP03o`000?nF
Ii[oUVNJ00GoUVNJ00?o0000oia/V_nLK9X01?nLK9X00ol0003oXW2Joj9`VP02oj9`VPoo00001?n_
Oj001?l0003o/h:Ook>2Wol00005okJ5X@03o`000?njR:3o^XRP00;o^XRP2?l00006ol6:VP03o`00
0?o8T9[ob92J00Oob92J00?o0000olnGV_o?UiX01Oo?UiX5o`0000CoeiVA00?o0000ombNTOoLWY40
0_oLWY43o`0000CoiIn300?o0000on^UPOo[YH400_l00003oo6SK0Co00000_oi[5P2o`0001kooooo
00?o0000ooooooooool04Oooool0013ooooo00?o0000ooooooooool0:_ooool5o`000004o`d0Bol0
003o0000ocL:J`?o00000omJ;X400ol0003oIcV4ofLiQ002o`000003ofm5Sol0003oNDf@00CoNDf@
00?o0000oh=DTOn3E9400_n3E942o`0000GoSf:J00?o0000oiIWV_nFIiX01OnFIiX00ol0003oW6bJ
oia/VP04oia/VP03o`000?nRL9[o000000;o00000_nTMZ02o`0000OoZgbQ00?o0000ojmoX?n_Oj00
1_n_Oj02o`0000Ko]XFQ00?o0000okZ8X?njR:001?njR:000ol0003o_HbRo`000003ol6>X0Go0000
00?o`HZJo`000?o8T9X02?o8T9X00ol0003ociNJolnGVP05olnGVP;o000000?odi^Jo`000?oFWIT0
0_l000000ooGVI7o0000ombNT@05ombNT@04o`000?oTY8ko0000o`0000;oiIn300Co0000on^UPOo[
YH7ojjF10_l00002oo6SK003o`000?ofZ6Co000000;o000000?onJaHo`000?l000007_ooool00ol0
003oooooooooo`0Aooooo`004?ooool00ol0003oooooooooo`0Zooooo`;o000000[o000do`000?l=
04_o0000ob40Hol0003o=`Y[o`000?m;8ggo00000omJ;X43o`0000?oKdF?00?o0000ogU=T?miCI00
0omiCI000ol0003oPeBAo`000002o`000003ohMMV_l0003oSf:J00GoSf:J00?o0000oiIWV_nFIiX0
1?nFIiX01?l0003oW6bJoia/V_nLK9X5o`0000CoY7JP00?o0000ojEiX_l000001on[O:400ol0003o
[gnPojmoX006ojmoX003o`000?nfQJ7o]XFQ00Go]XFQ00?o0000okZ8X?njR:000onjR:001?l0003o
_HbRokf<X_l00008ol6>X0Co00001oo8T9X00ol0003ociNJolnGVP05olnGVP04o`000?oCVi[odi^J
o`0000?oeYfI0_l00006ombNT@04o`000?oTY8koi:B>onBTSP?o00000oo[YH401Ol0003olJ]mo`00
0?oaXfco000000;omZQT00?o0000ooBL>ol000000_l0000Nooooo`03o`000?oooooooooo017ooooo
000@ooooo`03o`000?oooooooooo02Wooooo0_l000001ol003Co0000o`000?l0003o8@1So`000?lg
2V/00_l000000om;8ggo0000oeX^P@02oeX^P@03o`000?m_AHooKdF?00?oKdF?00?o0000ogU=T?mi
CI000_miCI03o`0000CoQefJ00?o0000ohmRV_n?HYX01?n?HYX00ol0003oUVNJoiIWVP02oiIWVPKo
00000onNLZ000ol0003oY7JPojAfX002ojAfX004o`000?nUNJ;oYGVRo`0000OoZgbQ00?o0000ojmo
X?n_Oj001_n_Oj000ol0003o]XFQokJ5X@05okJ5X@03o`000?njR:3o^XRP00?o^XRP00Go0000okf<
X_nmS:;o_HbRo`000008ol6>X003o`000?o8U:3ob9BP00Go000000Cob92Jo`000?o<U9_o00001_o?
UiX01Ol0003odi^Jom>KV_oCVi[o000000?oeYfI0_l00005ombNT@03o`000?oTY8koi:B>00?oi:B>
00Go0000on^UPOo[YH7ojjF1o`000002oo6[O@03o`000?oaXfco000000;omZQT1Ol0000Nooooo`03
o`000?oooooooooo013ooooo000@ooooo`03o`000?oooooooooo02Wooooo0_l000000ol003Co0000
o`000002ob40H`;o000000CoAAilo`000?m;8ggo00000_mJ;X42o`0000GoKdF?00?o0000ogU=T?mi
CI000_l000000omnEiWo0000ohMMVP04ohMMVP03o`000?n?HY[oSf:J00CoSf:J00?o0000oiIWV_l0
00000_l00002oiQ^X@03o`000?nNLZ3oWW:P00CoWW:P00Go0000ojAfX?nTMZ3oY7JPo`000003ojEi
XP03o`000?n[O:7oZgbQ00KoZgbQ00?o0000ojmoX?n_Oj001?n_Oj02o`0000So]XFQ00Go0000okZ8
X?njR:3o^XRPo`000004okf<XP03o`000?o1SZ3o`HjP00Go`HjP0_l00007olRDX0Ko00001?o?UiX0
1Ol0003odi^Jom>KV_oCVi[o000000?oeYfI00Co0000om^RVOl0003o00000ooLWY400ol0003oi:B>
onBTSP03onBTSP;o00000_o[YH401?l0003olJ]moo6[OOoaZgd2o`0000;omZQT00Go0000ooV/F?oa
ZcColJ/do`00000Nooooo`03o`000?oooooooooo013ooooo000?ooooo`03o`000?oooooooooo02[o
oooo0_l000000ol003Co0000o`000002ob40H`04o`000?m57WcoAAilodDNO0;o000000CoFRj1o`00
0?mS?8co00001Om_AHl3o`0000?oOUNI00?o0000ohMMV_n7GIX01?n7GIX00ol0003oSf:JohmRVP02
ohmRVP?o00001OnHKZ400ol0003oWW:PoiibX005oiibX003o`000?nTMZ3o000000GoYGVR00?o0000
oj]lXOn[O:401On[O:400ol0003o[gnPojmoX003ojmoX003o`000?nbPj;o000000So]XFQ00Go0000
okZ8X?njR:3o^XRPo`000004okf<XP03o`000?o1SZ3o`HjP00Go`HjP00?o0000olBBX_l000001oo8
U:000ol0003obiVRo`000002oljJX0Go00000ooCViX01Ol0003oeYfIomJMVOoFWIWo000000?ofj:I
0ol000000ooRXi3o0000onBTSP03onBTSP05o`000?oYZXgo0000on^UPOl000001?oaZgd00ol0003o
mZQTooJXI003o`000003oo6[=?l0003ooooo01gooooo00?o0000ooooooooool04?ooool000oooooo
00?o0000ooooooooool0:Oooool2o`000005o`00=?l0003o0000o`000?lQ06<00_l00003odDNO003
od/SOOl0003o000000;oHcb<00?o0000ofm5Som_AHl00_m_AHl2o`0000GoOUNI00?o0000ohMMV_n7
GIX01?n7GIX00ol0003oSf:Jo`000002o`000003oi9YXOl0003oV6jQ00GoV6jQ00?o0000oiibX?nN
LZ001OnNLZ02o`0000KoYGVR00?o0000oj]lXOn[O:401On[O:400ol0003o[gnPojmoX003ojmoX003
o`000?nbPj;o000000So]XFQ00Go0000okZ8X?njR:3o^XRPo`000004okf<XP03o`000?o1SZ3o`HjP
00Co`HjP00Co0000olBBX_o4TZ;o00001_o8U:001?l0003obiVRol^IX_l00005oljJX0?o00000_oC
ViX01Ol0003oeYfIomJMVOoFWIWo000000Gofj:I0ol00004onBTSP03o`000?oYZXgojJZ=00;o0000
1?oaZgd00ol0003omZQTooJXI005o`0001kooooo00?o0000ooooooooool04?ooool000oooooo00?o
0000ooooooooool0:Oooool3o`000006o`00D_l0003o8@1So`000?lb47Ko00000om57W`2o`0000Co
Hcb<00Ko0000ofm5Sol0003o0000ogE?V?l00005ogiGV@03o`000?n7GI[oQefJ00?oQefJ0ol00004
oi9YX@03o`000?nHKZ7oV6jQ00GoV6jQ00?o0000oiibX?nNLZ000onNLZ02o`0000OoYGVR00Co0000
oj]lXOn[O:7oZgbQ7Ol00002okf<XP03o`000?o1SZ3o`HjP00;o`HjP00Go0000olBBX_o4TZ;oa9:R
o`000006olRDX005o`000?o;VJ;obiVRol^IX_l000001?o>VZ02o`000003om:OXOl0003o000000;o
000000?oeYfIo`000?oKXYT01OoKXYT01?l0003oh:RIo`000?l00002onBTSP03o`000?oYZXgojJZ=
00;ojJZ=00?o0000oo6[OOoaZgd00_oaZgd2o`000003ooJXI?l0003onJaH00Co00007Oooool00ol0
003oooooooooo`0@ooooo`003oooool00ol0003oooooooooo`0Yooooo`;o000000Co001Bo`000?l0
003o00000_lb47H00ol0003oAAilodDNO003o`0000CoHcb<0_l00003ogE?V003o`000?mnEiWoOUNI
00?oOUNI00?o0000ohMMV_n7GIX00ol000000on;I:7o0000oi9YX@04oi9YX@03o`000?nHKZ7oV6jQ
00GoV6jQ00?o0000oiibX?nNLZ000_nNLZ000ol0003oX7FRo`000003ojEiXPSo00001?n/PJH01Ol0
003o/8BUok24YOn`Q:Go000000?o/XNW00?o0000okN:Y_ngRZH01_ngRZH01?l0003o^XbUokZ<YOl0
0004okf@Y`Go00000_o1SZ001Ol0003oa9:RolBBX_o4TZ;o000000Gob9BP00?o0000ol^IX_o;VJ80
0_o;VJ800ol0003ocYZPoljJX002oljJX0;o00001?oBWj43o`0000Kofj:I00Co0000on2XVOl0003o
hZVG0ol00004onVZS@;o00000ooaZgd00ol0003omk5go`000003o`000003onjI9_l0003o000001go
oooo00?o0000ooooooooool04?ooool000oooooo00?o0000ooooooooool0:?ooool3o`000003o`00
D_l0003o000000?o<Q1f00?o0000odDNO?l000000_mA<8X01?l0003oHcb<of<lS?mS?8`2o`0000Co
MDnH00?o0000ogiGVOmnEiT00omnEiT3o`0000CoRfBQ00?o0000oi9YXOnBJJ401?nBJJ400ol0003o
V6jQoiQ^X@04oiQ^X@04o`000?nNLZ3oWW:PoiibX0Oo00001?nWOZL00ol0003o[86Vojb1YP05ojb1
YP04o`000?n`Q:Go/8BUo`0000Co/XNW00?o0000okN:Y_ngRZH01ongRZH2o`0000Oo_I2W00?o0000
ol6BY_o1TZH01Ol00002olBBXP03o`000?o8U:3ob9BP00;ob9BP00?o0000ol^IX_o;VJ800_o;VJ80
1ol0003ocYZPoljJX?o>VZ3o0000om:OXOl000001?oBWj401?l0003oeJ6Oo`000?l00005om^RV@04
o`000?oPZ9Woh:RIo`0000;ohZVG0_l00003onVZS@05o`000?o_/H_o0000oo6[OOl000000_og/GL5
o`000003onjI9_l0003ooooo01cooooo00?o0000ooooooooool04?ooool000oooooo00?o0000oooo
ooooool0:?ooool3o`000003o`00D_l0003o000000?o<Q1f0_l00003oe4`RP06o`000?mS?8coHcb<
o`000?mZAiKo00001OmeCiP01?l0003oOUNIogiGVOmnEiT2o`0000KoRfBQ00?o0000oi9YXOnBJJ40
1?nBJJ400ol0003oV6jQoiQ^X@02oiQ^X@Oo00000_nQNZP00ol0003oYgjWojMnY`05ojMnY`03o`00
0?n/PJKo[86V00Ko[86V0_l00006ok:7Y`03o`000?ngRZKo]hZV00Ko]hZV00?o0000okf@YonmT:L0
1_nmT:L01Ol0003o`I:Vol6BY_o1TZKo000000?oa9JW1Ol00002olRDX003o`000?o;VJ;obiVR00;o
biVR00Oo0000oljJX?o>VZ3ocYZPo`000?oBWj7o000000CodYnQ00Co0000omFQWol0003ofZJP0_l0
0002om^RV@05o`000?oPZ9Woh:RIon2XVOl000000_oRZIL00ol0003oj:nGo`000002onVZS@03o`00
0?o_/H_okk6;00Co000000Gomk5go`000?oi[5So0000ooV]B003o`0001cooooo00?o0000oooooooo
ool04?ooool000oooooo00?o0000ooooooooool0:?ooool3o`000003o`00D_l0003o000000?o<Q1f
00?o0000oe4`R_mA<8X00_mA<8X3o`0000;oJTNF00?o0000ogE?V?meCiP00omeCiP01_l0003oOUNI
o`000?l0003oPenPo`0000KoRfBQ00?o0000oi9YXOnBJJ401?nBJJ400ol0003oV6jQo`000002o`00
00;oVW>V0_l00005oj5jZ003o`000?nWOZOoYgjW00GoYgjW00?o0000ojb1Y_n/PJH01_n/PJH00ol0
003o/XNWok:7Y`05ok:7Y`03o`000?ngRZKo]hZV00Ko]hZV00?o0000okf@YonmT:L01_nmT:L01?l0
003o`I:Vol6BY_l00006olBFY`03o`000?o7V:KoaiRV00Ko00000_o;VJ801_l0003ocYZPoljJX?l0
003odYnQo`0000GodYnQ00?o0000omZVX?oJYZ000_oJYZ03o`0000?oh:RI00Co0000on:YUooRZIOo
00000_oX[iL00ol0003ojJZ=o`000002onnaR`Co000000KolJ=/ooV/F?l0003onJaHo`000?oi[DP2
o`0001cooooo00?o0000ooooooooool04?ooool000oooooo00?o0000ooooooooool0:?ooool00ol0
003o0015o`000003o`0000;o<Q1f0_l00004oe4`RP;o00000omZAiH00ol0003oMDnHogE?V003ogE?
V0;o00000on3Gj000ol0003oRfBQoh]TX@05oh]TX@03o`000?nBJJ7oTVVQ00;oTVVQ0ol00004oiYc
YP;o00001onQNZP00ol0003oYgjWojMnY`04ojMnY`03o`000?n/PJKo[86V00Go[86V0_l00007ok:7
Y`03o`000?ngRZKo]hZV00Go]hZV0_l00009okf@Y`;o00002?o4UZL01?l0003oaiRVolNHY_l00004
ol^LY`Go00000_oBWj400ol0003odYnQom:OX@03om:OX@03o`000?oJYZ3ofZJP00CofZJP0_l00003
on2XV@03o`000?oRZIOo000000?oj:nG1?l000000ooVV7Oo0000oo6SK002oo6SK005o`000?oi[5So
0000o`000?oi[DP00_l0000Mooooo`03o`000?oooooooooo00oooooo000>ooooo`03o`000?oooooo
oooo02Wooooo00?o0000o`00AOl000000ol000001?lb47Ko0000od0SQ_l00003oe4`RP;o000000Go
IdNHo`000?mZAiKoJTNFo`000004ogE?V0;o00001?n3Gj000ol0003oRfBQoh]TX@05oh]TX@03o`00
0?nBJJ7oTVVQ00;o000000?oU6nVo`000?nJLjH00_nJLjH2o`000003oi]fZ?l0003oXGZX00KoXGZX
00?o0000ojMnYonWOZL01OnWOZL00ol0003o[86Vojb1YP03ojb1YP03o`000?n^Q:So000000Oo/XNW
00?o0000okN:Y_ngRZH01?ngRZH01?l0003o^HfXokV=Z?l00008okf@Y`;o00002?o4UZL00ol0003o
aiRVo`000007ol^LY`06o`000?o>WZKo0000o`000?oBWj7o00001OoBWj400ol0003ofZJPomZVX004
omZVX003o`000?oNZj7o000000;oh:RI0_l00004onR_U`?o00000_oVV7L02Ol0003olJ=/oo6SK?oa
Xfco0000ooV/F?ok]g3o0000ooV]B003o`0001cooooo00?o0000ooooooooool03oooool000kooooo
00?o0000ooooooooool0:?ooool2o`000004o`00AOl0003o3`1[o`l0J`;o00000_m08hH01_l0003o
DC2:oe4`R_l0003oFSjFo`0000;oIdNH00?o0000ofY7U_l000000_meCiP2o`000003ogYHWol0003o
PenP00CoPenP00?o0000oh]TXOn;I:401?n;I:43o`0000CoU6nV0ol00003oi]fZ003o`000?nQNZSo
XGZX00GoXGZX00?o0000ojMnYonWOZL01OnWOZL00ol0003o[86Vojb1YP02ojb1YP05o`000?n^Q:So
[XBXojj4Z?l000001onbQjL00ol0003o]hZVokN:YP02okN:YP05o`000?niSJSo^HfXokV=Z?l00000
2?nmT:L00ol0003oa9JWolBFY`07olBFY`03o`000?o7V:Ko000000OobibW00Co0000oljNY_l0003o
dJ>W0ol00003om:OX@;o00001_oJYZ001Ol0003ogZ^Qomj[XOl0003oh:RI00;o00000_oX[iL3o`00
00;oiYQg0_l000001OoVV7Oo0000oo6SK?oaXfco000000;onJaH00?o0000ooV]B?l000000_l0000L
ooooo`03o`000?oooooooooo00oooooo000>ooooo`03o`000?oooooooooo02Sooooo0_l000001Ol0
04Go0000o`l0Jol?06_o000000?o@2>600?o0000oe4`R_l000000_mJ?YH01?l0003oIdNHofM7V?mW
AiP2o`000003ogE?V?l0003oNURO00;oNURO00?o0000oh=OX?n3Gj000on3Gj000ol0003oRfBQoh]T
X@02oh]TX@?o00001?nDKjH3o`0000GoVgJX00?o0000oj5jZ?nQNZP01OnQNZP00ol0003oYgjWojMn
Y`05ojMnY`03o`000?n/PJKo000001co00001?nmT:L00ol0003oa9JWolBFY`08olBFY`;o00002?o;
W:L01_l0003odJ>Wom6SYooAXjOo0000om6SY`;o000000CodYnQo`000?oGY:;o00001?oJYZ000ol0
003ogZ^Qomj[X@02omj[X@08o`000?oPZ9Wo0000onR_Uol0003oj:nGom^?O?l00004onJHM`;o0000
0_oaXf`2o`000003ooV/F?l0003o000000?o00007?ooool00ol0003oooooooooo`0?ooooo`003_oo
ool00ol0003oooooooooo`0Xooooo`Co00000_l?06/01?l0003o@2>6od0SQ_m08hH2o`0000?oFSjF
00?o0000ofM7V?mWAiP00_mWAiP3o`0000?oNURO00?o0000oh=OX?n3Gj000on3Gj000ol0003oRfBQ
o`000002o`0000;oSF^V00?o0000oiA_Y_l000000_l00002oiEbZ@03o`000?nKMZSoVgJX00CoVgJX
00?o0000oj5jZ?nQNZP01OnQNZP01?l0003oYgjWojMnYonWOZL5o`000003ojb5Zol0003o[XR]00Co
[XR]00?o0000ok>;[?ncRj`01OncRj`01Ol0003o]hf[okN=ZongSJ_o000000Co^I6]00?o0000okfC
[?nmTj`00_nmTj`8o`0000Ooa9JW00?o0000ol^LYoo;W:L01oo;W:L01Ol0003odJ>Wom6SYooAXjOo
000000?odJ>W1?l00004omZVX003o`000?oNZj7ogZ^Q00?ogZ^Q0ol000001?oERgko0000om^?O?l0
0005onJHM`05o`000?oaXfcolJ=/o`000?oi[5P01_l0000Looooo`03o`000?oooooooooo00oooooo
000>ooooo`03o`000?oooooooooo02Oooooo0ol000001Ol0067o0000o`l0Jol?06_o000000?o@2>6
00?o0000oeXnU_mJ?YH00omJ?YH3ofM7V0;o00000_miFZ84o`0000CoPenP0ol00002ohe[YPGo0000
1OnELZT00ol0003oVgJXoi]fZ004oi]fZ004o`000?nQNZSoXGZXoj5jZ0So00000onWPZ`00ol0003o
[8F[o`000006ojj8[@03o`000?ncRjco/h^/00Go/h^/00Co0000okN=ZongSJ_o00001_niTJd00ol0
003o_I>/okfC[004okfC[003o`000?o0Ujko000000;o`iV/1Ol00002olBFY`03o`000?o;W:OobibW
00OobibW00Go0000om6SYooAXjOodJ>Wo`000003om6SY`03o`000?oEZ:WoeJRY00;o00000ooJYZ00
0ol0003ogZ^Qomj[X@02omj[X@?o00000_oERgh01?l0003ofhmlom^?O?l00004onJHM`;o00000_oa
Xf`00ol0003onJaHo`000004o`0001cooooo00?o0000ooooooooool03oooool000kooooo00?o0000
ooooooooool09oooool3o`000003o`00HOl0003o3`1[00;o00000om08hH00ol0003oFSjFoeXnUP03
oeXnUP;oIdNH00?o0000ofiBXOl000001OmiFZ8:o`0000?oSVfY00?o0000oiEbZOnELZT01OnELZT0
0ol0003oVgJXoi]fZ002oi]fZ0Go00001?nSOjd00ol0003oYh:/ojN2[004ojN2[0;o00002?n^R:d0
0ol0003o/h^/ok>;[005ok>;[0;o00001oniTJd00ol0003o_I>/okfC[003okfC[005o`000?o0Ujko
`9N^ol2G[_l000001_o3VJ`5o`0000KobibW00?o0000oljQZOl000000_oAXjL01?l0003odJ>Wom6S
Yol00003omFXZ@03o`000?oHZJKo000000;o00001?oNZj401?l0003oc8>1o`000?oERgh3o`0000;o
fhml00?o0000onJHMooVV7L00_oVV7L01_l0003olJ=/o`000?oaXfco0000ooV/F0Ko00006oooool0
0ol0003oooooooooo`0?ooooo`003_ooool00ol0003oooooooooo`0Wooooo`?o000000Go001Qo`l0
Jol0003o8Pmoo`000002od0SQP;o00001OmJ?YH01OmWAiSo0000ofiBXOm^DZ7o000000GoNEZR00?o
0000oh9PX_l000001?n6J:T00ol0003oSVfYohi]Z@03ohi]Z@03o`000?nELZWoUG:Y00GoUG:Y00?o
0000oi]fZ?l000000_l000000onMNjgo0000oj=o[@06oj=o[@03o`000?nWPZcoYh:/00?oYh:/00?o
0000ojV5[_l000002?n^R:d00ol0003o/h^/ok>;[005ok>;[003o`000?niTJgo^I6]00Ko^I6]00?o
0000okfC[?nmTj`00_nmTj`00ol0003o`9N^ol2G[P02ol2G[P03o`000?o3VJco`iV/00Go`iV/0_l0
0002olZO[0?o00000_o;W:L01?l0003ocZ6YoljQZOl00002om6SY`04o`000?oAXjOodJ>Wo`0000Co
eJRY00?o0000omRYY_oHZJH01Ol00002olb3P@04o`000?oERgkoeH]nomF;OPCo00001?oVV7L00ol0
003olJ=/oo6SK002o`000003ooV/F?l0003o000000Co00006oooool00ol0003oooooooooo`0?oooo
o`003_ooool00ol0003oooooooooo`0Wooooo`;o000000?o001Io`00HOl000000olR3gl2o`000003
od/cT_l0003oFSjF00?oFSjF0_l00003ofiBX@03o`000?miFZ;oNEZR00?oNEZR0_l00005ohIXZ@03
o`000?n>KJWoSVfY00CoSVfY00?o0000oiEbZOnELZT00_nELZT4o`0000CoWG^]00?o0000oj=o[OnS
Ojd01OnSOjd01?l0003oYh:/ojN2[?nWPZ`2o`0000?oZHF^00?o0000ojj8[On^R:d01On^R:d00ol0
003o/h^/ok>;[004ok>;[0;o00002OniTJd01Ol0003o_I>/okfC[?nmTjco000000Co`9N^00?o0000
ol>I[?o3VJ`01?o3VJ`01?l0003oaYf^olJM[_l00004olZO[0?o00000_o>XJT01_l0003odJ>Wom6S
Yol0003odJ>Wo`0000GoeJRY00Go0000omRYY_oHZJKo0000omb^Z002o`0000?oc8>100Go0000omF;
O_oERgkoeH]no`000002om^?O0;o00000ooVV7L02?l0003olJ=/oo6SK?oaXfco0000ooV/F?l0003o
oK]U1?l0000Kooooo`03o`000?oooooooooo00oooooo000>ooooo`03o`000?oooooooooo02Kooooo
0ol000000ol005Wo001Qo`000003ob8?O`05o`000?m;<i;oBc>Bod/cT_l000000_mJ?YH00ol0003o
HTZOo`000004ofiBX@CoNEZR00?o0000ogeRZOl000001On6J:T00ol0003oSVfYohi]Z@04ohi]Z@03
o`000?nELZWo000000;o00000_nGN:h00ol0003oWG^]oiek[@04oiek[@03o`000?nSOjgoXgn]00Go
Xgn]00?o0000ojN2[?l000001OnYQJh00ol0003o[XR]ojj8[@05ojj8[@03o`000?ncRjco/h^/00?o
/h^/00Co0000okF?[_neSjko00002?niTJd01?l0003o_I>/okfC[?l00006ol2G[P03o`000?o3VJco
`iV/00;o`iV/00Go0000olJM[_o6WJkoaYf^o`000005olZO[003o`000?o=Y:ko000000?o000000Co
dJ>Wo`000?oAXjOo00001OoEZ:T01?l0003of:VVo`000?oL[ZP3olb3P@04o`000?o<Ph7oc8>1o`00
00?oeH]n00Go0000om^?O?oKSgco0000onJHM`02o`000003onJHMol0003olJ=/00;olJ=/00?o0000
ooV/F?oi[5P00_l000000ook_EGo0000o`00000Looooo`03o`000?oooooooooo00kooooo000=oooo
o`03o`000?oooooooooo02Oooooo0ol000000ol005Wo0000o`000003ob8?O`07o`000?m;<i;oBc>B
od/cT_l0003oFSjFo`000002of9:W`03o`000?m^DZ7oKU:Q00;oKU:Q0_miFZ82o`0000;oOF:Y00?o
0000ohIXZOn6J:T01?n6J:T00ol0003oSVfYohi]Z@02ohi]Z@?o00001OnGN:h00ol0003oWG^]oiek
[@04oiek[@03o`000?nSOjgoXgn]00GoXgn]0_l00006ojV5[P03o`000?n^R:go[XR]00Ko[XR]00Go
0000ok>;[?ncRjco/h^/o`000003okF?[P03o`000?niTJgo^I6]00Ko^I6]00Co0000okfC[?nmTjco
00001_o0Ujh00ol0003o`iV/ol>I[002ol>I[005o`000?o6WJkoaYf^olJM[_l000001?o:Wj`00ol0
003ocJB^olfT[P03olfT[PGo00001_oEZ:T3o`0000Coc8>100?o0000olb3POl000000ooERgh01?l0
003ofhmlom^?O?l00003onJHM`;o00000ooaXf`2o`000004ooV/F?l0003o0000oo^mE@;o00007?oo
ool00ol0003oooooooooo`0>ooooo`003Oooool00ol0003oooooooooo`0Wooooo`04o`004ol0003o
001Io`00F@;o00000_lR3gl00ol0003oAC2Co`000002od/cTP;o00000omRBYl00ol0003oKU:QofiB
X@02ofiBX@03ogUJX_l0003oOF:Y00?oOF:Y00?o0000ohIXZOn6J:T01?n6J:T00ol0003oSVfYohi]
Z@02o`000003oi1c[_l0003oUgR^00GoUgR^00?o0000oiek[OnMNjd01?nMNjd00ol0003oXgn]oj=o
[@04oj=o[@;o00002?nYQJh01?l0003o[XR]ojj8[On^R:dBo`0000Co^I6]0_l00007ol2G[P05o`00
0?o3VJco`iV/ol>I[?l000001Oo6WJh01Ol0003obYn/olZO[?o:Wjco000000GocJB^00?o0000om2U
[?o@YJ`00_l00004omFXZ@;o000000?o_7J4o`000?l000000_l00002olb3P@03o`000?o<Ph7o0000
00CoeH]n00?o0000om^?O?l000001?oVV7L01_l0003olJ=/oo6SK?oaXfco0000ooV/F0?o000000?o
nkeEo`000?l000007?ooool00ol0003oooooooooo`0>ooooo`003Oooool00ol0003oooooooooo`0W
ooooo`03o`004ol0003o001I00?o000000?o8Pmoo`000?lb8hl00_m5<9<00ol0003oBc>Bo`000005
of9:W`03o`000?m^DZ7oKU:Q00;o00001OmmHZT00ol0003oQVRYohIXZ@04ohIXZ@?o00000on@Ljh0
0ol0003oUgR^oiMh[P04oiMh[P03o`000?nMNjgoWG^]00CoWG^]00?o0000oj=o[OnSOjd00onSOjd0
0ol0003oY8:_o`000004ojV5[PSo00001?n_S;400ol0003o/hj`o`000006okFB/P03o`000?niU;7o
^IBa00;o^IBa2_l00004ol2G[P04o`000?o3VJco`iV/o`0000GoaYf^00Co0000olZO[?o:Wjco0000
1_o=Y:h01Ol0003od:F/om2U[?l0003oe:Z^00Co000000?oeJRYokafQ?nlMX@00_l00002olb3P@?o
000000?oc8>1o`000?oERgh00ooERgh00ol0003ofhmlo`000004onJHM`;o00000_oaXf`01Ol0003o
nJaHooV/F?l0003oolU`00?o00007?ooool00ol0003oooooooooo`0>ooooo`003Oooool00ol0003o
ooooooooo`0Wooooo`04o`000?l004Wo0000o`00LP?o00000_lb8hl3odD`T`;o00001OmRBYl01Ol0
003oKU:Qo`000?mcFjSo000000KoOF:Y00?o0000ohIXZOn6J:T00_n6J:T2o`0000KoT7>^00?o0000
oiMh[_nGN:h01?nGN:h00ol0003oWG^]oiek[@03oiek[@03o`000?nSOjgoXgn]00;oXgn]00?o0000
ojB2[ol000001Ol00004ojZ9/P03o`000?n_S;7o[hba00Go[hba0_l00007okFB/P03o`000?niU;7o
^IBa00Go^IBa0_l00005oknJ/PGo000000?o`iV/o`000?o6WJh01Oo6WJh00ol0003obYn/o`000008
olfT[P?o00000_oDZZh2o`0000Co_7J40_l00005olb3P@Go000000CoeH]no`000?oKSgco00001?oV
V7L01Ol0003olJ=/o`000?oaXfco000000;onJaH1Ol0000Looooo`03o`000?oooooooooo00kooooo
000=ooooo`03o`000?oooooooooo02Oooooo00?o0000o`00BOl000000_l007801?l0003o<R>?oc8S
Solb8hl2odD`T`04o`000?m@?ioo0000o`0000CoHTZO0_l00002og=KZ003o`000?mmHZWoOF:Y00Co
OF:Y00?o0000ohIXZOn6J:T00_l000000on9KZko0000oi1c[P05oi1c[P03o`000?nGN:koUgR^00Co
UgR^00?o0000oiek[OnMNjd01?nMNjd00ol0003oXgn]o`000003o`0000;oYHJc00?o0000ojZ9/_nZ
RK801OnZRK800ol0003o[hbaojn</@04ojn</@;o00002OneT[800ol0003o^IBaokVD/@03okVD/@03
o`000?nlV;?o000000Wo_iZb1?l00006olJM[P;o00002?o=Y:h00ol0003oe:Z^o`000002o`0000Ko
_7J40_l00006olb3P@04o`000?oERgkoeH]nomF;OPCo00001?oVV7L00ol0003olJ=/oo6SK002o`00
00;onJaH1Ol0000Looooo`03o`000?oooooooooo00kooooo000=ooooo`03o`000?oooooooooo02Oo
oooo0ol00002o`00LP06o`000?lb8hoo<R>?oc8SSom5<9?o00000om@?il01?l0003oHTZOof9:WomR
BYl2o`0000CoLe^X00?o0000ogeRZOmmHZT00ommHZT00on6J:Wo0000o`000003ohU^[P03o`000?n@
LjkoT7>^00CoT7>^00?o0000oiMh[_nGN:h01?nGN:h01?l0003oWG^]oiek[OnMNjd5o`0000KoYHJc
00?o0000ojZ9/_nZRK801_nZRK800ol0003o[hbaojn</@02ojn</@03o`000?naT;Co000000Wo]I:b
00?o0000okVD/OniU;400_niU;401Ol0003o_9RcokbH/onlV;?o000000So_iZb00Co0000olJP/_o6
X;;oaZ2b1Ol000000oo6WJko0000olfT[P08olfT[P04o`000?oDZZko0000o`0000Oo_7J400?o0000
olAlPol000001Oo<Ph400ol0003oeH]nomF;OP02omF;OP04o`000?oKSgco0000o`0000?oiYQg00Go
0000oo6SK?oaXfcolJ=/o`000002ooV/F0;o000000?oolU`o`000?l000007?ooool00ol0003ooooo
ooooo`0>ooooo`003Oooool00ol0003oooooooooo`0Wooooo`?o00000_l007801Ol0003o<R>?oc8S
Solb8hoo000000CoD3nO0_l000001?mRBYoo0000ofQDYol00004og=KZ003o`000?mmHZWoOF:Y00;o
OF:Y00?o0000ohIXZOn9KZh01On9KZh00ol0003oT7>^oi1c[P03oi1c[P03o`000?nGN:koUgR^00?o
UgR^1Ol000001OnNP;;o0000o`000?nPPkCo000000OoYHJc00?o0000ojZ9/_nZRK801OnZRK801Ol0
003o[hbaojn</On_S;7o000000?o/I2d00?o0000okFB/_neT[801_neT[801Ol0003o^IBaokVD/Oni
U;7o000000Co_9Rc00?o0000oknJ/_noV[801OnoV[82o`0000SoaZ2b1?l00005olfT[P;o000000Co
dJV`o`000?l0003o00001onlMX@00ol0003oa7b3o`000005olb3P@03o`000?oERgkoeH]n00;oeH]n
00Go0000om^?O?l0003oiYQgo`000003onJHM`04o`000?oaXfcolJ=/o`0000;onJaH1_l0000Koooo
o`03o`000?oooooooooo00kooooo000=ooooo`03o`000?oooooooooo02Oooooo00?o000Wo`000?l0
06H00_l00782o`0000;o<R>?00?o0000oe0oWom@?il00_m@?il01_l0003oGTVRo`000?l0003oJ5BW
o`0000CoLe^X00?o0000ogeRZOmmHZT00_l000000on1JJko0000ohU^[P05ohU^[P03o`000?n@Ljko
T7>^00?oT7>^00Co0000oiMh[_nGN:koUgR^0_l000000onIO;;o0000oij0/P02oij0/P05o`000?nP
PkCoX8>doj23]?l000001onUQ[<00ol0003oZXVbojZ9/P05ojZ9/P04o`000?n_S;7o[hbao`0000Co
/I2d00?o0000okFB/_neT[801_neT[801?l0003o^IBaokVD/Ol00005okbH/`03o`000?noV[;o_iZb
00Co_iZb00Co0000ol:N]?o2W[Co00002?o6X;800ol0003oc:JcolbV/`04o`000003olfT[_l0003o
000000So00000onlMX@00ol0003oa7b3o`000006olb3P@07o`000?oERgkoeH]nomF;O_l0003ofhml
o`000002onJHM`;o000000CoiYQgo`000?oaXfcolJ=/0_l000000ooi[5So0000o`000004o`0001_o
oooo00?o0000ooooooooool03_ooool000cooooo00?o0000ooooooooool0:?ooool02?l002Oo0000
o`00I_l007;o0000o`l<Qol0003o<R>?0_l00004oe0oW`;o00000_mVE:X2o`0000GoLe^X0_l00004
oh5Y[P03o`000?n9KZkoRFj^00?oRFj^00?o0000oi1c[_n@Ljh01?n@Ljh3o`0000CoVGbb0ol00005
oj23]003o`000?nUQ[?oYHJc00CoYHJc00?o0000ojZ9/_nZRK801_nZRK82o`0000Ko/I2d00?o0000
okFB/_neT[801_neT[82o`0000Oo_9Rc00?o0000oknJ/_noV[800onoV[83ol:N]003o`000?o6X;;o
aZ2b00GoaZ2b00?o0000olVU]Ol000001Oo<Y[<2o`0000?o/fn50_l00004okafQ0So00001?o<Ph40
1ol0003oeH]nomF;O_oERgko0000om^?O?l000001?oVV7L2o`0000;olJ=/00?o0000ooV/F?l00000
1_l0000Looooo`03o`000?oooooooooo00gooooo000<ooooo`03o`000?oooooooooo02Sooooo00_o
000Wo`000?l006Ko001bo`000?l?38Oo0000oc8SSol0003o?c>Ko`000003oe0oW`03o`000?mVE:[o
IUBZ00;oIUBZ0_l00004og=KZ003o`000?n1JJkoPFV^00?oPFV^00?o0000ohU^[_n9KZh00on9KZh0
0ol0003oT7>^oi1c[P03oi1c[P;o00001?nIO;83o`0000OoX8>d00?o0000ojF6/onUQ[<01?nUQ[<0
0ol0003oZXVbojZ9/P05ojZ9/P;o00001onaT;@00ol0003o]I:bokFB/P06okFB/P03o`000?nlV;?o
_9Rc00Ko_9Rc00?o0000oknJ/_noV[800_noV[801Ol0003o`Yjdol:N]?o2W[Co000000KoaZ2b00Co
0000olVU]Oo9YKGo00001Oo<Y[<00on]JhGo0000ok=_Q@02ok=_Q@;o00001onlMX@00ol0003oa7b3
o`000002olb3P@?o000000?oc8>1o`000?oERgh00_oERgh00ol0003ofhmlo`000005onJHM`;o0000
0_oaXf`00ol0003onJaHo`000002o`000003oo[:H?l0003o000001cooooo00?o0000ooooooooool0
3Oooool000cooooo00?o0000ooooooooool0:?ooool01?l002Oo001Mo`00I_l00002o`l<Q`;o0000
0_lo<i/01Ol0003oD3nOoe0oWom@?ioo000000CoIUBZ00Go0000og9MZol0003o0000og=KZ002o`00
00GoPFV^00?o0000ohU^[_n9KZh01?n9KZh00ol0003oT7>^o`000002o`000003oi9h/ol0003oVGbb
00?o00000_nJOkD00ol0003oX8>doj23]005oj23]003o`000?nUQ[?oYHJc00CoYHJc00?o0000ojZ9
/_nZRK801?nZRK800ol0003o[8feo`000007ok6@]003o`000?neT[;o]I:b00Go]I:b0_l00008okbH
/`05o`000?noV[;o_iZboknJ/_l000001Oo2W[@00ol0003oaZ2bolJP/P02olJP/P03o`000?o9YKGo
bJFe00;obJFe00Co0000olbV/ol0003o00000_n]JhD01?l0003o/fn5ok=_QOncKhD2o`0000Oo_7J4
00?o0000olAlPol000001Oo<Ph43o`0000;oeH]n00Co0000om^?O?oKSgco00001?oVV7L02_l0003o
lJ=/o`000?oaXfco0000ooV/F?l0003olJ/do`000?ojbV02o`0001cooooo00?o0000ooooooooool0
3Oooool000cooooo00?o0000ooooooooool0:?ooool01?l0003o001Mo`00I_l00002o`l<Q`;o0000
0_lo<i/00ol0003oD3nOoe0oW`02o`0000CoIUBZ00?o0000og9MZombGJ/01?l00006oh5Y[P03o`00
0?n9KZkoRFj^00;oRFj^0ol000000onBN;?o0000o`000003o`0000KoVWne00?o0000oj23]?nPPk@0
1?nPPk@00ol0003oYHJcojF6/`05ojF6/`03o`000?nZRK;oZXVb01co00001?nlV;<00ol0003o_iZb
oknJ/P06ol:N]003o`000?o6X;;oaZ2b00;oaZ2b00?o0000olVU]Oo9YKD00_o9YKD2o`000005olbV
/ol0003o[F^5oje[QOl000000oncKhD00ol0003o/fn5o`000006okafQ003o`000?o4O8?o000000Ko
c8>100?o0000omF;O_l000000_l00002om^?O003o`000?oVV7OoiYQg00;oiYQg00?o0000oo6SK?oa
Xf`00_l000001Ooi[5So0000o`000?l0003on/YP00;o00007?ooool00ol0003oooooooooo`0=oooo
o`003?ooool00ol0003oooooooooo`0Xooooo`04o`000?l005go0000o`0000;o3`b700Oo0000ocH`
WOl0003o?c>Ko`000?m@?ioo000000;oF4^X00?o0000ofIDZ_mVE:X00_mVE:X2o`0000?oMfFa4?l0
0003oi=k]P03o`000?nJOkGoVWne00GoVWne00?o0000oj23]?nPPk@01OnPPk@4ojF6/`Oo00001?n/
T;T00ol0003o/I>hok6C^006ok6C^005o`000?neUKKo]IFfokFE]_l000000ongVKT00ol0003o^i^g
ok^K]`03ok^K]`So00001Oo2W[@01Ol0003oaZ2bolJP/_o6X;;o000000KobJFe00?o0000oj=SQOl0
00000_n]JhD01ol0003o/fn5ok=_QOncKhGo0000ok=_QOl000001_nlMX@00ol0003oa7b3o`000006
olb3P@04o`000?oERgkoeH]nomF;OPCo00001?oVV7L01_l0003olJ=/oo6SK?oaXfco0000ooV/F0?o
000000?on/YPo`000?l000007?ooool00ol0003oooooooooo`0=ooooo`003?ooool00ol0003ooooo
ooooo`0Xooooo`05o`000?l005go0000o`000?l?38L00_l00002ocH`W@04o`000?lo<i_oD3nOo`00
00;oF4^X00?o0000ofIDZ_mVE:X00_mVE:X00ol0003oMfFaogMU/@02ogMU/@03o`000?n1Jk;oPF^b
00CoPF^b0ol00003ohag]P03o`000?nCNkKoTg^f00CoTg^f00?o0000oiYo]OnJOkD01?nJOkD00ol0
003oX8>doj23]003oj23]0Ko00000onVR[L00ol0003oZhffo`000005ojb@^@03o`000?naTkSo/I>h
00Ko/I>h00Co0000okFE]_neUKKo00001OngVKT00ol0003o^i^gok^K]`06ok^K]`04o`000?o2XKSo
`Z6hol:Q^0Go000000Co`Yjdo`000?o6X;;o00001Oo9YKD2o`0000;oXf>500Co0000oje[QOn]JhGo
00000oncKhD00ol0003o/fn5o`000006okafQ003o`000?o4O8?o000000Koc8>100Go0000omF;O_oE
RgkoeH]no`000002om^?O0;o00000ooVV7L01Ol0003olJ=/oo6SK?oaXfco000000;onJaH0ol00000
0oo]aD_o0000ooooo`0Kooooo`03o`000?oooooooooo00gooooo000<ooooo`03o`000?oooooooooo
02Sooooo00Go0000o`00GOl007So0000o`l<Q`02o`0000;o=S2M00?o0000oclcVol000000omHBjP0
1?l0003oIUBZofIDZ_mVE:X2o`0000GoMfFa00?o0000oh5[/_n1Jk800_n1Jk82o`0000GoS7Nf00?o
0000oi=k]_nCNkH01?nCNkH00ol0003oVWneoiYo]@05oiYo]@03o`000?nPPkCo000000;o00000_nQ
QkP00ol0003oYXZgojJ:]`04ojJ:]`;o00001on/T;T00ol0003o/I>hok6C^006ok6C^0;o00001_ng
VKT00ol0003o^i^gok^K]`06ok^K]`03o`000?o2XKSo`Z6h00Ko`Z6h1_l00002olVU]@03o`000?nS
HhGo0000013o00000_nlMX@00ol0003oa7b3o`000006olb3P@05o`000?oERgkoeH]nomF;O_l00000
0_oKSg`01_l0003oiYQgo`000?l0003oiYQgo`0000?olJ=/0_l000001_oi[5So0000o`000?l0003o
kLE;o`0001cooooo00?o0000ooooooooool03Oooool000cooooo00?o0000ooooooooool0:?ooool0
1Ol003[o0000o`00N?l0003o3`b700;o00000olf<9d2o`0000?oF4^X00Ko0000ofIDZ_mVE:[o0000
ofaN/Ol00005ogMU/@07o`000?n1Jk;oPF^boh5[/_l0003oQ7:go`000006ohag]P03o`000?nCNkKo
Tg^f00?oTg^f00?o0000oiYo]OnJOkD00onJOkD4o`0000GoXHNh00?o0000ojJ:]onVR[L00_nVR[L2
o`000003ojN>^_l0003o[92i00Ko[92i00?o0000ok6C^?naTkP01OnaTkP2o`0000So]iVi00?o0000
ok^K]onkVkL01?nkVkL2okjO^P03o`000?o2XKSo`Z6h00Oo`Z6h00?o0000olRW^Oo8YkT01Ol00003
oj=SQ@04o`000?n]JhGo[F^5o`0000?o/fn500?o0000ok=_QOl000001?nlMX@5o`0000Koc8>100Go
0000omF;O_oERgkoeH]no`000002om^?O004o`000?oVV7OoiYQgonJHM`;o00000ooaXf`00ol0003o
nJaHo`000005o`0001cooooo00?o0000ooooooooool03Oooool000_ooooo00?o0000ooooooooool0
:Oooool01Ol003[o0000o`00N?l007So3`b700;o8B6G0olf<9d00om3?jSo0000oeQ;Z003oeQ;Z003
ofIDZ_l0003oK5ja00;oK5ja00?o0000ogMU/OmgIK400_mgIK401?l0003oPF^boh5[/_l00003ohAb
]`03o`000?n<MkKoS7Nf00?oS7Nf00?o0000oi=k]_nCNkH01?nCNkH00ol0003oVWneo`000002o`00
00;oVhBi00?o0000oj67^?nQQkP01OnQQkP01?l0003oYXZgojJ:]ol00004ojN>^P03o`000?n/T;Wo
[92i00Co[92i00?o0000ok6C^?naTkP01?naTkP00ol0003o/iNjo`000008okNI^@03o`000?nkVkOo
^i^g00?o^i^g0onnWkX00ol0003o`Z6hol:Q^006ol:Q^0;o00000_o8YkT2o`0000KoXf>500Co0000
oje[QOn]JhGo00000oncKhD00ol0003o/fn5o`000006okafQ003o`000?o4O8?o000000;o00001?o<
Ph400ol0003oeH]nomF;OP02omF;OP03o`000?oKSgco000000CoiYQg00Go0000oo6SK?oaXfcolJ=/
o`000002ooV/F0Go00007?ooool00ol0003oooooooooo`0=ooooo`002oooool00ol0003ooooooooo
o`0Yooooo`05o`00>_l0003o001ho`00N?l000000_lQ8IL2ocH`W@04o`000?m3?jSo0000o`0000?o
F4^X00?oIUBZofaN/Om/G[400_m/G[400ol0003oMfFaogMU/@03ogMU/@;o00001?n4L[L00ol0003o
S7Nfohag]P03ohag]P03o`000?nCNkKoTg^f00?oTg^f0ol00006oi^4^@03o`000?nQQkSoXHNh00Co
XHNh0ol00005ojN>^P03o`000?n/T;Wo[92i00Go[92i00?o0000ok6C^?naTkP00_naTkP01Ol0003o
/iNjok>G^_ncUk[o000000So]iVi00Co0000ok^K]onkVkOo^i^g1OnnWkX00ol0003o`Z6hol:Q^004
ol:Q^003o`000?o4Y[_oa:Jk00?o00001onSHhD01?l0003o[F^5oje[QOl00003ok=_Q@03o`000?nc
KhGo000000Ko_7J400?o0000olAlPol000000_o<Ph43o`000003olb3POl0003oeH]n00?oeH]n00?o
0000om^?O?l000001?oVV7L2o`0000;olJ=/00Go0000ooV/F?oi[5So0000oo6[=003o`0001gooooo
00?o0000ooooooooool03?ooool000_ooooo00?o0000ooooooooool0:Oooool2o`0000;o001h00Go
0000ob4QUolQ8IOo=S2Mo`000002od<oZ004o`000?mCBj_o0000oeQ;Z0;o00001?m/G[400ol0003o
MfFaogMU/@02ogMU/@;o00001On4L[L00ol0003oS7Nfohag]P03ohag]P04o`000?nCNkKoTg^foi=k
]P;o000000?oUH2jo`000?nKQ;T01_nKQ;T00ol0003oXHNhoj67^003oj67^0;o00001onWS[X00ol0
003o[92iojb@^@05ojb@^@05o`000?naTkSo/I>hok6C^?l000001?ncUkX00ol0003o]iViokNI^@06
okNI^@03o`000?nkVkOo^i^g00Ko_Ynj00?o0000ol:Q^?o2XKP00oo2XKP01ol0003oa:JkolBV^oo4
Y[_o0000oiIIQOl000001onSHhD01?l0003o[F^5oje[QOl00003ok=_Q@03o`000?ncKhGo000000Ko
_7J400?o0000olAlPol000001Oo<Ph45o`000004omF;O_l0003ofhmlo`0000CoiYQg00Go0000oo6S
K?l0003olJ=/o`000002ooV/F0Go00007Oooool00ol0003oooooooooo`0<ooooo`002oooool00ol0
003oooooooooo`0Yooooo`08o`000?l007So001ho`000?lC6iOo0000ob4QUol00003od<oZ003o`00
0?mCBj_oDd^[00?o00001?m/G[400ol0003oMfFaogMU/@02o`000003og]/]ol0003oQ7:g00GoQ7:g
00?o0000ohag]_n<MkH00on<MkH3o`0000CoUH2j00?o0000oi^4^OnKQ;T01?nKQ;T01?l0003oXHNh
oj67^?nQQkP2o`000003oj:;^ol0003oYhjj00OoYhjj00?o0000ojb@^On/T;T01?n/T;T01?l0003o
/I>hok6C^?l00005ok>G^P03o`000?ngVKWo]iVi00Oo]iVi00?o0000okjO^_nnWkX01OnnWkX00ol0
003o`Z6hol:Q^002ol:Q^005o`000?o4Y[_oa:JkolBV^ol000000_nFFHD00ol0003oXf>5oj=SQ@05
oj=SQ@05o`000?n]JhGo[F^5oje[QOl000000_ncKhD00ol0003o/fn5o`000006okafQ003o`000?o4
O8?o000000Koc8>100Co0000omF;O_oERgkoeH]n1?l00004onJHM`03o`000?oaXfcolJ=/00;o0000
0_oi[5P5o`0001gooooo00?o0000ooooooooool03?ooool000_ooooo00?o0000ooooooooool0:Ooo
ool02?l0003o001Mo`00N?l0003o4a^Go`000?lQ8IOo00001?m3?jP01?l0003oDd^[oeaF/omLE[<2
o`0000CoK5ja00?oMfFao`000?mkK;L00_mkK;L00ol0003oQ7:gohAb]`04ohAb]`03o`000?n<MkKo
S7Nf00;oS7Nf0_l00006oiF0^P03o`000?nKQ;WoVhBi00GoVhBi0ol00004oj:;^`03o`000?nWS[[o
Yhjj00GoYhjj00?o0000ojb@^On/T;T01On/T;T2o`0000Oo/iNj00?o0000okNI^OngVKT01OngVKT2
o`0000So_Ynj00Co0000ol:Q^?o2XKSo00000oo4Y[/01Ol0003oUUV5oiIIQOnFFHGo000000OoXf>5
00Go0000oje[QOn]JhGo[F^5o`000002ok=_Q@03o`000?ncKhGo000000Oo_7J400?o0000olAlPol0
00001Oo<Ph400ol0003oeH]nomF;OP02omF;OP04o`000?oKSgco0000o`0000?oiYQg00Go0000oo6S
K?oaXfcolJ=/o`000002ooV/F003o`000?oaZcCo000000;o00007Oooool00ol0003oooooooooo`0<
ooooo`002oooool00ol0003oooooooooo`0Yooooo`09o`000?l005go001ho`000?l028go4a^Go`00
0?l`<j?o000000?o@cnX0_l00003oeaF/`;o00000om/G[400ol0003oNfbgog]/]`03og]/]`03o`00
0?n4L[OoQ7:g00?oQ7:g00?o0000ohag]_n<MkH00_l000000on>O;_o0000oiF0^P05oiF0^P03o`00
0?nKQ;WoVhBi00?oVhBi0ol00006oj:;^`03o`000?nWS[[oYhjj00GoYhjj00?o0000ojb@^On/T;T0
0_n/T;TKo`0000?o_Ynj00?o0000ol:Q^?l000000oo4Y[/00ol0003oUUV5oiIIQ@02oiIIQ@03o`00
0?nSHhGoXf>500GoXf>500Go0000oje[QOn]JhGo[F^5o`000003ok=_Q@;o00001onlMX@00ol0003o
a7b3o`000005olb3P@03o`000?oERgkoeH]n00;oeH]n00Go0000om^?O?l0003oiYQgo`000003onJH
M`04o`000?oaXfcolJ=/o`0000;onJaH00?o0000oo6[=?l000000_l0000Mooooo`03o`000?oooooo
oooo00cooooo000;ooooo`03o`000?oooooooooo02Wooooo00?o^hH0o`00GOl000000_l028d01?lC
6iOo0000oc0cXol00003od<oZ003o`000?mLE[?oG5Jc00;oG5Jc00Ko0000ofUO]?l0003o0000ofaN
/Ol00005og]/]`03o`000?n4L[OoQ7:g00CoQ7:g00?oS7Nfo`000?n>O;/00on>O;/00ol0003oUH2j
oiF0^P04oiF0^P03o`000?nKQ;Wo000000;o00000_nLQk`00ol0003oXX^koj:;^`04oj:;^`03o`00
0?nWS[[oYhjj00;oYhjj2?l000001?n]Tkco0000ojjG_ol00008ok>J_@03o`000?ngW;co]ibl00;o
]ibl00Go0000okVP_oniX;oo^J2oo`000005okfR_@Go00000oo4Y[/00ol0003oUUV5oiIIQ@03oiII
Q@04o`000?nSHhGoXf>5oj=SQA;o00000onlMX@00ol0003oa7b3o`000006olb3P@07o`000?oERgko
eH]nomF;O_l0003ofhmlo`000002onJHM`;o000000CoiYQgo`000?oaXfcolJ=/0_l000000ooi[5So
0000oo6[=002o`0001kooooo00?o0000ooooooooool03?ooool000_ooooo00?o0000ooooooooool0
:Oooool00onkQP3o0000o`000002o`08S@04o`000?lT;jGo0000o`0000?o@cnX00?o0000oeaF/omL
E[<00_mLE[<00ol0003oJEndofUO]006o`0000;oNfbg00?o0000ohAb]on4L[L00on4L[L2o`0000Go
SWbk00Co0000oiF0^_nEP;[oUH2j1Ol00005oib7_003o`000?nRRk_oXX^k00?oXX^k1_l00004ojRA
_@03o`000?n]Tkco[I>l00;o00000on^Ukl00ol0003o/iZmok>J_@06ok>J_@04o`000?ngW;co]ibl
o`0000Go^J2o00?o0000okfR_OnmX[d01?nmX[d01?l0003o`:K0o`000?o3Z;h2o`0000?oUUV51ol0
0004oj=SQ@05o`000?n]JhGo[F^5oje[QOl000000oncKhD2o`0000Co_7J42?l00004olb3P@07o`00
0?oERgkoeH]nomF;O_l0003ofhmlo`000004onJHM`;o00000_oaXf`01Ol0003onJaHo`000?l0003o
lJ/d00;o00007_ooool00ol0003oooooooooo`0<ooooo`002_ooool00ol0003oooooooooo`0[oooo
o`05o`000?l008Wo0000o`08SOl000000_lT;jD2o`000003od<oZ?l0003o000000GoG5Jc0_l00003
ofmW^P03o`000?mjK[[oNVjj00Co00000on4L[L00ol0003oQgNko`000003ohil^`Ko00000onFPkd0
0ol0003oW8Nloib7_005oib7_003o`000?nRRk_o000000;o00000_nSS[l00ol0003oZ96mojRA_@06
ojRA_@;o00001On^Ukl00ol0003o/iZmok>J_@06ok>J_@03o`000?ngW;co000000Ko^J2o00?o0000
okfR_OnmX[d00onmX[d01?l0003o`:K0ol2V`?o0Y/06o`0000?oUUV500?o0000oj=SQOnSHhD01OnS
HhD01Ol0003o[F^5oje[QOn]JhGo000000?o/fn50_l00007okafQ003o`000?o4O8?o000000;oc8>1
0ol000000oo<Ph7o0000omF;OP02omF;OP03o`000?oKSgco000000GoiYQg0_l00002oo6SK004o`00
0?oi[5So0000oo6[=0;o00007_ooool00ol0003oooooooooo`0<ooooo`002_ooool00ol0003ooooo
ooooo`0[ooooo`05o`00COl0003o0000o`08SOl000000olT;jD01Ol0003o@cnXo`000?m=C;3o0000
00CoG5Jc00?o0000ofmW^_m_IkX00_m_IkX00ol0003oNVjjogY^^P03ogY^^P[o00000on>Okh00ol0
003oUX>moiJ3_@03oiJ3_@03o`000?nLQkcoW8Nl00?oW8Nl1?l00006oj>>_`03o`000?nXTKgoZ96m
00CoZ96m0_l00007ojjG_`03o`000?ncV[go/iZm00Go/iZm0_l00008okVP_`05o`000?nmX[go_J:m
okfR_Ol000000oo0Y/02o`000003ohM=Pol0003oUUV500GoUUV500?o0000oj=SQOnSHhD01OnSHhD0
1Ol0003o[F^5oje[QOn]JhGo000000?o/fn50_l00007okafQ003o`000?o4O8?o000000Goc8>10ol0
0002omF;OP04o`000?oKSgcofhmlo`0000CoiYQg00So0000oo6SK?l0003olJ=/o`000?oi[5So0000
oo6[=0;o00007_ooool00ol0003oooooooooo`0<ooooo`002_ooool00ol0003oooooooooo`0[oooo
o`04o`00COl0003o0000o`0000Co92nU0_l00002ode</003o`000?mLE[?oG5Jc00;oG5Jc00?o0000
ofmW^_m_IkX00om_IkX00ol0003oNVjjogY^^P02ogY^^P;o00001?n6N[l00ol0003oSWnnohio_P04
ohio_P03o`000?nFPkgoUX>m00CoUX>m00?o0000oib7_?l000000_l00002oif;`003o`000?nSS[oo
Xhjo00GoXhjo00Co0000ojRA_OnXTKgoZ96m0ol000000onYUL7o0000ojjG_`06ojjG_`03o`000?nc
V[go/iZm00Co/iZm00?o0000okFN`Ol000002?niX;l01?l0003o_J:mokfR_Ol00003ol2V`005o`00
0?n7CH?oQdf3ohM=Pol000001_nFFHD00ol0003oXf>5oj=SQ@05oj=SQ@05o`000?n]JhGo[F^5oje[
QOl000000oncKhD2o`0000Oo_7J400?o0000olAlPol000001_o<Ph400ol0003oeH]no`000002o`00
00;ofhml00?o0000onJHMooVV7L00_oVV7L00ol0003olJ=/oo6SK002o`000003ooV/F?l0003o0000
00;o00007oooool00ol0003oooooooooo`0;ooooo`002_ooool00ol0003oooooooooo`0[ooooo`;o
000000Co0029o`000?l=7Ygo00000_lT;jD01Ol0003oATbdo`000?m=C;3o000000?oG5Jc0_l00005
ofmW^P05o`000?mjK[[oNVjjogY^^_l000001on6N[l00ol0003oSWnnohio_P04ohio_P03o`000?nF
PkgoUX>m00;oUX>m0ol00006oif;`003o`000?nSS[ooXhjo00CoXhjo00Co0000ojRA_OnXTKgo0000
1?nYUL400ol0003o[YNoojjG_`05ojjG_`03o`000?ncV[go/iZm00;o/iZm0_l00003okFN`@03o`00
0?niX;oo^J2o00Go^J2o00?o0000okfR_Ol000000oo0Y/000ol0003oQdf3ohM=P`02ohM=P`03o`00
0?nFFHGoUUV500CoUUV500?o0000oj=SQOnSHhD01OnSHhD01Ol0003o[F^5oje[QOn]JhGo000000?o
/fn50_l00007okafQ003o`000?o4O8?o000000Koc8>100Co0000omF;O_oERgkoeH]n1?l00004onJH
M`06o`000?oaXfcolJ=/oo6SK?l0003onJaH1?l0000Oooooo`03o`000?oooooooooo00_ooooo000:
ooooo`03o`000?oooooooooo02_ooooo0_l000001?l008Wo01NLo`000?l00002ob@_Y@03o`000?m6
C;CoATbd00;o00000_mLE[<01?l0003oHf2iof=P^Ol00004ofmW^P06o`000?mjK[[oNVjjo`000?mm
MKoo00001_n6N[l00ol0003oSWnnohio_P04ohio_P03o`000?nFPkgo000000;o000000?oUhO1o`00
0?nMRl001_nMRl000ol0003oXhjooj>>_`04oj>>_`;o00001onYUL400ol0003o[YNoojjG_`05ojjG
_`04o`000?ncV[go/iZmo`0000Go]Ik100?o0000okVP_oniX;l01_niX;l01Ol0003o`:K0ol2V`?o0
Y/3o000000GoQdf300?o0000oiIIQOnFFHD01?nFFHD00ol0003oXf>5oj=SQ@05oj=SQ@05o`000?n]
JhGo[F^5oje[QOl000000oncKhD2o`0000Oo_7J400?o0000olAlPol000001_o<Ph401Ol0003oeH]n
omF;O_oERgko000000;ofhml0_l00003onJHM`05o`000?oaXfcolJ=/oo6SK?l000000_oi[5P2o`00
023ooooo00?o0000ooooooooool02oooool000[ooooo00?o0000ooooooooool0:oooool00ol0003o
001_o`00R@02o`0GW0;o92nU00?o0000oc<o/?l000000_m6C;@2o`000005oeaF/ol0003oHf2iof=P
^Ol000001Om_IkX2o`0000?oOGFo1on6N[l00ol0003oSWnnohio_P02ohio_P?o00001OnGQl400ol0
003oWH_0oif;`004oif;`004o`000?nSS[ooXhjooj>>_`?o000000?oY9;2o`000?nYUL401_nYUL40
0ol0003o[YNoojjG_`05ojjG_`03o`000?ncV[go000000Oo]Ik100?o0000okVP_oniX;l01?niX;l2
o`0000;o`:K000?o0000ohM=Pon7CH<01?n7CH<00ol0003oUUV5oiIIQ@04oiIIQ@03o`000?nSHhGo
Xf>500GoXf>500Go0000oje[QOn]JhGo[F^5o`000003ok=_Q@;o00001onlMX@00ol0003oa7b3o`00
0006olb3P@05o`000?oERgkoeH]nomF;O_l000000_oKSg`01_l0003oiYQgo`000?l0003oiYQgo`00
00?olJ=/0_l000001?oi[5So0000o`000?l0000Oooooo`03o`000?oooooooooo00_ooooo000:oooo
o`03o`000?oooooooooo02cooooo00Co0000o`00N_l0003o01NL0_lT;jD00ol0003o<cn`o`000003
odI<]0?o00000_mSH;T00ol0003oKfNjofmW^P03ofmW^P03o`000?mmMKooOGFo00;oOGFo1on6N[l0
0ol0003oSWnnohio_P02o`000003oi24`_l0003oUhO100GoUhO100?o0000oif;`?nMRl001OnMRl00
0ol0003oXhjoo`000005ojBB`P03o`000?nYUL7oZIG100CoZIG100?o0000ojjG_on^Ukl01On^Ukl2
o`0000So]Ik100?o0000okVP_oniX;l00oniX;l00ol0003o_:G2okbU`P03o`0000KoQdf300?o0000
oiIIQOnFFHD01?nFFHD01?l0003oXf>5oj=SQOnSHhDBo`0000?o_7J400?o0000olAlPol000001_o<
Ph401Ol0003oeH]nomF;O_oERgko000000;ofhml00Co0000onJHMooVV7OoiYQg0_l00003oo6SK003
o`000?oi[5So000000?o00007oooool00ol0003oooooooooo`0;ooooo`002_ooool00ol0003ooooo
ooooo`0/ooooo`?o00000_l05i`01?lT;jGo0000oc<o/?l00003odI<]003o`000?mNHKgoGV6m00?o
00001?m_IkX2o`0000CoOGFo00?o0000ohIj_on6N[l01?n6N[l00ol0003oSWnno`000004oi24`P03
o`000?nGQl7oUhO100CoUhO100?o0000oif;`?nMRl000onMRl02o`0000OoY9;200?o0000ojVE`OnY
UL401OnYUL400ol0003o[YNoojjG_`03ojjG_`03o`000?n`W<;o000000So]Ik100?o0000okVP_oni
X;l00_niX;l01ol0003o_:G2okbU`_nlYL;o0000ol2V`?l000001_n7CH<01?l0003oUUV5oiIIQOnF
FHD7o`0000CoXf>500Go0000oje[QOn]JhGo[F^5o`000003ok=_Q@;o00001?nlMX@8o`0000Coc8>1
00?o0000omF;O_oERgh00_oERgh00ol0003ofhmlo`000004onJHM`;o00000_oaXf`00ol0003onJaH
ooV/F003o`0001oooooo00?o0000ooooooooool02oooool000Wooooo00?o0000ooooooooool0;Ooo
ool00ol0003o001_o`000002o`0GW0;o00000_lc?k03odI<]003odmH^ol0003oGV6m00;oGV6m0_l0
0002ofmW^P03o`000?mcKkoo000000GoOGFo1_n6N[l2o`0000GoT8C200?o0000oiN7`OnGQl401?nG
Ql400ol0003oWH_0oif;`003o`000003oij?`ol0003oY9;200KoY9;200?o0000ojVE`OnYUL400_nY
UL4Ko`000005okbU`_l0003o0000og@oPOl000001?n7CH<6o`0000?oUUV500?o0000oj=SQOnSHhD0
1OnSHhD01Ol0003o[F^5oje[QOn]JhGo000000?o/fn50_l00007okafQ003o`000?o4O8?o000000;o
c8>10ol000000oo<Ph7o0000omF;OP03omF;OP03o`000?oKSgco000000CoiYQg00?o0000oo6SK?l0
00000_oaXf`01Ol0003onJaHo`000?oaZcCo000001oooooo00?o0000ooooooooool02oooool000Wo
oooo00?o0000ooooooooool0;Oooool01Ol0003o001_o`000?l0003o01NL00;o9cbb00Oo0000oc<o
/?m6C;CoATbdo`000?m?F;_o000000CoGV6m1?l00002og=__`03o`000?mmMKooOGFo00;oOGFo00?o
0000ohIj_on6N[l00_n6N[l00ol0003oRGo2o`000005oi24`P03o`000?nGQl7oUhO100?oUhO11?l0
0005oij?``03o`000?nTT/;oY9;200?oY9;21_l00003ojZHa004o`000?n^V/;o0000o`0000Go/9k5
00?o0000okFPa?neX<@01_neX<@2o`0000Co^jO50_l00002og@oP@03o`000?n7CH?o000000;o0000
0_n7CH<00ol0003oUUV5oiIIQ@04oiIIQ@03o`000?nSHhGoXf>500GoXf>500Go0000oje[QOn]JhGo
[F^5o`000003ok=_Q@;o00001onlMX@00ol0003oa7b3o`000005olb3P@Go000000CoeH]no`000?oK
Sgco00001?oVV7L01ol0003olJ=/oo6SK?l0003olJ=/o`000?oi[5P00ol0000Oooooo`03o`000?oo
oooooooo00_ooooo0009ooooo`03o`000?oooooooooo02kooooo00Co001_o`00R_l0003o01NL0olW
?;82o`000005odI<]?l0003oCeRkodmH^ol000001?mNHKd00ol0003oLG73og5a``03o`0000CoOGFo
00Go0000ohIj_on6N[ooQWZoo`000003ohUo`P03o`000?n@Q<;oT8C200?oT8C200?o0000oiN7`Ol0
00000_l00002oiR;a003o`000?nNSl?oWXo300CoWXo300?o0000ojBB`_nTT/800ol00002ojFEa@03
o`000?nZV<CoZYS400CoZYS40_l00008ok2Na@03o`000?neX<Co]J3400Co]J340_l00005ok^Wa@03
o`000?md?h7oM3n100?o00001On7CH<00ol0003oUUV5oiIIQ@04oiIIQ@03o`000?nSHhGoXf>500Go
Xf>500Go0000oje[QOn]JhGo[F^5o`000003ok=_Q@;o00001onlMX@00ol0003oa7b3o`000006olb3
P@04o`000?oERgkoeH]nomF;OP;o000000?ofhmlo`000?oVV7L00ooVV7L01?l0003olJ=/oo6SK?oa
Xf`2o`000004ooV/F?l0003o0000o`0001oooooo00?o0000ooooooooool02oooool000Wooooo00?o
0000ooooooooool0;_ooool3o`000003o`0GW?l0003o9cbb00;o9cbb00?o0000odI<]?m?F;/00_m?
F;/00ol0003oGV6moeiQ_@02oeiQ_@GoLG731?l00002ogee_`;oQWZo00?o0000ohUo`_l000002_l0
0005oiR;a003o`000?nNSl?oWXo300?oWXo31?l00006ojFEa@03o`000?nZV<CoZYS400;oZYS400?o
0000oj^Laol000002?n`W/D00ol0003o]J34okFPa003okFPa003o`000?ngYLOo000000Co^jO500Ko
0000og@oPOl0003o0000og@oPOl00006ohM=P`03o`000?nFFHGoUUV500CoUUV500?o0000oj=SQOnS
HhD01_nSHhD01?l0003o[F^5oje[QOl00003ok=_Q@03o`000?ncKhGo000000Ko_7J400?o0000olAl
Pol000001_o<Ph400ol0003oeH]nomF;OP02omF;OP?o00001?oVV7L00ol0003olJ=/oo6SK002oo6S
K005o`000?oi[5So0000oo6[=?l000007oooool00ol0003oooooooooo`0;ooooo`002Oooool00ol0
003oooooooooo`0^ooooo`03o`00A_l0003o002:00;o00001?lW?;801Ol0003oCeRkodmH^om?F;_o
000000?oGV6m00?o0000ofEZ`omaLL<00omaLL<01?l0003oO7S3ogah`omlN<<6o`0000?oR8?600?o
0000oi27aOn@QlD00on@QlD00ol0003oV8_4oiR;a005oiR;a003o`000?nNSl?o000000;o00000_nO
T/H00ol0003oYIG5ojFEa@05ojFEa@05o`000?nZV<CoZYS4ojZHa?l000000on[W<L00ol0003o/9k5
ok2Na@06ok2Na@05o`000?neX<Co]J34okFPa?l000000ongYLL00ol0003o^jO5ok^Wa@03o`0000?o
M3n100?o0000ohM=Pon7CH<01?n7CH<00ol0003oUUV5oiIIQ@05oiIIQ@03o`000?nSHhGoXf>500Go
Xf>500Co0000oje[QOn]JhGo00000oncKhD00ol0003o/fn5o`000007okafQ0;o00001_o<Ph400ol0
003oeH]nomF;OP02omF;OP04o`000?oKSgco0000o`0000CoiYQg00Go0000oo6SK?oaXfcolJ=/o`00
0002ooV/F0;o00008?ooool00ol0003oooooooooo`0:ooooo`002Oooool00ol0003oooooooooo`0_
ooooo`04o`000?l008[o0000o`0000Co9cbb00?o0000odQH_om?F;/00_m?F;/00ol0003oGV6mo`00
0002ofEZ``GoLG7300?o0000ogah`omlN<<00_mlN<<00omoOLOoR8?6ohR3aP05ohR3aP03o`000?n@
QlGoT8O500?oT8O500?o0000oiR;a?nHRl@00onHRl@3o`0000KoWi;600?o0000ojFEaOnUULD01?nU
ULD00ol0003oZYS4ojZHa005oj^La`03o`000?n`W/Go/9k500Ko/9k500?o0000okFPa?neX<@01Ong
YLL01?l0003o^jO5o`000?l00005og@oP@03o`000?n7CH?oQdf300CoQdf300?o0000oiIIQOnFFHD0
1OnFFHD00ol0003oXf>5oj=SQ@05oj=SQ@04o`000?n]JhGo[F^5o`0000?o/fn500?o0000ok=_QOl0
00001onlMX@2o`0000Koc8>100?o0000omF;O_oERgh00_oERgh01?l0003ofhmlo`000?oVV7L2o`00
00;oiYQg00Co0000oo6SK?oaXfcolJ=/0_l000000ooi[5So0000o`00000Pooooo`03o`000?oooooo
oooo00[ooooo0009ooooo`03o`000?oooooooooo02oooooo00Go0000o`00R_l0003o0000o`l/Z`02
obLl/P04o`000?leBkco0000odQH_`;oCeRk00?o0000oeiQ_Ol000000_mUJ/<00ol0003oLG73og5a
``02og5a``04o`000?mlN<?oO7S3ogah``?oOgg71_n8PlH00ol0003oT8O5oi27a@03oi27a@04o`00
0?nHRlCoV8_4oiR;a0;o000000?oVHo7o`000?nOT/H01_nOT/H00ol0003oYIG5ojFEa@03ojFEa@?o
00001on[W<L00ol0003o/9k5ok2Na@05ok2Na@;o00001ongYLL00ol0003o^jO5o`000005og@oP@03
o`000?n7CH?oQdf300CoQdf300?o0000oiIIQOnFFHD01OnFFHD01?l0003oXf>5oj=SQOnSHhDBo`00
00?o_7J40_l00007olb3P@07o`000?oERgkoeH]nomF;O_l0003ofhmlo`000003onJHM`?o00000ooa
Xf`00ol0003onJaHo`000002o`00023ooooo00?o0000ooooooooool02_ooool000Wooooo00?o0000
ooooooooool0;oooool00ol004Ko0000o`00RP02o`0000;o9cbb00?o0000ocE;_?l000000_m8F;l2
odmH^`03o`000?mUJ/?oIF[300;oIF[31?maLL<00ol0003oO7S3ogah``04ogmma`03o`000?n8PlKo
R8?600?oR8?600?o0000oi27aOn@QlD00on@QlD01?l0003oV8_4oiR;a?l00004oiV?a`03o`000?nO
T/KoWi;600CoWi;600?o0000ojFEaOnUULD00ol00002ojJIb0SoZic700?o0000ok2NaOn`W/D00on`
W/D2o`000003ok:Sb?l0003o]jG700Ko]jG700?o0000oeh^OOl000001Omd?h400ol0003oQdf3ohM=
P`04ohM=P`04o`000?nFFHGoUUV5oiIIQ@So00001?nSHhD01?l0003o[F^5oje[QOl00003ok=_Q@03
o`000?ncKhGo000000Co_7J41ol00005olb3P@07o`000?oERgkoeH]nomF;O_l0003ofhmlo`000005
onJHM`;o00000_oaXf`00ol0003onJaHooV/F002o`00023ooooo00?o0000ooooooooool02_ooool0
00Wooooo00?o0000ooooooooool0<?ooool01?l007oo002:o`000?l09Z/2obLl/P03o`000?leBkco
000000?oB5Ro0ol00003ofEZ``GoLG7300?o0000ogmmaomoOLL00omoOLL00ol0003oR8?6ohR3aP04
ohR3aP03o`000?n@QlGoT8O500;oT8O50_l00006oiV?a`03o`000?nOT/KoWi;600?oWi;61?l00006
ojJIb0SoZic700Go0000ok2NaOn`W/Go/9k5o`000004ok:Sb003o`000?ngYLOo]jG700?o]jG700Co
0000oeh^OOmN;Wgo00001Omd?h400ol0003oQdf3ohM=P`02ohM=P`Ko00001?nFFHD00ol0003oXf>5
oj=SQ@05oj=SQ@04o`000?n]JhGo[F^5o`0000?o/fn500?o0000ok=_QOl000001onlMX@2o`0000;o
c8>11?l000000oo<Ph7o0000omF;OP02omF;OP03o`000?oKSgco000000GoiYQg00Go0000oo6SK?l0
003olJ=/o`000002ooV/F0;o00008?ooool00ol0003oooooooooo`0:ooooo`002?ooool00ol0003o
ooooooooo`0aooooo`;o00000ol09Z/01Ol0003o=D^locE;_?leBkco000000;oB5Ro00?o0000of5/
aomQK<L00_l000000omUJ/?o0000og5a``02og5a``;o00001_moOLL00ol0003oR8?6ohR3aP03ohR3
aP03o`000?n@QlGoT8O500;o000000?oTX_8o`000?nISlL01OnISlL00ol0003oWi;6oinBaP03o`00
00;oX9K:00?o0000ojJIb?nVVLP01OnVVLP00ol0003oZic7oj^La`05oj^La`04o`000?n`W/Go0000
o`0000Go/Z?800?o0000okNUaongYLL00_ngYLL01Ol0003oGRimoeh^OOmN;Wgo000000GoM3n100?o
0000ohM=Pol000000_l00002ohM=P`03o`000?nFFHGoUUV500GoUUV500?o0000oj=SQOnSHhD01OnS
HhD01?l0003o[F^5oje[QOl00003ok=_Q@03o`000?ncKhGo000000Oo_7J40_l00006olb3P@Co0000
00GoeH]no`000?oKSgcofhmlo`000004onJHM`03o`000?oaXfcolJ=/00;o00000_oi[5P2o`00023o
oooo00?o0000ooooooooool02_ooool000Sooooo00?o0000ooooooooool0<Oooool00ol0003o001o
o`000002o`0VZ`;o00000_leBk`00ol0003oB5Roo`000002oe9Ra@?oHFc70_l00002og5a``04o`00
0?mfN<OoMWS7o`0000GoOgg700?o0000ohR3a_n8PlH00on8PlH00ol0003oT8O5o`000004oi:;b003
o`000?nISlOoVHo700?oVHo70ol00006oj2FbP03o`000?nVVLSoYYW800GoYYW800?o0000oj^Laon[
W<L01?n[W<L2o`0000Oo/Z?800?o0000okNUaongYLL00_ngYLL01Ol0003oGRimoeh^OOmN;Wgo0000
00CoM3n10ol00005ohM=P`03o`000?nFFHGoUUV500GoUUV500?o0000oj=SQOnSHhD01OnSHhD01?l0
003o[F^5oje[QOl00003ok=_Q@03o`000?ncKhGo000000Oo_7J40_l00007olb3P@03o`000?oERgko
eH]n00?o000000?ofhmlo`000?oVV7L00ooVV7L01Ol0003olJ=/oo6SK?oaXfco000000;onJaH0_l0
000Pooooo`03o`000?oooooooooo00[ooooo0008ooooo`03o`000?oooooooooo03;ooooo00Co001o
o`000?l09Z_o02J[0_lYBKh01Ol0003o=D^lo`000?m8F;oo000000;oDV;51OmQK<L6o`0000GoOgg7
00?o0000ohR3a_n8PlH00on8PlH2o`0000GoTX_800?o0000oiV?aonISlL00ol000000onJTl_o0000
oj2FbP06oj2FbP03o`000?nVVLSoYYW800GoYYW800?o0000oj^Laon[W<L00on[W<L00ol0003o[J3;
o`000008ok:Sb004o`000?ngYLOo0000o`0000CoGRim00?o0000og@oPOmd?h400_l000000omd?h7o
0000ohM=P`05ohM=P`03o`000?nFFHGoUUV500GoUUV500?o0000oj=SQOnSHhD01OnSHhD01Ol0003o
[F^5oje[QOn]JhGo000000?o/fn50_l00007okafQ0;o00001oo<Ph401_l0003oeH]nomF;O_oERgko
0000om^?O0;o00001?oVV7L01Ol0003olJ=/oo6SK?oaXfco000000;onJaH0_l0000Pooooo`03o`00
0?oooooooooo00[ooooo0008ooooo`03o`000?oooooooooo03;ooooo0ol000001_l09Z_o0000obU9
__lYBKko0000ocE;_0;o00000_mBH/D00ol0003oHFc7of5/a`02of5/a`03o`000?mcN/coLg[<00;o
Lg[<1Ol00002ogmma`07o`000?n8PlKoR8?6ohR3a_l0003oRhO9o`000003oi:;b0Go00001OnJTl/0
0ol0003oX9K:oj2FbP05oj2FbP03o`000?nVVLSoYYW800CoYYW800?o0000oj^Laon[W<L00_n[W<L0
0ol0003o[J3;o`00000<o`0000GoGRim0ol00003og@oP@03o`000?n7CH?oQdf300CoQdf300?o0000
oiIIQOnFFHD01OnFFHD00ol0003oXf>5oj=SQ@05oj=SQ@05o`000?n]JhGo[F^5oje[QOl000000onc
KhD2o`0000Oo_7J400?o0000olAlPol000001_o<Ph401Ol0003oeH]nomF;O_oERgko000000;ofhml
0_l00003onJHM`04o`000?oaXfcolJ=/oo6SK0;o000000ConJaHo`000?l0003o00007oooool00ol0
003oooooooooo`0:ooooo`002?ooool00ol0003oooooooooo`0booooo`05o`000?l007oo0000o`0V
Zol000000olYBKh2o`0000CoDV;51?mQK<L6og=jc004o`000?mnPLcoOX7<ogj1c0co00000onBSld0
0ol0003oVY?;oiZCb`04oiZCb`03o`000?nPU/[oX9K:00GoX9K:00?o0000ojJIb?nVVLP00_nVVLP9
o`0000;o[J?=00?o0000ok:UbonbYL/01_nbYL/2o`0000CoGRim0_l00005og@oP@03o`000?n7CH?o
Qdf300CoQdf300?o0000oiIIQOnFFHD01OnFFHD00ol0003oXf>5oj=SQ@05oj=SQ@05o`000?n]JhGo
[F^5oje[QOl000000oncKhD2o`0000Oo_7J400?o0000olAlPol000001_o<Ph401Ol0003oeH]nomF;
O_oERgko000000;ofhml00Ko0000onJHMol0003o0000onJHMol00003oo6SK003o`000?oi[5So0000
00?o00008?ooool00ol0003oooooooooo`09ooooo`002?ooool00ol0003oooooooooo`0cooooo`Co
000000Co4CVhobU9__lYBKko:DVn0ol00002oe9Ra@?oHFc700?o0000ofMcc?mcN/`01OmcN/`00ol0
003oOX7<ogj1c003ogj1c003o`000?n:RlkoRX_>00;oRX_>00?o0000oi:?cOnBSld01OnBSld00ol0
003oVY?;oiZCb`04oiZCb`03o`000?nPU/[oX9K:00?oX9K:1_l00002ojJLb`?o00001on]Xld00ol0
003o/ZG;ok:Ub`05ok:Ub`;o00000_mN;Wd2o`000003oeh^OOl0003oM3n100CoM3n100?o0000ohM=
Pon7CH<01?n7CH<00ol0003oUUV5oiIIQ@05oiIIQ@04o`000?nSHhGoXf>5oj=SQA;o00000onlMX@0
0ol0003oa7b3o`000006olb3P@05o`000?oERgkoeH]nomF;O_l000000_oKSg`01?l0003oiYQgonJH
MooVV7L2o`0000?olJ=/00?o0000ooV/F?oi[5P00ol0000Pooooo`03o`000?oooooooooo00Wooooo
0008ooooo`03o`000?oooooooooo03?ooooo0ol000000ol0=;So0000obU9_P02obU9_P03o`000?m;
Hl[oBf?:00?o00000_mQK<L00ol0003oIg?<o`000005og=jc003o`000?mnPLcoOX7<00;oOX7<0_l0
0005ohZ;cP03o`000?nBSlgoTXo=00CoTXo=00?o0000oiZCbonJTl/01?nJTl/00ol0003oX9K:oj2F
bP03o`0000;oXIW=00Co0000ojJLbonVW<_oYYc;0_l000000onWX<oo0000ojfSc@07ojfSc@03o`00
0?nbYL_o/ZG;00?o/ZG;0_l000001?m36WKo0000o`000?l00003oeh^O@03o`000?md?h7oM3n100?o
M3n100?o0000ohM=Pon7CH<01?n7CH<01?l0003oUUV5oiIIQOnFFHD8o`0000CoXf>500Go0000oje[
QOn]JhGo[F^5o`000003ok=_Q@;o00001?nlMX@8o`0000Coc8>100?o0000omF;O_oERgh00_oERgh0
0ol0003ofhmlo`000004onJHM`;o00000ooaXf`01Ol0003onJaHo`000?oaZcCo0000023ooooo00?o
0000ooooooooool02Oooool000Sooooo00?o0000ooooooooool0<oooool4o`000006o`0d^?lYBKko
:DVnobU9__l0003o=eO60om;HlX01?l0003oHFc7of5/aol00002ofMcc003o`000?mcN/coLg[<00?o
Lg[<00Co0000ogj1c?mnPLco00000_n1Q/l00ol0003oRX_>ohZ;cP02ohZ;cP03o`000?nBSlgoTXo=
00GoTXo=00?o0000oiZCbonJTl/00onJTl/3o`0000CoXIW=1?l00005ojNPc`03o`000?n]Xlgo[J?=
00Ko[J?=00Co0000ok:UbonbYL_o/ZG;0ol000000om36WKo0000oeh^O@04oeh^O@03o`000?md?h7o
M3n100?oM3n100?o0000ohM=Pon7CH<00_n7CH<6o`0000CoUUV500?o0000oj=SQOnSHhD01OnSHhD0
1Ol0003o[F^5oje[QOn]JhGo000000?o/fn50_l00007okafQ003o`000?o4O8?o000000;oc8>10ol0
00000oo<Ph7o0000omF;OP03omF;OP03o`000?oKSgco000000CoiYQg00Oo0000oo6SK?l0003o0000
oo6SK?l0003onJaH00?o00008?ooool00ol0003oooooooooo`09ooooo`001oooool00ol0003ooooo
ooooo`0eooooo`03o`000?l008go000000;o03Bh00Co:DVno`000?lgElKo=eO61?m;HlX3o`0000;o
Ig?<00?o0000og=jc?mcN/`00omcN/`00ol0003oOX7<o`000003oh66c`03o`000?n:RlkoRX_>00?o
RX_>00?o0000oi:?cOnBSld01?nBSld01?l0003oVY?;oiZCbonJTl/2o`000004oi^Fc_l0003oXIW=
oj6Ic@?o00000_nRWM000ol0003oYj3?ojNPc`04ojNPc`03o`000?n]Xlgo[J?=00Ko[J?=00?o0000
ok:UbonbYL/00_ndZ/l4o`0000GoGRim00?o0000og@oPOmd?h400omd?h400ol0003oQdf3o`000002
o`0000;oQdf300?o0000oiIIQOnFFHD01OnFFHD00ol0003oXf>5oj=SQ@05oj=SQ@05o`000?n]JhGo
[F^5oje[QOl000000oncKhD2o`0000Oo_7J400?o0000olAlPol000001Oo<Ph45o`000004omF;O_l0
003ofhmlo`0000CoiYQg00Co0000oo6SK?oaXfcolJ=/0_l000001?oi[5So0000o`000?l0000Poooo
o`03o`000?oooooooooo00Wooooo0007ooooo`03o`000?oooooooooo03Gooooo0_l008d3o`0d^005
obU9__l0003o=eO6ocMGa_l000001?m;HlX2of=fd0?o00001_mcN/`00ol0003oPHK?oh66c`03oh66
c`03o`000?n:RlkoRX_>00;oRX_>00?o0000oi:?cOnBSld01?nBSld01?l0003oVY?;o`000?l00003
oi^FcP?o00001_nRWM000ol0003oYj3?ojNPc`04ojNPc`03o`000?n]Xlgo[J?=00Go[J?=0_l00002
okBZc`05o`000?la377o0000od<JM_l000001OmN;Wd00ol0003oM3n1og@oP@02og@oP@?o00001On7
CH<00ol0003oUUV5oiIIQ@05oiIIQ@03o`000?nSHhGoXf>500GoXf>500Go0000oje[QOn]JhGo[F^5
o`000003ok=_Q@;o00001onlMX@00ol0003oa7b3o`000006olb3P@04o`000?oERgkoeH]nomF;OP;o
000000?ofhmlo`000?oVV7L00ooVV7L00ol0003olJ=/oo6SK002oo6SK005o`000?oi[5So0000oo6[
=?l000008?ooool00ol0003oooooooooo`09ooooo`001oooool00ol0003oooooooooo`0fooooo`;o
002=0ol0=;P2o`0000;o=eO60om;HlX00ol0003oDfg?of=fd003of=fd0?o00000_mcN/`2o`0000Go
PHK?00?o0000ohZ;c_n:Rlh00on:Rlh00ol0003oTXo=oi:?c@03oi:?c@;o00000_nKU/h3o`000003
oi^Jd_l0003oXYg@00KoXYg@00?o0000ojNPconWX<l01OnWX<l01?l0003o[J?=ojfScOn]Xld3o`00
0009ojjXdOl0003o]:[?okBZcol0003o<@aao`000?m36WKo000000GoGRim00?o0000og@oPOmd?h40
0_l000000omd?h7o0000ohM=P`05ohM=P`03o`000?nFFHGoUUV500GoUUV500?o0000oj=SQOnSHhD0
1OnSHhD01Ol0003o[F^5oje[QOn]JhGo000000?o/fn50_l00007okafQ003o`000?o4O8?o000000Ko
c8>100?o0000omF;O_oERgh00_oERgh3o`0000CoiYQg00?o0000oo6SK?oaXf`00_oaXf`00ol0003o
nJaHooV/F002o`00023ooooo00?o0000ooooooooool02Oooool000Oooooo00?o0000ooooooooool0
=oooool01?l008go0000o`0d^?l0=;P2ob]FbP;o00000om;HlX00ol0003oDfg?o`000003of=fd003
o`000?m`O]7oL7kA00So000000?oPHK?o`000?n:Rlh01?n:Rlh00ol0003oTXo=oi:?c@07o`0000Go
Vi[B00?o0000oj:Md?nRWM001?nRWM000ol0003oYj3?ojNPc`05ojNPc`04o`000?n]Xlgo0000o`00
00Go[ZSA1Ol000000om36WKo0000oeh^O@04oeh^O@?o00000omd?h400ol0003oQdf3ohM=P`04ohM=
P`03o`000?nFFHGoUUV500GoUUV500?o0000oj=SQOnSHhD01OnSHhD01Ol0003o[F^5oje[QOn]JhGo
000000?o/fn50_l00007okafQ003o`000?o4O8?o000000Koc8>100?o0000omF;O_oERgh00_oERgh0
1?l0003ofhmlo`000?l00004onJHM`04o`000?oaXfcolJ=/oo6SK0;o000000ConJaHo`000?l0003o
00007oooool00ol0003oooooooooo`09ooooo`001oooool00ol0003oooooooooo`0gooooo`04o`00
SOl0003o02beo`0d^0Co:eK:00Ko0000od]Sb_m;Hl[o0000oe=]col00004of=fd004o`000?m`O]7o
L7kAo`0000;oMHCD1?n0RM<;o`0000CoU9OC00?o0000oi^Jd_nKV]801?nKV]800ol0003oXYg@oj:M
d005oj:Md003o`000?nWX<ooYj3?00CoYj3?0_l00008ojjXd@;o000000Co<@aao`000?m36WKo0000
1?mN;Wd2o`0000GoM3n100?o0000ohM=Pon7CH<01?n7CH<00ol0003oUUV5oiIIQ@05oiIIQ@03o`00
0?nSHhGoXf>500GoXf>500Ko0000oje[QOn]JhGo[F^5o`000?ncKhD4o`0000Oo_7J400?o0000olAl
Pol000001_o<Ph400ol0003oeH]nomF;OP02omF;OP04o`000?oKSgco0000onJHM`;o00000_oVV7L0
1_l0003olJ=/oo6SK?oaXfco0000ooV/F0Co00007oooool00ol0003oooooooooo`09ooooo`001ooo
ool00ol0003oooooooooo`0hooooo`04o`00SOl0003o02beo`0d^0Co:eK:00?oBf?:o`000?mCKLl0
0_mCKLl01ol0003oHgK@of=fd?mSM]3o0000og1ndOl000001?meQ=@5oh29d`03o`000?n9Sm;oRHoB
00?oRHoB0_l00006oiBGd`03o`000?nKV];oVi[B00CoVi[B00?o0000oj:Md?nRWM001?nRWM001?l0
003oYj3?ojNPconWX<l3o`000003ojVUdol0003o[ZSA00Ko[ZSA0ol000001?la377o0000od<JM_l0
0002oeh^O@;o000000?oGRimo`000?md?h401?md?h400ol0003oQdf3ohM=P`04ohM=P`03o`000?nF
FHGoUUV500GoUUV500Co0000oj=SQOnSHhGoXf>54_l00003okafQ003o`000?o4O8?o000000Ooc8>1
00Oo0000omF;O_oERgkoeH]no`000?oKSgco000000?oiYQg0ol00003oo6SK003o`000?oi[5SonJaH
00?o00008?ooool00ol0003oooooooooo`08ooooo`001oooool00ol0003oooooooooo`0hooooo`05
o`00Nol0003o02beo`0/]Ol000000ol[E/X3o`0000;oDfg?00?o0000of=fd?mSM]000_mSM]000ol0
003oMHCDogF4e003ogF4e003o`000?n0RM?oP8WC00?oP8WC00?o0000ohV?d_n9Sm800_n9Sm800on<
T]Go0000oiBGd`05oiBGd`03o`000?nKV];oVi[B00CoVi[B00?o0000oj:Md?nRWM001?nRWM001?l0
003oYj3?o`000?l00005ojVUd`03o`000?n^Z=7o[ZSA00Co[ZSA00Ko0000o`T0I?l0003o<@aao`00
0?m36WH3o`0000?oGRim00?o0000og@oPOmd?h400omd?h400ol0003oQdf3ohM=P`04ohM=P`04o`00
0?nFFHGoUUV5oiIIQ@So00001?nSHhD3o`000003oje[QOl0003o/fn500?o/fn500?o0000okafQ?nl
MX@00_nlMX@8o`0000Goc8>100Oo0000omF;O_oERgkoeH]no`000?oKSgco000000GoiYQg0_l00002
oo6SK006o`000?oi[5SonJaHo`000?oaZcCo00008?ooool00ol0003oooooooooo`08ooooo`001ooo
ool00ol0003oooooooooo`0iooooo`03o`000?l05JGo02be00;o00000ol[E/X2oda^e0?o00001?mS
M]000ol0003oMHCDogF4e003ogF4e003o`000?n0RM?oP8WC00?oP8WC00Co0000ohV?d_n9Sm;oRHoB
0on<T]D00ol0003oU9OCoiBGd`04oiBGd`03o`000?nKV];oVi[B00CoVi[B00?o0000oj:Md?nRWM00
0onRWM02o`0000OoZJGC00?o0000ojjXdOn^Z=400_n^Z=402Ol0003o[ZSAo`000?l906Co0000oc4<
LOl0003o@aYfo`000005oeh^O@03o`000?md?h7oM3n100?oM3n100?o0000ohM=Pon7CH<00_n7CH<6
o`0000CoUUV500Co0000oj=SQOnSHhGoXf>51Ol00003oje[Q@03o`000?ncKhGo/fn500;o/fn50_l0
0006okafQ003o`000?o4O8?o000000;oc8>11?l000000oo<Ph7o0000omF;OP02omF;OP03o`000?oK
Sgco000000GoiYQg00Go0000oo6SK?l0003olJ=/o`000002ooV/F0?o00008?ooool00ol0003ooooo
ooooo`08ooooo`001_ooool00ol0003oooooooooo`0kooooo`05o`000?l0;;Go0000o`12`ol00000
0_l[E/X00ol0003oC6kDoda^e002oda^e0;o000000CoHgK@o`000?mXOMCo00001OmeQ=@00ol0003o
P8WCoh29d`02oh29d`03o`000?n9Sm;oRHoB00CoS9;E00?o0000oiBGdonDUm<01?nDUm<00ol0003o
Vi[Boi^JdP04oi^JdP03o`000?nRWM3oXYg@00?o000000?oXj;Eo`000?nYYM<01onYYM<01?l0003o
[ZSAojjXdOn^Z=42o`0000;o2@1T00?o0000oc4<LOm36WH00_l00005oeh^O@03o`000?md?h7oM3n1
00?oM3n100?o0000ohM=Pol000000_l00002ohM=P`03o`000?nFFHGoUUV500GoUUV51?l00004oj=S
Q@05o`000?n]JhGo[F^5oje[QOl000001?ncKhD00ol0003o_7J4o`000005okafQ003o`000?o4O8?o
000000Koc8>11?l000001OoERgko0000om^?O?oKSgco000000CoiYQg00?o0000oo6SK?oaXf`00_l0
0002ooV/F0?o00008?ooool00ol0003oooooooooo`08ooooo`001_ooool00ol0003oooooooooo`0k
ooooo`;o000000Go02beo`000?lKE<co6eC<ob]FbP02o`0000?oC6kD00?o0000oeeie_mMNMH00ol0
0005ogF4e003o`000?n0RM?oP8WC00?oP8WC00?o0000ohbBeOn<T]D01?n<T]D00ol0003oU9OCoiBG
d`03oiBGd`03o`000?nKV];oVi[B00;oVi[B1Ol00005oj>Re@03o`000?nYYM?oZJGC00GoZJGC00?o
0000ojjXdOn^Z=400ol00002o`T0I005o`000?la377o0000od<JM_l000001OmN;Wd00ol0003oM3n1
og@oP@02og@oP@?o00001On7CH<00ol0003oUUV5oiIIQ@03oiIIQ@?o00001onSHhD01Ol0003o[F^5
oje[QOn]JhGo000000Co/fn500Co0000okafQ?nlMXCo00001?nlMX@00ol0003oa7b3o`000007olb3
P@03o`000?oERgkoeH]n00?o000000?ofhmlo`000?oVV7L00ooVV7L01Ol0003olJ=/oo6SK?oaXfco
000000;onJaH00?o0000oo6[=?l000008?ooool00ol0003oooooooooo`08ooooo`001_ooool00ol0
003oooooooooo`0looooo`04o`08VOl0;;Go0000o`12``;o6eC<0ol00003oda^e003o`000?mMNMKo
000000;oI83I1?l000000omeQ=Co0000oh29d`04oh29d`;o00001On<T]D01?l0003oU9OCoiBGdonD
Um<7o`0000?oVioG00?o0000oj>ReOnSX]D01OnSX]D00ol0003oZJGCojVUd`02ojVUd`Go000000?o
/:oGo`000?l906@00_l906@01Ola377o0000o`000?m36WKo000000GoGRim00?o0000og@oPOmd?h40
0_l000000omd?h7o0000ohM=P`05ohM=P`03o`000?nFFHGo000000?o00000_nFFHD00ol0003oXf>5
oj=SQ@06oj=SQ@04o`000?n]JhGo[F^5o`0000Go/fn500Co0000okafQ?nlMXCo00000onlMX@00ol0
003oa7b3o`000007olb3P@06o`000?oERgkoeH]nomF;O_l0003ofhml0_l00004onJHM`05o`000?oa
XfcolJ=/oo6SK?l000000_oi[5P00ol0003olJ/do`00000Pooooo`03o`000?oooooooooo00Sooooo
0006ooooo`03o`000?oooooooooo03cooooo00Co0000o`08VOl0003o00000_lKE<`00ol0003o;6;D
o`000004oda^e0;o00000_mTP=T01?l0003oLHOIog67fOmaQmTBo`0000?oTi_H00?o0000oi^OeonK
WmL01OnKWmL00ol0003oXj;Eoj>Re@03oj>Re@Ko00000_nYYmD01Ol0003oZZcIo`000?n`[mOo0000
00?o2@1T00Go0000oc4<LOl0003o@aYfo`000005oeh^O@?o00000omd?h400ol0003oQdf3ohM=P`03
ohM=P`?o00001_nFFHD00ol0003oXf>5oj=SQ@06oj=SQ@04o`000?n]JhGo[F^5o`0000Go/fn500Go
0000okafQ?nlMXCo_7J4o`000003okafQ003o`000?o4O8?o000000Koc8>100Go0000omF;O_oERgko
eH]no`000002om^?O0;o00001?oVV7L00ol0003olJ=/oo6SK002o`000004ooV/F?l0003olJ/do`00
023ooooo00?o0000ooooooooool02?ooool000Kooooo00?o0000ooooooooool0?Oooool01_l0003o
03Zoo`0j_ol0003o6eC<o`0000;o;6;D0_l00003oda^e005o`000?mTP=WoI83IofB0fOl000001?ma
QmT01Ol0003oOXkIogj>fOmnS]Wo000000;oPI;K00?o0000oh^Gf_n;UmX00on;UmX00ol0003oTi_H
oi>Kf004oi>Kf003o`000?nKWmOoVioG00CoVioG00?o0000oj>ReOnSX]D00ol00002oj>Te`04o`00
0?nYYmGoZJOEojVWe@GoZZcI0_l00003o`T0I005o`000?la377o0000od<JM_l000001?mN;Wd2o`00
00GoM3n100?o0000ohM=Pol000000ol00002ohM=P`03o`000?nFFHGoUUV500CoUUV500?o0000oj=S
QOnSHhD01_nSHhD01?l0003o[F^5oje[QOl00005ok=_Q@05o`000?nlMXCo_7J4okafQ?l000000onl
MX@00ol0003oa7b3o`000006olb3P@05o`000?oERgkoeH]nomF;O_l000000_oKSg`01?l0003oiYQg
o`000?l00002onJHM`05o`000?oaXfcolJ=/o`000?oi[5P00_l000000ooaZcCo0000ooooo`0Ooooo
o`03o`000?oooooooooo00Sooooo0006ooooo`03o`000?oooooooooo03kooooo00Oo00RIo`0j_ol0
>[oo0000oa]Dc?l0003o;6;D00;o@W3I00Co0000oda^e?m<K]Co00001?mTP=T00ol0003oLHOIog67
f@02og67f@03o`000?mnS]Wo000000CoPI;K00?o0000oh^Gf_n;UmX00on;UmX00ol0003oTi_Hoi>K
f003oi>Kf003o`000?nKWmOoVioG00CoVioG0ol00004oj>Te`?o00001onZ[=T2o`0000;o2@1T0_l0
00001?la377o0000od<JM_l00002oeh^O@;o000000?oGRimo`000?md?h400omd?h43o`0000KoQdf3
00?o0000oiIIQOnFFHD01?nFFHD00ol0003oXf>5oj=SQ@02oj=SQA?o00000_nlMX@00ol0003oa7b3
o`000006olb3P@05o`000?oERgkoeH]nomF;O_l000000_oKSg`01?l0003oiYQgonJHMooVV7L3o`00
00;olJ=/00Ko0000ooV/F?oi[5So0000oo6[=?l0000Pooooo`03o`000?oooooooooo00Sooooo0006
ooooo`03o`000?oooooooooo03oooooo00Go00RIo`0j_ol0>[oo6eC<o`000002obaRe0?o@W3I0ol0
0003ofB0f@03o`000?maQmWoLHOI00?oLHOI00?o0000oh6Bfon1T]/00on1T]/00ol0003oRiOJoh^G
fP04oh^GfP03o`000?nCVmSoTi_H00?oTi_H00Co0000oi^OeonKWmOoVioG0_l000001?nLX]So0000
oj>TeonSY=L3o`0000;oY:[K00?o0000ojZ/fOnZ[=T01OnZ[=T2o`000007o`T0I?l0003o2@1To`00
0?la377o0000od<JMP03o`0000?oGRim00?o0000og@oPOl000000_l000000omd?h7o0000ohM=P`06
ohM=P`04o`000?nFFHGoUUV5oiIIQ@So00001?nSHhD01?l0003o[F^5oje[QOl00005ok=_Q@03o`00
0?nlMXCo_7J400;o_7J42?l00004olb3P@03o`000?oERgkoeH]n00;oeH]n00?o0000om^?O?l00000
1OoVV7L2o`0000;olJ=/00Go0000ooV/F?l0003olJ/do`00000Qooooo`03o`000?oooooooooo00Oo
oooo0006ooooo`03o`000?oooooooooo03oooooo00CoTQL0o`000?l0>[oo03Zo0_l00002obaRe0;o
@W3I00?o0000odaigOl000000ol000000omTP=Wo0000og67f@03og67f@03o`000?n1T]_oPI;K00Co
PI;K00?o0000oh^Gf_n;UmX00on;UmX00ol0003oTi_Hoi>Kf003oi>Kf005o`000?nKWmOo0000o`00
0?nLX]P01Ol00006ojBZf`03o`000?nZ[=WoZZcI00CoZZcI0ol00002o`T0I005o`000?la377o0000
od<JM_l000000omN;Wd4o`0000CoM3n100?o0000ohM=Pon7CH<00on7CH<6o`0000?oUUV500?o0000
oj=SQOnSHhD01_nSHhD01?l0003o[F^5oje[QOl00005ok=_Q@03o`000?nlMXCo_7J400Co_7J40_l0
00001?o4O8?o0000olb3POo<Ph43o`000003olb3POl0003oeH]n00?oeH]n00?o0000om^?O?l00000
1OoVV7L01_l0003olJ=/o`000?oaXfco0000ooV/F0?o00008Oooool00ol0003oooooooooo`07oooo
o`001Oooool00ol0003oooooooooo`11ooooo`05oi8G0?l0003o03Zoo`000?lLH=H00ol000001?m2
L=Wo0000odaigOl00003oej3gPCo000000CoLHOIo`000?mfS=co00001On1T]/00ol0003oRiOJoh^G
fP04oh^GfP03o`000?nCVmSoTi_H00?oTi_H1?l00003oibWg@03o`000?nTZ]_oY:[K00KoY:[K00?o
0000ojZ/fOnZ[=T00onZ[=T2o`0000?o2@1T00?o0000oc4<LOm36WH01Ol00002oeh^O@03o`000?md
?h7oM3n100?oM3n100?o0000ohM=Pol000000ol00002ohM=P`03o`000?nFFHGoUUV500CoUUV500?o
0000oj=SQOnSHhD01_nSHhD01?l0003o[F^5oje[QOl00005ok=_Q@03o`000?nlMXCo_7J400Go_7J4
00?o0000olAlPol000001Oo<Ph43o`0000?oeH]n00Co0000om^?O?oKSgco00001?oVV7L00ol0003o
lJ=/oo6SK002o`000004ooV/F?l0003o0000o`00027ooooo00?o0000ooooooooool01oooool000Go
oooo00?o0000ooooooooool0@_ooool2o`0`]`05o`0j_ol0003o763FoaaPe_l000000_m2L=T00ol0
003oC7WMo`000004oej3gP03o`000?m]RmooKH_O00Oo000000?oPI;Ko`000?n;UmX00on;UmX8o`00
0003oiBSgol0003oW:OM00GoW:OM00?o0000ojBZfonTZ]/01OnTZ]/00ol0003oZZcIojZ/f@02ojZ/
f@?o00000ol906@00ol0003o<@aao`000002o`0000GoGRim00?o0000og@oPOmd?h400_md?h43o`00
00KoQdf300?o0000oiIIQOnFFHD01?nFFHD00ol0003oXf>5oj=SQ@06oj=SQ@04o`000?n]JhGo[F^5
o`0000Go/fn500?o0000okafQ?nlMX@01OnlMX@3o`0000Koc8>100?o0000omF;O_l000000ol00002
om^?O003o`000?oVV7OoiYQg00;oiYQg00Wo0000oo6SK?oaXfcolJ=/o`000?oi[5So0000oo6[=?l0
00008Oooool00ol0003oooooooooo`07ooooo`001Oooool00ol0003oooooooooo`13ooooo`;o032g
0_l00003oaaPeP05od9`fOl0003oC7WModaigOl000001?mNPmh00ol0003oKH_Oo`000002og:@h@04
o`000?mnUn3oOYOPogjGh0Ko00000on9W=l00ol0003oTj7Mo`000004oiBSg`03o`000?nLYmgoW:OM
00CoW:OM00?o0000ojBZfonTZ]/01OnTZ]/00ol0003oZZcIo`000004o`000003o`T0I?l0003o0000
00?o000000?o@aYfo`000?mN;Wd01?mN;Wd00ol0003oM3n1og@oP@02o`000003og@oPOl0003oQdf3
00KoQdf300?o0000oiIIQOnFFHD01?nFFHD00ol0003oXf>5oj=SQ@06oj=SQ@05o`000?n]JhGo[F^5
oje[QOl000001?ncKhD00ol0003o_7J4okafQ005okafQ003o`000?o4O8?o000000Koc8>100?o0000
omF;O_oERgh00_oERgh4o`0000CoiYQg00Go0000oo6SK?oaXfcolJ=/o`000002ooV/F0?o00008?oo
ool00ol0003oooooooooo`07ooooo`001Oooool00ol0003oooooooooo`14ooooo`;o032g0_l00002
oaaPeP?o000000?oC7WMo`000?mNPmh00omNPmh2o`0000CoLY3Q00?o0000ogjGh?mnUn000_mnUn08
ohVLg`03o`000?nDXmooU:?O00CoU:?O00?o0000oibWgOnLYmd00onLYmd00ol0003oY:[KojBZf`04
ojBZf`?o00000_n[/]d4o`0000;o2@1T00Go0000oc4<LOl0003o@aYfo`000005oeh^O@?o00000omd
?h400ol0003oQdf3ohM=P`05ohM=P`03o`000?nFFHGoUUV500CoUUV500?o0000oj=SQOnSHhD01_nS
HhD01Ol0003o[F^5oje[QOn]JhGo000000Co/fn500?o0000okafQ?nlMX@01OnlMX@01?l0003oa7b3
o`000?l00005olb3P@03o`000?oERgkoeH]n00;oeH]n00?o0000om^?O?oKSg`00_l00003onJHM`04
o`000?oaXfcolJ=/oo6SK0;o000000ConJaHo`000?l0003o00008?ooool00ol0003oooooooooo`07
ooooo`001Oooool00ol0003oooooooooo`15ooooo`04o`0`]ol0003o04O7o`0000;o763F00?o0000
od9jhOl000000_l00004oej3gP03o`000?mbT>7oLY3Q00?oLY3Q00?o0000ogjGh?mnUn000_mnUn06
ohVLg`;o00001_nDXml00ol0003oW:OMoibWg@04oibWg@03o`000?nTZ]_oY:[K00?o00000_nT[n06
o`0000?o2@1T00Go0000oc4<LOl0003o@aYfo`000004oeh^O@;o00001Omd?h400ol0003oQdf3ohM=
P`05ohM=P`03o`000?nFFHGoUUV500CoUUV500?o0000oj=SQOnSHhD01_nSHhD01Ol0003o[F^5oje[
QOn]JhGo000000Co/fn500?o0000okafQ?nlMX@01OnlMX@01?l0003oa7b3o`000?l00005olb3P@03
o`000?oERgkoeH]n00;oeH]n00Go0000om^?O?oKSgco0000onJHM`02o`000003onJHMol0003olJ=/
00;olJ=/00?o0000ooV/F?l000000ol0000Pooooo`03o`000?oooooooooo00Oooooo0005ooooo`03
o`000?oooooooooo04Kooooo00Ko032go`000?l7G=Go1ecEoaaPe_l00004od9jh@?o000000?oGX?N
o`000?l000001?mbT>400ol0003oOYOPogjGh003ogjGh0CoRIcO00Co0000ohbOhOn<Wn7o00001_nD
Xml01?l0003oW:OMoibWgOnLYmd5o`0000;oY:oP1Ol000001?n[/]go0000o`000?l00002o`T0I0;o
000000Co<@aao`000?m36WKo00000_mN;Wd2o`000003oeh^OOl0003oM3n100CoM3n100?o0000ohM=
Pon7CH<01On7CH<00ol0003oUUV5oiIIQ@04oiIIQ@03o`000?nSHhGoXf>500;oXf>53?l000000onc
KhGo0000okafQ006okafQ005o`000?o4O8?o0000olb3POl000001Oo<Ph401Ol0003oeH]nomF;O_oE
Rgko000000;ofhml00Co0000onJHMooVV7OoiYQg0_l00003oo6SK003o`000?oi[5SonJaH00?o0000
8?ooool00ol0003oooooooooo`07ooooo`001Oooool00ol0003oooooooooo`17ooooo`06o`000?l0
AlOo1ecEo`MLeOlLH=Ko00000om2N^43oeJ6i0Oo000000?oLY3Qo`000?mnUn001?mnUn02ohVLg`05
o`000?n<Wn7oS9oQohbOhOl000001?nDXml6o`0000?oW:cR1?l00005ojB_h0;o000000Wo000ho`00
0?l906Co0000o`T0I?l0003o<@aao`000?m36WH00ol00003oeh^O@03o`000?md?h7oM3n100CoM3n1
00?o0000ohM=Pon7CH<01?n7CH<00ol0003oUUV5oiIIQ@02oiIIQ@Oo00001?nSHhD01Ol0003o[F^5
oje[QOn]JhGo000000?o/fn53?l00002olb3P@03o`000?o<Ph7oc8>100;oc8>100Go0000omF;O_oE
RgkoeH]no`000002om^?O003o`000?oVV7OoiYQg00;oiYQg0_l00003oo6SK005o`000?oi[5So0000
oo6[=?l000008?ooool00ol0003oooooooooo`07ooooo`001Oooool00ol0003oooooooooo`18oooo
o`;o00000_l7G=D3o`0000;o@W[Q0omFQ^@00ol0003oGXcVo`000003offEi`So000000?oRIcOo`00
0?l000001ol00003oi>Yi004o`000?nL[>;oW:cRoib/hPCo00001onT[n02o`000003o`00>?l0003o
000000;o2@1T00Go0000oc4<LOl0003o@aYfo`000005oeh^O@03o`000?md?h7oM3n100CoM3n100?o
0000ohM=Pon7CH<01?n7CH<00ol0003oUUV5o`000002o`0000;oUUV500?o0000oj=SQOnSHhD01_nS
HhD01Ol0003o[F^5oje[QOn]JhGo000000Co/fn500?o0000okafQ?nlMX@01OnlMX@00ol0003oa7b3
o`000004o`0000?oc8>100Go0000omF;O_oERgkoeH]no`000002om^?O003o`000?oVV7OoiYQg00;o
iYQg00Oo0000oo6SK?l0003o0000oo6SK?l0003onJaH00?o00008Oooool00ol0003oooooooooo`06
ooooo`001?ooool00ol0003oooooooooo`1:ooooo`;o000000Co1ecEo`000?l0003o=7_T0_l00000
1?m2N^7oEXKToeJ6i?l00002oej<iP03o`000?m]UNOoKIGW00;oKIGW00?o0000og^Li_mkW>H00omk
W>H00ol0003oRZCVohZTiP03ohZTiP03o`000?nCZNCoTjWT00CoTjWT1?l00004oib/hP03o`000?nT
[n3oY:oP00GoY:oP00?o0000o`00>?l000000ol906@00ol0003o<@aaod<JMP02o`0000GoGRim00?o
0000og@oPOmd?h401?md?h400ol0003oQdf3ohM=P`02ohM=P`Co00001OnFFHD00ol0003oXf>5oj=S
Q@06oj=SQ@05o`000?n]JhGo[F^5oje[QOl000001?ncKhD00ol0003o_7J4okafQ005okafQ003o`00
0?o4O8?o000000Coc8>11Ol00002omF;OP04o`000?oKSgcofhmlo`0000CoiYQg00Co0000oo6SK?oa
XfcolJ=/0_l000001?oi[5So0000o`000?l0000Qooooo`03o`000?oooooooooo00Kooooo0004oooo
o`03o`000?oooooooooo04_ooooo0_l000000ol7G=Go0000o`000002ocAki0;o000000?oEXKTo`00
0?mNS>H00_mNS>H00ol0003oKIGWoffEi`02offEi`03o`000?mkW>KoNicV00;oNicV0_l00005ohZT
iP03o`000?nCZNCoTjWT00?o00000_nCZN@00ol0003oW:cRoib/hP04oib/hP03o`000?nT[n3oY:oP
00?o000000CoY;KUo`000?l003So00000ol906@01Ol0003o<@aao`000?m36WKo000000GoGRim00?o
0000og@oPOmd?h401?md?h400ol0003oQdf3o`000002o`0000;oQdf300?o0000oiIIQOnFFHD01?nF
FHD00ol0003oXf>5oj=SQ@06oj=SQ@05o`000?n]JhGo[F^5oje[QOl000001?ncKhD00ol0003o_7J4
okafQ005okafQ003o`000?o4O8?o000000Goc8>100Co0000olb3POl0003oeH]n0ol00002om^?O003
o`000?oVV7OoiYQg00;oiYQg00?o0000oo6SK?oaXf`00_oaXf`01Ol0003onJaHo`000?oaZcCo0000
027ooooo00?o0000ooooooooool01_ooool000Cooooo00?o0000ooooooooool0C?ooool3o`000003
oa][gOl0003o=7_T00;o=7_T1_l00005offEi`07o`000?mkW>KoNicVog^Li_l0003oOioWo`000003
ohZTiPCo00001OnCZN@00ol0003oW:cRoib/hP02oib/hPGo00001?nT]^D00ol0003o000ho`000003
o`T0I005o`000?la377o0000od<JM_l000001OmN;Wd00ol0003oM3n1og@oP@02og@oP@Co00001On7
CH<00ol0003oUUV5oiIIQ@04oiIIQ@03o`000?nSHhGoXf>500KoXf>500Go0000oje[QOn]JhGo[F^5
o`000004ok=_Q@03o`000?nlMXCo_7J400Go_7J400?o0000olAlPol000001_o<Ph42o`0000?oeH]n
1?l00004onJHM`03o`000?oaXfcolJ=/00;olJ=/00?o0000ooV/F?oi[5P00ol0000Pooooo`03o`00
0?oooooooooo00Kooooo0004ooooo`03o`000?oooooooooo04gooooo1Ol00002ocAki0;o00000omE
T>/5o`000005offEiol0003oNicVog^Li_l000000omoWnL3o`0000?oRZCV00Co0000oi>Yi?nCZNCo
TjWT1ol00003oibbj003o`000?nT]^GoY;KU00?oY;KU0ol00003o`T0I005oc4<LOl0003o0000od<J
M_l000001OmN;Wd00ol0003oM3n1o`000002o`0000;oM3n100?o0000ohM=Pon7CH<01?n7CH<00ol0
003oUUV5oiIIQ@05oiIIQ@03o`000?nSHhGoXf>500GoXf>500Go0000oje[QOn]JhGo[F^5o`000004
ok=_Q@03o`000?nlMXCo_7J400Ko_7J40_l00006olb3P@;o00000ooERgh00ol0003ofhmlom^?O002
o`0000CoiYQg00Co0000oo6SK?oaXfcolJ=/0_l000001?oi[5So0000o`000?l0000Pooooo`03o`00
0?oooooooooo00Kooooo0004ooooo`03o`000?oooooooooo04kooooo0ol000001?l6Im_o0000o`00
0?ldNn@2o`0000?oEI3[00Co0000ofNIk?mWVNcoIiW/4_l00003oi:_jP03o`000?nL/^SoW;;X00Go
W;;X00?o0000ojBfiOnT]^D00_nT]^D00ol003So0000o`000003o`T0I005o`000?la377o0000od<J
M_l000001?mN;Wd3o`0000GoM3n100?o0000ohM=Pon7CH<01?n7CH<00ol0003oUUV5oiIIQ@05oiII
Q@03o`000?nSHhGoXf>500GoXf>500Go0000oje[QOn]JhGo[F^5o`000004ok=_Q@03o`000?nlMXCo
_7J400Ko_7J400?o0000olAlPol000001_o<Ph401Ol0003oeH]nomF;O_oERgko000000;ofhml00Co
0000onJHMol0003o00000_oVV7L01_l0003olJ=/oo6SK?oaXfco0000ooV/F0Co00008?ooool00ol0
003oooooooooo`06ooooo`001?ooool00ol0003oooooooooo`1?ooooo`?o000000?o1VOKo`000?l0
00000ol00003oeF@j`04o`000?mWVNcoIiW/ofNIk0Co00001?mkY>d00ol0003oQj[/ohNZk003ohNZ
k003o`000?nB[n[oTZoZ00CoTZoZ00?o0000oibbj?nL/^P01OnL/^P01ol0003oY;KUojBfiOnT]^Go
0000o`00>?l000000_l906@2o`000004oc4<LOl0003o@aYfo`0000?oGRim00?o0000oeh^OOl00000
1_md?h400ol0003oQdf3ohM=P`04ohM=P`03o`000?nFFHGoUUV500GoUUV500?o0000oj=SQOnSHhD0
1OnSHhD01Ol0003o[F^5oje[QOn]JhGo000000Co/fn500?o0000okafQ?nlMX@01_nlMX@00ol0003o
a7b3o`000006olb3P@;o00000_oERgh01?l0003ofhmlom^?O?l00003onJHM`?o00000ooaXf`00ol0
003onJaHooV/F003o`00023ooooo00?o0000ooooooooool01_ooool000Cooooo00?o0000oooooooo
ool0D?ooool5o`0000;o8g[U1?l000001?mET>_o0000o`000?l00003ofNIk0;o00001?mkY>d00ol0
003oQj[/ohNZk003ohNZk003o`000?nB[n[oTZoZ00CoTZoZ00?o0000oibbj?nL/^P01OnL/^P4o`00
000;o`00>?l0003o2@1To`000?l906Co0000oc4<LOl0003o@aYfo`000?mN;Wd00_l00002oeh^O@03
o`000?md?h7oM3n100CoM3n100?o0000ohM=Pon7CH<01?n7CH<00ol0003oUUV5oiIIQ@05oiIIQ@04
o`000?nSHhGoXf>5oj=SQA?o00000onlMX@00ol0003oa7b3o`000006olb3P@05o`000?oERgko0000
omF;O_l000000_oKSg`00ol0003oiYQgonJHM`03onJHM`05o`000?oaXfcolJ=/oo6SK?l000000_oi
[5P00ol0003olJ/do`00000Pooooo`03o`000?oooooooooo00Kooooo0004ooooo`03o`000?oooooo
oooo05;ooooo1?l000000olSN^Go0000oc>5jP05o`0000GoIiW/00?o0000og^TkOmkY>d00omkY>d0
0ol0003oQj[/ohNZk003ohNZk003o`000?nB[n[oTZoZ00CoTZoZ00?o0000oibbj?nL/^P00ol00002
oi^ik@04o`000?nT_N_o0000o`00>0;o00000_l906@01?l0003o<@aao`000?m36WH2o`0000CoGRim
00?o0000og@oPOmd?h401?md?h400ol0003oQdf3ohM=P`04ohM=P`04o`000?nFFHGoUUV5oiIIQ@So
00001?nSHhD01Ol0003o[F^5oje[QOn]JhGo000000Co/fn500?o0000okafQ?nlMX@00onlMX@8o`00
00Coc8>100So0000omF;O_oERgko0000omF;O_l0003ofhmlo`0000GoiYQg0_l00002oo6SK003o`00
0?oi[5SonJaH00?o00008?ooool00ol0003oooooooooo`06ooooo`000oooool00ol0003ooooooooo
o`1Dooooo`Ko000000?o<hGZo`000?m:T^l00_m:T^l4o`000003ofNIk?l0003oNjC]00CoNjC]00?o
0000ohNZk?n7Z^`01?n7Z^`01?l0003oTZoZoi:_j_nB[nX5o`0000KoVkW]0_l000000ol003So0000
o`T0I002o`T0I003o`000?la377o@aYf00;o00001OmN;Wd00ol0003oM3n1og@oP@04og@oP@03o`00
0?n7CH?oQdf300;oQdf31_l00004oiIIQ@03o`000?nSHhGoXf>500GoXf>500Go0000oje[QOn]JhGo
[F^5o`000004ok=_Q@03o`000?nlMXCo_7J400Ko_7J400?o0000olAlPol000000_o<Ph43o`000003
olb3POl0003oeH]n00;oeH]n0_l00002om^?O003o`000?oVV7OoiYQg00;oiYQg00Go0000oo6SK?l0
003olJ=/o`000002ooV/F0?o00008Oooool00ol0003oooooooooo`05ooooo`000oooool00ol0003o
ooooooooo`1Cooooo`Co000000Ko063Co`000?l0003o0000oc>5j_l00003odZBk`03o`000?mNWO;o
GYgb01;o00000on@]O000ol0003oVkW]oi^ik@06oi^ik@03o`000?l003So000000?o2@1T00Go0000
oc4<LOl0003o@aYfo`000005oeh^O@03o`000?md?h7oM3n100CoM3n100?o0000ohM=Pol000000_l0
0002ohM=P`03o`000?nFFHGoUUV500GoUUV500?o0000oj=SQOnSHhD01OnSHhD01Ol0003o[F^5oje[
QOn]JhGo000000Co/fn500?o0000okafQ?nlMX@01_nlMX@00ol0003oa7b3o`000005olb3P@Go0000
00GoeH]no`000?oKSgcofhmlo`000004onJHM`03o`000?oaXfcolJ=/00;o00000_oi[5P00ol0003o
lJ/do`00000Qooooo`03o`000?oooooooooo00Gooooo0003ooooo`03o`000?oooooooooo053ooooo
0ol00004ooooo`?o000000?o3GKRo`000?l000000ol000001om:T^oo0000oejMl_mNWO;o0000ofJR
l_l000001OmfZO<00ol0003oQ;3bohB`lP03ohB`lP03o`000?n@]O3oT;G`00CoT;G`00?o0000oi^i
kOnK^Nd01?nK^Nd2o`000003o`00>?l0003o2@1T00;o2@1T00Go0000oc4<LOl0003o@aYfo`000005
oeh^O@03o`000?md?h7oM3n100?oM3n10ol00005ohM=P`03o`000?nFFHGoUUV500GoUUV500?o0000
oj=SQOnSHhD01OnSHhD01Ol0003o[F^5oje[QOn]JhGo000000Co/fn500?o0000okafQ?nlMX@01_nl
MX@00ol0003oa7b3o`000006olb3P@04o`000?oERgkoeH]nomF;OP?o000000?ofhmlo`000?oVV7L0
0ooVV7L01Ol0003olJ=/oo6SK?oaXfco000000;onJaH00?o0000oo6[=?l000008Oooool00ol0003o
ooooooooo`05ooooo`000oooool00ol0003oooooooooo`1<ooooo`Co00002?ooool4o`000004o`ef
h_l0003o>i?aoc^Cl@?o00000_mNWO800ol0003oIZ;bo`000005ogJYl`03o`000?n4/?;oQ;3b00?o
Q;3b00?o0000oi2el?n@]O001?n@]O000ol0003oVkW]oi^ik@03o`000004oiW1lol0003o0000o`00
00?o2@1T00Go<@aao`000?l0003o@aYfo`000005oeh^O@03o`000?md?h7oM3n100?o000000?oM3n1
o`000?n7CH<01On7CH<00ol0003oUUV5oiIIQ@05oiIIQ@03o`000?nSHhGoXf>500GoXf>500Go0000
oje[QOn]JhGo[F^5o`000005ok=_Q@03o`000?nlMXCo_7J400Go_7J400?o0000olAlPol000001_o<
Ph400ol0003oeH]nomF;OP02omF;OPCo00001?oVV7L01?l0003olJ=/oo6SK?oaXf`2o`000004ooV/
F?l0003olJ/do`00027ooooo00?o0000ooooooooool01Oooool000?ooooo00?o0000ooooooooool0
BOooool3o`0000kooooo00?o0000o`1E`ol000000_l00004oc^Cl@Ko00001OmfZO<00ol0003oQ;3b
ohB`lP03ohB`lP04o`000?n@]O3oT;G`oi2el0Go00001?nI`O<00ol003So0000o`000003o`T0I005
o`000?la377o0000od<JM_l000001OmN;Wd3o`0000CoM3n100?o0000ohM=Pon7CH<01?n7CH<00ol0
003oUUV5oiIIQ@05oiIIQ@03o`000?nSHhGoXf>500GoXf>500Go0000oje[QOn]JhGo[F^5o`000005
ok=_Q@03o`000?nlMXCo_7J400Go_7J400?o0000olAlPol000001_o<Ph400ol0003oeH]nomF;OP02
omF;OP03o`000?oKSgco000000;o00000ooVV7L01_l0003olJ=/oo6SK?oaXfco0000ooV/F0;o0000
00?olJ/do`000?ooool08?ooool00ol0003oooooooooo`05ooooo`000oooool00ol0003ooooooooo
o`16ooooo`?o00004_ooool3o`000003o`1^eol0003o>i?a00?o>i?a00Go0000oe>Qm_mCXOKo0000
oebUm`0?o`0000GoSKcf00Oo0000oiW1lonI`O?oVL7co`000?l003So000000;o2@1T0_l000001?la
377o0000od<JM_l00004oeh^O@;o00001_md?h400ol0003oQdf3ohM=P`04ohM=P`03o`000?nFFHGo
UUV500GoUUV500?o0000oj=SQOnSHhD01OnSHhD01Ol0003o[F^5oje[QOn]JhGo000000Go/fn500?o
0000okafQ?nlMX@01OnlMX@00ol0003oa7b3o`000006olb3P@03o`000?oERgkoeH]n00;oeH]n00Go
0000om^?O?oKSgco0000onJHM`02o`000003onJHMol0003olJ=/00;olJ=/00Ko0000ooV/F?oi[5So
0000oo6[=?l0000Qooooo`03o`000?oooooooooo00Gooooo0003ooooo`03o`000?oooooooooo04;o
oooo1?l0000Gooooo`Oo000000Oo>i?ao`000?mCXOKoDj7fo`000?mLYOOo000000GoKjoh00?o0000
ognfmomo]_L01?mo]_L00ol0003oSKcfohflmP04ohflmP0>o`000?nI`O?oVL7co`000?l003So0000
o`T0I?l0003o2@1To`000?la377o0000od<JM_l00002oeh^O@;o000000?oGRimo`000?md?h401Omd
?h400ol0003oQdf3ohM=P`04ohM=P`03o`000?nFFHGoUUV500GoUUV500?o0000oj=SQOnSHhD01OnS
HhD01Ol0003o[F^5oje[QOn]JhGo000000Go/fn500?o0000okafQ?nlMX@01OnlMX@00ol0003oa7b3
o`000007olb3P@05o`000?oERgkoeH]nomF;O_l000000_oKSg`2o`0000;oiYQg0_l00003oo6SK006
o`000?oi[5SonJaHo`000?oaZcCo00008Oooool00ol0003oooooooooo`05ooooo`000oooool00ol0
003oooooooooo`0oooooo`?o00007_ooool01?l0003o06kGobRAk_lXTNh4o`000004oe>Qm_l0003o
G:Ggo`0000GoKjoh00?o0000ognfmomo]_L01?mo]_L01?l0003oSKcfohflm_n=_?H2o`000005ohfl
m_l0003o0000o`000?l003P00_l00002o`T0I004o`000?la377o0000od<JMP?o00000omN;Wd00ol0
003oM3n1og@oP@04og@oP@03o`000?n7CH?oQdf300CoQdf300?o0000oiIIQOnFFHD00onFFHDIo`00
00?o_7J400?o0000olAlPol000001oo<Ph401Ol0003oeH]nomF;O_oERgko000000;ofhml00?o0000
onJHMol000000_oVV7L2o`0000?olJ=/00?o0000ooV/F?l000000_l0000Qooooo`03o`000?oooooo
oooo00Gooooo0003ooooo`03o`000?oooooooooo03_ooooo1?l0000Rooooo`04o`000?l0HL?o0000
o`0000?o:97^00?oA:;fo`000?l000003Ol000001?mo]_Oo0000o`000?l00004ohS3n`;o000000?o
000ho`000?l906@00_l906@01Ol0003o<@aao`000?m36WKo000000GoGRim00?o0000og@oPOmd?h40
1?md?h400ol0003oQdf3ohM=P`04ohM=P`03o`000?nFFHGo000000?o000000?oXO7do`000?l00000
3_l00003ojIYS003o`000?nKHHcoVf6<00;oVf6<2?l00005olb3P@05o`000?oERgkoeH]nomF;O_l0
00000_oKSg`01ol0003oiYQgonJHMol0003oiYQgo`000?oaXf`00_l000000ooaXfco0000ooV/F003
o`00027ooooo00?o0000ooooooooool01Oooool000;ooooo00?o0000ooooooooool0>Oooool3o`00
02Sooooo00CoAP00o`1Q`ol0003o4HcU0_lXTNh00ol0003oA:;fodBRmP03o`0000GoIK?k00?o0000
ogNlo?mg_?`00omg_?`00ol0003oR<?kohS3n`04ohS3n`03o`000?l003So000000?o2@1T00?o0000
oc4<LOm36WH00_l00005oeh^O@03o`000?md?h7oM3n100CoM3n100?o0000ohM=Pon7CH<00_n7CH<4
o`000003ojcZnOl0003o000000Go_7^;00?o0000ok=dS?ncM8`00_ncM8`01Ol0003o[g2<ojm`S?n_
L8co000000KoYVV<00?o0000oi]QS?nKHH`01?nKHH`00ol0003oSUN;ohiGR`03ohiGR`Co000000?o
c8>1o`000?oERgh00_oERgh01?l0003ofhmlom^?O?l00003onJHM`;o00000ooaXf`2o`000004ooV/
F?l0003olJ/do`00027ooooo00?o0000ooooooooool01Oooool000;ooooo00?o0000ooooooooool0
=_ooool3o`0002kooooo00CoAP00o`000?lAS>Go4HcU0ol000000om4X_Ko0000o`000005ofFcn`03
o`000?mg_?coMkcl00?oMkcl00Co0000ohS3non8`o_oR<?k0ol000000ol003So0000o`T0I002o`T0
I005o`000?la377o0000od<JM_l000001OmN;Wd00ol0003oM3n1og@oP@04og@oP@03o`000?n7CH?o
000000;o000000KobHJ9o`000?o9QXWo0000ol:0R_l00006okakR`03o`000?ncM8co/gB<00;o/gB<
00Go0000ojm`S?n_L8co[g2<o`000006ojIYS003o`000?nKHHcoVf6<00CoVf6<00?o0000ohiGRon>
Eh/01?n>Eh/00ol0003oOdb:ogm<RP04o`000005omF;O_l0003ofhmlom^?O?l000000ooVV7L2o`00
00ColJ=/00?o0000ooV/F?oi[5P00ol0000Qooooo`03o`000?oooooooooo00Cooooo0002ooooo`03
o`000?oooooooooo03;ooooo1?l0000booooo`07o`000?m6003o0000o`000?lAS>Go0000obnPl@07
o`000003ofFcnol0003o000000?o000000CoMkclo`000?l0003o00000_n0bOh3o`0000?o2@1T00Go
<@aao`000?l0003o@aYfo`000005oeh^O@03o`000?md?h7oM3n100?oM3n11?l00005olV6R@03o`00
0?o2P8[o000000Ko_7^;00?o0000ok=dS?ncM8`00_ncM8`01Ol0003o[g2<ojm`S?n_L8co000000Ko
YVV<00?o0000oi]QS?nKHH`01?nKHH`00ol0003oSUN;ohiGR`04ohiGR`03o`000?moC8[o000000;o
000000?oOdb:o`000?l000001?l00004onJHM`03o`000?oaXfcolJ=/00;olJ=/00?o0000ooV/F?oi
[5P00ol0000Qooooo`03o`000?oooooooooo00Cooooo0002ooooo`03o`000?oooooooooo02oooooo
0ol0000fooooo`04o`000?ooooooooooooooo`?o00000ol_X?42o`0000GoEkKk00?o0000ofg0o_m]
`?h00om]`?h2o`000004oh39o_l003So0000o`0000?o2@1T00Go0000oc4<LOl0003o@aYfo`000005
oeh^O@03o`000?md?h7oM3n100Go000000?odXf8o`000?o9QXT01?o9QXT00ol0003o`X2:o`000006
okakR`03o`000?ncM8co/gB<00;o/gB<00Go0000ojm`S?n_L8co[g2<o`000006ojIYS003o`000?nK
HHcoVf6<00CoVf6<00?o0000ohiGRon>Eh/00_n>Eh/4o`0000CoOdb:00?o0000ofhoR?m^?hP00_m^
?hP2o`0000CoiYQg00Co0000oo6SK?oaXfcolJ=/0_l000001?oi[5So0000o`000?l0000Qooooo`03
o`000?oooooooooo00Cooooo0002ooooo`03o`000?oooooooooo02cooooo0ol0000iooooo`03o`00
0?oooooooooo00Cooooo0_l000000olFV>Co0000o`000005o`000003oeNfnol0003o000000Co0000
00GoKL3no`000?l0003o000ho`000002o`T0I0;o000000Co<@aao`000?m36WKo00001OmN;Wd3o`00
00;oei6600?o0000om:=R?oBSHP01?l00004olV6R@;o00001onlNh/01Ol0003o/gB<ok=dS?ncM8co
000000?o[g2<00?o0000ojIYS?nVJH`01?nVJH`00ol0003oVf6<oi]QS004oi]QS003o`000?n>Eh_o
000000;o00000_n>Eh/00ol0003oOdb:ogm<RP03ogm<RP03o`000?m^?hSoKSn800?oKSn80ol00002
onJHM`;o00000_oaXf`00ol0003onJaHo`000003o`00027ooooo00?o0000ooooooooool01?ooool0
00;ooooo00?o0000ooooooooool0:?ooool4o`0003cooooo00?o0000ooooooooool01oooool2o`00
00;o5YST0_l000000olf[O7o0000o`000003o`0000CoG/;l00_o0000o`00>?l0003o2@1To`000?l9
06Co0000oc4<LOl0003o@aYfo`000004oeh^O@;o000000GohIZ3o`000?oGTHKoei66o`000003om:=
R003o`000?o9QXWobHJ900?o000000?obHJ9o`000?l000001onlNh/01Ol0003o/gB<ok=dS?ncM8co
000000?o[g2<00?o0000ojIYS?nVJH`01?nVJH`01?l0003oVf6<oi]QS?nKHH`5o`0000GoSUN;00?o
0000ogm<R_moC8X00omoC8X00ol0003oKSn8ofhoR002ofhoR0;o000000?oFS65o`000?l000000_l0
00001?oaXfco0000oo6SK?l00002ooV/F003o`000?oaZcCo0000027ooooo00?o0000ooooooooool0
1?ooool000;ooooo00?o0000ooooooooool09Oooool3o`00043ooooo00?o0000ooooooooool02_oo
ool01?l0R/co0000oaJHi?l00004ocJ]l@Ko000000?o000ho`000?l000000_l906@01Ol0003o<@aa
o`000?m36WKo000000;oGRim0_l00003on6JP`04o`000?oGTHKoei66o`0000?odXf800?o0000olV6
ROo9QXT00oo9QXT7o`0000?o_7^;00Go0000ok=dS?ncM8co/gB<o`000003ojm`S004o`000?nVJHco
YVV<ojIYS0Oo00000onKHH`00ol0003oSUN;ohiGR`04ohiGR`03o`000?moC8[oOdb:00?oOdb:00?o
0000ofhoR?m^?hP00_l000001?m^?hSo0000oeXaQOl00002oddWPP03o`000?oaXfcolJ=/00;o0000
0_oi[5P00ol0003olJ/do`00000Qooooo`03o`000?oooooooooo00Cooooo0002ooooo`03o`000?oo
oooooooo02;ooooo0ol00013ooooo`03o`000?oooooooooo00oooooo00Co08[<o`000?l0003o0000
0olKXmh2o`000003o`00>?l0003o2@1T00;o2@1T00Co0000oc4<LOl0003o@aYf1?l00004on6JP`04
o`000?oGTHKoei66o`0000?odXf800?o0000olV6ROo9QXT01?o9QXT2o`0000Co_7^;3ol00003ojIY
S003o`000?nKHHcoVf6<00CoVf6<00?o0000ohiGRon>Eh/01?n>Eh/00ol0003oOdb:ogm<RP03ogm<
RP?o00000om^?hP00ol0003oFS65o`000003oddWPP04o`000?oaXfcolJ=/o`0000;onJaH0ol0000Q
ooooo`03o`000?oooooooooo00Cooooo00000ooooooo0000ooooo`0Pooooo`Co0000A_ooool00ol0
003oooooooooo`0Gooooo`03o`000?l003So000000?o2@1T00?o0000oc4<LOm36WH00_l000000oo/
Y7go0000on6JP`02o`0000;ohIZ300Co0000omNAQ_oGTHKo00000ooBSHP00ol0003obHJ9olV6R@04
olV6R@;o00001onlNh/01Ol0003o/gB<ok=dS?ncM8co000000?o[g2<00?o0000ojIYS?nVJH`01?nV
JH`00ol0003oVf6<oi]QS004oi]QS003o`000?n>Eh_oSUN;00CoSUN;00?o0000ogm<R_moC8X00_mo
C8X2o`0000GoKSn800?o0000oeXaQOl000000om=9h82o`000004oo6SK?l0003onJaHooV/F0?o0000
8Oooool00ol0003oooooooooo`04ooooo`0000?oooooo`000?ooool07Oooool3o`0004[ooooo00?o
0000ooooooooool05oooool00ol0003o000ho`000003o`T0I003o`000?la377o000000?ok:Am00Co
0000on6JPooQVX?ohIZ30ol00002omNAQP05o`000?oBSHSodXf8om:=R?l000001_o9QXT2o`0000Oo
_7^;00Go0000ok=dS?ncM8co/gB<o`000003ojm`S003o`000?nVJHcoYVV<00CoYVV<00?o0000oi]Q
S?nKHH`01OnKHH`00ol0003oSUN;ohiGR`03ohiGR`03o`000?moC8[oOdb:00;o000000?oOdb:o`00
0?m^?hP01?m^?hP01?l0003oFS65oeXaQOl00002oddWPPGo000000?onJaHo`000?oaZc@00_l0000P
ooooo`03o`000?oooooooooo00Cooooo00000ooooooo0000ooooo`0Jooooo`?o0000COooool00ol0
003oooooooooo`0Gooooo`?o00000ol906@00ol0003o<@aao`000003onbTO@03o`000?oQVX?ohIZ3
00?ohIZ31?l00003om:=R003o`000?o9QXWobHJ900CobHJ90_l00007okakR`05o`000?ncM8co/gB<
ok=dS?l000000on_L8`00ol0003oYVV<ojIYS004ojIYS003o`000?nKHHcoVf6<00GoVf6<00?o0000
ohiGRon>Eh/00on>Eh/3o`0000?oOdb:00?o0000ofhoR?m^?hP01?m^?hP2oeXaQ@04o`000?m=9h;o
0000o`0000;o<1=k0ol000001?oi[5So0000o`000?l0000Qooooo`03o`000?oooooooooo00?ooooo
00000ooooooo0000ooooo`0Fooooo`Co0000Coooool00ol0003oooooooooo`0Hooooo`03o`00>?l0
003o000000?o2@1T00?o<@aao`000?l000000oo/Y7d00ol0003ohIZ3on6JP`03on6JP`03o`000?oG
THKoei6600?o000000?odXf8o`000?o9QXT01Oo9QXT2o`0000Oo_7^;00?o0000ok=dS?ncM8`00_nc
M8`01?l0003o[g2<ojm`S?l00007ojIYS003o`000?nKHHcoVf6<00CoVf6<00?o0000ohiGRon>Eh/0
1?l00005ogm<RP03o`000?m^?hSoKSn800CoKSn80_mJ<HD01?m=9h;o0000oddWP_l00003oc0CN`03
oa40L_l0003o000000?o00008Oooool00ol0003oooooooooo`03ooooo`0000?oooooo`000?ooool0
4oooool3o`0005?ooooo00?o0000ooooooooool06?ooool00ol0003o000ho`000003o`T0I004o`00
0?og[g?o0000o`0000;ok:Am00?o0000on6JPooQVX<00ooQVX<01?l0003oei66omNAQ_l00002om:=
R0Ko00000_o9QXT2o`0000Oo_7^;00?o0000ok=dS?ncM8`00_ncM8`01?l0003o[g2<ojm`S?l00007
ojIYS003o`000?nKHHcoVf6<00;oVf6<1Ol00003ohiGR`03o`000?moC8[oOdb:00?oOdb:00?o0000
ofhoR?m^?hP01?m^?hP00omJ<HGo0000o`000002oddWPP06o`000?l`4g_o<1=koc0CNolA07;o001T
1?l0000Qooooo`03o`000?oooooooooo00?ooooo00000ooooooo0000ooooo`0?ooooo`Co0000E_oo
ool00ol0003oooooooooo`0Hooooo`03o`000?l003So000000;o2@1T00So0000ooN_Loog[g?o0000
onbTOOl0003ok:Amo`0000GohIZ300Co0000omNAQ_oGTHKo00000ooBSHP00ol0003obHJ9olV6R@02
olV6R@Co00001onlNh/00ol0003o/gB<ok=dS002ok=dS004o`000?n_L8co[g2<o`0000OoYVV<00?o
0000oi]QS?l000000_l00002oi]QS003o`000?n>Eh_oSUN;00?oSUN;00?o0000ogm<R_moC8X01?mo
C8X00ol0003oKSn8ofhoR002ofhoR0;o000000GoFS65o`000?m=9h;oCBN2o`000003oc0CN`03oa40
L_l0003o001T00?o00008Oooool00ol0003oooooooooo`03ooooo`0000?oooooo`000?ooool03?oo
ool3o`0005[ooooo00?o0000ooooooooool06?ooool01Ol0003o000ho`000?l906Co000000?omjmc
00?o0000onbTOOo/Y7d00_l00005on6JP`04o`000?oGTHKoei66o`0000?odXf800?o0000olV6ROo9
QXT01?o9QXTKo`0000GoVf6<00?o0000ohiGRon>Eh/00on>Eh/00ol0003oOdb:ogm<RP04ogm<RP03
o`000?m^?hSoKSn800;o000000CoKSn8o`000?mJ<HGo00000_m=9h801?l0003o<1=koc0CNol`4g/2
o`000004o`00I?l0003olJ/do`00027ooooo00?o0000ooooooooool00oooool00003ooooool0003o
oooo00Wooooo0ol0001Mooooo`03o`000?oooooooooo01Sooooo00?o0000o`00>?l000000_l00003
ooN_L`04o`000?o/Y7gok:AmonbTO@?o00000ooQVX<01?l0003oei66omNAQ_l00003om:=R003o`00
0?o9QXWobHJ900CobHJ90_l00007okakR`03o`000?ncM8co/gB<00;o/gB<00Co0000ojm`S?n_L8co
00001onVJH`00ol0003oVf6<oi]QS004oi]QS003o`000?n>Eh_oSUN;00?oSUN;00?o0000ogm<R_mo
C8X01?moC8X3o`0000?oKSn800?o0000oeXaQOl000000_m=9h800ol0003o<1=koc0CN`03o`0000;o
001T0ol0000Pooooo`03o`000?oooooooooo00?ooooo00000ol0003oooooooooo`05ooooo`Co0000
H?ooool00ol0003oooooooooo`0Hooooo`05o`000?l003So0000oofiH?l000000oog[g<01Ol0003o
k:AmonbTOOo/Y7go000000;ohIZ31?l00002omNAQP05o`000?oBSHSodXf8om:=R?l000001_o9QXT2
o`0000Oo_7^;00?o0000ok=dS?ncM8`00_ncM8`01?l0003o[g2<ojm`S?l00007ojIYS003o`000?nK
HHcoVf6<00CoVf6<00?o0000ohiGRon>Eh/01?n>Eh/00ol0003oOdb:ogm<RP02ogm<RP;o00001Om^
?hP00ol0003oFS65o`000002oddWPP04o`000?l`4g_o0000oc0CN`;o00000_l006@3o`00023ooooo
00?o0000ooooooooool00oooool00003o`000?oooooooooo00;ooooo0ol0001Tooooo`03o`000?oo
oooooooo01Sooooo00Co0000o`00>?l0003ooKUP0_l00002ooN_L`05o`000?o/Y7gok:AmonbTOOl0
00001OoQVX<4o`0000?odXf800?o0000olV6ROo9QXT01?o9QXT2o`0000Oo_7^;00?o0000ok=dS?nc
M8`00_ncM8`01?l0003o[g2<ojm`S?l00007ojIYS003o`000?nKHHcoVf6<00CoVf6<00?o0000ohiG
Ron>Eh/01?n>Eh/00ol0003oOdb:ogm<RP02o`000003ogm<R_l0003oKSn800CoKSn800?o0000oeXa
QOl000000_m=9h82o`0000;o<1=k0_l00002o`00I0;o000000?oooooo`000?ooool07_ooool00ol0
003oooooooooo`03ooooo`0000?o0000ooooool000000_l0001Wooooo`03o`000?oooooooooo01So
oooo00Wo0000o`00>?l0003ooKUPo`000?og[g?o0000ooN_Lol000000oo/Y7d00ol0003ohIZ3on6J
P`03on6JP`03o`000?oGTHKoei6600;o00000_oBSHP00ol0003obHJ9olV6R@04olV6R@03o`000?o2
P8[o000000Ko_7^;00?o0000ok=dS?ncM8`00_ncM8`01?l0003o[g2<ojm`S?l00007ojIYS003o`00
0?nKHHcoVf6<00CoVf6<00?o0000ohiGRon>Eh/01?n>Eh/3o`0000?oOdb:00?o0000ofhoR?m^?hP0
0om^?hP01?l0003oFS65o`000?m=9h82o`0000?o<1=k0_l00002o`00I0;o00000_ooool00ol0003o
ooooooooo`0Looooo`03o`000?oooooooooo00?ooooo0002o`0006[ooooo00?o0000ooooooooool0
6?ooool3o`000004oofiH?l0003omjmcooN_L`;o00000oo/Y7d00ol0003ohIZ3on6JP`03on6JP`05
o`000?oGTHKoei66o`000?oBSHP00ol00006olV6R@03o`000?o2P8[o000000Ko_7^;00?o0000ok=d
S?ncM8`00_ncM8`01?l0003o[g2<ojm`S?l00007ojIYS003o`000?nKHHcoVf6<00CoVf6<00Co0000
ohiGRon>Eh_oSUN;1?l00005ogm<RP03o`000?m^?hSoKSn800?oKSn800Ko0000oeXaQOl0003o0000
oddWP_l00004oc0CN`03o`000?l006Co000000;o00000oooool00ol0003oooooooooo`0Looooo`03
o`000?oooooooooo00;ooooo0002ooooo`03o`000?oooooooooo06Oooooo00?o0000ooooooooool0
6?ooool01Ol003So0000o`000?om^F3o000000?omjmc0_l00002onbTO@03o`000?oQVX?ohIZ300?o
hIZ300Co0000omNAQ_oGTHKo00000ooBSHP5o`0000;obHJ900?o0000ol:0R_l000001_nlNh/00ol0
003o/gB<ok=dS002ok=dS004o`000?n_L8co[g2<o`0000OoYVV<00?o0000oi]QS?nKHH`00_nKHH`6
o`0000?oSUN;00?o0000ogm<R_moC8X00omoC8X00ol0003oKSn8ofhoR003ofhoR0?o00000_m=9h80
0ol0003o<1=koc0CN`02oc0CN`05o`00I?l0003o001To`00BOl000001?ooool00ol0003ooooooooo
o`0Kooooo`03o`000?oooooooooo00;ooooo0003ooooo`03o`000?oooooooooo06Kooooo00?o0000
ooooooooool06?ooool01Ol0003olKLno`000?om^F3o000000?omjmc00Go0000onbTOOl0003ok:Am
o`000005on6JP`04o`000?oGTHKoei66o`0000?odXf800?o0000olV6ROo9QXT00_o9QXT9o`0000;o
_7^;00?o0000ok=dS?ncM8`00_ncM8`01?l0003o[g2<ojm`S?l00007ojIYS003o`000?nKHHco0000
00;o00000_nKHH`00ol0003oSUN;ohiGR`04ohiGR`03o`000?moC8[oOdb:00?oOdb:00?o0000ofho
R?m^?hP00_m^?hP2o`000005oeXaQOl0003oCBN2oddWP_l000001?l`4g/01Ol0003o001To`00I?l0
04Wo000000Gooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`02ooooo`001?ooool2
o`0006Kooooo00?o0000ooooooooool06?ooool01Ol0003olKLno`000?om^F3o000000?omjmc00?o
0000onbTOOo/Y7d00_l00005on6JP`04o`000?oGTHKoei66o`0000?odXf800?o0000olV6ROo9QXT0
1?o9QXT00ol0003o`X2:o`000004okakRaCo00001OnKHH`00ol0003oSUN;ohiGR`04ohiGR`03o`00
0?moC8[oOdb:00?oOdb:00?o0000ofhoR?m^?hP00_l000001?m^?hSo0000oeXaQOl00002oddWPP03
o`000?l`4g_o<1=k00;o<1=k00Go0000o`00I?l006Co0019o`000006ooooo`03o`000?oooooooooo
01Wooooo00?o0000ooooooooool00_ooool000Kooooo00?o0000ooooooooool0Hoooool00ol0003o
ooooooooo`0Hooooo`03o`000?oa]cko000000;o00000oog[g<01?l0003ok:AmonbTOOo/Y7d3o`00
00?ohIZ300Co0000omNAQ_oGTHKo00000ooBSHP00ol0003obHJ9olV6R@04olV6R@03o`000?o2P8[o
000000Ko_7^;00?o0000ok=dS?ncM8`00_ncM8`01?l0003o[g2<ojm`S?l00007ojIYS003o`000?nK
HHcoVf6<00CoVf6<00?o0000ohiGRon>Eh/01?n>Eh/00ol0003oOdb:ogm<RP03ogm<RP?o00000om^
?hP00ol0003oFS65o`000003oddWPP03o`000?l`4g_o<1=k00;o00000_l006@00ol004Wo0000oooo
o`05ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool00_ooool000Oooooo00?o0000
ooooooooool0H_ooool00ol0003oooooooooo`0Hooooo`03o`000?oa]cko000000;o00000oog[g<0
1Ol0003ok:AmonbTOOo/Y7go000000;ohIZ31?l00002omNAQP05o`000?oBSHSodXf8om:=R?l00000
1_o9QXT00ol0003o`X2:o`000006okakR`03o`000?ncM8co/gB<00;o/gB<00Co0000ojm`S?n_L8co
00001onVJH`00ol0003oVf6<oi]QS004oi]QS003o`000?n>Eh_oSUN;00CoSUN;00?o0000ogm<R_mo
C8X00_moC8X2o`0000GoKSn800?o0000oeXaQOl000000om=9h801Ol0003o<1=ko`000?l`4g_o0000
00;o001T00?o0019o`000?ooool01_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo
00;ooooo0008ooooo`;o0000H_ooool00ol0003oooooooooo`0Hooooo`04o`000?oa]cko0000oofi
H0;o00000_og[g<01Ol0003ok:AmonbTOOo/Y7go000000GohIZ31?l00003om:=R003o`000?o9QXWo
bHJ900CobHJ900?o0000ol:0R_l000001_nlNh/00ol0003o/gB<ok=dS002ok=dS004o`000?n_L8co
[g2<o`0000OoYVV<00?o0000oi]QS?nKHH`01OnKHH`00ol0003oSUN;ohiGR`03ohiGR`03o`000?mo
C8[oOdb:00;o000000?oOdb:o`000?m^?hP01?m^?hP01?l0003oFS65oeXaQOl00002oddWPP;o0000
0_l`4g/01?l0003o001To`00I?l00009ooooo`03o`000?oooooooooo01Oooooo00?o0000oooooooo
ool00_ooool000[ooooo00?o0000ooooooooool0Goooool00ol0003oooooooooo`0Hooooo`09o`00
0?oa]cko0000oofiH?l0003omjmco`000?og[g?o000000?ok:Am00?o0000on6JPooQVX<00ooQVX<0
0ol0003oei66omNAQP02o`0000;odXf800?o0000olV6ROo9QXT01?o9QXT00ol0003o`X2:o`000006
okakR`03o`000?ncM8co/gB<00;o/gB<00Co0000ojm`S?n_L8co00001onVJH`00ol0003oVf6<oi]Q
S005oi]QS003o`000?n>Eh_oSUN;00?oSUN;0ol00003ogm<RP03o`000?m^?hSoKSn800CoKSn80_mJ
<HD01?l0003oCBN2o`000?l00003oc0CN`04oa40L_l0003o001To`0000[ooooo00?o0000oooooooo
ool05_ooool00ol0003oooooooooo`02ooooo`002oooool2o`0005oooooo00?o0000ooooooooool0
6Oooool2o`000004oofiH?l0003omjmcooN_L`;o00000oo/Y7d00ol0003ohIZ3on6JP`03on6JP`05
o`000?oGTHKoei66o`000?oBSHP00ol00006olV6R@03o`000?o2P8[o000000Ko_7^;00?o0000ok=d
S?ncM8`00_ncM8`01Ol0003o[g2<ojm`S?n_L8co000000KoYVV<00?o0000oi]QS?nKHH`01OnKHH`0
0ol0003oSUN;ohiGR`04o`0000GoOdb:00?o0000ofhoR?m^?hP01?m^?hP2oeXaQ@04oddWP_l0003o
CBN2o`0000?o<1=k00Co4@1bo`000?l006Co00002oooool00ol0003oooooooooo`0Eooooo`03o`00
0?oooooooooo00;ooooo000=ooooo`03o`000?oooooooooo05cooooo00?o0000ooooooooool06Ooo
ool2o`000003oofiH?l0003omjmc00;omjmc0_l00002onbTO@03o`000?oQVX?ohIZ300?ohIZ300Co
0000omNAQ_oGTHKo00000ooBSHP5o`0000;obHJ900?o0000ol:0R_l000001_nlNh/00ol0003o/gB<
ok=dS002ok=dS005o`000?n_L8co[g2<ojm`S?l000001_nVJH`01?l0003oVf6<oi]QS?nKHH`7o`00
00?oSUN;00?o0000ogm<R_moC8X00omoC8X00ol0003oKSn8ofhoR004ofhoR003oeXaQOl0003o0000
00;oCBN200Go0000oc0CNol`4g_o<1=koa40LP02o`0000gooooo00?o0000ooooooooool05Oooool0
0ol0003oooooooooo`01ooooo`003_ooool00ol0003oooooooooo`1Kooooo`03o`000?oooooooooo
01[ooooo00?o0000oofiH?l000000oog[g<01Ol0003ok:Amo`000?o/Y7go000000GohIZ300Co0000
omNAQ_oGTHKo00000ooBSHP00ol0003obHJ9olV6R@02olV6R@Wo00000_nlNh/00ol0003o/gB<ok=d
S002ok=dS005o`000?n_L8co[g2<ojm`S?l000000onVJH`7o`0000CoVf6<00?o0000ohiGRon>Eh/0
0on>Eh/00ol0003oOdb:ogm<RP04ogm<RP03o`000?m^?hSoKSn800;oKSn80_l000001OmJ<HGo0000
oddWP_m=9h;o000000?o<1=k00?o4@1bo`00I?l000003_ooool00ol0003oooooooooo`0Dooooo`03
o`000?oooooooooo007ooooo000?ooooo`;o0000Foooool00ol0003oooooooooo`0Jooooo`03o`00
0?om^F3o000000?omjmc00?o0000onbTOOo/Y7d00_l00005on6JP`04o`000?oGTHKoei66o`0000?o
dXf800?o0000olV6ROo9QXT01?o9QXT00ol0003o`X2:o`000004okakR`oo00000onVJH`00ol0003o
Vf6<oi]QS005oi]QS003o`000?n>Eh_oSUN;00?oSUN;00?o0000ogm<R_moC8X01?moC8X00ol0003o
KSn8ofhoR002o`000004ofhoR?l0003oFS65o`0000;oCBN200Ko0000oc0CNol`4g_o<1=koa40L_l0
000?ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool00Oooool0017ooooo00?o0000
ooooooooool0F?ooool00ol0003oooooooooo`0Kooooo`;o00000oog[g<01?l0003ok:AmonbTOOo/
Y7d3o`0000?ohIZ300Co0000omNAQ_oGTHKo00000ooBSHP00ol0003obHJ9olV6R@04olV6R@03o`00
0?o2P8[o000000Ko_7^;00?o0000ok=dS?ncM8`00_ncM8`01Ol0003o[g2<ojm`S?n_L8co000000Ko
YVV<00?o0000oi]QS?nKHH`01OnKHH`00ol0003oSUN;ohiGR`03ohiGR`03o`000?moC8[oOdb:00Co
Odb:0ol00003ofhoR003o`000?mJ<HGo000000?oCBN200Co0000oc0CNol`4g_o00004Oooool00ol0
003oooooooooo`0Cooooo`03o`000?oooooooooo007ooooo000Booooo`03o`000?oooooooooo05Oo
oooo00?o0000ooooooooool06oooool2o`0000?omjmc00Go0000onbTOOo/Y7gok:Amo`000002on6J
P`Co00000_oGTHH01Ol0003odXf8om:=R?oBSHSo000000KobHJ900?o0000ol:0R_l000001_nlNh/0
0ol0003o/gB<ok=dS002ok=dS005o`000?n_L8co[g2<ojm`S?l000001_nVJH`00ol0003oVf6<oi]Q
S005oi]QS003o`000?n>Eh_oSUN;00CoSUN;00?o0000ogm<R_moC8X00_moC8X2o`0000GoKSn800?o
0000oeXaQOl000000om=9h800ol0003o<1=ko`00000Cooooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool00Oooool001?ooooo0_l0001Gooooo`03o`000?oooooooooo01cooooo0_l00002
ooN_L`05o`000?o/Y7gok:AmonbTOOl000001OoQVX<4o`0000?odXf800?o0000olV6ROo9QXT01?o9
QXT00ol0003o`X2:o`000006okakR`03o`000?ncM8co/gB<00;o/gB<00Go0000ojm`S?n_L8co[g2<
o`000006ojIYS003o`000?nKHHcoVf6<00GoVf6<00?o0000ohiGRon>Eh/01?n>Eh/00ol0003oOdb:
ogm<RP02o`000003ogm<R_l0003oKSn800CoKSn800Co0000oeXaQOmJ<HGo00000_m=9h82o`0001Go
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`01ooooo`005Oooool00ol0003ooooo
ooooo`1Dooooo`03o`000?oooooooooo01kooooo00?o0000ooN_Lol000000oo/Y7d00ol0003ohIZ3
on6JP`03on6JP`03o`000?oGTHKoei6600;o00000_oBSHP00ol0003obHJ9olV6R@04olV6R@03o`00
0?o2P8[o000000Ko_7^;00?o0000ok=dS?ncM8`00_ncM8`01Ol0003o[g2<ojm`S?n_L8co000000Oo
YVV<00?o0000oi]QS?nKHH`01?nKHH`00ol0003oSUN;ohiGR`04ohiGR`?o00000omoC8X00ol0003o
KSn8ofhoR003ofhoR005o`000?mJ<HGoFS65o`000?m=9h800_l0000Gooooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool00Oooool001Kooooo00?o0000ooooooooool0Doooool00ol0003o
ooooooooo`0Oooooo`;o00000oo/Y7d00ol0003ohIZ3on6JP`03on6JP`05o`000?oGTHKoei66o`00
0?oBSHP00ol00006olV6R@03o`000?o2P8[o000000Oo_7^;00?o0000ok=dS?ncM8`00_ncM8`01?l0
003o[g2<ojm`S?l00007ojIYS003o`000?nKHHcoVf6<00CoVf6<00Co0000ohiGRon>Eh_oSUN;1?l0
0005ogm<RP03o`000?m^?hSoKSn800?oKSn800Go0000oeXaQOmJ<HGoCBN2o`00000Jooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool00Oooool001Oooooo0_l0001Cooooo`03o`000?oo
oooooooo023ooooo0_l00003onbTO@03o`000?oQVX?ohIZ300;ohIZ300Co0000omNAQ_oGTHKo0000
0ooBSHP5o`0000;obHJ900?o0000ol:0R_l000001onlNh/00ol0003o/gB<ok=dS002ok=dS004o`00
0?n_L8co[g2<o`0000OoYVV<00?o0000oi]QS?nKHH`00_nKHH`6o`0000?oSUN;00?o0000ogm<R_mo
C8X00omoC8X00ol0003oKSn8ofhoR003ofhoR004o`000?mJ<HGo0000o`0001cooooo00?o0000oooo
ooooool03_ooool00ol0003oooooooooo`01ooooo`006Oooool00ol0003oooooooooo`1@ooooo`03
o`000?oooooooooo02;ooooo0_l000000oo/Y7go0000on6JP`03on6JP`04o`000?oGTHKoei66o`00
00?odXf800?o0000olV6ROo9QXT00_o9QXT9o`0000?o_7^;00?o0000ok=dS?ncM8`00_ncM8`01?l0
003o[g2<ojm`S?l00007ojIYS003o`000?nKHHco000000;o00000_nKHH`00ol0003oSUN;ohiGR`04
ohiGR`03o`000?moC8[oOdb:00?oOdb:00?o0000ofhoR?m^?hP00om^?hP00omJ<HGo0000ooooo`0N
ooooo`03o`000?oooooooooo00kooooo0Ol00001ooooo`7ooooo000Jooooo`;o0000D?ooool00ol0
003oooooooooo`0Tooooo`;o00001?oQVX<01?l0003oei66omNAQ_l00003om:=R003o`000?o9QXWo
bHJ900CobHJ900?o0000ol:0R_l000001?nlNh/Eo`0000GoVf6<00?o0000ohiGRon>Eh/01?n>Eh/0
0ol0003oOdb:ogm<RP03ogm<RP03o`000?m^?hSoKSn800;oKSn80_l0000Pooooo`03o`000?oooooo
oooo00kooooo0Ol00001ooooo`7ooooo000Looooo`03o`000?oooooooooo04gooooo00?o0000oooo
ooooool09Oooool2o`0000?ohIZ300Co0000omNAQ_oGTHKo00000ooBSHP00ol0003obHJ9olV6R@04
olV6R@03o`000?o2P8[o000000Oo_7^;00?o0000ok=dS?ncM8`00_ncM8`01?l0003o[g2<ojm`S?l0
0007ojIYS003o`000?nKHHcoVf6<00CoVf6<00?o0000ohiGRon>Eh/01?n>Eh/00ol0003oOdb:ogm<
RP03ogm<RP03o`000?m^?hSoKSn800;o00008oooool00ol0003oooooooooo`0=ooooo`7o00000Ooo
ool1ooooo`007Oooool00ol0003oooooooooo`1<ooooo`03o`000?oooooooooo02Oooooo0_l00000
1OoQVX?o0000omNAQ_oGTHKo000000?odXf800?o0000olV6ROo9QXT01?o9QXT00ol0003o`X2:o`00
0007okakR`03o`000?ncM8co/gB<00;o/gB<00Co0000ojm`S?n_L8co00001onVJH`00ol0003oVf6<
oi]QS004oi]QS003o`000?n>Eh_oSUN;00CoSUN;00?o0000ogm<R_moC8X00omoC8X3o`0002Kooooo
00?o0000ooooooooool03?ooool1o`00007ooooo0Oooool001kooooo0_l0001<ooooo`03o`000?oo
oooooooo02Wooooo0_l00002omNAQP05o`000?oBSHSodXf8om:=R?l000001_o9QXT00ol0003o`X2:
o`000007okakR`03o`000?ncM8co/gB<00;o/gB<00Co0000ojm`S?n_L8co00001onVJH`00ol0003o
Vf6<oi]QS004oi]QS003o`000?n>Eh_oSUN;00CoSUN;00?o0000ogm<R_moC8X00_moC8X2o`0002Wo
oooo00?o0000ooooooooool02oooool1o`00007ooooo0Oooool0023ooooo00?o0000ooooooooool0
BOooool00ol0003oooooooooo`0Zooooo`Co00000ooBSHP00ol0003obHJ9olV6R@04olV6R@03o`00
0?o2P8[o000000Oo_7^;00?o0000ok=dS?ncM8`00_ncM8`01?l0003o[g2<ojm`S?l00007ojIYS003
o`000?nKHHcoVf6<00CoVf6<00?o0000ohiGRon>Eh/01?n>Eh/00ol0003oOdb:o`000002o`0002co
oooo00?o0000ooooooooool02_ooool1o`00007ooooo0Oooool0027ooooo00?o0000ooooooooool0
B?ooool00ol0003oooooooooo`0]ooooo`?o000000?odXf8o`000?o9QXT01Oo9QXT00ol0003o`X2:
o`000007okakR`03o`000?ncM8co/gB<00;o/gB<00Co0000ojm`S?n_L8co00001onVJH`00ol0003o
Vf6<oi]QS004oi]QS003o`000?n>Eh_oSUN;00;oSUN;1?l0000`ooooo`03o`000?oooooooooo00Wo
oooo0Ol00001ooooo`7ooooo000Rooooo`;o0000B?ooool00ol0003oooooooooo`0`ooooo`Ko0000
0_o9QXT00ol0003o`X2:o`000007okakR`03o`000?ncM8co/gB<00;o/gB<00Co0000ojm`S?n_L8co
00001onVJH`00ol0003oVf6<oi]QS004oi]QS003o`000?n>Eh_o000000;o0000=Oooool00ol0003o
ooooooooo`08ooooo`7o00000Oooool1ooooo`009?ooool00ol0003oooooooooo`15ooooo`03o`00
0?oooooooooo03Kooooo1Ol00007okakR`03o`000?ncM8co/gB<00;o/gB<00Co0000ojm`S?n_L8co
00001onVJH`01?l0003oVf6<oi]QS?nKHH`5o`0003Sooooo00?o0000ooooooooool02?ooool1o`00
007ooooo0Oooool002Gooooo00?o0000ooooooooool0@oooool00ol0003oooooooooo`0koooooaco
0000?_ooool00ol0003oooooooooo`08ooooo`7o00000Oooool002Kooooo0_l00013ooooo`03o`00
0?oooooooooo09Kooooo00?o0000ooooooooool01oooool1o`00007ooooo000Xooooo`03o`000?oo
oooooooo043ooooo00?o0000ooooooooool0Uoooool00ol0003oooooooooo`06ooooo`7o00000Ooo
ool002Wooooo00?o0000ooooooooool0?oooool00ol0003oooooooooo`2Hooooo`03o`000?oooooo
oooo00Gooooo0Ol00001ooooo`00:_ooool2o`0003oooooo00?o0000ooooooooool0VOooool00ol0
003oooooooooo`04ooooo`7o00000Oooool002cooooo00?o0000ooooooooool0??ooool00ol0003o
ooooooooo`2Jooooo`03o`000?oooooooooo00?ooooo0Ol00001ooooo`00;Oooool2o`0003cooooo
00?o0000ooooooooool0Voooool00ol0003oooooooooo`02ooooo`7o00000Oooool002oooooo00?o
0000ooooooooool0>Oooool00ol0003oooooooooo`2Kooooo`03o`000?oooooooooo00;ooooo0Ol0
0001ooooo`00<?ooool00ol0003oooooooooo`0hooooo`03o`000?oooooooooo09cooooo00Go0000
ooooooooooooooooo`000001ooooo`00<Oooool2o`0003Sooooo00?o0000ooooooooool0WOooool0
1?l0003oooooooooooooool1o`000000<oooool00ol0003oooooooooo`0eooooo`03o`000?oooooo
oooo09kooooo00?o0000ooooooooool00Ol0000003Cooooo00?o0000ooooooooool0=?ooool00ol0
003oooooooooo`2Oooooo`7o00000Oooool1o`000000=Oooool2o`0003Cooooo00?o0000oooooooo
ool0X?ooool2o`000000=oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo09oooooo
0ol0000003Sooooo00?o0000ooooooooool0<?ooool00ol0003oooooooooo`2Jooooo`Go00000ooo
ool003Wooooo0_l0000`ooooo`03o`000?oooooooooo09Kooooo1?l00008ooooo`00>oooool00ol0
003oooooooooo`0]ooooo`03o`000?oooooooooo09;ooooo1?l0000<ooooo`00??ooool00ol0003o
ooooooooo`0/ooooo`03o`000?oooooooooo08gooooo1Ol0000@ooooo`00?Oooool2o`0002cooooo
00?o0000ooooooooool0ROooool4o`0001Gooooo000oooooo`03o`000?oooooooooo02Wooooo00?o
0000ooooooooool0QOooool4o`0001Wooooo0010ooooo`;o0000:Oooool00ol0003oooooooooo`20
ooooo`Go00007Oooool004;ooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`1loooo
o`Co00008_ooool004?ooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`1hooooo`Co
00009_ooool004Cooooo0_l0000Uooooo`03o`000?oooooooooo07?ooooo1Ol0000Zooooo`00A_oo
ool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo06oooooo1?l0000_ooooo`00Aoooool0
0ol0003oooooooooo`0Qooooo`03o`000?oooooooooo06_ooooo1?l0000cooooo`00B?ooool2o`00
027ooooo00?o0000ooooooooool0I_ooool5o`0003Oooooo001:ooooo`03o`000?oooooooooo01ko
oooo00?o0000ooooooooool0H_ooool4o`0003cooooo001;ooooo`03o`000?oooooooooo01gooooo
00?o0000ooooooooool0G_ooool4o`00043ooooo001<ooooo`;o00007Oooool00ol0003ooooooooo
o`1Iooooo`Go0000A?ooool004kooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`1E
ooooo`Co0000BOooool004oooooo0_l0000Jooooo`03o`000?oooooooooo057ooooo1?l0001=oooo
o`00DOooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo04cooooo1Ol0001Aooooo`00
D_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo04Sooooo1?l0001Fooooo`00Dooo
ool2o`0001Kooooo00?o0000ooooooooool0A?ooool4o`0005[ooooo001Eooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool0@?ooool5o`0005kooooo001Fooooo`03o`000?oooooooooo
017ooooo00?o0000ooooooooool0??ooool4o`0006?ooooo001Gooooo`;o00004Oooool00ol0003o
ooooooooo`0hooooo`Co0000Ioooool005Wooooo00?o0000ooooooooool03_ooool00ol0003ooooo
ooooo`0cooooo`Go0000Joooool005[ooooo00?o0000ooooooooool03Oooool00ol0003ooooooooo
o`0_ooooo`Co0000L?ooool005_ooooo0_l0000=ooooo`03o`000?oooooooooo02_ooooo1?l0001d
ooooo`00GOooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo02Kooooo1Ol0001hoooo
o`00G_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo02;ooooo1?l0001mooooo`00
Goooool2o`0000Wooooo00?o0000ooooooooool07_ooool4o`00087ooooo001Qooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool06Oooool5o`0008Gooooo001Rooooo`;o00001_ooool0
0ol0003oooooooooo`0Eooooo`Co0000R_ooool006Cooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0Aooooo`Co0000S_ooool006Gooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`0<ooooo`Go0000T_ooool006Kooooo0_l00002ooooo`03o`000?oooooooooo00Sooooo
1?l0002Gooooo`00J?ooool00ol0003oooooo`000006ooooo`Co0000Voooool006Wooooo0_l00000
0ooooooo0000o`000003o`0009oooooo001Zooooo`;o0000Y?ooool00001\
\>"],
  ImageRangeCache->{{{40.9375, 257.812}, {292.625, 28.125}} -> {-0.0589711, \
0.101849, 0.00290509, 0.00290509}}],

Cell[BoxData[{
    \(Simplify[
      x^2 + y^2 - r^2 /. {x \[Rule] \(alpha[t]\)[\([1]\)], 
          y \[Rule] \(alpha[t]\)[\([2]\)], 
          z \[Rule] \(alpha[t]\)[\([3]\)]}]\), "\n", 
    \(Simplify[\((x + r)\)\^2 + y\^2 + z\^2 - 
          4  r\^2 /. {x \[Rule] \(alpha[t]\)[\([1]\)], 
          y \[Rule] \(alpha[t]\)[\([2]\)], 
          z \[Rule] \(alpha[t]\)[\([3]\)]}]\)}], "Input",
  CellChangeTimes -> {{3.6856080672807198`*^9, 3.685608136464849*^9}, \
{3.685608269177239*^9, 3.685608285678957*^9}, {3.685608374035236*^9, \
3.6856083970996923`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Derivaci\[OAcute]n", "Subsubsection"]], \
"Subsubsection"],

Cell[BoxData[{
    \(D[alpha[t], t]\), "\n", 
    \(\(alpha'\)[t]\), "\n", 
    \(D[alpha[t], {t, 2}]\), "\[IndentingNewLine]", 
    \(\(alpha''\)[t]\)}], "Input",
  CellChangeTimes -> {{3.685606750053553*^9, 3.685606799451136*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Producto escalar ( . ) , norma ( Norm ), producto vectorial ( \
Cross o ", "Subsubsection"],
  "\[Cross] ",
  StyleBox[")  y mixto ( Det )", "Subsubsection"]
}], "Subsubsection",
  CellChangeTimes -> {{3.685606919036479*^9, 3.685606948696947*^9}, \
3.685607310000442*^9, {3.685607375008003*^9, 3.6856073841985083`*^9}, \
{3.685607436585216*^9, 3.685607439985674*^9}}],

Cell[BoxData[{
    \(Simplify[\(alpha'\)[t] . \(alpha'\)[t]]\ \), "\n", 
    \(\(\(Norm[\(alpha'\)[t]] // Expand\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(Simplify[
      Cross[\(alpha'\)[t], \(alpha''\)[t]]]\ \), "\[IndentingNewLine]", 
    \(\(\(Simplify[\(alpha'\)[t]\[Cross]\(alpha''\)[
          t]]\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(Simplify[\((\(alpha'\)[t]\[Cross]\(alpha''\)[t])\) . \(alpha'''\)[
          t]]\), "\n", 
    \(Simplify[
      Det[{\(alpha'\)[t], \(alpha''\)[t], \(alpha'''\)[t]}]]\)}], "Input",
  CellChangeTimes -> {{3.685606832053577*^9, 3.6856068635543013`*^9}, \
{3.685606975103972*^9, 3.685607019909628*^9}, {3.685607049965848*^9, \
3.685607223622511*^9}, {3.685607385907086*^9, 3.685607428223441*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Triedro de Frenet", "Subsubsection",
  CellChangeTimes -> {{3.685616674262237*^9, 3.68561668428519*^9}}],

Cell[BoxData[{
    \(T1 = 
      Simplify[\(alpha'\)[t]/Sqrt[\(alpha'\)[t] . \(alpha'\)[t]]]\), "\n", 
    \(\(aux = 
        Cross[\(alpha'\)[t], \(alpha''\)[t]] // 
          Simplify;\)\), "\[IndentingNewLine]", 
    \(B1 = 
      PowerExpand[aux/Sqrt[aux . aux]] // Simplify\), "\[IndentingNewLine]", 
    \(N1 = Cross[B1, T1]\)}], "Input",
  CellChangeTimes -> {{3.685616726223605*^9, 3.685616832989583*^9}, \
{3.685616924327319*^9, 3.685617104855938*^9}, {3.685617138324436*^9, \
3.685617154927765*^9}, {3.68561726957437*^9, 3.6856173133667192`*^9}, \
{3.685617367581998*^9, 3.685617368979906*^9}, 3.685617406158025*^9, \
{3.6856177907400208`*^9, 3.6856178155044394`*^9}}],

Cell[BoxData[{
    \(T1 /. {t \[Rule] Pi/2, r \[Rule] 1}\), "\[IndentingNewLine]", 
    \(N1 /. {t \[Rule] Pi/2, r \[Rule] 1}\), "\[IndentingNewLine]", 
    \(B1 /. {t \[Rule] Pi/2, r \[Rule] 1}\)}], "Input",
  CellChangeTimes -> {{3.6856174284540157`*^9, 3.685617450520612*^9}}],

Cell["Y como funci\[OAcute]n (escribimos s\[OAcute]lo T)", "Text",
  CellChangeTimes -> {{3.685618049324861*^9, 3.68561806039915*^9}, \
{3.685618146977722*^9, 3.6856181568955107`*^9}}],

Cell[BoxData[{
    \(Clear["\<T1\>"]\), "\n", 
    \(T1[t_] := 
      Simplify[\(alpha'\)[t]/Sqrt[\(alpha'\)[t] . \(alpha'\)[t]]]\)}], "Input",\

  CellChangeTimes -> {3.685618077845522*^9, 3.6856181384457903`*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Buscando puntos con torsi\[OAcute]n nula (", "Subsubsection"],
  "\[Alpha]",
  StyleBox["\[CloseCurlyQuote][t]\[Cross]", "Subsubsection"],
  "\[Alpha]",
  StyleBox["\[CloseCurlyQuote]\[CloseCurlyQuote][t]).", "Subsubsection"],
  "\[Alpha]",
  StyleBox["\[CloseCurlyQuote]\[CloseCurlyQuote]\[CloseCurlyQuote][t]=0 )", 
    "Subsubsection"]
}], "Subsubsection",
  CellChangeTimes -> {{3.6856076495277452`*^9, 3.685607658236524*^9}, \
{3.685607688925515*^9, 3.6856076989318542`*^9}, {3.685607864590839*^9, \
3.685607868171213*^9}, {3.685607905015974*^9, 3.685607919575811*^9}}],

Cell[BoxData[
    \(ss = 
      Solve[Det[{\(alpha'\)[t], \(alpha''\)[t], \(alpha'''\)[t]}] \[Equal] 0, 
        t]\)], "Input",
  CellChangeTimes -> {{3.685607705197241*^9, 3.68560771411897*^9}, \
{3.68560779776019*^9, 3.6856078005587273`*^9}}],

Cell[BoxData[
    \(Simplify[alpha[t]] /. ss\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Traza de una curva parametrizada en el espacio R3", \
"Subsubsection"]], "Subsubsection",
  CellChangeTimes -> {{3.6856084297863503`*^9, 3.685608430446471*^9}, \
{3.685608497582502*^9, 3.685608519532195*^9}}],

Cell[BoxData[{
    \(Clear[r]\), "\n", 
    \(\(r = 1;\)\), "\n", 
    \(traza = 
      ParametricPlot3D[Evaluate[alpha[t]], {t, 0, 4\ Pi\ r}, 
        ViewPoint \[Rule] {2.5, 2, 1}]\)}], "Input",
  CellChangeTimes -> {{3.6856084438916893`*^9, 3.6856084710836573`*^9}, \
{3.6859631177431087`*^9, 3.6859631350376253`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Longitud de un arco de curva", "Subsubsection"]], \
"Subsubsection",
  CellChangeTimes -> {{3.68560854527409*^9, 3.685608552409639*^9}}],

Cell[BoxData[{
    \(\(Clear[r];\)\), "\[IndentingNewLine]", 
    \(s[t_] := 
      Integrate[Sqrt[\(alpha'\)[t] . \(alpha'\)[t]], 
        t]\), "\[IndentingNewLine]", 
    \(s[t]\)}], "Input",
  CellChangeTimes -> {{3.6856088887847567`*^9, 3.685608903416367*^9}, \
{3.685608935072269*^9, 3.685608949591028*^9}}],

Cell[BoxData[{
    \(\(r = 1;\)\), "\[IndentingNewLine]", 
    \(NIntegrate[
      Sqrt[\(alpha'\)[t] . \(alpha'\)[t]], {t, 0, \ 4\ Pi\ r}]\)}], "Input",
  CellChangeTimes -> {{3.68560911229988*^9, 3.6856091153486433`*^9}, \
{3.685613220078135*^9, 3.6856132234731283`*^9}}],

Cell["\[DownQuestion]Parametrizamos por el arco? (No siempre)", "Text",
  CellChangeTimes -> {{3.6856090554294367`*^9, 3.685609072690872*^9}}],

Cell[BoxData[{
    \(\(r = 1;\)\), "\[IndentingNewLine]", 
    \(Solve[s[t] \[Equal] s, t]\)}], "Input",
  CellChangeTimes -> {{3.685609006438384*^9, 3.6856090421098747`*^9}, \
{3.685609084891824*^9, 3.685609088227914*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Parametrizando por el arco", "Subsubsection"]], \
"Subsubsection",
  CellChangeTimes -> {{3.68560854527409*^9, 3.685608552409639*^9}, \
{3.685613075301643*^9, 3.685613081019095*^9}}],

Cell["\<\
Veamos un ejemplo en que s\[IAcute] es posible parametrizar por el \
arco, una h\[EAcute]lice.\
\>", "Text",
  CellChangeTimes -> {{3.6856090554294367`*^9, 3.685609072690872*^9}, \
{3.6856130969408216`*^9, 3.685613109186462*^9}, {3.685613243456025*^9, \
3.68561325114188*^9}, {3.685614242125924*^9, 3.685614242484356*^9}}],

Cell[BoxData[{
    \(\(alpha[t_] := {Cos[t], Sin[t], t/3};\)\), "\[IndentingNewLine]", 
    \(rtrayectoria = 
      ParametricPlot3D[alpha[t], {t, \(-4\) Pi, 4  Pi}]\)}], "Input",
  CellChangeTimes -> {{3.6856088887847567`*^9, 3.685608903416367*^9}, \
{3.685608935072269*^9, 3.685608949591028*^9}, {3.6856131413417187`*^9, \
3.685613213746503*^9}, {3.685613284782967*^9, 3.68561332026173*^9}, \
{3.68561409619473*^9, 3.685614101866777*^9}}],

Cell[BoxData[{
    \(s[t_] := 
      Integrate[
        Sqrt[\(alpha'\)[z] . \(alpha'\)[z]], {z, \(-4\) Pi, 
          t}]\), "\[IndentingNewLine]", 
    \(s[t]\), "\[IndentingNewLine]", 
    \(sol = Solve[s[t] \[Equal] s, t]\)}], "Input",
  CellChangeTimes -> {{3.6856133280367002`*^9, 3.685613480270396*^9}, \
{3.6856135875034027`*^9, 3.685613588303195*^9}, {3.685613815375474*^9, \
3.685613868062729*^9}, {3.685613913612237*^9, 3.685613914845208*^9}, \
{3.6856140784303923`*^9, 3.685614091267046*^9}}],

Cell["Construimos la reparametrizaci\[OAcute]n p.p.a. de la curva:", "Text",
  CellChangeTimes -> {{3.6856090554294367`*^9, 3.685609072690872*^9}, \
3.685613513981112*^9, {3.685614256911291*^9, 3.685614281842787*^9}}],

Cell[BoxData[{
    \(alphappa = alpha[t /. sol[\([1]\)]]\), "\[IndentingNewLine]", 
    \(D[alphappa, s] . D[alphappa, s] // Simplify\)}], "Input",
  CellChangeTimes -> {{3.6856088887847567`*^9, 3.685608903416367*^9}, \
{3.685608935072269*^9, 3.685608949591028*^9}, {3.6856131413417187`*^9, \
3.685613213746503*^9}, {3.685613284782967*^9, 3.6856132850717077`*^9}, \
{3.6856134860701838`*^9, 3.685613559551825*^9}, {3.6856135918395987`*^9, \
3.6856136625798683`*^9}, {3.685613734883812*^9, 3.685613739204221*^9}, \
{3.68561376925893*^9, 3.685613803002594*^9}, {3.6856139254364443`*^9, \
3.6856139260684032`*^9}, {3.6856139699243937`*^9, 3.685613978726583*^9}, \
{3.6856141135253773`*^9, 3.685614198225175*^9}}]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Haz de curvas", "Subsubsection"]], "Subsection",
  CellChangeTimes -> {{3.6856092192400637`*^9, 3.685609314067144*^9}}],

Cell[CellGroupData[{

Cell["Dibujo de familias de curvas ", "Subsubsection",
  CellChangeTimes -> {{3.685609957704258*^9, 3.685609981780777*^9}}],

Cell[TextData[{
  StyleBox["Dibujo de curvas de la familia de par\[AAcute]metro r:  ", 
    "Subsubsection"],
  Cell[BoxData[
      \(TraditionalForm\`\[Alpha]\_r\)]],
  "(t) =(a+r cos(t),r sen(t)) con a =r/sen(p) y p=\[Pi]/6.\nEl primer valor \
de r es -5, el \[UAcute]ltimo es 5, increment\[AAcute]ndose en cada paso 0.5.\
\n\[DownQuestion]Qui\[EAcute]nes son las rectas a\[NTilde]adidas en el \
segundo dibujo?"
}], "Text",
  CellChangeTimes -> {3.6856092192400637`*^9, {3.685609320395194*^9, \
3.685609428734247*^9}, {3.6856095618769913`*^9, 3.6856095622925463`*^9}, \
{3.6856098716068277`*^9, 3.6856099126039762`*^9}}],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\n", 
    \(p = Pi\/6; a = r\/Sin[p];\), "\[IndentingNewLine]", 
    \(Show[\[IndentingNewLine]Table[
        ParametricPlot[{a + \ r\ Cos[t], r\ Sin[t]}, {t, 0, 2\ Pi}, 
          DisplayFunction \[Rule] Identity], {r, \(-5\), 5,  .5}], 
      DisplayFunction \[Rule] $DisplayFunction]\)}], "Input",
  CellChangeTimes -> {{3.685609590733781*^9, 3.6856095967009687`*^9}, \
{3.6856096302402077`*^9, 3.685609633584433*^9}, {3.685609917197422*^9, \
3.6856099188452578`*^9}}],

Cell[BoxData[
    \(Show[\[IndentingNewLine]Table[
        ParametricPlot[{a + \ r\ Cos[t], r\ Sin[t]}, {t, 0, 2\ Pi}, 
          DisplayFunction \[Rule] Identity], {r, \(-5\), 5,  .5}], 
      ParametricPlot[{t, t\ Tan[p]}, {t, \(-15\), 15}, 
        PlotStyle \[Rule] {Thickness[0.005]}, 
        DisplayFunction \[Rule] Identity], 
      ParametricPlot[{t, \(-t\)\ Tan[p]}, {t, \(-15\), 15}, 
        PlotStyle \[Rule] {Thickness[0.005]}, 
        DisplayFunction \[Rule] 
          Identity], \[IndentingNewLine]DisplayFunction \[Rule] \
$DisplayFunction, AspectRatio \[Rule] Automatic]\)], "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Otros c\[AAcute]lculos con curvas parametrizadas", \
"Subsubsection"]], "Subsection",
  CellChangeTimes -> {{3.6856059194534073`*^9, 3.685605923595993*^9}, \
{3.685606571014675*^9, 3.685606624634354*^9}, {3.685608028772184*^9, \
3.6856080292227917`*^9}, {3.685615902798786*^9, 3.685615915579739*^9}, \
{3.6856181873450603`*^9, 3.685618189430997*^9}}],

Cell[CellGroupData[{

Cell["Plano osculador", "Subsubsection",
  CellChangeTimes -> {{3.685609957704258*^9, 3.685609981780777*^9}, \
{3.685615993985639*^9, 3.6856160099520903`*^9}}],

Cell["\<\
Usamos que los puntos P del plano osculador en \[Alpha] (t) cumplen \
(P - \[Alpha] (t)) es combinaci\[OAcute]n de \[Alpha]' (t) y \[Alpha]'' (t), \
para obtener su ecuaci\[OAcute]n impl\[IAcute]cita.\
\>", "Text",
  CellChangeTimes -> {{3.685616211651752*^9, 3.685616271095641*^9}, \
3.6856163488817368`*^9, {3.685616401005742*^9, 3.6856164107299833`*^9}}],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\n", 
    \(alpha[t_] := {3  t, 3  t^2, 2  t^3}\), "\n", 
    \(\(X = {x, y, z};\)\), "\[IndentingNewLine]", 
    \(planoosculador = 
      Det[{\((X - alpha[t])\), \(alpha'\)[t], \(alpha''\)[t]}] \[Equal] 
        0\)}], "Input",
  CellChangeTimes -> {{3.685616040668812*^9, 3.685616057099497*^9}, \
{3.685616179613276*^9, 3.6856162011719103`*^9}, {3.685616276498829*^9, \
3.6856163191314697`*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Tecta tangente", "Subsubsection",
  CellChangeTimes -> {{3.685609957704258*^9, 3.685609981780777*^9}, \
{3.685615993985639*^9, 3.6856160099520903`*^9}, {3.685616358796513*^9, \
3.685616365282308*^9}}],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\n", 
    \(\(alpha[t_] := {3\ t, 3  t^2, 2  t^3};\)\), "\n", 
    \(rt[t_, u_] := \[Alpha][t] + u*\(\[Alpha]'\)[t]\)}], "Input",
  CellChangeTimes -> {{3.6856182446521*^9, 3.685618268811627*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Curvatura, torsi\[OAcute]n, radio de curvatura", "Subsubsection",
  CellChangeTimes -> {{3.685616674262237*^9, 3.68561668428519*^9}, \
{3.685618211699356*^9, 3.6856182292785883`*^9}, {3.68561895857692*^9, \
3.685618959743029*^9}}],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\n", 
    \(alpha[t_] := {r*Cos[t], r*Sin[t], 4  t}\ \), "\[IndentingNewLine]", 
    \(\(norma[z_] := Sqrt[z . z];\)\)}], "Input",
  CellChangeTimes -> {{3.685616726223605*^9, 3.685616814004925*^9}, \
{3.6856182870934153`*^9, 3.685618289186984*^9}, {3.68561835070012*^9, \
3.6856183723462152`*^9}, {3.685618459281002*^9, 3.6856185156246157`*^9}, \
3.685618797171515*^9, {3.6856188298808537`*^9, 3.6856188300237217`*^9}, \
{3.6856193732958307`*^9, 3.685619452544834*^9}}],

Cell[BoxData[{
    \(curvatura[t_] := 
      norma[Cross[\(alpha'\)[t], \(alpha''\)[t]]]/norma[\(alpha'\)[t]]^3 // 
        Simplify\), "\[IndentingNewLine]", 
    \(torsion[
        t_] := \(-Det[{\(alpha'\)[t], \(alpha''\)[t], \(alpha'''\)[t]}]\)/
          norma[Cross[\(alpha'\)[t], \(alpha''\)[t]]]^2 // 
        Simplify\), "\[IndentingNewLine]", 
    \(\(("\<recordar la nota sobre el signo de la torsi\[OAcute]n\>")\)\), "\
\[IndentingNewLine]", 
    \(radio[t_] := 1/curvatura[t]\), "\[IndentingNewLine]", 
    \(curvatura[t] // PowerExpand\), "\[IndentingNewLine]", 
    \(torsion[t]\)}], "Input",
  CellChangeTimes -> {{3.685618380191983*^9, 3.6856184536880217`*^9}, \
{3.6856185232730103`*^9, 3.6856185294319687`*^9}, {3.685618639424532*^9, \
3.685618728894682*^9}, {3.685618760926393*^9, 3.6856187898135767`*^9}, \
{3.6856188437365093`*^9, 3.685618915778376*^9}, {3.685618965101132*^9, \
3.685618968914814*^9}, {3.68561933902147*^9, 3.685619355864643*^9}, \
{3.685619460492524*^9, 3.685619460879903*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Centro de curvatura y Evoluta", "Subsubsection",
  CellChangeTimes -> {{3.685616674262237*^9, 3.68561668428519*^9}, \
{3.685618211699356*^9, 3.6856182292785883`*^9}, {3.68561895857692*^9, \
3.685618978918311*^9}, {3.685619111669519*^9, 3.685619116347598*^9}}],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\n", 
    \(\(alpha[t_] := {Cos[t], Sin[t], t/2};\)\), "\[IndentingNewLine]", 
    \(\(\(norma[z_] := Sqrt[z . z];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(T1[t_] := Simplify[\(alpha'\)[t]/norma[\(alpha'\)[t]]]\), "\n", 
    \(\(B1[t_] := 
        Cross[\(alpha'\)[t], \(alpha''\)[t]]/
            norma[Cross[\(alpha'\)[t], \(alpha''\)[t]]] // 
          Simplify;\)\), "\[IndentingNewLine]", 
    \(\(\(N1[t_] := Cross[B1[t], T1[t]]\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(curvatura[t_] := 
      norma[Cross[\(alpha'\)[t], \(alpha''\)[t]]]/norma[\(alpha'\)[t]]^3 // 
        Simplify\), "\[IndentingNewLine]", 
    \(\(\(radio[t_] := 1/curvatura[t]\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(evoluta[t_] := alpha[t] + N1[t]/curvatura[t]\), "\[IndentingNewLine]", 
    \(evoluta[t]\)}], "Input",
  CellChangeTimes -> {{3.685616726223605*^9, 3.685616832989583*^9}, \
{3.685616924327319*^9, 3.685617104855938*^9}, {3.685617138324436*^9, \
3.685617154927765*^9}, {3.68561726957437*^9, 3.6856173133667192`*^9}, \
{3.685617367581998*^9, 3.685617368979906*^9}, 3.685617406158025*^9, \
{3.6856177907400208`*^9, 3.6856178155044394`*^9}, {3.685619163763385*^9, \
3.6856192032262487`*^9}, {3.685619235146435*^9, 3.685619321889804*^9}, \
{3.685619513239435*^9, 3.685619603973319*^9}, {3.685619640463004*^9, \
3.685619682526092*^9}, {3.6856200728294*^9, 3.685620076658224*^9}, \
{3.6856201194430647`*^9, 3.685620135842643*^9}}],

Cell[BoxData[
    \(ParametricPlot3D[Evaluate[{alpha[t], evoluta[t]}], {t, 0, 4\ Pi}, 
      ViewPoint \[Rule] {2.5, 2, 1}]\)], "Input",
  CellChangeTimes -> {3.685620091095812*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Centro de curvatura y Evoluta 2D (usando la 3D)", "Subsubsection",
  CellChangeTimes -> {{3.685616674262237*^9, 3.68561668428519*^9}, \
{3.685618211699356*^9, 3.6856182292785883`*^9}, {3.68561895857692*^9, \
3.685618978918311*^9}, {3.685619111669519*^9, 3.685619116347598*^9}, \
{3.6856197907287617`*^9, 3.685619791597095*^9}, {3.685620011895739*^9, \
3.685620016255705*^9}}],

Cell["\<\
En este caso, dibujamos el astroide, como evoluta de una \
elipse.\
\>", "Text",
  CellChangeTimes -> {{3.685620177887315*^9, 3.6856202012387657`*^9}}],

Cell[BoxData[{
    \(Clear["\<Global`*\>"]\), "\n", 
    \(\(alpha[t_] := {2*Cos[t], Sin[t], 0};\)\), "\[IndentingNewLine]", 
    \(\(\(norma[z_] := Sqrt[z . z];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(T1[t_] := Simplify[\(alpha'\)[t]/norma[\(alpha'\)[t]]]\), "\n", 
    \(\(B1[t_] := 
        Cross[\(alpha'\)[t], \(alpha''\)[t]]/
            norma[Cross[\(alpha'\)[t], \(alpha''\)[t]]] // 
          Simplify;\)\), "\[IndentingNewLine]", 
    \(\(\(N1[t_] := Cross[B1[t], T1[t]] // Simplify\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(curvatura[t_] := 
      norma[Cross[\(alpha'\)[t], \(alpha''\)[t]]]/norma[\(alpha'\)[t]]^3 // 
        Simplify\), "\[IndentingNewLine]", 
    \(\(\(radio[t_] := 1/curvatura[t]\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(evoluta[t_] := alpha[t] + N1[t]/curvatura[t]\), "\[IndentingNewLine]", 
    \(evoluta[t]\)}], "Input",
  CellChangeTimes -> {{3.685616726223605*^9, 3.685616832989583*^9}, \
{3.685616924327319*^9, 3.685617104855938*^9}, {3.685617138324436*^9, \
3.685617154927765*^9}, {3.68561726957437*^9, 3.6856173133667192`*^9}, \
{3.685617367581998*^9, 3.685617368979906*^9}, 3.685617406158025*^9, \
{3.6856177907400208`*^9, 3.6856178155044394`*^9}, {3.685619163763385*^9, \
3.6856192032262487`*^9}, {3.685619235146435*^9, 3.685619321889804*^9}, \
{3.685619513239435*^9, 3.685619603973319*^9}, {3.685619640463004*^9, \
3.685619682526092*^9}, {3.6856198615719624`*^9, 3.68561986389797*^9}, \
{3.685619896577724*^9, 3.685619899416871*^9}}],

Cell[BoxData[
    \(ParametricPlot3D[Evaluate[{alpha[t], evoluta[t]}], {t, 0, 4\ Pi}, 
      ViewPoint \[Rule] {0, 0, 1}]\)], "Input",
  CellChangeTimes -> {{3.685619975278728*^9, 3.685620031861498*^9}}]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.0 for Macintosh",
ScreenRectangle->{{0, 1839}, {0, 1178}},
WindowSize->{1073, 1114},
WindowMargins->{{-1, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrintingOptions->{"PrintingMargins"->{{36, 36}, {36, 36}},
"PrintCellBrackets"->True,
"PrintRegistrationMarks"->True,
"PrintMultipleHorizontalPages"->False},
DockedCells -> FEPrivate`FrontEndResource[ "FEExpressions", \
"CompatibilityToolbar"],
StyleDefinitions -> "Default.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 150, 2, 68, "Title"],

Cell[CellGroupData[{
Cell[1951, 59, 100, 1, 69, "Section"],

Cell[CellGroupData[{
Cell[2076, 64, 333, 4, 38, "Subsection"],
Cell[2412, 70, 292, 6, 46, "Text"],
Cell[2707, 78, 676, 12, 91, "Input"],
Cell[3386, 92, 288, 6, 30, "Text"],
Cell[3677, 100, 271, 4, 27, "Input"],
Cell[3951, 106, 487, 7, 27, "Input"],
Cell[4441, 115, 468, 9, 62, "Text"],
Cell[4912, 126, 611, 12, 107, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[5560, 143, 251, 3, 30, "Subsection"],
Cell[5814, 148, 148, 2, 30, "Text"],
Cell[5965, 152, 425, 7, 59, "Input"],
Cell[6393, 161, 423, 9, 46, "Text"],
Cell[6819, 172, 684, 11, 75, "Input"],
Cell[7506, 185, 468, 9, 62, "Text"],
Cell[7977, 196, 896, 16, 123, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[8910, 217, 444, 6, 30, "Subsection"],
Cell[9357, 225, 502, 10, 59, "Input"],
Cell[9862, 237, 427, 8, 30, "Text"],
Cell[10292, 247, 399, 7, 59, "Input"],
Cell[10694, 256, 216, 3, 30, "Text"],
Cell[10913, 261, 879, 14, 75, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[11829, 280, 451, 6, 30, "Subsection"],
Cell[12283, 288, 427, 6, 43, "Input"],
Cell[12713, 296, 562, 12, 110, "Text"],
Cell[13278, 310, 793, 15, 91, "Input"],
Cell[14074, 327, 302, 4, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[14413, 336, 204, 2, 30, "Subsection"],
Cell[14620, 340, 1146, 21, 94, "Text"],
Cell[15769, 363, 588, 11, 91, "Input"],
Cell[16360, 376, 347, 5, 30, "Text"],
Cell[16710, 383, 228, 3, 43, "Input"],
Cell[16941, 388, 409, 5, 30, "Text"],
Cell[17353, 395, 388, 7, 43, "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17790, 408, 110, 1, 69, "Section"],

Cell[CellGroupData[{
Cell[17925, 413, 251, 4, 38, "Subsection"],
Cell[18179, 419, 259, 5, 43, "Input"],

Cell[CellGroupData[{
Cell[18463, 428, 264, 3, 28, "Subsubsection"],
Cell[18730, 433, 323, 8, 30, "Text"],
Cell[19056, 443, 865880, 39274, 344, 730690, 37601, "GraphicsData", \
"PostScript", "Graphics"],
Cell[884939, 39719, 562, 11, 47, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[885538, 39735, 82, 1, 22, "Subsubsection"],
Cell[885623, 39738, 232, 5, 75, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[885892, 39748, 395, 8, 22, "Subsubsection"],
Cell[886290, 39758, 770, 15, 139, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[887097, 39778, 110, 1, 22, "Subsubsection"],
Cell[887210, 39781, 678, 13, 75, "Input"],
Cell[887891, 39796, 279, 4, 59, "Input"],
Cell[888173, 39802, 184, 2, 30, "Text"],
Cell[888360, 39806, 214, 5, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[888611, 39816, 602, 12, 22, "Subsubsection"],
Cell[889216, 39830, 245, 5, 27, "Input"],
Cell[889464, 39837, 57, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[889558, 39843, 232, 3, 22, "Subsubsection"],
Cell[889793, 39848, 321, 7, 59, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[890151, 39860, 160, 2, 22, "Subsubsection"],
Cell[890314, 39864, 313, 7, 59, "Input"],
Cell[890630, 39873, 273, 5, 43, "Input"],
Cell[890906, 39880, 142, 1, 30, "Text"],
Cell[891051, 39883, 223, 4, 43, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[891311, 39892, 206, 3, 22, "Subsubsection"],
Cell[891520, 39897, 332, 6, 30, "Text"],
Cell[891855, 39905, 440, 7, 43, "Input"],
Cell[892298, 39914, 504, 10, 59, "Input"],
Cell[892805, 39926, 217, 2, 30, "Text"],
Cell[893025, 39930, 709, 10, 43, "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[893783, 39946, 143, 1, 38, "Subsection"],

Cell[CellGroupData[{
Cell[893951, 39951, 123, 1, 28, "Subsubsection"],
Cell[894077, 39954, 623, 12, 64, "Text"],
Cell[894703, 39968, 518, 9, 112, "Input"],
Cell[895224, 39979, 603, 11, 91, "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[895876, 39996, 374, 5, 38, "Subsection"],

Cell[CellGroupData[{
Cell[896275, 40005, 159, 2, 28, "Subsubsection"],
Cell[896437, 40009, 367, 6, 30, "Text"],
Cell[896807, 40017, 446, 9, 75, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[897290, 40031, 206, 3, 22, "Subsubsection"],
Cell[897499, 40036, 243, 4, 59, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[897779, 40045, 236, 3, 22, "Subsubsection"],
Cell[898018, 40050, 517, 8, 59, "Input"],
Cell[898538, 40060, 1017, 18, 107, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[899592, 40083, 265, 3, 22, "Subsubsection"],
Cell[899860, 40088, 1535, 27, 219, "Input"],
Cell[901398, 40117, 181, 3, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[901616, 40125, 381, 5, 22, "Subsubsection"],
Cell[902000, 40132, 161, 4, 30, "Text"],
Cell[902164, 40138, 1548, 27, 219, "Input"],
Cell[903715, 40167, 203, 3, 27, "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

