function RunVtsExample
%Run Vts (Vector Taylor Series compensation) Example
%Execute the Stages (see below) in this order: FETr, Tr, Te
%This program generates also a simulated Training/Test database (see
%GenTrTeData) just to observe some results
%
%
%VTS used in papers Juan A. Morales-Cordovilla papers such as:
%
%[1] Juan A. Morales-Cordovilla, Martin Hagmüller, Hannes Pessentheiner and Gernot Kubin. 
%"Distant speech recognition in reverberant noisy conditions employing a microphone array".
%EUSIPCO. 2014.
%
%[2]Juan A. Morales-Cordovilla, Hannes Pessentheiner, Martin Hagmüller, José A. González and Gernot Kubin. 
%"CVX-optimized beamforming and VTS compensation with German ASR employing star-shaped microphone array". 
%Lecture Notes in Computer Science (Springer), 8854: 148-157. 2014.


%Add paths
addpath('./Fun')
addpath('./Fun/VtsFun')
addpath('./Fun/Common')
addpath('./Fun/SignGen')
addpath('./Fun/voicebox')

%Parameters
ResDir='./Results'; %Results Directory
SpDir='./SpeechData'; %Speech Database
Stage='FETr'; %Stage: FETr (Feature Extraction of Training), Tr (Training) or Te (Test)
P=VtsParam(ResDir);



%Generate Training Test speech Database (only first time if neccesary)
GenTrTeData([SpDir '/Tr'],[SpDir '/Te']);

%Stages
switch Stage
    case 'FETr'
        FEVTSComp1Dir([SpDir '/Tr'],[ResDir '/Tr'],Stage,P);       
        
    case 'Tr'
        TrImpGmm(ResDir,P,{'Tr'});
       
    case 'Te'        
        FEVTSComp1Dir([SpDir '/Te'],[ResDir '/Te'],Stage,P);
        
        
end



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function GenTrTeData(TrDir,TeDir)
%Generate Training Test speech Database (only first time if neccesary)
if ~exist(TrDir,'dir')
    FSamp=16000; %Sample Frequency
    NUttDir=2; %Number of Utterances per Dir
    GenDirSpeech(TrDir,NUttDir,FSamp,0);
    GenDirSpeech(TeDir,NUttDir,FSamp,1);
end


function FEVTSComp1Dir(SD,RD,Stage,P)
%Front End VTS Compensation for One Directory
%SD: Speech Directory
%RD: Result Directory
%Stage: Stage 'FETr' or 'Te'
fy=dir([SD '/*' '.wav']); l=size(fy,1); 
[x,x,x]=mkdir(RD);
for i=1:l    
    [pn,bn]=fileparts(fy(i).name);    
    [y,P.FSamp]=audioread([SD '/' bn '.wav']);    
    FEVTSComp(y,RD,bn,Stage,P);

end











