function [s2]=PhAcFe2GammSignal(ChMag,DurSec,Voice,PiFa,StrFa,FSampHz,MePiHz)
%Phoneme Acoustic Features To Gammatone Signal
%ChMag: Channel Magnitude 
%DurSec: Duration in Seconds
%Voice: Voice/Unvoice 
%PiFa: Pitch Factor [0 2]
%StrFa: Stress Factor [0 2]
%FSampHz: Sample Freq in Hertz
%MePiHz: Mean Pitch in Hertz


%Parameters
NCH     = 26; %Number of channels
LCFHz   = 50; % Low Center Freq (50 Hz)
HCFHz   = round(FSampHz/2-(FSampHz/(NCH))); %High Center Freq  (3750 or 7500  Hz)
ExSamp  = FSampHz; %Extra Samples
GamCFHz = MakeErbCFs(LCFHz,HCFHz,NCH);  %Gammatone Center Freq in Hz

%With 26 channels the formants locate: /i/ in 6 and 20 ch. (320 and 3200
%Hz) /a/ in 12 and 13 ch. (1000 and 1400 Hz). If ChMag has only 5 channel
%codification we have to include row of zeros to locate formants properly.
[FL,nf]=size(ChMag); ChMag=[zeros(1,nf); ChMag; zeros(1,nf)];

%Pitch
PiHz=PiFa*MePiHz;
Pi=Dur2SampMSo(PiHz,DurSec,FSampHz);
Vo=Dur2SampMHa(Voice,DurSec,FSampHz); Pi=Pi.*Vo;

%Excitation
e=Pit2Excit(Pi,ExSamp,FSampHz);
[CG]=CochlGramSynt(e,FSampHz,GamCFHz);
CG=CG(:,ExSamp+1:end);

%Magnitude
M=Dur2SampMHa(ChMag,DurSec,FSampHz);
Mf=ReRMa(M,NCH);

%Stress Factor
StF=Dur2SampMSo(StrFa,DurSec,FSampHz);
%s=sum(M); i=s==0; StF(i)=0;


%Formanted and Stressed signal
CG=CG.*Mf;
s=sum(CG);
s2=s.*StF;

% subplot(511), jplot(s)
% subplot(512), jplot(s2)
% subplot(513), jimagesc(Mf)
% subplot(514), jplot(Pi)
% subplot(515), jplot(StF)
% soundsc(s2,FSampHz);
% pause

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Mf=ReRMa(M,NCH)
%Re sample Row of a Matrix (in FUTURE apply smooth)
[ONCH,NSamp]=size(M);
Mf=zeros(NCH,NSamp);
for c=1:NCH
    j=round(0.5+(c/NCH)*ONCH);
    j=min(j,ONCH);
    j=max(j,1);    
    Mf(c,:)=M(j,:);    
end






%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function ya=Dur2SampMSo(ys,DurSec,FSampHz)
%Duration To Sample Matrix Soft
TDurSec=sum(DurSec); %Total Duration in Seconds
NSamp=round(TDurSec*FSampHz); 
l=length(DurSec);
SSec=0; 
xs=zeros(1,l);
for i=1:l
    s=round(SSec*FSampHz)+1;
    e=round((SSec+DurSec(i))*FSampHz);
    xs(i)=round((s+e)/2);    
    SSec=SSec+DurSec(i);    
end
xa=1:NSamp; 
ya=interp1(xs,ys,xa,'pchip');

function M2=Dur2SampMHa(M,DurSec,FSampHz)
%Duration To Sample Matrix Hard
TDurSec=sum(DurSec); %Total Duration in Seconds
NSamp=round(TDurSec*FSampHz);  
FL=size(M,1);
M2=zeros(FL,NSamp);
l=length(DurSec);
SSec=0; 
for i=1:l
    s=round(SSec*FSampHz)+1;
    e=round((SSec+DurSec(i))*FSampHz);
    int=s:e;
    M2(:,int)=repmat(M(:,i),[1,length(int)]); 
    SSec=SSec+DurSec(i);    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function e=Pit2Excit(PitHzo,ExSamp,FSampHz)
%Pitch To Excitation. In 0 pitches is randn
%Fill Pit in Unvoiced
PitHz=PitHzo;
Vo=PitHz>0; Un=not(Vo); %Voice Samples
MePitHz=mean(PitHz(Vo));
PitHz(Un)=MePitHz;
%Pit excitation
NSamp=length(PitHz);
pit=(FSampHz./PitHz);     
p=[pit(1)*ones(1,ExSamp) pit];  
NSampT=ExSamp+NSamp;  
e=zeros(1,NSampT); e(1)=1; a=p(1);    
for i=1:NSampT
    a=a-1; if a<=0; e(i)=1; a=p(i); end
end      
%
Vo=[zeros(1,ExSamp) Vo];
[a,d]=FindAscDesc1(not(Vo));
for i=1:length(a)
    int=a(i):d(i);
    e(int)=randn(1,length(int))*0.10; %factor to have some 
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [CG]=CochlGramSynt(y,FSampHz,GamCFHz)
%Cochleagram and corresponding Hilbert Envelope for Synthesis (not
%Analysis)
NCH=length(GamCFHz);
ns=length(y); 
CG=zeros(NCH,ns); 
for c=1:NCH    
    %Fast (1, half-wave-rect)
    [CG(c,:)]=gammatone_c(y,FSampHz,GamCFHz(c),0); %CGe(c,:)=env;    
    %Slow
    %CG(c,:)=gammatone(y,FSampHz,GamCFHz(c),true);   
end
