function GenDirSpeech(do,NUtt,FSamp,AddNoise)
%Generate Directory of Speech signals (.wav)
%do: Dir Output
%NUtt: Number of Utterances
%FSamp: Sample Frequency
%AddNoise: Add Noise (0 or 1)



%Default
switch nargin
    case 0
        %Inputs/Outputs
        do='/tmp/SpDir'; 
        NUtt=10;
        FSamp=16000;
        AddNoise=0;
end
[x,x,x]=mkdir(do);

%Parameters Intervals
PiHz=[80 250]; %Humman pitch in Herz
PhDurSec=[1/7 1/3]; %Phone duration in Herz
%APos={'K' 'L' 'R' 'C' 'B'}; %Positions


%Draw Text Utterances from a Grammar
Utt=DrawTextUttGr(NUtt);


%
for i=1:NUtt
    
    %Chose random parameters from the intervals
    MePi=rand(1)*(PiHz(2)-PiHz(1))+PiHz(1);
    PhDur=rand(1)*(PhDurSec(2)-PhDurSec(1))+PhDurSec(1);
    %Pos=APos(randi(length(APos)));    
    
    %Synthesis 
    [M,Du,Vo,PiF,StF]=Text2PhAcFe(Utt{i},PhDur);
    s=PhAcFe2GammSignal(M,Du,Vo,PiF,StF,FSamp,MePi);
    %s2=Mono2SimHouse(s,FSamp,Pos,FSamp,APos);
    s2=AddNoise2Sign(s',AddNoise);
    
    
    %Write signal
    fn=[do '/Utt' num2str(i) '.wav'];
    audiowrite(fn,s2,FSamp);
    fprintf('Written: %s with transcription %s\n',fn,Utt{i});
    
    
%     %Plot    
%     subplot(211), plot(s)
%     subplot(212), plot(s2)
%     Utt{i}
%     soundsc(s,FSamp);    
%     pause
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function s2=AddNoise2Sign(s,AddNoise)
%
if AddNoise
    [ns,nch]=size(s);
    n=randn(ns,nch);
    s2=Mix(s,n,10);
%     subplot(211), jplot(s)
%     subplot(212), jplot(s2)
%     pause
    
else
    s2=s;
end


