function FEVTSComp(y,do,bn,Stage,P)
%Front End Vector Taylor Series Compensation
%y: noisy signal
%do: output directoy
%bn: basename 
%Stage:
%P: Parameters

%Derived Parameters
P       = DerivParam(P);


%Test Stage
if strcmp(Stage,'Te')   
    Fby=Sign2FBank(y,P);
    Fbnest=FbNoiseEst(Fby);
    Fbxest=VTSEnh(Fby,Fbnest,'VtsCov',P);
   
    
    subplot(411), jplot(y), title('Noisy signal')
    subplot(412), jimagesc(Fby), title('Filter Bank (FB) noisy')
    subplot(413), jimagesc(Fbnest), title('FB noise estimation')
    subplot(414), jimagesc(Fbxest), title('FB clean estimation (with VTS compensation)')
    pause


%Training Stage 
else         
    %Features
    Fbx=Sign2FBank(y,P);          
    WriteHTKF([do '/' bn '.Fbx'], Fbx, 0, 1);  

end
 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function Fb=Sign2FBank(y,P)
%Signal To Filter Bank
[My nf]=Segmx(y,P.FL,P.FS);
[Y, CY]=Msd(My,'x',P.N2pi,P);
Fb=SmoothFreqCompr(Y,P.NCH,P.FSamp,P.N2pi,P.MF);

function Fbnest=FbNoiseEst(Fby)
%FilterBank Noise Estimation
FLFr=20;
HSmLFr=2;
[FL,nf]=size(Fby);
vad=ones(1,nf); vad(1:FLFr)=0; vad(end-FLFr:end)=0;
Fbnest=Vad2Fbn(Fby,vad,FLFr,HSmLFr);

function Fbnest=Vad2Fbn(Fby,vad,ClK,HSmL)
%
Y=exp(Fby);
[NestNoSm,Mask]=VadNoise(Y,vad,ClK);  
Nest=MeanF(NestNoSm,HSmL); Nest(Nest<=0)=eps;
Fbnest=log(Nest);







