function Fby=SmoothFreqCompr(M,NCH,FSamp,NFT,mf)
%Smooth in freq and Compression (Improved version Nov-2011)
%M is the Magnitude Spectral Density. Must have 1+NFT/2 (NFT even) or (NFT+1)/2 (otherwise) (see Msd)
%mf: Mel Floor (A2: -2.80 for Mag-hamming, -5.60 for Pow-DDR)


%
[Mel, cb]=MelFB(64,FSamp,NFT,NCH);
MelM=Mel*M;

%
Fby=log(MelM); 
Fby(Fby<mf)=mf;



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function PlotFB(Mel)
%Plot Filter Bank (Mel is the FB Matrix) 
[NCH SL]=size(Mel);
i=1; plot(Mel(i,:)), hold on
for i=2:NCH;  
    plot(Mel(i,:));     
end
hold off, xlim([1 SL]), 




