function [M, CM]=Msd(My,kind,NFT,P)
%MAGN SPECTRAL DENSITY (Energy independent of signal length, only dependent of signal var).
%My:Segm Matrix y
%P.win, P.p
%NFT: NFT points 0-2pi; 
%IMPORTANT!!!!: if NFT even (par), 1+NFT/2 (in half  spectrum to use 
%the whole different  points); otherwise (NFT+1)/2


nf=size(My,2);
if (isfield(P,'win')); w=repmat(P.win,[1 nf]);  My=My.*w; 
else disp('WARNING: No win for Msd'); end

if mod(NFT,2)==0; NFTh=1+NFT/2; 
else NFTh=(NFT+1)/2; end


switch kind
    case 'x'
        [M, CM]=MFft(My,NFT,NFTh);
        
    case 'rx'
        M=MFftRx(My,NFT,NFTh);
        
    case 'rxosa'
        M=MFftRxosa(My,NFT,NFTh);    
               
    case 'lpc'
        M=MLpc(My,NFT,NFTh,P.p);
    
    case 'lev'         
         M=MLevi(My,NFT,NFTh,14,-Inf);     
    
    case 'cov'
        
    case 'dft'
        M=MDft(My,P.wrad);

             
     otherwise
        disp(['Unknown method: ' kind]) 
         
 end              

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [M CM]=MFft(x,N,Nh)
%It exactly gives the same than MFftRx(x) but you have to use directly rx=xcorr(x,x,'biased'); (w=hamming(FL))
%We divide by sqrt(Nx) to fullfit the Parseval rule: sum(Sp.^2)=sum(x.^2) almost 2*sum(M.^2)
[Nx, nf]=size(x);
CM=fft(x,N)/sqrt(Nx); 
M=abs(CM(1:Nh,:));

function M=MFftRx(rx,N,Nh)
%It exactly gives the same than MFft(x) but you have to use directly
%rx=xcorr(x,x,'biased'); (xcorr(w,w,'unbiased'); WinDDRcw([511 255 511]); 
Sp=abs(fft(rx,N)); 
M=sqrt(Sp(1:Nh,:));

function M=MFftRxosa(rx,N,Nh)
%It gives almost the same than MFft(x) but you have to use directly WinDDRcw([256 127 256]); 
Sp=abs(fft(rx,N)); 
M=sqrt(2*Sp(1:Nh,:));

function M=MDft(x,wk)
%It gives 
[FL nf]=size(x);
n=0:FL-1;
l=length(wk); 
MR=zeros(l,FL); MI=zeros(l,FL); 
for i=1:l
    MR(i,:)=cos((n-FL/2)*wk(i)); 
    MI(i,:)=sin((n-FL/2)*wk(i));
end
R=MR*x; I=MI*x; 
M=sqrt((R.^2+I.^2)/FL);

function M=MLpc(My,NFT,NFTh,p)
%Magnitude Lpc spectrum (My is Segmented signal)
[a,G]=lpc(My,p); 
G=repmat(G',[NFT 1]); d=fft(a',NFT); Sp=abs(G./d); 
M=Sp(1:NFTh,:);

function M=MLevi(rx,N,Nh,p,vmin)
%Equivalent to Lpc but imput is rx biased ([...r(-1) r(0) r(1) ...])
%rx=xcorr(x,x,'biased');
[FL nf]=size(rx);
b=(FL+1)/2;
[a, v]=levinson(rx(b:b+p+1,:),p);  
i=v<vmin; v(i)=vmin;
v=repmat(v',[N 1]); Sp=abs(sqrt(v)./fft(a',N)); 
M=Sp(1:Nh,:); 




    