function [M, cb]=MelFB(FStart,Fs,NFT,NCH)
%Mel Filter Bank, (Matrix and Center freq Bins)
cb=MelBins(FStart, Fs, NFT, NCH);
M=GenMel(NCH,cb,NFT);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function cbin=MelBins(fstart, Fs, NFT, NCH)
i=0:NCH+1; 
fci=InvMel(Mel(fstart)+i*(Mel(Fs/2)-Mel(fstart))/(NCH+1));
cbin=round(NFT*fci/Fs);
	
function m=Mel(f)
m=2595*log10(1+f/700);

function f=InvMel(m)
f=700*(exp(m/2595*2.3026)-1);	



function M=GenMel(NCH,cb,NFT)
%
if mod(NFT,2)==0; NFTh=1+NFT/2; 
else NFTh=(NFT+1)/2; end
M=zeros(NCH,NFTh);
for k=2:NCH+1         
        w=MWeight(cb,k);
        M(k-1,cb(k-1)+1:cb(k-1)+length(w))=w;  
end
M=M(:,1:NFTh); %sometimes M it's longer than NFTh 



function w=MWeight(cb,k)
%Mel Weight
  j=1;
for i=cb(k-1):cb(k)
	w(j)=(i-cb(k-1)+1)/(cb(k)-cb(k-1)+1);	
    j=j+1;
end        
        
for i=cb(k)+1:cb(k+1)
     w(j)=1.0-((i-cb(k))/(cb(k+1)-cb(k)+1));
     j=j+1;        
end      

