function B=SiftPopiGramC(ys,MicRMe,MicADeg,do,bn,P)
%Sifting PopiGram



P.MicDM=MicRMe;
P.MicAVD=MicADeg;


P.Np=3;
P.FL=2*P.FL;
[P.ns P.nch]=size(ys);
P.nf=ceil((P.ns-P.FL)/P.FS);

%
PFN=[do '/' bn '_FEConfig.txt'];
fni=[do '/' bn '.ys'];
fno=[do '/' bn '.PiSign'];

%
WrStr(P,PFN); 
CompileCFun('PopiSift',P.CFunDir);


[D,UD, ia, ic]=ChDel(P.nch,P); %Unique Delay (UD) matrix
na=size(UD,2);

pv=P.MiPitSa:P.MaPitSa;   lp=length(pv);
A=zeros(lp,na,P.nf);

for n=1:na 
    dys=DelSignArr(ys,UD(:,n)); %delay signal channels as UD vector.
    %PS=SiftPiSign(dys',P);
    PS=SiftPiSignC(fni,fno,do,bn,dys,PFN,lp,P);    
    A(:,n,:)=PS;  
    fprintf('%d/%d ', n,na); 
end
B=A(:,ic,:);
delete(fni,fno,PFN);




%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function PS=SiftPiSignC(fni,fno,do,bn,dys,PFN,lp,P)
%
%WriteHTKF([do '/' bn '.ys'], dys', 1, 1); 
WriteHTKF(fni, dys', 1, 1); 
%c=[P.SMRoot '/FEJuan/Common/CFun/bin/PopiSift ' do ' ' do ' ' bn ' '  PFN]; system(c); 
c=[P.CFunDir '/bin/PopiSift ' do ' ' do ' ' bn ' '  PFN]; system(c); 
%PS=RePiSing([do '/' bn '.PiSign'],P,lp);
PS=RePiSing(fno,P,lp);


function ps=RePiSing(fn,P,lp)
%Read Pit (of Popi) Signal
fi=fopen(fn,'rb');
ps=fread(fi, [lp P.nf], 'float');  
fclose(fi);


function CompileCFun(PName, CFunDir)
%Compile C Function
%PName: Program Name ('PopiSift')
BinF=[CFunDir '/bin/' PName];
if ~exist(BinF,'file')
    cudir=pwd; cfdir=[CFunDir '/sources']; 
    cd(cfdir); 
    o=system(['make -f Makefile.txt PNAME=' PName]);     
    cd(cudir);
    if o==0
        fprintf('Succesful compilation of program %s\n',BinF);
    else
        fprintf('ERROR: in compilation of %s\n',BinF);
    end    
else
     fprintf('Not neccesary compilation of %s\n',BinF);    
end
    


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [D, UD, ia, ic]=ChDel(nch,P)
%Channel Delays. Unique Delays
D=zeros(nch,360);
for a=0:360
   for i=1:nch-1   
        D(i,a+1)=round(P.MicDM*P.FSamp*cos(2*pi*(P.MicAVD(i)-a)/360)/P.SoundSp);
   end  
end
p=[2 3 5 7 11 13]'; %primes numbers
P=repmat(p,1,361);
D2=D-min(D(:));
N=prod(P.^D2);
[C,ia,ic]=unique(N);
UD=D(:,ia);
%a=0:360; ua=a(ia); a=ua(ic);


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function dy=DelSignArr(y,dv)
%Delay Signals Array
[ns nch]=size(y);
dy=zeros(ns,nch);
for i=1:nch
    dy(:,i)=TranslSign(y(:,i),dv(i));  
end

function y=TranslSign(x,d)
%Translate Sign
%y(n)=x(n-d)
%x=[1 0 0 0 0..]; d=2; y=[0 0 1 0 0..]
%x=[1 0 0 0 0..]; d=-2;  y=[0 0 0 0 0..]
ns=length(x);
y=zeros(size(x));
a=(max(0,d):min(ns-1,ns-1+d))+1;
b=(max(0,-d):min(ns-1,ns-1-d))+1;
y(a)=x(b);   

