function B=PopiGramC(ys,MicRMe,MicADeg,do,bn,P)
%PitM:  pitch matrix ([142 1] or [6 nf]). In Lag Samples (0,1,2..)
%dv: delays vector. In Lag Samples (...-1,0,1,2...)
%B: is in angles

DelVSa=round(MicRMe*P.FSamp*cos(2*pi*(0:180)/360)/P.SoundSp); %Delay Vector in Samples
%MiADelSa=min(DelVSa); MaADelSa=max(DelVSa); %Min and Max Arrive Delay in Samples
dv=min(DelVSa):max(DelVSa); 
PitM=(P.MiPitSa:P.MaPitSa)'; 



%CompileCFun('PopiG2Mic',P.SMRoot); pause

%
nch=size(ys,2);
[My0 nf]=Segmx(ys(:,nch),P.FL,P.FS); 
[lp, x]=size(PitM);

B=zeros(lp,360,nf);

%For C
%  PFN=[do '/' bn '_FEConfig.txt'];
%  fno=[do '/' bn '.PopiG'];
%  fni0=[do '/' bn '_0.M'];
%  fni1=[do '/' bn '_1.M'];
%  WrStr(P,PFN);
%  WriteHTKF(fni0, My0, 1, 1); 

%
for ch=1:nch-1     
    [My1 nf]=Segmx(ys(:,ch),P.FL,P.FS);         
    %B=B+Popi2MicC(My1,do,bn,PFN,fni1,fno,P,MicADeg(ch),DelVSa,PitM,dv);     
    B=B+Popi2Mic(My0,My1,DelVSa,MicADeg(ch),PitM,dv);   
    
end


%For C
%delete(PFN,fno,fni0,fni1);

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function B=Popi2Mic(My0,My1,DelVS,MicAD,PitM,dv)
%Popi Gram of 2 Microphones
hbn=2; %half bin n
[lp PmNf]=size(PitM);


ld=length(dv);
[FL,nf]=size(My0);
[x,C,x,x]=M2CC(My0,My1); 
A=zeros(lp,ld,nf);


if(PmNf==1)
    
    for i=1:lp 
        p=PitM(i);
        for j=1:ld    
            bpos=p*(-hbn:hbn)+dv(j)+FL; %index position: 0+FL is the r(0)
            A(i,j,:)=mean(C(bpos,:));               
        end
    end

else
    
end

B=Comp2ExpPopi(A,DelVS,MicAD);



function B=Popi2MicC(My1,do,bn,PFN,fni1,fn,P,MicAD,DelVS,PitM,dv)
%Popi Gram of 2 Microphones
[FL,nf]=size(My1);
lp=length(PitM); ld=length(dv);
%
WriteHTKF(fni1, My1, 1, 1);  c=[P.CFunDir '/bin/PopiG2Mic ' do ' ' do ' ' bn ' '  PFN];  system(c);
%
A=zeros(lp,ld,nf);
fi=fopen(fn,'rb');
for i=1:lp
    for j=1:ld  
        a=fread(fi, nf, 'float');        
        A(i,j,:)=a;    
        %plot(squeeze(squeeze(A(i,j,:)))), pause
    end
end
fclose(fi);
%
B=Comp2ExpPopi(A,DelVS,MicAD);
12
pause

function B=Comp2ExpPopi(A,DelVS,MicAD)
%Compressed To Expanded Popi
[lp,ld,nf]=size(A);
B=zeros(lp,360,nf);
MiADelSa=min(DelVS);
ra=0:180; %relative angle
ai=1+DelVS(ra+1)-MiADelSa;
bi1=mod(MicAD+ra,360)+1;
bi2=mod(MicAD-ra,360)+1; 
for i=1:181  
    B(:,bi1(i),:)=A(:,ai(i),:);
    B(:,bi2(i),:)=A(:,ai(i),:);
end
